// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import lombok.*;

@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AtlanGroup.AtlanGroupBuilderImpl.class)
public class AtlanGroup extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Name of the group as it appears in the UI.
     */
    String alias;
    /**
     * Detailed attributes of the group.
     */
    GroupAttributes attributes;
    // TODO
    /**
     * TBC
     */
    @JsonIgnore
    String decentralizedRoles;
    /**
     * Unique identifier for the group (GUID).
     */
    String id;
    /**
     * Unique (internal) name for the group.
     */
    String name;
    /**
     * TBC
     */
    String path;
    /**
     * Personas the group is associated with (limited details).
     */
    SortedSet<Persona> personas;
    /**
     * Purposes the group is associated with (limited details).
     */
    SortedSet<Purpose> purposes;
    /**
     * TBC
     */
    SortedSet<String> roles;
    /**
     * Number of users in the group.
     */
    Long userCount;

    /**
     * Whether this group is a default (auto-assigned to new users) (true), or not (false).
     */
    @JsonIgnore
    public boolean isDefault() {
        return attributes != null && attributes.getIsDefault() != null && attributes.getIsDefault().contains("true");
    }

    /**
     * Builds the minimal object necessary to create a group.
     *
     * @param alias name of the group, as it should appear in the UI
     * @return the minimal request necessary to update the group, as a builder
     */
    public static AtlanGroupBuilder<?, ?> creator(String alias) {
        return AtlanGroup.builder().name(generateName(alias)).attributes(GroupAttributes.builder().alias(List.of(alias)).build());
    }

    /**
     * Builds the minimal object necessary to update a group.
     *
     * @param id unique identifier (GUID) of the group
     * @param path unique path of the group
     * @return the minimal request necessary to update the group, as a builder
     */
    public static AtlanGroupBuilder<?, ?> updater(String id, String path) {
        return AtlanGroup.builder().id(id).path(path);
    }

    /**
     * Generate an internal name for this group from its UI-shown alias.
     *
     * @param alias name of the group as it appears in the UI
     * @return internal name for the group
     */
    public static String generateName(String alias) {
        String internal = alias.toLowerCase(Locale.ROOT);
        return internal.replace(" ", "_");
    }

    /**
     * Send this group to Atlan to create the group in Atlan.
     *
     * @return the unique identifier (GUID) of the group that was created, or null if no group was created
     * @throws AtlanException on any error during API invocation
     */
    public String create() throws AtlanException {
        return create(Atlan.getDefaultClient());
    }

    /**
     * Send this group to Atlan to create the group in Atlan.
     *
     * @param client connectivity to the Atlan tenant on which to create the group
     * @return the unique identifier (GUID) of the group that was created, or null if no group was created
     * @throws AtlanException on any error during API invocation
     */
    public String create(AtlanClient client) throws AtlanException {
        return client.groups.create(this);
    }

    /**
     * Send this group to Atlan to update the group in Atlan.
     *
     * @throws AtlanException on any error during API invocation
     */
    public void update() throws AtlanException {
        update(Atlan.getDefaultClient());
    }

    /**
     * Send this group to Atlan to update the group in Atlan.
     *
     * @param client connectivity to the Atlan tenant on which to update the group
     * @throws AtlanException on any error during API invocation
     */
    public void update(AtlanClient client) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_GROUP_ID);
        }
        client.groups.update(this.id, this);
    }

    /**
     * Delete a group from Atlan.
     *
     * @param id unique identifier (GUID) of the group to delete
     * @throws AtlanException on any error during API invocation
     */
    public static void delete(String id) throws AtlanException {
        delete(Atlan.getDefaultClient(), id);
    }

    /**
     * Delete a group from Atlan.
     *
     * @param client connectivity to the Atlan tenant from which to delete the group
     * @param id unique identifier (GUID) of the group to delete
     * @throws AtlanException on any error during API invocation
     */
    public static void delete(AtlanClient client, String id) throws AtlanException {
        client.groups.purge(id);
    }

    /**
     * Retrieves all groups currently defined in Atlan.
     *
     * @return the list of groups currently defined in Atlan
     * @throws AtlanException on any error during API invocation
     */
    public static List<AtlanGroup> list() throws AtlanException {
        return list(Atlan.getDefaultClient());
    }

    /**
     * Retrieves all groups currently defined in Atlan.
     *
     * @param client connectivity to the Atlan tenant from which to list the groups
     * @return the list of groups currently defined in Atlan
     * @throws AtlanException on any error during API invocation
     */
    public static List<AtlanGroup> list(AtlanClient client) throws AtlanException {
        return client.groups.list();
    }

    /**
     * Retrieves all groups with a name that contains the provided string.
     * (This could include a complete group name, in which case there should be at
     * most a single item in the returned list, or could be a partial group name
     * to retrieve all groups with that naming convention.)
     *
     * @param alias name (as it appears in the UI) on which to filter the groups
     * @return all groups whose name (in the UI) contains the provided string
     * @throws AtlanException on any error during API invocation
     */
    @JsonIgnore
    public static List<AtlanGroup> get(String alias) throws AtlanException {
        return get(Atlan.getDefaultClient(), alias);
    }

    /**
     * Retrieves all groups with a name that contains the provided string.
     * (This could include a complete group name, in which case there should be at
     * most a single item in the returned list, or could be a partial group name
     * to retrieve all groups with that naming convention.)
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the group
     * @param alias name (as it appears in the UI) on which to filter the groups
     * @return all groups whose name (in the UI) contains the provided string
     * @throws AtlanException on any error during API invocation
     */
    @JsonIgnore
    public static List<AtlanGroup> get(AtlanClient client, String alias) throws AtlanException {
        return client.groups.get(alias);
    }

    /**
     * Remove one or more users from this group.
     *
     * @param userIds unique identifiers (GUIDs) of the users to remove from the group
     * @throws AtlanException on any API communication issue
     */
    public void removeUsers(List<String> userIds) throws AtlanException {
        removeUsers(Atlan.getDefaultClient(), userIds);
    }

    /**
     * Remove one or more users from this group.
     *
     * @param client connectivity to the Atlan tenant from which to remove the users from the group
     * @param userIds unique identifiers (GUIDs) of the users to remove from the group
     * @throws AtlanException on any API communication issue
     */
    public void removeUsers(AtlanClient client, List<String> userIds) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_GROUP_ID);
        }
        client.groups.removeMembers(this.id, userIds);
    }

    /**
     * Fetch the users that belong to this group.
     *
     * @return details of the users that belong to this group
     * @throws AtlanException on any API communication issue
     */
    public UserResponse fetchUsers() throws AtlanException {
        return fetchUsers(Atlan.getDefaultClient());
    }

    /**
     * Fetch the users that belong to this group.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the users belonging to the group
     * @return details of the users that belong to this group
     * @throws AtlanException on any API communication issue
     */
    public UserResponse fetchUsers(AtlanClient client) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_GROUP_ID);
        }
        return client.groups.listMembers(this.id);
    }


    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AtlanGroup.GroupAttributes.GroupAttributesBuilderImpl.class)
    public static final class GroupAttributes extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /**
         * Name of the group as it appears in the UI.
         */
        List<String> alias;
        /**
         * Time (epoch) at which the group was created, in milliseconds.
         */
        List<String> createdAt;
        /**
         * User who created the group.
         */
        List<String> createdBy;
        /**
         * Time (epoch) at which the group was last updated, in milliseconds.
         */
        List<String> updatedAt;
        /**
         * User who last updated the group.
         */
        List<String> updatedBy;
        /**
         * Description of the group.
         */
        List<String> description;
        /**
         * Whether this group should be auto-assigned to all new users (true) or not (false).
         */
        List<String> isDefault;
        /**
         * Slack channels for this group.
         */
        List<String> channels;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static List<String> $default$isDefault() {
            return List.of("false");
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class GroupAttributesBuilder<C extends AtlanGroup.GroupAttributes, B extends AtlanGroup.GroupAttributes.GroupAttributesBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> alias;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> createdAt;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> createdBy;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> updatedAt;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> updatedBy;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> description;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private boolean isDefault$set;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> isDefault$value;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> channels;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                AtlanGroup.GroupAttributes.GroupAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final AtlanGroup.GroupAttributes instance, final AtlanGroup.GroupAttributes.GroupAttributesBuilder<?, ?> b) {
                b.alias(instance.alias);
                b.createdAt(instance.createdAt);
                b.createdBy(instance.createdBy);
                b.updatedAt(instance.updatedAt);
                b.updatedBy(instance.updatedBy);
                b.description(instance.description);
                b.isDefault(instance.isDefault);
                b.channels(instance.channels);
            }

            /**
             * Name of the group as it appears in the UI.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B alias(final List<String> alias) {
                this.alias = alias;
                return self();
            }

            /**
             * Time (epoch) at which the group was created, in milliseconds.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B createdAt(final List<String> createdAt) {
                this.createdAt = createdAt;
                return self();
            }

            /**
             * User who created the group.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B createdBy(final List<String> createdBy) {
                this.createdBy = createdBy;
                return self();
            }

            /**
             * Time (epoch) at which the group was last updated, in milliseconds.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B updatedAt(final List<String> updatedAt) {
                this.updatedAt = updatedAt;
                return self();
            }

            /**
             * User who last updated the group.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B updatedBy(final List<String> updatedBy) {
                this.updatedBy = updatedBy;
                return self();
            }

            /**
             * Description of the group.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B description(final List<String> description) {
                this.description = description;
                return self();
            }

            /**
             * Whether this group should be auto-assigned to all new users (true) or not (false).
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B isDefault(final List<String> isDefault) {
                this.isDefault$value = isDefault;
                isDefault$set = true;
                return self();
            }

            /**
             * Slack channels for this group.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B channels(final List<String> channels) {
                this.channels = channels;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "AtlanGroup.GroupAttributes.GroupAttributesBuilder(super=" + super.toString() + ", alias=" + this.alias + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ", updatedAt=" + this.updatedAt + ", updatedBy=" + this.updatedBy + ", description=" + this.description + ", isDefault$value=" + this.isDefault$value + ", channels=" + this.channels + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class GroupAttributesBuilderImpl extends AtlanGroup.GroupAttributes.GroupAttributesBuilder<AtlanGroup.GroupAttributes, AtlanGroup.GroupAttributes.GroupAttributesBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private GroupAttributesBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected AtlanGroup.GroupAttributes.GroupAttributesBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public AtlanGroup.GroupAttributes build() {
                return new AtlanGroup.GroupAttributes(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected GroupAttributes(final AtlanGroup.GroupAttributes.GroupAttributesBuilder<?, ?> b) {
            super(b);
            this.alias = b.alias;
            this.createdAt = b.createdAt;
            this.createdBy = b.createdBy;
            this.updatedAt = b.updatedAt;
            this.updatedBy = b.updatedBy;
            this.description = b.description;
            if (b.isDefault$set) this.isDefault = b.isDefault$value;
             else this.isDefault = AtlanGroup.GroupAttributes.$default$isDefault();
            this.channels = b.channels;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static AtlanGroup.GroupAttributes.GroupAttributesBuilder<?, ?> builder() {
            return new AtlanGroup.GroupAttributes.GroupAttributesBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanGroup.GroupAttributes.GroupAttributesBuilder<?, ?> toBuilder() {
            return new AtlanGroup.GroupAttributes.GroupAttributesBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Name of the group as it appears in the UI.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getAlias() {
            return this.alias;
        }

        /**
         * Time (epoch) at which the group was created, in milliseconds.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getCreatedAt() {
            return this.createdAt;
        }

        /**
         * User who created the group.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getCreatedBy() {
            return this.createdBy;
        }

        /**
         * Time (epoch) at which the group was last updated, in milliseconds.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getUpdatedAt() {
            return this.updatedAt;
        }

        /**
         * User who last updated the group.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getUpdatedBy() {
            return this.updatedBy;
        }

        /**
         * Description of the group.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getDescription() {
            return this.description;
        }

        /**
         * Whether this group should be auto-assigned to all new users (true) or not (false).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getIsDefault() {
            return this.isDefault;
        }

        /**
         * Slack channels for this group.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getChannels() {
            return this.channels;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof AtlanGroup.GroupAttributes)) return false;
            final AtlanGroup.GroupAttributes other = (AtlanGroup.GroupAttributes) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$alias = this.getAlias();
            final java.lang.Object other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) return false;
            final java.lang.Object this$createdAt = this.getCreatedAt();
            final java.lang.Object other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) return false;
            final java.lang.Object this$createdBy = this.getCreatedBy();
            final java.lang.Object other$createdBy = other.getCreatedBy();
            if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) return false;
            final java.lang.Object this$updatedAt = this.getUpdatedAt();
            final java.lang.Object other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) return false;
            final java.lang.Object this$updatedBy = this.getUpdatedBy();
            final java.lang.Object other$updatedBy = other.getUpdatedBy();
            if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) return false;
            final java.lang.Object this$description = this.getDescription();
            final java.lang.Object other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
            final java.lang.Object this$isDefault = this.getIsDefault();
            final java.lang.Object other$isDefault = other.getIsDefault();
            if (this$isDefault == null ? other$isDefault != null : !this$isDefault.equals(other$isDefault)) return false;
            final java.lang.Object this$channels = this.getChannels();
            final java.lang.Object other$channels = other.getChannels();
            if (this$channels == null ? other$channels != null : !this$channels.equals(other$channels)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof AtlanGroup.GroupAttributes;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $alias = this.getAlias();
            result = result * PRIME + ($alias == null ? 43 : $alias.hashCode());
            final java.lang.Object $createdAt = this.getCreatedAt();
            result = result * PRIME + ($createdAt == null ? 43 : $createdAt.hashCode());
            final java.lang.Object $createdBy = this.getCreatedBy();
            result = result * PRIME + ($createdBy == null ? 43 : $createdBy.hashCode());
            final java.lang.Object $updatedAt = this.getUpdatedAt();
            result = result * PRIME + ($updatedAt == null ? 43 : $updatedAt.hashCode());
            final java.lang.Object $updatedBy = this.getUpdatedBy();
            result = result * PRIME + ($updatedBy == null ? 43 : $updatedBy.hashCode());
            final java.lang.Object $description = this.getDescription();
            result = result * PRIME + ($description == null ? 43 : $description.hashCode());
            final java.lang.Object $isDefault = this.getIsDefault();
            result = result * PRIME + ($isDefault == null ? 43 : $isDefault.hashCode());
            final java.lang.Object $channels = this.getChannels();
            result = result * PRIME + ($channels == null ? 43 : $channels.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanGroup.GroupAttributes(super=" + super.toString() + ", alias=" + this.getAlias() + ", createdAt=" + this.getCreatedAt() + ", createdBy=" + this.getCreatedBy() + ", updatedAt=" + this.getUpdatedAt() + ", updatedBy=" + this.getUpdatedBy() + ", description=" + this.getDescription() + ", isDefault=" + this.getIsDefault() + ", channels=" + this.getChannels() + ")";
        }
    }


    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AtlanGroup.Persona.PersonaBuilderImpl.class)
    public static final class Persona extends AtlanObject implements Comparable<Persona> {
        private static final long serialVersionUID = 2L;
        private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
        private static final Comparator<AtlanGroup.Persona> personaComparator = Comparator.comparing(AtlanGroup.Persona::getId, stringComparator);
        /**
         * UUID of the persona.
         */
        String id;
        /**
         * Name of the persona.
         */
        String name;
        /**
         * Business name of the persona.
         */
        String displayName;
        /**
         * Unique internal name of the persona.
         */
        String qualifiedName;

        /**
         * {@inheritDoc}
         */
        @Override
        public int compareTo(AtlanGroup.Persona o) {
            return personaComparator.compare(this, o);
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class PersonaBuilder<C extends AtlanGroup.Persona, B extends AtlanGroup.Persona.PersonaBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String id;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String name;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String displayName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String qualifiedName;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                AtlanGroup.Persona.PersonaBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final AtlanGroup.Persona instance, final AtlanGroup.Persona.PersonaBuilder<?, ?> b) {
                b.id(instance.id);
                b.name(instance.name);
                b.displayName(instance.displayName);
                b.qualifiedName(instance.qualifiedName);
            }

            /**
             * UUID of the persona.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B id(final String id) {
                this.id = id;
                return self();
            }

            /**
             * Name of the persona.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B name(final String name) {
                this.name = name;
                return self();
            }

            /**
             * Business name of the persona.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B displayName(final String displayName) {
                this.displayName = displayName;
                return self();
            }

            /**
             * Unique internal name of the persona.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B qualifiedName(final String qualifiedName) {
                this.qualifiedName = qualifiedName;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "AtlanGroup.Persona.PersonaBuilder(super=" + super.toString() + ", id=" + this.id + ", name=" + this.name + ", displayName=" + this.displayName + ", qualifiedName=" + this.qualifiedName + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class PersonaBuilderImpl extends AtlanGroup.Persona.PersonaBuilder<AtlanGroup.Persona, AtlanGroup.Persona.PersonaBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private PersonaBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected AtlanGroup.Persona.PersonaBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public AtlanGroup.Persona build() {
                return new AtlanGroup.Persona(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Persona(final AtlanGroup.Persona.PersonaBuilder<?, ?> b) {
            super(b);
            this.id = b.id;
            this.name = b.name;
            this.displayName = b.displayName;
            this.qualifiedName = b.qualifiedName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static AtlanGroup.Persona.PersonaBuilder<?, ?> builder() {
            return new AtlanGroup.Persona.PersonaBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanGroup.Persona.PersonaBuilder<?, ?> toBuilder() {
            return new AtlanGroup.Persona.PersonaBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * UUID of the persona.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getId() {
            return this.id;
        }

        /**
         * Name of the persona.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
            return this.name;
        }

        /**
         * Business name of the persona.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDisplayName() {
            return this.displayName;
        }

        /**
         * Unique internal name of the persona.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getQualifiedName() {
            return this.qualifiedName;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof AtlanGroup.Persona)) return false;
            final AtlanGroup.Persona other = (AtlanGroup.Persona) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            final java.lang.Object this$displayName = this.getDisplayName();
            final java.lang.Object other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
            final java.lang.Object this$qualifiedName = this.getQualifiedName();
            final java.lang.Object other$qualifiedName = other.getQualifiedName();
            if (this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof AtlanGroup.Persona;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $displayName = this.getDisplayName();
            result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
            final java.lang.Object $qualifiedName = this.getQualifiedName();
            result = result * PRIME + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanGroup.Persona(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", qualifiedName=" + this.getQualifiedName() + ")";
        }
    }


    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AtlanGroup.Purpose.PurposeBuilderImpl.class)
    public static final class Purpose extends AtlanObject implements Comparable<Purpose> {
        private static final long serialVersionUID = 2L;
        private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
        private static final Comparator<AtlanGroup.Purpose> purposeComparator = Comparator.comparing(AtlanGroup.Purpose::getGuid, stringComparator);
        /** UUID of the purpose. */
        String guid;
        /** Name of the purpose. */
        String name;
        /** Unique internal name of the purpose. */
        String qualifiedName;

        /** {@inheritDoc} */
        @Override
        public int compareTo(AtlanGroup.Purpose o) {
            return purposeComparator.compare(this, o);
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class PurposeBuilder<C extends AtlanGroup.Purpose, B extends AtlanGroup.Purpose.PurposeBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String guid;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String name;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String qualifiedName;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                AtlanGroup.Purpose.PurposeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final AtlanGroup.Purpose instance, final AtlanGroup.Purpose.PurposeBuilder<?, ?> b) {
                b.guid(instance.guid);
                b.name(instance.name);
                b.qualifiedName(instance.qualifiedName);
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B guid(final String guid) {
                this.guid = guid;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B name(final String name) {
                this.name = name;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B qualifiedName(final String qualifiedName) {
                this.qualifiedName = qualifiedName;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "AtlanGroup.Purpose.PurposeBuilder(super=" + super.toString() + ", guid=" + this.guid + ", name=" + this.name + ", qualifiedName=" + this.qualifiedName + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class PurposeBuilderImpl extends AtlanGroup.Purpose.PurposeBuilder<AtlanGroup.Purpose, AtlanGroup.Purpose.PurposeBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private PurposeBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected AtlanGroup.Purpose.PurposeBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public AtlanGroup.Purpose build() {
                return new AtlanGroup.Purpose(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Purpose(final AtlanGroup.Purpose.PurposeBuilder<?, ?> b) {
            super(b);
            this.guid = b.guid;
            this.name = b.name;
            this.qualifiedName = b.qualifiedName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static AtlanGroup.Purpose.PurposeBuilder<?, ?> builder() {
            return new AtlanGroup.Purpose.PurposeBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanGroup.Purpose.PurposeBuilder<?, ?> toBuilder() {
            return new AtlanGroup.Purpose.PurposeBuilderImpl().$fillValuesFrom(this);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getGuid() {
            return this.guid;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
            return this.name;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getQualifiedName() {
            return this.qualifiedName;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof AtlanGroup.Purpose)) return false;
            final AtlanGroup.Purpose other = (AtlanGroup.Purpose) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$guid = this.getGuid();
            final java.lang.Object other$guid = other.getGuid();
            if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            final java.lang.Object this$qualifiedName = this.getQualifiedName();
            final java.lang.Object other$qualifiedName = other.getQualifiedName();
            if (this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof AtlanGroup.Purpose;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $guid = this.getGuid();
            result = result * PRIME + ($guid == null ? 43 : $guid.hashCode());
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $qualifiedName = this.getQualifiedName();
            result = result * PRIME + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanGroup.Purpose(super=" + super.toString() + ", guid=" + this.getGuid() + ", name=" + this.getName() + ", qualifiedName=" + this.getQualifiedName() + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AtlanGroupBuilder<C extends AtlanGroup, B extends AtlanGroup.AtlanGroupBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String alias;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private GroupAttributes attributes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String decentralizedRoles;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String id;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String name;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String path;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SortedSet<Persona> personas;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SortedSet<Purpose> purposes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SortedSet<String> roles;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long userCount;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AtlanGroup.AtlanGroupBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AtlanGroup instance, final AtlanGroup.AtlanGroupBuilder<?, ?> b) {
            b.alias(instance.alias);
            b.attributes(instance.attributes);
            b.decentralizedRoles(instance.decentralizedRoles);
            b.id(instance.id);
            b.name(instance.name);
            b.path(instance.path);
            b.personas(instance.personas);
            b.purposes(instance.purposes);
            b.roles(instance.roles);
            b.userCount(instance.userCount);
        }

        /**
         * Name of the group as it appears in the UI.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B alias(final String alias) {
            this.alias = alias;
            return self();
        }

        /**
         * Detailed attributes of the group.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attributes(final GroupAttributes attributes) {
            this.attributes = attributes;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B decentralizedRoles(final String decentralizedRoles) {
            this.decentralizedRoles = decentralizedRoles;
            return self();
        }

        /**
         * Unique identifier for the group (GUID).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B id(final String id) {
            this.id = id;
            return self();
        }

        /**
         * Unique (internal) name for the group.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B name(final String name) {
            this.name = name;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B path(final String path) {
            this.path = path;
            return self();
        }

        /**
         * Personas the group is associated with (limited details).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B personas(final SortedSet<Persona> personas) {
            this.personas = personas;
            return self();
        }

        /**
         * Purposes the group is associated with (limited details).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B purposes(final SortedSet<Purpose> purposes) {
            this.purposes = purposes;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B roles(final SortedSet<String> roles) {
            this.roles = roles;
            return self();
        }

        /**
         * Number of users in the group.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B userCount(final Long userCount) {
            this.userCount = userCount;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanGroup.AtlanGroupBuilder(super=" + super.toString() + ", alias=" + this.alias + ", attributes=" + this.attributes + ", decentralizedRoles=" + this.decentralizedRoles + ", id=" + this.id + ", name=" + this.name + ", path=" + this.path + ", personas=" + this.personas + ", purposes=" + this.purposes + ", roles=" + this.roles + ", userCount=" + this.userCount + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class AtlanGroupBuilderImpl extends AtlanGroup.AtlanGroupBuilder<AtlanGroup, AtlanGroup.AtlanGroupBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanGroupBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AtlanGroup.AtlanGroupBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanGroup build() {
            return new AtlanGroup(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AtlanGroup(final AtlanGroup.AtlanGroupBuilder<?, ?> b) {
        super(b);
        this.alias = b.alias;
        this.attributes = b.attributes;
        this.decentralizedRoles = b.decentralizedRoles;
        this.id = b.id;
        this.name = b.name;
        this.path = b.path;
        this.personas = b.personas;
        this.purposes = b.purposes;
        this.roles = b.roles;
        this.userCount = b.userCount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AtlanGroup.AtlanGroupBuilder<?, ?> builder() {
        return new AtlanGroup.AtlanGroupBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanGroup.AtlanGroupBuilder<?, ?> toBuilder() {
        return new AtlanGroup.AtlanGroupBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Name of the group as it appears in the UI.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAlias() {
        return this.alias;
    }

    /**
     * Detailed attributes of the group.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public GroupAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDecentralizedRoles() {
        return this.decentralizedRoles;
    }

    /**
     * Unique identifier for the group (GUID).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
        return this.id;
    }

    /**
     * Unique (internal) name for the group.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPath() {
        return this.path;
    }

    /**
     * Personas the group is associated with (limited details).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<Persona> getPersonas() {
        return this.personas;
    }

    /**
     * Purposes the group is associated with (limited details).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<Purpose> getPurposes() {
        return this.purposes;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getRoles() {
        return this.roles;
    }

    /**
     * Number of users in the group.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getUserCount() {
        return this.userCount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanGroup)) return false;
        final AtlanGroup other = (AtlanGroup) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$userCount = this.getUserCount();
        final java.lang.Object other$userCount = other.getUserCount();
        if (this$userCount == null ? other$userCount != null : !this$userCount.equals(other$userCount)) return false;
        final java.lang.Object this$alias = this.getAlias();
        final java.lang.Object other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) return false;
        final java.lang.Object this$attributes = this.getAttributes();
        final java.lang.Object other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
        final java.lang.Object this$decentralizedRoles = this.getDecentralizedRoles();
        final java.lang.Object other$decentralizedRoles = other.getDecentralizedRoles();
        if (this$decentralizedRoles == null ? other$decentralizedRoles != null : !this$decentralizedRoles.equals(other$decentralizedRoles)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$path = this.getPath();
        final java.lang.Object other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) return false;
        final java.lang.Object this$personas = this.getPersonas();
        final java.lang.Object other$personas = other.getPersonas();
        if (this$personas == null ? other$personas != null : !this$personas.equals(other$personas)) return false;
        final java.lang.Object this$purposes = this.getPurposes();
        final java.lang.Object other$purposes = other.getPurposes();
        if (this$purposes == null ? other$purposes != null : !this$purposes.equals(other$purposes)) return false;
        final java.lang.Object this$roles = this.getRoles();
        final java.lang.Object other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !this$roles.equals(other$roles)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AtlanGroup;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $userCount = this.getUserCount();
        result = result * PRIME + ($userCount == null ? 43 : $userCount.hashCode());
        final java.lang.Object $alias = this.getAlias();
        result = result * PRIME + ($alias == null ? 43 : $alias.hashCode());
        final java.lang.Object $attributes = this.getAttributes();
        result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
        final java.lang.Object $decentralizedRoles = this.getDecentralizedRoles();
        result = result * PRIME + ($decentralizedRoles == null ? 43 : $decentralizedRoles.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $path = this.getPath();
        result = result * PRIME + ($path == null ? 43 : $path.hashCode());
        final java.lang.Object $personas = this.getPersonas();
        result = result * PRIME + ($personas == null ? 43 : $personas.hashCode());
        final java.lang.Object $purposes = this.getPurposes();
        result = result * PRIME + ($purposes == null ? 43 : $purposes.hashCode());
        final java.lang.Object $roles = this.getRoles();
        result = result * PRIME + ($roles == null ? 43 : $roles.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanGroup(super=" + super.toString() + ", alias=" + this.getAlias() + ", attributes=" + this.getAttributes() + ", decentralizedRoles=" + this.getDecentralizedRoles() + ", id=" + this.getId() + ", name=" + this.getName() + ", path=" + this.getPath() + ", personas=" + this.getPersonas() + ", purposes=" + this.getPurposes() + ", roles=" + this.getRoles() + ", userCount=" + this.getUserCount() + ")";
    }
}
