// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.*;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanRequestStatus;
import com.atlan.serde.AtlanRequestDeserializer;
import com.atlan.serde.AtlanRequestSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.SortedSet;
import lombok.*;

@JsonSerialize(using = AtlanRequestSerializer.class)
@JsonDeserialize(using = AtlanRequestDeserializer.class)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "requestType")
@JsonSubTypes({@JsonSubTypes.Type(value = AttributeRequest.class, name = AttributeRequest.REQUEST_TYPE), @JsonSubTypes.Type(value = TermLinkRequest.class, name = TermLinkRequest.REQUEST_TYPE), @JsonSubTypes.Type(value = AtlanTagRequest.class, name = AtlanTagRequest.REQUEST_TYPE), @JsonSubTypes.Type(value = CustomMetadataRequest.class, name = CustomMetadataRequest.REQUEST_TYPE)})
public abstract class AtlanRequest extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Unique identifier for the request (GUID).
     */
    String id;
    /**
     * Unique version name for the request.
     */
    String version;
    /**
     * If true, the request is still open.
     */
    Boolean isActive;
    /**
     * Date and time at which the request was created.
     */
    final Long createdAt;
    /**
     * Date and time at which the request was last updated.
     */
    final Long updatedAt;
    /**
     * User who created the request.
     */
    String createdBy;
    /**
     * Name of the tenant for the request (usually `default`).
     */
    String tenantId;
    /**
     * Should be `static` for an ATTRIBUTE or CUSTOM_METADATA requestType, and `atlas` for other request types.
     */
    String sourceType;
    /**
     * Unique identifier (GUID) of the asset being related through this request, for example the term's GUID for a TERM_LINK.
     */
    String sourceGuid;
    /**
     * Unique name of the asset being related through this request, for example the term's qualifiedName for a TERM_LINK.
     */
    String sourceQualifiedName;
    /**
     * TBC
     */
    String sourceAttribute;
    /**
     * Unique identifier (GUID) of the asset this request was made against.
     */
    String destinationGuid;
    /**
     * Unique name of the asset this request was made against.
     */
    String destinationQualifiedName;
    /**
     * Attribute the request was made against.
     */
    String destinationAttribute;
    /**
     * Requested value for the attribute.
     */
    String destinationValue;
    /**
     * Type of the destination attribute value, for example `array`.
     */
    String destinationValueType;
    /**
     * Unused.
     */
    @JsonIgnore
    Object destinationValueArray;
    /**
     * Unused.
     */
    @JsonIgnore
    Object destinationValueObject;
    /**
     * Type of asset the change was requested against.
     */
    String entityType;
    /**
     * Type of change the request is for.
     */
    String requestType;
    /**
     * Unused.
     */
    @JsonIgnore
    Object confidenceScore;
    /**
     * Unused.
     */
    @JsonIgnore
    Object botRunId;
    /**
     * User who approved the request.
     */
    String approvedBy;
    /**
     * User who rejected the request.
     */
    String rejectedBy;
    /**
     * Status of the request.
     */
    AtlanRequestStatus status;
    /**
     * Comment recorded with the approval or rejection of the request.
     */
    String message;
    /**
     * Unused.
     */
    @JsonIgnore
    Object requestsBatch;
    /**
     * Type of approval required — currently only `single` is supported.
     */
    String approvalType;
    /**
     * Unused.
     */
    @JsonIgnore
    Object assignedApprovers;
    /**
     * Unused.
     */
    @JsonIgnore
    Object accessStartDate;
    /**
     * Unused.
     */
    @JsonIgnore
    Object accessEndDate;
    /**
     * TBC
     */
    Long hash;
    /**
     * TBC
     */
    Boolean isDuplicate;
    /**
     * Semantic to use when applying the destination value, for example `append`.
     */
    String destinationValueAction;
    /**
     * Names of users (in Keycloak) that can approve this request.
     */
    SortedSet<String> requestApproverUsers;
    /**
     * TBC
     */
    SortedSet<String> requestApproverGroups;
    /**
     * Names of roles (in Keycloak) that can approve this request.
     */
    SortedSet<String> requestApproverRoles;
    /**
     * Names of users (in Keycloak) that can deny this request.
     */
    SortedSet<String> requestDenyUsers;
    /**
     * TBC
     */
    SortedSet<String> requestDenyGroups;
    /**
     * Unique identifiers (GUIDs) of the roles that can deny this request.
     */
    SortedSet<String> requestDenyRoles;
    /**
     * TBC
     */
    @JsonIgnore
    Object sourceEntity;
    /**
     * Limited details about the asset this request was made against.
     */
    Asset destinationEntity;

    /**
     * Create the request in Atlan that is represented by this object.
     *
     * @throws AtlanException on any API interaction issues
     */
    public void create() throws AtlanException {
        create(Atlan.getDefaultClient());
    }

    /**
     * Create the request in Atlan that is represented by this object.
     *
     * @param client connectivity to the Atlan tenant in which to create the request
     * @throws AtlanException on any API interaction issues
     */
    public void create(AtlanClient client) throws AtlanException {
        client.requests.create(this);
    }

    /**
     * Retrieve the list of requests defined in Atlan as you would via the Admin UI.
     *
     * @return a list of all the requests in Atlan
     * @throws AtlanException on any API communication issue
     */
    public static AtlanRequestResponse list() throws AtlanException {
        return list(Atlan.getDefaultClient());
    }

    /**
     * Retrieve the list of requests defined in Atlan as you would via the Admin UI.
     *
     * @param client connectivity to the Atlan tenant from which to list requests
     * @return a list of all the requests in Atlan
     * @throws AtlanException on any API communication issue
     */
    public static AtlanRequestResponse list(AtlanClient client) throws AtlanException {
        return client.requests.list();
    }

    /**
     * Fetch a single request by its unique identifier (GUID).
     *
     * @param guid unique identifier (GUID) of the request to fetch.
     * @return the single request, or null if none was found
     * @throws AtlanException on any API communication issue
     */
    public static AtlanRequest retrieveByGuid(String guid) throws AtlanException {
        return retrieveByGuid(Atlan.getDefaultClient(), guid);
    }

    /**
     * Fetch a single request by its unique identifier (GUID).
     *
     * @param client connectivity to the Atlan tenant from which to fetch the request
     * @param guid unique identifier (GUID) of the request to fetch.
     * @return the single request, or null if none was found
     * @throws AtlanException on any API communication issue
     */
    public static AtlanRequest retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return client.requests.get(guid);
    }

    /**
     * Approve the specified request in Atlan.
     *
     * @param guid unique identifier (GUID) of the request to approve
     * @param message (optional) message to include with the approval
     * @return true if the approval succeeded, otherwise false
     * @throws AtlanException on any API interaction issues
     */
    public static boolean approve(String guid, String message) throws AtlanException {
        return approve(Atlan.getDefaultClient(), guid, message);
    }

    /**
     * Approve the specified request in Atlan.
     *
     * @param client connectivity to the Atlan tenant in which to approve the request
     * @param guid unique identifier (GUID) of the request to approve
     * @param message (optional) message to include with the approval
     * @return true if the approval succeeded, otherwise false
     * @throws AtlanException on any API interaction issues
     */
    public static boolean approve(AtlanClient client, String guid, String message) throws AtlanException {
        return client.requests.approve(guid, message);
    }

    /**
     * Reject the specified request in Atlan.
     *
     * @param guid unique identifier (GUID) of the request to reject
     * @param message (optional) message to include with the rejection
     * @return true if the rejection succeeded, otherwise false
     * @throws AtlanException on any API interaction issues
     */
    public static boolean reject(String guid, String message) throws AtlanException {
        return reject(Atlan.getDefaultClient(), guid, message);
    }

    /**
     * Reject the specified request in Atlan.
     *
     * @param client connectivity to the Atlan tenant in which to reject the request
     * @param guid unique identifier (GUID) of the request to reject
     * @param message (optional) message to include with the rejection
     * @return true if the rejection succeeded, otherwise false
     * @throws AtlanException on any API interaction issues
     */
    public static boolean reject(AtlanClient client, String guid, String message) throws AtlanException {
        return client.requests.reject(guid, message);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$tenantId() {
        return "default";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$approvalType() {
        return "single";
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AtlanRequestBuilder<C extends AtlanRequest, B extends AtlanRequest.AtlanRequestBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String id;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String version;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isActive;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long createdAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long updatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String createdBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean tenantId$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tenantId$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceAttribute;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String destinationGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String destinationQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String destinationAttribute;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String destinationValue;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String destinationValueType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Object destinationValueArray;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Object destinationValueObject;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String entityType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String requestType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Object confidenceScore;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Object botRunId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String approvedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String rejectedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanRequestStatus status;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String message;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Object requestsBatch;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean approvalType$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String approvalType$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Object assignedApprovers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Object accessStartDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Object accessEndDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long hash;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isDuplicate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String destinationValueAction;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> requestApproverUsers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> requestApproverGroups;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> requestApproverRoles;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> requestDenyUsers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> requestDenyGroups;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> requestDenyRoles;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Object sourceEntity;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Asset destinationEntity;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AtlanRequest.AtlanRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AtlanRequest instance, final AtlanRequest.AtlanRequestBuilder<?, ?> b) {
            b.id(instance.id);
            b.version(instance.version);
            b.isActive(instance.isActive);
            b.createdAt(instance.createdAt);
            b.updatedAt(instance.updatedAt);
            b.createdBy(instance.createdBy);
            b.tenantId(instance.tenantId);
            b.sourceType(instance.sourceType);
            b.sourceGuid(instance.sourceGuid);
            b.sourceQualifiedName(instance.sourceQualifiedName);
            b.sourceAttribute(instance.sourceAttribute);
            b.destinationGuid(instance.destinationGuid);
            b.destinationQualifiedName(instance.destinationQualifiedName);
            b.destinationAttribute(instance.destinationAttribute);
            b.destinationValue(instance.destinationValue);
            b.destinationValueType(instance.destinationValueType);
            b.destinationValueArray(instance.destinationValueArray);
            b.destinationValueObject(instance.destinationValueObject);
            b.entityType(instance.entityType);
            b.requestType(instance.requestType);
            b.confidenceScore(instance.confidenceScore);
            b.botRunId(instance.botRunId);
            b.approvedBy(instance.approvedBy);
            b.rejectedBy(instance.rejectedBy);
            b.status(instance.status);
            b.message(instance.message);
            b.requestsBatch(instance.requestsBatch);
            b.approvalType(instance.approvalType);
            b.assignedApprovers(instance.assignedApprovers);
            b.accessStartDate(instance.accessStartDate);
            b.accessEndDate(instance.accessEndDate);
            b.hash(instance.hash);
            b.isDuplicate(instance.isDuplicate);
            b.destinationValueAction(instance.destinationValueAction);
            b.requestApproverUsers(instance.requestApproverUsers == null ? java.util.Collections.<String>emptySortedSet() : instance.requestApproverUsers);
            b.requestApproverGroups(instance.requestApproverGroups == null ? java.util.Collections.<String>emptySortedSet() : instance.requestApproverGroups);
            b.requestApproverRoles(instance.requestApproverRoles == null ? java.util.Collections.<String>emptySortedSet() : instance.requestApproverRoles);
            b.requestDenyUsers(instance.requestDenyUsers == null ? java.util.Collections.<String>emptySortedSet() : instance.requestDenyUsers);
            b.requestDenyGroups(instance.requestDenyGroups == null ? java.util.Collections.<String>emptySortedSet() : instance.requestDenyGroups);
            b.requestDenyRoles(instance.requestDenyRoles == null ? java.util.Collections.<String>emptySortedSet() : instance.requestDenyRoles);
            b.sourceEntity(instance.sourceEntity);
            b.destinationEntity(instance.destinationEntity);
        }

        /**
         * Unique identifier for the request (GUID).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B id(final String id) {
            this.id = id;
            return self();
        }

        /**
         * Unique version name for the request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B version(final String version) {
            this.version = version;
            return self();
        }

        /**
         * If true, the request is still open.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isActive(final Boolean isActive) {
            this.isActive = isActive;
            return self();
        }

        /**
         * Date and time at which the request was created.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B createdAt(final Long createdAt) {
            this.createdAt = createdAt;
            return self();
        }

        /**
         * Date and time at which the request was last updated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B updatedAt(final Long updatedAt) {
            this.updatedAt = updatedAt;
            return self();
        }

        /**
         * User who created the request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B createdBy(final String createdBy) {
            this.createdBy = createdBy;
            return self();
        }

        /**
         * Name of the tenant for the request (usually `default`).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tenantId(final String tenantId) {
            this.tenantId$value = tenantId;
            tenantId$set = true;
            return self();
        }

        /**
         * Should be `static` for an ATTRIBUTE or CUSTOM_METADATA requestType, and `atlas` for other request types.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceType(final String sourceType) {
            this.sourceType = sourceType;
            return self();
        }

        /**
         * Unique identifier (GUID) of the asset being related through this request, for example the term's GUID for a TERM_LINK.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceGuid(final String sourceGuid) {
            this.sourceGuid = sourceGuid;
            return self();
        }

        /**
         * Unique name of the asset being related through this request, for example the term's qualifiedName for a TERM_LINK.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceQualifiedName(final String sourceQualifiedName) {
            this.sourceQualifiedName = sourceQualifiedName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceAttribute(final String sourceAttribute) {
            this.sourceAttribute = sourceAttribute;
            return self();
        }

        /**
         * Unique identifier (GUID) of the asset this request was made against.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B destinationGuid(final String destinationGuid) {
            this.destinationGuid = destinationGuid;
            return self();
        }

        /**
         * Unique name of the asset this request was made against.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B destinationQualifiedName(final String destinationQualifiedName) {
            this.destinationQualifiedName = destinationQualifiedName;
            return self();
        }

        /**
         * Attribute the request was made against.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B destinationAttribute(final String destinationAttribute) {
            this.destinationAttribute = destinationAttribute;
            return self();
        }

        /**
         * Requested value for the attribute.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B destinationValue(final String destinationValue) {
            this.destinationValue = destinationValue;
            return self();
        }

        /**
         * Type of the destination attribute value, for example `array`.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B destinationValueType(final String destinationValueType) {
            this.destinationValueType = destinationValueType;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B destinationValueArray(final Object destinationValueArray) {
            this.destinationValueArray = destinationValueArray;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B destinationValueObject(final Object destinationValueObject) {
            this.destinationValueObject = destinationValueObject;
            return self();
        }

        /**
         * Type of asset the change was requested against.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B entityType(final String entityType) {
            this.entityType = entityType;
            return self();
        }

        /**
         * Type of change the request is for.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestType(final String requestType) {
            this.requestType = requestType;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B confidenceScore(final Object confidenceScore) {
            this.confidenceScore = confidenceScore;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B botRunId(final Object botRunId) {
            this.botRunId = botRunId;
            return self();
        }

        /**
         * User who approved the request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B approvedBy(final String approvedBy) {
            this.approvedBy = approvedBy;
            return self();
        }

        /**
         * User who rejected the request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B rejectedBy(final String rejectedBy) {
            this.rejectedBy = rejectedBy;
            return self();
        }

        /**
         * Status of the request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B status(final AtlanRequestStatus status) {
            this.status = status;
            return self();
        }

        /**
         * Comment recorded with the approval or rejection of the request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B message(final String message) {
            this.message = message;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestsBatch(final Object requestsBatch) {
            this.requestsBatch = requestsBatch;
            return self();
        }

        /**
         * Type of approval required — currently only `single` is supported.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B approvalType(final String approvalType) {
            this.approvalType$value = approvalType;
            approvalType$set = true;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assignedApprovers(final Object assignedApprovers) {
            this.assignedApprovers = assignedApprovers;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B accessStartDate(final Object accessStartDate) {
            this.accessStartDate = accessStartDate;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B accessEndDate(final Object accessEndDate) {
            this.accessEndDate = accessEndDate;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B hash(final Long hash) {
            this.hash = hash;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isDuplicate(final Boolean isDuplicate) {
            this.isDuplicate = isDuplicate;
            return self();
        }

        /**
         * Semantic to use when applying the destination value, for example `append`.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B destinationValueAction(final String destinationValueAction) {
            this.destinationValueAction = destinationValueAction;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestApproverUser(final String requestApproverUser) {
            if (this.requestApproverUsers == null) this.requestApproverUsers = new java.util.ArrayList<String>();
            this.requestApproverUsers.add(requestApproverUser);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestApproverUsers(final java.util.Collection<? extends String> requestApproverUsers) {
            if (requestApproverUsers == null) {
                throw new java.lang.NullPointerException("requestApproverUsers cannot be null");
            }
            if (this.requestApproverUsers == null) this.requestApproverUsers = new java.util.ArrayList<String>();
            this.requestApproverUsers.addAll(requestApproverUsers);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearRequestApproverUsers() {
            if (this.requestApproverUsers != null) this.requestApproverUsers.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestApproverGroup(final String requestApproverGroup) {
            if (this.requestApproverGroups == null) this.requestApproverGroups = new java.util.ArrayList<String>();
            this.requestApproverGroups.add(requestApproverGroup);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestApproverGroups(final java.util.Collection<? extends String> requestApproverGroups) {
            if (requestApproverGroups == null) {
                throw new java.lang.NullPointerException("requestApproverGroups cannot be null");
            }
            if (this.requestApproverGroups == null) this.requestApproverGroups = new java.util.ArrayList<String>();
            this.requestApproverGroups.addAll(requestApproverGroups);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearRequestApproverGroups() {
            if (this.requestApproverGroups != null) this.requestApproverGroups.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestApproverRole(final String requestApproverRole) {
            if (this.requestApproverRoles == null) this.requestApproverRoles = new java.util.ArrayList<String>();
            this.requestApproverRoles.add(requestApproverRole);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestApproverRoles(final java.util.Collection<? extends String> requestApproverRoles) {
            if (requestApproverRoles == null) {
                throw new java.lang.NullPointerException("requestApproverRoles cannot be null");
            }
            if (this.requestApproverRoles == null) this.requestApproverRoles = new java.util.ArrayList<String>();
            this.requestApproverRoles.addAll(requestApproverRoles);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearRequestApproverRoles() {
            if (this.requestApproverRoles != null) this.requestApproverRoles.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestDenyUser(final String requestDenyUser) {
            if (this.requestDenyUsers == null) this.requestDenyUsers = new java.util.ArrayList<String>();
            this.requestDenyUsers.add(requestDenyUser);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestDenyUsers(final java.util.Collection<? extends String> requestDenyUsers) {
            if (requestDenyUsers == null) {
                throw new java.lang.NullPointerException("requestDenyUsers cannot be null");
            }
            if (this.requestDenyUsers == null) this.requestDenyUsers = new java.util.ArrayList<String>();
            this.requestDenyUsers.addAll(requestDenyUsers);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearRequestDenyUsers() {
            if (this.requestDenyUsers != null) this.requestDenyUsers.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestDenyGroup(final String requestDenyGroup) {
            if (this.requestDenyGroups == null) this.requestDenyGroups = new java.util.ArrayList<String>();
            this.requestDenyGroups.add(requestDenyGroup);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestDenyGroups(final java.util.Collection<? extends String> requestDenyGroups) {
            if (requestDenyGroups == null) {
                throw new java.lang.NullPointerException("requestDenyGroups cannot be null");
            }
            if (this.requestDenyGroups == null) this.requestDenyGroups = new java.util.ArrayList<String>();
            this.requestDenyGroups.addAll(requestDenyGroups);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearRequestDenyGroups() {
            if (this.requestDenyGroups != null) this.requestDenyGroups.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestDenyRole(final String requestDenyRole) {
            if (this.requestDenyRoles == null) this.requestDenyRoles = new java.util.ArrayList<String>();
            this.requestDenyRoles.add(requestDenyRole);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestDenyRoles(final java.util.Collection<? extends String> requestDenyRoles) {
            if (requestDenyRoles == null) {
                throw new java.lang.NullPointerException("requestDenyRoles cannot be null");
            }
            if (this.requestDenyRoles == null) this.requestDenyRoles = new java.util.ArrayList<String>();
            this.requestDenyRoles.addAll(requestDenyRoles);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearRequestDenyRoles() {
            if (this.requestDenyRoles != null) this.requestDenyRoles.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceEntity(final Object sourceEntity) {
            this.sourceEntity = sourceEntity;
            return self();
        }

        /**
         * Limited details about the asset this request was made against.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B destinationEntity(final Asset destinationEntity) {
            this.destinationEntity = destinationEntity;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanRequest.AtlanRequestBuilder(super=" + super.toString() + ", id=" + this.id + ", version=" + this.version + ", isActive=" + this.isActive + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", createdBy=" + this.createdBy + ", tenantId$value=" + this.tenantId$value + ", sourceType=" + this.sourceType + ", sourceGuid=" + this.sourceGuid + ", sourceQualifiedName=" + this.sourceQualifiedName + ", sourceAttribute=" + this.sourceAttribute + ", destinationGuid=" + this.destinationGuid + ", destinationQualifiedName=" + this.destinationQualifiedName + ", destinationAttribute=" + this.destinationAttribute + ", destinationValue=" + this.destinationValue + ", destinationValueType=" + this.destinationValueType + ", destinationValueArray=" + this.destinationValueArray + ", destinationValueObject=" + this.destinationValueObject + ", entityType=" + this.entityType + ", requestType=" + this.requestType + ", confidenceScore=" + this.confidenceScore + ", botRunId=" + this.botRunId + ", approvedBy=" + this.approvedBy + ", rejectedBy=" + this.rejectedBy + ", status=" + this.status + ", message=" + this.message + ", requestsBatch=" + this.requestsBatch + ", approvalType$value=" + this.approvalType$value + ", assignedApprovers=" + this.assignedApprovers + ", accessStartDate=" + this.accessStartDate + ", accessEndDate=" + this.accessEndDate + ", hash=" + this.hash + ", isDuplicate=" + this.isDuplicate + ", destinationValueAction=" + this.destinationValueAction + ", requestApproverUsers=" + this.requestApproverUsers + ", requestApproverGroups=" + this.requestApproverGroups + ", requestApproverRoles=" + this.requestApproverRoles + ", requestDenyUsers=" + this.requestDenyUsers + ", requestDenyGroups=" + this.requestDenyGroups + ", requestDenyRoles=" + this.requestDenyRoles + ", sourceEntity=" + this.sourceEntity + ", destinationEntity=" + this.destinationEntity + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AtlanRequest(final AtlanRequest.AtlanRequestBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.version = b.version;
        this.isActive = b.isActive;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.createdBy = b.createdBy;
        if (b.tenantId$set) this.tenantId = b.tenantId$value;
         else this.tenantId = AtlanRequest.$default$tenantId();
        this.sourceType = b.sourceType;
        this.sourceGuid = b.sourceGuid;
        this.sourceQualifiedName = b.sourceQualifiedName;
        this.sourceAttribute = b.sourceAttribute;
        this.destinationGuid = b.destinationGuid;
        this.destinationQualifiedName = b.destinationQualifiedName;
        this.destinationAttribute = b.destinationAttribute;
        this.destinationValue = b.destinationValue;
        this.destinationValueType = b.destinationValueType;
        this.destinationValueArray = b.destinationValueArray;
        this.destinationValueObject = b.destinationValueObject;
        this.entityType = b.entityType;
        this.requestType = b.requestType;
        this.confidenceScore = b.confidenceScore;
        this.botRunId = b.botRunId;
        this.approvedBy = b.approvedBy;
        this.rejectedBy = b.rejectedBy;
        this.status = b.status;
        this.message = b.message;
        this.requestsBatch = b.requestsBatch;
        if (b.approvalType$set) this.approvalType = b.approvalType$value;
         else this.approvalType = AtlanRequest.$default$approvalType();
        this.assignedApprovers = b.assignedApprovers;
        this.accessStartDate = b.accessStartDate;
        this.accessEndDate = b.accessEndDate;
        this.hash = b.hash;
        this.isDuplicate = b.isDuplicate;
        this.destinationValueAction = b.destinationValueAction;
        java.util.SortedSet<String> requestApproverUsers = new java.util.TreeSet<String>();
        if (b.requestApproverUsers != null) requestApproverUsers.addAll(b.requestApproverUsers);
        requestApproverUsers = java.util.Collections.unmodifiableSortedSet(requestApproverUsers);
        this.requestApproverUsers = requestApproverUsers;
        java.util.SortedSet<String> requestApproverGroups = new java.util.TreeSet<String>();
        if (b.requestApproverGroups != null) requestApproverGroups.addAll(b.requestApproverGroups);
        requestApproverGroups = java.util.Collections.unmodifiableSortedSet(requestApproverGroups);
        this.requestApproverGroups = requestApproverGroups;
        java.util.SortedSet<String> requestApproverRoles = new java.util.TreeSet<String>();
        if (b.requestApproverRoles != null) requestApproverRoles.addAll(b.requestApproverRoles);
        requestApproverRoles = java.util.Collections.unmodifiableSortedSet(requestApproverRoles);
        this.requestApproverRoles = requestApproverRoles;
        java.util.SortedSet<String> requestDenyUsers = new java.util.TreeSet<String>();
        if (b.requestDenyUsers != null) requestDenyUsers.addAll(b.requestDenyUsers);
        requestDenyUsers = java.util.Collections.unmodifiableSortedSet(requestDenyUsers);
        this.requestDenyUsers = requestDenyUsers;
        java.util.SortedSet<String> requestDenyGroups = new java.util.TreeSet<String>();
        if (b.requestDenyGroups != null) requestDenyGroups.addAll(b.requestDenyGroups);
        requestDenyGroups = java.util.Collections.unmodifiableSortedSet(requestDenyGroups);
        this.requestDenyGroups = requestDenyGroups;
        java.util.SortedSet<String> requestDenyRoles = new java.util.TreeSet<String>();
        if (b.requestDenyRoles != null) requestDenyRoles.addAll(b.requestDenyRoles);
        requestDenyRoles = java.util.Collections.unmodifiableSortedSet(requestDenyRoles);
        this.requestDenyRoles = requestDenyRoles;
        this.sourceEntity = b.sourceEntity;
        this.destinationEntity = b.destinationEntity;
    }

    /**
     * Unique identifier for the request (GUID).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
        return this.id;
    }

    /**
     * Unique version name for the request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getVersion() {
        return this.version;
    }

    /**
     * If true, the request is still open.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsActive() {
        return this.isActive;
    }

    /**
     * Date and time at which the request was created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCreatedAt() {
        return this.createdAt;
    }

    /**
     * Date and time at which the request was last updated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    /**
     * User who created the request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    /**
     * Name of the tenant for the request (usually `default`).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTenantId() {
        return this.tenantId;
    }

    /**
     * Should be `static` for an ATTRIBUTE or CUSTOM_METADATA requestType, and `atlas` for other request types.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceType() {
        return this.sourceType;
    }

    /**
     * Unique identifier (GUID) of the asset being related through this request, for example the term's GUID for a TERM_LINK.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceGuid() {
        return this.sourceGuid;
    }

    /**
     * Unique name of the asset being related through this request, for example the term's qualifiedName for a TERM_LINK.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceQualifiedName() {
        return this.sourceQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceAttribute() {
        return this.sourceAttribute;
    }

    /**
     * Unique identifier (GUID) of the asset this request was made against.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDestinationGuid() {
        return this.destinationGuid;
    }

    /**
     * Unique name of the asset this request was made against.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDestinationQualifiedName() {
        return this.destinationQualifiedName;
    }

    /**
     * Attribute the request was made against.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDestinationAttribute() {
        return this.destinationAttribute;
    }

    /**
     * Requested value for the attribute.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDestinationValue() {
        return this.destinationValue;
    }

    /**
     * Type of the destination attribute value, for example `array`.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDestinationValueType() {
        return this.destinationValueType;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getDestinationValueArray() {
        return this.destinationValueArray;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getDestinationValueObject() {
        return this.destinationValueObject;
    }

    /**
     * Type of asset the change was requested against.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEntityType() {
        return this.entityType;
    }

    /**
     * Type of change the request is for.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRequestType() {
        return this.requestType;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getConfidenceScore() {
        return this.confidenceScore;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getBotRunId() {
        return this.botRunId;
    }

    /**
     * User who approved the request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApprovedBy() {
        return this.approvedBy;
    }

    /**
     * User who rejected the request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRejectedBy() {
        return this.rejectedBy;
    }

    /**
     * Status of the request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanRequestStatus getStatus() {
        return this.status;
    }

    /**
     * Comment recorded with the approval or rejection of the request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMessage() {
        return this.message;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getRequestsBatch() {
        return this.requestsBatch;
    }

    /**
     * Type of approval required — currently only `single` is supported.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApprovalType() {
        return this.approvalType;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getAssignedApprovers() {
        return this.assignedApprovers;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getAccessStartDate() {
        return this.accessStartDate;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getAccessEndDate() {
        return this.accessEndDate;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getHash() {
        return this.hash;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsDuplicate() {
        return this.isDuplicate;
    }

    /**
     * Semantic to use when applying the destination value, for example `append`.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDestinationValueAction() {
        return this.destinationValueAction;
    }

    /**
     * Names of users (in Keycloak) that can approve this request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getRequestApproverUsers() {
        return this.requestApproverUsers;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getRequestApproverGroups() {
        return this.requestApproverGroups;
    }

    /**
     * Names of roles (in Keycloak) that can approve this request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getRequestApproverRoles() {
        return this.requestApproverRoles;
    }

    /**
     * Names of users (in Keycloak) that can deny this request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getRequestDenyUsers() {
        return this.requestDenyUsers;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getRequestDenyGroups() {
        return this.requestDenyGroups;
    }

    /**
     * Unique identifiers (GUIDs) of the roles that can deny this request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getRequestDenyRoles() {
        return this.requestDenyRoles;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getSourceEntity() {
        return this.sourceEntity;
    }

    /**
     * Limited details about the asset this request was made against.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Asset getDestinationEntity() {
        return this.destinationEntity;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanRequest)) return false;
        final AtlanRequest other = (AtlanRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$isActive = this.getIsActive();
        final java.lang.Object other$isActive = other.getIsActive();
        if (this$isActive == null ? other$isActive != null : !this$isActive.equals(other$isActive)) return false;
        final java.lang.Object this$createdAt = this.getCreatedAt();
        final java.lang.Object other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) return false;
        final java.lang.Object this$updatedAt = this.getUpdatedAt();
        final java.lang.Object other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) return false;
        final java.lang.Object this$hash = this.getHash();
        final java.lang.Object other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) return false;
        final java.lang.Object this$isDuplicate = this.getIsDuplicate();
        final java.lang.Object other$isDuplicate = other.getIsDuplicate();
        if (this$isDuplicate == null ? other$isDuplicate != null : !this$isDuplicate.equals(other$isDuplicate)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$version = this.getVersion();
        final java.lang.Object other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
        final java.lang.Object this$createdBy = this.getCreatedBy();
        final java.lang.Object other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) return false;
        final java.lang.Object this$tenantId = this.getTenantId();
        final java.lang.Object other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) return false;
        final java.lang.Object this$sourceType = this.getSourceType();
        final java.lang.Object other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) return false;
        final java.lang.Object this$sourceGuid = this.getSourceGuid();
        final java.lang.Object other$sourceGuid = other.getSourceGuid();
        if (this$sourceGuid == null ? other$sourceGuid != null : !this$sourceGuid.equals(other$sourceGuid)) return false;
        final java.lang.Object this$sourceQualifiedName = this.getSourceQualifiedName();
        final java.lang.Object other$sourceQualifiedName = other.getSourceQualifiedName();
        if (this$sourceQualifiedName == null ? other$sourceQualifiedName != null : !this$sourceQualifiedName.equals(other$sourceQualifiedName)) return false;
        final java.lang.Object this$sourceAttribute = this.getSourceAttribute();
        final java.lang.Object other$sourceAttribute = other.getSourceAttribute();
        if (this$sourceAttribute == null ? other$sourceAttribute != null : !this$sourceAttribute.equals(other$sourceAttribute)) return false;
        final java.lang.Object this$destinationGuid = this.getDestinationGuid();
        final java.lang.Object other$destinationGuid = other.getDestinationGuid();
        if (this$destinationGuid == null ? other$destinationGuid != null : !this$destinationGuid.equals(other$destinationGuid)) return false;
        final java.lang.Object this$destinationQualifiedName = this.getDestinationQualifiedName();
        final java.lang.Object other$destinationQualifiedName = other.getDestinationQualifiedName();
        if (this$destinationQualifiedName == null ? other$destinationQualifiedName != null : !this$destinationQualifiedName.equals(other$destinationQualifiedName)) return false;
        final java.lang.Object this$destinationAttribute = this.getDestinationAttribute();
        final java.lang.Object other$destinationAttribute = other.getDestinationAttribute();
        if (this$destinationAttribute == null ? other$destinationAttribute != null : !this$destinationAttribute.equals(other$destinationAttribute)) return false;
        final java.lang.Object this$destinationValue = this.getDestinationValue();
        final java.lang.Object other$destinationValue = other.getDestinationValue();
        if (this$destinationValue == null ? other$destinationValue != null : !this$destinationValue.equals(other$destinationValue)) return false;
        final java.lang.Object this$destinationValueType = this.getDestinationValueType();
        final java.lang.Object other$destinationValueType = other.getDestinationValueType();
        if (this$destinationValueType == null ? other$destinationValueType != null : !this$destinationValueType.equals(other$destinationValueType)) return false;
        final java.lang.Object this$destinationValueArray = this.getDestinationValueArray();
        final java.lang.Object other$destinationValueArray = other.getDestinationValueArray();
        if (this$destinationValueArray == null ? other$destinationValueArray != null : !this$destinationValueArray.equals(other$destinationValueArray)) return false;
        final java.lang.Object this$destinationValueObject = this.getDestinationValueObject();
        final java.lang.Object other$destinationValueObject = other.getDestinationValueObject();
        if (this$destinationValueObject == null ? other$destinationValueObject != null : !this$destinationValueObject.equals(other$destinationValueObject)) return false;
        final java.lang.Object this$entityType = this.getEntityType();
        final java.lang.Object other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) return false;
        final java.lang.Object this$requestType = this.getRequestType();
        final java.lang.Object other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType)) return false;
        final java.lang.Object this$confidenceScore = this.getConfidenceScore();
        final java.lang.Object other$confidenceScore = other.getConfidenceScore();
        if (this$confidenceScore == null ? other$confidenceScore != null : !this$confidenceScore.equals(other$confidenceScore)) return false;
        final java.lang.Object this$botRunId = this.getBotRunId();
        final java.lang.Object other$botRunId = other.getBotRunId();
        if (this$botRunId == null ? other$botRunId != null : !this$botRunId.equals(other$botRunId)) return false;
        final java.lang.Object this$approvedBy = this.getApprovedBy();
        final java.lang.Object other$approvedBy = other.getApprovedBy();
        if (this$approvedBy == null ? other$approvedBy != null : !this$approvedBy.equals(other$approvedBy)) return false;
        final java.lang.Object this$rejectedBy = this.getRejectedBy();
        final java.lang.Object other$rejectedBy = other.getRejectedBy();
        if (this$rejectedBy == null ? other$rejectedBy != null : !this$rejectedBy.equals(other$rejectedBy)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        final java.lang.Object this$message = this.getMessage();
        final java.lang.Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
        final java.lang.Object this$requestsBatch = this.getRequestsBatch();
        final java.lang.Object other$requestsBatch = other.getRequestsBatch();
        if (this$requestsBatch == null ? other$requestsBatch != null : !this$requestsBatch.equals(other$requestsBatch)) return false;
        final java.lang.Object this$approvalType = this.getApprovalType();
        final java.lang.Object other$approvalType = other.getApprovalType();
        if (this$approvalType == null ? other$approvalType != null : !this$approvalType.equals(other$approvalType)) return false;
        final java.lang.Object this$assignedApprovers = this.getAssignedApprovers();
        final java.lang.Object other$assignedApprovers = other.getAssignedApprovers();
        if (this$assignedApprovers == null ? other$assignedApprovers != null : !this$assignedApprovers.equals(other$assignedApprovers)) return false;
        final java.lang.Object this$accessStartDate = this.getAccessStartDate();
        final java.lang.Object other$accessStartDate = other.getAccessStartDate();
        if (this$accessStartDate == null ? other$accessStartDate != null : !this$accessStartDate.equals(other$accessStartDate)) return false;
        final java.lang.Object this$accessEndDate = this.getAccessEndDate();
        final java.lang.Object other$accessEndDate = other.getAccessEndDate();
        if (this$accessEndDate == null ? other$accessEndDate != null : !this$accessEndDate.equals(other$accessEndDate)) return false;
        final java.lang.Object this$destinationValueAction = this.getDestinationValueAction();
        final java.lang.Object other$destinationValueAction = other.getDestinationValueAction();
        if (this$destinationValueAction == null ? other$destinationValueAction != null : !this$destinationValueAction.equals(other$destinationValueAction)) return false;
        final java.lang.Object this$requestApproverUsers = this.getRequestApproverUsers();
        final java.lang.Object other$requestApproverUsers = other.getRequestApproverUsers();
        if (this$requestApproverUsers == null ? other$requestApproverUsers != null : !this$requestApproverUsers.equals(other$requestApproverUsers)) return false;
        final java.lang.Object this$requestApproverGroups = this.getRequestApproverGroups();
        final java.lang.Object other$requestApproverGroups = other.getRequestApproverGroups();
        if (this$requestApproverGroups == null ? other$requestApproverGroups != null : !this$requestApproverGroups.equals(other$requestApproverGroups)) return false;
        final java.lang.Object this$requestApproverRoles = this.getRequestApproverRoles();
        final java.lang.Object other$requestApproverRoles = other.getRequestApproverRoles();
        if (this$requestApproverRoles == null ? other$requestApproverRoles != null : !this$requestApproverRoles.equals(other$requestApproverRoles)) return false;
        final java.lang.Object this$requestDenyUsers = this.getRequestDenyUsers();
        final java.lang.Object other$requestDenyUsers = other.getRequestDenyUsers();
        if (this$requestDenyUsers == null ? other$requestDenyUsers != null : !this$requestDenyUsers.equals(other$requestDenyUsers)) return false;
        final java.lang.Object this$requestDenyGroups = this.getRequestDenyGroups();
        final java.lang.Object other$requestDenyGroups = other.getRequestDenyGroups();
        if (this$requestDenyGroups == null ? other$requestDenyGroups != null : !this$requestDenyGroups.equals(other$requestDenyGroups)) return false;
        final java.lang.Object this$requestDenyRoles = this.getRequestDenyRoles();
        final java.lang.Object other$requestDenyRoles = other.getRequestDenyRoles();
        if (this$requestDenyRoles == null ? other$requestDenyRoles != null : !this$requestDenyRoles.equals(other$requestDenyRoles)) return false;
        final java.lang.Object this$sourceEntity = this.getSourceEntity();
        final java.lang.Object other$sourceEntity = other.getSourceEntity();
        if (this$sourceEntity == null ? other$sourceEntity != null : !this$sourceEntity.equals(other$sourceEntity)) return false;
        final java.lang.Object this$destinationEntity = this.getDestinationEntity();
        final java.lang.Object other$destinationEntity = other.getDestinationEntity();
        if (this$destinationEntity == null ? other$destinationEntity != null : !this$destinationEntity.equals(other$destinationEntity)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AtlanRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $isActive = this.getIsActive();
        result = result * PRIME + ($isActive == null ? 43 : $isActive.hashCode());
        final java.lang.Object $createdAt = this.getCreatedAt();
        result = result * PRIME + ($createdAt == null ? 43 : $createdAt.hashCode());
        final java.lang.Object $updatedAt = this.getUpdatedAt();
        result = result * PRIME + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        final java.lang.Object $hash = this.getHash();
        result = result * PRIME + ($hash == null ? 43 : $hash.hashCode());
        final java.lang.Object $isDuplicate = this.getIsDuplicate();
        result = result * PRIME + ($isDuplicate == null ? 43 : $isDuplicate.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $version = this.getVersion();
        result = result * PRIME + ($version == null ? 43 : $version.hashCode());
        final java.lang.Object $createdBy = this.getCreatedBy();
        result = result * PRIME + ($createdBy == null ? 43 : $createdBy.hashCode());
        final java.lang.Object $tenantId = this.getTenantId();
        result = result * PRIME + ($tenantId == null ? 43 : $tenantId.hashCode());
        final java.lang.Object $sourceType = this.getSourceType();
        result = result * PRIME + ($sourceType == null ? 43 : $sourceType.hashCode());
        final java.lang.Object $sourceGuid = this.getSourceGuid();
        result = result * PRIME + ($sourceGuid == null ? 43 : $sourceGuid.hashCode());
        final java.lang.Object $sourceQualifiedName = this.getSourceQualifiedName();
        result = result * PRIME + ($sourceQualifiedName == null ? 43 : $sourceQualifiedName.hashCode());
        final java.lang.Object $sourceAttribute = this.getSourceAttribute();
        result = result * PRIME + ($sourceAttribute == null ? 43 : $sourceAttribute.hashCode());
        final java.lang.Object $destinationGuid = this.getDestinationGuid();
        result = result * PRIME + ($destinationGuid == null ? 43 : $destinationGuid.hashCode());
        final java.lang.Object $destinationQualifiedName = this.getDestinationQualifiedName();
        result = result * PRIME + ($destinationQualifiedName == null ? 43 : $destinationQualifiedName.hashCode());
        final java.lang.Object $destinationAttribute = this.getDestinationAttribute();
        result = result * PRIME + ($destinationAttribute == null ? 43 : $destinationAttribute.hashCode());
        final java.lang.Object $destinationValue = this.getDestinationValue();
        result = result * PRIME + ($destinationValue == null ? 43 : $destinationValue.hashCode());
        final java.lang.Object $destinationValueType = this.getDestinationValueType();
        result = result * PRIME + ($destinationValueType == null ? 43 : $destinationValueType.hashCode());
        final java.lang.Object $destinationValueArray = this.getDestinationValueArray();
        result = result * PRIME + ($destinationValueArray == null ? 43 : $destinationValueArray.hashCode());
        final java.lang.Object $destinationValueObject = this.getDestinationValueObject();
        result = result * PRIME + ($destinationValueObject == null ? 43 : $destinationValueObject.hashCode());
        final java.lang.Object $entityType = this.getEntityType();
        result = result * PRIME + ($entityType == null ? 43 : $entityType.hashCode());
        final java.lang.Object $requestType = this.getRequestType();
        result = result * PRIME + ($requestType == null ? 43 : $requestType.hashCode());
        final java.lang.Object $confidenceScore = this.getConfidenceScore();
        result = result * PRIME + ($confidenceScore == null ? 43 : $confidenceScore.hashCode());
        final java.lang.Object $botRunId = this.getBotRunId();
        result = result * PRIME + ($botRunId == null ? 43 : $botRunId.hashCode());
        final java.lang.Object $approvedBy = this.getApprovedBy();
        result = result * PRIME + ($approvedBy == null ? 43 : $approvedBy.hashCode());
        final java.lang.Object $rejectedBy = this.getRejectedBy();
        result = result * PRIME + ($rejectedBy == null ? 43 : $rejectedBy.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        final java.lang.Object $message = this.getMessage();
        result = result * PRIME + ($message == null ? 43 : $message.hashCode());
        final java.lang.Object $requestsBatch = this.getRequestsBatch();
        result = result * PRIME + ($requestsBatch == null ? 43 : $requestsBatch.hashCode());
        final java.lang.Object $approvalType = this.getApprovalType();
        result = result * PRIME + ($approvalType == null ? 43 : $approvalType.hashCode());
        final java.lang.Object $assignedApprovers = this.getAssignedApprovers();
        result = result * PRIME + ($assignedApprovers == null ? 43 : $assignedApprovers.hashCode());
        final java.lang.Object $accessStartDate = this.getAccessStartDate();
        result = result * PRIME + ($accessStartDate == null ? 43 : $accessStartDate.hashCode());
        final java.lang.Object $accessEndDate = this.getAccessEndDate();
        result = result * PRIME + ($accessEndDate == null ? 43 : $accessEndDate.hashCode());
        final java.lang.Object $destinationValueAction = this.getDestinationValueAction();
        result = result * PRIME + ($destinationValueAction == null ? 43 : $destinationValueAction.hashCode());
        final java.lang.Object $requestApproverUsers = this.getRequestApproverUsers();
        result = result * PRIME + ($requestApproverUsers == null ? 43 : $requestApproverUsers.hashCode());
        final java.lang.Object $requestApproverGroups = this.getRequestApproverGroups();
        result = result * PRIME + ($requestApproverGroups == null ? 43 : $requestApproverGroups.hashCode());
        final java.lang.Object $requestApproverRoles = this.getRequestApproverRoles();
        result = result * PRIME + ($requestApproverRoles == null ? 43 : $requestApproverRoles.hashCode());
        final java.lang.Object $requestDenyUsers = this.getRequestDenyUsers();
        result = result * PRIME + ($requestDenyUsers == null ? 43 : $requestDenyUsers.hashCode());
        final java.lang.Object $requestDenyGroups = this.getRequestDenyGroups();
        result = result * PRIME + ($requestDenyGroups == null ? 43 : $requestDenyGroups.hashCode());
        final java.lang.Object $requestDenyRoles = this.getRequestDenyRoles();
        result = result * PRIME + ($requestDenyRoles == null ? 43 : $requestDenyRoles.hashCode());
        final java.lang.Object $sourceEntity = this.getSourceEntity();
        result = result * PRIME + ($sourceEntity == null ? 43 : $sourceEntity.hashCode());
        final java.lang.Object $destinationEntity = this.getDestinationEntity();
        result = result * PRIME + ($destinationEntity == null ? 43 : $destinationEntity.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanRequest(super=" + super.toString() + ", id=" + this.getId() + ", version=" + this.getVersion() + ", isActive=" + this.getIsActive() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", createdBy=" + this.getCreatedBy() + ", tenantId=" + this.getTenantId() + ", sourceType=" + this.getSourceType() + ", sourceGuid=" + this.getSourceGuid() + ", sourceQualifiedName=" + this.getSourceQualifiedName() + ", sourceAttribute=" + this.getSourceAttribute() + ", destinationGuid=" + this.getDestinationGuid() + ", destinationQualifiedName=" + this.getDestinationQualifiedName() + ", destinationAttribute=" + this.getDestinationAttribute() + ", destinationValue=" + this.getDestinationValue() + ", destinationValueType=" + this.getDestinationValueType() + ", destinationValueArray=" + this.getDestinationValueArray() + ", destinationValueObject=" + this.getDestinationValueObject() + ", entityType=" + this.getEntityType() + ", requestType=" + this.getRequestType() + ", confidenceScore=" + this.getConfidenceScore() + ", botRunId=" + this.getBotRunId() + ", approvedBy=" + this.getApprovedBy() + ", rejectedBy=" + this.getRejectedBy() + ", status=" + this.getStatus() + ", message=" + this.getMessage() + ", requestsBatch=" + this.getRequestsBatch() + ", approvalType=" + this.getApprovalType() + ", assignedApprovers=" + this.getAssignedApprovers() + ", accessStartDate=" + this.getAccessStartDate() + ", accessEndDate=" + this.getAccessEndDate() + ", hash=" + this.getHash() + ", isDuplicate=" + this.getIsDuplicate() + ", destinationValueAction=" + this.getDestinationValueAction() + ", requestApproverUsers=" + this.getRequestApproverUsers() + ", requestApproverGroups=" + this.getRequestApproverGroups() + ", requestApproverRoles=" + this.getRequestApproverRoles() + ", requestDenyUsers=" + this.getRequestDenyUsers() + ", requestDenyGroups=" + this.getRequestDenyGroups() + ", requestDenyRoles=" + this.getRequestDenyRoles() + ", sourceEntity=" + this.getSourceEntity() + ", destinationEntity=" + this.getDestinationEntity() + ")";
    }
}
