// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import java.util.List;

/**
 * Captures the details of an Atlan tag in a request.
 */
public class AtlanTagPayload extends AtlanRequestPayload {
    private static final long serialVersionUID = 2L;
    /**
     * Name of the Atlan tag.
     */
    String typeName;
    /**
     * Whether the Atlan tag should propagate.
     */
    Boolean propagate;
    /**
     * Whether removing the Atlan tag should also remove its propagations.
     */
    Boolean removePropagationsOnEntityDelete;
    /**
     * Unused.
     */
    List<Object> validityPeriods;

    /**
     * Create a Atlan tag payload with the specified Atlan tag and defaults for propagation.
     *
     * @param atlanTagName human-readable name of the Atlan tag
     * @return the Atlan tag payload with defaults for propagation
     */
    public static AtlanTagPayload of(String atlanTagName) {
        return AtlanTagPayload.builder().typeName(atlanTagName).build();
    }

    /**
     * Create an Atlan tag payload with the specified details.
     *
     * @param atlanTagName human-readable name of the Atlan tag
     * @param propagate whether the Atlan tag should propagate (true) or not (false)
     * @param removePropagationsOnDelete whether the propagated Atlan tags should be cascaded (true) or not (false)
     * @return the Atlan tag payload with the specified propagation settings
     */
    public static AtlanTagPayload of(String atlanTagName, boolean propagate, boolean removePropagationsOnDelete) {
        return AtlanTagPayload.builder().typeName(atlanTagName).propagate(propagate).removePropagationsOnEntityDelete(removePropagationsOnDelete).build();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$propagate() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$removePropagationsOnEntityDelete() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    AtlanTagPayload(final String typeName, final Boolean propagate, final Boolean removePropagationsOnEntityDelete, final List<Object> validityPeriods) {
        this.typeName = typeName;
        this.propagate = propagate;
        this.removePropagationsOnEntityDelete = removePropagationsOnEntityDelete;
        this.validityPeriods = validityPeriods;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class AtlanTagPayloadBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean propagate$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean propagate$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean removePropagationsOnEntityDelete$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean removePropagationsOnEntityDelete$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<Object> validityPeriods;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        AtlanTagPayloadBuilder() {
        }

        /**
         * Name of the Atlan tag.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanTagPayload.AtlanTagPayloadBuilder typeName(final String typeName) {
            this.typeName = typeName;
            return this;
        }

        /**
         * Whether the Atlan tag should propagate.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanTagPayload.AtlanTagPayloadBuilder propagate(final Boolean propagate) {
            this.propagate$value = propagate;
            propagate$set = true;
            return this;
        }

        /**
         * Whether removing the Atlan tag should also remove its propagations.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanTagPayload.AtlanTagPayloadBuilder removePropagationsOnEntityDelete(final Boolean removePropagationsOnEntityDelete) {
            this.removePropagationsOnEntityDelete$value = removePropagationsOnEntityDelete;
            removePropagationsOnEntityDelete$set = true;
            return this;
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanTagPayload.AtlanTagPayloadBuilder validityPeriods(final List<Object> validityPeriods) {
            this.validityPeriods = validityPeriods;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanTagPayload build() {
            Boolean propagate$value = this.propagate$value;
            if (!this.propagate$set) propagate$value = AtlanTagPayload.$default$propagate();
            Boolean removePropagationsOnEntityDelete$value = this.removePropagationsOnEntityDelete$value;
            if (!this.removePropagationsOnEntityDelete$set) removePropagationsOnEntityDelete$value = AtlanTagPayload.$default$removePropagationsOnEntityDelete();
            return new AtlanTagPayload(this.typeName, propagate$value, removePropagationsOnEntityDelete$value, this.validityPeriods);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanTagPayload.AtlanTagPayloadBuilder(typeName=" + this.typeName + ", propagate$value=" + this.propagate$value + ", removePropagationsOnEntityDelete$value=" + this.removePropagationsOnEntityDelete$value + ", validityPeriods=" + this.validityPeriods + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AtlanTagPayload.AtlanTagPayloadBuilder builder() {
        return new AtlanTagPayload.AtlanTagPayloadBuilder();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTagPayload.AtlanTagPayloadBuilder toBuilder() {
        return new AtlanTagPayload.AtlanTagPayloadBuilder().typeName(this.typeName).propagate(this.propagate).removePropagationsOnEntityDelete(this.removePropagationsOnEntityDelete).validityPeriods(this.validityPeriods);
    }

    /**
     * Name of the Atlan tag.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }

    /**
     * Whether the Atlan tag should propagate.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPropagate() {
        return this.propagate;
    }

    /**
     * Whether removing the Atlan tag should also remove its propagations.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRemovePropagationsOnEntityDelete() {
        return this.removePropagationsOnEntityDelete;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Object> getValidityPeriods() {
        return this.validityPeriods;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanTagPayload)) return false;
        final AtlanTagPayload other = (AtlanTagPayload) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$propagate = this.getPropagate();
        final java.lang.Object other$propagate = other.getPropagate();
        if (this$propagate == null ? other$propagate != null : !this$propagate.equals(other$propagate)) return false;
        final java.lang.Object this$removePropagationsOnEntityDelete = this.getRemovePropagationsOnEntityDelete();
        final java.lang.Object other$removePropagationsOnEntityDelete = other.getRemovePropagationsOnEntityDelete();
        if (this$removePropagationsOnEntityDelete == null ? other$removePropagationsOnEntityDelete != null : !this$removePropagationsOnEntityDelete.equals(other$removePropagationsOnEntityDelete)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$validityPeriods = this.getValidityPeriods();
        final java.lang.Object other$validityPeriods = other.getValidityPeriods();
        if (this$validityPeriods == null ? other$validityPeriods != null : !this$validityPeriods.equals(other$validityPeriods)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AtlanTagPayload;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $propagate = this.getPropagate();
        result = result * PRIME + ($propagate == null ? 43 : $propagate.hashCode());
        final java.lang.Object $removePropagationsOnEntityDelete = this.getRemovePropagationsOnEntityDelete();
        result = result * PRIME + ($removePropagationsOnEntityDelete == null ? 43 : $removePropagationsOnEntityDelete.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $validityPeriods = this.getValidityPeriods();
        result = result * PRIME + ($validityPeriods == null ? 43 : $validityPeriods.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanTagPayload(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", propagate=" + this.getPropagate() + ", removePropagationsOnEntityDelete=" + this.getRemovePropagationsOnEntityDelete() + ", validityPeriods=" + this.getValidityPeriods() + ")";
    }
}
