// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Asset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class AtlanTagRequest extends AtlanRequest {
    private static final long serialVersionUID = 2L;
    public static final String REQUEST_TYPE = "attach_classification";
    public static final String SOURCE_TYPE = "atlas";
    /**
     * Fixed requestType for Atlan tags.
     */
    String requestType;
    /**
     * Fixed sourceType for Atlan tags.
     */
    String sourceType;
    /**
     * Details of the requested Atlan tag.
     */
    AtlanTagPayload payload;

    /**
     * Create a new request to attach an Atlan tag to an asset.
     * Note that the asset must have at least its real (not placeholder) GUID and qualifiedName populated.
     *
     * @param asset against which to raise the request
     * @param atlanTagDetails details of the requested Atlan tag
     * @return a builder for the request with these details
     * @throws InvalidRequestException if any of the required details for the provided asset are missing
     */
    public static AtlanTagRequestBuilder<?, ?> creator(Asset asset, AtlanTagPayload atlanTagDetails) throws InvalidRequestException {
        List<String> missing = new ArrayList<>();
        if (asset.getQualifiedName() == null || asset.getQualifiedName().isEmpty()) {
            missing.add("qualifiedName");
        }
        if (asset.getGuid() == null || asset.getGuid().isEmpty()) {
            missing.add("guid");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, asset.getTypeName(), String.join(",", missing));
        }
        return creator(asset.getGuid(), asset.getQualifiedName(), asset.getTypeName(), atlanTagDetails);
    }

    /**
     * Create a new request to attach an Atlan tag to an asset.
     *
     * @param assetGuid unique identifier (GUID) of the asset to classify
     * @param assetQualifiedName qualifiedName of the asset to classify
     * @param assetType type of the asset to classify
     * @param atlanTagDetails details of the requested Atlan tag
     * @return a builder for the request with these details
     */
    public static AtlanTagRequestBuilder<?, ?> creator(String assetGuid, String assetQualifiedName, String assetType, AtlanTagPayload atlanTagDetails) {
        return AtlanTagRequest.builder().id(UUID.randomUUID().toString()).destinationGuid(assetGuid).destinationQualifiedName(assetQualifiedName).entityType(assetType).payload(atlanTagDetails);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$requestType() {
        return REQUEST_TYPE;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$sourceType() {
        return SOURCE_TYPE;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AtlanTagRequestBuilder<C extends AtlanTagRequest, B extends AtlanTagRequest.AtlanTagRequestBuilder<C, B>> extends AtlanRequest.AtlanRequestBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean requestType$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String requestType$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean sourceType$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceType$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTagPayload payload;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AtlanTagRequest.AtlanTagRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AtlanTagRequest instance, final AtlanTagRequest.AtlanTagRequestBuilder<?, ?> b) {
            b.requestType(instance.requestType);
            b.sourceType(instance.sourceType);
            b.payload(instance.payload);
        }

        /**
         * Fixed requestType for Atlan tags.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestType(final String requestType) {
            this.requestType$value = requestType;
            requestType$set = true;
            return self();
        }

        /**
         * Fixed sourceType for Atlan tags.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceType(final String sourceType) {
            this.sourceType$value = sourceType;
            sourceType$set = true;
            return self();
        }

        /**
         * Details of the requested Atlan tag.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B payload(final AtlanTagPayload payload) {
            this.payload = payload;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanTagRequest.AtlanTagRequestBuilder(super=" + super.toString() + ", requestType$value=" + this.requestType$value + ", sourceType$value=" + this.sourceType$value + ", payload=" + this.payload + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AtlanTagRequestBuilderImpl extends AtlanTagRequest.AtlanTagRequestBuilder<AtlanTagRequest, AtlanTagRequest.AtlanTagRequestBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTagRequestBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AtlanTagRequest.AtlanTagRequestBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanTagRequest build() {
            return new AtlanTagRequest(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AtlanTagRequest(final AtlanTagRequest.AtlanTagRequestBuilder<?, ?> b) {
        super(b);
        if (b.requestType$set) this.requestType = b.requestType$value;
         else this.requestType = AtlanTagRequest.$default$requestType();
        if (b.sourceType$set) this.sourceType = b.sourceType$value;
         else this.sourceType = AtlanTagRequest.$default$sourceType();
        this.payload = b.payload;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AtlanTagRequest.AtlanTagRequestBuilder<?, ?> builder() {
        return new AtlanTagRequest.AtlanTagRequestBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTagRequest.AtlanTagRequestBuilder<?, ?> toBuilder() {
        return new AtlanTagRequest.AtlanTagRequestBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Details of the requested Atlan tag.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTagPayload getPayload() {
        return this.payload;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanTagRequest)) return false;
        final AtlanTagRequest other = (AtlanTagRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$requestType = this.getRequestType();
        final java.lang.Object other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType)) return false;
        final java.lang.Object this$sourceType = this.getSourceType();
        final java.lang.Object other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) return false;
        final java.lang.Object this$payload = this.getPayload();
        final java.lang.Object other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AtlanTagRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $requestType = this.getRequestType();
        result = result * PRIME + ($requestType == null ? 43 : $requestType.hashCode());
        final java.lang.Object $sourceType = this.getSourceType();
        result = result * PRIME + ($sourceType == null ? 43 : $sourceType.hashCode());
        final java.lang.Object $payload = this.getPayload();
        result = result * PRIME + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanTagRequest(super=" + super.toString() + ", requestType=" + this.getRequestType() + ", sourceType=" + this.getSourceType() + ", payload=" + this.getPayload() + ")";
    }

    /**
     * Fixed requestType for Atlan tags.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRequestType() {
        return this.requestType;
    }

    /**
     * Fixed sourceType for Atlan tags.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceType() {
        return this.sourceType;
    }
}
