// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import lombok.*;

@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AtlanUser.AtlanUserBuilderImpl.class)
public class AtlanUser extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Username of the user within Atlan.
     */
    String username;
    /**
     * Unique identifier (GUID) of the user within Atlan.
     */
    String id;
    /**
     * Name of the role of the user within Atlan.
     */
    String workspaceRole;
    /**
     * Email address of the user.
     */
    String email;
    /**
     * When true, the email address of the user has been verified.
     */
    Boolean emailVerified;
    /**
     * When true, the user is enabled. When false, the user has been deactivated.
     */
    Boolean enabled;
    /**
     * First name of the user.
     */
    String firstName;
    /**
     * Last name (surname) of the user.
     */
    String lastName;
    /**
     * Detailed attributes of the user.
     */
    UserAttributes attributes;
    /**
     * Time (epoch) at which the user was created, in milliseconds.
     */
    Long createdTimestamp;
    /**
     * Time (epoch) at which the user last logged into Atlan.
     */
    Long lastLoginTime;
    /**
     * Number of groups to which the user belongs.
     */
    Long groupCount;
    /**
     * TBC
     */
    List<String> defaultRoles;
    /**
     * TBC
     */
    List<String> roles;
    // TODO
    /**
     * TBC
     */
    @JsonIgnore
    String decentralizedRoles;
    /**
     * Personas the user is associated with.
     */
    SortedSet<AtlanUser.Persona> personas;
    // TODO
    /**
     * Purposes the user is associated with.
     */
    @JsonIgnore
    SortedSet<String> purposes;
    /**
     * List of administration-related events for this user.
     */
    final List<AdminEvent> adminEvents;
    /**
     * List of login-related events for this user.
     */
    final List<KeycloakEvent> loginEvents;

    /**
     * Builds the minimal object necessary to create (invite) a user.
     *
     * @param email email address of the user
     * @param roleName name of the role for the user ({@code $admin}, {@code $member}, or {@code $guest})
     * @return the minimal request necessary to update the user, as a builder
     */
    public static AtlanUserBuilder<?, ?> creator(String email, String roleName) {
        return AtlanUser.builder().email(email).workspaceRole(roleName);
    }

    /**
     * Builds the minimal object necessary to update a user.
     *
     * @param id unique identifier (GUID) of the user
     * @return the minimal request necessary to update the user, as a builder
     */
    public static AtlanUserBuilder<?, ?> updater(String id) {
        return AtlanUser.builder().id(id);
    }

    /**
     * Send this user to Atlan to create the user in Atlan.
     *
     * @throws AtlanException on any error during API invocation
     */
    public void create() throws AtlanException {
        create(Atlan.getDefaultClient());
    }

    /**
     * Send this user to Atlan to create the user in Atlan.
     *
     * @param client connectivity to the Atlan tenant on which to create the user
     * @throws AtlanException on any error during API invocation
     */
    public void create(AtlanClient client) throws AtlanException {
        client.users.create(this);
    }

    /**
     * Send this user to Atlan to create the user in Atlan, and return the created user.
     * Note: this will make 2 API calls, one to create the user and a second to retrieve the created user.
     *
     * @param returnUser whether to return the created user (true) or not (false)
     * @return the created user
     * @throws AtlanException on any error during API invocation
     */
    public AtlanUser create(boolean returnUser) throws AtlanException {
        return create(Atlan.getDefaultClient(), returnUser);
    }

    /**
     * Send this user to Atlan to create the user in Atlan, and return the created user.
     * Note: this will make 2 API calls, one to create the user and a second to retrieve the created user.
     *
     * @param client connectivity to the Atlan tenant on which to create the user
     * @param returnUser whether to return the created user (true) or not (false)
     * @return the created user
     * @throws AtlanException on any error during API invocation
     */
    public AtlanUser create(AtlanClient client, boolean returnUser) throws AtlanException {
        return client.users.create(this, returnUser);
    }

    /**
     * Send this user to Atlan to update the user in Atlan.
     * Note: you can only update users that have already signed up to Atlan. Users that are
     * only invited (but have not yet logged in) cannot be updated.
     *
     * @throws AtlanException on any error during API invocation
     */
    public UserMinimalResponse update() throws AtlanException {
        return update(Atlan.getDefaultClient());
    }

    /**
     * Send this user to Atlan to update the user in Atlan.
     * Note: you can only update users that have already signed up to Atlan. Users that are
     * only invited (but have not yet logged in) cannot be updated.
     *
     * @param client connectivity to the Atlan tenant where the user should be updated
     * @throws AtlanException on any error during API invocation
     */
    public UserMinimalResponse update(AtlanClient client) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_USER_ID);
        }
        return client.users.update(this.id, this);
    }

    /**
     * Add this user to one or more groups.
     *
     * @param groupIds unique identifiers (GUIDs) of the groups to add the user into
     * @throws AtlanException on any API communication issue
     */
    public void addToGroups(List<String> groupIds) throws AtlanException {
        addToGroups(Atlan.getDefaultClient(), groupIds);
    }

    /**
     * Add this user to one or more groups.
     *
     * @param client connectivity to the Atlan tenant where the user should be added to one or more groups
     * @param groupIds unique identifiers (GUIDs) of the groups to add the user into
     * @throws AtlanException on any API communication issue
     */
    public void addToGroups(AtlanClient client, List<String> groupIds) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_USER_ID);
        }
        client.users.addToGroups(this.id, groupIds);
    }

    /**
     * Fetch the groups this user belongs to.
     *
     * @return details of the groups the user belongs to
     * @throws AtlanException on any API communication issue
     */
    public GroupResponse fetchGroups() throws AtlanException {
        return fetchGroups(Atlan.getDefaultClient());
    }

    /**
     * Fetch the groups this user belongs to.
     *
     * @param client connectivity to the Atlan tenant from which the groups for the user should be fetched
     * @return details of the groups the user belongs to
     * @throws AtlanException on any API communication issue
     */
    public GroupResponse fetchGroups(AtlanClient client) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_USER_ID);
        }
        return client.users.listGroups(this.id);
    }

    /**
     * Retrieves all users currently defined in Atlan.
     *
     * @return the list of users currently defined in Atlan
     * @throws AtlanException on any error during API invocation
     */
    public static List<AtlanUser> list() throws AtlanException {
        return list(Atlan.getDefaultClient());
    }

    /**
     * Retrieves all users currently defined in Atlan.
     *
     * @param client connectivity to the Atlan tenant from which users should be listed
     * @return the list of users currently defined in Atlan
     * @throws AtlanException on any error during API invocation
     */
    public static List<AtlanUser> list(AtlanClient client) throws AtlanException {
        return client.users.list();
    }

    /**
     * Retrieves all users with email addresses that contain the provided email.
     * (This could include a complete email address, in which case there should be at
     * most a single item in the returned list, or could be a partial email address
     * such as "@example.com" to retrieve all users with that domain in their email
     * address.)
     *
     * @param email on which to filter the users
     * @return all users whose email addresses contain the provided string
     * @throws AtlanException on any error during API invocation
     */
    @JsonIgnore
    public static List<AtlanUser> getByEmail(String email) throws AtlanException {
        return getByEmail(Atlan.getDefaultClient(), email);
    }

    /**
     * Retrieves all users with email addresses that contain the provided email.
     * (This could include a complete email address, in which case there should be at
     * most a single item in the returned list, or could be a partial email address
     * such as "@example.com" to retrieve all users with that domain in their email
     * address.)
     *
     * @param client connectivity to the Atlan tenant from which to list users
     * @param email on which to filter the users
     * @return all users whose email addresses contain the provided string
     * @throws AtlanException on any error during API invocation
     */
    @JsonIgnore
    public static List<AtlanUser> getByEmail(AtlanClient client, String email) throws AtlanException {
        return client.users.getByEmail(email);
    }

    /**
     * Retrieves a user based on the username. (This attempts an exact match on username rather than a
     * contains search.)
     *
     * @param user the username by which to find the user
     * @return the user with that username
     * @throws AtlanException on any error during API invocation
     */
    @JsonIgnore
    public static AtlanUser getByUsername(String user) throws AtlanException {
        return getByUsername(Atlan.getDefaultClient(), user);
    }

    /**
     * Retrieves a user based on the username. (This attempts an exact match on username rather than a
     * contains search.)
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the user
     * @param user the username by which to find the user
     * @return the user with that username
     * @throws AtlanException on any error during API invocation
     */
    @JsonIgnore
    public static AtlanUser getByUsername(AtlanClient client, String user) throws AtlanException {
        return client.users.getByUsername(user);
    }

    /**
     * Change the role of this user.
     *
     * @param roleId unique identifier (GUID) of the role to move the user into
     * @throws AtlanException on any API communication issue
     */
    public void changeRole(String roleId) throws AtlanException {
        changeRole(Atlan.getDefaultClient(), roleId);
    }

    /**
     * Change the role of this user.
     *
     * @param client connectivity to the Atlan tenant in which to change the user's role
     * @param roleId unique identifier (GUID) of the role to move the user into
     * @throws AtlanException on any API communication issue
     */
    public void changeRole(AtlanClient client, String roleId) throws AtlanException {
        client.users.changeRole(this.id, roleId);
    }

    /**
     * Retrieve the sessions for this user.
     *
     * @return the list of sessions for this user
     * @throws AtlanException on any API communication issue
     */
    public SessionResponse fetchSessions() throws AtlanException {
        return fetchSessions(Atlan.getDefaultClient());
    }

    /**
     * Retrieve the sessions for this user.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the user's sessions
     * @return the list of sessions for this user
     * @throws AtlanException on any API communication issue
     */
    public SessionResponse fetchSessions(AtlanClient client) throws AtlanException {
        return client.users.listSessions(this.id);
    }


    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AtlanUser.UserAttributes.UserAttributesBuilderImpl.class)
    public static final class UserAttributes extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /**
         * (Unused)
         */
        List<String> designation;
        /**
         * Skills the user possesses.
         */
        List<String> skills;
        /**
         * Unique Slack member identifier.
         */
        List<String> slack;
        /**
         * Unique JIRA user identifier.
         */
        List<String> jira;
        /**
         * Time at which the user was invited (as a formatted string).
         */
        List<String> invitedAt;
        /**
         * User who invited this user.
         */
        List<String> invitedBy;
        /**
         * TBC
         */
        List<String> invitedByName;
        /**
         * User-provided role during initial registration.
         */
        List<String> profileRole;
        /**
         * User-provided role during initial registration when profileRole is "other".
         */
        List<String> profileRoleOther;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class UserAttributesBuilder<C extends AtlanUser.UserAttributes, B extends AtlanUser.UserAttributes.UserAttributesBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> designation;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> skills;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> slack;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> jira;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> invitedAt;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> invitedBy;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> invitedByName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> profileRole;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> profileRoleOther;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                AtlanUser.UserAttributes.UserAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final AtlanUser.UserAttributes instance, final AtlanUser.UserAttributes.UserAttributesBuilder<?, ?> b) {
                b.designation(instance.designation);
                b.skills(instance.skills);
                b.slack(instance.slack);
                b.jira(instance.jira);
                b.invitedAt(instance.invitedAt);
                b.invitedBy(instance.invitedBy);
                b.invitedByName(instance.invitedByName);
                b.profileRole(instance.profileRole);
                b.profileRoleOther(instance.profileRoleOther);
            }

            /**
             * (Unused)
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B designation(final List<String> designation) {
                this.designation = designation;
                return self();
            }

            /**
             * Skills the user possesses.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B skills(final List<String> skills) {
                this.skills = skills;
                return self();
            }

            /**
             * Unique Slack member identifier.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B slack(final List<String> slack) {
                this.slack = slack;
                return self();
            }

            /**
             * Unique JIRA user identifier.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B jira(final List<String> jira) {
                this.jira = jira;
                return self();
            }

            /**
             * Time at which the user was invited (as a formatted string).
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B invitedAt(final List<String> invitedAt) {
                this.invitedAt = invitedAt;
                return self();
            }

            /**
             * User who invited this user.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B invitedBy(final List<String> invitedBy) {
                this.invitedBy = invitedBy;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B invitedByName(final List<String> invitedByName) {
                this.invitedByName = invitedByName;
                return self();
            }

            /**
             * User-provided role during initial registration.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B profileRole(final List<String> profileRole) {
                this.profileRole = profileRole;
                return self();
            }

            /**
             * User-provided role during initial registration when profileRole is "other".
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B profileRoleOther(final List<String> profileRoleOther) {
                this.profileRoleOther = profileRoleOther;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "AtlanUser.UserAttributes.UserAttributesBuilder(super=" + super.toString() + ", designation=" + this.designation + ", skills=" + this.skills + ", slack=" + this.slack + ", jira=" + this.jira + ", invitedAt=" + this.invitedAt + ", invitedBy=" + this.invitedBy + ", invitedByName=" + this.invitedByName + ", profileRole=" + this.profileRole + ", profileRoleOther=" + this.profileRoleOther + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class UserAttributesBuilderImpl extends AtlanUser.UserAttributes.UserAttributesBuilder<AtlanUser.UserAttributes, AtlanUser.UserAttributes.UserAttributesBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private UserAttributesBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected AtlanUser.UserAttributes.UserAttributesBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public AtlanUser.UserAttributes build() {
                return new AtlanUser.UserAttributes(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected UserAttributes(final AtlanUser.UserAttributes.UserAttributesBuilder<?, ?> b) {
            super(b);
            this.designation = b.designation;
            this.skills = b.skills;
            this.slack = b.slack;
            this.jira = b.jira;
            this.invitedAt = b.invitedAt;
            this.invitedBy = b.invitedBy;
            this.invitedByName = b.invitedByName;
            this.profileRole = b.profileRole;
            this.profileRoleOther = b.profileRoleOther;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static AtlanUser.UserAttributes.UserAttributesBuilder<?, ?> builder() {
            return new AtlanUser.UserAttributes.UserAttributesBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanUser.UserAttributes.UserAttributesBuilder<?, ?> toBuilder() {
            return new AtlanUser.UserAttributes.UserAttributesBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * (Unused)
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getDesignation() {
            return this.designation;
        }

        /**
         * Skills the user possesses.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getSkills() {
            return this.skills;
        }

        /**
         * Unique Slack member identifier.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getSlack() {
            return this.slack;
        }

        /**
         * Unique JIRA user identifier.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getJira() {
            return this.jira;
        }

        /**
         * Time at which the user was invited (as a formatted string).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getInvitedAt() {
            return this.invitedAt;
        }

        /**
         * User who invited this user.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getInvitedBy() {
            return this.invitedBy;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getInvitedByName() {
            return this.invitedByName;
        }

        /**
         * User-provided role during initial registration.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getProfileRole() {
            return this.profileRole;
        }

        /**
         * User-provided role during initial registration when profileRole is "other".
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getProfileRoleOther() {
            return this.profileRoleOther;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof AtlanUser.UserAttributes)) return false;
            final AtlanUser.UserAttributes other = (AtlanUser.UserAttributes) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$designation = this.getDesignation();
            final java.lang.Object other$designation = other.getDesignation();
            if (this$designation == null ? other$designation != null : !this$designation.equals(other$designation)) return false;
            final java.lang.Object this$skills = this.getSkills();
            final java.lang.Object other$skills = other.getSkills();
            if (this$skills == null ? other$skills != null : !this$skills.equals(other$skills)) return false;
            final java.lang.Object this$slack = this.getSlack();
            final java.lang.Object other$slack = other.getSlack();
            if (this$slack == null ? other$slack != null : !this$slack.equals(other$slack)) return false;
            final java.lang.Object this$jira = this.getJira();
            final java.lang.Object other$jira = other.getJira();
            if (this$jira == null ? other$jira != null : !this$jira.equals(other$jira)) return false;
            final java.lang.Object this$invitedAt = this.getInvitedAt();
            final java.lang.Object other$invitedAt = other.getInvitedAt();
            if (this$invitedAt == null ? other$invitedAt != null : !this$invitedAt.equals(other$invitedAt)) return false;
            final java.lang.Object this$invitedBy = this.getInvitedBy();
            final java.lang.Object other$invitedBy = other.getInvitedBy();
            if (this$invitedBy == null ? other$invitedBy != null : !this$invitedBy.equals(other$invitedBy)) return false;
            final java.lang.Object this$invitedByName = this.getInvitedByName();
            final java.lang.Object other$invitedByName = other.getInvitedByName();
            if (this$invitedByName == null ? other$invitedByName != null : !this$invitedByName.equals(other$invitedByName)) return false;
            final java.lang.Object this$profileRole = this.getProfileRole();
            final java.lang.Object other$profileRole = other.getProfileRole();
            if (this$profileRole == null ? other$profileRole != null : !this$profileRole.equals(other$profileRole)) return false;
            final java.lang.Object this$profileRoleOther = this.getProfileRoleOther();
            final java.lang.Object other$profileRoleOther = other.getProfileRoleOther();
            if (this$profileRoleOther == null ? other$profileRoleOther != null : !this$profileRoleOther.equals(other$profileRoleOther)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof AtlanUser.UserAttributes;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $designation = this.getDesignation();
            result = result * PRIME + ($designation == null ? 43 : $designation.hashCode());
            final java.lang.Object $skills = this.getSkills();
            result = result * PRIME + ($skills == null ? 43 : $skills.hashCode());
            final java.lang.Object $slack = this.getSlack();
            result = result * PRIME + ($slack == null ? 43 : $slack.hashCode());
            final java.lang.Object $jira = this.getJira();
            result = result * PRIME + ($jira == null ? 43 : $jira.hashCode());
            final java.lang.Object $invitedAt = this.getInvitedAt();
            result = result * PRIME + ($invitedAt == null ? 43 : $invitedAt.hashCode());
            final java.lang.Object $invitedBy = this.getInvitedBy();
            result = result * PRIME + ($invitedBy == null ? 43 : $invitedBy.hashCode());
            final java.lang.Object $invitedByName = this.getInvitedByName();
            result = result * PRIME + ($invitedByName == null ? 43 : $invitedByName.hashCode());
            final java.lang.Object $profileRole = this.getProfileRole();
            result = result * PRIME + ($profileRole == null ? 43 : $profileRole.hashCode());
            final java.lang.Object $profileRoleOther = this.getProfileRoleOther();
            result = result * PRIME + ($profileRoleOther == null ? 43 : $profileRoleOther.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanUser.UserAttributes(super=" + super.toString() + ", designation=" + this.getDesignation() + ", skills=" + this.getSkills() + ", slack=" + this.getSlack() + ", jira=" + this.getJira() + ", invitedAt=" + this.getInvitedAt() + ", invitedBy=" + this.getInvitedBy() + ", invitedByName=" + this.getInvitedByName() + ", profileRole=" + this.getProfileRole() + ", profileRoleOther=" + this.getProfileRoleOther() + ")";
        }
    }


    /**
     * Personas associated with a user.
     */
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AtlanUser.Persona.PersonaBuilderImpl.class)
    public static final class Persona extends AtlanObject implements Comparable<Persona> {
        private static final long serialVersionUID = 2L;
        private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
        private static final Comparator<Persona> personaComparator = Comparator.comparing(Persona::getId, stringComparator);
        /** Unique identifier (GUID) of the persona. */
        String id;
        /** Internal name of the persona. */
        String name;
        /** Human-readable name of the persona. */
        String displayName;

        /** {@inheritDoc} */
        @Override
        public int compareTo(Persona o) {
            return personaComparator.compare(this, o);
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class PersonaBuilder<C extends AtlanUser.Persona, B extends AtlanUser.Persona.PersonaBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String id;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String name;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String displayName;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                AtlanUser.Persona.PersonaBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final AtlanUser.Persona instance, final AtlanUser.Persona.PersonaBuilder<?, ?> b) {
                b.id(instance.id);
                b.name(instance.name);
                b.displayName(instance.displayName);
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B id(final String id) {
                this.id = id;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B name(final String name) {
                this.name = name;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B displayName(final String displayName) {
                this.displayName = displayName;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "AtlanUser.Persona.PersonaBuilder(super=" + super.toString() + ", id=" + this.id + ", name=" + this.name + ", displayName=" + this.displayName + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class PersonaBuilderImpl extends AtlanUser.Persona.PersonaBuilder<AtlanUser.Persona, AtlanUser.Persona.PersonaBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private PersonaBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected AtlanUser.Persona.PersonaBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public AtlanUser.Persona build() {
                return new AtlanUser.Persona(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Persona(final AtlanUser.Persona.PersonaBuilder<?, ?> b) {
            super(b);
            this.id = b.id;
            this.name = b.name;
            this.displayName = b.displayName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static AtlanUser.Persona.PersonaBuilder<?, ?> builder() {
            return new AtlanUser.Persona.PersonaBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanUser.Persona.PersonaBuilder<?, ?> toBuilder() {
            return new AtlanUser.Persona.PersonaBuilderImpl().$fillValuesFrom(this);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getId() {
            return this.id;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
            return this.name;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof AtlanUser.Persona)) return false;
            final AtlanUser.Persona other = (AtlanUser.Persona) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            final java.lang.Object this$displayName = this.getDisplayName();
            final java.lang.Object other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof AtlanUser.Persona;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $displayName = this.getDisplayName();
            result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanUser.Persona(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AtlanUserBuilder<C extends AtlanUser, B extends AtlanUser.AtlanUserBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String username;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String id;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workspaceRole;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String email;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean emailVerified;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean enabled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String firstName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String lastName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private UserAttributes attributes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long createdTimestamp;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long lastLoginTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long groupCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<String> defaultRoles;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<String> roles;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String decentralizedRoles;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SortedSet<AtlanUser.Persona> personas;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SortedSet<String> purposes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<AdminEvent> adminEvents;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<KeycloakEvent> loginEvents;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AtlanUser.AtlanUserBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AtlanUser instance, final AtlanUser.AtlanUserBuilder<?, ?> b) {
            b.username(instance.username);
            b.id(instance.id);
            b.workspaceRole(instance.workspaceRole);
            b.email(instance.email);
            b.emailVerified(instance.emailVerified);
            b.enabled(instance.enabled);
            b.firstName(instance.firstName);
            b.lastName(instance.lastName);
            b.attributes(instance.attributes);
            b.createdTimestamp(instance.createdTimestamp);
            b.lastLoginTime(instance.lastLoginTime);
            b.groupCount(instance.groupCount);
            b.defaultRoles(instance.defaultRoles);
            b.roles(instance.roles);
            b.decentralizedRoles(instance.decentralizedRoles);
            b.personas(instance.personas);
            b.purposes(instance.purposes);
            b.adminEvents(instance.adminEvents);
            b.loginEvents(instance.loginEvents);
        }

        /**
         * Username of the user within Atlan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B username(final String username) {
            this.username = username;
            return self();
        }

        /**
         * Unique identifier (GUID) of the user within Atlan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B id(final String id) {
            this.id = id;
            return self();
        }

        /**
         * Name of the role of the user within Atlan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workspaceRole(final String workspaceRole) {
            this.workspaceRole = workspaceRole;
            return self();
        }

        /**
         * Email address of the user.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B email(final String email) {
            this.email = email;
            return self();
        }

        /**
         * When true, the email address of the user has been verified.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B emailVerified(final Boolean emailVerified) {
            this.emailVerified = emailVerified;
            return self();
        }

        /**
         * When true, the user is enabled. When false, the user has been deactivated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B enabled(final Boolean enabled) {
            this.enabled = enabled;
            return self();
        }

        /**
         * First name of the user.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B firstName(final String firstName) {
            this.firstName = firstName;
            return self();
        }

        /**
         * Last name (surname) of the user.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lastName(final String lastName) {
            this.lastName = lastName;
            return self();
        }

        /**
         * Detailed attributes of the user.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attributes(final UserAttributes attributes) {
            this.attributes = attributes;
            return self();
        }

        /**
         * Time (epoch) at which the user was created, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B createdTimestamp(final Long createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return self();
        }

        /**
         * Time (epoch) at which the user last logged into Atlan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lastLoginTime(final Long lastLoginTime) {
            this.lastLoginTime = lastLoginTime;
            return self();
        }

        /**
         * Number of groups to which the user belongs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B groupCount(final Long groupCount) {
            this.groupCount = groupCount;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B defaultRoles(final List<String> defaultRoles) {
            this.defaultRoles = defaultRoles;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B roles(final List<String> roles) {
            this.roles = roles;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B decentralizedRoles(final String decentralizedRoles) {
            this.decentralizedRoles = decentralizedRoles;
            return self();
        }

        /**
         * Personas the user is associated with.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B personas(final SortedSet<AtlanUser.Persona> personas) {
            this.personas = personas;
            return self();
        }

        /**
         * Purposes the user is associated with.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B purposes(final SortedSet<String> purposes) {
            this.purposes = purposes;
            return self();
        }

        /**
         * List of administration-related events for this user.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adminEvents(final List<AdminEvent> adminEvents) {
            this.adminEvents = adminEvents;
            return self();
        }

        /**
         * List of login-related events for this user.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B loginEvents(final List<KeycloakEvent> loginEvents) {
            this.loginEvents = loginEvents;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanUser.AtlanUserBuilder(super=" + super.toString() + ", username=" + this.username + ", id=" + this.id + ", workspaceRole=" + this.workspaceRole + ", email=" + this.email + ", emailVerified=" + this.emailVerified + ", enabled=" + this.enabled + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", attributes=" + this.attributes + ", createdTimestamp=" + this.createdTimestamp + ", lastLoginTime=" + this.lastLoginTime + ", groupCount=" + this.groupCount + ", defaultRoles=" + this.defaultRoles + ", roles=" + this.roles + ", decentralizedRoles=" + this.decentralizedRoles + ", personas=" + this.personas + ", purposes=" + this.purposes + ", adminEvents=" + this.adminEvents + ", loginEvents=" + this.loginEvents + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class AtlanUserBuilderImpl extends AtlanUser.AtlanUserBuilder<AtlanUser, AtlanUser.AtlanUserBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanUserBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AtlanUser.AtlanUserBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanUser build() {
            return new AtlanUser(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AtlanUser(final AtlanUser.AtlanUserBuilder<?, ?> b) {
        super(b);
        this.username = b.username;
        this.id = b.id;
        this.workspaceRole = b.workspaceRole;
        this.email = b.email;
        this.emailVerified = b.emailVerified;
        this.enabled = b.enabled;
        this.firstName = b.firstName;
        this.lastName = b.lastName;
        this.attributes = b.attributes;
        this.createdTimestamp = b.createdTimestamp;
        this.lastLoginTime = b.lastLoginTime;
        this.groupCount = b.groupCount;
        this.defaultRoles = b.defaultRoles;
        this.roles = b.roles;
        this.decentralizedRoles = b.decentralizedRoles;
        this.personas = b.personas;
        this.purposes = b.purposes;
        this.adminEvents = b.adminEvents;
        this.loginEvents = b.loginEvents;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AtlanUser.AtlanUserBuilder<?, ?> builder() {
        return new AtlanUser.AtlanUserBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanUser.AtlanUserBuilder<?, ?> toBuilder() {
        return new AtlanUser.AtlanUserBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Username of the user within Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUsername() {
        return this.username;
    }

    /**
     * Unique identifier (GUID) of the user within Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
        return this.id;
    }

    /**
     * Name of the role of the user within Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkspaceRole() {
        return this.workspaceRole;
    }

    /**
     * Email address of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEmail() {
        return this.email;
    }

    /**
     * When true, the email address of the user has been verified.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEmailVerified() {
        return this.emailVerified;
    }

    /**
     * When true, the user is enabled. When false, the user has been deactivated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * First name of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFirstName() {
        return this.firstName;
    }

    /**
     * Last name (surname) of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLastName() {
        return this.lastName;
    }

    /**
     * Detailed attributes of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UserAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Time (epoch) at which the user was created, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    /**
     * Time (epoch) at which the user last logged into Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLastLoginTime() {
        return this.lastLoginTime;
    }

    /**
     * Number of groups to which the user belongs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGroupCount() {
        return this.groupCount;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getDefaultRoles() {
        return this.defaultRoles;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getRoles() {
        return this.roles;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDecentralizedRoles() {
        return this.decentralizedRoles;
    }

    /**
     * Personas the user is associated with.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<AtlanUser.Persona> getPersonas() {
        return this.personas;
    }

    /**
     * Purposes the user is associated with.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getPurposes() {
        return this.purposes;
    }

    /**
     * List of administration-related events for this user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<AdminEvent> getAdminEvents() {
        return this.adminEvents;
    }

    /**
     * List of login-related events for this user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<KeycloakEvent> getLoginEvents() {
        return this.loginEvents;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanUser)) return false;
        final AtlanUser other = (AtlanUser) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$emailVerified = this.getEmailVerified();
        final java.lang.Object other$emailVerified = other.getEmailVerified();
        if (this$emailVerified == null ? other$emailVerified != null : !this$emailVerified.equals(other$emailVerified)) return false;
        final java.lang.Object this$enabled = this.getEnabled();
        final java.lang.Object other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
        final java.lang.Object this$createdTimestamp = this.getCreatedTimestamp();
        final java.lang.Object other$createdTimestamp = other.getCreatedTimestamp();
        if (this$createdTimestamp == null ? other$createdTimestamp != null : !this$createdTimestamp.equals(other$createdTimestamp)) return false;
        final java.lang.Object this$lastLoginTime = this.getLastLoginTime();
        final java.lang.Object other$lastLoginTime = other.getLastLoginTime();
        if (this$lastLoginTime == null ? other$lastLoginTime != null : !this$lastLoginTime.equals(other$lastLoginTime)) return false;
        final java.lang.Object this$groupCount = this.getGroupCount();
        final java.lang.Object other$groupCount = other.getGroupCount();
        if (this$groupCount == null ? other$groupCount != null : !this$groupCount.equals(other$groupCount)) return false;
        final java.lang.Object this$username = this.getUsername();
        final java.lang.Object other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$workspaceRole = this.getWorkspaceRole();
        final java.lang.Object other$workspaceRole = other.getWorkspaceRole();
        if (this$workspaceRole == null ? other$workspaceRole != null : !this$workspaceRole.equals(other$workspaceRole)) return false;
        final java.lang.Object this$email = this.getEmail();
        final java.lang.Object other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
        final java.lang.Object this$firstName = this.getFirstName();
        final java.lang.Object other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) return false;
        final java.lang.Object this$lastName = this.getLastName();
        final java.lang.Object other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) return false;
        final java.lang.Object this$attributes = this.getAttributes();
        final java.lang.Object other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
        final java.lang.Object this$defaultRoles = this.getDefaultRoles();
        final java.lang.Object other$defaultRoles = other.getDefaultRoles();
        if (this$defaultRoles == null ? other$defaultRoles != null : !this$defaultRoles.equals(other$defaultRoles)) return false;
        final java.lang.Object this$roles = this.getRoles();
        final java.lang.Object other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !this$roles.equals(other$roles)) return false;
        final java.lang.Object this$decentralizedRoles = this.getDecentralizedRoles();
        final java.lang.Object other$decentralizedRoles = other.getDecentralizedRoles();
        if (this$decentralizedRoles == null ? other$decentralizedRoles != null : !this$decentralizedRoles.equals(other$decentralizedRoles)) return false;
        final java.lang.Object this$personas = this.getPersonas();
        final java.lang.Object other$personas = other.getPersonas();
        if (this$personas == null ? other$personas != null : !this$personas.equals(other$personas)) return false;
        final java.lang.Object this$purposes = this.getPurposes();
        final java.lang.Object other$purposes = other.getPurposes();
        if (this$purposes == null ? other$purposes != null : !this$purposes.equals(other$purposes)) return false;
        final java.lang.Object this$adminEvents = this.getAdminEvents();
        final java.lang.Object other$adminEvents = other.getAdminEvents();
        if (this$adminEvents == null ? other$adminEvents != null : !this$adminEvents.equals(other$adminEvents)) return false;
        final java.lang.Object this$loginEvents = this.getLoginEvents();
        final java.lang.Object other$loginEvents = other.getLoginEvents();
        if (this$loginEvents == null ? other$loginEvents != null : !this$loginEvents.equals(other$loginEvents)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AtlanUser;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $emailVerified = this.getEmailVerified();
        result = result * PRIME + ($emailVerified == null ? 43 : $emailVerified.hashCode());
        final java.lang.Object $enabled = this.getEnabled();
        result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
        final java.lang.Object $createdTimestamp = this.getCreatedTimestamp();
        result = result * PRIME + ($createdTimestamp == null ? 43 : $createdTimestamp.hashCode());
        final java.lang.Object $lastLoginTime = this.getLastLoginTime();
        result = result * PRIME + ($lastLoginTime == null ? 43 : $lastLoginTime.hashCode());
        final java.lang.Object $groupCount = this.getGroupCount();
        result = result * PRIME + ($groupCount == null ? 43 : $groupCount.hashCode());
        final java.lang.Object $username = this.getUsername();
        result = result * PRIME + ($username == null ? 43 : $username.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $workspaceRole = this.getWorkspaceRole();
        result = result * PRIME + ($workspaceRole == null ? 43 : $workspaceRole.hashCode());
        final java.lang.Object $email = this.getEmail();
        result = result * PRIME + ($email == null ? 43 : $email.hashCode());
        final java.lang.Object $firstName = this.getFirstName();
        result = result * PRIME + ($firstName == null ? 43 : $firstName.hashCode());
        final java.lang.Object $lastName = this.getLastName();
        result = result * PRIME + ($lastName == null ? 43 : $lastName.hashCode());
        final java.lang.Object $attributes = this.getAttributes();
        result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
        final java.lang.Object $defaultRoles = this.getDefaultRoles();
        result = result * PRIME + ($defaultRoles == null ? 43 : $defaultRoles.hashCode());
        final java.lang.Object $roles = this.getRoles();
        result = result * PRIME + ($roles == null ? 43 : $roles.hashCode());
        final java.lang.Object $decentralizedRoles = this.getDecentralizedRoles();
        result = result * PRIME + ($decentralizedRoles == null ? 43 : $decentralizedRoles.hashCode());
        final java.lang.Object $personas = this.getPersonas();
        result = result * PRIME + ($personas == null ? 43 : $personas.hashCode());
        final java.lang.Object $purposes = this.getPurposes();
        result = result * PRIME + ($purposes == null ? 43 : $purposes.hashCode());
        final java.lang.Object $adminEvents = this.getAdminEvents();
        result = result * PRIME + ($adminEvents == null ? 43 : $adminEvents.hashCode());
        final java.lang.Object $loginEvents = this.getLoginEvents();
        result = result * PRIME + ($loginEvents == null ? 43 : $loginEvents.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanUser(super=" + super.toString() + ", username=" + this.getUsername() + ", id=" + this.getId() + ", workspaceRole=" + this.getWorkspaceRole() + ", email=" + this.getEmail() + ", emailVerified=" + this.getEmailVerified() + ", enabled=" + this.getEnabled() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", attributes=" + this.getAttributes() + ", createdTimestamp=" + this.getCreatedTimestamp() + ", lastLoginTime=" + this.getLastLoginTime() + ", groupCount=" + this.getGroupCount() + ", defaultRoles=" + this.getDefaultRoles() + ", roles=" + this.getRoles() + ", decentralizedRoles=" + this.getDecentralizedRoles() + ", personas=" + this.getPersonas() + ", purposes=" + this.getPurposes() + ", adminEvents=" + this.getAdminEvents() + ", loginEvents=" + this.getLoginEvents() + ")";
    }
}
