// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Asset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class AttributeRequest extends AtlanRequest {
    private static final long serialVersionUID = 2L;
    public static final String REQUEST_TYPE = "attribute";
    public static final String SOURCE_TYPE = "static";
    /**
     * Fixed requestType for attributes.
     */
    String requestType;
    /**
     * Fixed sourceType for attributes.
     */
    String sourceType;

    /**
     * Create a new request to change an attribute's value.
     * Note that the asset must have at least its real (not placeholder) GUID and qualifiedName populated.
     *
     * @param asset against which to raise the request
     * @param attribute name of the attribute to change
     * @param value new value for the attribute
     * @return a builder for the request with these details
     * @throws InvalidRequestException if any of the required details for the provided asset are missing
     */
    public static AttributeRequestBuilder<?, ?> creator(Asset asset, String attribute, String value) throws InvalidRequestException {
        List<String> missing = new ArrayList<>();
        if (asset.getQualifiedName() == null || asset.getQualifiedName().isEmpty()) {
            missing.add("qualifiedName");
        }
        if (asset.getGuid() == null || asset.getGuid().isEmpty()) {
            missing.add("guid");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, asset.getTypeName(), String.join(",", missing));
        }
        return creator(asset.getGuid(), asset.getQualifiedName(), asset.getTypeName(), attribute, value);
    }

    /**
     * Create a new request to change an attribute's value.
     *
     * @param assetGuid unique identifier (GUID) of the asset to change
     * @param assetQualifiedName qualifiedName of the asset to change
     * @param assetType type of the asset to change
     * @param attribute name of the attribute to change
     * @param value new value for the attribute
     * @return a builder for the request with these details
     */
    public static AttributeRequestBuilder<?, ?> creator(String assetGuid, String assetQualifiedName, String assetType, String attribute, String value) {
        return AttributeRequest.builder().id(UUID.randomUUID().toString()).destinationAttribute(attribute).destinationGuid(assetGuid).destinationQualifiedName(assetQualifiedName).entityType(assetType).destinationValue(value);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$requestType() {
        return REQUEST_TYPE;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$sourceType() {
        return SOURCE_TYPE;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AttributeRequestBuilder<C extends AttributeRequest, B extends AttributeRequest.AttributeRequestBuilder<C, B>> extends AtlanRequest.AtlanRequestBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean requestType$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String requestType$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean sourceType$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceType$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AttributeRequest.AttributeRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AttributeRequest instance, final AttributeRequest.AttributeRequestBuilder<?, ?> b) {
            b.requestType(instance.requestType);
            b.sourceType(instance.sourceType);
        }

        /**
         * Fixed requestType for attributes.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestType(final String requestType) {
            this.requestType$value = requestType;
            requestType$set = true;
            return self();
        }

        /**
         * Fixed sourceType for attributes.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceType(final String sourceType) {
            this.sourceType$value = sourceType;
            sourceType$set = true;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AttributeRequest.AttributeRequestBuilder(super=" + super.toString() + ", requestType$value=" + this.requestType$value + ", sourceType$value=" + this.sourceType$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AttributeRequestBuilderImpl extends AttributeRequest.AttributeRequestBuilder<AttributeRequest, AttributeRequest.AttributeRequestBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AttributeRequestBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AttributeRequest.AttributeRequestBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AttributeRequest build() {
            return new AttributeRequest(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AttributeRequest(final AttributeRequest.AttributeRequestBuilder<?, ?> b) {
        super(b);
        if (b.requestType$set) this.requestType = b.requestType$value;
         else this.requestType = AttributeRequest.$default$requestType();
        if (b.sourceType$set) this.sourceType = b.sourceType$value;
         else this.sourceType = AttributeRequest.$default$sourceType();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AttributeRequest.AttributeRequestBuilder<?, ?> builder() {
        return new AttributeRequest.AttributeRequestBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AttributeRequest.AttributeRequestBuilder<?, ?> toBuilder() {
        return new AttributeRequest.AttributeRequestBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AttributeRequest)) return false;
        final AttributeRequest other = (AttributeRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$requestType = this.getRequestType();
        final java.lang.Object other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType)) return false;
        final java.lang.Object this$sourceType = this.getSourceType();
        final java.lang.Object other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AttributeRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $requestType = this.getRequestType();
        result = result * PRIME + ($requestType == null ? 43 : $requestType.hashCode());
        final java.lang.Object $sourceType = this.getSourceType();
        result = result * PRIME + ($sourceType == null ? 43 : $sourceType.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AttributeRequest(super=" + super.toString() + ", requestType=" + this.getRequestType() + ", sourceType=" + this.getSourceType() + ")";
    }

    /**
     * Fixed requestType for attributes.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRequestType() {
        return this.requestType;
    }

    /**
     * Fixed sourceType for attributes.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceType() {
        return this.sourceType;
    }
}
