// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.model.core.AtlanObject;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import lombok.*;

/**
 * Specialized response for creating a group, as the details included are different
 * from those when updating or retrieving a group.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = CreateGroupResponse.CreateGroupResponseBuilder.class)
public class CreateGroupResponse extends ApiResource {
    private static final long serialVersionUID = 2L;
    /**
     * Unique identifier (GUID) of the group within Atlan.
     */
    String group;
    /**
     * Map of user association statuses, keyed by unique identifier (GUID) of the user.
     */
    Map<String, UserStatus> users;


    /**
     * Status of the user being added to the group during its creation.
     */
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = CreateGroupResponse.UserStatus.UserStatusBuilderImpl.class)
    public static final class UserStatus extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /** Response code for the association (200 is success). */
        Integer status;
        /** Status message for the association ({@code success} means the association was successful). */
        String statusMessage;

        /** Indicates whether the association was made successfully (true) or not (false). */
        @JsonIgnore
        public boolean wasSuccessful() {
            if (status != null) {
                return status == 200;
            }
            if (statusMessage != null) {
                return statusMessage.equals("success");
            }
            return false;
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class UserStatusBuilder<C extends CreateGroupResponse.UserStatus, B extends CreateGroupResponse.UserStatus.UserStatusBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer status;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String statusMessage;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                CreateGroupResponse.UserStatus.UserStatusBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final CreateGroupResponse.UserStatus instance, final CreateGroupResponse.UserStatus.UserStatusBuilder<?, ?> b) {
                b.status(instance.status);
                b.statusMessage(instance.statusMessage);
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B status(final Integer status) {
                this.status = status;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B statusMessage(final String statusMessage) {
                this.statusMessage = statusMessage;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "CreateGroupResponse.UserStatus.UserStatusBuilder(super=" + super.toString() + ", status=" + this.status + ", statusMessage=" + this.statusMessage + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class UserStatusBuilderImpl extends CreateGroupResponse.UserStatus.UserStatusBuilder<CreateGroupResponse.UserStatus, CreateGroupResponse.UserStatus.UserStatusBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private UserStatusBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected CreateGroupResponse.UserStatus.UserStatusBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public CreateGroupResponse.UserStatus build() {
                return new CreateGroupResponse.UserStatus(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected UserStatus(final CreateGroupResponse.UserStatus.UserStatusBuilder<?, ?> b) {
            super(b);
            this.status = b.status;
            this.statusMessage = b.statusMessage;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static CreateGroupResponse.UserStatus.UserStatusBuilder<?, ?> builder() {
            return new CreateGroupResponse.UserStatus.UserStatusBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CreateGroupResponse.UserStatus.UserStatusBuilder<?, ?> toBuilder() {
            return new CreateGroupResponse.UserStatus.UserStatusBuilderImpl().$fillValuesFrom(this);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getStatus() {
            return this.status;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getStatusMessage() {
            return this.statusMessage;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof CreateGroupResponse.UserStatus)) return false;
            final CreateGroupResponse.UserStatus other = (CreateGroupResponse.UserStatus) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$status = this.getStatus();
            final java.lang.Object other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
            final java.lang.Object this$statusMessage = this.getStatusMessage();
            final java.lang.Object other$statusMessage = other.getStatusMessage();
            if (this$statusMessage == null ? other$statusMessage != null : !this$statusMessage.equals(other$statusMessage)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof CreateGroupResponse.UserStatus;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $status = this.getStatus();
            result = result * PRIME + ($status == null ? 43 : $status.hashCode());
            final java.lang.Object $statusMessage = this.getStatusMessage();
            result = result * PRIME + ($statusMessage == null ? 43 : $statusMessage.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "CreateGroupResponse.UserStatus(super=" + super.toString() + ", status=" + this.getStatus() + ", statusMessage=" + this.getStatusMessage() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    CreateGroupResponse(final String group, final Map<String, UserStatus> users) {
        this.group = group;
        this.users = users;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class CreateGroupResponseBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String group;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, UserStatus> users;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        CreateGroupResponseBuilder() {
        }

        /**
         * Unique identifier (GUID) of the group within Atlan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CreateGroupResponse.CreateGroupResponseBuilder group(final String group) {
            this.group = group;
            return this;
        }

        /**
         * Map of user association statuses, keyed by unique identifier (GUID) of the user.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CreateGroupResponse.CreateGroupResponseBuilder users(final Map<String, UserStatus> users) {
            this.users = users;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CreateGroupResponse build() {
            return new CreateGroupResponse(this.group, this.users);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "CreateGroupResponse.CreateGroupResponseBuilder(group=" + this.group + ", users=" + this.users + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static CreateGroupResponse.CreateGroupResponseBuilder builder() {
        return new CreateGroupResponse.CreateGroupResponseBuilder();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CreateGroupResponse.CreateGroupResponseBuilder toBuilder() {
        return new CreateGroupResponse.CreateGroupResponseBuilder().group(this.group).users(this.users);
    }

    /**
     * Unique identifier (GUID) of the group within Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGroup() {
        return this.group;
    }

    /**
     * Map of user association statuses, keyed by unique identifier (GUID) of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, UserStatus> getUsers() {
        return this.users;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CreateGroupResponse)) return false;
        final CreateGroupResponse other = (CreateGroupResponse) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$group = this.getGroup();
        final java.lang.Object other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) return false;
        final java.lang.Object this$users = this.getUsers();
        final java.lang.Object other$users = other.getUsers();
        if (this$users == null ? other$users != null : !this$users.equals(other$users)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CreateGroupResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $group = this.getGroup();
        result = result * PRIME + ($group == null ? 43 : $group.hashCode());
        final java.lang.Object $users = this.getUsers();
        result = result * PRIME + ($users == null ? 43 : $users.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "CreateGroupResponse(super=" + super.toString() + ", group=" + this.getGroup() + ", users=" + this.getUsers() + ")";
    }
}
