// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.*;
import lombok.*;

@SuppressWarnings("cast")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = Credential.CredentialBuilderImpl.class)
public class Credential extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Unique identifier (GUID) of the credential.
     */
    String id;
    /**
     * Name of the credential.
     */
    String name;
    /**
     * Hostname the for which connectivity is defined by the credential.
     */
    String host;
    /**
     * Port number on which connectivity should be done.
     */
    Integer port;
    /**
     * Authentication mechanism represented by the credential.
     */
    String authType;
    /**
     * Type of connector used by the credential.
     */
    String connectorType;
    /**
     * Less sensitive portion of the credential, typically used for a username for basic
     * authentication or client IDs for other forms of authentication.
     */
    String username;
    /**
     * More sensitive portion of the credential, typically used for a password for basic
     * authentication or client secrets for other forms of authentication.
     */
    String password;
    /**
     * Additional details about the credential. This can capture, for example, a secondary
     * secret for particular forms of authentication and / or additional details about the
     * scope of the connectivity (a specific database, role, warehouse, etc).
     */
    @JsonInclude(JsonInclude.Include.ALWAYS)
    @JsonProperty("extra")
    Map<String, String> extras;
    /**
     * Name of the connector configuration responsible for managing the credential.
     */
    String connectorConfigName;

    /**
     * Retrieves a credential by its unique identifier (GUID).
     *
     * @param guid unique identifier (GUID) of the credential to retrieve
     * @return the credential, or null if none exists
     * @throws AtlanException on any error during API invocation
     */
    public static CredentialResponse get(String guid) throws AtlanException {
        return get(Atlan.getDefaultClient(), guid);
    }

    /**
     * Retrieves a credential by its unique identifier (GUID).
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the credential
     * @param guid unique identifier (GUID) of the credential to retrieve
     * @return the credential, or null if none exists
     * @throws AtlanException on any error during API invocation
     */
    public static CredentialResponse get(AtlanClient client, String guid) throws AtlanException {
        return client.credentials.get(guid);
    }

    /**
     * Sends this credential to Atlan to update it in Atlan, after first testing it
     * to confirm it works.
     *
     * @return the updated credential
     * @throws InvalidRequestException if the provided credentials cannot be validated successfully
     * @throws AtlanException on any error during API invocation
     */
    public CredentialResponse update() throws AtlanException {
        return update(Atlan.getDefaultClient());
    }

    /**
     * Sends this credential to Atlan to update it in Atlan, after first testing it
     * to confirm it works.
     *
     * @param client connectivity to the Atlan tenant on which to update the credential
     * @return the updated credential
     * @throws InvalidRequestException if the provided credentials cannot be validated successfully
     * @throws AtlanException on any error during API invocation
     */
    public CredentialResponse update(AtlanClient client) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_TOKEN_ID);
        }
        CredentialTestResponse test = client.credentials.test(this);
        if (test.isSuccessful()) {
            return client.credentials.update(this.id, this);
        } else {
            throw new InvalidRequestException(ErrorCode.INVALID_CREDENTIALS, test.getMessage());
        }
    }

    /**
     * Convert this credential into a map, for embedding within a package (crawler).
     *
     * @return map representation of the credential
     */
    public Map<String, Object> toMap() {
        Map<String, Object> credential = new HashMap<>();
        if (name != null) {
            credential.put("name", name);
        }
        if (host != null) {
            credential.put("host", host);
        }
        if (port != null) {
            credential.put("port", port);
        }
        if (authType != null) {
            credential.put("authType", authType);
        }
        if (connectorType != null) {
            credential.put("connectorType", connectorType);
        }
        if (username != null) {
            credential.put("username", username);
        }
        if (password != null) {
            credential.put("password", password);
        }
        if (extras != null) {
            credential.put("extra", extras);
        }
        if (connectorConfigName != null) {
            credential.put("connectorConfigName", connectorConfigName);
        }
        return credential;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class CredentialBuilder<C extends Credential, B extends Credential.CredentialBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String id;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String name;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String host;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer port;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String authType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String connectorType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String username;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String password;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> extras$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> extras$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String connectorConfigName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Credential.CredentialBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Credential instance, final Credential.CredentialBuilder<?, ?> b) {
            b.id(instance.id);
            b.name(instance.name);
            b.host(instance.host);
            b.port(instance.port);
            b.authType(instance.authType);
            b.connectorType(instance.connectorType);
            b.username(instance.username);
            b.password(instance.password);
            b.extras(instance.extras == null ? java.util.Collections.<String, String>emptyMap() : instance.extras);
            b.connectorConfigName(instance.connectorConfigName);
        }

        /**
         * Unique identifier (GUID) of the credential.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B id(final String id) {
            this.id = id;
            return self();
        }

        /**
         * Name of the credential.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B name(final String name) {
            this.name = name;
            return self();
        }

        /**
         * Hostname the for which connectivity is defined by the credential.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B host(final String host) {
            this.host = host;
            return self();
        }

        /**
         * Port number on which connectivity should be done.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B port(final Integer port) {
            this.port = port;
            return self();
        }

        /**
         * Authentication mechanism represented by the credential.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B authType(final String authType) {
            this.authType = authType;
            return self();
        }

        /**
         * Type of connector used by the credential.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B connectorType(final String connectorType) {
            this.connectorType = connectorType;
            return self();
        }

        /**
         * Less sensitive portion of the credential, typically used for a username for basic
         * authentication or client IDs for other forms of authentication.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B username(final String username) {
            this.username = username;
            return self();
        }

        /**
         * More sensitive portion of the credential, typically used for a password for basic
         * authentication or client secrets for other forms of authentication.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B password(final String password) {
            this.password = password;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B extra(final String extraKey, final String extraValue) {
            if (this.extras$key == null) {
                this.extras$key = new java.util.ArrayList<String>();
                this.extras$value = new java.util.ArrayList<String>();
            }
            this.extras$key.add(extraKey);
            this.extras$value.add(extraValue);
            return self();
        }

        @JsonProperty("extra")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B extras(final java.util.Map<? extends String, ? extends String> extras) {
            if (extras == null) {
                throw new java.lang.NullPointerException("extras cannot be null");
            }
            if (this.extras$key == null) {
                this.extras$key = new java.util.ArrayList<String>();
                this.extras$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : extras.entrySet()) {
                this.extras$key.add($lombokEntry.getKey());
                this.extras$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearExtras() {
            if (this.extras$key != null) {
                this.extras$key.clear();
                this.extras$value.clear();
            }
            return self();
        }

        /**
         * Name of the connector configuration responsible for managing the credential.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B connectorConfigName(final String connectorConfigName) {
            this.connectorConfigName = connectorConfigName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Credential.CredentialBuilder(super=" + super.toString() + ", id=" + this.id + ", name=" + this.name + ", host=" + this.host + ", port=" + this.port + ", authType=" + this.authType + ", connectorType=" + this.connectorType + ", username=" + this.username + ", password=" + this.password + ", extras$key=" + this.extras$key + ", extras$value=" + this.extras$value + ", connectorConfigName=" + this.connectorConfigName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class CredentialBuilderImpl extends Credential.CredentialBuilder<Credential, Credential.CredentialBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CredentialBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Credential.CredentialBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Credential build() {
            return new Credential(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Credential(final Credential.CredentialBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.name = b.name;
        this.host = b.host;
        this.port = b.port;
        this.authType = b.authType;
        this.connectorType = b.connectorType;
        this.username = b.username;
        this.password = b.password;
        java.util.Map<String, String> extras;
        switch (b.extras$key == null ? 0 : b.extras$key.size()) {
        case 0: 
            extras = java.util.Collections.emptyMap();
            break;
        case 1: 
            extras = java.util.Collections.singletonMap(b.extras$key.get(0), b.extras$value.get(0));
            break;
        default: 
            extras = new java.util.LinkedHashMap<String, String>(b.extras$key.size() < 1073741824 ? 1 + b.extras$key.size() + (b.extras$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.extras$key.size(); $i++) extras.put(b.extras$key.get($i), (String) b.extras$value.get($i));
            extras = java.util.Collections.unmodifiableMap(extras);
        }
        this.extras = extras;
        this.connectorConfigName = b.connectorConfigName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Credential.CredentialBuilder<?, ?> builder() {
        return new Credential.CredentialBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Credential.CredentialBuilder<?, ?> toBuilder() {
        return new Credential.CredentialBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Unique identifier (GUID) of the credential.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
        return this.id;
    }

    /**
     * Name of the credential.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * Hostname the for which connectivity is defined by the credential.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getHost() {
        return this.host;
    }

    /**
     * Port number on which connectivity should be done.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getPort() {
        return this.port;
    }

    /**
     * Authentication mechanism represented by the credential.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAuthType() {
        return this.authType;
    }

    /**
     * Type of connector used by the credential.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getConnectorType() {
        return this.connectorType;
    }

    /**
     * Less sensitive portion of the credential, typically used for a username for basic
     * authentication or client IDs for other forms of authentication.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUsername() {
        return this.username;
    }

    /**
     * More sensitive portion of the credential, typically used for a password for basic
     * authentication or client secrets for other forms of authentication.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPassword() {
        return this.password;
    }

    /**
     * Additional details about the credential. This can capture, for example, a secondary
     * secret for particular forms of authentication and / or additional details about the
     * scope of the connectivity (a specific database, role, warehouse, etc).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getExtras() {
        return this.extras;
    }

    /**
     * Name of the connector configuration responsible for managing the credential.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getConnectorConfigName() {
        return this.connectorConfigName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Credential)) return false;
        final Credential other = (Credential) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$port = this.getPort();
        final java.lang.Object other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$host = this.getHost();
        final java.lang.Object other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) return false;
        final java.lang.Object this$authType = this.getAuthType();
        final java.lang.Object other$authType = other.getAuthType();
        if (this$authType == null ? other$authType != null : !this$authType.equals(other$authType)) return false;
        final java.lang.Object this$connectorType = this.getConnectorType();
        final java.lang.Object other$connectorType = other.getConnectorType();
        if (this$connectorType == null ? other$connectorType != null : !this$connectorType.equals(other$connectorType)) return false;
        final java.lang.Object this$username = this.getUsername();
        final java.lang.Object other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) return false;
        final java.lang.Object this$password = this.getPassword();
        final java.lang.Object other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) return false;
        final java.lang.Object this$extras = this.getExtras();
        final java.lang.Object other$extras = other.getExtras();
        if (this$extras == null ? other$extras != null : !this$extras.equals(other$extras)) return false;
        final java.lang.Object this$connectorConfigName = this.getConnectorConfigName();
        final java.lang.Object other$connectorConfigName = other.getConnectorConfigName();
        if (this$connectorConfigName == null ? other$connectorConfigName != null : !this$connectorConfigName.equals(other$connectorConfigName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Credential;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $port = this.getPort();
        result = result * PRIME + ($port == null ? 43 : $port.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $host = this.getHost();
        result = result * PRIME + ($host == null ? 43 : $host.hashCode());
        final java.lang.Object $authType = this.getAuthType();
        result = result * PRIME + ($authType == null ? 43 : $authType.hashCode());
        final java.lang.Object $connectorType = this.getConnectorType();
        result = result * PRIME + ($connectorType == null ? 43 : $connectorType.hashCode());
        final java.lang.Object $username = this.getUsername();
        result = result * PRIME + ($username == null ? 43 : $username.hashCode());
        final java.lang.Object $password = this.getPassword();
        result = result * PRIME + ($password == null ? 43 : $password.hashCode());
        final java.lang.Object $extras = this.getExtras();
        result = result * PRIME + ($extras == null ? 43 : $extras.hashCode());
        final java.lang.Object $connectorConfigName = this.getConnectorConfigName();
        result = result * PRIME + ($connectorConfigName == null ? 43 : $connectorConfigName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Credential(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", authType=" + this.getAuthType() + ", connectorType=" + this.getConnectorType() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", extras=" + this.getExtras() + ", connectorConfigName=" + this.getConnectorConfigName() + ")";
    }
}
