// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import lombok.*;

public class GroupRequest extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Criteria by which to filter the list of groups to retrieve.
     */
    String filter;
    /**
     * Property by which to sort the resulting list of groups.
     */
    String sort;
    /**
     * Whether to include an overall count of groups (true) or not (false).
     */
    boolean count;
    /**
     * Starting point for the list of groups when paging.
     */
    int offset;
    /**
     * Maximum number of groups to return per page.
     */
    int limit;

    /**
     * Search for groups using the filters specified in this request object.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the groups
     * @return the filtered groups
     * @throws AtlanException on any issues interacting with the APIs
     */
    public GroupResponse list(AtlanClient client) throws AtlanException {
        return client.groups.list(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$sort() {
        return "name";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static boolean $default$count() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static int $default$offset() {
        return 0;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static int $default$limit() {
        return 20;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class GroupRequestBuilder<C extends GroupRequest, B extends GroupRequest.GroupRequestBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String filter;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean sort$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sort$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean count$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean count$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean offset$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int offset$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean limit$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int limit$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            GroupRequest.GroupRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final GroupRequest instance, final GroupRequest.GroupRequestBuilder<?, ?> b) {
            b.filter(instance.filter);
            b.sort(instance.sort);
            b.count(instance.count);
            b.offset(instance.offset);
            b.limit(instance.limit);
        }

        /**
         * Criteria by which to filter the list of groups to retrieve.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B filter(final String filter) {
            this.filter = filter;
            return self();
        }

        /**
         * Property by which to sort the resulting list of groups.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sort(final String sort) {
            this.sort$value = sort;
            sort$set = true;
            return self();
        }

        /**
         * Whether to include an overall count of groups (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B count(final boolean count) {
            this.count$value = count;
            count$set = true;
            return self();
        }

        /**
         * Starting point for the list of groups when paging.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B offset(final int offset) {
            this.offset$value = offset;
            offset$set = true;
            return self();
        }

        /**
         * Maximum number of groups to return per page.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B limit(final int limit) {
            this.limit$value = limit;
            limit$set = true;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "GroupRequest.GroupRequestBuilder(super=" + super.toString() + ", filter=" + this.filter + ", sort$value=" + this.sort$value + ", count$value=" + this.count$value + ", offset$value=" + this.offset$value + ", limit$value=" + this.limit$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class GroupRequestBuilderImpl extends GroupRequest.GroupRequestBuilder<GroupRequest, GroupRequest.GroupRequestBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private GroupRequestBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected GroupRequest.GroupRequestBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GroupRequest build() {
            return new GroupRequest(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected GroupRequest(final GroupRequest.GroupRequestBuilder<?, ?> b) {
        super(b);
        this.filter = b.filter;
        if (b.sort$set) this.sort = b.sort$value;
         else this.sort = GroupRequest.$default$sort();
        if (b.count$set) this.count = b.count$value;
         else this.count = GroupRequest.$default$count();
        if (b.offset$set) this.offset = b.offset$value;
         else this.offset = GroupRequest.$default$offset();
        if (b.limit$set) this.limit = b.limit$value;
         else this.limit = GroupRequest.$default$limit();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static GroupRequest.GroupRequestBuilder<?, ?> builder() {
        return new GroupRequest.GroupRequestBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public GroupRequest.GroupRequestBuilder<?, ?> toBuilder() {
        return new GroupRequest.GroupRequestBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Criteria by which to filter the list of groups to retrieve.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFilter() {
        return this.filter;
    }

    /**
     * Property by which to sort the resulting list of groups.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSort() {
        return this.sort;
    }

    /**
     * Whether to include an overall count of groups (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean getCount() {
        return this.count;
    }

    /**
     * Starting point for the list of groups when paging.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getOffset() {
        return this.offset;
    }

    /**
     * Maximum number of groups to return per page.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getLimit() {
        return this.limit;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GroupRequest)) return false;
        final GroupRequest other = (GroupRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        if (this.getCount() != other.getCount()) return false;
        if (this.getOffset() != other.getOffset()) return false;
        if (this.getLimit() != other.getLimit()) return false;
        final java.lang.Object this$filter = this.getFilter();
        final java.lang.Object other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) return false;
        final java.lang.Object this$sort = this.getSort();
        final java.lang.Object other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof GroupRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = result * PRIME + (this.getCount() ? 79 : 97);
        result = result * PRIME + this.getOffset();
        result = result * PRIME + this.getLimit();
        final java.lang.Object $filter = this.getFilter();
        result = result * PRIME + ($filter == null ? 43 : $filter.hashCode());
        final java.lang.Object $sort = this.getSort();
        result = result * PRIME + ($sort == null ? 43 : $sort.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "GroupRequest(super=" + super.toString() + ", filter=" + this.getFilter() + ", sort=" + this.getSort() + ", count=" + this.getCount() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }
}
