// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class GroupResponse extends ApiResource implements Iterable<AtlanGroup> {
    private static final long serialVersionUID = 2L;
    private static final int CHARACTERISTICS = Spliterator.NONNULL | Spliterator.IMMUTABLE | Spliterator.ORDERED;
    /**
     * Connectivity to the Atlan tenant where the search was run.
     */
    @JsonIgnore
    AtlanClient client;
    /**
     * Request that produced this response.
     */
    @JsonIgnore
    GroupRequest request;
    /**
     * Total number of groups.
     */
    Integer totalRecord;
    /**
     * Filtered number of groups.
     */
    Integer filterRecord;
    /**
     * Details about each group in this page of the response.
     */
    List<AtlanGroup> records;

    /**
     * Retrieve the next page of results from this response.
     *
     * @return next page of results from this response
     * @throws AtlanException on any API interaction problem
     */
    @JsonIgnore
    public GroupResponse getNextPage() throws AtlanException {
        int from = request.getOffset() < 0 ? 0 : request.getOffset();
        int page = request.getLimit() < 0 ? 20 : request.getLimit();
        GroupRequest next = request.toBuilder().offset(from + page).build();
        return next.list(client);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Iterator<AtlanGroup> iterator() {
        return new GroupResponseIterator(this);
    }

    /**
     * Stream the results (lazily) for processing without needing to manually manage paging.
     * @return a lazily-loaded stream of results from the search
     */
    public Stream<AtlanGroup> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator(), CHARACTERISTICS), false);
    }


    /**
     * Allow results to be iterated through without managing paging retrievals.
     */
    private static class GroupResponseIterator implements Iterator<AtlanGroup> {
        private GroupResponse response;
        private int i;

        public GroupResponseIterator(GroupResponse response) {
            this.response = response;
            this.i = 0;
        }

        /** {@inheritDoc} */
        @Override
        public boolean hasNext() {
            if (response.getRecords() != null && response.getRecords().size() > i) {
                return true;
            } else {
                try {
                    response = response.getNextPage();
                    i = 0;
                    return response.getRecords() != null && response.getRecords().size() > i;
                } catch (AtlanException e) {
                    throw new RuntimeException("Unable to iterate through all pages of search results.", e);
                }
            }
        }

        /** {@inheritDoc} */
        @Override
        public AtlanGroup next() {
            return response.getRecords().get(i++);
        }
    }

    /**
     * Connectivity to the Atlan tenant where the search was run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanClient getClient() {
        return this.client;
    }

    /**
     * Request that produced this response.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public GroupRequest getRequest() {
        return this.request;
    }

    /**
     * Total number of groups.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getTotalRecord() {
        return this.totalRecord;
    }

    /**
     * Filtered number of groups.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getFilterRecord() {
        return this.filterRecord;
    }

    /**
     * Details about each group in this page of the response.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<AtlanGroup> getRecords() {
        return this.records;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GroupResponse)) return false;
        final GroupResponse other = (GroupResponse) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$totalRecord = this.getTotalRecord();
        final java.lang.Object other$totalRecord = other.getTotalRecord();
        if (this$totalRecord == null ? other$totalRecord != null : !this$totalRecord.equals(other$totalRecord)) return false;
        final java.lang.Object this$filterRecord = this.getFilterRecord();
        final java.lang.Object other$filterRecord = other.getFilterRecord();
        if (this$filterRecord == null ? other$filterRecord != null : !this$filterRecord.equals(other$filterRecord)) return false;
        final java.lang.Object this$client = this.getClient();
        final java.lang.Object other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) return false;
        final java.lang.Object this$request = this.getRequest();
        final java.lang.Object other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) return false;
        final java.lang.Object this$records = this.getRecords();
        final java.lang.Object other$records = other.getRecords();
        if (this$records == null ? other$records != null : !this$records.equals(other$records)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof GroupResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $totalRecord = this.getTotalRecord();
        result = result * PRIME + ($totalRecord == null ? 43 : $totalRecord.hashCode());
        final java.lang.Object $filterRecord = this.getFilterRecord();
        result = result * PRIME + ($filterRecord == null ? 43 : $filterRecord.hashCode());
        final java.lang.Object $client = this.getClient();
        result = result * PRIME + ($client == null ? 43 : $client.hashCode());
        final java.lang.Object $request = this.getRequest();
        result = result * PRIME + ($request == null ? 43 : $request.hashCode());
        final java.lang.Object $records = this.getRecords();
        result = result * PRIME + ($records == null ? 43 : $records.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "GroupResponse(super=" + super.toString() + ", client=" + this.getClient() + ", request=" + this.getRequest() + ", totalRecord=" + this.getTotalRecord() + ", filterRecord=" + this.getFilterRecord() + ", records=" + this.getRecords() + ")";
    }

    /**
     * Connectivity to the Atlan tenant where the search was run.
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setClient(final AtlanClient client) {
        this.client = client;
    }

    /**
     * Request that produced this response.
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRequest(final GroupRequest request) {
        this.request = request;
    }
}
