// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.KeycloakEventType;
import java.util.List;
import lombok.*;

public class KeycloakEventRequest extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Application or OAuth client name.
     */
    String client;
    /**
     * IP address from which the event was triggered.
     */
    String ipAddress;
    /**
     * Earliest date from which to include events (format: yyyy-MM-dd).
     */
    String dateFrom;
    /**
     * Latest date up to which to include events (format: yyyy-MM-dd).
     */
    String dateTo;
    /**
     * Starting point for the events (for paging).
     */
    int offset;
    /**
     * Maximum number of events to retrieve (per page).
     */
    int size;
    /**
     * Include events only of the supplied types.
     */
    List<KeycloakEventType> types;
    /**
     * Unique identifier (GUID) of the user who triggered the event.
     */
    String userId;

    /**
     * Search for events using the filters specified in this request object.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the events
     * @return the filtered events
     * @throws AtlanException on any issues interacting with the APIs
     */
    public KeycloakEventResponse search(AtlanClient client) throws AtlanException {
        return client.logs.getEvents(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static int $default$offset() {
        return 0;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static int $default$size() {
        return 100;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class KeycloakEventRequestBuilder<C extends KeycloakEventRequest, B extends KeycloakEventRequest.KeycloakEventRequestBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String client;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String ipAddress;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dateFrom;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dateTo;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean offset$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int offset$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean size$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int size$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<KeycloakEventType> types;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String userId;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            KeycloakEventRequest.KeycloakEventRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final KeycloakEventRequest instance, final KeycloakEventRequest.KeycloakEventRequestBuilder<?, ?> b) {
            b.client(instance.client);
            b.ipAddress(instance.ipAddress);
            b.dateFrom(instance.dateFrom);
            b.dateTo(instance.dateTo);
            b.offset(instance.offset);
            b.size(instance.size);
            b.types(instance.types == null ? java.util.Collections.<KeycloakEventType>emptyList() : instance.types);
            b.userId(instance.userId);
        }

        /**
         * Application or OAuth client name.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B client(final String client) {
            this.client = client;
            return self();
        }

        /**
         * IP address from which the event was triggered.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B ipAddress(final String ipAddress) {
            this.ipAddress = ipAddress;
            return self();
        }

        /**
         * Earliest date from which to include events (format: yyyy-MM-dd).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dateFrom(final String dateFrom) {
            this.dateFrom = dateFrom;
            return self();
        }

        /**
         * Latest date up to which to include events (format: yyyy-MM-dd).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dateTo(final String dateTo) {
            this.dateTo = dateTo;
            return self();
        }

        /**
         * Starting point for the events (for paging).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B offset(final int offset) {
            this.offset$value = offset;
            offset$set = true;
            return self();
        }

        /**
         * Maximum number of events to retrieve (per page).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B size(final int size) {
            this.size$value = size;
            size$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B type(final KeycloakEventType type) {
            if (this.types == null) this.types = new java.util.ArrayList<KeycloakEventType>();
            this.types.add(type);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B types(final java.util.Collection<? extends KeycloakEventType> types) {
            if (types == null) {
                throw new java.lang.NullPointerException("types cannot be null");
            }
            if (this.types == null) this.types = new java.util.ArrayList<KeycloakEventType>();
            this.types.addAll(types);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTypes() {
            if (this.types != null) this.types.clear();
            return self();
        }

        /**
         * Unique identifier (GUID) of the user who triggered the event.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B userId(final String userId) {
            this.userId = userId;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "KeycloakEventRequest.KeycloakEventRequestBuilder(super=" + super.toString() + ", client=" + this.client + ", ipAddress=" + this.ipAddress + ", dateFrom=" + this.dateFrom + ", dateTo=" + this.dateTo + ", offset$value=" + this.offset$value + ", size$value=" + this.size$value + ", types=" + this.types + ", userId=" + this.userId + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class KeycloakEventRequestBuilderImpl extends KeycloakEventRequest.KeycloakEventRequestBuilder<KeycloakEventRequest, KeycloakEventRequest.KeycloakEventRequestBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private KeycloakEventRequestBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected KeycloakEventRequest.KeycloakEventRequestBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public KeycloakEventRequest build() {
            return new KeycloakEventRequest(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected KeycloakEventRequest(final KeycloakEventRequest.KeycloakEventRequestBuilder<?, ?> b) {
        super(b);
        this.client = b.client;
        this.ipAddress = b.ipAddress;
        this.dateFrom = b.dateFrom;
        this.dateTo = b.dateTo;
        if (b.offset$set) this.offset = b.offset$value;
         else this.offset = KeycloakEventRequest.$default$offset();
        if (b.size$set) this.size = b.size$value;
         else this.size = KeycloakEventRequest.$default$size();
        java.util.List<KeycloakEventType> types;
        switch (b.types == null ? 0 : b.types.size()) {
        case 0: 
            types = java.util.Collections.emptyList();
            break;
        case 1: 
            types = java.util.Collections.singletonList(b.types.get(0));
            break;
        default: 
            types = java.util.Collections.unmodifiableList(new java.util.ArrayList<KeycloakEventType>(b.types));
        }
        this.types = types;
        this.userId = b.userId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static KeycloakEventRequest.KeycloakEventRequestBuilder<?, ?> builder() {
        return new KeycloakEventRequest.KeycloakEventRequestBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public KeycloakEventRequest.KeycloakEventRequestBuilder<?, ?> toBuilder() {
        return new KeycloakEventRequest.KeycloakEventRequestBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Application or OAuth client name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getClient() {
        return this.client;
    }

    /**
     * IP address from which the event was triggered.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    /**
     * Earliest date from which to include events (format: yyyy-MM-dd).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDateFrom() {
        return this.dateFrom;
    }

    /**
     * Latest date up to which to include events (format: yyyy-MM-dd).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDateTo() {
        return this.dateTo;
    }

    /**
     * Starting point for the events (for paging).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getOffset() {
        return this.offset;
    }

    /**
     * Maximum number of events to retrieve (per page).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getSize() {
        return this.size;
    }

    /**
     * Include events only of the supplied types.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<KeycloakEventType> getTypes() {
        return this.types;
    }

    /**
     * Unique identifier (GUID) of the user who triggered the event.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUserId() {
        return this.userId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof KeycloakEventRequest)) return false;
        final KeycloakEventRequest other = (KeycloakEventRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        if (this.getOffset() != other.getOffset()) return false;
        if (this.getSize() != other.getSize()) return false;
        final java.lang.Object this$client = this.getClient();
        final java.lang.Object other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) return false;
        final java.lang.Object this$ipAddress = this.getIpAddress();
        final java.lang.Object other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) return false;
        final java.lang.Object this$dateFrom = this.getDateFrom();
        final java.lang.Object other$dateFrom = other.getDateFrom();
        if (this$dateFrom == null ? other$dateFrom != null : !this$dateFrom.equals(other$dateFrom)) return false;
        final java.lang.Object this$dateTo = this.getDateTo();
        final java.lang.Object other$dateTo = other.getDateTo();
        if (this$dateTo == null ? other$dateTo != null : !this$dateTo.equals(other$dateTo)) return false;
        final java.lang.Object this$types = this.getTypes();
        final java.lang.Object other$types = other.getTypes();
        if (this$types == null ? other$types != null : !this$types.equals(other$types)) return false;
        final java.lang.Object this$userId = this.getUserId();
        final java.lang.Object other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof KeycloakEventRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = result * PRIME + this.getOffset();
        result = result * PRIME + this.getSize();
        final java.lang.Object $client = this.getClient();
        result = result * PRIME + ($client == null ? 43 : $client.hashCode());
        final java.lang.Object $ipAddress = this.getIpAddress();
        result = result * PRIME + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        final java.lang.Object $dateFrom = this.getDateFrom();
        result = result * PRIME + ($dateFrom == null ? 43 : $dateFrom.hashCode());
        final java.lang.Object $dateTo = this.getDateTo();
        result = result * PRIME + ($dateTo == null ? 43 : $dateTo.hashCode());
        final java.lang.Object $types = this.getTypes();
        result = result * PRIME + ($types == null ? 43 : $types.hashCode());
        final java.lang.Object $userId = this.getUserId();
        result = result * PRIME + ($userId == null ? 43 : $userId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "KeycloakEventRequest(super=" + super.toString() + ", client=" + this.getClient() + ", ipAddress=" + this.getIpAddress() + ", dateFrom=" + this.getDateFrom() + ", dateTo=" + this.getDateTo() + ", offset=" + this.getOffset() + ", size=" + this.getSize() + ", types=" + this.getTypes() + ", userId=" + this.getUserId() + ")";
    }
}
