// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.model.core.AtlanObject;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.*;

/**
 * Response containing the details of a parsed SQL query.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ParsedQuery.ParsedQueryBuilder.class)
public class ParsedQuery extends ApiResource {
    private static final long serialVersionUID = 2L;
    /**
     * All the database objects detected in the query.
     */
    @JsonProperty("dbobjs")
    List<DatabaseObject> objects;
    /**
     * All the relationship objects detected in the query.
     */
    List<Relationship> relationships;
    /**
     * Any errors during parsing.
     */
    List<ParseError> errors;


    /**
     * Details about a database object in a query.
     */
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ParsedQuery.DatabaseObject.DatabaseObjectBuilderImpl.class)
    public static final class DatabaseObject extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /**
         * Fully-qualified name of the SQL object. (Only present on non-process objects.)
         */
        String displayName;
        /**
         * Numeric identifier for the object.
         */
        String id;
        /**
         * Name of the object (unqualified).
         */
        String name;
        /**
         * Type of the object.
         */
        String type;
        /**
         * Name of the database the object exists within.
         */
        String database;
        /**
         * Name of the schema the object exists within.
         */
        String schema;
        /**
         * List of details about the columns queried within the object. (Only present on non-process objects.)
         */
        List<DatabaseColumn> columns;
        /**
         * Name of the procedure (only for process objects).
         */
        String procedureName;
        /**
         * Unique hash representing the query (only for process objects).
         */
        String queryHashId;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class DatabaseObjectBuilder<C extends ParsedQuery.DatabaseObject, B extends ParsedQuery.DatabaseObject.DatabaseObjectBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String displayName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String id;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String name;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String type;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String database;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String schema;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<DatabaseColumn> columns;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String procedureName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String queryHashId;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                ParsedQuery.DatabaseObject.DatabaseObjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final ParsedQuery.DatabaseObject instance, final ParsedQuery.DatabaseObject.DatabaseObjectBuilder<?, ?> b) {
                b.displayName(instance.displayName);
                b.id(instance.id);
                b.name(instance.name);
                b.type(instance.type);
                b.database(instance.database);
                b.schema(instance.schema);
                b.columns(instance.columns);
                b.procedureName(instance.procedureName);
                b.queryHashId(instance.queryHashId);
            }

            /**
             * Fully-qualified name of the SQL object. (Only present on non-process objects.)
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B displayName(final String displayName) {
                this.displayName = displayName;
                return self();
            }

            /**
             * Numeric identifier for the object.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B id(final String id) {
                this.id = id;
                return self();
            }

            /**
             * Name of the object (unqualified).
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B name(final String name) {
                this.name = name;
                return self();
            }

            /**
             * Type of the object.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B type(final String type) {
                this.type = type;
                return self();
            }

            /**
             * Name of the database the object exists within.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B database(final String database) {
                this.database = database;
                return self();
            }

            /**
             * Name of the schema the object exists within.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B schema(final String schema) {
                this.schema = schema;
                return self();
            }

            /**
             * List of details about the columns queried within the object. (Only present on non-process objects.)
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B columns(final List<DatabaseColumn> columns) {
                this.columns = columns;
                return self();
            }

            /**
             * Name of the procedure (only for process objects).
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B procedureName(final String procedureName) {
                this.procedureName = procedureName;
                return self();
            }

            /**
             * Unique hash representing the query (only for process objects).
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B queryHashId(final String queryHashId) {
                this.queryHashId = queryHashId;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "ParsedQuery.DatabaseObject.DatabaseObjectBuilder(super=" + super.toString() + ", displayName=" + this.displayName + ", id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", database=" + this.database + ", schema=" + this.schema + ", columns=" + this.columns + ", procedureName=" + this.procedureName + ", queryHashId=" + this.queryHashId + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class DatabaseObjectBuilderImpl extends ParsedQuery.DatabaseObject.DatabaseObjectBuilder<ParsedQuery.DatabaseObject, ParsedQuery.DatabaseObject.DatabaseObjectBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private DatabaseObjectBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected ParsedQuery.DatabaseObject.DatabaseObjectBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ParsedQuery.DatabaseObject build() {
                return new ParsedQuery.DatabaseObject(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DatabaseObject(final ParsedQuery.DatabaseObject.DatabaseObjectBuilder<?, ?> b) {
            super(b);
            this.displayName = b.displayName;
            this.id = b.id;
            this.name = b.name;
            this.type = b.type;
            this.database = b.database;
            this.schema = b.schema;
            this.columns = b.columns;
            this.procedureName = b.procedureName;
            this.queryHashId = b.queryHashId;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static ParsedQuery.DatabaseObject.DatabaseObjectBuilder<?, ?> builder() {
            return new ParsedQuery.DatabaseObject.DatabaseObjectBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ParsedQuery.DatabaseObject.DatabaseObjectBuilder<?, ?> toBuilder() {
            return new ParsedQuery.DatabaseObject.DatabaseObjectBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Fully-qualified name of the SQL object. (Only present on non-process objects.)
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDisplayName() {
            return this.displayName;
        }

        /**
         * Numeric identifier for the object.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getId() {
            return this.id;
        }

        /**
         * Name of the object (unqualified).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
            return this.name;
        }

        /**
         * Type of the object.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getType() {
            return this.type;
        }

        /**
         * Name of the database the object exists within.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDatabase() {
            return this.database;
        }

        /**
         * Name of the schema the object exists within.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getSchema() {
            return this.schema;
        }

        /**
         * List of details about the columns queried within the object. (Only present on non-process objects.)
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<DatabaseColumn> getColumns() {
            return this.columns;
        }

        /**
         * Name of the procedure (only for process objects).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getProcedureName() {
            return this.procedureName;
        }

        /**
         * Unique hash representing the query (only for process objects).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getQueryHashId() {
            return this.queryHashId;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ParsedQuery.DatabaseObject)) return false;
            final ParsedQuery.DatabaseObject other = (ParsedQuery.DatabaseObject) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$displayName = this.getDisplayName();
            final java.lang.Object other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            final java.lang.Object this$type = this.getType();
            final java.lang.Object other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
            final java.lang.Object this$database = this.getDatabase();
            final java.lang.Object other$database = other.getDatabase();
            if (this$database == null ? other$database != null : !this$database.equals(other$database)) return false;
            final java.lang.Object this$schema = this.getSchema();
            final java.lang.Object other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) return false;
            final java.lang.Object this$columns = this.getColumns();
            final java.lang.Object other$columns = other.getColumns();
            if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) return false;
            final java.lang.Object this$procedureName = this.getProcedureName();
            final java.lang.Object other$procedureName = other.getProcedureName();
            if (this$procedureName == null ? other$procedureName != null : !this$procedureName.equals(other$procedureName)) return false;
            final java.lang.Object this$queryHashId = this.getQueryHashId();
            final java.lang.Object other$queryHashId = other.getQueryHashId();
            if (this$queryHashId == null ? other$queryHashId != null : !this$queryHashId.equals(other$queryHashId)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ParsedQuery.DatabaseObject;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $displayName = this.getDisplayName();
            result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $type = this.getType();
            result = result * PRIME + ($type == null ? 43 : $type.hashCode());
            final java.lang.Object $database = this.getDatabase();
            result = result * PRIME + ($database == null ? 43 : $database.hashCode());
            final java.lang.Object $schema = this.getSchema();
            result = result * PRIME + ($schema == null ? 43 : $schema.hashCode());
            final java.lang.Object $columns = this.getColumns();
            result = result * PRIME + ($columns == null ? 43 : $columns.hashCode());
            final java.lang.Object $procedureName = this.getProcedureName();
            result = result * PRIME + ($procedureName == null ? 43 : $procedureName.hashCode());
            final java.lang.Object $queryHashId = this.getQueryHashId();
            result = result * PRIME + ($queryHashId == null ? 43 : $queryHashId.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ParsedQuery.DatabaseObject(super=" + super.toString() + ", displayName=" + this.getDisplayName() + ", id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", database=" + this.getDatabase() + ", schema=" + this.getSchema() + ", columns=" + this.getColumns() + ", procedureName=" + this.getProcedureName() + ", queryHashId=" + this.getQueryHashId() + ")";
        }
    }


    /**
     * Details about relationships found in a query.
     */
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ParsedQuery.Relationship.RelationshipBuilderImpl.class)
    public static final class Relationship extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /**
         * Numeric identifier for the relationship.
         */
        String id;
        /**
         * Type of the relationship.
         */
        String type;
        /**
         * Type of effect made by the query (for example, select vs insert).
         */
        String effectType;
        /**
         * TBC
         */
        RelationshipEndpoint target;
        /**
         * TBC
         */
        List<RelationshipEndpoint> sources;
        /**
         * Numeric identifier for the procedure (if any) that manages this relationship.
         */
        String processId;
        /**
         * Type of procedure (if any) that manages this relationship.
         */
        String processType;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class RelationshipBuilder<C extends ParsedQuery.Relationship, B extends ParsedQuery.Relationship.RelationshipBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String id;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String type;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String effectType;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private RelationshipEndpoint target;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<RelationshipEndpoint> sources;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String processId;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String processType;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                ParsedQuery.Relationship.RelationshipBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final ParsedQuery.Relationship instance, final ParsedQuery.Relationship.RelationshipBuilder<?, ?> b) {
                b.id(instance.id);
                b.type(instance.type);
                b.effectType(instance.effectType);
                b.target(instance.target);
                b.sources(instance.sources);
                b.processId(instance.processId);
                b.processType(instance.processType);
            }

            /**
             * Numeric identifier for the relationship.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B id(final String id) {
                this.id = id;
                return self();
            }

            /**
             * Type of the relationship.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B type(final String type) {
                this.type = type;
                return self();
            }

            /**
             * Type of effect made by the query (for example, select vs insert).
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B effectType(final String effectType) {
                this.effectType = effectType;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B target(final RelationshipEndpoint target) {
                this.target = target;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B sources(final List<RelationshipEndpoint> sources) {
                this.sources = sources;
                return self();
            }

            /**
             * Numeric identifier for the procedure (if any) that manages this relationship.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B processId(final String processId) {
                this.processId = processId;
                return self();
            }

            /**
             * Type of procedure (if any) that manages this relationship.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B processType(final String processType) {
                this.processType = processType;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "ParsedQuery.Relationship.RelationshipBuilder(super=" + super.toString() + ", id=" + this.id + ", type=" + this.type + ", effectType=" + this.effectType + ", target=" + this.target + ", sources=" + this.sources + ", processId=" + this.processId + ", processType=" + this.processType + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class RelationshipBuilderImpl extends ParsedQuery.Relationship.RelationshipBuilder<ParsedQuery.Relationship, ParsedQuery.Relationship.RelationshipBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private RelationshipBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected ParsedQuery.Relationship.RelationshipBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ParsedQuery.Relationship build() {
                return new ParsedQuery.Relationship(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Relationship(final ParsedQuery.Relationship.RelationshipBuilder<?, ?> b) {
            super(b);
            this.id = b.id;
            this.type = b.type;
            this.effectType = b.effectType;
            this.target = b.target;
            this.sources = b.sources;
            this.processId = b.processId;
            this.processType = b.processType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static ParsedQuery.Relationship.RelationshipBuilder<?, ?> builder() {
            return new ParsedQuery.Relationship.RelationshipBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ParsedQuery.Relationship.RelationshipBuilder<?, ?> toBuilder() {
            return new ParsedQuery.Relationship.RelationshipBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Numeric identifier for the relationship.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getId() {
            return this.id;
        }

        /**
         * Type of the relationship.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getType() {
            return this.type;
        }

        /**
         * Type of effect made by the query (for example, select vs insert).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getEffectType() {
            return this.effectType;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RelationshipEndpoint getTarget() {
            return this.target;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<RelationshipEndpoint> getSources() {
            return this.sources;
        }

        /**
         * Numeric identifier for the procedure (if any) that manages this relationship.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getProcessId() {
            return this.processId;
        }

        /**
         * Type of procedure (if any) that manages this relationship.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getProcessType() {
            return this.processType;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ParsedQuery.Relationship)) return false;
            final ParsedQuery.Relationship other = (ParsedQuery.Relationship) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
            final java.lang.Object this$type = this.getType();
            final java.lang.Object other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
            final java.lang.Object this$effectType = this.getEffectType();
            final java.lang.Object other$effectType = other.getEffectType();
            if (this$effectType == null ? other$effectType != null : !this$effectType.equals(other$effectType)) return false;
            final java.lang.Object this$target = this.getTarget();
            final java.lang.Object other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) return false;
            final java.lang.Object this$sources = this.getSources();
            final java.lang.Object other$sources = other.getSources();
            if (this$sources == null ? other$sources != null : !this$sources.equals(other$sources)) return false;
            final java.lang.Object this$processId = this.getProcessId();
            final java.lang.Object other$processId = other.getProcessId();
            if (this$processId == null ? other$processId != null : !this$processId.equals(other$processId)) return false;
            final java.lang.Object this$processType = this.getProcessType();
            final java.lang.Object other$processType = other.getProcessType();
            if (this$processType == null ? other$processType != null : !this$processType.equals(other$processType)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ParsedQuery.Relationship;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            final java.lang.Object $type = this.getType();
            result = result * PRIME + ($type == null ? 43 : $type.hashCode());
            final java.lang.Object $effectType = this.getEffectType();
            result = result * PRIME + ($effectType == null ? 43 : $effectType.hashCode());
            final java.lang.Object $target = this.getTarget();
            result = result * PRIME + ($target == null ? 43 : $target.hashCode());
            final java.lang.Object $sources = this.getSources();
            result = result * PRIME + ($sources == null ? 43 : $sources.hashCode());
            final java.lang.Object $processId = this.getProcessId();
            result = result * PRIME + ($processId == null ? 43 : $processId.hashCode());
            final java.lang.Object $processType = this.getProcessType();
            result = result * PRIME + ($processType == null ? 43 : $processType.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ParsedQuery.Relationship(super=" + super.toString() + ", id=" + this.getId() + ", type=" + this.getType() + ", effectType=" + this.getEffectType() + ", target=" + this.getTarget() + ", sources=" + this.getSources() + ", processId=" + this.getProcessId() + ", processType=" + this.getProcessType() + ")";
        }
    }


    /**
     * Details about a column accessed by a query.
     */
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ParsedQuery.DatabaseColumn.DatabaseColumnBuilderImpl.class)
    public static final class DatabaseColumn extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /**
         * Numeric identifier for the column.
         */
        String id;
        /**
         * Name of the column (unqualified).
         */
        String name;
        /**
         * TBC
         */
        String source;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class DatabaseColumnBuilder<C extends ParsedQuery.DatabaseColumn, B extends ParsedQuery.DatabaseColumn.DatabaseColumnBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String id;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String name;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String source;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                ParsedQuery.DatabaseColumn.DatabaseColumnBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final ParsedQuery.DatabaseColumn instance, final ParsedQuery.DatabaseColumn.DatabaseColumnBuilder<?, ?> b) {
                b.id(instance.id);
                b.name(instance.name);
                b.source(instance.source);
            }

            /**
             * Numeric identifier for the column.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B id(final String id) {
                this.id = id;
                return self();
            }

            /**
             * Name of the column (unqualified).
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B name(final String name) {
                this.name = name;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B source(final String source) {
                this.source = source;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "ParsedQuery.DatabaseColumn.DatabaseColumnBuilder(super=" + super.toString() + ", id=" + this.id + ", name=" + this.name + ", source=" + this.source + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class DatabaseColumnBuilderImpl extends ParsedQuery.DatabaseColumn.DatabaseColumnBuilder<ParsedQuery.DatabaseColumn, ParsedQuery.DatabaseColumn.DatabaseColumnBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private DatabaseColumnBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected ParsedQuery.DatabaseColumn.DatabaseColumnBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ParsedQuery.DatabaseColumn build() {
                return new ParsedQuery.DatabaseColumn(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DatabaseColumn(final ParsedQuery.DatabaseColumn.DatabaseColumnBuilder<?, ?> b) {
            super(b);
            this.id = b.id;
            this.name = b.name;
            this.source = b.source;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static ParsedQuery.DatabaseColumn.DatabaseColumnBuilder<?, ?> builder() {
            return new ParsedQuery.DatabaseColumn.DatabaseColumnBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ParsedQuery.DatabaseColumn.DatabaseColumnBuilder<?, ?> toBuilder() {
            return new ParsedQuery.DatabaseColumn.DatabaseColumnBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Numeric identifier for the column.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getId() {
            return this.id;
        }

        /**
         * Name of the column (unqualified).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
            return this.name;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getSource() {
            return this.source;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ParsedQuery.DatabaseColumn)) return false;
            final ParsedQuery.DatabaseColumn other = (ParsedQuery.DatabaseColumn) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            final java.lang.Object this$source = this.getSource();
            final java.lang.Object other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ParsedQuery.DatabaseColumn;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $source = this.getSource();
            result = result * PRIME + ($source == null ? 43 : $source.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ParsedQuery.DatabaseColumn(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", source=" + this.getSource() + ")";
        }
    }


    /**
     * Details about one end of a relationship in a query.
     */
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilderImpl.class)
    public static final class RelationshipEndpoint extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /**
         * Numeric identifier for the column referred to by this end of the relationship.
         */
        String id;
        /**
         * Name of the column used by this end of the relationship.
         */
        String column;
        /**
         * Numeric identifier of the parent object in which the column exists.
         */
        String parentId;
        /**
         * Name of the parent object in which the column exists.
         */
        String parentName;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class RelationshipEndpointBuilder<C extends ParsedQuery.RelationshipEndpoint, B extends ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String id;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String column;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String parentId;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String parentName;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final ParsedQuery.RelationshipEndpoint instance, final ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilder<?, ?> b) {
                b.id(instance.id);
                b.column(instance.column);
                b.parentId(instance.parentId);
                b.parentName(instance.parentName);
            }

            /**
             * Numeric identifier for the column referred to by this end of the relationship.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B id(final String id) {
                this.id = id;
                return self();
            }

            /**
             * Name of the column used by this end of the relationship.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B column(final String column) {
                this.column = column;
                return self();
            }

            /**
             * Numeric identifier of the parent object in which the column exists.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B parentId(final String parentId) {
                this.parentId = parentId;
                return self();
            }

            /**
             * Name of the parent object in which the column exists.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B parentName(final String parentName) {
                this.parentName = parentName;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilder(super=" + super.toString() + ", id=" + this.id + ", column=" + this.column + ", parentId=" + this.parentId + ", parentName=" + this.parentName + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class RelationshipEndpointBuilderImpl extends ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilder<ParsedQuery.RelationshipEndpoint, ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private RelationshipEndpointBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ParsedQuery.RelationshipEndpoint build() {
                return new ParsedQuery.RelationshipEndpoint(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected RelationshipEndpoint(final ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilder<?, ?> b) {
            super(b);
            this.id = b.id;
            this.column = b.column;
            this.parentId = b.parentId;
            this.parentName = b.parentName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilder<?, ?> builder() {
            return new ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilder<?, ?> toBuilder() {
            return new ParsedQuery.RelationshipEndpoint.RelationshipEndpointBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Numeric identifier for the column referred to by this end of the relationship.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getId() {
            return this.id;
        }

        /**
         * Name of the column used by this end of the relationship.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getColumn() {
            return this.column;
        }

        /**
         * Numeric identifier of the parent object in which the column exists.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getParentId() {
            return this.parentId;
        }

        /**
         * Name of the parent object in which the column exists.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getParentName() {
            return this.parentName;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ParsedQuery.RelationshipEndpoint)) return false;
            final ParsedQuery.RelationshipEndpoint other = (ParsedQuery.RelationshipEndpoint) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
            final java.lang.Object this$column = this.getColumn();
            final java.lang.Object other$column = other.getColumn();
            if (this$column == null ? other$column != null : !this$column.equals(other$column)) return false;
            final java.lang.Object this$parentId = this.getParentId();
            final java.lang.Object other$parentId = other.getParentId();
            if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) return false;
            final java.lang.Object this$parentName = this.getParentName();
            final java.lang.Object other$parentName = other.getParentName();
            if (this$parentName == null ? other$parentName != null : !this$parentName.equals(other$parentName)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ParsedQuery.RelationshipEndpoint;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            final java.lang.Object $column = this.getColumn();
            result = result * PRIME + ($column == null ? 43 : $column.hashCode());
            final java.lang.Object $parentId = this.getParentId();
            result = result * PRIME + ($parentId == null ? 43 : $parentId.hashCode());
            final java.lang.Object $parentName = this.getParentName();
            result = result * PRIME + ($parentName == null ? 43 : $parentName.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ParsedQuery.RelationshipEndpoint(super=" + super.toString() + ", id=" + this.getId() + ", column=" + this.getColumn() + ", parentId=" + this.getParentId() + ", parentName=" + this.getParentName() + ")";
        }
    }


    /**
     * Details of any errors during query parsing.
     */
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ParsedQuery.ParseError.ParseErrorBuilderImpl.class)
    public static final class ParseError extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /** Description of the error. */
        String errorMessage;
        /** Type of the error. */
        String errorType;
        /** TBC */
        List<Object> coordinates;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class ParseErrorBuilder<C extends ParsedQuery.ParseError, B extends ParsedQuery.ParseError.ParseErrorBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String errorMessage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String errorType;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<Object> coordinates;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                ParsedQuery.ParseError.ParseErrorBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final ParsedQuery.ParseError instance, final ParsedQuery.ParseError.ParseErrorBuilder<?, ?> b) {
                b.errorMessage(instance.errorMessage);
                b.errorType(instance.errorType);
                b.coordinates(instance.coordinates);
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B errorMessage(final String errorMessage) {
                this.errorMessage = errorMessage;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B errorType(final String errorType) {
                this.errorType = errorType;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B coordinates(final List<Object> coordinates) {
                this.coordinates = coordinates;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "ParsedQuery.ParseError.ParseErrorBuilder(super=" + super.toString() + ", errorMessage=" + this.errorMessage + ", errorType=" + this.errorType + ", coordinates=" + this.coordinates + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class ParseErrorBuilderImpl extends ParsedQuery.ParseError.ParseErrorBuilder<ParsedQuery.ParseError, ParsedQuery.ParseError.ParseErrorBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private ParseErrorBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected ParsedQuery.ParseError.ParseErrorBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ParsedQuery.ParseError build() {
                return new ParsedQuery.ParseError(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected ParseError(final ParsedQuery.ParseError.ParseErrorBuilder<?, ?> b) {
            super(b);
            this.errorMessage = b.errorMessage;
            this.errorType = b.errorType;
            this.coordinates = b.coordinates;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static ParsedQuery.ParseError.ParseErrorBuilder<?, ?> builder() {
            return new ParsedQuery.ParseError.ParseErrorBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ParsedQuery.ParseError.ParseErrorBuilder<?, ?> toBuilder() {
            return new ParsedQuery.ParseError.ParseErrorBuilderImpl().$fillValuesFrom(this);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getErrorType() {
            return this.errorType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<Object> getCoordinates() {
            return this.coordinates;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ParsedQuery.ParseError)) return false;
            final ParsedQuery.ParseError other = (ParsedQuery.ParseError) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$errorMessage = this.getErrorMessage();
            final java.lang.Object other$errorMessage = other.getErrorMessage();
            if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) return false;
            final java.lang.Object this$errorType = this.getErrorType();
            final java.lang.Object other$errorType = other.getErrorType();
            if (this$errorType == null ? other$errorType != null : !this$errorType.equals(other$errorType)) return false;
            final java.lang.Object this$coordinates = this.getCoordinates();
            final java.lang.Object other$coordinates = other.getCoordinates();
            if (this$coordinates == null ? other$coordinates != null : !this$coordinates.equals(other$coordinates)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ParsedQuery.ParseError;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $errorMessage = this.getErrorMessage();
            result = result * PRIME + ($errorMessage == null ? 43 : $errorMessage.hashCode());
            final java.lang.Object $errorType = this.getErrorType();
            result = result * PRIME + ($errorType == null ? 43 : $errorType.hashCode());
            final java.lang.Object $coordinates = this.getCoordinates();
            result = result * PRIME + ($coordinates == null ? 43 : $coordinates.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ParsedQuery.ParseError(super=" + super.toString() + ", errorMessage=" + this.getErrorMessage() + ", errorType=" + this.getErrorType() + ", coordinates=" + this.getCoordinates() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    ParsedQuery(final List<DatabaseObject> objects, final List<Relationship> relationships, final List<ParseError> errors) {
        this.objects = objects;
        this.relationships = relationships;
        this.errors = errors;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class ParsedQueryBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<DatabaseObject> objects;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<Relationship> relationships;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<ParseError> errors;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        ParsedQueryBuilder() {
        }

        /**
         * All the database objects detected in the query.
         * @return {@code this}.
         */
        @JsonProperty("dbobjs")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ParsedQuery.ParsedQueryBuilder objects(final List<DatabaseObject> objects) {
            this.objects = objects;
            return this;
        }

        /**
         * All the relationship objects detected in the query.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ParsedQuery.ParsedQueryBuilder relationships(final List<Relationship> relationships) {
            this.relationships = relationships;
            return this;
        }

        /**
         * Any errors during parsing.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ParsedQuery.ParsedQueryBuilder errors(final List<ParseError> errors) {
            this.errors = errors;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ParsedQuery build() {
            return new ParsedQuery(this.objects, this.relationships, this.errors);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ParsedQuery.ParsedQueryBuilder(objects=" + this.objects + ", relationships=" + this.relationships + ", errors=" + this.errors + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ParsedQuery.ParsedQueryBuilder builder() {
        return new ParsedQuery.ParsedQueryBuilder();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ParsedQuery.ParsedQueryBuilder toBuilder() {
        return new ParsedQuery.ParsedQueryBuilder().objects(this.objects).relationships(this.relationships).errors(this.errors);
    }

    /**
     * All the database objects detected in the query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<DatabaseObject> getObjects() {
        return this.objects;
    }

    /**
     * All the relationship objects detected in the query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    /**
     * Any errors during parsing.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<ParseError> getErrors() {
        return this.errors;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ParsedQuery)) return false;
        final ParsedQuery other = (ParsedQuery) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$objects = this.getObjects();
        final java.lang.Object other$objects = other.getObjects();
        if (this$objects == null ? other$objects != null : !this$objects.equals(other$objects)) return false;
        final java.lang.Object this$relationships = this.getRelationships();
        final java.lang.Object other$relationships = other.getRelationships();
        if (this$relationships == null ? other$relationships != null : !this$relationships.equals(other$relationships)) return false;
        final java.lang.Object this$errors = this.getErrors();
        final java.lang.Object other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !this$errors.equals(other$errors)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ParsedQuery;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $objects = this.getObjects();
        result = result * PRIME + ($objects == null ? 43 : $objects.hashCode());
        final java.lang.Object $relationships = this.getRelationships();
        result = result * PRIME + ($relationships == null ? 43 : $relationships.hashCode());
        final java.lang.Object $errors = this.getErrors();
        result = result * PRIME + ($errors == null ? 43 : $errors.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ParsedQuery(super=" + super.toString() + ", objects=" + this.getObjects() + ", relationships=" + this.getRelationships() + ", errors=" + this.getErrors() + ")";
    }
}
