// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.model.core.AtlanObject;

public class QueryRequest extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * SQL query to run.
     */
    String sql;
    /**
     * Unique name of the connection to use for the query.
     */
    String dataSourceName;
    /**
     * Default schema name to use for unqualified objects in the SQL, in the form {@code DB.SCHEMA}.
     */
    String defaultSchema;

    /**
     * Builds the minimal object necessary to run a query.
     *
     * @param sql the SQL code to parse
     * @param connectionQualifiedName qualifiedName of the connection on which to run the query
     * @return the minimal request necessary to run a query, as a builder
     */
    public static QueryRequestBuilder<?, ?> creator(String sql, String connectionQualifiedName) {
        return QueryRequest.builder().sql(sql).dataSourceName(connectionQualifiedName);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class QueryRequestBuilder<C extends QueryRequest, B extends QueryRequest.QueryRequestBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sql;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dataSourceName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String defaultSchema;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            QueryRequest.QueryRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final QueryRequest instance, final QueryRequest.QueryRequestBuilder<?, ?> b) {
            b.sql(instance.sql);
            b.dataSourceName(instance.dataSourceName);
            b.defaultSchema(instance.defaultSchema);
        }

        /**
         * SQL query to run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sql(final String sql) {
            this.sql = sql;
            return self();
        }

        /**
         * Unique name of the connection to use for the query.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataSourceName(final String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return self();
        }

        /**
         * Default schema name to use for unqualified objects in the SQL, in the form {@code DB.SCHEMA}.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B defaultSchema(final String defaultSchema) {
            this.defaultSchema = defaultSchema;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "QueryRequest.QueryRequestBuilder(super=" + super.toString() + ", sql=" + this.sql + ", dataSourceName=" + this.dataSourceName + ", defaultSchema=" + this.defaultSchema + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class QueryRequestBuilderImpl extends QueryRequest.QueryRequestBuilder<QueryRequest, QueryRequest.QueryRequestBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private QueryRequestBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected QueryRequest.QueryRequestBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public QueryRequest build() {
            return new QueryRequest(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected QueryRequest(final QueryRequest.QueryRequestBuilder<?, ?> b) {
        super(b);
        this.sql = b.sql;
        this.dataSourceName = b.dataSourceName;
        this.defaultSchema = b.defaultSchema;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static QueryRequest.QueryRequestBuilder<?, ?> builder() {
        return new QueryRequest.QueryRequestBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public QueryRequest.QueryRequestBuilder<?, ?> toBuilder() {
        return new QueryRequest.QueryRequestBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * SQL query to run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSql() {
        return this.sql;
    }

    /**
     * Unique name of the connection to use for the query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    /**
     * Default schema name to use for unqualified objects in the SQL, in the form {@code DB.SCHEMA}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof QueryRequest)) return false;
        final QueryRequest other = (QueryRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$sql = this.getSql();
        final java.lang.Object other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) return false;
        final java.lang.Object this$dataSourceName = this.getDataSourceName();
        final java.lang.Object other$dataSourceName = other.getDataSourceName();
        if (this$dataSourceName == null ? other$dataSourceName != null : !this$dataSourceName.equals(other$dataSourceName)) return false;
        final java.lang.Object this$defaultSchema = this.getDefaultSchema();
        final java.lang.Object other$defaultSchema = other.getDefaultSchema();
        if (this$defaultSchema == null ? other$defaultSchema != null : !this$defaultSchema.equals(other$defaultSchema)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof QueryRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $sql = this.getSql();
        result = result * PRIME + ($sql == null ? 43 : $sql.hashCode());
        final java.lang.Object $dataSourceName = this.getDataSourceName();
        result = result * PRIME + ($dataSourceName == null ? 43 : $dataSourceName.hashCode());
        final java.lang.Object $defaultSchema = this.getDefaultSchema();
        result = result * PRIME + ($defaultSchema == null ? 43 : $defaultSchema.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "QueryRequest(super=" + super.toString() + ", sql=" + this.getSql() + ", dataSourceName=" + this.getDataSourceName() + ", defaultSchema=" + this.getDefaultSchema() + ")";
    }
}
