// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.HekaFlow;
import com.atlan.model.enums.ParsingFlow;
import com.atlan.model.enums.QueryStatus;
import com.atlan.net.ApiEventStreamResource;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import lombok.*;

/**
 * Response containing the details of a parsed SQL query.
 */
public class QueryResponse extends ApiEventStreamResource {
    private static final long serialVersionUID = 2L;

    /**
     * Create a single consolidated response from multiple events related to the same query.
     * (All ApiEventStreamResource objects must have a List constructor like this, as it is
     * used as part of the response deserialization process, via reflection.)
     *
     * @param events detailing the streamed results of a query
     */
    public QueryResponse(List<QueryResponse> events) {
        if (events != null) {
            rows = new ArrayList<>();
            columns = new ArrayList<>();
            // Populate the results from all events that have rows
            for (QueryResponse event : events) {
                if (event.getRows() != null && !event.getRows().isEmpty()) {
                    rows.addAll(event.getRows());
                }
                if (columns.isEmpty() && event.getColumns() != null && !event.getColumns().isEmpty()) {
                    // Only need to do this once
                    columns = event.getColumns();
                }
            }
            // Populate the remainder from the final event
            QueryResponse lastEvent = events.get(events.size() - 1);
            requestId = lastEvent.getRequestId();
            errorName = lastEvent.getErrorName();
            errorMessage = lastEvent.getErrorMessage();
            errorCode = lastEvent.getErrorCode();
            queryId = lastEvent.getQueryId();
            details = lastEvent.getDetails();
        }
    }

    /**
     * All-args constructor needed by Jackson to deserialize individual events.
     * (Used by Jackson as part of the response deserialization process.)
     *
     * @param requestId see {@link #requestId}
     * @param errorName see {@link #errorName}
     * @param errorMessage see {@link #errorMessage}
     * @param errorCode see {@link #errorCode}
     * @param queryId see {@link #queryId}
     * @param rows see {@link #rows}
     * @param columns see {@link #columns}
     * @param details see {@link #details}
     */
    @JsonCreator
    public QueryResponse(@JsonProperty("requestId") String requestId, @JsonProperty("errorName") String errorName, @JsonProperty("errorMessage") String errorMessage, @JsonProperty("errorCode") String errorCode, @JsonProperty("queryId") String queryId, @JsonProperty("rows") List<List<String>> rows, @JsonProperty("columns") List<ColumnDetails> columns, @JsonProperty("details") QueryDetails details) {
        this.requestId = requestId;
        this.errorName = errorName;
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
        this.queryId = queryId;
        this.rows = rows;
        this.columns = columns;
        this.details = details;
    }

    /**
     * Unique identifier for the request, if there was any error.
     */
    String requestId;
    /**
     * Unique name for the error, if there was any error.
     */
    String errorName;
    /**
     * Explanation of the error, if there was any error.
     */
    String errorMessage;
    /**
     * Unique code for the error, if there was any error.
     */
    String errorCode;
    /**
     * Unique identifier (GUID) for the specific run of the query.
     */
    String queryId;
    /**
     * Results of the query. Each element is of the outer list is a single row,
     * while each inner list gives the column values for that row (in order).
     */
    List<List<String>> rows;
    /**
     * Columns that are present in each row of the results. The order of the elements
     * of this list will match the order of the inner list of values for the {@link #rows}.
     */
    List<ColumnDetails> columns;
    /**
     * Details about the query.
     */
    QueryDetails details;


    /**
     * Details about the columns that were returned from a query that was run.
     */
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = QueryResponse.ColumnDetails.ColumnDetailsBuilderImpl.class)
    public static final class ColumnDetails extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /**
         * Position of the column (1-based).
         */
        Integer ordinal;
        /**
         * TBC
         */
        Boolean autoIncrement;
        /**
         * TBC
         */
        Boolean caseSensitive;
        /**
         * TBC
         */
        Boolean searchable;
        /**
         * TBC
         */
        Boolean currency;
        /**
         * TBC
         */
        Integer nullable;
        /**
         * TBC
         */
        Boolean signed;
        /**
         * TBC
         */
        Integer displaySize;
        /**
         * Display value for the column's name.
         */
        String label;
        /**
         * Name of the column (technical).
         */
        String columnName;
        /**
         * Name of the schema in which this column's table is contained.
         */
        String schemaName;
        /**
         * TBC
         */
        Integer precision;
        /**
         * TBC
         */
        Integer scale;
        /**
         * Name of the table in which the column is contained.
         */
        String tableName;
        /**
         * Name of the database in which the table's schema is contained.
         */
        String catalogName;
        /**
         * TBC
         */
        Boolean readOnly;
        /**
         * TBC
         */
        Boolean writable;
        /**
         * TBC
         */
        Boolean definitelyWritable;
        /**
         * Canonical name of the Java class representing this column's values.
         */
        String columnClassName;
        /**
         * Details about the (SQL) data type of the column.
         */
        ColumnType type;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class ColumnDetailsBuilder<C extends QueryResponse.ColumnDetails, B extends QueryResponse.ColumnDetails.ColumnDetailsBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer ordinal;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean autoIncrement;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean caseSensitive;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean searchable;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean currency;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer nullable;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean signed;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer displaySize;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String label;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String columnName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String schemaName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer precision;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer scale;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String tableName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String catalogName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean readOnly;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean writable;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean definitelyWritable;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String columnClassName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private ColumnType type;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                QueryResponse.ColumnDetails.ColumnDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final QueryResponse.ColumnDetails instance, final QueryResponse.ColumnDetails.ColumnDetailsBuilder<?, ?> b) {
                b.ordinal(instance.ordinal);
                b.autoIncrement(instance.autoIncrement);
                b.caseSensitive(instance.caseSensitive);
                b.searchable(instance.searchable);
                b.currency(instance.currency);
                b.nullable(instance.nullable);
                b.signed(instance.signed);
                b.displaySize(instance.displaySize);
                b.label(instance.label);
                b.columnName(instance.columnName);
                b.schemaName(instance.schemaName);
                b.precision(instance.precision);
                b.scale(instance.scale);
                b.tableName(instance.tableName);
                b.catalogName(instance.catalogName);
                b.readOnly(instance.readOnly);
                b.writable(instance.writable);
                b.definitelyWritable(instance.definitelyWritable);
                b.columnClassName(instance.columnClassName);
                b.type(instance.type);
            }

            /**
             * Position of the column (1-based).
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B ordinal(final Integer ordinal) {
                this.ordinal = ordinal;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B autoIncrement(final Boolean autoIncrement) {
                this.autoIncrement = autoIncrement;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B caseSensitive(final Boolean caseSensitive) {
                this.caseSensitive = caseSensitive;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B searchable(final Boolean searchable) {
                this.searchable = searchable;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B currency(final Boolean currency) {
                this.currency = currency;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B nullable(final Integer nullable) {
                this.nullable = nullable;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B signed(final Boolean signed) {
                this.signed = signed;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B displaySize(final Integer displaySize) {
                this.displaySize = displaySize;
                return self();
            }

            /**
             * Display value for the column's name.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B label(final String label) {
                this.label = label;
                return self();
            }

            /**
             * Name of the column (technical).
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B columnName(final String columnName) {
                this.columnName = columnName;
                return self();
            }

            /**
             * Name of the schema in which this column's table is contained.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B schemaName(final String schemaName) {
                this.schemaName = schemaName;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B precision(final Integer precision) {
                this.precision = precision;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B scale(final Integer scale) {
                this.scale = scale;
                return self();
            }

            /**
             * Name of the table in which the column is contained.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B tableName(final String tableName) {
                this.tableName = tableName;
                return self();
            }

            /**
             * Name of the database in which the table's schema is contained.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B catalogName(final String catalogName) {
                this.catalogName = catalogName;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B readOnly(final Boolean readOnly) {
                this.readOnly = readOnly;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B writable(final Boolean writable) {
                this.writable = writable;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B definitelyWritable(final Boolean definitelyWritable) {
                this.definitelyWritable = definitelyWritable;
                return self();
            }

            /**
             * Canonical name of the Java class representing this column's values.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B columnClassName(final String columnClassName) {
                this.columnClassName = columnClassName;
                return self();
            }

            /**
             * Details about the (SQL) data type of the column.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B type(final ColumnType type) {
                this.type = type;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "QueryResponse.ColumnDetails.ColumnDetailsBuilder(super=" + super.toString() + ", ordinal=" + this.ordinal + ", autoIncrement=" + this.autoIncrement + ", caseSensitive=" + this.caseSensitive + ", searchable=" + this.searchable + ", currency=" + this.currency + ", nullable=" + this.nullable + ", signed=" + this.signed + ", displaySize=" + this.displaySize + ", label=" + this.label + ", columnName=" + this.columnName + ", schemaName=" + this.schemaName + ", precision=" + this.precision + ", scale=" + this.scale + ", tableName=" + this.tableName + ", catalogName=" + this.catalogName + ", readOnly=" + this.readOnly + ", writable=" + this.writable + ", definitelyWritable=" + this.definitelyWritable + ", columnClassName=" + this.columnClassName + ", type=" + this.type + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class ColumnDetailsBuilderImpl extends QueryResponse.ColumnDetails.ColumnDetailsBuilder<QueryResponse.ColumnDetails, QueryResponse.ColumnDetails.ColumnDetailsBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private ColumnDetailsBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected QueryResponse.ColumnDetails.ColumnDetailsBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public QueryResponse.ColumnDetails build() {
                return new QueryResponse.ColumnDetails(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected ColumnDetails(final QueryResponse.ColumnDetails.ColumnDetailsBuilder<?, ?> b) {
            super(b);
            this.ordinal = b.ordinal;
            this.autoIncrement = b.autoIncrement;
            this.caseSensitive = b.caseSensitive;
            this.searchable = b.searchable;
            this.currency = b.currency;
            this.nullable = b.nullable;
            this.signed = b.signed;
            this.displaySize = b.displaySize;
            this.label = b.label;
            this.columnName = b.columnName;
            this.schemaName = b.schemaName;
            this.precision = b.precision;
            this.scale = b.scale;
            this.tableName = b.tableName;
            this.catalogName = b.catalogName;
            this.readOnly = b.readOnly;
            this.writable = b.writable;
            this.definitelyWritable = b.definitelyWritable;
            this.columnClassName = b.columnClassName;
            this.type = b.type;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static QueryResponse.ColumnDetails.ColumnDetailsBuilder<?, ?> builder() {
            return new QueryResponse.ColumnDetails.ColumnDetailsBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public QueryResponse.ColumnDetails.ColumnDetailsBuilder<?, ?> toBuilder() {
            return new QueryResponse.ColumnDetails.ColumnDetailsBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Position of the column (1-based).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getOrdinal() {
            return this.ordinal;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getAutoIncrement() {
            return this.autoIncrement;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getCaseSensitive() {
            return this.caseSensitive;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getSearchable() {
            return this.searchable;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getCurrency() {
            return this.currency;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getNullable() {
            return this.nullable;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getSigned() {
            return this.signed;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getDisplaySize() {
            return this.displaySize;
        }

        /**
         * Display value for the column's name.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getLabel() {
            return this.label;
        }

        /**
         * Name of the column (technical).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getColumnName() {
            return this.columnName;
        }

        /**
         * Name of the schema in which this column's table is contained.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getSchemaName() {
            return this.schemaName;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getPrecision() {
            return this.precision;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getScale() {
            return this.scale;
        }

        /**
         * Name of the table in which the column is contained.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getTableName() {
            return this.tableName;
        }

        /**
         * Name of the database in which the table's schema is contained.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCatalogName() {
            return this.catalogName;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getReadOnly() {
            return this.readOnly;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getWritable() {
            return this.writable;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getDefinitelyWritable() {
            return this.definitelyWritable;
        }

        /**
         * Canonical name of the Java class representing this column's values.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getColumnClassName() {
            return this.columnClassName;
        }

        /**
         * Details about the (SQL) data type of the column.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ColumnType getType() {
            return this.type;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof QueryResponse.ColumnDetails)) return false;
            final QueryResponse.ColumnDetails other = (QueryResponse.ColumnDetails) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$ordinal = this.getOrdinal();
            final java.lang.Object other$ordinal = other.getOrdinal();
            if (this$ordinal == null ? other$ordinal != null : !this$ordinal.equals(other$ordinal)) return false;
            final java.lang.Object this$autoIncrement = this.getAutoIncrement();
            final java.lang.Object other$autoIncrement = other.getAutoIncrement();
            if (this$autoIncrement == null ? other$autoIncrement != null : !this$autoIncrement.equals(other$autoIncrement)) return false;
            final java.lang.Object this$caseSensitive = this.getCaseSensitive();
            final java.lang.Object other$caseSensitive = other.getCaseSensitive();
            if (this$caseSensitive == null ? other$caseSensitive != null : !this$caseSensitive.equals(other$caseSensitive)) return false;
            final java.lang.Object this$searchable = this.getSearchable();
            final java.lang.Object other$searchable = other.getSearchable();
            if (this$searchable == null ? other$searchable != null : !this$searchable.equals(other$searchable)) return false;
            final java.lang.Object this$currency = this.getCurrency();
            final java.lang.Object other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
            final java.lang.Object this$nullable = this.getNullable();
            final java.lang.Object other$nullable = other.getNullable();
            if (this$nullable == null ? other$nullable != null : !this$nullable.equals(other$nullable)) return false;
            final java.lang.Object this$signed = this.getSigned();
            final java.lang.Object other$signed = other.getSigned();
            if (this$signed == null ? other$signed != null : !this$signed.equals(other$signed)) return false;
            final java.lang.Object this$displaySize = this.getDisplaySize();
            final java.lang.Object other$displaySize = other.getDisplaySize();
            if (this$displaySize == null ? other$displaySize != null : !this$displaySize.equals(other$displaySize)) return false;
            final java.lang.Object this$precision = this.getPrecision();
            final java.lang.Object other$precision = other.getPrecision();
            if (this$precision == null ? other$precision != null : !this$precision.equals(other$precision)) return false;
            final java.lang.Object this$scale = this.getScale();
            final java.lang.Object other$scale = other.getScale();
            if (this$scale == null ? other$scale != null : !this$scale.equals(other$scale)) return false;
            final java.lang.Object this$readOnly = this.getReadOnly();
            final java.lang.Object other$readOnly = other.getReadOnly();
            if (this$readOnly == null ? other$readOnly != null : !this$readOnly.equals(other$readOnly)) return false;
            final java.lang.Object this$writable = this.getWritable();
            final java.lang.Object other$writable = other.getWritable();
            if (this$writable == null ? other$writable != null : !this$writable.equals(other$writable)) return false;
            final java.lang.Object this$definitelyWritable = this.getDefinitelyWritable();
            final java.lang.Object other$definitelyWritable = other.getDefinitelyWritable();
            if (this$definitelyWritable == null ? other$definitelyWritable != null : !this$definitelyWritable.equals(other$definitelyWritable)) return false;
            final java.lang.Object this$label = this.getLabel();
            final java.lang.Object other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
            final java.lang.Object this$columnName = this.getColumnName();
            final java.lang.Object other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) return false;
            final java.lang.Object this$schemaName = this.getSchemaName();
            final java.lang.Object other$schemaName = other.getSchemaName();
            if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) return false;
            final java.lang.Object this$tableName = this.getTableName();
            final java.lang.Object other$tableName = other.getTableName();
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) return false;
            final java.lang.Object this$catalogName = this.getCatalogName();
            final java.lang.Object other$catalogName = other.getCatalogName();
            if (this$catalogName == null ? other$catalogName != null : !this$catalogName.equals(other$catalogName)) return false;
            final java.lang.Object this$columnClassName = this.getColumnClassName();
            final java.lang.Object other$columnClassName = other.getColumnClassName();
            if (this$columnClassName == null ? other$columnClassName != null : !this$columnClassName.equals(other$columnClassName)) return false;
            final java.lang.Object this$type = this.getType();
            final java.lang.Object other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof QueryResponse.ColumnDetails;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $ordinal = this.getOrdinal();
            result = result * PRIME + ($ordinal == null ? 43 : $ordinal.hashCode());
            final java.lang.Object $autoIncrement = this.getAutoIncrement();
            result = result * PRIME + ($autoIncrement == null ? 43 : $autoIncrement.hashCode());
            final java.lang.Object $caseSensitive = this.getCaseSensitive();
            result = result * PRIME + ($caseSensitive == null ? 43 : $caseSensitive.hashCode());
            final java.lang.Object $searchable = this.getSearchable();
            result = result * PRIME + ($searchable == null ? 43 : $searchable.hashCode());
            final java.lang.Object $currency = this.getCurrency();
            result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
            final java.lang.Object $nullable = this.getNullable();
            result = result * PRIME + ($nullable == null ? 43 : $nullable.hashCode());
            final java.lang.Object $signed = this.getSigned();
            result = result * PRIME + ($signed == null ? 43 : $signed.hashCode());
            final java.lang.Object $displaySize = this.getDisplaySize();
            result = result * PRIME + ($displaySize == null ? 43 : $displaySize.hashCode());
            final java.lang.Object $precision = this.getPrecision();
            result = result * PRIME + ($precision == null ? 43 : $precision.hashCode());
            final java.lang.Object $scale = this.getScale();
            result = result * PRIME + ($scale == null ? 43 : $scale.hashCode());
            final java.lang.Object $readOnly = this.getReadOnly();
            result = result * PRIME + ($readOnly == null ? 43 : $readOnly.hashCode());
            final java.lang.Object $writable = this.getWritable();
            result = result * PRIME + ($writable == null ? 43 : $writable.hashCode());
            final java.lang.Object $definitelyWritable = this.getDefinitelyWritable();
            result = result * PRIME + ($definitelyWritable == null ? 43 : $definitelyWritable.hashCode());
            final java.lang.Object $label = this.getLabel();
            result = result * PRIME + ($label == null ? 43 : $label.hashCode());
            final java.lang.Object $columnName = this.getColumnName();
            result = result * PRIME + ($columnName == null ? 43 : $columnName.hashCode());
            final java.lang.Object $schemaName = this.getSchemaName();
            result = result * PRIME + ($schemaName == null ? 43 : $schemaName.hashCode());
            final java.lang.Object $tableName = this.getTableName();
            result = result * PRIME + ($tableName == null ? 43 : $tableName.hashCode());
            final java.lang.Object $catalogName = this.getCatalogName();
            result = result * PRIME + ($catalogName == null ? 43 : $catalogName.hashCode());
            final java.lang.Object $columnClassName = this.getColumnClassName();
            result = result * PRIME + ($columnClassName == null ? 43 : $columnClassName.hashCode());
            final java.lang.Object $type = this.getType();
            result = result * PRIME + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "QueryResponse.ColumnDetails(super=" + super.toString() + ", ordinal=" + this.getOrdinal() + ", autoIncrement=" + this.getAutoIncrement() + ", caseSensitive=" + this.getCaseSensitive() + ", searchable=" + this.getSearchable() + ", currency=" + this.getCurrency() + ", nullable=" + this.getNullable() + ", signed=" + this.getSigned() + ", displaySize=" + this.getDisplaySize() + ", label=" + this.getLabel() + ", columnName=" + this.getColumnName() + ", schemaName=" + this.getSchemaName() + ", precision=" + this.getPrecision() + ", scale=" + this.getScale() + ", tableName=" + this.getTableName() + ", catalogName=" + this.getCatalogName() + ", readOnly=" + this.getReadOnly() + ", writable=" + this.getWritable() + ", definitelyWritable=" + this.getDefinitelyWritable() + ", columnClassName=" + this.getColumnClassName() + ", type=" + this.getType() + ")";
        }
    }


    /**
     * Details about the type of column that was returned from a query that was run.
     */
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = QueryResponse.ColumnType.ColumnTypeBuilderImpl.class)
    public static final class ColumnType extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /**
         * Numeric identifier for this column, generally matches the ordinal of the column.
         */
        Integer id;
        /**
         * SQL name of the data type for this column.
         */
        String name;
        /**
         * TBC
         */
        String rep;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class ColumnTypeBuilder<C extends QueryResponse.ColumnType, B extends QueryResponse.ColumnType.ColumnTypeBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer id;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String name;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String rep;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                QueryResponse.ColumnType.ColumnTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final QueryResponse.ColumnType instance, final QueryResponse.ColumnType.ColumnTypeBuilder<?, ?> b) {
                b.id(instance.id);
                b.name(instance.name);
                b.rep(instance.rep);
            }

            /**
             * Numeric identifier for this column, generally matches the ordinal of the column.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B id(final Integer id) {
                this.id = id;
                return self();
            }

            /**
             * SQL name of the data type for this column.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B name(final String name) {
                this.name = name;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B rep(final String rep) {
                this.rep = rep;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "QueryResponse.ColumnType.ColumnTypeBuilder(super=" + super.toString() + ", id=" + this.id + ", name=" + this.name + ", rep=" + this.rep + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class ColumnTypeBuilderImpl extends QueryResponse.ColumnType.ColumnTypeBuilder<QueryResponse.ColumnType, QueryResponse.ColumnType.ColumnTypeBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private ColumnTypeBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected QueryResponse.ColumnType.ColumnTypeBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public QueryResponse.ColumnType build() {
                return new QueryResponse.ColumnType(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected ColumnType(final QueryResponse.ColumnType.ColumnTypeBuilder<?, ?> b) {
            super(b);
            this.id = b.id;
            this.name = b.name;
            this.rep = b.rep;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static QueryResponse.ColumnType.ColumnTypeBuilder<?, ?> builder() {
            return new QueryResponse.ColumnType.ColumnTypeBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public QueryResponse.ColumnType.ColumnTypeBuilder<?, ?> toBuilder() {
            return new QueryResponse.ColumnType.ColumnTypeBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Numeric identifier for this column, generally matches the ordinal of the column.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getId() {
            return this.id;
        }

        /**
         * SQL name of the data type for this column.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
            return this.name;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getRep() {
            return this.rep;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof QueryResponse.ColumnType)) return false;
            final QueryResponse.ColumnType other = (QueryResponse.ColumnType) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            final java.lang.Object this$rep = this.getRep();
            final java.lang.Object other$rep = other.getRep();
            if (this$rep == null ? other$rep != null : !this$rep.equals(other$rep)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof QueryResponse.ColumnType;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $rep = this.getRep();
            result = result * PRIME + ($rep == null ? 43 : $rep.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "QueryResponse.ColumnType(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", rep=" + this.getRep() + ")";
        }
    }


    /**
     * Details about a query that was run.
     */
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = QueryResponse.QueryDetails.QueryDetailsBuilderImpl.class)
    public static final class QueryDetails extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /**
         * Total number of results returned by the query.
         */
        Long totalRowsStreamed;
        /**
         * Status of the query.
         */
        QueryStatus status;
        /**
         * TBC
         */
        String parsedQuery;
        /**
         * Query that was sent to the data store.
         */
        String pushdownQuery;
        /**
         * How long the query took to run, in milliseconds.
         */
        Long executionTime;
        /**
         * TBC
         */
        String sourceQueryId;
        /**
         * TBC
         */
        String resultOutputLocation;
        /**
         * List of any warnings produced when running the query.
         */
        List<String> warnings;
        /**
         * How the query was parsed prior to running.
         */
        ParsingFlow parsingFlow;
        /**
         * How the query was run.
         */
        HekaFlow hekaFlow;
        /**
         * TBC
         */
        String s3UploadPath;
        /**
         * TBC
         */
        @JsonProperty("source_first_connection_time")
        Integer sourceFirstConnectionTime;
        /**
         * TBC
         */
        @JsonProperty("source_first_connection_time_perc")
        Double sourceFirstConnectionPercentage;
        /**
         * TBC
         */
        @JsonProperty("explain_call_time_perc")
        Double explainCallTimePercentage;
        /**
         * TBC
         */
        @JsonProperty("init_data_source_time")
        Integer initDataSourceTime;
        /**
         * TBC
         */
        @JsonProperty("init_data_source_time_perc")
        Double initDataSourcePercentage;
        /**
         * TBC
         */
        @JsonProperty("authorization_time")
        Integer authorizationTime;
        /**
         * TBC
         */
        @JsonProperty("authorization_time_perc")
        Double authorizationPercentage;
        /**
         * TBC
         */
        @JsonProperty("rewrite_validation_time")
        Integer rewriteValidationTime;
        /**
         * TBC
         */
        @JsonProperty("rewrite_validation_time_perc")
        Double rewriteValidationPercentage;
        /**
         * Elapsed time to extract table metadata, in milliseconds.
         */
        @JsonProperty("extract_table_metadata_time")
        Integer extractTableMetadataTime;
        /**
         * TBC
         */
        @JsonProperty("extract_table_metadata_time_perc")
        Double extractTableMetadataPercentage;
        /**
         * Elapsed time to run the query (from internal engine), in milliseconds.
         */
        @JsonProperty("execution_time")
        Integer executionTimeInternal;
        /**
         * TBC
         */
        @JsonProperty("execution_time_perc")
        Double executionPercentage;
        /**
         * TBC
         */
        @JsonProperty("bypass_parsing_time")
        Integer bypassQueryTime;
        /**
         * TBC
         */
        @JsonProperty("bypass_parsing_time_perc")
        Double bypassParsingPercentage;
        /**
         * TBC
         */
        @JsonProperty("check_insights_enabled_time")
        Integer checkInsightsEnabledTime;
        /**
         * TBC
         */
        @JsonProperty("check_insights_enabled_time_perc")
        Double checkInsightsEnabledPercentage;
        /**
         * TBC
         */
        @JsonProperty("initialization_time")
        Integer initializationTime;
        /**
         * TBC
         */
        @JsonProperty("initialization_time_perc")
        Double initializationPercentage;
        /**
         * TBC
         */
        @JsonProperty("extract_credentials_time")
        Integer extractCredentialsTime;
        /**
         * TBC
         */
        @JsonProperty("extract_credentials_time_perc")
        Double extractCredentialsPercentage;
        /**
         * TBC
         */
        @JsonProperty("overall_time")
        Integer overallTime;
        /**
         * TBC
         */
        @JsonProperty("overall_time_perc")
        Double overallTimePercentage;
        /**
         * TBC
         */
        @JsonProperty("heka_atlan_time")
        Integer hekaAtlanTime;
        /**
         * TBC
         */
        @JsonProperty("calcite_parsing_time_perc")
        Double calciteParsingPercentage;
        /**
         * TBC
         */
        @JsonProperty("calcite_validation_time_perc")
        Double calciteValidationPercentage;
        /**
         * Metadata about the asset used in the query, in case of any errors.
         */
        AssetDetails asset;
        /**
         * Detailed back-end error message that could be helpful for developers.
         */
        String developerMessage;
        /**
         * Line number of the query that had a validation error, if any.
         */
        Long line;
        /**
         * Column position of the validation error, if any.
         */
        Long column;
        /**
         * Name of the object that caused the validation error, if any.
         */
        String object;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class QueryDetailsBuilder<C extends QueryResponse.QueryDetails, B extends QueryResponse.QueryDetails.QueryDetailsBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long totalRowsStreamed;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private QueryStatus status;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String parsedQuery;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String pushdownQuery;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long executionTime;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String sourceQueryId;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String resultOutputLocation;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private List<String> warnings;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private ParsingFlow parsingFlow;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private HekaFlow hekaFlow;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String s3UploadPath;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer sourceFirstConnectionTime;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double sourceFirstConnectionPercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double explainCallTimePercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer initDataSourceTime;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double initDataSourcePercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer authorizationTime;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double authorizationPercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer rewriteValidationTime;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double rewriteValidationPercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer extractTableMetadataTime;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double extractTableMetadataPercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer executionTimeInternal;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double executionPercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer bypassQueryTime;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double bypassParsingPercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer checkInsightsEnabledTime;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double checkInsightsEnabledPercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer initializationTime;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double initializationPercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer extractCredentialsTime;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double extractCredentialsPercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer overallTime;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double overallTimePercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer hekaAtlanTime;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double calciteParsingPercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double calciteValidationPercentage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private AssetDetails asset;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String developerMessage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long line;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long column;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String object;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                QueryResponse.QueryDetails.QueryDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final QueryResponse.QueryDetails instance, final QueryResponse.QueryDetails.QueryDetailsBuilder<?, ?> b) {
                b.totalRowsStreamed(instance.totalRowsStreamed);
                b.status(instance.status);
                b.parsedQuery(instance.parsedQuery);
                b.pushdownQuery(instance.pushdownQuery);
                b.executionTime(instance.executionTime);
                b.sourceQueryId(instance.sourceQueryId);
                b.resultOutputLocation(instance.resultOutputLocation);
                b.warnings(instance.warnings);
                b.parsingFlow(instance.parsingFlow);
                b.hekaFlow(instance.hekaFlow);
                b.s3UploadPath(instance.s3UploadPath);
                b.sourceFirstConnectionTime(instance.sourceFirstConnectionTime);
                b.sourceFirstConnectionPercentage(instance.sourceFirstConnectionPercentage);
                b.explainCallTimePercentage(instance.explainCallTimePercentage);
                b.initDataSourceTime(instance.initDataSourceTime);
                b.initDataSourcePercentage(instance.initDataSourcePercentage);
                b.authorizationTime(instance.authorizationTime);
                b.authorizationPercentage(instance.authorizationPercentage);
                b.rewriteValidationTime(instance.rewriteValidationTime);
                b.rewriteValidationPercentage(instance.rewriteValidationPercentage);
                b.extractTableMetadataTime(instance.extractTableMetadataTime);
                b.extractTableMetadataPercentage(instance.extractTableMetadataPercentage);
                b.executionTimeInternal(instance.executionTimeInternal);
                b.executionPercentage(instance.executionPercentage);
                b.bypassQueryTime(instance.bypassQueryTime);
                b.bypassParsingPercentage(instance.bypassParsingPercentage);
                b.checkInsightsEnabledTime(instance.checkInsightsEnabledTime);
                b.checkInsightsEnabledPercentage(instance.checkInsightsEnabledPercentage);
                b.initializationTime(instance.initializationTime);
                b.initializationPercentage(instance.initializationPercentage);
                b.extractCredentialsTime(instance.extractCredentialsTime);
                b.extractCredentialsPercentage(instance.extractCredentialsPercentage);
                b.overallTime(instance.overallTime);
                b.overallTimePercentage(instance.overallTimePercentage);
                b.hekaAtlanTime(instance.hekaAtlanTime);
                b.calciteParsingPercentage(instance.calciteParsingPercentage);
                b.calciteValidationPercentage(instance.calciteValidationPercentage);
                b.asset(instance.asset);
                b.developerMessage(instance.developerMessage);
                b.line(instance.line);
                b.column(instance.column);
                b.object(instance.object);
            }

            /**
             * Total number of results returned by the query.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B totalRowsStreamed(final Long totalRowsStreamed) {
                this.totalRowsStreamed = totalRowsStreamed;
                return self();
            }

            /**
             * Status of the query.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B status(final QueryStatus status) {
                this.status = status;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B parsedQuery(final String parsedQuery) {
                this.parsedQuery = parsedQuery;
                return self();
            }

            /**
             * Query that was sent to the data store.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B pushdownQuery(final String pushdownQuery) {
                this.pushdownQuery = pushdownQuery;
                return self();
            }

            /**
             * How long the query took to run, in milliseconds.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B executionTime(final Long executionTime) {
                this.executionTime = executionTime;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B sourceQueryId(final String sourceQueryId) {
                this.sourceQueryId = sourceQueryId;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B resultOutputLocation(final String resultOutputLocation) {
                this.resultOutputLocation = resultOutputLocation;
                return self();
            }

            /**
             * List of any warnings produced when running the query.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B warnings(final List<String> warnings) {
                this.warnings = warnings;
                return self();
            }

            /**
             * How the query was parsed prior to running.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B parsingFlow(final ParsingFlow parsingFlow) {
                this.parsingFlow = parsingFlow;
                return self();
            }

            /**
             * How the query was run.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B hekaFlow(final HekaFlow hekaFlow) {
                this.hekaFlow = hekaFlow;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B s3UploadPath(final String s3UploadPath) {
                this.s3UploadPath = s3UploadPath;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("source_first_connection_time")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B sourceFirstConnectionTime(final Integer sourceFirstConnectionTime) {
                this.sourceFirstConnectionTime = sourceFirstConnectionTime;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("source_first_connection_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B sourceFirstConnectionPercentage(final Double sourceFirstConnectionPercentage) {
                this.sourceFirstConnectionPercentage = sourceFirstConnectionPercentage;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("explain_call_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B explainCallTimePercentage(final Double explainCallTimePercentage) {
                this.explainCallTimePercentage = explainCallTimePercentage;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("init_data_source_time")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B initDataSourceTime(final Integer initDataSourceTime) {
                this.initDataSourceTime = initDataSourceTime;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("init_data_source_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B initDataSourcePercentage(final Double initDataSourcePercentage) {
                this.initDataSourcePercentage = initDataSourcePercentage;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("authorization_time")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B authorizationTime(final Integer authorizationTime) {
                this.authorizationTime = authorizationTime;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("authorization_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B authorizationPercentage(final Double authorizationPercentage) {
                this.authorizationPercentage = authorizationPercentage;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("rewrite_validation_time")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B rewriteValidationTime(final Integer rewriteValidationTime) {
                this.rewriteValidationTime = rewriteValidationTime;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("rewrite_validation_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B rewriteValidationPercentage(final Double rewriteValidationPercentage) {
                this.rewriteValidationPercentage = rewriteValidationPercentage;
                return self();
            }

            /**
             * Elapsed time to extract table metadata, in milliseconds.
             * @return {@code this}.
             */
            @JsonProperty("extract_table_metadata_time")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B extractTableMetadataTime(final Integer extractTableMetadataTime) {
                this.extractTableMetadataTime = extractTableMetadataTime;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("extract_table_metadata_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B extractTableMetadataPercentage(final Double extractTableMetadataPercentage) {
                this.extractTableMetadataPercentage = extractTableMetadataPercentage;
                return self();
            }

            /**
             * Elapsed time to run the query (from internal engine), in milliseconds.
             * @return {@code this}.
             */
            @JsonProperty("execution_time")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B executionTimeInternal(final Integer executionTimeInternal) {
                this.executionTimeInternal = executionTimeInternal;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("execution_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B executionPercentage(final Double executionPercentage) {
                this.executionPercentage = executionPercentage;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("bypass_parsing_time")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B bypassQueryTime(final Integer bypassQueryTime) {
                this.bypassQueryTime = bypassQueryTime;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("bypass_parsing_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B bypassParsingPercentage(final Double bypassParsingPercentage) {
                this.bypassParsingPercentage = bypassParsingPercentage;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("check_insights_enabled_time")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B checkInsightsEnabledTime(final Integer checkInsightsEnabledTime) {
                this.checkInsightsEnabledTime = checkInsightsEnabledTime;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("check_insights_enabled_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B checkInsightsEnabledPercentage(final Double checkInsightsEnabledPercentage) {
                this.checkInsightsEnabledPercentage = checkInsightsEnabledPercentage;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("initialization_time")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B initializationTime(final Integer initializationTime) {
                this.initializationTime = initializationTime;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("initialization_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B initializationPercentage(final Double initializationPercentage) {
                this.initializationPercentage = initializationPercentage;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("extract_credentials_time")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B extractCredentialsTime(final Integer extractCredentialsTime) {
                this.extractCredentialsTime = extractCredentialsTime;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("extract_credentials_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B extractCredentialsPercentage(final Double extractCredentialsPercentage) {
                this.extractCredentialsPercentage = extractCredentialsPercentage;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("overall_time")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B overallTime(final Integer overallTime) {
                this.overallTime = overallTime;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("overall_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B overallTimePercentage(final Double overallTimePercentage) {
                this.overallTimePercentage = overallTimePercentage;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("heka_atlan_time")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B hekaAtlanTime(final Integer hekaAtlanTime) {
                this.hekaAtlanTime = hekaAtlanTime;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("calcite_parsing_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B calciteParsingPercentage(final Double calciteParsingPercentage) {
                this.calciteParsingPercentage = calciteParsingPercentage;
                return self();
            }

            /**
             * TBC
             * @return {@code this}.
             */
            @JsonProperty("calcite_validation_time_perc")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B calciteValidationPercentage(final Double calciteValidationPercentage) {
                this.calciteValidationPercentage = calciteValidationPercentage;
                return self();
            }

            /**
             * Metadata about the asset used in the query, in case of any errors.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B asset(final AssetDetails asset) {
                this.asset = asset;
                return self();
            }

            /**
             * Detailed back-end error message that could be helpful for developers.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B developerMessage(final String developerMessage) {
                this.developerMessage = developerMessage;
                return self();
            }

            /**
             * Line number of the query that had a validation error, if any.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B line(final Long line) {
                this.line = line;
                return self();
            }

            /**
             * Column position of the validation error, if any.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B column(final Long column) {
                this.column = column;
                return self();
            }

            /**
             * Name of the object that caused the validation error, if any.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B object(final String object) {
                this.object = object;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "QueryResponse.QueryDetails.QueryDetailsBuilder(super=" + super.toString() + ", totalRowsStreamed=" + this.totalRowsStreamed + ", status=" + this.status + ", parsedQuery=" + this.parsedQuery + ", pushdownQuery=" + this.pushdownQuery + ", executionTime=" + this.executionTime + ", sourceQueryId=" + this.sourceQueryId + ", resultOutputLocation=" + this.resultOutputLocation + ", warnings=" + this.warnings + ", parsingFlow=" + this.parsingFlow + ", hekaFlow=" + this.hekaFlow + ", s3UploadPath=" + this.s3UploadPath + ", sourceFirstConnectionTime=" + this.sourceFirstConnectionTime + ", sourceFirstConnectionPercentage=" + this.sourceFirstConnectionPercentage + ", explainCallTimePercentage=" + this.explainCallTimePercentage + ", initDataSourceTime=" + this.initDataSourceTime + ", initDataSourcePercentage=" + this.initDataSourcePercentage + ", authorizationTime=" + this.authorizationTime + ", authorizationPercentage=" + this.authorizationPercentage + ", rewriteValidationTime=" + this.rewriteValidationTime + ", rewriteValidationPercentage=" + this.rewriteValidationPercentage + ", extractTableMetadataTime=" + this.extractTableMetadataTime + ", extractTableMetadataPercentage=" + this.extractTableMetadataPercentage + ", executionTimeInternal=" + this.executionTimeInternal + ", executionPercentage=" + this.executionPercentage + ", bypassQueryTime=" + this.bypassQueryTime + ", bypassParsingPercentage=" + this.bypassParsingPercentage + ", checkInsightsEnabledTime=" + this.checkInsightsEnabledTime + ", checkInsightsEnabledPercentage=" + this.checkInsightsEnabledPercentage + ", initializationTime=" + this.initializationTime + ", initializationPercentage=" + this.initializationPercentage + ", extractCredentialsTime=" + this.extractCredentialsTime + ", extractCredentialsPercentage=" + this.extractCredentialsPercentage + ", overallTime=" + this.overallTime + ", overallTimePercentage=" + this.overallTimePercentage + ", hekaAtlanTime=" + this.hekaAtlanTime + ", calciteParsingPercentage=" + this.calciteParsingPercentage + ", calciteValidationPercentage=" + this.calciteValidationPercentage + ", asset=" + this.asset + ", developerMessage=" + this.developerMessage + ", line=" + this.line + ", column=" + this.column + ", object=" + this.object + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class QueryDetailsBuilderImpl extends QueryResponse.QueryDetails.QueryDetailsBuilder<QueryResponse.QueryDetails, QueryResponse.QueryDetails.QueryDetailsBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private QueryDetailsBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected QueryResponse.QueryDetails.QueryDetailsBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public QueryResponse.QueryDetails build() {
                return new QueryResponse.QueryDetails(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected QueryDetails(final QueryResponse.QueryDetails.QueryDetailsBuilder<?, ?> b) {
            super(b);
            this.totalRowsStreamed = b.totalRowsStreamed;
            this.status = b.status;
            this.parsedQuery = b.parsedQuery;
            this.pushdownQuery = b.pushdownQuery;
            this.executionTime = b.executionTime;
            this.sourceQueryId = b.sourceQueryId;
            this.resultOutputLocation = b.resultOutputLocation;
            this.warnings = b.warnings;
            this.parsingFlow = b.parsingFlow;
            this.hekaFlow = b.hekaFlow;
            this.s3UploadPath = b.s3UploadPath;
            this.sourceFirstConnectionTime = b.sourceFirstConnectionTime;
            this.sourceFirstConnectionPercentage = b.sourceFirstConnectionPercentage;
            this.explainCallTimePercentage = b.explainCallTimePercentage;
            this.initDataSourceTime = b.initDataSourceTime;
            this.initDataSourcePercentage = b.initDataSourcePercentage;
            this.authorizationTime = b.authorizationTime;
            this.authorizationPercentage = b.authorizationPercentage;
            this.rewriteValidationTime = b.rewriteValidationTime;
            this.rewriteValidationPercentage = b.rewriteValidationPercentage;
            this.extractTableMetadataTime = b.extractTableMetadataTime;
            this.extractTableMetadataPercentage = b.extractTableMetadataPercentage;
            this.executionTimeInternal = b.executionTimeInternal;
            this.executionPercentage = b.executionPercentage;
            this.bypassQueryTime = b.bypassQueryTime;
            this.bypassParsingPercentage = b.bypassParsingPercentage;
            this.checkInsightsEnabledTime = b.checkInsightsEnabledTime;
            this.checkInsightsEnabledPercentage = b.checkInsightsEnabledPercentage;
            this.initializationTime = b.initializationTime;
            this.initializationPercentage = b.initializationPercentage;
            this.extractCredentialsTime = b.extractCredentialsTime;
            this.extractCredentialsPercentage = b.extractCredentialsPercentage;
            this.overallTime = b.overallTime;
            this.overallTimePercentage = b.overallTimePercentage;
            this.hekaAtlanTime = b.hekaAtlanTime;
            this.calciteParsingPercentage = b.calciteParsingPercentage;
            this.calciteValidationPercentage = b.calciteValidationPercentage;
            this.asset = b.asset;
            this.developerMessage = b.developerMessage;
            this.line = b.line;
            this.column = b.column;
            this.object = b.object;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static QueryResponse.QueryDetails.QueryDetailsBuilder<?, ?> builder() {
            return new QueryResponse.QueryDetails.QueryDetailsBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public QueryResponse.QueryDetails.QueryDetailsBuilder<?, ?> toBuilder() {
            return new QueryResponse.QueryDetails.QueryDetailsBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Total number of results returned by the query.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getTotalRowsStreamed() {
            return this.totalRowsStreamed;
        }

        /**
         * Status of the query.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public QueryStatus getStatus() {
            return this.status;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getParsedQuery() {
            return this.parsedQuery;
        }

        /**
         * Query that was sent to the data store.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getPushdownQuery() {
            return this.pushdownQuery;
        }

        /**
         * How long the query took to run, in milliseconds.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getExecutionTime() {
            return this.executionTime;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getSourceQueryId() {
            return this.sourceQueryId;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getResultOutputLocation() {
            return this.resultOutputLocation;
        }

        /**
         * List of any warnings produced when running the query.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getWarnings() {
            return this.warnings;
        }

        /**
         * How the query was parsed prior to running.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ParsingFlow getParsingFlow() {
            return this.parsingFlow;
        }

        /**
         * How the query was run.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public HekaFlow getHekaFlow() {
            return this.hekaFlow;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getS3UploadPath() {
            return this.s3UploadPath;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getSourceFirstConnectionTime() {
            return this.sourceFirstConnectionTime;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getSourceFirstConnectionPercentage() {
            return this.sourceFirstConnectionPercentage;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getExplainCallTimePercentage() {
            return this.explainCallTimePercentage;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getInitDataSourceTime() {
            return this.initDataSourceTime;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getInitDataSourcePercentage() {
            return this.initDataSourcePercentage;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getAuthorizationTime() {
            return this.authorizationTime;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getAuthorizationPercentage() {
            return this.authorizationPercentage;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getRewriteValidationTime() {
            return this.rewriteValidationTime;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getRewriteValidationPercentage() {
            return this.rewriteValidationPercentage;
        }

        /**
         * Elapsed time to extract table metadata, in milliseconds.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getExtractTableMetadataTime() {
            return this.extractTableMetadataTime;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getExtractTableMetadataPercentage() {
            return this.extractTableMetadataPercentage;
        }

        /**
         * Elapsed time to run the query (from internal engine), in milliseconds.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getExecutionTimeInternal() {
            return this.executionTimeInternal;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getExecutionPercentage() {
            return this.executionPercentage;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getBypassQueryTime() {
            return this.bypassQueryTime;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getBypassParsingPercentage() {
            return this.bypassParsingPercentage;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getCheckInsightsEnabledTime() {
            return this.checkInsightsEnabledTime;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getCheckInsightsEnabledPercentage() {
            return this.checkInsightsEnabledPercentage;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getInitializationTime() {
            return this.initializationTime;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getInitializationPercentage() {
            return this.initializationPercentage;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getExtractCredentialsTime() {
            return this.extractCredentialsTime;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getExtractCredentialsPercentage() {
            return this.extractCredentialsPercentage;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getOverallTime() {
            return this.overallTime;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getOverallTimePercentage() {
            return this.overallTimePercentage;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getHekaAtlanTime() {
            return this.hekaAtlanTime;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getCalciteParsingPercentage() {
            return this.calciteParsingPercentage;
        }

        /**
         * TBC
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getCalciteValidationPercentage() {
            return this.calciteValidationPercentage;
        }

        /**
         * Metadata about the asset used in the query, in case of any errors.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AssetDetails getAsset() {
            return this.asset;
        }

        /**
         * Detailed back-end error message that could be helpful for developers.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDeveloperMessage() {
            return this.developerMessage;
        }

        /**
         * Line number of the query that had a validation error, if any.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getLine() {
            return this.line;
        }

        /**
         * Column position of the validation error, if any.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getColumn() {
            return this.column;
        }

        /**
         * Name of the object that caused the validation error, if any.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getObject() {
            return this.object;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof QueryResponse.QueryDetails)) return false;
            final QueryResponse.QueryDetails other = (QueryResponse.QueryDetails) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$totalRowsStreamed = this.getTotalRowsStreamed();
            final java.lang.Object other$totalRowsStreamed = other.getTotalRowsStreamed();
            if (this$totalRowsStreamed == null ? other$totalRowsStreamed != null : !this$totalRowsStreamed.equals(other$totalRowsStreamed)) return false;
            final java.lang.Object this$executionTime = this.getExecutionTime();
            final java.lang.Object other$executionTime = other.getExecutionTime();
            if (this$executionTime == null ? other$executionTime != null : !this$executionTime.equals(other$executionTime)) return false;
            final java.lang.Object this$sourceFirstConnectionTime = this.getSourceFirstConnectionTime();
            final java.lang.Object other$sourceFirstConnectionTime = other.getSourceFirstConnectionTime();
            if (this$sourceFirstConnectionTime == null ? other$sourceFirstConnectionTime != null : !this$sourceFirstConnectionTime.equals(other$sourceFirstConnectionTime)) return false;
            final java.lang.Object this$sourceFirstConnectionPercentage = this.getSourceFirstConnectionPercentage();
            final java.lang.Object other$sourceFirstConnectionPercentage = other.getSourceFirstConnectionPercentage();
            if (this$sourceFirstConnectionPercentage == null ? other$sourceFirstConnectionPercentage != null : !this$sourceFirstConnectionPercentage.equals(other$sourceFirstConnectionPercentage)) return false;
            final java.lang.Object this$explainCallTimePercentage = this.getExplainCallTimePercentage();
            final java.lang.Object other$explainCallTimePercentage = other.getExplainCallTimePercentage();
            if (this$explainCallTimePercentage == null ? other$explainCallTimePercentage != null : !this$explainCallTimePercentage.equals(other$explainCallTimePercentage)) return false;
            final java.lang.Object this$initDataSourceTime = this.getInitDataSourceTime();
            final java.lang.Object other$initDataSourceTime = other.getInitDataSourceTime();
            if (this$initDataSourceTime == null ? other$initDataSourceTime != null : !this$initDataSourceTime.equals(other$initDataSourceTime)) return false;
            final java.lang.Object this$initDataSourcePercentage = this.getInitDataSourcePercentage();
            final java.lang.Object other$initDataSourcePercentage = other.getInitDataSourcePercentage();
            if (this$initDataSourcePercentage == null ? other$initDataSourcePercentage != null : !this$initDataSourcePercentage.equals(other$initDataSourcePercentage)) return false;
            final java.lang.Object this$authorizationTime = this.getAuthorizationTime();
            final java.lang.Object other$authorizationTime = other.getAuthorizationTime();
            if (this$authorizationTime == null ? other$authorizationTime != null : !this$authorizationTime.equals(other$authorizationTime)) return false;
            final java.lang.Object this$authorizationPercentage = this.getAuthorizationPercentage();
            final java.lang.Object other$authorizationPercentage = other.getAuthorizationPercentage();
            if (this$authorizationPercentage == null ? other$authorizationPercentage != null : !this$authorizationPercentage.equals(other$authorizationPercentage)) return false;
            final java.lang.Object this$rewriteValidationTime = this.getRewriteValidationTime();
            final java.lang.Object other$rewriteValidationTime = other.getRewriteValidationTime();
            if (this$rewriteValidationTime == null ? other$rewriteValidationTime != null : !this$rewriteValidationTime.equals(other$rewriteValidationTime)) return false;
            final java.lang.Object this$rewriteValidationPercentage = this.getRewriteValidationPercentage();
            final java.lang.Object other$rewriteValidationPercentage = other.getRewriteValidationPercentage();
            if (this$rewriteValidationPercentage == null ? other$rewriteValidationPercentage != null : !this$rewriteValidationPercentage.equals(other$rewriteValidationPercentage)) return false;
            final java.lang.Object this$extractTableMetadataTime = this.getExtractTableMetadataTime();
            final java.lang.Object other$extractTableMetadataTime = other.getExtractTableMetadataTime();
            if (this$extractTableMetadataTime == null ? other$extractTableMetadataTime != null : !this$extractTableMetadataTime.equals(other$extractTableMetadataTime)) return false;
            final java.lang.Object this$extractTableMetadataPercentage = this.getExtractTableMetadataPercentage();
            final java.lang.Object other$extractTableMetadataPercentage = other.getExtractTableMetadataPercentage();
            if (this$extractTableMetadataPercentage == null ? other$extractTableMetadataPercentage != null : !this$extractTableMetadataPercentage.equals(other$extractTableMetadataPercentage)) return false;
            final java.lang.Object this$executionTimeInternal = this.getExecutionTimeInternal();
            final java.lang.Object other$executionTimeInternal = other.getExecutionTimeInternal();
            if (this$executionTimeInternal == null ? other$executionTimeInternal != null : !this$executionTimeInternal.equals(other$executionTimeInternal)) return false;
            final java.lang.Object this$executionPercentage = this.getExecutionPercentage();
            final java.lang.Object other$executionPercentage = other.getExecutionPercentage();
            if (this$executionPercentage == null ? other$executionPercentage != null : !this$executionPercentage.equals(other$executionPercentage)) return false;
            final java.lang.Object this$bypassQueryTime = this.getBypassQueryTime();
            final java.lang.Object other$bypassQueryTime = other.getBypassQueryTime();
            if (this$bypassQueryTime == null ? other$bypassQueryTime != null : !this$bypassQueryTime.equals(other$bypassQueryTime)) return false;
            final java.lang.Object this$bypassParsingPercentage = this.getBypassParsingPercentage();
            final java.lang.Object other$bypassParsingPercentage = other.getBypassParsingPercentage();
            if (this$bypassParsingPercentage == null ? other$bypassParsingPercentage != null : !this$bypassParsingPercentage.equals(other$bypassParsingPercentage)) return false;
            final java.lang.Object this$checkInsightsEnabledTime = this.getCheckInsightsEnabledTime();
            final java.lang.Object other$checkInsightsEnabledTime = other.getCheckInsightsEnabledTime();
            if (this$checkInsightsEnabledTime == null ? other$checkInsightsEnabledTime != null : !this$checkInsightsEnabledTime.equals(other$checkInsightsEnabledTime)) return false;
            final java.lang.Object this$checkInsightsEnabledPercentage = this.getCheckInsightsEnabledPercentage();
            final java.lang.Object other$checkInsightsEnabledPercentage = other.getCheckInsightsEnabledPercentage();
            if (this$checkInsightsEnabledPercentage == null ? other$checkInsightsEnabledPercentage != null : !this$checkInsightsEnabledPercentage.equals(other$checkInsightsEnabledPercentage)) return false;
            final java.lang.Object this$initializationTime = this.getInitializationTime();
            final java.lang.Object other$initializationTime = other.getInitializationTime();
            if (this$initializationTime == null ? other$initializationTime != null : !this$initializationTime.equals(other$initializationTime)) return false;
            final java.lang.Object this$initializationPercentage = this.getInitializationPercentage();
            final java.lang.Object other$initializationPercentage = other.getInitializationPercentage();
            if (this$initializationPercentage == null ? other$initializationPercentage != null : !this$initializationPercentage.equals(other$initializationPercentage)) return false;
            final java.lang.Object this$extractCredentialsTime = this.getExtractCredentialsTime();
            final java.lang.Object other$extractCredentialsTime = other.getExtractCredentialsTime();
            if (this$extractCredentialsTime == null ? other$extractCredentialsTime != null : !this$extractCredentialsTime.equals(other$extractCredentialsTime)) return false;
            final java.lang.Object this$extractCredentialsPercentage = this.getExtractCredentialsPercentage();
            final java.lang.Object other$extractCredentialsPercentage = other.getExtractCredentialsPercentage();
            if (this$extractCredentialsPercentage == null ? other$extractCredentialsPercentage != null : !this$extractCredentialsPercentage.equals(other$extractCredentialsPercentage)) return false;
            final java.lang.Object this$overallTime = this.getOverallTime();
            final java.lang.Object other$overallTime = other.getOverallTime();
            if (this$overallTime == null ? other$overallTime != null : !this$overallTime.equals(other$overallTime)) return false;
            final java.lang.Object this$overallTimePercentage = this.getOverallTimePercentage();
            final java.lang.Object other$overallTimePercentage = other.getOverallTimePercentage();
            if (this$overallTimePercentage == null ? other$overallTimePercentage != null : !this$overallTimePercentage.equals(other$overallTimePercentage)) return false;
            final java.lang.Object this$hekaAtlanTime = this.getHekaAtlanTime();
            final java.lang.Object other$hekaAtlanTime = other.getHekaAtlanTime();
            if (this$hekaAtlanTime == null ? other$hekaAtlanTime != null : !this$hekaAtlanTime.equals(other$hekaAtlanTime)) return false;
            final java.lang.Object this$calciteParsingPercentage = this.getCalciteParsingPercentage();
            final java.lang.Object other$calciteParsingPercentage = other.getCalciteParsingPercentage();
            if (this$calciteParsingPercentage == null ? other$calciteParsingPercentage != null : !this$calciteParsingPercentage.equals(other$calciteParsingPercentage)) return false;
            final java.lang.Object this$calciteValidationPercentage = this.getCalciteValidationPercentage();
            final java.lang.Object other$calciteValidationPercentage = other.getCalciteValidationPercentage();
            if (this$calciteValidationPercentage == null ? other$calciteValidationPercentage != null : !this$calciteValidationPercentage.equals(other$calciteValidationPercentage)) return false;
            final java.lang.Object this$line = this.getLine();
            final java.lang.Object other$line = other.getLine();
            if (this$line == null ? other$line != null : !this$line.equals(other$line)) return false;
            final java.lang.Object this$column = this.getColumn();
            final java.lang.Object other$column = other.getColumn();
            if (this$column == null ? other$column != null : !this$column.equals(other$column)) return false;
            final java.lang.Object this$status = this.getStatus();
            final java.lang.Object other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
            final java.lang.Object this$parsedQuery = this.getParsedQuery();
            final java.lang.Object other$parsedQuery = other.getParsedQuery();
            if (this$parsedQuery == null ? other$parsedQuery != null : !this$parsedQuery.equals(other$parsedQuery)) return false;
            final java.lang.Object this$pushdownQuery = this.getPushdownQuery();
            final java.lang.Object other$pushdownQuery = other.getPushdownQuery();
            if (this$pushdownQuery == null ? other$pushdownQuery != null : !this$pushdownQuery.equals(other$pushdownQuery)) return false;
            final java.lang.Object this$sourceQueryId = this.getSourceQueryId();
            final java.lang.Object other$sourceQueryId = other.getSourceQueryId();
            if (this$sourceQueryId == null ? other$sourceQueryId != null : !this$sourceQueryId.equals(other$sourceQueryId)) return false;
            final java.lang.Object this$resultOutputLocation = this.getResultOutputLocation();
            final java.lang.Object other$resultOutputLocation = other.getResultOutputLocation();
            if (this$resultOutputLocation == null ? other$resultOutputLocation != null : !this$resultOutputLocation.equals(other$resultOutputLocation)) return false;
            final java.lang.Object this$warnings = this.getWarnings();
            final java.lang.Object other$warnings = other.getWarnings();
            if (this$warnings == null ? other$warnings != null : !this$warnings.equals(other$warnings)) return false;
            final java.lang.Object this$parsingFlow = this.getParsingFlow();
            final java.lang.Object other$parsingFlow = other.getParsingFlow();
            if (this$parsingFlow == null ? other$parsingFlow != null : !this$parsingFlow.equals(other$parsingFlow)) return false;
            final java.lang.Object this$hekaFlow = this.getHekaFlow();
            final java.lang.Object other$hekaFlow = other.getHekaFlow();
            if (this$hekaFlow == null ? other$hekaFlow != null : !this$hekaFlow.equals(other$hekaFlow)) return false;
            final java.lang.Object this$s3UploadPath = this.getS3UploadPath();
            final java.lang.Object other$s3UploadPath = other.getS3UploadPath();
            if (this$s3UploadPath == null ? other$s3UploadPath != null : !this$s3UploadPath.equals(other$s3UploadPath)) return false;
            final java.lang.Object this$asset = this.getAsset();
            final java.lang.Object other$asset = other.getAsset();
            if (this$asset == null ? other$asset != null : !this$asset.equals(other$asset)) return false;
            final java.lang.Object this$developerMessage = this.getDeveloperMessage();
            final java.lang.Object other$developerMessage = other.getDeveloperMessage();
            if (this$developerMessage == null ? other$developerMessage != null : !this$developerMessage.equals(other$developerMessage)) return false;
            final java.lang.Object this$object = this.getObject();
            final java.lang.Object other$object = other.getObject();
            if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof QueryResponse.QueryDetails;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $totalRowsStreamed = this.getTotalRowsStreamed();
            result = result * PRIME + ($totalRowsStreamed == null ? 43 : $totalRowsStreamed.hashCode());
            final java.lang.Object $executionTime = this.getExecutionTime();
            result = result * PRIME + ($executionTime == null ? 43 : $executionTime.hashCode());
            final java.lang.Object $sourceFirstConnectionTime = this.getSourceFirstConnectionTime();
            result = result * PRIME + ($sourceFirstConnectionTime == null ? 43 : $sourceFirstConnectionTime.hashCode());
            final java.lang.Object $sourceFirstConnectionPercentage = this.getSourceFirstConnectionPercentage();
            result = result * PRIME + ($sourceFirstConnectionPercentage == null ? 43 : $sourceFirstConnectionPercentage.hashCode());
            final java.lang.Object $explainCallTimePercentage = this.getExplainCallTimePercentage();
            result = result * PRIME + ($explainCallTimePercentage == null ? 43 : $explainCallTimePercentage.hashCode());
            final java.lang.Object $initDataSourceTime = this.getInitDataSourceTime();
            result = result * PRIME + ($initDataSourceTime == null ? 43 : $initDataSourceTime.hashCode());
            final java.lang.Object $initDataSourcePercentage = this.getInitDataSourcePercentage();
            result = result * PRIME + ($initDataSourcePercentage == null ? 43 : $initDataSourcePercentage.hashCode());
            final java.lang.Object $authorizationTime = this.getAuthorizationTime();
            result = result * PRIME + ($authorizationTime == null ? 43 : $authorizationTime.hashCode());
            final java.lang.Object $authorizationPercentage = this.getAuthorizationPercentage();
            result = result * PRIME + ($authorizationPercentage == null ? 43 : $authorizationPercentage.hashCode());
            final java.lang.Object $rewriteValidationTime = this.getRewriteValidationTime();
            result = result * PRIME + ($rewriteValidationTime == null ? 43 : $rewriteValidationTime.hashCode());
            final java.lang.Object $rewriteValidationPercentage = this.getRewriteValidationPercentage();
            result = result * PRIME + ($rewriteValidationPercentage == null ? 43 : $rewriteValidationPercentage.hashCode());
            final java.lang.Object $extractTableMetadataTime = this.getExtractTableMetadataTime();
            result = result * PRIME + ($extractTableMetadataTime == null ? 43 : $extractTableMetadataTime.hashCode());
            final java.lang.Object $extractTableMetadataPercentage = this.getExtractTableMetadataPercentage();
            result = result * PRIME + ($extractTableMetadataPercentage == null ? 43 : $extractTableMetadataPercentage.hashCode());
            final java.lang.Object $executionTimeInternal = this.getExecutionTimeInternal();
            result = result * PRIME + ($executionTimeInternal == null ? 43 : $executionTimeInternal.hashCode());
            final java.lang.Object $executionPercentage = this.getExecutionPercentage();
            result = result * PRIME + ($executionPercentage == null ? 43 : $executionPercentage.hashCode());
            final java.lang.Object $bypassQueryTime = this.getBypassQueryTime();
            result = result * PRIME + ($bypassQueryTime == null ? 43 : $bypassQueryTime.hashCode());
            final java.lang.Object $bypassParsingPercentage = this.getBypassParsingPercentage();
            result = result * PRIME + ($bypassParsingPercentage == null ? 43 : $bypassParsingPercentage.hashCode());
            final java.lang.Object $checkInsightsEnabledTime = this.getCheckInsightsEnabledTime();
            result = result * PRIME + ($checkInsightsEnabledTime == null ? 43 : $checkInsightsEnabledTime.hashCode());
            final java.lang.Object $checkInsightsEnabledPercentage = this.getCheckInsightsEnabledPercentage();
            result = result * PRIME + ($checkInsightsEnabledPercentage == null ? 43 : $checkInsightsEnabledPercentage.hashCode());
            final java.lang.Object $initializationTime = this.getInitializationTime();
            result = result * PRIME + ($initializationTime == null ? 43 : $initializationTime.hashCode());
            final java.lang.Object $initializationPercentage = this.getInitializationPercentage();
            result = result * PRIME + ($initializationPercentage == null ? 43 : $initializationPercentage.hashCode());
            final java.lang.Object $extractCredentialsTime = this.getExtractCredentialsTime();
            result = result * PRIME + ($extractCredentialsTime == null ? 43 : $extractCredentialsTime.hashCode());
            final java.lang.Object $extractCredentialsPercentage = this.getExtractCredentialsPercentage();
            result = result * PRIME + ($extractCredentialsPercentage == null ? 43 : $extractCredentialsPercentage.hashCode());
            final java.lang.Object $overallTime = this.getOverallTime();
            result = result * PRIME + ($overallTime == null ? 43 : $overallTime.hashCode());
            final java.lang.Object $overallTimePercentage = this.getOverallTimePercentage();
            result = result * PRIME + ($overallTimePercentage == null ? 43 : $overallTimePercentage.hashCode());
            final java.lang.Object $hekaAtlanTime = this.getHekaAtlanTime();
            result = result * PRIME + ($hekaAtlanTime == null ? 43 : $hekaAtlanTime.hashCode());
            final java.lang.Object $calciteParsingPercentage = this.getCalciteParsingPercentage();
            result = result * PRIME + ($calciteParsingPercentage == null ? 43 : $calciteParsingPercentage.hashCode());
            final java.lang.Object $calciteValidationPercentage = this.getCalciteValidationPercentage();
            result = result * PRIME + ($calciteValidationPercentage == null ? 43 : $calciteValidationPercentage.hashCode());
            final java.lang.Object $line = this.getLine();
            result = result * PRIME + ($line == null ? 43 : $line.hashCode());
            final java.lang.Object $column = this.getColumn();
            result = result * PRIME + ($column == null ? 43 : $column.hashCode());
            final java.lang.Object $status = this.getStatus();
            result = result * PRIME + ($status == null ? 43 : $status.hashCode());
            final java.lang.Object $parsedQuery = this.getParsedQuery();
            result = result * PRIME + ($parsedQuery == null ? 43 : $parsedQuery.hashCode());
            final java.lang.Object $pushdownQuery = this.getPushdownQuery();
            result = result * PRIME + ($pushdownQuery == null ? 43 : $pushdownQuery.hashCode());
            final java.lang.Object $sourceQueryId = this.getSourceQueryId();
            result = result * PRIME + ($sourceQueryId == null ? 43 : $sourceQueryId.hashCode());
            final java.lang.Object $resultOutputLocation = this.getResultOutputLocation();
            result = result * PRIME + ($resultOutputLocation == null ? 43 : $resultOutputLocation.hashCode());
            final java.lang.Object $warnings = this.getWarnings();
            result = result * PRIME + ($warnings == null ? 43 : $warnings.hashCode());
            final java.lang.Object $parsingFlow = this.getParsingFlow();
            result = result * PRIME + ($parsingFlow == null ? 43 : $parsingFlow.hashCode());
            final java.lang.Object $hekaFlow = this.getHekaFlow();
            result = result * PRIME + ($hekaFlow == null ? 43 : $hekaFlow.hashCode());
            final java.lang.Object $s3UploadPath = this.getS3UploadPath();
            result = result * PRIME + ($s3UploadPath == null ? 43 : $s3UploadPath.hashCode());
            final java.lang.Object $asset = this.getAsset();
            result = result * PRIME + ($asset == null ? 43 : $asset.hashCode());
            final java.lang.Object $developerMessage = this.getDeveloperMessage();
            result = result * PRIME + ($developerMessage == null ? 43 : $developerMessage.hashCode());
            final java.lang.Object $object = this.getObject();
            result = result * PRIME + ($object == null ? 43 : $object.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "QueryResponse.QueryDetails(super=" + super.toString() + ", totalRowsStreamed=" + this.getTotalRowsStreamed() + ", status=" + this.getStatus() + ", parsedQuery=" + this.getParsedQuery() + ", pushdownQuery=" + this.getPushdownQuery() + ", executionTime=" + this.getExecutionTime() + ", sourceQueryId=" + this.getSourceQueryId() + ", resultOutputLocation=" + this.getResultOutputLocation() + ", warnings=" + this.getWarnings() + ", parsingFlow=" + this.getParsingFlow() + ", hekaFlow=" + this.getHekaFlow() + ", s3UploadPath=" + this.getS3UploadPath() + ", sourceFirstConnectionTime=" + this.getSourceFirstConnectionTime() + ", sourceFirstConnectionPercentage=" + this.getSourceFirstConnectionPercentage() + ", explainCallTimePercentage=" + this.getExplainCallTimePercentage() + ", initDataSourceTime=" + this.getInitDataSourceTime() + ", initDataSourcePercentage=" + this.getInitDataSourcePercentage() + ", authorizationTime=" + this.getAuthorizationTime() + ", authorizationPercentage=" + this.getAuthorizationPercentage() + ", rewriteValidationTime=" + this.getRewriteValidationTime() + ", rewriteValidationPercentage=" + this.getRewriteValidationPercentage() + ", extractTableMetadataTime=" + this.getExtractTableMetadataTime() + ", extractTableMetadataPercentage=" + this.getExtractTableMetadataPercentage() + ", executionTimeInternal=" + this.getExecutionTimeInternal() + ", executionPercentage=" + this.getExecutionPercentage() + ", bypassQueryTime=" + this.getBypassQueryTime() + ", bypassParsingPercentage=" + this.getBypassParsingPercentage() + ", checkInsightsEnabledTime=" + this.getCheckInsightsEnabledTime() + ", checkInsightsEnabledPercentage=" + this.getCheckInsightsEnabledPercentage() + ", initializationTime=" + this.getInitializationTime() + ", initializationPercentage=" + this.getInitializationPercentage() + ", extractCredentialsTime=" + this.getExtractCredentialsTime() + ", extractCredentialsPercentage=" + this.getExtractCredentialsPercentage() + ", overallTime=" + this.getOverallTime() + ", overallTimePercentage=" + this.getOverallTimePercentage() + ", hekaAtlanTime=" + this.getHekaAtlanTime() + ", calciteParsingPercentage=" + this.getCalciteParsingPercentage() + ", calciteValidationPercentage=" + this.getCalciteValidationPercentage() + ", asset=" + this.getAsset() + ", developerMessage=" + this.getDeveloperMessage() + ", line=" + this.getLine() + ", column=" + this.getColumn() + ", object=" + this.getObject() + ")";
        }
    }


    /**
     * Details about an asset that was queried, in case of errors.
     */
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = QueryResponse.AssetDetails.AssetDetailsBuilderImpl.class)
    public static final class AssetDetails extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /** Simple name of the connection. */
        String connectionName;
        /** Unique name of the connection. */
        String connectionQN;
        /** Simple name of the database. */
        String database;
        /** Simple name of the schema. */
        String schema;
        /** Simple name of the table. */
        String table;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class AssetDetailsBuilder<C extends QueryResponse.AssetDetails, B extends QueryResponse.AssetDetails.AssetDetailsBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String connectionName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String connectionQN;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String database;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String schema;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String table;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                QueryResponse.AssetDetails.AssetDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final QueryResponse.AssetDetails instance, final QueryResponse.AssetDetails.AssetDetailsBuilder<?, ?> b) {
                b.connectionName(instance.connectionName);
                b.connectionQN(instance.connectionQN);
                b.database(instance.database);
                b.schema(instance.schema);
                b.table(instance.table);
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B connectionName(final String connectionName) {
                this.connectionName = connectionName;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B connectionQN(final String connectionQN) {
                this.connectionQN = connectionQN;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B database(final String database) {
                this.database = database;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B schema(final String schema) {
                this.schema = schema;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B table(final String table) {
                this.table = table;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "QueryResponse.AssetDetails.AssetDetailsBuilder(super=" + super.toString() + ", connectionName=" + this.connectionName + ", connectionQN=" + this.connectionQN + ", database=" + this.database + ", schema=" + this.schema + ", table=" + this.table + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class AssetDetailsBuilderImpl extends QueryResponse.AssetDetails.AssetDetailsBuilder<QueryResponse.AssetDetails, QueryResponse.AssetDetails.AssetDetailsBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private AssetDetailsBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected QueryResponse.AssetDetails.AssetDetailsBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public QueryResponse.AssetDetails build() {
                return new QueryResponse.AssetDetails(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AssetDetails(final QueryResponse.AssetDetails.AssetDetailsBuilder<?, ?> b) {
            super(b);
            this.connectionName = b.connectionName;
            this.connectionQN = b.connectionQN;
            this.database = b.database;
            this.schema = b.schema;
            this.table = b.table;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static QueryResponse.AssetDetails.AssetDetailsBuilder<?, ?> builder() {
            return new QueryResponse.AssetDetails.AssetDetailsBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public QueryResponse.AssetDetails.AssetDetailsBuilder<?, ?> toBuilder() {
            return new QueryResponse.AssetDetails.AssetDetailsBuilderImpl().$fillValuesFrom(this);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getConnectionName() {
            return this.connectionName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getConnectionQN() {
            return this.connectionQN;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDatabase() {
            return this.database;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getSchema() {
            return this.schema;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getTable() {
            return this.table;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof QueryResponse.AssetDetails)) return false;
            final QueryResponse.AssetDetails other = (QueryResponse.AssetDetails) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$connectionName = this.getConnectionName();
            final java.lang.Object other$connectionName = other.getConnectionName();
            if (this$connectionName == null ? other$connectionName != null : !this$connectionName.equals(other$connectionName)) return false;
            final java.lang.Object this$connectionQN = this.getConnectionQN();
            final java.lang.Object other$connectionQN = other.getConnectionQN();
            if (this$connectionQN == null ? other$connectionQN != null : !this$connectionQN.equals(other$connectionQN)) return false;
            final java.lang.Object this$database = this.getDatabase();
            final java.lang.Object other$database = other.getDatabase();
            if (this$database == null ? other$database != null : !this$database.equals(other$database)) return false;
            final java.lang.Object this$schema = this.getSchema();
            final java.lang.Object other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) return false;
            final java.lang.Object this$table = this.getTable();
            final java.lang.Object other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof QueryResponse.AssetDetails;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $connectionName = this.getConnectionName();
            result = result * PRIME + ($connectionName == null ? 43 : $connectionName.hashCode());
            final java.lang.Object $connectionQN = this.getConnectionQN();
            result = result * PRIME + ($connectionQN == null ? 43 : $connectionQN.hashCode());
            final java.lang.Object $database = this.getDatabase();
            result = result * PRIME + ($database == null ? 43 : $database.hashCode());
            final java.lang.Object $schema = this.getSchema();
            result = result * PRIME + ($schema == null ? 43 : $schema.hashCode());
            final java.lang.Object $table = this.getTable();
            result = result * PRIME + ($table == null ? 43 : $table.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "QueryResponse.AssetDetails(super=" + super.toString() + ", connectionName=" + this.getConnectionName() + ", connectionQN=" + this.getConnectionQN() + ", database=" + this.getDatabase() + ", schema=" + this.getSchema() + ", table=" + this.getTable() + ")";
        }
    }

    /**
     * Unique identifier for the request, if there was any error.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRequestId() {
        return this.requestId;
    }

    /**
     * Unique name for the error, if there was any error.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getErrorName() {
        return this.errorName;
    }

    /**
     * Explanation of the error, if there was any error.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    /**
     * Unique code for the error, if there was any error.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getErrorCode() {
        return this.errorCode;
    }

    /**
     * Unique identifier (GUID) for the specific run of the query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQueryId() {
        return this.queryId;
    }

    /**
     * Results of the query. Each element is of the outer list is a single row,
     * while each inner list gives the column values for that row (in order).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<List<String>> getRows() {
        return this.rows;
    }

    /**
     * Columns that are present in each row of the results. The order of the elements
     * of this list will match the order of the inner list of values for the {@link #rows}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<ColumnDetails> getColumns() {
        return this.columns;
    }

    /**
     * Details about the query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public QueryDetails getDetails() {
        return this.details;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof QueryResponse)) return false;
        final QueryResponse other = (QueryResponse) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$requestId = this.getRequestId();
        final java.lang.Object other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) return false;
        final java.lang.Object this$errorName = this.getErrorName();
        final java.lang.Object other$errorName = other.getErrorName();
        if (this$errorName == null ? other$errorName != null : !this$errorName.equals(other$errorName)) return false;
        final java.lang.Object this$errorMessage = this.getErrorMessage();
        final java.lang.Object other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) return false;
        final java.lang.Object this$errorCode = this.getErrorCode();
        final java.lang.Object other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) return false;
        final java.lang.Object this$queryId = this.getQueryId();
        final java.lang.Object other$queryId = other.getQueryId();
        if (this$queryId == null ? other$queryId != null : !this$queryId.equals(other$queryId)) return false;
        final java.lang.Object this$rows = this.getRows();
        final java.lang.Object other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !this$rows.equals(other$rows)) return false;
        final java.lang.Object this$columns = this.getColumns();
        final java.lang.Object other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) return false;
        final java.lang.Object this$details = this.getDetails();
        final java.lang.Object other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof QueryResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $requestId = this.getRequestId();
        result = result * PRIME + ($requestId == null ? 43 : $requestId.hashCode());
        final java.lang.Object $errorName = this.getErrorName();
        result = result * PRIME + ($errorName == null ? 43 : $errorName.hashCode());
        final java.lang.Object $errorMessage = this.getErrorMessage();
        result = result * PRIME + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        final java.lang.Object $errorCode = this.getErrorCode();
        result = result * PRIME + ($errorCode == null ? 43 : $errorCode.hashCode());
        final java.lang.Object $queryId = this.getQueryId();
        result = result * PRIME + ($queryId == null ? 43 : $queryId.hashCode());
        final java.lang.Object $rows = this.getRows();
        result = result * PRIME + ($rows == null ? 43 : $rows.hashCode());
        final java.lang.Object $columns = this.getColumns();
        result = result * PRIME + ($columns == null ? 43 : $columns.hashCode());
        final java.lang.Object $details = this.getDetails();
        result = result * PRIME + ($details == null ? 43 : $details.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "QueryResponse(super=" + super.toString() + ", requestId=" + this.getRequestId() + ", errorName=" + this.getErrorName() + ", errorMessage=" + this.getErrorMessage() + ", errorCode=" + this.getErrorCode() + ", queryId=" + this.getQueryId() + ", rows=" + this.getRows() + ", columns=" + this.getColumns() + ", details=" + this.getDetails() + ")";
    }
}
