// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.GlossaryTerm;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class TermLinkRequest extends AtlanRequest {
    private static final long serialVersionUID = 2L;
    public static final String REQUEST_TYPE = "term_link";
    public static final String SOURCE_TYPE = "atlas";
    /**
     * Fixed requestType for term assignments.
     */
    String requestType;
    /**
     * Fixed sourceType for term assignments.
     */
    String sourceType;

    /**
     * Create a new request to change an attribute's value.
     * Note that the asset must have at least its real (not placeholder) GUID and qualifiedName populated.
     *
     * @param asset against which to raise the request
     * @param term to link to the asset
     * @return a builder for the request with these details
     * @throws InvalidRequestException if any of the required details for the provided asset are missing
     */
    public static TermLinkRequestBuilder<?, ?> creator(Asset asset, GlossaryTerm term) throws InvalidRequestException {
        List<String> missing = new ArrayList<>();
        if (asset.getQualifiedName() == null || asset.getQualifiedName().isEmpty()) {
            missing.add("qualifiedName");
        }
        if (asset.getGuid() == null || asset.getGuid().isEmpty()) {
            missing.add("guid");
        }
        if (term.getQualifiedName() == null || term.getQualifiedName().isEmpty()) {
            missing.add("term::qualifiedName");
        }
        if (term.getGuid() == null || term.getGuid().isEmpty()) {
            missing.add("term::guid");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, asset.getTypeName(), String.join(",", missing));
        }
        return creator(asset.getGuid(), asset.getQualifiedName(), asset.getTypeName(), term.getGuid(), term.getQualifiedName());
    }

    /**
     * Create a new request to link a term to an asset.
     *
     * @param assetGuid unique identifier (GUID) of the asset to link to the term
     * @param assetQualifiedName qualifiedName of the asset to link to the term
     * @param assetType type of the asset to link to the term
     * @param termGuid unique identifier (GUID) of the term to link to the asset
     * @param termQualifiedName qualifiedName of the term to link to the asset
     * @return a builder for the request with these details
     */
    public static TermLinkRequestBuilder<?, ?> creator(String assetGuid, String assetQualifiedName, String assetType, String termGuid, String termQualifiedName) {
        return TermLinkRequest.builder().id(UUID.randomUUID().toString()).destinationGuid(assetGuid).destinationQualifiedName(assetQualifiedName).entityType(assetType).sourceGuid(termGuid).sourceQualifiedName(termQualifiedName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$requestType() {
        return REQUEST_TYPE;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$sourceType() {
        return SOURCE_TYPE;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class TermLinkRequestBuilder<C extends TermLinkRequest, B extends TermLinkRequest.TermLinkRequestBuilder<C, B>> extends AtlanRequest.AtlanRequestBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean requestType$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String requestType$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean sourceType$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceType$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            TermLinkRequest.TermLinkRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final TermLinkRequest instance, final TermLinkRequest.TermLinkRequestBuilder<?, ?> b) {
            b.requestType(instance.requestType);
            b.sourceType(instance.sourceType);
        }

        /**
         * Fixed requestType for term assignments.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestType(final String requestType) {
            this.requestType$value = requestType;
            requestType$set = true;
            return self();
        }

        /**
         * Fixed sourceType for term assignments.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceType(final String sourceType) {
            this.sourceType$value = sourceType;
            sourceType$set = true;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TermLinkRequest.TermLinkRequestBuilder(super=" + super.toString() + ", requestType$value=" + this.requestType$value + ", sourceType$value=" + this.sourceType$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class TermLinkRequestBuilderImpl extends TermLinkRequest.TermLinkRequestBuilder<TermLinkRequest, TermLinkRequest.TermLinkRequestBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private TermLinkRequestBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected TermLinkRequest.TermLinkRequestBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TermLinkRequest build() {
            return new TermLinkRequest(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected TermLinkRequest(final TermLinkRequest.TermLinkRequestBuilder<?, ?> b) {
        super(b);
        if (b.requestType$set) this.requestType = b.requestType$value;
         else this.requestType = TermLinkRequest.$default$requestType();
        if (b.sourceType$set) this.sourceType = b.sourceType$value;
         else this.sourceType = TermLinkRequest.$default$sourceType();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static TermLinkRequest.TermLinkRequestBuilder<?, ?> builder() {
        return new TermLinkRequest.TermLinkRequestBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TermLinkRequest.TermLinkRequestBuilder<?, ?> toBuilder() {
        return new TermLinkRequest.TermLinkRequestBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TermLinkRequest)) return false;
        final TermLinkRequest other = (TermLinkRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$requestType = this.getRequestType();
        final java.lang.Object other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType)) return false;
        final java.lang.Object this$sourceType = this.getSourceType();
        final java.lang.Object other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TermLinkRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $requestType = this.getRequestType();
        result = result * PRIME + ($requestType == null ? 43 : $requestType.hashCode());
        final java.lang.Object $sourceType = this.getSourceType();
        result = result * PRIME + ($sourceType == null ? 43 : $sourceType.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TermLinkRequest(super=" + super.toString() + ", requestType=" + this.getRequestType() + ", sourceType=" + this.getSourceType() + ")";
    }

    /**
     * Fixed requestType for term assignments.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRequestType() {
        return this.requestType;
    }

    /**
     * Fixed sourceType for term assignments.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceType() {
        return this.sourceType;
    }
}
