// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * Specialized response for minimalist user details, as returned by some operations.
 */
public class UserMinimalResponse extends ApiResource {
    private static final long serialVersionUID = 2L;

    /**
     * Convert this minimalist response into an AtlanUser object.
     *
     * @return an AtlanUser representation of the same user
     */
    public AtlanUser toAtlanUser() {
        return AtlanUser.builder().username(username).id(id).email(email).emailVerified(emailVerified).enabled(enabled).firstName(firstName).lastName(lastName).attributes(attributes).createdTimestamp(createdTimestamp).build();
    }

    /**
     * Username of the user within Atlan.
     */
    String username;
    /**
     * Unique identifier (GUID) of the user within Atlan.
     */
    String id;
    /**
     * Email address of the user.
     */
    String email;
    /**
     * When true, the email address of the user has been verified.
     */
    Boolean emailVerified;
    /**
     * When true, the user is enabled. When false, the user has been deactivated.
     */
    Boolean enabled;
    /**
     * First name of the user.
     */
    String firstName;
    /**
     * Last name (surname) of the user.
     */
    String lastName;
    /**
     * Detailed attributes of the user.
     */
    AtlanUser.UserAttributes attributes;
    /**
     * Time (epoch) at which the user was created, in milliseconds.
     */
    Long createdTimestamp;
    /**
     * TBC
     */
    Boolean totp;
    // TODO
    /**
     * TBC
     */
    @JsonIgnore
    String disableableCredentialTypes;
    // TODO
    /**
     * TBC
     */
    @JsonIgnore
    String requiredActions;
    // TODO
    /**
     * TBC
     */
    @JsonIgnore
    String access;

    /**
     * Username of the user within Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUsername() {
        return this.username;
    }

    /**
     * Unique identifier (GUID) of the user within Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
        return this.id;
    }

    /**
     * Email address of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEmail() {
        return this.email;
    }

    /**
     * When true, the email address of the user has been verified.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEmailVerified() {
        return this.emailVerified;
    }

    /**
     * When true, the user is enabled. When false, the user has been deactivated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * First name of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFirstName() {
        return this.firstName;
    }

    /**
     * Last name (surname) of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLastName() {
        return this.lastName;
    }

    /**
     * Detailed attributes of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanUser.UserAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Time (epoch) at which the user was created, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getTotp() {
        return this.totp;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisableableCredentialTypes() {
        return this.disableableCredentialTypes;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRequiredActions() {
        return this.requiredActions;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAccess() {
        return this.access;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof UserMinimalResponse)) return false;
        final UserMinimalResponse other = (UserMinimalResponse) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$emailVerified = this.getEmailVerified();
        final java.lang.Object other$emailVerified = other.getEmailVerified();
        if (this$emailVerified == null ? other$emailVerified != null : !this$emailVerified.equals(other$emailVerified)) return false;
        final java.lang.Object this$enabled = this.getEnabled();
        final java.lang.Object other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
        final java.lang.Object this$createdTimestamp = this.getCreatedTimestamp();
        final java.lang.Object other$createdTimestamp = other.getCreatedTimestamp();
        if (this$createdTimestamp == null ? other$createdTimestamp != null : !this$createdTimestamp.equals(other$createdTimestamp)) return false;
        final java.lang.Object this$totp = this.getTotp();
        final java.lang.Object other$totp = other.getTotp();
        if (this$totp == null ? other$totp != null : !this$totp.equals(other$totp)) return false;
        final java.lang.Object this$username = this.getUsername();
        final java.lang.Object other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$email = this.getEmail();
        final java.lang.Object other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
        final java.lang.Object this$firstName = this.getFirstName();
        final java.lang.Object other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) return false;
        final java.lang.Object this$lastName = this.getLastName();
        final java.lang.Object other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) return false;
        final java.lang.Object this$attributes = this.getAttributes();
        final java.lang.Object other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
        final java.lang.Object this$disableableCredentialTypes = this.getDisableableCredentialTypes();
        final java.lang.Object other$disableableCredentialTypes = other.getDisableableCredentialTypes();
        if (this$disableableCredentialTypes == null ? other$disableableCredentialTypes != null : !this$disableableCredentialTypes.equals(other$disableableCredentialTypes)) return false;
        final java.lang.Object this$requiredActions = this.getRequiredActions();
        final java.lang.Object other$requiredActions = other.getRequiredActions();
        if (this$requiredActions == null ? other$requiredActions != null : !this$requiredActions.equals(other$requiredActions)) return false;
        final java.lang.Object this$access = this.getAccess();
        final java.lang.Object other$access = other.getAccess();
        if (this$access == null ? other$access != null : !this$access.equals(other$access)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof UserMinimalResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $emailVerified = this.getEmailVerified();
        result = result * PRIME + ($emailVerified == null ? 43 : $emailVerified.hashCode());
        final java.lang.Object $enabled = this.getEnabled();
        result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
        final java.lang.Object $createdTimestamp = this.getCreatedTimestamp();
        result = result * PRIME + ($createdTimestamp == null ? 43 : $createdTimestamp.hashCode());
        final java.lang.Object $totp = this.getTotp();
        result = result * PRIME + ($totp == null ? 43 : $totp.hashCode());
        final java.lang.Object $username = this.getUsername();
        result = result * PRIME + ($username == null ? 43 : $username.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $email = this.getEmail();
        result = result * PRIME + ($email == null ? 43 : $email.hashCode());
        final java.lang.Object $firstName = this.getFirstName();
        result = result * PRIME + ($firstName == null ? 43 : $firstName.hashCode());
        final java.lang.Object $lastName = this.getLastName();
        result = result * PRIME + ($lastName == null ? 43 : $lastName.hashCode());
        final java.lang.Object $attributes = this.getAttributes();
        result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
        final java.lang.Object $disableableCredentialTypes = this.getDisableableCredentialTypes();
        result = result * PRIME + ($disableableCredentialTypes == null ? 43 : $disableableCredentialTypes.hashCode());
        final java.lang.Object $requiredActions = this.getRequiredActions();
        result = result * PRIME + ($requiredActions == null ? 43 : $requiredActions.hashCode());
        final java.lang.Object $access = this.getAccess();
        result = result * PRIME + ($access == null ? 43 : $access.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "UserMinimalResponse(super=" + super.toString() + ", username=" + this.getUsername() + ", id=" + this.getId() + ", email=" + this.getEmail() + ", emailVerified=" + this.getEmailVerified() + ", enabled=" + this.getEnabled() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", attributes=" + this.getAttributes() + ", createdTimestamp=" + this.getCreatedTimestamp() + ", totp=" + this.getTotp() + ", disableableCredentialTypes=" + this.getDisableableCredentialTypes() + ", requiredActions=" + this.getRequiredActions() + ", access=" + this.getAccess() + ")";
    }
}
