// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import java.util.List;
import lombok.*;

public class UserRequest extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * TBC
     */
    int maxLoginEvents;
    /**
     * Criteria by which to filter the list of users to retrieve.
     */
    String filter;
    /**
     * Property by which to sort the resulting list of users.
     */
    String sort;
    /**
     * Whether to include an overall count of users (true) or not (false).
     */
    boolean count;
    /**
     * Starting point for the list of users when paging.
     */
    int offset;
    /**
     * Maximum number of users to return per page.
     */
    int limit;
    /**
     * List of columns to be returned about each user in the response.
     */
    List<String> columns;

    /**
     * Search for users using the filters specified in this request object.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the users
     * @return the filtered users
     * @throws AtlanException on any issues interacting with the APIs
     */
    public UserResponse list(AtlanClient client) throws AtlanException {
        return client.users.list(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static int $default$maxLoginEvents() {
        return 1;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$sort() {
        return "username";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static boolean $default$count() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static int $default$offset() {
        return 0;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static int $default$limit() {
        return 20;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class UserRequestBuilder<C extends UserRequest, B extends UserRequest.UserRequestBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean maxLoginEvents$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int maxLoginEvents$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String filter;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean sort$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sort$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean count$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean count$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean offset$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int offset$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean limit$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int limit$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> columns;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            UserRequest.UserRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final UserRequest instance, final UserRequest.UserRequestBuilder<?, ?> b) {
            b.maxLoginEvents(instance.maxLoginEvents);
            b.filter(instance.filter);
            b.sort(instance.sort);
            b.count(instance.count);
            b.offset(instance.offset);
            b.limit(instance.limit);
            b.columns(instance.columns == null ? java.util.Collections.<String>emptyList() : instance.columns);
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B maxLoginEvents(final int maxLoginEvents) {
            this.maxLoginEvents$value = maxLoginEvents;
            maxLoginEvents$set = true;
            return self();
        }

        /**
         * Criteria by which to filter the list of users to retrieve.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B filter(final String filter) {
            this.filter = filter;
            return self();
        }

        /**
         * Property by which to sort the resulting list of users.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sort(final String sort) {
            this.sort$value = sort;
            sort$set = true;
            return self();
        }

        /**
         * Whether to include an overall count of users (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B count(final boolean count) {
            this.count$value = count;
            count$set = true;
            return self();
        }

        /**
         * Starting point for the list of users when paging.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B offset(final int offset) {
            this.offset$value = offset;
            offset$set = true;
            return self();
        }

        /**
         * Maximum number of users to return per page.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B limit(final int limit) {
            this.limit$value = limit;
            limit$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B column(final String column) {
            if (this.columns == null) this.columns = new java.util.ArrayList<String>();
            this.columns.add(column);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columns(final java.util.Collection<? extends String> columns) {
            if (columns == null) {
                throw new java.lang.NullPointerException("columns cannot be null");
            }
            if (this.columns == null) this.columns = new java.util.ArrayList<String>();
            this.columns.addAll(columns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumns() {
            if (this.columns != null) this.columns.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "UserRequest.UserRequestBuilder(super=" + super.toString() + ", maxLoginEvents$value=" + this.maxLoginEvents$value + ", filter=" + this.filter + ", sort$value=" + this.sort$value + ", count$value=" + this.count$value + ", offset$value=" + this.offset$value + ", limit$value=" + this.limit$value + ", columns=" + this.columns + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class UserRequestBuilderImpl extends UserRequest.UserRequestBuilder<UserRequest, UserRequest.UserRequestBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private UserRequestBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected UserRequest.UserRequestBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public UserRequest build() {
            return new UserRequest(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected UserRequest(final UserRequest.UserRequestBuilder<?, ?> b) {
        super(b);
        if (b.maxLoginEvents$set) this.maxLoginEvents = b.maxLoginEvents$value;
         else this.maxLoginEvents = UserRequest.$default$maxLoginEvents();
        this.filter = b.filter;
        if (b.sort$set) this.sort = b.sort$value;
         else this.sort = UserRequest.$default$sort();
        if (b.count$set) this.count = b.count$value;
         else this.count = UserRequest.$default$count();
        if (b.offset$set) this.offset = b.offset$value;
         else this.offset = UserRequest.$default$offset();
        if (b.limit$set) this.limit = b.limit$value;
         else this.limit = UserRequest.$default$limit();
        java.util.List<String> columns;
        switch (b.columns == null ? 0 : b.columns.size()) {
        case 0: 
            columns = java.util.Collections.emptyList();
            break;
        case 1: 
            columns = java.util.Collections.singletonList(b.columns.get(0));
            break;
        default: 
            columns = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.columns));
        }
        this.columns = columns;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static UserRequest.UserRequestBuilder<?, ?> builder() {
        return new UserRequest.UserRequestBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UserRequest.UserRequestBuilder<?, ?> toBuilder() {
        return new UserRequest.UserRequestBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getMaxLoginEvents() {
        return this.maxLoginEvents;
    }

    /**
     * Criteria by which to filter the list of users to retrieve.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFilter() {
        return this.filter;
    }

    /**
     * Property by which to sort the resulting list of users.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSort() {
        return this.sort;
    }

    /**
     * Whether to include an overall count of users (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean getCount() {
        return this.count;
    }

    /**
     * Starting point for the list of users when paging.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getOffset() {
        return this.offset;
    }

    /**
     * Maximum number of users to return per page.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getLimit() {
        return this.limit;
    }

    /**
     * List of columns to be returned about each user in the response.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getColumns() {
        return this.columns;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof UserRequest)) return false;
        final UserRequest other = (UserRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        if (this.getMaxLoginEvents() != other.getMaxLoginEvents()) return false;
        if (this.getCount() != other.getCount()) return false;
        if (this.getOffset() != other.getOffset()) return false;
        if (this.getLimit() != other.getLimit()) return false;
        final java.lang.Object this$filter = this.getFilter();
        final java.lang.Object other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) return false;
        final java.lang.Object this$sort = this.getSort();
        final java.lang.Object other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) return false;
        final java.lang.Object this$columns = this.getColumns();
        final java.lang.Object other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof UserRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = result * PRIME + this.getMaxLoginEvents();
        result = result * PRIME + (this.getCount() ? 79 : 97);
        result = result * PRIME + this.getOffset();
        result = result * PRIME + this.getLimit();
        final java.lang.Object $filter = this.getFilter();
        result = result * PRIME + ($filter == null ? 43 : $filter.hashCode());
        final java.lang.Object $sort = this.getSort();
        result = result * PRIME + ($sort == null ? 43 : $sort.hashCode());
        final java.lang.Object $columns = this.getColumns();
        result = result * PRIME + ($columns == null ? 43 : $columns.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "UserRequest(super=" + super.toString() + ", maxLoginEvents=" + this.getMaxLoginEvents() + ", filter=" + this.getFilter() + ", sort=" + this.getSort() + ", count=" + this.getCount() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", columns=" + this.getColumns() + ")";
    }
}
