// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.ADLSAccessTier;
import com.atlan.model.enums.ADLSLeaseState;
import com.atlan.model.enums.ADLSLeaseStatus;
import com.atlan.model.enums.ADLSObjectArchiveStatus;
import com.atlan.model.enums.ADLSObjectType;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.AzureTag;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of an Azure Data Lake Storage (ADLS) blob / object in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class ADLSObject extends Asset implements IADLSObject, IADLS, IObjectStore, IAzure, ICatalog, IAsset, IReferenceable, ICloud {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ADLSObject.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ADLSObject";
    /**
     * Fixed typeName for ADLSObjects.
     */
    String typeName;
    /**
     * Unique name of the account for this ADLS asset.
     */
    @Attribute
    String adlsAccountQualifiedName;
    /**
     * Secondary location of the ADLS account.
     */
    @Attribute
    String adlsAccountSecondaryLocation;
    /**
     * Container this object exists within.
     */
    @Attribute
    IADLSContainer adlsContainer;
    /**
     * Unique name of the container this object exists within.
     */
    @Attribute
    String adlsContainerQualifiedName;
    /**
     * Access tier of this object.
     */
    @Attribute
    ADLSAccessTier adlsObjectAccessTier;
    /**
     * Time (epoch) when the acccess tier for this object was last modified, in milliseconds.
     */
    @Attribute
    @Date
    Long adlsObjectAccessTierLastModifiedTime;
    /**
     * Archive status of this object.
     */
    @Attribute
    ADLSObjectArchiveStatus adlsObjectArchiveStatus;
    /**
     * Cache control of this object.
     */
    @Attribute
    String adlsObjectCacheControl;
    /**
     * Language of this object's contents.
     */
    @Attribute
    String adlsObjectContentLanguage;
    /**
     * MD5 hash of this object's contents.
     */
    @Attribute
    String adlsObjectContentMD5Hash;
    /**
     * Content type of this object.
     */
    @Attribute
    String adlsObjectContentType;
    /**
     * State of this object's lease.
     */
    @Attribute
    ADLSLeaseState adlsObjectLeaseState;
    /**
     * Status of this object's lease.
     */
    @Attribute
    ADLSLeaseStatus adlsObjectLeaseStatus;
    /**
     * Metadata associated with this object, from ADLS.
     */
    @Attribute
    Map<String, String> adlsObjectMetadata;
    /**
     * Whether this object is server encrypted (true) or not (false).
     */
    @Attribute
    Boolean adlsObjectServerEncrypted;
    /**
     * Size of this object.
     */
    @Attribute
    Long adlsObjectSize;
    /**
     * Type of this object.
     */
    @Attribute
    ADLSObjectType adlsObjectType;
    /**
     * URL of this object.
     */
    @Attribute
    String adlsObjectUrl;
    /**
     * Identifier of the version of this object, from ADLS.
     */
    @Attribute
    String adlsObjectVersionId;
    /**
     * Whether this object supports version-level immutability (true) or not (false).
     */
    @Attribute
    Boolean adlsObjectVersionLevelImmutabilitySupport;
    /**
     * Location of this asset in Azure.
     */
    @Attribute
    String azureLocation;
    /**
     * Resource identifier of this asset in Azure.
     */
    @Attribute
    String azureResourceId;
    /**
     * Tags that have been applied to this asset in Azure.
     */
    @Attribute
    List<AzureTag> azureTags;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a ADLSObject, from a potentially
     * more-complete ADLSObject object.
     *
     * @return the minimal object necessary to relate to the ADLSObject
     * @throws InvalidRequestException if any of the minimal set of required properties for a ADLSObject relationship are not found in the initial object
     */
    @Override
    public ADLSObject trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all ADLSObject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ADLSObject assets will be included.
     *
     * @return a fluent search that includes all ADLSObject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all ADLSObject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ADLSObject assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all ADLSObject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all ADLSObject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) ADLSObjects will be included
     * @return a fluent search that includes all ADLSObject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all ADLSObject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) ADLSObjects will be included
     * @return a fluent search that includes all ADLSObject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a ADLSObject by GUID. Use this to create a relationship to this ADLSObject,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the ADLSObject to reference
     * @return reference to a ADLSObject that can be used for defining a relationship to a ADLSObject
     */
    public static ADLSObject refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ADLSObject by GUID. Use this to create a relationship to this ADLSObject,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the ADLSObject to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ADLSObject that can be used for defining a relationship to a ADLSObject
     */
    public static ADLSObject refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ADLSObject._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a ADLSObject by qualifiedName. Use this to create a relationship to this ADLSObject,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the ADLSObject to reference
     * @return reference to a ADLSObject that can be used for defining a relationship to a ADLSObject
     */
    public static ADLSObject refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ADLSObject by qualifiedName. Use this to create a relationship to this ADLSObject,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the ADLSObject to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ADLSObject that can be used for defining a relationship to a ADLSObject
     */
    public static ADLSObject refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ADLSObject._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a ADLSObject by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the ADLSObject to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ADLSObject, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ADLSObject does not exist or the provided GUID is not a ADLSObject
     */
    @JsonIgnore
    public static ADLSObject get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a ADLSObject by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ADLSObject to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ADLSObject, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ADLSObject does not exist or the provided GUID is not a ADLSObject
     */
    @JsonIgnore
    public static ADLSObject get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a ADLSObject by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ADLSObject to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full ADLSObject, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ADLSObject does not exist or the provided GUID is not a ADLSObject
     */
    @JsonIgnore
    public static ADLSObject get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof ADLSObject) {
                return (ADLSObject) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof ADLSObject) {
                return (ADLSObject) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) ADLSObject to active.
     *
     * @param qualifiedName for the ADLSObject
     * @return true if the ADLSObject is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) ADLSObject to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the ADLSObject
     * @return true if the ADLSObject is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a ADLSObject.
     *
     * @param name of the ADLSObject
     * @param container in which the ADLSObject should be created, which must have at least
     *                  a qualifiedName
     * @return the minimal request necessary to create the ADLSObject, as a builder
     * @throws InvalidRequestException if the container provided is without a qualifiedName
     */
    public static ADLSObjectBuilder<?, ?> creator(String name, ADLSContainer container) throws InvalidRequestException {
        validateRelationship(ADLSContainer.TYPE_NAME, Map.of("connectionQualifiedName", container.getConnectionQualifiedName(), "accountQualifiedName", container.getAdlsAccountQualifiedName(), "qualifiedName", container.getQualifiedName()));
        return creator(name, container.getConnectionQualifiedName(), container.getAdlsAccountQualifiedName(), container.getQualifiedName()).adlsContainer(container.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a ADLSObject.
     *
     * @param name of the ADLSObject
     * @param containerQualifiedName unique name of the container through which the ADLSObject is accessible
     * @return the minimal object necessary to create the ADLSObject, as a builder
     */
    public static ADLSObjectBuilder<?, ?> creator(String name, String containerQualifiedName) {
        String accountQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(containerQualifiedName);
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(containerQualifiedName);
        return creator(name, connectionQualifiedName, accountQualifiedName, containerQualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a ADLSObject.
     *
     * @param name of the ADLSObject
     * @param connectionQualifiedName unique name of the connection in which the ADLSObject should be created
     * @param accountQualifiedName unique name of the account in which the ADLSObject should be created
     * @param containerQualifiedName unique name of the container through which the ADLSObject is accessible
     * @return the minimal object necessary to create the ADLSObject, as a builder
     */
    public static ADLSObjectBuilder<?, ?> creator(String name, String connectionQualifiedName, String accountQualifiedName, String containerQualifiedName) {
        return ADLSObject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(generateQualifiedName(name, containerQualifiedName)).name(name).adlsContainer(ADLSContainer.refByQualifiedName(containerQualifiedName)).adlsAccountQualifiedName(accountQualifiedName).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.ADLS);
    }

    /**
     * Generate a unique ADLSObject name.
     *
     * @param name of the ADLSObject
     * @param containerQualifiedName unique name of the container through which the ADLSObject is accessible
     * @return a unique name for the ADLSObject
     */
    public static String generateQualifiedName(String name, String containerQualifiedName) {
        return containerQualifiedName + "/" + name;
    }

    /**
     * Builds the minimal object necessary to update a ADLSObject.
     *
     * @param qualifiedName of the ADLSObject
     * @param name of the ADLSObject
     * @return the minimal request necessary to update the ADLSObject, as a builder
     */
    public static ADLSObjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return ADLSObject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a ADLSObject, from a potentially
     * more-complete ADLSObject object.
     *
     * @return the minimal object necessary to update the ADLSObject, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for ADLSObject are not found in the initial object
     */
    @Override
    public ADLSObjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a ADLSObject.
     *
     * @param qualifiedName of the ADLSObject
     * @param name of the ADLSObject
     * @return the updated ADLSObject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a ADLSObject.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ADLSObject
     * @param name of the ADLSObject
     * @return the updated ADLSObject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSObject) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a ADLSObject.
     *
     * @param qualifiedName of the ADLSObject
     * @param name of the ADLSObject
     * @return the updated ADLSObject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a ADLSObject.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ADLSObject
     * @param name of the ADLSObject
     * @return the updated ADLSObject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSObject) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a ADLSObject.
     *
     * @param qualifiedName of the ADLSObject
     * @param name of the ADLSObject
     * @return the updated ADLSObject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a ADLSObject.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ADLSObject's owners
     * @param qualifiedName of the ADLSObject
     * @param name of the ADLSObject
     * @return the updated ADLSObject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSObject) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a ADLSObject.
     *
     * @param qualifiedName of the ADLSObject
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ADLSObject, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a ADLSObject.
     *
     * @param client connectivity to the Atlan tenant on which to update the ADLSObject's certificate
     * @param qualifiedName of the ADLSObject
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ADLSObject, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ADLSObject) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a ADLSObject.
     *
     * @param qualifiedName of the ADLSObject
     * @param name of the ADLSObject
     * @return the updated ADLSObject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a ADLSObject.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ADLSObject's certificate
     * @param qualifiedName of the ADLSObject
     * @param name of the ADLSObject
     * @return the updated ADLSObject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSObject) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a ADLSObject.
     *
     * @param qualifiedName of the ADLSObject
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a ADLSObject.
     *
     * @param client connectivity to the Atlan tenant on which to update the ADLSObject's announcement
     * @param qualifiedName of the ADLSObject
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ADLSObject) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a ADLSObject.
     *
     * @param qualifiedName of the ADLSObject
     * @param name of the ADLSObject
     * @return the updated ADLSObject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a ADLSObject.
     *
     * @param client connectivity to the Atlan client from which to remove the ADLSObject's announcement
     * @param qualifiedName of the ADLSObject
     * @param name of the ADLSObject
     * @return the updated ADLSObject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ADLSObject removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSObject) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the ADLSObject.
     *
     * @param qualifiedName for the ADLSObject
     * @param name human-readable name of the ADLSObject
     * @param terms the list of terms to replace on the ADLSObject, or null to remove all terms from the ADLSObject
     * @return the ADLSObject that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ADLSObject replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the ADLSObject.
     *
     * @param client connectivity to the Atlan tenant on which to replace the ADLSObject's assigned terms
     * @param qualifiedName for the ADLSObject
     * @param name human-readable name of the ADLSObject
     * @param terms the list of terms to replace on the ADLSObject, or null to remove all terms from the ADLSObject
     * @return the ADLSObject that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ADLSObject replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ADLSObject) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the ADLSObject, without replacing existing terms linked to the ADLSObject.
     * Note: this operation must make two API calls — one to retrieve the ADLSObject's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the ADLSObject
     * @param terms the list of terms to append to the ADLSObject
     * @return the ADLSObject that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ADLSObject appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the ADLSObject, without replacing existing terms linked to the ADLSObject.
     * Note: this operation must make two API calls — one to retrieve the ADLSObject's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the ADLSObject
     * @param qualifiedName for the ADLSObject
     * @param terms the list of terms to append to the ADLSObject
     * @return the ADLSObject that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ADLSObject appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ADLSObject) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a ADLSObject, without replacing all existing terms linked to the ADLSObject.
     * Note: this operation must make two API calls — one to retrieve the ADLSObject's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the ADLSObject
     * @param terms the list of terms to remove from the ADLSObject, which must be referenced by GUID
     * @return the ADLSObject that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ADLSObject removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a ADLSObject, without replacing all existing terms linked to the ADLSObject.
     * Note: this operation must make two API calls — one to retrieve the ADLSObject's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the ADLSObject
     * @param qualifiedName for the ADLSObject
     * @param terms the list of terms to remove from the ADLSObject, which must be referenced by GUID
     * @return the ADLSObject that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ADLSObject removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ADLSObject) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a ADLSObject, without replacing existing Atlan tags linked to the ADLSObject.
     * Note: this operation must make two API calls — one to retrieve the ADLSObject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ADLSObject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ADLSObject
     */
    public static ADLSObject appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ADLSObject, without replacing existing Atlan tags linked to the ADLSObject.
     * Note: this operation must make two API calls — one to retrieve the ADLSObject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ADLSObject
     * @param qualifiedName of the ADLSObject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ADLSObject
     */
    public static ADLSObject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ADLSObject) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ADLSObject, without replacing existing Atlan tags linked to the ADLSObject.
     * Note: this operation must make two API calls — one to retrieve the ADLSObject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ADLSObject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ADLSObject
     */
    public static ADLSObject appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a ADLSObject, without replacing existing Atlan tags linked to the ADLSObject.
     * Note: this operation must make two API calls — one to retrieve the ADLSObject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ADLSObject
     * @param qualifiedName of the ADLSObject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ADLSObject
     */
    public static ADLSObject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ADLSObject) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a ADLSObject.
     *
     * @param qualifiedName of the ADLSObject
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ADLSObject
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a ADLSObject.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a ADLSObject
     * @param qualifiedName of the ADLSObject
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ADLSObject
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class ADLSObjectBuilder<C extends ADLSObject, B extends ADLSObject.ADLSObjectBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String adlsAccountQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String adlsAccountSecondaryLocation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IADLSContainer adlsContainer;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String adlsContainerQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ADLSAccessTier adlsObjectAccessTier;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long adlsObjectAccessTierLastModifiedTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ADLSObjectArchiveStatus adlsObjectArchiveStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String adlsObjectCacheControl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String adlsObjectContentLanguage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String adlsObjectContentMD5Hash;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String adlsObjectContentType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ADLSLeaseState adlsObjectLeaseState;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ADLSLeaseStatus adlsObjectLeaseStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> adlsObjectMetadata$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> adlsObjectMetadata$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean adlsObjectServerEncrypted;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long adlsObjectSize;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ADLSObjectType adlsObjectType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String adlsObjectUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String adlsObjectVersionId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean adlsObjectVersionLevelImmutabilitySupport;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String azureLocation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String azureResourceId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AzureTag> azureTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            ADLSObject.ADLSObjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final ADLSObject instance, final ADLSObject.ADLSObjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.adlsAccountQualifiedName(instance.adlsAccountQualifiedName);
            b.adlsAccountSecondaryLocation(instance.adlsAccountSecondaryLocation);
            b.adlsContainer(instance.adlsContainer);
            b.adlsContainerQualifiedName(instance.adlsContainerQualifiedName);
            b.adlsObjectAccessTier(instance.adlsObjectAccessTier);
            b.adlsObjectAccessTierLastModifiedTime(instance.adlsObjectAccessTierLastModifiedTime);
            b.adlsObjectArchiveStatus(instance.adlsObjectArchiveStatus);
            b.adlsObjectCacheControl(instance.adlsObjectCacheControl);
            b.adlsObjectContentLanguage(instance.adlsObjectContentLanguage);
            b.adlsObjectContentMD5Hash(instance.adlsObjectContentMD5Hash);
            b.adlsObjectContentType(instance.adlsObjectContentType);
            b.adlsObjectLeaseState(instance.adlsObjectLeaseState);
            b.adlsObjectLeaseStatus(instance.adlsObjectLeaseStatus);
            b.adlsObjectMetadata(instance.adlsObjectMetadata == null ? java.util.Collections.<String, String>emptyMap() : instance.adlsObjectMetadata);
            b.adlsObjectServerEncrypted(instance.adlsObjectServerEncrypted);
            b.adlsObjectSize(instance.adlsObjectSize);
            b.adlsObjectType(instance.adlsObjectType);
            b.adlsObjectUrl(instance.adlsObjectUrl);
            b.adlsObjectVersionId(instance.adlsObjectVersionId);
            b.adlsObjectVersionLevelImmutabilitySupport(instance.adlsObjectVersionLevelImmutabilitySupport);
            b.azureLocation(instance.azureLocation);
            b.azureResourceId(instance.azureResourceId);
            b.azureTags(instance.azureTags == null ? java.util.Collections.<AzureTag>emptyList() : instance.azureTags);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for ADLSObjects.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Unique name of the account for this ADLS asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsAccountQualifiedName(final String adlsAccountQualifiedName) {
            this.adlsAccountQualifiedName = adlsAccountQualifiedName;
            return self();
        }

        /**
         * Secondary location of the ADLS account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsAccountSecondaryLocation(final String adlsAccountSecondaryLocation) {
            this.adlsAccountSecondaryLocation = adlsAccountSecondaryLocation;
            return self();
        }

        /**
         * Container this object exists within.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsContainer(final IADLSContainer adlsContainer) {
            this.adlsContainer = adlsContainer;
            return self();
        }

        /**
         * Unique name of the container this object exists within.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsContainerQualifiedName(final String adlsContainerQualifiedName) {
            this.adlsContainerQualifiedName = adlsContainerQualifiedName;
            return self();
        }

        /**
         * Access tier of this object.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectAccessTier(final ADLSAccessTier adlsObjectAccessTier) {
            this.adlsObjectAccessTier = adlsObjectAccessTier;
            return self();
        }

        /**
         * Time (epoch) when the acccess tier for this object was last modified, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectAccessTierLastModifiedTime(final Long adlsObjectAccessTierLastModifiedTime) {
            this.adlsObjectAccessTierLastModifiedTime = adlsObjectAccessTierLastModifiedTime;
            return self();
        }

        /**
         * Archive status of this object.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectArchiveStatus(final ADLSObjectArchiveStatus adlsObjectArchiveStatus) {
            this.adlsObjectArchiveStatus = adlsObjectArchiveStatus;
            return self();
        }

        /**
         * Cache control of this object.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectCacheControl(final String adlsObjectCacheControl) {
            this.adlsObjectCacheControl = adlsObjectCacheControl;
            return self();
        }

        /**
         * Language of this object's contents.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectContentLanguage(final String adlsObjectContentLanguage) {
            this.adlsObjectContentLanguage = adlsObjectContentLanguage;
            return self();
        }

        /**
         * MD5 hash of this object's contents.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectContentMD5Hash(final String adlsObjectContentMD5Hash) {
            this.adlsObjectContentMD5Hash = adlsObjectContentMD5Hash;
            return self();
        }

        /**
         * Content type of this object.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectContentType(final String adlsObjectContentType) {
            this.adlsObjectContentType = adlsObjectContentType;
            return self();
        }

        /**
         * State of this object's lease.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectLeaseState(final ADLSLeaseState adlsObjectLeaseState) {
            this.adlsObjectLeaseState = adlsObjectLeaseState;
            return self();
        }

        /**
         * Status of this object's lease.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectLeaseStatus(final ADLSLeaseStatus adlsObjectLeaseStatus) {
            this.adlsObjectLeaseStatus = adlsObjectLeaseStatus;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putAdlsObjectMetadata(final String putAdlsObjectMetadataKey, final String putAdlsObjectMetadataValue) {
            if (this.adlsObjectMetadata$key == null) {
                this.adlsObjectMetadata$key = new java.util.ArrayList<String>();
                this.adlsObjectMetadata$value = new java.util.ArrayList<String>();
            }
            this.adlsObjectMetadata$key.add(putAdlsObjectMetadataKey);
            this.adlsObjectMetadata$value.add(putAdlsObjectMetadataValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectMetadata(final java.util.Map<? extends String, ? extends String> adlsObjectMetadata) {
            if (adlsObjectMetadata == null) {
                throw new java.lang.NullPointerException("adlsObjectMetadata cannot be null");
            }
            if (this.adlsObjectMetadata$key == null) {
                this.adlsObjectMetadata$key = new java.util.ArrayList<String>();
                this.adlsObjectMetadata$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : adlsObjectMetadata.entrySet()) {
                this.adlsObjectMetadata$key.add($lombokEntry.getKey());
                this.adlsObjectMetadata$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAdlsObjectMetadata() {
            if (this.adlsObjectMetadata$key != null) {
                this.adlsObjectMetadata$key.clear();
                this.adlsObjectMetadata$value.clear();
            }
            return self();
        }

        /**
         * Whether this object is server encrypted (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectServerEncrypted(final Boolean adlsObjectServerEncrypted) {
            this.adlsObjectServerEncrypted = adlsObjectServerEncrypted;
            return self();
        }

        /**
         * Size of this object.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectSize(final Long adlsObjectSize) {
            this.adlsObjectSize = adlsObjectSize;
            return self();
        }

        /**
         * Type of this object.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectType(final ADLSObjectType adlsObjectType) {
            this.adlsObjectType = adlsObjectType;
            return self();
        }

        /**
         * URL of this object.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectUrl(final String adlsObjectUrl) {
            this.adlsObjectUrl = adlsObjectUrl;
            return self();
        }

        /**
         * Identifier of the version of this object, from ADLS.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectVersionId(final String adlsObjectVersionId) {
            this.adlsObjectVersionId = adlsObjectVersionId;
            return self();
        }

        /**
         * Whether this object supports version-level immutability (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adlsObjectVersionLevelImmutabilitySupport(final Boolean adlsObjectVersionLevelImmutabilitySupport) {
            this.adlsObjectVersionLevelImmutabilitySupport = adlsObjectVersionLevelImmutabilitySupport;
            return self();
        }

        /**
         * Location of this asset in Azure.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B azureLocation(final String azureLocation) {
            this.azureLocation = azureLocation;
            return self();
        }

        /**
         * Resource identifier of this asset in Azure.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B azureResourceId(final String azureResourceId) {
            this.azureResourceId = azureResourceId;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B azureTag(final AzureTag azureTag) {
            if (this.azureTags == null) this.azureTags = new java.util.ArrayList<AzureTag>();
            this.azureTags.add(azureTag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B azureTags(final java.util.Collection<? extends AzureTag> azureTags) {
            if (azureTags == null) {
                throw new java.lang.NullPointerException("azureTags cannot be null");
            }
            if (this.azureTags == null) this.azureTags = new java.util.ArrayList<AzureTag>();
            this.azureTags.addAll(azureTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAzureTags() {
            if (this.azureTags != null) this.azureTags.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ADLSObject.ADLSObjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", adlsAccountQualifiedName=" + this.adlsAccountQualifiedName + ", adlsAccountSecondaryLocation=" + this.adlsAccountSecondaryLocation + ", adlsContainer=" + this.adlsContainer + ", adlsContainerQualifiedName=" + this.adlsContainerQualifiedName + ", adlsObjectAccessTier=" + this.adlsObjectAccessTier + ", adlsObjectAccessTierLastModifiedTime=" + this.adlsObjectAccessTierLastModifiedTime + ", adlsObjectArchiveStatus=" + this.adlsObjectArchiveStatus + ", adlsObjectCacheControl=" + this.adlsObjectCacheControl + ", adlsObjectContentLanguage=" + this.adlsObjectContentLanguage + ", adlsObjectContentMD5Hash=" + this.adlsObjectContentMD5Hash + ", adlsObjectContentType=" + this.adlsObjectContentType + ", adlsObjectLeaseState=" + this.adlsObjectLeaseState + ", adlsObjectLeaseStatus=" + this.adlsObjectLeaseStatus + ", adlsObjectMetadata$key=" + this.adlsObjectMetadata$key + ", adlsObjectMetadata$value=" + this.adlsObjectMetadata$value + ", adlsObjectServerEncrypted=" + this.adlsObjectServerEncrypted + ", adlsObjectSize=" + this.adlsObjectSize + ", adlsObjectType=" + this.adlsObjectType + ", adlsObjectUrl=" + this.adlsObjectUrl + ", adlsObjectVersionId=" + this.adlsObjectVersionId + ", adlsObjectVersionLevelImmutabilitySupport=" + this.adlsObjectVersionLevelImmutabilitySupport + ", azureLocation=" + this.azureLocation + ", azureResourceId=" + this.azureResourceId + ", azureTags=" + this.azureTags + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class ADLSObjectBuilderImpl extends ADLSObject.ADLSObjectBuilder<ADLSObject, ADLSObject.ADLSObjectBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ADLSObjectBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected ADLSObject.ADLSObjectBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ADLSObject build() {
            return new ADLSObject(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected ADLSObject(final ADLSObject.ADLSObjectBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = ADLSObject.$default$typeName();
        this.adlsAccountQualifiedName = b.adlsAccountQualifiedName;
        this.adlsAccountSecondaryLocation = b.adlsAccountSecondaryLocation;
        this.adlsContainer = b.adlsContainer;
        this.adlsContainerQualifiedName = b.adlsContainerQualifiedName;
        this.adlsObjectAccessTier = b.adlsObjectAccessTier;
        this.adlsObjectAccessTierLastModifiedTime = b.adlsObjectAccessTierLastModifiedTime;
        this.adlsObjectArchiveStatus = b.adlsObjectArchiveStatus;
        this.adlsObjectCacheControl = b.adlsObjectCacheControl;
        this.adlsObjectContentLanguage = b.adlsObjectContentLanguage;
        this.adlsObjectContentMD5Hash = b.adlsObjectContentMD5Hash;
        this.adlsObjectContentType = b.adlsObjectContentType;
        this.adlsObjectLeaseState = b.adlsObjectLeaseState;
        this.adlsObjectLeaseStatus = b.adlsObjectLeaseStatus;
        java.util.Map<String, String> adlsObjectMetadata;
        switch (b.adlsObjectMetadata$key == null ? 0 : b.adlsObjectMetadata$key.size()) {
        case 0: 
            adlsObjectMetadata = java.util.Collections.emptyMap();
            break;
        case 1: 
            adlsObjectMetadata = java.util.Collections.singletonMap(b.adlsObjectMetadata$key.get(0), b.adlsObjectMetadata$value.get(0));
            break;
        default: 
            adlsObjectMetadata = new java.util.LinkedHashMap<String, String>(b.adlsObjectMetadata$key.size() < 1073741824 ? 1 + b.adlsObjectMetadata$key.size() + (b.adlsObjectMetadata$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.adlsObjectMetadata$key.size(); $i++) adlsObjectMetadata.put(b.adlsObjectMetadata$key.get($i), (String) b.adlsObjectMetadata$value.get($i));
            adlsObjectMetadata = java.util.Collections.unmodifiableMap(adlsObjectMetadata);
        }
        this.adlsObjectMetadata = adlsObjectMetadata;
        this.adlsObjectServerEncrypted = b.adlsObjectServerEncrypted;
        this.adlsObjectSize = b.adlsObjectSize;
        this.adlsObjectType = b.adlsObjectType;
        this.adlsObjectUrl = b.adlsObjectUrl;
        this.adlsObjectVersionId = b.adlsObjectVersionId;
        this.adlsObjectVersionLevelImmutabilitySupport = b.adlsObjectVersionLevelImmutabilitySupport;
        this.azureLocation = b.azureLocation;
        this.azureResourceId = b.azureResourceId;
        java.util.List<AzureTag> azureTags;
        switch (b.azureTags == null ? 0 : b.azureTags.size()) {
        case 0: 
            azureTags = java.util.Collections.emptyList();
            break;
        case 1: 
            azureTags = java.util.Collections.singletonList(b.azureTags.get(0));
            break;
        default: 
            azureTags = java.util.Collections.unmodifiableList(new java.util.ArrayList<AzureTag>(b.azureTags));
        }
        this.azureTags = azureTags;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ADLSObject.ADLSObjectBuilder<?, ?> _internal() {
        return new ADLSObject.ADLSObjectBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ADLSObject.ADLSObjectBuilder<?, ?> toBuilder() {
        return new ADLSObject.ADLSObjectBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Unique name of the account for this ADLS asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAdlsAccountQualifiedName() {
        return this.adlsAccountQualifiedName;
    }

    /**
     * Secondary location of the ADLS account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAdlsAccountSecondaryLocation() {
        return this.adlsAccountSecondaryLocation;
    }

    /**
     * Container this object exists within.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IADLSContainer getAdlsContainer() {
        return this.adlsContainer;
    }

    /**
     * Unique name of the container this object exists within.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAdlsContainerQualifiedName() {
        return this.adlsContainerQualifiedName;
    }

    /**
     * Access tier of this object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ADLSAccessTier getAdlsObjectAccessTier() {
        return this.adlsObjectAccessTier;
    }

    /**
     * Time (epoch) when the acccess tier for this object was last modified, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAdlsObjectAccessTierLastModifiedTime() {
        return this.adlsObjectAccessTierLastModifiedTime;
    }

    /**
     * Archive status of this object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ADLSObjectArchiveStatus getAdlsObjectArchiveStatus() {
        return this.adlsObjectArchiveStatus;
    }

    /**
     * Cache control of this object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAdlsObjectCacheControl() {
        return this.adlsObjectCacheControl;
    }

    /**
     * Language of this object's contents.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAdlsObjectContentLanguage() {
        return this.adlsObjectContentLanguage;
    }

    /**
     * MD5 hash of this object's contents.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAdlsObjectContentMD5Hash() {
        return this.adlsObjectContentMD5Hash;
    }

    /**
     * Content type of this object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAdlsObjectContentType() {
        return this.adlsObjectContentType;
    }

    /**
     * State of this object's lease.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ADLSLeaseState getAdlsObjectLeaseState() {
        return this.adlsObjectLeaseState;
    }

    /**
     * Status of this object's lease.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ADLSLeaseStatus getAdlsObjectLeaseStatus() {
        return this.adlsObjectLeaseStatus;
    }

    /**
     * Metadata associated with this object, from ADLS.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getAdlsObjectMetadata() {
        return this.adlsObjectMetadata;
    }

    /**
     * Whether this object is server encrypted (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAdlsObjectServerEncrypted() {
        return this.adlsObjectServerEncrypted;
    }

    /**
     * Size of this object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAdlsObjectSize() {
        return this.adlsObjectSize;
    }

    /**
     * Type of this object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ADLSObjectType getAdlsObjectType() {
        return this.adlsObjectType;
    }

    /**
     * URL of this object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAdlsObjectUrl() {
        return this.adlsObjectUrl;
    }

    /**
     * Identifier of the version of this object, from ADLS.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAdlsObjectVersionId() {
        return this.adlsObjectVersionId;
    }

    /**
     * Whether this object supports version-level immutability (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAdlsObjectVersionLevelImmutabilitySupport() {
        return this.adlsObjectVersionLevelImmutabilitySupport;
    }

    /**
     * Location of this asset in Azure.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAzureLocation() {
        return this.azureLocation;
    }

    /**
     * Resource identifier of this asset in Azure.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAzureResourceId() {
        return this.azureResourceId;
    }

    /**
     * Tags that have been applied to this asset in Azure.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<AzureTag> getAzureTags() {
        return this.azureTags;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ADLSObject)) return false;
        final ADLSObject other = (ADLSObject) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$adlsObjectAccessTierLastModifiedTime = this.getAdlsObjectAccessTierLastModifiedTime();
        final java.lang.Object other$adlsObjectAccessTierLastModifiedTime = other.getAdlsObjectAccessTierLastModifiedTime();
        if (this$adlsObjectAccessTierLastModifiedTime == null ? other$adlsObjectAccessTierLastModifiedTime != null : !this$adlsObjectAccessTierLastModifiedTime.equals(other$adlsObjectAccessTierLastModifiedTime)) return false;
        final java.lang.Object this$adlsObjectServerEncrypted = this.getAdlsObjectServerEncrypted();
        final java.lang.Object other$adlsObjectServerEncrypted = other.getAdlsObjectServerEncrypted();
        if (this$adlsObjectServerEncrypted == null ? other$adlsObjectServerEncrypted != null : !this$adlsObjectServerEncrypted.equals(other$adlsObjectServerEncrypted)) return false;
        final java.lang.Object this$adlsObjectSize = this.getAdlsObjectSize();
        final java.lang.Object other$adlsObjectSize = other.getAdlsObjectSize();
        if (this$adlsObjectSize == null ? other$adlsObjectSize != null : !this$adlsObjectSize.equals(other$adlsObjectSize)) return false;
        final java.lang.Object this$adlsObjectVersionLevelImmutabilitySupport = this.getAdlsObjectVersionLevelImmutabilitySupport();
        final java.lang.Object other$adlsObjectVersionLevelImmutabilitySupport = other.getAdlsObjectVersionLevelImmutabilitySupport();
        if (this$adlsObjectVersionLevelImmutabilitySupport == null ? other$adlsObjectVersionLevelImmutabilitySupport != null : !this$adlsObjectVersionLevelImmutabilitySupport.equals(other$adlsObjectVersionLevelImmutabilitySupport)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$adlsAccountQualifiedName = this.getAdlsAccountQualifiedName();
        final java.lang.Object other$adlsAccountQualifiedName = other.getAdlsAccountQualifiedName();
        if (this$adlsAccountQualifiedName == null ? other$adlsAccountQualifiedName != null : !this$adlsAccountQualifiedName.equals(other$adlsAccountQualifiedName)) return false;
        final java.lang.Object this$adlsAccountSecondaryLocation = this.getAdlsAccountSecondaryLocation();
        final java.lang.Object other$adlsAccountSecondaryLocation = other.getAdlsAccountSecondaryLocation();
        if (this$adlsAccountSecondaryLocation == null ? other$adlsAccountSecondaryLocation != null : !this$adlsAccountSecondaryLocation.equals(other$adlsAccountSecondaryLocation)) return false;
        final java.lang.Object this$adlsContainer = this.getAdlsContainer();
        final java.lang.Object other$adlsContainer = other.getAdlsContainer();
        if (this$adlsContainer == null ? other$adlsContainer != null : !this$adlsContainer.equals(other$adlsContainer)) return false;
        final java.lang.Object this$adlsContainerQualifiedName = this.getAdlsContainerQualifiedName();
        final java.lang.Object other$adlsContainerQualifiedName = other.getAdlsContainerQualifiedName();
        if (this$adlsContainerQualifiedName == null ? other$adlsContainerQualifiedName != null : !this$adlsContainerQualifiedName.equals(other$adlsContainerQualifiedName)) return false;
        final java.lang.Object this$adlsObjectAccessTier = this.getAdlsObjectAccessTier();
        final java.lang.Object other$adlsObjectAccessTier = other.getAdlsObjectAccessTier();
        if (this$adlsObjectAccessTier == null ? other$adlsObjectAccessTier != null : !this$adlsObjectAccessTier.equals(other$adlsObjectAccessTier)) return false;
        final java.lang.Object this$adlsObjectArchiveStatus = this.getAdlsObjectArchiveStatus();
        final java.lang.Object other$adlsObjectArchiveStatus = other.getAdlsObjectArchiveStatus();
        if (this$adlsObjectArchiveStatus == null ? other$adlsObjectArchiveStatus != null : !this$adlsObjectArchiveStatus.equals(other$adlsObjectArchiveStatus)) return false;
        final java.lang.Object this$adlsObjectCacheControl = this.getAdlsObjectCacheControl();
        final java.lang.Object other$adlsObjectCacheControl = other.getAdlsObjectCacheControl();
        if (this$adlsObjectCacheControl == null ? other$adlsObjectCacheControl != null : !this$adlsObjectCacheControl.equals(other$adlsObjectCacheControl)) return false;
        final java.lang.Object this$adlsObjectContentLanguage = this.getAdlsObjectContentLanguage();
        final java.lang.Object other$adlsObjectContentLanguage = other.getAdlsObjectContentLanguage();
        if (this$adlsObjectContentLanguage == null ? other$adlsObjectContentLanguage != null : !this$adlsObjectContentLanguage.equals(other$adlsObjectContentLanguage)) return false;
        final java.lang.Object this$adlsObjectContentMD5Hash = this.getAdlsObjectContentMD5Hash();
        final java.lang.Object other$adlsObjectContentMD5Hash = other.getAdlsObjectContentMD5Hash();
        if (this$adlsObjectContentMD5Hash == null ? other$adlsObjectContentMD5Hash != null : !this$adlsObjectContentMD5Hash.equals(other$adlsObjectContentMD5Hash)) return false;
        final java.lang.Object this$adlsObjectContentType = this.getAdlsObjectContentType();
        final java.lang.Object other$adlsObjectContentType = other.getAdlsObjectContentType();
        if (this$adlsObjectContentType == null ? other$adlsObjectContentType != null : !this$adlsObjectContentType.equals(other$adlsObjectContentType)) return false;
        final java.lang.Object this$adlsObjectLeaseState = this.getAdlsObjectLeaseState();
        final java.lang.Object other$adlsObjectLeaseState = other.getAdlsObjectLeaseState();
        if (this$adlsObjectLeaseState == null ? other$adlsObjectLeaseState != null : !this$adlsObjectLeaseState.equals(other$adlsObjectLeaseState)) return false;
        final java.lang.Object this$adlsObjectLeaseStatus = this.getAdlsObjectLeaseStatus();
        final java.lang.Object other$adlsObjectLeaseStatus = other.getAdlsObjectLeaseStatus();
        if (this$adlsObjectLeaseStatus == null ? other$adlsObjectLeaseStatus != null : !this$adlsObjectLeaseStatus.equals(other$adlsObjectLeaseStatus)) return false;
        final java.lang.Object this$adlsObjectMetadata = this.getAdlsObjectMetadata();
        final java.lang.Object other$adlsObjectMetadata = other.getAdlsObjectMetadata();
        if (this$adlsObjectMetadata == null ? other$adlsObjectMetadata != null : !this$adlsObjectMetadata.equals(other$adlsObjectMetadata)) return false;
        final java.lang.Object this$adlsObjectType = this.getAdlsObjectType();
        final java.lang.Object other$adlsObjectType = other.getAdlsObjectType();
        if (this$adlsObjectType == null ? other$adlsObjectType != null : !this$adlsObjectType.equals(other$adlsObjectType)) return false;
        final java.lang.Object this$adlsObjectUrl = this.getAdlsObjectUrl();
        final java.lang.Object other$adlsObjectUrl = other.getAdlsObjectUrl();
        if (this$adlsObjectUrl == null ? other$adlsObjectUrl != null : !this$adlsObjectUrl.equals(other$adlsObjectUrl)) return false;
        final java.lang.Object this$adlsObjectVersionId = this.getAdlsObjectVersionId();
        final java.lang.Object other$adlsObjectVersionId = other.getAdlsObjectVersionId();
        if (this$adlsObjectVersionId == null ? other$adlsObjectVersionId != null : !this$adlsObjectVersionId.equals(other$adlsObjectVersionId)) return false;
        final java.lang.Object this$azureLocation = this.getAzureLocation();
        final java.lang.Object other$azureLocation = other.getAzureLocation();
        if (this$azureLocation == null ? other$azureLocation != null : !this$azureLocation.equals(other$azureLocation)) return false;
        final java.lang.Object this$azureResourceId = this.getAzureResourceId();
        final java.lang.Object other$azureResourceId = other.getAzureResourceId();
        if (this$azureResourceId == null ? other$azureResourceId != null : !this$azureResourceId.equals(other$azureResourceId)) return false;
        final java.lang.Object this$azureTags = this.getAzureTags();
        final java.lang.Object other$azureTags = other.getAzureTags();
        if (this$azureTags == null ? other$azureTags != null : !this$azureTags.equals(other$azureTags)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ADLSObject;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $adlsObjectAccessTierLastModifiedTime = this.getAdlsObjectAccessTierLastModifiedTime();
        result = result * PRIME + ($adlsObjectAccessTierLastModifiedTime == null ? 43 : $adlsObjectAccessTierLastModifiedTime.hashCode());
        final java.lang.Object $adlsObjectServerEncrypted = this.getAdlsObjectServerEncrypted();
        result = result * PRIME + ($adlsObjectServerEncrypted == null ? 43 : $adlsObjectServerEncrypted.hashCode());
        final java.lang.Object $adlsObjectSize = this.getAdlsObjectSize();
        result = result * PRIME + ($adlsObjectSize == null ? 43 : $adlsObjectSize.hashCode());
        final java.lang.Object $adlsObjectVersionLevelImmutabilitySupport = this.getAdlsObjectVersionLevelImmutabilitySupport();
        result = result * PRIME + ($adlsObjectVersionLevelImmutabilitySupport == null ? 43 : $adlsObjectVersionLevelImmutabilitySupport.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $adlsAccountQualifiedName = this.getAdlsAccountQualifiedName();
        result = result * PRIME + ($adlsAccountQualifiedName == null ? 43 : $adlsAccountQualifiedName.hashCode());
        final java.lang.Object $adlsAccountSecondaryLocation = this.getAdlsAccountSecondaryLocation();
        result = result * PRIME + ($adlsAccountSecondaryLocation == null ? 43 : $adlsAccountSecondaryLocation.hashCode());
        final java.lang.Object $adlsContainer = this.getAdlsContainer();
        result = result * PRIME + ($adlsContainer == null ? 43 : $adlsContainer.hashCode());
        final java.lang.Object $adlsContainerQualifiedName = this.getAdlsContainerQualifiedName();
        result = result * PRIME + ($adlsContainerQualifiedName == null ? 43 : $adlsContainerQualifiedName.hashCode());
        final java.lang.Object $adlsObjectAccessTier = this.getAdlsObjectAccessTier();
        result = result * PRIME + ($adlsObjectAccessTier == null ? 43 : $adlsObjectAccessTier.hashCode());
        final java.lang.Object $adlsObjectArchiveStatus = this.getAdlsObjectArchiveStatus();
        result = result * PRIME + ($adlsObjectArchiveStatus == null ? 43 : $adlsObjectArchiveStatus.hashCode());
        final java.lang.Object $adlsObjectCacheControl = this.getAdlsObjectCacheControl();
        result = result * PRIME + ($adlsObjectCacheControl == null ? 43 : $adlsObjectCacheControl.hashCode());
        final java.lang.Object $adlsObjectContentLanguage = this.getAdlsObjectContentLanguage();
        result = result * PRIME + ($adlsObjectContentLanguage == null ? 43 : $adlsObjectContentLanguage.hashCode());
        final java.lang.Object $adlsObjectContentMD5Hash = this.getAdlsObjectContentMD5Hash();
        result = result * PRIME + ($adlsObjectContentMD5Hash == null ? 43 : $adlsObjectContentMD5Hash.hashCode());
        final java.lang.Object $adlsObjectContentType = this.getAdlsObjectContentType();
        result = result * PRIME + ($adlsObjectContentType == null ? 43 : $adlsObjectContentType.hashCode());
        final java.lang.Object $adlsObjectLeaseState = this.getAdlsObjectLeaseState();
        result = result * PRIME + ($adlsObjectLeaseState == null ? 43 : $adlsObjectLeaseState.hashCode());
        final java.lang.Object $adlsObjectLeaseStatus = this.getAdlsObjectLeaseStatus();
        result = result * PRIME + ($adlsObjectLeaseStatus == null ? 43 : $adlsObjectLeaseStatus.hashCode());
        final java.lang.Object $adlsObjectMetadata = this.getAdlsObjectMetadata();
        result = result * PRIME + ($adlsObjectMetadata == null ? 43 : $adlsObjectMetadata.hashCode());
        final java.lang.Object $adlsObjectType = this.getAdlsObjectType();
        result = result * PRIME + ($adlsObjectType == null ? 43 : $adlsObjectType.hashCode());
        final java.lang.Object $adlsObjectUrl = this.getAdlsObjectUrl();
        result = result * PRIME + ($adlsObjectUrl == null ? 43 : $adlsObjectUrl.hashCode());
        final java.lang.Object $adlsObjectVersionId = this.getAdlsObjectVersionId();
        result = result * PRIME + ($adlsObjectVersionId == null ? 43 : $adlsObjectVersionId.hashCode());
        final java.lang.Object $azureLocation = this.getAzureLocation();
        result = result * PRIME + ($azureLocation == null ? 43 : $azureLocation.hashCode());
        final java.lang.Object $azureResourceId = this.getAzureResourceId();
        result = result * PRIME + ($azureResourceId == null ? 43 : $azureResourceId.hashCode());
        final java.lang.Object $azureTags = this.getAzureTags();
        result = result * PRIME + ($azureTags == null ? 43 : $azureTags.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ADLSObject(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", adlsAccountQualifiedName=" + this.getAdlsAccountQualifiedName() + ", adlsAccountSecondaryLocation=" + this.getAdlsAccountSecondaryLocation() + ", adlsContainer=" + this.getAdlsContainer() + ", adlsContainerQualifiedName=" + this.getAdlsContainerQualifiedName() + ", adlsObjectAccessTier=" + this.getAdlsObjectAccessTier() + ", adlsObjectAccessTierLastModifiedTime=" + this.getAdlsObjectAccessTierLastModifiedTime() + ", adlsObjectArchiveStatus=" + this.getAdlsObjectArchiveStatus() + ", adlsObjectCacheControl=" + this.getAdlsObjectCacheControl() + ", adlsObjectContentLanguage=" + this.getAdlsObjectContentLanguage() + ", adlsObjectContentMD5Hash=" + this.getAdlsObjectContentMD5Hash() + ", adlsObjectContentType=" + this.getAdlsObjectContentType() + ", adlsObjectLeaseState=" + this.getAdlsObjectLeaseState() + ", adlsObjectLeaseStatus=" + this.getAdlsObjectLeaseStatus() + ", adlsObjectMetadata=" + this.getAdlsObjectMetadata() + ", adlsObjectServerEncrypted=" + this.getAdlsObjectServerEncrypted() + ", adlsObjectSize=" + this.getAdlsObjectSize() + ", adlsObjectType=" + this.getAdlsObjectType() + ", adlsObjectUrl=" + this.getAdlsObjectUrl() + ", adlsObjectVersionId=" + this.getAdlsObjectVersionId() + ", adlsObjectVersionLevelImmutabilitySupport=" + this.getAdlsObjectVersionLevelImmutabilitySupport() + ", azureLocation=" + this.getAzureLocation() + ", azureResourceId=" + this.getAzureResourceId() + ", azureTags=" + this.getAzureTags() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for ADLSObjects.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
