// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of an API path that could contain one or more endpoints in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class APIPath extends Asset implements IAPIPath, IAPI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(APIPath.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "APIPath";
    /**
     * Fixed typeName for APIPaths.
     */
    String typeName;
    /**
     * External documentation of the API.
     */
    @Attribute
    Map<String, String> apiExternalDocs;
    /**
     * Whether authentication is optional (true) or required (false).
     */
    @Attribute
    Boolean apiIsAuthOptional;
    /**
     * List of the operations available on the endpoint.
     */
    @Attribute
    SortedSet<String> apiPathAvailableOperations;
    /**
     * Response codes available on the path across all operations.
     */
    @Attribute
    Map<String, String> apiPathAvailableResponseCodes;
    /**
     * Whether the path is exposed as an ingress (true) or not (false).
     */
    @Attribute
    Boolean apiPathIsIngressExposed;
    /**
     * Whether the endpoint's path contains replaceable parameters (true) or not (false).
     */
    @Attribute
    Boolean apiPathIsTemplated;
    /**
     * Absolute path to an individual endpoint.
     */
    @Attribute
    String apiPathRawURI;
    /**
     * Descriptive summary intended to apply to all operations in this path.
     */
    @Attribute
    String apiPathSummary;
    /**
     * API specification in which this path exists.
     */
    @Attribute
    IAPISpec apiSpec;
    /**
     * Simple name of the API spec, if this asset is contained in an API spec.
     */
    @Attribute
    String apiSpecName;
    /**
     * Unique name of the API spec, if this asset is contained in an API spec.
     */
    @Attribute
    String apiSpecQualifiedName;
    /**
     * Type of API, for example: OpenAPI, GraphQL, etc.
     */
    @Attribute
    String apiSpecType;
    /**
     * Version of the API specification.
     */
    @Attribute
    String apiSpecVersion;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a APIPath, from a potentially
     * more-complete APIPath object.
     *
     * @return the minimal object necessary to relate to the APIPath
     * @throws InvalidRequestException if any of the minimal set of required properties for a APIPath relationship are not found in the initial object
     */
    @Override
    public APIPath trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all APIPath assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) APIPath assets will be included.
     *
     * @return a fluent search that includes all APIPath assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all APIPath assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) APIPath assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all APIPath assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all APIPath assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) APIPaths will be included
     * @return a fluent search that includes all APIPath assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all APIPath assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) APIPaths will be included
     * @return a fluent search that includes all APIPath assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a APIPath by GUID. Use this to create a relationship to this APIPath,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the APIPath to reference
     * @return reference to a APIPath that can be used for defining a relationship to a APIPath
     */
    public static APIPath refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a APIPath by GUID. Use this to create a relationship to this APIPath,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the APIPath to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a APIPath that can be used for defining a relationship to a APIPath
     */
    public static APIPath refByGuid(String guid, Reference.SaveSemantic semantic) {
        return APIPath._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a APIPath by qualifiedName. Use this to create a relationship to this APIPath,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the APIPath to reference
     * @return reference to a APIPath that can be used for defining a relationship to a APIPath
     */
    public static APIPath refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a APIPath by qualifiedName. Use this to create a relationship to this APIPath,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the APIPath to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a APIPath that can be used for defining a relationship to a APIPath
     */
    public static APIPath refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return APIPath._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a APIPath by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the APIPath to retrieve, either its GUID or its full qualifiedName
     * @return the requested full APIPath, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the APIPath does not exist or the provided GUID is not a APIPath
     */
    @JsonIgnore
    public static APIPath get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a APIPath by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the APIPath to retrieve, either its GUID or its full qualifiedName
     * @return the requested full APIPath, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the APIPath does not exist or the provided GUID is not a APIPath
     */
    @JsonIgnore
    public static APIPath get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a APIPath by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the APIPath to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full APIPath, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the APIPath does not exist or the provided GUID is not a APIPath
     */
    @JsonIgnore
    public static APIPath get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof APIPath) {
                return (APIPath) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof APIPath) {
                return (APIPath) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) APIPath to active.
     *
     * @param qualifiedName for the APIPath
     * @return true if the APIPath is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) APIPath to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the APIPath
     * @return true if the APIPath is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create an API path.
     *
     * @param name of the API path
     * @param apiSpec in which the API path should be created, which must have at least
     *                a qualifiedName
     * @return the minimal request necessary to create the API path, as a builder
     * @throws InvalidRequestException if the apiSpec provided is without a qualifiedName
     */
    public static APIPathBuilder<?, ?> creator(String name, APISpec apiSpec) throws InvalidRequestException {
        validateRelationship(APISpec.TYPE_NAME, Map.of("qualifiedName", apiSpec.getQualifiedName()));
        return creator(name, apiSpec.getQualifiedName()).apiSpec(apiSpec.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create an API path.
     *
     * @param pathURI unique URI of the API path
     * @param apiSpecQualifiedName unique name of the API spec through which the path is accessible
     * @return the minimal object necessary to create the API path, as a builder
     */
    public static APIPathBuilder<?, ?> creator(String pathURI, String apiSpecQualifiedName) {
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(apiSpecQualifiedName);
        String normalizedURI = pathURI.startsWith("/") ? pathURI : "/" + pathURI;
        return APIPath._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(apiSpecQualifiedName + normalizedURI).name(normalizedURI).apiPathRawURI(normalizedURI).apiSpec(APISpec.refByQualifiedName(apiSpecQualifiedName)).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.API);
    }

    /**
     * Builds the minimal object necessary to update a APIPath.
     *
     * @param qualifiedName of the APIPath
     * @param name of the APIPath
     * @return the minimal request necessary to update the APIPath, as a builder
     */
    public static APIPathBuilder<?, ?> updater(String qualifiedName, String name) {
        return APIPath._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a APIPath, from a potentially
     * more-complete APIPath object.
     *
     * @return the minimal object necessary to update the APIPath, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for APIPath are not found in the initial object
     */
    @Override
    public APIPathBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a APIPath.
     *
     * @param qualifiedName of the APIPath
     * @param name of the APIPath
     * @return the updated APIPath, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APIPath removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a APIPath.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the APIPath
     * @param name of the APIPath
     * @return the updated APIPath, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APIPath removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIPath) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a APIPath.
     *
     * @param qualifiedName of the APIPath
     * @param name of the APIPath
     * @return the updated APIPath, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APIPath removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a APIPath.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the APIPath
     * @param name of the APIPath
     * @return the updated APIPath, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APIPath removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIPath) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a APIPath.
     *
     * @param qualifiedName of the APIPath
     * @param name of the APIPath
     * @return the updated APIPath, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APIPath removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a APIPath.
     *
     * @param client connectivity to the Atlan tenant from which to remove the APIPath's owners
     * @param qualifiedName of the APIPath
     * @param name of the APIPath
     * @return the updated APIPath, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APIPath removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIPath) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a APIPath.
     *
     * @param qualifiedName of the APIPath
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated APIPath, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static APIPath updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a APIPath.
     *
     * @param client connectivity to the Atlan tenant on which to update the APIPath's certificate
     * @param qualifiedName of the APIPath
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated APIPath, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static APIPath updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (APIPath) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a APIPath.
     *
     * @param qualifiedName of the APIPath
     * @param name of the APIPath
     * @return the updated APIPath, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APIPath removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a APIPath.
     *
     * @param client connectivity to the Atlan tenant from which to remove the APIPath's certificate
     * @param qualifiedName of the APIPath
     * @param name of the APIPath
     * @return the updated APIPath, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APIPath removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIPath) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a APIPath.
     *
     * @param qualifiedName of the APIPath
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static APIPath updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a APIPath.
     *
     * @param client connectivity to the Atlan tenant on which to update the APIPath's announcement
     * @param qualifiedName of the APIPath
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static APIPath updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (APIPath) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a APIPath.
     *
     * @param qualifiedName of the APIPath
     * @param name of the APIPath
     * @return the updated APIPath, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APIPath removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a APIPath.
     *
     * @param client connectivity to the Atlan client from which to remove the APIPath's announcement
     * @param qualifiedName of the APIPath
     * @param name of the APIPath
     * @return the updated APIPath, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APIPath removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIPath) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the APIPath.
     *
     * @param qualifiedName for the APIPath
     * @param name human-readable name of the APIPath
     * @param terms the list of terms to replace on the APIPath, or null to remove all terms from the APIPath
     * @return the APIPath that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static APIPath replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the APIPath.
     *
     * @param client connectivity to the Atlan tenant on which to replace the APIPath's assigned terms
     * @param qualifiedName for the APIPath
     * @param name human-readable name of the APIPath
     * @param terms the list of terms to replace on the APIPath, or null to remove all terms from the APIPath
     * @return the APIPath that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static APIPath replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (APIPath) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the APIPath, without replacing existing terms linked to the APIPath.
     * Note: this operation must make two API calls — one to retrieve the APIPath's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the APIPath
     * @param terms the list of terms to append to the APIPath
     * @return the APIPath that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static APIPath appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the APIPath, without replacing existing terms linked to the APIPath.
     * Note: this operation must make two API calls — one to retrieve the APIPath's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the APIPath
     * @param qualifiedName for the APIPath
     * @param terms the list of terms to append to the APIPath
     * @return the APIPath that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static APIPath appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (APIPath) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a APIPath, without replacing all existing terms linked to the APIPath.
     * Note: this operation must make two API calls — one to retrieve the APIPath's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the APIPath
     * @param terms the list of terms to remove from the APIPath, which must be referenced by GUID
     * @return the APIPath that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static APIPath removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a APIPath, without replacing all existing terms linked to the APIPath.
     * Note: this operation must make two API calls — one to retrieve the APIPath's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the APIPath
     * @param qualifiedName for the APIPath
     * @param terms the list of terms to remove from the APIPath, which must be referenced by GUID
     * @return the APIPath that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static APIPath removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (APIPath) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a APIPath, without replacing existing Atlan tags linked to the APIPath.
     * Note: this operation must make two API calls — one to retrieve the APIPath's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the APIPath
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated APIPath
     */
    public static APIPath appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a APIPath, without replacing existing Atlan tags linked to the APIPath.
     * Note: this operation must make two API calls — one to retrieve the APIPath's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the APIPath
     * @param qualifiedName of the APIPath
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated APIPath
     */
    public static APIPath appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (APIPath) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a APIPath, without replacing existing Atlan tags linked to the APIPath.
     * Note: this operation must make two API calls — one to retrieve the APIPath's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the APIPath
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated APIPath
     */
    public static APIPath appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a APIPath, without replacing existing Atlan tags linked to the APIPath.
     * Note: this operation must make two API calls — one to retrieve the APIPath's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the APIPath
     * @param qualifiedName of the APIPath
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated APIPath
     */
    public static APIPath appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (APIPath) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a APIPath.
     *
     * @param qualifiedName of the APIPath
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the APIPath
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a APIPath.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a APIPath
     * @param qualifiedName of the APIPath
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the APIPath
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class APIPathBuilder<C extends APIPath, B extends APIPath.APIPathBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> apiExternalDocs$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> apiExternalDocs$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean apiIsAuthOptional;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> apiPathAvailableOperations;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> apiPathAvailableResponseCodes$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> apiPathAvailableResponseCodes$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean apiPathIsIngressExposed;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean apiPathIsTemplated;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiPathRawURI;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiPathSummary;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IAPISpec apiSpec;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            APIPath.APIPathBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final APIPath instance, final APIPath.APIPathBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.apiExternalDocs(instance.apiExternalDocs == null ? java.util.Collections.<String, String>emptyMap() : instance.apiExternalDocs);
            b.apiIsAuthOptional(instance.apiIsAuthOptional);
            b.apiPathAvailableOperations(instance.apiPathAvailableOperations == null ? java.util.Collections.<String>emptySortedSet() : instance.apiPathAvailableOperations);
            b.apiPathAvailableResponseCodes(instance.apiPathAvailableResponseCodes == null ? java.util.Collections.<String, String>emptyMap() : instance.apiPathAvailableResponseCodes);
            b.apiPathIsIngressExposed(instance.apiPathIsIngressExposed);
            b.apiPathIsTemplated(instance.apiPathIsTemplated);
            b.apiPathRawURI(instance.apiPathRawURI);
            b.apiPathSummary(instance.apiPathSummary);
            b.apiSpec(instance.apiSpec);
            b.apiSpecName(instance.apiSpecName);
            b.apiSpecQualifiedName(instance.apiSpecQualifiedName);
            b.apiSpecType(instance.apiSpecType);
            b.apiSpecVersion(instance.apiSpecVersion);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for APIPaths.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiExternalDoc(final String apiExternalDocKey, final String apiExternalDocValue) {
            if (this.apiExternalDocs$key == null) {
                this.apiExternalDocs$key = new java.util.ArrayList<String>();
                this.apiExternalDocs$value = new java.util.ArrayList<String>();
            }
            this.apiExternalDocs$key.add(apiExternalDocKey);
            this.apiExternalDocs$value.add(apiExternalDocValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiExternalDocs(final java.util.Map<? extends String, ? extends String> apiExternalDocs) {
            if (apiExternalDocs == null) {
                throw new java.lang.NullPointerException("apiExternalDocs cannot be null");
            }
            if (this.apiExternalDocs$key == null) {
                this.apiExternalDocs$key = new java.util.ArrayList<String>();
                this.apiExternalDocs$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : apiExternalDocs.entrySet()) {
                this.apiExternalDocs$key.add($lombokEntry.getKey());
                this.apiExternalDocs$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearApiExternalDocs() {
            if (this.apiExternalDocs$key != null) {
                this.apiExternalDocs$key.clear();
                this.apiExternalDocs$value.clear();
            }
            return self();
        }

        /**
         * Whether authentication is optional (true) or required (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiIsAuthOptional(final Boolean apiIsAuthOptional) {
            this.apiIsAuthOptional = apiIsAuthOptional;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiPathAvailableOperation(final String apiPathAvailableOperation) {
            if (this.apiPathAvailableOperations == null) this.apiPathAvailableOperations = new java.util.ArrayList<String>();
            this.apiPathAvailableOperations.add(apiPathAvailableOperation);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiPathAvailableOperations(final java.util.Collection<? extends String> apiPathAvailableOperations) {
            if (apiPathAvailableOperations == null) {
                throw new java.lang.NullPointerException("apiPathAvailableOperations cannot be null");
            }
            if (this.apiPathAvailableOperations == null) this.apiPathAvailableOperations = new java.util.ArrayList<String>();
            this.apiPathAvailableOperations.addAll(apiPathAvailableOperations);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearApiPathAvailableOperations() {
            if (this.apiPathAvailableOperations != null) this.apiPathAvailableOperations.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiPathAvailableResponseCode(final String apiPathAvailableResponseCodeKey, final String apiPathAvailableResponseCodeValue) {
            if (this.apiPathAvailableResponseCodes$key == null) {
                this.apiPathAvailableResponseCodes$key = new java.util.ArrayList<String>();
                this.apiPathAvailableResponseCodes$value = new java.util.ArrayList<String>();
            }
            this.apiPathAvailableResponseCodes$key.add(apiPathAvailableResponseCodeKey);
            this.apiPathAvailableResponseCodes$value.add(apiPathAvailableResponseCodeValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiPathAvailableResponseCodes(final java.util.Map<? extends String, ? extends String> apiPathAvailableResponseCodes) {
            if (apiPathAvailableResponseCodes == null) {
                throw new java.lang.NullPointerException("apiPathAvailableResponseCodes cannot be null");
            }
            if (this.apiPathAvailableResponseCodes$key == null) {
                this.apiPathAvailableResponseCodes$key = new java.util.ArrayList<String>();
                this.apiPathAvailableResponseCodes$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : apiPathAvailableResponseCodes.entrySet()) {
                this.apiPathAvailableResponseCodes$key.add($lombokEntry.getKey());
                this.apiPathAvailableResponseCodes$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearApiPathAvailableResponseCodes() {
            if (this.apiPathAvailableResponseCodes$key != null) {
                this.apiPathAvailableResponseCodes$key.clear();
                this.apiPathAvailableResponseCodes$value.clear();
            }
            return self();
        }

        /**
         * Whether the path is exposed as an ingress (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiPathIsIngressExposed(final Boolean apiPathIsIngressExposed) {
            this.apiPathIsIngressExposed = apiPathIsIngressExposed;
            return self();
        }

        /**
         * Whether the endpoint's path contains replaceable parameters (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiPathIsTemplated(final Boolean apiPathIsTemplated) {
            this.apiPathIsTemplated = apiPathIsTemplated;
            return self();
        }

        /**
         * Absolute path to an individual endpoint.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiPathRawURI(final String apiPathRawURI) {
            this.apiPathRawURI = apiPathRawURI;
            return self();
        }

        /**
         * Descriptive summary intended to apply to all operations in this path.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiPathSummary(final String apiPathSummary) {
            this.apiPathSummary = apiPathSummary;
            return self();
        }

        /**
         * API specification in which this path exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpec(final IAPISpec apiSpec) {
            this.apiSpec = apiSpec;
            return self();
        }

        /**
         * Simple name of the API spec, if this asset is contained in an API spec.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecName(final String apiSpecName) {
            this.apiSpecName = apiSpecName;
            return self();
        }

        /**
         * Unique name of the API spec, if this asset is contained in an API spec.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecQualifiedName(final String apiSpecQualifiedName) {
            this.apiSpecQualifiedName = apiSpecQualifiedName;
            return self();
        }

        /**
         * Type of API, for example: OpenAPI, GraphQL, etc.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecType(final String apiSpecType) {
            this.apiSpecType = apiSpecType;
            return self();
        }

        /**
         * Version of the API specification.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecVersion(final String apiSpecVersion) {
            this.apiSpecVersion = apiSpecVersion;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "APIPath.APIPathBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", apiExternalDocs$key=" + this.apiExternalDocs$key + ", apiExternalDocs$value=" + this.apiExternalDocs$value + ", apiIsAuthOptional=" + this.apiIsAuthOptional + ", apiPathAvailableOperations=" + this.apiPathAvailableOperations + ", apiPathAvailableResponseCodes$key=" + this.apiPathAvailableResponseCodes$key + ", apiPathAvailableResponseCodes$value=" + this.apiPathAvailableResponseCodes$value + ", apiPathIsIngressExposed=" + this.apiPathIsIngressExposed + ", apiPathIsTemplated=" + this.apiPathIsTemplated + ", apiPathRawURI=" + this.apiPathRawURI + ", apiPathSummary=" + this.apiPathSummary + ", apiSpec=" + this.apiSpec + ", apiSpecName=" + this.apiSpecName + ", apiSpecQualifiedName=" + this.apiSpecQualifiedName + ", apiSpecType=" + this.apiSpecType + ", apiSpecVersion=" + this.apiSpecVersion + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class APIPathBuilderImpl extends APIPath.APIPathBuilder<APIPath, APIPath.APIPathBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private APIPathBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected APIPath.APIPathBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public APIPath build() {
            return new APIPath(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected APIPath(final APIPath.APIPathBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = APIPath.$default$typeName();
        java.util.Map<String, String> apiExternalDocs;
        switch (b.apiExternalDocs$key == null ? 0 : b.apiExternalDocs$key.size()) {
        case 0: 
            apiExternalDocs = java.util.Collections.emptyMap();
            break;
        case 1: 
            apiExternalDocs = java.util.Collections.singletonMap(b.apiExternalDocs$key.get(0), b.apiExternalDocs$value.get(0));
            break;
        default: 
            apiExternalDocs = new java.util.LinkedHashMap<String, String>(b.apiExternalDocs$key.size() < 1073741824 ? 1 + b.apiExternalDocs$key.size() + (b.apiExternalDocs$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.apiExternalDocs$key.size(); $i++) apiExternalDocs.put(b.apiExternalDocs$key.get($i), (String) b.apiExternalDocs$value.get($i));
            apiExternalDocs = java.util.Collections.unmodifiableMap(apiExternalDocs);
        }
        this.apiExternalDocs = apiExternalDocs;
        this.apiIsAuthOptional = b.apiIsAuthOptional;
        java.util.SortedSet<String> apiPathAvailableOperations = new java.util.TreeSet<String>();
        if (b.apiPathAvailableOperations != null) apiPathAvailableOperations.addAll(b.apiPathAvailableOperations);
        apiPathAvailableOperations = java.util.Collections.unmodifiableSortedSet(apiPathAvailableOperations);
        this.apiPathAvailableOperations = apiPathAvailableOperations;
        java.util.Map<String, String> apiPathAvailableResponseCodes;
        switch (b.apiPathAvailableResponseCodes$key == null ? 0 : b.apiPathAvailableResponseCodes$key.size()) {
        case 0: 
            apiPathAvailableResponseCodes = java.util.Collections.emptyMap();
            break;
        case 1: 
            apiPathAvailableResponseCodes = java.util.Collections.singletonMap(b.apiPathAvailableResponseCodes$key.get(0), b.apiPathAvailableResponseCodes$value.get(0));
            break;
        default: 
            apiPathAvailableResponseCodes = new java.util.LinkedHashMap<String, String>(b.apiPathAvailableResponseCodes$key.size() < 1073741824 ? 1 + b.apiPathAvailableResponseCodes$key.size() + (b.apiPathAvailableResponseCodes$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.apiPathAvailableResponseCodes$key.size(); $i++) apiPathAvailableResponseCodes.put(b.apiPathAvailableResponseCodes$key.get($i), (String) b.apiPathAvailableResponseCodes$value.get($i));
            apiPathAvailableResponseCodes = java.util.Collections.unmodifiableMap(apiPathAvailableResponseCodes);
        }
        this.apiPathAvailableResponseCodes = apiPathAvailableResponseCodes;
        this.apiPathIsIngressExposed = b.apiPathIsIngressExposed;
        this.apiPathIsTemplated = b.apiPathIsTemplated;
        this.apiPathRawURI = b.apiPathRawURI;
        this.apiPathSummary = b.apiPathSummary;
        this.apiSpec = b.apiSpec;
        this.apiSpecName = b.apiSpecName;
        this.apiSpecQualifiedName = b.apiSpecQualifiedName;
        this.apiSpecType = b.apiSpecType;
        this.apiSpecVersion = b.apiSpecVersion;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static APIPath.APIPathBuilder<?, ?> _internal() {
        return new APIPath.APIPathBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public APIPath.APIPathBuilder<?, ?> toBuilder() {
        return new APIPath.APIPathBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * External documentation of the API.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getApiExternalDocs() {
        return this.apiExternalDocs;
    }

    /**
     * Whether authentication is optional (true) or required (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getApiIsAuthOptional() {
        return this.apiIsAuthOptional;
    }

    /**
     * List of the operations available on the endpoint.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getApiPathAvailableOperations() {
        return this.apiPathAvailableOperations;
    }

    /**
     * Response codes available on the path across all operations.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getApiPathAvailableResponseCodes() {
        return this.apiPathAvailableResponseCodes;
    }

    /**
     * Whether the path is exposed as an ingress (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getApiPathIsIngressExposed() {
        return this.apiPathIsIngressExposed;
    }

    /**
     * Whether the endpoint's path contains replaceable parameters (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getApiPathIsTemplated() {
        return this.apiPathIsTemplated;
    }

    /**
     * Absolute path to an individual endpoint.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiPathRawURI() {
        return this.apiPathRawURI;
    }

    /**
     * Descriptive summary intended to apply to all operations in this path.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiPathSummary() {
        return this.apiPathSummary;
    }

    /**
     * API specification in which this path exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IAPISpec getApiSpec() {
        return this.apiSpec;
    }

    /**
     * Simple name of the API spec, if this asset is contained in an API spec.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecName() {
        return this.apiSpecName;
    }

    /**
     * Unique name of the API spec, if this asset is contained in an API spec.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecQualifiedName() {
        return this.apiSpecQualifiedName;
    }

    /**
     * Type of API, for example: OpenAPI, GraphQL, etc.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecType() {
        return this.apiSpecType;
    }

    /**
     * Version of the API specification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecVersion() {
        return this.apiSpecVersion;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof APIPath)) return false;
        final APIPath other = (APIPath) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$apiIsAuthOptional = this.getApiIsAuthOptional();
        final java.lang.Object other$apiIsAuthOptional = other.getApiIsAuthOptional();
        if (this$apiIsAuthOptional == null ? other$apiIsAuthOptional != null : !this$apiIsAuthOptional.equals(other$apiIsAuthOptional)) return false;
        final java.lang.Object this$apiPathIsIngressExposed = this.getApiPathIsIngressExposed();
        final java.lang.Object other$apiPathIsIngressExposed = other.getApiPathIsIngressExposed();
        if (this$apiPathIsIngressExposed == null ? other$apiPathIsIngressExposed != null : !this$apiPathIsIngressExposed.equals(other$apiPathIsIngressExposed)) return false;
        final java.lang.Object this$apiPathIsTemplated = this.getApiPathIsTemplated();
        final java.lang.Object other$apiPathIsTemplated = other.getApiPathIsTemplated();
        if (this$apiPathIsTemplated == null ? other$apiPathIsTemplated != null : !this$apiPathIsTemplated.equals(other$apiPathIsTemplated)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$apiExternalDocs = this.getApiExternalDocs();
        final java.lang.Object other$apiExternalDocs = other.getApiExternalDocs();
        if (this$apiExternalDocs == null ? other$apiExternalDocs != null : !this$apiExternalDocs.equals(other$apiExternalDocs)) return false;
        final java.lang.Object this$apiPathAvailableOperations = this.getApiPathAvailableOperations();
        final java.lang.Object other$apiPathAvailableOperations = other.getApiPathAvailableOperations();
        if (this$apiPathAvailableOperations == null ? other$apiPathAvailableOperations != null : !this$apiPathAvailableOperations.equals(other$apiPathAvailableOperations)) return false;
        final java.lang.Object this$apiPathAvailableResponseCodes = this.getApiPathAvailableResponseCodes();
        final java.lang.Object other$apiPathAvailableResponseCodes = other.getApiPathAvailableResponseCodes();
        if (this$apiPathAvailableResponseCodes == null ? other$apiPathAvailableResponseCodes != null : !this$apiPathAvailableResponseCodes.equals(other$apiPathAvailableResponseCodes)) return false;
        final java.lang.Object this$apiPathRawURI = this.getApiPathRawURI();
        final java.lang.Object other$apiPathRawURI = other.getApiPathRawURI();
        if (this$apiPathRawURI == null ? other$apiPathRawURI != null : !this$apiPathRawURI.equals(other$apiPathRawURI)) return false;
        final java.lang.Object this$apiPathSummary = this.getApiPathSummary();
        final java.lang.Object other$apiPathSummary = other.getApiPathSummary();
        if (this$apiPathSummary == null ? other$apiPathSummary != null : !this$apiPathSummary.equals(other$apiPathSummary)) return false;
        final java.lang.Object this$apiSpec = this.getApiSpec();
        final java.lang.Object other$apiSpec = other.getApiSpec();
        if (this$apiSpec == null ? other$apiSpec != null : !this$apiSpec.equals(other$apiSpec)) return false;
        final java.lang.Object this$apiSpecName = this.getApiSpecName();
        final java.lang.Object other$apiSpecName = other.getApiSpecName();
        if (this$apiSpecName == null ? other$apiSpecName != null : !this$apiSpecName.equals(other$apiSpecName)) return false;
        final java.lang.Object this$apiSpecQualifiedName = this.getApiSpecQualifiedName();
        final java.lang.Object other$apiSpecQualifiedName = other.getApiSpecQualifiedName();
        if (this$apiSpecQualifiedName == null ? other$apiSpecQualifiedName != null : !this$apiSpecQualifiedName.equals(other$apiSpecQualifiedName)) return false;
        final java.lang.Object this$apiSpecType = this.getApiSpecType();
        final java.lang.Object other$apiSpecType = other.getApiSpecType();
        if (this$apiSpecType == null ? other$apiSpecType != null : !this$apiSpecType.equals(other$apiSpecType)) return false;
        final java.lang.Object this$apiSpecVersion = this.getApiSpecVersion();
        final java.lang.Object other$apiSpecVersion = other.getApiSpecVersion();
        if (this$apiSpecVersion == null ? other$apiSpecVersion != null : !this$apiSpecVersion.equals(other$apiSpecVersion)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof APIPath;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $apiIsAuthOptional = this.getApiIsAuthOptional();
        result = result * PRIME + ($apiIsAuthOptional == null ? 43 : $apiIsAuthOptional.hashCode());
        final java.lang.Object $apiPathIsIngressExposed = this.getApiPathIsIngressExposed();
        result = result * PRIME + ($apiPathIsIngressExposed == null ? 43 : $apiPathIsIngressExposed.hashCode());
        final java.lang.Object $apiPathIsTemplated = this.getApiPathIsTemplated();
        result = result * PRIME + ($apiPathIsTemplated == null ? 43 : $apiPathIsTemplated.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $apiExternalDocs = this.getApiExternalDocs();
        result = result * PRIME + ($apiExternalDocs == null ? 43 : $apiExternalDocs.hashCode());
        final java.lang.Object $apiPathAvailableOperations = this.getApiPathAvailableOperations();
        result = result * PRIME + ($apiPathAvailableOperations == null ? 43 : $apiPathAvailableOperations.hashCode());
        final java.lang.Object $apiPathAvailableResponseCodes = this.getApiPathAvailableResponseCodes();
        result = result * PRIME + ($apiPathAvailableResponseCodes == null ? 43 : $apiPathAvailableResponseCodes.hashCode());
        final java.lang.Object $apiPathRawURI = this.getApiPathRawURI();
        result = result * PRIME + ($apiPathRawURI == null ? 43 : $apiPathRawURI.hashCode());
        final java.lang.Object $apiPathSummary = this.getApiPathSummary();
        result = result * PRIME + ($apiPathSummary == null ? 43 : $apiPathSummary.hashCode());
        final java.lang.Object $apiSpec = this.getApiSpec();
        result = result * PRIME + ($apiSpec == null ? 43 : $apiSpec.hashCode());
        final java.lang.Object $apiSpecName = this.getApiSpecName();
        result = result * PRIME + ($apiSpecName == null ? 43 : $apiSpecName.hashCode());
        final java.lang.Object $apiSpecQualifiedName = this.getApiSpecQualifiedName();
        result = result * PRIME + ($apiSpecQualifiedName == null ? 43 : $apiSpecQualifiedName.hashCode());
        final java.lang.Object $apiSpecType = this.getApiSpecType();
        result = result * PRIME + ($apiSpecType == null ? 43 : $apiSpecType.hashCode());
        final java.lang.Object $apiSpecVersion = this.getApiSpecVersion();
        result = result * PRIME + ($apiSpecVersion == null ? 43 : $apiSpecVersion.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "APIPath(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", apiExternalDocs=" + this.getApiExternalDocs() + ", apiIsAuthOptional=" + this.getApiIsAuthOptional() + ", apiPathAvailableOperations=" + this.getApiPathAvailableOperations() + ", apiPathAvailableResponseCodes=" + this.getApiPathAvailableResponseCodes() + ", apiPathIsIngressExposed=" + this.getApiPathIsIngressExposed() + ", apiPathIsTemplated=" + this.getApiPathIsTemplated() + ", apiPathRawURI=" + this.getApiPathRawURI() + ", apiPathSummary=" + this.getApiPathSummary() + ", apiSpec=" + this.getApiSpec() + ", apiSpecName=" + this.getApiSpecName() + ", apiSpecQualifiedName=" + this.getApiSpecQualifiedName() + ", apiSpecType=" + this.getApiSpecType() + ", apiSpecVersion=" + this.getApiSpecVersion() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for APIPaths.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
