// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of an API specification in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class APISpec extends Asset implements IAPISpec, IAPI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(APISpec.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "APISpec";
    /**
     * Fixed typeName for APISpecs.
     */
    String typeName;
    /**
     * External documentation of the API.
     */
    @Attribute
    Map<String, String> apiExternalDocs;
    /**
     * Whether authentication is optional (true) or required (false).
     */
    @Attribute
    Boolean apiIsAuthOptional;
    /**
     * Paths that exist within this API specification.
     */
    @Attribute
    SortedSet<IAPIPath> apiPaths;
    /**
     * Email address for a contact responsible for the API specification.
     */
    @Attribute
    String apiSpecContactEmail;
    /**
     * Name of the contact responsible for the API specification.
     */
    @Attribute
    String apiSpecContactName;
    /**
     * URL pointing to the contact information.
     */
    @Attribute
    String apiSpecContactURL;
    /**
     * Version of the contract for the API specification.
     */
    @Attribute
    String apiSpecContractVersion;
    /**
     * Name of the license under which the API specification is available.
     */
    @Attribute
    String apiSpecLicenseName;
    /**
     * URL to the license under which the API specification is available.
     */
    @Attribute
    String apiSpecLicenseURL;
    /**
     * Simple name of the API spec, if this asset is contained in an API spec.
     */
    @Attribute
    String apiSpecName;
    /**
     * Unique name of the API spec, if this asset is contained in an API spec.
     */
    @Attribute
    String apiSpecQualifiedName;
    /**
     * Service alias for the API specification.
     */
    @Attribute
    String apiSpecServiceAlias;
    /**
     * URL to the terms of service for the API specification.
     */
    @Attribute
    String apiSpecTermsOfServiceURL;
    /**
     * Type of API, for example: OpenAPI, GraphQL, etc.
     */
    @Attribute
    String apiSpecType;
    /**
     * Version of the API specification.
     */
    @Attribute
    String apiSpecVersion;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a APISpec, from a potentially
     * more-complete APISpec object.
     *
     * @return the minimal object necessary to relate to the APISpec
     * @throws InvalidRequestException if any of the minimal set of required properties for a APISpec relationship are not found in the initial object
     */
    @Override
    public APISpec trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all APISpec assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) APISpec assets will be included.
     *
     * @return a fluent search that includes all APISpec assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all APISpec assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) APISpec assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all APISpec assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all APISpec assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) APISpecs will be included
     * @return a fluent search that includes all APISpec assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all APISpec assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) APISpecs will be included
     * @return a fluent search that includes all APISpec assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a APISpec by GUID. Use this to create a relationship to this APISpec,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the APISpec to reference
     * @return reference to a APISpec that can be used for defining a relationship to a APISpec
     */
    public static APISpec refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a APISpec by GUID. Use this to create a relationship to this APISpec,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the APISpec to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a APISpec that can be used for defining a relationship to a APISpec
     */
    public static APISpec refByGuid(String guid, Reference.SaveSemantic semantic) {
        return APISpec._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a APISpec by qualifiedName. Use this to create a relationship to this APISpec,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the APISpec to reference
     * @return reference to a APISpec that can be used for defining a relationship to a APISpec
     */
    public static APISpec refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a APISpec by qualifiedName. Use this to create a relationship to this APISpec,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the APISpec to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a APISpec that can be used for defining a relationship to a APISpec
     */
    public static APISpec refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return APISpec._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a APISpec by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the APISpec to retrieve, either its GUID or its full qualifiedName
     * @return the requested full APISpec, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the APISpec does not exist or the provided GUID is not a APISpec
     */
    @JsonIgnore
    public static APISpec get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a APISpec by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the APISpec to retrieve, either its GUID or its full qualifiedName
     * @return the requested full APISpec, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the APISpec does not exist or the provided GUID is not a APISpec
     */
    @JsonIgnore
    public static APISpec get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a APISpec by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the APISpec to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full APISpec, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the APISpec does not exist or the provided GUID is not a APISpec
     */
    @JsonIgnore
    public static APISpec get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof APISpec) {
                return (APISpec) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof APISpec) {
                return (APISpec) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) APISpec to active.
     *
     * @param qualifiedName for the APISpec
     * @return true if the APISpec is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) APISpec to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the APISpec
     * @return true if the APISpec is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create an API spec.
     *
     * @param name of the API spec
     * @param connectionQualifiedName unique name of the connection through which the spec is accessible
     * @return the minimal object necessary to create the API spec, as a builder
     */
    public static APISpecBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return APISpec._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(connectionQualifiedName + "/" + name).name(name).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.API);
    }

    /**
     * Builds the minimal object necessary to update a APISpec.
     *
     * @param qualifiedName of the APISpec
     * @param name of the APISpec
     * @return the minimal request necessary to update the APISpec, as a builder
     */
    public static APISpecBuilder<?, ?> updater(String qualifiedName, String name) {
        return APISpec._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a APISpec, from a potentially
     * more-complete APISpec object.
     *
     * @return the minimal object necessary to update the APISpec, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for APISpec are not found in the initial object
     */
    @Override
    public APISpecBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a APISpec.
     *
     * @param qualifiedName of the APISpec
     * @param name of the APISpec
     * @return the updated APISpec, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APISpec removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a APISpec.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the APISpec
     * @param name of the APISpec
     * @return the updated APISpec, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APISpec removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APISpec) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a APISpec.
     *
     * @param qualifiedName of the APISpec
     * @param name of the APISpec
     * @return the updated APISpec, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APISpec removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a APISpec.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the APISpec
     * @param name of the APISpec
     * @return the updated APISpec, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APISpec removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APISpec) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a APISpec.
     *
     * @param qualifiedName of the APISpec
     * @param name of the APISpec
     * @return the updated APISpec, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APISpec removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a APISpec.
     *
     * @param client connectivity to the Atlan tenant from which to remove the APISpec's owners
     * @param qualifiedName of the APISpec
     * @param name of the APISpec
     * @return the updated APISpec, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APISpec removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APISpec) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a APISpec.
     *
     * @param qualifiedName of the APISpec
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated APISpec, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static APISpec updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a APISpec.
     *
     * @param client connectivity to the Atlan tenant on which to update the APISpec's certificate
     * @param qualifiedName of the APISpec
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated APISpec, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static APISpec updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (APISpec) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a APISpec.
     *
     * @param qualifiedName of the APISpec
     * @param name of the APISpec
     * @return the updated APISpec, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APISpec removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a APISpec.
     *
     * @param client connectivity to the Atlan tenant from which to remove the APISpec's certificate
     * @param qualifiedName of the APISpec
     * @param name of the APISpec
     * @return the updated APISpec, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APISpec removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APISpec) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a APISpec.
     *
     * @param qualifiedName of the APISpec
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static APISpec updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a APISpec.
     *
     * @param client connectivity to the Atlan tenant on which to update the APISpec's announcement
     * @param qualifiedName of the APISpec
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static APISpec updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (APISpec) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a APISpec.
     *
     * @param qualifiedName of the APISpec
     * @param name of the APISpec
     * @return the updated APISpec, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APISpec removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a APISpec.
     *
     * @param client connectivity to the Atlan client from which to remove the APISpec's announcement
     * @param qualifiedName of the APISpec
     * @param name of the APISpec
     * @return the updated APISpec, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static APISpec removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APISpec) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the APISpec.
     *
     * @param qualifiedName for the APISpec
     * @param name human-readable name of the APISpec
     * @param terms the list of terms to replace on the APISpec, or null to remove all terms from the APISpec
     * @return the APISpec that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static APISpec replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the APISpec.
     *
     * @param client connectivity to the Atlan tenant on which to replace the APISpec's assigned terms
     * @param qualifiedName for the APISpec
     * @param name human-readable name of the APISpec
     * @param terms the list of terms to replace on the APISpec, or null to remove all terms from the APISpec
     * @return the APISpec that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static APISpec replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (APISpec) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the APISpec, without replacing existing terms linked to the APISpec.
     * Note: this operation must make two API calls — one to retrieve the APISpec's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the APISpec
     * @param terms the list of terms to append to the APISpec
     * @return the APISpec that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static APISpec appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the APISpec, without replacing existing terms linked to the APISpec.
     * Note: this operation must make two API calls — one to retrieve the APISpec's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the APISpec
     * @param qualifiedName for the APISpec
     * @param terms the list of terms to append to the APISpec
     * @return the APISpec that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static APISpec appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (APISpec) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a APISpec, without replacing all existing terms linked to the APISpec.
     * Note: this operation must make two API calls — one to retrieve the APISpec's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the APISpec
     * @param terms the list of terms to remove from the APISpec, which must be referenced by GUID
     * @return the APISpec that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static APISpec removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a APISpec, without replacing all existing terms linked to the APISpec.
     * Note: this operation must make two API calls — one to retrieve the APISpec's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the APISpec
     * @param qualifiedName for the APISpec
     * @param terms the list of terms to remove from the APISpec, which must be referenced by GUID
     * @return the APISpec that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static APISpec removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (APISpec) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a APISpec, without replacing existing Atlan tags linked to the APISpec.
     * Note: this operation must make two API calls — one to retrieve the APISpec's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the APISpec
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated APISpec
     */
    public static APISpec appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a APISpec, without replacing existing Atlan tags linked to the APISpec.
     * Note: this operation must make two API calls — one to retrieve the APISpec's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the APISpec
     * @param qualifiedName of the APISpec
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated APISpec
     */
    public static APISpec appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (APISpec) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a APISpec, without replacing existing Atlan tags linked to the APISpec.
     * Note: this operation must make two API calls — one to retrieve the APISpec's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the APISpec
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated APISpec
     */
    public static APISpec appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a APISpec, without replacing existing Atlan tags linked to the APISpec.
     * Note: this operation must make two API calls — one to retrieve the APISpec's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the APISpec
     * @param qualifiedName of the APISpec
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated APISpec
     */
    public static APISpec appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (APISpec) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a APISpec.
     *
     * @param qualifiedName of the APISpec
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the APISpec
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a APISpec.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a APISpec
     * @param qualifiedName of the APISpec
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the APISpec
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class APISpecBuilder<C extends APISpec, B extends APISpec.APISpecBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> apiExternalDocs$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> apiExternalDocs$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean apiIsAuthOptional;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAPIPath> apiPaths;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecContactEmail;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecContactName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecContactURL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecContractVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecLicenseName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecLicenseURL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecServiceAlias;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecTermsOfServiceURL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiSpecVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            APISpec.APISpecBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final APISpec instance, final APISpec.APISpecBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.apiExternalDocs(instance.apiExternalDocs == null ? java.util.Collections.<String, String>emptyMap() : instance.apiExternalDocs);
            b.apiIsAuthOptional(instance.apiIsAuthOptional);
            b.apiPaths(instance.apiPaths == null ? java.util.Collections.<IAPIPath>emptySortedSet() : instance.apiPaths);
            b.apiSpecContactEmail(instance.apiSpecContactEmail);
            b.apiSpecContactName(instance.apiSpecContactName);
            b.apiSpecContactURL(instance.apiSpecContactURL);
            b.apiSpecContractVersion(instance.apiSpecContractVersion);
            b.apiSpecLicenseName(instance.apiSpecLicenseName);
            b.apiSpecLicenseURL(instance.apiSpecLicenseURL);
            b.apiSpecName(instance.apiSpecName);
            b.apiSpecQualifiedName(instance.apiSpecQualifiedName);
            b.apiSpecServiceAlias(instance.apiSpecServiceAlias);
            b.apiSpecTermsOfServiceURL(instance.apiSpecTermsOfServiceURL);
            b.apiSpecType(instance.apiSpecType);
            b.apiSpecVersion(instance.apiSpecVersion);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for APISpecs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiExternalDoc(final String apiExternalDocKey, final String apiExternalDocValue) {
            if (this.apiExternalDocs$key == null) {
                this.apiExternalDocs$key = new java.util.ArrayList<String>();
                this.apiExternalDocs$value = new java.util.ArrayList<String>();
            }
            this.apiExternalDocs$key.add(apiExternalDocKey);
            this.apiExternalDocs$value.add(apiExternalDocValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiExternalDocs(final java.util.Map<? extends String, ? extends String> apiExternalDocs) {
            if (apiExternalDocs == null) {
                throw new java.lang.NullPointerException("apiExternalDocs cannot be null");
            }
            if (this.apiExternalDocs$key == null) {
                this.apiExternalDocs$key = new java.util.ArrayList<String>();
                this.apiExternalDocs$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : apiExternalDocs.entrySet()) {
                this.apiExternalDocs$key.add($lombokEntry.getKey());
                this.apiExternalDocs$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearApiExternalDocs() {
            if (this.apiExternalDocs$key != null) {
                this.apiExternalDocs$key.clear();
                this.apiExternalDocs$value.clear();
            }
            return self();
        }

        /**
         * Whether authentication is optional (true) or required (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiIsAuthOptional(final Boolean apiIsAuthOptional) {
            this.apiIsAuthOptional = apiIsAuthOptional;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiPath(final IAPIPath apiPath) {
            if (this.apiPaths == null) this.apiPaths = new java.util.ArrayList<IAPIPath>();
            this.apiPaths.add(apiPath);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiPaths(final java.util.Collection<? extends IAPIPath> apiPaths) {
            if (apiPaths == null) {
                throw new java.lang.NullPointerException("apiPaths cannot be null");
            }
            if (this.apiPaths == null) this.apiPaths = new java.util.ArrayList<IAPIPath>();
            this.apiPaths.addAll(apiPaths);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearApiPaths() {
            if (this.apiPaths != null) this.apiPaths.clear();
            return self();
        }

        /**
         * Email address for a contact responsible for the API specification.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecContactEmail(final String apiSpecContactEmail) {
            this.apiSpecContactEmail = apiSpecContactEmail;
            return self();
        }

        /**
         * Name of the contact responsible for the API specification.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecContactName(final String apiSpecContactName) {
            this.apiSpecContactName = apiSpecContactName;
            return self();
        }

        /**
         * URL pointing to the contact information.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecContactURL(final String apiSpecContactURL) {
            this.apiSpecContactURL = apiSpecContactURL;
            return self();
        }

        /**
         * Version of the contract for the API specification.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecContractVersion(final String apiSpecContractVersion) {
            this.apiSpecContractVersion = apiSpecContractVersion;
            return self();
        }

        /**
         * Name of the license under which the API specification is available.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecLicenseName(final String apiSpecLicenseName) {
            this.apiSpecLicenseName = apiSpecLicenseName;
            return self();
        }

        /**
         * URL to the license under which the API specification is available.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecLicenseURL(final String apiSpecLicenseURL) {
            this.apiSpecLicenseURL = apiSpecLicenseURL;
            return self();
        }

        /**
         * Simple name of the API spec, if this asset is contained in an API spec.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecName(final String apiSpecName) {
            this.apiSpecName = apiSpecName;
            return self();
        }

        /**
         * Unique name of the API spec, if this asset is contained in an API spec.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecQualifiedName(final String apiSpecQualifiedName) {
            this.apiSpecQualifiedName = apiSpecQualifiedName;
            return self();
        }

        /**
         * Service alias for the API specification.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecServiceAlias(final String apiSpecServiceAlias) {
            this.apiSpecServiceAlias = apiSpecServiceAlias;
            return self();
        }

        /**
         * URL to the terms of service for the API specification.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecTermsOfServiceURL(final String apiSpecTermsOfServiceURL) {
            this.apiSpecTermsOfServiceURL = apiSpecTermsOfServiceURL;
            return self();
        }

        /**
         * Type of API, for example: OpenAPI, GraphQL, etc.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecType(final String apiSpecType) {
            this.apiSpecType = apiSpecType;
            return self();
        }

        /**
         * Version of the API specification.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiSpecVersion(final String apiSpecVersion) {
            this.apiSpecVersion = apiSpecVersion;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "APISpec.APISpecBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", apiExternalDocs$key=" + this.apiExternalDocs$key + ", apiExternalDocs$value=" + this.apiExternalDocs$value + ", apiIsAuthOptional=" + this.apiIsAuthOptional + ", apiPaths=" + this.apiPaths + ", apiSpecContactEmail=" + this.apiSpecContactEmail + ", apiSpecContactName=" + this.apiSpecContactName + ", apiSpecContactURL=" + this.apiSpecContactURL + ", apiSpecContractVersion=" + this.apiSpecContractVersion + ", apiSpecLicenseName=" + this.apiSpecLicenseName + ", apiSpecLicenseURL=" + this.apiSpecLicenseURL + ", apiSpecName=" + this.apiSpecName + ", apiSpecQualifiedName=" + this.apiSpecQualifiedName + ", apiSpecServiceAlias=" + this.apiSpecServiceAlias + ", apiSpecTermsOfServiceURL=" + this.apiSpecTermsOfServiceURL + ", apiSpecType=" + this.apiSpecType + ", apiSpecVersion=" + this.apiSpecVersion + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class APISpecBuilderImpl extends APISpec.APISpecBuilder<APISpec, APISpec.APISpecBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private APISpecBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected APISpec.APISpecBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public APISpec build() {
            return new APISpec(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected APISpec(final APISpec.APISpecBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = APISpec.$default$typeName();
        java.util.Map<String, String> apiExternalDocs;
        switch (b.apiExternalDocs$key == null ? 0 : b.apiExternalDocs$key.size()) {
        case 0: 
            apiExternalDocs = java.util.Collections.emptyMap();
            break;
        case 1: 
            apiExternalDocs = java.util.Collections.singletonMap(b.apiExternalDocs$key.get(0), b.apiExternalDocs$value.get(0));
            break;
        default: 
            apiExternalDocs = new java.util.LinkedHashMap<String, String>(b.apiExternalDocs$key.size() < 1073741824 ? 1 + b.apiExternalDocs$key.size() + (b.apiExternalDocs$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.apiExternalDocs$key.size(); $i++) apiExternalDocs.put(b.apiExternalDocs$key.get($i), (String) b.apiExternalDocs$value.get($i));
            apiExternalDocs = java.util.Collections.unmodifiableMap(apiExternalDocs);
        }
        this.apiExternalDocs = apiExternalDocs;
        this.apiIsAuthOptional = b.apiIsAuthOptional;
        java.util.SortedSet<IAPIPath> apiPaths = new java.util.TreeSet<IAPIPath>();
        if (b.apiPaths != null) apiPaths.addAll(b.apiPaths);
        apiPaths = java.util.Collections.unmodifiableSortedSet(apiPaths);
        this.apiPaths = apiPaths;
        this.apiSpecContactEmail = b.apiSpecContactEmail;
        this.apiSpecContactName = b.apiSpecContactName;
        this.apiSpecContactURL = b.apiSpecContactURL;
        this.apiSpecContractVersion = b.apiSpecContractVersion;
        this.apiSpecLicenseName = b.apiSpecLicenseName;
        this.apiSpecLicenseURL = b.apiSpecLicenseURL;
        this.apiSpecName = b.apiSpecName;
        this.apiSpecQualifiedName = b.apiSpecQualifiedName;
        this.apiSpecServiceAlias = b.apiSpecServiceAlias;
        this.apiSpecTermsOfServiceURL = b.apiSpecTermsOfServiceURL;
        this.apiSpecType = b.apiSpecType;
        this.apiSpecVersion = b.apiSpecVersion;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static APISpec.APISpecBuilder<?, ?> _internal() {
        return new APISpec.APISpecBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public APISpec.APISpecBuilder<?, ?> toBuilder() {
        return new APISpec.APISpecBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * External documentation of the API.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getApiExternalDocs() {
        return this.apiExternalDocs;
    }

    /**
     * Whether authentication is optional (true) or required (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getApiIsAuthOptional() {
        return this.apiIsAuthOptional;
    }

    /**
     * Paths that exist within this API specification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAPIPath> getApiPaths() {
        return this.apiPaths;
    }

    /**
     * Email address for a contact responsible for the API specification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecContactEmail() {
        return this.apiSpecContactEmail;
    }

    /**
     * Name of the contact responsible for the API specification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecContactName() {
        return this.apiSpecContactName;
    }

    /**
     * URL pointing to the contact information.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecContactURL() {
        return this.apiSpecContactURL;
    }

    /**
     * Version of the contract for the API specification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecContractVersion() {
        return this.apiSpecContractVersion;
    }

    /**
     * Name of the license under which the API specification is available.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecLicenseName() {
        return this.apiSpecLicenseName;
    }

    /**
     * URL to the license under which the API specification is available.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecLicenseURL() {
        return this.apiSpecLicenseURL;
    }

    /**
     * Simple name of the API spec, if this asset is contained in an API spec.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecName() {
        return this.apiSpecName;
    }

    /**
     * Unique name of the API spec, if this asset is contained in an API spec.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecQualifiedName() {
        return this.apiSpecQualifiedName;
    }

    /**
     * Service alias for the API specification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecServiceAlias() {
        return this.apiSpecServiceAlias;
    }

    /**
     * URL to the terms of service for the API specification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecTermsOfServiceURL() {
        return this.apiSpecTermsOfServiceURL;
    }

    /**
     * Type of API, for example: OpenAPI, GraphQL, etc.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecType() {
        return this.apiSpecType;
    }

    /**
     * Version of the API specification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiSpecVersion() {
        return this.apiSpecVersion;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof APISpec)) return false;
        final APISpec other = (APISpec) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$apiIsAuthOptional = this.getApiIsAuthOptional();
        final java.lang.Object other$apiIsAuthOptional = other.getApiIsAuthOptional();
        if (this$apiIsAuthOptional == null ? other$apiIsAuthOptional != null : !this$apiIsAuthOptional.equals(other$apiIsAuthOptional)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$apiExternalDocs = this.getApiExternalDocs();
        final java.lang.Object other$apiExternalDocs = other.getApiExternalDocs();
        if (this$apiExternalDocs == null ? other$apiExternalDocs != null : !this$apiExternalDocs.equals(other$apiExternalDocs)) return false;
        final java.lang.Object this$apiPaths = this.getApiPaths();
        final java.lang.Object other$apiPaths = other.getApiPaths();
        if (this$apiPaths == null ? other$apiPaths != null : !this$apiPaths.equals(other$apiPaths)) return false;
        final java.lang.Object this$apiSpecContactEmail = this.getApiSpecContactEmail();
        final java.lang.Object other$apiSpecContactEmail = other.getApiSpecContactEmail();
        if (this$apiSpecContactEmail == null ? other$apiSpecContactEmail != null : !this$apiSpecContactEmail.equals(other$apiSpecContactEmail)) return false;
        final java.lang.Object this$apiSpecContactName = this.getApiSpecContactName();
        final java.lang.Object other$apiSpecContactName = other.getApiSpecContactName();
        if (this$apiSpecContactName == null ? other$apiSpecContactName != null : !this$apiSpecContactName.equals(other$apiSpecContactName)) return false;
        final java.lang.Object this$apiSpecContactURL = this.getApiSpecContactURL();
        final java.lang.Object other$apiSpecContactURL = other.getApiSpecContactURL();
        if (this$apiSpecContactURL == null ? other$apiSpecContactURL != null : !this$apiSpecContactURL.equals(other$apiSpecContactURL)) return false;
        final java.lang.Object this$apiSpecContractVersion = this.getApiSpecContractVersion();
        final java.lang.Object other$apiSpecContractVersion = other.getApiSpecContractVersion();
        if (this$apiSpecContractVersion == null ? other$apiSpecContractVersion != null : !this$apiSpecContractVersion.equals(other$apiSpecContractVersion)) return false;
        final java.lang.Object this$apiSpecLicenseName = this.getApiSpecLicenseName();
        final java.lang.Object other$apiSpecLicenseName = other.getApiSpecLicenseName();
        if (this$apiSpecLicenseName == null ? other$apiSpecLicenseName != null : !this$apiSpecLicenseName.equals(other$apiSpecLicenseName)) return false;
        final java.lang.Object this$apiSpecLicenseURL = this.getApiSpecLicenseURL();
        final java.lang.Object other$apiSpecLicenseURL = other.getApiSpecLicenseURL();
        if (this$apiSpecLicenseURL == null ? other$apiSpecLicenseURL != null : !this$apiSpecLicenseURL.equals(other$apiSpecLicenseURL)) return false;
        final java.lang.Object this$apiSpecName = this.getApiSpecName();
        final java.lang.Object other$apiSpecName = other.getApiSpecName();
        if (this$apiSpecName == null ? other$apiSpecName != null : !this$apiSpecName.equals(other$apiSpecName)) return false;
        final java.lang.Object this$apiSpecQualifiedName = this.getApiSpecQualifiedName();
        final java.lang.Object other$apiSpecQualifiedName = other.getApiSpecQualifiedName();
        if (this$apiSpecQualifiedName == null ? other$apiSpecQualifiedName != null : !this$apiSpecQualifiedName.equals(other$apiSpecQualifiedName)) return false;
        final java.lang.Object this$apiSpecServiceAlias = this.getApiSpecServiceAlias();
        final java.lang.Object other$apiSpecServiceAlias = other.getApiSpecServiceAlias();
        if (this$apiSpecServiceAlias == null ? other$apiSpecServiceAlias != null : !this$apiSpecServiceAlias.equals(other$apiSpecServiceAlias)) return false;
        final java.lang.Object this$apiSpecTermsOfServiceURL = this.getApiSpecTermsOfServiceURL();
        final java.lang.Object other$apiSpecTermsOfServiceURL = other.getApiSpecTermsOfServiceURL();
        if (this$apiSpecTermsOfServiceURL == null ? other$apiSpecTermsOfServiceURL != null : !this$apiSpecTermsOfServiceURL.equals(other$apiSpecTermsOfServiceURL)) return false;
        final java.lang.Object this$apiSpecType = this.getApiSpecType();
        final java.lang.Object other$apiSpecType = other.getApiSpecType();
        if (this$apiSpecType == null ? other$apiSpecType != null : !this$apiSpecType.equals(other$apiSpecType)) return false;
        final java.lang.Object this$apiSpecVersion = this.getApiSpecVersion();
        final java.lang.Object other$apiSpecVersion = other.getApiSpecVersion();
        if (this$apiSpecVersion == null ? other$apiSpecVersion != null : !this$apiSpecVersion.equals(other$apiSpecVersion)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof APISpec;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $apiIsAuthOptional = this.getApiIsAuthOptional();
        result = result * PRIME + ($apiIsAuthOptional == null ? 43 : $apiIsAuthOptional.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $apiExternalDocs = this.getApiExternalDocs();
        result = result * PRIME + ($apiExternalDocs == null ? 43 : $apiExternalDocs.hashCode());
        final java.lang.Object $apiPaths = this.getApiPaths();
        result = result * PRIME + ($apiPaths == null ? 43 : $apiPaths.hashCode());
        final java.lang.Object $apiSpecContactEmail = this.getApiSpecContactEmail();
        result = result * PRIME + ($apiSpecContactEmail == null ? 43 : $apiSpecContactEmail.hashCode());
        final java.lang.Object $apiSpecContactName = this.getApiSpecContactName();
        result = result * PRIME + ($apiSpecContactName == null ? 43 : $apiSpecContactName.hashCode());
        final java.lang.Object $apiSpecContactURL = this.getApiSpecContactURL();
        result = result * PRIME + ($apiSpecContactURL == null ? 43 : $apiSpecContactURL.hashCode());
        final java.lang.Object $apiSpecContractVersion = this.getApiSpecContractVersion();
        result = result * PRIME + ($apiSpecContractVersion == null ? 43 : $apiSpecContractVersion.hashCode());
        final java.lang.Object $apiSpecLicenseName = this.getApiSpecLicenseName();
        result = result * PRIME + ($apiSpecLicenseName == null ? 43 : $apiSpecLicenseName.hashCode());
        final java.lang.Object $apiSpecLicenseURL = this.getApiSpecLicenseURL();
        result = result * PRIME + ($apiSpecLicenseURL == null ? 43 : $apiSpecLicenseURL.hashCode());
        final java.lang.Object $apiSpecName = this.getApiSpecName();
        result = result * PRIME + ($apiSpecName == null ? 43 : $apiSpecName.hashCode());
        final java.lang.Object $apiSpecQualifiedName = this.getApiSpecQualifiedName();
        result = result * PRIME + ($apiSpecQualifiedName == null ? 43 : $apiSpecQualifiedName.hashCode());
        final java.lang.Object $apiSpecServiceAlias = this.getApiSpecServiceAlias();
        result = result * PRIME + ($apiSpecServiceAlias == null ? 43 : $apiSpecServiceAlias.hashCode());
        final java.lang.Object $apiSpecTermsOfServiceURL = this.getApiSpecTermsOfServiceURL();
        result = result * PRIME + ($apiSpecTermsOfServiceURL == null ? 43 : $apiSpecTermsOfServiceURL.hashCode());
        final java.lang.Object $apiSpecType = this.getApiSpecType();
        result = result * PRIME + ($apiSpecType == null ? 43 : $apiSpecType.hashCode());
        final java.lang.Object $apiSpecVersion = this.getApiSpecVersion();
        result = result * PRIME + ($apiSpecVersion == null ? 43 : $apiSpecVersion.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "APISpec(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", apiExternalDocs=" + this.getApiExternalDocs() + ", apiIsAuthOptional=" + this.getApiIsAuthOptional() + ", apiPaths=" + this.getApiPaths() + ", apiSpecContactEmail=" + this.getApiSpecContactEmail() + ", apiSpecContactName=" + this.getApiSpecContactName() + ", apiSpecContactURL=" + this.getApiSpecContactURL() + ", apiSpecContractVersion=" + this.getApiSpecContractVersion() + ", apiSpecLicenseName=" + this.getApiSpecLicenseName() + ", apiSpecLicenseURL=" + this.getApiSpecLicenseURL() + ", apiSpecName=" + this.getApiSpecName() + ", apiSpecQualifiedName=" + this.getApiSpecQualifiedName() + ", apiSpecServiceAlias=" + this.getApiSpecServiceAlias() + ", apiSpecTermsOfServiceURL=" + this.getApiSpecTermsOfServiceURL() + ", apiSpecType=" + this.getApiSpecType() + ", apiSpecVersion=" + this.getApiSpecVersion() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for APISpecs.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
