// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.OpenLineageRunState;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of an Airflow DAG in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class AirflowDag extends Asset implements IAirflowDag, IAirflow, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(AirflowDag.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AirflowDag";
    /**
     * Fixed typeName for AirflowDags.
     */
    String typeName;
    /**
     * Schedule for the DAG.
     */
    @Attribute
    String airflowDagSchedule;
    /**
     * Duration between scheduled runs, in seconds.
     */
    @Attribute
    Long airflowDagScheduleDelta;
    /**
     * End time of the run.
     */
    @Attribute
    @Date
    Long airflowRunEndTime;
    /**
     * Name of the run.
     */
    @Attribute
    String airflowRunName;
    /**
     * State of the run in OpenLineage.
     */
    @Attribute
    OpenLineageRunState airflowRunOpenLineageState;
    /**
     * Version of the run in OpenLineage.
     */
    @Attribute
    String airflowRunOpenLineageVersion;
    /**
     * Start time of the run.
     */
    @Attribute
    @Date
    Long airflowRunStartTime;
    /**
     * Type of the run.
     */
    @Attribute
    String airflowRunType;
    /**
     * Version of the run in Airflow.
     */
    @Attribute
    String airflowRunVersion;
    /**
     * Tags assigned to the asset in Airflow.
     */
    @Attribute
    SortedSet<String> airflowTags;
    /**
     * Tasks that exist within this DAG.
     */
    @Attribute
    SortedSet<IAirflowTask> airflowTasks;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a AirflowDag, from a potentially
     * more-complete AirflowDag object.
     *
     * @return the minimal object necessary to relate to the AirflowDag
     * @throws InvalidRequestException if any of the minimal set of required properties for a AirflowDag relationship are not found in the initial object
     */
    @Override
    public AirflowDag trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all AirflowDag assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AirflowDag assets will be included.
     *
     * @return a fluent search that includes all AirflowDag assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all AirflowDag assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AirflowDag assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all AirflowDag assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all AirflowDag assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) AirflowDags will be included
     * @return a fluent search that includes all AirflowDag assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all AirflowDag assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) AirflowDags will be included
     * @return a fluent search that includes all AirflowDag assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a AirflowDag by GUID. Use this to create a relationship to this AirflowDag,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the AirflowDag to reference
     * @return reference to a AirflowDag that can be used for defining a relationship to a AirflowDag
     */
    public static AirflowDag refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AirflowDag by GUID. Use this to create a relationship to this AirflowDag,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the AirflowDag to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AirflowDag that can be used for defining a relationship to a AirflowDag
     */
    public static AirflowDag refByGuid(String guid, Reference.SaveSemantic semantic) {
        return AirflowDag._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a AirflowDag by qualifiedName. Use this to create a relationship to this AirflowDag,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the AirflowDag to reference
     * @return reference to a AirflowDag that can be used for defining a relationship to a AirflowDag
     */
    public static AirflowDag refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AirflowDag by qualifiedName. Use this to create a relationship to this AirflowDag,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the AirflowDag to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AirflowDag that can be used for defining a relationship to a AirflowDag
     */
    public static AirflowDag refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return AirflowDag._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a AirflowDag by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the AirflowDag to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AirflowDag, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AirflowDag does not exist or the provided GUID is not a AirflowDag
     */
    @JsonIgnore
    public static AirflowDag get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a AirflowDag by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AirflowDag to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AirflowDag, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AirflowDag does not exist or the provided GUID is not a AirflowDag
     */
    @JsonIgnore
    public static AirflowDag get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a AirflowDag by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AirflowDag to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full AirflowDag, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AirflowDag does not exist or the provided GUID is not a AirflowDag
     */
    @JsonIgnore
    public static AirflowDag get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof AirflowDag) {
                return (AirflowDag) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof AirflowDag) {
                return (AirflowDag) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) AirflowDag to active.
     *
     * @param qualifiedName for the AirflowDag
     * @return true if the AirflowDag is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) AirflowDag to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the AirflowDag
     * @return true if the AirflowDag is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create an AirflowDag.
     *
     * @param name of the AirflowDag
     * @param connectionQualifiedName unique name of the connection through which the DAG is accessible
     * @return the minimal object necessary to create the AirflowDag, as a builder
     */
    public static AirflowDagBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return AirflowDag._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(connectionQualifiedName + "/" + name).name(name).connectionQualifiedName(connectionQualifiedName).connectorType(Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName));
    }

    /**
     * Builds the minimal object necessary to update a AirflowDag.
     *
     * @param qualifiedName of the AirflowDag
     * @param name of the AirflowDag
     * @return the minimal request necessary to update the AirflowDag, as a builder
     */
    public static AirflowDagBuilder<?, ?> updater(String qualifiedName, String name) {
        return AirflowDag._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a AirflowDag, from a potentially
     * more-complete AirflowDag object.
     *
     * @return the minimal object necessary to update the AirflowDag, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for AirflowDag are not found in the initial object
     */
    @Override
    public AirflowDagBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a AirflowDag.
     *
     * @param qualifiedName of the AirflowDag
     * @param name of the AirflowDag
     * @return the updated AirflowDag, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a AirflowDag.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the AirflowDag
     * @param name of the AirflowDag
     * @return the updated AirflowDag, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowDag) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a AirflowDag.
     *
     * @param qualifiedName of the AirflowDag
     * @param name of the AirflowDag
     * @return the updated AirflowDag, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a AirflowDag.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the AirflowDag
     * @param name of the AirflowDag
     * @return the updated AirflowDag, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowDag) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a AirflowDag.
     *
     * @param qualifiedName of the AirflowDag
     * @param name of the AirflowDag
     * @return the updated AirflowDag, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a AirflowDag.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AirflowDag's owners
     * @param qualifiedName of the AirflowDag
     * @param name of the AirflowDag
     * @return the updated AirflowDag, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowDag) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a AirflowDag.
     *
     * @param qualifiedName of the AirflowDag
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AirflowDag, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a AirflowDag.
     *
     * @param client connectivity to the Atlan tenant on which to update the AirflowDag's certificate
     * @param qualifiedName of the AirflowDag
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AirflowDag, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AirflowDag) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a AirflowDag.
     *
     * @param qualifiedName of the AirflowDag
     * @param name of the AirflowDag
     * @return the updated AirflowDag, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a AirflowDag.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AirflowDag's certificate
     * @param qualifiedName of the AirflowDag
     * @param name of the AirflowDag
     * @return the updated AirflowDag, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowDag) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a AirflowDag.
     *
     * @param qualifiedName of the AirflowDag
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a AirflowDag.
     *
     * @param client connectivity to the Atlan tenant on which to update the AirflowDag's announcement
     * @param qualifiedName of the AirflowDag
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AirflowDag) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a AirflowDag.
     *
     * @param qualifiedName of the AirflowDag
     * @param name of the AirflowDag
     * @return the updated AirflowDag, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a AirflowDag.
     *
     * @param client connectivity to the Atlan client from which to remove the AirflowDag's announcement
     * @param qualifiedName of the AirflowDag
     * @param name of the AirflowDag
     * @return the updated AirflowDag, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowDag removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowDag) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the AirflowDag.
     *
     * @param qualifiedName for the AirflowDag
     * @param name human-readable name of the AirflowDag
     * @param terms the list of terms to replace on the AirflowDag, or null to remove all terms from the AirflowDag
     * @return the AirflowDag that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static AirflowDag replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the AirflowDag.
     *
     * @param client connectivity to the Atlan tenant on which to replace the AirflowDag's assigned terms
     * @param qualifiedName for the AirflowDag
     * @param name human-readable name of the AirflowDag
     * @param terms the list of terms to replace on the AirflowDag, or null to remove all terms from the AirflowDag
     * @return the AirflowDag that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static AirflowDag replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AirflowDag) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the AirflowDag, without replacing existing terms linked to the AirflowDag.
     * Note: this operation must make two API calls — one to retrieve the AirflowDag's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the AirflowDag
     * @param terms the list of terms to append to the AirflowDag
     * @return the AirflowDag that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static AirflowDag appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the AirflowDag, without replacing existing terms linked to the AirflowDag.
     * Note: this operation must make two API calls — one to retrieve the AirflowDag's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the AirflowDag
     * @param qualifiedName for the AirflowDag
     * @param terms the list of terms to append to the AirflowDag
     * @return the AirflowDag that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static AirflowDag appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AirflowDag) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a AirflowDag, without replacing all existing terms linked to the AirflowDag.
     * Note: this operation must make two API calls — one to retrieve the AirflowDag's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the AirflowDag
     * @param terms the list of terms to remove from the AirflowDag, which must be referenced by GUID
     * @return the AirflowDag that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static AirflowDag removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a AirflowDag, without replacing all existing terms linked to the AirflowDag.
     * Note: this operation must make two API calls — one to retrieve the AirflowDag's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the AirflowDag
     * @param qualifiedName for the AirflowDag
     * @param terms the list of terms to remove from the AirflowDag, which must be referenced by GUID
     * @return the AirflowDag that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static AirflowDag removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AirflowDag) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a AirflowDag, without replacing existing Atlan tags linked to the AirflowDag.
     * Note: this operation must make two API calls — one to retrieve the AirflowDag's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AirflowDag
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AirflowDag
     */
    public static AirflowDag appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AirflowDag, without replacing existing Atlan tags linked to the AirflowDag.
     * Note: this operation must make two API calls — one to retrieve the AirflowDag's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AirflowDag
     * @param qualifiedName of the AirflowDag
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AirflowDag
     */
    public static AirflowDag appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AirflowDag) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AirflowDag, without replacing existing Atlan tags linked to the AirflowDag.
     * Note: this operation must make two API calls — one to retrieve the AirflowDag's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AirflowDag
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AirflowDag
     */
    public static AirflowDag appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a AirflowDag, without replacing existing Atlan tags linked to the AirflowDag.
     * Note: this operation must make two API calls — one to retrieve the AirflowDag's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AirflowDag
     * @param qualifiedName of the AirflowDag
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AirflowDag
     */
    public static AirflowDag appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AirflowDag) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a AirflowDag.
     *
     * @param qualifiedName of the AirflowDag
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AirflowDag
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a AirflowDag.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a AirflowDag
     * @param qualifiedName of the AirflowDag
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AirflowDag
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AirflowDagBuilder<C extends AirflowDag, B extends AirflowDag.AirflowDagBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowDagSchedule;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long airflowDagScheduleDelta;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long airflowRunEndTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowRunName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineageRunState airflowRunOpenLineageState;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowRunOpenLineageVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long airflowRunStartTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowRunType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowRunVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> airflowTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> airflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AirflowDag.AirflowDagBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AirflowDag instance, final AirflowDag.AirflowDagBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.airflowDagSchedule(instance.airflowDagSchedule);
            b.airflowDagScheduleDelta(instance.airflowDagScheduleDelta);
            b.airflowRunEndTime(instance.airflowRunEndTime);
            b.airflowRunName(instance.airflowRunName);
            b.airflowRunOpenLineageState(instance.airflowRunOpenLineageState);
            b.airflowRunOpenLineageVersion(instance.airflowRunOpenLineageVersion);
            b.airflowRunStartTime(instance.airflowRunStartTime);
            b.airflowRunType(instance.airflowRunType);
            b.airflowRunVersion(instance.airflowRunVersion);
            b.airflowTags(instance.airflowTags == null ? java.util.Collections.<String>emptySortedSet() : instance.airflowTags);
            b.airflowTasks(instance.airflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.airflowTasks);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for AirflowDags.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Schedule for the DAG.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowDagSchedule(final String airflowDagSchedule) {
            this.airflowDagSchedule = airflowDagSchedule;
            return self();
        }

        /**
         * Duration between scheduled runs, in seconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowDagScheduleDelta(final Long airflowDagScheduleDelta) {
            this.airflowDagScheduleDelta = airflowDagScheduleDelta;
            return self();
        }

        /**
         * End time of the run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunEndTime(final Long airflowRunEndTime) {
            this.airflowRunEndTime = airflowRunEndTime;
            return self();
        }

        /**
         * Name of the run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunName(final String airflowRunName) {
            this.airflowRunName = airflowRunName;
            return self();
        }

        /**
         * State of the run in OpenLineage.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunOpenLineageState(final OpenLineageRunState airflowRunOpenLineageState) {
            this.airflowRunOpenLineageState = airflowRunOpenLineageState;
            return self();
        }

        /**
         * Version of the run in OpenLineage.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunOpenLineageVersion(final String airflowRunOpenLineageVersion) {
            this.airflowRunOpenLineageVersion = airflowRunOpenLineageVersion;
            return self();
        }

        /**
         * Start time of the run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunStartTime(final Long airflowRunStartTime) {
            this.airflowRunStartTime = airflowRunStartTime;
            return self();
        }

        /**
         * Type of the run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunType(final String airflowRunType) {
            this.airflowRunType = airflowRunType;
            return self();
        }

        /**
         * Version of the run in Airflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunVersion(final String airflowRunVersion) {
            this.airflowRunVersion = airflowRunVersion;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTag(final String airflowTag) {
            if (this.airflowTags == null) this.airflowTags = new java.util.ArrayList<String>();
            this.airflowTags.add(airflowTag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTags(final java.util.Collection<? extends String> airflowTags) {
            if (airflowTags == null) {
                throw new java.lang.NullPointerException("airflowTags cannot be null");
            }
            if (this.airflowTags == null) this.airflowTags = new java.util.ArrayList<String>();
            this.airflowTags.addAll(airflowTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAirflowTags() {
            if (this.airflowTags != null) this.airflowTags.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTask(final IAirflowTask airflowTask) {
            if (this.airflowTasks == null) this.airflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.airflowTasks.add(airflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTasks(final java.util.Collection<? extends IAirflowTask> airflowTasks) {
            if (airflowTasks == null) {
                throw new java.lang.NullPointerException("airflowTasks cannot be null");
            }
            if (this.airflowTasks == null) this.airflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.airflowTasks.addAll(airflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAirflowTasks() {
            if (this.airflowTasks != null) this.airflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AirflowDag.AirflowDagBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", airflowDagSchedule=" + this.airflowDagSchedule + ", airflowDagScheduleDelta=" + this.airflowDagScheduleDelta + ", airflowRunEndTime=" + this.airflowRunEndTime + ", airflowRunName=" + this.airflowRunName + ", airflowRunOpenLineageState=" + this.airflowRunOpenLineageState + ", airflowRunOpenLineageVersion=" + this.airflowRunOpenLineageVersion + ", airflowRunStartTime=" + this.airflowRunStartTime + ", airflowRunType=" + this.airflowRunType + ", airflowRunVersion=" + this.airflowRunVersion + ", airflowTags=" + this.airflowTags + ", airflowTasks=" + this.airflowTasks + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AirflowDagBuilderImpl extends AirflowDag.AirflowDagBuilder<AirflowDag, AirflowDag.AirflowDagBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AirflowDagBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AirflowDag.AirflowDagBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AirflowDag build() {
            return new AirflowDag(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AirflowDag(final AirflowDag.AirflowDagBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = AirflowDag.$default$typeName();
        this.airflowDagSchedule = b.airflowDagSchedule;
        this.airflowDagScheduleDelta = b.airflowDagScheduleDelta;
        this.airflowRunEndTime = b.airflowRunEndTime;
        this.airflowRunName = b.airflowRunName;
        this.airflowRunOpenLineageState = b.airflowRunOpenLineageState;
        this.airflowRunOpenLineageVersion = b.airflowRunOpenLineageVersion;
        this.airflowRunStartTime = b.airflowRunStartTime;
        this.airflowRunType = b.airflowRunType;
        this.airflowRunVersion = b.airflowRunVersion;
        java.util.SortedSet<String> airflowTags = new java.util.TreeSet<String>();
        if (b.airflowTags != null) airflowTags.addAll(b.airflowTags);
        airflowTags = java.util.Collections.unmodifiableSortedSet(airflowTags);
        this.airflowTags = airflowTags;
        java.util.SortedSet<IAirflowTask> airflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.airflowTasks != null) airflowTasks.addAll(b.airflowTasks);
        airflowTasks = java.util.Collections.unmodifiableSortedSet(airflowTasks);
        this.airflowTasks = airflowTasks;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AirflowDag.AirflowDagBuilder<?, ?> _internal() {
        return new AirflowDag.AirflowDagBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AirflowDag.AirflowDagBuilder<?, ?> toBuilder() {
        return new AirflowDag.AirflowDagBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Schedule for the DAG.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowDagSchedule() {
        return this.airflowDagSchedule;
    }

    /**
     * Duration between scheduled runs, in seconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAirflowDagScheduleDelta() {
        return this.airflowDagScheduleDelta;
    }

    /**
     * End time of the run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAirflowRunEndTime() {
        return this.airflowRunEndTime;
    }

    /**
     * Name of the run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowRunName() {
        return this.airflowRunName;
    }

    /**
     * State of the run in OpenLineage.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public OpenLineageRunState getAirflowRunOpenLineageState() {
        return this.airflowRunOpenLineageState;
    }

    /**
     * Version of the run in OpenLineage.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowRunOpenLineageVersion() {
        return this.airflowRunOpenLineageVersion;
    }

    /**
     * Start time of the run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAirflowRunStartTime() {
        return this.airflowRunStartTime;
    }

    /**
     * Type of the run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowRunType() {
        return this.airflowRunType;
    }

    /**
     * Version of the run in Airflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowRunVersion() {
        return this.airflowRunVersion;
    }

    /**
     * Tags assigned to the asset in Airflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAirflowTags() {
        return this.airflowTags;
    }

    /**
     * Tasks that exist within this DAG.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getAirflowTasks() {
        return this.airflowTasks;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AirflowDag)) return false;
        final AirflowDag other = (AirflowDag) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$airflowDagScheduleDelta = this.getAirflowDagScheduleDelta();
        final java.lang.Object other$airflowDagScheduleDelta = other.getAirflowDagScheduleDelta();
        if (this$airflowDagScheduleDelta == null ? other$airflowDagScheduleDelta != null : !this$airflowDagScheduleDelta.equals(other$airflowDagScheduleDelta)) return false;
        final java.lang.Object this$airflowRunEndTime = this.getAirflowRunEndTime();
        final java.lang.Object other$airflowRunEndTime = other.getAirflowRunEndTime();
        if (this$airflowRunEndTime == null ? other$airflowRunEndTime != null : !this$airflowRunEndTime.equals(other$airflowRunEndTime)) return false;
        final java.lang.Object this$airflowRunStartTime = this.getAirflowRunStartTime();
        final java.lang.Object other$airflowRunStartTime = other.getAirflowRunStartTime();
        if (this$airflowRunStartTime == null ? other$airflowRunStartTime != null : !this$airflowRunStartTime.equals(other$airflowRunStartTime)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$airflowDagSchedule = this.getAirflowDagSchedule();
        final java.lang.Object other$airflowDagSchedule = other.getAirflowDagSchedule();
        if (this$airflowDagSchedule == null ? other$airflowDagSchedule != null : !this$airflowDagSchedule.equals(other$airflowDagSchedule)) return false;
        final java.lang.Object this$airflowRunName = this.getAirflowRunName();
        final java.lang.Object other$airflowRunName = other.getAirflowRunName();
        if (this$airflowRunName == null ? other$airflowRunName != null : !this$airflowRunName.equals(other$airflowRunName)) return false;
        final java.lang.Object this$airflowRunOpenLineageState = this.getAirflowRunOpenLineageState();
        final java.lang.Object other$airflowRunOpenLineageState = other.getAirflowRunOpenLineageState();
        if (this$airflowRunOpenLineageState == null ? other$airflowRunOpenLineageState != null : !this$airflowRunOpenLineageState.equals(other$airflowRunOpenLineageState)) return false;
        final java.lang.Object this$airflowRunOpenLineageVersion = this.getAirflowRunOpenLineageVersion();
        final java.lang.Object other$airflowRunOpenLineageVersion = other.getAirflowRunOpenLineageVersion();
        if (this$airflowRunOpenLineageVersion == null ? other$airflowRunOpenLineageVersion != null : !this$airflowRunOpenLineageVersion.equals(other$airflowRunOpenLineageVersion)) return false;
        final java.lang.Object this$airflowRunType = this.getAirflowRunType();
        final java.lang.Object other$airflowRunType = other.getAirflowRunType();
        if (this$airflowRunType == null ? other$airflowRunType != null : !this$airflowRunType.equals(other$airflowRunType)) return false;
        final java.lang.Object this$airflowRunVersion = this.getAirflowRunVersion();
        final java.lang.Object other$airflowRunVersion = other.getAirflowRunVersion();
        if (this$airflowRunVersion == null ? other$airflowRunVersion != null : !this$airflowRunVersion.equals(other$airflowRunVersion)) return false;
        final java.lang.Object this$airflowTags = this.getAirflowTags();
        final java.lang.Object other$airflowTags = other.getAirflowTags();
        if (this$airflowTags == null ? other$airflowTags != null : !this$airflowTags.equals(other$airflowTags)) return false;
        final java.lang.Object this$airflowTasks = this.getAirflowTasks();
        final java.lang.Object other$airflowTasks = other.getAirflowTasks();
        if (this$airflowTasks == null ? other$airflowTasks != null : !this$airflowTasks.equals(other$airflowTasks)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AirflowDag;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $airflowDagScheduleDelta = this.getAirflowDagScheduleDelta();
        result = result * PRIME + ($airflowDagScheduleDelta == null ? 43 : $airflowDagScheduleDelta.hashCode());
        final java.lang.Object $airflowRunEndTime = this.getAirflowRunEndTime();
        result = result * PRIME + ($airflowRunEndTime == null ? 43 : $airflowRunEndTime.hashCode());
        final java.lang.Object $airflowRunStartTime = this.getAirflowRunStartTime();
        result = result * PRIME + ($airflowRunStartTime == null ? 43 : $airflowRunStartTime.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $airflowDagSchedule = this.getAirflowDagSchedule();
        result = result * PRIME + ($airflowDagSchedule == null ? 43 : $airflowDagSchedule.hashCode());
        final java.lang.Object $airflowRunName = this.getAirflowRunName();
        result = result * PRIME + ($airflowRunName == null ? 43 : $airflowRunName.hashCode());
        final java.lang.Object $airflowRunOpenLineageState = this.getAirflowRunOpenLineageState();
        result = result * PRIME + ($airflowRunOpenLineageState == null ? 43 : $airflowRunOpenLineageState.hashCode());
        final java.lang.Object $airflowRunOpenLineageVersion = this.getAirflowRunOpenLineageVersion();
        result = result * PRIME + ($airflowRunOpenLineageVersion == null ? 43 : $airflowRunOpenLineageVersion.hashCode());
        final java.lang.Object $airflowRunType = this.getAirflowRunType();
        result = result * PRIME + ($airflowRunType == null ? 43 : $airflowRunType.hashCode());
        final java.lang.Object $airflowRunVersion = this.getAirflowRunVersion();
        result = result * PRIME + ($airflowRunVersion == null ? 43 : $airflowRunVersion.hashCode());
        final java.lang.Object $airflowTags = this.getAirflowTags();
        result = result * PRIME + ($airflowTags == null ? 43 : $airflowTags.hashCode());
        final java.lang.Object $airflowTasks = this.getAirflowTasks();
        result = result * PRIME + ($airflowTasks == null ? 43 : $airflowTasks.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AirflowDag(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", airflowDagSchedule=" + this.getAirflowDagSchedule() + ", airflowDagScheduleDelta=" + this.getAirflowDagScheduleDelta() + ", airflowRunEndTime=" + this.getAirflowRunEndTime() + ", airflowRunName=" + this.getAirflowRunName() + ", airflowRunOpenLineageState=" + this.getAirflowRunOpenLineageState() + ", airflowRunOpenLineageVersion=" + this.getAirflowRunOpenLineageVersion() + ", airflowRunStartTime=" + this.getAirflowRunStartTime() + ", airflowRunType=" + this.getAirflowRunType() + ", airflowRunVersion=" + this.getAirflowRunVersion() + ", airflowTags=" + this.getAirflowTags() + ", airflowTasks=" + this.getAirflowTasks() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for AirflowDags.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
