// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.OpenLineageRunState;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of an Airflow task in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class AirflowTask extends Asset implements IAirflowTask, IAirflow, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(AirflowTask.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AirflowTask";
    /**
     * Fixed typeName for AirflowTasks.
     */
    String typeName;
    /**
     * DAG in which this task exists.
     */
    @Attribute
    IAirflowDag airflowDag;
    /**
     * Simple name of the DAG this task is contained within.
     */
    @Attribute
    String airflowDagName;
    /**
     * Unique name of the DAG this task is contained within.
     */
    @Attribute
    String airflowDagQualifiedName;
    /**
     * End time of the run.
     */
    @Attribute
    @Date
    Long airflowRunEndTime;
    /**
     * Name of the run.
     */
    @Attribute
    String airflowRunName;
    /**
     * State of the run in OpenLineage.
     */
    @Attribute
    OpenLineageRunState airflowRunOpenLineageState;
    /**
     * Version of the run in OpenLineage.
     */
    @Attribute
    String airflowRunOpenLineageVersion;
    /**
     * Start time of the run.
     */
    @Attribute
    @Date
    Long airflowRunStartTime;
    /**
     * Type of the run.
     */
    @Attribute
    String airflowRunType;
    /**
     * Version of the run in Airflow.
     */
    @Attribute
    String airflowRunVersion;
    /**
     * Tags assigned to the asset in Airflow.
     */
    @Attribute
    SortedSet<String> airflowTags;
    /**
     * Identifier for the connection this task accesses.
     */
    @Attribute
    String airflowTaskConnectionId;
    /**
     * Group name for the task.
     */
    @Attribute
    String airflowTaskGroupName;
    /**
     * Class name for the operator this task uses.
     */
    @Attribute
    String airflowTaskOperatorClass;
    /**
     * Pool on which this run happened.
     */
    @Attribute
    String airflowTaskPool;
    /**
     * Pool slots used for the run.
     */
    @Attribute
    Long airflowTaskPoolSlots;
    /**
     * Priority of the run.
     */
    @Attribute
    Long airflowTaskPriorityWeight;
    /**
     * Queue on which this run happened.
     */
    @Attribute
    String airflowTaskQueue;
    /**
     * Retry count for this task running.
     */
    @Attribute
    Long airflowTaskRetryNumber;
    /**
     * SQL code that executes through this task.
     */
    @Attribute
    String airflowTaskSql;
    /**
     * Trigger for the run.
     */
    @Attribute
    String airflowTaskTriggerRule;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Assets that are inputs to this task.
     */
    @Attribute
    SortedSet<ICatalog> inputs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Assets that are outputs from this task.
     */
    @Attribute
    SortedSet<ICatalog> outputs;
    /**
     * Process in which this task exists.
     */
    @Attribute
    ILineageProcess process;

    /**
     * Builds the minimal object necessary to create a relationship to a AirflowTask, from a potentially
     * more-complete AirflowTask object.
     *
     * @return the minimal object necessary to relate to the AirflowTask
     * @throws InvalidRequestException if any of the minimal set of required properties for a AirflowTask relationship are not found in the initial object
     */
    @Override
    public AirflowTask trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all AirflowTask assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AirflowTask assets will be included.
     *
     * @return a fluent search that includes all AirflowTask assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all AirflowTask assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AirflowTask assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all AirflowTask assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all AirflowTask assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) AirflowTasks will be included
     * @return a fluent search that includes all AirflowTask assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all AirflowTask assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) AirflowTasks will be included
     * @return a fluent search that includes all AirflowTask assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a AirflowTask by GUID. Use this to create a relationship to this AirflowTask,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the AirflowTask to reference
     * @return reference to a AirflowTask that can be used for defining a relationship to a AirflowTask
     */
    public static AirflowTask refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AirflowTask by GUID. Use this to create a relationship to this AirflowTask,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the AirflowTask to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AirflowTask that can be used for defining a relationship to a AirflowTask
     */
    public static AirflowTask refByGuid(String guid, Reference.SaveSemantic semantic) {
        return AirflowTask._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a AirflowTask by qualifiedName. Use this to create a relationship to this AirflowTask,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the AirflowTask to reference
     * @return reference to a AirflowTask that can be used for defining a relationship to a AirflowTask
     */
    public static AirflowTask refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AirflowTask by qualifiedName. Use this to create a relationship to this AirflowTask,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the AirflowTask to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AirflowTask that can be used for defining a relationship to a AirflowTask
     */
    public static AirflowTask refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return AirflowTask._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a AirflowTask by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the AirflowTask to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AirflowTask, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AirflowTask does not exist or the provided GUID is not a AirflowTask
     */
    @JsonIgnore
    public static AirflowTask get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a AirflowTask by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AirflowTask to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AirflowTask, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AirflowTask does not exist or the provided GUID is not a AirflowTask
     */
    @JsonIgnore
    public static AirflowTask get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a AirflowTask by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AirflowTask to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full AirflowTask, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AirflowTask does not exist or the provided GUID is not a AirflowTask
     */
    @JsonIgnore
    public static AirflowTask get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof AirflowTask) {
                return (AirflowTask) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof AirflowTask) {
                return (AirflowTask) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) AirflowTask to active.
     *
     * @param qualifiedName for the AirflowTask
     * @return true if the AirflowTask is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) AirflowTask to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the AirflowTask
     * @return true if the AirflowTask is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create an AirflowTask.
     *
     * @param name of the AirflowTask
     * @param airflowDag in which the AirflowTask should be created, which must have at least
     *                   a qualifiedName
     * @return the minimal request necessary to create the AirflowTask, as a builder
     * @throws InvalidRequestException if the AirflowDag provided is without a qualifiedName
     */
    public static AirflowTaskBuilder<?, ?> creator(String name, AirflowDag airflowDag) throws InvalidRequestException {
        validateRelationship(AirflowDag.TYPE_NAME, Map.of("qualifiedName", airflowDag.getQualifiedName()));
        return creator(name, airflowDag.getQualifiedName()).airflowDag(airflowDag.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create an AirflowTask.
     *
     * @param name of the AirflowTask
     * @param airflowDagQualifiedName unique name of the DAG through which the task is accessible
     * @return the minimal object necessary to create the AirflowTask, as a builder
     */
    public static AirflowTaskBuilder<?, ?> creator(String name, String airflowDagQualifiedName) {
        String[] tokens = airflowDagQualifiedName.split("/");
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(tokens);
        String airflowDagName = StringUtils.getNameFromQualifiedName(airflowDagQualifiedName);
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(airflowDagQualifiedName);
        return AirflowTask._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(airflowDagQualifiedName + "/" + name).name(name).airflowDagQualifiedName(airflowDagQualifiedName).airflowDagName(airflowDagName).airflowDag(AirflowDag.refByQualifiedName(airflowDagQualifiedName)).connectionQualifiedName(connectionQualifiedName).connectorType(Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName));
    }

    /**
     * Builds the minimal object necessary to update a AirflowTask.
     *
     * @param qualifiedName of the AirflowTask
     * @param name of the AirflowTask
     * @return the minimal request necessary to update the AirflowTask, as a builder
     */
    public static AirflowTaskBuilder<?, ?> updater(String qualifiedName, String name) {
        return AirflowTask._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a AirflowTask, from a potentially
     * more-complete AirflowTask object.
     *
     * @return the minimal object necessary to update the AirflowTask, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for AirflowTask are not found in the initial object
     */
    @Override
    public AirflowTaskBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a AirflowTask.
     *
     * @param qualifiedName of the AirflowTask
     * @param name of the AirflowTask
     * @return the updated AirflowTask, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a AirflowTask.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the AirflowTask
     * @param name of the AirflowTask
     * @return the updated AirflowTask, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowTask) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a AirflowTask.
     *
     * @param qualifiedName of the AirflowTask
     * @param name of the AirflowTask
     * @return the updated AirflowTask, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a AirflowTask.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the AirflowTask
     * @param name of the AirflowTask
     * @return the updated AirflowTask, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowTask) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a AirflowTask.
     *
     * @param qualifiedName of the AirflowTask
     * @param name of the AirflowTask
     * @return the updated AirflowTask, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a AirflowTask.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AirflowTask's owners
     * @param qualifiedName of the AirflowTask
     * @param name of the AirflowTask
     * @return the updated AirflowTask, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowTask) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a AirflowTask.
     *
     * @param qualifiedName of the AirflowTask
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AirflowTask, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a AirflowTask.
     *
     * @param client connectivity to the Atlan tenant on which to update the AirflowTask's certificate
     * @param qualifiedName of the AirflowTask
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AirflowTask, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AirflowTask) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a AirflowTask.
     *
     * @param qualifiedName of the AirflowTask
     * @param name of the AirflowTask
     * @return the updated AirflowTask, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a AirflowTask.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AirflowTask's certificate
     * @param qualifiedName of the AirflowTask
     * @param name of the AirflowTask
     * @return the updated AirflowTask, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowTask) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a AirflowTask.
     *
     * @param qualifiedName of the AirflowTask
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a AirflowTask.
     *
     * @param client connectivity to the Atlan tenant on which to update the AirflowTask's announcement
     * @param qualifiedName of the AirflowTask
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AirflowTask) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a AirflowTask.
     *
     * @param qualifiedName of the AirflowTask
     * @param name of the AirflowTask
     * @return the updated AirflowTask, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a AirflowTask.
     *
     * @param client connectivity to the Atlan client from which to remove the AirflowTask's announcement
     * @param qualifiedName of the AirflowTask
     * @param name of the AirflowTask
     * @return the updated AirflowTask, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AirflowTask removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowTask) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the AirflowTask.
     *
     * @param qualifiedName for the AirflowTask
     * @param name human-readable name of the AirflowTask
     * @param terms the list of terms to replace on the AirflowTask, or null to remove all terms from the AirflowTask
     * @return the AirflowTask that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static AirflowTask replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the AirflowTask.
     *
     * @param client connectivity to the Atlan tenant on which to replace the AirflowTask's assigned terms
     * @param qualifiedName for the AirflowTask
     * @param name human-readable name of the AirflowTask
     * @param terms the list of terms to replace on the AirflowTask, or null to remove all terms from the AirflowTask
     * @return the AirflowTask that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static AirflowTask replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AirflowTask) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the AirflowTask, without replacing existing terms linked to the AirflowTask.
     * Note: this operation must make two API calls — one to retrieve the AirflowTask's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the AirflowTask
     * @param terms the list of terms to append to the AirflowTask
     * @return the AirflowTask that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static AirflowTask appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the AirflowTask, without replacing existing terms linked to the AirflowTask.
     * Note: this operation must make two API calls — one to retrieve the AirflowTask's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the AirflowTask
     * @param qualifiedName for the AirflowTask
     * @param terms the list of terms to append to the AirflowTask
     * @return the AirflowTask that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static AirflowTask appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AirflowTask) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a AirflowTask, without replacing all existing terms linked to the AirflowTask.
     * Note: this operation must make two API calls — one to retrieve the AirflowTask's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the AirflowTask
     * @param terms the list of terms to remove from the AirflowTask, which must be referenced by GUID
     * @return the AirflowTask that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static AirflowTask removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a AirflowTask, without replacing all existing terms linked to the AirflowTask.
     * Note: this operation must make two API calls — one to retrieve the AirflowTask's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the AirflowTask
     * @param qualifiedName for the AirflowTask
     * @param terms the list of terms to remove from the AirflowTask, which must be referenced by GUID
     * @return the AirflowTask that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static AirflowTask removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AirflowTask) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a AirflowTask, without replacing existing Atlan tags linked to the AirflowTask.
     * Note: this operation must make two API calls — one to retrieve the AirflowTask's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AirflowTask
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AirflowTask
     */
    public static AirflowTask appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AirflowTask, without replacing existing Atlan tags linked to the AirflowTask.
     * Note: this operation must make two API calls — one to retrieve the AirflowTask's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AirflowTask
     * @param qualifiedName of the AirflowTask
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AirflowTask
     */
    public static AirflowTask appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AirflowTask) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AirflowTask, without replacing existing Atlan tags linked to the AirflowTask.
     * Note: this operation must make two API calls — one to retrieve the AirflowTask's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AirflowTask
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AirflowTask
     */
    public static AirflowTask appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a AirflowTask, without replacing existing Atlan tags linked to the AirflowTask.
     * Note: this operation must make two API calls — one to retrieve the AirflowTask's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AirflowTask
     * @param qualifiedName of the AirflowTask
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AirflowTask
     */
    public static AirflowTask appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AirflowTask) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a AirflowTask.
     *
     * @param qualifiedName of the AirflowTask
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AirflowTask
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a AirflowTask.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a AirflowTask
     * @param qualifiedName of the AirflowTask
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AirflowTask
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AirflowTaskBuilder<C extends AirflowTask, B extends AirflowTask.AirflowTaskBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IAirflowDag airflowDag;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowDagName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowDagQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long airflowRunEndTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowRunName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineageRunState airflowRunOpenLineageState;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowRunOpenLineageVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long airflowRunStartTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowRunType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowRunVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> airflowTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowTaskConnectionId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowTaskGroupName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowTaskOperatorClass;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowTaskPool;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long airflowTaskPoolSlots;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long airflowTaskPriorityWeight;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowTaskQueue;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long airflowTaskRetryNumber;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowTaskSql;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String airflowTaskTriggerRule;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICatalog> inputs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICatalog> outputs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILineageProcess process;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AirflowTask.AirflowTaskBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AirflowTask instance, final AirflowTask.AirflowTaskBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.airflowDag(instance.airflowDag);
            b.airflowDagName(instance.airflowDagName);
            b.airflowDagQualifiedName(instance.airflowDagQualifiedName);
            b.airflowRunEndTime(instance.airflowRunEndTime);
            b.airflowRunName(instance.airflowRunName);
            b.airflowRunOpenLineageState(instance.airflowRunOpenLineageState);
            b.airflowRunOpenLineageVersion(instance.airflowRunOpenLineageVersion);
            b.airflowRunStartTime(instance.airflowRunStartTime);
            b.airflowRunType(instance.airflowRunType);
            b.airflowRunVersion(instance.airflowRunVersion);
            b.airflowTags(instance.airflowTags == null ? java.util.Collections.<String>emptySortedSet() : instance.airflowTags);
            b.airflowTaskConnectionId(instance.airflowTaskConnectionId);
            b.airflowTaskGroupName(instance.airflowTaskGroupName);
            b.airflowTaskOperatorClass(instance.airflowTaskOperatorClass);
            b.airflowTaskPool(instance.airflowTaskPool);
            b.airflowTaskPoolSlots(instance.airflowTaskPoolSlots);
            b.airflowTaskPriorityWeight(instance.airflowTaskPriorityWeight);
            b.airflowTaskQueue(instance.airflowTaskQueue);
            b.airflowTaskRetryNumber(instance.airflowTaskRetryNumber);
            b.airflowTaskSql(instance.airflowTaskSql);
            b.airflowTaskTriggerRule(instance.airflowTaskTriggerRule);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.inputs(instance.inputs == null ? java.util.Collections.<ICatalog>emptySortedSet() : instance.inputs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.outputs(instance.outputs == null ? java.util.Collections.<ICatalog>emptySortedSet() : instance.outputs);
            b.process(instance.process);
        }

        /**
         * Fixed typeName for AirflowTasks.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * DAG in which this task exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowDag(final IAirflowDag airflowDag) {
            this.airflowDag = airflowDag;
            return self();
        }

        /**
         * Simple name of the DAG this task is contained within.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowDagName(final String airflowDagName) {
            this.airflowDagName = airflowDagName;
            return self();
        }

        /**
         * Unique name of the DAG this task is contained within.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowDagQualifiedName(final String airflowDagQualifiedName) {
            this.airflowDagQualifiedName = airflowDagQualifiedName;
            return self();
        }

        /**
         * End time of the run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunEndTime(final Long airflowRunEndTime) {
            this.airflowRunEndTime = airflowRunEndTime;
            return self();
        }

        /**
         * Name of the run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunName(final String airflowRunName) {
            this.airflowRunName = airflowRunName;
            return self();
        }

        /**
         * State of the run in OpenLineage.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunOpenLineageState(final OpenLineageRunState airflowRunOpenLineageState) {
            this.airflowRunOpenLineageState = airflowRunOpenLineageState;
            return self();
        }

        /**
         * Version of the run in OpenLineage.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunOpenLineageVersion(final String airflowRunOpenLineageVersion) {
            this.airflowRunOpenLineageVersion = airflowRunOpenLineageVersion;
            return self();
        }

        /**
         * Start time of the run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunStartTime(final Long airflowRunStartTime) {
            this.airflowRunStartTime = airflowRunStartTime;
            return self();
        }

        /**
         * Type of the run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunType(final String airflowRunType) {
            this.airflowRunType = airflowRunType;
            return self();
        }

        /**
         * Version of the run in Airflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowRunVersion(final String airflowRunVersion) {
            this.airflowRunVersion = airflowRunVersion;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTag(final String airflowTag) {
            if (this.airflowTags == null) this.airflowTags = new java.util.ArrayList<String>();
            this.airflowTags.add(airflowTag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTags(final java.util.Collection<? extends String> airflowTags) {
            if (airflowTags == null) {
                throw new java.lang.NullPointerException("airflowTags cannot be null");
            }
            if (this.airflowTags == null) this.airflowTags = new java.util.ArrayList<String>();
            this.airflowTags.addAll(airflowTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAirflowTags() {
            if (this.airflowTags != null) this.airflowTags.clear();
            return self();
        }

        /**
         * Identifier for the connection this task accesses.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTaskConnectionId(final String airflowTaskConnectionId) {
            this.airflowTaskConnectionId = airflowTaskConnectionId;
            return self();
        }

        /**
         * Group name for the task.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTaskGroupName(final String airflowTaskGroupName) {
            this.airflowTaskGroupName = airflowTaskGroupName;
            return self();
        }

        /**
         * Class name for the operator this task uses.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTaskOperatorClass(final String airflowTaskOperatorClass) {
            this.airflowTaskOperatorClass = airflowTaskOperatorClass;
            return self();
        }

        /**
         * Pool on which this run happened.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTaskPool(final String airflowTaskPool) {
            this.airflowTaskPool = airflowTaskPool;
            return self();
        }

        /**
         * Pool slots used for the run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTaskPoolSlots(final Long airflowTaskPoolSlots) {
            this.airflowTaskPoolSlots = airflowTaskPoolSlots;
            return self();
        }

        /**
         * Priority of the run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTaskPriorityWeight(final Long airflowTaskPriorityWeight) {
            this.airflowTaskPriorityWeight = airflowTaskPriorityWeight;
            return self();
        }

        /**
         * Queue on which this run happened.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTaskQueue(final String airflowTaskQueue) {
            this.airflowTaskQueue = airflowTaskQueue;
            return self();
        }

        /**
         * Retry count for this task running.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTaskRetryNumber(final Long airflowTaskRetryNumber) {
            this.airflowTaskRetryNumber = airflowTaskRetryNumber;
            return self();
        }

        /**
         * SQL code that executes through this task.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTaskSql(final String airflowTaskSql) {
            this.airflowTaskSql = airflowTaskSql;
            return self();
        }

        /**
         * Trigger for the run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTaskTriggerRule(final String airflowTaskTriggerRule) {
            this.airflowTaskTriggerRule = airflowTaskTriggerRule;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B input(final ICatalog input) {
            if (this.inputs == null) this.inputs = new java.util.ArrayList<ICatalog>();
            this.inputs.add(input);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputs(final java.util.Collection<? extends ICatalog> inputs) {
            if (inputs == null) {
                throw new java.lang.NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) this.inputs = new java.util.ArrayList<ICatalog>();
            this.inputs.addAll(inputs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputs() {
            if (this.inputs != null) this.inputs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B output(final ICatalog output) {
            if (this.outputs == null) this.outputs = new java.util.ArrayList<ICatalog>();
            this.outputs.add(output);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputs(final java.util.Collection<? extends ICatalog> outputs) {
            if (outputs == null) {
                throw new java.lang.NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) this.outputs = new java.util.ArrayList<ICatalog>();
            this.outputs.addAll(outputs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputs() {
            if (this.outputs != null) this.outputs.clear();
            return self();
        }

        /**
         * Process in which this task exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B process(final ILineageProcess process) {
            this.process = process;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AirflowTask.AirflowTaskBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", airflowDag=" + this.airflowDag + ", airflowDagName=" + this.airflowDagName + ", airflowDagQualifiedName=" + this.airflowDagQualifiedName + ", airflowRunEndTime=" + this.airflowRunEndTime + ", airflowRunName=" + this.airflowRunName + ", airflowRunOpenLineageState=" + this.airflowRunOpenLineageState + ", airflowRunOpenLineageVersion=" + this.airflowRunOpenLineageVersion + ", airflowRunStartTime=" + this.airflowRunStartTime + ", airflowRunType=" + this.airflowRunType + ", airflowRunVersion=" + this.airflowRunVersion + ", airflowTags=" + this.airflowTags + ", airflowTaskConnectionId=" + this.airflowTaskConnectionId + ", airflowTaskGroupName=" + this.airflowTaskGroupName + ", airflowTaskOperatorClass=" + this.airflowTaskOperatorClass + ", airflowTaskPool=" + this.airflowTaskPool + ", airflowTaskPoolSlots=" + this.airflowTaskPoolSlots + ", airflowTaskPriorityWeight=" + this.airflowTaskPriorityWeight + ", airflowTaskQueue=" + this.airflowTaskQueue + ", airflowTaskRetryNumber=" + this.airflowTaskRetryNumber + ", airflowTaskSql=" + this.airflowTaskSql + ", airflowTaskTriggerRule=" + this.airflowTaskTriggerRule + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", inputs=" + this.inputs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", outputs=" + this.outputs + ", process=" + this.process + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AirflowTaskBuilderImpl extends AirflowTask.AirflowTaskBuilder<AirflowTask, AirflowTask.AirflowTaskBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AirflowTaskBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AirflowTask.AirflowTaskBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AirflowTask build() {
            return new AirflowTask(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AirflowTask(final AirflowTask.AirflowTaskBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = AirflowTask.$default$typeName();
        this.airflowDag = b.airflowDag;
        this.airflowDagName = b.airflowDagName;
        this.airflowDagQualifiedName = b.airflowDagQualifiedName;
        this.airflowRunEndTime = b.airflowRunEndTime;
        this.airflowRunName = b.airflowRunName;
        this.airflowRunOpenLineageState = b.airflowRunOpenLineageState;
        this.airflowRunOpenLineageVersion = b.airflowRunOpenLineageVersion;
        this.airflowRunStartTime = b.airflowRunStartTime;
        this.airflowRunType = b.airflowRunType;
        this.airflowRunVersion = b.airflowRunVersion;
        java.util.SortedSet<String> airflowTags = new java.util.TreeSet<String>();
        if (b.airflowTags != null) airflowTags.addAll(b.airflowTags);
        airflowTags = java.util.Collections.unmodifiableSortedSet(airflowTags);
        this.airflowTags = airflowTags;
        this.airflowTaskConnectionId = b.airflowTaskConnectionId;
        this.airflowTaskGroupName = b.airflowTaskGroupName;
        this.airflowTaskOperatorClass = b.airflowTaskOperatorClass;
        this.airflowTaskPool = b.airflowTaskPool;
        this.airflowTaskPoolSlots = b.airflowTaskPoolSlots;
        this.airflowTaskPriorityWeight = b.airflowTaskPriorityWeight;
        this.airflowTaskQueue = b.airflowTaskQueue;
        this.airflowTaskRetryNumber = b.airflowTaskRetryNumber;
        this.airflowTaskSql = b.airflowTaskSql;
        this.airflowTaskTriggerRule = b.airflowTaskTriggerRule;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<ICatalog> inputs = new java.util.TreeSet<ICatalog>();
        if (b.inputs != null) inputs.addAll(b.inputs);
        inputs = java.util.Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.SortedSet<ICatalog> outputs = new java.util.TreeSet<ICatalog>();
        if (b.outputs != null) outputs.addAll(b.outputs);
        outputs = java.util.Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
        this.process = b.process;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AirflowTask.AirflowTaskBuilder<?, ?> _internal() {
        return new AirflowTask.AirflowTaskBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AirflowTask.AirflowTaskBuilder<?, ?> toBuilder() {
        return new AirflowTask.AirflowTaskBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * DAG in which this task exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IAirflowDag getAirflowDag() {
        return this.airflowDag;
    }

    /**
     * Simple name of the DAG this task is contained within.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowDagName() {
        return this.airflowDagName;
    }

    /**
     * Unique name of the DAG this task is contained within.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowDagQualifiedName() {
        return this.airflowDagQualifiedName;
    }

    /**
     * End time of the run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAirflowRunEndTime() {
        return this.airflowRunEndTime;
    }

    /**
     * Name of the run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowRunName() {
        return this.airflowRunName;
    }

    /**
     * State of the run in OpenLineage.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public OpenLineageRunState getAirflowRunOpenLineageState() {
        return this.airflowRunOpenLineageState;
    }

    /**
     * Version of the run in OpenLineage.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowRunOpenLineageVersion() {
        return this.airflowRunOpenLineageVersion;
    }

    /**
     * Start time of the run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAirflowRunStartTime() {
        return this.airflowRunStartTime;
    }

    /**
     * Type of the run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowRunType() {
        return this.airflowRunType;
    }

    /**
     * Version of the run in Airflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowRunVersion() {
        return this.airflowRunVersion;
    }

    /**
     * Tags assigned to the asset in Airflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAirflowTags() {
        return this.airflowTags;
    }

    /**
     * Identifier for the connection this task accesses.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowTaskConnectionId() {
        return this.airflowTaskConnectionId;
    }

    /**
     * Group name for the task.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowTaskGroupName() {
        return this.airflowTaskGroupName;
    }

    /**
     * Class name for the operator this task uses.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowTaskOperatorClass() {
        return this.airflowTaskOperatorClass;
    }

    /**
     * Pool on which this run happened.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowTaskPool() {
        return this.airflowTaskPool;
    }

    /**
     * Pool slots used for the run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAirflowTaskPoolSlots() {
        return this.airflowTaskPoolSlots;
    }

    /**
     * Priority of the run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAirflowTaskPriorityWeight() {
        return this.airflowTaskPriorityWeight;
    }

    /**
     * Queue on which this run happened.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowTaskQueue() {
        return this.airflowTaskQueue;
    }

    /**
     * Retry count for this task running.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAirflowTaskRetryNumber() {
        return this.airflowTaskRetryNumber;
    }

    /**
     * SQL code that executes through this task.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowTaskSql() {
        return this.airflowTaskSql;
    }

    /**
     * Trigger for the run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAirflowTaskTriggerRule() {
        return this.airflowTaskTriggerRule;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Assets that are inputs to this task.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICatalog> getInputs() {
        return this.inputs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Assets that are outputs from this task.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICatalog> getOutputs() {
        return this.outputs;
    }

    /**
     * Process in which this task exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILineageProcess getProcess() {
        return this.process;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AirflowTask)) return false;
        final AirflowTask other = (AirflowTask) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$airflowRunEndTime = this.getAirflowRunEndTime();
        final java.lang.Object other$airflowRunEndTime = other.getAirflowRunEndTime();
        if (this$airflowRunEndTime == null ? other$airflowRunEndTime != null : !this$airflowRunEndTime.equals(other$airflowRunEndTime)) return false;
        final java.lang.Object this$airflowRunStartTime = this.getAirflowRunStartTime();
        final java.lang.Object other$airflowRunStartTime = other.getAirflowRunStartTime();
        if (this$airflowRunStartTime == null ? other$airflowRunStartTime != null : !this$airflowRunStartTime.equals(other$airflowRunStartTime)) return false;
        final java.lang.Object this$airflowTaskPoolSlots = this.getAirflowTaskPoolSlots();
        final java.lang.Object other$airflowTaskPoolSlots = other.getAirflowTaskPoolSlots();
        if (this$airflowTaskPoolSlots == null ? other$airflowTaskPoolSlots != null : !this$airflowTaskPoolSlots.equals(other$airflowTaskPoolSlots)) return false;
        final java.lang.Object this$airflowTaskPriorityWeight = this.getAirflowTaskPriorityWeight();
        final java.lang.Object other$airflowTaskPriorityWeight = other.getAirflowTaskPriorityWeight();
        if (this$airflowTaskPriorityWeight == null ? other$airflowTaskPriorityWeight != null : !this$airflowTaskPriorityWeight.equals(other$airflowTaskPriorityWeight)) return false;
        final java.lang.Object this$airflowTaskRetryNumber = this.getAirflowTaskRetryNumber();
        final java.lang.Object other$airflowTaskRetryNumber = other.getAirflowTaskRetryNumber();
        if (this$airflowTaskRetryNumber == null ? other$airflowTaskRetryNumber != null : !this$airflowTaskRetryNumber.equals(other$airflowTaskRetryNumber)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$airflowDag = this.getAirflowDag();
        final java.lang.Object other$airflowDag = other.getAirflowDag();
        if (this$airflowDag == null ? other$airflowDag != null : !this$airflowDag.equals(other$airflowDag)) return false;
        final java.lang.Object this$airflowDagName = this.getAirflowDagName();
        final java.lang.Object other$airflowDagName = other.getAirflowDagName();
        if (this$airflowDagName == null ? other$airflowDagName != null : !this$airflowDagName.equals(other$airflowDagName)) return false;
        final java.lang.Object this$airflowDagQualifiedName = this.getAirflowDagQualifiedName();
        final java.lang.Object other$airflowDagQualifiedName = other.getAirflowDagQualifiedName();
        if (this$airflowDagQualifiedName == null ? other$airflowDagQualifiedName != null : !this$airflowDagQualifiedName.equals(other$airflowDagQualifiedName)) return false;
        final java.lang.Object this$airflowRunName = this.getAirflowRunName();
        final java.lang.Object other$airflowRunName = other.getAirflowRunName();
        if (this$airflowRunName == null ? other$airflowRunName != null : !this$airflowRunName.equals(other$airflowRunName)) return false;
        final java.lang.Object this$airflowRunOpenLineageState = this.getAirflowRunOpenLineageState();
        final java.lang.Object other$airflowRunOpenLineageState = other.getAirflowRunOpenLineageState();
        if (this$airflowRunOpenLineageState == null ? other$airflowRunOpenLineageState != null : !this$airflowRunOpenLineageState.equals(other$airflowRunOpenLineageState)) return false;
        final java.lang.Object this$airflowRunOpenLineageVersion = this.getAirflowRunOpenLineageVersion();
        final java.lang.Object other$airflowRunOpenLineageVersion = other.getAirflowRunOpenLineageVersion();
        if (this$airflowRunOpenLineageVersion == null ? other$airflowRunOpenLineageVersion != null : !this$airflowRunOpenLineageVersion.equals(other$airflowRunOpenLineageVersion)) return false;
        final java.lang.Object this$airflowRunType = this.getAirflowRunType();
        final java.lang.Object other$airflowRunType = other.getAirflowRunType();
        if (this$airflowRunType == null ? other$airflowRunType != null : !this$airflowRunType.equals(other$airflowRunType)) return false;
        final java.lang.Object this$airflowRunVersion = this.getAirflowRunVersion();
        final java.lang.Object other$airflowRunVersion = other.getAirflowRunVersion();
        if (this$airflowRunVersion == null ? other$airflowRunVersion != null : !this$airflowRunVersion.equals(other$airflowRunVersion)) return false;
        final java.lang.Object this$airflowTags = this.getAirflowTags();
        final java.lang.Object other$airflowTags = other.getAirflowTags();
        if (this$airflowTags == null ? other$airflowTags != null : !this$airflowTags.equals(other$airflowTags)) return false;
        final java.lang.Object this$airflowTaskConnectionId = this.getAirflowTaskConnectionId();
        final java.lang.Object other$airflowTaskConnectionId = other.getAirflowTaskConnectionId();
        if (this$airflowTaskConnectionId == null ? other$airflowTaskConnectionId != null : !this$airflowTaskConnectionId.equals(other$airflowTaskConnectionId)) return false;
        final java.lang.Object this$airflowTaskGroupName = this.getAirflowTaskGroupName();
        final java.lang.Object other$airflowTaskGroupName = other.getAirflowTaskGroupName();
        if (this$airflowTaskGroupName == null ? other$airflowTaskGroupName != null : !this$airflowTaskGroupName.equals(other$airflowTaskGroupName)) return false;
        final java.lang.Object this$airflowTaskOperatorClass = this.getAirflowTaskOperatorClass();
        final java.lang.Object other$airflowTaskOperatorClass = other.getAirflowTaskOperatorClass();
        if (this$airflowTaskOperatorClass == null ? other$airflowTaskOperatorClass != null : !this$airflowTaskOperatorClass.equals(other$airflowTaskOperatorClass)) return false;
        final java.lang.Object this$airflowTaskPool = this.getAirflowTaskPool();
        final java.lang.Object other$airflowTaskPool = other.getAirflowTaskPool();
        if (this$airflowTaskPool == null ? other$airflowTaskPool != null : !this$airflowTaskPool.equals(other$airflowTaskPool)) return false;
        final java.lang.Object this$airflowTaskQueue = this.getAirflowTaskQueue();
        final java.lang.Object other$airflowTaskQueue = other.getAirflowTaskQueue();
        if (this$airflowTaskQueue == null ? other$airflowTaskQueue != null : !this$airflowTaskQueue.equals(other$airflowTaskQueue)) return false;
        final java.lang.Object this$airflowTaskSql = this.getAirflowTaskSql();
        final java.lang.Object other$airflowTaskSql = other.getAirflowTaskSql();
        if (this$airflowTaskSql == null ? other$airflowTaskSql != null : !this$airflowTaskSql.equals(other$airflowTaskSql)) return false;
        final java.lang.Object this$airflowTaskTriggerRule = this.getAirflowTaskTriggerRule();
        final java.lang.Object other$airflowTaskTriggerRule = other.getAirflowTaskTriggerRule();
        if (this$airflowTaskTriggerRule == null ? other$airflowTaskTriggerRule != null : !this$airflowTaskTriggerRule.equals(other$airflowTaskTriggerRule)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$inputs = this.getInputs();
        final java.lang.Object other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$outputs = this.getOutputs();
        final java.lang.Object other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) return false;
        final java.lang.Object this$process = this.getProcess();
        final java.lang.Object other$process = other.getProcess();
        if (this$process == null ? other$process != null : !this$process.equals(other$process)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AirflowTask;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $airflowRunEndTime = this.getAirflowRunEndTime();
        result = result * PRIME + ($airflowRunEndTime == null ? 43 : $airflowRunEndTime.hashCode());
        final java.lang.Object $airflowRunStartTime = this.getAirflowRunStartTime();
        result = result * PRIME + ($airflowRunStartTime == null ? 43 : $airflowRunStartTime.hashCode());
        final java.lang.Object $airflowTaskPoolSlots = this.getAirflowTaskPoolSlots();
        result = result * PRIME + ($airflowTaskPoolSlots == null ? 43 : $airflowTaskPoolSlots.hashCode());
        final java.lang.Object $airflowTaskPriorityWeight = this.getAirflowTaskPriorityWeight();
        result = result * PRIME + ($airflowTaskPriorityWeight == null ? 43 : $airflowTaskPriorityWeight.hashCode());
        final java.lang.Object $airflowTaskRetryNumber = this.getAirflowTaskRetryNumber();
        result = result * PRIME + ($airflowTaskRetryNumber == null ? 43 : $airflowTaskRetryNumber.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $airflowDag = this.getAirflowDag();
        result = result * PRIME + ($airflowDag == null ? 43 : $airflowDag.hashCode());
        final java.lang.Object $airflowDagName = this.getAirflowDagName();
        result = result * PRIME + ($airflowDagName == null ? 43 : $airflowDagName.hashCode());
        final java.lang.Object $airflowDagQualifiedName = this.getAirflowDagQualifiedName();
        result = result * PRIME + ($airflowDagQualifiedName == null ? 43 : $airflowDagQualifiedName.hashCode());
        final java.lang.Object $airflowRunName = this.getAirflowRunName();
        result = result * PRIME + ($airflowRunName == null ? 43 : $airflowRunName.hashCode());
        final java.lang.Object $airflowRunOpenLineageState = this.getAirflowRunOpenLineageState();
        result = result * PRIME + ($airflowRunOpenLineageState == null ? 43 : $airflowRunOpenLineageState.hashCode());
        final java.lang.Object $airflowRunOpenLineageVersion = this.getAirflowRunOpenLineageVersion();
        result = result * PRIME + ($airflowRunOpenLineageVersion == null ? 43 : $airflowRunOpenLineageVersion.hashCode());
        final java.lang.Object $airflowRunType = this.getAirflowRunType();
        result = result * PRIME + ($airflowRunType == null ? 43 : $airflowRunType.hashCode());
        final java.lang.Object $airflowRunVersion = this.getAirflowRunVersion();
        result = result * PRIME + ($airflowRunVersion == null ? 43 : $airflowRunVersion.hashCode());
        final java.lang.Object $airflowTags = this.getAirflowTags();
        result = result * PRIME + ($airflowTags == null ? 43 : $airflowTags.hashCode());
        final java.lang.Object $airflowTaskConnectionId = this.getAirflowTaskConnectionId();
        result = result * PRIME + ($airflowTaskConnectionId == null ? 43 : $airflowTaskConnectionId.hashCode());
        final java.lang.Object $airflowTaskGroupName = this.getAirflowTaskGroupName();
        result = result * PRIME + ($airflowTaskGroupName == null ? 43 : $airflowTaskGroupName.hashCode());
        final java.lang.Object $airflowTaskOperatorClass = this.getAirflowTaskOperatorClass();
        result = result * PRIME + ($airflowTaskOperatorClass == null ? 43 : $airflowTaskOperatorClass.hashCode());
        final java.lang.Object $airflowTaskPool = this.getAirflowTaskPool();
        result = result * PRIME + ($airflowTaskPool == null ? 43 : $airflowTaskPool.hashCode());
        final java.lang.Object $airflowTaskQueue = this.getAirflowTaskQueue();
        result = result * PRIME + ($airflowTaskQueue == null ? 43 : $airflowTaskQueue.hashCode());
        final java.lang.Object $airflowTaskSql = this.getAirflowTaskSql();
        result = result * PRIME + ($airflowTaskSql == null ? 43 : $airflowTaskSql.hashCode());
        final java.lang.Object $airflowTaskTriggerRule = this.getAirflowTaskTriggerRule();
        result = result * PRIME + ($airflowTaskTriggerRule == null ? 43 : $airflowTaskTriggerRule.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $inputs = this.getInputs();
        result = result * PRIME + ($inputs == null ? 43 : $inputs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $outputs = this.getOutputs();
        result = result * PRIME + ($outputs == null ? 43 : $outputs.hashCode());
        final java.lang.Object $process = this.getProcess();
        result = result * PRIME + ($process == null ? 43 : $process.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AirflowTask(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", airflowDag=" + this.getAirflowDag() + ", airflowDagName=" + this.getAirflowDagName() + ", airflowDagQualifiedName=" + this.getAirflowDagQualifiedName() + ", airflowRunEndTime=" + this.getAirflowRunEndTime() + ", airflowRunName=" + this.getAirflowRunName() + ", airflowRunOpenLineageState=" + this.getAirflowRunOpenLineageState() + ", airflowRunOpenLineageVersion=" + this.getAirflowRunOpenLineageVersion() + ", airflowRunStartTime=" + this.getAirflowRunStartTime() + ", airflowRunType=" + this.getAirflowRunType() + ", airflowRunVersion=" + this.getAirflowRunVersion() + ", airflowTags=" + this.getAirflowTags() + ", airflowTaskConnectionId=" + this.getAirflowTaskConnectionId() + ", airflowTaskGroupName=" + this.getAirflowTaskGroupName() + ", airflowTaskOperatorClass=" + this.getAirflowTaskOperatorClass() + ", airflowTaskPool=" + this.getAirflowTaskPool() + ", airflowTaskPoolSlots=" + this.getAirflowTaskPoolSlots() + ", airflowTaskPriorityWeight=" + this.getAirflowTaskPriorityWeight() + ", airflowTaskQueue=" + this.getAirflowTaskQueue() + ", airflowTaskRetryNumber=" + this.getAirflowTaskRetryNumber() + ", airflowTaskSql=" + this.getAirflowTaskSql() + ", airflowTaskTriggerRule=" + this.getAirflowTaskTriggerRule() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", inputs=" + this.getInputs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", outputs=" + this.getOutputs() + ", process=" + this.getProcess() + ")";
    }

    /**
     * Fixed typeName for AirflowTasks.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
