// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Anomalo Check in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class AnomaloCheck extends Asset implements IAnomaloCheck, IAnomalo, IDataQuality, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(AnomaloCheck.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AnomaloCheck";
    /**
     * Fixed typeName for AnomaloChecks.
     */
    String typeName;
    /**
     * The asset this Check is linked to.
     */
    @Attribute
    IAsset anomaloCheckAsset;
    /**
     * Category type of the check in Anomalo
     */
    @Attribute
    String anomaloCheckCategoryType;
    /**
     * Historic run status of the check in Anomalo
     */
    @Attribute
    String anomaloCheckHistoricRunStatus;
    /**
     * Flag to indicate if the check is an out of the box available check
     */
    @Attribute
    Boolean anomaloCheckIsSystemAdded;
    /**
     * Timestamp when the check was last run
     */
    @Attribute
    @Date
    Long anomaloCheckLastRunCompletedAt;
    /**
     * Evaluated message of the latest check run.
     */
    @Attribute
    String anomaloCheckLastRunEvaluatedMessage;
    /**
     * URL to the latest check run.
     */
    @Attribute
    String anomaloCheckLastRunUrl;
    /**
     * QualifiedName of the asset associated with the check
     */
    @Attribute
    String anomaloCheckLinkedAssetQualifiedName;
    /**
     * Priority level of the check in Anomalo
     */
    @Attribute
    String anomaloCheckPriorityLevel;
    /**
     * Status of the check in Anomalo
     */
    @Attribute
    String anomaloCheckStatus;
    /**
     * Image URL for the status of the check in Anomalo
     */
    @Attribute
    String anomaloCheckStatusImageUrl;
    /**
     * Type of check in Anomalo
     */
    @Attribute
    String anomaloCheckType;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a AnomaloCheck, from a potentially
     * more-complete AnomaloCheck object.
     *
     * @return the minimal object necessary to relate to the AnomaloCheck
     * @throws InvalidRequestException if any of the minimal set of required properties for a AnomaloCheck relationship are not found in the initial object
     */
    @Override
    public AnomaloCheck trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all AnomaloCheck assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AnomaloCheck assets will be included.
     *
     * @return a fluent search that includes all AnomaloCheck assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all AnomaloCheck assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AnomaloCheck assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all AnomaloCheck assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all AnomaloCheck assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) AnomaloChecks will be included
     * @return a fluent search that includes all AnomaloCheck assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all AnomaloCheck assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) AnomaloChecks will be included
     * @return a fluent search that includes all AnomaloCheck assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a AnomaloCheck by GUID. Use this to create a relationship to this AnomaloCheck,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the AnomaloCheck to reference
     * @return reference to a AnomaloCheck that can be used for defining a relationship to a AnomaloCheck
     */
    public static AnomaloCheck refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AnomaloCheck by GUID. Use this to create a relationship to this AnomaloCheck,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the AnomaloCheck to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AnomaloCheck that can be used for defining a relationship to a AnomaloCheck
     */
    public static AnomaloCheck refByGuid(String guid, Reference.SaveSemantic semantic) {
        return AnomaloCheck._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a AnomaloCheck by qualifiedName. Use this to create a relationship to this AnomaloCheck,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the AnomaloCheck to reference
     * @return reference to a AnomaloCheck that can be used for defining a relationship to a AnomaloCheck
     */
    public static AnomaloCheck refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AnomaloCheck by qualifiedName. Use this to create a relationship to this AnomaloCheck,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the AnomaloCheck to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AnomaloCheck that can be used for defining a relationship to a AnomaloCheck
     */
    public static AnomaloCheck refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return AnomaloCheck._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a AnomaloCheck by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the AnomaloCheck to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AnomaloCheck, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AnomaloCheck does not exist or the provided GUID is not a AnomaloCheck
     */
    @JsonIgnore
    public static AnomaloCheck get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a AnomaloCheck by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AnomaloCheck to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AnomaloCheck, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AnomaloCheck does not exist or the provided GUID is not a AnomaloCheck
     */
    @JsonIgnore
    public static AnomaloCheck get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a AnomaloCheck by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AnomaloCheck to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full AnomaloCheck, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AnomaloCheck does not exist or the provided GUID is not a AnomaloCheck
     */
    @JsonIgnore
    public static AnomaloCheck get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof AnomaloCheck) {
                return (AnomaloCheck) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof AnomaloCheck) {
                return (AnomaloCheck) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) AnomaloCheck to active.
     *
     * @param qualifiedName for the AnomaloCheck
     * @return true if the AnomaloCheck is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) AnomaloCheck to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the AnomaloCheck
     * @return true if the AnomaloCheck is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a AnomaloCheck.
     *
     * @param qualifiedName of the AnomaloCheck
     * @param name of the AnomaloCheck
     * @return the minimal request necessary to update the AnomaloCheck, as a builder
     */
    public static AnomaloCheckBuilder<?, ?> updater(String qualifiedName, String name) {
        return AnomaloCheck._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a AnomaloCheck, from a potentially
     * more-complete AnomaloCheck object.
     *
     * @return the minimal object necessary to update the AnomaloCheck, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for AnomaloCheck are not found in the initial object
     */
    @Override
    public AnomaloCheckBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a AnomaloCheck.
     *
     * @param qualifiedName of the AnomaloCheck
     * @param name of the AnomaloCheck
     * @return the updated AnomaloCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a AnomaloCheck.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the AnomaloCheck
     * @param name of the AnomaloCheck
     * @return the updated AnomaloCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnomaloCheck) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a AnomaloCheck.
     *
     * @param qualifiedName of the AnomaloCheck
     * @param name of the AnomaloCheck
     * @return the updated AnomaloCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a AnomaloCheck.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the AnomaloCheck
     * @param name of the AnomaloCheck
     * @return the updated AnomaloCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnomaloCheck) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a AnomaloCheck.
     *
     * @param qualifiedName of the AnomaloCheck
     * @param name of the AnomaloCheck
     * @return the updated AnomaloCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a AnomaloCheck.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AnomaloCheck's owners
     * @param qualifiedName of the AnomaloCheck
     * @param name of the AnomaloCheck
     * @return the updated AnomaloCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnomaloCheck) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a AnomaloCheck.
     *
     * @param qualifiedName of the AnomaloCheck
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AnomaloCheck, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a AnomaloCheck.
     *
     * @param client connectivity to the Atlan tenant on which to update the AnomaloCheck's certificate
     * @param qualifiedName of the AnomaloCheck
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AnomaloCheck, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AnomaloCheck) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a AnomaloCheck.
     *
     * @param qualifiedName of the AnomaloCheck
     * @param name of the AnomaloCheck
     * @return the updated AnomaloCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a AnomaloCheck.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AnomaloCheck's certificate
     * @param qualifiedName of the AnomaloCheck
     * @param name of the AnomaloCheck
     * @return the updated AnomaloCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnomaloCheck) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a AnomaloCheck.
     *
     * @param qualifiedName of the AnomaloCheck
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a AnomaloCheck.
     *
     * @param client connectivity to the Atlan tenant on which to update the AnomaloCheck's announcement
     * @param qualifiedName of the AnomaloCheck
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AnomaloCheck) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a AnomaloCheck.
     *
     * @param qualifiedName of the AnomaloCheck
     * @param name of the AnomaloCheck
     * @return the updated AnomaloCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a AnomaloCheck.
     *
     * @param client connectivity to the Atlan client from which to remove the AnomaloCheck's announcement
     * @param qualifiedName of the AnomaloCheck
     * @param name of the AnomaloCheck
     * @return the updated AnomaloCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnomaloCheck) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the AnomaloCheck.
     *
     * @param qualifiedName for the AnomaloCheck
     * @param name human-readable name of the AnomaloCheck
     * @param terms the list of terms to replace on the AnomaloCheck, or null to remove all terms from the AnomaloCheck
     * @return the AnomaloCheck that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the AnomaloCheck.
     *
     * @param client connectivity to the Atlan tenant on which to replace the AnomaloCheck's assigned terms
     * @param qualifiedName for the AnomaloCheck
     * @param name human-readable name of the AnomaloCheck
     * @param terms the list of terms to replace on the AnomaloCheck, or null to remove all terms from the AnomaloCheck
     * @return the AnomaloCheck that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AnomaloCheck) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the AnomaloCheck, without replacing existing terms linked to the AnomaloCheck.
     * Note: this operation must make two API calls — one to retrieve the AnomaloCheck's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the AnomaloCheck
     * @param terms the list of terms to append to the AnomaloCheck
     * @return the AnomaloCheck that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the AnomaloCheck, without replacing existing terms linked to the AnomaloCheck.
     * Note: this operation must make two API calls — one to retrieve the AnomaloCheck's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the AnomaloCheck
     * @param qualifiedName for the AnomaloCheck
     * @param terms the list of terms to append to the AnomaloCheck
     * @return the AnomaloCheck that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AnomaloCheck) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a AnomaloCheck, without replacing all existing terms linked to the AnomaloCheck.
     * Note: this operation must make two API calls — one to retrieve the AnomaloCheck's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the AnomaloCheck
     * @param terms the list of terms to remove from the AnomaloCheck, which must be referenced by GUID
     * @return the AnomaloCheck that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a AnomaloCheck, without replacing all existing terms linked to the AnomaloCheck.
     * Note: this operation must make two API calls — one to retrieve the AnomaloCheck's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the AnomaloCheck
     * @param qualifiedName for the AnomaloCheck
     * @param terms the list of terms to remove from the AnomaloCheck, which must be referenced by GUID
     * @return the AnomaloCheck that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static AnomaloCheck removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AnomaloCheck) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a AnomaloCheck, without replacing existing Atlan tags linked to the AnomaloCheck.
     * Note: this operation must make two API calls — one to retrieve the AnomaloCheck's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AnomaloCheck
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AnomaloCheck
     */
    public static AnomaloCheck appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AnomaloCheck, without replacing existing Atlan tags linked to the AnomaloCheck.
     * Note: this operation must make two API calls — one to retrieve the AnomaloCheck's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AnomaloCheck
     * @param qualifiedName of the AnomaloCheck
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AnomaloCheck
     */
    public static AnomaloCheck appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AnomaloCheck) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AnomaloCheck, without replacing existing Atlan tags linked to the AnomaloCheck.
     * Note: this operation must make two API calls — one to retrieve the AnomaloCheck's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AnomaloCheck
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AnomaloCheck
     */
    public static AnomaloCheck appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a AnomaloCheck, without replacing existing Atlan tags linked to the AnomaloCheck.
     * Note: this operation must make two API calls — one to retrieve the AnomaloCheck's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AnomaloCheck
     * @param qualifiedName of the AnomaloCheck
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AnomaloCheck
     */
    public static AnomaloCheck appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AnomaloCheck) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a AnomaloCheck.
     *
     * @param qualifiedName of the AnomaloCheck
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AnomaloCheck
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a AnomaloCheck.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a AnomaloCheck
     * @param qualifiedName of the AnomaloCheck
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AnomaloCheck
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AnomaloCheckBuilder<C extends AnomaloCheck, B extends AnomaloCheck.AnomaloCheckBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IAsset anomaloCheckAsset;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String anomaloCheckCategoryType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String anomaloCheckHistoricRunStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean anomaloCheckIsSystemAdded;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long anomaloCheckLastRunCompletedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String anomaloCheckLastRunEvaluatedMessage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String anomaloCheckLastRunUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String anomaloCheckLinkedAssetQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String anomaloCheckPriorityLevel;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String anomaloCheckStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String anomaloCheckStatusImageUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String anomaloCheckType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AnomaloCheck.AnomaloCheckBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AnomaloCheck instance, final AnomaloCheck.AnomaloCheckBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.anomaloCheckAsset(instance.anomaloCheckAsset);
            b.anomaloCheckCategoryType(instance.anomaloCheckCategoryType);
            b.anomaloCheckHistoricRunStatus(instance.anomaloCheckHistoricRunStatus);
            b.anomaloCheckIsSystemAdded(instance.anomaloCheckIsSystemAdded);
            b.anomaloCheckLastRunCompletedAt(instance.anomaloCheckLastRunCompletedAt);
            b.anomaloCheckLastRunEvaluatedMessage(instance.anomaloCheckLastRunEvaluatedMessage);
            b.anomaloCheckLastRunUrl(instance.anomaloCheckLastRunUrl);
            b.anomaloCheckLinkedAssetQualifiedName(instance.anomaloCheckLinkedAssetQualifiedName);
            b.anomaloCheckPriorityLevel(instance.anomaloCheckPriorityLevel);
            b.anomaloCheckStatus(instance.anomaloCheckStatus);
            b.anomaloCheckStatusImageUrl(instance.anomaloCheckStatusImageUrl);
            b.anomaloCheckType(instance.anomaloCheckType);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for AnomaloChecks.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * The asset this Check is linked to.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheckAsset(final IAsset anomaloCheckAsset) {
            this.anomaloCheckAsset = anomaloCheckAsset;
            return self();
        }

        /**
         * Category type of the check in Anomalo
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheckCategoryType(final String anomaloCheckCategoryType) {
            this.anomaloCheckCategoryType = anomaloCheckCategoryType;
            return self();
        }

        /**
         * Historic run status of the check in Anomalo
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheckHistoricRunStatus(final String anomaloCheckHistoricRunStatus) {
            this.anomaloCheckHistoricRunStatus = anomaloCheckHistoricRunStatus;
            return self();
        }

        /**
         * Flag to indicate if the check is an out of the box available check
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheckIsSystemAdded(final Boolean anomaloCheckIsSystemAdded) {
            this.anomaloCheckIsSystemAdded = anomaloCheckIsSystemAdded;
            return self();
        }

        /**
         * Timestamp when the check was last run
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheckLastRunCompletedAt(final Long anomaloCheckLastRunCompletedAt) {
            this.anomaloCheckLastRunCompletedAt = anomaloCheckLastRunCompletedAt;
            return self();
        }

        /**
         * Evaluated message of the latest check run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheckLastRunEvaluatedMessage(final String anomaloCheckLastRunEvaluatedMessage) {
            this.anomaloCheckLastRunEvaluatedMessage = anomaloCheckLastRunEvaluatedMessage;
            return self();
        }

        /**
         * URL to the latest check run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheckLastRunUrl(final String anomaloCheckLastRunUrl) {
            this.anomaloCheckLastRunUrl = anomaloCheckLastRunUrl;
            return self();
        }

        /**
         * QualifiedName of the asset associated with the check
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheckLinkedAssetQualifiedName(final String anomaloCheckLinkedAssetQualifiedName) {
            this.anomaloCheckLinkedAssetQualifiedName = anomaloCheckLinkedAssetQualifiedName;
            return self();
        }

        /**
         * Priority level of the check in Anomalo
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheckPriorityLevel(final String anomaloCheckPriorityLevel) {
            this.anomaloCheckPriorityLevel = anomaloCheckPriorityLevel;
            return self();
        }

        /**
         * Status of the check in Anomalo
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheckStatus(final String anomaloCheckStatus) {
            this.anomaloCheckStatus = anomaloCheckStatus;
            return self();
        }

        /**
         * Image URL for the status of the check in Anomalo
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheckStatusImageUrl(final String anomaloCheckStatusImageUrl) {
            this.anomaloCheckStatusImageUrl = anomaloCheckStatusImageUrl;
            return self();
        }

        /**
         * Type of check in Anomalo
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheckType(final String anomaloCheckType) {
            this.anomaloCheckType = anomaloCheckType;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AnomaloCheck.AnomaloCheckBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", anomaloCheckAsset=" + this.anomaloCheckAsset + ", anomaloCheckCategoryType=" + this.anomaloCheckCategoryType + ", anomaloCheckHistoricRunStatus=" + this.anomaloCheckHistoricRunStatus + ", anomaloCheckIsSystemAdded=" + this.anomaloCheckIsSystemAdded + ", anomaloCheckLastRunCompletedAt=" + this.anomaloCheckLastRunCompletedAt + ", anomaloCheckLastRunEvaluatedMessage=" + this.anomaloCheckLastRunEvaluatedMessage + ", anomaloCheckLastRunUrl=" + this.anomaloCheckLastRunUrl + ", anomaloCheckLinkedAssetQualifiedName=" + this.anomaloCheckLinkedAssetQualifiedName + ", anomaloCheckPriorityLevel=" + this.anomaloCheckPriorityLevel + ", anomaloCheckStatus=" + this.anomaloCheckStatus + ", anomaloCheckStatusImageUrl=" + this.anomaloCheckStatusImageUrl + ", anomaloCheckType=" + this.anomaloCheckType + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AnomaloCheckBuilderImpl extends AnomaloCheck.AnomaloCheckBuilder<AnomaloCheck, AnomaloCheck.AnomaloCheckBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AnomaloCheckBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AnomaloCheck.AnomaloCheckBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AnomaloCheck build() {
            return new AnomaloCheck(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AnomaloCheck(final AnomaloCheck.AnomaloCheckBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = AnomaloCheck.$default$typeName();
        this.anomaloCheckAsset = b.anomaloCheckAsset;
        this.anomaloCheckCategoryType = b.anomaloCheckCategoryType;
        this.anomaloCheckHistoricRunStatus = b.anomaloCheckHistoricRunStatus;
        this.anomaloCheckIsSystemAdded = b.anomaloCheckIsSystemAdded;
        this.anomaloCheckLastRunCompletedAt = b.anomaloCheckLastRunCompletedAt;
        this.anomaloCheckLastRunEvaluatedMessage = b.anomaloCheckLastRunEvaluatedMessage;
        this.anomaloCheckLastRunUrl = b.anomaloCheckLastRunUrl;
        this.anomaloCheckLinkedAssetQualifiedName = b.anomaloCheckLinkedAssetQualifiedName;
        this.anomaloCheckPriorityLevel = b.anomaloCheckPriorityLevel;
        this.anomaloCheckStatus = b.anomaloCheckStatus;
        this.anomaloCheckStatusImageUrl = b.anomaloCheckStatusImageUrl;
        this.anomaloCheckType = b.anomaloCheckType;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AnomaloCheck.AnomaloCheckBuilder<?, ?> _internal() {
        return new AnomaloCheck.AnomaloCheckBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AnomaloCheck.AnomaloCheckBuilder<?, ?> toBuilder() {
        return new AnomaloCheck.AnomaloCheckBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * The asset this Check is linked to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IAsset getAnomaloCheckAsset() {
        return this.anomaloCheckAsset;
    }

    /**
     * Category type of the check in Anomalo
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAnomaloCheckCategoryType() {
        return this.anomaloCheckCategoryType;
    }

    /**
     * Historic run status of the check in Anomalo
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAnomaloCheckHistoricRunStatus() {
        return this.anomaloCheckHistoricRunStatus;
    }

    /**
     * Flag to indicate if the check is an out of the box available check
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAnomaloCheckIsSystemAdded() {
        return this.anomaloCheckIsSystemAdded;
    }

    /**
     * Timestamp when the check was last run
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAnomaloCheckLastRunCompletedAt() {
        return this.anomaloCheckLastRunCompletedAt;
    }

    /**
     * Evaluated message of the latest check run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAnomaloCheckLastRunEvaluatedMessage() {
        return this.anomaloCheckLastRunEvaluatedMessage;
    }

    /**
     * URL to the latest check run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAnomaloCheckLastRunUrl() {
        return this.anomaloCheckLastRunUrl;
    }

    /**
     * QualifiedName of the asset associated with the check
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAnomaloCheckLinkedAssetQualifiedName() {
        return this.anomaloCheckLinkedAssetQualifiedName;
    }

    /**
     * Priority level of the check in Anomalo
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAnomaloCheckPriorityLevel() {
        return this.anomaloCheckPriorityLevel;
    }

    /**
     * Status of the check in Anomalo
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAnomaloCheckStatus() {
        return this.anomaloCheckStatus;
    }

    /**
     * Image URL for the status of the check in Anomalo
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAnomaloCheckStatusImageUrl() {
        return this.anomaloCheckStatusImageUrl;
    }

    /**
     * Type of check in Anomalo
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAnomaloCheckType() {
        return this.anomaloCheckType;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AnomaloCheck)) return false;
        final AnomaloCheck other = (AnomaloCheck) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$anomaloCheckIsSystemAdded = this.getAnomaloCheckIsSystemAdded();
        final java.lang.Object other$anomaloCheckIsSystemAdded = other.getAnomaloCheckIsSystemAdded();
        if (this$anomaloCheckIsSystemAdded == null ? other$anomaloCheckIsSystemAdded != null : !this$anomaloCheckIsSystemAdded.equals(other$anomaloCheckIsSystemAdded)) return false;
        final java.lang.Object this$anomaloCheckLastRunCompletedAt = this.getAnomaloCheckLastRunCompletedAt();
        final java.lang.Object other$anomaloCheckLastRunCompletedAt = other.getAnomaloCheckLastRunCompletedAt();
        if (this$anomaloCheckLastRunCompletedAt == null ? other$anomaloCheckLastRunCompletedAt != null : !this$anomaloCheckLastRunCompletedAt.equals(other$anomaloCheckLastRunCompletedAt)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$anomaloCheckAsset = this.getAnomaloCheckAsset();
        final java.lang.Object other$anomaloCheckAsset = other.getAnomaloCheckAsset();
        if (this$anomaloCheckAsset == null ? other$anomaloCheckAsset != null : !this$anomaloCheckAsset.equals(other$anomaloCheckAsset)) return false;
        final java.lang.Object this$anomaloCheckCategoryType = this.getAnomaloCheckCategoryType();
        final java.lang.Object other$anomaloCheckCategoryType = other.getAnomaloCheckCategoryType();
        if (this$anomaloCheckCategoryType == null ? other$anomaloCheckCategoryType != null : !this$anomaloCheckCategoryType.equals(other$anomaloCheckCategoryType)) return false;
        final java.lang.Object this$anomaloCheckHistoricRunStatus = this.getAnomaloCheckHistoricRunStatus();
        final java.lang.Object other$anomaloCheckHistoricRunStatus = other.getAnomaloCheckHistoricRunStatus();
        if (this$anomaloCheckHistoricRunStatus == null ? other$anomaloCheckHistoricRunStatus != null : !this$anomaloCheckHistoricRunStatus.equals(other$anomaloCheckHistoricRunStatus)) return false;
        final java.lang.Object this$anomaloCheckLastRunEvaluatedMessage = this.getAnomaloCheckLastRunEvaluatedMessage();
        final java.lang.Object other$anomaloCheckLastRunEvaluatedMessage = other.getAnomaloCheckLastRunEvaluatedMessage();
        if (this$anomaloCheckLastRunEvaluatedMessage == null ? other$anomaloCheckLastRunEvaluatedMessage != null : !this$anomaloCheckLastRunEvaluatedMessage.equals(other$anomaloCheckLastRunEvaluatedMessage)) return false;
        final java.lang.Object this$anomaloCheckLastRunUrl = this.getAnomaloCheckLastRunUrl();
        final java.lang.Object other$anomaloCheckLastRunUrl = other.getAnomaloCheckLastRunUrl();
        if (this$anomaloCheckLastRunUrl == null ? other$anomaloCheckLastRunUrl != null : !this$anomaloCheckLastRunUrl.equals(other$anomaloCheckLastRunUrl)) return false;
        final java.lang.Object this$anomaloCheckLinkedAssetQualifiedName = this.getAnomaloCheckLinkedAssetQualifiedName();
        final java.lang.Object other$anomaloCheckLinkedAssetQualifiedName = other.getAnomaloCheckLinkedAssetQualifiedName();
        if (this$anomaloCheckLinkedAssetQualifiedName == null ? other$anomaloCheckLinkedAssetQualifiedName != null : !this$anomaloCheckLinkedAssetQualifiedName.equals(other$anomaloCheckLinkedAssetQualifiedName)) return false;
        final java.lang.Object this$anomaloCheckPriorityLevel = this.getAnomaloCheckPriorityLevel();
        final java.lang.Object other$anomaloCheckPriorityLevel = other.getAnomaloCheckPriorityLevel();
        if (this$anomaloCheckPriorityLevel == null ? other$anomaloCheckPriorityLevel != null : !this$anomaloCheckPriorityLevel.equals(other$anomaloCheckPriorityLevel)) return false;
        final java.lang.Object this$anomaloCheckStatus = this.getAnomaloCheckStatus();
        final java.lang.Object other$anomaloCheckStatus = other.getAnomaloCheckStatus();
        if (this$anomaloCheckStatus == null ? other$anomaloCheckStatus != null : !this$anomaloCheckStatus.equals(other$anomaloCheckStatus)) return false;
        final java.lang.Object this$anomaloCheckStatusImageUrl = this.getAnomaloCheckStatusImageUrl();
        final java.lang.Object other$anomaloCheckStatusImageUrl = other.getAnomaloCheckStatusImageUrl();
        if (this$anomaloCheckStatusImageUrl == null ? other$anomaloCheckStatusImageUrl != null : !this$anomaloCheckStatusImageUrl.equals(other$anomaloCheckStatusImageUrl)) return false;
        final java.lang.Object this$anomaloCheckType = this.getAnomaloCheckType();
        final java.lang.Object other$anomaloCheckType = other.getAnomaloCheckType();
        if (this$anomaloCheckType == null ? other$anomaloCheckType != null : !this$anomaloCheckType.equals(other$anomaloCheckType)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AnomaloCheck;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $anomaloCheckIsSystemAdded = this.getAnomaloCheckIsSystemAdded();
        result = result * PRIME + ($anomaloCheckIsSystemAdded == null ? 43 : $anomaloCheckIsSystemAdded.hashCode());
        final java.lang.Object $anomaloCheckLastRunCompletedAt = this.getAnomaloCheckLastRunCompletedAt();
        result = result * PRIME + ($anomaloCheckLastRunCompletedAt == null ? 43 : $anomaloCheckLastRunCompletedAt.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $anomaloCheckAsset = this.getAnomaloCheckAsset();
        result = result * PRIME + ($anomaloCheckAsset == null ? 43 : $anomaloCheckAsset.hashCode());
        final java.lang.Object $anomaloCheckCategoryType = this.getAnomaloCheckCategoryType();
        result = result * PRIME + ($anomaloCheckCategoryType == null ? 43 : $anomaloCheckCategoryType.hashCode());
        final java.lang.Object $anomaloCheckHistoricRunStatus = this.getAnomaloCheckHistoricRunStatus();
        result = result * PRIME + ($anomaloCheckHistoricRunStatus == null ? 43 : $anomaloCheckHistoricRunStatus.hashCode());
        final java.lang.Object $anomaloCheckLastRunEvaluatedMessage = this.getAnomaloCheckLastRunEvaluatedMessage();
        result = result * PRIME + ($anomaloCheckLastRunEvaluatedMessage == null ? 43 : $anomaloCheckLastRunEvaluatedMessage.hashCode());
        final java.lang.Object $anomaloCheckLastRunUrl = this.getAnomaloCheckLastRunUrl();
        result = result * PRIME + ($anomaloCheckLastRunUrl == null ? 43 : $anomaloCheckLastRunUrl.hashCode());
        final java.lang.Object $anomaloCheckLinkedAssetQualifiedName = this.getAnomaloCheckLinkedAssetQualifiedName();
        result = result * PRIME + ($anomaloCheckLinkedAssetQualifiedName == null ? 43 : $anomaloCheckLinkedAssetQualifiedName.hashCode());
        final java.lang.Object $anomaloCheckPriorityLevel = this.getAnomaloCheckPriorityLevel();
        result = result * PRIME + ($anomaloCheckPriorityLevel == null ? 43 : $anomaloCheckPriorityLevel.hashCode());
        final java.lang.Object $anomaloCheckStatus = this.getAnomaloCheckStatus();
        result = result * PRIME + ($anomaloCheckStatus == null ? 43 : $anomaloCheckStatus.hashCode());
        final java.lang.Object $anomaloCheckStatusImageUrl = this.getAnomaloCheckStatusImageUrl();
        result = result * PRIME + ($anomaloCheckStatusImageUrl == null ? 43 : $anomaloCheckStatusImageUrl.hashCode());
        final java.lang.Object $anomaloCheckType = this.getAnomaloCheckType();
        result = result * PRIME + ($anomaloCheckType == null ? 43 : $anomaloCheckType.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AnomaloCheck(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", anomaloCheckAsset=" + this.getAnomaloCheckAsset() + ", anomaloCheckCategoryType=" + this.getAnomaloCheckCategoryType() + ", anomaloCheckHistoricRunStatus=" + this.getAnomaloCheckHistoricRunStatus() + ", anomaloCheckIsSystemAdded=" + this.getAnomaloCheckIsSystemAdded() + ", anomaloCheckLastRunCompletedAt=" + this.getAnomaloCheckLastRunCompletedAt() + ", anomaloCheckLastRunEvaluatedMessage=" + this.getAnomaloCheckLastRunEvaluatedMessage() + ", anomaloCheckLastRunUrl=" + this.getAnomaloCheckLastRunUrl() + ", anomaloCheckLinkedAssetQualifiedName=" + this.getAnomaloCheckLinkedAssetQualifiedName() + ", anomaloCheckPriorityLevel=" + this.getAnomaloCheckPriorityLevel() + ", anomaloCheckStatus=" + this.getAnomaloCheckStatus() + ", anomaloCheckStatusImageUrl=" + this.getAnomaloCheckStatusImageUrl() + ", anomaloCheckType=" + this.getAnomaloCheckType() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for AnomaloChecks.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
