// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.ApiException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.core.AssetDeletionResponse;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AssetResponse;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanDeleteType;
import com.atlan.model.enums.AtlanIcon;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.SourceCostUnitType;
import com.atlan.model.lineage.FluentLineage;
import com.atlan.model.relations.Reference;
import com.atlan.model.structs.PopularityInsights;
import com.atlan.model.structs.StarredDetails;
import com.atlan.net.HttpClient;
import com.atlan.serde.AssetDeserializer;
import com.atlan.serde.AssetSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Base class for all assets.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@JsonSerialize(using = AssetSerializer.class)
@JsonDeserialize(using = AssetDeserializer.class)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "typeName", defaultImpl = IndistinctAsset.class)
@SuppressWarnings("cast")
public abstract class Asset extends Reference implements IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(Asset.class);
    private static final long serialVersionUID = 2L;
    /**
     * List of groups who administer this asset. (This is only used for certain asset types.)
     */
    @Attribute
    SortedSet<String> adminGroups;
    /**
     * List of roles who administer this asset. (This is only used for Connection assets.)
     */
    @Attribute
    SortedSet<String> adminRoles;
    /**
     * List of users who administer this asset. (This is only used for certain asset types.)
     */
    @Attribute
    SortedSet<String> adminUsers;
    /**
     * Detailed message to include in the announcement on this asset.
     */
    @Attribute
    String announcementMessage;
    /**
     * Brief title for the announcement on this asset. Required when announcementType is specified.
     */
    @Attribute
    String announcementTitle;
    /**
     * Type of announcement on this asset.
     */
    @Attribute
    AtlanAnnouncementType announcementType;
    /**
     * Time (epoch) at which the announcement was last updated, in milliseconds.
     */
    @Attribute
    @Date
    Long announcementUpdatedAt;
    /**
     * Name of the user who last updated the announcement.
     */
    @Attribute
    String announcementUpdatedBy;
    /**
     * Checks that run on this asset.
     */
    @Attribute
    SortedSet<IAnomaloCheck> anomaloChecks;
    /**
     * All associated Anomalo check types.
     */
    @Attribute
    SortedSet<String> assetAnomaloAppliedCheckTypes;
    /**
     * Total number of checks present in Anomalo for this asset.
     */
    @Attribute
    Long assetAnomaloCheckCount;
    /**
     * Stringified JSON object containing status of all Anomalo checks associated to this asset.
     */
    @Attribute
    String assetAnomaloCheckStatuses;
    /**
     * Status of data quality from Anomalo.
     */
    @Attribute
    String assetAnomaloDQStatus;
    /**
     * Total number of checks failed in Anomalo for this asset.
     */
    @Attribute
    Long assetAnomaloFailedCheckCount;
    /**
     * All associated Anomalo failed check types.
     */
    @Attribute
    SortedSet<String> assetAnomaloFailedCheckTypes;
    /**
     * Time (epoch) at which the last check was run via Anomalo.
     */
    @Attribute
    @Date
    Long assetAnomaloLastCheckRunAt;
    /**
     * URL of the source in Anomalo.
     */
    @Attribute
    String assetAnomaloSourceUrl;
    /**
     * TBC
     */
    @Attribute
    String assetCoverImage;
    /**
     * Name of the account in which this asset exists in dbt.
     */
    @Attribute
    String assetDbtAccountName;
    /**
     * Alias of this asset in dbt.
     */
    @Attribute
    String assetDbtAlias;
    /**
     * Version of the environment in which this asset is materialized in dbt.
     */
    @Attribute
    String assetDbtEnvironmentDbtVersion;
    /**
     * Name of the environment in which this asset is materialized in dbt.
     */
    @Attribute
    String assetDbtEnvironmentName;
    /**
     * Time (epoch) at which the job that materialized this asset in dbt last ran, in milliseconds.
     */
    @Attribute
    @Date
    Long assetDbtJobLastRun;
    /**
     * Path in S3 to the artifacts saved from the last run of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobLastRunArtifactS3Path;
    /**
     * Whether artifacts were saved from the last run of the job that materialized this asset in dbt (true) or not (false).
     */
    @Attribute
    Boolean assetDbtJobLastRunArtifactsSaved;
    /**
     * Time (epoch) at which the job that materialized this asset in dbt was last created, in milliseconds.
     */
    @Attribute
    @Date
    Long assetDbtJobLastRunCreatedAt;
    /**
     * Time (epoch) at which the job that materialized this asset in dbt was dequeued, in milliseconds.
     */
    @Attribute
    @Date
    Long assetDbtJobLastRunDequedAt;
    /**
     * Thread ID of the user who executed the last run of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobLastRunExecutedByThreadId;
    /**
     * Branch in git from which the last run of the job that materialized this asset in dbt ran.
     */
    @Attribute
    String assetDbtJobLastRunGitBranch;
    /**
     * SHA hash in git for the last run of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobLastRunGitSha;
    /**
     * Whether docs were generated from the last run of the job that materialized this asset in dbt (true) or not (false).
     */
    @Attribute
    Boolean assetDbtJobLastRunHasDocsGenerated;
    /**
     * Whether sources were generated from the last run of the job that materialized this asset in dbt (true) or not (false).
     */
    @Attribute
    Boolean assetDbtJobLastRunHasSourcesGenerated;
    /**
     * Whether notifications were sent from the last run of the job that materialized this asset in dbt (true) or not (false).
     */
    @Attribute
    Boolean assetDbtJobLastRunNotificationsSent;
    /**
     * Thread ID of the owner of the last run of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobLastRunOwnerThreadId;
    /**
     * Total duration the job that materialized this asset in dbt spent being queued.
     */
    @Attribute
    String assetDbtJobLastRunQueuedDuration;
    /**
     * Human-readable total duration of the last run of the job that materialized this asset in dbt spend being queued.
     */
    @Attribute
    String assetDbtJobLastRunQueuedDurationHumanized;
    /**
     * Run duration of the last run of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobLastRunRunDuration;
    /**
     * Human-readable run duration of the last run of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobLastRunRunDurationHumanized;
    /**
     * Time (epoch) at which the job that materialized this asset in dbt was started running, in milliseconds.
     */
    @Attribute
    @Date
    Long assetDbtJobLastRunStartedAt;
    /**
     * Status message of the last run of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobLastRunStatusMessage;
    /**
     * Total duration of the last run of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobLastRunTotalDuration;
    /**
     * Human-readable total duration of the last run of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobLastRunTotalDurationHumanized;
    /**
     * Time (epoch) at which the job that materialized this asset in dbt was last updated, in milliseconds.
     */
    @Attribute
    @Date
    Long assetDbtJobLastRunUpdatedAt;
    /**
     * URL of the last run of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobLastRunUrl;
    /**
     * Name of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobName;
    /**
     * Time (epoch) when the next run of the job that materializes this asset in dbt is scheduled.
     */
    @Attribute
    @Date
    Long assetDbtJobNextRun;
    /**
     * Human-readable time when the next run of the job that materializes this asset in dbt is scheduled.
     */
    @Attribute
    String assetDbtJobNextRunHumanized;
    /**
     * Schedule of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobSchedule;
    /**
     * Human-readable cron schedule of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobScheduleCronHumanized;
    /**
     * Status of the job that materialized this asset in dbt.
     */
    @Attribute
    String assetDbtJobStatus;
    /**
     * Metadata for this asset in dbt, specifically everything under the 'meta' key in the dbt object.
     */
    @Attribute
    String assetDbtMeta;
    /**
     * Name of the package in which this asset exists in dbt.
     */
    @Attribute
    String assetDbtPackageName;
    /**
     * Name of the project in which this asset exists in dbt.
     */
    @Attribute
    String assetDbtProjectName;
    /**
     * URL of the semantic layer proxy for this asset in dbt.
     */
    @Attribute
    String assetDbtSemanticLayerProxyUrl;
    /**
     * Freshness criteria for the source of this asset in dbt.
     */
    @Attribute
    String assetDbtSourceFreshnessCriteria;
    /**
     * List of tags attached to this asset in dbt.
     */
    @Attribute
    SortedSet<String> assetDbtTags;
    /**
     * All associated dbt test statuses.
     */
    @Attribute
    String assetDbtTestStatus;
    /**
     * Unique identifier of this asset in dbt.
     */
    @Attribute
    String assetDbtUniqueId;
    /**
     * Name of the DBT workflow in Atlan that last updated the asset.
     */
    @Attribute
    String assetDbtWorkflowLastUpdated;
    /**
     * Name of the icon to use for this asset. (Only applies to glossaries, currently.)
     */
    @Attribute
    AtlanIcon assetIcon;
    /**
     * List of unique Monte Carlo alert names attached to this asset.
     */
    @Attribute
    SortedSet<String> assetMcAlertQualifiedNames;
    /**
     * List of Monte Carlo incident names attached to this asset.
     */
    @Attribute
    SortedSet<String> assetMcIncidentNames;
    /**
     * List of Monte Carlo incident priorities associated with this asset.
     */
    @Attribute
    SortedSet<String> assetMcIncidentPriorities;
    /**
     * List of unique Monte Carlo incident names attached to this asset.
     */
    @Attribute
    SortedSet<String> assetMcIncidentQualifiedNames;
    /**
     * List of Monte Carlo incident severities associated with this asset.
     */
    @Attribute
    SortedSet<String> assetMcIncidentSeverities;
    /**
     * List of Monte Carlo incident states associated with this asset.
     */
    @Attribute
    SortedSet<String> assetMcIncidentStates;
    /**
     * List of Monte Carlo incident sub-types associated with this asset.
     */
    @Attribute
    SortedSet<String> assetMcIncidentSubTypes;
    /**
     * List of Monte Carlo incident types associated with this asset.
     */
    @Attribute
    SortedSet<String> assetMcIncidentTypes;
    /**
     * Time (epoch) at which this asset was last synced from Monte Carlo.
     */
    @Attribute
    @Date
    Long assetMcLastSyncRunAt;
    /**
     * List of Monte Carlo monitor names attached to this asset.
     */
    @Attribute
    SortedSet<String> assetMcMonitorNames;
    /**
     * List of unique Monte Carlo monitor names attached to this asset.
     */
    @Attribute
    SortedSet<String> assetMcMonitorQualifiedNames;
    /**
     * Schedules of all associated Monte Carlo monitors.
     */
    @Attribute
    SortedSet<String> assetMcMonitorScheduleTypes;
    /**
     * Statuses of all associated Monte Carlo monitors.
     */
    @Attribute
    SortedSet<String> assetMcMonitorStatuses;
    /**
     * Types of all associated Monte Carlo monitors.
     */
    @Attribute
    SortedSet<String> assetMcMonitorTypes;
    /**
     * Count of policies inside the asset
     */
    @Attribute
    Long assetPoliciesCount;
    /**
     * Array of policy ids governing this asset
     */
    @Attribute
    SortedSet<String> assetPolicyGUIDs;
    /**
     * Number of checks done via Soda.
     */
    @Attribute
    Long assetSodaCheckCount;
    /**
     * All associated Soda check statuses.
     */
    @Attribute
    String assetSodaCheckStatuses;
    /**
     * Status of data quality from Soda.
     */
    @Attribute
    String assetSodaDQStatus;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long assetSodaLastScanAt;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long assetSodaLastSyncRunAt;
    /**
     * TBC
     */
    @Attribute
    String assetSodaSourceURL;
    /**
     * List of tags attached to this asset.
     */
    @Attribute
    SortedSet<String> assetTags;
    /**
     * Color (in hexadecimal RGB) to use to represent this asset.
     */
    @Attribute
    String assetThemeHex;
    /**
     * Glossary terms that are linked to this asset.
     */
    @Attribute
    @JsonProperty("meanings")
    SortedSet<IGlossaryTerm> assignedTerms;
    /**
     * Status of this asset's certification.
     */
    @Attribute
    CertificateStatus certificateStatus;
    /**
     * Human-readable descriptive message used to provide further detail to certificateStatus.
     */
    @Attribute
    String certificateStatusMessage;
    /**
     * Time (epoch) at which the certification was last updated, in milliseconds.
     */
    @Attribute
    @Date
    Long certificateUpdatedAt;
    /**
     * Name of the user who last updated the certification of this asset.
     */
    @Attribute
    String certificateUpdatedBy;
    /**
     * Simple name of the connection through which this asset is accessible.
     */
    @Attribute
    String connectionName;
    /**
     * Unique name of the connection through which this asset is accessible.
     */
    @Attribute
    String connectionQualifiedName;
    /**
     * Type of the connector through which this asset is accessible.
     */
    @Attribute
    @JsonProperty("connectorName")
    AtlanConnectorType connectorType;
    /**
     * Latest version of the data contract (in any status) for this asset.
     */
    @Attribute
    IDataContract dataContractLatest;
    /**
     * Latest certified version of the data contract for this asset.
     */
    @Attribute
    IDataContract dataContractLatestCertified;
    /**
     * Unique name of this asset in dbt.
     */
    @Attribute
    String dbtQualifiedName;
    /**
     * Description of this asset, for example as crawled from a source. Fallback for display purposes, if userDescription is empty.
     */
    @Attribute
    String description;
    /**
     * Human-readable name of this asset used for display purposes (in user interface).
     */
    @Attribute
    String displayName;
    /**
     * Array of domain guids linked to this asset
     */
    @Attribute
    SortedSet<String> domainGUIDs;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IFile> files;
    /**
     * Whether this asset has contract (true) or not (false).
     */
    @Attribute
    Boolean hasContract;
    /**
     * Whether this asset has lineage (true) or not (false).
     */
    @Attribute
    @JsonProperty("__hasLineage")
    Boolean hasLineage;
    /**
     * Data products for which this asset is an input port.
     */
    @Attribute
    SortedSet<IDataProduct> inputPortDataProducts;
    /**
     * TBC
     */
    @Attribute
    Boolean isAIGenerated;
    /**
     * Whether this asset is discoverable through the UI (true) or not (false).
     */
    @Attribute
    Boolean isDiscoverable;
    /**
     * Whether this asset can be edited in the UI (true) or not (false).
     */
    @Attribute
    Boolean isEditable;
    /**
     * TBC
     */
    @Attribute
    Boolean isPartial;
    /**
     * Time (epoch) of the last operation that inserted, updated, or deleted rows, in milliseconds.
     */
    @Attribute
    @Date
    Long lastRowChangedAt;
    /**
     * Name of the last run of the crawler that last synchronized this asset.
     */
    @Attribute
    String lastSyncRun;
    /**
     * Time (epoch) at which this asset was last crawled, in milliseconds.
     */
    @Attribute
    @Date
    Long lastSyncRunAt;
    /**
     * Name of the crawler that last synchronized this asset.
     */
    @Attribute
    String lastSyncWorkflowName;
    /**
     * Custom order for sorting purpose, managed by client
     */
    @Attribute
    String lexicographicalSortOrder;
    /**
     * Links that are attached to this asset.
     */
    @Attribute
    SortedSet<ILink> links;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IMCIncident> mcIncidents;
    /**
     * Monitors that observe this asset.
     */
    @Attribute
    SortedSet<IMCMonitor> mcMonitors;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IMetric> metrics;
    /**
     * Name of this asset. Fallback for display purposes, if displayName is empty.
     */
    @Attribute
    String name;
    /**
     * Array of policy ids non-compliant to this asset
     */
    @Attribute
    SortedSet<String> nonCompliantAssetPolicyGUIDs;
    /**
     * Data products for which this asset is an output port.
     */
    @Attribute
    SortedSet<IDataProduct> outputPortDataProducts;
    /**
     * List of groups who own this asset.
     */
    @Attribute
    SortedSet<String> ownerGroups;
    /**
     * List of users who own this asset.
     */
    @Attribute
    SortedSet<String> ownerUsers;
    /**
     * Popularity score for this asset.
     */
    @Attribute
    Double popularityScore;
    /**
     * Unique name for this asset. This is typically a concatenation of the asset's name onto its parent's qualifiedName. This must be unique across all assets of the same type.
     */
    @Attribute
    String qualifiedName;
    /**
     * README that is linked to this asset.
     */
    @Attribute
    IReadme readme;
    /**
     * URL for sample data for this asset.
     */
    @Attribute
    String sampleDataUrl;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISchemaRegistrySubject> schemaRegistrySubjects;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISodaCheck> sodaChecks;
    /**
     * The unit of measure for sourceTotalCost.
     */
    @Attribute
    SourceCostUnitType sourceCostUnit;
    /**
     * Time (epoch) at which this asset was created in the source system, in milliseconds.
     */
    @Attribute
    @Date
    Long sourceCreatedAt;
    /**
     * Name of the user who created this asset, in the source system.
     */
    @Attribute
    String sourceCreatedBy;
    /**
     * URL to create an embed for a resource (for example, an image of a dashboard) within Atlan.
     */
    @Attribute
    String sourceEmbedURL;
    /**
     * Timestamp of most recent read operation.
     */
    @Attribute
    @Date
    Long sourceLastReadAt;
    /**
     * List of owners of this asset, in the source system.
     */
    @Attribute
    String sourceOwners;
    /**
     * List of most expensive warehouses with extra insights.
     */
    @Attribute
    @JsonProperty("sourceQueryComputeCostRecordList")
    List<PopularityInsights> sourceQueryComputeCostRecords;
    /**
     * List of most expensive warehouse names.
     */
    @Attribute
    @JsonProperty("sourceQueryComputeCostList")
    SortedSet<String> sourceQueryComputeCosts;
    /**
     * Total count of all read operations at source.
     */
    @Attribute
    Long sourceReadCount;
    /**
     * List of the most expensive queries that accessed this asset.
     */
    @Attribute
    @JsonProperty("sourceReadExpensiveQueryRecordList")
    List<PopularityInsights> sourceReadExpensiveQueryRecords;
    /**
     * List of the most popular queries that accessed this asset.
     */
    @Attribute
    @JsonProperty("sourceReadPopularQueryRecordList")
    List<PopularityInsights> sourceReadPopularQueryRecords;
    /**
     * Total cost of read queries at source.
     */
    @Attribute
    Double sourceReadQueryCost;
    /**
     * List of usernames with extra insights for the most recent users who read this asset.
     */
    @Attribute
    @JsonProperty("sourceReadRecentUserRecordList")
    List<PopularityInsights> sourceReadRecentUserRecords;
    /**
     * List of usernames of the most recent users who read this asset.
     */
    @Attribute
    @JsonProperty("sourceReadRecentUserList")
    SortedSet<String> sourceReadRecentUsers;
    /**
     * List of the slowest queries that accessed this asset.
     */
    @Attribute
    @JsonProperty("sourceReadSlowQueryRecordList")
    List<PopularityInsights> sourceReadSlowQueryRecords;
    /**
     * List of usernames with extra insights for the users who read this asset the most.
     */
    @Attribute
    @JsonProperty("sourceReadTopUserRecordList")
    List<PopularityInsights> sourceReadTopUserRecords;
    /**
     * List of usernames of the users who read this asset the most.
     */
    @Attribute
    @JsonProperty("sourceReadTopUserList")
    SortedSet<String> sourceReadTopUsers;
    /**
     * Total number of unique users that read data from asset.
     */
    @Attribute
    Long sourceReadUserCount;
    /**
     * Total cost of all operations at source.
     */
    @Attribute
    Double sourceTotalCost;
    /**
     * URL to the resource within the source application, used to create a button to view this asset in the source application.
     */
    @Attribute
    String sourceURL;
    /**
     * Time (epoch) at which this asset was last updated in the source system, in milliseconds.
     */
    @Attribute
    @Date
    Long sourceUpdatedAt;
    /**
     * Name of the user who last updated this asset, in the source system.
     */
    @Attribute
    String sourceUpdatedBy;
    /**
     * Users who have starred this asset.
     */
    @Attribute
    SortedSet<String> starredBy;
    /**
     * Number of users who have starred this asset.
     */
    @Attribute
    Integer starredCount;
    /**
     * List of usernames with extra information of the users who have starred an asset.
     */
    @Attribute
    @JsonProperty("starredDetailsList")
    List<StarredDetails> starredDetails;
    /**
     * Subtype of this asset.
     */
    @Attribute
    String subType;
    /**
     * Name of the Atlan workspace in which this asset exists.
     */
    @Attribute
    String tenantId;
    /**
     * TBC
     */
    @Attribute
    @JsonProperty("userDefRelationshipFrom")
    SortedSet<IAsset> userDefRelationshipFroms;
    /**
     * TBC
     */
    @Attribute
    @JsonProperty("userDefRelationshipTo")
    SortedSet<IAsset> userDefRelationshipTos;
    /**
     * Description of this asset, as provided by a user. If present, this will be used for the description in user interface.
     */
    @Attribute
    String userDescription;
    /**
     * View score for this asset.
     */
    @Attribute
    Double viewScore;
    /**
     * List of groups who can view assets contained in a collection. (This is only used for certain asset types.)
     */
    @Attribute
    SortedSet<String> viewerGroups;
    /**
     * List of users who can view assets contained in a collection. (This is only used for certain asset types.)
     */
    @Attribute
    SortedSet<String> viewerUsers;
    /**
     * Internal tracking of fields that should be serialized with null values.
     */
    @JsonIgnore
    transient Set<String> nullFields;

    /**
     * Retrieve the list of fields to be serialized with null values.
     */
    @JsonIgnore
    public Set<String> getNullFields() {
        if (nullFields == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(nullFields);
    }

    /**
     * Atlan tags assigned to the asset.
     */
    @JsonProperty("classifications")
    SortedSet<AtlanTag> atlanTags;
    /**
     * Map of custom metadata attributes and values defined on the asset. The map is keyed by the human-readable
     * name of the custom metadata set, and the values are a further mapping from human-readable attribute name
     * to the value for that attribute on this asset.
     */
    Map<String, CustomMetadataAttributes> customMetadataSets;
    /**
     * Status of the asset.
     */
    AtlanStatus status;
    /**
     * User or account that created the asset.
     */
    final String createdBy;
    /**
     * User or account that last updated the asset.
     */
    final String updatedBy;
    /**
     * Time (epoch) at which the asset was created, in milliseconds.
     */
    @Date
    final Long createTime;
    /**
     * Time (epoch) at which the asset was last updated, in milliseconds.
     */
    @Date
    final Long updateTime;
    /**
     * Details on the handler used for deletion of the asset.
     */
    final String deleteHandler;
    /**
     * Depth of this asset within lineage.
     * Note: this will only be available in assets retrieved via lineage, and will vary even for
     * the same asset depending on the starting point of the lineage requested.
     */
    final Long depth;
    /**
     * Reference details about the asset(s) that are immediately upstream of this asset within lineage.
     * Note: this will only be available in assets retrieved via lineage when {@code immediateNeighbors} is true,
     * and could vary even for the same asset depending on the starting point and depth of the lineage requested.
     */
    final List<LineageRef> immediateUpstream;
    /**
     * Reference details about the asset(s) that are immediately downstream of this asset within lineage.
     * Note: this will only be available in assets retrieved via lineage when {@code immediateNeighbors} is true,
     * and could vary even for the same asset depending on the starting point and depth of the lineage requested.
     */
    final List<LineageRef> immediateDownstream;
    /**
     * The names of the Atlan tags that exist on the asset. This is not always returned, even by
     * full retrieval operations. It is better to depend on the detailed values in the Atlan tags
     * property.
     * @see #atlanTags
     */
    @Deprecated
    @JsonProperty("classificationNames")
    SortedSet<String> atlanTagNames;
    /**
     * Unused.
     */
    Boolean isIncomplete;
    /**
     * Names of terms that have been linked to this asset.
     */
    SortedSet<String> meaningNames;
    /**
     * Details of terms that have been linked to this asset. This is not set by all API endpoints, so cannot
     * be relied upon in general, even when there are terms assigned to an asset.
     * @deprecated see {@link #assignedTerms} instead
     */
    @Deprecated
    SortedSet<Meaning> meanings;
    /**
     * Unique identifiers (GUIDs) for any background tasks that are yet to operate on this asset.
     */
    final SortedSet<String> pendingTasks;

    /**
     * {@inheritDoc}
     */
    @Override
    public String getQualifiedName() {
        return qualifiedName != null ? qualifiedName : (getUniqueAttributes() != null ? getUniqueAttributes().getQualifiedName() : null);
    }

    /**
     * Retrieve the value of the custom metadata attribute from this asset.
     * Note: returns null in all cases where the custom metadata does not exist, is not available on this asset,
     * or simply is not assigned any value on this asset.
     *
     * @param setName the name of the custom metadata set from which to retrieve the attribute's value
     * @param attrName the name of the custom metadata attribute for which to retrieve the value
     * @return the value of that custom metadata attribute on this asset, or null if there is no value
     */
    @JsonIgnore
    public Object getCustomMetadata(String setName, String attrName) {
        if (customMetadataSets == null) {
            return null;
        } else if (!customMetadataSets.containsKey(setName)) {
            return null;
        } else {
            Map<String, Object> attrs = customMetadataSets.get(setName).getAttributes();
            if (!attrs.containsKey(attrName)) {
                return null;
            } else {
                return attrs.get(attrName);
            }
        }
    }

    /**
     * Reduce the asset to the minimum set of properties required to update it.
     *
     * @return a builder containing the minimal set of properties required to update this asset
     * @throws InvalidRequestException if any of the minimal set of required properties are not found in the initial object
     */
    public AssetBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(getTypeName(), Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return IndistinctAsset.updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Reduce the asset to the minimum set of properties required to relate to it.
     *
     * @return an asset containing the minimal set of properties required to relate to this asset
     * @throws InvalidRequestException if any of the minimal set of required properties are not found in the initial object
     */
    public Asset trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return IndistinctAsset.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return IndistinctAsset.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return IndistinctAsset.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, "Asset", "guid, qualifiedName");
    }

    /**
     * If an asset with the same qualifiedName exists, updates the existing asset. Otherwise, creates the asset.
     * No Atlan tags or custom metadata will be changed if updating an existing asset, irrespective of what
     * is included in the asset itself when the method is called.
     *
     * @return details of the created or updated asset
     * @throws AtlanException on any error during the API invocation
     */
    public AssetMutationResponse save() throws AtlanException {
        return save(Atlan.getDefaultClient());
    }

    /**
     * If an asset with the same qualifiedName exists, updates the existing asset. Otherwise, creates the asset.
     * No Atlan tags or custom metadata will be changed if updating an existing asset, irrespective of what
     * is included in the asset itself when the method is called.
     *
     * @param client connectivity to the Atlan tenant on which to save the asset
     * @return details of the created or updated asset
     * @throws AtlanException on any error during the API invocation
     */
    public AssetMutationResponse save(AtlanClient client) throws AtlanException {
        return client.assets.save(this, false);
    }

    /**
     * If no asset exists, has the same behavior as the {@link #save()} method.
     * If an asset does exist, optionally overwrites any Atlan tags. Custom metadata will always
     * be entirely ignored using this method.
     *
     * @param replaceAtlanTags whether to replace Atlan tags during an update (true) or not (false)
     * @return details of the created or updated asset
     * @throws AtlanException on any error during the API invocation
     */
    public AssetMutationResponse save(boolean replaceAtlanTags) throws AtlanException {
        return save(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    /**
     * If no asset exists, has the same behavior as the {@link #save()} method.
     * If an asset does exist, optionally overwrites any Atlan tags. Custom metadata will always
     * be entirely ignored using this method.
     *
     * @param client connectivity to the Atlan tenant on which to save this asset
     * @param replaceAtlanTags whether to replace Atlan tags during an update (true) or not (false)
     * @return details of the created or updated asset
     * @throws AtlanException on any error during the API invocation
     */
    public AssetMutationResponse save(AtlanClient client, boolean replaceAtlanTags) throws AtlanException {
        return client.assets.save(this, replaceAtlanTags);
    }

    /**
     * If no asset exists, has the same behavior as the {@link #save()} method, while also setting
     * any custom metadata provided.
     * If an asset does exist, optionally overwrites any Atlan tags.
     * Will merge any provided custom metadata with any custom metadata that already exists on the asset.
     *
     * @param replaceAtlanTags whether to replace AtlanTags during an update (true) or not (false)
     * @return details of the created or updated asset
     * @throws AtlanException on any error during the API invocation
     */
    public AssetMutationResponse saveMergingCM(boolean replaceAtlanTags) throws AtlanException {
        return saveMergingCM(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    /**
     * If no asset exists, has the same behavior as the {@link #save()} method, while also setting
     * any custom metadata provided.
     * If an asset does exist, optionally overwrites any Atlan tags.
     * Will merge any provided custom metadata with any custom metadata that already exists on the asset.
     *
     * @param client connectivity to the Atlan tenant where this asset should be saved
     * @param replaceAtlanTags whether to replace AtlanTags during an update (true) or not (false)
     * @return details of the created or updated asset
     * @throws AtlanException on any error during the API invocation
     */
    public AssetMutationResponse saveMergingCM(AtlanClient client, boolean replaceAtlanTags) throws AtlanException {
        return client.assets.saveMergingCM(List.of(this), replaceAtlanTags);
    }

    /**
     * If no asset exists, has the same behavior as the {@link #save()} method, while also setting
     * any custom metadata provided.
     * If an asset does exist, optionally overwrites any Atlan tags.
     * Will overwrite all custom metadata on any existing asset with only the custom metadata provided
     * (wiping out any other custom metadata on an existing asset that is not provided in the request).
     *
     * @param replaceAtlanTags whether to replace Atlan tags during an update (true) or not (false)
     * @return details of the created or updated asset
     * @throws AtlanException on any error during the API invocation
     */
    public AssetMutationResponse saveReplacingCM(boolean replaceAtlanTags) throws AtlanException {
        return saveReplacingCM(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    /**
     * If no asset exists, has the same behavior as the {@link #save()} method, while also setting
     * any custom metadata provided.
     * If an asset does exist, optionally overwrites any Atlan tags.
     * Will overwrite all custom metadata on any existing asset with only the custom metadata provided
     * (wiping out any other custom metadata on an existing asset that is not provided in the request).
     *
     * @param client connectivity to the Atlan tenant where this asset should be saved
     * @param replaceAtlanTags whether to replace Atlan tags during an update (true) or not (false)
     * @return details of the created or updated asset
     * @throws AtlanException on any error during the API invocation
     */
    public AssetMutationResponse saveReplacingCM(AtlanClient client, boolean replaceAtlanTags) throws AtlanException {
        return client.assets.saveReplacingCM(List.of(this), replaceAtlanTags);
    }

    /**
     * If no asset exists, fails with a NotFoundException.
     * Will merge any provided custom metadata with any custom metadata that already exists on the asset.
     * If an asset does exist, optionally overwrites any Atlan tags.
     *
     * @param replaceAtlanTags whether to replace AtlanTags during an update (true) or not (false)
     * @return details of the updated asset
     * @throws AtlanException on any error during the API invocation
     * @throws com.atlan.exception.NotFoundException if the asset does not exist (will not create it)
     */
    public AssetMutationResponse updateMergingCM(boolean replaceAtlanTags) throws AtlanException {
        return updateMergingCM(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    /**
     * If no asset exists, fails with a NotFoundException.
     * Will merge any provided custom metadata with any custom metadata that already exists on the asset.
     * If an asset does exist, optionally overwrites any Atlan tags.
     *
     * @param client connectivity to the Atlan tenant where this asset should be saved
     * @param replaceAtlanTags whether to replace AtlanTags during an update (true) or not (false)
     * @return details of the updated asset
     * @throws AtlanException on any error during the API invocation
     * @throws com.atlan.exception.NotFoundException if the asset does not exist (will not create it)
     */
    public AssetMutationResponse updateMergingCM(AtlanClient client, boolean replaceAtlanTags) throws AtlanException {
        // Attempt to retrieve the asset first, and allow this to throw a NotFoundException if it does not exist
        get(client, this.getTypeName(), this.getQualifiedName(), false);
        // Otherwise, attempt the update
        return saveReplacingCM(client, replaceAtlanTags);
    }

    /**
     * If no asset exists, fails with a NotFoundException.
     * Will overwrite all custom metadata on any existing asset with only the custom metadata provided
     * (wiping out any other custom metadata on an existing asset that is not provided in the request).
     * If an asset does exist, optionally overwrites any Atlan tags.
     *
     * @param replaceAtlanTags whether to replace Atlan tags during an update (true) or not (false)
     * @return details of the updated asset
     * @throws AtlanException on any error during the API invocation
     * @throws com.atlan.exception.NotFoundException if the asset does not exist (will not create it)
     */
    public AssetMutationResponse updateReplacingCM(boolean replaceAtlanTags) throws AtlanException {
        return updateReplacingCM(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    /**
     * If no asset exists, fails with a NotFoundException.
     * Will overwrite all custom metadata on any existing asset with only the custom metadata provided
     * (wiping out any other custom metadata on an existing asset that is not provided in the request).
     * If an asset does exist, optionally overwrites any Atlan tags.
     *
     * @param client connectivity to the Atlan tenant where this asset should be saved
     * @param replaceAtlanTags whether to replace Atlan tags during an update (true) or not (false)
     * @return details of the updated asset
     * @throws AtlanException on any error during the API invocation
     * @throws com.atlan.exception.NotFoundException if the asset does not exist (will not create it)
     */
    public AssetMutationResponse updateReplacingCM(AtlanClient client, boolean replaceAtlanTags) throws AtlanException {
        // Attempt to retrieve the asset first, and allow this to throw a NotFoundException if it does not exist
        get(client, this.getTypeName(), this.getQualifiedName(), false);
        // Otherwise, attempt the update
        return saveReplacingCM(client, replaceAtlanTags);
    }

    /**
     * Start a fluent lineage request that will return all active downstream assets.
     * Additional conditions can be chained onto the returned builder before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) assets will be included.
     * (To change the default direction of downstream, chain a .direction() call.)
     *
     * @return a fluent lineage request that includes all active downstream assets
     */
    public FluentLineage.FluentLineageBuilder requestLineage() {
        return Asset.lineage(getGuid());
    }

    /**
     * Start a fluent lineage request that will return all active downstream assets.
     * Additional conditions can be chained onto the returned builder before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) assets will be included.
     * (To change the default direction of downstream, chain a .direction() call.)
     *
     * @param client connectivity to Atlan tenant
     * @return a fluent lineage request that includes all active downstream assets
     */
    public FluentLineage.FluentLineageBuilder requestLineage(AtlanClient client) {
        return Asset.lineage(client, getGuid());
    }

    /**
     * Add the API token configured for the default client as an admin to this object.
     *
     * @param assetGuid unique identifier (GUID) of the asset to which we should add this API token as an admin
     * @param impersonationToken a bearer token for an actual user who is already an admin for the object, NOT an API token
     * @throws AtlanException on any error during API invocation
     */
    protected static AssetMutationResponse addApiTokenAsAdmin(final String assetGuid, final String impersonationToken) throws AtlanException {
        AtlanClient client = Atlan.getDefaultClient();
        String token = client.users.getCurrentUser().getUsername();
        String clientGuid = UUID.randomUUID().toString();
        AtlanClient tmp = Atlan.getClient(client.getBaseUrl(), clientGuid);
        tmp.setApiToken(impersonationToken);
        // Look for the asset as the impersonated user, ensuring we include the admin users
        // in the results (so we avoid clobbering any existing admin users)
        Optional<Asset> found = tmp.assets.select().where(GUID.eq(assetGuid)).includeOnResults(ADMIN_USERS).pageSize(1).stream().findFirst();
        AssetMutationResponse response = null;
        if (found.isPresent()) {
            Asset asset = found.get();
            Set<String> existingAdmins = asset.getAdminUsers();
            response = asset.trimToRequired().adminUsers(existingAdmins).adminUser(token).build().save(tmp);
        } else {
            Atlan.removeClient(client.getBaseUrl(), clientGuid);
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, assetGuid);
        }
        Atlan.removeClient(client.getBaseUrl(), clientGuid);
        return response;
    }

    /**
     * Retrieves an asset by its GUID, optionally complete with all of its relationships.
     * The type of the asset will only be determined at runtime.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param guid of the asset to retrieve
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full asset, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link com.atlan.exception.NotFoundException} if the asset does not exist
     */
    @JsonIgnore
    public static Asset get(AtlanClient client, String guid, boolean includeRelationships) throws AtlanException {
        AssetResponse response = client.assets.get(guid, !includeRelationships, !includeRelationships);
        Asset asset = response.getAsset();
        if (asset != null && includeRelationships) {
            asset.setCompleteObject();
        }
        return asset;
    }

    /**
     * Retrieves an asset by its qualifiedName, optionally complete with all of its relationships.
     * The type of the asset will only be determined at runtime.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param typeName the type of the asset to retrieve
     * @param qualifiedName the unique name of the asset to retrieve
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full asset, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link com.atlan.exception.NotFoundException} if the asset does not exist
     */
    @JsonIgnore
    public static Asset get(AtlanClient client, String typeName, String qualifiedName, boolean includeRelationships) throws AtlanException {
        AssetResponse response = client.assets.get(typeName, qualifiedName, !includeRelationships, !includeRelationships);
        Asset asset = response.getAsset();
        if (asset != null && includeRelationships) {
            asset.setCompleteObject();
        }
        return asset;
    }

    /**
     * Soft-deletes an asset by its GUID. This operation can be reversed by updating the asset and changing
     * its {@link #status} to {@code ACTIVE}.
     *
     * @param guid of the asset to soft-delete
     * @return details of the soft-deleted asset
     * @throws AtlanException on any error during the API invocation
     */
    public static AssetDeletionResponse delete(String guid) throws AtlanException {
        return delete(Atlan.getDefaultClient(), guid);
    }

    /**
     * Soft-deletes an asset by its GUID. This operation can be reversed by updating the asset and changing
     * its {@link #status} to {@code ACTIVE}.
     *
     * @param client connectivity to the Atlan tenant from which to delete the asset
     * @param guid of the asset to soft-delete
     * @return details of the soft-deleted asset
     * @throws AtlanException on any error during the API invocation
     */
    public static AssetDeletionResponse delete(AtlanClient client, String guid) throws AtlanException {
        return client.assets.delete(guid, AtlanDeleteType.SOFT);
    }

    /**
     * Hard-deletes (purges) an asset by its GUID. This operation is irreversible.
     *
     * @param guid of the asset to hard-delete
     * @return details of the hard-deleted asset
     * @throws AtlanException on any error during the API invocation
     */
    public static AssetDeletionResponse purge(String guid) throws AtlanException {
        return purge(Atlan.getDefaultClient(), guid);
    }

    /**
     * Hard-deletes (purges) an asset by its GUID. This operation is irreversible.
     *
     * @param client connectivity to the Atlan tenant from which to delete the asset
     * @param guid of the asset to hard-delete
     * @return details of the hard-deleted asset
     * @throws AtlanException on any error during the API invocation
     */
    public static AssetDeletionResponse purge(AtlanClient client, String guid) throws AtlanException {
        return client.assets.delete(guid, AtlanDeleteType.PURGE);
    }

    /**
     * Start a fluent lineage request that will return all active downstream assets.
     * Additional conditions can be chained onto the returned builder before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) assets will be included.
     * (To change the default direction of downstream, chain a .direction() call.)
     *
     * @param guid unique identifier (GUID) for the starting point of lineage
     * @return a fluent lineage request that includes all active downstream assets
     */
    public static FluentLineage.FluentLineageBuilder lineage(String guid) {
        return lineage(Atlan.getDefaultClient(), guid);
    }

    /**
     * Start a fluent lineage request that will return all active downstream assets.
     * Additional conditions can be chained onto the returned builder before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) assets will be included.
     * (To change the default direction of downstream, chain a .direction() call.)
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param guid unique identifier (GUID) for the starting point of lineage
     * @return a fluent lineage request that includes all active downstream assets
     */
    public static FluentLineage.FluentLineageBuilder lineage(AtlanClient client, String guid) {
        return lineage(client, guid, false);
    }

    /**
     * Start a fluent lineage request that will return all downstream assets.
     * Additional conditions can be chained onto the returned builder before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. (To change the default direction of downstream, chain a
     * .direction() call.)
     *
     * @param guid unique identifier (GUID) for the starting point of lineage
     * @param includeArchived when true, archived (soft-deleted) assets in lineage will be included
     * @return a fluent lineage request that includes all downstream assets
     */
    public static FluentLineage.FluentLineageBuilder lineage(String guid, boolean includeArchived) {
        return lineage(Atlan.getDefaultClient(), guid, includeArchived);
    }

    /**
     * Start a fluent lineage request that will return all downstream assets.
     * Additional conditions can be chained onto the returned builder before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. (To change the default direction of downstream, chain a
     * .direction() call.)
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the lineage
     * @param guid unique identifier (GUID) for the starting point of lineage
     * @param includeArchived when true, archived (soft-deleted) assets in lineage will be included
     * @return a fluent search that includes all downstream assets
     */
    public static FluentLineage.FluentLineageBuilder lineage(AtlanClient client, String guid, boolean includeArchived) {
        FluentLineage.FluentLineageBuilder builder = FluentLineage.builder(client, guid);
        if (!includeArchived) {
            builder.whereAsset(FluentLineage.ACTIVE).whereRelationship(FluentLineage.ACTIVE).includeInResults(FluentLineage.ACTIVE);
        }
        return builder;
    }

    /**
     * Update only the provided custom metadata attributes on the asset. This will leave all other custom metadata
     * attributes, even within the same named custom metadata, unchanged.
     *
     * @param guid unique identifier of the asset
     * @param cmName human-readable name of the custom metadata to update
     * @param attributes the values of the custom metadata attributes to change
     * @throws AtlanException on any API problems, or if the custom metadata is not defined in Atlan
     */
    public static void updateCustomMetadataAttributes(String guid, String cmName, CustomMetadataAttributes attributes) throws AtlanException {
        updateCustomMetadataAttributes(Atlan.getDefaultClient(), guid, cmName, attributes);
    }

    /**
     * Update only the provided custom metadata attributes on the asset. This will leave all other custom metadata
     * attributes, even within the same named custom metadata, unchanged.
     *
     * @param client connectivity to the Atlan tenant on which to update the asset's custom metadata attributes
     * @param guid unique identifier of the asset
     * @param cmName human-readable name of the custom metadata to update
     * @param attributes the values of the custom metadata attributes to change
     * @throws AtlanException on any API problems, or if the custom metadata is not defined in Atlan
     */
    public static void updateCustomMetadataAttributes(AtlanClient client, String guid, String cmName, CustomMetadataAttributes attributes) throws AtlanException {
        client.assets.updateCustomMetadataAttributes(guid, cmName, attributes);
    }

    /**
     * Replace specific custom metadata on the asset. This will replace everything within the named custom metadata,
     * but will not change any of the other named custom metadata on the asset.
     *
     * @param guid unique identifier of the asset
     * @param cmName human-readable name of the custom metadata to replace
     * @param attributes the values of the attributes to replace for the custom metadata
     * @throws AtlanException on any API problems, or if the custom metadata is not defined in Atlan
     */
    public static void replaceCustomMetadata(String guid, String cmName, CustomMetadataAttributes attributes) throws AtlanException {
        replaceCustomMetadata(Atlan.getDefaultClient(), guid, cmName, attributes);
    }

    /**
     * Replace specific custom metadata on the asset. This will replace everything within the named custom metadata,
     * but will not change any of the other named custom metadata on the asset.
     *
     * @param client connectivity to the Atlan tenant on which to replace the asset's custom metadata
     * @param guid unique identifier of the asset
     * @param cmName human-readable name of the custom metadata to replace
     * @param attributes the values of the attributes to replace for the custom metadata
     * @throws AtlanException on any API problems, or if the custom metadata is not defined in Atlan
     */
    public static void replaceCustomMetadata(AtlanClient client, String guid, String cmName, CustomMetadataAttributes attributes) throws AtlanException {
        client.assets.replaceCustomMetadata(guid, cmName, attributes);
    }

    /**
     * Remove specific custom metadata from an asset.
     *
     * @param guid unique identifier of the asset
     * @param cmName human-readable name of the custom metadata to remove
     * @throws AtlanException on any API problems, or if the custom metadata is not defined in Atlan
     */
    public static void removeCustomMetadata(String guid, String cmName) throws AtlanException {
        removeCustomMetadata(Atlan.getDefaultClient(), guid, cmName);
    }

    /**
     * Remove specific custom metadata from an asset.
     *
     * @param client connectivity to the Atlan tenant from which to remove the asset's custom metadata
     * @param guid unique identifier of the asset
     * @param cmName human-readable name of the custom metadata to remove
     * @throws AtlanException on any API problems, or if the custom metadata is not defined in Atlan
     */
    public static void removeCustomMetadata(AtlanClient client, String guid, String cmName) throws AtlanException {
        client.assets.removeCustomMetadata(guid, cmName);
    }

    /**
     * Add Atlan tags to an asset, without replacing existing Atlan tags linked to the asset.
     * Note: this operation must make two API calls — one to retrieve the asset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the asset
     * @param typeName type of the asset
     * @param qualifiedName of the asset
     * @param atlanTagNames human-readable names of the Atlan tags to append
     * @return the asset that was updated
     * @throws AtlanException on any API problems
     */
    protected static Asset appendAtlanTags(AtlanClient client, String typeName, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(client, typeName, qualifiedName, atlanTagNames, true, true, false);
    }

    /**
     * Add Atlan tags to an asset, without replacing existing Atlan tags linked to the asset.
     * Note: this operation must make two API calls — one to retrieve the asset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to add the Atlan tags to the asset
     * @param typeName type of the asset
     * @param qualifiedName of the asset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @return the asset that was updated
     * @throws AtlanException on any API problems
     */
    protected static Asset appendAtlanTags(AtlanClient client, String typeName, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset existing = get(client, typeName, qualifiedName, true);
        if (atlanTagNames == null) {
            return existing;
        } else if (existing != null) {
            Set<AtlanTag> replacementAtlanTags = new TreeSet<>();
            Set<AtlanTag> existingAtlanTags = existing.getAtlanTags();
            if (existingAtlanTags != null) {
                for (AtlanTag atlanTag : existingAtlanTags) {
                    if (existing.getGuid().equals(atlanTag.getEntityGuid())) {
                        // Only re-include Atlan tags that are directly assigned, and whose
                        // propagation settings are not being overridden by this update
                        // (Propagation overrides will be handled by the loop further below)
                        if (!atlanTagNames.contains(atlanTag.getTypeName())) {
                            replacementAtlanTags.add(atlanTag);
                        }
                    }
                }
            }
            // Append all the extra Atlan tags (including any propagation overrides)
            for (String atlanTagName : atlanTagNames) {
                replacementAtlanTags.add(AtlanTag.builder().typeName(atlanTagName).propagate(propagate).removePropagationsOnEntityDelete(removePropagationsOnDelete).restrictPropagationThroughLineage(restrictLineagePropagation).build());
            }
            AssetBuilder<?, ?> minimal = existing.trimToRequired();
            return replaceAtlanTags(client, minimal.atlanTags(replacementAtlanTags).build());
        }
        return null;
    }

    /**
     * Remove an Atlan tag from an asset.
     *
     * @param client connectivity to the Atlan tenant on which to remove the Atlan tag from the asset
     * @param typeName type of the asset
     * @param qualifiedName of the asset
     * @param atlanTagName human-readable name of the Atlan tags to remove
     * @throws AtlanException on any API problems, or if any of the Atlan tag does not exist on the asset
     */
    protected static void removeAtlanTag(AtlanClient client, String typeName, String qualifiedName, String atlanTagName) throws AtlanException {
        client.assets.removeAtlanTag(typeName, qualifiedName, atlanTagName, true);
    }

    /**
     * Update the certificate on an asset.
     *
     * @param client connectivity to the Atlan tenant on which to update the asset's certificate
     * @param builder the builder to use for updating the certificate
     * @param certificate certificate to set
     * @param message (optional) message to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    protected static Asset updateCertificate(AtlanClient client, AssetBuilder<?, ?> builder, CertificateStatus certificate, String message) throws AtlanException {
        builder.certificateStatus(certificate);
        if (message != null && message.length() > 1) {
            builder.certificateStatusMessage(message);
        }
        return updateAttributes(client, builder.build());
    }

    /**
     * Remove the certificate on an asset.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's certificate
     * @param builder the builder to use for removing the certificate
     * @return the result of the removal, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    protected static Asset removeCertificate(AtlanClient client, AssetBuilder<?, ?> builder) throws AtlanException {
        Asset asset = builder.removeCertificate().build();
        AssetMutationResponse response = asset.save(client);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        } else {
            return null;
        }
    }

    /**
     * Update the announcement on an asset.
     *
     * @param client connectivity to the Atlan tenant on which to update the asset's announcement
     * @param builder the builder to use for updating the announcement
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    protected static Asset updateAnnouncement(AtlanClient client, AssetBuilder<?, ?> builder, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        builder.announcementType(type);
        if (title != null && title.length() > 1) {
            builder.announcementTitle(title);
        }
        if (message != null && message.length() > 1) {
            builder.announcementMessage(message);
        }
        return updateAttributes(client, builder.build());
    }

    /**
     * Remove the announcement on an asset.
     *
     * @param client connectivity to the Atlan tenant from which to remove the asset's announcement
     * @param builder the builder to use for removing the announcement
     * @return the result of the removal, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    protected static Asset removeAnnouncement(AtlanClient client, AssetBuilder<?, ?> builder) throws AtlanException {
        Asset asset = builder.removeAnnouncement().build();
        AssetMutationResponse response = asset.save(client);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        } else {
            return null;
        }
    }

    /**
     * Remove the system description from an asset.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param builder the builder to use for removing the description
     * @return the result of the removal, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    protected static Asset removeDescription(AtlanClient client, AssetBuilder<?, ?> builder) throws AtlanException {
        Asset asset = builder.removeDescription().build();
        AssetMutationResponse response = asset.save(client);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        } else {
            return null;
        }
    }

    /**
     * Remove the user-provided description from an asset.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param builder the builder to use for removing the description
     * @return the result of the removal, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    protected static Asset removeUserDescription(AtlanClient client, AssetBuilder<?, ?> builder) throws AtlanException {
        Asset asset = builder.removeUserDescription().build();
        AssetMutationResponse response = asset.save(client);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        } else {
            return null;
        }
    }

    /**
     * Remove the owners from an asset.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's owners
     * @param builder the builder to use for removing the owners
     * @return the result of the removal, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    protected static Asset removeOwners(AtlanClient client, AssetBuilder<?, ?> builder) throws AtlanException {
        Asset asset = builder.removeOwners().build();
        AssetMutationResponse response = asset.save(client);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        } else {
            return null;
        }
    }

    private static Asset updateAttributes(AtlanClient client, Asset asset) throws AtlanException {
        AssetMutationResponse response = client.assets.save(asset, false);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        }
        return null;
    }

    private static Asset replaceAtlanTags(AtlanClient client, Asset asset) throws AtlanException {
        AssetMutationResponse response = client.assets.save(asset, true);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        }
        return null;
    }

    /**
     * Update the certificate on an asset.
     *
     * @param client connectivity to the Atlan tenant on which to update the asset's certificate
     * @param builder the builder to use for updating the certificate
     * @param typeName type of the asset
     * @param qualifiedName for the asset
     * @param certificate certificate to set
     * @param message (optional) message to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    protected static Asset updateCertificate(AtlanClient client, AssetBuilder<?, ?> builder, String typeName, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        builder.qualifiedName(qualifiedName).certificateStatus(certificate);
        if (message != null && message.length() > 1) {
            builder.certificateStatusMessage(message);
        }
        return updateAttributes(client, typeName, qualifiedName, builder.build());
    }

    /**
     * Update the announcement on an asset.
     *
     * @param client connectivity to the Atlan tenant on which to update the asset's announcement
     * @param builder the builder to use for updating the announcement
     * @param typeName type of the asset
     * @param qualifiedName for the asset
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    protected static Asset updateAnnouncement(AtlanClient client, AssetBuilder<?, ?> builder, String typeName, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        builder.qualifiedName(qualifiedName).announcementType(type);
        if (title != null && title.length() > 1) {
            builder.announcementTitle(title);
        }
        if (message != null && message.length() > 1) {
            builder.announcementMessage(message);
        }
        return updateAttributes(client, typeName, qualifiedName, builder.build());
    }

    private static Asset updateAttributes(AtlanClient client, String typeName, String qualifiedName, Asset asset) throws AtlanException {
        AssetMutationResponse response = client.assets.updateAttributes(typeName, qualifiedName, asset);
        if (response != null && !response.getPartiallyUpdatedAssets().isEmpty()) {
            return response.getPartiallyUpdatedAssets().get(0);
        }
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            return response.getUpdatedAssets().get(0);
        }
        return null;
    }

    /**
     * Restore an archived (soft-deleted) asset to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param typeName type of the asset to restore
     * @param qualifiedName of the asset to restore
     * @return true if the asset is now restored, or false if not
     * @throws AtlanException on any API problems
     */
    protected static boolean restore(AtlanClient client, String typeName, String qualifiedName) throws AtlanException {
        try {
            return restore(client, typeName, qualifiedName, 0);
        } catch (InterruptedException e) {
            throw new ApiException(ErrorCode.RETRIES_INTERRUPTED, e);
        }
    }

    /**
     * Restore an archived (soft-deleted) asset to active, retrying in case it is found to
     * already be active (since the delete handlers run asynchronously).
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param typeName type of the asset to restore
     * @param qualifiedName of the asset to restore
     * @param retryCount number of retries we have already attempted
     * @return true if the asset is now restored, or false if not
     * @throws AtlanException on any API problems
     * @throws InterruptedException if the retry cycle sleeps are interrupted
     */
    private static boolean restore(AtlanClient client, String typeName, String qualifiedName, int retryCount) throws AtlanException, InterruptedException {
        Asset existing = get(client, typeName, qualifiedName, true);
        if (existing == null) {
            // Nothing to restore, so cannot be restored
            return false;
        } else if (existing.getStatus() == AtlanStatus.ACTIVE) {
            // Already active, but this could be due to the async nature of the delete handlers
            if (retryCount < Atlan.getMaxNetworkRetries()) {
                // So continue to retry up to the maximum number of allowed retries
                log.debug("Attempted to restore an active asset, retrying status check for async delete handling (attempt: {}).", retryCount + 1);
                Thread.sleep(HttpClient.waitTime(retryCount).toMillis());
                return restore(client, typeName, qualifiedName, retryCount + 1);
            } else {
                // If we have exhausted the retries, though, then we should just short-circuit
                return true;
            }
        } else {
            Optional<String> guidRestored = restore(client, existing);
            return guidRestored.isPresent() && guidRestored.get().equals(existing.getGuid());
        }
    }

    /**
     * Replace the terms linked to an asset.
     *
     * @param client connectivity to the Atlan tenant on which to replace the asset's terms
     * @param builder the builder to use for updating the terms
     * @param terms the list of terms to replace on the asset, or null to remove all terms from an asset
     * @return the asset that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    protected static Asset replaceTerms(AtlanClient client, AssetBuilder<?, ?> builder, List<IGlossaryTerm> terms) throws AtlanException {
        if (terms == null || terms.isEmpty()) {
            Asset asset = builder.removeAssignedTerms().build();
            return updateRelationships(client, asset);
        } else {
            return updateRelationships(client, builder.assignedTerms(getTermRefs(terms)).build());
        }
    }

    /**
     * Link additional terms to an asset, without replacing existing terms linked to the asset.
     * Note: this operation must make two API calls — one to retrieve the asset's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the asset
     * @param typeName type of the asset
     * @param qualifiedName for the asset
     * @param terms the list of terms to append to the asset
     * @return the asset that was updated (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    protected static Asset appendTerms(AtlanClient client, String typeName, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        Asset existing = get(client, typeName, qualifiedName, true);
        if (terms == null) {
            return existing;
        } else if (existing != null) {
            Set<IGlossaryTerm> replacementTerms = new TreeSet<>();
            Set<IGlossaryTerm> existingTerms = existing.getAssignedTerms();
            if (existingTerms != null) {
                for (IGlossaryTerm term : existingTerms) {
                    if (term.getRelationshipStatus() != AtlanStatus.DELETED) {
                        // Only re-include the terms that are not already deleted
                        replacementTerms.add(term);
                    }
                }
            }
            replacementTerms.addAll(terms);
            AssetBuilder<?, ?> minimal = existing.trimToRequired();
            return updateRelationships(client, minimal.assignedTerms(getTermRefs(replacementTerms)).build());
        }
        return null;
    }

    /**
     * Remove terms from an asset, without replacing all existing terms linked to the asset.
     * Note: this operation must make two API calls — one to retrieve the asset's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant on which to remove terms from the asset
     * @param typeName type of the asset
     * @param qualifiedName for the asset
     * @param terms the list of terms to remove from the asset (note: these must be references by GUID
     *              in order to efficiently remove any existing terms)
     * @return the asset that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     * @throws InvalidRequestException if any of the passed terms are not valid references by GUID to a term
     */
    protected static Asset removeTerms(AtlanClient client, String typeName, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        Asset existing = get(client, typeName, qualifiedName, true);
        if (existing != null) {
            Set<IGlossaryTerm> replacementTerms = new TreeSet<>();
            Set<IGlossaryTerm> existingTerms = existing.getAssignedTerms();
            Set<String> removeGuids = new HashSet<>();
            for (IGlossaryTerm term : terms) {
                if (term.isValidReferenceByGuid()) {
                    removeGuids.add(term.getGuid());
                } else {
                    throw new InvalidRequestException(ErrorCode.MISSING_TERM_GUID);
                }
            }
            for (IGlossaryTerm term : existingTerms) {
                String existingTermGuid = term.getGuid();
                if (!removeGuids.contains(existingTermGuid) && term.getRelationshipStatus() != AtlanStatus.DELETED) {
                    // Only re-include the terms that we are not removing and that are not already deleted
                    replacementTerms.add(term);
                }
            }
            AssetBuilder<?, ?> minimal = existing.trimToRequired();
            Asset update;
            if (replacementTerms.isEmpty()) {
                // If there are no terms left after the removal, we need to do the same as removing all terms
                update = minimal.removeAssignedTerms().build();
            } else {
                // Otherwise we should do the update with the difference
                update = minimal.assignedTerms(getTermRefs(replacementTerms)).build();
            }
            return updateRelationships(client, update);
        }
        return null;
    }

    private static Collection<IGlossaryTerm> getTermRefs(Collection<IGlossaryTerm> terms) {
        if (terms != null && !terms.isEmpty()) {
            Set<IGlossaryTerm> termRefs = new TreeSet<>();
            for (IGlossaryTerm term : terms) {
                if (term.getGuid() != null) {
                    termRefs.add(GlossaryTerm.refByGuid(term.getGuid()));
                } else if (term.getQualifiedName() != null) {
                    termRefs.add(GlossaryTerm.refByQualifiedName(term.getQualifiedName()));
                }
            }
            return termRefs;
        } else {
            return Collections.emptySet();
        }
    }

    private static Asset updateRelationships(AtlanClient client, Asset asset) throws AtlanException {
        String typeNameToUpdate = asset.getTypeName();
        AssetMutationResponse response = client.assets.save(asset, false);
        if (response != null && !response.getUpdatedAssets().isEmpty()) {
            for (Asset result : response.getUpdatedAssets()) {
                if (result.getTypeName().equals(typeNameToUpdate)) {
                    String foundQN = result.getQualifiedName();
                    if (foundQN != null && foundQN.equals(asset.getQualifiedName())) {
                        // Return the first result that matches both the type that we attempted to update
                        // and the qualifiedName of the asset we attempted to update. Irrespective of
                        // the kind of relationship, this should uniquely identify the asset that we
                        // attempted to update
                        return result;
                    }
                }
            }
        }
        return null;
    }

    private static Optional<String> restore(AtlanClient client, Asset asset) throws AtlanException {
        AssetMutationResponse response = client.assets.restore(asset);
        if (response != null && !response.getGuidAssignments().isEmpty()) {
            return response.getGuidAssignments().values().stream().findFirst();
        }
        return Optional.empty();
    }


    public static abstract class AssetBuilder<C extends Asset, B extends Asset.AssetBuilder<C, B>> extends Reference.ReferenceBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> adminGroups;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> adminRoles;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> adminUsers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String announcementMessage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String announcementTitle;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanAnnouncementType announcementType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long announcementUpdatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String announcementUpdatedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAnomaloCheck> anomaloChecks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetAnomaloAppliedCheckTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetAnomaloCheckCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetAnomaloCheckStatuses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetAnomaloDQStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetAnomaloFailedCheckCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetAnomaloFailedCheckTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetAnomaloLastCheckRunAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetAnomaloSourceUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetCoverImage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtAccountName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtAlias;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtEnvironmentDbtVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtEnvironmentName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetDbtJobLastRun;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunArtifactS3Path;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean assetDbtJobLastRunArtifactsSaved;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetDbtJobLastRunCreatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetDbtJobLastRunDequedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunExecutedByThreadId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunGitBranch;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunGitSha;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean assetDbtJobLastRunHasDocsGenerated;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean assetDbtJobLastRunHasSourcesGenerated;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean assetDbtJobLastRunNotificationsSent;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunOwnerThreadId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunQueuedDuration;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunQueuedDurationHumanized;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunRunDuration;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunRunDurationHumanized;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetDbtJobLastRunStartedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunStatusMessage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunTotalDuration;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunTotalDurationHumanized;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetDbtJobLastRunUpdatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobLastRunUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetDbtJobNextRun;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobNextRunHumanized;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobSchedule;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobScheduleCronHumanized;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtJobStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtMeta;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtPackageName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtProjectName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtSemanticLayerProxyUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtSourceFreshnessCriteria;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetDbtTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtTestStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtUniqueId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetDbtWorkflowLastUpdated;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanIcon assetIcon;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcAlertQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcIncidentNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcIncidentPriorities;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcIncidentQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcIncidentSeverities;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcIncidentStates;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcIncidentSubTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcIncidentTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetMcLastSyncRunAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcMonitorNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcMonitorQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcMonitorScheduleTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcMonitorStatuses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetMcMonitorTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetPoliciesCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetPolicyGUIDs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetSodaCheckCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetSodaCheckStatuses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetSodaDQStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetSodaLastScanAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long assetSodaLastSyncRunAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetSodaSourceURL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> assetTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetThemeHex;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> assignedTerms;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CertificateStatus certificateStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String certificateStatusMessage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long certificateUpdatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String certificateUpdatedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String connectionName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String connectionQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanConnectorType connectorType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IDataContract dataContractLatest;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IDataContract dataContractLatestCertified;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String description;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String displayName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> domainGUIDs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IFile> files;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean hasContract;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean hasLineage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDataProduct> inputPortDataProducts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isAIGenerated;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isDiscoverable;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isEditable;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isPartial;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long lastRowChangedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String lastSyncRun;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long lastSyncRunAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String lastSyncWorkflowName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String lexicographicalSortOrder;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILink> links;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMCIncident> mcIncidents;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMCMonitor> mcMonitors;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMetric> metrics;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String name;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> nonCompliantAssetPolicyGUIDs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDataProduct> outputPortDataProducts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> ownerGroups;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> ownerUsers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double popularityScore;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IReadme readme;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sampleDataUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISchemaRegistrySubject> schemaRegistrySubjects;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISodaCheck> sodaChecks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SourceCostUnitType sourceCostUnit;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sourceCreatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceCreatedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceEmbedURL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sourceLastReadAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceOwners;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<PopularityInsights> sourceQueryComputeCostRecords;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> sourceQueryComputeCosts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sourceReadCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<PopularityInsights> sourceReadExpensiveQueryRecords;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<PopularityInsights> sourceReadPopularQueryRecords;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double sourceReadQueryCost;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<PopularityInsights> sourceReadRecentUserRecords;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> sourceReadRecentUsers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<PopularityInsights> sourceReadSlowQueryRecords;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<PopularityInsights> sourceReadTopUserRecords;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> sourceReadTopUsers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sourceReadUserCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double sourceTotalCost;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceURL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sourceUpdatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceUpdatedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> starredBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer starredCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<StarredDetails> starredDetails;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String subType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tenantId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAsset> userDefRelationshipFroms;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAsset> userDefRelationshipTos;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String userDescription;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double viewScore;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> viewerGroups;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> viewerUsers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> nullFields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AtlanTag> atlanTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> customMetadataSets$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<CustomMetadataAttributes> customMetadataSets$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanStatus status;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String createdBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String updatedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long createTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long updateTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String deleteHandler;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long depth;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<LineageRef> immediateUpstream;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<LineageRef> immediateDownstream;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> atlanTagNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isIncomplete;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> meaningNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Meaning> meanings;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> pendingTasks;

        /** Remove the announcement from the asset, if any is set on the asset. */
        public B removeAnnouncement() {
            nullField("announcementType");
            nullField("announcementTitle");
            nullField("announcementMessage");
            return self();
        }

        /** Remove all custom metadata from the asset, if any is set on the asset. */
        public B removeCustomMetadata() {
            // It is sufficient to simply exclude businessAttributes from a request in order
            // for them to be removed, as long as the "replaceBusinessAttributes" flag is set
            // to true (which it must be for any update to work to businessAttributes anyway)
            clearCustomMetadataSets();
            return self();
        }

        /** Remove the Atlan tags from the asset, if the asset is classified with any. */
        public B removeAtlanTags() {
            // It is sufficient to simply exclude Atlan tags from a request in order
            // for them to be removed, as long as the "replaceAtlanTags" flag is set to
            // true (which it must be for any update to work to Atlan tags anyway)
            clearAtlanTags();
            clearAtlanTagNames();
            return self();
        }

        /** Remove the system description from the asset, if any is set on the asset. */
        public B removeDescription() {
            nullField("description");
            return self();
        }

        /** Remove the user's description from the asset, if any is set on the asset. */
        public B removeUserDescription() {
            nullField("userDescription");
            return self();
        }

        /** Remove the owners from the asset, if any are set on the asset. */
        public B removeOwners() {
            nullField("ownerUsers");
            nullField("ownerGroups");
            return self();
        }

        /** Remove the certificate from the asset, if any is set on the asset. */
        public B removeCertificate() {
            nullField("certificateStatus");
            nullField("certificateStatusMessage");
            return self();
        }

        /** Remove the linked terms from the asset, if any are set on the asset. */
        public B removeAssignedTerms() {
            nullField("assignedTerms");
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Asset.AssetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Asset instance, final Asset.AssetBuilder<?, ?> b) {
            b.adminGroups(instance.adminGroups == null ? java.util.Collections.<String>emptySortedSet() : instance.adminGroups);
            b.adminRoles(instance.adminRoles == null ? java.util.Collections.<String>emptySortedSet() : instance.adminRoles);
            b.adminUsers(instance.adminUsers == null ? java.util.Collections.<String>emptySortedSet() : instance.adminUsers);
            b.announcementMessage(instance.announcementMessage);
            b.announcementTitle(instance.announcementTitle);
            b.announcementType(instance.announcementType);
            b.announcementUpdatedAt(instance.announcementUpdatedAt);
            b.announcementUpdatedBy(instance.announcementUpdatedBy);
            b.anomaloChecks(instance.anomaloChecks == null ? java.util.Collections.<IAnomaloCheck>emptySortedSet() : instance.anomaloChecks);
            b.assetAnomaloAppliedCheckTypes(instance.assetAnomaloAppliedCheckTypes == null ? java.util.Collections.<String>emptySortedSet() : instance.assetAnomaloAppliedCheckTypes);
            b.assetAnomaloCheckCount(instance.assetAnomaloCheckCount);
            b.assetAnomaloCheckStatuses(instance.assetAnomaloCheckStatuses);
            b.assetAnomaloDQStatus(instance.assetAnomaloDQStatus);
            b.assetAnomaloFailedCheckCount(instance.assetAnomaloFailedCheckCount);
            b.assetAnomaloFailedCheckTypes(instance.assetAnomaloFailedCheckTypes == null ? java.util.Collections.<String>emptySortedSet() : instance.assetAnomaloFailedCheckTypes);
            b.assetAnomaloLastCheckRunAt(instance.assetAnomaloLastCheckRunAt);
            b.assetAnomaloSourceUrl(instance.assetAnomaloSourceUrl);
            b.assetCoverImage(instance.assetCoverImage);
            b.assetDbtAccountName(instance.assetDbtAccountName);
            b.assetDbtAlias(instance.assetDbtAlias);
            b.assetDbtEnvironmentDbtVersion(instance.assetDbtEnvironmentDbtVersion);
            b.assetDbtEnvironmentName(instance.assetDbtEnvironmentName);
            b.assetDbtJobLastRun(instance.assetDbtJobLastRun);
            b.assetDbtJobLastRunArtifactS3Path(instance.assetDbtJobLastRunArtifactS3Path);
            b.assetDbtJobLastRunArtifactsSaved(instance.assetDbtJobLastRunArtifactsSaved);
            b.assetDbtJobLastRunCreatedAt(instance.assetDbtJobLastRunCreatedAt);
            b.assetDbtJobLastRunDequedAt(instance.assetDbtJobLastRunDequedAt);
            b.assetDbtJobLastRunExecutedByThreadId(instance.assetDbtJobLastRunExecutedByThreadId);
            b.assetDbtJobLastRunGitBranch(instance.assetDbtJobLastRunGitBranch);
            b.assetDbtJobLastRunGitSha(instance.assetDbtJobLastRunGitSha);
            b.assetDbtJobLastRunHasDocsGenerated(instance.assetDbtJobLastRunHasDocsGenerated);
            b.assetDbtJobLastRunHasSourcesGenerated(instance.assetDbtJobLastRunHasSourcesGenerated);
            b.assetDbtJobLastRunNotificationsSent(instance.assetDbtJobLastRunNotificationsSent);
            b.assetDbtJobLastRunOwnerThreadId(instance.assetDbtJobLastRunOwnerThreadId);
            b.assetDbtJobLastRunQueuedDuration(instance.assetDbtJobLastRunQueuedDuration);
            b.assetDbtJobLastRunQueuedDurationHumanized(instance.assetDbtJobLastRunQueuedDurationHumanized);
            b.assetDbtJobLastRunRunDuration(instance.assetDbtJobLastRunRunDuration);
            b.assetDbtJobLastRunRunDurationHumanized(instance.assetDbtJobLastRunRunDurationHumanized);
            b.assetDbtJobLastRunStartedAt(instance.assetDbtJobLastRunStartedAt);
            b.assetDbtJobLastRunStatusMessage(instance.assetDbtJobLastRunStatusMessage);
            b.assetDbtJobLastRunTotalDuration(instance.assetDbtJobLastRunTotalDuration);
            b.assetDbtJobLastRunTotalDurationHumanized(instance.assetDbtJobLastRunTotalDurationHumanized);
            b.assetDbtJobLastRunUpdatedAt(instance.assetDbtJobLastRunUpdatedAt);
            b.assetDbtJobLastRunUrl(instance.assetDbtJobLastRunUrl);
            b.assetDbtJobName(instance.assetDbtJobName);
            b.assetDbtJobNextRun(instance.assetDbtJobNextRun);
            b.assetDbtJobNextRunHumanized(instance.assetDbtJobNextRunHumanized);
            b.assetDbtJobSchedule(instance.assetDbtJobSchedule);
            b.assetDbtJobScheduleCronHumanized(instance.assetDbtJobScheduleCronHumanized);
            b.assetDbtJobStatus(instance.assetDbtJobStatus);
            b.assetDbtMeta(instance.assetDbtMeta);
            b.assetDbtPackageName(instance.assetDbtPackageName);
            b.assetDbtProjectName(instance.assetDbtProjectName);
            b.assetDbtSemanticLayerProxyUrl(instance.assetDbtSemanticLayerProxyUrl);
            b.assetDbtSourceFreshnessCriteria(instance.assetDbtSourceFreshnessCriteria);
            b.assetDbtTags(instance.assetDbtTags == null ? java.util.Collections.<String>emptySortedSet() : instance.assetDbtTags);
            b.assetDbtTestStatus(instance.assetDbtTestStatus);
            b.assetDbtUniqueId(instance.assetDbtUniqueId);
            b.assetDbtWorkflowLastUpdated(instance.assetDbtWorkflowLastUpdated);
            b.assetIcon(instance.assetIcon);
            b.assetMcAlertQualifiedNames(instance.assetMcAlertQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcAlertQualifiedNames);
            b.assetMcIncidentNames(instance.assetMcIncidentNames == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcIncidentNames);
            b.assetMcIncidentPriorities(instance.assetMcIncidentPriorities == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcIncidentPriorities);
            b.assetMcIncidentQualifiedNames(instance.assetMcIncidentQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcIncidentQualifiedNames);
            b.assetMcIncidentSeverities(instance.assetMcIncidentSeverities == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcIncidentSeverities);
            b.assetMcIncidentStates(instance.assetMcIncidentStates == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcIncidentStates);
            b.assetMcIncidentSubTypes(instance.assetMcIncidentSubTypes == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcIncidentSubTypes);
            b.assetMcIncidentTypes(instance.assetMcIncidentTypes == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcIncidentTypes);
            b.assetMcLastSyncRunAt(instance.assetMcLastSyncRunAt);
            b.assetMcMonitorNames(instance.assetMcMonitorNames == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcMonitorNames);
            b.assetMcMonitorQualifiedNames(instance.assetMcMonitorQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcMonitorQualifiedNames);
            b.assetMcMonitorScheduleTypes(instance.assetMcMonitorScheduleTypes == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcMonitorScheduleTypes);
            b.assetMcMonitorStatuses(instance.assetMcMonitorStatuses == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcMonitorStatuses);
            b.assetMcMonitorTypes(instance.assetMcMonitorTypes == null ? java.util.Collections.<String>emptySortedSet() : instance.assetMcMonitorTypes);
            b.assetPoliciesCount(instance.assetPoliciesCount);
            b.assetPolicyGUIDs(instance.assetPolicyGUIDs == null ? java.util.Collections.<String>emptySortedSet() : instance.assetPolicyGUIDs);
            b.assetSodaCheckCount(instance.assetSodaCheckCount);
            b.assetSodaCheckStatuses(instance.assetSodaCheckStatuses);
            b.assetSodaDQStatus(instance.assetSodaDQStatus);
            b.assetSodaLastScanAt(instance.assetSodaLastScanAt);
            b.assetSodaLastSyncRunAt(instance.assetSodaLastSyncRunAt);
            b.assetSodaSourceURL(instance.assetSodaSourceURL);
            b.assetTags(instance.assetTags == null ? java.util.Collections.<String>emptySortedSet() : instance.assetTags);
            b.assetThemeHex(instance.assetThemeHex);
            b.assignedTerms(instance.assignedTerms == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.assignedTerms);
            b.certificateStatus(instance.certificateStatus);
            b.certificateStatusMessage(instance.certificateStatusMessage);
            b.certificateUpdatedAt(instance.certificateUpdatedAt);
            b.certificateUpdatedBy(instance.certificateUpdatedBy);
            b.connectionName(instance.connectionName);
            b.connectionQualifiedName(instance.connectionQualifiedName);
            b.connectorType(instance.connectorType);
            b.dataContractLatest(instance.dataContractLatest);
            b.dataContractLatestCertified(instance.dataContractLatestCertified);
            b.dbtQualifiedName(instance.dbtQualifiedName);
            b.description(instance.description);
            b.displayName(instance.displayName);
            b.domainGUIDs(instance.domainGUIDs == null ? java.util.Collections.<String>emptySortedSet() : instance.domainGUIDs);
            b.files(instance.files == null ? java.util.Collections.<IFile>emptySortedSet() : instance.files);
            b.hasContract(instance.hasContract);
            b.hasLineage(instance.hasLineage);
            b.inputPortDataProducts(instance.inputPortDataProducts == null ? java.util.Collections.<IDataProduct>emptySortedSet() : instance.inputPortDataProducts);
            b.isAIGenerated(instance.isAIGenerated);
            b.isDiscoverable(instance.isDiscoverable);
            b.isEditable(instance.isEditable);
            b.isPartial(instance.isPartial);
            b.lastRowChangedAt(instance.lastRowChangedAt);
            b.lastSyncRun(instance.lastSyncRun);
            b.lastSyncRunAt(instance.lastSyncRunAt);
            b.lastSyncWorkflowName(instance.lastSyncWorkflowName);
            b.lexicographicalSortOrder(instance.lexicographicalSortOrder);
            b.links(instance.links == null ? java.util.Collections.<ILink>emptySortedSet() : instance.links);
            b.mcIncidents(instance.mcIncidents == null ? java.util.Collections.<IMCIncident>emptySortedSet() : instance.mcIncidents);
            b.mcMonitors(instance.mcMonitors == null ? java.util.Collections.<IMCMonitor>emptySortedSet() : instance.mcMonitors);
            b.metrics(instance.metrics == null ? java.util.Collections.<IMetric>emptySortedSet() : instance.metrics);
            b.name(instance.name);
            b.nonCompliantAssetPolicyGUIDs(instance.nonCompliantAssetPolicyGUIDs == null ? java.util.Collections.<String>emptySortedSet() : instance.nonCompliantAssetPolicyGUIDs);
            b.outputPortDataProducts(instance.outputPortDataProducts == null ? java.util.Collections.<IDataProduct>emptySortedSet() : instance.outputPortDataProducts);
            b.ownerGroups(instance.ownerGroups == null ? java.util.Collections.<String>emptySortedSet() : instance.ownerGroups);
            b.ownerUsers(instance.ownerUsers == null ? java.util.Collections.<String>emptySortedSet() : instance.ownerUsers);
            b.popularityScore(instance.popularityScore);
            b.qualifiedName(instance.qualifiedName);
            b.readme(instance.readme);
            b.sampleDataUrl(instance.sampleDataUrl);
            b.schemaRegistrySubjects(instance.schemaRegistrySubjects == null ? java.util.Collections.<ISchemaRegistrySubject>emptySortedSet() : instance.schemaRegistrySubjects);
            b.sodaChecks(instance.sodaChecks == null ? java.util.Collections.<ISodaCheck>emptySortedSet() : instance.sodaChecks);
            b.sourceCostUnit(instance.sourceCostUnit);
            b.sourceCreatedAt(instance.sourceCreatedAt);
            b.sourceCreatedBy(instance.sourceCreatedBy);
            b.sourceEmbedURL(instance.sourceEmbedURL);
            b.sourceLastReadAt(instance.sourceLastReadAt);
            b.sourceOwners(instance.sourceOwners);
            b.sourceQueryComputeCostRecords(instance.sourceQueryComputeCostRecords == null ? java.util.Collections.<PopularityInsights>emptyList() : instance.sourceQueryComputeCostRecords);
            b.sourceQueryComputeCosts(instance.sourceQueryComputeCosts == null ? java.util.Collections.<String>emptySortedSet() : instance.sourceQueryComputeCosts);
            b.sourceReadCount(instance.sourceReadCount);
            b.sourceReadExpensiveQueryRecords(instance.sourceReadExpensiveQueryRecords == null ? java.util.Collections.<PopularityInsights>emptyList() : instance.sourceReadExpensiveQueryRecords);
            b.sourceReadPopularQueryRecords(instance.sourceReadPopularQueryRecords == null ? java.util.Collections.<PopularityInsights>emptyList() : instance.sourceReadPopularQueryRecords);
            b.sourceReadQueryCost(instance.sourceReadQueryCost);
            b.sourceReadRecentUserRecords(instance.sourceReadRecentUserRecords == null ? java.util.Collections.<PopularityInsights>emptyList() : instance.sourceReadRecentUserRecords);
            b.sourceReadRecentUsers(instance.sourceReadRecentUsers == null ? java.util.Collections.<String>emptySortedSet() : instance.sourceReadRecentUsers);
            b.sourceReadSlowQueryRecords(instance.sourceReadSlowQueryRecords == null ? java.util.Collections.<PopularityInsights>emptyList() : instance.sourceReadSlowQueryRecords);
            b.sourceReadTopUserRecords(instance.sourceReadTopUserRecords == null ? java.util.Collections.<PopularityInsights>emptyList() : instance.sourceReadTopUserRecords);
            b.sourceReadTopUsers(instance.sourceReadTopUsers == null ? java.util.Collections.<String>emptySortedSet() : instance.sourceReadTopUsers);
            b.sourceReadUserCount(instance.sourceReadUserCount);
            b.sourceTotalCost(instance.sourceTotalCost);
            b.sourceURL(instance.sourceURL);
            b.sourceUpdatedAt(instance.sourceUpdatedAt);
            b.sourceUpdatedBy(instance.sourceUpdatedBy);
            b.starredBy(instance.starredBy == null ? java.util.Collections.<String>emptySortedSet() : instance.starredBy);
            b.starredCount(instance.starredCount);
            b.starredDetails(instance.starredDetails == null ? java.util.Collections.<StarredDetails>emptyList() : instance.starredDetails);
            b.subType(instance.subType);
            b.tenantId(instance.tenantId);
            b.userDefRelationshipFroms(instance.userDefRelationshipFroms == null ? java.util.Collections.<IAsset>emptySortedSet() : instance.userDefRelationshipFroms);
            b.userDefRelationshipTos(instance.userDefRelationshipTos == null ? java.util.Collections.<IAsset>emptySortedSet() : instance.userDefRelationshipTos);
            b.userDescription(instance.userDescription);
            b.viewScore(instance.viewScore);
            b.viewerGroups(instance.viewerGroups == null ? java.util.Collections.<String>emptySortedSet() : instance.viewerGroups);
            b.viewerUsers(instance.viewerUsers == null ? java.util.Collections.<String>emptySortedSet() : instance.viewerUsers);
            b.nullFields(instance.nullFields == null ? java.util.Collections.<String>emptySet() : instance.nullFields);
            b.atlanTags(instance.atlanTags == null ? java.util.Collections.<AtlanTag>emptySortedSet() : instance.atlanTags);
            b.customMetadataSets(instance.customMetadataSets == null ? java.util.Collections.<String, CustomMetadataAttributes>emptyMap() : instance.customMetadataSets);
            b.status(instance.status);
            b.createdBy(instance.createdBy);
            b.updatedBy(instance.updatedBy);
            b.createTime(instance.createTime);
            b.updateTime(instance.updateTime);
            b.deleteHandler(instance.deleteHandler);
            b.depth(instance.depth);
            b.immediateUpstream(instance.immediateUpstream);
            b.immediateDownstream(instance.immediateDownstream);
            b.atlanTagNames(instance.atlanTagNames == null ? java.util.Collections.<String>emptySortedSet() : instance.atlanTagNames);
            b.isIncomplete(instance.isIncomplete);
            b.meaningNames(instance.meaningNames == null ? java.util.Collections.<String>emptySortedSet() : instance.meaningNames);
            b.meanings(instance.meanings == null ? java.util.Collections.<Meaning>emptySortedSet() : instance.meanings);
            b.pendingTasks(instance.pendingTasks == null ? java.util.Collections.<String>emptySortedSet() : instance.pendingTasks);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adminGroup(final String adminGroup) {
            if (this.adminGroups == null) this.adminGroups = new java.util.ArrayList<String>();
            this.adminGroups.add(adminGroup);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adminGroups(final java.util.Collection<? extends String> adminGroups) {
            if (adminGroups == null) {
                throw new java.lang.NullPointerException("adminGroups cannot be null");
            }
            if (this.adminGroups == null) this.adminGroups = new java.util.ArrayList<String>();
            this.adminGroups.addAll(adminGroups);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAdminGroups() {
            if (this.adminGroups != null) this.adminGroups.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adminRole(final String adminRole) {
            if (this.adminRoles == null) this.adminRoles = new java.util.ArrayList<String>();
            this.adminRoles.add(adminRole);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adminRoles(final java.util.Collection<? extends String> adminRoles) {
            if (adminRoles == null) {
                throw new java.lang.NullPointerException("adminRoles cannot be null");
            }
            if (this.adminRoles == null) this.adminRoles = new java.util.ArrayList<String>();
            this.adminRoles.addAll(adminRoles);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAdminRoles() {
            if (this.adminRoles != null) this.adminRoles.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adminUser(final String adminUser) {
            if (this.adminUsers == null) this.adminUsers = new java.util.ArrayList<String>();
            this.adminUsers.add(adminUser);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B adminUsers(final java.util.Collection<? extends String> adminUsers) {
            if (adminUsers == null) {
                throw new java.lang.NullPointerException("adminUsers cannot be null");
            }
            if (this.adminUsers == null) this.adminUsers = new java.util.ArrayList<String>();
            this.adminUsers.addAll(adminUsers);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAdminUsers() {
            if (this.adminUsers != null) this.adminUsers.clear();
            return self();
        }

        /**
         * Detailed message to include in the announcement on this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B announcementMessage(final String announcementMessage) {
            this.announcementMessage = announcementMessage;
            return self();
        }

        /**
         * Brief title for the announcement on this asset. Required when announcementType is specified.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B announcementTitle(final String announcementTitle) {
            this.announcementTitle = announcementTitle;
            return self();
        }

        /**
         * Type of announcement on this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B announcementType(final AtlanAnnouncementType announcementType) {
            this.announcementType = announcementType;
            return self();
        }

        /**
         * Time (epoch) at which the announcement was last updated, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B announcementUpdatedAt(final Long announcementUpdatedAt) {
            this.announcementUpdatedAt = announcementUpdatedAt;
            return self();
        }

        /**
         * Name of the user who last updated the announcement.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B announcementUpdatedBy(final String announcementUpdatedBy) {
            this.announcementUpdatedBy = announcementUpdatedBy;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloCheck(final IAnomaloCheck anomaloCheck) {
            if (this.anomaloChecks == null) this.anomaloChecks = new java.util.ArrayList<IAnomaloCheck>();
            this.anomaloChecks.add(anomaloCheck);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anomaloChecks(final java.util.Collection<? extends IAnomaloCheck> anomaloChecks) {
            if (anomaloChecks == null) {
                throw new java.lang.NullPointerException("anomaloChecks cannot be null");
            }
            if (this.anomaloChecks == null) this.anomaloChecks = new java.util.ArrayList<IAnomaloCheck>();
            this.anomaloChecks.addAll(anomaloChecks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAnomaloChecks() {
            if (this.anomaloChecks != null) this.anomaloChecks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetAnomaloAppliedCheckType(final String assetAnomaloAppliedCheckType) {
            if (this.assetAnomaloAppliedCheckTypes == null) this.assetAnomaloAppliedCheckTypes = new java.util.ArrayList<String>();
            this.assetAnomaloAppliedCheckTypes.add(assetAnomaloAppliedCheckType);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetAnomaloAppliedCheckTypes(final java.util.Collection<? extends String> assetAnomaloAppliedCheckTypes) {
            if (assetAnomaloAppliedCheckTypes == null) {
                throw new java.lang.NullPointerException("assetAnomaloAppliedCheckTypes cannot be null");
            }
            if (this.assetAnomaloAppliedCheckTypes == null) this.assetAnomaloAppliedCheckTypes = new java.util.ArrayList<String>();
            this.assetAnomaloAppliedCheckTypes.addAll(assetAnomaloAppliedCheckTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetAnomaloAppliedCheckTypes() {
            if (this.assetAnomaloAppliedCheckTypes != null) this.assetAnomaloAppliedCheckTypes.clear();
            return self();
        }

        /**
         * Total number of checks present in Anomalo for this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetAnomaloCheckCount(final Long assetAnomaloCheckCount) {
            this.assetAnomaloCheckCount = assetAnomaloCheckCount;
            return self();
        }

        /**
         * Stringified JSON object containing status of all Anomalo checks associated to this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetAnomaloCheckStatuses(final String assetAnomaloCheckStatuses) {
            this.assetAnomaloCheckStatuses = assetAnomaloCheckStatuses;
            return self();
        }

        /**
         * Status of data quality from Anomalo.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetAnomaloDQStatus(final String assetAnomaloDQStatus) {
            this.assetAnomaloDQStatus = assetAnomaloDQStatus;
            return self();
        }

        /**
         * Total number of checks failed in Anomalo for this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetAnomaloFailedCheckCount(final Long assetAnomaloFailedCheckCount) {
            this.assetAnomaloFailedCheckCount = assetAnomaloFailedCheckCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetAnomaloFailedCheckType(final String assetAnomaloFailedCheckType) {
            if (this.assetAnomaloFailedCheckTypes == null) this.assetAnomaloFailedCheckTypes = new java.util.ArrayList<String>();
            this.assetAnomaloFailedCheckTypes.add(assetAnomaloFailedCheckType);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetAnomaloFailedCheckTypes(final java.util.Collection<? extends String> assetAnomaloFailedCheckTypes) {
            if (assetAnomaloFailedCheckTypes == null) {
                throw new java.lang.NullPointerException("assetAnomaloFailedCheckTypes cannot be null");
            }
            if (this.assetAnomaloFailedCheckTypes == null) this.assetAnomaloFailedCheckTypes = new java.util.ArrayList<String>();
            this.assetAnomaloFailedCheckTypes.addAll(assetAnomaloFailedCheckTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetAnomaloFailedCheckTypes() {
            if (this.assetAnomaloFailedCheckTypes != null) this.assetAnomaloFailedCheckTypes.clear();
            return self();
        }

        /**
         * Time (epoch) at which the last check was run via Anomalo.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetAnomaloLastCheckRunAt(final Long assetAnomaloLastCheckRunAt) {
            this.assetAnomaloLastCheckRunAt = assetAnomaloLastCheckRunAt;
            return self();
        }

        /**
         * URL of the source in Anomalo.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetAnomaloSourceUrl(final String assetAnomaloSourceUrl) {
            this.assetAnomaloSourceUrl = assetAnomaloSourceUrl;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetCoverImage(final String assetCoverImage) {
            this.assetCoverImage = assetCoverImage;
            return self();
        }

        /**
         * Name of the account in which this asset exists in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtAccountName(final String assetDbtAccountName) {
            this.assetDbtAccountName = assetDbtAccountName;
            return self();
        }

        /**
         * Alias of this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtAlias(final String assetDbtAlias) {
            this.assetDbtAlias = assetDbtAlias;
            return self();
        }

        /**
         * Version of the environment in which this asset is materialized in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtEnvironmentDbtVersion(final String assetDbtEnvironmentDbtVersion) {
            this.assetDbtEnvironmentDbtVersion = assetDbtEnvironmentDbtVersion;
            return self();
        }

        /**
         * Name of the environment in which this asset is materialized in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtEnvironmentName(final String assetDbtEnvironmentName) {
            this.assetDbtEnvironmentName = assetDbtEnvironmentName;
            return self();
        }

        /**
         * Time (epoch) at which the job that materialized this asset in dbt last ran, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRun(final Long assetDbtJobLastRun) {
            this.assetDbtJobLastRun = assetDbtJobLastRun;
            return self();
        }

        /**
         * Path in S3 to the artifacts saved from the last run of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunArtifactS3Path(final String assetDbtJobLastRunArtifactS3Path) {
            this.assetDbtJobLastRunArtifactS3Path = assetDbtJobLastRunArtifactS3Path;
            return self();
        }

        /**
         * Whether artifacts were saved from the last run of the job that materialized this asset in dbt (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunArtifactsSaved(final Boolean assetDbtJobLastRunArtifactsSaved) {
            this.assetDbtJobLastRunArtifactsSaved = assetDbtJobLastRunArtifactsSaved;
            return self();
        }

        /**
         * Time (epoch) at which the job that materialized this asset in dbt was last created, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunCreatedAt(final Long assetDbtJobLastRunCreatedAt) {
            this.assetDbtJobLastRunCreatedAt = assetDbtJobLastRunCreatedAt;
            return self();
        }

        /**
         * Time (epoch) at which the job that materialized this asset in dbt was dequeued, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunDequedAt(final Long assetDbtJobLastRunDequedAt) {
            this.assetDbtJobLastRunDequedAt = assetDbtJobLastRunDequedAt;
            return self();
        }

        /**
         * Thread ID of the user who executed the last run of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunExecutedByThreadId(final String assetDbtJobLastRunExecutedByThreadId) {
            this.assetDbtJobLastRunExecutedByThreadId = assetDbtJobLastRunExecutedByThreadId;
            return self();
        }

        /**
         * Branch in git from which the last run of the job that materialized this asset in dbt ran.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunGitBranch(final String assetDbtJobLastRunGitBranch) {
            this.assetDbtJobLastRunGitBranch = assetDbtJobLastRunGitBranch;
            return self();
        }

        /**
         * SHA hash in git for the last run of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunGitSha(final String assetDbtJobLastRunGitSha) {
            this.assetDbtJobLastRunGitSha = assetDbtJobLastRunGitSha;
            return self();
        }

        /**
         * Whether docs were generated from the last run of the job that materialized this asset in dbt (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunHasDocsGenerated(final Boolean assetDbtJobLastRunHasDocsGenerated) {
            this.assetDbtJobLastRunHasDocsGenerated = assetDbtJobLastRunHasDocsGenerated;
            return self();
        }

        /**
         * Whether sources were generated from the last run of the job that materialized this asset in dbt (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunHasSourcesGenerated(final Boolean assetDbtJobLastRunHasSourcesGenerated) {
            this.assetDbtJobLastRunHasSourcesGenerated = assetDbtJobLastRunHasSourcesGenerated;
            return self();
        }

        /**
         * Whether notifications were sent from the last run of the job that materialized this asset in dbt (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunNotificationsSent(final Boolean assetDbtJobLastRunNotificationsSent) {
            this.assetDbtJobLastRunNotificationsSent = assetDbtJobLastRunNotificationsSent;
            return self();
        }

        /**
         * Thread ID of the owner of the last run of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunOwnerThreadId(final String assetDbtJobLastRunOwnerThreadId) {
            this.assetDbtJobLastRunOwnerThreadId = assetDbtJobLastRunOwnerThreadId;
            return self();
        }

        /**
         * Total duration the job that materialized this asset in dbt spent being queued.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunQueuedDuration(final String assetDbtJobLastRunQueuedDuration) {
            this.assetDbtJobLastRunQueuedDuration = assetDbtJobLastRunQueuedDuration;
            return self();
        }

        /**
         * Human-readable total duration of the last run of the job that materialized this asset in dbt spend being queued.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunQueuedDurationHumanized(final String assetDbtJobLastRunQueuedDurationHumanized) {
            this.assetDbtJobLastRunQueuedDurationHumanized = assetDbtJobLastRunQueuedDurationHumanized;
            return self();
        }

        /**
         * Run duration of the last run of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunRunDuration(final String assetDbtJobLastRunRunDuration) {
            this.assetDbtJobLastRunRunDuration = assetDbtJobLastRunRunDuration;
            return self();
        }

        /**
         * Human-readable run duration of the last run of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunRunDurationHumanized(final String assetDbtJobLastRunRunDurationHumanized) {
            this.assetDbtJobLastRunRunDurationHumanized = assetDbtJobLastRunRunDurationHumanized;
            return self();
        }

        /**
         * Time (epoch) at which the job that materialized this asset in dbt was started running, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunStartedAt(final Long assetDbtJobLastRunStartedAt) {
            this.assetDbtJobLastRunStartedAt = assetDbtJobLastRunStartedAt;
            return self();
        }

        /**
         * Status message of the last run of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunStatusMessage(final String assetDbtJobLastRunStatusMessage) {
            this.assetDbtJobLastRunStatusMessage = assetDbtJobLastRunStatusMessage;
            return self();
        }

        /**
         * Total duration of the last run of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunTotalDuration(final String assetDbtJobLastRunTotalDuration) {
            this.assetDbtJobLastRunTotalDuration = assetDbtJobLastRunTotalDuration;
            return self();
        }

        /**
         * Human-readable total duration of the last run of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunTotalDurationHumanized(final String assetDbtJobLastRunTotalDurationHumanized) {
            this.assetDbtJobLastRunTotalDurationHumanized = assetDbtJobLastRunTotalDurationHumanized;
            return self();
        }

        /**
         * Time (epoch) at which the job that materialized this asset in dbt was last updated, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunUpdatedAt(final Long assetDbtJobLastRunUpdatedAt) {
            this.assetDbtJobLastRunUpdatedAt = assetDbtJobLastRunUpdatedAt;
            return self();
        }

        /**
         * URL of the last run of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobLastRunUrl(final String assetDbtJobLastRunUrl) {
            this.assetDbtJobLastRunUrl = assetDbtJobLastRunUrl;
            return self();
        }

        /**
         * Name of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobName(final String assetDbtJobName) {
            this.assetDbtJobName = assetDbtJobName;
            return self();
        }

        /**
         * Time (epoch) when the next run of the job that materializes this asset in dbt is scheduled.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobNextRun(final Long assetDbtJobNextRun) {
            this.assetDbtJobNextRun = assetDbtJobNextRun;
            return self();
        }

        /**
         * Human-readable time when the next run of the job that materializes this asset in dbt is scheduled.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobNextRunHumanized(final String assetDbtJobNextRunHumanized) {
            this.assetDbtJobNextRunHumanized = assetDbtJobNextRunHumanized;
            return self();
        }

        /**
         * Schedule of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobSchedule(final String assetDbtJobSchedule) {
            this.assetDbtJobSchedule = assetDbtJobSchedule;
            return self();
        }

        /**
         * Human-readable cron schedule of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobScheduleCronHumanized(final String assetDbtJobScheduleCronHumanized) {
            this.assetDbtJobScheduleCronHumanized = assetDbtJobScheduleCronHumanized;
            return self();
        }

        /**
         * Status of the job that materialized this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtJobStatus(final String assetDbtJobStatus) {
            this.assetDbtJobStatus = assetDbtJobStatus;
            return self();
        }

        /**
         * Metadata for this asset in dbt, specifically everything under the 'meta' key in the dbt object.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtMeta(final String assetDbtMeta) {
            this.assetDbtMeta = assetDbtMeta;
            return self();
        }

        /**
         * Name of the package in which this asset exists in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtPackageName(final String assetDbtPackageName) {
            this.assetDbtPackageName = assetDbtPackageName;
            return self();
        }

        /**
         * Name of the project in which this asset exists in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtProjectName(final String assetDbtProjectName) {
            this.assetDbtProjectName = assetDbtProjectName;
            return self();
        }

        /**
         * URL of the semantic layer proxy for this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtSemanticLayerProxyUrl(final String assetDbtSemanticLayerProxyUrl) {
            this.assetDbtSemanticLayerProxyUrl = assetDbtSemanticLayerProxyUrl;
            return self();
        }

        /**
         * Freshness criteria for the source of this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtSourceFreshnessCriteria(final String assetDbtSourceFreshnessCriteria) {
            this.assetDbtSourceFreshnessCriteria = assetDbtSourceFreshnessCriteria;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtTag(final String assetDbtTag) {
            if (this.assetDbtTags == null) this.assetDbtTags = new java.util.ArrayList<String>();
            this.assetDbtTags.add(assetDbtTag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtTags(final java.util.Collection<? extends String> assetDbtTags) {
            if (assetDbtTags == null) {
                throw new java.lang.NullPointerException("assetDbtTags cannot be null");
            }
            if (this.assetDbtTags == null) this.assetDbtTags = new java.util.ArrayList<String>();
            this.assetDbtTags.addAll(assetDbtTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetDbtTags() {
            if (this.assetDbtTags != null) this.assetDbtTags.clear();
            return self();
        }

        /**
         * All associated dbt test statuses.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtTestStatus(final String assetDbtTestStatus) {
            this.assetDbtTestStatus = assetDbtTestStatus;
            return self();
        }

        /**
         * Unique identifier of this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtUniqueId(final String assetDbtUniqueId) {
            this.assetDbtUniqueId = assetDbtUniqueId;
            return self();
        }

        /**
         * Name of the DBT workflow in Atlan that last updated the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetDbtWorkflowLastUpdated(final String assetDbtWorkflowLastUpdated) {
            this.assetDbtWorkflowLastUpdated = assetDbtWorkflowLastUpdated;
            return self();
        }

        /**
         * Name of the icon to use for this asset. (Only applies to glossaries, currently.)
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetIcon(final AtlanIcon assetIcon) {
            this.assetIcon = assetIcon;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcAlertQualifiedName(final String assetMcAlertQualifiedName) {
            if (this.assetMcAlertQualifiedNames == null) this.assetMcAlertQualifiedNames = new java.util.ArrayList<String>();
            this.assetMcAlertQualifiedNames.add(assetMcAlertQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcAlertQualifiedNames(final java.util.Collection<? extends String> assetMcAlertQualifiedNames) {
            if (assetMcAlertQualifiedNames == null) {
                throw new java.lang.NullPointerException("assetMcAlertQualifiedNames cannot be null");
            }
            if (this.assetMcAlertQualifiedNames == null) this.assetMcAlertQualifiedNames = new java.util.ArrayList<String>();
            this.assetMcAlertQualifiedNames.addAll(assetMcAlertQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcAlertQualifiedNames() {
            if (this.assetMcAlertQualifiedNames != null) this.assetMcAlertQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentName(final String assetMcIncidentName) {
            if (this.assetMcIncidentNames == null) this.assetMcIncidentNames = new java.util.ArrayList<String>();
            this.assetMcIncidentNames.add(assetMcIncidentName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentNames(final java.util.Collection<? extends String> assetMcIncidentNames) {
            if (assetMcIncidentNames == null) {
                throw new java.lang.NullPointerException("assetMcIncidentNames cannot be null");
            }
            if (this.assetMcIncidentNames == null) this.assetMcIncidentNames = new java.util.ArrayList<String>();
            this.assetMcIncidentNames.addAll(assetMcIncidentNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcIncidentNames() {
            if (this.assetMcIncidentNames != null) this.assetMcIncidentNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentPriority(final String assetMcIncidentPriority) {
            if (this.assetMcIncidentPriorities == null) this.assetMcIncidentPriorities = new java.util.ArrayList<String>();
            this.assetMcIncidentPriorities.add(assetMcIncidentPriority);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentPriorities(final java.util.Collection<? extends String> assetMcIncidentPriorities) {
            if (assetMcIncidentPriorities == null) {
                throw new java.lang.NullPointerException("assetMcIncidentPriorities cannot be null");
            }
            if (this.assetMcIncidentPriorities == null) this.assetMcIncidentPriorities = new java.util.ArrayList<String>();
            this.assetMcIncidentPriorities.addAll(assetMcIncidentPriorities);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcIncidentPriorities() {
            if (this.assetMcIncidentPriorities != null) this.assetMcIncidentPriorities.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentQualifiedName(final String assetMcIncidentQualifiedName) {
            if (this.assetMcIncidentQualifiedNames == null) this.assetMcIncidentQualifiedNames = new java.util.ArrayList<String>();
            this.assetMcIncidentQualifiedNames.add(assetMcIncidentQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentQualifiedNames(final java.util.Collection<? extends String> assetMcIncidentQualifiedNames) {
            if (assetMcIncidentQualifiedNames == null) {
                throw new java.lang.NullPointerException("assetMcIncidentQualifiedNames cannot be null");
            }
            if (this.assetMcIncidentQualifiedNames == null) this.assetMcIncidentQualifiedNames = new java.util.ArrayList<String>();
            this.assetMcIncidentQualifiedNames.addAll(assetMcIncidentQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcIncidentQualifiedNames() {
            if (this.assetMcIncidentQualifiedNames != null) this.assetMcIncidentQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentSeverity(final String assetMcIncidentSeverity) {
            if (this.assetMcIncidentSeverities == null) this.assetMcIncidentSeverities = new java.util.ArrayList<String>();
            this.assetMcIncidentSeverities.add(assetMcIncidentSeverity);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentSeverities(final java.util.Collection<? extends String> assetMcIncidentSeverities) {
            if (assetMcIncidentSeverities == null) {
                throw new java.lang.NullPointerException("assetMcIncidentSeverities cannot be null");
            }
            if (this.assetMcIncidentSeverities == null) this.assetMcIncidentSeverities = new java.util.ArrayList<String>();
            this.assetMcIncidentSeverities.addAll(assetMcIncidentSeverities);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcIncidentSeverities() {
            if (this.assetMcIncidentSeverities != null) this.assetMcIncidentSeverities.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentState(final String assetMcIncidentState) {
            if (this.assetMcIncidentStates == null) this.assetMcIncidentStates = new java.util.ArrayList<String>();
            this.assetMcIncidentStates.add(assetMcIncidentState);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentStates(final java.util.Collection<? extends String> assetMcIncidentStates) {
            if (assetMcIncidentStates == null) {
                throw new java.lang.NullPointerException("assetMcIncidentStates cannot be null");
            }
            if (this.assetMcIncidentStates == null) this.assetMcIncidentStates = new java.util.ArrayList<String>();
            this.assetMcIncidentStates.addAll(assetMcIncidentStates);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcIncidentStates() {
            if (this.assetMcIncidentStates != null) this.assetMcIncidentStates.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentSubType(final String assetMcIncidentSubType) {
            if (this.assetMcIncidentSubTypes == null) this.assetMcIncidentSubTypes = new java.util.ArrayList<String>();
            this.assetMcIncidentSubTypes.add(assetMcIncidentSubType);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentSubTypes(final java.util.Collection<? extends String> assetMcIncidentSubTypes) {
            if (assetMcIncidentSubTypes == null) {
                throw new java.lang.NullPointerException("assetMcIncidentSubTypes cannot be null");
            }
            if (this.assetMcIncidentSubTypes == null) this.assetMcIncidentSubTypes = new java.util.ArrayList<String>();
            this.assetMcIncidentSubTypes.addAll(assetMcIncidentSubTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcIncidentSubTypes() {
            if (this.assetMcIncidentSubTypes != null) this.assetMcIncidentSubTypes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentType(final String assetMcIncidentType) {
            if (this.assetMcIncidentTypes == null) this.assetMcIncidentTypes = new java.util.ArrayList<String>();
            this.assetMcIncidentTypes.add(assetMcIncidentType);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcIncidentTypes(final java.util.Collection<? extends String> assetMcIncidentTypes) {
            if (assetMcIncidentTypes == null) {
                throw new java.lang.NullPointerException("assetMcIncidentTypes cannot be null");
            }
            if (this.assetMcIncidentTypes == null) this.assetMcIncidentTypes = new java.util.ArrayList<String>();
            this.assetMcIncidentTypes.addAll(assetMcIncidentTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcIncidentTypes() {
            if (this.assetMcIncidentTypes != null) this.assetMcIncidentTypes.clear();
            return self();
        }

        /**
         * Time (epoch) at which this asset was last synced from Monte Carlo.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcLastSyncRunAt(final Long assetMcLastSyncRunAt) {
            this.assetMcLastSyncRunAt = assetMcLastSyncRunAt;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcMonitorName(final String assetMcMonitorName) {
            if (this.assetMcMonitorNames == null) this.assetMcMonitorNames = new java.util.ArrayList<String>();
            this.assetMcMonitorNames.add(assetMcMonitorName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcMonitorNames(final java.util.Collection<? extends String> assetMcMonitorNames) {
            if (assetMcMonitorNames == null) {
                throw new java.lang.NullPointerException("assetMcMonitorNames cannot be null");
            }
            if (this.assetMcMonitorNames == null) this.assetMcMonitorNames = new java.util.ArrayList<String>();
            this.assetMcMonitorNames.addAll(assetMcMonitorNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcMonitorNames() {
            if (this.assetMcMonitorNames != null) this.assetMcMonitorNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcMonitorQualifiedName(final String assetMcMonitorQualifiedName) {
            if (this.assetMcMonitorQualifiedNames == null) this.assetMcMonitorQualifiedNames = new java.util.ArrayList<String>();
            this.assetMcMonitorQualifiedNames.add(assetMcMonitorQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcMonitorQualifiedNames(final java.util.Collection<? extends String> assetMcMonitorQualifiedNames) {
            if (assetMcMonitorQualifiedNames == null) {
                throw new java.lang.NullPointerException("assetMcMonitorQualifiedNames cannot be null");
            }
            if (this.assetMcMonitorQualifiedNames == null) this.assetMcMonitorQualifiedNames = new java.util.ArrayList<String>();
            this.assetMcMonitorQualifiedNames.addAll(assetMcMonitorQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcMonitorQualifiedNames() {
            if (this.assetMcMonitorQualifiedNames != null) this.assetMcMonitorQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcMonitorScheduleType(final String assetMcMonitorScheduleType) {
            if (this.assetMcMonitorScheduleTypes == null) this.assetMcMonitorScheduleTypes = new java.util.ArrayList<String>();
            this.assetMcMonitorScheduleTypes.add(assetMcMonitorScheduleType);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcMonitorScheduleTypes(final java.util.Collection<? extends String> assetMcMonitorScheduleTypes) {
            if (assetMcMonitorScheduleTypes == null) {
                throw new java.lang.NullPointerException("assetMcMonitorScheduleTypes cannot be null");
            }
            if (this.assetMcMonitorScheduleTypes == null) this.assetMcMonitorScheduleTypes = new java.util.ArrayList<String>();
            this.assetMcMonitorScheduleTypes.addAll(assetMcMonitorScheduleTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcMonitorScheduleTypes() {
            if (this.assetMcMonitorScheduleTypes != null) this.assetMcMonitorScheduleTypes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcMonitorStatus(final String assetMcMonitorStatus) {
            if (this.assetMcMonitorStatuses == null) this.assetMcMonitorStatuses = new java.util.ArrayList<String>();
            this.assetMcMonitorStatuses.add(assetMcMonitorStatus);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcMonitorStatuses(final java.util.Collection<? extends String> assetMcMonitorStatuses) {
            if (assetMcMonitorStatuses == null) {
                throw new java.lang.NullPointerException("assetMcMonitorStatuses cannot be null");
            }
            if (this.assetMcMonitorStatuses == null) this.assetMcMonitorStatuses = new java.util.ArrayList<String>();
            this.assetMcMonitorStatuses.addAll(assetMcMonitorStatuses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcMonitorStatuses() {
            if (this.assetMcMonitorStatuses != null) this.assetMcMonitorStatuses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcMonitorType(final String assetMcMonitorType) {
            if (this.assetMcMonitorTypes == null) this.assetMcMonitorTypes = new java.util.ArrayList<String>();
            this.assetMcMonitorTypes.add(assetMcMonitorType);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetMcMonitorTypes(final java.util.Collection<? extends String> assetMcMonitorTypes) {
            if (assetMcMonitorTypes == null) {
                throw new java.lang.NullPointerException("assetMcMonitorTypes cannot be null");
            }
            if (this.assetMcMonitorTypes == null) this.assetMcMonitorTypes = new java.util.ArrayList<String>();
            this.assetMcMonitorTypes.addAll(assetMcMonitorTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetMcMonitorTypes() {
            if (this.assetMcMonitorTypes != null) this.assetMcMonitorTypes.clear();
            return self();
        }

        /**
         * Count of policies inside the asset
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetPoliciesCount(final Long assetPoliciesCount) {
            this.assetPoliciesCount = assetPoliciesCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetPolicyGUID(final String assetPolicyGUID) {
            if (this.assetPolicyGUIDs == null) this.assetPolicyGUIDs = new java.util.ArrayList<String>();
            this.assetPolicyGUIDs.add(assetPolicyGUID);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetPolicyGUIDs(final java.util.Collection<? extends String> assetPolicyGUIDs) {
            if (assetPolicyGUIDs == null) {
                throw new java.lang.NullPointerException("assetPolicyGUIDs cannot be null");
            }
            if (this.assetPolicyGUIDs == null) this.assetPolicyGUIDs = new java.util.ArrayList<String>();
            this.assetPolicyGUIDs.addAll(assetPolicyGUIDs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetPolicyGUIDs() {
            if (this.assetPolicyGUIDs != null) this.assetPolicyGUIDs.clear();
            return self();
        }

        /**
         * Number of checks done via Soda.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetSodaCheckCount(final Long assetSodaCheckCount) {
            this.assetSodaCheckCount = assetSodaCheckCount;
            return self();
        }

        /**
         * All associated Soda check statuses.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetSodaCheckStatuses(final String assetSodaCheckStatuses) {
            this.assetSodaCheckStatuses = assetSodaCheckStatuses;
            return self();
        }

        /**
         * Status of data quality from Soda.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetSodaDQStatus(final String assetSodaDQStatus) {
            this.assetSodaDQStatus = assetSodaDQStatus;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetSodaLastScanAt(final Long assetSodaLastScanAt) {
            this.assetSodaLastScanAt = assetSodaLastScanAt;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetSodaLastSyncRunAt(final Long assetSodaLastSyncRunAt) {
            this.assetSodaLastSyncRunAt = assetSodaLastSyncRunAt;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetSodaSourceURL(final String assetSodaSourceURL) {
            this.assetSodaSourceURL = assetSodaSourceURL;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetTag(final String assetTag) {
            if (this.assetTags == null) this.assetTags = new java.util.ArrayList<String>();
            this.assetTags.add(assetTag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetTags(final java.util.Collection<? extends String> assetTags) {
            if (assetTags == null) {
                throw new java.lang.NullPointerException("assetTags cannot be null");
            }
            if (this.assetTags == null) this.assetTags = new java.util.ArrayList<String>();
            this.assetTags.addAll(assetTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssetTags() {
            if (this.assetTags != null) this.assetTags.clear();
            return self();
        }

        /**
         * Color (in hexadecimal RGB) to use to represent this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetThemeHex(final String assetThemeHex) {
            this.assetThemeHex = assetThemeHex;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assignedTerm(final IGlossaryTerm assignedTerm) {
            if (this.assignedTerms == null) this.assignedTerms = new java.util.ArrayList<IGlossaryTerm>();
            this.assignedTerms.add(assignedTerm);
            return self();
        }

        @JsonProperty("meanings")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assignedTerms(final java.util.Collection<? extends IGlossaryTerm> assignedTerms) {
            if (assignedTerms == null) {
                throw new java.lang.NullPointerException("assignedTerms cannot be null");
            }
            if (this.assignedTerms == null) this.assignedTerms = new java.util.ArrayList<IGlossaryTerm>();
            this.assignedTerms.addAll(assignedTerms);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssignedTerms() {
            if (this.assignedTerms != null) this.assignedTerms.clear();
            return self();
        }

        /**
         * Status of this asset's certification.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B certificateStatus(final CertificateStatus certificateStatus) {
            this.certificateStatus = certificateStatus;
            return self();
        }

        /**
         * Human-readable descriptive message used to provide further detail to certificateStatus.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B certificateStatusMessage(final String certificateStatusMessage) {
            this.certificateStatusMessage = certificateStatusMessage;
            return self();
        }

        /**
         * Time (epoch) at which the certification was last updated, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B certificateUpdatedAt(final Long certificateUpdatedAt) {
            this.certificateUpdatedAt = certificateUpdatedAt;
            return self();
        }

        /**
         * Name of the user who last updated the certification of this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B certificateUpdatedBy(final String certificateUpdatedBy) {
            this.certificateUpdatedBy = certificateUpdatedBy;
            return self();
        }

        /**
         * Simple name of the connection through which this asset is accessible.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B connectionName(final String connectionName) {
            this.connectionName = connectionName;
            return self();
        }

        /**
         * Unique name of the connection through which this asset is accessible.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B connectionQualifiedName(final String connectionQualifiedName) {
            this.connectionQualifiedName = connectionQualifiedName;
            return self();
        }

        /**
         * Type of the connector through which this asset is accessible.
         * @return {@code this}.
         */
        @JsonProperty("connectorName")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B connectorType(final AtlanConnectorType connectorType) {
            this.connectorType = connectorType;
            return self();
        }

        /**
         * Latest version of the data contract (in any status) for this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataContractLatest(final IDataContract dataContractLatest) {
            this.dataContractLatest = dataContractLatest;
            return self();
        }

        /**
         * Latest certified version of the data contract for this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataContractLatestCertified(final IDataContract dataContractLatestCertified) {
            this.dataContractLatestCertified = dataContractLatestCertified;
            return self();
        }

        /**
         * Unique name of this asset in dbt.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtQualifiedName(final String dbtQualifiedName) {
            this.dbtQualifiedName = dbtQualifiedName;
            return self();
        }

        /**
         * Description of this asset, for example as crawled from a source. Fallback for display purposes, if userDescription is empty.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B description(final String description) {
            this.description = description;
            return self();
        }

        /**
         * Human-readable name of this asset used for display purposes (in user interface).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B displayName(final String displayName) {
            this.displayName = displayName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B domainGUID(final String domainGUID) {
            if (this.domainGUIDs == null) this.domainGUIDs = new java.util.ArrayList<String>();
            this.domainGUIDs.add(domainGUID);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B domainGUIDs(final java.util.Collection<? extends String> domainGUIDs) {
            if (domainGUIDs == null) {
                throw new java.lang.NullPointerException("domainGUIDs cannot be null");
            }
            if (this.domainGUIDs == null) this.domainGUIDs = new java.util.ArrayList<String>();
            this.domainGUIDs.addAll(domainGUIDs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDomainGUIDs() {
            if (this.domainGUIDs != null) this.domainGUIDs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B file(final IFile file) {
            if (this.files == null) this.files = new java.util.ArrayList<IFile>();
            this.files.add(file);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B files(final java.util.Collection<? extends IFile> files) {
            if (files == null) {
                throw new java.lang.NullPointerException("files cannot be null");
            }
            if (this.files == null) this.files = new java.util.ArrayList<IFile>();
            this.files.addAll(files);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearFiles() {
            if (this.files != null) this.files.clear();
            return self();
        }

        /**
         * Whether this asset has contract (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B hasContract(final Boolean hasContract) {
            this.hasContract = hasContract;
            return self();
        }

        /**
         * Whether this asset has lineage (true) or not (false).
         * @return {@code this}.
         */
        @JsonProperty("__hasLineage")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B hasLineage(final Boolean hasLineage) {
            this.hasLineage = hasLineage;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputPortDataProduct(final IDataProduct inputPortDataProduct) {
            if (this.inputPortDataProducts == null) this.inputPortDataProducts = new java.util.ArrayList<IDataProduct>();
            this.inputPortDataProducts.add(inputPortDataProduct);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputPortDataProducts(final java.util.Collection<? extends IDataProduct> inputPortDataProducts) {
            if (inputPortDataProducts == null) {
                throw new java.lang.NullPointerException("inputPortDataProducts cannot be null");
            }
            if (this.inputPortDataProducts == null) this.inputPortDataProducts = new java.util.ArrayList<IDataProduct>();
            this.inputPortDataProducts.addAll(inputPortDataProducts);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputPortDataProducts() {
            if (this.inputPortDataProducts != null) this.inputPortDataProducts.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isAIGenerated(final Boolean isAIGenerated) {
            this.isAIGenerated = isAIGenerated;
            return self();
        }

        /**
         * Whether this asset is discoverable through the UI (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isDiscoverable(final Boolean isDiscoverable) {
            this.isDiscoverable = isDiscoverable;
            return self();
        }

        /**
         * Whether this asset can be edited in the UI (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isEditable(final Boolean isEditable) {
            this.isEditable = isEditable;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isPartial(final Boolean isPartial) {
            this.isPartial = isPartial;
            return self();
        }

        /**
         * Time (epoch) of the last operation that inserted, updated, or deleted rows, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lastRowChangedAt(final Long lastRowChangedAt) {
            this.lastRowChangedAt = lastRowChangedAt;
            return self();
        }

        /**
         * Name of the last run of the crawler that last synchronized this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lastSyncRun(final String lastSyncRun) {
            this.lastSyncRun = lastSyncRun;
            return self();
        }

        /**
         * Time (epoch) at which this asset was last crawled, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lastSyncRunAt(final Long lastSyncRunAt) {
            this.lastSyncRunAt = lastSyncRunAt;
            return self();
        }

        /**
         * Name of the crawler that last synchronized this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lastSyncWorkflowName(final String lastSyncWorkflowName) {
            this.lastSyncWorkflowName = lastSyncWorkflowName;
            return self();
        }

        /**
         * Custom order for sorting purpose, managed by client
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lexicographicalSortOrder(final String lexicographicalSortOrder) {
            this.lexicographicalSortOrder = lexicographicalSortOrder;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B link(final ILink link) {
            if (this.links == null) this.links = new java.util.ArrayList<ILink>();
            this.links.add(link);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B links(final java.util.Collection<? extends ILink> links) {
            if (links == null) {
                throw new java.lang.NullPointerException("links cannot be null");
            }
            if (this.links == null) this.links = new java.util.ArrayList<ILink>();
            this.links.addAll(links);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearLinks() {
            if (this.links != null) this.links.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcIncident(final IMCIncident mcIncident) {
            if (this.mcIncidents == null) this.mcIncidents = new java.util.ArrayList<IMCIncident>();
            this.mcIncidents.add(mcIncident);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcIncidents(final java.util.Collection<? extends IMCIncident> mcIncidents) {
            if (mcIncidents == null) {
                throw new java.lang.NullPointerException("mcIncidents cannot be null");
            }
            if (this.mcIncidents == null) this.mcIncidents = new java.util.ArrayList<IMCIncident>();
            this.mcIncidents.addAll(mcIncidents);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMcIncidents() {
            if (this.mcIncidents != null) this.mcIncidents.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitor(final IMCMonitor mcMonitor) {
            if (this.mcMonitors == null) this.mcMonitors = new java.util.ArrayList<IMCMonitor>();
            this.mcMonitors.add(mcMonitor);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitors(final java.util.Collection<? extends IMCMonitor> mcMonitors) {
            if (mcMonitors == null) {
                throw new java.lang.NullPointerException("mcMonitors cannot be null");
            }
            if (this.mcMonitors == null) this.mcMonitors = new java.util.ArrayList<IMCMonitor>();
            this.mcMonitors.addAll(mcMonitors);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMcMonitors() {
            if (this.mcMonitors != null) this.mcMonitors.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metric(final IMetric metric) {
            if (this.metrics == null) this.metrics = new java.util.ArrayList<IMetric>();
            this.metrics.add(metric);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metrics(final java.util.Collection<? extends IMetric> metrics) {
            if (metrics == null) {
                throw new java.lang.NullPointerException("metrics cannot be null");
            }
            if (this.metrics == null) this.metrics = new java.util.ArrayList<IMetric>();
            this.metrics.addAll(metrics);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMetrics() {
            if (this.metrics != null) this.metrics.clear();
            return self();
        }

        /**
         * Name of this asset. Fallback for display purposes, if displayName is empty.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B name(final String name) {
            this.name = name;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B nonCompliantAssetPolicyGUID(final String nonCompliantAssetPolicyGUID) {
            if (this.nonCompliantAssetPolicyGUIDs == null) this.nonCompliantAssetPolicyGUIDs = new java.util.ArrayList<String>();
            this.nonCompliantAssetPolicyGUIDs.add(nonCompliantAssetPolicyGUID);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B nonCompliantAssetPolicyGUIDs(final java.util.Collection<? extends String> nonCompliantAssetPolicyGUIDs) {
            if (nonCompliantAssetPolicyGUIDs == null) {
                throw new java.lang.NullPointerException("nonCompliantAssetPolicyGUIDs cannot be null");
            }
            if (this.nonCompliantAssetPolicyGUIDs == null) this.nonCompliantAssetPolicyGUIDs = new java.util.ArrayList<String>();
            this.nonCompliantAssetPolicyGUIDs.addAll(nonCompliantAssetPolicyGUIDs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearNonCompliantAssetPolicyGUIDs() {
            if (this.nonCompliantAssetPolicyGUIDs != null) this.nonCompliantAssetPolicyGUIDs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputPortDataProduct(final IDataProduct outputPortDataProduct) {
            if (this.outputPortDataProducts == null) this.outputPortDataProducts = new java.util.ArrayList<IDataProduct>();
            this.outputPortDataProducts.add(outputPortDataProduct);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputPortDataProducts(final java.util.Collection<? extends IDataProduct> outputPortDataProducts) {
            if (outputPortDataProducts == null) {
                throw new java.lang.NullPointerException("outputPortDataProducts cannot be null");
            }
            if (this.outputPortDataProducts == null) this.outputPortDataProducts = new java.util.ArrayList<IDataProduct>();
            this.outputPortDataProducts.addAll(outputPortDataProducts);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputPortDataProducts() {
            if (this.outputPortDataProducts != null) this.outputPortDataProducts.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B ownerGroup(final String ownerGroup) {
            if (this.ownerGroups == null) this.ownerGroups = new java.util.ArrayList<String>();
            this.ownerGroups.add(ownerGroup);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B ownerGroups(final java.util.Collection<? extends String> ownerGroups) {
            if (ownerGroups == null) {
                throw new java.lang.NullPointerException("ownerGroups cannot be null");
            }
            if (this.ownerGroups == null) this.ownerGroups = new java.util.ArrayList<String>();
            this.ownerGroups.addAll(ownerGroups);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOwnerGroups() {
            if (this.ownerGroups != null) this.ownerGroups.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B ownerUser(final String ownerUser) {
            if (this.ownerUsers == null) this.ownerUsers = new java.util.ArrayList<String>();
            this.ownerUsers.add(ownerUser);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B ownerUsers(final java.util.Collection<? extends String> ownerUsers) {
            if (ownerUsers == null) {
                throw new java.lang.NullPointerException("ownerUsers cannot be null");
            }
            if (this.ownerUsers == null) this.ownerUsers = new java.util.ArrayList<String>();
            this.ownerUsers.addAll(ownerUsers);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOwnerUsers() {
            if (this.ownerUsers != null) this.ownerUsers.clear();
            return self();
        }

        /**
         * Popularity score for this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B popularityScore(final Double popularityScore) {
            this.popularityScore = popularityScore;
            return self();
        }

        /**
         * Unique name for this asset. This is typically a concatenation of the asset's name onto its parent's qualifiedName. This must be unique across all assets of the same type.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qualifiedName(final String qualifiedName) {
            this.qualifiedName = qualifiedName;
            return self();
        }

        /**
         * README that is linked to this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B readme(final IReadme readme) {
            this.readme = readme;
            return self();
        }

        /**
         * URL for sample data for this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sampleDataUrl(final String sampleDataUrl) {
            this.sampleDataUrl = sampleDataUrl;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaRegistrySubject(final ISchemaRegistrySubject schemaRegistrySubject) {
            if (this.schemaRegistrySubjects == null) this.schemaRegistrySubjects = new java.util.ArrayList<ISchemaRegistrySubject>();
            this.schemaRegistrySubjects.add(schemaRegistrySubject);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaRegistrySubjects(final java.util.Collection<? extends ISchemaRegistrySubject> schemaRegistrySubjects) {
            if (schemaRegistrySubjects == null) {
                throw new java.lang.NullPointerException("schemaRegistrySubjects cannot be null");
            }
            if (this.schemaRegistrySubjects == null) this.schemaRegistrySubjects = new java.util.ArrayList<ISchemaRegistrySubject>();
            this.schemaRegistrySubjects.addAll(schemaRegistrySubjects);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSchemaRegistrySubjects() {
            if (this.schemaRegistrySubjects != null) this.schemaRegistrySubjects.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sodaCheck(final ISodaCheck sodaCheck) {
            if (this.sodaChecks == null) this.sodaChecks = new java.util.ArrayList<ISodaCheck>();
            this.sodaChecks.add(sodaCheck);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sodaChecks(final java.util.Collection<? extends ISodaCheck> sodaChecks) {
            if (sodaChecks == null) {
                throw new java.lang.NullPointerException("sodaChecks cannot be null");
            }
            if (this.sodaChecks == null) this.sodaChecks = new java.util.ArrayList<ISodaCheck>();
            this.sodaChecks.addAll(sodaChecks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSodaChecks() {
            if (this.sodaChecks != null) this.sodaChecks.clear();
            return self();
        }

        /**
         * The unit of measure for sourceTotalCost.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceCostUnit(final SourceCostUnitType sourceCostUnit) {
            this.sourceCostUnit = sourceCostUnit;
            return self();
        }

        /**
         * Time (epoch) at which this asset was created in the source system, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceCreatedAt(final Long sourceCreatedAt) {
            this.sourceCreatedAt = sourceCreatedAt;
            return self();
        }

        /**
         * Name of the user who created this asset, in the source system.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceCreatedBy(final String sourceCreatedBy) {
            this.sourceCreatedBy = sourceCreatedBy;
            return self();
        }

        /**
         * URL to create an embed for a resource (for example, an image of a dashboard) within Atlan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceEmbedURL(final String sourceEmbedURL) {
            this.sourceEmbedURL = sourceEmbedURL;
            return self();
        }

        /**
         * Timestamp of most recent read operation.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceLastReadAt(final Long sourceLastReadAt) {
            this.sourceLastReadAt = sourceLastReadAt;
            return self();
        }

        /**
         * List of owners of this asset, in the source system.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceOwners(final String sourceOwners) {
            this.sourceOwners = sourceOwners;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceQueryComputeCostRecord(final PopularityInsights sourceQueryComputeCostRecord) {
            if (this.sourceQueryComputeCostRecords == null) this.sourceQueryComputeCostRecords = new java.util.ArrayList<PopularityInsights>();
            this.sourceQueryComputeCostRecords.add(sourceQueryComputeCostRecord);
            return self();
        }

        @JsonProperty("sourceQueryComputeCostRecordList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceQueryComputeCostRecords(final java.util.Collection<? extends PopularityInsights> sourceQueryComputeCostRecords) {
            if (sourceQueryComputeCostRecords == null) {
                throw new java.lang.NullPointerException("sourceQueryComputeCostRecords cannot be null");
            }
            if (this.sourceQueryComputeCostRecords == null) this.sourceQueryComputeCostRecords = new java.util.ArrayList<PopularityInsights>();
            this.sourceQueryComputeCostRecords.addAll(sourceQueryComputeCostRecords);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSourceQueryComputeCostRecords() {
            if (this.sourceQueryComputeCostRecords != null) this.sourceQueryComputeCostRecords.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceQueryComputeCost(final String sourceQueryComputeCost) {
            if (this.sourceQueryComputeCosts == null) this.sourceQueryComputeCosts = new java.util.ArrayList<String>();
            this.sourceQueryComputeCosts.add(sourceQueryComputeCost);
            return self();
        }

        @JsonProperty("sourceQueryComputeCostList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceQueryComputeCosts(final java.util.Collection<? extends String> sourceQueryComputeCosts) {
            if (sourceQueryComputeCosts == null) {
                throw new java.lang.NullPointerException("sourceQueryComputeCosts cannot be null");
            }
            if (this.sourceQueryComputeCosts == null) this.sourceQueryComputeCosts = new java.util.ArrayList<String>();
            this.sourceQueryComputeCosts.addAll(sourceQueryComputeCosts);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSourceQueryComputeCosts() {
            if (this.sourceQueryComputeCosts != null) this.sourceQueryComputeCosts.clear();
            return self();
        }

        /**
         * Total count of all read operations at source.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadCount(final Long sourceReadCount) {
            this.sourceReadCount = sourceReadCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadExpensiveQueryRecord(final PopularityInsights sourceReadExpensiveQueryRecord) {
            if (this.sourceReadExpensiveQueryRecords == null) this.sourceReadExpensiveQueryRecords = new java.util.ArrayList<PopularityInsights>();
            this.sourceReadExpensiveQueryRecords.add(sourceReadExpensiveQueryRecord);
            return self();
        }

        @JsonProperty("sourceReadExpensiveQueryRecordList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadExpensiveQueryRecords(final java.util.Collection<? extends PopularityInsights> sourceReadExpensiveQueryRecords) {
            if (sourceReadExpensiveQueryRecords == null) {
                throw new java.lang.NullPointerException("sourceReadExpensiveQueryRecords cannot be null");
            }
            if (this.sourceReadExpensiveQueryRecords == null) this.sourceReadExpensiveQueryRecords = new java.util.ArrayList<PopularityInsights>();
            this.sourceReadExpensiveQueryRecords.addAll(sourceReadExpensiveQueryRecords);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSourceReadExpensiveQueryRecords() {
            if (this.sourceReadExpensiveQueryRecords != null) this.sourceReadExpensiveQueryRecords.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadPopularQueryRecord(final PopularityInsights sourceReadPopularQueryRecord) {
            if (this.sourceReadPopularQueryRecords == null) this.sourceReadPopularQueryRecords = new java.util.ArrayList<PopularityInsights>();
            this.sourceReadPopularQueryRecords.add(sourceReadPopularQueryRecord);
            return self();
        }

        @JsonProperty("sourceReadPopularQueryRecordList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadPopularQueryRecords(final java.util.Collection<? extends PopularityInsights> sourceReadPopularQueryRecords) {
            if (sourceReadPopularQueryRecords == null) {
                throw new java.lang.NullPointerException("sourceReadPopularQueryRecords cannot be null");
            }
            if (this.sourceReadPopularQueryRecords == null) this.sourceReadPopularQueryRecords = new java.util.ArrayList<PopularityInsights>();
            this.sourceReadPopularQueryRecords.addAll(sourceReadPopularQueryRecords);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSourceReadPopularQueryRecords() {
            if (this.sourceReadPopularQueryRecords != null) this.sourceReadPopularQueryRecords.clear();
            return self();
        }

        /**
         * Total cost of read queries at source.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadQueryCost(final Double sourceReadQueryCost) {
            this.sourceReadQueryCost = sourceReadQueryCost;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadRecentUserRecord(final PopularityInsights sourceReadRecentUserRecord) {
            if (this.sourceReadRecentUserRecords == null) this.sourceReadRecentUserRecords = new java.util.ArrayList<PopularityInsights>();
            this.sourceReadRecentUserRecords.add(sourceReadRecentUserRecord);
            return self();
        }

        @JsonProperty("sourceReadRecentUserRecordList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadRecentUserRecords(final java.util.Collection<? extends PopularityInsights> sourceReadRecentUserRecords) {
            if (sourceReadRecentUserRecords == null) {
                throw new java.lang.NullPointerException("sourceReadRecentUserRecords cannot be null");
            }
            if (this.sourceReadRecentUserRecords == null) this.sourceReadRecentUserRecords = new java.util.ArrayList<PopularityInsights>();
            this.sourceReadRecentUserRecords.addAll(sourceReadRecentUserRecords);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSourceReadRecentUserRecords() {
            if (this.sourceReadRecentUserRecords != null) this.sourceReadRecentUserRecords.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadRecentUser(final String sourceReadRecentUser) {
            if (this.sourceReadRecentUsers == null) this.sourceReadRecentUsers = new java.util.ArrayList<String>();
            this.sourceReadRecentUsers.add(sourceReadRecentUser);
            return self();
        }

        @JsonProperty("sourceReadRecentUserList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadRecentUsers(final java.util.Collection<? extends String> sourceReadRecentUsers) {
            if (sourceReadRecentUsers == null) {
                throw new java.lang.NullPointerException("sourceReadRecentUsers cannot be null");
            }
            if (this.sourceReadRecentUsers == null) this.sourceReadRecentUsers = new java.util.ArrayList<String>();
            this.sourceReadRecentUsers.addAll(sourceReadRecentUsers);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSourceReadRecentUsers() {
            if (this.sourceReadRecentUsers != null) this.sourceReadRecentUsers.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadSlowQueryRecord(final PopularityInsights sourceReadSlowQueryRecord) {
            if (this.sourceReadSlowQueryRecords == null) this.sourceReadSlowQueryRecords = new java.util.ArrayList<PopularityInsights>();
            this.sourceReadSlowQueryRecords.add(sourceReadSlowQueryRecord);
            return self();
        }

        @JsonProperty("sourceReadSlowQueryRecordList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadSlowQueryRecords(final java.util.Collection<? extends PopularityInsights> sourceReadSlowQueryRecords) {
            if (sourceReadSlowQueryRecords == null) {
                throw new java.lang.NullPointerException("sourceReadSlowQueryRecords cannot be null");
            }
            if (this.sourceReadSlowQueryRecords == null) this.sourceReadSlowQueryRecords = new java.util.ArrayList<PopularityInsights>();
            this.sourceReadSlowQueryRecords.addAll(sourceReadSlowQueryRecords);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSourceReadSlowQueryRecords() {
            if (this.sourceReadSlowQueryRecords != null) this.sourceReadSlowQueryRecords.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadTopUserRecord(final PopularityInsights sourceReadTopUserRecord) {
            if (this.sourceReadTopUserRecords == null) this.sourceReadTopUserRecords = new java.util.ArrayList<PopularityInsights>();
            this.sourceReadTopUserRecords.add(sourceReadTopUserRecord);
            return self();
        }

        @JsonProperty("sourceReadTopUserRecordList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadTopUserRecords(final java.util.Collection<? extends PopularityInsights> sourceReadTopUserRecords) {
            if (sourceReadTopUserRecords == null) {
                throw new java.lang.NullPointerException("sourceReadTopUserRecords cannot be null");
            }
            if (this.sourceReadTopUserRecords == null) this.sourceReadTopUserRecords = new java.util.ArrayList<PopularityInsights>();
            this.sourceReadTopUserRecords.addAll(sourceReadTopUserRecords);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSourceReadTopUserRecords() {
            if (this.sourceReadTopUserRecords != null) this.sourceReadTopUserRecords.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadTopUser(final String sourceReadTopUser) {
            if (this.sourceReadTopUsers == null) this.sourceReadTopUsers = new java.util.ArrayList<String>();
            this.sourceReadTopUsers.add(sourceReadTopUser);
            return self();
        }

        @JsonProperty("sourceReadTopUserList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadTopUsers(final java.util.Collection<? extends String> sourceReadTopUsers) {
            if (sourceReadTopUsers == null) {
                throw new java.lang.NullPointerException("sourceReadTopUsers cannot be null");
            }
            if (this.sourceReadTopUsers == null) this.sourceReadTopUsers = new java.util.ArrayList<String>();
            this.sourceReadTopUsers.addAll(sourceReadTopUsers);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSourceReadTopUsers() {
            if (this.sourceReadTopUsers != null) this.sourceReadTopUsers.clear();
            return self();
        }

        /**
         * Total number of unique users that read data from asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceReadUserCount(final Long sourceReadUserCount) {
            this.sourceReadUserCount = sourceReadUserCount;
            return self();
        }

        /**
         * Total cost of all operations at source.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceTotalCost(final Double sourceTotalCost) {
            this.sourceTotalCost = sourceTotalCost;
            return self();
        }

        /**
         * URL to the resource within the source application, used to create a button to view this asset in the source application.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceURL(final String sourceURL) {
            this.sourceURL = sourceURL;
            return self();
        }

        /**
         * Time (epoch) at which this asset was last updated in the source system, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceUpdatedAt(final Long sourceUpdatedAt) {
            this.sourceUpdatedAt = sourceUpdatedAt;
            return self();
        }

        /**
         * Name of the user who last updated this asset, in the source system.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceUpdatedBy(final String sourceUpdatedBy) {
            this.sourceUpdatedBy = sourceUpdatedBy;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B addStarredBy(final String addStarredBy) {
            if (this.starredBy == null) this.starredBy = new java.util.ArrayList<String>();
            this.starredBy.add(addStarredBy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B starredBy(final java.util.Collection<? extends String> starredBy) {
            if (starredBy == null) {
                throw new java.lang.NullPointerException("starredBy cannot be null");
            }
            if (this.starredBy == null) this.starredBy = new java.util.ArrayList<String>();
            this.starredBy.addAll(starredBy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearStarredBy() {
            if (this.starredBy != null) this.starredBy.clear();
            return self();
        }

        /**
         * Number of users who have starred this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B starredCount(final Integer starredCount) {
            this.starredCount = starredCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B starredDetail(final StarredDetails starredDetail) {
            if (this.starredDetails == null) this.starredDetails = new java.util.ArrayList<StarredDetails>();
            this.starredDetails.add(starredDetail);
            return self();
        }

        @JsonProperty("starredDetailsList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B starredDetails(final java.util.Collection<? extends StarredDetails> starredDetails) {
            if (starredDetails == null) {
                throw new java.lang.NullPointerException("starredDetails cannot be null");
            }
            if (this.starredDetails == null) this.starredDetails = new java.util.ArrayList<StarredDetails>();
            this.starredDetails.addAll(starredDetails);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearStarredDetails() {
            if (this.starredDetails != null) this.starredDetails.clear();
            return self();
        }

        /**
         * Subtype of this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B subType(final String subType) {
            this.subType = subType;
            return self();
        }

        /**
         * Name of the Atlan workspace in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tenantId(final String tenantId) {
            this.tenantId = tenantId;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B userDefRelationshipFrom(final IAsset userDefRelationshipFrom) {
            if (this.userDefRelationshipFroms == null) this.userDefRelationshipFroms = new java.util.ArrayList<IAsset>();
            this.userDefRelationshipFroms.add(userDefRelationshipFrom);
            return self();
        }

        @JsonProperty("userDefRelationshipFrom")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B userDefRelationshipFroms(final java.util.Collection<? extends IAsset> userDefRelationshipFroms) {
            if (userDefRelationshipFroms == null) {
                throw new java.lang.NullPointerException("userDefRelationshipFroms cannot be null");
            }
            if (this.userDefRelationshipFroms == null) this.userDefRelationshipFroms = new java.util.ArrayList<IAsset>();
            this.userDefRelationshipFroms.addAll(userDefRelationshipFroms);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearUserDefRelationshipFroms() {
            if (this.userDefRelationshipFroms != null) this.userDefRelationshipFroms.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B userDefRelationshipTo(final IAsset userDefRelationshipTo) {
            if (this.userDefRelationshipTos == null) this.userDefRelationshipTos = new java.util.ArrayList<IAsset>();
            this.userDefRelationshipTos.add(userDefRelationshipTo);
            return self();
        }

        @JsonProperty("userDefRelationshipTo")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B userDefRelationshipTos(final java.util.Collection<? extends IAsset> userDefRelationshipTos) {
            if (userDefRelationshipTos == null) {
                throw new java.lang.NullPointerException("userDefRelationshipTos cannot be null");
            }
            if (this.userDefRelationshipTos == null) this.userDefRelationshipTos = new java.util.ArrayList<IAsset>();
            this.userDefRelationshipTos.addAll(userDefRelationshipTos);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearUserDefRelationshipTos() {
            if (this.userDefRelationshipTos != null) this.userDefRelationshipTos.clear();
            return self();
        }

        /**
         * Description of this asset, as provided by a user. If present, this will be used for the description in user interface.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B userDescription(final String userDescription) {
            this.userDescription = userDescription;
            return self();
        }

        /**
         * View score for this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewScore(final Double viewScore) {
            this.viewScore = viewScore;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewerGroup(final String viewerGroup) {
            if (this.viewerGroups == null) this.viewerGroups = new java.util.ArrayList<String>();
            this.viewerGroups.add(viewerGroup);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewerGroups(final java.util.Collection<? extends String> viewerGroups) {
            if (viewerGroups == null) {
                throw new java.lang.NullPointerException("viewerGroups cannot be null");
            }
            if (this.viewerGroups == null) this.viewerGroups = new java.util.ArrayList<String>();
            this.viewerGroups.addAll(viewerGroups);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearViewerGroups() {
            if (this.viewerGroups != null) this.viewerGroups.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewerUser(final String viewerUser) {
            if (this.viewerUsers == null) this.viewerUsers = new java.util.ArrayList<String>();
            this.viewerUsers.add(viewerUser);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewerUsers(final java.util.Collection<? extends String> viewerUsers) {
            if (viewerUsers == null) {
                throw new java.lang.NullPointerException("viewerUsers cannot be null");
            }
            if (this.viewerUsers == null) this.viewerUsers = new java.util.ArrayList<String>();
            this.viewerUsers.addAll(viewerUsers);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearViewerUsers() {
            if (this.viewerUsers != null) this.viewerUsers.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B nullField(final String nullField) {
            if (this.nullFields == null) this.nullFields = new java.util.ArrayList<String>();
            this.nullFields.add(nullField);
            return self();
        }

        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B nullFields(final java.util.Collection<? extends String> nullFields) {
            if (nullFields == null) {
                throw new java.lang.NullPointerException("nullFields cannot be null");
            }
            if (this.nullFields == null) this.nullFields = new java.util.ArrayList<String>();
            this.nullFields.addAll(nullFields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearNullFields() {
            if (this.nullFields != null) this.nullFields.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B atlanTag(final AtlanTag atlanTag) {
            if (this.atlanTags == null) this.atlanTags = new java.util.ArrayList<AtlanTag>();
            this.atlanTags.add(atlanTag);
            return self();
        }

        @JsonProperty("classifications")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B atlanTags(final java.util.Collection<? extends AtlanTag> atlanTags) {
            if (atlanTags == null) {
                throw new java.lang.NullPointerException("atlanTags cannot be null");
            }
            if (this.atlanTags == null) this.atlanTags = new java.util.ArrayList<AtlanTag>();
            this.atlanTags.addAll(atlanTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAtlanTags() {
            if (this.atlanTags != null) this.atlanTags.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B customMetadata(final String customMetadataKey, final CustomMetadataAttributes customMetadataValue) {
            if (this.customMetadataSets$key == null) {
                this.customMetadataSets$key = new java.util.ArrayList<String>();
                this.customMetadataSets$value = new java.util.ArrayList<CustomMetadataAttributes>();
            }
            this.customMetadataSets$key.add(customMetadataKey);
            this.customMetadataSets$value.add(customMetadataValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B customMetadataSets(final java.util.Map<? extends String, ? extends CustomMetadataAttributes> customMetadataSets) {
            if (customMetadataSets == null) {
                throw new java.lang.NullPointerException("customMetadataSets cannot be null");
            }
            if (this.customMetadataSets$key == null) {
                this.customMetadataSets$key = new java.util.ArrayList<String>();
                this.customMetadataSets$value = new java.util.ArrayList<CustomMetadataAttributes>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends CustomMetadataAttributes> $lombokEntry : customMetadataSets.entrySet()) {
                this.customMetadataSets$key.add($lombokEntry.getKey());
                this.customMetadataSets$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCustomMetadataSets() {
            if (this.customMetadataSets$key != null) {
                this.customMetadataSets$key.clear();
                this.customMetadataSets$value.clear();
            }
            return self();
        }

        /**
         * Status of the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B status(final AtlanStatus status) {
            this.status = status;
            return self();
        }

        /**
         * User or account that created the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B createdBy(final String createdBy) {
            this.createdBy = createdBy;
            return self();
        }

        /**
         * User or account that last updated the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B updatedBy(final String updatedBy) {
            this.updatedBy = updatedBy;
            return self();
        }

        /**
         * Time (epoch) at which the asset was created, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B createTime(final Long createTime) {
            this.createTime = createTime;
            return self();
        }

        /**
         * Time (epoch) at which the asset was last updated, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B updateTime(final Long updateTime) {
            this.updateTime = updateTime;
            return self();
        }

        /**
         * Details on the handler used for deletion of the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B deleteHandler(final String deleteHandler) {
            this.deleteHandler = deleteHandler;
            return self();
        }

        /**
         * Depth of this asset within lineage.
         * Note: this will only be available in assets retrieved via lineage, and will vary even for
         * the same asset depending on the starting point of the lineage requested.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B depth(final Long depth) {
            this.depth = depth;
            return self();
        }

        /**
         * Reference details about the asset(s) that are immediately upstream of this asset within lineage.
         * Note: this will only be available in assets retrieved via lineage when {@code immediateNeighbors} is true,
         * and could vary even for the same asset depending on the starting point and depth of the lineage requested.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B immediateUpstream(final List<LineageRef> immediateUpstream) {
            this.immediateUpstream = immediateUpstream;
            return self();
        }

        /**
         * Reference details about the asset(s) that are immediately downstream of this asset within lineage.
         * Note: this will only be available in assets retrieved via lineage when {@code immediateNeighbors} is true,
         * and could vary even for the same asset depending on the starting point and depth of the lineage requested.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B immediateDownstream(final List<LineageRef> immediateDownstream) {
            this.immediateDownstream = immediateDownstream;
            return self();
        }

        @java.lang.Deprecated
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B atlanTagName(final String atlanTagName) {
            if (this.atlanTagNames == null) this.atlanTagNames = new java.util.ArrayList<String>();
            this.atlanTagNames.add(atlanTagName);
            return self();
        }

        @java.lang.Deprecated
        @JsonProperty("classificationNames")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B atlanTagNames(final java.util.Collection<? extends String> atlanTagNames) {
            if (atlanTagNames == null) {
                throw new java.lang.NullPointerException("atlanTagNames cannot be null");
            }
            if (this.atlanTagNames == null) this.atlanTagNames = new java.util.ArrayList<String>();
            this.atlanTagNames.addAll(atlanTagNames);
            return self();
        }

        @java.lang.Deprecated
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAtlanTagNames() {
            if (this.atlanTagNames != null) this.atlanTagNames.clear();
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isIncomplete(final Boolean isIncomplete) {
            this.isIncomplete = isIncomplete;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B meaningName(final String meaningName) {
            if (this.meaningNames == null) this.meaningNames = new java.util.ArrayList<String>();
            this.meaningNames.add(meaningName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B meaningNames(final java.util.Collection<? extends String> meaningNames) {
            if (meaningNames == null) {
                throw new java.lang.NullPointerException("meaningNames cannot be null");
            }
            if (this.meaningNames == null) this.meaningNames = new java.util.ArrayList<String>();
            this.meaningNames.addAll(meaningNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMeaningNames() {
            if (this.meaningNames != null) this.meaningNames.clear();
            return self();
        }

        @java.lang.Deprecated
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B meaning(final Meaning meaning) {
            if (this.meanings == null) this.meanings = new java.util.ArrayList<Meaning>();
            this.meanings.add(meaning);
            return self();
        }

        @java.lang.Deprecated
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B meanings(final java.util.Collection<? extends Meaning> meanings) {
            if (meanings == null) {
                throw new java.lang.NullPointerException("meanings cannot be null");
            }
            if (this.meanings == null) this.meanings = new java.util.ArrayList<Meaning>();
            this.meanings.addAll(meanings);
            return self();
        }

        @java.lang.Deprecated
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMeanings() {
            if (this.meanings != null) this.meanings.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B pendingTask(final String pendingTask) {
            if (this.pendingTasks == null) this.pendingTasks = new java.util.ArrayList<String>();
            this.pendingTasks.add(pendingTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B pendingTasks(final java.util.Collection<? extends String> pendingTasks) {
            if (pendingTasks == null) {
                throw new java.lang.NullPointerException("pendingTasks cannot be null");
            }
            if (this.pendingTasks == null) this.pendingTasks = new java.util.ArrayList<String>();
            this.pendingTasks.addAll(pendingTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPendingTasks() {
            if (this.pendingTasks != null) this.pendingTasks.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Asset.AssetBuilder(super=" + super.toString() + ", adminGroups=" + this.adminGroups + ", adminRoles=" + this.adminRoles + ", adminUsers=" + this.adminUsers + ", announcementMessage=" + this.announcementMessage + ", announcementTitle=" + this.announcementTitle + ", announcementType=" + this.announcementType + ", announcementUpdatedAt=" + this.announcementUpdatedAt + ", announcementUpdatedBy=" + this.announcementUpdatedBy + ", anomaloChecks=" + this.anomaloChecks + ", assetAnomaloAppliedCheckTypes=" + this.assetAnomaloAppliedCheckTypes + ", assetAnomaloCheckCount=" + this.assetAnomaloCheckCount + ", assetAnomaloCheckStatuses=" + this.assetAnomaloCheckStatuses + ", assetAnomaloDQStatus=" + this.assetAnomaloDQStatus + ", assetAnomaloFailedCheckCount=" + this.assetAnomaloFailedCheckCount + ", assetAnomaloFailedCheckTypes=" + this.assetAnomaloFailedCheckTypes + ", assetAnomaloLastCheckRunAt=" + this.assetAnomaloLastCheckRunAt + ", assetAnomaloSourceUrl=" + this.assetAnomaloSourceUrl + ", assetCoverImage=" + this.assetCoverImage + ", assetDbtAccountName=" + this.assetDbtAccountName + ", assetDbtAlias=" + this.assetDbtAlias + ", assetDbtEnvironmentDbtVersion=" + this.assetDbtEnvironmentDbtVersion + ", assetDbtEnvironmentName=" + this.assetDbtEnvironmentName + ", assetDbtJobLastRun=" + this.assetDbtJobLastRun + ", assetDbtJobLastRunArtifactS3Path=" + this.assetDbtJobLastRunArtifactS3Path + ", assetDbtJobLastRunArtifactsSaved=" + this.assetDbtJobLastRunArtifactsSaved + ", assetDbtJobLastRunCreatedAt=" + this.assetDbtJobLastRunCreatedAt + ", assetDbtJobLastRunDequedAt=" + this.assetDbtJobLastRunDequedAt + ", assetDbtJobLastRunExecutedByThreadId=" + this.assetDbtJobLastRunExecutedByThreadId + ", assetDbtJobLastRunGitBranch=" + this.assetDbtJobLastRunGitBranch + ", assetDbtJobLastRunGitSha=" + this.assetDbtJobLastRunGitSha + ", assetDbtJobLastRunHasDocsGenerated=" + this.assetDbtJobLastRunHasDocsGenerated + ", assetDbtJobLastRunHasSourcesGenerated=" + this.assetDbtJobLastRunHasSourcesGenerated + ", assetDbtJobLastRunNotificationsSent=" + this.assetDbtJobLastRunNotificationsSent + ", assetDbtJobLastRunOwnerThreadId=" + this.assetDbtJobLastRunOwnerThreadId + ", assetDbtJobLastRunQueuedDuration=" + this.assetDbtJobLastRunQueuedDuration + ", assetDbtJobLastRunQueuedDurationHumanized=" + this.assetDbtJobLastRunQueuedDurationHumanized + ", assetDbtJobLastRunRunDuration=" + this.assetDbtJobLastRunRunDuration + ", assetDbtJobLastRunRunDurationHumanized=" + this.assetDbtJobLastRunRunDurationHumanized + ", assetDbtJobLastRunStartedAt=" + this.assetDbtJobLastRunStartedAt + ", assetDbtJobLastRunStatusMessage=" + this.assetDbtJobLastRunStatusMessage + ", assetDbtJobLastRunTotalDuration=" + this.assetDbtJobLastRunTotalDuration + ", assetDbtJobLastRunTotalDurationHumanized=" + this.assetDbtJobLastRunTotalDurationHumanized + ", assetDbtJobLastRunUpdatedAt=" + this.assetDbtJobLastRunUpdatedAt + ", assetDbtJobLastRunUrl=" + this.assetDbtJobLastRunUrl + ", assetDbtJobName=" + this.assetDbtJobName + ", assetDbtJobNextRun=" + this.assetDbtJobNextRun + ", assetDbtJobNextRunHumanized=" + this.assetDbtJobNextRunHumanized + ", assetDbtJobSchedule=" + this.assetDbtJobSchedule + ", assetDbtJobScheduleCronHumanized=" + this.assetDbtJobScheduleCronHumanized + ", assetDbtJobStatus=" + this.assetDbtJobStatus + ", assetDbtMeta=" + this.assetDbtMeta + ", assetDbtPackageName=" + this.assetDbtPackageName + ", assetDbtProjectName=" + this.assetDbtProjectName + ", assetDbtSemanticLayerProxyUrl=" + this.assetDbtSemanticLayerProxyUrl + ", assetDbtSourceFreshnessCriteria=" + this.assetDbtSourceFreshnessCriteria + ", assetDbtTags=" + this.assetDbtTags + ", assetDbtTestStatus=" + this.assetDbtTestStatus + ", assetDbtUniqueId=" + this.assetDbtUniqueId + ", assetDbtWorkflowLastUpdated=" + this.assetDbtWorkflowLastUpdated + ", assetIcon=" + this.assetIcon + ", assetMcAlertQualifiedNames=" + this.assetMcAlertQualifiedNames + ", assetMcIncidentNames=" + this.assetMcIncidentNames + ", assetMcIncidentPriorities=" + this.assetMcIncidentPriorities + ", assetMcIncidentQualifiedNames=" + this.assetMcIncidentQualifiedNames + ", assetMcIncidentSeverities=" + this.assetMcIncidentSeverities + ", assetMcIncidentStates=" + this.assetMcIncidentStates + ", assetMcIncidentSubTypes=" + this.assetMcIncidentSubTypes + ", assetMcIncidentTypes=" + this.assetMcIncidentTypes + ", assetMcLastSyncRunAt=" + this.assetMcLastSyncRunAt + ", assetMcMonitorNames=" + this.assetMcMonitorNames + ", assetMcMonitorQualifiedNames=" + this.assetMcMonitorQualifiedNames + ", assetMcMonitorScheduleTypes=" + this.assetMcMonitorScheduleTypes + ", assetMcMonitorStatuses=" + this.assetMcMonitorStatuses + ", assetMcMonitorTypes=" + this.assetMcMonitorTypes + ", assetPoliciesCount=" + this.assetPoliciesCount + ", assetPolicyGUIDs=" + this.assetPolicyGUIDs + ", assetSodaCheckCount=" + this.assetSodaCheckCount + ", assetSodaCheckStatuses=" + this.assetSodaCheckStatuses + ", assetSodaDQStatus=" + this.assetSodaDQStatus + ", assetSodaLastScanAt=" + this.assetSodaLastScanAt + ", assetSodaLastSyncRunAt=" + this.assetSodaLastSyncRunAt + ", assetSodaSourceURL=" + this.assetSodaSourceURL + ", assetTags=" + this.assetTags + ", assetThemeHex=" + this.assetThemeHex + ", assignedTerms=" + this.assignedTerms + ", certificateStatus=" + this.certificateStatus + ", certificateStatusMessage=" + this.certificateStatusMessage + ", certificateUpdatedAt=" + this.certificateUpdatedAt + ", certificateUpdatedBy=" + this.certificateUpdatedBy + ", connectionName=" + this.connectionName + ", connectionQualifiedName=" + this.connectionQualifiedName + ", connectorType=" + this.connectorType + ", dataContractLatest=" + this.dataContractLatest + ", dataContractLatestCertified=" + this.dataContractLatestCertified + ", dbtQualifiedName=" + this.dbtQualifiedName + ", description=" + this.description + ", displayName=" + this.displayName + ", domainGUIDs=" + this.domainGUIDs + ", files=" + this.files + ", hasContract=" + this.hasContract + ", hasLineage=" + this.hasLineage + ", inputPortDataProducts=" + this.inputPortDataProducts + ", isAIGenerated=" + this.isAIGenerated + ", isDiscoverable=" + this.isDiscoverable + ", isEditable=" + this.isEditable + ", isPartial=" + this.isPartial + ", lastRowChangedAt=" + this.lastRowChangedAt + ", lastSyncRun=" + this.lastSyncRun + ", lastSyncRunAt=" + this.lastSyncRunAt + ", lastSyncWorkflowName=" + this.lastSyncWorkflowName + ", lexicographicalSortOrder=" + this.lexicographicalSortOrder + ", links=" + this.links + ", mcIncidents=" + this.mcIncidents + ", mcMonitors=" + this.mcMonitors + ", metrics=" + this.metrics + ", name=" + this.name + ", nonCompliantAssetPolicyGUIDs=" + this.nonCompliantAssetPolicyGUIDs + ", outputPortDataProducts=" + this.outputPortDataProducts + ", ownerGroups=" + this.ownerGroups + ", ownerUsers=" + this.ownerUsers + ", popularityScore=" + this.popularityScore + ", qualifiedName=" + this.qualifiedName + ", readme=" + this.readme + ", sampleDataUrl=" + this.sampleDataUrl + ", schemaRegistrySubjects=" + this.schemaRegistrySubjects + ", sodaChecks=" + this.sodaChecks + ", sourceCostUnit=" + this.sourceCostUnit + ", sourceCreatedAt=" + this.sourceCreatedAt + ", sourceCreatedBy=" + this.sourceCreatedBy + ", sourceEmbedURL=" + this.sourceEmbedURL + ", sourceLastReadAt=" + this.sourceLastReadAt + ", sourceOwners=" + this.sourceOwners + ", sourceQueryComputeCostRecords=" + this.sourceQueryComputeCostRecords + ", sourceQueryComputeCosts=" + this.sourceQueryComputeCosts + ", sourceReadCount=" + this.sourceReadCount + ", sourceReadExpensiveQueryRecords=" + this.sourceReadExpensiveQueryRecords + ", sourceReadPopularQueryRecords=" + this.sourceReadPopularQueryRecords + ", sourceReadQueryCost=" + this.sourceReadQueryCost + ", sourceReadRecentUserRecords=" + this.sourceReadRecentUserRecords + ", sourceReadRecentUsers=" + this.sourceReadRecentUsers + ", sourceReadSlowQueryRecords=" + this.sourceReadSlowQueryRecords + ", sourceReadTopUserRecords=" + this.sourceReadTopUserRecords + ", sourceReadTopUsers=" + this.sourceReadTopUsers + ", sourceReadUserCount=" + this.sourceReadUserCount + ", sourceTotalCost=" + this.sourceTotalCost + ", sourceURL=" + this.sourceURL + ", sourceUpdatedAt=" + this.sourceUpdatedAt + ", sourceUpdatedBy=" + this.sourceUpdatedBy + ", starredBy=" + this.starredBy + ", starredCount=" + this.starredCount + ", starredDetails=" + this.starredDetails + ", subType=" + this.subType + ", tenantId=" + this.tenantId + ", userDefRelationshipFroms=" + this.userDefRelationshipFroms + ", userDefRelationshipTos=" + this.userDefRelationshipTos + ", userDescription=" + this.userDescription + ", viewScore=" + this.viewScore + ", viewerGroups=" + this.viewerGroups + ", viewerUsers=" + this.viewerUsers + ", nullFields=" + this.nullFields + ", atlanTags=" + this.atlanTags + ", customMetadataSets$key=" + this.customMetadataSets$key + ", customMetadataSets$value=" + this.customMetadataSets$value + ", status=" + this.status + ", createdBy=" + this.createdBy + ", updatedBy=" + this.updatedBy + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", deleteHandler=" + this.deleteHandler + ", depth=" + this.depth + ", immediateUpstream=" + this.immediateUpstream + ", immediateDownstream=" + this.immediateDownstream + ", atlanTagNames=" + this.atlanTagNames + ", isIncomplete=" + this.isIncomplete + ", meaningNames=" + this.meaningNames + ", meanings=" + this.meanings + ", pendingTasks=" + this.pendingTasks + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Asset(final Asset.AssetBuilder<?, ?> b) {
        super(b);
        java.util.SortedSet<String> adminGroups = new java.util.TreeSet<String>();
        if (b.adminGroups != null) adminGroups.addAll(b.adminGroups);
        adminGroups = java.util.Collections.unmodifiableSortedSet(adminGroups);
        this.adminGroups = adminGroups;
        java.util.SortedSet<String> adminRoles = new java.util.TreeSet<String>();
        if (b.adminRoles != null) adminRoles.addAll(b.adminRoles);
        adminRoles = java.util.Collections.unmodifiableSortedSet(adminRoles);
        this.adminRoles = adminRoles;
        java.util.SortedSet<String> adminUsers = new java.util.TreeSet<String>();
        if (b.adminUsers != null) adminUsers.addAll(b.adminUsers);
        adminUsers = java.util.Collections.unmodifiableSortedSet(adminUsers);
        this.adminUsers = adminUsers;
        this.announcementMessage = b.announcementMessage;
        this.announcementTitle = b.announcementTitle;
        this.announcementType = b.announcementType;
        this.announcementUpdatedAt = b.announcementUpdatedAt;
        this.announcementUpdatedBy = b.announcementUpdatedBy;
        java.util.SortedSet<IAnomaloCheck> anomaloChecks = new java.util.TreeSet<IAnomaloCheck>();
        if (b.anomaloChecks != null) anomaloChecks.addAll(b.anomaloChecks);
        anomaloChecks = java.util.Collections.unmodifiableSortedSet(anomaloChecks);
        this.anomaloChecks = anomaloChecks;
        java.util.SortedSet<String> assetAnomaloAppliedCheckTypes = new java.util.TreeSet<String>();
        if (b.assetAnomaloAppliedCheckTypes != null) assetAnomaloAppliedCheckTypes.addAll(b.assetAnomaloAppliedCheckTypes);
        assetAnomaloAppliedCheckTypes = java.util.Collections.unmodifiableSortedSet(assetAnomaloAppliedCheckTypes);
        this.assetAnomaloAppliedCheckTypes = assetAnomaloAppliedCheckTypes;
        this.assetAnomaloCheckCount = b.assetAnomaloCheckCount;
        this.assetAnomaloCheckStatuses = b.assetAnomaloCheckStatuses;
        this.assetAnomaloDQStatus = b.assetAnomaloDQStatus;
        this.assetAnomaloFailedCheckCount = b.assetAnomaloFailedCheckCount;
        java.util.SortedSet<String> assetAnomaloFailedCheckTypes = new java.util.TreeSet<String>();
        if (b.assetAnomaloFailedCheckTypes != null) assetAnomaloFailedCheckTypes.addAll(b.assetAnomaloFailedCheckTypes);
        assetAnomaloFailedCheckTypes = java.util.Collections.unmodifiableSortedSet(assetAnomaloFailedCheckTypes);
        this.assetAnomaloFailedCheckTypes = assetAnomaloFailedCheckTypes;
        this.assetAnomaloLastCheckRunAt = b.assetAnomaloLastCheckRunAt;
        this.assetAnomaloSourceUrl = b.assetAnomaloSourceUrl;
        this.assetCoverImage = b.assetCoverImage;
        this.assetDbtAccountName = b.assetDbtAccountName;
        this.assetDbtAlias = b.assetDbtAlias;
        this.assetDbtEnvironmentDbtVersion = b.assetDbtEnvironmentDbtVersion;
        this.assetDbtEnvironmentName = b.assetDbtEnvironmentName;
        this.assetDbtJobLastRun = b.assetDbtJobLastRun;
        this.assetDbtJobLastRunArtifactS3Path = b.assetDbtJobLastRunArtifactS3Path;
        this.assetDbtJobLastRunArtifactsSaved = b.assetDbtJobLastRunArtifactsSaved;
        this.assetDbtJobLastRunCreatedAt = b.assetDbtJobLastRunCreatedAt;
        this.assetDbtJobLastRunDequedAt = b.assetDbtJobLastRunDequedAt;
        this.assetDbtJobLastRunExecutedByThreadId = b.assetDbtJobLastRunExecutedByThreadId;
        this.assetDbtJobLastRunGitBranch = b.assetDbtJobLastRunGitBranch;
        this.assetDbtJobLastRunGitSha = b.assetDbtJobLastRunGitSha;
        this.assetDbtJobLastRunHasDocsGenerated = b.assetDbtJobLastRunHasDocsGenerated;
        this.assetDbtJobLastRunHasSourcesGenerated = b.assetDbtJobLastRunHasSourcesGenerated;
        this.assetDbtJobLastRunNotificationsSent = b.assetDbtJobLastRunNotificationsSent;
        this.assetDbtJobLastRunOwnerThreadId = b.assetDbtJobLastRunOwnerThreadId;
        this.assetDbtJobLastRunQueuedDuration = b.assetDbtJobLastRunQueuedDuration;
        this.assetDbtJobLastRunQueuedDurationHumanized = b.assetDbtJobLastRunQueuedDurationHumanized;
        this.assetDbtJobLastRunRunDuration = b.assetDbtJobLastRunRunDuration;
        this.assetDbtJobLastRunRunDurationHumanized = b.assetDbtJobLastRunRunDurationHumanized;
        this.assetDbtJobLastRunStartedAt = b.assetDbtJobLastRunStartedAt;
        this.assetDbtJobLastRunStatusMessage = b.assetDbtJobLastRunStatusMessage;
        this.assetDbtJobLastRunTotalDuration = b.assetDbtJobLastRunTotalDuration;
        this.assetDbtJobLastRunTotalDurationHumanized = b.assetDbtJobLastRunTotalDurationHumanized;
        this.assetDbtJobLastRunUpdatedAt = b.assetDbtJobLastRunUpdatedAt;
        this.assetDbtJobLastRunUrl = b.assetDbtJobLastRunUrl;
        this.assetDbtJobName = b.assetDbtJobName;
        this.assetDbtJobNextRun = b.assetDbtJobNextRun;
        this.assetDbtJobNextRunHumanized = b.assetDbtJobNextRunHumanized;
        this.assetDbtJobSchedule = b.assetDbtJobSchedule;
        this.assetDbtJobScheduleCronHumanized = b.assetDbtJobScheduleCronHumanized;
        this.assetDbtJobStatus = b.assetDbtJobStatus;
        this.assetDbtMeta = b.assetDbtMeta;
        this.assetDbtPackageName = b.assetDbtPackageName;
        this.assetDbtProjectName = b.assetDbtProjectName;
        this.assetDbtSemanticLayerProxyUrl = b.assetDbtSemanticLayerProxyUrl;
        this.assetDbtSourceFreshnessCriteria = b.assetDbtSourceFreshnessCriteria;
        java.util.SortedSet<String> assetDbtTags = new java.util.TreeSet<String>();
        if (b.assetDbtTags != null) assetDbtTags.addAll(b.assetDbtTags);
        assetDbtTags = java.util.Collections.unmodifiableSortedSet(assetDbtTags);
        this.assetDbtTags = assetDbtTags;
        this.assetDbtTestStatus = b.assetDbtTestStatus;
        this.assetDbtUniqueId = b.assetDbtUniqueId;
        this.assetDbtWorkflowLastUpdated = b.assetDbtWorkflowLastUpdated;
        this.assetIcon = b.assetIcon;
        java.util.SortedSet<String> assetMcAlertQualifiedNames = new java.util.TreeSet<String>();
        if (b.assetMcAlertQualifiedNames != null) assetMcAlertQualifiedNames.addAll(b.assetMcAlertQualifiedNames);
        assetMcAlertQualifiedNames = java.util.Collections.unmodifiableSortedSet(assetMcAlertQualifiedNames);
        this.assetMcAlertQualifiedNames = assetMcAlertQualifiedNames;
        java.util.SortedSet<String> assetMcIncidentNames = new java.util.TreeSet<String>();
        if (b.assetMcIncidentNames != null) assetMcIncidentNames.addAll(b.assetMcIncidentNames);
        assetMcIncidentNames = java.util.Collections.unmodifiableSortedSet(assetMcIncidentNames);
        this.assetMcIncidentNames = assetMcIncidentNames;
        java.util.SortedSet<String> assetMcIncidentPriorities = new java.util.TreeSet<String>();
        if (b.assetMcIncidentPriorities != null) assetMcIncidentPriorities.addAll(b.assetMcIncidentPriorities);
        assetMcIncidentPriorities = java.util.Collections.unmodifiableSortedSet(assetMcIncidentPriorities);
        this.assetMcIncidentPriorities = assetMcIncidentPriorities;
        java.util.SortedSet<String> assetMcIncidentQualifiedNames = new java.util.TreeSet<String>();
        if (b.assetMcIncidentQualifiedNames != null) assetMcIncidentQualifiedNames.addAll(b.assetMcIncidentQualifiedNames);
        assetMcIncidentQualifiedNames = java.util.Collections.unmodifiableSortedSet(assetMcIncidentQualifiedNames);
        this.assetMcIncidentQualifiedNames = assetMcIncidentQualifiedNames;
        java.util.SortedSet<String> assetMcIncidentSeverities = new java.util.TreeSet<String>();
        if (b.assetMcIncidentSeverities != null) assetMcIncidentSeverities.addAll(b.assetMcIncidentSeverities);
        assetMcIncidentSeverities = java.util.Collections.unmodifiableSortedSet(assetMcIncidentSeverities);
        this.assetMcIncidentSeverities = assetMcIncidentSeverities;
        java.util.SortedSet<String> assetMcIncidentStates = new java.util.TreeSet<String>();
        if (b.assetMcIncidentStates != null) assetMcIncidentStates.addAll(b.assetMcIncidentStates);
        assetMcIncidentStates = java.util.Collections.unmodifiableSortedSet(assetMcIncidentStates);
        this.assetMcIncidentStates = assetMcIncidentStates;
        java.util.SortedSet<String> assetMcIncidentSubTypes = new java.util.TreeSet<String>();
        if (b.assetMcIncidentSubTypes != null) assetMcIncidentSubTypes.addAll(b.assetMcIncidentSubTypes);
        assetMcIncidentSubTypes = java.util.Collections.unmodifiableSortedSet(assetMcIncidentSubTypes);
        this.assetMcIncidentSubTypes = assetMcIncidentSubTypes;
        java.util.SortedSet<String> assetMcIncidentTypes = new java.util.TreeSet<String>();
        if (b.assetMcIncidentTypes != null) assetMcIncidentTypes.addAll(b.assetMcIncidentTypes);
        assetMcIncidentTypes = java.util.Collections.unmodifiableSortedSet(assetMcIncidentTypes);
        this.assetMcIncidentTypes = assetMcIncidentTypes;
        this.assetMcLastSyncRunAt = b.assetMcLastSyncRunAt;
        java.util.SortedSet<String> assetMcMonitorNames = new java.util.TreeSet<String>();
        if (b.assetMcMonitorNames != null) assetMcMonitorNames.addAll(b.assetMcMonitorNames);
        assetMcMonitorNames = java.util.Collections.unmodifiableSortedSet(assetMcMonitorNames);
        this.assetMcMonitorNames = assetMcMonitorNames;
        java.util.SortedSet<String> assetMcMonitorQualifiedNames = new java.util.TreeSet<String>();
        if (b.assetMcMonitorQualifiedNames != null) assetMcMonitorQualifiedNames.addAll(b.assetMcMonitorQualifiedNames);
        assetMcMonitorQualifiedNames = java.util.Collections.unmodifiableSortedSet(assetMcMonitorQualifiedNames);
        this.assetMcMonitorQualifiedNames = assetMcMonitorQualifiedNames;
        java.util.SortedSet<String> assetMcMonitorScheduleTypes = new java.util.TreeSet<String>();
        if (b.assetMcMonitorScheduleTypes != null) assetMcMonitorScheduleTypes.addAll(b.assetMcMonitorScheduleTypes);
        assetMcMonitorScheduleTypes = java.util.Collections.unmodifiableSortedSet(assetMcMonitorScheduleTypes);
        this.assetMcMonitorScheduleTypes = assetMcMonitorScheduleTypes;
        java.util.SortedSet<String> assetMcMonitorStatuses = new java.util.TreeSet<String>();
        if (b.assetMcMonitorStatuses != null) assetMcMonitorStatuses.addAll(b.assetMcMonitorStatuses);
        assetMcMonitorStatuses = java.util.Collections.unmodifiableSortedSet(assetMcMonitorStatuses);
        this.assetMcMonitorStatuses = assetMcMonitorStatuses;
        java.util.SortedSet<String> assetMcMonitorTypes = new java.util.TreeSet<String>();
        if (b.assetMcMonitorTypes != null) assetMcMonitorTypes.addAll(b.assetMcMonitorTypes);
        assetMcMonitorTypes = java.util.Collections.unmodifiableSortedSet(assetMcMonitorTypes);
        this.assetMcMonitorTypes = assetMcMonitorTypes;
        this.assetPoliciesCount = b.assetPoliciesCount;
        java.util.SortedSet<String> assetPolicyGUIDs = new java.util.TreeSet<String>();
        if (b.assetPolicyGUIDs != null) assetPolicyGUIDs.addAll(b.assetPolicyGUIDs);
        assetPolicyGUIDs = java.util.Collections.unmodifiableSortedSet(assetPolicyGUIDs);
        this.assetPolicyGUIDs = assetPolicyGUIDs;
        this.assetSodaCheckCount = b.assetSodaCheckCount;
        this.assetSodaCheckStatuses = b.assetSodaCheckStatuses;
        this.assetSodaDQStatus = b.assetSodaDQStatus;
        this.assetSodaLastScanAt = b.assetSodaLastScanAt;
        this.assetSodaLastSyncRunAt = b.assetSodaLastSyncRunAt;
        this.assetSodaSourceURL = b.assetSodaSourceURL;
        java.util.SortedSet<String> assetTags = new java.util.TreeSet<String>();
        if (b.assetTags != null) assetTags.addAll(b.assetTags);
        assetTags = java.util.Collections.unmodifiableSortedSet(assetTags);
        this.assetTags = assetTags;
        this.assetThemeHex = b.assetThemeHex;
        java.util.SortedSet<IGlossaryTerm> assignedTerms = new java.util.TreeSet<IGlossaryTerm>();
        if (b.assignedTerms != null) assignedTerms.addAll(b.assignedTerms);
        assignedTerms = java.util.Collections.unmodifiableSortedSet(assignedTerms);
        this.assignedTerms = assignedTerms;
        this.certificateStatus = b.certificateStatus;
        this.certificateStatusMessage = b.certificateStatusMessage;
        this.certificateUpdatedAt = b.certificateUpdatedAt;
        this.certificateUpdatedBy = b.certificateUpdatedBy;
        this.connectionName = b.connectionName;
        this.connectionQualifiedName = b.connectionQualifiedName;
        this.connectorType = b.connectorType;
        this.dataContractLatest = b.dataContractLatest;
        this.dataContractLatestCertified = b.dataContractLatestCertified;
        this.dbtQualifiedName = b.dbtQualifiedName;
        this.description = b.description;
        this.displayName = b.displayName;
        java.util.SortedSet<String> domainGUIDs = new java.util.TreeSet<String>();
        if (b.domainGUIDs != null) domainGUIDs.addAll(b.domainGUIDs);
        domainGUIDs = java.util.Collections.unmodifiableSortedSet(domainGUIDs);
        this.domainGUIDs = domainGUIDs;
        java.util.SortedSet<IFile> files = new java.util.TreeSet<IFile>();
        if (b.files != null) files.addAll(b.files);
        files = java.util.Collections.unmodifiableSortedSet(files);
        this.files = files;
        this.hasContract = b.hasContract;
        this.hasLineage = b.hasLineage;
        java.util.SortedSet<IDataProduct> inputPortDataProducts = new java.util.TreeSet<IDataProduct>();
        if (b.inputPortDataProducts != null) inputPortDataProducts.addAll(b.inputPortDataProducts);
        inputPortDataProducts = java.util.Collections.unmodifiableSortedSet(inputPortDataProducts);
        this.inputPortDataProducts = inputPortDataProducts;
        this.isAIGenerated = b.isAIGenerated;
        this.isDiscoverable = b.isDiscoverable;
        this.isEditable = b.isEditable;
        this.isPartial = b.isPartial;
        this.lastRowChangedAt = b.lastRowChangedAt;
        this.lastSyncRun = b.lastSyncRun;
        this.lastSyncRunAt = b.lastSyncRunAt;
        this.lastSyncWorkflowName = b.lastSyncWorkflowName;
        this.lexicographicalSortOrder = b.lexicographicalSortOrder;
        java.util.SortedSet<ILink> links = new java.util.TreeSet<ILink>();
        if (b.links != null) links.addAll(b.links);
        links = java.util.Collections.unmodifiableSortedSet(links);
        this.links = links;
        java.util.SortedSet<IMCIncident> mcIncidents = new java.util.TreeSet<IMCIncident>();
        if (b.mcIncidents != null) mcIncidents.addAll(b.mcIncidents);
        mcIncidents = java.util.Collections.unmodifiableSortedSet(mcIncidents);
        this.mcIncidents = mcIncidents;
        java.util.SortedSet<IMCMonitor> mcMonitors = new java.util.TreeSet<IMCMonitor>();
        if (b.mcMonitors != null) mcMonitors.addAll(b.mcMonitors);
        mcMonitors = java.util.Collections.unmodifiableSortedSet(mcMonitors);
        this.mcMonitors = mcMonitors;
        java.util.SortedSet<IMetric> metrics = new java.util.TreeSet<IMetric>();
        if (b.metrics != null) metrics.addAll(b.metrics);
        metrics = java.util.Collections.unmodifiableSortedSet(metrics);
        this.metrics = metrics;
        this.name = b.name;
        java.util.SortedSet<String> nonCompliantAssetPolicyGUIDs = new java.util.TreeSet<String>();
        if (b.nonCompliantAssetPolicyGUIDs != null) nonCompliantAssetPolicyGUIDs.addAll(b.nonCompliantAssetPolicyGUIDs);
        nonCompliantAssetPolicyGUIDs = java.util.Collections.unmodifiableSortedSet(nonCompliantAssetPolicyGUIDs);
        this.nonCompliantAssetPolicyGUIDs = nonCompliantAssetPolicyGUIDs;
        java.util.SortedSet<IDataProduct> outputPortDataProducts = new java.util.TreeSet<IDataProduct>();
        if (b.outputPortDataProducts != null) outputPortDataProducts.addAll(b.outputPortDataProducts);
        outputPortDataProducts = java.util.Collections.unmodifiableSortedSet(outputPortDataProducts);
        this.outputPortDataProducts = outputPortDataProducts;
        java.util.SortedSet<String> ownerGroups = new java.util.TreeSet<String>();
        if (b.ownerGroups != null) ownerGroups.addAll(b.ownerGroups);
        ownerGroups = java.util.Collections.unmodifiableSortedSet(ownerGroups);
        this.ownerGroups = ownerGroups;
        java.util.SortedSet<String> ownerUsers = new java.util.TreeSet<String>();
        if (b.ownerUsers != null) ownerUsers.addAll(b.ownerUsers);
        ownerUsers = java.util.Collections.unmodifiableSortedSet(ownerUsers);
        this.ownerUsers = ownerUsers;
        this.popularityScore = b.popularityScore;
        this.qualifiedName = b.qualifiedName;
        this.readme = b.readme;
        this.sampleDataUrl = b.sampleDataUrl;
        java.util.SortedSet<ISchemaRegistrySubject> schemaRegistrySubjects = new java.util.TreeSet<ISchemaRegistrySubject>();
        if (b.schemaRegistrySubjects != null) schemaRegistrySubjects.addAll(b.schemaRegistrySubjects);
        schemaRegistrySubjects = java.util.Collections.unmodifiableSortedSet(schemaRegistrySubjects);
        this.schemaRegistrySubjects = schemaRegistrySubjects;
        java.util.SortedSet<ISodaCheck> sodaChecks = new java.util.TreeSet<ISodaCheck>();
        if (b.sodaChecks != null) sodaChecks.addAll(b.sodaChecks);
        sodaChecks = java.util.Collections.unmodifiableSortedSet(sodaChecks);
        this.sodaChecks = sodaChecks;
        this.sourceCostUnit = b.sourceCostUnit;
        this.sourceCreatedAt = b.sourceCreatedAt;
        this.sourceCreatedBy = b.sourceCreatedBy;
        this.sourceEmbedURL = b.sourceEmbedURL;
        this.sourceLastReadAt = b.sourceLastReadAt;
        this.sourceOwners = b.sourceOwners;
        java.util.List<PopularityInsights> sourceQueryComputeCostRecords;
        switch (b.sourceQueryComputeCostRecords == null ? 0 : b.sourceQueryComputeCostRecords.size()) {
        case 0: 
            sourceQueryComputeCostRecords = java.util.Collections.emptyList();
            break;
        case 1: 
            sourceQueryComputeCostRecords = java.util.Collections.singletonList(b.sourceQueryComputeCostRecords.get(0));
            break;
        default: 
            sourceQueryComputeCostRecords = java.util.Collections.unmodifiableList(new java.util.ArrayList<PopularityInsights>(b.sourceQueryComputeCostRecords));
        }
        this.sourceQueryComputeCostRecords = sourceQueryComputeCostRecords;
        java.util.SortedSet<String> sourceQueryComputeCosts = new java.util.TreeSet<String>();
        if (b.sourceQueryComputeCosts != null) sourceQueryComputeCosts.addAll(b.sourceQueryComputeCosts);
        sourceQueryComputeCosts = java.util.Collections.unmodifiableSortedSet(sourceQueryComputeCosts);
        this.sourceQueryComputeCosts = sourceQueryComputeCosts;
        this.sourceReadCount = b.sourceReadCount;
        java.util.List<PopularityInsights> sourceReadExpensiveQueryRecords;
        switch (b.sourceReadExpensiveQueryRecords == null ? 0 : b.sourceReadExpensiveQueryRecords.size()) {
        case 0: 
            sourceReadExpensiveQueryRecords = java.util.Collections.emptyList();
            break;
        case 1: 
            sourceReadExpensiveQueryRecords = java.util.Collections.singletonList(b.sourceReadExpensiveQueryRecords.get(0));
            break;
        default: 
            sourceReadExpensiveQueryRecords = java.util.Collections.unmodifiableList(new java.util.ArrayList<PopularityInsights>(b.sourceReadExpensiveQueryRecords));
        }
        this.sourceReadExpensiveQueryRecords = sourceReadExpensiveQueryRecords;
        java.util.List<PopularityInsights> sourceReadPopularQueryRecords;
        switch (b.sourceReadPopularQueryRecords == null ? 0 : b.sourceReadPopularQueryRecords.size()) {
        case 0: 
            sourceReadPopularQueryRecords = java.util.Collections.emptyList();
            break;
        case 1: 
            sourceReadPopularQueryRecords = java.util.Collections.singletonList(b.sourceReadPopularQueryRecords.get(0));
            break;
        default: 
            sourceReadPopularQueryRecords = java.util.Collections.unmodifiableList(new java.util.ArrayList<PopularityInsights>(b.sourceReadPopularQueryRecords));
        }
        this.sourceReadPopularQueryRecords = sourceReadPopularQueryRecords;
        this.sourceReadQueryCost = b.sourceReadQueryCost;
        java.util.List<PopularityInsights> sourceReadRecentUserRecords;
        switch (b.sourceReadRecentUserRecords == null ? 0 : b.sourceReadRecentUserRecords.size()) {
        case 0: 
            sourceReadRecentUserRecords = java.util.Collections.emptyList();
            break;
        case 1: 
            sourceReadRecentUserRecords = java.util.Collections.singletonList(b.sourceReadRecentUserRecords.get(0));
            break;
        default: 
            sourceReadRecentUserRecords = java.util.Collections.unmodifiableList(new java.util.ArrayList<PopularityInsights>(b.sourceReadRecentUserRecords));
        }
        this.sourceReadRecentUserRecords = sourceReadRecentUserRecords;
        java.util.SortedSet<String> sourceReadRecentUsers = new java.util.TreeSet<String>();
        if (b.sourceReadRecentUsers != null) sourceReadRecentUsers.addAll(b.sourceReadRecentUsers);
        sourceReadRecentUsers = java.util.Collections.unmodifiableSortedSet(sourceReadRecentUsers);
        this.sourceReadRecentUsers = sourceReadRecentUsers;
        java.util.List<PopularityInsights> sourceReadSlowQueryRecords;
        switch (b.sourceReadSlowQueryRecords == null ? 0 : b.sourceReadSlowQueryRecords.size()) {
        case 0: 
            sourceReadSlowQueryRecords = java.util.Collections.emptyList();
            break;
        case 1: 
            sourceReadSlowQueryRecords = java.util.Collections.singletonList(b.sourceReadSlowQueryRecords.get(0));
            break;
        default: 
            sourceReadSlowQueryRecords = java.util.Collections.unmodifiableList(new java.util.ArrayList<PopularityInsights>(b.sourceReadSlowQueryRecords));
        }
        this.sourceReadSlowQueryRecords = sourceReadSlowQueryRecords;
        java.util.List<PopularityInsights> sourceReadTopUserRecords;
        switch (b.sourceReadTopUserRecords == null ? 0 : b.sourceReadTopUserRecords.size()) {
        case 0: 
            sourceReadTopUserRecords = java.util.Collections.emptyList();
            break;
        case 1: 
            sourceReadTopUserRecords = java.util.Collections.singletonList(b.sourceReadTopUserRecords.get(0));
            break;
        default: 
            sourceReadTopUserRecords = java.util.Collections.unmodifiableList(new java.util.ArrayList<PopularityInsights>(b.sourceReadTopUserRecords));
        }
        this.sourceReadTopUserRecords = sourceReadTopUserRecords;
        java.util.SortedSet<String> sourceReadTopUsers = new java.util.TreeSet<String>();
        if (b.sourceReadTopUsers != null) sourceReadTopUsers.addAll(b.sourceReadTopUsers);
        sourceReadTopUsers = java.util.Collections.unmodifiableSortedSet(sourceReadTopUsers);
        this.sourceReadTopUsers = sourceReadTopUsers;
        this.sourceReadUserCount = b.sourceReadUserCount;
        this.sourceTotalCost = b.sourceTotalCost;
        this.sourceURL = b.sourceURL;
        this.sourceUpdatedAt = b.sourceUpdatedAt;
        this.sourceUpdatedBy = b.sourceUpdatedBy;
        java.util.SortedSet<String> starredBy = new java.util.TreeSet<String>();
        if (b.starredBy != null) starredBy.addAll(b.starredBy);
        starredBy = java.util.Collections.unmodifiableSortedSet(starredBy);
        this.starredBy = starredBy;
        this.starredCount = b.starredCount;
        java.util.List<StarredDetails> starredDetails;
        switch (b.starredDetails == null ? 0 : b.starredDetails.size()) {
        case 0: 
            starredDetails = java.util.Collections.emptyList();
            break;
        case 1: 
            starredDetails = java.util.Collections.singletonList(b.starredDetails.get(0));
            break;
        default: 
            starredDetails = java.util.Collections.unmodifiableList(new java.util.ArrayList<StarredDetails>(b.starredDetails));
        }
        this.starredDetails = starredDetails;
        this.subType = b.subType;
        this.tenantId = b.tenantId;
        java.util.SortedSet<IAsset> userDefRelationshipFroms = new java.util.TreeSet<IAsset>();
        if (b.userDefRelationshipFroms != null) userDefRelationshipFroms.addAll(b.userDefRelationshipFroms);
        userDefRelationshipFroms = java.util.Collections.unmodifiableSortedSet(userDefRelationshipFroms);
        this.userDefRelationshipFroms = userDefRelationshipFroms;
        java.util.SortedSet<IAsset> userDefRelationshipTos = new java.util.TreeSet<IAsset>();
        if (b.userDefRelationshipTos != null) userDefRelationshipTos.addAll(b.userDefRelationshipTos);
        userDefRelationshipTos = java.util.Collections.unmodifiableSortedSet(userDefRelationshipTos);
        this.userDefRelationshipTos = userDefRelationshipTos;
        this.userDescription = b.userDescription;
        this.viewScore = b.viewScore;
        java.util.SortedSet<String> viewerGroups = new java.util.TreeSet<String>();
        if (b.viewerGroups != null) viewerGroups.addAll(b.viewerGroups);
        viewerGroups = java.util.Collections.unmodifiableSortedSet(viewerGroups);
        this.viewerGroups = viewerGroups;
        java.util.SortedSet<String> viewerUsers = new java.util.TreeSet<String>();
        if (b.viewerUsers != null) viewerUsers.addAll(b.viewerUsers);
        viewerUsers = java.util.Collections.unmodifiableSortedSet(viewerUsers);
        this.viewerUsers = viewerUsers;
        java.util.Set<String> nullFields;
        switch (b.nullFields == null ? 0 : b.nullFields.size()) {
        case 0: 
            nullFields = java.util.Collections.emptySet();
            break;
        case 1: 
            nullFields = java.util.Collections.singleton(b.nullFields.get(0));
            break;
        default: 
            nullFields = new java.util.LinkedHashSet<String>(b.nullFields.size() < 1073741824 ? 1 + b.nullFields.size() + (b.nullFields.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            nullFields.addAll(b.nullFields);
            nullFields = java.util.Collections.unmodifiableSet(nullFields);
        }
        this.nullFields = nullFields;
        java.util.SortedSet<AtlanTag> atlanTags = new java.util.TreeSet<AtlanTag>();
        if (b.atlanTags != null) atlanTags.addAll(b.atlanTags);
        atlanTags = java.util.Collections.unmodifiableSortedSet(atlanTags);
        this.atlanTags = atlanTags;
        java.util.Map<String, CustomMetadataAttributes> customMetadataSets;
        switch (b.customMetadataSets$key == null ? 0 : b.customMetadataSets$key.size()) {
        case 0: 
            customMetadataSets = java.util.Collections.emptyMap();
            break;
        case 1: 
            customMetadataSets = java.util.Collections.singletonMap(b.customMetadataSets$key.get(0), b.customMetadataSets$value.get(0));
            break;
        default: 
            customMetadataSets = new java.util.LinkedHashMap<String, CustomMetadataAttributes>(b.customMetadataSets$key.size() < 1073741824 ? 1 + b.customMetadataSets$key.size() + (b.customMetadataSets$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.customMetadataSets$key.size(); $i++) customMetadataSets.put(b.customMetadataSets$key.get($i), (CustomMetadataAttributes) b.customMetadataSets$value.get($i));
            customMetadataSets = java.util.Collections.unmodifiableMap(customMetadataSets);
        }
        this.customMetadataSets = customMetadataSets;
        this.status = b.status;
        this.createdBy = b.createdBy;
        this.updatedBy = b.updatedBy;
        this.createTime = b.createTime;
        this.updateTime = b.updateTime;
        this.deleteHandler = b.deleteHandler;
        this.depth = b.depth;
        this.immediateUpstream = b.immediateUpstream;
        this.immediateDownstream = b.immediateDownstream;
        java.util.SortedSet<String> atlanTagNames = new java.util.TreeSet<String>();
        if (b.atlanTagNames != null) atlanTagNames.addAll(b.atlanTagNames);
        atlanTagNames = java.util.Collections.unmodifiableSortedSet(atlanTagNames);
        this.atlanTagNames = atlanTagNames;
        this.isIncomplete = b.isIncomplete;
        java.util.SortedSet<String> meaningNames = new java.util.TreeSet<String>();
        if (b.meaningNames != null) meaningNames.addAll(b.meaningNames);
        meaningNames = java.util.Collections.unmodifiableSortedSet(meaningNames);
        this.meaningNames = meaningNames;
        java.util.SortedSet<Meaning> meanings = new java.util.TreeSet<Meaning>();
        if (b.meanings != null) meanings.addAll(b.meanings);
        meanings = java.util.Collections.unmodifiableSortedSet(meanings);
        this.meanings = meanings;
        java.util.SortedSet<String> pendingTasks = new java.util.TreeSet<String>();
        if (b.pendingTasks != null) pendingTasks.addAll(b.pendingTasks);
        pendingTasks = java.util.Collections.unmodifiableSortedSet(pendingTasks);
        this.pendingTasks = pendingTasks;
    }

    /**
     * List of groups who administer this asset. (This is only used for certain asset types.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAdminGroups() {
        return this.adminGroups;
    }

    /**
     * List of roles who administer this asset. (This is only used for Connection assets.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAdminRoles() {
        return this.adminRoles;
    }

    /**
     * List of users who administer this asset. (This is only used for certain asset types.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAdminUsers() {
        return this.adminUsers;
    }

    /**
     * Detailed message to include in the announcement on this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAnnouncementMessage() {
        return this.announcementMessage;
    }

    /**
     * Brief title for the announcement on this asset. Required when announcementType is specified.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAnnouncementTitle() {
        return this.announcementTitle;
    }

    /**
     * Type of announcement on this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanAnnouncementType getAnnouncementType() {
        return this.announcementType;
    }

    /**
     * Time (epoch) at which the announcement was last updated, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAnnouncementUpdatedAt() {
        return this.announcementUpdatedAt;
    }

    /**
     * Name of the user who last updated the announcement.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAnnouncementUpdatedBy() {
        return this.announcementUpdatedBy;
    }

    /**
     * Checks that run on this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAnomaloCheck> getAnomaloChecks() {
        return this.anomaloChecks;
    }

    /**
     * All associated Anomalo check types.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetAnomaloAppliedCheckTypes() {
        return this.assetAnomaloAppliedCheckTypes;
    }

    /**
     * Total number of checks present in Anomalo for this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetAnomaloCheckCount() {
        return this.assetAnomaloCheckCount;
    }

    /**
     * Stringified JSON object containing status of all Anomalo checks associated to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetAnomaloCheckStatuses() {
        return this.assetAnomaloCheckStatuses;
    }

    /**
     * Status of data quality from Anomalo.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetAnomaloDQStatus() {
        return this.assetAnomaloDQStatus;
    }

    /**
     * Total number of checks failed in Anomalo for this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetAnomaloFailedCheckCount() {
        return this.assetAnomaloFailedCheckCount;
    }

    /**
     * All associated Anomalo failed check types.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetAnomaloFailedCheckTypes() {
        return this.assetAnomaloFailedCheckTypes;
    }

    /**
     * Time (epoch) at which the last check was run via Anomalo.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetAnomaloLastCheckRunAt() {
        return this.assetAnomaloLastCheckRunAt;
    }

    /**
     * URL of the source in Anomalo.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetAnomaloSourceUrl() {
        return this.assetAnomaloSourceUrl;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetCoverImage() {
        return this.assetCoverImage;
    }

    /**
     * Name of the account in which this asset exists in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtAccountName() {
        return this.assetDbtAccountName;
    }

    /**
     * Alias of this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtAlias() {
        return this.assetDbtAlias;
    }

    /**
     * Version of the environment in which this asset is materialized in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtEnvironmentDbtVersion() {
        return this.assetDbtEnvironmentDbtVersion;
    }

    /**
     * Name of the environment in which this asset is materialized in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtEnvironmentName() {
        return this.assetDbtEnvironmentName;
    }

    /**
     * Time (epoch) at which the job that materialized this asset in dbt last ran, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetDbtJobLastRun() {
        return this.assetDbtJobLastRun;
    }

    /**
     * Path in S3 to the artifacts saved from the last run of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunArtifactS3Path() {
        return this.assetDbtJobLastRunArtifactS3Path;
    }

    /**
     * Whether artifacts were saved from the last run of the job that materialized this asset in dbt (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAssetDbtJobLastRunArtifactsSaved() {
        return this.assetDbtJobLastRunArtifactsSaved;
    }

    /**
     * Time (epoch) at which the job that materialized this asset in dbt was last created, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetDbtJobLastRunCreatedAt() {
        return this.assetDbtJobLastRunCreatedAt;
    }

    /**
     * Time (epoch) at which the job that materialized this asset in dbt was dequeued, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetDbtJobLastRunDequedAt() {
        return this.assetDbtJobLastRunDequedAt;
    }

    /**
     * Thread ID of the user who executed the last run of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunExecutedByThreadId() {
        return this.assetDbtJobLastRunExecutedByThreadId;
    }

    /**
     * Branch in git from which the last run of the job that materialized this asset in dbt ran.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunGitBranch() {
        return this.assetDbtJobLastRunGitBranch;
    }

    /**
     * SHA hash in git for the last run of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunGitSha() {
        return this.assetDbtJobLastRunGitSha;
    }

    /**
     * Whether docs were generated from the last run of the job that materialized this asset in dbt (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAssetDbtJobLastRunHasDocsGenerated() {
        return this.assetDbtJobLastRunHasDocsGenerated;
    }

    /**
     * Whether sources were generated from the last run of the job that materialized this asset in dbt (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAssetDbtJobLastRunHasSourcesGenerated() {
        return this.assetDbtJobLastRunHasSourcesGenerated;
    }

    /**
     * Whether notifications were sent from the last run of the job that materialized this asset in dbt (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAssetDbtJobLastRunNotificationsSent() {
        return this.assetDbtJobLastRunNotificationsSent;
    }

    /**
     * Thread ID of the owner of the last run of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunOwnerThreadId() {
        return this.assetDbtJobLastRunOwnerThreadId;
    }

    /**
     * Total duration the job that materialized this asset in dbt spent being queued.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunQueuedDuration() {
        return this.assetDbtJobLastRunQueuedDuration;
    }

    /**
     * Human-readable total duration of the last run of the job that materialized this asset in dbt spend being queued.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunQueuedDurationHumanized() {
        return this.assetDbtJobLastRunQueuedDurationHumanized;
    }

    /**
     * Run duration of the last run of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunRunDuration() {
        return this.assetDbtJobLastRunRunDuration;
    }

    /**
     * Human-readable run duration of the last run of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunRunDurationHumanized() {
        return this.assetDbtJobLastRunRunDurationHumanized;
    }

    /**
     * Time (epoch) at which the job that materialized this asset in dbt was started running, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetDbtJobLastRunStartedAt() {
        return this.assetDbtJobLastRunStartedAt;
    }

    /**
     * Status message of the last run of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunStatusMessage() {
        return this.assetDbtJobLastRunStatusMessage;
    }

    /**
     * Total duration of the last run of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunTotalDuration() {
        return this.assetDbtJobLastRunTotalDuration;
    }

    /**
     * Human-readable total duration of the last run of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunTotalDurationHumanized() {
        return this.assetDbtJobLastRunTotalDurationHumanized;
    }

    /**
     * Time (epoch) at which the job that materialized this asset in dbt was last updated, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetDbtJobLastRunUpdatedAt() {
        return this.assetDbtJobLastRunUpdatedAt;
    }

    /**
     * URL of the last run of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobLastRunUrl() {
        return this.assetDbtJobLastRunUrl;
    }

    /**
     * Name of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobName() {
        return this.assetDbtJobName;
    }

    /**
     * Time (epoch) when the next run of the job that materializes this asset in dbt is scheduled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetDbtJobNextRun() {
        return this.assetDbtJobNextRun;
    }

    /**
     * Human-readable time when the next run of the job that materializes this asset in dbt is scheduled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobNextRunHumanized() {
        return this.assetDbtJobNextRunHumanized;
    }

    /**
     * Schedule of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobSchedule() {
        return this.assetDbtJobSchedule;
    }

    /**
     * Human-readable cron schedule of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobScheduleCronHumanized() {
        return this.assetDbtJobScheduleCronHumanized;
    }

    /**
     * Status of the job that materialized this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtJobStatus() {
        return this.assetDbtJobStatus;
    }

    /**
     * Metadata for this asset in dbt, specifically everything under the 'meta' key in the dbt object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtMeta() {
        return this.assetDbtMeta;
    }

    /**
     * Name of the package in which this asset exists in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtPackageName() {
        return this.assetDbtPackageName;
    }

    /**
     * Name of the project in which this asset exists in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtProjectName() {
        return this.assetDbtProjectName;
    }

    /**
     * URL of the semantic layer proxy for this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtSemanticLayerProxyUrl() {
        return this.assetDbtSemanticLayerProxyUrl;
    }

    /**
     * Freshness criteria for the source of this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtSourceFreshnessCriteria() {
        return this.assetDbtSourceFreshnessCriteria;
    }

    /**
     * List of tags attached to this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetDbtTags() {
        return this.assetDbtTags;
    }

    /**
     * All associated dbt test statuses.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtTestStatus() {
        return this.assetDbtTestStatus;
    }

    /**
     * Unique identifier of this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtUniqueId() {
        return this.assetDbtUniqueId;
    }

    /**
     * Name of the DBT workflow in Atlan that last updated the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetDbtWorkflowLastUpdated() {
        return this.assetDbtWorkflowLastUpdated;
    }

    /**
     * Name of the icon to use for this asset. (Only applies to glossaries, currently.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanIcon getAssetIcon() {
        return this.assetIcon;
    }

    /**
     * List of unique Monte Carlo alert names attached to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcAlertQualifiedNames() {
        return this.assetMcAlertQualifiedNames;
    }

    /**
     * List of Monte Carlo incident names attached to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcIncidentNames() {
        return this.assetMcIncidentNames;
    }

    /**
     * List of Monte Carlo incident priorities associated with this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcIncidentPriorities() {
        return this.assetMcIncidentPriorities;
    }

    /**
     * List of unique Monte Carlo incident names attached to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcIncidentQualifiedNames() {
        return this.assetMcIncidentQualifiedNames;
    }

    /**
     * List of Monte Carlo incident severities associated with this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcIncidentSeverities() {
        return this.assetMcIncidentSeverities;
    }

    /**
     * List of Monte Carlo incident states associated with this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcIncidentStates() {
        return this.assetMcIncidentStates;
    }

    /**
     * List of Monte Carlo incident sub-types associated with this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcIncidentSubTypes() {
        return this.assetMcIncidentSubTypes;
    }

    /**
     * List of Monte Carlo incident types associated with this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcIncidentTypes() {
        return this.assetMcIncidentTypes;
    }

    /**
     * Time (epoch) at which this asset was last synced from Monte Carlo.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetMcLastSyncRunAt() {
        return this.assetMcLastSyncRunAt;
    }

    /**
     * List of Monte Carlo monitor names attached to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcMonitorNames() {
        return this.assetMcMonitorNames;
    }

    /**
     * List of unique Monte Carlo monitor names attached to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcMonitorQualifiedNames() {
        return this.assetMcMonitorQualifiedNames;
    }

    /**
     * Schedules of all associated Monte Carlo monitors.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcMonitorScheduleTypes() {
        return this.assetMcMonitorScheduleTypes;
    }

    /**
     * Statuses of all associated Monte Carlo monitors.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcMonitorStatuses() {
        return this.assetMcMonitorStatuses;
    }

    /**
     * Types of all associated Monte Carlo monitors.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetMcMonitorTypes() {
        return this.assetMcMonitorTypes;
    }

    /**
     * Count of policies inside the asset
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetPoliciesCount() {
        return this.assetPoliciesCount;
    }

    /**
     * Array of policy ids governing this asset
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetPolicyGUIDs() {
        return this.assetPolicyGUIDs;
    }

    /**
     * Number of checks done via Soda.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetSodaCheckCount() {
        return this.assetSodaCheckCount;
    }

    /**
     * All associated Soda check statuses.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetSodaCheckStatuses() {
        return this.assetSodaCheckStatuses;
    }

    /**
     * Status of data quality from Soda.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetSodaDQStatus() {
        return this.assetSodaDQStatus;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetSodaLastScanAt() {
        return this.assetSodaLastScanAt;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAssetSodaLastSyncRunAt() {
        return this.assetSodaLastSyncRunAt;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetSodaSourceURL() {
        return this.assetSodaSourceURL;
    }

    /**
     * List of tags attached to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAssetTags() {
        return this.assetTags;
    }

    /**
     * Color (in hexadecimal RGB) to use to represent this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssetThemeHex() {
        return this.assetThemeHex;
    }

    /**
     * Glossary terms that are linked to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getAssignedTerms() {
        return this.assignedTerms;
    }

    /**
     * Status of this asset's certification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CertificateStatus getCertificateStatus() {
        return this.certificateStatus;
    }

    /**
     * Human-readable descriptive message used to provide further detail to certificateStatus.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCertificateStatusMessage() {
        return this.certificateStatusMessage;
    }

    /**
     * Time (epoch) at which the certification was last updated, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCertificateUpdatedAt() {
        return this.certificateUpdatedAt;
    }

    /**
     * Name of the user who last updated the certification of this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCertificateUpdatedBy() {
        return this.certificateUpdatedBy;
    }

    /**
     * Simple name of the connection through which this asset is accessible.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getConnectionName() {
        return this.connectionName;
    }

    /**
     * Unique name of the connection through which this asset is accessible.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getConnectionQualifiedName() {
        return this.connectionQualifiedName;
    }

    /**
     * Type of the connector through which this asset is accessible.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanConnectorType getConnectorType() {
        return this.connectorType;
    }

    /**
     * Latest version of the data contract (in any status) for this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IDataContract getDataContractLatest() {
        return this.dataContractLatest;
    }

    /**
     * Latest certified version of the data contract for this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IDataContract getDataContractLatestCertified() {
        return this.dataContractLatestCertified;
    }

    /**
     * Unique name of this asset in dbt.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtQualifiedName() {
        return this.dbtQualifiedName;
    }

    /**
     * Description of this asset, for example as crawled from a source. Fallback for display purposes, if userDescription is empty.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Human-readable name of this asset used for display purposes (in user interface).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * Array of domain guids linked to this asset
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDomainGUIDs() {
        return this.domainGUIDs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IFile> getFiles() {
        return this.files;
    }

    /**
     * Whether this asset has contract (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getHasContract() {
        return this.hasContract;
    }

    /**
     * Whether this asset has lineage (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getHasLineage() {
        return this.hasLineage;
    }

    /**
     * Data products for which this asset is an input port.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDataProduct> getInputPortDataProducts() {
        return this.inputPortDataProducts;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsAIGenerated() {
        return this.isAIGenerated;
    }

    /**
     * Whether this asset is discoverable through the UI (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsDiscoverable() {
        return this.isDiscoverable;
    }

    /**
     * Whether this asset can be edited in the UI (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsEditable() {
        return this.isEditable;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsPartial() {
        return this.isPartial;
    }

    /**
     * Time (epoch) of the last operation that inserted, updated, or deleted rows, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLastRowChangedAt() {
        return this.lastRowChangedAt;
    }

    /**
     * Name of the last run of the crawler that last synchronized this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLastSyncRun() {
        return this.lastSyncRun;
    }

    /**
     * Time (epoch) at which this asset was last crawled, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLastSyncRunAt() {
        return this.lastSyncRunAt;
    }

    /**
     * Name of the crawler that last synchronized this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLastSyncWorkflowName() {
        return this.lastSyncWorkflowName;
    }

    /**
     * Custom order for sorting purpose, managed by client
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLexicographicalSortOrder() {
        return this.lexicographicalSortOrder;
    }

    /**
     * Links that are attached to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILink> getLinks() {
        return this.links;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMCIncident> getMcIncidents() {
        return this.mcIncidents;
    }

    /**
     * Monitors that observe this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMCMonitor> getMcMonitors() {
        return this.mcMonitors;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMetric> getMetrics() {
        return this.metrics;
    }

    /**
     * Name of this asset. Fallback for display purposes, if displayName is empty.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * Array of policy ids non-compliant to this asset
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getNonCompliantAssetPolicyGUIDs() {
        return this.nonCompliantAssetPolicyGUIDs;
    }

    /**
     * Data products for which this asset is an output port.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDataProduct> getOutputPortDataProducts() {
        return this.outputPortDataProducts;
    }

    /**
     * List of groups who own this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getOwnerGroups() {
        return this.ownerGroups;
    }

    /**
     * List of users who own this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getOwnerUsers() {
        return this.ownerUsers;
    }

    /**
     * Popularity score for this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getPopularityScore() {
        return this.popularityScore;
    }

    /**
     * README that is linked to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IReadme getReadme() {
        return this.readme;
    }

    /**
     * URL for sample data for this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSampleDataUrl() {
        return this.sampleDataUrl;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISchemaRegistrySubject> getSchemaRegistrySubjects() {
        return this.schemaRegistrySubjects;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISodaCheck> getSodaChecks() {
        return this.sodaChecks;
    }

    /**
     * The unit of measure for sourceTotalCost.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SourceCostUnitType getSourceCostUnit() {
        return this.sourceCostUnit;
    }

    /**
     * Time (epoch) at which this asset was created in the source system, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSourceCreatedAt() {
        return this.sourceCreatedAt;
    }

    /**
     * Name of the user who created this asset, in the source system.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceCreatedBy() {
        return this.sourceCreatedBy;
    }

    /**
     * URL to create an embed for a resource (for example, an image of a dashboard) within Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceEmbedURL() {
        return this.sourceEmbedURL;
    }

    /**
     * Timestamp of most recent read operation.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSourceLastReadAt() {
        return this.sourceLastReadAt;
    }

    /**
     * List of owners of this asset, in the source system.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceOwners() {
        return this.sourceOwners;
    }

    /**
     * List of most expensive warehouses with extra insights.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<PopularityInsights> getSourceQueryComputeCostRecords() {
        return this.sourceQueryComputeCostRecords;
    }

    /**
     * List of most expensive warehouse names.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getSourceQueryComputeCosts() {
        return this.sourceQueryComputeCosts;
    }

    /**
     * Total count of all read operations at source.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSourceReadCount() {
        return this.sourceReadCount;
    }

    /**
     * List of the most expensive queries that accessed this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<PopularityInsights> getSourceReadExpensiveQueryRecords() {
        return this.sourceReadExpensiveQueryRecords;
    }

    /**
     * List of the most popular queries that accessed this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<PopularityInsights> getSourceReadPopularQueryRecords() {
        return this.sourceReadPopularQueryRecords;
    }

    /**
     * Total cost of read queries at source.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getSourceReadQueryCost() {
        return this.sourceReadQueryCost;
    }

    /**
     * List of usernames with extra insights for the most recent users who read this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<PopularityInsights> getSourceReadRecentUserRecords() {
        return this.sourceReadRecentUserRecords;
    }

    /**
     * List of usernames of the most recent users who read this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getSourceReadRecentUsers() {
        return this.sourceReadRecentUsers;
    }

    /**
     * List of the slowest queries that accessed this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<PopularityInsights> getSourceReadSlowQueryRecords() {
        return this.sourceReadSlowQueryRecords;
    }

    /**
     * List of usernames with extra insights for the users who read this asset the most.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<PopularityInsights> getSourceReadTopUserRecords() {
        return this.sourceReadTopUserRecords;
    }

    /**
     * List of usernames of the users who read this asset the most.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getSourceReadTopUsers() {
        return this.sourceReadTopUsers;
    }

    /**
     * Total number of unique users that read data from asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSourceReadUserCount() {
        return this.sourceReadUserCount;
    }

    /**
     * Total cost of all operations at source.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getSourceTotalCost() {
        return this.sourceTotalCost;
    }

    /**
     * URL to the resource within the source application, used to create a button to view this asset in the source application.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceURL() {
        return this.sourceURL;
    }

    /**
     * Time (epoch) at which this asset was last updated in the source system, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSourceUpdatedAt() {
        return this.sourceUpdatedAt;
    }

    /**
     * Name of the user who last updated this asset, in the source system.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceUpdatedBy() {
        return this.sourceUpdatedBy;
    }

    /**
     * Users who have starred this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getStarredBy() {
        return this.starredBy;
    }

    /**
     * Number of users who have starred this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getStarredCount() {
        return this.starredCount;
    }

    /**
     * List of usernames with extra information of the users who have starred an asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<StarredDetails> getStarredDetails() {
        return this.starredDetails;
    }

    /**
     * Subtype of this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSubType() {
        return this.subType;
    }

    /**
     * Name of the Atlan workspace in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTenantId() {
        return this.tenantId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAsset> getUserDefRelationshipFroms() {
        return this.userDefRelationshipFroms;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAsset> getUserDefRelationshipTos() {
        return this.userDefRelationshipTos;
    }

    /**
     * Description of this asset, as provided by a user. If present, this will be used for the description in user interface.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUserDescription() {
        return this.userDescription;
    }

    /**
     * View score for this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getViewScore() {
        return this.viewScore;
    }

    /**
     * List of groups who can view assets contained in a collection. (This is only used for certain asset types.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getViewerGroups() {
        return this.viewerGroups;
    }

    /**
     * List of users who can view assets contained in a collection. (This is only used for certain asset types.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getViewerUsers() {
        return this.viewerUsers;
    }

    /**
     * Atlan tags assigned to the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<AtlanTag> getAtlanTags() {
        return this.atlanTags;
    }

    /**
     * Map of custom metadata attributes and values defined on the asset. The map is keyed by the human-readable
     * name of the custom metadata set, and the values are a further mapping from human-readable attribute name
     * to the value for that attribute on this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, CustomMetadataAttributes> getCustomMetadataSets() {
        return this.customMetadataSets;
    }

    /**
     * Status of the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanStatus getStatus() {
        return this.status;
    }

    /**
     * User or account that created the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    /**
     * User or account that last updated the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    /**
     * Time (epoch) at which the asset was created, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Time (epoch) at which the asset was last updated, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getUpdateTime() {
        return this.updateTime;
    }

    /**
     * Details on the handler used for deletion of the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDeleteHandler() {
        return this.deleteHandler;
    }

    /**
     * Depth of this asset within lineage.
     * Note: this will only be available in assets retrieved via lineage, and will vary even for
     * the same asset depending on the starting point of the lineage requested.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDepth() {
        return this.depth;
    }

    /**
     * Reference details about the asset(s) that are immediately upstream of this asset within lineage.
     * Note: this will only be available in assets retrieved via lineage when {@code immediateNeighbors} is true,
     * and could vary even for the same asset depending on the starting point and depth of the lineage requested.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<LineageRef> getImmediateUpstream() {
        return this.immediateUpstream;
    }

    /**
     * Reference details about the asset(s) that are immediately downstream of this asset within lineage.
     * Note: this will only be available in assets retrieved via lineage when {@code immediateNeighbors} is true,
     * and could vary even for the same asset depending on the starting point and depth of the lineage requested.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<LineageRef> getImmediateDownstream() {
        return this.immediateDownstream;
    }

    /**
     * The names of the Atlan tags that exist on the asset. This is not always returned, even by
     * full retrieval operations. It is better to depend on the detailed values in the Atlan tags
     * property.
     * @see #atlanTags
     */
    @java.lang.Deprecated
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getAtlanTagNames() {
        return this.atlanTagNames;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsIncomplete() {
        return this.isIncomplete;
    }

    /**
     * Names of terms that have been linked to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMeaningNames() {
        return this.meaningNames;
    }

    /**
     * Details of terms that have been linked to this asset. This is not set by all API endpoints, so cannot
     * be relied upon in general, even when there are terms assigned to an asset.
     * @deprecated see {@link #assignedTerms} instead
     */
    @java.lang.Deprecated
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<Meaning> getMeanings() {
        return this.meanings;
    }

    /**
     * Unique identifiers (GUIDs) for any background tasks that are yet to operate on this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getPendingTasks() {
        return this.pendingTasks;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Asset)) return false;
        final Asset other = (Asset) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$announcementUpdatedAt = this.getAnnouncementUpdatedAt();
        final java.lang.Object other$announcementUpdatedAt = other.getAnnouncementUpdatedAt();
        if (this$announcementUpdatedAt == null ? other$announcementUpdatedAt != null : !this$announcementUpdatedAt.equals(other$announcementUpdatedAt)) return false;
        final java.lang.Object this$assetAnomaloCheckCount = this.getAssetAnomaloCheckCount();
        final java.lang.Object other$assetAnomaloCheckCount = other.getAssetAnomaloCheckCount();
        if (this$assetAnomaloCheckCount == null ? other$assetAnomaloCheckCount != null : !this$assetAnomaloCheckCount.equals(other$assetAnomaloCheckCount)) return false;
        final java.lang.Object this$assetAnomaloFailedCheckCount = this.getAssetAnomaloFailedCheckCount();
        final java.lang.Object other$assetAnomaloFailedCheckCount = other.getAssetAnomaloFailedCheckCount();
        if (this$assetAnomaloFailedCheckCount == null ? other$assetAnomaloFailedCheckCount != null : !this$assetAnomaloFailedCheckCount.equals(other$assetAnomaloFailedCheckCount)) return false;
        final java.lang.Object this$assetAnomaloLastCheckRunAt = this.getAssetAnomaloLastCheckRunAt();
        final java.lang.Object other$assetAnomaloLastCheckRunAt = other.getAssetAnomaloLastCheckRunAt();
        if (this$assetAnomaloLastCheckRunAt == null ? other$assetAnomaloLastCheckRunAt != null : !this$assetAnomaloLastCheckRunAt.equals(other$assetAnomaloLastCheckRunAt)) return false;
        final java.lang.Object this$assetDbtJobLastRun = this.getAssetDbtJobLastRun();
        final java.lang.Object other$assetDbtJobLastRun = other.getAssetDbtJobLastRun();
        if (this$assetDbtJobLastRun == null ? other$assetDbtJobLastRun != null : !this$assetDbtJobLastRun.equals(other$assetDbtJobLastRun)) return false;
        final java.lang.Object this$assetDbtJobLastRunArtifactsSaved = this.getAssetDbtJobLastRunArtifactsSaved();
        final java.lang.Object other$assetDbtJobLastRunArtifactsSaved = other.getAssetDbtJobLastRunArtifactsSaved();
        if (this$assetDbtJobLastRunArtifactsSaved == null ? other$assetDbtJobLastRunArtifactsSaved != null : !this$assetDbtJobLastRunArtifactsSaved.equals(other$assetDbtJobLastRunArtifactsSaved)) return false;
        final java.lang.Object this$assetDbtJobLastRunCreatedAt = this.getAssetDbtJobLastRunCreatedAt();
        final java.lang.Object other$assetDbtJobLastRunCreatedAt = other.getAssetDbtJobLastRunCreatedAt();
        if (this$assetDbtJobLastRunCreatedAt == null ? other$assetDbtJobLastRunCreatedAt != null : !this$assetDbtJobLastRunCreatedAt.equals(other$assetDbtJobLastRunCreatedAt)) return false;
        final java.lang.Object this$assetDbtJobLastRunDequedAt = this.getAssetDbtJobLastRunDequedAt();
        final java.lang.Object other$assetDbtJobLastRunDequedAt = other.getAssetDbtJobLastRunDequedAt();
        if (this$assetDbtJobLastRunDequedAt == null ? other$assetDbtJobLastRunDequedAt != null : !this$assetDbtJobLastRunDequedAt.equals(other$assetDbtJobLastRunDequedAt)) return false;
        final java.lang.Object this$assetDbtJobLastRunHasDocsGenerated = this.getAssetDbtJobLastRunHasDocsGenerated();
        final java.lang.Object other$assetDbtJobLastRunHasDocsGenerated = other.getAssetDbtJobLastRunHasDocsGenerated();
        if (this$assetDbtJobLastRunHasDocsGenerated == null ? other$assetDbtJobLastRunHasDocsGenerated != null : !this$assetDbtJobLastRunHasDocsGenerated.equals(other$assetDbtJobLastRunHasDocsGenerated)) return false;
        final java.lang.Object this$assetDbtJobLastRunHasSourcesGenerated = this.getAssetDbtJobLastRunHasSourcesGenerated();
        final java.lang.Object other$assetDbtJobLastRunHasSourcesGenerated = other.getAssetDbtJobLastRunHasSourcesGenerated();
        if (this$assetDbtJobLastRunHasSourcesGenerated == null ? other$assetDbtJobLastRunHasSourcesGenerated != null : !this$assetDbtJobLastRunHasSourcesGenerated.equals(other$assetDbtJobLastRunHasSourcesGenerated)) return false;
        final java.lang.Object this$assetDbtJobLastRunNotificationsSent = this.getAssetDbtJobLastRunNotificationsSent();
        final java.lang.Object other$assetDbtJobLastRunNotificationsSent = other.getAssetDbtJobLastRunNotificationsSent();
        if (this$assetDbtJobLastRunNotificationsSent == null ? other$assetDbtJobLastRunNotificationsSent != null : !this$assetDbtJobLastRunNotificationsSent.equals(other$assetDbtJobLastRunNotificationsSent)) return false;
        final java.lang.Object this$assetDbtJobLastRunStartedAt = this.getAssetDbtJobLastRunStartedAt();
        final java.lang.Object other$assetDbtJobLastRunStartedAt = other.getAssetDbtJobLastRunStartedAt();
        if (this$assetDbtJobLastRunStartedAt == null ? other$assetDbtJobLastRunStartedAt != null : !this$assetDbtJobLastRunStartedAt.equals(other$assetDbtJobLastRunStartedAt)) return false;
        final java.lang.Object this$assetDbtJobLastRunUpdatedAt = this.getAssetDbtJobLastRunUpdatedAt();
        final java.lang.Object other$assetDbtJobLastRunUpdatedAt = other.getAssetDbtJobLastRunUpdatedAt();
        if (this$assetDbtJobLastRunUpdatedAt == null ? other$assetDbtJobLastRunUpdatedAt != null : !this$assetDbtJobLastRunUpdatedAt.equals(other$assetDbtJobLastRunUpdatedAt)) return false;
        final java.lang.Object this$assetDbtJobNextRun = this.getAssetDbtJobNextRun();
        final java.lang.Object other$assetDbtJobNextRun = other.getAssetDbtJobNextRun();
        if (this$assetDbtJobNextRun == null ? other$assetDbtJobNextRun != null : !this$assetDbtJobNextRun.equals(other$assetDbtJobNextRun)) return false;
        final java.lang.Object this$assetMcLastSyncRunAt = this.getAssetMcLastSyncRunAt();
        final java.lang.Object other$assetMcLastSyncRunAt = other.getAssetMcLastSyncRunAt();
        if (this$assetMcLastSyncRunAt == null ? other$assetMcLastSyncRunAt != null : !this$assetMcLastSyncRunAt.equals(other$assetMcLastSyncRunAt)) return false;
        final java.lang.Object this$assetPoliciesCount = this.getAssetPoliciesCount();
        final java.lang.Object other$assetPoliciesCount = other.getAssetPoliciesCount();
        if (this$assetPoliciesCount == null ? other$assetPoliciesCount != null : !this$assetPoliciesCount.equals(other$assetPoliciesCount)) return false;
        final java.lang.Object this$assetSodaCheckCount = this.getAssetSodaCheckCount();
        final java.lang.Object other$assetSodaCheckCount = other.getAssetSodaCheckCount();
        if (this$assetSodaCheckCount == null ? other$assetSodaCheckCount != null : !this$assetSodaCheckCount.equals(other$assetSodaCheckCount)) return false;
        final java.lang.Object this$assetSodaLastScanAt = this.getAssetSodaLastScanAt();
        final java.lang.Object other$assetSodaLastScanAt = other.getAssetSodaLastScanAt();
        if (this$assetSodaLastScanAt == null ? other$assetSodaLastScanAt != null : !this$assetSodaLastScanAt.equals(other$assetSodaLastScanAt)) return false;
        final java.lang.Object this$assetSodaLastSyncRunAt = this.getAssetSodaLastSyncRunAt();
        final java.lang.Object other$assetSodaLastSyncRunAt = other.getAssetSodaLastSyncRunAt();
        if (this$assetSodaLastSyncRunAt == null ? other$assetSodaLastSyncRunAt != null : !this$assetSodaLastSyncRunAt.equals(other$assetSodaLastSyncRunAt)) return false;
        final java.lang.Object this$certificateUpdatedAt = this.getCertificateUpdatedAt();
        final java.lang.Object other$certificateUpdatedAt = other.getCertificateUpdatedAt();
        if (this$certificateUpdatedAt == null ? other$certificateUpdatedAt != null : !this$certificateUpdatedAt.equals(other$certificateUpdatedAt)) return false;
        final java.lang.Object this$hasContract = this.getHasContract();
        final java.lang.Object other$hasContract = other.getHasContract();
        if (this$hasContract == null ? other$hasContract != null : !this$hasContract.equals(other$hasContract)) return false;
        final java.lang.Object this$hasLineage = this.getHasLineage();
        final java.lang.Object other$hasLineage = other.getHasLineage();
        if (this$hasLineage == null ? other$hasLineage != null : !this$hasLineage.equals(other$hasLineage)) return false;
        final java.lang.Object this$isAIGenerated = this.getIsAIGenerated();
        final java.lang.Object other$isAIGenerated = other.getIsAIGenerated();
        if (this$isAIGenerated == null ? other$isAIGenerated != null : !this$isAIGenerated.equals(other$isAIGenerated)) return false;
        final java.lang.Object this$isDiscoverable = this.getIsDiscoverable();
        final java.lang.Object other$isDiscoverable = other.getIsDiscoverable();
        if (this$isDiscoverable == null ? other$isDiscoverable != null : !this$isDiscoverable.equals(other$isDiscoverable)) return false;
        final java.lang.Object this$isEditable = this.getIsEditable();
        final java.lang.Object other$isEditable = other.getIsEditable();
        if (this$isEditable == null ? other$isEditable != null : !this$isEditable.equals(other$isEditable)) return false;
        final java.lang.Object this$isPartial = this.getIsPartial();
        final java.lang.Object other$isPartial = other.getIsPartial();
        if (this$isPartial == null ? other$isPartial != null : !this$isPartial.equals(other$isPartial)) return false;
        final java.lang.Object this$lastRowChangedAt = this.getLastRowChangedAt();
        final java.lang.Object other$lastRowChangedAt = other.getLastRowChangedAt();
        if (this$lastRowChangedAt == null ? other$lastRowChangedAt != null : !this$lastRowChangedAt.equals(other$lastRowChangedAt)) return false;
        final java.lang.Object this$lastSyncRunAt = this.getLastSyncRunAt();
        final java.lang.Object other$lastSyncRunAt = other.getLastSyncRunAt();
        if (this$lastSyncRunAt == null ? other$lastSyncRunAt != null : !this$lastSyncRunAt.equals(other$lastSyncRunAt)) return false;
        final java.lang.Object this$popularityScore = this.getPopularityScore();
        final java.lang.Object other$popularityScore = other.getPopularityScore();
        if (this$popularityScore == null ? other$popularityScore != null : !this$popularityScore.equals(other$popularityScore)) return false;
        final java.lang.Object this$sourceCreatedAt = this.getSourceCreatedAt();
        final java.lang.Object other$sourceCreatedAt = other.getSourceCreatedAt();
        if (this$sourceCreatedAt == null ? other$sourceCreatedAt != null : !this$sourceCreatedAt.equals(other$sourceCreatedAt)) return false;
        final java.lang.Object this$sourceLastReadAt = this.getSourceLastReadAt();
        final java.lang.Object other$sourceLastReadAt = other.getSourceLastReadAt();
        if (this$sourceLastReadAt == null ? other$sourceLastReadAt != null : !this$sourceLastReadAt.equals(other$sourceLastReadAt)) return false;
        final java.lang.Object this$sourceReadCount = this.getSourceReadCount();
        final java.lang.Object other$sourceReadCount = other.getSourceReadCount();
        if (this$sourceReadCount == null ? other$sourceReadCount != null : !this$sourceReadCount.equals(other$sourceReadCount)) return false;
        final java.lang.Object this$sourceReadQueryCost = this.getSourceReadQueryCost();
        final java.lang.Object other$sourceReadQueryCost = other.getSourceReadQueryCost();
        if (this$sourceReadQueryCost == null ? other$sourceReadQueryCost != null : !this$sourceReadQueryCost.equals(other$sourceReadQueryCost)) return false;
        final java.lang.Object this$sourceReadUserCount = this.getSourceReadUserCount();
        final java.lang.Object other$sourceReadUserCount = other.getSourceReadUserCount();
        if (this$sourceReadUserCount == null ? other$sourceReadUserCount != null : !this$sourceReadUserCount.equals(other$sourceReadUserCount)) return false;
        final java.lang.Object this$sourceTotalCost = this.getSourceTotalCost();
        final java.lang.Object other$sourceTotalCost = other.getSourceTotalCost();
        if (this$sourceTotalCost == null ? other$sourceTotalCost != null : !this$sourceTotalCost.equals(other$sourceTotalCost)) return false;
        final java.lang.Object this$sourceUpdatedAt = this.getSourceUpdatedAt();
        final java.lang.Object other$sourceUpdatedAt = other.getSourceUpdatedAt();
        if (this$sourceUpdatedAt == null ? other$sourceUpdatedAt != null : !this$sourceUpdatedAt.equals(other$sourceUpdatedAt)) return false;
        final java.lang.Object this$starredCount = this.getStarredCount();
        final java.lang.Object other$starredCount = other.getStarredCount();
        if (this$starredCount == null ? other$starredCount != null : !this$starredCount.equals(other$starredCount)) return false;
        final java.lang.Object this$viewScore = this.getViewScore();
        final java.lang.Object other$viewScore = other.getViewScore();
        if (this$viewScore == null ? other$viewScore != null : !this$viewScore.equals(other$viewScore)) return false;
        final java.lang.Object this$createTime = this.getCreateTime();
        final java.lang.Object other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) return false;
        final java.lang.Object this$updateTime = this.getUpdateTime();
        final java.lang.Object other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) return false;
        final java.lang.Object this$depth = this.getDepth();
        final java.lang.Object other$depth = other.getDepth();
        if (this$depth == null ? other$depth != null : !this$depth.equals(other$depth)) return false;
        final java.lang.Object this$isIncomplete = this.getIsIncomplete();
        final java.lang.Object other$isIncomplete = other.getIsIncomplete();
        if (this$isIncomplete == null ? other$isIncomplete != null : !this$isIncomplete.equals(other$isIncomplete)) return false;
        final java.lang.Object this$adminGroups = this.getAdminGroups();
        final java.lang.Object other$adminGroups = other.getAdminGroups();
        if (this$adminGroups == null ? other$adminGroups != null : !this$adminGroups.equals(other$adminGroups)) return false;
        final java.lang.Object this$adminRoles = this.getAdminRoles();
        final java.lang.Object other$adminRoles = other.getAdminRoles();
        if (this$adminRoles == null ? other$adminRoles != null : !this$adminRoles.equals(other$adminRoles)) return false;
        final java.lang.Object this$adminUsers = this.getAdminUsers();
        final java.lang.Object other$adminUsers = other.getAdminUsers();
        if (this$adminUsers == null ? other$adminUsers != null : !this$adminUsers.equals(other$adminUsers)) return false;
        final java.lang.Object this$announcementMessage = this.getAnnouncementMessage();
        final java.lang.Object other$announcementMessage = other.getAnnouncementMessage();
        if (this$announcementMessage == null ? other$announcementMessage != null : !this$announcementMessage.equals(other$announcementMessage)) return false;
        final java.lang.Object this$announcementTitle = this.getAnnouncementTitle();
        final java.lang.Object other$announcementTitle = other.getAnnouncementTitle();
        if (this$announcementTitle == null ? other$announcementTitle != null : !this$announcementTitle.equals(other$announcementTitle)) return false;
        final java.lang.Object this$announcementType = this.getAnnouncementType();
        final java.lang.Object other$announcementType = other.getAnnouncementType();
        if (this$announcementType == null ? other$announcementType != null : !this$announcementType.equals(other$announcementType)) return false;
        final java.lang.Object this$announcementUpdatedBy = this.getAnnouncementUpdatedBy();
        final java.lang.Object other$announcementUpdatedBy = other.getAnnouncementUpdatedBy();
        if (this$announcementUpdatedBy == null ? other$announcementUpdatedBy != null : !this$announcementUpdatedBy.equals(other$announcementUpdatedBy)) return false;
        final java.lang.Object this$anomaloChecks = this.getAnomaloChecks();
        final java.lang.Object other$anomaloChecks = other.getAnomaloChecks();
        if (this$anomaloChecks == null ? other$anomaloChecks != null : !this$anomaloChecks.equals(other$anomaloChecks)) return false;
        final java.lang.Object this$assetAnomaloAppliedCheckTypes = this.getAssetAnomaloAppliedCheckTypes();
        final java.lang.Object other$assetAnomaloAppliedCheckTypes = other.getAssetAnomaloAppliedCheckTypes();
        if (this$assetAnomaloAppliedCheckTypes == null ? other$assetAnomaloAppliedCheckTypes != null : !this$assetAnomaloAppliedCheckTypes.equals(other$assetAnomaloAppliedCheckTypes)) return false;
        final java.lang.Object this$assetAnomaloCheckStatuses = this.getAssetAnomaloCheckStatuses();
        final java.lang.Object other$assetAnomaloCheckStatuses = other.getAssetAnomaloCheckStatuses();
        if (this$assetAnomaloCheckStatuses == null ? other$assetAnomaloCheckStatuses != null : !this$assetAnomaloCheckStatuses.equals(other$assetAnomaloCheckStatuses)) return false;
        final java.lang.Object this$assetAnomaloDQStatus = this.getAssetAnomaloDQStatus();
        final java.lang.Object other$assetAnomaloDQStatus = other.getAssetAnomaloDQStatus();
        if (this$assetAnomaloDQStatus == null ? other$assetAnomaloDQStatus != null : !this$assetAnomaloDQStatus.equals(other$assetAnomaloDQStatus)) return false;
        final java.lang.Object this$assetAnomaloFailedCheckTypes = this.getAssetAnomaloFailedCheckTypes();
        final java.lang.Object other$assetAnomaloFailedCheckTypes = other.getAssetAnomaloFailedCheckTypes();
        if (this$assetAnomaloFailedCheckTypes == null ? other$assetAnomaloFailedCheckTypes != null : !this$assetAnomaloFailedCheckTypes.equals(other$assetAnomaloFailedCheckTypes)) return false;
        final java.lang.Object this$assetAnomaloSourceUrl = this.getAssetAnomaloSourceUrl();
        final java.lang.Object other$assetAnomaloSourceUrl = other.getAssetAnomaloSourceUrl();
        if (this$assetAnomaloSourceUrl == null ? other$assetAnomaloSourceUrl != null : !this$assetAnomaloSourceUrl.equals(other$assetAnomaloSourceUrl)) return false;
        final java.lang.Object this$assetCoverImage = this.getAssetCoverImage();
        final java.lang.Object other$assetCoverImage = other.getAssetCoverImage();
        if (this$assetCoverImage == null ? other$assetCoverImage != null : !this$assetCoverImage.equals(other$assetCoverImage)) return false;
        final java.lang.Object this$assetDbtAccountName = this.getAssetDbtAccountName();
        final java.lang.Object other$assetDbtAccountName = other.getAssetDbtAccountName();
        if (this$assetDbtAccountName == null ? other$assetDbtAccountName != null : !this$assetDbtAccountName.equals(other$assetDbtAccountName)) return false;
        final java.lang.Object this$assetDbtAlias = this.getAssetDbtAlias();
        final java.lang.Object other$assetDbtAlias = other.getAssetDbtAlias();
        if (this$assetDbtAlias == null ? other$assetDbtAlias != null : !this$assetDbtAlias.equals(other$assetDbtAlias)) return false;
        final java.lang.Object this$assetDbtEnvironmentDbtVersion = this.getAssetDbtEnvironmentDbtVersion();
        final java.lang.Object other$assetDbtEnvironmentDbtVersion = other.getAssetDbtEnvironmentDbtVersion();
        if (this$assetDbtEnvironmentDbtVersion == null ? other$assetDbtEnvironmentDbtVersion != null : !this$assetDbtEnvironmentDbtVersion.equals(other$assetDbtEnvironmentDbtVersion)) return false;
        final java.lang.Object this$assetDbtEnvironmentName = this.getAssetDbtEnvironmentName();
        final java.lang.Object other$assetDbtEnvironmentName = other.getAssetDbtEnvironmentName();
        if (this$assetDbtEnvironmentName == null ? other$assetDbtEnvironmentName != null : !this$assetDbtEnvironmentName.equals(other$assetDbtEnvironmentName)) return false;
        final java.lang.Object this$assetDbtJobLastRunArtifactS3Path = this.getAssetDbtJobLastRunArtifactS3Path();
        final java.lang.Object other$assetDbtJobLastRunArtifactS3Path = other.getAssetDbtJobLastRunArtifactS3Path();
        if (this$assetDbtJobLastRunArtifactS3Path == null ? other$assetDbtJobLastRunArtifactS3Path != null : !this$assetDbtJobLastRunArtifactS3Path.equals(other$assetDbtJobLastRunArtifactS3Path)) return false;
        final java.lang.Object this$assetDbtJobLastRunExecutedByThreadId = this.getAssetDbtJobLastRunExecutedByThreadId();
        final java.lang.Object other$assetDbtJobLastRunExecutedByThreadId = other.getAssetDbtJobLastRunExecutedByThreadId();
        if (this$assetDbtJobLastRunExecutedByThreadId == null ? other$assetDbtJobLastRunExecutedByThreadId != null : !this$assetDbtJobLastRunExecutedByThreadId.equals(other$assetDbtJobLastRunExecutedByThreadId)) return false;
        final java.lang.Object this$assetDbtJobLastRunGitBranch = this.getAssetDbtJobLastRunGitBranch();
        final java.lang.Object other$assetDbtJobLastRunGitBranch = other.getAssetDbtJobLastRunGitBranch();
        if (this$assetDbtJobLastRunGitBranch == null ? other$assetDbtJobLastRunGitBranch != null : !this$assetDbtJobLastRunGitBranch.equals(other$assetDbtJobLastRunGitBranch)) return false;
        final java.lang.Object this$assetDbtJobLastRunGitSha = this.getAssetDbtJobLastRunGitSha();
        final java.lang.Object other$assetDbtJobLastRunGitSha = other.getAssetDbtJobLastRunGitSha();
        if (this$assetDbtJobLastRunGitSha == null ? other$assetDbtJobLastRunGitSha != null : !this$assetDbtJobLastRunGitSha.equals(other$assetDbtJobLastRunGitSha)) return false;
        final java.lang.Object this$assetDbtJobLastRunOwnerThreadId = this.getAssetDbtJobLastRunOwnerThreadId();
        final java.lang.Object other$assetDbtJobLastRunOwnerThreadId = other.getAssetDbtJobLastRunOwnerThreadId();
        if (this$assetDbtJobLastRunOwnerThreadId == null ? other$assetDbtJobLastRunOwnerThreadId != null : !this$assetDbtJobLastRunOwnerThreadId.equals(other$assetDbtJobLastRunOwnerThreadId)) return false;
        final java.lang.Object this$assetDbtJobLastRunQueuedDuration = this.getAssetDbtJobLastRunQueuedDuration();
        final java.lang.Object other$assetDbtJobLastRunQueuedDuration = other.getAssetDbtJobLastRunQueuedDuration();
        if (this$assetDbtJobLastRunQueuedDuration == null ? other$assetDbtJobLastRunQueuedDuration != null : !this$assetDbtJobLastRunQueuedDuration.equals(other$assetDbtJobLastRunQueuedDuration)) return false;
        final java.lang.Object this$assetDbtJobLastRunQueuedDurationHumanized = this.getAssetDbtJobLastRunQueuedDurationHumanized();
        final java.lang.Object other$assetDbtJobLastRunQueuedDurationHumanized = other.getAssetDbtJobLastRunQueuedDurationHumanized();
        if (this$assetDbtJobLastRunQueuedDurationHumanized == null ? other$assetDbtJobLastRunQueuedDurationHumanized != null : !this$assetDbtJobLastRunQueuedDurationHumanized.equals(other$assetDbtJobLastRunQueuedDurationHumanized)) return false;
        final java.lang.Object this$assetDbtJobLastRunRunDuration = this.getAssetDbtJobLastRunRunDuration();
        final java.lang.Object other$assetDbtJobLastRunRunDuration = other.getAssetDbtJobLastRunRunDuration();
        if (this$assetDbtJobLastRunRunDuration == null ? other$assetDbtJobLastRunRunDuration != null : !this$assetDbtJobLastRunRunDuration.equals(other$assetDbtJobLastRunRunDuration)) return false;
        final java.lang.Object this$assetDbtJobLastRunRunDurationHumanized = this.getAssetDbtJobLastRunRunDurationHumanized();
        final java.lang.Object other$assetDbtJobLastRunRunDurationHumanized = other.getAssetDbtJobLastRunRunDurationHumanized();
        if (this$assetDbtJobLastRunRunDurationHumanized == null ? other$assetDbtJobLastRunRunDurationHumanized != null : !this$assetDbtJobLastRunRunDurationHumanized.equals(other$assetDbtJobLastRunRunDurationHumanized)) return false;
        final java.lang.Object this$assetDbtJobLastRunStatusMessage = this.getAssetDbtJobLastRunStatusMessage();
        final java.lang.Object other$assetDbtJobLastRunStatusMessage = other.getAssetDbtJobLastRunStatusMessage();
        if (this$assetDbtJobLastRunStatusMessage == null ? other$assetDbtJobLastRunStatusMessage != null : !this$assetDbtJobLastRunStatusMessage.equals(other$assetDbtJobLastRunStatusMessage)) return false;
        final java.lang.Object this$assetDbtJobLastRunTotalDuration = this.getAssetDbtJobLastRunTotalDuration();
        final java.lang.Object other$assetDbtJobLastRunTotalDuration = other.getAssetDbtJobLastRunTotalDuration();
        if (this$assetDbtJobLastRunTotalDuration == null ? other$assetDbtJobLastRunTotalDuration != null : !this$assetDbtJobLastRunTotalDuration.equals(other$assetDbtJobLastRunTotalDuration)) return false;
        final java.lang.Object this$assetDbtJobLastRunTotalDurationHumanized = this.getAssetDbtJobLastRunTotalDurationHumanized();
        final java.lang.Object other$assetDbtJobLastRunTotalDurationHumanized = other.getAssetDbtJobLastRunTotalDurationHumanized();
        if (this$assetDbtJobLastRunTotalDurationHumanized == null ? other$assetDbtJobLastRunTotalDurationHumanized != null : !this$assetDbtJobLastRunTotalDurationHumanized.equals(other$assetDbtJobLastRunTotalDurationHumanized)) return false;
        final java.lang.Object this$assetDbtJobLastRunUrl = this.getAssetDbtJobLastRunUrl();
        final java.lang.Object other$assetDbtJobLastRunUrl = other.getAssetDbtJobLastRunUrl();
        if (this$assetDbtJobLastRunUrl == null ? other$assetDbtJobLastRunUrl != null : !this$assetDbtJobLastRunUrl.equals(other$assetDbtJobLastRunUrl)) return false;
        final java.lang.Object this$assetDbtJobName = this.getAssetDbtJobName();
        final java.lang.Object other$assetDbtJobName = other.getAssetDbtJobName();
        if (this$assetDbtJobName == null ? other$assetDbtJobName != null : !this$assetDbtJobName.equals(other$assetDbtJobName)) return false;
        final java.lang.Object this$assetDbtJobNextRunHumanized = this.getAssetDbtJobNextRunHumanized();
        final java.lang.Object other$assetDbtJobNextRunHumanized = other.getAssetDbtJobNextRunHumanized();
        if (this$assetDbtJobNextRunHumanized == null ? other$assetDbtJobNextRunHumanized != null : !this$assetDbtJobNextRunHumanized.equals(other$assetDbtJobNextRunHumanized)) return false;
        final java.lang.Object this$assetDbtJobSchedule = this.getAssetDbtJobSchedule();
        final java.lang.Object other$assetDbtJobSchedule = other.getAssetDbtJobSchedule();
        if (this$assetDbtJobSchedule == null ? other$assetDbtJobSchedule != null : !this$assetDbtJobSchedule.equals(other$assetDbtJobSchedule)) return false;
        final java.lang.Object this$assetDbtJobScheduleCronHumanized = this.getAssetDbtJobScheduleCronHumanized();
        final java.lang.Object other$assetDbtJobScheduleCronHumanized = other.getAssetDbtJobScheduleCronHumanized();
        if (this$assetDbtJobScheduleCronHumanized == null ? other$assetDbtJobScheduleCronHumanized != null : !this$assetDbtJobScheduleCronHumanized.equals(other$assetDbtJobScheduleCronHumanized)) return false;
        final java.lang.Object this$assetDbtJobStatus = this.getAssetDbtJobStatus();
        final java.lang.Object other$assetDbtJobStatus = other.getAssetDbtJobStatus();
        if (this$assetDbtJobStatus == null ? other$assetDbtJobStatus != null : !this$assetDbtJobStatus.equals(other$assetDbtJobStatus)) return false;
        final java.lang.Object this$assetDbtMeta = this.getAssetDbtMeta();
        final java.lang.Object other$assetDbtMeta = other.getAssetDbtMeta();
        if (this$assetDbtMeta == null ? other$assetDbtMeta != null : !this$assetDbtMeta.equals(other$assetDbtMeta)) return false;
        final java.lang.Object this$assetDbtPackageName = this.getAssetDbtPackageName();
        final java.lang.Object other$assetDbtPackageName = other.getAssetDbtPackageName();
        if (this$assetDbtPackageName == null ? other$assetDbtPackageName != null : !this$assetDbtPackageName.equals(other$assetDbtPackageName)) return false;
        final java.lang.Object this$assetDbtProjectName = this.getAssetDbtProjectName();
        final java.lang.Object other$assetDbtProjectName = other.getAssetDbtProjectName();
        if (this$assetDbtProjectName == null ? other$assetDbtProjectName != null : !this$assetDbtProjectName.equals(other$assetDbtProjectName)) return false;
        final java.lang.Object this$assetDbtSemanticLayerProxyUrl = this.getAssetDbtSemanticLayerProxyUrl();
        final java.lang.Object other$assetDbtSemanticLayerProxyUrl = other.getAssetDbtSemanticLayerProxyUrl();
        if (this$assetDbtSemanticLayerProxyUrl == null ? other$assetDbtSemanticLayerProxyUrl != null : !this$assetDbtSemanticLayerProxyUrl.equals(other$assetDbtSemanticLayerProxyUrl)) return false;
        final java.lang.Object this$assetDbtSourceFreshnessCriteria = this.getAssetDbtSourceFreshnessCriteria();
        final java.lang.Object other$assetDbtSourceFreshnessCriteria = other.getAssetDbtSourceFreshnessCriteria();
        if (this$assetDbtSourceFreshnessCriteria == null ? other$assetDbtSourceFreshnessCriteria != null : !this$assetDbtSourceFreshnessCriteria.equals(other$assetDbtSourceFreshnessCriteria)) return false;
        final java.lang.Object this$assetDbtTags = this.getAssetDbtTags();
        final java.lang.Object other$assetDbtTags = other.getAssetDbtTags();
        if (this$assetDbtTags == null ? other$assetDbtTags != null : !this$assetDbtTags.equals(other$assetDbtTags)) return false;
        final java.lang.Object this$assetDbtTestStatus = this.getAssetDbtTestStatus();
        final java.lang.Object other$assetDbtTestStatus = other.getAssetDbtTestStatus();
        if (this$assetDbtTestStatus == null ? other$assetDbtTestStatus != null : !this$assetDbtTestStatus.equals(other$assetDbtTestStatus)) return false;
        final java.lang.Object this$assetDbtUniqueId = this.getAssetDbtUniqueId();
        final java.lang.Object other$assetDbtUniqueId = other.getAssetDbtUniqueId();
        if (this$assetDbtUniqueId == null ? other$assetDbtUniqueId != null : !this$assetDbtUniqueId.equals(other$assetDbtUniqueId)) return false;
        final java.lang.Object this$assetDbtWorkflowLastUpdated = this.getAssetDbtWorkflowLastUpdated();
        final java.lang.Object other$assetDbtWorkflowLastUpdated = other.getAssetDbtWorkflowLastUpdated();
        if (this$assetDbtWorkflowLastUpdated == null ? other$assetDbtWorkflowLastUpdated != null : !this$assetDbtWorkflowLastUpdated.equals(other$assetDbtWorkflowLastUpdated)) return false;
        final java.lang.Object this$assetIcon = this.getAssetIcon();
        final java.lang.Object other$assetIcon = other.getAssetIcon();
        if (this$assetIcon == null ? other$assetIcon != null : !this$assetIcon.equals(other$assetIcon)) return false;
        final java.lang.Object this$assetMcAlertQualifiedNames = this.getAssetMcAlertQualifiedNames();
        final java.lang.Object other$assetMcAlertQualifiedNames = other.getAssetMcAlertQualifiedNames();
        if (this$assetMcAlertQualifiedNames == null ? other$assetMcAlertQualifiedNames != null : !this$assetMcAlertQualifiedNames.equals(other$assetMcAlertQualifiedNames)) return false;
        final java.lang.Object this$assetMcIncidentNames = this.getAssetMcIncidentNames();
        final java.lang.Object other$assetMcIncidentNames = other.getAssetMcIncidentNames();
        if (this$assetMcIncidentNames == null ? other$assetMcIncidentNames != null : !this$assetMcIncidentNames.equals(other$assetMcIncidentNames)) return false;
        final java.lang.Object this$assetMcIncidentPriorities = this.getAssetMcIncidentPriorities();
        final java.lang.Object other$assetMcIncidentPriorities = other.getAssetMcIncidentPriorities();
        if (this$assetMcIncidentPriorities == null ? other$assetMcIncidentPriorities != null : !this$assetMcIncidentPriorities.equals(other$assetMcIncidentPriorities)) return false;
        final java.lang.Object this$assetMcIncidentQualifiedNames = this.getAssetMcIncidentQualifiedNames();
        final java.lang.Object other$assetMcIncidentQualifiedNames = other.getAssetMcIncidentQualifiedNames();
        if (this$assetMcIncidentQualifiedNames == null ? other$assetMcIncidentQualifiedNames != null : !this$assetMcIncidentQualifiedNames.equals(other$assetMcIncidentQualifiedNames)) return false;
        final java.lang.Object this$assetMcIncidentSeverities = this.getAssetMcIncidentSeverities();
        final java.lang.Object other$assetMcIncidentSeverities = other.getAssetMcIncidentSeverities();
        if (this$assetMcIncidentSeverities == null ? other$assetMcIncidentSeverities != null : !this$assetMcIncidentSeverities.equals(other$assetMcIncidentSeverities)) return false;
        final java.lang.Object this$assetMcIncidentStates = this.getAssetMcIncidentStates();
        final java.lang.Object other$assetMcIncidentStates = other.getAssetMcIncidentStates();
        if (this$assetMcIncidentStates == null ? other$assetMcIncidentStates != null : !this$assetMcIncidentStates.equals(other$assetMcIncidentStates)) return false;
        final java.lang.Object this$assetMcIncidentSubTypes = this.getAssetMcIncidentSubTypes();
        final java.lang.Object other$assetMcIncidentSubTypes = other.getAssetMcIncidentSubTypes();
        if (this$assetMcIncidentSubTypes == null ? other$assetMcIncidentSubTypes != null : !this$assetMcIncidentSubTypes.equals(other$assetMcIncidentSubTypes)) return false;
        final java.lang.Object this$assetMcIncidentTypes = this.getAssetMcIncidentTypes();
        final java.lang.Object other$assetMcIncidentTypes = other.getAssetMcIncidentTypes();
        if (this$assetMcIncidentTypes == null ? other$assetMcIncidentTypes != null : !this$assetMcIncidentTypes.equals(other$assetMcIncidentTypes)) return false;
        final java.lang.Object this$assetMcMonitorNames = this.getAssetMcMonitorNames();
        final java.lang.Object other$assetMcMonitorNames = other.getAssetMcMonitorNames();
        if (this$assetMcMonitorNames == null ? other$assetMcMonitorNames != null : !this$assetMcMonitorNames.equals(other$assetMcMonitorNames)) return false;
        final java.lang.Object this$assetMcMonitorQualifiedNames = this.getAssetMcMonitorQualifiedNames();
        final java.lang.Object other$assetMcMonitorQualifiedNames = other.getAssetMcMonitorQualifiedNames();
        if (this$assetMcMonitorQualifiedNames == null ? other$assetMcMonitorQualifiedNames != null : !this$assetMcMonitorQualifiedNames.equals(other$assetMcMonitorQualifiedNames)) return false;
        final java.lang.Object this$assetMcMonitorScheduleTypes = this.getAssetMcMonitorScheduleTypes();
        final java.lang.Object other$assetMcMonitorScheduleTypes = other.getAssetMcMonitorScheduleTypes();
        if (this$assetMcMonitorScheduleTypes == null ? other$assetMcMonitorScheduleTypes != null : !this$assetMcMonitorScheduleTypes.equals(other$assetMcMonitorScheduleTypes)) return false;
        final java.lang.Object this$assetMcMonitorStatuses = this.getAssetMcMonitorStatuses();
        final java.lang.Object other$assetMcMonitorStatuses = other.getAssetMcMonitorStatuses();
        if (this$assetMcMonitorStatuses == null ? other$assetMcMonitorStatuses != null : !this$assetMcMonitorStatuses.equals(other$assetMcMonitorStatuses)) return false;
        final java.lang.Object this$assetMcMonitorTypes = this.getAssetMcMonitorTypes();
        final java.lang.Object other$assetMcMonitorTypes = other.getAssetMcMonitorTypes();
        if (this$assetMcMonitorTypes == null ? other$assetMcMonitorTypes != null : !this$assetMcMonitorTypes.equals(other$assetMcMonitorTypes)) return false;
        final java.lang.Object this$assetPolicyGUIDs = this.getAssetPolicyGUIDs();
        final java.lang.Object other$assetPolicyGUIDs = other.getAssetPolicyGUIDs();
        if (this$assetPolicyGUIDs == null ? other$assetPolicyGUIDs != null : !this$assetPolicyGUIDs.equals(other$assetPolicyGUIDs)) return false;
        final java.lang.Object this$assetSodaCheckStatuses = this.getAssetSodaCheckStatuses();
        final java.lang.Object other$assetSodaCheckStatuses = other.getAssetSodaCheckStatuses();
        if (this$assetSodaCheckStatuses == null ? other$assetSodaCheckStatuses != null : !this$assetSodaCheckStatuses.equals(other$assetSodaCheckStatuses)) return false;
        final java.lang.Object this$assetSodaDQStatus = this.getAssetSodaDQStatus();
        final java.lang.Object other$assetSodaDQStatus = other.getAssetSodaDQStatus();
        if (this$assetSodaDQStatus == null ? other$assetSodaDQStatus != null : !this$assetSodaDQStatus.equals(other$assetSodaDQStatus)) return false;
        final java.lang.Object this$assetSodaSourceURL = this.getAssetSodaSourceURL();
        final java.lang.Object other$assetSodaSourceURL = other.getAssetSodaSourceURL();
        if (this$assetSodaSourceURL == null ? other$assetSodaSourceURL != null : !this$assetSodaSourceURL.equals(other$assetSodaSourceURL)) return false;
        final java.lang.Object this$assetTags = this.getAssetTags();
        final java.lang.Object other$assetTags = other.getAssetTags();
        if (this$assetTags == null ? other$assetTags != null : !this$assetTags.equals(other$assetTags)) return false;
        final java.lang.Object this$assetThemeHex = this.getAssetThemeHex();
        final java.lang.Object other$assetThemeHex = other.getAssetThemeHex();
        if (this$assetThemeHex == null ? other$assetThemeHex != null : !this$assetThemeHex.equals(other$assetThemeHex)) return false;
        final java.lang.Object this$assignedTerms = this.getAssignedTerms();
        final java.lang.Object other$assignedTerms = other.getAssignedTerms();
        if (this$assignedTerms == null ? other$assignedTerms != null : !this$assignedTerms.equals(other$assignedTerms)) return false;
        final java.lang.Object this$certificateStatus = this.getCertificateStatus();
        final java.lang.Object other$certificateStatus = other.getCertificateStatus();
        if (this$certificateStatus == null ? other$certificateStatus != null : !this$certificateStatus.equals(other$certificateStatus)) return false;
        final java.lang.Object this$certificateStatusMessage = this.getCertificateStatusMessage();
        final java.lang.Object other$certificateStatusMessage = other.getCertificateStatusMessage();
        if (this$certificateStatusMessage == null ? other$certificateStatusMessage != null : !this$certificateStatusMessage.equals(other$certificateStatusMessage)) return false;
        final java.lang.Object this$certificateUpdatedBy = this.getCertificateUpdatedBy();
        final java.lang.Object other$certificateUpdatedBy = other.getCertificateUpdatedBy();
        if (this$certificateUpdatedBy == null ? other$certificateUpdatedBy != null : !this$certificateUpdatedBy.equals(other$certificateUpdatedBy)) return false;
        final java.lang.Object this$connectionName = this.getConnectionName();
        final java.lang.Object other$connectionName = other.getConnectionName();
        if (this$connectionName == null ? other$connectionName != null : !this$connectionName.equals(other$connectionName)) return false;
        final java.lang.Object this$connectionQualifiedName = this.getConnectionQualifiedName();
        final java.lang.Object other$connectionQualifiedName = other.getConnectionQualifiedName();
        if (this$connectionQualifiedName == null ? other$connectionQualifiedName != null : !this$connectionQualifiedName.equals(other$connectionQualifiedName)) return false;
        final java.lang.Object this$connectorType = this.getConnectorType();
        final java.lang.Object other$connectorType = other.getConnectorType();
        if (this$connectorType == null ? other$connectorType != null : !this$connectorType.equals(other$connectorType)) return false;
        final java.lang.Object this$dataContractLatest = this.getDataContractLatest();
        final java.lang.Object other$dataContractLatest = other.getDataContractLatest();
        if (this$dataContractLatest == null ? other$dataContractLatest != null : !this$dataContractLatest.equals(other$dataContractLatest)) return false;
        final java.lang.Object this$dataContractLatestCertified = this.getDataContractLatestCertified();
        final java.lang.Object other$dataContractLatestCertified = other.getDataContractLatestCertified();
        if (this$dataContractLatestCertified == null ? other$dataContractLatestCertified != null : !this$dataContractLatestCertified.equals(other$dataContractLatestCertified)) return false;
        final java.lang.Object this$dbtQualifiedName = this.getDbtQualifiedName();
        final java.lang.Object other$dbtQualifiedName = other.getDbtQualifiedName();
        if (this$dbtQualifiedName == null ? other$dbtQualifiedName != null : !this$dbtQualifiedName.equals(other$dbtQualifiedName)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$displayName = this.getDisplayName();
        final java.lang.Object other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
        final java.lang.Object this$domainGUIDs = this.getDomainGUIDs();
        final java.lang.Object other$domainGUIDs = other.getDomainGUIDs();
        if (this$domainGUIDs == null ? other$domainGUIDs != null : !this$domainGUIDs.equals(other$domainGUIDs)) return false;
        final java.lang.Object this$files = this.getFiles();
        final java.lang.Object other$files = other.getFiles();
        if (this$files == null ? other$files != null : !this$files.equals(other$files)) return false;
        final java.lang.Object this$inputPortDataProducts = this.getInputPortDataProducts();
        final java.lang.Object other$inputPortDataProducts = other.getInputPortDataProducts();
        if (this$inputPortDataProducts == null ? other$inputPortDataProducts != null : !this$inputPortDataProducts.equals(other$inputPortDataProducts)) return false;
        final java.lang.Object this$lastSyncRun = this.getLastSyncRun();
        final java.lang.Object other$lastSyncRun = other.getLastSyncRun();
        if (this$lastSyncRun == null ? other$lastSyncRun != null : !this$lastSyncRun.equals(other$lastSyncRun)) return false;
        final java.lang.Object this$lastSyncWorkflowName = this.getLastSyncWorkflowName();
        final java.lang.Object other$lastSyncWorkflowName = other.getLastSyncWorkflowName();
        if (this$lastSyncWorkflowName == null ? other$lastSyncWorkflowName != null : !this$lastSyncWorkflowName.equals(other$lastSyncWorkflowName)) return false;
        final java.lang.Object this$lexicographicalSortOrder = this.getLexicographicalSortOrder();
        final java.lang.Object other$lexicographicalSortOrder = other.getLexicographicalSortOrder();
        if (this$lexicographicalSortOrder == null ? other$lexicographicalSortOrder != null : !this$lexicographicalSortOrder.equals(other$lexicographicalSortOrder)) return false;
        final java.lang.Object this$links = this.getLinks();
        final java.lang.Object other$links = other.getLinks();
        if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
        final java.lang.Object this$mcIncidents = this.getMcIncidents();
        final java.lang.Object other$mcIncidents = other.getMcIncidents();
        if (this$mcIncidents == null ? other$mcIncidents != null : !this$mcIncidents.equals(other$mcIncidents)) return false;
        final java.lang.Object this$mcMonitors = this.getMcMonitors();
        final java.lang.Object other$mcMonitors = other.getMcMonitors();
        if (this$mcMonitors == null ? other$mcMonitors != null : !this$mcMonitors.equals(other$mcMonitors)) return false;
        final java.lang.Object this$metrics = this.getMetrics();
        final java.lang.Object other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$nonCompliantAssetPolicyGUIDs = this.getNonCompliantAssetPolicyGUIDs();
        final java.lang.Object other$nonCompliantAssetPolicyGUIDs = other.getNonCompliantAssetPolicyGUIDs();
        if (this$nonCompliantAssetPolicyGUIDs == null ? other$nonCompliantAssetPolicyGUIDs != null : !this$nonCompliantAssetPolicyGUIDs.equals(other$nonCompliantAssetPolicyGUIDs)) return false;
        final java.lang.Object this$outputPortDataProducts = this.getOutputPortDataProducts();
        final java.lang.Object other$outputPortDataProducts = other.getOutputPortDataProducts();
        if (this$outputPortDataProducts == null ? other$outputPortDataProducts != null : !this$outputPortDataProducts.equals(other$outputPortDataProducts)) return false;
        final java.lang.Object this$ownerGroups = this.getOwnerGroups();
        final java.lang.Object other$ownerGroups = other.getOwnerGroups();
        if (this$ownerGroups == null ? other$ownerGroups != null : !this$ownerGroups.equals(other$ownerGroups)) return false;
        final java.lang.Object this$ownerUsers = this.getOwnerUsers();
        final java.lang.Object other$ownerUsers = other.getOwnerUsers();
        if (this$ownerUsers == null ? other$ownerUsers != null : !this$ownerUsers.equals(other$ownerUsers)) return false;
        final java.lang.Object this$qualifiedName = this.getQualifiedName();
        final java.lang.Object other$qualifiedName = other.getQualifiedName();
        if (this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName)) return false;
        final java.lang.Object this$readme = this.getReadme();
        final java.lang.Object other$readme = other.getReadme();
        if (this$readme == null ? other$readme != null : !this$readme.equals(other$readme)) return false;
        final java.lang.Object this$sampleDataUrl = this.getSampleDataUrl();
        final java.lang.Object other$sampleDataUrl = other.getSampleDataUrl();
        if (this$sampleDataUrl == null ? other$sampleDataUrl != null : !this$sampleDataUrl.equals(other$sampleDataUrl)) return false;
        final java.lang.Object this$schemaRegistrySubjects = this.getSchemaRegistrySubjects();
        final java.lang.Object other$schemaRegistrySubjects = other.getSchemaRegistrySubjects();
        if (this$schemaRegistrySubjects == null ? other$schemaRegistrySubjects != null : !this$schemaRegistrySubjects.equals(other$schemaRegistrySubjects)) return false;
        final java.lang.Object this$sodaChecks = this.getSodaChecks();
        final java.lang.Object other$sodaChecks = other.getSodaChecks();
        if (this$sodaChecks == null ? other$sodaChecks != null : !this$sodaChecks.equals(other$sodaChecks)) return false;
        final java.lang.Object this$sourceCostUnit = this.getSourceCostUnit();
        final java.lang.Object other$sourceCostUnit = other.getSourceCostUnit();
        if (this$sourceCostUnit == null ? other$sourceCostUnit != null : !this$sourceCostUnit.equals(other$sourceCostUnit)) return false;
        final java.lang.Object this$sourceCreatedBy = this.getSourceCreatedBy();
        final java.lang.Object other$sourceCreatedBy = other.getSourceCreatedBy();
        if (this$sourceCreatedBy == null ? other$sourceCreatedBy != null : !this$sourceCreatedBy.equals(other$sourceCreatedBy)) return false;
        final java.lang.Object this$sourceEmbedURL = this.getSourceEmbedURL();
        final java.lang.Object other$sourceEmbedURL = other.getSourceEmbedURL();
        if (this$sourceEmbedURL == null ? other$sourceEmbedURL != null : !this$sourceEmbedURL.equals(other$sourceEmbedURL)) return false;
        final java.lang.Object this$sourceOwners = this.getSourceOwners();
        final java.lang.Object other$sourceOwners = other.getSourceOwners();
        if (this$sourceOwners == null ? other$sourceOwners != null : !this$sourceOwners.equals(other$sourceOwners)) return false;
        final java.lang.Object this$sourceQueryComputeCostRecords = this.getSourceQueryComputeCostRecords();
        final java.lang.Object other$sourceQueryComputeCostRecords = other.getSourceQueryComputeCostRecords();
        if (this$sourceQueryComputeCostRecords == null ? other$sourceQueryComputeCostRecords != null : !this$sourceQueryComputeCostRecords.equals(other$sourceQueryComputeCostRecords)) return false;
        final java.lang.Object this$sourceQueryComputeCosts = this.getSourceQueryComputeCosts();
        final java.lang.Object other$sourceQueryComputeCosts = other.getSourceQueryComputeCosts();
        if (this$sourceQueryComputeCosts == null ? other$sourceQueryComputeCosts != null : !this$sourceQueryComputeCosts.equals(other$sourceQueryComputeCosts)) return false;
        final java.lang.Object this$sourceReadExpensiveQueryRecords = this.getSourceReadExpensiveQueryRecords();
        final java.lang.Object other$sourceReadExpensiveQueryRecords = other.getSourceReadExpensiveQueryRecords();
        if (this$sourceReadExpensiveQueryRecords == null ? other$sourceReadExpensiveQueryRecords != null : !this$sourceReadExpensiveQueryRecords.equals(other$sourceReadExpensiveQueryRecords)) return false;
        final java.lang.Object this$sourceReadPopularQueryRecords = this.getSourceReadPopularQueryRecords();
        final java.lang.Object other$sourceReadPopularQueryRecords = other.getSourceReadPopularQueryRecords();
        if (this$sourceReadPopularQueryRecords == null ? other$sourceReadPopularQueryRecords != null : !this$sourceReadPopularQueryRecords.equals(other$sourceReadPopularQueryRecords)) return false;
        final java.lang.Object this$sourceReadRecentUserRecords = this.getSourceReadRecentUserRecords();
        final java.lang.Object other$sourceReadRecentUserRecords = other.getSourceReadRecentUserRecords();
        if (this$sourceReadRecentUserRecords == null ? other$sourceReadRecentUserRecords != null : !this$sourceReadRecentUserRecords.equals(other$sourceReadRecentUserRecords)) return false;
        final java.lang.Object this$sourceReadRecentUsers = this.getSourceReadRecentUsers();
        final java.lang.Object other$sourceReadRecentUsers = other.getSourceReadRecentUsers();
        if (this$sourceReadRecentUsers == null ? other$sourceReadRecentUsers != null : !this$sourceReadRecentUsers.equals(other$sourceReadRecentUsers)) return false;
        final java.lang.Object this$sourceReadSlowQueryRecords = this.getSourceReadSlowQueryRecords();
        final java.lang.Object other$sourceReadSlowQueryRecords = other.getSourceReadSlowQueryRecords();
        if (this$sourceReadSlowQueryRecords == null ? other$sourceReadSlowQueryRecords != null : !this$sourceReadSlowQueryRecords.equals(other$sourceReadSlowQueryRecords)) return false;
        final java.lang.Object this$sourceReadTopUserRecords = this.getSourceReadTopUserRecords();
        final java.lang.Object other$sourceReadTopUserRecords = other.getSourceReadTopUserRecords();
        if (this$sourceReadTopUserRecords == null ? other$sourceReadTopUserRecords != null : !this$sourceReadTopUserRecords.equals(other$sourceReadTopUserRecords)) return false;
        final java.lang.Object this$sourceReadTopUsers = this.getSourceReadTopUsers();
        final java.lang.Object other$sourceReadTopUsers = other.getSourceReadTopUsers();
        if (this$sourceReadTopUsers == null ? other$sourceReadTopUsers != null : !this$sourceReadTopUsers.equals(other$sourceReadTopUsers)) return false;
        final java.lang.Object this$sourceURL = this.getSourceURL();
        final java.lang.Object other$sourceURL = other.getSourceURL();
        if (this$sourceURL == null ? other$sourceURL != null : !this$sourceURL.equals(other$sourceURL)) return false;
        final java.lang.Object this$sourceUpdatedBy = this.getSourceUpdatedBy();
        final java.lang.Object other$sourceUpdatedBy = other.getSourceUpdatedBy();
        if (this$sourceUpdatedBy == null ? other$sourceUpdatedBy != null : !this$sourceUpdatedBy.equals(other$sourceUpdatedBy)) return false;
        final java.lang.Object this$starredBy = this.getStarredBy();
        final java.lang.Object other$starredBy = other.getStarredBy();
        if (this$starredBy == null ? other$starredBy != null : !this$starredBy.equals(other$starredBy)) return false;
        final java.lang.Object this$starredDetails = this.getStarredDetails();
        final java.lang.Object other$starredDetails = other.getStarredDetails();
        if (this$starredDetails == null ? other$starredDetails != null : !this$starredDetails.equals(other$starredDetails)) return false;
        final java.lang.Object this$subType = this.getSubType();
        final java.lang.Object other$subType = other.getSubType();
        if (this$subType == null ? other$subType != null : !this$subType.equals(other$subType)) return false;
        final java.lang.Object this$tenantId = this.getTenantId();
        final java.lang.Object other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) return false;
        final java.lang.Object this$userDefRelationshipFroms = this.getUserDefRelationshipFroms();
        final java.lang.Object other$userDefRelationshipFroms = other.getUserDefRelationshipFroms();
        if (this$userDefRelationshipFroms == null ? other$userDefRelationshipFroms != null : !this$userDefRelationshipFroms.equals(other$userDefRelationshipFroms)) return false;
        final java.lang.Object this$userDefRelationshipTos = this.getUserDefRelationshipTos();
        final java.lang.Object other$userDefRelationshipTos = other.getUserDefRelationshipTos();
        if (this$userDefRelationshipTos == null ? other$userDefRelationshipTos != null : !this$userDefRelationshipTos.equals(other$userDefRelationshipTos)) return false;
        final java.lang.Object this$userDescription = this.getUserDescription();
        final java.lang.Object other$userDescription = other.getUserDescription();
        if (this$userDescription == null ? other$userDescription != null : !this$userDescription.equals(other$userDescription)) return false;
        final java.lang.Object this$viewerGroups = this.getViewerGroups();
        final java.lang.Object other$viewerGroups = other.getViewerGroups();
        if (this$viewerGroups == null ? other$viewerGroups != null : !this$viewerGroups.equals(other$viewerGroups)) return false;
        final java.lang.Object this$viewerUsers = this.getViewerUsers();
        final java.lang.Object other$viewerUsers = other.getViewerUsers();
        if (this$viewerUsers == null ? other$viewerUsers != null : !this$viewerUsers.equals(other$viewerUsers)) return false;
        final java.lang.Object this$atlanTags = this.getAtlanTags();
        final java.lang.Object other$atlanTags = other.getAtlanTags();
        if (this$atlanTags == null ? other$atlanTags != null : !this$atlanTags.equals(other$atlanTags)) return false;
        final java.lang.Object this$customMetadataSets = this.getCustomMetadataSets();
        final java.lang.Object other$customMetadataSets = other.getCustomMetadataSets();
        if (this$customMetadataSets == null ? other$customMetadataSets != null : !this$customMetadataSets.equals(other$customMetadataSets)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        final java.lang.Object this$createdBy = this.getCreatedBy();
        final java.lang.Object other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) return false;
        final java.lang.Object this$updatedBy = this.getUpdatedBy();
        final java.lang.Object other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) return false;
        final java.lang.Object this$deleteHandler = this.getDeleteHandler();
        final java.lang.Object other$deleteHandler = other.getDeleteHandler();
        if (this$deleteHandler == null ? other$deleteHandler != null : !this$deleteHandler.equals(other$deleteHandler)) return false;
        final java.lang.Object this$immediateUpstream = this.getImmediateUpstream();
        final java.lang.Object other$immediateUpstream = other.getImmediateUpstream();
        if (this$immediateUpstream == null ? other$immediateUpstream != null : !this$immediateUpstream.equals(other$immediateUpstream)) return false;
        final java.lang.Object this$immediateDownstream = this.getImmediateDownstream();
        final java.lang.Object other$immediateDownstream = other.getImmediateDownstream();
        if (this$immediateDownstream == null ? other$immediateDownstream != null : !this$immediateDownstream.equals(other$immediateDownstream)) return false;
        final java.lang.Object this$atlanTagNames = this.getAtlanTagNames();
        final java.lang.Object other$atlanTagNames = other.getAtlanTagNames();
        if (this$atlanTagNames == null ? other$atlanTagNames != null : !this$atlanTagNames.equals(other$atlanTagNames)) return false;
        final java.lang.Object this$meaningNames = this.getMeaningNames();
        final java.lang.Object other$meaningNames = other.getMeaningNames();
        if (this$meaningNames == null ? other$meaningNames != null : !this$meaningNames.equals(other$meaningNames)) return false;
        final java.lang.Object this$meanings = this.getMeanings();
        final java.lang.Object other$meanings = other.getMeanings();
        if (this$meanings == null ? other$meanings != null : !this$meanings.equals(other$meanings)) return false;
        final java.lang.Object this$pendingTasks = this.getPendingTasks();
        final java.lang.Object other$pendingTasks = other.getPendingTasks();
        if (this$pendingTasks == null ? other$pendingTasks != null : !this$pendingTasks.equals(other$pendingTasks)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Asset;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $announcementUpdatedAt = this.getAnnouncementUpdatedAt();
        result = result * PRIME + ($announcementUpdatedAt == null ? 43 : $announcementUpdatedAt.hashCode());
        final java.lang.Object $assetAnomaloCheckCount = this.getAssetAnomaloCheckCount();
        result = result * PRIME + ($assetAnomaloCheckCount == null ? 43 : $assetAnomaloCheckCount.hashCode());
        final java.lang.Object $assetAnomaloFailedCheckCount = this.getAssetAnomaloFailedCheckCount();
        result = result * PRIME + ($assetAnomaloFailedCheckCount == null ? 43 : $assetAnomaloFailedCheckCount.hashCode());
        final java.lang.Object $assetAnomaloLastCheckRunAt = this.getAssetAnomaloLastCheckRunAt();
        result = result * PRIME + ($assetAnomaloLastCheckRunAt == null ? 43 : $assetAnomaloLastCheckRunAt.hashCode());
        final java.lang.Object $assetDbtJobLastRun = this.getAssetDbtJobLastRun();
        result = result * PRIME + ($assetDbtJobLastRun == null ? 43 : $assetDbtJobLastRun.hashCode());
        final java.lang.Object $assetDbtJobLastRunArtifactsSaved = this.getAssetDbtJobLastRunArtifactsSaved();
        result = result * PRIME + ($assetDbtJobLastRunArtifactsSaved == null ? 43 : $assetDbtJobLastRunArtifactsSaved.hashCode());
        final java.lang.Object $assetDbtJobLastRunCreatedAt = this.getAssetDbtJobLastRunCreatedAt();
        result = result * PRIME + ($assetDbtJobLastRunCreatedAt == null ? 43 : $assetDbtJobLastRunCreatedAt.hashCode());
        final java.lang.Object $assetDbtJobLastRunDequedAt = this.getAssetDbtJobLastRunDequedAt();
        result = result * PRIME + ($assetDbtJobLastRunDequedAt == null ? 43 : $assetDbtJobLastRunDequedAt.hashCode());
        final java.lang.Object $assetDbtJobLastRunHasDocsGenerated = this.getAssetDbtJobLastRunHasDocsGenerated();
        result = result * PRIME + ($assetDbtJobLastRunHasDocsGenerated == null ? 43 : $assetDbtJobLastRunHasDocsGenerated.hashCode());
        final java.lang.Object $assetDbtJobLastRunHasSourcesGenerated = this.getAssetDbtJobLastRunHasSourcesGenerated();
        result = result * PRIME + ($assetDbtJobLastRunHasSourcesGenerated == null ? 43 : $assetDbtJobLastRunHasSourcesGenerated.hashCode());
        final java.lang.Object $assetDbtJobLastRunNotificationsSent = this.getAssetDbtJobLastRunNotificationsSent();
        result = result * PRIME + ($assetDbtJobLastRunNotificationsSent == null ? 43 : $assetDbtJobLastRunNotificationsSent.hashCode());
        final java.lang.Object $assetDbtJobLastRunStartedAt = this.getAssetDbtJobLastRunStartedAt();
        result = result * PRIME + ($assetDbtJobLastRunStartedAt == null ? 43 : $assetDbtJobLastRunStartedAt.hashCode());
        final java.lang.Object $assetDbtJobLastRunUpdatedAt = this.getAssetDbtJobLastRunUpdatedAt();
        result = result * PRIME + ($assetDbtJobLastRunUpdatedAt == null ? 43 : $assetDbtJobLastRunUpdatedAt.hashCode());
        final java.lang.Object $assetDbtJobNextRun = this.getAssetDbtJobNextRun();
        result = result * PRIME + ($assetDbtJobNextRun == null ? 43 : $assetDbtJobNextRun.hashCode());
        final java.lang.Object $assetMcLastSyncRunAt = this.getAssetMcLastSyncRunAt();
        result = result * PRIME + ($assetMcLastSyncRunAt == null ? 43 : $assetMcLastSyncRunAt.hashCode());
        final java.lang.Object $assetPoliciesCount = this.getAssetPoliciesCount();
        result = result * PRIME + ($assetPoliciesCount == null ? 43 : $assetPoliciesCount.hashCode());
        final java.lang.Object $assetSodaCheckCount = this.getAssetSodaCheckCount();
        result = result * PRIME + ($assetSodaCheckCount == null ? 43 : $assetSodaCheckCount.hashCode());
        final java.lang.Object $assetSodaLastScanAt = this.getAssetSodaLastScanAt();
        result = result * PRIME + ($assetSodaLastScanAt == null ? 43 : $assetSodaLastScanAt.hashCode());
        final java.lang.Object $assetSodaLastSyncRunAt = this.getAssetSodaLastSyncRunAt();
        result = result * PRIME + ($assetSodaLastSyncRunAt == null ? 43 : $assetSodaLastSyncRunAt.hashCode());
        final java.lang.Object $certificateUpdatedAt = this.getCertificateUpdatedAt();
        result = result * PRIME + ($certificateUpdatedAt == null ? 43 : $certificateUpdatedAt.hashCode());
        final java.lang.Object $hasContract = this.getHasContract();
        result = result * PRIME + ($hasContract == null ? 43 : $hasContract.hashCode());
        final java.lang.Object $hasLineage = this.getHasLineage();
        result = result * PRIME + ($hasLineage == null ? 43 : $hasLineage.hashCode());
        final java.lang.Object $isAIGenerated = this.getIsAIGenerated();
        result = result * PRIME + ($isAIGenerated == null ? 43 : $isAIGenerated.hashCode());
        final java.lang.Object $isDiscoverable = this.getIsDiscoverable();
        result = result * PRIME + ($isDiscoverable == null ? 43 : $isDiscoverable.hashCode());
        final java.lang.Object $isEditable = this.getIsEditable();
        result = result * PRIME + ($isEditable == null ? 43 : $isEditable.hashCode());
        final java.lang.Object $isPartial = this.getIsPartial();
        result = result * PRIME + ($isPartial == null ? 43 : $isPartial.hashCode());
        final java.lang.Object $lastRowChangedAt = this.getLastRowChangedAt();
        result = result * PRIME + ($lastRowChangedAt == null ? 43 : $lastRowChangedAt.hashCode());
        final java.lang.Object $lastSyncRunAt = this.getLastSyncRunAt();
        result = result * PRIME + ($lastSyncRunAt == null ? 43 : $lastSyncRunAt.hashCode());
        final java.lang.Object $popularityScore = this.getPopularityScore();
        result = result * PRIME + ($popularityScore == null ? 43 : $popularityScore.hashCode());
        final java.lang.Object $sourceCreatedAt = this.getSourceCreatedAt();
        result = result * PRIME + ($sourceCreatedAt == null ? 43 : $sourceCreatedAt.hashCode());
        final java.lang.Object $sourceLastReadAt = this.getSourceLastReadAt();
        result = result * PRIME + ($sourceLastReadAt == null ? 43 : $sourceLastReadAt.hashCode());
        final java.lang.Object $sourceReadCount = this.getSourceReadCount();
        result = result * PRIME + ($sourceReadCount == null ? 43 : $sourceReadCount.hashCode());
        final java.lang.Object $sourceReadQueryCost = this.getSourceReadQueryCost();
        result = result * PRIME + ($sourceReadQueryCost == null ? 43 : $sourceReadQueryCost.hashCode());
        final java.lang.Object $sourceReadUserCount = this.getSourceReadUserCount();
        result = result * PRIME + ($sourceReadUserCount == null ? 43 : $sourceReadUserCount.hashCode());
        final java.lang.Object $sourceTotalCost = this.getSourceTotalCost();
        result = result * PRIME + ($sourceTotalCost == null ? 43 : $sourceTotalCost.hashCode());
        final java.lang.Object $sourceUpdatedAt = this.getSourceUpdatedAt();
        result = result * PRIME + ($sourceUpdatedAt == null ? 43 : $sourceUpdatedAt.hashCode());
        final java.lang.Object $starredCount = this.getStarredCount();
        result = result * PRIME + ($starredCount == null ? 43 : $starredCount.hashCode());
        final java.lang.Object $viewScore = this.getViewScore();
        result = result * PRIME + ($viewScore == null ? 43 : $viewScore.hashCode());
        final java.lang.Object $createTime = this.getCreateTime();
        result = result * PRIME + ($createTime == null ? 43 : $createTime.hashCode());
        final java.lang.Object $updateTime = this.getUpdateTime();
        result = result * PRIME + ($updateTime == null ? 43 : $updateTime.hashCode());
        final java.lang.Object $depth = this.getDepth();
        result = result * PRIME + ($depth == null ? 43 : $depth.hashCode());
        final java.lang.Object $isIncomplete = this.getIsIncomplete();
        result = result * PRIME + ($isIncomplete == null ? 43 : $isIncomplete.hashCode());
        final java.lang.Object $adminGroups = this.getAdminGroups();
        result = result * PRIME + ($adminGroups == null ? 43 : $adminGroups.hashCode());
        final java.lang.Object $adminRoles = this.getAdminRoles();
        result = result * PRIME + ($adminRoles == null ? 43 : $adminRoles.hashCode());
        final java.lang.Object $adminUsers = this.getAdminUsers();
        result = result * PRIME + ($adminUsers == null ? 43 : $adminUsers.hashCode());
        final java.lang.Object $announcementMessage = this.getAnnouncementMessage();
        result = result * PRIME + ($announcementMessage == null ? 43 : $announcementMessage.hashCode());
        final java.lang.Object $announcementTitle = this.getAnnouncementTitle();
        result = result * PRIME + ($announcementTitle == null ? 43 : $announcementTitle.hashCode());
        final java.lang.Object $announcementType = this.getAnnouncementType();
        result = result * PRIME + ($announcementType == null ? 43 : $announcementType.hashCode());
        final java.lang.Object $announcementUpdatedBy = this.getAnnouncementUpdatedBy();
        result = result * PRIME + ($announcementUpdatedBy == null ? 43 : $announcementUpdatedBy.hashCode());
        final java.lang.Object $anomaloChecks = this.getAnomaloChecks();
        result = result * PRIME + ($anomaloChecks == null ? 43 : $anomaloChecks.hashCode());
        final java.lang.Object $assetAnomaloAppliedCheckTypes = this.getAssetAnomaloAppliedCheckTypes();
        result = result * PRIME + ($assetAnomaloAppliedCheckTypes == null ? 43 : $assetAnomaloAppliedCheckTypes.hashCode());
        final java.lang.Object $assetAnomaloCheckStatuses = this.getAssetAnomaloCheckStatuses();
        result = result * PRIME + ($assetAnomaloCheckStatuses == null ? 43 : $assetAnomaloCheckStatuses.hashCode());
        final java.lang.Object $assetAnomaloDQStatus = this.getAssetAnomaloDQStatus();
        result = result * PRIME + ($assetAnomaloDQStatus == null ? 43 : $assetAnomaloDQStatus.hashCode());
        final java.lang.Object $assetAnomaloFailedCheckTypes = this.getAssetAnomaloFailedCheckTypes();
        result = result * PRIME + ($assetAnomaloFailedCheckTypes == null ? 43 : $assetAnomaloFailedCheckTypes.hashCode());
        final java.lang.Object $assetAnomaloSourceUrl = this.getAssetAnomaloSourceUrl();
        result = result * PRIME + ($assetAnomaloSourceUrl == null ? 43 : $assetAnomaloSourceUrl.hashCode());
        final java.lang.Object $assetCoverImage = this.getAssetCoverImage();
        result = result * PRIME + ($assetCoverImage == null ? 43 : $assetCoverImage.hashCode());
        final java.lang.Object $assetDbtAccountName = this.getAssetDbtAccountName();
        result = result * PRIME + ($assetDbtAccountName == null ? 43 : $assetDbtAccountName.hashCode());
        final java.lang.Object $assetDbtAlias = this.getAssetDbtAlias();
        result = result * PRIME + ($assetDbtAlias == null ? 43 : $assetDbtAlias.hashCode());
        final java.lang.Object $assetDbtEnvironmentDbtVersion = this.getAssetDbtEnvironmentDbtVersion();
        result = result * PRIME + ($assetDbtEnvironmentDbtVersion == null ? 43 : $assetDbtEnvironmentDbtVersion.hashCode());
        final java.lang.Object $assetDbtEnvironmentName = this.getAssetDbtEnvironmentName();
        result = result * PRIME + ($assetDbtEnvironmentName == null ? 43 : $assetDbtEnvironmentName.hashCode());
        final java.lang.Object $assetDbtJobLastRunArtifactS3Path = this.getAssetDbtJobLastRunArtifactS3Path();
        result = result * PRIME + ($assetDbtJobLastRunArtifactS3Path == null ? 43 : $assetDbtJobLastRunArtifactS3Path.hashCode());
        final java.lang.Object $assetDbtJobLastRunExecutedByThreadId = this.getAssetDbtJobLastRunExecutedByThreadId();
        result = result * PRIME + ($assetDbtJobLastRunExecutedByThreadId == null ? 43 : $assetDbtJobLastRunExecutedByThreadId.hashCode());
        final java.lang.Object $assetDbtJobLastRunGitBranch = this.getAssetDbtJobLastRunGitBranch();
        result = result * PRIME + ($assetDbtJobLastRunGitBranch == null ? 43 : $assetDbtJobLastRunGitBranch.hashCode());
        final java.lang.Object $assetDbtJobLastRunGitSha = this.getAssetDbtJobLastRunGitSha();
        result = result * PRIME + ($assetDbtJobLastRunGitSha == null ? 43 : $assetDbtJobLastRunGitSha.hashCode());
        final java.lang.Object $assetDbtJobLastRunOwnerThreadId = this.getAssetDbtJobLastRunOwnerThreadId();
        result = result * PRIME + ($assetDbtJobLastRunOwnerThreadId == null ? 43 : $assetDbtJobLastRunOwnerThreadId.hashCode());
        final java.lang.Object $assetDbtJobLastRunQueuedDuration = this.getAssetDbtJobLastRunQueuedDuration();
        result = result * PRIME + ($assetDbtJobLastRunQueuedDuration == null ? 43 : $assetDbtJobLastRunQueuedDuration.hashCode());
        final java.lang.Object $assetDbtJobLastRunQueuedDurationHumanized = this.getAssetDbtJobLastRunQueuedDurationHumanized();
        result = result * PRIME + ($assetDbtJobLastRunQueuedDurationHumanized == null ? 43 : $assetDbtJobLastRunQueuedDurationHumanized.hashCode());
        final java.lang.Object $assetDbtJobLastRunRunDuration = this.getAssetDbtJobLastRunRunDuration();
        result = result * PRIME + ($assetDbtJobLastRunRunDuration == null ? 43 : $assetDbtJobLastRunRunDuration.hashCode());
        final java.lang.Object $assetDbtJobLastRunRunDurationHumanized = this.getAssetDbtJobLastRunRunDurationHumanized();
        result = result * PRIME + ($assetDbtJobLastRunRunDurationHumanized == null ? 43 : $assetDbtJobLastRunRunDurationHumanized.hashCode());
        final java.lang.Object $assetDbtJobLastRunStatusMessage = this.getAssetDbtJobLastRunStatusMessage();
        result = result * PRIME + ($assetDbtJobLastRunStatusMessage == null ? 43 : $assetDbtJobLastRunStatusMessage.hashCode());
        final java.lang.Object $assetDbtJobLastRunTotalDuration = this.getAssetDbtJobLastRunTotalDuration();
        result = result * PRIME + ($assetDbtJobLastRunTotalDuration == null ? 43 : $assetDbtJobLastRunTotalDuration.hashCode());
        final java.lang.Object $assetDbtJobLastRunTotalDurationHumanized = this.getAssetDbtJobLastRunTotalDurationHumanized();
        result = result * PRIME + ($assetDbtJobLastRunTotalDurationHumanized == null ? 43 : $assetDbtJobLastRunTotalDurationHumanized.hashCode());
        final java.lang.Object $assetDbtJobLastRunUrl = this.getAssetDbtJobLastRunUrl();
        result = result * PRIME + ($assetDbtJobLastRunUrl == null ? 43 : $assetDbtJobLastRunUrl.hashCode());
        final java.lang.Object $assetDbtJobName = this.getAssetDbtJobName();
        result = result * PRIME + ($assetDbtJobName == null ? 43 : $assetDbtJobName.hashCode());
        final java.lang.Object $assetDbtJobNextRunHumanized = this.getAssetDbtJobNextRunHumanized();
        result = result * PRIME + ($assetDbtJobNextRunHumanized == null ? 43 : $assetDbtJobNextRunHumanized.hashCode());
        final java.lang.Object $assetDbtJobSchedule = this.getAssetDbtJobSchedule();
        result = result * PRIME + ($assetDbtJobSchedule == null ? 43 : $assetDbtJobSchedule.hashCode());
        final java.lang.Object $assetDbtJobScheduleCronHumanized = this.getAssetDbtJobScheduleCronHumanized();
        result = result * PRIME + ($assetDbtJobScheduleCronHumanized == null ? 43 : $assetDbtJobScheduleCronHumanized.hashCode());
        final java.lang.Object $assetDbtJobStatus = this.getAssetDbtJobStatus();
        result = result * PRIME + ($assetDbtJobStatus == null ? 43 : $assetDbtJobStatus.hashCode());
        final java.lang.Object $assetDbtMeta = this.getAssetDbtMeta();
        result = result * PRIME + ($assetDbtMeta == null ? 43 : $assetDbtMeta.hashCode());
        final java.lang.Object $assetDbtPackageName = this.getAssetDbtPackageName();
        result = result * PRIME + ($assetDbtPackageName == null ? 43 : $assetDbtPackageName.hashCode());
        final java.lang.Object $assetDbtProjectName = this.getAssetDbtProjectName();
        result = result * PRIME + ($assetDbtProjectName == null ? 43 : $assetDbtProjectName.hashCode());
        final java.lang.Object $assetDbtSemanticLayerProxyUrl = this.getAssetDbtSemanticLayerProxyUrl();
        result = result * PRIME + ($assetDbtSemanticLayerProxyUrl == null ? 43 : $assetDbtSemanticLayerProxyUrl.hashCode());
        final java.lang.Object $assetDbtSourceFreshnessCriteria = this.getAssetDbtSourceFreshnessCriteria();
        result = result * PRIME + ($assetDbtSourceFreshnessCriteria == null ? 43 : $assetDbtSourceFreshnessCriteria.hashCode());
        final java.lang.Object $assetDbtTags = this.getAssetDbtTags();
        result = result * PRIME + ($assetDbtTags == null ? 43 : $assetDbtTags.hashCode());
        final java.lang.Object $assetDbtTestStatus = this.getAssetDbtTestStatus();
        result = result * PRIME + ($assetDbtTestStatus == null ? 43 : $assetDbtTestStatus.hashCode());
        final java.lang.Object $assetDbtUniqueId = this.getAssetDbtUniqueId();
        result = result * PRIME + ($assetDbtUniqueId == null ? 43 : $assetDbtUniqueId.hashCode());
        final java.lang.Object $assetDbtWorkflowLastUpdated = this.getAssetDbtWorkflowLastUpdated();
        result = result * PRIME + ($assetDbtWorkflowLastUpdated == null ? 43 : $assetDbtWorkflowLastUpdated.hashCode());
        final java.lang.Object $assetIcon = this.getAssetIcon();
        result = result * PRIME + ($assetIcon == null ? 43 : $assetIcon.hashCode());
        final java.lang.Object $assetMcAlertQualifiedNames = this.getAssetMcAlertQualifiedNames();
        result = result * PRIME + ($assetMcAlertQualifiedNames == null ? 43 : $assetMcAlertQualifiedNames.hashCode());
        final java.lang.Object $assetMcIncidentNames = this.getAssetMcIncidentNames();
        result = result * PRIME + ($assetMcIncidentNames == null ? 43 : $assetMcIncidentNames.hashCode());
        final java.lang.Object $assetMcIncidentPriorities = this.getAssetMcIncidentPriorities();
        result = result * PRIME + ($assetMcIncidentPriorities == null ? 43 : $assetMcIncidentPriorities.hashCode());
        final java.lang.Object $assetMcIncidentQualifiedNames = this.getAssetMcIncidentQualifiedNames();
        result = result * PRIME + ($assetMcIncidentQualifiedNames == null ? 43 : $assetMcIncidentQualifiedNames.hashCode());
        final java.lang.Object $assetMcIncidentSeverities = this.getAssetMcIncidentSeverities();
        result = result * PRIME + ($assetMcIncidentSeverities == null ? 43 : $assetMcIncidentSeverities.hashCode());
        final java.lang.Object $assetMcIncidentStates = this.getAssetMcIncidentStates();
        result = result * PRIME + ($assetMcIncidentStates == null ? 43 : $assetMcIncidentStates.hashCode());
        final java.lang.Object $assetMcIncidentSubTypes = this.getAssetMcIncidentSubTypes();
        result = result * PRIME + ($assetMcIncidentSubTypes == null ? 43 : $assetMcIncidentSubTypes.hashCode());
        final java.lang.Object $assetMcIncidentTypes = this.getAssetMcIncidentTypes();
        result = result * PRIME + ($assetMcIncidentTypes == null ? 43 : $assetMcIncidentTypes.hashCode());
        final java.lang.Object $assetMcMonitorNames = this.getAssetMcMonitorNames();
        result = result * PRIME + ($assetMcMonitorNames == null ? 43 : $assetMcMonitorNames.hashCode());
        final java.lang.Object $assetMcMonitorQualifiedNames = this.getAssetMcMonitorQualifiedNames();
        result = result * PRIME + ($assetMcMonitorQualifiedNames == null ? 43 : $assetMcMonitorQualifiedNames.hashCode());
        final java.lang.Object $assetMcMonitorScheduleTypes = this.getAssetMcMonitorScheduleTypes();
        result = result * PRIME + ($assetMcMonitorScheduleTypes == null ? 43 : $assetMcMonitorScheduleTypes.hashCode());
        final java.lang.Object $assetMcMonitorStatuses = this.getAssetMcMonitorStatuses();
        result = result * PRIME + ($assetMcMonitorStatuses == null ? 43 : $assetMcMonitorStatuses.hashCode());
        final java.lang.Object $assetMcMonitorTypes = this.getAssetMcMonitorTypes();
        result = result * PRIME + ($assetMcMonitorTypes == null ? 43 : $assetMcMonitorTypes.hashCode());
        final java.lang.Object $assetPolicyGUIDs = this.getAssetPolicyGUIDs();
        result = result * PRIME + ($assetPolicyGUIDs == null ? 43 : $assetPolicyGUIDs.hashCode());
        final java.lang.Object $assetSodaCheckStatuses = this.getAssetSodaCheckStatuses();
        result = result * PRIME + ($assetSodaCheckStatuses == null ? 43 : $assetSodaCheckStatuses.hashCode());
        final java.lang.Object $assetSodaDQStatus = this.getAssetSodaDQStatus();
        result = result * PRIME + ($assetSodaDQStatus == null ? 43 : $assetSodaDQStatus.hashCode());
        final java.lang.Object $assetSodaSourceURL = this.getAssetSodaSourceURL();
        result = result * PRIME + ($assetSodaSourceURL == null ? 43 : $assetSodaSourceURL.hashCode());
        final java.lang.Object $assetTags = this.getAssetTags();
        result = result * PRIME + ($assetTags == null ? 43 : $assetTags.hashCode());
        final java.lang.Object $assetThemeHex = this.getAssetThemeHex();
        result = result * PRIME + ($assetThemeHex == null ? 43 : $assetThemeHex.hashCode());
        final java.lang.Object $assignedTerms = this.getAssignedTerms();
        result = result * PRIME + ($assignedTerms == null ? 43 : $assignedTerms.hashCode());
        final java.lang.Object $certificateStatus = this.getCertificateStatus();
        result = result * PRIME + ($certificateStatus == null ? 43 : $certificateStatus.hashCode());
        final java.lang.Object $certificateStatusMessage = this.getCertificateStatusMessage();
        result = result * PRIME + ($certificateStatusMessage == null ? 43 : $certificateStatusMessage.hashCode());
        final java.lang.Object $certificateUpdatedBy = this.getCertificateUpdatedBy();
        result = result * PRIME + ($certificateUpdatedBy == null ? 43 : $certificateUpdatedBy.hashCode());
        final java.lang.Object $connectionName = this.getConnectionName();
        result = result * PRIME + ($connectionName == null ? 43 : $connectionName.hashCode());
        final java.lang.Object $connectionQualifiedName = this.getConnectionQualifiedName();
        result = result * PRIME + ($connectionQualifiedName == null ? 43 : $connectionQualifiedName.hashCode());
        final java.lang.Object $connectorType = this.getConnectorType();
        result = result * PRIME + ($connectorType == null ? 43 : $connectorType.hashCode());
        final java.lang.Object $dataContractLatest = this.getDataContractLatest();
        result = result * PRIME + ($dataContractLatest == null ? 43 : $dataContractLatest.hashCode());
        final java.lang.Object $dataContractLatestCertified = this.getDataContractLatestCertified();
        result = result * PRIME + ($dataContractLatestCertified == null ? 43 : $dataContractLatestCertified.hashCode());
        final java.lang.Object $dbtQualifiedName = this.getDbtQualifiedName();
        result = result * PRIME + ($dbtQualifiedName == null ? 43 : $dbtQualifiedName.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $displayName = this.getDisplayName();
        result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
        final java.lang.Object $domainGUIDs = this.getDomainGUIDs();
        result = result * PRIME + ($domainGUIDs == null ? 43 : $domainGUIDs.hashCode());
        final java.lang.Object $files = this.getFiles();
        result = result * PRIME + ($files == null ? 43 : $files.hashCode());
        final java.lang.Object $inputPortDataProducts = this.getInputPortDataProducts();
        result = result * PRIME + ($inputPortDataProducts == null ? 43 : $inputPortDataProducts.hashCode());
        final java.lang.Object $lastSyncRun = this.getLastSyncRun();
        result = result * PRIME + ($lastSyncRun == null ? 43 : $lastSyncRun.hashCode());
        final java.lang.Object $lastSyncWorkflowName = this.getLastSyncWorkflowName();
        result = result * PRIME + ($lastSyncWorkflowName == null ? 43 : $lastSyncWorkflowName.hashCode());
        final java.lang.Object $lexicographicalSortOrder = this.getLexicographicalSortOrder();
        result = result * PRIME + ($lexicographicalSortOrder == null ? 43 : $lexicographicalSortOrder.hashCode());
        final java.lang.Object $links = this.getLinks();
        result = result * PRIME + ($links == null ? 43 : $links.hashCode());
        final java.lang.Object $mcIncidents = this.getMcIncidents();
        result = result * PRIME + ($mcIncidents == null ? 43 : $mcIncidents.hashCode());
        final java.lang.Object $mcMonitors = this.getMcMonitors();
        result = result * PRIME + ($mcMonitors == null ? 43 : $mcMonitors.hashCode());
        final java.lang.Object $metrics = this.getMetrics();
        result = result * PRIME + ($metrics == null ? 43 : $metrics.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $nonCompliantAssetPolicyGUIDs = this.getNonCompliantAssetPolicyGUIDs();
        result = result * PRIME + ($nonCompliantAssetPolicyGUIDs == null ? 43 : $nonCompliantAssetPolicyGUIDs.hashCode());
        final java.lang.Object $outputPortDataProducts = this.getOutputPortDataProducts();
        result = result * PRIME + ($outputPortDataProducts == null ? 43 : $outputPortDataProducts.hashCode());
        final java.lang.Object $ownerGroups = this.getOwnerGroups();
        result = result * PRIME + ($ownerGroups == null ? 43 : $ownerGroups.hashCode());
        final java.lang.Object $ownerUsers = this.getOwnerUsers();
        result = result * PRIME + ($ownerUsers == null ? 43 : $ownerUsers.hashCode());
        final java.lang.Object $qualifiedName = this.getQualifiedName();
        result = result * PRIME + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
        final java.lang.Object $readme = this.getReadme();
        result = result * PRIME + ($readme == null ? 43 : $readme.hashCode());
        final java.lang.Object $sampleDataUrl = this.getSampleDataUrl();
        result = result * PRIME + ($sampleDataUrl == null ? 43 : $sampleDataUrl.hashCode());
        final java.lang.Object $schemaRegistrySubjects = this.getSchemaRegistrySubjects();
        result = result * PRIME + ($schemaRegistrySubjects == null ? 43 : $schemaRegistrySubjects.hashCode());
        final java.lang.Object $sodaChecks = this.getSodaChecks();
        result = result * PRIME + ($sodaChecks == null ? 43 : $sodaChecks.hashCode());
        final java.lang.Object $sourceCostUnit = this.getSourceCostUnit();
        result = result * PRIME + ($sourceCostUnit == null ? 43 : $sourceCostUnit.hashCode());
        final java.lang.Object $sourceCreatedBy = this.getSourceCreatedBy();
        result = result * PRIME + ($sourceCreatedBy == null ? 43 : $sourceCreatedBy.hashCode());
        final java.lang.Object $sourceEmbedURL = this.getSourceEmbedURL();
        result = result * PRIME + ($sourceEmbedURL == null ? 43 : $sourceEmbedURL.hashCode());
        final java.lang.Object $sourceOwners = this.getSourceOwners();
        result = result * PRIME + ($sourceOwners == null ? 43 : $sourceOwners.hashCode());
        final java.lang.Object $sourceQueryComputeCostRecords = this.getSourceQueryComputeCostRecords();
        result = result * PRIME + ($sourceQueryComputeCostRecords == null ? 43 : $sourceQueryComputeCostRecords.hashCode());
        final java.lang.Object $sourceQueryComputeCosts = this.getSourceQueryComputeCosts();
        result = result * PRIME + ($sourceQueryComputeCosts == null ? 43 : $sourceQueryComputeCosts.hashCode());
        final java.lang.Object $sourceReadExpensiveQueryRecords = this.getSourceReadExpensiveQueryRecords();
        result = result * PRIME + ($sourceReadExpensiveQueryRecords == null ? 43 : $sourceReadExpensiveQueryRecords.hashCode());
        final java.lang.Object $sourceReadPopularQueryRecords = this.getSourceReadPopularQueryRecords();
        result = result * PRIME + ($sourceReadPopularQueryRecords == null ? 43 : $sourceReadPopularQueryRecords.hashCode());
        final java.lang.Object $sourceReadRecentUserRecords = this.getSourceReadRecentUserRecords();
        result = result * PRIME + ($sourceReadRecentUserRecords == null ? 43 : $sourceReadRecentUserRecords.hashCode());
        final java.lang.Object $sourceReadRecentUsers = this.getSourceReadRecentUsers();
        result = result * PRIME + ($sourceReadRecentUsers == null ? 43 : $sourceReadRecentUsers.hashCode());
        final java.lang.Object $sourceReadSlowQueryRecords = this.getSourceReadSlowQueryRecords();
        result = result * PRIME + ($sourceReadSlowQueryRecords == null ? 43 : $sourceReadSlowQueryRecords.hashCode());
        final java.lang.Object $sourceReadTopUserRecords = this.getSourceReadTopUserRecords();
        result = result * PRIME + ($sourceReadTopUserRecords == null ? 43 : $sourceReadTopUserRecords.hashCode());
        final java.lang.Object $sourceReadTopUsers = this.getSourceReadTopUsers();
        result = result * PRIME + ($sourceReadTopUsers == null ? 43 : $sourceReadTopUsers.hashCode());
        final java.lang.Object $sourceURL = this.getSourceURL();
        result = result * PRIME + ($sourceURL == null ? 43 : $sourceURL.hashCode());
        final java.lang.Object $sourceUpdatedBy = this.getSourceUpdatedBy();
        result = result * PRIME + ($sourceUpdatedBy == null ? 43 : $sourceUpdatedBy.hashCode());
        final java.lang.Object $starredBy = this.getStarredBy();
        result = result * PRIME + ($starredBy == null ? 43 : $starredBy.hashCode());
        final java.lang.Object $starredDetails = this.getStarredDetails();
        result = result * PRIME + ($starredDetails == null ? 43 : $starredDetails.hashCode());
        final java.lang.Object $subType = this.getSubType();
        result = result * PRIME + ($subType == null ? 43 : $subType.hashCode());
        final java.lang.Object $tenantId = this.getTenantId();
        result = result * PRIME + ($tenantId == null ? 43 : $tenantId.hashCode());
        final java.lang.Object $userDefRelationshipFroms = this.getUserDefRelationshipFroms();
        result = result * PRIME + ($userDefRelationshipFroms == null ? 43 : $userDefRelationshipFroms.hashCode());
        final java.lang.Object $userDefRelationshipTos = this.getUserDefRelationshipTos();
        result = result * PRIME + ($userDefRelationshipTos == null ? 43 : $userDefRelationshipTos.hashCode());
        final java.lang.Object $userDescription = this.getUserDescription();
        result = result * PRIME + ($userDescription == null ? 43 : $userDescription.hashCode());
        final java.lang.Object $viewerGroups = this.getViewerGroups();
        result = result * PRIME + ($viewerGroups == null ? 43 : $viewerGroups.hashCode());
        final java.lang.Object $viewerUsers = this.getViewerUsers();
        result = result * PRIME + ($viewerUsers == null ? 43 : $viewerUsers.hashCode());
        final java.lang.Object $atlanTags = this.getAtlanTags();
        result = result * PRIME + ($atlanTags == null ? 43 : $atlanTags.hashCode());
        final java.lang.Object $customMetadataSets = this.getCustomMetadataSets();
        result = result * PRIME + ($customMetadataSets == null ? 43 : $customMetadataSets.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        final java.lang.Object $createdBy = this.getCreatedBy();
        result = result * PRIME + ($createdBy == null ? 43 : $createdBy.hashCode());
        final java.lang.Object $updatedBy = this.getUpdatedBy();
        result = result * PRIME + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        final java.lang.Object $deleteHandler = this.getDeleteHandler();
        result = result * PRIME + ($deleteHandler == null ? 43 : $deleteHandler.hashCode());
        final java.lang.Object $immediateUpstream = this.getImmediateUpstream();
        result = result * PRIME + ($immediateUpstream == null ? 43 : $immediateUpstream.hashCode());
        final java.lang.Object $immediateDownstream = this.getImmediateDownstream();
        result = result * PRIME + ($immediateDownstream == null ? 43 : $immediateDownstream.hashCode());
        final java.lang.Object $atlanTagNames = this.getAtlanTagNames();
        result = result * PRIME + ($atlanTagNames == null ? 43 : $atlanTagNames.hashCode());
        final java.lang.Object $meaningNames = this.getMeaningNames();
        result = result * PRIME + ($meaningNames == null ? 43 : $meaningNames.hashCode());
        final java.lang.Object $meanings = this.getMeanings();
        result = result * PRIME + ($meanings == null ? 43 : $meanings.hashCode());
        final java.lang.Object $pendingTasks = this.getPendingTasks();
        result = result * PRIME + ($pendingTasks == null ? 43 : $pendingTasks.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Asset(super=" + super.toString() + ", adminGroups=" + this.getAdminGroups() + ", adminRoles=" + this.getAdminRoles() + ", adminUsers=" + this.getAdminUsers() + ", announcementMessage=" + this.getAnnouncementMessage() + ", announcementTitle=" + this.getAnnouncementTitle() + ", announcementType=" + this.getAnnouncementType() + ", announcementUpdatedAt=" + this.getAnnouncementUpdatedAt() + ", announcementUpdatedBy=" + this.getAnnouncementUpdatedBy() + ", anomaloChecks=" + this.getAnomaloChecks() + ", assetAnomaloAppliedCheckTypes=" + this.getAssetAnomaloAppliedCheckTypes() + ", assetAnomaloCheckCount=" + this.getAssetAnomaloCheckCount() + ", assetAnomaloCheckStatuses=" + this.getAssetAnomaloCheckStatuses() + ", assetAnomaloDQStatus=" + this.getAssetAnomaloDQStatus() + ", assetAnomaloFailedCheckCount=" + this.getAssetAnomaloFailedCheckCount() + ", assetAnomaloFailedCheckTypes=" + this.getAssetAnomaloFailedCheckTypes() + ", assetAnomaloLastCheckRunAt=" + this.getAssetAnomaloLastCheckRunAt() + ", assetAnomaloSourceUrl=" + this.getAssetAnomaloSourceUrl() + ", assetCoverImage=" + this.getAssetCoverImage() + ", assetDbtAccountName=" + this.getAssetDbtAccountName() + ", assetDbtAlias=" + this.getAssetDbtAlias() + ", assetDbtEnvironmentDbtVersion=" + this.getAssetDbtEnvironmentDbtVersion() + ", assetDbtEnvironmentName=" + this.getAssetDbtEnvironmentName() + ", assetDbtJobLastRun=" + this.getAssetDbtJobLastRun() + ", assetDbtJobLastRunArtifactS3Path=" + this.getAssetDbtJobLastRunArtifactS3Path() + ", assetDbtJobLastRunArtifactsSaved=" + this.getAssetDbtJobLastRunArtifactsSaved() + ", assetDbtJobLastRunCreatedAt=" + this.getAssetDbtJobLastRunCreatedAt() + ", assetDbtJobLastRunDequedAt=" + this.getAssetDbtJobLastRunDequedAt() + ", assetDbtJobLastRunExecutedByThreadId=" + this.getAssetDbtJobLastRunExecutedByThreadId() + ", assetDbtJobLastRunGitBranch=" + this.getAssetDbtJobLastRunGitBranch() + ", assetDbtJobLastRunGitSha=" + this.getAssetDbtJobLastRunGitSha() + ", assetDbtJobLastRunHasDocsGenerated=" + this.getAssetDbtJobLastRunHasDocsGenerated() + ", assetDbtJobLastRunHasSourcesGenerated=" + this.getAssetDbtJobLastRunHasSourcesGenerated() + ", assetDbtJobLastRunNotificationsSent=" + this.getAssetDbtJobLastRunNotificationsSent() + ", assetDbtJobLastRunOwnerThreadId=" + this.getAssetDbtJobLastRunOwnerThreadId() + ", assetDbtJobLastRunQueuedDuration=" + this.getAssetDbtJobLastRunQueuedDuration() + ", assetDbtJobLastRunQueuedDurationHumanized=" + this.getAssetDbtJobLastRunQueuedDurationHumanized() + ", assetDbtJobLastRunRunDuration=" + this.getAssetDbtJobLastRunRunDuration() + ", assetDbtJobLastRunRunDurationHumanized=" + this.getAssetDbtJobLastRunRunDurationHumanized() + ", assetDbtJobLastRunStartedAt=" + this.getAssetDbtJobLastRunStartedAt() + ", assetDbtJobLastRunStatusMessage=" + this.getAssetDbtJobLastRunStatusMessage() + ", assetDbtJobLastRunTotalDuration=" + this.getAssetDbtJobLastRunTotalDuration() + ", assetDbtJobLastRunTotalDurationHumanized=" + this.getAssetDbtJobLastRunTotalDurationHumanized() + ", assetDbtJobLastRunUpdatedAt=" + this.getAssetDbtJobLastRunUpdatedAt() + ", assetDbtJobLastRunUrl=" + this.getAssetDbtJobLastRunUrl() + ", assetDbtJobName=" + this.getAssetDbtJobName() + ", assetDbtJobNextRun=" + this.getAssetDbtJobNextRun() + ", assetDbtJobNextRunHumanized=" + this.getAssetDbtJobNextRunHumanized() + ", assetDbtJobSchedule=" + this.getAssetDbtJobSchedule() + ", assetDbtJobScheduleCronHumanized=" + this.getAssetDbtJobScheduleCronHumanized() + ", assetDbtJobStatus=" + this.getAssetDbtJobStatus() + ", assetDbtMeta=" + this.getAssetDbtMeta() + ", assetDbtPackageName=" + this.getAssetDbtPackageName() + ", assetDbtProjectName=" + this.getAssetDbtProjectName() + ", assetDbtSemanticLayerProxyUrl=" + this.getAssetDbtSemanticLayerProxyUrl() + ", assetDbtSourceFreshnessCriteria=" + this.getAssetDbtSourceFreshnessCriteria() + ", assetDbtTags=" + this.getAssetDbtTags() + ", assetDbtTestStatus=" + this.getAssetDbtTestStatus() + ", assetDbtUniqueId=" + this.getAssetDbtUniqueId() + ", assetDbtWorkflowLastUpdated=" + this.getAssetDbtWorkflowLastUpdated() + ", assetIcon=" + this.getAssetIcon() + ", assetMcAlertQualifiedNames=" + this.getAssetMcAlertQualifiedNames() + ", assetMcIncidentNames=" + this.getAssetMcIncidentNames() + ", assetMcIncidentPriorities=" + this.getAssetMcIncidentPriorities() + ", assetMcIncidentQualifiedNames=" + this.getAssetMcIncidentQualifiedNames() + ", assetMcIncidentSeverities=" + this.getAssetMcIncidentSeverities() + ", assetMcIncidentStates=" + this.getAssetMcIncidentStates() + ", assetMcIncidentSubTypes=" + this.getAssetMcIncidentSubTypes() + ", assetMcIncidentTypes=" + this.getAssetMcIncidentTypes() + ", assetMcLastSyncRunAt=" + this.getAssetMcLastSyncRunAt() + ", assetMcMonitorNames=" + this.getAssetMcMonitorNames() + ", assetMcMonitorQualifiedNames=" + this.getAssetMcMonitorQualifiedNames() + ", assetMcMonitorScheduleTypes=" + this.getAssetMcMonitorScheduleTypes() + ", assetMcMonitorStatuses=" + this.getAssetMcMonitorStatuses() + ", assetMcMonitorTypes=" + this.getAssetMcMonitorTypes() + ", assetPoliciesCount=" + this.getAssetPoliciesCount() + ", assetPolicyGUIDs=" + this.getAssetPolicyGUIDs() + ", assetSodaCheckCount=" + this.getAssetSodaCheckCount() + ", assetSodaCheckStatuses=" + this.getAssetSodaCheckStatuses() + ", assetSodaDQStatus=" + this.getAssetSodaDQStatus() + ", assetSodaLastScanAt=" + this.getAssetSodaLastScanAt() + ", assetSodaLastSyncRunAt=" + this.getAssetSodaLastSyncRunAt() + ", assetSodaSourceURL=" + this.getAssetSodaSourceURL() + ", assetTags=" + this.getAssetTags() + ", assetThemeHex=" + this.getAssetThemeHex() + ", assignedTerms=" + this.getAssignedTerms() + ", certificateStatus=" + this.getCertificateStatus() + ", certificateStatusMessage=" + this.getCertificateStatusMessage() + ", certificateUpdatedAt=" + this.getCertificateUpdatedAt() + ", certificateUpdatedBy=" + this.getCertificateUpdatedBy() + ", connectionName=" + this.getConnectionName() + ", connectionQualifiedName=" + this.getConnectionQualifiedName() + ", connectorType=" + this.getConnectorType() + ", dataContractLatest=" + this.getDataContractLatest() + ", dataContractLatestCertified=" + this.getDataContractLatestCertified() + ", dbtQualifiedName=" + this.getDbtQualifiedName() + ", description=" + this.getDescription() + ", displayName=" + this.getDisplayName() + ", domainGUIDs=" + this.getDomainGUIDs() + ", files=" + this.getFiles() + ", hasContract=" + this.getHasContract() + ", hasLineage=" + this.getHasLineage() + ", inputPortDataProducts=" + this.getInputPortDataProducts() + ", isAIGenerated=" + this.getIsAIGenerated() + ", isDiscoverable=" + this.getIsDiscoverable() + ", isEditable=" + this.getIsEditable() + ", isPartial=" + this.getIsPartial() + ", lastRowChangedAt=" + this.getLastRowChangedAt() + ", lastSyncRun=" + this.getLastSyncRun() + ", lastSyncRunAt=" + this.getLastSyncRunAt() + ", lastSyncWorkflowName=" + this.getLastSyncWorkflowName() + ", lexicographicalSortOrder=" + this.getLexicographicalSortOrder() + ", links=" + this.getLinks() + ", mcIncidents=" + this.getMcIncidents() + ", mcMonitors=" + this.getMcMonitors() + ", metrics=" + this.getMetrics() + ", name=" + this.getName() + ", nonCompliantAssetPolicyGUIDs=" + this.getNonCompliantAssetPolicyGUIDs() + ", outputPortDataProducts=" + this.getOutputPortDataProducts() + ", ownerGroups=" + this.getOwnerGroups() + ", ownerUsers=" + this.getOwnerUsers() + ", popularityScore=" + this.getPopularityScore() + ", qualifiedName=" + this.getQualifiedName() + ", readme=" + this.getReadme() + ", sampleDataUrl=" + this.getSampleDataUrl() + ", schemaRegistrySubjects=" + this.getSchemaRegistrySubjects() + ", sodaChecks=" + this.getSodaChecks() + ", sourceCostUnit=" + this.getSourceCostUnit() + ", sourceCreatedAt=" + this.getSourceCreatedAt() + ", sourceCreatedBy=" + this.getSourceCreatedBy() + ", sourceEmbedURL=" + this.getSourceEmbedURL() + ", sourceLastReadAt=" + this.getSourceLastReadAt() + ", sourceOwners=" + this.getSourceOwners() + ", sourceQueryComputeCostRecords=" + this.getSourceQueryComputeCostRecords() + ", sourceQueryComputeCosts=" + this.getSourceQueryComputeCosts() + ", sourceReadCount=" + this.getSourceReadCount() + ", sourceReadExpensiveQueryRecords=" + this.getSourceReadExpensiveQueryRecords() + ", sourceReadPopularQueryRecords=" + this.getSourceReadPopularQueryRecords() + ", sourceReadQueryCost=" + this.getSourceReadQueryCost() + ", sourceReadRecentUserRecords=" + this.getSourceReadRecentUserRecords() + ", sourceReadRecentUsers=" + this.getSourceReadRecentUsers() + ", sourceReadSlowQueryRecords=" + this.getSourceReadSlowQueryRecords() + ", sourceReadTopUserRecords=" + this.getSourceReadTopUserRecords() + ", sourceReadTopUsers=" + this.getSourceReadTopUsers() + ", sourceReadUserCount=" + this.getSourceReadUserCount() + ", sourceTotalCost=" + this.getSourceTotalCost() + ", sourceURL=" + this.getSourceURL() + ", sourceUpdatedAt=" + this.getSourceUpdatedAt() + ", sourceUpdatedBy=" + this.getSourceUpdatedBy() + ", starredBy=" + this.getStarredBy() + ", starredCount=" + this.getStarredCount() + ", starredDetails=" + this.getStarredDetails() + ", subType=" + this.getSubType() + ", tenantId=" + this.getTenantId() + ", userDefRelationshipFroms=" + this.getUserDefRelationshipFroms() + ", userDefRelationshipTos=" + this.getUserDefRelationshipTos() + ", userDescription=" + this.getUserDescription() + ", viewScore=" + this.getViewScore() + ", viewerGroups=" + this.getViewerGroups() + ", viewerUsers=" + this.getViewerUsers() + ", nullFields=" + this.getNullFields() + ", atlanTags=" + this.getAtlanTags() + ", customMetadataSets=" + this.getCustomMetadataSets() + ", status=" + this.getStatus() + ", createdBy=" + this.getCreatedBy() + ", updatedBy=" + this.getUpdatedBy() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", deleteHandler=" + this.getDeleteHandler() + ", depth=" + this.getDepth() + ", immediateUpstream=" + this.getImmediateUpstream() + ", immediateDownstream=" + this.getImmediateDownstream() + ", atlanTagNames=" + this.getAtlanTagNames() + ", isIncomplete=" + this.getIsIncomplete() + ", meaningNames=" + this.getMeaningNames() + ", meanings=" + this.getMeanings() + ", pendingTasks=" + this.getPendingTasks() + ")";
    }
}
