// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a query in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class AtlanQuery extends Asset implements IAtlanQuery, ISQL, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(AtlanQuery.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Query";
    /**
     * Fixed typeName for AtlanQuerys.
     */
    String typeName;
    /**
     * TBC
     */
    @Attribute
    String calculationViewName;
    /**
     * TBC
     */
    @Attribute
    String calculationViewQualifiedName;
    /**
     * TBC
     */
    @Attribute
    String collectionQualifiedName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IColumn> columns;
    /**
     * TBC
     */
    @Attribute
    String databaseName;
    /**
     * TBC
     */
    @Attribute
    String databaseQualifiedName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    /**
     * TBC
     */
    @Attribute
    String defaultDatabaseQualifiedName;
    /**
     * TBC
     */
    @Attribute
    String defaultSchemaQualifiedName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * TBC
     */
    @Attribute
    Boolean isPrivate;
    /**
     * TBC
     */
    @Attribute
    Boolean isProfiled;
    /**
     * TBC
     */
    @Attribute
    Boolean isSqlSnippet;
    /**
     * TBC
     */
    @Attribute
    Boolean isVisualQuery;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long lastProfiledAt;
    /**
     * TBC
     */
    @Attribute
    String longRawQuery;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * TBC
     */
    @Attribute
    INamespace parent;
    /**
     * TBC
     */
    @Attribute
    String parentQualifiedName;
    /**
     * TBC
     */
    @Attribute
    Long queryCount;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long queryCountUpdatedAt;
    /**
     * TBC
     */
    @Attribute
    Long queryUserCount;
    /**
     * TBC
     */
    @Attribute
    Map<String, Long> queryUserMap;
    /**
     * TBC
     */
    @Attribute
    String rawQuery;
    /**
     * TBC
     */
    @Attribute
    String rawQueryText;
    /**
     * TBC
     */
    @Attribute
    String schemaName;
    /**
     * TBC
     */
    @Attribute
    String schemaQualifiedName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    /**
     * TBC
     */
    @Attribute
    String tableName;
    /**
     * TBC
     */
    @Attribute
    String tableQualifiedName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ITable> tables;
    /**
     * TBC
     */
    @Attribute
    String variablesSchemaBase64;
    /**
     * TBC
     */
    @Attribute
    String viewName;
    /**
     * TBC
     */
    @Attribute
    String viewQualifiedName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IView> views;
    /**
     * TBC
     */
    @Attribute
    String visualBuilderSchemaBase64;

    /**
     * Builds the minimal object necessary to create a relationship to a AtlanQuery, from a potentially
     * more-complete AtlanQuery object.
     *
     * @return the minimal object necessary to relate to the AtlanQuery
     * @throws InvalidRequestException if any of the minimal set of required properties for a AtlanQuery relationship are not found in the initial object
     */
    @Override
    public AtlanQuery trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all AtlanQuery assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AtlanQuery assets will be included.
     *
     * @return a fluent search that includes all AtlanQuery assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all AtlanQuery assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AtlanQuery assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all AtlanQuery assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all AtlanQuery assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) AtlanQuerys will be included
     * @return a fluent search that includes all AtlanQuery assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all AtlanQuery assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) AtlanQuerys will be included
     * @return a fluent search that includes all AtlanQuery assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a AtlanQuery by GUID. Use this to create a relationship to this AtlanQuery,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the AtlanQuery to reference
     * @return reference to a AtlanQuery that can be used for defining a relationship to a AtlanQuery
     */
    public static AtlanQuery refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AtlanQuery by GUID. Use this to create a relationship to this AtlanQuery,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the AtlanQuery to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AtlanQuery that can be used for defining a relationship to a AtlanQuery
     */
    public static AtlanQuery refByGuid(String guid, Reference.SaveSemantic semantic) {
        return AtlanQuery._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a AtlanQuery by qualifiedName. Use this to create a relationship to this AtlanQuery,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the AtlanQuery to reference
     * @return reference to a AtlanQuery that can be used for defining a relationship to a AtlanQuery
     */
    public static AtlanQuery refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AtlanQuery by qualifiedName. Use this to create a relationship to this AtlanQuery,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the AtlanQuery to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AtlanQuery that can be used for defining a relationship to a AtlanQuery
     */
    public static AtlanQuery refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return AtlanQuery._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a AtlanQuery by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the AtlanQuery to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AtlanQuery, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AtlanQuery does not exist or the provided GUID is not a AtlanQuery
     */
    @JsonIgnore
    public static AtlanQuery get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a AtlanQuery by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AtlanQuery to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AtlanQuery, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AtlanQuery does not exist or the provided GUID is not a AtlanQuery
     */
    @JsonIgnore
    public static AtlanQuery get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a AtlanQuery by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AtlanQuery to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full AtlanQuery, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AtlanQuery does not exist or the provided GUID is not a AtlanQuery
     */
    @JsonIgnore
    public static AtlanQuery get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof AtlanQuery) {
                return (AtlanQuery) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof AtlanQuery) {
                return (AtlanQuery) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) AtlanQuery to active.
     *
     * @param qualifiedName for the AtlanQuery
     * @return true if the AtlanQuery is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) AtlanQuery to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the AtlanQuery
     * @return true if the AtlanQuery is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a Query.
     *
     * @param name of the Query
     * @param parentFolder in which the Query should be created, which must have at least
     *               a qualifiedName
     * @return the minimal request necessary to create the Query, as a builder
     * @throws InvalidRequestException if the parentFolder provided is without a qualifiedName
     */
    public static AtlanQueryBuilder<?, ?> creator(String name, Folder parentFolder) throws InvalidRequestException {
        validateRelationship(AtlanCollection.TYPE_NAME, Map.of("qualifiedName", parentFolder.getQualifiedName(), "collectionQualifiedName", parentFolder.getCollectionQualifiedName()));
        return creator(name, parentFolder.getCollectionQualifiedName(), parentFolder.getQualifiedName()).parent(parentFolder.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a Query.
     *
     * @param name of the Query
     * @param collection in which the Query should be created, which must have at least
     *               a qualifiedName
     * @return the minimal request necessary to create the Query, as a builder
     * @throws InvalidRequestException if the collection provided is without a qualifiedName
     */
    public static AtlanQueryBuilder<?, ?> creator(String name, AtlanCollection collection) throws InvalidRequestException {
        validateRelationship(AtlanCollection.TYPE_NAME, Map.of("qualifiedName", collection.getQualifiedName()));
        return creator(name, collection.getQualifiedName(), null).parent(collection.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a Query.
     *
     * @param name of the Query
     * @param collectionQualifiedName unique name of the AtlanCollection in which the Query should be created
     * @param parentFolderQualifiedName unique name of the Folder in which this Query should be created, or null if it should be created directly in the collection
     * @return the minimal request necessary to create the Query, as a builder
     */
    public static AtlanQueryBuilder<?, ?> creator(String name, String collectionQualifiedName, String parentFolderQualifiedName) {
        String qualifiedName = parentFolderQualifiedName == null ? generateQualifiedName(name, collectionQualifiedName) : generateQualifiedName(name, parentFolderQualifiedName);
        AtlanQueryBuilder<?, ?> builder = AtlanQuery._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).name(name).qualifiedName(qualifiedName).collectionQualifiedName(collectionQualifiedName).parentQualifiedName(collectionQualifiedName).parent(AtlanCollection.refByQualifiedName(collectionQualifiedName));
        if (parentFolderQualifiedName != null) {
            builder.parentQualifiedName(parentFolderQualifiedName).parent(Folder.refByQualifiedName(parentFolderQualifiedName));
        }
        return builder;
    }

    /**
     * Generate a unique Query.
     *
     * @param name of the Query
     * @param parentQualifiedName unique name of the collection or folder in which this Query exists
     * @return a unique name for the Query
     */
    public static String generateQualifiedName(String name, String parentQualifiedName) {
        return parentQualifiedName + "/" + name;
    }

    /**
     * Builds the minimal object necessary to update a AtlanQuery.
     *
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the parent collection the query is contained within
     * @param parentQualifiedName qualifiedName of the parent collection or folder the query is contained within
     * @return the minimal request necessary to update the AtlanQuery, as a builder
     */
    public static AtlanQueryBuilder<?, ?> updater(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) {
        INamespace parent;
        if (collectionQualifiedName.equals(parentQualifiedName)) {
            parent = AtlanCollection.refByQualifiedName(collectionQualifiedName);
        } else {
            parent = Folder.refByQualifiedName(parentQualifiedName);
        }
        return AtlanQuery._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name).parent(parent).parentQualifiedName(parentQualifiedName).collectionQualifiedName(collectionQualifiedName);
    }

    /**
     * Builds the minimal object necessary to apply an update to a AtlanQuery, from a potentially
     * more-complete AtlanQuery object.
     *
     * @return the minimal object necessary to update the AtlanQuery, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for AtlanQuery are not found in the initial object
     */
    @Override
    public AtlanQueryBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName(), "collectionQualifiedName", this.getCollectionQualifiedName(), "parentQualifiedName", this.getParentQualifiedName()));
        return updater(this.getQualifiedName(), this.getName(), this.getCollectionQualifiedName(), this.getParentQualifiedName());
    }


    public static abstract class AtlanQueryBuilder<C extends AtlanQuery, B extends AtlanQueryBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String calculationViewName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String calculationViewQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String collectionQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IColumn> columns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String databaseName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String databaseQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModel> dbtModels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtSource> dbtSources;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtTest> dbtTests;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String defaultDatabaseQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String defaultSchemaQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isPrivate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isProfiled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isSqlSnippet;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isVisualQuery;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long lastProfiledAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String longRawQuery;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private INamespace parent;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String parentQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryCountUpdatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryUserCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> queryUserMap$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Long> queryUserMap$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String rawQuery;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String rawQueryText;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtSource> sqlDBTSources;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModel> sqlDbtModels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ITable> tables;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String variablesSchemaBase64;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String viewName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String viewQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IView> views;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String visualBuilderSchemaBase64;
        private static final String DEFAULT_VARIABLE_SCHEMA = "{\"customvariablesDateTimeFormat\":{\"defaultDateFormat\":\"YYYY-MM-DD\",\"defaultTimeFormat\":\"HH:mm\"},\"customVariables\":[]}";

        public B withRawQuery(String schemaQualifiedName, String query) {
            String databaseQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(schemaQualifiedName);
            String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(databaseQualifiedName);
            AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
            return connectionName(connectorType.getValue()).connectionQualifiedName(connectionQualifiedName).connectorType(connectorType).defaultDatabaseQualifiedName(databaseQualifiedName).defaultSchemaQualifiedName(schemaQualifiedName).isVisualQuery(false).rawQueryText(query).variablesSchemaBase64(Base64.getEncoder().encodeToString(DEFAULT_VARIABLE_SCHEMA.getBytes(StandardCharsets.UTF_8)));
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AtlanQuery.AtlanQueryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AtlanQuery instance, final AtlanQuery.AtlanQueryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.calculationViewName(instance.calculationViewName);
            b.calculationViewQualifiedName(instance.calculationViewQualifiedName);
            b.collectionQualifiedName(instance.collectionQualifiedName);
            b.columns(instance.columns == null ? java.util.Collections.<IColumn>emptySortedSet() : instance.columns);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtModels(instance.dbtModels == null ? java.util.Collections.<IDbtModel>emptySortedSet() : instance.dbtModels);
            b.dbtSources(instance.dbtSources == null ? java.util.Collections.<IDbtSource>emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? java.util.Collections.<IDbtTest>emptySortedSet() : instance.dbtTests);
            b.defaultDatabaseQualifiedName(instance.defaultDatabaseQualifiedName);
            b.defaultSchemaQualifiedName(instance.defaultSchemaQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.isPrivate(instance.isPrivate);
            b.isProfiled(instance.isProfiled);
            b.isSqlSnippet(instance.isSqlSnippet);
            b.isVisualQuery(instance.isVisualQuery);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.longRawQuery(instance.longRawQuery);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.parent(instance.parent);
            b.parentQualifiedName(instance.parentQualifiedName);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? java.util.Collections.<String, Long>emptyMap() : instance.queryUserMap);
            b.rawQuery(instance.rawQuery);
            b.rawQueryText(instance.rawQueryText);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.sqlDBTSources(instance.sqlDBTSources == null ? java.util.Collections.<IDbtSource>emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? java.util.Collections.<IDbtModel>emptySortedSet() : instance.sqlDbtModels);
            b.tableName(instance.tableName);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.tables(instance.tables == null ? java.util.Collections.<ITable>emptySortedSet() : instance.tables);
            b.variablesSchemaBase64(instance.variablesSchemaBase64);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
            b.views(instance.views == null ? java.util.Collections.<IView>emptySortedSet() : instance.views);
            b.visualBuilderSchemaBase64(instance.visualBuilderSchemaBase64);
        }

        /**
         * Fixed typeName for AtlanQuerys.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationViewName(final String calculationViewName) {
            this.calculationViewName = calculationViewName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationViewQualifiedName(final String calculationViewQualifiedName) {
            this.calculationViewQualifiedName = calculationViewQualifiedName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B collectionQualifiedName(final String collectionQualifiedName) {
            this.collectionQualifiedName = collectionQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B column(final IColumn column) {
            if (this.columns == null) this.columns = new java.util.ArrayList<IColumn>();
            this.columns.add(column);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columns(final java.util.Collection<? extends IColumn> columns) {
            if (columns == null) {
                throw new java.lang.NullPointerException("columns cannot be null");
            }
            if (this.columns == null) this.columns = new java.util.ArrayList<IColumn>();
            this.columns.addAll(columns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumns() {
            if (this.columns != null) this.columns.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B databaseName(final String databaseName) {
            this.databaseName = databaseName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B databaseQualifiedName(final String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModel(final IDbtModel dbtModel) {
            if (this.dbtModels == null) this.dbtModels = new java.util.ArrayList<IDbtModel>();
            this.dbtModels.add(dbtModel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModels(final java.util.Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new java.lang.NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) this.dbtModels = new java.util.ArrayList<IDbtModel>();
            this.dbtModels.addAll(dbtModels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) this.dbtModels.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtSource(final IDbtSource dbtSource) {
            if (this.dbtSources == null) this.dbtSources = new java.util.ArrayList<IDbtSource>();
            this.dbtSources.add(dbtSource);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtSources(final java.util.Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new java.lang.NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) this.dbtSources = new java.util.ArrayList<IDbtSource>();
            this.dbtSources.addAll(dbtSources);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) this.dbtSources.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTest(final IDbtTest dbtTest) {
            if (this.dbtTests == null) this.dbtTests = new java.util.ArrayList<IDbtTest>();
            this.dbtTests.add(dbtTest);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTests(final java.util.Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new java.lang.NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) this.dbtTests = new java.util.ArrayList<IDbtTest>();
            this.dbtTests.addAll(dbtTests);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) this.dbtTests.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B defaultDatabaseQualifiedName(final String defaultDatabaseQualifiedName) {
            this.defaultDatabaseQualifiedName = defaultDatabaseQualifiedName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B defaultSchemaQualifiedName(final String defaultSchemaQualifiedName) {
            this.defaultSchemaQualifiedName = defaultSchemaQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isPrivate(final Boolean isPrivate) {
            this.isPrivate = isPrivate;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isProfiled(final Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isSqlSnippet(final Boolean isSqlSnippet) {
            this.isSqlSnippet = isSqlSnippet;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isVisualQuery(final Boolean isVisualQuery) {
            this.isVisualQuery = isVisualQuery;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lastProfiledAt(final Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B longRawQuery(final String longRawQuery) {
            this.longRawQuery = longRawQuery;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B parent(final INamespace parent) {
            this.parent = parent;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B parentQualifiedName(final String parentQualifiedName) {
            this.parentQualifiedName = parentQualifiedName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryCount(final Long queryCount) {
            this.queryCount = queryCount;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryCountUpdatedAt(final Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryUserCount(final Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putQueryUserMap(final String putQueryUserMapKey, final Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new java.util.ArrayList<String>();
                this.queryUserMap$value = new java.util.ArrayList<Long>();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryUserMap(final java.util.Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new java.lang.NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new java.util.ArrayList<String>();
                this.queryUserMap$value = new java.util.ArrayList<Long>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B rawQuery(final String rawQuery) {
            this.rawQuery = rawQuery;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B rawQueryText(final String rawQueryText) {
            this.rawQueryText = rawQueryText;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaName(final String schemaName) {
            this.schemaName = schemaName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaQualifiedName(final String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDBTSource(final IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) this.sqlDBTSources = new java.util.ArrayList<IDbtSource>();
            this.sqlDBTSources.add(sqlDBTSource);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDBTSources(final java.util.Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new java.lang.NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) this.sqlDBTSources = new java.util.ArrayList<IDbtSource>();
            this.sqlDBTSources.addAll(sqlDBTSources);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) this.sqlDBTSources.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDbtModel(final IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) this.sqlDbtModels = new java.util.ArrayList<IDbtModel>();
            this.sqlDbtModels.add(sqlDbtModel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDbtModels(final java.util.Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new java.lang.NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) this.sqlDbtModels = new java.util.ArrayList<IDbtModel>();
            this.sqlDbtModels.addAll(sqlDbtModels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) this.sqlDbtModels.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableName(final String tableName) {
            this.tableName = tableName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableQualifiedName(final String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B table(final ITable table) {
            if (this.tables == null) this.tables = new java.util.ArrayList<ITable>();
            this.tables.add(table);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tables(final java.util.Collection<? extends ITable> tables) {
            if (tables == null) {
                throw new java.lang.NullPointerException("tables cannot be null");
            }
            if (this.tables == null) this.tables = new java.util.ArrayList<ITable>();
            this.tables.addAll(tables);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTables() {
            if (this.tables != null) this.tables.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B variablesSchemaBase64(final String variablesSchemaBase64) {
            this.variablesSchemaBase64 = variablesSchemaBase64;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewName(final String viewName) {
            this.viewName = viewName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewQualifiedName(final String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B view(final IView view) {
            if (this.views == null) this.views = new java.util.ArrayList<IView>();
            this.views.add(view);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B views(final java.util.Collection<? extends IView> views) {
            if (views == null) {
                throw new java.lang.NullPointerException("views cannot be null");
            }
            if (this.views == null) this.views = new java.util.ArrayList<IView>();
            this.views.addAll(views);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearViews() {
            if (this.views != null) this.views.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B visualBuilderSchemaBase64(final String visualBuilderSchemaBase64) {
            this.visualBuilderSchemaBase64 = visualBuilderSchemaBase64;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanQuery.AtlanQueryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", calculationViewName=" + this.calculationViewName + ", calculationViewQualifiedName=" + this.calculationViewQualifiedName + ", collectionQualifiedName=" + this.collectionQualifiedName + ", columns=" + this.columns + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtModels=" + this.dbtModels + ", dbtSources=" + this.dbtSources + ", dbtTests=" + this.dbtTests + ", defaultDatabaseQualifiedName=" + this.defaultDatabaseQualifiedName + ", defaultSchemaQualifiedName=" + this.defaultSchemaQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isPrivate=" + this.isPrivate + ", isProfiled=" + this.isProfiled + ", isSqlSnippet=" + this.isSqlSnippet + ", isVisualQuery=" + this.isVisualQuery + ", lastProfiledAt=" + this.lastProfiledAt + ", longRawQuery=" + this.longRawQuery + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", parent=" + this.parent + ", parentQualifiedName=" + this.parentQualifiedName + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + this.queryUserMap$key + ", queryUserMap$value=" + this.queryUserMap$value + ", rawQuery=" + this.rawQuery + ", rawQueryText=" + this.rawQueryText + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", sqlDBTSources=" + this.sqlDBTSources + ", sqlDbtModels=" + this.sqlDbtModels + ", tableName=" + this.tableName + ", tableQualifiedName=" + this.tableQualifiedName + ", tables=" + this.tables + ", variablesSchemaBase64=" + this.variablesSchemaBase64 + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ", views=" + this.views + ", visualBuilderSchemaBase64=" + this.visualBuilderSchemaBase64 + ")";
        }
    }

    /**
     * Find a query by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the query, if found.
     *
     * @param name of the query
     * @return all queries with that name, if found
     * @throws AtlanException on any API problems
     * @throws NotFoundException if the query does not exist
     */
    public static List<AtlanQuery> findByName(String name) throws AtlanException {
        return findByName(name, (List<AtlanField>) null);
    }

    /**
     * Find a query by its human-readable name.
     *
     * @param name of the query
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the query
     * @return all queries with that name, if found
     * @throws AtlanException on any API problems
     * @throws NotFoundException if the query does not exist
     */
    public static List<AtlanQuery> findByName(String name, Collection<String> attributes) throws AtlanException {
        return findByName(Atlan.getDefaultClient(), name, attributes);
    }

    /**
     * Find a query by its human-readable name.
     *
     * @param name of the query
     * @param attributes an optional collection of attributes (checked) to retrieve for the query
     * @return all queries with that name, if found
     * @throws AtlanException on any API problems
     * @throws NotFoundException if the query does not exist
     */
    public static List<AtlanQuery> findByName(String name, List<AtlanField> attributes) throws AtlanException {
        return findByName(Atlan.getDefaultClient(), name, attributes);
    }

    /**
     * Find a query by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the query, if found.
     *
     * @param client connectivity to the Atlan tenant in which to search for the query
     * @param name of the query
     * @return all queries with that name, if found
     * @throws AtlanException on any API problems
     * @throws NotFoundException if the query does not exist
     */
    public static List<AtlanQuery> findByName(AtlanClient client, String name) throws AtlanException {
        return findByName(client, name, (List<AtlanField>) null);
    }

    /**
     * Find a query by its human-readable name.
     *
     * @param client connectivity to the Atlan tenant in which to search for the query
     * @param name of the query
     * @param attributes an optional collection of attributes to retrieve for the query
     * @return all queries with that name, if found
     * @throws AtlanException on any API problems
     * @throws NotFoundException if the query does not exist
     */
    public static List<AtlanQuery> findByName(AtlanClient client, String name, Collection<String> attributes) throws AtlanException {
        List<AtlanQuery> results = new ArrayList<>();
        AtlanQuery.select(client).where(NAME.eq(name))._includesOnResults(attributes == null ? Collections.emptyList() : attributes).stream().filter(a -> a instanceof AtlanQuery).forEach(q -> results.add((AtlanQuery) q));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.QUERY_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    /**
     * Find a query by its human-readable name.
     *
     * @param client connectivity to the Atlan tenant in which to search for the query
     * @param name of the query
     * @param attributes an optional collection of attributes (checked) to retrieve for the query
     * @return all queries with that name, if found
     * @throws AtlanException on any API problems
     * @throws NotFoundException if the query does not exist
     */
    public static List<AtlanQuery> findByName(AtlanClient client, String name, List<AtlanField> attributes) throws AtlanException {
        List<AtlanQuery> results = new ArrayList<>();
        AtlanQuery.select(client).where(NAME.eq(name)).includesOnResults(attributes == null ? Collections.emptyList() : attributes).stream().filter(a -> a instanceof AtlanQuery).forEach(q -> results.add((AtlanQuery) q));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.QUERY_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    /**
     * Remove the system description from a AtlanQuery.
     *
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @return the updated AtlanQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery removeDescription(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName);
    }

    /**
     * Remove the system description from a AtlanQuery.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AtlanQuery's description
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @return the updated AtlanQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery removeDescription(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return (AtlanQuery) Asset.removeDescription(client, updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName));
    }

    /**
     * Remove the user's description from a AtlanQuery.
     *
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @return the updated AtlanQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery removeUserDescription(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName);
    }

    /**
     * Remove the user's description from a AtlanQuery.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AtlanQuery's description
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @return the updated AtlanQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery removeUserDescription(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return (AtlanQuery) Asset.removeUserDescription(client, updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName));
    }

    /**
     * Remove the owners from a AtlanQuery.
     *
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @return the updated AtlanQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery removeOwners(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName);
    }

    /**
     * Remove the owners from a AtlanQuery.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AtlanQuery's owners
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @return the updated AtlanQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery removeOwners(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return (AtlanQuery) Asset.removeOwners(client, updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName));
    }

    /**
     * Update the certificate on a AtlanQuery.
     *
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AtlanQuery, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery updateCertificate(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a AtlanQuery.
     *
     * @param client connectivity to the Atlan tenant on which to update the AtlanQuery's certificate
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AtlanQuery, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery updateCertificate(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AtlanQuery) Asset.updateCertificate(client, updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName), certificate, message);
    }

    /**
     * Remove the certificate from a AtlanQuery.
     *
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @return the updated AtlanQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery removeCertificate(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName);
    }

    /**
     * Remove the certificate from a AtlanQuery.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AtlanQuery's certificate
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @return the updated AtlanQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery removeCertificate(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return (AtlanQuery) Asset.removeCertificate(client, updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName));
    }

    /**
     * Update the announcement on a AtlanQuery.
     *
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the updated AtlanQuery, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery updateAnnouncement(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a AtlanQuery.
     *
     * @param client connectivity to the Atlan tenant on which to update the AtlanQuery's announcement
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the updated AtlanQuery, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery updateAnnouncement(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AtlanQuery) Asset.updateAnnouncement(client, updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName), type, title, message);
    }

    /**
     * Remove the announcement from a AtlanQuery.
     *
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @return the updated AtlanQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery removeAnnouncement(String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name, collectionQualifiedName, parentQualifiedName);
    }

    /**
     * Remove the announcement from a AtlanQuery.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AtlanQuery's announcement
     * @param qualifiedName of the AtlanQuery
     * @param name of the AtlanQuery
     * @param collectionQualifiedName qualifiedName of the AtlanQuery's collection
     * @param parentQualifiedName qualifiedName of the AtlanQuery's parent namespace
     * @return the updated AtlanQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AtlanQuery removeAnnouncement(AtlanClient client, String qualifiedName, String name, String collectionQualifiedName, String parentQualifiedName) throws AtlanException {
        return (AtlanQuery) Asset.removeAnnouncement(client, updater(qualifiedName, name, collectionQualifiedName, parentQualifiedName));
    }

    /**
     * Add Atlan tags to a AtlanQuery, without replacing existing Atlan tags linked to the AtlanQuery.
     * Note: this operation must make two API calls — one to retrieve the AtlanQuery's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AtlanQuery
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AtlanQuery
     */
    public static AtlanQuery appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AtlanQuery, without replacing existing Atlan tags linked to the AtlanQuery.
     * Note: this operation must make two API calls — one to retrieve the AtlanQuery's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AtlanQuery
     * @param qualifiedName of the AtlanQuery
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AtlanQuery
     */
    public static AtlanQuery appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AtlanQuery) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AtlanQuery, without replacing existing Atlan tags linked to the AtlanQuery.
     * Note: this operation must make two API calls — one to retrieve the AtlanQuery's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AtlanQuery
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AtlanQuery
     */
    public static AtlanQuery appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a AtlanQuery, without replacing existing Atlan tags linked to the AtlanQuery.
     * Note: this operation must make two API calls — one to retrieve the AtlanQuery's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AtlanQuery
     * @param qualifiedName of the AtlanQuery
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AtlanQuery
     */
    public static AtlanQuery appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AtlanQuery) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a AtlanQuery.
     *
     * @param qualifiedName of the AtlanQuery
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AtlanQuery
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a AtlanQuery.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a AtlanQuery
     * @param qualifiedName of the AtlanQuery
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AtlanQuery
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AtlanQueryBuilderImpl extends AtlanQuery.AtlanQueryBuilder<AtlanQuery, AtlanQuery.AtlanQueryBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanQueryBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AtlanQuery.AtlanQueryBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanQuery build() {
            return new AtlanQuery(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AtlanQuery(final AtlanQuery.AtlanQueryBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = AtlanQuery.$default$typeName();
        this.calculationViewName = b.calculationViewName;
        this.calculationViewQualifiedName = b.calculationViewQualifiedName;
        this.collectionQualifiedName = b.collectionQualifiedName;
        java.util.SortedSet<IColumn> columns = new java.util.TreeSet<IColumn>();
        if (b.columns != null) columns.addAll(b.columns);
        columns = java.util.Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        java.util.SortedSet<IDbtModel> dbtModels = new java.util.TreeSet<IDbtModel>();
        if (b.dbtModels != null) dbtModels.addAll(b.dbtModels);
        dbtModels = java.util.Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        java.util.SortedSet<IDbtSource> dbtSources = new java.util.TreeSet<IDbtSource>();
        if (b.dbtSources != null) dbtSources.addAll(b.dbtSources);
        dbtSources = java.util.Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        java.util.SortedSet<IDbtTest> dbtTests = new java.util.TreeSet<IDbtTest>();
        if (b.dbtTests != null) dbtTests.addAll(b.dbtTests);
        dbtTests = java.util.Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        this.defaultDatabaseQualifiedName = b.defaultDatabaseQualifiedName;
        this.defaultSchemaQualifiedName = b.defaultSchemaQualifiedName;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isPrivate = b.isPrivate;
        this.isProfiled = b.isProfiled;
        this.isSqlSnippet = b.isSqlSnippet;
        this.isVisualQuery = b.isVisualQuery;
        this.lastProfiledAt = b.lastProfiledAt;
        this.longRawQuery = b.longRawQuery;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.parent = b.parent;
        this.parentQualifiedName = b.parentQualifiedName;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        this.queryUserCount = b.queryUserCount;
        java.util.Map<String, Long> queryUserMap;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
        case 0: 
            queryUserMap = java.util.Collections.emptyMap();
            break;
        case 1: 
            queryUserMap = java.util.Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
            break;
        default: 
            queryUserMap = new java.util.LinkedHashMap<String, Long>(b.queryUserMap$key.size() < 1073741824 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.queryUserMap$key.size(); $i++) queryUserMap.put(b.queryUserMap$key.get($i), (Long) b.queryUserMap$value.get($i));
            queryUserMap = java.util.Collections.unmodifiableMap(queryUserMap);
        }
        this.queryUserMap = queryUserMap;
        this.rawQuery = b.rawQuery;
        this.rawQueryText = b.rawQueryText;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        java.util.SortedSet<IDbtSource> sqlDBTSources = new java.util.TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) sqlDBTSources.addAll(b.sqlDBTSources);
        sqlDBTSources = java.util.Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        java.util.SortedSet<IDbtModel> sqlDbtModels = new java.util.TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) sqlDbtModels.addAll(b.sqlDbtModels);
        sqlDbtModels = java.util.Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.tableName = b.tableName;
        this.tableQualifiedName = b.tableQualifiedName;
        java.util.SortedSet<ITable> tables = new java.util.TreeSet<ITable>();
        if (b.tables != null) tables.addAll(b.tables);
        tables = java.util.Collections.unmodifiableSortedSet(tables);
        this.tables = tables;
        this.variablesSchemaBase64 = b.variablesSchemaBase64;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
        java.util.SortedSet<IView> views = new java.util.TreeSet<IView>();
        if (b.views != null) views.addAll(b.views);
        views = java.util.Collections.unmodifiableSortedSet(views);
        this.views = views;
        this.visualBuilderSchemaBase64 = b.visualBuilderSchemaBase64;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AtlanQuery.AtlanQueryBuilder<?, ?> _internal() {
        return new AtlanQuery.AtlanQueryBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanQuery.AtlanQueryBuilder<?, ?> toBuilder() {
        return new AtlanQuery.AtlanQueryBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCalculationViewName() {
        return this.calculationViewName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCalculationViewQualifiedName() {
        return this.calculationViewQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCollectionQualifiedName() {
        return this.collectionQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IColumn> getColumns() {
        return this.columns;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDefaultDatabaseQualifiedName() {
        return this.defaultDatabaseQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDefaultSchemaQualifiedName() {
        return this.defaultSchemaQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsSqlSnippet() {
        return this.isSqlSnippet;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsVisualQuery() {
        return this.isVisualQuery;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLongRawQuery() {
        return this.longRawQuery;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public INamespace getParent() {
        return this.parent;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getParentQualifiedName() {
        return this.parentQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryCount() {
        return this.queryCount;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRawQuery() {
        return this.rawQuery;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRawQueryText() {
        return this.rawQueryText;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableName() {
        return this.tableName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ITable> getTables() {
        return this.tables;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getVariablesSchemaBase64() {
        return this.variablesSchemaBase64;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getViewName() {
        return this.viewName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IView> getViews() {
        return this.views;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getVisualBuilderSchemaBase64() {
        return this.visualBuilderSchemaBase64;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanQuery)) return false;
        final AtlanQuery other = (AtlanQuery) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$isPrivate = this.getIsPrivate();
        final java.lang.Object other$isPrivate = other.getIsPrivate();
        if (this$isPrivate == null ? other$isPrivate != null : !this$isPrivate.equals(other$isPrivate)) return false;
        final java.lang.Object this$isProfiled = this.getIsProfiled();
        final java.lang.Object other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !this$isProfiled.equals(other$isProfiled)) return false;
        final java.lang.Object this$isSqlSnippet = this.getIsSqlSnippet();
        final java.lang.Object other$isSqlSnippet = other.getIsSqlSnippet();
        if (this$isSqlSnippet == null ? other$isSqlSnippet != null : !this$isSqlSnippet.equals(other$isSqlSnippet)) return false;
        final java.lang.Object this$isVisualQuery = this.getIsVisualQuery();
        final java.lang.Object other$isVisualQuery = other.getIsVisualQuery();
        if (this$isVisualQuery == null ? other$isVisualQuery != null : !this$isVisualQuery.equals(other$isVisualQuery)) return false;
        final java.lang.Object this$lastProfiledAt = this.getLastProfiledAt();
        final java.lang.Object other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !this$lastProfiledAt.equals(other$lastProfiledAt)) return false;
        final java.lang.Object this$queryCount = this.getQueryCount();
        final java.lang.Object other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !this$queryCount.equals(other$queryCount)) return false;
        final java.lang.Object this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        final java.lang.Object other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !this$queryCountUpdatedAt.equals(other$queryCountUpdatedAt)) return false;
        final java.lang.Object this$queryUserCount = this.getQueryUserCount();
        final java.lang.Object other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !this$queryUserCount.equals(other$queryUserCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$calculationViewName = this.getCalculationViewName();
        final java.lang.Object other$calculationViewName = other.getCalculationViewName();
        if (this$calculationViewName == null ? other$calculationViewName != null : !this$calculationViewName.equals(other$calculationViewName)) return false;
        final java.lang.Object this$calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        final java.lang.Object other$calculationViewQualifiedName = other.getCalculationViewQualifiedName();
        if (this$calculationViewQualifiedName == null ? other$calculationViewQualifiedName != null : !this$calculationViewQualifiedName.equals(other$calculationViewQualifiedName)) return false;
        final java.lang.Object this$collectionQualifiedName = this.getCollectionQualifiedName();
        final java.lang.Object other$collectionQualifiedName = other.getCollectionQualifiedName();
        if (this$collectionQualifiedName == null ? other$collectionQualifiedName != null : !this$collectionQualifiedName.equals(other$collectionQualifiedName)) return false;
        final java.lang.Object this$columns = this.getColumns();
        final java.lang.Object other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) return false;
        final java.lang.Object this$databaseName = this.getDatabaseName();
        final java.lang.Object other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) return false;
        final java.lang.Object this$databaseQualifiedName = this.getDatabaseQualifiedName();
        final java.lang.Object other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) return false;
        final java.lang.Object this$dbtModels = this.getDbtModels();
        final java.lang.Object other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) return false;
        final java.lang.Object this$dbtSources = this.getDbtSources();
        final java.lang.Object other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) return false;
        final java.lang.Object this$dbtTests = this.getDbtTests();
        final java.lang.Object other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) return false;
        final java.lang.Object this$defaultDatabaseQualifiedName = this.getDefaultDatabaseQualifiedName();
        final java.lang.Object other$defaultDatabaseQualifiedName = other.getDefaultDatabaseQualifiedName();
        if (this$defaultDatabaseQualifiedName == null ? other$defaultDatabaseQualifiedName != null : !this$defaultDatabaseQualifiedName.equals(other$defaultDatabaseQualifiedName)) return false;
        final java.lang.Object this$defaultSchemaQualifiedName = this.getDefaultSchemaQualifiedName();
        final java.lang.Object other$defaultSchemaQualifiedName = other.getDefaultSchemaQualifiedName();
        if (this$defaultSchemaQualifiedName == null ? other$defaultSchemaQualifiedName != null : !this$defaultSchemaQualifiedName.equals(other$defaultSchemaQualifiedName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$longRawQuery = this.getLongRawQuery();
        final java.lang.Object other$longRawQuery = other.getLongRawQuery();
        if (this$longRawQuery == null ? other$longRawQuery != null : !this$longRawQuery.equals(other$longRawQuery)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$parent = this.getParent();
        final java.lang.Object other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) return false;
        final java.lang.Object this$parentQualifiedName = this.getParentQualifiedName();
        final java.lang.Object other$parentQualifiedName = other.getParentQualifiedName();
        if (this$parentQualifiedName == null ? other$parentQualifiedName != null : !this$parentQualifiedName.equals(other$parentQualifiedName)) return false;
        final java.lang.Object this$queryUserMap = this.getQueryUserMap();
        final java.lang.Object other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !this$queryUserMap.equals(other$queryUserMap)) return false;
        final java.lang.Object this$rawQuery = this.getRawQuery();
        final java.lang.Object other$rawQuery = other.getRawQuery();
        if (this$rawQuery == null ? other$rawQuery != null : !this$rawQuery.equals(other$rawQuery)) return false;
        final java.lang.Object this$rawQueryText = this.getRawQueryText();
        final java.lang.Object other$rawQueryText = other.getRawQueryText();
        if (this$rawQueryText == null ? other$rawQueryText != null : !this$rawQueryText.equals(other$rawQueryText)) return false;
        final java.lang.Object this$schemaName = this.getSchemaName();
        final java.lang.Object other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) return false;
        final java.lang.Object this$schemaQualifiedName = this.getSchemaQualifiedName();
        final java.lang.Object other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) return false;
        final java.lang.Object this$sqlDBTSources = this.getSqlDBTSources();
        final java.lang.Object other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) return false;
        final java.lang.Object this$sqlDbtModels = this.getSqlDbtModels();
        final java.lang.Object other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) return false;
        final java.lang.Object this$tableName = this.getTableName();
        final java.lang.Object other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) return false;
        final java.lang.Object this$tableQualifiedName = this.getTableQualifiedName();
        final java.lang.Object other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) return false;
        final java.lang.Object this$tables = this.getTables();
        final java.lang.Object other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !this$tables.equals(other$tables)) return false;
        final java.lang.Object this$variablesSchemaBase64 = this.getVariablesSchemaBase64();
        final java.lang.Object other$variablesSchemaBase64 = other.getVariablesSchemaBase64();
        if (this$variablesSchemaBase64 == null ? other$variablesSchemaBase64 != null : !this$variablesSchemaBase64.equals(other$variablesSchemaBase64)) return false;
        final java.lang.Object this$viewName = this.getViewName();
        final java.lang.Object other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) return false;
        final java.lang.Object this$viewQualifiedName = this.getViewQualifiedName();
        final java.lang.Object other$viewQualifiedName = other.getViewQualifiedName();
        if (this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName)) return false;
        final java.lang.Object this$views = this.getViews();
        final java.lang.Object other$views = other.getViews();
        if (this$views == null ? other$views != null : !this$views.equals(other$views)) return false;
        final java.lang.Object this$visualBuilderSchemaBase64 = this.getVisualBuilderSchemaBase64();
        final java.lang.Object other$visualBuilderSchemaBase64 = other.getVisualBuilderSchemaBase64();
        if (this$visualBuilderSchemaBase64 == null ? other$visualBuilderSchemaBase64 != null : !this$visualBuilderSchemaBase64.equals(other$visualBuilderSchemaBase64)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AtlanQuery;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $isPrivate = this.getIsPrivate();
        result = result * PRIME + ($isPrivate == null ? 43 : $isPrivate.hashCode());
        final java.lang.Object $isProfiled = this.getIsProfiled();
        result = result * PRIME + ($isProfiled == null ? 43 : $isProfiled.hashCode());
        final java.lang.Object $isSqlSnippet = this.getIsSqlSnippet();
        result = result * PRIME + ($isSqlSnippet == null ? 43 : $isSqlSnippet.hashCode());
        final java.lang.Object $isVisualQuery = this.getIsVisualQuery();
        result = result * PRIME + ($isVisualQuery == null ? 43 : $isVisualQuery.hashCode());
        final java.lang.Object $lastProfiledAt = this.getLastProfiledAt();
        result = result * PRIME + ($lastProfiledAt == null ? 43 : $lastProfiledAt.hashCode());
        final java.lang.Object $queryCount = this.getQueryCount();
        result = result * PRIME + ($queryCount == null ? 43 : $queryCount.hashCode());
        final java.lang.Object $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * PRIME + ($queryCountUpdatedAt == null ? 43 : $queryCountUpdatedAt.hashCode());
        final java.lang.Object $queryUserCount = this.getQueryUserCount();
        result = result * PRIME + ($queryUserCount == null ? 43 : $queryUserCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $calculationViewName = this.getCalculationViewName();
        result = result * PRIME + ($calculationViewName == null ? 43 : $calculationViewName.hashCode());
        final java.lang.Object $calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        result = result * PRIME + ($calculationViewQualifiedName == null ? 43 : $calculationViewQualifiedName.hashCode());
        final java.lang.Object $collectionQualifiedName = this.getCollectionQualifiedName();
        result = result * PRIME + ($collectionQualifiedName == null ? 43 : $collectionQualifiedName.hashCode());
        final java.lang.Object $columns = this.getColumns();
        result = result * PRIME + ($columns == null ? 43 : $columns.hashCode());
        final java.lang.Object $databaseName = this.getDatabaseName();
        result = result * PRIME + ($databaseName == null ? 43 : $databaseName.hashCode());
        final java.lang.Object $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * PRIME + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        final java.lang.Object $dbtModels = this.getDbtModels();
        result = result * PRIME + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        final java.lang.Object $dbtSources = this.getDbtSources();
        result = result * PRIME + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        final java.lang.Object $dbtTests = this.getDbtTests();
        result = result * PRIME + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        final java.lang.Object $defaultDatabaseQualifiedName = this.getDefaultDatabaseQualifiedName();
        result = result * PRIME + ($defaultDatabaseQualifiedName == null ? 43 : $defaultDatabaseQualifiedName.hashCode());
        final java.lang.Object $defaultSchemaQualifiedName = this.getDefaultSchemaQualifiedName();
        result = result * PRIME + ($defaultSchemaQualifiedName == null ? 43 : $defaultSchemaQualifiedName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $longRawQuery = this.getLongRawQuery();
        result = result * PRIME + ($longRawQuery == null ? 43 : $longRawQuery.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $parent = this.getParent();
        result = result * PRIME + ($parent == null ? 43 : $parent.hashCode());
        final java.lang.Object $parentQualifiedName = this.getParentQualifiedName();
        result = result * PRIME + ($parentQualifiedName == null ? 43 : $parentQualifiedName.hashCode());
        final java.lang.Object $queryUserMap = this.getQueryUserMap();
        result = result * PRIME + ($queryUserMap == null ? 43 : $queryUserMap.hashCode());
        final java.lang.Object $rawQuery = this.getRawQuery();
        result = result * PRIME + ($rawQuery == null ? 43 : $rawQuery.hashCode());
        final java.lang.Object $rawQueryText = this.getRawQueryText();
        result = result * PRIME + ($rawQueryText == null ? 43 : $rawQueryText.hashCode());
        final java.lang.Object $schemaName = this.getSchemaName();
        result = result * PRIME + ($schemaName == null ? 43 : $schemaName.hashCode());
        final java.lang.Object $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * PRIME + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        final java.lang.Object $sqlDBTSources = this.getSqlDBTSources();
        result = result * PRIME + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        final java.lang.Object $sqlDbtModels = this.getSqlDbtModels();
        result = result * PRIME + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        final java.lang.Object $tableName = this.getTableName();
        result = result * PRIME + ($tableName == null ? 43 : $tableName.hashCode());
        final java.lang.Object $tableQualifiedName = this.getTableQualifiedName();
        result = result * PRIME + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        final java.lang.Object $tables = this.getTables();
        result = result * PRIME + ($tables == null ? 43 : $tables.hashCode());
        final java.lang.Object $variablesSchemaBase64 = this.getVariablesSchemaBase64();
        result = result * PRIME + ($variablesSchemaBase64 == null ? 43 : $variablesSchemaBase64.hashCode());
        final java.lang.Object $viewName = this.getViewName();
        result = result * PRIME + ($viewName == null ? 43 : $viewName.hashCode());
        final java.lang.Object $viewQualifiedName = this.getViewQualifiedName();
        result = result * PRIME + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        final java.lang.Object $views = this.getViews();
        result = result * PRIME + ($views == null ? 43 : $views.hashCode());
        final java.lang.Object $visualBuilderSchemaBase64 = this.getVisualBuilderSchemaBase64();
        result = result * PRIME + ($visualBuilderSchemaBase64 == null ? 43 : $visualBuilderSchemaBase64.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanQuery(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", calculationViewName=" + this.getCalculationViewName() + ", calculationViewQualifiedName=" + this.getCalculationViewQualifiedName() + ", collectionQualifiedName=" + this.getCollectionQualifiedName() + ", columns=" + this.getColumns() + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtModels=" + this.getDbtModels() + ", dbtSources=" + this.getDbtSources() + ", dbtTests=" + this.getDbtTests() + ", defaultDatabaseQualifiedName=" + this.getDefaultDatabaseQualifiedName() + ", defaultSchemaQualifiedName=" + this.getDefaultSchemaQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isPrivate=" + this.getIsPrivate() + ", isProfiled=" + this.getIsProfiled() + ", isSqlSnippet=" + this.getIsSqlSnippet() + ", isVisualQuery=" + this.getIsVisualQuery() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", longRawQuery=" + this.getLongRawQuery() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", parent=" + this.getParent() + ", parentQualifiedName=" + this.getParentQualifiedName() + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + this.getQueryUserMap() + ", rawQuery=" + this.getRawQuery() + ", rawQueryText=" + this.getRawQueryText() + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", sqlDBTSources=" + this.getSqlDBTSources() + ", sqlDbtModels=" + this.getSqlDbtModels() + ", tableName=" + this.getTableName() + ", tableQualifiedName=" + this.getTableQualifiedName() + ", tables=" + this.getTables() + ", variablesSchemaBase64=" + this.getVariablesSchemaBase64() + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ", views=" + this.getViews() + ", visualBuilderSchemaBase64=" + this.getVisualBuilderSchemaBase64() + ")";
    }

    /**
     * Fixed typeName for AtlanQuerys.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
