// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanPolicyAction;
import com.atlan.model.enums.AuthPolicyCategory;
import com.atlan.model.enums.AuthPolicyResourceCategory;
import com.atlan.model.enums.AuthPolicyType;
import com.atlan.model.enums.DataMaskingType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.AuthPolicyCondition;
import com.atlan.model.structs.AuthPolicyValiditySchedule;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Model to store an accesscontrol policy in Atlas
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class AuthPolicy extends Asset implements IAuthPolicy, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(AuthPolicy.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AuthPolicy";
    /**
     * Fixed typeName for AuthPolicys.
     */
    String typeName;
    /**
     * TBC
     */
    @Attribute
    IAccessControl accessControl;
    /**
     * TBC
     */
    @Attribute
    Boolean isPolicyEnabled;
    /**
     * TBC
     */
    @Attribute
    SortedSet<AtlanPolicyAction> policyActions;
    /**
     * TBC
     */
    @Attribute
    AuthPolicyCategory policyCategory;
    /**
     * TBC
     */
    @Attribute
    List<AuthPolicyCondition> policyConditions;
    /**
     * TBC
     */
    @Attribute
    Boolean policyDelegateAdmin;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> policyGroups;
    /**
     * TBC
     */
    @Attribute
    DataMaskingType policyMaskType;
    /**
     * TBC
     */
    @Attribute
    Integer policyPriority;
    /**
     * TBC
     */
    @Attribute
    AuthPolicyResourceCategory policyResourceCategory;
    /**
     * TBC
     */
    @Attribute
    String policyResourceSignature;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> policyResources;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> policyRoles;
    /**
     * TBC
     */
    @Attribute
    String policyServiceName;
    /**
     * TBC
     */
    @Attribute
    String policySubCategory;
    /**
     * TBC
     */
    @Attribute
    AuthPolicyType policyType;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> policyUsers;
    /**
     * TBC
     */
    @Attribute
    List<AuthPolicyValiditySchedule> policyValiditySchedule;

    /**
     * Builds the minimal object necessary to create a relationship to a AuthPolicy, from a potentially
     * more-complete AuthPolicy object.
     *
     * @return the minimal object necessary to relate to the AuthPolicy
     * @throws InvalidRequestException if any of the minimal set of required properties for a AuthPolicy relationship are not found in the initial object
     */
    @Override
    public AuthPolicy trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all AuthPolicy assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AuthPolicy assets will be included.
     *
     * @return a fluent search that includes all AuthPolicy assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all AuthPolicy assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AuthPolicy assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all AuthPolicy assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all AuthPolicy assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) AuthPolicys will be included
     * @return a fluent search that includes all AuthPolicy assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all AuthPolicy assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) AuthPolicys will be included
     * @return a fluent search that includes all AuthPolicy assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a AuthPolicy by GUID. Use this to create a relationship to this AuthPolicy,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the AuthPolicy to reference
     * @return reference to a AuthPolicy that can be used for defining a relationship to a AuthPolicy
     */
    public static AuthPolicy refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AuthPolicy by GUID. Use this to create a relationship to this AuthPolicy,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the AuthPolicy to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AuthPolicy that can be used for defining a relationship to a AuthPolicy
     */
    public static AuthPolicy refByGuid(String guid, Reference.SaveSemantic semantic) {
        return AuthPolicy._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a AuthPolicy by qualifiedName. Use this to create a relationship to this AuthPolicy,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the AuthPolicy to reference
     * @return reference to a AuthPolicy that can be used for defining a relationship to a AuthPolicy
     */
    public static AuthPolicy refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AuthPolicy by qualifiedName. Use this to create a relationship to this AuthPolicy,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the AuthPolicy to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AuthPolicy that can be used for defining a relationship to a AuthPolicy
     */
    public static AuthPolicy refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return AuthPolicy._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a AuthPolicy by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the AuthPolicy to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AuthPolicy, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AuthPolicy does not exist or the provided GUID is not a AuthPolicy
     */
    @JsonIgnore
    public static AuthPolicy get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a AuthPolicy by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AuthPolicy to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AuthPolicy, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AuthPolicy does not exist or the provided GUID is not a AuthPolicy
     */
    @JsonIgnore
    public static AuthPolicy get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a AuthPolicy by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AuthPolicy to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full AuthPolicy, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AuthPolicy does not exist or the provided GUID is not a AuthPolicy
     */
    @JsonIgnore
    public static AuthPolicy get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof AuthPolicy) {
                return (AuthPolicy) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof AuthPolicy) {
                return (AuthPolicy) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) AuthPolicy to active.
     *
     * @param qualifiedName for the AuthPolicy
     * @return true if the AuthPolicy is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) AuthPolicy to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the AuthPolicy
     * @return true if the AuthPolicy is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create an AuthPolicy.
     * Note: this method is only for internal use; for creating policies specific to a persona
     * or purpose, use the helper methods from those classes.
     *
     * @param name of the AuthPolicy
     * @return the minimal request necessary to create the AuthPolicy, as a builder
     * @see Persona#createMetadataPolicy(String, String, AuthPolicyType, Collection, String, Collection)
     * @see Persona#createDataPolicy(String, String, AuthPolicyType, String, Collection)
     * @see Persona#createGlossaryPolicy(String, String, AuthPolicyType, Collection, Collection)
     * @see Purpose#createMetadataPolicy(String, String, AuthPolicyType, Collection, Collection, Collection, boolean)
     * @see Purpose#createDataPolicy(String, String, AuthPolicyType, Collection, Collection, boolean)
     */
    public static AuthPolicyBuilder<?, ?> creator(String name) {
        return AuthPolicy._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(name).name(name).displayName("");
    }

    /**
     * Builds the minimal object necessary to apply an update to an AuthPolicy, from a potentially
     * more-complete AuthPolicy object.
     *
     * @return the minimal object necessary to update the AuthPolicy, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for AuthPolicy are not found in the initial object
     */
    @Override
    public AuthPolicyBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        throw new InvalidRequestException(ErrorCode.FULL_UPDATE_ONLY, "AuthPolicy");
    }

    /**
     * Add Atlan tags to a AuthPolicy, without replacing existing Atlan tags linked to the AuthPolicy.
     * Note: this operation must make two API calls — one to retrieve the AuthPolicy's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AuthPolicy
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AuthPolicy
     */
    public static AuthPolicy appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AuthPolicy, without replacing existing Atlan tags linked to the AuthPolicy.
     * Note: this operation must make two API calls — one to retrieve the AuthPolicy's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AuthPolicy
     * @param qualifiedName of the AuthPolicy
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AuthPolicy
     */
    public static AuthPolicy appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AuthPolicy) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AuthPolicy, without replacing existing Atlan tags linked to the AuthPolicy.
     * Note: this operation must make two API calls — one to retrieve the AuthPolicy's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AuthPolicy
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AuthPolicy
     */
    public static AuthPolicy appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a AuthPolicy, without replacing existing Atlan tags linked to the AuthPolicy.
     * Note: this operation must make two API calls — one to retrieve the AuthPolicy's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AuthPolicy
     * @param qualifiedName of the AuthPolicy
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AuthPolicy
     */
    public static AuthPolicy appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AuthPolicy) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a AuthPolicy.
     *
     * @param qualifiedName of the AuthPolicy
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AuthPolicy
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a AuthPolicy.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a AuthPolicy
     * @param qualifiedName of the AuthPolicy
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AuthPolicy
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AuthPolicyBuilder<C extends AuthPolicy, B extends AuthPolicy.AuthPolicyBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IAccessControl accessControl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isPolicyEnabled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AtlanPolicyAction> policyActions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AuthPolicyCategory policyCategory;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AuthPolicyCondition> policyConditions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean policyDelegateAdmin;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> policyGroups;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataMaskingType policyMaskType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer policyPriority;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AuthPolicyResourceCategory policyResourceCategory;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String policyResourceSignature;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> policyResources;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> policyRoles;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String policyServiceName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String policySubCategory;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AuthPolicyType policyType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> policyUsers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AuthPolicyValiditySchedule> policyValiditySchedule;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AuthPolicy.AuthPolicyBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AuthPolicy instance, final AuthPolicy.AuthPolicyBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.accessControl(instance.accessControl);
            b.isPolicyEnabled(instance.isPolicyEnabled);
            b.policyActions(instance.policyActions == null ? java.util.Collections.<AtlanPolicyAction>emptySortedSet() : instance.policyActions);
            b.policyCategory(instance.policyCategory);
            b.policyConditions(instance.policyConditions == null ? java.util.Collections.<AuthPolicyCondition>emptyList() : instance.policyConditions);
            b.policyDelegateAdmin(instance.policyDelegateAdmin);
            b.policyGroups(instance.policyGroups == null ? java.util.Collections.<String>emptySortedSet() : instance.policyGroups);
            b.policyMaskType(instance.policyMaskType);
            b.policyPriority(instance.policyPriority);
            b.policyResourceCategory(instance.policyResourceCategory);
            b.policyResourceSignature(instance.policyResourceSignature);
            b.policyResources(instance.policyResources == null ? java.util.Collections.<String>emptySortedSet() : instance.policyResources);
            b.policyRoles(instance.policyRoles == null ? java.util.Collections.<String>emptySortedSet() : instance.policyRoles);
            b.policyServiceName(instance.policyServiceName);
            b.policySubCategory(instance.policySubCategory);
            b.policyType(instance.policyType);
            b.policyUsers(instance.policyUsers == null ? java.util.Collections.<String>emptySortedSet() : instance.policyUsers);
            b.policyValiditySchedule(instance.policyValiditySchedule == null ? java.util.Collections.<AuthPolicyValiditySchedule>emptyList() : instance.policyValiditySchedule);
        }

        /**
         * Fixed typeName for AuthPolicys.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B accessControl(final IAccessControl accessControl) {
            this.accessControl = accessControl;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isPolicyEnabled(final Boolean isPolicyEnabled) {
            this.isPolicyEnabled = isPolicyEnabled;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyAction(final AtlanPolicyAction policyAction) {
            if (this.policyActions == null) this.policyActions = new java.util.ArrayList<AtlanPolicyAction>();
            this.policyActions.add(policyAction);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyActions(final java.util.Collection<? extends AtlanPolicyAction> policyActions) {
            if (policyActions == null) {
                throw new java.lang.NullPointerException("policyActions cannot be null");
            }
            if (this.policyActions == null) this.policyActions = new java.util.ArrayList<AtlanPolicyAction>();
            this.policyActions.addAll(policyActions);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPolicyActions() {
            if (this.policyActions != null) this.policyActions.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyCategory(final AuthPolicyCategory policyCategory) {
            this.policyCategory = policyCategory;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyCondition(final AuthPolicyCondition policyCondition) {
            if (this.policyConditions == null) this.policyConditions = new java.util.ArrayList<AuthPolicyCondition>();
            this.policyConditions.add(policyCondition);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyConditions(final java.util.Collection<? extends AuthPolicyCondition> policyConditions) {
            if (policyConditions == null) {
                throw new java.lang.NullPointerException("policyConditions cannot be null");
            }
            if (this.policyConditions == null) this.policyConditions = new java.util.ArrayList<AuthPolicyCondition>();
            this.policyConditions.addAll(policyConditions);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPolicyConditions() {
            if (this.policyConditions != null) this.policyConditions.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyDelegateAdmin(final Boolean policyDelegateAdmin) {
            this.policyDelegateAdmin = policyDelegateAdmin;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyGroup(final String policyGroup) {
            if (this.policyGroups == null) this.policyGroups = new java.util.ArrayList<String>();
            this.policyGroups.add(policyGroup);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyGroups(final java.util.Collection<? extends String> policyGroups) {
            if (policyGroups == null) {
                throw new java.lang.NullPointerException("policyGroups cannot be null");
            }
            if (this.policyGroups == null) this.policyGroups = new java.util.ArrayList<String>();
            this.policyGroups.addAll(policyGroups);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPolicyGroups() {
            if (this.policyGroups != null) this.policyGroups.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyMaskType(final DataMaskingType policyMaskType) {
            this.policyMaskType = policyMaskType;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyPriority(final Integer policyPriority) {
            this.policyPriority = policyPriority;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyResourceCategory(final AuthPolicyResourceCategory policyResourceCategory) {
            this.policyResourceCategory = policyResourceCategory;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyResourceSignature(final String policyResourceSignature) {
            this.policyResourceSignature = policyResourceSignature;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyResource(final String policyResource) {
            if (this.policyResources == null) this.policyResources = new java.util.ArrayList<String>();
            this.policyResources.add(policyResource);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyResources(final java.util.Collection<? extends String> policyResources) {
            if (policyResources == null) {
                throw new java.lang.NullPointerException("policyResources cannot be null");
            }
            if (this.policyResources == null) this.policyResources = new java.util.ArrayList<String>();
            this.policyResources.addAll(policyResources);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPolicyResources() {
            if (this.policyResources != null) this.policyResources.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyRole(final String policyRole) {
            if (this.policyRoles == null) this.policyRoles = new java.util.ArrayList<String>();
            this.policyRoles.add(policyRole);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyRoles(final java.util.Collection<? extends String> policyRoles) {
            if (policyRoles == null) {
                throw new java.lang.NullPointerException("policyRoles cannot be null");
            }
            if (this.policyRoles == null) this.policyRoles = new java.util.ArrayList<String>();
            this.policyRoles.addAll(policyRoles);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPolicyRoles() {
            if (this.policyRoles != null) this.policyRoles.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyServiceName(final String policyServiceName) {
            this.policyServiceName = policyServiceName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policySubCategory(final String policySubCategory) {
            this.policySubCategory = policySubCategory;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyType(final AuthPolicyType policyType) {
            this.policyType = policyType;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyUser(final String policyUser) {
            if (this.policyUsers == null) this.policyUsers = new java.util.ArrayList<String>();
            this.policyUsers.add(policyUser);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyUsers(final java.util.Collection<? extends String> policyUsers) {
            if (policyUsers == null) {
                throw new java.lang.NullPointerException("policyUsers cannot be null");
            }
            if (this.policyUsers == null) this.policyUsers = new java.util.ArrayList<String>();
            this.policyUsers.addAll(policyUsers);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPolicyUsers() {
            if (this.policyUsers != null) this.policyUsers.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B addPolicyValiditySchedule(final AuthPolicyValiditySchedule addPolicyValiditySchedule) {
            if (this.policyValiditySchedule == null) this.policyValiditySchedule = new java.util.ArrayList<AuthPolicyValiditySchedule>();
            this.policyValiditySchedule.add(addPolicyValiditySchedule);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policyValiditySchedule(final java.util.Collection<? extends AuthPolicyValiditySchedule> policyValiditySchedule) {
            if (policyValiditySchedule == null) {
                throw new java.lang.NullPointerException("policyValiditySchedule cannot be null");
            }
            if (this.policyValiditySchedule == null) this.policyValiditySchedule = new java.util.ArrayList<AuthPolicyValiditySchedule>();
            this.policyValiditySchedule.addAll(policyValiditySchedule);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPolicyValiditySchedule() {
            if (this.policyValiditySchedule != null) this.policyValiditySchedule.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AuthPolicy.AuthPolicyBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", accessControl=" + this.accessControl + ", isPolicyEnabled=" + this.isPolicyEnabled + ", policyActions=" + this.policyActions + ", policyCategory=" + this.policyCategory + ", policyConditions=" + this.policyConditions + ", policyDelegateAdmin=" + this.policyDelegateAdmin + ", policyGroups=" + this.policyGroups + ", policyMaskType=" + this.policyMaskType + ", policyPriority=" + this.policyPriority + ", policyResourceCategory=" + this.policyResourceCategory + ", policyResourceSignature=" + this.policyResourceSignature + ", policyResources=" + this.policyResources + ", policyRoles=" + this.policyRoles + ", policyServiceName=" + this.policyServiceName + ", policySubCategory=" + this.policySubCategory + ", policyType=" + this.policyType + ", policyUsers=" + this.policyUsers + ", policyValiditySchedule=" + this.policyValiditySchedule + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AuthPolicyBuilderImpl extends AuthPolicy.AuthPolicyBuilder<AuthPolicy, AuthPolicy.AuthPolicyBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AuthPolicyBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AuthPolicy.AuthPolicyBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthPolicy build() {
            return new AuthPolicy(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AuthPolicy(final AuthPolicy.AuthPolicyBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = AuthPolicy.$default$typeName();
        this.accessControl = b.accessControl;
        this.isPolicyEnabled = b.isPolicyEnabled;
        java.util.SortedSet<AtlanPolicyAction> policyActions = new java.util.TreeSet<AtlanPolicyAction>();
        if (b.policyActions != null) policyActions.addAll(b.policyActions);
        policyActions = java.util.Collections.unmodifiableSortedSet(policyActions);
        this.policyActions = policyActions;
        this.policyCategory = b.policyCategory;
        java.util.List<AuthPolicyCondition> policyConditions;
        switch (b.policyConditions == null ? 0 : b.policyConditions.size()) {
        case 0: 
            policyConditions = java.util.Collections.emptyList();
            break;
        case 1: 
            policyConditions = java.util.Collections.singletonList(b.policyConditions.get(0));
            break;
        default: 
            policyConditions = java.util.Collections.unmodifiableList(new java.util.ArrayList<AuthPolicyCondition>(b.policyConditions));
        }
        this.policyConditions = policyConditions;
        this.policyDelegateAdmin = b.policyDelegateAdmin;
        java.util.SortedSet<String> policyGroups = new java.util.TreeSet<String>();
        if (b.policyGroups != null) policyGroups.addAll(b.policyGroups);
        policyGroups = java.util.Collections.unmodifiableSortedSet(policyGroups);
        this.policyGroups = policyGroups;
        this.policyMaskType = b.policyMaskType;
        this.policyPriority = b.policyPriority;
        this.policyResourceCategory = b.policyResourceCategory;
        this.policyResourceSignature = b.policyResourceSignature;
        java.util.SortedSet<String> policyResources = new java.util.TreeSet<String>();
        if (b.policyResources != null) policyResources.addAll(b.policyResources);
        policyResources = java.util.Collections.unmodifiableSortedSet(policyResources);
        this.policyResources = policyResources;
        java.util.SortedSet<String> policyRoles = new java.util.TreeSet<String>();
        if (b.policyRoles != null) policyRoles.addAll(b.policyRoles);
        policyRoles = java.util.Collections.unmodifiableSortedSet(policyRoles);
        this.policyRoles = policyRoles;
        this.policyServiceName = b.policyServiceName;
        this.policySubCategory = b.policySubCategory;
        this.policyType = b.policyType;
        java.util.SortedSet<String> policyUsers = new java.util.TreeSet<String>();
        if (b.policyUsers != null) policyUsers.addAll(b.policyUsers);
        policyUsers = java.util.Collections.unmodifiableSortedSet(policyUsers);
        this.policyUsers = policyUsers;
        java.util.List<AuthPolicyValiditySchedule> policyValiditySchedule;
        switch (b.policyValiditySchedule == null ? 0 : b.policyValiditySchedule.size()) {
        case 0: 
            policyValiditySchedule = java.util.Collections.emptyList();
            break;
        case 1: 
            policyValiditySchedule = java.util.Collections.singletonList(b.policyValiditySchedule.get(0));
            break;
        default: 
            policyValiditySchedule = java.util.Collections.unmodifiableList(new java.util.ArrayList<AuthPolicyValiditySchedule>(b.policyValiditySchedule));
        }
        this.policyValiditySchedule = policyValiditySchedule;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AuthPolicy.AuthPolicyBuilder<?, ?> _internal() {
        return new AuthPolicy.AuthPolicyBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthPolicy.AuthPolicyBuilder<?, ?> toBuilder() {
        return new AuthPolicy.AuthPolicyBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IAccessControl getAccessControl() {
        return this.accessControl;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsPolicyEnabled() {
        return this.isPolicyEnabled;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<AtlanPolicyAction> getPolicyActions() {
        return this.policyActions;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthPolicyCategory getPolicyCategory() {
        return this.policyCategory;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<AuthPolicyCondition> getPolicyConditions() {
        return this.policyConditions;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPolicyDelegateAdmin() {
        return this.policyDelegateAdmin;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getPolicyGroups() {
        return this.policyGroups;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataMaskingType getPolicyMaskType() {
        return this.policyMaskType;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getPolicyPriority() {
        return this.policyPriority;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthPolicyResourceCategory getPolicyResourceCategory() {
        return this.policyResourceCategory;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPolicyResourceSignature() {
        return this.policyResourceSignature;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getPolicyResources() {
        return this.policyResources;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getPolicyRoles() {
        return this.policyRoles;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPolicyServiceName() {
        return this.policyServiceName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPolicySubCategory() {
        return this.policySubCategory;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthPolicyType getPolicyType() {
        return this.policyType;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getPolicyUsers() {
        return this.policyUsers;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<AuthPolicyValiditySchedule> getPolicyValiditySchedule() {
        return this.policyValiditySchedule;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AuthPolicy)) return false;
        final AuthPolicy other = (AuthPolicy) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$isPolicyEnabled = this.getIsPolicyEnabled();
        final java.lang.Object other$isPolicyEnabled = other.getIsPolicyEnabled();
        if (this$isPolicyEnabled == null ? other$isPolicyEnabled != null : !this$isPolicyEnabled.equals(other$isPolicyEnabled)) return false;
        final java.lang.Object this$policyDelegateAdmin = this.getPolicyDelegateAdmin();
        final java.lang.Object other$policyDelegateAdmin = other.getPolicyDelegateAdmin();
        if (this$policyDelegateAdmin == null ? other$policyDelegateAdmin != null : !this$policyDelegateAdmin.equals(other$policyDelegateAdmin)) return false;
        final java.lang.Object this$policyPriority = this.getPolicyPriority();
        final java.lang.Object other$policyPriority = other.getPolicyPriority();
        if (this$policyPriority == null ? other$policyPriority != null : !this$policyPriority.equals(other$policyPriority)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$accessControl = this.getAccessControl();
        final java.lang.Object other$accessControl = other.getAccessControl();
        if (this$accessControl == null ? other$accessControl != null : !this$accessControl.equals(other$accessControl)) return false;
        final java.lang.Object this$policyActions = this.getPolicyActions();
        final java.lang.Object other$policyActions = other.getPolicyActions();
        if (this$policyActions == null ? other$policyActions != null : !this$policyActions.equals(other$policyActions)) return false;
        final java.lang.Object this$policyCategory = this.getPolicyCategory();
        final java.lang.Object other$policyCategory = other.getPolicyCategory();
        if (this$policyCategory == null ? other$policyCategory != null : !this$policyCategory.equals(other$policyCategory)) return false;
        final java.lang.Object this$policyConditions = this.getPolicyConditions();
        final java.lang.Object other$policyConditions = other.getPolicyConditions();
        if (this$policyConditions == null ? other$policyConditions != null : !this$policyConditions.equals(other$policyConditions)) return false;
        final java.lang.Object this$policyGroups = this.getPolicyGroups();
        final java.lang.Object other$policyGroups = other.getPolicyGroups();
        if (this$policyGroups == null ? other$policyGroups != null : !this$policyGroups.equals(other$policyGroups)) return false;
        final java.lang.Object this$policyMaskType = this.getPolicyMaskType();
        final java.lang.Object other$policyMaskType = other.getPolicyMaskType();
        if (this$policyMaskType == null ? other$policyMaskType != null : !this$policyMaskType.equals(other$policyMaskType)) return false;
        final java.lang.Object this$policyResourceCategory = this.getPolicyResourceCategory();
        final java.lang.Object other$policyResourceCategory = other.getPolicyResourceCategory();
        if (this$policyResourceCategory == null ? other$policyResourceCategory != null : !this$policyResourceCategory.equals(other$policyResourceCategory)) return false;
        final java.lang.Object this$policyResourceSignature = this.getPolicyResourceSignature();
        final java.lang.Object other$policyResourceSignature = other.getPolicyResourceSignature();
        if (this$policyResourceSignature == null ? other$policyResourceSignature != null : !this$policyResourceSignature.equals(other$policyResourceSignature)) return false;
        final java.lang.Object this$policyResources = this.getPolicyResources();
        final java.lang.Object other$policyResources = other.getPolicyResources();
        if (this$policyResources == null ? other$policyResources != null : !this$policyResources.equals(other$policyResources)) return false;
        final java.lang.Object this$policyRoles = this.getPolicyRoles();
        final java.lang.Object other$policyRoles = other.getPolicyRoles();
        if (this$policyRoles == null ? other$policyRoles != null : !this$policyRoles.equals(other$policyRoles)) return false;
        final java.lang.Object this$policyServiceName = this.getPolicyServiceName();
        final java.lang.Object other$policyServiceName = other.getPolicyServiceName();
        if (this$policyServiceName == null ? other$policyServiceName != null : !this$policyServiceName.equals(other$policyServiceName)) return false;
        final java.lang.Object this$policySubCategory = this.getPolicySubCategory();
        final java.lang.Object other$policySubCategory = other.getPolicySubCategory();
        if (this$policySubCategory == null ? other$policySubCategory != null : !this$policySubCategory.equals(other$policySubCategory)) return false;
        final java.lang.Object this$policyType = this.getPolicyType();
        final java.lang.Object other$policyType = other.getPolicyType();
        if (this$policyType == null ? other$policyType != null : !this$policyType.equals(other$policyType)) return false;
        final java.lang.Object this$policyUsers = this.getPolicyUsers();
        final java.lang.Object other$policyUsers = other.getPolicyUsers();
        if (this$policyUsers == null ? other$policyUsers != null : !this$policyUsers.equals(other$policyUsers)) return false;
        final java.lang.Object this$policyValiditySchedule = this.getPolicyValiditySchedule();
        final java.lang.Object other$policyValiditySchedule = other.getPolicyValiditySchedule();
        if (this$policyValiditySchedule == null ? other$policyValiditySchedule != null : !this$policyValiditySchedule.equals(other$policyValiditySchedule)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AuthPolicy;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $isPolicyEnabled = this.getIsPolicyEnabled();
        result = result * PRIME + ($isPolicyEnabled == null ? 43 : $isPolicyEnabled.hashCode());
        final java.lang.Object $policyDelegateAdmin = this.getPolicyDelegateAdmin();
        result = result * PRIME + ($policyDelegateAdmin == null ? 43 : $policyDelegateAdmin.hashCode());
        final java.lang.Object $policyPriority = this.getPolicyPriority();
        result = result * PRIME + ($policyPriority == null ? 43 : $policyPriority.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $accessControl = this.getAccessControl();
        result = result * PRIME + ($accessControl == null ? 43 : $accessControl.hashCode());
        final java.lang.Object $policyActions = this.getPolicyActions();
        result = result * PRIME + ($policyActions == null ? 43 : $policyActions.hashCode());
        final java.lang.Object $policyCategory = this.getPolicyCategory();
        result = result * PRIME + ($policyCategory == null ? 43 : $policyCategory.hashCode());
        final java.lang.Object $policyConditions = this.getPolicyConditions();
        result = result * PRIME + ($policyConditions == null ? 43 : $policyConditions.hashCode());
        final java.lang.Object $policyGroups = this.getPolicyGroups();
        result = result * PRIME + ($policyGroups == null ? 43 : $policyGroups.hashCode());
        final java.lang.Object $policyMaskType = this.getPolicyMaskType();
        result = result * PRIME + ($policyMaskType == null ? 43 : $policyMaskType.hashCode());
        final java.lang.Object $policyResourceCategory = this.getPolicyResourceCategory();
        result = result * PRIME + ($policyResourceCategory == null ? 43 : $policyResourceCategory.hashCode());
        final java.lang.Object $policyResourceSignature = this.getPolicyResourceSignature();
        result = result * PRIME + ($policyResourceSignature == null ? 43 : $policyResourceSignature.hashCode());
        final java.lang.Object $policyResources = this.getPolicyResources();
        result = result * PRIME + ($policyResources == null ? 43 : $policyResources.hashCode());
        final java.lang.Object $policyRoles = this.getPolicyRoles();
        result = result * PRIME + ($policyRoles == null ? 43 : $policyRoles.hashCode());
        final java.lang.Object $policyServiceName = this.getPolicyServiceName();
        result = result * PRIME + ($policyServiceName == null ? 43 : $policyServiceName.hashCode());
        final java.lang.Object $policySubCategory = this.getPolicySubCategory();
        result = result * PRIME + ($policySubCategory == null ? 43 : $policySubCategory.hashCode());
        final java.lang.Object $policyType = this.getPolicyType();
        result = result * PRIME + ($policyType == null ? 43 : $policyType.hashCode());
        final java.lang.Object $policyUsers = this.getPolicyUsers();
        result = result * PRIME + ($policyUsers == null ? 43 : $policyUsers.hashCode());
        final java.lang.Object $policyValiditySchedule = this.getPolicyValiditySchedule();
        result = result * PRIME + ($policyValiditySchedule == null ? 43 : $policyValiditySchedule.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AuthPolicy(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", accessControl=" + this.getAccessControl() + ", isPolicyEnabled=" + this.getIsPolicyEnabled() + ", policyActions=" + this.getPolicyActions() + ", policyCategory=" + this.getPolicyCategory() + ", policyConditions=" + this.getPolicyConditions() + ", policyDelegateAdmin=" + this.getPolicyDelegateAdmin() + ", policyGroups=" + this.getPolicyGroups() + ", policyMaskType=" + this.getPolicyMaskType() + ", policyPriority=" + this.getPolicyPriority() + ", policyResourceCategory=" + this.getPolicyResourceCategory() + ", policyResourceSignature=" + this.getPolicyResourceSignature() + ", policyResources=" + this.getPolicyResources() + ", policyRoles=" + this.getPolicyRoles() + ", policyServiceName=" + this.getPolicyServiceName() + ", policySubCategory=" + this.getPolicySubCategory() + ", policyType=" + this.getPolicyType() + ", policyUsers=" + this.getPolicyUsers() + ", policyValiditySchedule=" + this.getPolicyValiditySchedule() + ")";
    }

    /**
     * Fixed typeName for AuthPolicys.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
