// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Model to store auth service in Atlas
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class AuthService extends Asset implements IAuthService, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(AuthService.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AuthService";
    /**
     * Fixed typeName for AuthServices.
     */
    String typeName;
    /**
     * TBC
     */
    @Attribute
    Map<String, String> authServiceConfig;
    /**
     * TBC
     */
    @Attribute
    Boolean authServiceIsEnabled;
    /**
     * TBC
     */
    @Attribute
    Long authServicePolicyLastSync;
    /**
     * TBC
     */
    @Attribute
    String authServiceType;
    /**
     * TBC
     */
    @Attribute
    String tagService;

    /**
     * Builds the minimal object necessary to create a relationship to a AuthService, from a potentially
     * more-complete AuthService object.
     *
     * @return the minimal object necessary to relate to the AuthService
     * @throws InvalidRequestException if any of the minimal set of required properties for a AuthService relationship are not found in the initial object
     */
    @Override
    public AuthService trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all AuthService assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AuthService assets will be included.
     *
     * @return a fluent search that includes all AuthService assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all AuthService assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AuthService assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all AuthService assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all AuthService assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) AuthServices will be included
     * @return a fluent search that includes all AuthService assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all AuthService assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) AuthServices will be included
     * @return a fluent search that includes all AuthService assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a AuthService by GUID. Use this to create a relationship to this AuthService,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the AuthService to reference
     * @return reference to a AuthService that can be used for defining a relationship to a AuthService
     */
    public static AuthService refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AuthService by GUID. Use this to create a relationship to this AuthService,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the AuthService to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AuthService that can be used for defining a relationship to a AuthService
     */
    public static AuthService refByGuid(String guid, Reference.SaveSemantic semantic) {
        return AuthService._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a AuthService by qualifiedName. Use this to create a relationship to this AuthService,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the AuthService to reference
     * @return reference to a AuthService that can be used for defining a relationship to a AuthService
     */
    public static AuthService refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AuthService by qualifiedName. Use this to create a relationship to this AuthService,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the AuthService to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AuthService that can be used for defining a relationship to a AuthService
     */
    public static AuthService refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return AuthService._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a AuthService by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the AuthService to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AuthService, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AuthService does not exist or the provided GUID is not a AuthService
     */
    @JsonIgnore
    public static AuthService get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a AuthService by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AuthService to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AuthService, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AuthService does not exist or the provided GUID is not a AuthService
     */
    @JsonIgnore
    public static AuthService get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a AuthService by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AuthService to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full AuthService, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AuthService does not exist or the provided GUID is not a AuthService
     */
    @JsonIgnore
    public static AuthService get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof AuthService) {
                return (AuthService) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof AuthService) {
                return (AuthService) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) AuthService to active.
     *
     * @param qualifiedName for the AuthService
     * @return true if the AuthService is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) AuthService to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the AuthService
     * @return true if the AuthService is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a AuthService.
     *
     * @param qualifiedName of the AuthService
     * @param name of the AuthService
     * @return the minimal request necessary to update the AuthService, as a builder
     */
    public static AuthServiceBuilder<?, ?> updater(String qualifiedName, String name) {
        return AuthService._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a AuthService, from a potentially
     * more-complete AuthService object.
     *
     * @return the minimal object necessary to update the AuthService, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for AuthService are not found in the initial object
     */
    @Override
    public AuthServiceBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a AuthService.
     *
     * @param qualifiedName of the AuthService
     * @param name of the AuthService
     * @return the updated AuthService, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AuthService removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a AuthService.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the AuthService
     * @param name of the AuthService
     * @return the updated AuthService, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AuthService removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AuthService) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a AuthService.
     *
     * @param qualifiedName of the AuthService
     * @param name of the AuthService
     * @return the updated AuthService, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AuthService removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a AuthService.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the AuthService
     * @param name of the AuthService
     * @return the updated AuthService, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AuthService removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AuthService) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a AuthService.
     *
     * @param qualifiedName of the AuthService
     * @param name of the AuthService
     * @return the updated AuthService, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AuthService removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a AuthService.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AuthService's owners
     * @param qualifiedName of the AuthService
     * @param name of the AuthService
     * @return the updated AuthService, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AuthService removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AuthService) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a AuthService.
     *
     * @param qualifiedName of the AuthService
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AuthService, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AuthService updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a AuthService.
     *
     * @param client connectivity to the Atlan tenant on which to update the AuthService's certificate
     * @param qualifiedName of the AuthService
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AuthService, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AuthService updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AuthService) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a AuthService.
     *
     * @param qualifiedName of the AuthService
     * @param name of the AuthService
     * @return the updated AuthService, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AuthService removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a AuthService.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AuthService's certificate
     * @param qualifiedName of the AuthService
     * @param name of the AuthService
     * @return the updated AuthService, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AuthService removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AuthService) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a AuthService.
     *
     * @param qualifiedName of the AuthService
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AuthService updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a AuthService.
     *
     * @param client connectivity to the Atlan tenant on which to update the AuthService's announcement
     * @param qualifiedName of the AuthService
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AuthService updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AuthService) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a AuthService.
     *
     * @param qualifiedName of the AuthService
     * @param name of the AuthService
     * @return the updated AuthService, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AuthService removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a AuthService.
     *
     * @param client connectivity to the Atlan client from which to remove the AuthService's announcement
     * @param qualifiedName of the AuthService
     * @param name of the AuthService
     * @return the updated AuthService, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AuthService removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AuthService) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the AuthService.
     *
     * @param qualifiedName for the AuthService
     * @param name human-readable name of the AuthService
     * @param terms the list of terms to replace on the AuthService, or null to remove all terms from the AuthService
     * @return the AuthService that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static AuthService replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the AuthService.
     *
     * @param client connectivity to the Atlan tenant on which to replace the AuthService's assigned terms
     * @param qualifiedName for the AuthService
     * @param name human-readable name of the AuthService
     * @param terms the list of terms to replace on the AuthService, or null to remove all terms from the AuthService
     * @return the AuthService that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static AuthService replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AuthService) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the AuthService, without replacing existing terms linked to the AuthService.
     * Note: this operation must make two API calls — one to retrieve the AuthService's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the AuthService
     * @param terms the list of terms to append to the AuthService
     * @return the AuthService that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static AuthService appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the AuthService, without replacing existing terms linked to the AuthService.
     * Note: this operation must make two API calls — one to retrieve the AuthService's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the AuthService
     * @param qualifiedName for the AuthService
     * @param terms the list of terms to append to the AuthService
     * @return the AuthService that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static AuthService appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AuthService) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a AuthService, without replacing all existing terms linked to the AuthService.
     * Note: this operation must make two API calls — one to retrieve the AuthService's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the AuthService
     * @param terms the list of terms to remove from the AuthService, which must be referenced by GUID
     * @return the AuthService that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static AuthService removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a AuthService, without replacing all existing terms linked to the AuthService.
     * Note: this operation must make two API calls — one to retrieve the AuthService's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the AuthService
     * @param qualifiedName for the AuthService
     * @param terms the list of terms to remove from the AuthService, which must be referenced by GUID
     * @return the AuthService that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static AuthService removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AuthService) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a AuthService, without replacing existing Atlan tags linked to the AuthService.
     * Note: this operation must make two API calls — one to retrieve the AuthService's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AuthService
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AuthService
     */
    public static AuthService appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AuthService, without replacing existing Atlan tags linked to the AuthService.
     * Note: this operation must make two API calls — one to retrieve the AuthService's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AuthService
     * @param qualifiedName of the AuthService
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AuthService
     */
    public static AuthService appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AuthService) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AuthService, without replacing existing Atlan tags linked to the AuthService.
     * Note: this operation must make two API calls — one to retrieve the AuthService's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AuthService
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AuthService
     */
    public static AuthService appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a AuthService, without replacing existing Atlan tags linked to the AuthService.
     * Note: this operation must make two API calls — one to retrieve the AuthService's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AuthService
     * @param qualifiedName of the AuthService
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AuthService
     */
    public static AuthService appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AuthService) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a AuthService.
     *
     * @param qualifiedName of the AuthService
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AuthService
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a AuthService.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a AuthService
     * @param qualifiedName of the AuthService
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AuthService
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AuthServiceBuilder<C extends AuthService, B extends AuthService.AuthServiceBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> authServiceConfig$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> authServiceConfig$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean authServiceIsEnabled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long authServicePolicyLastSync;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String authServiceType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tagService;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AuthService.AuthServiceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AuthService instance, final AuthService.AuthServiceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.authServiceConfig(instance.authServiceConfig == null ? java.util.Collections.<String, String>emptyMap() : instance.authServiceConfig);
            b.authServiceIsEnabled(instance.authServiceIsEnabled);
            b.authServicePolicyLastSync(instance.authServicePolicyLastSync);
            b.authServiceType(instance.authServiceType);
            b.tagService(instance.tagService);
        }

        /**
         * Fixed typeName for AuthServices.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putAuthServiceConfig(final String putAuthServiceConfigKey, final String putAuthServiceConfigValue) {
            if (this.authServiceConfig$key == null) {
                this.authServiceConfig$key = new java.util.ArrayList<String>();
                this.authServiceConfig$value = new java.util.ArrayList<String>();
            }
            this.authServiceConfig$key.add(putAuthServiceConfigKey);
            this.authServiceConfig$value.add(putAuthServiceConfigValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B authServiceConfig(final java.util.Map<? extends String, ? extends String> authServiceConfig) {
            if (authServiceConfig == null) {
                throw new java.lang.NullPointerException("authServiceConfig cannot be null");
            }
            if (this.authServiceConfig$key == null) {
                this.authServiceConfig$key = new java.util.ArrayList<String>();
                this.authServiceConfig$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : authServiceConfig.entrySet()) {
                this.authServiceConfig$key.add($lombokEntry.getKey());
                this.authServiceConfig$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAuthServiceConfig() {
            if (this.authServiceConfig$key != null) {
                this.authServiceConfig$key.clear();
                this.authServiceConfig$value.clear();
            }
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B authServiceIsEnabled(final Boolean authServiceIsEnabled) {
            this.authServiceIsEnabled = authServiceIsEnabled;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B authServicePolicyLastSync(final Long authServicePolicyLastSync) {
            this.authServicePolicyLastSync = authServicePolicyLastSync;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B authServiceType(final String authServiceType) {
            this.authServiceType = authServiceType;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tagService(final String tagService) {
            this.tagService = tagService;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AuthService.AuthServiceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", authServiceConfig$key=" + this.authServiceConfig$key + ", authServiceConfig$value=" + this.authServiceConfig$value + ", authServiceIsEnabled=" + this.authServiceIsEnabled + ", authServicePolicyLastSync=" + this.authServicePolicyLastSync + ", authServiceType=" + this.authServiceType + ", tagService=" + this.tagService + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AuthServiceBuilderImpl extends AuthService.AuthServiceBuilder<AuthService, AuthService.AuthServiceBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AuthServiceBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AuthService.AuthServiceBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthService build() {
            return new AuthService(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AuthService(final AuthService.AuthServiceBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = AuthService.$default$typeName();
        java.util.Map<String, String> authServiceConfig;
        switch (b.authServiceConfig$key == null ? 0 : b.authServiceConfig$key.size()) {
        case 0: 
            authServiceConfig = java.util.Collections.emptyMap();
            break;
        case 1: 
            authServiceConfig = java.util.Collections.singletonMap(b.authServiceConfig$key.get(0), b.authServiceConfig$value.get(0));
            break;
        default: 
            authServiceConfig = new java.util.LinkedHashMap<String, String>(b.authServiceConfig$key.size() < 1073741824 ? 1 + b.authServiceConfig$key.size() + (b.authServiceConfig$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.authServiceConfig$key.size(); $i++) authServiceConfig.put(b.authServiceConfig$key.get($i), (String) b.authServiceConfig$value.get($i));
            authServiceConfig = java.util.Collections.unmodifiableMap(authServiceConfig);
        }
        this.authServiceConfig = authServiceConfig;
        this.authServiceIsEnabled = b.authServiceIsEnabled;
        this.authServicePolicyLastSync = b.authServicePolicyLastSync;
        this.authServiceType = b.authServiceType;
        this.tagService = b.tagService;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AuthService.AuthServiceBuilder<?, ?> _internal() {
        return new AuthService.AuthServiceBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthService.AuthServiceBuilder<?, ?> toBuilder() {
        return new AuthService.AuthServiceBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getAuthServiceConfig() {
        return this.authServiceConfig;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAuthServiceIsEnabled() {
        return this.authServiceIsEnabled;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAuthServicePolicyLastSync() {
        return this.authServicePolicyLastSync;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAuthServiceType() {
        return this.authServiceType;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTagService() {
        return this.tagService;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AuthService)) return false;
        final AuthService other = (AuthService) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$authServiceIsEnabled = this.getAuthServiceIsEnabled();
        final java.lang.Object other$authServiceIsEnabled = other.getAuthServiceIsEnabled();
        if (this$authServiceIsEnabled == null ? other$authServiceIsEnabled != null : !this$authServiceIsEnabled.equals(other$authServiceIsEnabled)) return false;
        final java.lang.Object this$authServicePolicyLastSync = this.getAuthServicePolicyLastSync();
        final java.lang.Object other$authServicePolicyLastSync = other.getAuthServicePolicyLastSync();
        if (this$authServicePolicyLastSync == null ? other$authServicePolicyLastSync != null : !this$authServicePolicyLastSync.equals(other$authServicePolicyLastSync)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$authServiceConfig = this.getAuthServiceConfig();
        final java.lang.Object other$authServiceConfig = other.getAuthServiceConfig();
        if (this$authServiceConfig == null ? other$authServiceConfig != null : !this$authServiceConfig.equals(other$authServiceConfig)) return false;
        final java.lang.Object this$authServiceType = this.getAuthServiceType();
        final java.lang.Object other$authServiceType = other.getAuthServiceType();
        if (this$authServiceType == null ? other$authServiceType != null : !this$authServiceType.equals(other$authServiceType)) return false;
        final java.lang.Object this$tagService = this.getTagService();
        final java.lang.Object other$tagService = other.getTagService();
        if (this$tagService == null ? other$tagService != null : !this$tagService.equals(other$tagService)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AuthService;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $authServiceIsEnabled = this.getAuthServiceIsEnabled();
        result = result * PRIME + ($authServiceIsEnabled == null ? 43 : $authServiceIsEnabled.hashCode());
        final java.lang.Object $authServicePolicyLastSync = this.getAuthServicePolicyLastSync();
        result = result * PRIME + ($authServicePolicyLastSync == null ? 43 : $authServicePolicyLastSync.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $authServiceConfig = this.getAuthServiceConfig();
        result = result * PRIME + ($authServiceConfig == null ? 43 : $authServiceConfig.hashCode());
        final java.lang.Object $authServiceType = this.getAuthServiceType();
        result = result * PRIME + ($authServiceType == null ? 43 : $authServiceType.hashCode());
        final java.lang.Object $tagService = this.getTagService();
        result = result * PRIME + ($tagService == null ? 43 : $tagService.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AuthService(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", authServiceConfig=" + this.getAuthServiceConfig() + ", authServiceIsEnabled=" + this.getAuthServiceIsEnabled() + ", authServicePolicyLastSync=" + this.getAuthServicePolicyLastSync() + ", authServiceType=" + this.getAuthServiceType() + ", tagService=" + this.getTagService() + ")";
    }

    /**
     * Fixed typeName for AuthServices.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
