// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.KafkaTopicConsumption;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of an Azure Event Hub Consumer Group asset, equivalent to Kafka ConsumerGroup.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class AzureEventHubConsumerGroup extends Asset implements IAzureEventHubConsumerGroup, IKafkaConsumerGroup, IKafka, IEventStore, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(AzureEventHubConsumerGroup.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AzureEventHubConsumerGroup";
    /**
     * Fixed typeName for AzureEventHubConsumerGroups.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Number of members in this consumer group.
     */
    @Attribute
    Long kafkaConsumerGroupMemberCount;
    /**
     * List of consumption properties for Kafka topics, for this consumer group.
     */
    @Attribute
    List<KafkaTopicConsumption> kafkaConsumerGroupTopicConsumptionProperties;
    /**
     * Simple names of the topics consumed by this consumer group.
     */
    @Attribute
    SortedSet<String> kafkaTopicNames;
    /**
     * Unique names of the topics consumed by this consumer group.
     */
    @Attribute
    SortedSet<String> kafkaTopicQualifiedNames;
    /**
     * Topics consumed by this consumer group.
     */
    @Attribute
    SortedSet<IKafkaTopic> kafkaTopics;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a AzureEventHubConsumerGroup, from a potentially
     * more-complete AzureEventHubConsumerGroup object.
     *
     * @return the minimal object necessary to relate to the AzureEventHubConsumerGroup
     * @throws InvalidRequestException if any of the minimal set of required properties for a AzureEventHubConsumerGroup relationship are not found in the initial object
     */
    @Override
    public AzureEventHubConsumerGroup trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all AzureEventHubConsumerGroup assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AzureEventHubConsumerGroup assets will be included.
     *
     * @return a fluent search that includes all AzureEventHubConsumerGroup assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all AzureEventHubConsumerGroup assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AzureEventHubConsumerGroup assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all AzureEventHubConsumerGroup assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all AzureEventHubConsumerGroup assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) AzureEventHubConsumerGroups will be included
     * @return a fluent search that includes all AzureEventHubConsumerGroup assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all AzureEventHubConsumerGroup assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) AzureEventHubConsumerGroups will be included
     * @return a fluent search that includes all AzureEventHubConsumerGroup assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a AzureEventHubConsumerGroup by GUID. Use this to create a relationship to this AzureEventHubConsumerGroup,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the AzureEventHubConsumerGroup to reference
     * @return reference to a AzureEventHubConsumerGroup that can be used for defining a relationship to a AzureEventHubConsumerGroup
     */
    public static AzureEventHubConsumerGroup refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AzureEventHubConsumerGroup by GUID. Use this to create a relationship to this AzureEventHubConsumerGroup,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the AzureEventHubConsumerGroup to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AzureEventHubConsumerGroup that can be used for defining a relationship to a AzureEventHubConsumerGroup
     */
    public static AzureEventHubConsumerGroup refByGuid(String guid, Reference.SaveSemantic semantic) {
        return AzureEventHubConsumerGroup._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a AzureEventHubConsumerGroup by qualifiedName. Use this to create a relationship to this AzureEventHubConsumerGroup,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the AzureEventHubConsumerGroup to reference
     * @return reference to a AzureEventHubConsumerGroup that can be used for defining a relationship to a AzureEventHubConsumerGroup
     */
    public static AzureEventHubConsumerGroup refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AzureEventHubConsumerGroup by qualifiedName. Use this to create a relationship to this AzureEventHubConsumerGroup,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the AzureEventHubConsumerGroup to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AzureEventHubConsumerGroup that can be used for defining a relationship to a AzureEventHubConsumerGroup
     */
    public static AzureEventHubConsumerGroup refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return AzureEventHubConsumerGroup._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a AzureEventHubConsumerGroup by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the AzureEventHubConsumerGroup to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AzureEventHubConsumerGroup, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AzureEventHubConsumerGroup does not exist or the provided GUID is not a AzureEventHubConsumerGroup
     */
    @JsonIgnore
    public static AzureEventHubConsumerGroup get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a AzureEventHubConsumerGroup by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AzureEventHubConsumerGroup to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AzureEventHubConsumerGroup, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AzureEventHubConsumerGroup does not exist or the provided GUID is not a AzureEventHubConsumerGroup
     */
    @JsonIgnore
    public static AzureEventHubConsumerGroup get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a AzureEventHubConsumerGroup by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AzureEventHubConsumerGroup to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full AzureEventHubConsumerGroup, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AzureEventHubConsumerGroup does not exist or the provided GUID is not a AzureEventHubConsumerGroup
     */
    @JsonIgnore
    public static AzureEventHubConsumerGroup get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof AzureEventHubConsumerGroup) {
                return (AzureEventHubConsumerGroup) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof AzureEventHubConsumerGroup) {
                return (AzureEventHubConsumerGroup) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) AzureEventHubConsumerGroup to active.
     *
     * @param qualifiedName for the AzureEventHubConsumerGroup
     * @return true if the AzureEventHubConsumerGroup is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) AzureEventHubConsumerGroup to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the AzureEventHubConsumerGroup
     * @return true if the AzureEventHubConsumerGroup is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create an AzureEventHubConsumerGroup.
     *
     * @param name of the AzureEventHubConsumerGroup
     * @param hubs in which the AzureEventHubConsumerGroup should be created, the first of which must have at least
     *             a qualifiedName
     * @return the minimal request necessary to create the AzureEventHubConsumerGroup, as a builder
     * @throws InvalidRequestException if the first hub provided is without a qualifiedName
     */
    public static AzureEventHubConsumerGroupBuilder<?, ?> creatorObj(String name, List<AzureEventHub> hubs) throws InvalidRequestException {
        if (hubs == null || hubs.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, AzureEventHub.TYPE_NAME, "null");
        }
        List<String> hubNames = new ArrayList<>();
        List<String> hubQualifiedNames = new ArrayList<>();
        List<AzureEventHub> minimalHubs = new ArrayList<>();
        for (AzureEventHub hub : hubs) {
            validateRelationship(AzureEventHub.TYPE_NAME, Map.of("connectionQualifiedName", hub.getConnectionQualifiedName(), "name", hub.getName(), "qualifiedName", hub.getQualifiedName()));
            hubNames.add(hub.getName());
            hubQualifiedNames.add(hub.getQualifiedName());
            minimalHubs.add(hub.trimToReference());
        }
        return creator(name, hubs.get(0).getConnectionQualifiedName(), hubNames, hubQualifiedNames).kafkaTopics(minimalHubs);
    }

    /**
     * Builds the minimal object necessary to create an AzureEventHubConsumerGroup.
     *
     * @param name of the AzureEventHubConsumerGroup
     * @param hubQualifiedNames unique names of the hubs in which the AzureEventHubConsumerGroup is contained
     * @throws InvalidRequestException if no hub qualifiedNames are provided
     * @return the minimal object necessary to create the AzureEventHubConsumerGroup, as a builder
     */
    public static AzureEventHubConsumerGroupBuilder<?, ?> creator(String name, List<String> hubQualifiedNames) throws InvalidRequestException {
        if (hubQualifiedNames == null || hubQualifiedNames.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, AzureEventHub.TYPE_NAME, "null");
        }
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(hubQualifiedNames.get(0));
        List<String> hubNames = hubQualifiedNames.stream().map(h -> (StringUtils.getNameFromQualifiedName(h))).collect(Collectors.toList());
        return creator(name, connectionQualifiedName, hubNames, hubQualifiedNames);
    }

    /**
     * Builds the minimal object necessary to create an AzureEventHubConsumerGroup.
     *
     * @param name of the AzureEventHubConsumerGroup
     * @param connectionQualifiedName unique name of the connection in which the AzureEventHubConsumerGroup should be created
     * @param hubNames simple names of the AzureEventHubs in which the AzureEventHubConsumerGroup should be created
     * @param hubQualifiedNames unique names of the AzureEventHubs in which the AzureEventHubConsumerGroup should be created
     * @return the minimal object necessary to create the AzureEventHubConsumerGroup, as a builder
     */
    public static AzureEventHubConsumerGroupBuilder<?, ?> creator(String name, String connectionQualifiedName, List<String> hubNames, List<String> hubQualifiedNames) {
        return AzureEventHubConsumerGroup._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(generateQualifiedName(name, connectionQualifiedName, hubNames.get(0))).name(name).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.AZURE_EVENT_HUB).kafkaTopics(hubQualifiedNames.stream().map(h -> AzureEventHub.refByQualifiedName(h)).collect(Collectors.toList())).kafkaTopicNames(hubNames).kafkaTopicQualifiedNames(hubQualifiedNames);
    }

    /**
     * Generate a unique AzureEventHubConsumerGroup name.
     *
     * @param name of the AzureEventHubConsumerGroup
     * @param hubName simple name of the first AzureEventHubs in which the AzureEventHubConsumerGroup is contained
     * @return a unique name for the AzureEventHubConsumerGroup
     */
    public static String generateQualifiedName(String name, String connectionQualifiedName, String hubName) {
        return connectionQualifiedName + "/consumer-group/" + hubName + "/" + name;
    }

    /**
     * Builds the minimal object necessary to update an AzureEventHubConsumerGroup.
     *
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param name of the AzureEventHubConsumerGroup
     * @return the minimal request necessary to update the AzureEventHubConsumerGroup, as a builder
     */
    public static AzureEventHubConsumerGroupBuilder<?, ?> updater(String qualifiedName, String name) {
        return AzureEventHubConsumerGroup._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to an AzureEventHubConsumerGroup, from a potentially
     * more-complete AzureEventHubConsumerGroup object.
     *
     * @return the minimal object necessary to update the AzureEventHubConsumerGroup, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for AzureEventHubConsumerGroup are not found in the initial object
     */
    @Override
    public AzureEventHubConsumerGroupBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a AzureEventHubConsumerGroup.
     *
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param name of the AzureEventHubConsumerGroup
     * @return the updated AzureEventHubConsumerGroup, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a AzureEventHubConsumerGroup.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param name of the AzureEventHubConsumerGroup
     * @return the updated AzureEventHubConsumerGroup, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureEventHubConsumerGroup) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a AzureEventHubConsumerGroup.
     *
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param name of the AzureEventHubConsumerGroup
     * @return the updated AzureEventHubConsumerGroup, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a AzureEventHubConsumerGroup.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param name of the AzureEventHubConsumerGroup
     * @return the updated AzureEventHubConsumerGroup, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureEventHubConsumerGroup) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a AzureEventHubConsumerGroup.
     *
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param name of the AzureEventHubConsumerGroup
     * @return the updated AzureEventHubConsumerGroup, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a AzureEventHubConsumerGroup.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AzureEventHubConsumerGroup's owners
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param name of the AzureEventHubConsumerGroup
     * @return the updated AzureEventHubConsumerGroup, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureEventHubConsumerGroup) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a AzureEventHubConsumerGroup.
     *
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AzureEventHubConsumerGroup, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a AzureEventHubConsumerGroup.
     *
     * @param client connectivity to the Atlan tenant on which to update the AzureEventHubConsumerGroup's certificate
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AzureEventHubConsumerGroup, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AzureEventHubConsumerGroup) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a AzureEventHubConsumerGroup.
     *
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param name of the AzureEventHubConsumerGroup
     * @return the updated AzureEventHubConsumerGroup, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a AzureEventHubConsumerGroup.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AzureEventHubConsumerGroup's certificate
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param name of the AzureEventHubConsumerGroup
     * @return the updated AzureEventHubConsumerGroup, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureEventHubConsumerGroup) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a AzureEventHubConsumerGroup.
     *
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a AzureEventHubConsumerGroup.
     *
     * @param client connectivity to the Atlan tenant on which to update the AzureEventHubConsumerGroup's announcement
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AzureEventHubConsumerGroup) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a AzureEventHubConsumerGroup.
     *
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param name of the AzureEventHubConsumerGroup
     * @return the updated AzureEventHubConsumerGroup, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a AzureEventHubConsumerGroup.
     *
     * @param client connectivity to the Atlan client from which to remove the AzureEventHubConsumerGroup's announcement
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param name of the AzureEventHubConsumerGroup
     * @return the updated AzureEventHubConsumerGroup, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureEventHubConsumerGroup) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the AzureEventHubConsumerGroup.
     *
     * @param qualifiedName for the AzureEventHubConsumerGroup
     * @param name human-readable name of the AzureEventHubConsumerGroup
     * @param terms the list of terms to replace on the AzureEventHubConsumerGroup, or null to remove all terms from the AzureEventHubConsumerGroup
     * @return the AzureEventHubConsumerGroup that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the AzureEventHubConsumerGroup.
     *
     * @param client connectivity to the Atlan tenant on which to replace the AzureEventHubConsumerGroup's assigned terms
     * @param qualifiedName for the AzureEventHubConsumerGroup
     * @param name human-readable name of the AzureEventHubConsumerGroup
     * @param terms the list of terms to replace on the AzureEventHubConsumerGroup, or null to remove all terms from the AzureEventHubConsumerGroup
     * @return the AzureEventHubConsumerGroup that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AzureEventHubConsumerGroup) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the AzureEventHubConsumerGroup, without replacing existing terms linked to the AzureEventHubConsumerGroup.
     * Note: this operation must make two API calls — one to retrieve the AzureEventHubConsumerGroup's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the AzureEventHubConsumerGroup
     * @param terms the list of terms to append to the AzureEventHubConsumerGroup
     * @return the AzureEventHubConsumerGroup that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the AzureEventHubConsumerGroup, without replacing existing terms linked to the AzureEventHubConsumerGroup.
     * Note: this operation must make two API calls — one to retrieve the AzureEventHubConsumerGroup's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the AzureEventHubConsumerGroup
     * @param qualifiedName for the AzureEventHubConsumerGroup
     * @param terms the list of terms to append to the AzureEventHubConsumerGroup
     * @return the AzureEventHubConsumerGroup that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AzureEventHubConsumerGroup) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a AzureEventHubConsumerGroup, without replacing all existing terms linked to the AzureEventHubConsumerGroup.
     * Note: this operation must make two API calls — one to retrieve the AzureEventHubConsumerGroup's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the AzureEventHubConsumerGroup
     * @param terms the list of terms to remove from the AzureEventHubConsumerGroup, which must be referenced by GUID
     * @return the AzureEventHubConsumerGroup that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a AzureEventHubConsumerGroup, without replacing all existing terms linked to the AzureEventHubConsumerGroup.
     * Note: this operation must make two API calls — one to retrieve the AzureEventHubConsumerGroup's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the AzureEventHubConsumerGroup
     * @param qualifiedName for the AzureEventHubConsumerGroup
     * @param terms the list of terms to remove from the AzureEventHubConsumerGroup, which must be referenced by GUID
     * @return the AzureEventHubConsumerGroup that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static AzureEventHubConsumerGroup removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AzureEventHubConsumerGroup) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a AzureEventHubConsumerGroup, without replacing existing Atlan tags linked to the AzureEventHubConsumerGroup.
     * Note: this operation must make two API calls — one to retrieve the AzureEventHubConsumerGroup's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AzureEventHubConsumerGroup
     */
    public static AzureEventHubConsumerGroup appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AzureEventHubConsumerGroup, without replacing existing Atlan tags linked to the AzureEventHubConsumerGroup.
     * Note: this operation must make two API calls — one to retrieve the AzureEventHubConsumerGroup's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AzureEventHubConsumerGroup
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AzureEventHubConsumerGroup
     */
    public static AzureEventHubConsumerGroup appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AzureEventHubConsumerGroup) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AzureEventHubConsumerGroup, without replacing existing Atlan tags linked to the AzureEventHubConsumerGroup.
     * Note: this operation must make two API calls — one to retrieve the AzureEventHubConsumerGroup's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AzureEventHubConsumerGroup
     */
    public static AzureEventHubConsumerGroup appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a AzureEventHubConsumerGroup, without replacing existing Atlan tags linked to the AzureEventHubConsumerGroup.
     * Note: this operation must make two API calls — one to retrieve the AzureEventHubConsumerGroup's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AzureEventHubConsumerGroup
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AzureEventHubConsumerGroup
     */
    public static AzureEventHubConsumerGroup appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AzureEventHubConsumerGroup) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a AzureEventHubConsumerGroup.
     *
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AzureEventHubConsumerGroup
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a AzureEventHubConsumerGroup.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a AzureEventHubConsumerGroup
     * @param qualifiedName of the AzureEventHubConsumerGroup
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AzureEventHubConsumerGroup
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AzureEventHubConsumerGroupBuilder<C extends AzureEventHubConsumerGroup, B extends AzureEventHubConsumerGroup.AzureEventHubConsumerGroupBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long kafkaConsumerGroupMemberCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<KafkaTopicConsumption> kafkaConsumerGroupTopicConsumptionProperties;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> kafkaTopicNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> kafkaTopicQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IKafkaTopic> kafkaTopics;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AzureEventHubConsumerGroup.AzureEventHubConsumerGroupBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AzureEventHubConsumerGroup instance, final AzureEventHubConsumerGroup.AzureEventHubConsumerGroupBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.kafkaConsumerGroupMemberCount(instance.kafkaConsumerGroupMemberCount);
            b.kafkaConsumerGroupTopicConsumptionProperties(instance.kafkaConsumerGroupTopicConsumptionProperties == null ? java.util.Collections.<KafkaTopicConsumption>emptyList() : instance.kafkaConsumerGroupTopicConsumptionProperties);
            b.kafkaTopicNames(instance.kafkaTopicNames == null ? java.util.Collections.<String>emptySortedSet() : instance.kafkaTopicNames);
            b.kafkaTopicQualifiedNames(instance.kafkaTopicQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.kafkaTopicQualifiedNames);
            b.kafkaTopics(instance.kafkaTopics == null ? java.util.Collections.<IKafkaTopic>emptySortedSet() : instance.kafkaTopics);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for AzureEventHubConsumerGroups.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Number of members in this consumer group.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B kafkaConsumerGroupMemberCount(final Long kafkaConsumerGroupMemberCount) {
            this.kafkaConsumerGroupMemberCount = kafkaConsumerGroupMemberCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B kafkaConsumerGroupTopicConsumptionProperty(final KafkaTopicConsumption kafkaConsumerGroupTopicConsumptionProperty) {
            if (this.kafkaConsumerGroupTopicConsumptionProperties == null) this.kafkaConsumerGroupTopicConsumptionProperties = new java.util.ArrayList<KafkaTopicConsumption>();
            this.kafkaConsumerGroupTopicConsumptionProperties.add(kafkaConsumerGroupTopicConsumptionProperty);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B kafkaConsumerGroupTopicConsumptionProperties(final java.util.Collection<? extends KafkaTopicConsumption> kafkaConsumerGroupTopicConsumptionProperties) {
            if (kafkaConsumerGroupTopicConsumptionProperties == null) {
                throw new java.lang.NullPointerException("kafkaConsumerGroupTopicConsumptionProperties cannot be null");
            }
            if (this.kafkaConsumerGroupTopicConsumptionProperties == null) this.kafkaConsumerGroupTopicConsumptionProperties = new java.util.ArrayList<KafkaTopicConsumption>();
            this.kafkaConsumerGroupTopicConsumptionProperties.addAll(kafkaConsumerGroupTopicConsumptionProperties);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearKafkaConsumerGroupTopicConsumptionProperties() {
            if (this.kafkaConsumerGroupTopicConsumptionProperties != null) this.kafkaConsumerGroupTopicConsumptionProperties.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B kafkaTopicName(final String kafkaTopicName) {
            if (this.kafkaTopicNames == null) this.kafkaTopicNames = new java.util.ArrayList<String>();
            this.kafkaTopicNames.add(kafkaTopicName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B kafkaTopicNames(final java.util.Collection<? extends String> kafkaTopicNames) {
            if (kafkaTopicNames == null) {
                throw new java.lang.NullPointerException("kafkaTopicNames cannot be null");
            }
            if (this.kafkaTopicNames == null) this.kafkaTopicNames = new java.util.ArrayList<String>();
            this.kafkaTopicNames.addAll(kafkaTopicNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearKafkaTopicNames() {
            if (this.kafkaTopicNames != null) this.kafkaTopicNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B kafkaTopicQualifiedName(final String kafkaTopicQualifiedName) {
            if (this.kafkaTopicQualifiedNames == null) this.kafkaTopicQualifiedNames = new java.util.ArrayList<String>();
            this.kafkaTopicQualifiedNames.add(kafkaTopicQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B kafkaTopicQualifiedNames(final java.util.Collection<? extends String> kafkaTopicQualifiedNames) {
            if (kafkaTopicQualifiedNames == null) {
                throw new java.lang.NullPointerException("kafkaTopicQualifiedNames cannot be null");
            }
            if (this.kafkaTopicQualifiedNames == null) this.kafkaTopicQualifiedNames = new java.util.ArrayList<String>();
            this.kafkaTopicQualifiedNames.addAll(kafkaTopicQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearKafkaTopicQualifiedNames() {
            if (this.kafkaTopicQualifiedNames != null) this.kafkaTopicQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B kafkaTopic(final IKafkaTopic kafkaTopic) {
            if (this.kafkaTopics == null) this.kafkaTopics = new java.util.ArrayList<IKafkaTopic>();
            this.kafkaTopics.add(kafkaTopic);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B kafkaTopics(final java.util.Collection<? extends IKafkaTopic> kafkaTopics) {
            if (kafkaTopics == null) {
                throw new java.lang.NullPointerException("kafkaTopics cannot be null");
            }
            if (this.kafkaTopics == null) this.kafkaTopics = new java.util.ArrayList<IKafkaTopic>();
            this.kafkaTopics.addAll(kafkaTopics);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearKafkaTopics() {
            if (this.kafkaTopics != null) this.kafkaTopics.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AzureEventHubConsumerGroup.AzureEventHubConsumerGroupBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", kafkaConsumerGroupMemberCount=" + this.kafkaConsumerGroupMemberCount + ", kafkaConsumerGroupTopicConsumptionProperties=" + this.kafkaConsumerGroupTopicConsumptionProperties + ", kafkaTopicNames=" + this.kafkaTopicNames + ", kafkaTopicQualifiedNames=" + this.kafkaTopicQualifiedNames + ", kafkaTopics=" + this.kafkaTopics + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AzureEventHubConsumerGroupBuilderImpl extends AzureEventHubConsumerGroup.AzureEventHubConsumerGroupBuilder<AzureEventHubConsumerGroup, AzureEventHubConsumerGroup.AzureEventHubConsumerGroupBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AzureEventHubConsumerGroupBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AzureEventHubConsumerGroup.AzureEventHubConsumerGroupBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AzureEventHubConsumerGroup build() {
            return new AzureEventHubConsumerGroup(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AzureEventHubConsumerGroup(final AzureEventHubConsumerGroup.AzureEventHubConsumerGroupBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = AzureEventHubConsumerGroup.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.kafkaConsumerGroupMemberCount = b.kafkaConsumerGroupMemberCount;
        java.util.List<KafkaTopicConsumption> kafkaConsumerGroupTopicConsumptionProperties;
        switch (b.kafkaConsumerGroupTopicConsumptionProperties == null ? 0 : b.kafkaConsumerGroupTopicConsumptionProperties.size()) {
        case 0: 
            kafkaConsumerGroupTopicConsumptionProperties = java.util.Collections.emptyList();
            break;
        case 1: 
            kafkaConsumerGroupTopicConsumptionProperties = java.util.Collections.singletonList(b.kafkaConsumerGroupTopicConsumptionProperties.get(0));
            break;
        default: 
            kafkaConsumerGroupTopicConsumptionProperties = java.util.Collections.unmodifiableList(new java.util.ArrayList<KafkaTopicConsumption>(b.kafkaConsumerGroupTopicConsumptionProperties));
        }
        this.kafkaConsumerGroupTopicConsumptionProperties = kafkaConsumerGroupTopicConsumptionProperties;
        java.util.SortedSet<String> kafkaTopicNames = new java.util.TreeSet<String>();
        if (b.kafkaTopicNames != null) kafkaTopicNames.addAll(b.kafkaTopicNames);
        kafkaTopicNames = java.util.Collections.unmodifiableSortedSet(kafkaTopicNames);
        this.kafkaTopicNames = kafkaTopicNames;
        java.util.SortedSet<String> kafkaTopicQualifiedNames = new java.util.TreeSet<String>();
        if (b.kafkaTopicQualifiedNames != null) kafkaTopicQualifiedNames.addAll(b.kafkaTopicQualifiedNames);
        kafkaTopicQualifiedNames = java.util.Collections.unmodifiableSortedSet(kafkaTopicQualifiedNames);
        this.kafkaTopicQualifiedNames = kafkaTopicQualifiedNames;
        java.util.SortedSet<IKafkaTopic> kafkaTopics = new java.util.TreeSet<IKafkaTopic>();
        if (b.kafkaTopics != null) kafkaTopics.addAll(b.kafkaTopics);
        kafkaTopics = java.util.Collections.unmodifiableSortedSet(kafkaTopics);
        this.kafkaTopics = kafkaTopics;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AzureEventHubConsumerGroup.AzureEventHubConsumerGroupBuilder<?, ?> _internal() {
        return new AzureEventHubConsumerGroup.AzureEventHubConsumerGroupBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AzureEventHubConsumerGroup.AzureEventHubConsumerGroupBuilder<?, ?> toBuilder() {
        return new AzureEventHubConsumerGroup.AzureEventHubConsumerGroupBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Number of members in this consumer group.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getKafkaConsumerGroupMemberCount() {
        return this.kafkaConsumerGroupMemberCount;
    }

    /**
     * List of consumption properties for Kafka topics, for this consumer group.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<KafkaTopicConsumption> getKafkaConsumerGroupTopicConsumptionProperties() {
        return this.kafkaConsumerGroupTopicConsumptionProperties;
    }

    /**
     * Simple names of the topics consumed by this consumer group.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getKafkaTopicNames() {
        return this.kafkaTopicNames;
    }

    /**
     * Unique names of the topics consumed by this consumer group.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getKafkaTopicQualifiedNames() {
        return this.kafkaTopicQualifiedNames;
    }

    /**
     * Topics consumed by this consumer group.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IKafkaTopic> getKafkaTopics() {
        return this.kafkaTopics;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AzureEventHubConsumerGroup)) return false;
        final AzureEventHubConsumerGroup other = (AzureEventHubConsumerGroup) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$kafkaConsumerGroupMemberCount = this.getKafkaConsumerGroupMemberCount();
        final java.lang.Object other$kafkaConsumerGroupMemberCount = other.getKafkaConsumerGroupMemberCount();
        if (this$kafkaConsumerGroupMemberCount == null ? other$kafkaConsumerGroupMemberCount != null : !this$kafkaConsumerGroupMemberCount.equals(other$kafkaConsumerGroupMemberCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$kafkaConsumerGroupTopicConsumptionProperties = this.getKafkaConsumerGroupTopicConsumptionProperties();
        final java.lang.Object other$kafkaConsumerGroupTopicConsumptionProperties = other.getKafkaConsumerGroupTopicConsumptionProperties();
        if (this$kafkaConsumerGroupTopicConsumptionProperties == null ? other$kafkaConsumerGroupTopicConsumptionProperties != null : !this$kafkaConsumerGroupTopicConsumptionProperties.equals(other$kafkaConsumerGroupTopicConsumptionProperties)) return false;
        final java.lang.Object this$kafkaTopicNames = this.getKafkaTopicNames();
        final java.lang.Object other$kafkaTopicNames = other.getKafkaTopicNames();
        if (this$kafkaTopicNames == null ? other$kafkaTopicNames != null : !this$kafkaTopicNames.equals(other$kafkaTopicNames)) return false;
        final java.lang.Object this$kafkaTopicQualifiedNames = this.getKafkaTopicQualifiedNames();
        final java.lang.Object other$kafkaTopicQualifiedNames = other.getKafkaTopicQualifiedNames();
        if (this$kafkaTopicQualifiedNames == null ? other$kafkaTopicQualifiedNames != null : !this$kafkaTopicQualifiedNames.equals(other$kafkaTopicQualifiedNames)) return false;
        final java.lang.Object this$kafkaTopics = this.getKafkaTopics();
        final java.lang.Object other$kafkaTopics = other.getKafkaTopics();
        if (this$kafkaTopics == null ? other$kafkaTopics != null : !this$kafkaTopics.equals(other$kafkaTopics)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AzureEventHubConsumerGroup;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $kafkaConsumerGroupMemberCount = this.getKafkaConsumerGroupMemberCount();
        result = result * PRIME + ($kafkaConsumerGroupMemberCount == null ? 43 : $kafkaConsumerGroupMemberCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $kafkaConsumerGroupTopicConsumptionProperties = this.getKafkaConsumerGroupTopicConsumptionProperties();
        result = result * PRIME + ($kafkaConsumerGroupTopicConsumptionProperties == null ? 43 : $kafkaConsumerGroupTopicConsumptionProperties.hashCode());
        final java.lang.Object $kafkaTopicNames = this.getKafkaTopicNames();
        result = result * PRIME + ($kafkaTopicNames == null ? 43 : $kafkaTopicNames.hashCode());
        final java.lang.Object $kafkaTopicQualifiedNames = this.getKafkaTopicQualifiedNames();
        result = result * PRIME + ($kafkaTopicQualifiedNames == null ? 43 : $kafkaTopicQualifiedNames.hashCode());
        final java.lang.Object $kafkaTopics = this.getKafkaTopics();
        result = result * PRIME + ($kafkaTopics == null ? 43 : $kafkaTopics.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AzureEventHubConsumerGroup(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", kafkaConsumerGroupMemberCount=" + this.getKafkaConsumerGroupMemberCount() + ", kafkaConsumerGroupTopicConsumptionProperties=" + this.getKafkaConsumerGroupTopicConsumptionProperties() + ", kafkaTopicNames=" + this.getKafkaTopicNames() + ", kafkaTopicQualifiedNames=" + this.getKafkaTopicQualifiedNames() + ", kafkaTopics=" + this.getKafkaTopics() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for AzureEventHubConsumerGroups.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
