// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instances of AzureServiceBusField in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class AzureServiceBusTopic extends Asset implements IAzureServiceBusTopic, IAzureServiceBus, IEventStore, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(AzureServiceBusTopic.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AzureServiceBusTopic";
    /**
     * Fixed typeName for AzureServiceBusTopics.
     */
    String typeName;
    /**
     * AzureServiceBusNamespace asset containing this AzureServiceBusTopic.
     */
    @Attribute
    IAzureServiceBusNamespace azureServiceBusNamespace;
    /**
     * Simple name of the AzureServiceBus Namespace in which this asset exists.
     */
    @Attribute
    String azureServiceBusNamespaceName;
    /**
     * Unique name of the AzureServiceBus Namespace in which this asset exists.
     */
    @Attribute
    String azureServiceBusNamespaceQualifiedName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a AzureServiceBusTopic, from a potentially
     * more-complete AzureServiceBusTopic object.
     *
     * @return the minimal object necessary to relate to the AzureServiceBusTopic
     * @throws InvalidRequestException if any of the minimal set of required properties for a AzureServiceBusTopic relationship are not found in the initial object
     */
    @Override
    public AzureServiceBusTopic trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all AzureServiceBusTopic assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AzureServiceBusTopic assets will be included.
     *
     * @return a fluent search that includes all AzureServiceBusTopic assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all AzureServiceBusTopic assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) AzureServiceBusTopic assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all AzureServiceBusTopic assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all AzureServiceBusTopic assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) AzureServiceBusTopics will be included
     * @return a fluent search that includes all AzureServiceBusTopic assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all AzureServiceBusTopic assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) AzureServiceBusTopics will be included
     * @return a fluent search that includes all AzureServiceBusTopic assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a AzureServiceBusTopic by GUID. Use this to create a relationship to this AzureServiceBusTopic,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the AzureServiceBusTopic to reference
     * @return reference to a AzureServiceBusTopic that can be used for defining a relationship to a AzureServiceBusTopic
     */
    public static AzureServiceBusTopic refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AzureServiceBusTopic by GUID. Use this to create a relationship to this AzureServiceBusTopic,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the AzureServiceBusTopic to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AzureServiceBusTopic that can be used for defining a relationship to a AzureServiceBusTopic
     */
    public static AzureServiceBusTopic refByGuid(String guid, Reference.SaveSemantic semantic) {
        return AzureServiceBusTopic._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a AzureServiceBusTopic by qualifiedName. Use this to create a relationship to this AzureServiceBusTopic,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the AzureServiceBusTopic to reference
     * @return reference to a AzureServiceBusTopic that can be used for defining a relationship to a AzureServiceBusTopic
     */
    public static AzureServiceBusTopic refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a AzureServiceBusTopic by qualifiedName. Use this to create a relationship to this AzureServiceBusTopic,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the AzureServiceBusTopic to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a AzureServiceBusTopic that can be used for defining a relationship to a AzureServiceBusTopic
     */
    public static AzureServiceBusTopic refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return AzureServiceBusTopic._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a AzureServiceBusTopic by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the AzureServiceBusTopic to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AzureServiceBusTopic, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AzureServiceBusTopic does not exist or the provided GUID is not a AzureServiceBusTopic
     */
    @JsonIgnore
    public static AzureServiceBusTopic get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a AzureServiceBusTopic by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AzureServiceBusTopic to retrieve, either its GUID or its full qualifiedName
     * @return the requested full AzureServiceBusTopic, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AzureServiceBusTopic does not exist or the provided GUID is not a AzureServiceBusTopic
     */
    @JsonIgnore
    public static AzureServiceBusTopic get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a AzureServiceBusTopic by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the AzureServiceBusTopic to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full AzureServiceBusTopic, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the AzureServiceBusTopic does not exist or the provided GUID is not a AzureServiceBusTopic
     */
    @JsonIgnore
    public static AzureServiceBusTopic get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof AzureServiceBusTopic) {
                return (AzureServiceBusTopic) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof AzureServiceBusTopic) {
                return (AzureServiceBusTopic) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) AzureServiceBusTopic to active.
     *
     * @param qualifiedName for the AzureServiceBusTopic
     * @return true if the AzureServiceBusTopic is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) AzureServiceBusTopic to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the AzureServiceBusTopic
     * @return true if the AzureServiceBusTopic is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a AzureServiceBusTopic.
     *
     * @param qualifiedName of the AzureServiceBusTopic
     * @param name of the AzureServiceBusTopic
     * @return the minimal request necessary to update the AzureServiceBusTopic, as a builder
     */
    public static AzureServiceBusTopicBuilder<?, ?> updater(String qualifiedName, String name) {
        return AzureServiceBusTopic._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a AzureServiceBusTopic, from a potentially
     * more-complete AzureServiceBusTopic object.
     *
     * @return the minimal object necessary to update the AzureServiceBusTopic, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for AzureServiceBusTopic are not found in the initial object
     */
    @Override
    public AzureServiceBusTopicBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a AzureServiceBusTopic.
     *
     * @param qualifiedName of the AzureServiceBusTopic
     * @param name of the AzureServiceBusTopic
     * @return the updated AzureServiceBusTopic, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a AzureServiceBusTopic.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the AzureServiceBusTopic
     * @param name of the AzureServiceBusTopic
     * @return the updated AzureServiceBusTopic, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureServiceBusTopic) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a AzureServiceBusTopic.
     *
     * @param qualifiedName of the AzureServiceBusTopic
     * @param name of the AzureServiceBusTopic
     * @return the updated AzureServiceBusTopic, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a AzureServiceBusTopic.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the AzureServiceBusTopic
     * @param name of the AzureServiceBusTopic
     * @return the updated AzureServiceBusTopic, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureServiceBusTopic) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a AzureServiceBusTopic.
     *
     * @param qualifiedName of the AzureServiceBusTopic
     * @param name of the AzureServiceBusTopic
     * @return the updated AzureServiceBusTopic, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a AzureServiceBusTopic.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AzureServiceBusTopic's owners
     * @param qualifiedName of the AzureServiceBusTopic
     * @param name of the AzureServiceBusTopic
     * @return the updated AzureServiceBusTopic, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureServiceBusTopic) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a AzureServiceBusTopic.
     *
     * @param qualifiedName of the AzureServiceBusTopic
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AzureServiceBusTopic, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a AzureServiceBusTopic.
     *
     * @param client connectivity to the Atlan tenant on which to update the AzureServiceBusTopic's certificate
     * @param qualifiedName of the AzureServiceBusTopic
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated AzureServiceBusTopic, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AzureServiceBusTopic) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a AzureServiceBusTopic.
     *
     * @param qualifiedName of the AzureServiceBusTopic
     * @param name of the AzureServiceBusTopic
     * @return the updated AzureServiceBusTopic, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a AzureServiceBusTopic.
     *
     * @param client connectivity to the Atlan tenant from which to remove the AzureServiceBusTopic's certificate
     * @param qualifiedName of the AzureServiceBusTopic
     * @param name of the AzureServiceBusTopic
     * @return the updated AzureServiceBusTopic, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureServiceBusTopic) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a AzureServiceBusTopic.
     *
     * @param qualifiedName of the AzureServiceBusTopic
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a AzureServiceBusTopic.
     *
     * @param client connectivity to the Atlan tenant on which to update the AzureServiceBusTopic's announcement
     * @param qualifiedName of the AzureServiceBusTopic
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AzureServiceBusTopic) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a AzureServiceBusTopic.
     *
     * @param qualifiedName of the AzureServiceBusTopic
     * @param name of the AzureServiceBusTopic
     * @return the updated AzureServiceBusTopic, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a AzureServiceBusTopic.
     *
     * @param client connectivity to the Atlan client from which to remove the AzureServiceBusTopic's announcement
     * @param qualifiedName of the AzureServiceBusTopic
     * @param name of the AzureServiceBusTopic
     * @return the updated AzureServiceBusTopic, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureServiceBusTopic) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the AzureServiceBusTopic.
     *
     * @param qualifiedName for the AzureServiceBusTopic
     * @param name human-readable name of the AzureServiceBusTopic
     * @param terms the list of terms to replace on the AzureServiceBusTopic, or null to remove all terms from the AzureServiceBusTopic
     * @return the AzureServiceBusTopic that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the AzureServiceBusTopic.
     *
     * @param client connectivity to the Atlan tenant on which to replace the AzureServiceBusTopic's assigned terms
     * @param qualifiedName for the AzureServiceBusTopic
     * @param name human-readable name of the AzureServiceBusTopic
     * @param terms the list of terms to replace on the AzureServiceBusTopic, or null to remove all terms from the AzureServiceBusTopic
     * @return the AzureServiceBusTopic that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AzureServiceBusTopic) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the AzureServiceBusTopic, without replacing existing terms linked to the AzureServiceBusTopic.
     * Note: this operation must make two API calls — one to retrieve the AzureServiceBusTopic's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the AzureServiceBusTopic
     * @param terms the list of terms to append to the AzureServiceBusTopic
     * @return the AzureServiceBusTopic that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the AzureServiceBusTopic, without replacing existing terms linked to the AzureServiceBusTopic.
     * Note: this operation must make two API calls — one to retrieve the AzureServiceBusTopic's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the AzureServiceBusTopic
     * @param qualifiedName for the AzureServiceBusTopic
     * @param terms the list of terms to append to the AzureServiceBusTopic
     * @return the AzureServiceBusTopic that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AzureServiceBusTopic) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a AzureServiceBusTopic, without replacing all existing terms linked to the AzureServiceBusTopic.
     * Note: this operation must make two API calls — one to retrieve the AzureServiceBusTopic's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the AzureServiceBusTopic
     * @param terms the list of terms to remove from the AzureServiceBusTopic, which must be referenced by GUID
     * @return the AzureServiceBusTopic that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a AzureServiceBusTopic, without replacing all existing terms linked to the AzureServiceBusTopic.
     * Note: this operation must make two API calls — one to retrieve the AzureServiceBusTopic's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the AzureServiceBusTopic
     * @param qualifiedName for the AzureServiceBusTopic
     * @param terms the list of terms to remove from the AzureServiceBusTopic, which must be referenced by GUID
     * @return the AzureServiceBusTopic that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static AzureServiceBusTopic removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AzureServiceBusTopic) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a AzureServiceBusTopic, without replacing existing Atlan tags linked to the AzureServiceBusTopic.
     * Note: this operation must make two API calls — one to retrieve the AzureServiceBusTopic's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AzureServiceBusTopic
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AzureServiceBusTopic
     */
    public static AzureServiceBusTopic appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AzureServiceBusTopic, without replacing existing Atlan tags linked to the AzureServiceBusTopic.
     * Note: this operation must make two API calls — one to retrieve the AzureServiceBusTopic's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AzureServiceBusTopic
     * @param qualifiedName of the AzureServiceBusTopic
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated AzureServiceBusTopic
     */
    public static AzureServiceBusTopic appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AzureServiceBusTopic) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a AzureServiceBusTopic, without replacing existing Atlan tags linked to the AzureServiceBusTopic.
     * Note: this operation must make two API calls — one to retrieve the AzureServiceBusTopic's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the AzureServiceBusTopic
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AzureServiceBusTopic
     */
    public static AzureServiceBusTopic appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a AzureServiceBusTopic, without replacing existing Atlan tags linked to the AzureServiceBusTopic.
     * Note: this operation must make two API calls — one to retrieve the AzureServiceBusTopic's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the AzureServiceBusTopic
     * @param qualifiedName of the AzureServiceBusTopic
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated AzureServiceBusTopic
     */
    public static AzureServiceBusTopic appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AzureServiceBusTopic) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a AzureServiceBusTopic.
     *
     * @param qualifiedName of the AzureServiceBusTopic
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AzureServiceBusTopic
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a AzureServiceBusTopic.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a AzureServiceBusTopic
     * @param qualifiedName of the AzureServiceBusTopic
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the AzureServiceBusTopic
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AzureServiceBusTopicBuilder<C extends AzureServiceBusTopic, B extends AzureServiceBusTopic.AzureServiceBusTopicBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IAzureServiceBusNamespace azureServiceBusNamespace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String azureServiceBusNamespaceName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String azureServiceBusNamespaceQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AzureServiceBusTopic.AzureServiceBusTopicBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AzureServiceBusTopic instance, final AzureServiceBusTopic.AzureServiceBusTopicBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.azureServiceBusNamespace(instance.azureServiceBusNamespace);
            b.azureServiceBusNamespaceName(instance.azureServiceBusNamespaceName);
            b.azureServiceBusNamespaceQualifiedName(instance.azureServiceBusNamespaceQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for AzureServiceBusTopics.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * AzureServiceBusNamespace asset containing this AzureServiceBusTopic.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B azureServiceBusNamespace(final IAzureServiceBusNamespace azureServiceBusNamespace) {
            this.azureServiceBusNamespace = azureServiceBusNamespace;
            return self();
        }

        /**
         * Simple name of the AzureServiceBus Namespace in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B azureServiceBusNamespaceName(final String azureServiceBusNamespaceName) {
            this.azureServiceBusNamespaceName = azureServiceBusNamespaceName;
            return self();
        }

        /**
         * Unique name of the AzureServiceBus Namespace in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B azureServiceBusNamespaceQualifiedName(final String azureServiceBusNamespaceQualifiedName) {
            this.azureServiceBusNamespaceQualifiedName = azureServiceBusNamespaceQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AzureServiceBusTopic.AzureServiceBusTopicBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", azureServiceBusNamespace=" + this.azureServiceBusNamespace + ", azureServiceBusNamespaceName=" + this.azureServiceBusNamespaceName + ", azureServiceBusNamespaceQualifiedName=" + this.azureServiceBusNamespaceQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AzureServiceBusTopicBuilderImpl extends AzureServiceBusTopic.AzureServiceBusTopicBuilder<AzureServiceBusTopic, AzureServiceBusTopic.AzureServiceBusTopicBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AzureServiceBusTopicBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AzureServiceBusTopic.AzureServiceBusTopicBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AzureServiceBusTopic build() {
            return new AzureServiceBusTopic(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AzureServiceBusTopic(final AzureServiceBusTopic.AzureServiceBusTopicBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = AzureServiceBusTopic.$default$typeName();
        this.azureServiceBusNamespace = b.azureServiceBusNamespace;
        this.azureServiceBusNamespaceName = b.azureServiceBusNamespaceName;
        this.azureServiceBusNamespaceQualifiedName = b.azureServiceBusNamespaceQualifiedName;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AzureServiceBusTopic.AzureServiceBusTopicBuilder<?, ?> _internal() {
        return new AzureServiceBusTopic.AzureServiceBusTopicBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AzureServiceBusTopic.AzureServiceBusTopicBuilder<?, ?> toBuilder() {
        return new AzureServiceBusTopic.AzureServiceBusTopicBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * AzureServiceBusNamespace asset containing this AzureServiceBusTopic.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IAzureServiceBusNamespace getAzureServiceBusNamespace() {
        return this.azureServiceBusNamespace;
    }

    /**
     * Simple name of the AzureServiceBus Namespace in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAzureServiceBusNamespaceName() {
        return this.azureServiceBusNamespaceName;
    }

    /**
     * Unique name of the AzureServiceBus Namespace in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAzureServiceBusNamespaceQualifiedName() {
        return this.azureServiceBusNamespaceQualifiedName;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AzureServiceBusTopic)) return false;
        final AzureServiceBusTopic other = (AzureServiceBusTopic) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$azureServiceBusNamespace = this.getAzureServiceBusNamespace();
        final java.lang.Object other$azureServiceBusNamespace = other.getAzureServiceBusNamespace();
        if (this$azureServiceBusNamespace == null ? other$azureServiceBusNamespace != null : !this$azureServiceBusNamespace.equals(other$azureServiceBusNamespace)) return false;
        final java.lang.Object this$azureServiceBusNamespaceName = this.getAzureServiceBusNamespaceName();
        final java.lang.Object other$azureServiceBusNamespaceName = other.getAzureServiceBusNamespaceName();
        if (this$azureServiceBusNamespaceName == null ? other$azureServiceBusNamespaceName != null : !this$azureServiceBusNamespaceName.equals(other$azureServiceBusNamespaceName)) return false;
        final java.lang.Object this$azureServiceBusNamespaceQualifiedName = this.getAzureServiceBusNamespaceQualifiedName();
        final java.lang.Object other$azureServiceBusNamespaceQualifiedName = other.getAzureServiceBusNamespaceQualifiedName();
        if (this$azureServiceBusNamespaceQualifiedName == null ? other$azureServiceBusNamespaceQualifiedName != null : !this$azureServiceBusNamespaceQualifiedName.equals(other$azureServiceBusNamespaceQualifiedName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AzureServiceBusTopic;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $azureServiceBusNamespace = this.getAzureServiceBusNamespace();
        result = result * PRIME + ($azureServiceBusNamespace == null ? 43 : $azureServiceBusNamespace.hashCode());
        final java.lang.Object $azureServiceBusNamespaceName = this.getAzureServiceBusNamespaceName();
        result = result * PRIME + ($azureServiceBusNamespaceName == null ? 43 : $azureServiceBusNamespaceName.hashCode());
        final java.lang.Object $azureServiceBusNamespaceQualifiedName = this.getAzureServiceBusNamespaceQualifiedName();
        result = result * PRIME + ($azureServiceBusNamespaceQualifiedName == null ? 43 : $azureServiceBusNamespaceQualifiedName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AzureServiceBusTopic(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", azureServiceBusNamespace=" + this.getAzureServiceBusNamespace() + ", azureServiceBusNamespaceName=" + this.getAzureServiceBusNamespaceName() + ", azureServiceBusNamespaceQualifiedName=" + this.getAzureServiceBusNamespaceQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for AzureServiceBusTopics.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
