// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of business intelligence lineage in Atlan. These are used to short-circuit lineage from table-like assets directly to dashboard-like assets.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class BIProcess extends Asset implements IBIProcess, ILineageProcess, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(BIProcess.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "BIProcess";
    /**
     * Fixed typeName for BIProcesss.
     */
    String typeName;
    /**
     * Additional Context of the ETL pipeline/notebook which creates the process.
     */
    @Attribute
    String additionalEtlContext;
    /**
     * Tasks that exist within this process.
     */
    @Attribute
    SortedSet<IAirflowTask> airflowTasks;
    /**
     * Parsed AST of the code or SQL statements that describe the logic of this process.
     */
    @Attribute
    String ast;
    /**
     * Code that ran within the process.
     */
    @Attribute
    String code;
    /**
     * Processes that detail column-level lineage for this process.
     */
    @Attribute
    SortedSet<IColumnProcess> columnProcesses;
    /**
     * Assets that are inputs to this process.
     */
    @Attribute
    SortedSet<ICatalog> inputs;
    /**
     * Matillion component that contains the logic for this lineage process.
     */
    @Attribute
    IMatillionComponent matillionComponent;
    /**
     * Assets that are outputs from this process.
     */
    @Attribute
    SortedSet<ICatalog> outputs;
    /**
     * PowerBI Dataflow that is associated with this lineage process.
     */
    @Attribute
    IPowerBIDataflow powerBIDataflow;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> sparkJobs;
    /**
     * SQL query that ran to produce the outputs.
     */
    @Attribute
    String sql;

    /**
     * Builds the minimal object necessary to create a relationship to a BIProcess, from a potentially
     * more-complete BIProcess object.
     *
     * @return the minimal object necessary to relate to the BIProcess
     * @throws InvalidRequestException if any of the minimal set of required properties for a BIProcess relationship are not found in the initial object
     */
    @Override
    public BIProcess trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all BIProcess assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) BIProcess assets will be included.
     *
     * @return a fluent search that includes all BIProcess assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all BIProcess assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) BIProcess assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all BIProcess assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all BIProcess assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) BIProcesss will be included
     * @return a fluent search that includes all BIProcess assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all BIProcess assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) BIProcesss will be included
     * @return a fluent search that includes all BIProcess assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a BIProcess by GUID. Use this to create a relationship to this BIProcess,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the BIProcess to reference
     * @return reference to a BIProcess that can be used for defining a relationship to a BIProcess
     */
    public static BIProcess refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a BIProcess by GUID. Use this to create a relationship to this BIProcess,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the BIProcess to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a BIProcess that can be used for defining a relationship to a BIProcess
     */
    public static BIProcess refByGuid(String guid, Reference.SaveSemantic semantic) {
        return BIProcess._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a BIProcess by qualifiedName. Use this to create a relationship to this BIProcess,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the BIProcess to reference
     * @return reference to a BIProcess that can be used for defining a relationship to a BIProcess
     */
    public static BIProcess refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a BIProcess by qualifiedName. Use this to create a relationship to this BIProcess,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the BIProcess to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a BIProcess that can be used for defining a relationship to a BIProcess
     */
    public static BIProcess refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return BIProcess._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a BIProcess by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the BIProcess to retrieve, either its GUID or its full qualifiedName
     * @return the requested full BIProcess, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the BIProcess does not exist or the provided GUID is not a BIProcess
     */
    @JsonIgnore
    public static BIProcess get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a BIProcess by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the BIProcess to retrieve, either its GUID or its full qualifiedName
     * @return the requested full BIProcess, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the BIProcess does not exist or the provided GUID is not a BIProcess
     */
    @JsonIgnore
    public static BIProcess get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a BIProcess by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the BIProcess to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full BIProcess, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the BIProcess does not exist or the provided GUID is not a BIProcess
     */
    @JsonIgnore
    public static BIProcess get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof BIProcess) {
                return (BIProcess) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof BIProcess) {
                return (BIProcess) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) BIProcess to active.
     *
     * @param qualifiedName for the BIProcess
     * @return true if the BIProcess is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) BIProcess to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the BIProcess
     * @return true if the BIProcess is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a BIProcess.
     *
     * @param qualifiedName of the BIProcess
     * @param name of the BIProcess
     * @return the minimal request necessary to update the BIProcess, as a builder
     */
    public static BIProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return BIProcess._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a BIProcess, from a potentially
     * more-complete BIProcess object.
     *
     * @return the minimal object necessary to update the BIProcess, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for BIProcess are not found in the initial object
     */
    @Override
    public BIProcessBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a BIProcess.
     *
     * @param qualifiedName of the BIProcess
     * @param name of the BIProcess
     * @return the updated BIProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a BIProcess.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the BIProcess
     * @param name of the BIProcess
     * @return the updated BIProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BIProcess) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a BIProcess.
     *
     * @param qualifiedName of the BIProcess
     * @param name of the BIProcess
     * @return the updated BIProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a BIProcess.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the BIProcess
     * @param name of the BIProcess
     * @return the updated BIProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BIProcess) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a BIProcess.
     *
     * @param qualifiedName of the BIProcess
     * @param name of the BIProcess
     * @return the updated BIProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a BIProcess.
     *
     * @param client connectivity to the Atlan tenant from which to remove the BIProcess's owners
     * @param qualifiedName of the BIProcess
     * @param name of the BIProcess
     * @return the updated BIProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BIProcess) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a BIProcess.
     *
     * @param qualifiedName of the BIProcess
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated BIProcess, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a BIProcess.
     *
     * @param client connectivity to the Atlan tenant on which to update the BIProcess's certificate
     * @param qualifiedName of the BIProcess
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated BIProcess, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (BIProcess) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a BIProcess.
     *
     * @param qualifiedName of the BIProcess
     * @param name of the BIProcess
     * @return the updated BIProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a BIProcess.
     *
     * @param client connectivity to the Atlan tenant from which to remove the BIProcess's certificate
     * @param qualifiedName of the BIProcess
     * @param name of the BIProcess
     * @return the updated BIProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BIProcess) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a BIProcess.
     *
     * @param qualifiedName of the BIProcess
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a BIProcess.
     *
     * @param client connectivity to the Atlan tenant on which to update the BIProcess's announcement
     * @param qualifiedName of the BIProcess
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (BIProcess) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a BIProcess.
     *
     * @param qualifiedName of the BIProcess
     * @param name of the BIProcess
     * @return the updated BIProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a BIProcess.
     *
     * @param client connectivity to the Atlan client from which to remove the BIProcess's announcement
     * @param qualifiedName of the BIProcess
     * @param name of the BIProcess
     * @return the updated BIProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BIProcess removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BIProcess) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the BIProcess.
     *
     * @param qualifiedName for the BIProcess
     * @param name human-readable name of the BIProcess
     * @param terms the list of terms to replace on the BIProcess, or null to remove all terms from the BIProcess
     * @return the BIProcess that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static BIProcess replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the BIProcess.
     *
     * @param client connectivity to the Atlan tenant on which to replace the BIProcess's assigned terms
     * @param qualifiedName for the BIProcess
     * @param name human-readable name of the BIProcess
     * @param terms the list of terms to replace on the BIProcess, or null to remove all terms from the BIProcess
     * @return the BIProcess that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static BIProcess replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (BIProcess) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the BIProcess, without replacing existing terms linked to the BIProcess.
     * Note: this operation must make two API calls — one to retrieve the BIProcess's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the BIProcess
     * @param terms the list of terms to append to the BIProcess
     * @return the BIProcess that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static BIProcess appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the BIProcess, without replacing existing terms linked to the BIProcess.
     * Note: this operation must make two API calls — one to retrieve the BIProcess's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the BIProcess
     * @param qualifiedName for the BIProcess
     * @param terms the list of terms to append to the BIProcess
     * @return the BIProcess that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static BIProcess appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BIProcess) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a BIProcess, without replacing all existing terms linked to the BIProcess.
     * Note: this operation must make two API calls — one to retrieve the BIProcess's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the BIProcess
     * @param terms the list of terms to remove from the BIProcess, which must be referenced by GUID
     * @return the BIProcess that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static BIProcess removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a BIProcess, without replacing all existing terms linked to the BIProcess.
     * Note: this operation must make two API calls — one to retrieve the BIProcess's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the BIProcess
     * @param qualifiedName for the BIProcess
     * @param terms the list of terms to remove from the BIProcess, which must be referenced by GUID
     * @return the BIProcess that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static BIProcess removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BIProcess) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a BIProcess, without replacing existing Atlan tags linked to the BIProcess.
     * Note: this operation must make two API calls — one to retrieve the BIProcess's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the BIProcess
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated BIProcess
     */
    public static BIProcess appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a BIProcess, without replacing existing Atlan tags linked to the BIProcess.
     * Note: this operation must make two API calls — one to retrieve the BIProcess's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the BIProcess
     * @param qualifiedName of the BIProcess
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated BIProcess
     */
    public static BIProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (BIProcess) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a BIProcess, without replacing existing Atlan tags linked to the BIProcess.
     * Note: this operation must make two API calls — one to retrieve the BIProcess's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the BIProcess
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated BIProcess
     */
    public static BIProcess appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a BIProcess, without replacing existing Atlan tags linked to the BIProcess.
     * Note: this operation must make two API calls — one to retrieve the BIProcess's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the BIProcess
     * @param qualifiedName of the BIProcess
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated BIProcess
     */
    public static BIProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (BIProcess) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a BIProcess.
     *
     * @param qualifiedName of the BIProcess
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the BIProcess
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a BIProcess.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a BIProcess
     * @param qualifiedName of the BIProcess
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the BIProcess
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class BIProcessBuilder<C extends BIProcess, B extends BIProcess.BIProcessBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String additionalEtlContext;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> airflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String ast;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String code;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IColumnProcess> columnProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICatalog> inputs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IMatillionComponent matillionComponent;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICatalog> outputs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IPowerBIDataflow powerBIDataflow;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> sparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sql;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            BIProcess.BIProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final BIProcess instance, final BIProcess.BIProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.additionalEtlContext(instance.additionalEtlContext);
            b.airflowTasks(instance.airflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.airflowTasks);
            b.ast(instance.ast);
            b.code(instance.code);
            b.columnProcesses(instance.columnProcesses == null ? java.util.Collections.<IColumnProcess>emptySortedSet() : instance.columnProcesses);
            b.inputs(instance.inputs == null ? java.util.Collections.<ICatalog>emptySortedSet() : instance.inputs);
            b.matillionComponent(instance.matillionComponent);
            b.outputs(instance.outputs == null ? java.util.Collections.<ICatalog>emptySortedSet() : instance.outputs);
            b.powerBIDataflow(instance.powerBIDataflow);
            b.sparkJobs(instance.sparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.sparkJobs);
            b.sql(instance.sql);
        }

        /**
         * Fixed typeName for BIProcesss.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Additional Context of the ETL pipeline/notebook which creates the process.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B additionalEtlContext(final String additionalEtlContext) {
            this.additionalEtlContext = additionalEtlContext;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTask(final IAirflowTask airflowTask) {
            if (this.airflowTasks == null) this.airflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.airflowTasks.add(airflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTasks(final java.util.Collection<? extends IAirflowTask> airflowTasks) {
            if (airflowTasks == null) {
                throw new java.lang.NullPointerException("airflowTasks cannot be null");
            }
            if (this.airflowTasks == null) this.airflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.airflowTasks.addAll(airflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAirflowTasks() {
            if (this.airflowTasks != null) this.airflowTasks.clear();
            return self();
        }

        /**
         * Parsed AST of the code or SQL statements that describe the logic of this process.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B ast(final String ast) {
            this.ast = ast;
            return self();
        }

        /**
         * Code that ran within the process.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B code(final String code) {
            this.code = code;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnProcess(final IColumnProcess columnProcess) {
            if (this.columnProcesses == null) this.columnProcesses = new java.util.ArrayList<IColumnProcess>();
            this.columnProcesses.add(columnProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnProcesses(final java.util.Collection<? extends IColumnProcess> columnProcesses) {
            if (columnProcesses == null) {
                throw new java.lang.NullPointerException("columnProcesses cannot be null");
            }
            if (this.columnProcesses == null) this.columnProcesses = new java.util.ArrayList<IColumnProcess>();
            this.columnProcesses.addAll(columnProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumnProcesses() {
            if (this.columnProcesses != null) this.columnProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B input(final ICatalog input) {
            if (this.inputs == null) this.inputs = new java.util.ArrayList<ICatalog>();
            this.inputs.add(input);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputs(final java.util.Collection<? extends ICatalog> inputs) {
            if (inputs == null) {
                throw new java.lang.NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) this.inputs = new java.util.ArrayList<ICatalog>();
            this.inputs.addAll(inputs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputs() {
            if (this.inputs != null) this.inputs.clear();
            return self();
        }

        /**
         * Matillion component that contains the logic for this lineage process.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionComponent(final IMatillionComponent matillionComponent) {
            this.matillionComponent = matillionComponent;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B output(final ICatalog output) {
            if (this.outputs == null) this.outputs = new java.util.ArrayList<ICatalog>();
            this.outputs.add(output);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputs(final java.util.Collection<? extends ICatalog> outputs) {
            if (outputs == null) {
                throw new java.lang.NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) this.outputs = new java.util.ArrayList<ICatalog>();
            this.outputs.addAll(outputs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputs() {
            if (this.outputs != null) this.outputs.clear();
            return self();
        }

        /**
         * PowerBI Dataflow that is associated with this lineage process.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIDataflow(final IPowerBIDataflow powerBIDataflow) {
            this.powerBIDataflow = powerBIDataflow;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sparkJob(final ISparkJob sparkJob) {
            if (this.sparkJobs == null) this.sparkJobs = new java.util.ArrayList<ISparkJob>();
            this.sparkJobs.add(sparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sparkJobs(final java.util.Collection<? extends ISparkJob> sparkJobs) {
            if (sparkJobs == null) {
                throw new java.lang.NullPointerException("sparkJobs cannot be null");
            }
            if (this.sparkJobs == null) this.sparkJobs = new java.util.ArrayList<ISparkJob>();
            this.sparkJobs.addAll(sparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSparkJobs() {
            if (this.sparkJobs != null) this.sparkJobs.clear();
            return self();
        }

        /**
         * SQL query that ran to produce the outputs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sql(final String sql) {
            this.sql = sql;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "BIProcess.BIProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", additionalEtlContext=" + this.additionalEtlContext + ", airflowTasks=" + this.airflowTasks + ", ast=" + this.ast + ", code=" + this.code + ", columnProcesses=" + this.columnProcesses + ", inputs=" + this.inputs + ", matillionComponent=" + this.matillionComponent + ", outputs=" + this.outputs + ", powerBIDataflow=" + this.powerBIDataflow + ", sparkJobs=" + this.sparkJobs + ", sql=" + this.sql + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class BIProcessBuilderImpl extends BIProcess.BIProcessBuilder<BIProcess, BIProcess.BIProcessBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private BIProcessBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected BIProcess.BIProcessBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public BIProcess build() {
            return new BIProcess(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected BIProcess(final BIProcess.BIProcessBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = BIProcess.$default$typeName();
        this.additionalEtlContext = b.additionalEtlContext;
        java.util.SortedSet<IAirflowTask> airflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.airflowTasks != null) airflowTasks.addAll(b.airflowTasks);
        airflowTasks = java.util.Collections.unmodifiableSortedSet(airflowTasks);
        this.airflowTasks = airflowTasks;
        this.ast = b.ast;
        this.code = b.code;
        java.util.SortedSet<IColumnProcess> columnProcesses = new java.util.TreeSet<IColumnProcess>();
        if (b.columnProcesses != null) columnProcesses.addAll(b.columnProcesses);
        columnProcesses = java.util.Collections.unmodifiableSortedSet(columnProcesses);
        this.columnProcesses = columnProcesses;
        java.util.SortedSet<ICatalog> inputs = new java.util.TreeSet<ICatalog>();
        if (b.inputs != null) inputs.addAll(b.inputs);
        inputs = java.util.Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        this.matillionComponent = b.matillionComponent;
        java.util.SortedSet<ICatalog> outputs = new java.util.TreeSet<ICatalog>();
        if (b.outputs != null) outputs.addAll(b.outputs);
        outputs = java.util.Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
        this.powerBIDataflow = b.powerBIDataflow;
        java.util.SortedSet<ISparkJob> sparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.sparkJobs != null) sparkJobs.addAll(b.sparkJobs);
        sparkJobs = java.util.Collections.unmodifiableSortedSet(sparkJobs);
        this.sparkJobs = sparkJobs;
        this.sql = b.sql;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static BIProcess.BIProcessBuilder<?, ?> _internal() {
        return new BIProcess.BIProcessBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BIProcess.BIProcessBuilder<?, ?> toBuilder() {
        return new BIProcess.BIProcessBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Additional Context of the ETL pipeline/notebook which creates the process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAdditionalEtlContext() {
        return this.additionalEtlContext;
    }

    /**
     * Tasks that exist within this process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getAirflowTasks() {
        return this.airflowTasks;
    }

    /**
     * Parsed AST of the code or SQL statements that describe the logic of this process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAst() {
        return this.ast;
    }

    /**
     * Code that ran within the process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCode() {
        return this.code;
    }

    /**
     * Processes that detail column-level lineage for this process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IColumnProcess> getColumnProcesses() {
        return this.columnProcesses;
    }

    /**
     * Assets that are inputs to this process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICatalog> getInputs() {
        return this.inputs;
    }

    /**
     * Matillion component that contains the logic for this lineage process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IMatillionComponent getMatillionComponent() {
        return this.matillionComponent;
    }

    /**
     * Assets that are outputs from this process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICatalog> getOutputs() {
        return this.outputs;
    }

    /**
     * PowerBI Dataflow that is associated with this lineage process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IPowerBIDataflow getPowerBIDataflow() {
        return this.powerBIDataflow;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getSparkJobs() {
        return this.sparkJobs;
    }

    /**
     * SQL query that ran to produce the outputs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSql() {
        return this.sql;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof BIProcess)) return false;
        final BIProcess other = (BIProcess) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$additionalEtlContext = this.getAdditionalEtlContext();
        final java.lang.Object other$additionalEtlContext = other.getAdditionalEtlContext();
        if (this$additionalEtlContext == null ? other$additionalEtlContext != null : !this$additionalEtlContext.equals(other$additionalEtlContext)) return false;
        final java.lang.Object this$airflowTasks = this.getAirflowTasks();
        final java.lang.Object other$airflowTasks = other.getAirflowTasks();
        if (this$airflowTasks == null ? other$airflowTasks != null : !this$airflowTasks.equals(other$airflowTasks)) return false;
        final java.lang.Object this$ast = this.getAst();
        final java.lang.Object other$ast = other.getAst();
        if (this$ast == null ? other$ast != null : !this$ast.equals(other$ast)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$columnProcesses = this.getColumnProcesses();
        final java.lang.Object other$columnProcesses = other.getColumnProcesses();
        if (this$columnProcesses == null ? other$columnProcesses != null : !this$columnProcesses.equals(other$columnProcesses)) return false;
        final java.lang.Object this$inputs = this.getInputs();
        final java.lang.Object other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) return false;
        final java.lang.Object this$matillionComponent = this.getMatillionComponent();
        final java.lang.Object other$matillionComponent = other.getMatillionComponent();
        if (this$matillionComponent == null ? other$matillionComponent != null : !this$matillionComponent.equals(other$matillionComponent)) return false;
        final java.lang.Object this$outputs = this.getOutputs();
        final java.lang.Object other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) return false;
        final java.lang.Object this$powerBIDataflow = this.getPowerBIDataflow();
        final java.lang.Object other$powerBIDataflow = other.getPowerBIDataflow();
        if (this$powerBIDataflow == null ? other$powerBIDataflow != null : !this$powerBIDataflow.equals(other$powerBIDataflow)) return false;
        final java.lang.Object this$sparkJobs = this.getSparkJobs();
        final java.lang.Object other$sparkJobs = other.getSparkJobs();
        if (this$sparkJobs == null ? other$sparkJobs != null : !this$sparkJobs.equals(other$sparkJobs)) return false;
        final java.lang.Object this$sql = this.getSql();
        final java.lang.Object other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof BIProcess;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $additionalEtlContext = this.getAdditionalEtlContext();
        result = result * PRIME + ($additionalEtlContext == null ? 43 : $additionalEtlContext.hashCode());
        final java.lang.Object $airflowTasks = this.getAirflowTasks();
        result = result * PRIME + ($airflowTasks == null ? 43 : $airflowTasks.hashCode());
        final java.lang.Object $ast = this.getAst();
        result = result * PRIME + ($ast == null ? 43 : $ast.hashCode());
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $columnProcesses = this.getColumnProcesses();
        result = result * PRIME + ($columnProcesses == null ? 43 : $columnProcesses.hashCode());
        final java.lang.Object $inputs = this.getInputs();
        result = result * PRIME + ($inputs == null ? 43 : $inputs.hashCode());
        final java.lang.Object $matillionComponent = this.getMatillionComponent();
        result = result * PRIME + ($matillionComponent == null ? 43 : $matillionComponent.hashCode());
        final java.lang.Object $outputs = this.getOutputs();
        result = result * PRIME + ($outputs == null ? 43 : $outputs.hashCode());
        final java.lang.Object $powerBIDataflow = this.getPowerBIDataflow();
        result = result * PRIME + ($powerBIDataflow == null ? 43 : $powerBIDataflow.hashCode());
        final java.lang.Object $sparkJobs = this.getSparkJobs();
        result = result * PRIME + ($sparkJobs == null ? 43 : $sparkJobs.hashCode());
        final java.lang.Object $sql = this.getSql();
        result = result * PRIME + ($sql == null ? 43 : $sql.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "BIProcess(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", additionalEtlContext=" + this.getAdditionalEtlContext() + ", airflowTasks=" + this.getAirflowTasks() + ", ast=" + this.getAst() + ", code=" + this.getCode() + ", columnProcesses=" + this.getColumnProcesses() + ", inputs=" + this.getInputs() + ", matillionComponent=" + this.getMatillionComponent() + ", outputs=" + this.getOutputs() + ", powerBIDataflow=" + this.getPowerBIDataflow() + ", sparkJobs=" + this.getSparkJobs() + ", sql=" + this.getSql() + ")";
    }

    /**
     * Fixed typeName for BIProcesss.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
