// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.BadgeCondition;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a badge in Atlan. Badges visually highlight key information about an asset, surfaced from custom metadata.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class Badge extends Asset implements IBadge, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(Badge.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Badge";
    /**
     * Fixed typeName for Badges.
     */
    String typeName;
    /**
     * List of conditions that determine the colors to diplay for various values.
     */
    @Attribute
    List<BadgeCondition> badgeConditions;
    /**
     * Custom metadata attribute for which to show the badge.
     */
    @Attribute
    String badgeMetadataAttribute;

    /**
     * Builds the minimal object necessary to create a relationship to a Badge, from a potentially
     * more-complete Badge object.
     *
     * @return the minimal object necessary to relate to the Badge
     * @throws InvalidRequestException if any of the minimal set of required properties for a Badge relationship are not found in the initial object
     */
    @Override
    public Badge trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all Badge assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Badge assets will be included.
     *
     * @return a fluent search that includes all Badge assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all Badge assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Badge assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all Badge assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all Badge assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) Badges will be included
     * @return a fluent search that includes all Badge assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all Badge assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) Badges will be included
     * @return a fluent search that includes all Badge assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a Badge by GUID. Use this to create a relationship to this Badge,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the Badge to reference
     * @return reference to a Badge that can be used for defining a relationship to a Badge
     */
    public static Badge refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Badge by GUID. Use this to create a relationship to this Badge,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the Badge to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Badge that can be used for defining a relationship to a Badge
     */
    public static Badge refByGuid(String guid, Reference.SaveSemantic semantic) {
        return Badge._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a Badge by qualifiedName. Use this to create a relationship to this Badge,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the Badge to reference
     * @return reference to a Badge that can be used for defining a relationship to a Badge
     */
    public static Badge refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Badge by qualifiedName. Use this to create a relationship to this Badge,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the Badge to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Badge that can be used for defining a relationship to a Badge
     */
    public static Badge refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return Badge._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a Badge by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the Badge to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Badge, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Badge does not exist or the provided GUID is not a Badge
     */
    @JsonIgnore
    public static Badge get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a Badge by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Badge to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Badge, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Badge does not exist or the provided GUID is not a Badge
     */
    @JsonIgnore
    public static Badge get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a Badge by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Badge to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full Badge, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Badge does not exist or the provided GUID is not a Badge
     */
    @JsonIgnore
    public static Badge get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof Badge) {
                return (Badge) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof Badge) {
                return (Badge) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) Badge to active.
     *
     * @param qualifiedName for the Badge
     * @return true if the Badge is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) Badge to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the Badge
     * @return true if the Badge is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a Badge.
     *
     * @param name of the Badge
     * @param cmName human-readable name of the custom metadata for which to create the badge
     * @param cmAttribute human-readable name of the custom metadata attribute for which to create the badge
     * @return the minimal request necessary to create the Badge, as a builder
     * @throws AtlanException if the specified custom metadata for the badge cannot be found
     */
    public static BadgeBuilder<?, ?> creator(String name, String cmName, String cmAttribute) throws AtlanException {
        return creator(Atlan.getDefaultClient(), name, cmName, cmAttribute);
    }

    /**
     * Builds the minimal object necessary to create a Badge.
     *
     * @param client connectivity to the Atlan tenant on which the Badge is intended to be created
     * @param name of the Badge
     * @param cmName human-readable name of the custom metadata for which to create the badge
     * @param cmAttribute human-readable name of the custom metadata attribute for which to create the badge
     * @return the minimal request necessary to create the Badge, as a builder
     * @throws AtlanException if the specified custom metadata for the badge cannot be found
     */
    public static BadgeBuilder<?, ?> creator(AtlanClient client, String name, String cmName, String cmAttribute) throws AtlanException {
        String cmId = client.getCustomMetadataCache().getIdForName(cmName);
        String cmAttrId = client.getCustomMetadataCache().getAttrIdForName(cmName, cmAttribute);
        return Badge._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(generateQualifiedName(client, cmName, cmAttribute)).name(name).badgeMetadataAttribute(cmId + "." + cmAttrId);
    }

    /**
     * Generate a unique name for this badge.
     *
     * @param cmName human-readable name of the custom metadata for which to create the badge
     * @param cmAttribute human-readable name of the custom metadata attribute for which to create the badge
     * @return the unique qualifiedName of the badge
     * @throws AtlanException if the specified custom metadata cannot be found
     */
    public static String generateQualifiedName(String cmName, String cmAttribute) throws AtlanException {
        return generateQualifiedName(Atlan.getDefaultClient(), cmName, cmAttribute);
    }

    /**
     * Generate a unique name for this badge.
     *
     * @param client connectivity to the Atlan tenant through which to generate the unique name of the badge
     * @param cmName human-readable name of the custom metadata for which to create the badge
     * @param cmAttribute human-readable name of the custom metadata attribute for which to create the badge
     * @return the unique qualifiedName of the badge
     * @throws AtlanException if the specified custom metadata cannot be found
     */
    public static String generateQualifiedName(AtlanClient client, String cmName, String cmAttribute) throws AtlanException {
        String cmId = client.getCustomMetadataCache().getIdForName(cmName);
        String cmAttrId = client.getCustomMetadataCache().getAttrIdForName(cmName, cmAttribute);
        return "badges/global/" + cmId + "." + cmAttrId;
    }

    /**
     * Builds the minimal object necessary to update a Badge.
     *
     * @param qualifiedName of the Badge
     * @param name of the Badge
     * @return the minimal request necessary to update the Badge, as a builder
     */
    public static BadgeBuilder<?, ?> updater(String qualifiedName, String name) {
        return Badge._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a Badge, from a potentially
     * more-complete Badge object.
     *
     * @return the minimal object necessary to update the Badge, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for Badge are not found in the initial object
     */
    @Override
    public BadgeBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a Badge.
     *
     * @param qualifiedName of the Badge
     * @param name of the Badge
     * @return the updated Badge, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Badge removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a Badge.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Badge
     * @param name of the Badge
     * @return the updated Badge, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Badge removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Badge) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a Badge.
     *
     * @param qualifiedName of the Badge
     * @param name of the Badge
     * @return the updated Badge, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Badge removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a Badge.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Badge
     * @param name of the Badge
     * @return the updated Badge, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Badge removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Badge) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class BadgeBuilder<C extends Badge, B extends Badge.BadgeBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<BadgeCondition> badgeConditions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String badgeMetadataAttribute;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Badge.BadgeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Badge instance, final Badge.BadgeBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.badgeConditions(instance.badgeConditions == null ? java.util.Collections.<BadgeCondition>emptyList() : instance.badgeConditions);
            b.badgeMetadataAttribute(instance.badgeMetadataAttribute);
        }

        /**
         * Fixed typeName for Badges.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B badgeCondition(final BadgeCondition badgeCondition) {
            if (this.badgeConditions == null) this.badgeConditions = new java.util.ArrayList<BadgeCondition>();
            this.badgeConditions.add(badgeCondition);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B badgeConditions(final java.util.Collection<? extends BadgeCondition> badgeConditions) {
            if (badgeConditions == null) {
                throw new java.lang.NullPointerException("badgeConditions cannot be null");
            }
            if (this.badgeConditions == null) this.badgeConditions = new java.util.ArrayList<BadgeCondition>();
            this.badgeConditions.addAll(badgeConditions);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearBadgeConditions() {
            if (this.badgeConditions != null) this.badgeConditions.clear();
            return self();
        }

        /**
         * Custom metadata attribute for which to show the badge.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B badgeMetadataAttribute(final String badgeMetadataAttribute) {
            this.badgeMetadataAttribute = badgeMetadataAttribute;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Badge.BadgeBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", badgeConditions=" + this.badgeConditions + ", badgeMetadataAttribute=" + this.badgeMetadataAttribute + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class BadgeBuilderImpl extends Badge.BadgeBuilder<Badge, Badge.BadgeBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private BadgeBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Badge.BadgeBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Badge build() {
            return new Badge(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Badge(final Badge.BadgeBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = Badge.$default$typeName();
        java.util.List<BadgeCondition> badgeConditions;
        switch (b.badgeConditions == null ? 0 : b.badgeConditions.size()) {
        case 0: 
            badgeConditions = java.util.Collections.emptyList();
            break;
        case 1: 
            badgeConditions = java.util.Collections.singletonList(b.badgeConditions.get(0));
            break;
        default: 
            badgeConditions = java.util.Collections.unmodifiableList(new java.util.ArrayList<BadgeCondition>(b.badgeConditions));
        }
        this.badgeConditions = badgeConditions;
        this.badgeMetadataAttribute = b.badgeMetadataAttribute;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Badge.BadgeBuilder<?, ?> _internal() {
        return new Badge.BadgeBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Badge.BadgeBuilder<?, ?> toBuilder() {
        return new Badge.BadgeBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * List of conditions that determine the colors to diplay for various values.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<BadgeCondition> getBadgeConditions() {
        return this.badgeConditions;
    }

    /**
     * Custom metadata attribute for which to show the badge.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBadgeMetadataAttribute() {
        return this.badgeMetadataAttribute;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Badge)) return false;
        final Badge other = (Badge) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$badgeConditions = this.getBadgeConditions();
        final java.lang.Object other$badgeConditions = other.getBadgeConditions();
        if (this$badgeConditions == null ? other$badgeConditions != null : !this$badgeConditions.equals(other$badgeConditions)) return false;
        final java.lang.Object this$badgeMetadataAttribute = this.getBadgeMetadataAttribute();
        final java.lang.Object other$badgeMetadataAttribute = other.getBadgeMetadataAttribute();
        if (this$badgeMetadataAttribute == null ? other$badgeMetadataAttribute != null : !this$badgeMetadataAttribute.equals(other$badgeMetadataAttribute)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Badge;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $badgeConditions = this.getBadgeConditions();
        result = result * PRIME + ($badgeConditions == null ? 43 : $badgeConditions.hashCode());
        final java.lang.Object $badgeMetadataAttribute = this.getBadgeMetadataAttribute();
        result = result * PRIME + ($badgeMetadataAttribute == null ? 43 : $badgeMetadataAttribute.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Badge(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", badgeConditions=" + this.getBadgeConditions() + ", badgeMetadataAttribute=" + this.getBadgeMetadataAttribute() + ")";
    }

    /**
     * Fixed typeName for Badges.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
