// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a business policy template in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class BusinessPolicy extends Asset implements IBusinessPolicy, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(BusinessPolicy.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "BusinessPolicy";
    /**
     * Fixed typeName for BusinessPolicys.
     */
    String typeName;
    /**
     * Base parent Guid for policy used in version
     */
    @Attribute
    String businessPolicyBaseParentGuid;
    /**
     * Business Policy Filter ES DSL to denote the associate asset/s involved.
     */
    @Attribute
    String businessPolicyFilterDSL;
    /**
     * Body of the business policy, a long readme like document
     */
    @Attribute
    String businessPolicyLongDescription;
    /**
     * Duration for the business policy to complete review.
     */
    @Attribute
    String businessPolicyReviewPeriod;
    /**
     * Selected approval workflow id for business policy
     */
    @Attribute
    String businessPolicySelectedApprovalWF;
    /**
     * Type of business policy
     */
    @Attribute
    String businessPolicyType;
    /**
     * Validity start date of the policy
     */
    @Attribute
    @Date
    Long businessPolicyValidFrom;
    /**
     * Validity end date of the policy
     */
    @Attribute
    @Date
    Long businessPolicyValidTill;
    /**
     * Version of the policy
     */
    @Attribute
    Integer businessPolicyVersion;
    /**
     * Exception assigned to business polices
     */
    @Attribute
    SortedSet<IBusinessPolicyException> exceptionsForBusinessPolicy;
    /**
     * BusinessPolicy that have the same (or relatable) compliance
     */
    @Attribute
    SortedSet<IBusinessPolicy> relatedBusinessPolicies;

    /**
     * Builds the minimal object necessary to create a relationship to a BusinessPolicy, from a potentially
     * more-complete BusinessPolicy object.
     *
     * @return the minimal object necessary to relate to the BusinessPolicy
     * @throws InvalidRequestException if any of the minimal set of required properties for a BusinessPolicy relationship are not found in the initial object
     */
    @Override
    public BusinessPolicy trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all BusinessPolicy assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) BusinessPolicy assets will be included.
     *
     * @return a fluent search that includes all BusinessPolicy assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all BusinessPolicy assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) BusinessPolicy assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all BusinessPolicy assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all BusinessPolicy assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) BusinessPolicys will be included
     * @return a fluent search that includes all BusinessPolicy assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all BusinessPolicy assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) BusinessPolicys will be included
     * @return a fluent search that includes all BusinessPolicy assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a BusinessPolicy by GUID. Use this to create a relationship to this BusinessPolicy,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the BusinessPolicy to reference
     * @return reference to a BusinessPolicy that can be used for defining a relationship to a BusinessPolicy
     */
    public static BusinessPolicy refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a BusinessPolicy by GUID. Use this to create a relationship to this BusinessPolicy,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the BusinessPolicy to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a BusinessPolicy that can be used for defining a relationship to a BusinessPolicy
     */
    public static BusinessPolicy refByGuid(String guid, Reference.SaveSemantic semantic) {
        return BusinessPolicy._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a BusinessPolicy by qualifiedName. Use this to create a relationship to this BusinessPolicy,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the BusinessPolicy to reference
     * @return reference to a BusinessPolicy that can be used for defining a relationship to a BusinessPolicy
     */
    public static BusinessPolicy refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a BusinessPolicy by qualifiedName. Use this to create a relationship to this BusinessPolicy,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the BusinessPolicy to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a BusinessPolicy that can be used for defining a relationship to a BusinessPolicy
     */
    public static BusinessPolicy refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return BusinessPolicy._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a BusinessPolicy by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the BusinessPolicy to retrieve, either its GUID or its full qualifiedName
     * @return the requested full BusinessPolicy, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the BusinessPolicy does not exist or the provided GUID is not a BusinessPolicy
     */
    @JsonIgnore
    public static BusinessPolicy get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a BusinessPolicy by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the BusinessPolicy to retrieve, either its GUID or its full qualifiedName
     * @return the requested full BusinessPolicy, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the BusinessPolicy does not exist or the provided GUID is not a BusinessPolicy
     */
    @JsonIgnore
    public static BusinessPolicy get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a BusinessPolicy by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the BusinessPolicy to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full BusinessPolicy, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the BusinessPolicy does not exist or the provided GUID is not a BusinessPolicy
     */
    @JsonIgnore
    public static BusinessPolicy get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof BusinessPolicy) {
                return (BusinessPolicy) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof BusinessPolicy) {
                return (BusinessPolicy) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) BusinessPolicy to active.
     *
     * @param qualifiedName for the BusinessPolicy
     * @return true if the BusinessPolicy is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) BusinessPolicy to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the BusinessPolicy
     * @return true if the BusinessPolicy is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a BusinessPolicy.
     *
     * @param qualifiedName of the BusinessPolicy
     * @param name of the BusinessPolicy
     * @return the minimal request necessary to update the BusinessPolicy, as a builder
     */
    public static BusinessPolicyBuilder<?, ?> updater(String qualifiedName, String name) {
        return BusinessPolicy._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a BusinessPolicy, from a potentially
     * more-complete BusinessPolicy object.
     *
     * @return the minimal object necessary to update the BusinessPolicy, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for BusinessPolicy are not found in the initial object
     */
    @Override
    public BusinessPolicyBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a BusinessPolicy.
     *
     * @param qualifiedName of the BusinessPolicy
     * @param name of the BusinessPolicy
     * @return the updated BusinessPolicy, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a BusinessPolicy.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the BusinessPolicy
     * @param name of the BusinessPolicy
     * @return the updated BusinessPolicy, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicy) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a BusinessPolicy.
     *
     * @param qualifiedName of the BusinessPolicy
     * @param name of the BusinessPolicy
     * @return the updated BusinessPolicy, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a BusinessPolicy.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the BusinessPolicy
     * @param name of the BusinessPolicy
     * @return the updated BusinessPolicy, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicy) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a BusinessPolicy.
     *
     * @param qualifiedName of the BusinessPolicy
     * @param name of the BusinessPolicy
     * @return the updated BusinessPolicy, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a BusinessPolicy.
     *
     * @param client connectivity to the Atlan tenant from which to remove the BusinessPolicy's owners
     * @param qualifiedName of the BusinessPolicy
     * @param name of the BusinessPolicy
     * @return the updated BusinessPolicy, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicy) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a BusinessPolicy.
     *
     * @param qualifiedName of the BusinessPolicy
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated BusinessPolicy, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a BusinessPolicy.
     *
     * @param client connectivity to the Atlan tenant on which to update the BusinessPolicy's certificate
     * @param qualifiedName of the BusinessPolicy
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated BusinessPolicy, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (BusinessPolicy) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a BusinessPolicy.
     *
     * @param qualifiedName of the BusinessPolicy
     * @param name of the BusinessPolicy
     * @return the updated BusinessPolicy, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a BusinessPolicy.
     *
     * @param client connectivity to the Atlan tenant from which to remove the BusinessPolicy's certificate
     * @param qualifiedName of the BusinessPolicy
     * @param name of the BusinessPolicy
     * @return the updated BusinessPolicy, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicy) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a BusinessPolicy.
     *
     * @param qualifiedName of the BusinessPolicy
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a BusinessPolicy.
     *
     * @param client connectivity to the Atlan tenant on which to update the BusinessPolicy's announcement
     * @param qualifiedName of the BusinessPolicy
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (BusinessPolicy) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a BusinessPolicy.
     *
     * @param qualifiedName of the BusinessPolicy
     * @param name of the BusinessPolicy
     * @return the updated BusinessPolicy, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a BusinessPolicy.
     *
     * @param client connectivity to the Atlan client from which to remove the BusinessPolicy's announcement
     * @param qualifiedName of the BusinessPolicy
     * @param name of the BusinessPolicy
     * @return the updated BusinessPolicy, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicy) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the BusinessPolicy.
     *
     * @param qualifiedName for the BusinessPolicy
     * @param name human-readable name of the BusinessPolicy
     * @param terms the list of terms to replace on the BusinessPolicy, or null to remove all terms from the BusinessPolicy
     * @return the BusinessPolicy that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the BusinessPolicy.
     *
     * @param client connectivity to the Atlan tenant on which to replace the BusinessPolicy's assigned terms
     * @param qualifiedName for the BusinessPolicy
     * @param name human-readable name of the BusinessPolicy
     * @param terms the list of terms to replace on the BusinessPolicy, or null to remove all terms from the BusinessPolicy
     * @return the BusinessPolicy that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicy) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the BusinessPolicy, without replacing existing terms linked to the BusinessPolicy.
     * Note: this operation must make two API calls — one to retrieve the BusinessPolicy's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the BusinessPolicy
     * @param terms the list of terms to append to the BusinessPolicy
     * @return the BusinessPolicy that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the BusinessPolicy, without replacing existing terms linked to the BusinessPolicy.
     * Note: this operation must make two API calls — one to retrieve the BusinessPolicy's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the BusinessPolicy
     * @param qualifiedName for the BusinessPolicy
     * @param terms the list of terms to append to the BusinessPolicy
     * @return the BusinessPolicy that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicy) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a BusinessPolicy, without replacing all existing terms linked to the BusinessPolicy.
     * Note: this operation must make two API calls — one to retrieve the BusinessPolicy's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the BusinessPolicy
     * @param terms the list of terms to remove from the BusinessPolicy, which must be referenced by GUID
     * @return the BusinessPolicy that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a BusinessPolicy, without replacing all existing terms linked to the BusinessPolicy.
     * Note: this operation must make two API calls — one to retrieve the BusinessPolicy's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the BusinessPolicy
     * @param qualifiedName for the BusinessPolicy
     * @param terms the list of terms to remove from the BusinessPolicy, which must be referenced by GUID
     * @return the BusinessPolicy that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static BusinessPolicy removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicy) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a BusinessPolicy, without replacing existing Atlan tags linked to the BusinessPolicy.
     * Note: this operation must make two API calls — one to retrieve the BusinessPolicy's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the BusinessPolicy
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated BusinessPolicy
     */
    public static BusinessPolicy appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a BusinessPolicy, without replacing existing Atlan tags linked to the BusinessPolicy.
     * Note: this operation must make two API calls — one to retrieve the BusinessPolicy's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the BusinessPolicy
     * @param qualifiedName of the BusinessPolicy
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated BusinessPolicy
     */
    public static BusinessPolicy appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (BusinessPolicy) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a BusinessPolicy, without replacing existing Atlan tags linked to the BusinessPolicy.
     * Note: this operation must make two API calls — one to retrieve the BusinessPolicy's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the BusinessPolicy
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated BusinessPolicy
     */
    public static BusinessPolicy appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a BusinessPolicy, without replacing existing Atlan tags linked to the BusinessPolicy.
     * Note: this operation must make two API calls — one to retrieve the BusinessPolicy's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the BusinessPolicy
     * @param qualifiedName of the BusinessPolicy
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated BusinessPolicy
     */
    public static BusinessPolicy appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (BusinessPolicy) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a BusinessPolicy.
     *
     * @param qualifiedName of the BusinessPolicy
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the BusinessPolicy
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a BusinessPolicy.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a BusinessPolicy
     * @param qualifiedName of the BusinessPolicy
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the BusinessPolicy
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class BusinessPolicyBuilder<C extends BusinessPolicy, B extends BusinessPolicy.BusinessPolicyBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String businessPolicyBaseParentGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String businessPolicyFilterDSL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String businessPolicyLongDescription;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String businessPolicyReviewPeriod;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String businessPolicySelectedApprovalWF;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String businessPolicyType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long businessPolicyValidFrom;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long businessPolicyValidTill;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer businessPolicyVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IBusinessPolicyException> exceptionsForBusinessPolicy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IBusinessPolicy> relatedBusinessPolicies;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            BusinessPolicy.BusinessPolicyBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final BusinessPolicy instance, final BusinessPolicy.BusinessPolicyBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.businessPolicyBaseParentGuid(instance.businessPolicyBaseParentGuid);
            b.businessPolicyFilterDSL(instance.businessPolicyFilterDSL);
            b.businessPolicyLongDescription(instance.businessPolicyLongDescription);
            b.businessPolicyReviewPeriod(instance.businessPolicyReviewPeriod);
            b.businessPolicySelectedApprovalWF(instance.businessPolicySelectedApprovalWF);
            b.businessPolicyType(instance.businessPolicyType);
            b.businessPolicyValidFrom(instance.businessPolicyValidFrom);
            b.businessPolicyValidTill(instance.businessPolicyValidTill);
            b.businessPolicyVersion(instance.businessPolicyVersion);
            b.exceptionsForBusinessPolicy(instance.exceptionsForBusinessPolicy == null ? java.util.Collections.<IBusinessPolicyException>emptySortedSet() : instance.exceptionsForBusinessPolicy);
            b.relatedBusinessPolicies(instance.relatedBusinessPolicies == null ? java.util.Collections.<IBusinessPolicy>emptySortedSet() : instance.relatedBusinessPolicies);
        }

        /**
         * Fixed typeName for BusinessPolicys.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Base parent Guid for policy used in version
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B businessPolicyBaseParentGuid(final String businessPolicyBaseParentGuid) {
            this.businessPolicyBaseParentGuid = businessPolicyBaseParentGuid;
            return self();
        }

        /**
         * Business Policy Filter ES DSL to denote the associate asset/s involved.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B businessPolicyFilterDSL(final String businessPolicyFilterDSL) {
            this.businessPolicyFilterDSL = businessPolicyFilterDSL;
            return self();
        }

        /**
         * Body of the business policy, a long readme like document
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B businessPolicyLongDescription(final String businessPolicyLongDescription) {
            this.businessPolicyLongDescription = businessPolicyLongDescription;
            return self();
        }

        /**
         * Duration for the business policy to complete review.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B businessPolicyReviewPeriod(final String businessPolicyReviewPeriod) {
            this.businessPolicyReviewPeriod = businessPolicyReviewPeriod;
            return self();
        }

        /**
         * Selected approval workflow id for business policy
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B businessPolicySelectedApprovalWF(final String businessPolicySelectedApprovalWF) {
            this.businessPolicySelectedApprovalWF = businessPolicySelectedApprovalWF;
            return self();
        }

        /**
         * Type of business policy
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B businessPolicyType(final String businessPolicyType) {
            this.businessPolicyType = businessPolicyType;
            return self();
        }

        /**
         * Validity start date of the policy
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B businessPolicyValidFrom(final Long businessPolicyValidFrom) {
            this.businessPolicyValidFrom = businessPolicyValidFrom;
            return self();
        }

        /**
         * Validity end date of the policy
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B businessPolicyValidTill(final Long businessPolicyValidTill) {
            this.businessPolicyValidTill = businessPolicyValidTill;
            return self();
        }

        /**
         * Version of the policy
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B businessPolicyVersion(final Integer businessPolicyVersion) {
            this.businessPolicyVersion = businessPolicyVersion;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B exceptionForBusinessPolicy(final IBusinessPolicyException exceptionForBusinessPolicy) {
            if (this.exceptionsForBusinessPolicy == null) this.exceptionsForBusinessPolicy = new java.util.ArrayList<IBusinessPolicyException>();
            this.exceptionsForBusinessPolicy.add(exceptionForBusinessPolicy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B exceptionsForBusinessPolicy(final java.util.Collection<? extends IBusinessPolicyException> exceptionsForBusinessPolicy) {
            if (exceptionsForBusinessPolicy == null) {
                throw new java.lang.NullPointerException("exceptionsForBusinessPolicy cannot be null");
            }
            if (this.exceptionsForBusinessPolicy == null) this.exceptionsForBusinessPolicy = new java.util.ArrayList<IBusinessPolicyException>();
            this.exceptionsForBusinessPolicy.addAll(exceptionsForBusinessPolicy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearExceptionsForBusinessPolicy() {
            if (this.exceptionsForBusinessPolicy != null) this.exceptionsForBusinessPolicy.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relatedBusinessPolicy(final IBusinessPolicy relatedBusinessPolicy) {
            if (this.relatedBusinessPolicies == null) this.relatedBusinessPolicies = new java.util.ArrayList<IBusinessPolicy>();
            this.relatedBusinessPolicies.add(relatedBusinessPolicy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relatedBusinessPolicies(final java.util.Collection<? extends IBusinessPolicy> relatedBusinessPolicies) {
            if (relatedBusinessPolicies == null) {
                throw new java.lang.NullPointerException("relatedBusinessPolicies cannot be null");
            }
            if (this.relatedBusinessPolicies == null) this.relatedBusinessPolicies = new java.util.ArrayList<IBusinessPolicy>();
            this.relatedBusinessPolicies.addAll(relatedBusinessPolicies);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearRelatedBusinessPolicies() {
            if (this.relatedBusinessPolicies != null) this.relatedBusinessPolicies.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "BusinessPolicy.BusinessPolicyBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", businessPolicyBaseParentGuid=" + this.businessPolicyBaseParentGuid + ", businessPolicyFilterDSL=" + this.businessPolicyFilterDSL + ", businessPolicyLongDescription=" + this.businessPolicyLongDescription + ", businessPolicyReviewPeriod=" + this.businessPolicyReviewPeriod + ", businessPolicySelectedApprovalWF=" + this.businessPolicySelectedApprovalWF + ", businessPolicyType=" + this.businessPolicyType + ", businessPolicyValidFrom=" + this.businessPolicyValidFrom + ", businessPolicyValidTill=" + this.businessPolicyValidTill + ", businessPolicyVersion=" + this.businessPolicyVersion + ", exceptionsForBusinessPolicy=" + this.exceptionsForBusinessPolicy + ", relatedBusinessPolicies=" + this.relatedBusinessPolicies + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class BusinessPolicyBuilderImpl extends BusinessPolicy.BusinessPolicyBuilder<BusinessPolicy, BusinessPolicy.BusinessPolicyBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private BusinessPolicyBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected BusinessPolicy.BusinessPolicyBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public BusinessPolicy build() {
            return new BusinessPolicy(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected BusinessPolicy(final BusinessPolicy.BusinessPolicyBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = BusinessPolicy.$default$typeName();
        this.businessPolicyBaseParentGuid = b.businessPolicyBaseParentGuid;
        this.businessPolicyFilterDSL = b.businessPolicyFilterDSL;
        this.businessPolicyLongDescription = b.businessPolicyLongDescription;
        this.businessPolicyReviewPeriod = b.businessPolicyReviewPeriod;
        this.businessPolicySelectedApprovalWF = b.businessPolicySelectedApprovalWF;
        this.businessPolicyType = b.businessPolicyType;
        this.businessPolicyValidFrom = b.businessPolicyValidFrom;
        this.businessPolicyValidTill = b.businessPolicyValidTill;
        this.businessPolicyVersion = b.businessPolicyVersion;
        java.util.SortedSet<IBusinessPolicyException> exceptionsForBusinessPolicy = new java.util.TreeSet<IBusinessPolicyException>();
        if (b.exceptionsForBusinessPolicy != null) exceptionsForBusinessPolicy.addAll(b.exceptionsForBusinessPolicy);
        exceptionsForBusinessPolicy = java.util.Collections.unmodifiableSortedSet(exceptionsForBusinessPolicy);
        this.exceptionsForBusinessPolicy = exceptionsForBusinessPolicy;
        java.util.SortedSet<IBusinessPolicy> relatedBusinessPolicies = new java.util.TreeSet<IBusinessPolicy>();
        if (b.relatedBusinessPolicies != null) relatedBusinessPolicies.addAll(b.relatedBusinessPolicies);
        relatedBusinessPolicies = java.util.Collections.unmodifiableSortedSet(relatedBusinessPolicies);
        this.relatedBusinessPolicies = relatedBusinessPolicies;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static BusinessPolicy.BusinessPolicyBuilder<?, ?> _internal() {
        return new BusinessPolicy.BusinessPolicyBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BusinessPolicy.BusinessPolicyBuilder<?, ?> toBuilder() {
        return new BusinessPolicy.BusinessPolicyBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Base parent Guid for policy used in version
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBusinessPolicyBaseParentGuid() {
        return this.businessPolicyBaseParentGuid;
    }

    /**
     * Business Policy Filter ES DSL to denote the associate asset/s involved.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBusinessPolicyFilterDSL() {
        return this.businessPolicyFilterDSL;
    }

    /**
     * Body of the business policy, a long readme like document
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBusinessPolicyLongDescription() {
        return this.businessPolicyLongDescription;
    }

    /**
     * Duration for the business policy to complete review.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBusinessPolicyReviewPeriod() {
        return this.businessPolicyReviewPeriod;
    }

    /**
     * Selected approval workflow id for business policy
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBusinessPolicySelectedApprovalWF() {
        return this.businessPolicySelectedApprovalWF;
    }

    /**
     * Type of business policy
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBusinessPolicyType() {
        return this.businessPolicyType;
    }

    /**
     * Validity start date of the policy
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getBusinessPolicyValidFrom() {
        return this.businessPolicyValidFrom;
    }

    /**
     * Validity end date of the policy
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getBusinessPolicyValidTill() {
        return this.businessPolicyValidTill;
    }

    /**
     * Version of the policy
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getBusinessPolicyVersion() {
        return this.businessPolicyVersion;
    }

    /**
     * Exception assigned to business polices
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IBusinessPolicyException> getExceptionsForBusinessPolicy() {
        return this.exceptionsForBusinessPolicy;
    }

    /**
     * BusinessPolicy that have the same (or relatable) compliance
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IBusinessPolicy> getRelatedBusinessPolicies() {
        return this.relatedBusinessPolicies;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof BusinessPolicy)) return false;
        final BusinessPolicy other = (BusinessPolicy) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$businessPolicyValidFrom = this.getBusinessPolicyValidFrom();
        final java.lang.Object other$businessPolicyValidFrom = other.getBusinessPolicyValidFrom();
        if (this$businessPolicyValidFrom == null ? other$businessPolicyValidFrom != null : !this$businessPolicyValidFrom.equals(other$businessPolicyValidFrom)) return false;
        final java.lang.Object this$businessPolicyValidTill = this.getBusinessPolicyValidTill();
        final java.lang.Object other$businessPolicyValidTill = other.getBusinessPolicyValidTill();
        if (this$businessPolicyValidTill == null ? other$businessPolicyValidTill != null : !this$businessPolicyValidTill.equals(other$businessPolicyValidTill)) return false;
        final java.lang.Object this$businessPolicyVersion = this.getBusinessPolicyVersion();
        final java.lang.Object other$businessPolicyVersion = other.getBusinessPolicyVersion();
        if (this$businessPolicyVersion == null ? other$businessPolicyVersion != null : !this$businessPolicyVersion.equals(other$businessPolicyVersion)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$businessPolicyBaseParentGuid = this.getBusinessPolicyBaseParentGuid();
        final java.lang.Object other$businessPolicyBaseParentGuid = other.getBusinessPolicyBaseParentGuid();
        if (this$businessPolicyBaseParentGuid == null ? other$businessPolicyBaseParentGuid != null : !this$businessPolicyBaseParentGuid.equals(other$businessPolicyBaseParentGuid)) return false;
        final java.lang.Object this$businessPolicyFilterDSL = this.getBusinessPolicyFilterDSL();
        final java.lang.Object other$businessPolicyFilterDSL = other.getBusinessPolicyFilterDSL();
        if (this$businessPolicyFilterDSL == null ? other$businessPolicyFilterDSL != null : !this$businessPolicyFilterDSL.equals(other$businessPolicyFilterDSL)) return false;
        final java.lang.Object this$businessPolicyLongDescription = this.getBusinessPolicyLongDescription();
        final java.lang.Object other$businessPolicyLongDescription = other.getBusinessPolicyLongDescription();
        if (this$businessPolicyLongDescription == null ? other$businessPolicyLongDescription != null : !this$businessPolicyLongDescription.equals(other$businessPolicyLongDescription)) return false;
        final java.lang.Object this$businessPolicyReviewPeriod = this.getBusinessPolicyReviewPeriod();
        final java.lang.Object other$businessPolicyReviewPeriod = other.getBusinessPolicyReviewPeriod();
        if (this$businessPolicyReviewPeriod == null ? other$businessPolicyReviewPeriod != null : !this$businessPolicyReviewPeriod.equals(other$businessPolicyReviewPeriod)) return false;
        final java.lang.Object this$businessPolicySelectedApprovalWF = this.getBusinessPolicySelectedApprovalWF();
        final java.lang.Object other$businessPolicySelectedApprovalWF = other.getBusinessPolicySelectedApprovalWF();
        if (this$businessPolicySelectedApprovalWF == null ? other$businessPolicySelectedApprovalWF != null : !this$businessPolicySelectedApprovalWF.equals(other$businessPolicySelectedApprovalWF)) return false;
        final java.lang.Object this$businessPolicyType = this.getBusinessPolicyType();
        final java.lang.Object other$businessPolicyType = other.getBusinessPolicyType();
        if (this$businessPolicyType == null ? other$businessPolicyType != null : !this$businessPolicyType.equals(other$businessPolicyType)) return false;
        final java.lang.Object this$exceptionsForBusinessPolicy = this.getExceptionsForBusinessPolicy();
        final java.lang.Object other$exceptionsForBusinessPolicy = other.getExceptionsForBusinessPolicy();
        if (this$exceptionsForBusinessPolicy == null ? other$exceptionsForBusinessPolicy != null : !this$exceptionsForBusinessPolicy.equals(other$exceptionsForBusinessPolicy)) return false;
        final java.lang.Object this$relatedBusinessPolicies = this.getRelatedBusinessPolicies();
        final java.lang.Object other$relatedBusinessPolicies = other.getRelatedBusinessPolicies();
        if (this$relatedBusinessPolicies == null ? other$relatedBusinessPolicies != null : !this$relatedBusinessPolicies.equals(other$relatedBusinessPolicies)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof BusinessPolicy;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $businessPolicyValidFrom = this.getBusinessPolicyValidFrom();
        result = result * PRIME + ($businessPolicyValidFrom == null ? 43 : $businessPolicyValidFrom.hashCode());
        final java.lang.Object $businessPolicyValidTill = this.getBusinessPolicyValidTill();
        result = result * PRIME + ($businessPolicyValidTill == null ? 43 : $businessPolicyValidTill.hashCode());
        final java.lang.Object $businessPolicyVersion = this.getBusinessPolicyVersion();
        result = result * PRIME + ($businessPolicyVersion == null ? 43 : $businessPolicyVersion.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $businessPolicyBaseParentGuid = this.getBusinessPolicyBaseParentGuid();
        result = result * PRIME + ($businessPolicyBaseParentGuid == null ? 43 : $businessPolicyBaseParentGuid.hashCode());
        final java.lang.Object $businessPolicyFilterDSL = this.getBusinessPolicyFilterDSL();
        result = result * PRIME + ($businessPolicyFilterDSL == null ? 43 : $businessPolicyFilterDSL.hashCode());
        final java.lang.Object $businessPolicyLongDescription = this.getBusinessPolicyLongDescription();
        result = result * PRIME + ($businessPolicyLongDescription == null ? 43 : $businessPolicyLongDescription.hashCode());
        final java.lang.Object $businessPolicyReviewPeriod = this.getBusinessPolicyReviewPeriod();
        result = result * PRIME + ($businessPolicyReviewPeriod == null ? 43 : $businessPolicyReviewPeriod.hashCode());
        final java.lang.Object $businessPolicySelectedApprovalWF = this.getBusinessPolicySelectedApprovalWF();
        result = result * PRIME + ($businessPolicySelectedApprovalWF == null ? 43 : $businessPolicySelectedApprovalWF.hashCode());
        final java.lang.Object $businessPolicyType = this.getBusinessPolicyType();
        result = result * PRIME + ($businessPolicyType == null ? 43 : $businessPolicyType.hashCode());
        final java.lang.Object $exceptionsForBusinessPolicy = this.getExceptionsForBusinessPolicy();
        result = result * PRIME + ($exceptionsForBusinessPolicy == null ? 43 : $exceptionsForBusinessPolicy.hashCode());
        final java.lang.Object $relatedBusinessPolicies = this.getRelatedBusinessPolicies();
        result = result * PRIME + ($relatedBusinessPolicies == null ? 43 : $relatedBusinessPolicies.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "BusinessPolicy(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", businessPolicyBaseParentGuid=" + this.getBusinessPolicyBaseParentGuid() + ", businessPolicyFilterDSL=" + this.getBusinessPolicyFilterDSL() + ", businessPolicyLongDescription=" + this.getBusinessPolicyLongDescription() + ", businessPolicyReviewPeriod=" + this.getBusinessPolicyReviewPeriod() + ", businessPolicySelectedApprovalWF=" + this.getBusinessPolicySelectedApprovalWF() + ", businessPolicyType=" + this.getBusinessPolicyType() + ", businessPolicyValidFrom=" + this.getBusinessPolicyValidFrom() + ", businessPolicyValidTill=" + this.getBusinessPolicyValidTill() + ", businessPolicyVersion=" + this.getBusinessPolicyVersion() + ", exceptionsForBusinessPolicy=" + this.getExceptionsForBusinessPolicy() + ", relatedBusinessPolicies=" + this.getRelatedBusinessPolicies() + ")";
    }

    /**
     * Fixed typeName for BusinessPolicys.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
