// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Cognite asset in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class CogniteAsset extends Asset implements ICogniteAsset, ICognite, ISaaS, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CogniteAsset.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CogniteAsset";
    /**
     * Fixed typeName for CogniteAssets.
     */
    String typeName;
    /**
     * 3D models that exist within this asset.
     */
    @Attribute
    SortedSet<ICognite3DModel> cognite3dmodels;
    /**
     * Events that exist within this asset.
     */
    @Attribute
    SortedSet<ICogniteEvent> cogniteEvents;
    /**
     * Files that exist within this asset.
     */
    @Attribute
    SortedSet<ICogniteFile> cogniteFiles;
    /**
     * Sequences that exist within this asset.
     */
    @Attribute
    SortedSet<ICogniteSequence> cogniteSequences;
    /**
     * Time series that exist within this asset.
     */
    @Attribute
    SortedSet<ICogniteTimeSeries> cogniteTimeseries;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a CogniteAsset, from a potentially
     * more-complete CogniteAsset object.
     *
     * @return the minimal object necessary to relate to the CogniteAsset
     * @throws InvalidRequestException if any of the minimal set of required properties for a CogniteAsset relationship are not found in the initial object
     */
    @Override
    public CogniteAsset trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all CogniteAsset assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) CogniteAsset assets will be included.
     *
     * @return a fluent search that includes all CogniteAsset assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all CogniteAsset assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) CogniteAsset assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all CogniteAsset assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all CogniteAsset assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) CogniteAssets will be included
     * @return a fluent search that includes all CogniteAsset assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all CogniteAsset assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) CogniteAssets will be included
     * @return a fluent search that includes all CogniteAsset assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a CogniteAsset by GUID. Use this to create a relationship to this CogniteAsset,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the CogniteAsset to reference
     * @return reference to a CogniteAsset that can be used for defining a relationship to a CogniteAsset
     */
    public static CogniteAsset refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a CogniteAsset by GUID. Use this to create a relationship to this CogniteAsset,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the CogniteAsset to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a CogniteAsset that can be used for defining a relationship to a CogniteAsset
     */
    public static CogniteAsset refByGuid(String guid, Reference.SaveSemantic semantic) {
        return CogniteAsset._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a CogniteAsset by qualifiedName. Use this to create a relationship to this CogniteAsset,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the CogniteAsset to reference
     * @return reference to a CogniteAsset that can be used for defining a relationship to a CogniteAsset
     */
    public static CogniteAsset refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a CogniteAsset by qualifiedName. Use this to create a relationship to this CogniteAsset,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the CogniteAsset to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a CogniteAsset that can be used for defining a relationship to a CogniteAsset
     */
    public static CogniteAsset refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return CogniteAsset._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a CogniteAsset by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the CogniteAsset to retrieve, either its GUID or its full qualifiedName
     * @return the requested full CogniteAsset, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CogniteAsset does not exist or the provided GUID is not a CogniteAsset
     */
    @JsonIgnore
    public static CogniteAsset get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a CogniteAsset by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the CogniteAsset to retrieve, either its GUID or its full qualifiedName
     * @return the requested full CogniteAsset, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CogniteAsset does not exist or the provided GUID is not a CogniteAsset
     */
    @JsonIgnore
    public static CogniteAsset get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a CogniteAsset by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the CogniteAsset to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full CogniteAsset, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CogniteAsset does not exist or the provided GUID is not a CogniteAsset
     */
    @JsonIgnore
    public static CogniteAsset get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof CogniteAsset) {
                return (CogniteAsset) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof CogniteAsset) {
                return (CogniteAsset) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) CogniteAsset to active.
     *
     * @param qualifiedName for the CogniteAsset
     * @return true if the CogniteAsset is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) CogniteAsset to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the CogniteAsset
     * @return true if the CogniteAsset is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a CogniteAsset.
     *
     * @param qualifiedName of the CogniteAsset
     * @param name of the CogniteAsset
     * @return the minimal request necessary to update the CogniteAsset, as a builder
     */
    public static CogniteAssetBuilder<?, ?> updater(String qualifiedName, String name) {
        return CogniteAsset._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a CogniteAsset, from a potentially
     * more-complete CogniteAsset object.
     *
     * @return the minimal object necessary to update the CogniteAsset, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for CogniteAsset are not found in the initial object
     */
    @Override
    public CogniteAssetBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a CogniteAsset.
     *
     * @param qualifiedName of the CogniteAsset
     * @param name of the CogniteAsset
     * @return the updated CogniteAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a CogniteAsset.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the CogniteAsset
     * @param name of the CogniteAsset
     * @return the updated CogniteAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CogniteAsset) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a CogniteAsset.
     *
     * @param qualifiedName of the CogniteAsset
     * @param name of the CogniteAsset
     * @return the updated CogniteAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a CogniteAsset.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the CogniteAsset
     * @param name of the CogniteAsset
     * @return the updated CogniteAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CogniteAsset) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a CogniteAsset.
     *
     * @param qualifiedName of the CogniteAsset
     * @param name of the CogniteAsset
     * @return the updated CogniteAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a CogniteAsset.
     *
     * @param client connectivity to the Atlan tenant from which to remove the CogniteAsset's owners
     * @param qualifiedName of the CogniteAsset
     * @param name of the CogniteAsset
     * @return the updated CogniteAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CogniteAsset) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a CogniteAsset.
     *
     * @param qualifiedName of the CogniteAsset
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated CogniteAsset, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a CogniteAsset.
     *
     * @param client connectivity to the Atlan tenant on which to update the CogniteAsset's certificate
     * @param qualifiedName of the CogniteAsset
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated CogniteAsset, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CogniteAsset) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a CogniteAsset.
     *
     * @param qualifiedName of the CogniteAsset
     * @param name of the CogniteAsset
     * @return the updated CogniteAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a CogniteAsset.
     *
     * @param client connectivity to the Atlan tenant from which to remove the CogniteAsset's certificate
     * @param qualifiedName of the CogniteAsset
     * @param name of the CogniteAsset
     * @return the updated CogniteAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CogniteAsset) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a CogniteAsset.
     *
     * @param qualifiedName of the CogniteAsset
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a CogniteAsset.
     *
     * @param client connectivity to the Atlan tenant on which to update the CogniteAsset's announcement
     * @param qualifiedName of the CogniteAsset
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CogniteAsset) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a CogniteAsset.
     *
     * @param qualifiedName of the CogniteAsset
     * @param name of the CogniteAsset
     * @return the updated CogniteAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a CogniteAsset.
     *
     * @param client connectivity to the Atlan client from which to remove the CogniteAsset's announcement
     * @param qualifiedName of the CogniteAsset
     * @param name of the CogniteAsset
     * @return the updated CogniteAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CogniteAsset) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the CogniteAsset.
     *
     * @param qualifiedName for the CogniteAsset
     * @param name human-readable name of the CogniteAsset
     * @param terms the list of terms to replace on the CogniteAsset, or null to remove all terms from the CogniteAsset
     * @return the CogniteAsset that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the CogniteAsset.
     *
     * @param client connectivity to the Atlan tenant on which to replace the CogniteAsset's assigned terms
     * @param qualifiedName for the CogniteAsset
     * @param name human-readable name of the CogniteAsset
     * @param terms the list of terms to replace on the CogniteAsset, or null to remove all terms from the CogniteAsset
     * @return the CogniteAsset that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CogniteAsset) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the CogniteAsset, without replacing existing terms linked to the CogniteAsset.
     * Note: this operation must make two API calls — one to retrieve the CogniteAsset's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the CogniteAsset
     * @param terms the list of terms to append to the CogniteAsset
     * @return the CogniteAsset that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the CogniteAsset, without replacing existing terms linked to the CogniteAsset.
     * Note: this operation must make two API calls — one to retrieve the CogniteAsset's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the CogniteAsset
     * @param qualifiedName for the CogniteAsset
     * @param terms the list of terms to append to the CogniteAsset
     * @return the CogniteAsset that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CogniteAsset) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a CogniteAsset, without replacing all existing terms linked to the CogniteAsset.
     * Note: this operation must make two API calls — one to retrieve the CogniteAsset's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the CogniteAsset
     * @param terms the list of terms to remove from the CogniteAsset, which must be referenced by GUID
     * @return the CogniteAsset that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a CogniteAsset, without replacing all existing terms linked to the CogniteAsset.
     * Note: this operation must make two API calls — one to retrieve the CogniteAsset's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the CogniteAsset
     * @param qualifiedName for the CogniteAsset
     * @param terms the list of terms to remove from the CogniteAsset, which must be referenced by GUID
     * @return the CogniteAsset that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static CogniteAsset removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CogniteAsset) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a CogniteAsset, without replacing existing Atlan tags linked to the CogniteAsset.
     * Note: this operation must make two API calls — one to retrieve the CogniteAsset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the CogniteAsset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated CogniteAsset
     */
    public static CogniteAsset appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a CogniteAsset, without replacing existing Atlan tags linked to the CogniteAsset.
     * Note: this operation must make two API calls — one to retrieve the CogniteAsset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the CogniteAsset
     * @param qualifiedName of the CogniteAsset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated CogniteAsset
     */
    public static CogniteAsset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CogniteAsset) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a CogniteAsset, without replacing existing Atlan tags linked to the CogniteAsset.
     * Note: this operation must make two API calls — one to retrieve the CogniteAsset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the CogniteAsset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated CogniteAsset
     */
    public static CogniteAsset appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a CogniteAsset, without replacing existing Atlan tags linked to the CogniteAsset.
     * Note: this operation must make two API calls — one to retrieve the CogniteAsset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the CogniteAsset
     * @param qualifiedName of the CogniteAsset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated CogniteAsset
     */
    public static CogniteAsset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CogniteAsset) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a CogniteAsset.
     *
     * @param qualifiedName of the CogniteAsset
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the CogniteAsset
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a CogniteAsset.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a CogniteAsset
     * @param qualifiedName of the CogniteAsset
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the CogniteAsset
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class CogniteAssetBuilder<C extends CogniteAsset, B extends CogniteAsset.CogniteAssetBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICognite3DModel> cognite3dmodels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICogniteEvent> cogniteEvents;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICogniteFile> cogniteFiles;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICogniteSequence> cogniteSequences;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICogniteTimeSeries> cogniteTimeseries;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            CogniteAsset.CogniteAssetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final CogniteAsset instance, final CogniteAsset.CogniteAssetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cognite3dmodels(instance.cognite3dmodels == null ? java.util.Collections.<ICognite3DModel>emptySortedSet() : instance.cognite3dmodels);
            b.cogniteEvents(instance.cogniteEvents == null ? java.util.Collections.<ICogniteEvent>emptySortedSet() : instance.cogniteEvents);
            b.cogniteFiles(instance.cogniteFiles == null ? java.util.Collections.<ICogniteFile>emptySortedSet() : instance.cogniteFiles);
            b.cogniteSequences(instance.cogniteSequences == null ? java.util.Collections.<ICogniteSequence>emptySortedSet() : instance.cogniteSequences);
            b.cogniteTimeseries(instance.cogniteTimeseries == null ? java.util.Collections.<ICogniteTimeSeries>emptySortedSet() : instance.cogniteTimeseries);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for CogniteAssets.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cognite3dmodel(final ICognite3DModel cognite3dmodel) {
            if (this.cognite3dmodels == null) this.cognite3dmodels = new java.util.ArrayList<ICognite3DModel>();
            this.cognite3dmodels.add(cognite3dmodel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cognite3dmodels(final java.util.Collection<? extends ICognite3DModel> cognite3dmodels) {
            if (cognite3dmodels == null) {
                throw new java.lang.NullPointerException("cognite3dmodels cannot be null");
            }
            if (this.cognite3dmodels == null) this.cognite3dmodels = new java.util.ArrayList<ICognite3DModel>();
            this.cognite3dmodels.addAll(cognite3dmodels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCognite3dmodels() {
            if (this.cognite3dmodels != null) this.cognite3dmodels.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cogniteEvent(final ICogniteEvent cogniteEvent) {
            if (this.cogniteEvents == null) this.cogniteEvents = new java.util.ArrayList<ICogniteEvent>();
            this.cogniteEvents.add(cogniteEvent);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cogniteEvents(final java.util.Collection<? extends ICogniteEvent> cogniteEvents) {
            if (cogniteEvents == null) {
                throw new java.lang.NullPointerException("cogniteEvents cannot be null");
            }
            if (this.cogniteEvents == null) this.cogniteEvents = new java.util.ArrayList<ICogniteEvent>();
            this.cogniteEvents.addAll(cogniteEvents);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCogniteEvents() {
            if (this.cogniteEvents != null) this.cogniteEvents.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cogniteFile(final ICogniteFile cogniteFile) {
            if (this.cogniteFiles == null) this.cogniteFiles = new java.util.ArrayList<ICogniteFile>();
            this.cogniteFiles.add(cogniteFile);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cogniteFiles(final java.util.Collection<? extends ICogniteFile> cogniteFiles) {
            if (cogniteFiles == null) {
                throw new java.lang.NullPointerException("cogniteFiles cannot be null");
            }
            if (this.cogniteFiles == null) this.cogniteFiles = new java.util.ArrayList<ICogniteFile>();
            this.cogniteFiles.addAll(cogniteFiles);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCogniteFiles() {
            if (this.cogniteFiles != null) this.cogniteFiles.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cogniteSequence(final ICogniteSequence cogniteSequence) {
            if (this.cogniteSequences == null) this.cogniteSequences = new java.util.ArrayList<ICogniteSequence>();
            this.cogniteSequences.add(cogniteSequence);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cogniteSequences(final java.util.Collection<? extends ICogniteSequence> cogniteSequences) {
            if (cogniteSequences == null) {
                throw new java.lang.NullPointerException("cogniteSequences cannot be null");
            }
            if (this.cogniteSequences == null) this.cogniteSequences = new java.util.ArrayList<ICogniteSequence>();
            this.cogniteSequences.addAll(cogniteSequences);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCogniteSequences() {
            if (this.cogniteSequences != null) this.cogniteSequences.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B addCogniteTimeseries(final ICogniteTimeSeries addCogniteTimeseries) {
            if (this.cogniteTimeseries == null) this.cogniteTimeseries = new java.util.ArrayList<ICogniteTimeSeries>();
            this.cogniteTimeseries.add(addCogniteTimeseries);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cogniteTimeseries(final java.util.Collection<? extends ICogniteTimeSeries> cogniteTimeseries) {
            if (cogniteTimeseries == null) {
                throw new java.lang.NullPointerException("cogniteTimeseries cannot be null");
            }
            if (this.cogniteTimeseries == null) this.cogniteTimeseries = new java.util.ArrayList<ICogniteTimeSeries>();
            this.cogniteTimeseries.addAll(cogniteTimeseries);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCogniteTimeseries() {
            if (this.cogniteTimeseries != null) this.cogniteTimeseries.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "CogniteAsset.CogniteAssetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cognite3dmodels=" + this.cognite3dmodels + ", cogniteEvents=" + this.cogniteEvents + ", cogniteFiles=" + this.cogniteFiles + ", cogniteSequences=" + this.cogniteSequences + ", cogniteTimeseries=" + this.cogniteTimeseries + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class CogniteAssetBuilderImpl extends CogniteAsset.CogniteAssetBuilder<CogniteAsset, CogniteAsset.CogniteAssetBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CogniteAssetBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected CogniteAsset.CogniteAssetBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CogniteAsset build() {
            return new CogniteAsset(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected CogniteAsset(final CogniteAsset.CogniteAssetBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = CogniteAsset.$default$typeName();
        java.util.SortedSet<ICognite3DModel> cognite3dmodels = new java.util.TreeSet<ICognite3DModel>();
        if (b.cognite3dmodels != null) cognite3dmodels.addAll(b.cognite3dmodels);
        cognite3dmodels = java.util.Collections.unmodifiableSortedSet(cognite3dmodels);
        this.cognite3dmodels = cognite3dmodels;
        java.util.SortedSet<ICogniteEvent> cogniteEvents = new java.util.TreeSet<ICogniteEvent>();
        if (b.cogniteEvents != null) cogniteEvents.addAll(b.cogniteEvents);
        cogniteEvents = java.util.Collections.unmodifiableSortedSet(cogniteEvents);
        this.cogniteEvents = cogniteEvents;
        java.util.SortedSet<ICogniteFile> cogniteFiles = new java.util.TreeSet<ICogniteFile>();
        if (b.cogniteFiles != null) cogniteFiles.addAll(b.cogniteFiles);
        cogniteFiles = java.util.Collections.unmodifiableSortedSet(cogniteFiles);
        this.cogniteFiles = cogniteFiles;
        java.util.SortedSet<ICogniteSequence> cogniteSequences = new java.util.TreeSet<ICogniteSequence>();
        if (b.cogniteSequences != null) cogniteSequences.addAll(b.cogniteSequences);
        cogniteSequences = java.util.Collections.unmodifiableSortedSet(cogniteSequences);
        this.cogniteSequences = cogniteSequences;
        java.util.SortedSet<ICogniteTimeSeries> cogniteTimeseries = new java.util.TreeSet<ICogniteTimeSeries>();
        if (b.cogniteTimeseries != null) cogniteTimeseries.addAll(b.cogniteTimeseries);
        cogniteTimeseries = java.util.Collections.unmodifiableSortedSet(cogniteTimeseries);
        this.cogniteTimeseries = cogniteTimeseries;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static CogniteAsset.CogniteAssetBuilder<?, ?> _internal() {
        return new CogniteAsset.CogniteAssetBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CogniteAsset.CogniteAssetBuilder<?, ?> toBuilder() {
        return new CogniteAsset.CogniteAssetBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * 3D models that exist within this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICognite3DModel> getCognite3dmodels() {
        return this.cognite3dmodels;
    }

    /**
     * Events that exist within this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICogniteEvent> getCogniteEvents() {
        return this.cogniteEvents;
    }

    /**
     * Files that exist within this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICogniteFile> getCogniteFiles() {
        return this.cogniteFiles;
    }

    /**
     * Sequences that exist within this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICogniteSequence> getCogniteSequences() {
        return this.cogniteSequences;
    }

    /**
     * Time series that exist within this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICogniteTimeSeries> getCogniteTimeseries() {
        return this.cogniteTimeseries;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CogniteAsset)) return false;
        final CogniteAsset other = (CogniteAsset) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$cognite3dmodels = this.getCognite3dmodels();
        final java.lang.Object other$cognite3dmodels = other.getCognite3dmodels();
        if (this$cognite3dmodels == null ? other$cognite3dmodels != null : !this$cognite3dmodels.equals(other$cognite3dmodels)) return false;
        final java.lang.Object this$cogniteEvents = this.getCogniteEvents();
        final java.lang.Object other$cogniteEvents = other.getCogniteEvents();
        if (this$cogniteEvents == null ? other$cogniteEvents != null : !this$cogniteEvents.equals(other$cogniteEvents)) return false;
        final java.lang.Object this$cogniteFiles = this.getCogniteFiles();
        final java.lang.Object other$cogniteFiles = other.getCogniteFiles();
        if (this$cogniteFiles == null ? other$cogniteFiles != null : !this$cogniteFiles.equals(other$cogniteFiles)) return false;
        final java.lang.Object this$cogniteSequences = this.getCogniteSequences();
        final java.lang.Object other$cogniteSequences = other.getCogniteSequences();
        if (this$cogniteSequences == null ? other$cogniteSequences != null : !this$cogniteSequences.equals(other$cogniteSequences)) return false;
        final java.lang.Object this$cogniteTimeseries = this.getCogniteTimeseries();
        final java.lang.Object other$cogniteTimeseries = other.getCogniteTimeseries();
        if (this$cogniteTimeseries == null ? other$cogniteTimeseries != null : !this$cogniteTimeseries.equals(other$cogniteTimeseries)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CogniteAsset;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $cognite3dmodels = this.getCognite3dmodels();
        result = result * PRIME + ($cognite3dmodels == null ? 43 : $cognite3dmodels.hashCode());
        final java.lang.Object $cogniteEvents = this.getCogniteEvents();
        result = result * PRIME + ($cogniteEvents == null ? 43 : $cogniteEvents.hashCode());
        final java.lang.Object $cogniteFiles = this.getCogniteFiles();
        result = result * PRIME + ($cogniteFiles == null ? 43 : $cogniteFiles.hashCode());
        final java.lang.Object $cogniteSequences = this.getCogniteSequences();
        result = result * PRIME + ($cogniteSequences == null ? 43 : $cogniteSequences.hashCode());
        final java.lang.Object $cogniteTimeseries = this.getCogniteTimeseries();
        result = result * PRIME + ($cogniteTimeseries == null ? 43 : $cogniteTimeseries.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "CogniteAsset(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cognite3dmodels=" + this.getCognite3dmodels() + ", cogniteEvents=" + this.getCogniteEvents() + ", cogniteFiles=" + this.getCogniteFiles() + ", cogniteSequences=" + this.getCogniteSequences() + ", cogniteTimeseries=" + this.getCogniteTimeseries() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for CogniteAssets.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
