// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.ColumnValueFrequencyMap;
import com.atlan.model.structs.Histogram;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a column in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class Column extends Asset implements IColumn, ISQL, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(Column.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Column";
    /**
     * Fixed typeName for Columns.
     */
    String typeName;
    /**
     * Calculate view in which this column exists.
     */
    @Attribute
    ICalculationView calculationView;
    /**
     * Simple name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @Attribute
    String calculationViewName;
    /**
     * Unique name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @Attribute
    String calculationViewQualifiedName;
    /**
     * Average value in this column.
     */
    @Attribute
    Double columnAverage;
    /**
     * Average length of values in a string column.
     */
    @Attribute
    Double columnAverageLength;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtModelColumn> columnDbtModelColumns;
    /**
     * Level of nesting of this column, used for STRUCT and NESTED columns.
     */
    @Attribute
    Integer columnDepthLevel;
    /**
     * Number of rows that contain distinct values.
     */
    @Attribute
    Integer columnDistinctValuesCount;
    /**
     * Number of rows that contain distinct values.
     */
    @Attribute
    Long columnDistinctValuesCountLong;
    /**
     * Number of rows that contain duplicate values.
     */
    @Attribute
    Integer columnDuplicateValuesCount;
    /**
     * Number of rows that contain duplicate values.
     */
    @Attribute
    Long columnDuplicateValuesCountLong;
    /**
     * List of top-level upstream nested columns.
     */
    @Attribute
    List<Map<String, String>> columnHierarchy;
    /**
     * List of values in a histogram that represents the contents of this column.
     */
    @Attribute
    Histogram columnHistogram;
    /**
     * Greatest value in a numeric column.
     */
    @Attribute
    Double columnMax;
    /**
     * Length of the longest value in a string column.
     */
    @Attribute
    Integer columnMaximumStringLength;
    /**
     * List of the greatest values in a column.
     */
    @Attribute
    SortedSet<String> columnMaxs;
    /**
     * Arithmetic mean of the values in a numeric column.
     */
    @Attribute
    Double columnMean;
    /**
     * Calculated median of the values in a numeric column.
     */
    @Attribute
    Double columnMedian;
    /**
     * Least value in a numeric column.
     */
    @Attribute
    Double columnMin;
    /**
     * Length of the shortest value in a string column.
     */
    @Attribute
    Integer columnMinimumStringLength;
    /**
     * List of the least values in a column.
     */
    @Attribute
    SortedSet<String> columnMins;
    /**
     * Number of rows in a column that do not contain content.
     */
    @Attribute
    Integer columnMissingValuesCount;
    /**
     * Number of rows in a column that do not contain content.
     */
    @Attribute
    Long columnMissingValuesCountLong;
    /**
     * Percentage of rows in a column that do not contain content.
     */
    @Attribute
    Double columnMissingValuesPercentage;
    /**
     * Calculated standard deviation of the values in a numeric column.
     */
    @Attribute
    Double columnStandardDeviation;
    /**
     * Calculated sum of the values in a numeric column.
     */
    @Attribute
    Double columnSum;
    /**
     * List of top values in this column.
     */
    @Attribute
    List<ColumnValueFrequencyMap> columnTopValues;
    /**
     * Number of rows in which a value in this column appears only once.
     */
    @Attribute
    Integer columnUniqueValuesCount;
    /**
     * Number of rows in which a value in this column appears only once.
     */
    @Attribute
    Long columnUniqueValuesCountLong;
    /**
     * Ratio indicating how unique data in this column is: 0 indicates that all values are the same, 100 indicates that all values in this column are unique.
     */
    @Attribute
    Double columnUniquenessPercentage;
    /**
     * Calculated variance of the values in a numeric column.
     */
    @Attribute
    Double columnVariance;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IMetric> dataQualityMetricDimensions;
    /**
     * Data type of values in this column.
     */
    @Attribute
    String dataType;
    /**
     * Simple name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @Attribute
    String databaseName;
    /**
     * Unique name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @Attribute
    String databaseQualifiedName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtMetric> dbtMetrics;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtModelColumn> dbtModelColumns;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    /**
     * Default value for this column.
     */
    @Attribute
    String defaultValue;
    /**
     * Column this foreign key column refers to.
     */
    @Attribute
    IColumn foreignKeyFrom;
    /**
     * Columns that use this column as a foreign key.
     */
    @Attribute
    SortedSet<IColumn> foreignKeyTo;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Whether this column is a clustered column (true) or not (false).
     */
    @Attribute
    Boolean isClustered;
    /**
     * Whether this column is a distribution column (true) or not (false).
     */
    @Attribute
    Boolean isDist;
    /**
     * When true, this column is a foreign key to another table. NOTE: this must be true when using the foreignKeyTo relationship to specify columns that refer to this column as a foreign key.
     */
    @Attribute
    Boolean isForeign;
    /**
     * When true, this column is indexed in the database.
     */
    @Attribute
    Boolean isIndexed;
    /**
     * When true, the values in this column can be null.
     */
    @Attribute
    Boolean isNullable;
    /**
     * Whether this column is a partition column (true) or not (false).
     */
    @Attribute
    Boolean isPartition;
    /**
     * Whether this column is pinned (true) or not (false).
     */
    @Attribute
    Boolean isPinned;
    /**
     * When true, this column is the primary key for the table.
     */
    @Attribute
    Boolean isPrimary;
    /**
     * Whether this asset has been profiled (true) or not (false).
     */
    @Attribute
    Boolean isProfiled;
    /**
     * Whether this column is a sort column (true) or not (false).
     */
    @Attribute
    Boolean isSort;
    /**
     * Time (epoch) at which this asset was last profiled, in milliseconds.
     */
    @Attribute
    @Date
    Long lastProfiledAt;
    /**
     * Materialized view in which this column exists.
     */
    @Attribute
    @JsonProperty("materialisedView")
    IMaterializedView materializedView;
    /**
     * Maximum length of a value in this column.
     */
    @Attribute
    Long maxLength;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IMetric> metricTimestamps;
    /**
     * Number of columns nested within this (STRUCT or NESTED) column.
     */
    @Attribute
    Integer nestedColumnCount;
    /**
     * Order (position) in which this column appears in the nested Column (nest level starts at 1).
     */
    @Attribute
    String nestedColumnOrder;
    /**
     * Nested columns that exist within this column.
     */
    @Attribute
    SortedSet<IColumn> nestedColumns;
    /**
     * Number of digits allowed to the right of the decimal point.
     */
    @Attribute
    Double numericScale;
    /**
     * Order (position) in which this column appears in the table (starting at 1).
     */
    @Attribute
    Integer order;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Column in which this sub-column is nested.
     */
    @Attribute
    IColumn parentColumn;
    /**
     * Simple name of the column this column is nested within, for STRUCT and NESTED columns.
     */
    @Attribute
    String parentColumnName;
    /**
     * Unique name of the column this column is nested within, for STRUCT and NESTED columns.
     */
    @Attribute
    String parentColumnQualifiedName;
    /**
     * Order (position) of this partition column in the table.
     */
    @Attribute
    Integer partitionOrder;
    /**
     * Time (epoch) at which this column was pinned, in milliseconds.
     */
    @Attribute
    @Date
    Long pinnedAt;
    /**
     * User who pinned this column.
     */
    @Attribute
    String pinnedBy;
    /**
     * Total number of digits allowed, when the dataType is numeric.
     */
    @Attribute
    Integer precision;
    /**
     * Queries that access this column.
     */
    @Attribute
    SortedSet<IAtlanQuery> queries;
    /**
     * Number of times this asset has been queried.
     */
    @Attribute
    Long queryCount;
    /**
     * Time (epoch) at which the query count was last updated, in milliseconds.
     */
    @Attribute
    @Date
    Long queryCountUpdatedAt;
    /**
     * Number of unique users who have queried this asset.
     */
    @Attribute
    Long queryUserCount;
    /**
     * Map of unique users who have queried this asset to the number of times they have queried it.
     */
    @Attribute
    Map<String, Long> queryUserMap;
    /**
     * TBC
     */
    @Attribute
    String rawDataTypeDefinition;
    /**
     * Simple name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @Attribute
    String schemaName;
    /**
     * Unique name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @Attribute
    String schemaQualifiedName;
    /**
     * Snowflake dynamic table in which this column exists.
     */
    @Attribute
    ISnowflakeDynamicTable snowflakeDynamicTable;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    /**
     * Sub-data type of this column.
     */
    @Attribute
    String subDataType;
    /**
     * Table in which this column exists.
     */
    @Attribute
    ITable table;
    /**
     * Simple name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @Attribute
    String tableName;
    /**
     * Table partition that contains this column.
     */
    @Attribute
    ITablePartition tablePartition;
    /**
     * Unique name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @Attribute
    String tableQualifiedName;
    /**
     * Validations for this column.
     */
    @Attribute
    Map<String, String> validations;
    /**
     * View in which this column exists.
     */
    @Attribute
    IView view;
    /**
     * Simple name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @Attribute
    String viewName;
    /**
     * Unique name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @Attribute
    String viewQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a Column, from a potentially
     * more-complete Column object.
     *
     * @return the minimal object necessary to relate to the Column
     * @throws InvalidRequestException if any of the minimal set of required properties for a Column relationship are not found in the initial object
     */
    @Override
    public Column trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all Column assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Column assets will be included.
     *
     * @return a fluent search that includes all Column assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all Column assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Column assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all Column assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all Column assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) Columns will be included
     * @return a fluent search that includes all Column assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all Column assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) Columns will be included
     * @return a fluent search that includes all Column assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a Column by GUID. Use this to create a relationship to this Column,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the Column to reference
     * @return reference to a Column that can be used for defining a relationship to a Column
     */
    public static Column refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Column by GUID. Use this to create a relationship to this Column,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the Column to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Column that can be used for defining a relationship to a Column
     */
    public static Column refByGuid(String guid, Reference.SaveSemantic semantic) {
        return Column._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a Column by qualifiedName. Use this to create a relationship to this Column,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the Column to reference
     * @return reference to a Column that can be used for defining a relationship to a Column
     */
    public static Column refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Column by qualifiedName. Use this to create a relationship to this Column,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the Column to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Column that can be used for defining a relationship to a Column
     */
    public static Column refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return Column._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a Column by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the Column to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Column, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Column does not exist or the provided GUID is not a Column
     */
    @JsonIgnore
    public static Column get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a Column by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Column to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Column, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Column does not exist or the provided GUID is not a Column
     */
    @JsonIgnore
    public static Column get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a Column by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Column to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full Column, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Column does not exist or the provided GUID is not a Column
     */
    @JsonIgnore
    public static Column get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof Column) {
                return (Column) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof Column) {
                return (Column) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) Column to active.
     *
     * @param qualifiedName for the Column
     * @return true if the Column is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) Column to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the Column
     * @return true if the Column is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Retrieve the parent of this Column, irrespective of its type.
     * @return the reference to this Column's parent
     */
    public ISQL getParent() {
        if (table != null) {
            return (ISQL) table;
        } else if (view != null) {
            return (ISQL) view;
        } else if (materializedView != null) {
            return (ISQL) materializedView;
        } else if (tablePartition != null) {
            return (ISQL) tablePartition;
        }
        return null;
    }

    /**
     * Builds the minimal object necessary to create a Column.
     *
     * @param name of the Column
     * @param table in which the Column should be created, which must have at least
     *              a qualifiedName
     * @param order the order the Column appears within its table (the Column's position)
     * @return the minimal request necessary to create the Column, as a builder
     * @throws InvalidRequestException if the table provided is without a qualifiedName
     */
    public static ColumnBuilder<?, ?> creator(String name, Table table, int order) throws InvalidRequestException {
        validateRelationship(Table.TYPE_NAME, Map.of("connectionQualifiedName", table.getConnectionQualifiedName(), "databaseName", table.getDatabaseName(), "databaseQualifiedName", table.getDatabaseQualifiedName(), "schemaName", table.getSchemaName(), "schemaQualifiedName", table.getSchemaQualifiedName(), "name", table.getName(), "qualifiedName", table.getQualifiedName()));
        return creator(name, table.getConnectionQualifiedName(), table.getDatabaseName(), table.getDatabaseQualifiedName(), table.getSchemaName(), table.getSchemaQualifiedName(), table.getName(), table.getQualifiedName(), Table.TYPE_NAME, null, null, order).table(table.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a Column.
     *
     * @param name of the Column
     * @param partition in which the Column should be created, which must have at least
     *                  a qualifiedName
     * @param order the order the Column appears within its partition (the Column's position)
     * @return the minimal request necessary to create the Column, as a builder
     * @throws InvalidRequestException if the partition provided is without a qualifiedName
     */
    public static ColumnBuilder<?, ?> creator(String name, TablePartition partition, int order) throws InvalidRequestException {
        validateRelationship(TablePartition.TYPE_NAME, Map.of("connectionQualifiedName", partition.getConnectionQualifiedName(), "databaseName", partition.getDatabaseName(), "databaseQualifiedName", partition.getDatabaseQualifiedName(), "schemaName", partition.getSchemaName(), "schemaQualifiedName", partition.getSchemaQualifiedName(), "name", partition.getName(), "qualifiedName", partition.getQualifiedName(), "tableName", partition.getTableName(), "tableQualifiedName", partition.getTableQualifiedName()));
        return creator(name, partition.getConnectionQualifiedName(), partition.getDatabaseName(), partition.getDatabaseQualifiedName(), partition.getSchemaName(), partition.getSchemaQualifiedName(), partition.getName(), partition.getQualifiedName(), TablePartition.TYPE_NAME, partition.getTableName(), partition.getTableQualifiedName(), order).tablePartition(partition.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a Column.
     *
     * @param name of the Column
     * @param view in which the Column should be created, which must have at least
     *             a qualifiedName
     * @param order the order the Column appears within its view (the Column's position)
     * @return the minimal request necessary to create the Column, as a builder
     * @throws InvalidRequestException if the view provided is without a qualifiedName
     */
    public static ColumnBuilder<?, ?> creator(String name, View view, int order) throws InvalidRequestException {
        validateRelationship(View.TYPE_NAME, Map.of("connectionQualifiedName", view.getConnectionQualifiedName(), "databaseName", view.getDatabaseName(), "databaseQualifiedName", view.getDatabaseQualifiedName(), "schemaName", view.getSchemaName(), "schemaQualifiedName", view.getSchemaQualifiedName(), "name", view.getName(), "qualifiedName", view.getQualifiedName()));
        return creator(name, view.getConnectionQualifiedName(), view.getDatabaseName(), view.getDatabaseQualifiedName(), view.getSchemaName(), view.getSchemaQualifiedName(), view.getName(), view.getQualifiedName(), View.TYPE_NAME, null, null, order).view(view.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a Column.
     *
     * @param name of the Column
     * @param view in which the Column should be created, which must have at least
     *             a qualifiedName
     * @param order the order the Column appears within its materialized view (the Column's position)
     * @return the minimal request necessary to create the Column, as a builder
     * @throws InvalidRequestException if the materialized view provided is without a qualifiedName
     */
    public static ColumnBuilder<?, ?> creator(String name, MaterializedView view, int order) throws InvalidRequestException {
        validateRelationship(MaterializedView.TYPE_NAME, Map.of("connectionQualifiedName", view.getConnectionQualifiedName(), "databaseName", view.getDatabaseName(), "databaseQualifiedName", view.getDatabaseQualifiedName(), "schemaName", view.getSchemaName(), "schemaQualifiedName", view.getSchemaQualifiedName(), "name", view.getName(), "qualifiedName", view.getQualifiedName()));
        return creator(name, view.getConnectionQualifiedName(), view.getDatabaseName(), view.getDatabaseQualifiedName(), view.getSchemaName(), view.getSchemaQualifiedName(), view.getName(), view.getQualifiedName(), MaterializedView.TYPE_NAME, null, null, order).materializedView(view.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a Column.
     *
     * @param name of the Column
     * @param parentType type of parent (table, view, materialized view), should be a TYPE_NAME static string
     * @param parentQualifiedName unique name of the table / view / materialized view in which this Column exists
     * @param order the order the Column appears within its parent (the Column's position)
     * @return the minimal request necessary to create the Column, as a builder
     */
    public static ColumnBuilder<?, ?> creator(String name, String parentType, String parentQualifiedName, int order) {
        String parentName = StringUtils.getNameFromQualifiedName(parentQualifiedName);
        String tableName = null;
        String tableQualifiedName = null;
        String schemaQualifiedName;
        if (TablePartition.TYPE_NAME.equals(parentType)) {
            tableQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(parentQualifiedName);
            tableName = StringUtils.getNameFromQualifiedName(tableQualifiedName);
            schemaQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(tableQualifiedName);
        } else {
            schemaQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(parentQualifiedName);
        }
        String schemaName = StringUtils.getNameFromQualifiedName(schemaQualifiedName);
        String databaseQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(schemaQualifiedName);
        String databaseName = StringUtils.getNameFromQualifiedName(databaseQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(databaseQualifiedName);
        return creator(name, connectionQualifiedName, databaseName, databaseQualifiedName, schemaName, schemaQualifiedName, parentName, parentQualifiedName, parentType, tableName, tableQualifiedName, order);
    }

    /**
     * Builds the minimal object necessary to create a Column.
     *
     * @param name of the Column
     * @param connectionQualifiedName unique name of the connection in which the Column should be created
     * @param databaseName simple name of the database in which the Column should be created
     * @param databaseQualifiedName unique name of the database in which the Column should be created
     * @param schemaName simple name of the schema in which the Column should be created
     * @param schemaQualifiedName unique name of the schema in which the Column should be created
     * @param parentName simple name of the table / view / materialized view in which the Column should be created
     * @param parentQualifiedName unique name of the table / view / materialized view in which this Column exists
     * @param parentType type of parent (table, view, materialized view), should be a TYPE_NAME static string
     * @param tableName simple name of the table if the parentType is TablePartition
     * @param tableQualifiedName unique name of the table if the parentType is TablePartition
     * @param order the order the Column appears within its parent (the Column's position)
     * @return the minimal request necessary to create the Column, as a builder
     */
    public static ColumnBuilder<?, ?> creator(String name, String connectionQualifiedName, String databaseName, String databaseQualifiedName, String schemaName, String schemaQualifiedName, String parentName, String parentQualifiedName, String parentType, String tableName, String tableQualifiedName, int order) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(parentQualifiedName);
        ColumnBuilder<?, ?> builder = Column._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).name(name).qualifiedName(generateQualifiedName(name, parentQualifiedName)).connectorType(connectorType).schemaName(schemaName).schemaQualifiedName(schemaQualifiedName).databaseName(databaseName).databaseQualifiedName(databaseQualifiedName).connectionQualifiedName(connectionQualifiedName).order(order);
        switch (parentType) {
        case Table.TYPE_NAME: 
            builder.tableName(parentName).tableQualifiedName(parentQualifiedName).table(Table.refByQualifiedName(parentQualifiedName));
            break;
        case View.TYPE_NAME: 
            builder.viewName(parentName).viewQualifiedName(parentQualifiedName).view(View.refByQualifiedName(parentQualifiedName));
            break;
        case MaterializedView.TYPE_NAME: 
            builder.viewName(parentName).viewQualifiedName(parentQualifiedName).materializedView(MaterializedView.refByQualifiedName(parentQualifiedName));
            break;
        case TablePartition.TYPE_NAME: 
            builder.tableName(tableName).tableQualifiedName(tableQualifiedName).tablePartition(TablePartition.refByQualifiedName(parentQualifiedName));
            break;
        }
        return builder;
    }

    /**
     * Generate a unique Column name.
     *
     * @param name of the Column
     * @param parentQualifiedName unique name of the container in which this Column exists
     * @return a unique name for the Column
     */
    public static String generateQualifiedName(String name, String parentQualifiedName) {
        return parentQualifiedName + "/" + name;
    }

    /**
     * Builds the minimal object necessary to update a Column.
     *
     * @param qualifiedName of the Column
     * @param name of the Column
     * @return the minimal request necessary to update the Column, as a builder
     */
    public static ColumnBuilder<?, ?> updater(String qualifiedName, String name) {
        return Column._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a Column, from a potentially
     * more-complete Column object.
     *
     * @return the minimal object necessary to update the Column, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for Column are not found in the initial object
     */
    @Override
    public ColumnBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a Column.
     *
     * @param qualifiedName of the Column
     * @param name of the Column
     * @return the updated Column, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Column removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a Column.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Column
     * @param name of the Column
     * @return the updated Column, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Column removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Column) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a Column.
     *
     * @param qualifiedName of the Column
     * @param name of the Column
     * @return the updated Column, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Column removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a Column.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Column
     * @param name of the Column
     * @return the updated Column, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Column removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Column) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a Column.
     *
     * @param qualifiedName of the Column
     * @param name of the Column
     * @return the updated Column, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Column removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a Column.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Column's owners
     * @param qualifiedName of the Column
     * @param name of the Column
     * @return the updated Column, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Column removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Column) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a Column.
     *
     * @param qualifiedName of the Column
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Column, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Column updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a Column.
     *
     * @param client connectivity to the Atlan tenant on which to update the Column's certificate
     * @param qualifiedName of the Column
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Column, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Column updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Column) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a Column.
     *
     * @param qualifiedName of the Column
     * @param name of the Column
     * @return the updated Column, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Column removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a Column.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Column's certificate
     * @param qualifiedName of the Column
     * @param name of the Column
     * @return the updated Column, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Column removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Column) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a Column.
     *
     * @param qualifiedName of the Column
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Column updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a Column.
     *
     * @param client connectivity to the Atlan tenant on which to update the Column's announcement
     * @param qualifiedName of the Column
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Column updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Column) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a Column.
     *
     * @param qualifiedName of the Column
     * @param name of the Column
     * @return the updated Column, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Column removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a Column.
     *
     * @param client connectivity to the Atlan client from which to remove the Column's announcement
     * @param qualifiedName of the Column
     * @param name of the Column
     * @return the updated Column, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Column removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Column) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the Column.
     *
     * @param qualifiedName for the Column
     * @param name human-readable name of the Column
     * @param terms the list of terms to replace on the Column, or null to remove all terms from the Column
     * @return the Column that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Column replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the Column.
     *
     * @param client connectivity to the Atlan tenant on which to replace the Column's assigned terms
     * @param qualifiedName for the Column
     * @param name human-readable name of the Column
     * @param terms the list of terms to replace on the Column, or null to remove all terms from the Column
     * @return the Column that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Column replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Column) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the Column, without replacing existing terms linked to the Column.
     * Note: this operation must make two API calls — one to retrieve the Column's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the Column
     * @param terms the list of terms to append to the Column
     * @return the Column that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Column appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the Column, without replacing existing terms linked to the Column.
     * Note: this operation must make two API calls — one to retrieve the Column's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the Column
     * @param qualifiedName for the Column
     * @param terms the list of terms to append to the Column
     * @return the Column that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Column appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Column) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a Column, without replacing all existing terms linked to the Column.
     * Note: this operation must make two API calls — one to retrieve the Column's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the Column
     * @param terms the list of terms to remove from the Column, which must be referenced by GUID
     * @return the Column that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Column removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a Column, without replacing all existing terms linked to the Column.
     * Note: this operation must make two API calls — one to retrieve the Column's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the Column
     * @param qualifiedName for the Column
     * @param terms the list of terms to remove from the Column, which must be referenced by GUID
     * @return the Column that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Column removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Column) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a Column, without replacing existing Atlan tags linked to the Column.
     * Note: this operation must make two API calls — one to retrieve the Column's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Column
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Column
     */
    public static Column appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Column, without replacing existing Atlan tags linked to the Column.
     * Note: this operation must make two API calls — one to retrieve the Column's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Column
     * @param qualifiedName of the Column
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Column
     */
    public static Column appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Column) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Column, without replacing existing Atlan tags linked to the Column.
     * Note: this operation must make two API calls — one to retrieve the Column's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Column
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Column
     */
    public static Column appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a Column, without replacing existing Atlan tags linked to the Column.
     * Note: this operation must make two API calls — one to retrieve the Column's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Column
     * @param qualifiedName of the Column
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Column
     */
    public static Column appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Column) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a Column.
     *
     * @param qualifiedName of the Column
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Column
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a Column.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a Column
     * @param qualifiedName of the Column
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Column
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class ColumnBuilder<C extends Column, B extends Column.ColumnBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ICalculationView calculationView;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String calculationViewName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String calculationViewQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double columnAverage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double columnAverageLength;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModelColumn> columnDbtModelColumns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer columnDepthLevel;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer columnDistinctValuesCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long columnDistinctValuesCountLong;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer columnDuplicateValuesCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long columnDuplicateValuesCountLong;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> columnHierarchy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Histogram columnHistogram;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double columnMax;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer columnMaximumStringLength;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> columnMaxs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double columnMean;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double columnMedian;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double columnMin;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer columnMinimumStringLength;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> columnMins;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer columnMissingValuesCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long columnMissingValuesCountLong;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double columnMissingValuesPercentage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double columnStandardDeviation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double columnSum;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ColumnValueFrequencyMap> columnTopValues;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer columnUniqueValuesCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long columnUniqueValuesCountLong;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double columnUniquenessPercentage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double columnVariance;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMetric> dataQualityMetricDimensions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dataType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String databaseName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String databaseQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtMetric> dbtMetrics;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModelColumn> dbtModelColumns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModel> dbtModels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtSource> dbtSources;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtTest> dbtTests;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String defaultValue;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IColumn foreignKeyFrom;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IColumn> foreignKeyTo;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isClustered;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isDist;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isForeign;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isIndexed;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isNullable;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isPartition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isPinned;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isPrimary;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isProfiled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isSort;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long lastProfiledAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IMaterializedView materializedView;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long maxLength;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMetric> metricTimestamps;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer nestedColumnCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String nestedColumnOrder;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IColumn> nestedColumns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double numericScale;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer order;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IColumn parentColumn;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String parentColumnName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String parentColumnQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer partitionOrder;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long pinnedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String pinnedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer precision;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAtlanQuery> queries;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryCountUpdatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryUserCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> queryUserMap$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Long> queryUserMap$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String rawDataTypeDefinition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ISnowflakeDynamicTable snowflakeDynamicTable;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtSource> sqlDBTSources;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModel> sqlDbtModels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String subDataType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ITable table;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ITablePartition tablePartition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> validations$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> validations$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IView view;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String viewName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String viewQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Column.ColumnBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Column instance, final Column.ColumnBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.calculationView(instance.calculationView);
            b.calculationViewName(instance.calculationViewName);
            b.calculationViewQualifiedName(instance.calculationViewQualifiedName);
            b.columnAverage(instance.columnAverage);
            b.columnAverageLength(instance.columnAverageLength);
            b.columnDbtModelColumns(instance.columnDbtModelColumns == null ? java.util.Collections.<IDbtModelColumn>emptySortedSet() : instance.columnDbtModelColumns);
            b.columnDepthLevel(instance.columnDepthLevel);
            b.columnDistinctValuesCount(instance.columnDistinctValuesCount);
            b.columnDistinctValuesCountLong(instance.columnDistinctValuesCountLong);
            b.columnDuplicateValuesCount(instance.columnDuplicateValuesCount);
            b.columnDuplicateValuesCountLong(instance.columnDuplicateValuesCountLong);
            b.columnHierarchy(instance.columnHierarchy == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.columnHierarchy);
            b.columnHistogram(instance.columnHistogram);
            b.columnMax(instance.columnMax);
            b.columnMaximumStringLength(instance.columnMaximumStringLength);
            b.columnMaxs(instance.columnMaxs == null ? java.util.Collections.<String>emptySortedSet() : instance.columnMaxs);
            b.columnMean(instance.columnMean);
            b.columnMedian(instance.columnMedian);
            b.columnMin(instance.columnMin);
            b.columnMinimumStringLength(instance.columnMinimumStringLength);
            b.columnMins(instance.columnMins == null ? java.util.Collections.<String>emptySortedSet() : instance.columnMins);
            b.columnMissingValuesCount(instance.columnMissingValuesCount);
            b.columnMissingValuesCountLong(instance.columnMissingValuesCountLong);
            b.columnMissingValuesPercentage(instance.columnMissingValuesPercentage);
            b.columnStandardDeviation(instance.columnStandardDeviation);
            b.columnSum(instance.columnSum);
            b.columnTopValues(instance.columnTopValues == null ? java.util.Collections.<ColumnValueFrequencyMap>emptyList() : instance.columnTopValues);
            b.columnUniqueValuesCount(instance.columnUniqueValuesCount);
            b.columnUniqueValuesCountLong(instance.columnUniqueValuesCountLong);
            b.columnUniquenessPercentage(instance.columnUniquenessPercentage);
            b.columnVariance(instance.columnVariance);
            b.dataQualityMetricDimensions(instance.dataQualityMetricDimensions == null ? java.util.Collections.<IMetric>emptySortedSet() : instance.dataQualityMetricDimensions);
            b.dataType(instance.dataType);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtMetrics(instance.dbtMetrics == null ? java.util.Collections.<IDbtMetric>emptySortedSet() : instance.dbtMetrics);
            b.dbtModelColumns(instance.dbtModelColumns == null ? java.util.Collections.<IDbtModelColumn>emptySortedSet() : instance.dbtModelColumns);
            b.dbtModels(instance.dbtModels == null ? java.util.Collections.<IDbtModel>emptySortedSet() : instance.dbtModels);
            b.dbtSources(instance.dbtSources == null ? java.util.Collections.<IDbtSource>emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? java.util.Collections.<IDbtTest>emptySortedSet() : instance.dbtTests);
            b.defaultValue(instance.defaultValue);
            b.foreignKeyFrom(instance.foreignKeyFrom);
            b.foreignKeyTo(instance.foreignKeyTo == null ? java.util.Collections.<IColumn>emptySortedSet() : instance.foreignKeyTo);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.isClustered(instance.isClustered);
            b.isDist(instance.isDist);
            b.isForeign(instance.isForeign);
            b.isIndexed(instance.isIndexed);
            b.isNullable(instance.isNullable);
            b.isPartition(instance.isPartition);
            b.isPinned(instance.isPinned);
            b.isPrimary(instance.isPrimary);
            b.isProfiled(instance.isProfiled);
            b.isSort(instance.isSort);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.materializedView(instance.materializedView);
            b.maxLength(instance.maxLength);
            b.metricTimestamps(instance.metricTimestamps == null ? java.util.Collections.<IMetric>emptySortedSet() : instance.metricTimestamps);
            b.nestedColumnCount(instance.nestedColumnCount);
            b.nestedColumnOrder(instance.nestedColumnOrder);
            b.nestedColumns(instance.nestedColumns == null ? java.util.Collections.<IColumn>emptySortedSet() : instance.nestedColumns);
            b.numericScale(instance.numericScale);
            b.order(instance.order);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.parentColumn(instance.parentColumn);
            b.parentColumnName(instance.parentColumnName);
            b.parentColumnQualifiedName(instance.parentColumnQualifiedName);
            b.partitionOrder(instance.partitionOrder);
            b.pinnedAt(instance.pinnedAt);
            b.pinnedBy(instance.pinnedBy);
            b.precision(instance.precision);
            b.queries(instance.queries == null ? java.util.Collections.<IAtlanQuery>emptySortedSet() : instance.queries);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? java.util.Collections.<String, Long>emptyMap() : instance.queryUserMap);
            b.rawDataTypeDefinition(instance.rawDataTypeDefinition);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.snowflakeDynamicTable(instance.snowflakeDynamicTable);
            b.sqlDBTSources(instance.sqlDBTSources == null ? java.util.Collections.<IDbtSource>emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? java.util.Collections.<IDbtModel>emptySortedSet() : instance.sqlDbtModels);
            b.subDataType(instance.subDataType);
            b.table(instance.table);
            b.tableName(instance.tableName);
            b.tablePartition(instance.tablePartition);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.validations(instance.validations == null ? java.util.Collections.<String, String>emptyMap() : instance.validations);
            b.view(instance.view);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
        }

        /**
         * Fixed typeName for Columns.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Calculate view in which this column exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationView(final ICalculationView calculationView) {
            this.calculationView = calculationView;
            return self();
        }

        /**
         * Simple name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationViewName(final String calculationViewName) {
            this.calculationViewName = calculationViewName;
            return self();
        }

        /**
         * Unique name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationViewQualifiedName(final String calculationViewQualifiedName) {
            this.calculationViewQualifiedName = calculationViewQualifiedName;
            return self();
        }

        /**
         * Average value in this column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnAverage(final Double columnAverage) {
            this.columnAverage = columnAverage;
            return self();
        }

        /**
         * Average length of values in a string column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnAverageLength(final Double columnAverageLength) {
            this.columnAverageLength = columnAverageLength;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnDbtModelColumn(final IDbtModelColumn columnDbtModelColumn) {
            if (this.columnDbtModelColumns == null) this.columnDbtModelColumns = new java.util.ArrayList<IDbtModelColumn>();
            this.columnDbtModelColumns.add(columnDbtModelColumn);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnDbtModelColumns(final java.util.Collection<? extends IDbtModelColumn> columnDbtModelColumns) {
            if (columnDbtModelColumns == null) {
                throw new java.lang.NullPointerException("columnDbtModelColumns cannot be null");
            }
            if (this.columnDbtModelColumns == null) this.columnDbtModelColumns = new java.util.ArrayList<IDbtModelColumn>();
            this.columnDbtModelColumns.addAll(columnDbtModelColumns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumnDbtModelColumns() {
            if (this.columnDbtModelColumns != null) this.columnDbtModelColumns.clear();
            return self();
        }

        /**
         * Level of nesting of this column, used for STRUCT and NESTED columns.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnDepthLevel(final Integer columnDepthLevel) {
            this.columnDepthLevel = columnDepthLevel;
            return self();
        }

        /**
         * Number of rows that contain distinct values.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnDistinctValuesCount(final Integer columnDistinctValuesCount) {
            this.columnDistinctValuesCount = columnDistinctValuesCount;
            return self();
        }

        /**
         * Number of rows that contain distinct values.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnDistinctValuesCountLong(final Long columnDistinctValuesCountLong) {
            this.columnDistinctValuesCountLong = columnDistinctValuesCountLong;
            return self();
        }

        /**
         * Number of rows that contain duplicate values.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnDuplicateValuesCount(final Integer columnDuplicateValuesCount) {
            this.columnDuplicateValuesCount = columnDuplicateValuesCount;
            return self();
        }

        /**
         * Number of rows that contain duplicate values.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnDuplicateValuesCountLong(final Long columnDuplicateValuesCountLong) {
            this.columnDuplicateValuesCountLong = columnDuplicateValuesCountLong;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putColumnHierarchy(final Map<String, String> putColumnHierarchy) {
            if (this.columnHierarchy == null) this.columnHierarchy = new java.util.ArrayList<Map<String, String>>();
            this.columnHierarchy.add(putColumnHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnHierarchy(final java.util.Collection<? extends Map<String, String>> columnHierarchy) {
            if (columnHierarchy == null) {
                throw new java.lang.NullPointerException("columnHierarchy cannot be null");
            }
            if (this.columnHierarchy == null) this.columnHierarchy = new java.util.ArrayList<Map<String, String>>();
            this.columnHierarchy.addAll(columnHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumnHierarchy() {
            if (this.columnHierarchy != null) this.columnHierarchy.clear();
            return self();
        }

        /**
         * List of values in a histogram that represents the contents of this column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnHistogram(final Histogram columnHistogram) {
            this.columnHistogram = columnHistogram;
            return self();
        }

        /**
         * Greatest value in a numeric column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnMax(final Double columnMax) {
            this.columnMax = columnMax;
            return self();
        }

        /**
         * Length of the longest value in a string column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnMaximumStringLength(final Integer columnMaximumStringLength) {
            this.columnMaximumStringLength = columnMaximumStringLength;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B addColumnMax(final String addColumnMax) {
            if (this.columnMaxs == null) this.columnMaxs = new java.util.ArrayList<String>();
            this.columnMaxs.add(addColumnMax);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnMaxs(final java.util.Collection<? extends String> columnMaxs) {
            if (columnMaxs == null) {
                throw new java.lang.NullPointerException("columnMaxs cannot be null");
            }
            if (this.columnMaxs == null) this.columnMaxs = new java.util.ArrayList<String>();
            this.columnMaxs.addAll(columnMaxs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumnMaxs() {
            if (this.columnMaxs != null) this.columnMaxs.clear();
            return self();
        }

        /**
         * Arithmetic mean of the values in a numeric column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnMean(final Double columnMean) {
            this.columnMean = columnMean;
            return self();
        }

        /**
         * Calculated median of the values in a numeric column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnMedian(final Double columnMedian) {
            this.columnMedian = columnMedian;
            return self();
        }

        /**
         * Least value in a numeric column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnMin(final Double columnMin) {
            this.columnMin = columnMin;
            return self();
        }

        /**
         * Length of the shortest value in a string column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnMinimumStringLength(final Integer columnMinimumStringLength) {
            this.columnMinimumStringLength = columnMinimumStringLength;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B addColumnMin(final String addColumnMin) {
            if (this.columnMins == null) this.columnMins = new java.util.ArrayList<String>();
            this.columnMins.add(addColumnMin);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnMins(final java.util.Collection<? extends String> columnMins) {
            if (columnMins == null) {
                throw new java.lang.NullPointerException("columnMins cannot be null");
            }
            if (this.columnMins == null) this.columnMins = new java.util.ArrayList<String>();
            this.columnMins.addAll(columnMins);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumnMins() {
            if (this.columnMins != null) this.columnMins.clear();
            return self();
        }

        /**
         * Number of rows in a column that do not contain content.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnMissingValuesCount(final Integer columnMissingValuesCount) {
            this.columnMissingValuesCount = columnMissingValuesCount;
            return self();
        }

        /**
         * Number of rows in a column that do not contain content.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnMissingValuesCountLong(final Long columnMissingValuesCountLong) {
            this.columnMissingValuesCountLong = columnMissingValuesCountLong;
            return self();
        }

        /**
         * Percentage of rows in a column that do not contain content.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnMissingValuesPercentage(final Double columnMissingValuesPercentage) {
            this.columnMissingValuesPercentage = columnMissingValuesPercentage;
            return self();
        }

        /**
         * Calculated standard deviation of the values in a numeric column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnStandardDeviation(final Double columnStandardDeviation) {
            this.columnStandardDeviation = columnStandardDeviation;
            return self();
        }

        /**
         * Calculated sum of the values in a numeric column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnSum(final Double columnSum) {
            this.columnSum = columnSum;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnTopValue(final ColumnValueFrequencyMap columnTopValue) {
            if (this.columnTopValues == null) this.columnTopValues = new java.util.ArrayList<ColumnValueFrequencyMap>();
            this.columnTopValues.add(columnTopValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnTopValues(final java.util.Collection<? extends ColumnValueFrequencyMap> columnTopValues) {
            if (columnTopValues == null) {
                throw new java.lang.NullPointerException("columnTopValues cannot be null");
            }
            if (this.columnTopValues == null) this.columnTopValues = new java.util.ArrayList<ColumnValueFrequencyMap>();
            this.columnTopValues.addAll(columnTopValues);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumnTopValues() {
            if (this.columnTopValues != null) this.columnTopValues.clear();
            return self();
        }

        /**
         * Number of rows in which a value in this column appears only once.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnUniqueValuesCount(final Integer columnUniqueValuesCount) {
            this.columnUniqueValuesCount = columnUniqueValuesCount;
            return self();
        }

        /**
         * Number of rows in which a value in this column appears only once.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnUniqueValuesCountLong(final Long columnUniqueValuesCountLong) {
            this.columnUniqueValuesCountLong = columnUniqueValuesCountLong;
            return self();
        }

        /**
         * Ratio indicating how unique data in this column is: 0 indicates that all values are the same, 100 indicates that all values in this column are unique.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnUniquenessPercentage(final Double columnUniquenessPercentage) {
            this.columnUniquenessPercentage = columnUniquenessPercentage;
            return self();
        }

        /**
         * Calculated variance of the values in a numeric column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnVariance(final Double columnVariance) {
            this.columnVariance = columnVariance;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataQualityMetricDimension(final IMetric dataQualityMetricDimension) {
            if (this.dataQualityMetricDimensions == null) this.dataQualityMetricDimensions = new java.util.ArrayList<IMetric>();
            this.dataQualityMetricDimensions.add(dataQualityMetricDimension);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataQualityMetricDimensions(final java.util.Collection<? extends IMetric> dataQualityMetricDimensions) {
            if (dataQualityMetricDimensions == null) {
                throw new java.lang.NullPointerException("dataQualityMetricDimensions cannot be null");
            }
            if (this.dataQualityMetricDimensions == null) this.dataQualityMetricDimensions = new java.util.ArrayList<IMetric>();
            this.dataQualityMetricDimensions.addAll(dataQualityMetricDimensions);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDataQualityMetricDimensions() {
            if (this.dataQualityMetricDimensions != null) this.dataQualityMetricDimensions.clear();
            return self();
        }

        /**
         * Data type of values in this column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataType(final String dataType) {
            this.dataType = dataType;
            return self();
        }

        /**
         * Simple name of the database in which this SQL asset exists, or empty if it does not exist within a database.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B databaseName(final String databaseName) {
            this.databaseName = databaseName;
            return self();
        }

        /**
         * Unique name of the database in which this SQL asset exists, or empty if it does not exist within a database.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B databaseQualifiedName(final String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtMetric(final IDbtMetric dbtMetric) {
            if (this.dbtMetrics == null) this.dbtMetrics = new java.util.ArrayList<IDbtMetric>();
            this.dbtMetrics.add(dbtMetric);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtMetrics(final java.util.Collection<? extends IDbtMetric> dbtMetrics) {
            if (dbtMetrics == null) {
                throw new java.lang.NullPointerException("dbtMetrics cannot be null");
            }
            if (this.dbtMetrics == null) this.dbtMetrics = new java.util.ArrayList<IDbtMetric>();
            this.dbtMetrics.addAll(dbtMetrics);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtMetrics() {
            if (this.dbtMetrics != null) this.dbtMetrics.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelColumn(final IDbtModelColumn dbtModelColumn) {
            if (this.dbtModelColumns == null) this.dbtModelColumns = new java.util.ArrayList<IDbtModelColumn>();
            this.dbtModelColumns.add(dbtModelColumn);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelColumns(final java.util.Collection<? extends IDbtModelColumn> dbtModelColumns) {
            if (dbtModelColumns == null) {
                throw new java.lang.NullPointerException("dbtModelColumns cannot be null");
            }
            if (this.dbtModelColumns == null) this.dbtModelColumns = new java.util.ArrayList<IDbtModelColumn>();
            this.dbtModelColumns.addAll(dbtModelColumns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtModelColumns() {
            if (this.dbtModelColumns != null) this.dbtModelColumns.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModel(final IDbtModel dbtModel) {
            if (this.dbtModels == null) this.dbtModels = new java.util.ArrayList<IDbtModel>();
            this.dbtModels.add(dbtModel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModels(final java.util.Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new java.lang.NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) this.dbtModels = new java.util.ArrayList<IDbtModel>();
            this.dbtModels.addAll(dbtModels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) this.dbtModels.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtSource(final IDbtSource dbtSource) {
            if (this.dbtSources == null) this.dbtSources = new java.util.ArrayList<IDbtSource>();
            this.dbtSources.add(dbtSource);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtSources(final java.util.Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new java.lang.NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) this.dbtSources = new java.util.ArrayList<IDbtSource>();
            this.dbtSources.addAll(dbtSources);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) this.dbtSources.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTest(final IDbtTest dbtTest) {
            if (this.dbtTests == null) this.dbtTests = new java.util.ArrayList<IDbtTest>();
            this.dbtTests.add(dbtTest);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTests(final java.util.Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new java.lang.NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) this.dbtTests = new java.util.ArrayList<IDbtTest>();
            this.dbtTests.addAll(dbtTests);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) this.dbtTests.clear();
            return self();
        }

        /**
         * Default value for this column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B defaultValue(final String defaultValue) {
            this.defaultValue = defaultValue;
            return self();
        }

        /**
         * Column this foreign key column refers to.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B foreignKeyFrom(final IColumn foreignKeyFrom) {
            this.foreignKeyFrom = foreignKeyFrom;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B addForeignKeyTo(final IColumn addForeignKeyTo) {
            if (this.foreignKeyTo == null) this.foreignKeyTo = new java.util.ArrayList<IColumn>();
            this.foreignKeyTo.add(addForeignKeyTo);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B foreignKeyTo(final java.util.Collection<? extends IColumn> foreignKeyTo) {
            if (foreignKeyTo == null) {
                throw new java.lang.NullPointerException("foreignKeyTo cannot be null");
            }
            if (this.foreignKeyTo == null) this.foreignKeyTo = new java.util.ArrayList<IColumn>();
            this.foreignKeyTo.addAll(foreignKeyTo);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearForeignKeyTo() {
            if (this.foreignKeyTo != null) this.foreignKeyTo.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Whether this column is a clustered column (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isClustered(final Boolean isClustered) {
            this.isClustered = isClustered;
            return self();
        }

        /**
         * Whether this column is a distribution column (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isDist(final Boolean isDist) {
            this.isDist = isDist;
            return self();
        }

        /**
         * When true, this column is a foreign key to another table. NOTE: this must be true when using the foreignKeyTo relationship to specify columns that refer to this column as a foreign key.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isForeign(final Boolean isForeign) {
            this.isForeign = isForeign;
            return self();
        }

        /**
         * When true, this column is indexed in the database.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isIndexed(final Boolean isIndexed) {
            this.isIndexed = isIndexed;
            return self();
        }

        /**
         * When true, the values in this column can be null.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isNullable(final Boolean isNullable) {
            this.isNullable = isNullable;
            return self();
        }

        /**
         * Whether this column is a partition column (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isPartition(final Boolean isPartition) {
            this.isPartition = isPartition;
            return self();
        }

        /**
         * Whether this column is pinned (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isPinned(final Boolean isPinned) {
            this.isPinned = isPinned;
            return self();
        }

        /**
         * When true, this column is the primary key for the table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isPrimary(final Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return self();
        }

        /**
         * Whether this asset has been profiled (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isProfiled(final Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return self();
        }

        /**
         * Whether this column is a sort column (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isSort(final Boolean isSort) {
            this.isSort = isSort;
            return self();
        }

        /**
         * Time (epoch) at which this asset was last profiled, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lastProfiledAt(final Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return self();
        }

        /**
         * Materialized view in which this column exists.
         * @return {@code this}.
         */
        @JsonProperty("materialisedView")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B materializedView(final IMaterializedView materializedView) {
            this.materializedView = materializedView;
            return self();
        }

        /**
         * Maximum length of a value in this column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B maxLength(final Long maxLength) {
            this.maxLength = maxLength;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metricTimestamp(final IMetric metricTimestamp) {
            if (this.metricTimestamps == null) this.metricTimestamps = new java.util.ArrayList<IMetric>();
            this.metricTimestamps.add(metricTimestamp);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metricTimestamps(final java.util.Collection<? extends IMetric> metricTimestamps) {
            if (metricTimestamps == null) {
                throw new java.lang.NullPointerException("metricTimestamps cannot be null");
            }
            if (this.metricTimestamps == null) this.metricTimestamps = new java.util.ArrayList<IMetric>();
            this.metricTimestamps.addAll(metricTimestamps);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMetricTimestamps() {
            if (this.metricTimestamps != null) this.metricTimestamps.clear();
            return self();
        }

        /**
         * Number of columns nested within this (STRUCT or NESTED) column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B nestedColumnCount(final Integer nestedColumnCount) {
            this.nestedColumnCount = nestedColumnCount;
            return self();
        }

        /**
         * Order (position) in which this column appears in the nested Column (nest level starts at 1).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B nestedColumnOrder(final String nestedColumnOrder) {
            this.nestedColumnOrder = nestedColumnOrder;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B nestedColumn(final IColumn nestedColumn) {
            if (this.nestedColumns == null) this.nestedColumns = new java.util.ArrayList<IColumn>();
            this.nestedColumns.add(nestedColumn);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B nestedColumns(final java.util.Collection<? extends IColumn> nestedColumns) {
            if (nestedColumns == null) {
                throw new java.lang.NullPointerException("nestedColumns cannot be null");
            }
            if (this.nestedColumns == null) this.nestedColumns = new java.util.ArrayList<IColumn>();
            this.nestedColumns.addAll(nestedColumns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearNestedColumns() {
            if (this.nestedColumns != null) this.nestedColumns.clear();
            return self();
        }

        /**
         * Number of digits allowed to the right of the decimal point.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B numericScale(final Double numericScale) {
            this.numericScale = numericScale;
            return self();
        }

        /**
         * Order (position) in which this column appears in the table (starting at 1).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B order(final Integer order) {
            this.order = order;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Column in which this sub-column is nested.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B parentColumn(final IColumn parentColumn) {
            this.parentColumn = parentColumn;
            return self();
        }

        /**
         * Simple name of the column this column is nested within, for STRUCT and NESTED columns.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B parentColumnName(final String parentColumnName) {
            this.parentColumnName = parentColumnName;
            return self();
        }

        /**
         * Unique name of the column this column is nested within, for STRUCT and NESTED columns.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B parentColumnQualifiedName(final String parentColumnQualifiedName) {
            this.parentColumnQualifiedName = parentColumnQualifiedName;
            return self();
        }

        /**
         * Order (position) of this partition column in the table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B partitionOrder(final Integer partitionOrder) {
            this.partitionOrder = partitionOrder;
            return self();
        }

        /**
         * Time (epoch) at which this column was pinned, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B pinnedAt(final Long pinnedAt) {
            this.pinnedAt = pinnedAt;
            return self();
        }

        /**
         * User who pinned this column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B pinnedBy(final String pinnedBy) {
            this.pinnedBy = pinnedBy;
            return self();
        }

        /**
         * Total number of digits allowed, when the dataType is numeric.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B precision(final Integer precision) {
            this.precision = precision;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B query(final IAtlanQuery query) {
            if (this.queries == null) this.queries = new java.util.ArrayList<IAtlanQuery>();
            this.queries.add(query);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queries(final java.util.Collection<? extends IAtlanQuery> queries) {
            if (queries == null) {
                throw new java.lang.NullPointerException("queries cannot be null");
            }
            if (this.queries == null) this.queries = new java.util.ArrayList<IAtlanQuery>();
            this.queries.addAll(queries);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQueries() {
            if (this.queries != null) this.queries.clear();
            return self();
        }

        /**
         * Number of times this asset has been queried.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryCount(final Long queryCount) {
            this.queryCount = queryCount;
            return self();
        }

        /**
         * Time (epoch) at which the query count was last updated, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryCountUpdatedAt(final Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return self();
        }

        /**
         * Number of unique users who have queried this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryUserCount(final Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putQueryUserMap(final String putQueryUserMapKey, final Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new java.util.ArrayList<String>();
                this.queryUserMap$value = new java.util.ArrayList<Long>();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryUserMap(final java.util.Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new java.lang.NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new java.util.ArrayList<String>();
                this.queryUserMap$value = new java.util.ArrayList<Long>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B rawDataTypeDefinition(final String rawDataTypeDefinition) {
            this.rawDataTypeDefinition = rawDataTypeDefinition;
            return self();
        }

        /**
         * Simple name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaName(final String schemaName) {
            this.schemaName = schemaName;
            return self();
        }

        /**
         * Unique name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaQualifiedName(final String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return self();
        }

        /**
         * Snowflake dynamic table in which this column exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B snowflakeDynamicTable(final ISnowflakeDynamicTable snowflakeDynamicTable) {
            this.snowflakeDynamicTable = snowflakeDynamicTable;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDBTSource(final IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) this.sqlDBTSources = new java.util.ArrayList<IDbtSource>();
            this.sqlDBTSources.add(sqlDBTSource);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDBTSources(final java.util.Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new java.lang.NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) this.sqlDBTSources = new java.util.ArrayList<IDbtSource>();
            this.sqlDBTSources.addAll(sqlDBTSources);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) this.sqlDBTSources.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDbtModel(final IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) this.sqlDbtModels = new java.util.ArrayList<IDbtModel>();
            this.sqlDbtModels.add(sqlDbtModel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDbtModels(final java.util.Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new java.lang.NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) this.sqlDbtModels = new java.util.ArrayList<IDbtModel>();
            this.sqlDbtModels.addAll(sqlDbtModels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) this.sqlDbtModels.clear();
            return self();
        }

        /**
         * Sub-data type of this column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B subDataType(final String subDataType) {
            this.subDataType = subDataType;
            return self();
        }

        /**
         * Table in which this column exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B table(final ITable table) {
            this.table = table;
            return self();
        }

        /**
         * Simple name of the table in which this SQL asset exists, or empty if it does not exist within a table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableName(final String tableName) {
            this.tableName = tableName;
            return self();
        }

        /**
         * Table partition that contains this column.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tablePartition(final ITablePartition tablePartition) {
            this.tablePartition = tablePartition;
            return self();
        }

        /**
         * Unique name of the table in which this SQL asset exists, or empty if it does not exist within a table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableQualifiedName(final String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B validation(final String validationKey, final String validationValue) {
            if (this.validations$key == null) {
                this.validations$key = new java.util.ArrayList<String>();
                this.validations$value = new java.util.ArrayList<String>();
            }
            this.validations$key.add(validationKey);
            this.validations$value.add(validationValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B validations(final java.util.Map<? extends String, ? extends String> validations) {
            if (validations == null) {
                throw new java.lang.NullPointerException("validations cannot be null");
            }
            if (this.validations$key == null) {
                this.validations$key = new java.util.ArrayList<String>();
                this.validations$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : validations.entrySet()) {
                this.validations$key.add($lombokEntry.getKey());
                this.validations$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearValidations() {
            if (this.validations$key != null) {
                this.validations$key.clear();
                this.validations$value.clear();
            }
            return self();
        }

        /**
         * View in which this column exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B view(final IView view) {
            this.view = view;
            return self();
        }

        /**
         * Simple name of the view in which this SQL asset exists, or empty if it does not exist within a view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewName(final String viewName) {
            this.viewName = viewName;
            return self();
        }

        /**
         * Unique name of the view in which this SQL asset exists, or empty if it does not exist within a view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewQualifiedName(final String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Column.ColumnBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", calculationView=" + this.calculationView + ", calculationViewName=" + this.calculationViewName + ", calculationViewQualifiedName=" + this.calculationViewQualifiedName + ", columnAverage=" + this.columnAverage + ", columnAverageLength=" + this.columnAverageLength + ", columnDbtModelColumns=" + this.columnDbtModelColumns + ", columnDepthLevel=" + this.columnDepthLevel + ", columnDistinctValuesCount=" + this.columnDistinctValuesCount + ", columnDistinctValuesCountLong=" + this.columnDistinctValuesCountLong + ", columnDuplicateValuesCount=" + this.columnDuplicateValuesCount + ", columnDuplicateValuesCountLong=" + this.columnDuplicateValuesCountLong + ", columnHierarchy=" + this.columnHierarchy + ", columnHistogram=" + this.columnHistogram + ", columnMax=" + this.columnMax + ", columnMaximumStringLength=" + this.columnMaximumStringLength + ", columnMaxs=" + this.columnMaxs + ", columnMean=" + this.columnMean + ", columnMedian=" + this.columnMedian + ", columnMin=" + this.columnMin + ", columnMinimumStringLength=" + this.columnMinimumStringLength + ", columnMins=" + this.columnMins + ", columnMissingValuesCount=" + this.columnMissingValuesCount + ", columnMissingValuesCountLong=" + this.columnMissingValuesCountLong + ", columnMissingValuesPercentage=" + this.columnMissingValuesPercentage + ", columnStandardDeviation=" + this.columnStandardDeviation + ", columnSum=" + this.columnSum + ", columnTopValues=" + this.columnTopValues + ", columnUniqueValuesCount=" + this.columnUniqueValuesCount + ", columnUniqueValuesCountLong=" + this.columnUniqueValuesCountLong + ", columnUniquenessPercentage=" + this.columnUniquenessPercentage + ", columnVariance=" + this.columnVariance + ", dataQualityMetricDimensions=" + this.dataQualityMetricDimensions + ", dataType=" + this.dataType + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtMetrics=" + this.dbtMetrics + ", dbtModelColumns=" + this.dbtModelColumns + ", dbtModels=" + this.dbtModels + ", dbtSources=" + this.dbtSources + ", dbtTests=" + this.dbtTests + ", defaultValue=" + this.defaultValue + ", foreignKeyFrom=" + this.foreignKeyFrom + ", foreignKeyTo=" + this.foreignKeyTo + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isClustered=" + this.isClustered + ", isDist=" + this.isDist + ", isForeign=" + this.isForeign + ", isIndexed=" + this.isIndexed + ", isNullable=" + this.isNullable + ", isPartition=" + this.isPartition + ", isPinned=" + this.isPinned + ", isPrimary=" + this.isPrimary + ", isProfiled=" + this.isProfiled + ", isSort=" + this.isSort + ", lastProfiledAt=" + this.lastProfiledAt + ", materializedView=" + this.materializedView + ", maxLength=" + this.maxLength + ", metricTimestamps=" + this.metricTimestamps + ", nestedColumnCount=" + this.nestedColumnCount + ", nestedColumnOrder=" + this.nestedColumnOrder + ", nestedColumns=" + this.nestedColumns + ", numericScale=" + this.numericScale + ", order=" + this.order + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", parentColumn=" + this.parentColumn + ", parentColumnName=" + this.parentColumnName + ", parentColumnQualifiedName=" + this.parentColumnQualifiedName + ", partitionOrder=" + this.partitionOrder + ", pinnedAt=" + this.pinnedAt + ", pinnedBy=" + this.pinnedBy + ", precision=" + this.precision + ", queries=" + this.queries + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + this.queryUserMap$key + ", queryUserMap$value=" + this.queryUserMap$value + ", rawDataTypeDefinition=" + this.rawDataTypeDefinition + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", snowflakeDynamicTable=" + this.snowflakeDynamicTable + ", sqlDBTSources=" + this.sqlDBTSources + ", sqlDbtModels=" + this.sqlDbtModels + ", subDataType=" + this.subDataType + ", table=" + this.table + ", tableName=" + this.tableName + ", tablePartition=" + this.tablePartition + ", tableQualifiedName=" + this.tableQualifiedName + ", validations$key=" + this.validations$key + ", validations$value=" + this.validations$value + ", view=" + this.view + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class ColumnBuilderImpl extends Column.ColumnBuilder<Column, Column.ColumnBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ColumnBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Column.ColumnBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Column build() {
            return new Column(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Column(final Column.ColumnBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = Column.$default$typeName();
        this.calculationView = b.calculationView;
        this.calculationViewName = b.calculationViewName;
        this.calculationViewQualifiedName = b.calculationViewQualifiedName;
        this.columnAverage = b.columnAverage;
        this.columnAverageLength = b.columnAverageLength;
        java.util.SortedSet<IDbtModelColumn> columnDbtModelColumns = new java.util.TreeSet<IDbtModelColumn>();
        if (b.columnDbtModelColumns != null) columnDbtModelColumns.addAll(b.columnDbtModelColumns);
        columnDbtModelColumns = java.util.Collections.unmodifiableSortedSet(columnDbtModelColumns);
        this.columnDbtModelColumns = columnDbtModelColumns;
        this.columnDepthLevel = b.columnDepthLevel;
        this.columnDistinctValuesCount = b.columnDistinctValuesCount;
        this.columnDistinctValuesCountLong = b.columnDistinctValuesCountLong;
        this.columnDuplicateValuesCount = b.columnDuplicateValuesCount;
        this.columnDuplicateValuesCountLong = b.columnDuplicateValuesCountLong;
        java.util.List<Map<String, String>> columnHierarchy;
        switch (b.columnHierarchy == null ? 0 : b.columnHierarchy.size()) {
        case 0: 
            columnHierarchy = java.util.Collections.emptyList();
            break;
        case 1: 
            columnHierarchy = java.util.Collections.singletonList(b.columnHierarchy.get(0));
            break;
        default: 
            columnHierarchy = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.columnHierarchy));
        }
        this.columnHierarchy = columnHierarchy;
        this.columnHistogram = b.columnHistogram;
        this.columnMax = b.columnMax;
        this.columnMaximumStringLength = b.columnMaximumStringLength;
        java.util.SortedSet<String> columnMaxs = new java.util.TreeSet<String>();
        if (b.columnMaxs != null) columnMaxs.addAll(b.columnMaxs);
        columnMaxs = java.util.Collections.unmodifiableSortedSet(columnMaxs);
        this.columnMaxs = columnMaxs;
        this.columnMean = b.columnMean;
        this.columnMedian = b.columnMedian;
        this.columnMin = b.columnMin;
        this.columnMinimumStringLength = b.columnMinimumStringLength;
        java.util.SortedSet<String> columnMins = new java.util.TreeSet<String>();
        if (b.columnMins != null) columnMins.addAll(b.columnMins);
        columnMins = java.util.Collections.unmodifiableSortedSet(columnMins);
        this.columnMins = columnMins;
        this.columnMissingValuesCount = b.columnMissingValuesCount;
        this.columnMissingValuesCountLong = b.columnMissingValuesCountLong;
        this.columnMissingValuesPercentage = b.columnMissingValuesPercentage;
        this.columnStandardDeviation = b.columnStandardDeviation;
        this.columnSum = b.columnSum;
        java.util.List<ColumnValueFrequencyMap> columnTopValues;
        switch (b.columnTopValues == null ? 0 : b.columnTopValues.size()) {
        case 0: 
            columnTopValues = java.util.Collections.emptyList();
            break;
        case 1: 
            columnTopValues = java.util.Collections.singletonList(b.columnTopValues.get(0));
            break;
        default: 
            columnTopValues = java.util.Collections.unmodifiableList(new java.util.ArrayList<ColumnValueFrequencyMap>(b.columnTopValues));
        }
        this.columnTopValues = columnTopValues;
        this.columnUniqueValuesCount = b.columnUniqueValuesCount;
        this.columnUniqueValuesCountLong = b.columnUniqueValuesCountLong;
        this.columnUniquenessPercentage = b.columnUniquenessPercentage;
        this.columnVariance = b.columnVariance;
        java.util.SortedSet<IMetric> dataQualityMetricDimensions = new java.util.TreeSet<IMetric>();
        if (b.dataQualityMetricDimensions != null) dataQualityMetricDimensions.addAll(b.dataQualityMetricDimensions);
        dataQualityMetricDimensions = java.util.Collections.unmodifiableSortedSet(dataQualityMetricDimensions);
        this.dataQualityMetricDimensions = dataQualityMetricDimensions;
        this.dataType = b.dataType;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        java.util.SortedSet<IDbtMetric> dbtMetrics = new java.util.TreeSet<IDbtMetric>();
        if (b.dbtMetrics != null) dbtMetrics.addAll(b.dbtMetrics);
        dbtMetrics = java.util.Collections.unmodifiableSortedSet(dbtMetrics);
        this.dbtMetrics = dbtMetrics;
        java.util.SortedSet<IDbtModelColumn> dbtModelColumns = new java.util.TreeSet<IDbtModelColumn>();
        if (b.dbtModelColumns != null) dbtModelColumns.addAll(b.dbtModelColumns);
        dbtModelColumns = java.util.Collections.unmodifiableSortedSet(dbtModelColumns);
        this.dbtModelColumns = dbtModelColumns;
        java.util.SortedSet<IDbtModel> dbtModels = new java.util.TreeSet<IDbtModel>();
        if (b.dbtModels != null) dbtModels.addAll(b.dbtModels);
        dbtModels = java.util.Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        java.util.SortedSet<IDbtSource> dbtSources = new java.util.TreeSet<IDbtSource>();
        if (b.dbtSources != null) dbtSources.addAll(b.dbtSources);
        dbtSources = java.util.Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        java.util.SortedSet<IDbtTest> dbtTests = new java.util.TreeSet<IDbtTest>();
        if (b.dbtTests != null) dbtTests.addAll(b.dbtTests);
        dbtTests = java.util.Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        this.defaultValue = b.defaultValue;
        this.foreignKeyFrom = b.foreignKeyFrom;
        java.util.SortedSet<IColumn> foreignKeyTo = new java.util.TreeSet<IColumn>();
        if (b.foreignKeyTo != null) foreignKeyTo.addAll(b.foreignKeyTo);
        foreignKeyTo = java.util.Collections.unmodifiableSortedSet(foreignKeyTo);
        this.foreignKeyTo = foreignKeyTo;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isClustered = b.isClustered;
        this.isDist = b.isDist;
        this.isForeign = b.isForeign;
        this.isIndexed = b.isIndexed;
        this.isNullable = b.isNullable;
        this.isPartition = b.isPartition;
        this.isPinned = b.isPinned;
        this.isPrimary = b.isPrimary;
        this.isProfiled = b.isProfiled;
        this.isSort = b.isSort;
        this.lastProfiledAt = b.lastProfiledAt;
        this.materializedView = b.materializedView;
        this.maxLength = b.maxLength;
        java.util.SortedSet<IMetric> metricTimestamps = new java.util.TreeSet<IMetric>();
        if (b.metricTimestamps != null) metricTimestamps.addAll(b.metricTimestamps);
        metricTimestamps = java.util.Collections.unmodifiableSortedSet(metricTimestamps);
        this.metricTimestamps = metricTimestamps;
        this.nestedColumnCount = b.nestedColumnCount;
        this.nestedColumnOrder = b.nestedColumnOrder;
        java.util.SortedSet<IColumn> nestedColumns = new java.util.TreeSet<IColumn>();
        if (b.nestedColumns != null) nestedColumns.addAll(b.nestedColumns);
        nestedColumns = java.util.Collections.unmodifiableSortedSet(nestedColumns);
        this.nestedColumns = nestedColumns;
        this.numericScale = b.numericScale;
        this.order = b.order;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.parentColumn = b.parentColumn;
        this.parentColumnName = b.parentColumnName;
        this.parentColumnQualifiedName = b.parentColumnQualifiedName;
        this.partitionOrder = b.partitionOrder;
        this.pinnedAt = b.pinnedAt;
        this.pinnedBy = b.pinnedBy;
        this.precision = b.precision;
        java.util.SortedSet<IAtlanQuery> queries = new java.util.TreeSet<IAtlanQuery>();
        if (b.queries != null) queries.addAll(b.queries);
        queries = java.util.Collections.unmodifiableSortedSet(queries);
        this.queries = queries;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        this.queryUserCount = b.queryUserCount;
        java.util.Map<String, Long> queryUserMap;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
        case 0: 
            queryUserMap = java.util.Collections.emptyMap();
            break;
        case 1: 
            queryUserMap = java.util.Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
            break;
        default: 
            queryUserMap = new java.util.LinkedHashMap<String, Long>(b.queryUserMap$key.size() < 1073741824 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.queryUserMap$key.size(); $i++) queryUserMap.put(b.queryUserMap$key.get($i), (Long) b.queryUserMap$value.get($i));
            queryUserMap = java.util.Collections.unmodifiableMap(queryUserMap);
        }
        this.queryUserMap = queryUserMap;
        this.rawDataTypeDefinition = b.rawDataTypeDefinition;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        this.snowflakeDynamicTable = b.snowflakeDynamicTable;
        java.util.SortedSet<IDbtSource> sqlDBTSources = new java.util.TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) sqlDBTSources.addAll(b.sqlDBTSources);
        sqlDBTSources = java.util.Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        java.util.SortedSet<IDbtModel> sqlDbtModels = new java.util.TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) sqlDbtModels.addAll(b.sqlDbtModels);
        sqlDbtModels = java.util.Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.subDataType = b.subDataType;
        this.table = b.table;
        this.tableName = b.tableName;
        this.tablePartition = b.tablePartition;
        this.tableQualifiedName = b.tableQualifiedName;
        java.util.Map<String, String> validations;
        switch (b.validations$key == null ? 0 : b.validations$key.size()) {
        case 0: 
            validations = java.util.Collections.emptyMap();
            break;
        case 1: 
            validations = java.util.Collections.singletonMap(b.validations$key.get(0), b.validations$value.get(0));
            break;
        default: 
            validations = new java.util.LinkedHashMap<String, String>(b.validations$key.size() < 1073741824 ? 1 + b.validations$key.size() + (b.validations$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.validations$key.size(); $i++) validations.put(b.validations$key.get($i), (String) b.validations$value.get($i));
            validations = java.util.Collections.unmodifiableMap(validations);
        }
        this.validations = validations;
        this.view = b.view;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Column.ColumnBuilder<?, ?> _internal() {
        return new Column.ColumnBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Column.ColumnBuilder<?, ?> toBuilder() {
        return new Column.ColumnBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Calculate view in which this column exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ICalculationView getCalculationView() {
        return this.calculationView;
    }

    /**
     * Simple name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCalculationViewName() {
        return this.calculationViewName;
    }

    /**
     * Unique name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCalculationViewQualifiedName() {
        return this.calculationViewQualifiedName;
    }

    /**
     * Average value in this column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getColumnAverage() {
        return this.columnAverage;
    }

    /**
     * Average length of values in a string column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getColumnAverageLength() {
        return this.columnAverageLength;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModelColumn> getColumnDbtModelColumns() {
        return this.columnDbtModelColumns;
    }

    /**
     * Level of nesting of this column, used for STRUCT and NESTED columns.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getColumnDepthLevel() {
        return this.columnDepthLevel;
    }

    /**
     * Number of rows that contain distinct values.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getColumnDistinctValuesCount() {
        return this.columnDistinctValuesCount;
    }

    /**
     * Number of rows that contain distinct values.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getColumnDistinctValuesCountLong() {
        return this.columnDistinctValuesCountLong;
    }

    /**
     * Number of rows that contain duplicate values.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getColumnDuplicateValuesCount() {
        return this.columnDuplicateValuesCount;
    }

    /**
     * Number of rows that contain duplicate values.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getColumnDuplicateValuesCountLong() {
        return this.columnDuplicateValuesCountLong;
    }

    /**
     * List of top-level upstream nested columns.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getColumnHierarchy() {
        return this.columnHierarchy;
    }

    /**
     * List of values in a histogram that represents the contents of this column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Histogram getColumnHistogram() {
        return this.columnHistogram;
    }

    /**
     * Greatest value in a numeric column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getColumnMax() {
        return this.columnMax;
    }

    /**
     * Length of the longest value in a string column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getColumnMaximumStringLength() {
        return this.columnMaximumStringLength;
    }

    /**
     * List of the greatest values in a column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getColumnMaxs() {
        return this.columnMaxs;
    }

    /**
     * Arithmetic mean of the values in a numeric column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getColumnMean() {
        return this.columnMean;
    }

    /**
     * Calculated median of the values in a numeric column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getColumnMedian() {
        return this.columnMedian;
    }

    /**
     * Least value in a numeric column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getColumnMin() {
        return this.columnMin;
    }

    /**
     * Length of the shortest value in a string column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getColumnMinimumStringLength() {
        return this.columnMinimumStringLength;
    }

    /**
     * List of the least values in a column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getColumnMins() {
        return this.columnMins;
    }

    /**
     * Number of rows in a column that do not contain content.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getColumnMissingValuesCount() {
        return this.columnMissingValuesCount;
    }

    /**
     * Number of rows in a column that do not contain content.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getColumnMissingValuesCountLong() {
        return this.columnMissingValuesCountLong;
    }

    /**
     * Percentage of rows in a column that do not contain content.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getColumnMissingValuesPercentage() {
        return this.columnMissingValuesPercentage;
    }

    /**
     * Calculated standard deviation of the values in a numeric column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getColumnStandardDeviation() {
        return this.columnStandardDeviation;
    }

    /**
     * Calculated sum of the values in a numeric column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getColumnSum() {
        return this.columnSum;
    }

    /**
     * List of top values in this column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<ColumnValueFrequencyMap> getColumnTopValues() {
        return this.columnTopValues;
    }

    /**
     * Number of rows in which a value in this column appears only once.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getColumnUniqueValuesCount() {
        return this.columnUniqueValuesCount;
    }

    /**
     * Number of rows in which a value in this column appears only once.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getColumnUniqueValuesCountLong() {
        return this.columnUniqueValuesCountLong;
    }

    /**
     * Ratio indicating how unique data in this column is: 0 indicates that all values are the same, 100 indicates that all values in this column are unique.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getColumnUniquenessPercentage() {
        return this.columnUniquenessPercentage;
    }

    /**
     * Calculated variance of the values in a numeric column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getColumnVariance() {
        return this.columnVariance;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMetric> getDataQualityMetricDimensions() {
        return this.dataQualityMetricDimensions;
    }

    /**
     * Data type of values in this column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataType() {
        return this.dataType;
    }

    /**
     * Simple name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    /**
     * Unique name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtMetric> getDbtMetrics() {
        return this.dbtMetrics;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModelColumn> getDbtModelColumns() {
        return this.dbtModelColumns;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    /**
     * Default value for this column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    /**
     * Column this foreign key column refers to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IColumn getForeignKeyFrom() {
        return this.foreignKeyFrom;
    }

    /**
     * Columns that use this column as a foreign key.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IColumn> getForeignKeyTo() {
        return this.foreignKeyTo;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Whether this column is a clustered column (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsClustered() {
        return this.isClustered;
    }

    /**
     * Whether this column is a distribution column (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsDist() {
        return this.isDist;
    }

    /**
     * When true, this column is a foreign key to another table. NOTE: this must be true when using the foreignKeyTo relationship to specify columns that refer to this column as a foreign key.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsForeign() {
        return this.isForeign;
    }

    /**
     * When true, this column is indexed in the database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsIndexed() {
        return this.isIndexed;
    }

    /**
     * When true, the values in this column can be null.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsNullable() {
        return this.isNullable;
    }

    /**
     * Whether this column is a partition column (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsPartition() {
        return this.isPartition;
    }

    /**
     * Whether this column is pinned (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsPinned() {
        return this.isPinned;
    }

    /**
     * When true, this column is the primary key for the table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    /**
     * Whether this asset has been profiled (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    /**
     * Whether this column is a sort column (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsSort() {
        return this.isSort;
    }

    /**
     * Time (epoch) at which this asset was last profiled, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    /**
     * Materialized view in which this column exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IMaterializedView getMaterializedView() {
        return this.materializedView;
    }

    /**
     * Maximum length of a value in this column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMaxLength() {
        return this.maxLength;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMetric> getMetricTimestamps() {
        return this.metricTimestamps;
    }

    /**
     * Number of columns nested within this (STRUCT or NESTED) column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getNestedColumnCount() {
        return this.nestedColumnCount;
    }

    /**
     * Order (position) in which this column appears in the nested Column (nest level starts at 1).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNestedColumnOrder() {
        return this.nestedColumnOrder;
    }

    /**
     * Nested columns that exist within this column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IColumn> getNestedColumns() {
        return this.nestedColumns;
    }

    /**
     * Number of digits allowed to the right of the decimal point.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getNumericScale() {
        return this.numericScale;
    }

    /**
     * Order (position) in which this column appears in the table (starting at 1).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getOrder() {
        return this.order;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Column in which this sub-column is nested.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IColumn getParentColumn() {
        return this.parentColumn;
    }

    /**
     * Simple name of the column this column is nested within, for STRUCT and NESTED columns.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getParentColumnName() {
        return this.parentColumnName;
    }

    /**
     * Unique name of the column this column is nested within, for STRUCT and NESTED columns.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getParentColumnQualifiedName() {
        return this.parentColumnQualifiedName;
    }

    /**
     * Order (position) of this partition column in the table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getPartitionOrder() {
        return this.partitionOrder;
    }

    /**
     * Time (epoch) at which this column was pinned, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPinnedAt() {
        return this.pinnedAt;
    }

    /**
     * User who pinned this column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPinnedBy() {
        return this.pinnedBy;
    }

    /**
     * Total number of digits allowed, when the dataType is numeric.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getPrecision() {
        return this.precision;
    }

    /**
     * Queries that access this column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAtlanQuery> getQueries() {
        return this.queries;
    }

    /**
     * Number of times this asset has been queried.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryCount() {
        return this.queryCount;
    }

    /**
     * Time (epoch) at which the query count was last updated, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    /**
     * Number of unique users who have queried this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    /**
     * Map of unique users who have queried this asset to the number of times they have queried it.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRawDataTypeDefinition() {
        return this.rawDataTypeDefinition;
    }

    /**
     * Simple name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    /**
     * Unique name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    /**
     * Snowflake dynamic table in which this column exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ISnowflakeDynamicTable getSnowflakeDynamicTable() {
        return this.snowflakeDynamicTable;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    /**
     * Sub-data type of this column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSubDataType() {
        return this.subDataType;
    }

    /**
     * Table in which this column exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ITable getTable() {
        return this.table;
    }

    /**
     * Simple name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableName() {
        return this.tableName;
    }

    /**
     * Table partition that contains this column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ITablePartition getTablePartition() {
        return this.tablePartition;
    }

    /**
     * Unique name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    /**
     * Validations for this column.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getValidations() {
        return this.validations;
    }

    /**
     * View in which this column exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IView getView() {
        return this.view;
    }

    /**
     * Simple name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getViewName() {
        return this.viewName;
    }

    /**
     * Unique name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Column)) return false;
        final Column other = (Column) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$columnAverage = this.getColumnAverage();
        final java.lang.Object other$columnAverage = other.getColumnAverage();
        if (this$columnAverage == null ? other$columnAverage != null : !this$columnAverage.equals(other$columnAverage)) return false;
        final java.lang.Object this$columnAverageLength = this.getColumnAverageLength();
        final java.lang.Object other$columnAverageLength = other.getColumnAverageLength();
        if (this$columnAverageLength == null ? other$columnAverageLength != null : !this$columnAverageLength.equals(other$columnAverageLength)) return false;
        final java.lang.Object this$columnDepthLevel = this.getColumnDepthLevel();
        final java.lang.Object other$columnDepthLevel = other.getColumnDepthLevel();
        if (this$columnDepthLevel == null ? other$columnDepthLevel != null : !this$columnDepthLevel.equals(other$columnDepthLevel)) return false;
        final java.lang.Object this$columnDistinctValuesCount = this.getColumnDistinctValuesCount();
        final java.lang.Object other$columnDistinctValuesCount = other.getColumnDistinctValuesCount();
        if (this$columnDistinctValuesCount == null ? other$columnDistinctValuesCount != null : !this$columnDistinctValuesCount.equals(other$columnDistinctValuesCount)) return false;
        final java.lang.Object this$columnDistinctValuesCountLong = this.getColumnDistinctValuesCountLong();
        final java.lang.Object other$columnDistinctValuesCountLong = other.getColumnDistinctValuesCountLong();
        if (this$columnDistinctValuesCountLong == null ? other$columnDistinctValuesCountLong != null : !this$columnDistinctValuesCountLong.equals(other$columnDistinctValuesCountLong)) return false;
        final java.lang.Object this$columnDuplicateValuesCount = this.getColumnDuplicateValuesCount();
        final java.lang.Object other$columnDuplicateValuesCount = other.getColumnDuplicateValuesCount();
        if (this$columnDuplicateValuesCount == null ? other$columnDuplicateValuesCount != null : !this$columnDuplicateValuesCount.equals(other$columnDuplicateValuesCount)) return false;
        final java.lang.Object this$columnDuplicateValuesCountLong = this.getColumnDuplicateValuesCountLong();
        final java.lang.Object other$columnDuplicateValuesCountLong = other.getColumnDuplicateValuesCountLong();
        if (this$columnDuplicateValuesCountLong == null ? other$columnDuplicateValuesCountLong != null : !this$columnDuplicateValuesCountLong.equals(other$columnDuplicateValuesCountLong)) return false;
        final java.lang.Object this$columnMax = this.getColumnMax();
        final java.lang.Object other$columnMax = other.getColumnMax();
        if (this$columnMax == null ? other$columnMax != null : !this$columnMax.equals(other$columnMax)) return false;
        final java.lang.Object this$columnMaximumStringLength = this.getColumnMaximumStringLength();
        final java.lang.Object other$columnMaximumStringLength = other.getColumnMaximumStringLength();
        if (this$columnMaximumStringLength == null ? other$columnMaximumStringLength != null : !this$columnMaximumStringLength.equals(other$columnMaximumStringLength)) return false;
        final java.lang.Object this$columnMean = this.getColumnMean();
        final java.lang.Object other$columnMean = other.getColumnMean();
        if (this$columnMean == null ? other$columnMean != null : !this$columnMean.equals(other$columnMean)) return false;
        final java.lang.Object this$columnMedian = this.getColumnMedian();
        final java.lang.Object other$columnMedian = other.getColumnMedian();
        if (this$columnMedian == null ? other$columnMedian != null : !this$columnMedian.equals(other$columnMedian)) return false;
        final java.lang.Object this$columnMin = this.getColumnMin();
        final java.lang.Object other$columnMin = other.getColumnMin();
        if (this$columnMin == null ? other$columnMin != null : !this$columnMin.equals(other$columnMin)) return false;
        final java.lang.Object this$columnMinimumStringLength = this.getColumnMinimumStringLength();
        final java.lang.Object other$columnMinimumStringLength = other.getColumnMinimumStringLength();
        if (this$columnMinimumStringLength == null ? other$columnMinimumStringLength != null : !this$columnMinimumStringLength.equals(other$columnMinimumStringLength)) return false;
        final java.lang.Object this$columnMissingValuesCount = this.getColumnMissingValuesCount();
        final java.lang.Object other$columnMissingValuesCount = other.getColumnMissingValuesCount();
        if (this$columnMissingValuesCount == null ? other$columnMissingValuesCount != null : !this$columnMissingValuesCount.equals(other$columnMissingValuesCount)) return false;
        final java.lang.Object this$columnMissingValuesCountLong = this.getColumnMissingValuesCountLong();
        final java.lang.Object other$columnMissingValuesCountLong = other.getColumnMissingValuesCountLong();
        if (this$columnMissingValuesCountLong == null ? other$columnMissingValuesCountLong != null : !this$columnMissingValuesCountLong.equals(other$columnMissingValuesCountLong)) return false;
        final java.lang.Object this$columnMissingValuesPercentage = this.getColumnMissingValuesPercentage();
        final java.lang.Object other$columnMissingValuesPercentage = other.getColumnMissingValuesPercentage();
        if (this$columnMissingValuesPercentage == null ? other$columnMissingValuesPercentage != null : !this$columnMissingValuesPercentage.equals(other$columnMissingValuesPercentage)) return false;
        final java.lang.Object this$columnStandardDeviation = this.getColumnStandardDeviation();
        final java.lang.Object other$columnStandardDeviation = other.getColumnStandardDeviation();
        if (this$columnStandardDeviation == null ? other$columnStandardDeviation != null : !this$columnStandardDeviation.equals(other$columnStandardDeviation)) return false;
        final java.lang.Object this$columnSum = this.getColumnSum();
        final java.lang.Object other$columnSum = other.getColumnSum();
        if (this$columnSum == null ? other$columnSum != null : !this$columnSum.equals(other$columnSum)) return false;
        final java.lang.Object this$columnUniqueValuesCount = this.getColumnUniqueValuesCount();
        final java.lang.Object other$columnUniqueValuesCount = other.getColumnUniqueValuesCount();
        if (this$columnUniqueValuesCount == null ? other$columnUniqueValuesCount != null : !this$columnUniqueValuesCount.equals(other$columnUniqueValuesCount)) return false;
        final java.lang.Object this$columnUniqueValuesCountLong = this.getColumnUniqueValuesCountLong();
        final java.lang.Object other$columnUniqueValuesCountLong = other.getColumnUniqueValuesCountLong();
        if (this$columnUniqueValuesCountLong == null ? other$columnUniqueValuesCountLong != null : !this$columnUniqueValuesCountLong.equals(other$columnUniqueValuesCountLong)) return false;
        final java.lang.Object this$columnUniquenessPercentage = this.getColumnUniquenessPercentage();
        final java.lang.Object other$columnUniquenessPercentage = other.getColumnUniquenessPercentage();
        if (this$columnUniquenessPercentage == null ? other$columnUniquenessPercentage != null : !this$columnUniquenessPercentage.equals(other$columnUniquenessPercentage)) return false;
        final java.lang.Object this$columnVariance = this.getColumnVariance();
        final java.lang.Object other$columnVariance = other.getColumnVariance();
        if (this$columnVariance == null ? other$columnVariance != null : !this$columnVariance.equals(other$columnVariance)) return false;
        final java.lang.Object this$isClustered = this.getIsClustered();
        final java.lang.Object other$isClustered = other.getIsClustered();
        if (this$isClustered == null ? other$isClustered != null : !this$isClustered.equals(other$isClustered)) return false;
        final java.lang.Object this$isDist = this.getIsDist();
        final java.lang.Object other$isDist = other.getIsDist();
        if (this$isDist == null ? other$isDist != null : !this$isDist.equals(other$isDist)) return false;
        final java.lang.Object this$isForeign = this.getIsForeign();
        final java.lang.Object other$isForeign = other.getIsForeign();
        if (this$isForeign == null ? other$isForeign != null : !this$isForeign.equals(other$isForeign)) return false;
        final java.lang.Object this$isIndexed = this.getIsIndexed();
        final java.lang.Object other$isIndexed = other.getIsIndexed();
        if (this$isIndexed == null ? other$isIndexed != null : !this$isIndexed.equals(other$isIndexed)) return false;
        final java.lang.Object this$isNullable = this.getIsNullable();
        final java.lang.Object other$isNullable = other.getIsNullable();
        if (this$isNullable == null ? other$isNullable != null : !this$isNullable.equals(other$isNullable)) return false;
        final java.lang.Object this$isPartition = this.getIsPartition();
        final java.lang.Object other$isPartition = other.getIsPartition();
        if (this$isPartition == null ? other$isPartition != null : !this$isPartition.equals(other$isPartition)) return false;
        final java.lang.Object this$isPinned = this.getIsPinned();
        final java.lang.Object other$isPinned = other.getIsPinned();
        if (this$isPinned == null ? other$isPinned != null : !this$isPinned.equals(other$isPinned)) return false;
        final java.lang.Object this$isPrimary = this.getIsPrimary();
        final java.lang.Object other$isPrimary = other.getIsPrimary();
        if (this$isPrimary == null ? other$isPrimary != null : !this$isPrimary.equals(other$isPrimary)) return false;
        final java.lang.Object this$isProfiled = this.getIsProfiled();
        final java.lang.Object other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !this$isProfiled.equals(other$isProfiled)) return false;
        final java.lang.Object this$isSort = this.getIsSort();
        final java.lang.Object other$isSort = other.getIsSort();
        if (this$isSort == null ? other$isSort != null : !this$isSort.equals(other$isSort)) return false;
        final java.lang.Object this$lastProfiledAt = this.getLastProfiledAt();
        final java.lang.Object other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !this$lastProfiledAt.equals(other$lastProfiledAt)) return false;
        final java.lang.Object this$maxLength = this.getMaxLength();
        final java.lang.Object other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !this$maxLength.equals(other$maxLength)) return false;
        final java.lang.Object this$nestedColumnCount = this.getNestedColumnCount();
        final java.lang.Object other$nestedColumnCount = other.getNestedColumnCount();
        if (this$nestedColumnCount == null ? other$nestedColumnCount != null : !this$nestedColumnCount.equals(other$nestedColumnCount)) return false;
        final java.lang.Object this$numericScale = this.getNumericScale();
        final java.lang.Object other$numericScale = other.getNumericScale();
        if (this$numericScale == null ? other$numericScale != null : !this$numericScale.equals(other$numericScale)) return false;
        final java.lang.Object this$order = this.getOrder();
        final java.lang.Object other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) return false;
        final java.lang.Object this$partitionOrder = this.getPartitionOrder();
        final java.lang.Object other$partitionOrder = other.getPartitionOrder();
        if (this$partitionOrder == null ? other$partitionOrder != null : !this$partitionOrder.equals(other$partitionOrder)) return false;
        final java.lang.Object this$pinnedAt = this.getPinnedAt();
        final java.lang.Object other$pinnedAt = other.getPinnedAt();
        if (this$pinnedAt == null ? other$pinnedAt != null : !this$pinnedAt.equals(other$pinnedAt)) return false;
        final java.lang.Object this$precision = this.getPrecision();
        final java.lang.Object other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !this$precision.equals(other$precision)) return false;
        final java.lang.Object this$queryCount = this.getQueryCount();
        final java.lang.Object other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !this$queryCount.equals(other$queryCount)) return false;
        final java.lang.Object this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        final java.lang.Object other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !this$queryCountUpdatedAt.equals(other$queryCountUpdatedAt)) return false;
        final java.lang.Object this$queryUserCount = this.getQueryUserCount();
        final java.lang.Object other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !this$queryUserCount.equals(other$queryUserCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$calculationView = this.getCalculationView();
        final java.lang.Object other$calculationView = other.getCalculationView();
        if (this$calculationView == null ? other$calculationView != null : !this$calculationView.equals(other$calculationView)) return false;
        final java.lang.Object this$calculationViewName = this.getCalculationViewName();
        final java.lang.Object other$calculationViewName = other.getCalculationViewName();
        if (this$calculationViewName == null ? other$calculationViewName != null : !this$calculationViewName.equals(other$calculationViewName)) return false;
        final java.lang.Object this$calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        final java.lang.Object other$calculationViewQualifiedName = other.getCalculationViewQualifiedName();
        if (this$calculationViewQualifiedName == null ? other$calculationViewQualifiedName != null : !this$calculationViewQualifiedName.equals(other$calculationViewQualifiedName)) return false;
        final java.lang.Object this$columnDbtModelColumns = this.getColumnDbtModelColumns();
        final java.lang.Object other$columnDbtModelColumns = other.getColumnDbtModelColumns();
        if (this$columnDbtModelColumns == null ? other$columnDbtModelColumns != null : !this$columnDbtModelColumns.equals(other$columnDbtModelColumns)) return false;
        final java.lang.Object this$columnHierarchy = this.getColumnHierarchy();
        final java.lang.Object other$columnHierarchy = other.getColumnHierarchy();
        if (this$columnHierarchy == null ? other$columnHierarchy != null : !this$columnHierarchy.equals(other$columnHierarchy)) return false;
        final java.lang.Object this$columnHistogram = this.getColumnHistogram();
        final java.lang.Object other$columnHistogram = other.getColumnHistogram();
        if (this$columnHistogram == null ? other$columnHistogram != null : !this$columnHistogram.equals(other$columnHistogram)) return false;
        final java.lang.Object this$columnMaxs = this.getColumnMaxs();
        final java.lang.Object other$columnMaxs = other.getColumnMaxs();
        if (this$columnMaxs == null ? other$columnMaxs != null : !this$columnMaxs.equals(other$columnMaxs)) return false;
        final java.lang.Object this$columnMins = this.getColumnMins();
        final java.lang.Object other$columnMins = other.getColumnMins();
        if (this$columnMins == null ? other$columnMins != null : !this$columnMins.equals(other$columnMins)) return false;
        final java.lang.Object this$columnTopValues = this.getColumnTopValues();
        final java.lang.Object other$columnTopValues = other.getColumnTopValues();
        if (this$columnTopValues == null ? other$columnTopValues != null : !this$columnTopValues.equals(other$columnTopValues)) return false;
        final java.lang.Object this$dataQualityMetricDimensions = this.getDataQualityMetricDimensions();
        final java.lang.Object other$dataQualityMetricDimensions = other.getDataQualityMetricDimensions();
        if (this$dataQualityMetricDimensions == null ? other$dataQualityMetricDimensions != null : !this$dataQualityMetricDimensions.equals(other$dataQualityMetricDimensions)) return false;
        final java.lang.Object this$dataType = this.getDataType();
        final java.lang.Object other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) return false;
        final java.lang.Object this$databaseName = this.getDatabaseName();
        final java.lang.Object other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) return false;
        final java.lang.Object this$databaseQualifiedName = this.getDatabaseQualifiedName();
        final java.lang.Object other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) return false;
        final java.lang.Object this$dbtMetrics = this.getDbtMetrics();
        final java.lang.Object other$dbtMetrics = other.getDbtMetrics();
        if (this$dbtMetrics == null ? other$dbtMetrics != null : !this$dbtMetrics.equals(other$dbtMetrics)) return false;
        final java.lang.Object this$dbtModelColumns = this.getDbtModelColumns();
        final java.lang.Object other$dbtModelColumns = other.getDbtModelColumns();
        if (this$dbtModelColumns == null ? other$dbtModelColumns != null : !this$dbtModelColumns.equals(other$dbtModelColumns)) return false;
        final java.lang.Object this$dbtModels = this.getDbtModels();
        final java.lang.Object other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) return false;
        final java.lang.Object this$dbtSources = this.getDbtSources();
        final java.lang.Object other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) return false;
        final java.lang.Object this$dbtTests = this.getDbtTests();
        final java.lang.Object other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) return false;
        final java.lang.Object this$defaultValue = this.getDefaultValue();
        final java.lang.Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) return false;
        final java.lang.Object this$foreignKeyFrom = this.getForeignKeyFrom();
        final java.lang.Object other$foreignKeyFrom = other.getForeignKeyFrom();
        if (this$foreignKeyFrom == null ? other$foreignKeyFrom != null : !this$foreignKeyFrom.equals(other$foreignKeyFrom)) return false;
        final java.lang.Object this$foreignKeyTo = this.getForeignKeyTo();
        final java.lang.Object other$foreignKeyTo = other.getForeignKeyTo();
        if (this$foreignKeyTo == null ? other$foreignKeyTo != null : !this$foreignKeyTo.equals(other$foreignKeyTo)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$materializedView = this.getMaterializedView();
        final java.lang.Object other$materializedView = other.getMaterializedView();
        if (this$materializedView == null ? other$materializedView != null : !this$materializedView.equals(other$materializedView)) return false;
        final java.lang.Object this$metricTimestamps = this.getMetricTimestamps();
        final java.lang.Object other$metricTimestamps = other.getMetricTimestamps();
        if (this$metricTimestamps == null ? other$metricTimestamps != null : !this$metricTimestamps.equals(other$metricTimestamps)) return false;
        final java.lang.Object this$nestedColumnOrder = this.getNestedColumnOrder();
        final java.lang.Object other$nestedColumnOrder = other.getNestedColumnOrder();
        if (this$nestedColumnOrder == null ? other$nestedColumnOrder != null : !this$nestedColumnOrder.equals(other$nestedColumnOrder)) return false;
        final java.lang.Object this$nestedColumns = this.getNestedColumns();
        final java.lang.Object other$nestedColumns = other.getNestedColumns();
        if (this$nestedColumns == null ? other$nestedColumns != null : !this$nestedColumns.equals(other$nestedColumns)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$parentColumn = this.getParentColumn();
        final java.lang.Object other$parentColumn = other.getParentColumn();
        if (this$parentColumn == null ? other$parentColumn != null : !this$parentColumn.equals(other$parentColumn)) return false;
        final java.lang.Object this$parentColumnName = this.getParentColumnName();
        final java.lang.Object other$parentColumnName = other.getParentColumnName();
        if (this$parentColumnName == null ? other$parentColumnName != null : !this$parentColumnName.equals(other$parentColumnName)) return false;
        final java.lang.Object this$parentColumnQualifiedName = this.getParentColumnQualifiedName();
        final java.lang.Object other$parentColumnQualifiedName = other.getParentColumnQualifiedName();
        if (this$parentColumnQualifiedName == null ? other$parentColumnQualifiedName != null : !this$parentColumnQualifiedName.equals(other$parentColumnQualifiedName)) return false;
        final java.lang.Object this$pinnedBy = this.getPinnedBy();
        final java.lang.Object other$pinnedBy = other.getPinnedBy();
        if (this$pinnedBy == null ? other$pinnedBy != null : !this$pinnedBy.equals(other$pinnedBy)) return false;
        final java.lang.Object this$queries = this.getQueries();
        final java.lang.Object other$queries = other.getQueries();
        if (this$queries == null ? other$queries != null : !this$queries.equals(other$queries)) return false;
        final java.lang.Object this$queryUserMap = this.getQueryUserMap();
        final java.lang.Object other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !this$queryUserMap.equals(other$queryUserMap)) return false;
        final java.lang.Object this$rawDataTypeDefinition = this.getRawDataTypeDefinition();
        final java.lang.Object other$rawDataTypeDefinition = other.getRawDataTypeDefinition();
        if (this$rawDataTypeDefinition == null ? other$rawDataTypeDefinition != null : !this$rawDataTypeDefinition.equals(other$rawDataTypeDefinition)) return false;
        final java.lang.Object this$schemaName = this.getSchemaName();
        final java.lang.Object other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) return false;
        final java.lang.Object this$schemaQualifiedName = this.getSchemaQualifiedName();
        final java.lang.Object other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) return false;
        final java.lang.Object this$snowflakeDynamicTable = this.getSnowflakeDynamicTable();
        final java.lang.Object other$snowflakeDynamicTable = other.getSnowflakeDynamicTable();
        if (this$snowflakeDynamicTable == null ? other$snowflakeDynamicTable != null : !this$snowflakeDynamicTable.equals(other$snowflakeDynamicTable)) return false;
        final java.lang.Object this$sqlDBTSources = this.getSqlDBTSources();
        final java.lang.Object other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) return false;
        final java.lang.Object this$sqlDbtModels = this.getSqlDbtModels();
        final java.lang.Object other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) return false;
        final java.lang.Object this$subDataType = this.getSubDataType();
        final java.lang.Object other$subDataType = other.getSubDataType();
        if (this$subDataType == null ? other$subDataType != null : !this$subDataType.equals(other$subDataType)) return false;
        final java.lang.Object this$table = this.getTable();
        final java.lang.Object other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) return false;
        final java.lang.Object this$tableName = this.getTableName();
        final java.lang.Object other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) return false;
        final java.lang.Object this$tablePartition = this.getTablePartition();
        final java.lang.Object other$tablePartition = other.getTablePartition();
        if (this$tablePartition == null ? other$tablePartition != null : !this$tablePartition.equals(other$tablePartition)) return false;
        final java.lang.Object this$tableQualifiedName = this.getTableQualifiedName();
        final java.lang.Object other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) return false;
        final java.lang.Object this$validations = this.getValidations();
        final java.lang.Object other$validations = other.getValidations();
        if (this$validations == null ? other$validations != null : !this$validations.equals(other$validations)) return false;
        final java.lang.Object this$view = this.getView();
        final java.lang.Object other$view = other.getView();
        if (this$view == null ? other$view != null : !this$view.equals(other$view)) return false;
        final java.lang.Object this$viewName = this.getViewName();
        final java.lang.Object other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) return false;
        final java.lang.Object this$viewQualifiedName = this.getViewQualifiedName();
        final java.lang.Object other$viewQualifiedName = other.getViewQualifiedName();
        if (this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Column;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $columnAverage = this.getColumnAverage();
        result = result * PRIME + ($columnAverage == null ? 43 : $columnAverage.hashCode());
        final java.lang.Object $columnAverageLength = this.getColumnAverageLength();
        result = result * PRIME + ($columnAverageLength == null ? 43 : $columnAverageLength.hashCode());
        final java.lang.Object $columnDepthLevel = this.getColumnDepthLevel();
        result = result * PRIME + ($columnDepthLevel == null ? 43 : $columnDepthLevel.hashCode());
        final java.lang.Object $columnDistinctValuesCount = this.getColumnDistinctValuesCount();
        result = result * PRIME + ($columnDistinctValuesCount == null ? 43 : $columnDistinctValuesCount.hashCode());
        final java.lang.Object $columnDistinctValuesCountLong = this.getColumnDistinctValuesCountLong();
        result = result * PRIME + ($columnDistinctValuesCountLong == null ? 43 : $columnDistinctValuesCountLong.hashCode());
        final java.lang.Object $columnDuplicateValuesCount = this.getColumnDuplicateValuesCount();
        result = result * PRIME + ($columnDuplicateValuesCount == null ? 43 : $columnDuplicateValuesCount.hashCode());
        final java.lang.Object $columnDuplicateValuesCountLong = this.getColumnDuplicateValuesCountLong();
        result = result * PRIME + ($columnDuplicateValuesCountLong == null ? 43 : $columnDuplicateValuesCountLong.hashCode());
        final java.lang.Object $columnMax = this.getColumnMax();
        result = result * PRIME + ($columnMax == null ? 43 : $columnMax.hashCode());
        final java.lang.Object $columnMaximumStringLength = this.getColumnMaximumStringLength();
        result = result * PRIME + ($columnMaximumStringLength == null ? 43 : $columnMaximumStringLength.hashCode());
        final java.lang.Object $columnMean = this.getColumnMean();
        result = result * PRIME + ($columnMean == null ? 43 : $columnMean.hashCode());
        final java.lang.Object $columnMedian = this.getColumnMedian();
        result = result * PRIME + ($columnMedian == null ? 43 : $columnMedian.hashCode());
        final java.lang.Object $columnMin = this.getColumnMin();
        result = result * PRIME + ($columnMin == null ? 43 : $columnMin.hashCode());
        final java.lang.Object $columnMinimumStringLength = this.getColumnMinimumStringLength();
        result = result * PRIME + ($columnMinimumStringLength == null ? 43 : $columnMinimumStringLength.hashCode());
        final java.lang.Object $columnMissingValuesCount = this.getColumnMissingValuesCount();
        result = result * PRIME + ($columnMissingValuesCount == null ? 43 : $columnMissingValuesCount.hashCode());
        final java.lang.Object $columnMissingValuesCountLong = this.getColumnMissingValuesCountLong();
        result = result * PRIME + ($columnMissingValuesCountLong == null ? 43 : $columnMissingValuesCountLong.hashCode());
        final java.lang.Object $columnMissingValuesPercentage = this.getColumnMissingValuesPercentage();
        result = result * PRIME + ($columnMissingValuesPercentage == null ? 43 : $columnMissingValuesPercentage.hashCode());
        final java.lang.Object $columnStandardDeviation = this.getColumnStandardDeviation();
        result = result * PRIME + ($columnStandardDeviation == null ? 43 : $columnStandardDeviation.hashCode());
        final java.lang.Object $columnSum = this.getColumnSum();
        result = result * PRIME + ($columnSum == null ? 43 : $columnSum.hashCode());
        final java.lang.Object $columnUniqueValuesCount = this.getColumnUniqueValuesCount();
        result = result * PRIME + ($columnUniqueValuesCount == null ? 43 : $columnUniqueValuesCount.hashCode());
        final java.lang.Object $columnUniqueValuesCountLong = this.getColumnUniqueValuesCountLong();
        result = result * PRIME + ($columnUniqueValuesCountLong == null ? 43 : $columnUniqueValuesCountLong.hashCode());
        final java.lang.Object $columnUniquenessPercentage = this.getColumnUniquenessPercentage();
        result = result * PRIME + ($columnUniquenessPercentage == null ? 43 : $columnUniquenessPercentage.hashCode());
        final java.lang.Object $columnVariance = this.getColumnVariance();
        result = result * PRIME + ($columnVariance == null ? 43 : $columnVariance.hashCode());
        final java.lang.Object $isClustered = this.getIsClustered();
        result = result * PRIME + ($isClustered == null ? 43 : $isClustered.hashCode());
        final java.lang.Object $isDist = this.getIsDist();
        result = result * PRIME + ($isDist == null ? 43 : $isDist.hashCode());
        final java.lang.Object $isForeign = this.getIsForeign();
        result = result * PRIME + ($isForeign == null ? 43 : $isForeign.hashCode());
        final java.lang.Object $isIndexed = this.getIsIndexed();
        result = result * PRIME + ($isIndexed == null ? 43 : $isIndexed.hashCode());
        final java.lang.Object $isNullable = this.getIsNullable();
        result = result * PRIME + ($isNullable == null ? 43 : $isNullable.hashCode());
        final java.lang.Object $isPartition = this.getIsPartition();
        result = result * PRIME + ($isPartition == null ? 43 : $isPartition.hashCode());
        final java.lang.Object $isPinned = this.getIsPinned();
        result = result * PRIME + ($isPinned == null ? 43 : $isPinned.hashCode());
        final java.lang.Object $isPrimary = this.getIsPrimary();
        result = result * PRIME + ($isPrimary == null ? 43 : $isPrimary.hashCode());
        final java.lang.Object $isProfiled = this.getIsProfiled();
        result = result * PRIME + ($isProfiled == null ? 43 : $isProfiled.hashCode());
        final java.lang.Object $isSort = this.getIsSort();
        result = result * PRIME + ($isSort == null ? 43 : $isSort.hashCode());
        final java.lang.Object $lastProfiledAt = this.getLastProfiledAt();
        result = result * PRIME + ($lastProfiledAt == null ? 43 : $lastProfiledAt.hashCode());
        final java.lang.Object $maxLength = this.getMaxLength();
        result = result * PRIME + ($maxLength == null ? 43 : $maxLength.hashCode());
        final java.lang.Object $nestedColumnCount = this.getNestedColumnCount();
        result = result * PRIME + ($nestedColumnCount == null ? 43 : $nestedColumnCount.hashCode());
        final java.lang.Object $numericScale = this.getNumericScale();
        result = result * PRIME + ($numericScale == null ? 43 : $numericScale.hashCode());
        final java.lang.Object $order = this.getOrder();
        result = result * PRIME + ($order == null ? 43 : $order.hashCode());
        final java.lang.Object $partitionOrder = this.getPartitionOrder();
        result = result * PRIME + ($partitionOrder == null ? 43 : $partitionOrder.hashCode());
        final java.lang.Object $pinnedAt = this.getPinnedAt();
        result = result * PRIME + ($pinnedAt == null ? 43 : $pinnedAt.hashCode());
        final java.lang.Object $precision = this.getPrecision();
        result = result * PRIME + ($precision == null ? 43 : $precision.hashCode());
        final java.lang.Object $queryCount = this.getQueryCount();
        result = result * PRIME + ($queryCount == null ? 43 : $queryCount.hashCode());
        final java.lang.Object $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * PRIME + ($queryCountUpdatedAt == null ? 43 : $queryCountUpdatedAt.hashCode());
        final java.lang.Object $queryUserCount = this.getQueryUserCount();
        result = result * PRIME + ($queryUserCount == null ? 43 : $queryUserCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $calculationView = this.getCalculationView();
        result = result * PRIME + ($calculationView == null ? 43 : $calculationView.hashCode());
        final java.lang.Object $calculationViewName = this.getCalculationViewName();
        result = result * PRIME + ($calculationViewName == null ? 43 : $calculationViewName.hashCode());
        final java.lang.Object $calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        result = result * PRIME + ($calculationViewQualifiedName == null ? 43 : $calculationViewQualifiedName.hashCode());
        final java.lang.Object $columnDbtModelColumns = this.getColumnDbtModelColumns();
        result = result * PRIME + ($columnDbtModelColumns == null ? 43 : $columnDbtModelColumns.hashCode());
        final java.lang.Object $columnHierarchy = this.getColumnHierarchy();
        result = result * PRIME + ($columnHierarchy == null ? 43 : $columnHierarchy.hashCode());
        final java.lang.Object $columnHistogram = this.getColumnHistogram();
        result = result * PRIME + ($columnHistogram == null ? 43 : $columnHistogram.hashCode());
        final java.lang.Object $columnMaxs = this.getColumnMaxs();
        result = result * PRIME + ($columnMaxs == null ? 43 : $columnMaxs.hashCode());
        final java.lang.Object $columnMins = this.getColumnMins();
        result = result * PRIME + ($columnMins == null ? 43 : $columnMins.hashCode());
        final java.lang.Object $columnTopValues = this.getColumnTopValues();
        result = result * PRIME + ($columnTopValues == null ? 43 : $columnTopValues.hashCode());
        final java.lang.Object $dataQualityMetricDimensions = this.getDataQualityMetricDimensions();
        result = result * PRIME + ($dataQualityMetricDimensions == null ? 43 : $dataQualityMetricDimensions.hashCode());
        final java.lang.Object $dataType = this.getDataType();
        result = result * PRIME + ($dataType == null ? 43 : $dataType.hashCode());
        final java.lang.Object $databaseName = this.getDatabaseName();
        result = result * PRIME + ($databaseName == null ? 43 : $databaseName.hashCode());
        final java.lang.Object $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * PRIME + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        final java.lang.Object $dbtMetrics = this.getDbtMetrics();
        result = result * PRIME + ($dbtMetrics == null ? 43 : $dbtMetrics.hashCode());
        final java.lang.Object $dbtModelColumns = this.getDbtModelColumns();
        result = result * PRIME + ($dbtModelColumns == null ? 43 : $dbtModelColumns.hashCode());
        final java.lang.Object $dbtModels = this.getDbtModels();
        result = result * PRIME + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        final java.lang.Object $dbtSources = this.getDbtSources();
        result = result * PRIME + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        final java.lang.Object $dbtTests = this.getDbtTests();
        result = result * PRIME + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        final java.lang.Object $defaultValue = this.getDefaultValue();
        result = result * PRIME + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        final java.lang.Object $foreignKeyFrom = this.getForeignKeyFrom();
        result = result * PRIME + ($foreignKeyFrom == null ? 43 : $foreignKeyFrom.hashCode());
        final java.lang.Object $foreignKeyTo = this.getForeignKeyTo();
        result = result * PRIME + ($foreignKeyTo == null ? 43 : $foreignKeyTo.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $materializedView = this.getMaterializedView();
        result = result * PRIME + ($materializedView == null ? 43 : $materializedView.hashCode());
        final java.lang.Object $metricTimestamps = this.getMetricTimestamps();
        result = result * PRIME + ($metricTimestamps == null ? 43 : $metricTimestamps.hashCode());
        final java.lang.Object $nestedColumnOrder = this.getNestedColumnOrder();
        result = result * PRIME + ($nestedColumnOrder == null ? 43 : $nestedColumnOrder.hashCode());
        final java.lang.Object $nestedColumns = this.getNestedColumns();
        result = result * PRIME + ($nestedColumns == null ? 43 : $nestedColumns.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $parentColumn = this.getParentColumn();
        result = result * PRIME + ($parentColumn == null ? 43 : $parentColumn.hashCode());
        final java.lang.Object $parentColumnName = this.getParentColumnName();
        result = result * PRIME + ($parentColumnName == null ? 43 : $parentColumnName.hashCode());
        final java.lang.Object $parentColumnQualifiedName = this.getParentColumnQualifiedName();
        result = result * PRIME + ($parentColumnQualifiedName == null ? 43 : $parentColumnQualifiedName.hashCode());
        final java.lang.Object $pinnedBy = this.getPinnedBy();
        result = result * PRIME + ($pinnedBy == null ? 43 : $pinnedBy.hashCode());
        final java.lang.Object $queries = this.getQueries();
        result = result * PRIME + ($queries == null ? 43 : $queries.hashCode());
        final java.lang.Object $queryUserMap = this.getQueryUserMap();
        result = result * PRIME + ($queryUserMap == null ? 43 : $queryUserMap.hashCode());
        final java.lang.Object $rawDataTypeDefinition = this.getRawDataTypeDefinition();
        result = result * PRIME + ($rawDataTypeDefinition == null ? 43 : $rawDataTypeDefinition.hashCode());
        final java.lang.Object $schemaName = this.getSchemaName();
        result = result * PRIME + ($schemaName == null ? 43 : $schemaName.hashCode());
        final java.lang.Object $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * PRIME + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        final java.lang.Object $snowflakeDynamicTable = this.getSnowflakeDynamicTable();
        result = result * PRIME + ($snowflakeDynamicTable == null ? 43 : $snowflakeDynamicTable.hashCode());
        final java.lang.Object $sqlDBTSources = this.getSqlDBTSources();
        result = result * PRIME + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        final java.lang.Object $sqlDbtModels = this.getSqlDbtModels();
        result = result * PRIME + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        final java.lang.Object $subDataType = this.getSubDataType();
        result = result * PRIME + ($subDataType == null ? 43 : $subDataType.hashCode());
        final java.lang.Object $table = this.getTable();
        result = result * PRIME + ($table == null ? 43 : $table.hashCode());
        final java.lang.Object $tableName = this.getTableName();
        result = result * PRIME + ($tableName == null ? 43 : $tableName.hashCode());
        final java.lang.Object $tablePartition = this.getTablePartition();
        result = result * PRIME + ($tablePartition == null ? 43 : $tablePartition.hashCode());
        final java.lang.Object $tableQualifiedName = this.getTableQualifiedName();
        result = result * PRIME + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        final java.lang.Object $validations = this.getValidations();
        result = result * PRIME + ($validations == null ? 43 : $validations.hashCode());
        final java.lang.Object $view = this.getView();
        result = result * PRIME + ($view == null ? 43 : $view.hashCode());
        final java.lang.Object $viewName = this.getViewName();
        result = result * PRIME + ($viewName == null ? 43 : $viewName.hashCode());
        final java.lang.Object $viewQualifiedName = this.getViewQualifiedName();
        result = result * PRIME + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Column(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", calculationView=" + this.getCalculationView() + ", calculationViewName=" + this.getCalculationViewName() + ", calculationViewQualifiedName=" + this.getCalculationViewQualifiedName() + ", columnAverage=" + this.getColumnAverage() + ", columnAverageLength=" + this.getColumnAverageLength() + ", columnDbtModelColumns=" + this.getColumnDbtModelColumns() + ", columnDepthLevel=" + this.getColumnDepthLevel() + ", columnDistinctValuesCount=" + this.getColumnDistinctValuesCount() + ", columnDistinctValuesCountLong=" + this.getColumnDistinctValuesCountLong() + ", columnDuplicateValuesCount=" + this.getColumnDuplicateValuesCount() + ", columnDuplicateValuesCountLong=" + this.getColumnDuplicateValuesCountLong() + ", columnHierarchy=" + this.getColumnHierarchy() + ", columnHistogram=" + this.getColumnHistogram() + ", columnMax=" + this.getColumnMax() + ", columnMaximumStringLength=" + this.getColumnMaximumStringLength() + ", columnMaxs=" + this.getColumnMaxs() + ", columnMean=" + this.getColumnMean() + ", columnMedian=" + this.getColumnMedian() + ", columnMin=" + this.getColumnMin() + ", columnMinimumStringLength=" + this.getColumnMinimumStringLength() + ", columnMins=" + this.getColumnMins() + ", columnMissingValuesCount=" + this.getColumnMissingValuesCount() + ", columnMissingValuesCountLong=" + this.getColumnMissingValuesCountLong() + ", columnMissingValuesPercentage=" + this.getColumnMissingValuesPercentage() + ", columnStandardDeviation=" + this.getColumnStandardDeviation() + ", columnSum=" + this.getColumnSum() + ", columnTopValues=" + this.getColumnTopValues() + ", columnUniqueValuesCount=" + this.getColumnUniqueValuesCount() + ", columnUniqueValuesCountLong=" + this.getColumnUniqueValuesCountLong() + ", columnUniquenessPercentage=" + this.getColumnUniquenessPercentage() + ", columnVariance=" + this.getColumnVariance() + ", dataQualityMetricDimensions=" + this.getDataQualityMetricDimensions() + ", dataType=" + this.getDataType() + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtMetrics=" + this.getDbtMetrics() + ", dbtModelColumns=" + this.getDbtModelColumns() + ", dbtModels=" + this.getDbtModels() + ", dbtSources=" + this.getDbtSources() + ", dbtTests=" + this.getDbtTests() + ", defaultValue=" + this.getDefaultValue() + ", foreignKeyFrom=" + this.getForeignKeyFrom() + ", foreignKeyTo=" + this.getForeignKeyTo() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isClustered=" + this.getIsClustered() + ", isDist=" + this.getIsDist() + ", isForeign=" + this.getIsForeign() + ", isIndexed=" + this.getIsIndexed() + ", isNullable=" + this.getIsNullable() + ", isPartition=" + this.getIsPartition() + ", isPinned=" + this.getIsPinned() + ", isPrimary=" + this.getIsPrimary() + ", isProfiled=" + this.getIsProfiled() + ", isSort=" + this.getIsSort() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", materializedView=" + this.getMaterializedView() + ", maxLength=" + this.getMaxLength() + ", metricTimestamps=" + this.getMetricTimestamps() + ", nestedColumnCount=" + this.getNestedColumnCount() + ", nestedColumnOrder=" + this.getNestedColumnOrder() + ", nestedColumns=" + this.getNestedColumns() + ", numericScale=" + this.getNumericScale() + ", order=" + this.getOrder() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", parentColumn=" + this.getParentColumn() + ", parentColumnName=" + this.getParentColumnName() + ", parentColumnQualifiedName=" + this.getParentColumnQualifiedName() + ", partitionOrder=" + this.getPartitionOrder() + ", pinnedAt=" + this.getPinnedAt() + ", pinnedBy=" + this.getPinnedBy() + ", precision=" + this.getPrecision() + ", queries=" + this.getQueries() + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + this.getQueryUserMap() + ", rawDataTypeDefinition=" + this.getRawDataTypeDefinition() + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", snowflakeDynamicTable=" + this.getSnowflakeDynamicTable() + ", sqlDBTSources=" + this.getSqlDBTSources() + ", sqlDbtModels=" + this.getSqlDbtModels() + ", subDataType=" + this.getSubDataType() + ", table=" + this.getTable() + ", tableName=" + this.getTableName() + ", tablePartition=" + this.getTablePartition() + ", tableQualifiedName=" + this.getTableQualifiedName() + ", validations=" + this.getValidations() + ", view=" + this.getView() + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ")";
    }

    /**
     * Fixed typeName for Columns.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
