// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a column-level lineage process in Atlan. Inputs and outputs of these processes should be columns.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class ColumnProcess extends Asset implements IColumnProcess, ILineageProcess, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ColumnProcess.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ColumnProcess";
    /**
     * Fixed typeName for ColumnProcesss.
     */
    String typeName;
    /**
     * Additional Context of the ETL pipeline/notebook which creates the process.
     */
    @Attribute
    String additionalEtlContext;
    /**
     * Tasks that exist within this process.
     */
    @Attribute
    SortedSet<IAirflowTask> airflowTasks;
    /**
     * Parsed AST of the code or SQL statements that describe the logic of this process.
     */
    @Attribute
    String ast;
    /**
     * Code that ran within the process.
     */
    @Attribute
    String code;
    /**
     * Processes that detail column-level lineage for this process.
     */
    @Attribute
    SortedSet<IColumnProcess> columnProcesses;
    /**
     * Assets that are inputs to this process.
     */
    @Attribute
    SortedSet<ICatalog> inputs;
    /**
     * Matillion component that contains the logic for this lineage process.
     */
    @Attribute
    IMatillionComponent matillionComponent;
    /**
     * Assets that are outputs from this process.
     */
    @Attribute
    SortedSet<ICatalog> outputs;
    /**
     * PowerBI Dataflow that is associated with this lineage process.
     */
    @Attribute
    IPowerBIDataflow powerBIDataflow;
    /**
     * Process in which this task exists.
     */
    @Attribute
    ILineageProcess process;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> sparkJobs;
    /**
     * SQL query that ran to produce the outputs.
     */
    @Attribute
    String sql;

    /**
     * Builds the minimal object necessary to create a relationship to a ColumnProcess, from a potentially
     * more-complete ColumnProcess object.
     *
     * @return the minimal object necessary to relate to the ColumnProcess
     * @throws InvalidRequestException if any of the minimal set of required properties for a ColumnProcess relationship are not found in the initial object
     */
    @Override
    public ColumnProcess trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all ColumnProcess assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ColumnProcess assets will be included.
     *
     * @return a fluent search that includes all ColumnProcess assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all ColumnProcess assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ColumnProcess assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all ColumnProcess assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all ColumnProcess assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) ColumnProcesss will be included
     * @return a fluent search that includes all ColumnProcess assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all ColumnProcess assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) ColumnProcesss will be included
     * @return a fluent search that includes all ColumnProcess assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a ColumnProcess by GUID. Use this to create a relationship to this ColumnProcess,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the ColumnProcess to reference
     * @return reference to a ColumnProcess that can be used for defining a relationship to a ColumnProcess
     */
    public static ColumnProcess refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ColumnProcess by GUID. Use this to create a relationship to this ColumnProcess,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the ColumnProcess to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ColumnProcess that can be used for defining a relationship to a ColumnProcess
     */
    public static ColumnProcess refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ColumnProcess._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a ColumnProcess by qualifiedName. Use this to create a relationship to this ColumnProcess,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the ColumnProcess to reference
     * @return reference to a ColumnProcess that can be used for defining a relationship to a ColumnProcess
     */
    public static ColumnProcess refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ColumnProcess by qualifiedName. Use this to create a relationship to this ColumnProcess,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the ColumnProcess to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ColumnProcess that can be used for defining a relationship to a ColumnProcess
     */
    public static ColumnProcess refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ColumnProcess._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a ColumnProcess by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the ColumnProcess to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ColumnProcess, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ColumnProcess does not exist or the provided GUID is not a ColumnProcess
     */
    @JsonIgnore
    public static ColumnProcess get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a ColumnProcess by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ColumnProcess to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ColumnProcess, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ColumnProcess does not exist or the provided GUID is not a ColumnProcess
     */
    @JsonIgnore
    public static ColumnProcess get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a ColumnProcess by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ColumnProcess to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full ColumnProcess, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ColumnProcess does not exist or the provided GUID is not a ColumnProcess
     */
    @JsonIgnore
    public static ColumnProcess get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof ColumnProcess) {
                return (ColumnProcess) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof ColumnProcess) {
                return (ColumnProcess) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) ColumnProcess to active.
     *
     * @param qualifiedName for the ColumnProcess
     * @return true if the ColumnProcess is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) ColumnProcess to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the ColumnProcess
     * @return true if the ColumnProcess is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a column-level process.
     *
     * @param name of the column-level process
     * @param connectionQualifiedName unique name of the specific instance of that software / system that ran the process
     * @param id (optional) unique ID of this process within the software / system that ran it (if not provided, it will be generated)
     * @param inputs columns of data the process reads from
     * @param outputs columns of data the process writes to
     * @param parent parent process in which this column-level process ran
     * @return the minimal object necessary to create the column-level process, as a builder
     */
    public static ColumnProcessBuilder<?, ?> creator(String name, String connectionQualifiedName, String id, List<ICatalog> inputs, List<ICatalog> outputs, LineageProcess parent) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        String connectionName = StringUtils.getNameFromQualifiedName(connectionQualifiedName);
        ColumnProcessBuilder<?, ?> builder = ColumnProcess._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(LineageProcess.generateQualifiedName(name, connectionQualifiedName, id, inputs, outputs, parent)).name(name).connectorType(connectorType).connectionName(connectionName).connectionQualifiedName(connectionQualifiedName).inputs(inputs).outputs(outputs);
        if (parent != null) {
            builder.process(parent);
        }
        return builder;
    }

    /**
     * Builds the minimal object necessary to update a ColumnProcess.
     *
     * @param qualifiedName of the ColumnProcess
     * @param name of the ColumnProcess
     * @return the minimal request necessary to update the ColumnProcess, as a builder
     */
    public static ColumnProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return ColumnProcess._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a ColumnProcess, from a potentially
     * more-complete ColumnProcess object.
     *
     * @return the minimal object necessary to update the ColumnProcess, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for ColumnProcess are not found in the initial object
     */
    @Override
    public ColumnProcessBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a ColumnProcess.
     *
     * @param qualifiedName of the ColumnProcess
     * @param name of the ColumnProcess
     * @return the updated ColumnProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a ColumnProcess.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ColumnProcess
     * @param name of the ColumnProcess
     * @return the updated ColumnProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a ColumnProcess.
     *
     * @param qualifiedName of the ColumnProcess
     * @param name of the ColumnProcess
     * @return the updated ColumnProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a ColumnProcess.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ColumnProcess
     * @param name of the ColumnProcess
     * @return the updated ColumnProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a ColumnProcess.
     *
     * @param qualifiedName of the ColumnProcess
     * @param name of the ColumnProcess
     * @return the updated ColumnProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a ColumnProcess.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ColumnProcess's owners
     * @param qualifiedName of the ColumnProcess
     * @param name of the ColumnProcess
     * @return the updated ColumnProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a ColumnProcess.
     *
     * @param qualifiedName of the ColumnProcess
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ColumnProcess, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a ColumnProcess.
     *
     * @param client connectivity to the Atlan tenant on which to update the ColumnProcess's certificate
     * @param qualifiedName of the ColumnProcess
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ColumnProcess, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ColumnProcess) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a ColumnProcess.
     *
     * @param qualifiedName of the ColumnProcess
     * @param name of the ColumnProcess
     * @return the updated ColumnProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a ColumnProcess.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ColumnProcess's certificate
     * @param qualifiedName of the ColumnProcess
     * @param name of the ColumnProcess
     * @return the updated ColumnProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a ColumnProcess.
     *
     * @param qualifiedName of the ColumnProcess
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a ColumnProcess.
     *
     * @param client connectivity to the Atlan tenant on which to update the ColumnProcess's announcement
     * @param qualifiedName of the ColumnProcess
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ColumnProcess) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a ColumnProcess.
     *
     * @param qualifiedName of the ColumnProcess
     * @param name of the ColumnProcess
     * @return the updated ColumnProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a ColumnProcess.
     *
     * @param client connectivity to the Atlan client from which to remove the ColumnProcess's announcement
     * @param qualifiedName of the ColumnProcess
     * @param name of the ColumnProcess
     * @return the updated ColumnProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the ColumnProcess.
     *
     * @param qualifiedName for the ColumnProcess
     * @param name human-readable name of the ColumnProcess
     * @param terms the list of terms to replace on the ColumnProcess, or null to remove all terms from the ColumnProcess
     * @return the ColumnProcess that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the ColumnProcess.
     *
     * @param client connectivity to the Atlan tenant on which to replace the ColumnProcess's assigned terms
     * @param qualifiedName for the ColumnProcess
     * @param name human-readable name of the ColumnProcess
     * @param terms the list of terms to replace on the ColumnProcess, or null to remove all terms from the ColumnProcess
     * @return the ColumnProcess that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ColumnProcess) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the ColumnProcess, without replacing existing terms linked to the ColumnProcess.
     * Note: this operation must make two API calls — one to retrieve the ColumnProcess's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the ColumnProcess
     * @param terms the list of terms to append to the ColumnProcess
     * @return the ColumnProcess that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the ColumnProcess, without replacing existing terms linked to the ColumnProcess.
     * Note: this operation must make two API calls — one to retrieve the ColumnProcess's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the ColumnProcess
     * @param qualifiedName for the ColumnProcess
     * @param terms the list of terms to append to the ColumnProcess
     * @return the ColumnProcess that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ColumnProcess) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a ColumnProcess, without replacing all existing terms linked to the ColumnProcess.
     * Note: this operation must make two API calls — one to retrieve the ColumnProcess's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the ColumnProcess
     * @param terms the list of terms to remove from the ColumnProcess, which must be referenced by GUID
     * @return the ColumnProcess that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a ColumnProcess, without replacing all existing terms linked to the ColumnProcess.
     * Note: this operation must make two API calls — one to retrieve the ColumnProcess's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the ColumnProcess
     * @param qualifiedName for the ColumnProcess
     * @param terms the list of terms to remove from the ColumnProcess, which must be referenced by GUID
     * @return the ColumnProcess that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ColumnProcess removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ColumnProcess) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a ColumnProcess, without replacing existing Atlan tags linked to the ColumnProcess.
     * Note: this operation must make two API calls — one to retrieve the ColumnProcess's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ColumnProcess
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ColumnProcess
     */
    public static ColumnProcess appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ColumnProcess, without replacing existing Atlan tags linked to the ColumnProcess.
     * Note: this operation must make two API calls — one to retrieve the ColumnProcess's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ColumnProcess
     * @param qualifiedName of the ColumnProcess
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ColumnProcess
     */
    public static ColumnProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ColumnProcess) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ColumnProcess, without replacing existing Atlan tags linked to the ColumnProcess.
     * Note: this operation must make two API calls — one to retrieve the ColumnProcess's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ColumnProcess
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ColumnProcess
     */
    public static ColumnProcess appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a ColumnProcess, without replacing existing Atlan tags linked to the ColumnProcess.
     * Note: this operation must make two API calls — one to retrieve the ColumnProcess's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ColumnProcess
     * @param qualifiedName of the ColumnProcess
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ColumnProcess
     */
    public static ColumnProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ColumnProcess) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a ColumnProcess.
     *
     * @param qualifiedName of the ColumnProcess
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ColumnProcess
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a ColumnProcess.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a ColumnProcess
     * @param qualifiedName of the ColumnProcess
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ColumnProcess
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class ColumnProcessBuilder<C extends ColumnProcess, B extends ColumnProcess.ColumnProcessBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String additionalEtlContext;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> airflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String ast;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String code;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IColumnProcess> columnProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICatalog> inputs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IMatillionComponent matillionComponent;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICatalog> outputs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IPowerBIDataflow powerBIDataflow;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILineageProcess process;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> sparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sql;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            ColumnProcess.ColumnProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final ColumnProcess instance, final ColumnProcess.ColumnProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.additionalEtlContext(instance.additionalEtlContext);
            b.airflowTasks(instance.airflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.airflowTasks);
            b.ast(instance.ast);
            b.code(instance.code);
            b.columnProcesses(instance.columnProcesses == null ? java.util.Collections.<IColumnProcess>emptySortedSet() : instance.columnProcesses);
            b.inputs(instance.inputs == null ? java.util.Collections.<ICatalog>emptySortedSet() : instance.inputs);
            b.matillionComponent(instance.matillionComponent);
            b.outputs(instance.outputs == null ? java.util.Collections.<ICatalog>emptySortedSet() : instance.outputs);
            b.powerBIDataflow(instance.powerBIDataflow);
            b.process(instance.process);
            b.sparkJobs(instance.sparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.sparkJobs);
            b.sql(instance.sql);
        }

        /**
         * Fixed typeName for ColumnProcesss.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Additional Context of the ETL pipeline/notebook which creates the process.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B additionalEtlContext(final String additionalEtlContext) {
            this.additionalEtlContext = additionalEtlContext;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTask(final IAirflowTask airflowTask) {
            if (this.airflowTasks == null) this.airflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.airflowTasks.add(airflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTasks(final java.util.Collection<? extends IAirflowTask> airflowTasks) {
            if (airflowTasks == null) {
                throw new java.lang.NullPointerException("airflowTasks cannot be null");
            }
            if (this.airflowTasks == null) this.airflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.airflowTasks.addAll(airflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAirflowTasks() {
            if (this.airflowTasks != null) this.airflowTasks.clear();
            return self();
        }

        /**
         * Parsed AST of the code or SQL statements that describe the logic of this process.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B ast(final String ast) {
            this.ast = ast;
            return self();
        }

        /**
         * Code that ran within the process.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B code(final String code) {
            this.code = code;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnProcess(final IColumnProcess columnProcess) {
            if (this.columnProcesses == null) this.columnProcesses = new java.util.ArrayList<IColumnProcess>();
            this.columnProcesses.add(columnProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnProcesses(final java.util.Collection<? extends IColumnProcess> columnProcesses) {
            if (columnProcesses == null) {
                throw new java.lang.NullPointerException("columnProcesses cannot be null");
            }
            if (this.columnProcesses == null) this.columnProcesses = new java.util.ArrayList<IColumnProcess>();
            this.columnProcesses.addAll(columnProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumnProcesses() {
            if (this.columnProcesses != null) this.columnProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B input(final ICatalog input) {
            if (this.inputs == null) this.inputs = new java.util.ArrayList<ICatalog>();
            this.inputs.add(input);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputs(final java.util.Collection<? extends ICatalog> inputs) {
            if (inputs == null) {
                throw new java.lang.NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) this.inputs = new java.util.ArrayList<ICatalog>();
            this.inputs.addAll(inputs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputs() {
            if (this.inputs != null) this.inputs.clear();
            return self();
        }

        /**
         * Matillion component that contains the logic for this lineage process.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionComponent(final IMatillionComponent matillionComponent) {
            this.matillionComponent = matillionComponent;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B output(final ICatalog output) {
            if (this.outputs == null) this.outputs = new java.util.ArrayList<ICatalog>();
            this.outputs.add(output);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputs(final java.util.Collection<? extends ICatalog> outputs) {
            if (outputs == null) {
                throw new java.lang.NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) this.outputs = new java.util.ArrayList<ICatalog>();
            this.outputs.addAll(outputs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputs() {
            if (this.outputs != null) this.outputs.clear();
            return self();
        }

        /**
         * PowerBI Dataflow that is associated with this lineage process.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIDataflow(final IPowerBIDataflow powerBIDataflow) {
            this.powerBIDataflow = powerBIDataflow;
            return self();
        }

        /**
         * Process in which this task exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B process(final ILineageProcess process) {
            this.process = process;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sparkJob(final ISparkJob sparkJob) {
            if (this.sparkJobs == null) this.sparkJobs = new java.util.ArrayList<ISparkJob>();
            this.sparkJobs.add(sparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sparkJobs(final java.util.Collection<? extends ISparkJob> sparkJobs) {
            if (sparkJobs == null) {
                throw new java.lang.NullPointerException("sparkJobs cannot be null");
            }
            if (this.sparkJobs == null) this.sparkJobs = new java.util.ArrayList<ISparkJob>();
            this.sparkJobs.addAll(sparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSparkJobs() {
            if (this.sparkJobs != null) this.sparkJobs.clear();
            return self();
        }

        /**
         * SQL query that ran to produce the outputs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sql(final String sql) {
            this.sql = sql;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ColumnProcess.ColumnProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", additionalEtlContext=" + this.additionalEtlContext + ", airflowTasks=" + this.airflowTasks + ", ast=" + this.ast + ", code=" + this.code + ", columnProcesses=" + this.columnProcesses + ", inputs=" + this.inputs + ", matillionComponent=" + this.matillionComponent + ", outputs=" + this.outputs + ", powerBIDataflow=" + this.powerBIDataflow + ", process=" + this.process + ", sparkJobs=" + this.sparkJobs + ", sql=" + this.sql + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class ColumnProcessBuilderImpl extends ColumnProcess.ColumnProcessBuilder<ColumnProcess, ColumnProcess.ColumnProcessBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ColumnProcessBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected ColumnProcess.ColumnProcessBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ColumnProcess build() {
            return new ColumnProcess(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected ColumnProcess(final ColumnProcess.ColumnProcessBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = ColumnProcess.$default$typeName();
        this.additionalEtlContext = b.additionalEtlContext;
        java.util.SortedSet<IAirflowTask> airflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.airflowTasks != null) airflowTasks.addAll(b.airflowTasks);
        airflowTasks = java.util.Collections.unmodifiableSortedSet(airflowTasks);
        this.airflowTasks = airflowTasks;
        this.ast = b.ast;
        this.code = b.code;
        java.util.SortedSet<IColumnProcess> columnProcesses = new java.util.TreeSet<IColumnProcess>();
        if (b.columnProcesses != null) columnProcesses.addAll(b.columnProcesses);
        columnProcesses = java.util.Collections.unmodifiableSortedSet(columnProcesses);
        this.columnProcesses = columnProcesses;
        java.util.SortedSet<ICatalog> inputs = new java.util.TreeSet<ICatalog>();
        if (b.inputs != null) inputs.addAll(b.inputs);
        inputs = java.util.Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        this.matillionComponent = b.matillionComponent;
        java.util.SortedSet<ICatalog> outputs = new java.util.TreeSet<ICatalog>();
        if (b.outputs != null) outputs.addAll(b.outputs);
        outputs = java.util.Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
        this.powerBIDataflow = b.powerBIDataflow;
        this.process = b.process;
        java.util.SortedSet<ISparkJob> sparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.sparkJobs != null) sparkJobs.addAll(b.sparkJobs);
        sparkJobs = java.util.Collections.unmodifiableSortedSet(sparkJobs);
        this.sparkJobs = sparkJobs;
        this.sql = b.sql;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ColumnProcess.ColumnProcessBuilder<?, ?> _internal() {
        return new ColumnProcess.ColumnProcessBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ColumnProcess.ColumnProcessBuilder<?, ?> toBuilder() {
        return new ColumnProcess.ColumnProcessBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Additional Context of the ETL pipeline/notebook which creates the process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAdditionalEtlContext() {
        return this.additionalEtlContext;
    }

    /**
     * Tasks that exist within this process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getAirflowTasks() {
        return this.airflowTasks;
    }

    /**
     * Parsed AST of the code or SQL statements that describe the logic of this process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAst() {
        return this.ast;
    }

    /**
     * Code that ran within the process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCode() {
        return this.code;
    }

    /**
     * Processes that detail column-level lineage for this process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IColumnProcess> getColumnProcesses() {
        return this.columnProcesses;
    }

    /**
     * Assets that are inputs to this process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICatalog> getInputs() {
        return this.inputs;
    }

    /**
     * Matillion component that contains the logic for this lineage process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IMatillionComponent getMatillionComponent() {
        return this.matillionComponent;
    }

    /**
     * Assets that are outputs from this process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICatalog> getOutputs() {
        return this.outputs;
    }

    /**
     * PowerBI Dataflow that is associated with this lineage process.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IPowerBIDataflow getPowerBIDataflow() {
        return this.powerBIDataflow;
    }

    /**
     * Process in which this task exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILineageProcess getProcess() {
        return this.process;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getSparkJobs() {
        return this.sparkJobs;
    }

    /**
     * SQL query that ran to produce the outputs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSql() {
        return this.sql;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ColumnProcess)) return false;
        final ColumnProcess other = (ColumnProcess) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$additionalEtlContext = this.getAdditionalEtlContext();
        final java.lang.Object other$additionalEtlContext = other.getAdditionalEtlContext();
        if (this$additionalEtlContext == null ? other$additionalEtlContext != null : !this$additionalEtlContext.equals(other$additionalEtlContext)) return false;
        final java.lang.Object this$airflowTasks = this.getAirflowTasks();
        final java.lang.Object other$airflowTasks = other.getAirflowTasks();
        if (this$airflowTasks == null ? other$airflowTasks != null : !this$airflowTasks.equals(other$airflowTasks)) return false;
        final java.lang.Object this$ast = this.getAst();
        final java.lang.Object other$ast = other.getAst();
        if (this$ast == null ? other$ast != null : !this$ast.equals(other$ast)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$columnProcesses = this.getColumnProcesses();
        final java.lang.Object other$columnProcesses = other.getColumnProcesses();
        if (this$columnProcesses == null ? other$columnProcesses != null : !this$columnProcesses.equals(other$columnProcesses)) return false;
        final java.lang.Object this$inputs = this.getInputs();
        final java.lang.Object other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) return false;
        final java.lang.Object this$matillionComponent = this.getMatillionComponent();
        final java.lang.Object other$matillionComponent = other.getMatillionComponent();
        if (this$matillionComponent == null ? other$matillionComponent != null : !this$matillionComponent.equals(other$matillionComponent)) return false;
        final java.lang.Object this$outputs = this.getOutputs();
        final java.lang.Object other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) return false;
        final java.lang.Object this$powerBIDataflow = this.getPowerBIDataflow();
        final java.lang.Object other$powerBIDataflow = other.getPowerBIDataflow();
        if (this$powerBIDataflow == null ? other$powerBIDataflow != null : !this$powerBIDataflow.equals(other$powerBIDataflow)) return false;
        final java.lang.Object this$process = this.getProcess();
        final java.lang.Object other$process = other.getProcess();
        if (this$process == null ? other$process != null : !this$process.equals(other$process)) return false;
        final java.lang.Object this$sparkJobs = this.getSparkJobs();
        final java.lang.Object other$sparkJobs = other.getSparkJobs();
        if (this$sparkJobs == null ? other$sparkJobs != null : !this$sparkJobs.equals(other$sparkJobs)) return false;
        final java.lang.Object this$sql = this.getSql();
        final java.lang.Object other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ColumnProcess;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $additionalEtlContext = this.getAdditionalEtlContext();
        result = result * PRIME + ($additionalEtlContext == null ? 43 : $additionalEtlContext.hashCode());
        final java.lang.Object $airflowTasks = this.getAirflowTasks();
        result = result * PRIME + ($airflowTasks == null ? 43 : $airflowTasks.hashCode());
        final java.lang.Object $ast = this.getAst();
        result = result * PRIME + ($ast == null ? 43 : $ast.hashCode());
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $columnProcesses = this.getColumnProcesses();
        result = result * PRIME + ($columnProcesses == null ? 43 : $columnProcesses.hashCode());
        final java.lang.Object $inputs = this.getInputs();
        result = result * PRIME + ($inputs == null ? 43 : $inputs.hashCode());
        final java.lang.Object $matillionComponent = this.getMatillionComponent();
        result = result * PRIME + ($matillionComponent == null ? 43 : $matillionComponent.hashCode());
        final java.lang.Object $outputs = this.getOutputs();
        result = result * PRIME + ($outputs == null ? 43 : $outputs.hashCode());
        final java.lang.Object $powerBIDataflow = this.getPowerBIDataflow();
        result = result * PRIME + ($powerBIDataflow == null ? 43 : $powerBIDataflow.hashCode());
        final java.lang.Object $process = this.getProcess();
        result = result * PRIME + ($process == null ? 43 : $process.hashCode());
        final java.lang.Object $sparkJobs = this.getSparkJobs();
        result = result * PRIME + ($sparkJobs == null ? 43 : $sparkJobs.hashCode());
        final java.lang.Object $sql = this.getSql();
        result = result * PRIME + ($sql == null ? 43 : $sql.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ColumnProcess(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", additionalEtlContext=" + this.getAdditionalEtlContext() + ", airflowTasks=" + this.getAirflowTasks() + ", ast=" + this.getAst() + ", code=" + this.getCode() + ", columnProcesses=" + this.getColumnProcesses() + ", inputs=" + this.getInputs() + ", matillionComponent=" + this.getMatillionComponent() + ", outputs=" + this.getOutputs() + ", powerBIDataflow=" + this.getPowerBIDataflow() + ", process=" + this.getProcess() + ", sparkJobs=" + this.getSparkJobs() + ", sql=" + this.getSql() + ")";
    }

    /**
     * Fixed typeName for ColumnProcesss.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
