// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Cosmos MongoDB account in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class CosmosMongoDBAccount extends Asset implements ICosmosMongoDBAccount, ICosmosMongoDB, INoSQL, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CosmosMongoDBAccount.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CosmosMongoDBAccount";
    /**
     * Fixed typeName for CosmosMongoDBAccounts.
     */
    String typeName;
    /**
     * The consistency policy configured for the Cosmos MongoDB account.
     */
    @Attribute
    String cosmosMongoDBAccountConsistencyPolicy;
    /**
     * The Document Endpoint URL for the Cosmos MongoDB account.
     */
    @Attribute
    String cosmosMongoDBAccountDocumentEndpoint;
    /**
     * Indicates whether automatic failover is enabled for the Cosmos MongoDB account.
     */
    @Attribute
    Boolean cosmosMongoDBAccountEnableAutomaticFailover;
    /**
     * Indicates whether multiple write locations are enabled for the Cosmos MongoDB account.
     */
    @Attribute
    Boolean cosmosMongoDBAccountEnableMultipleWriteLocations;
    /**
     * Indicates whether partition key monitoring is enabled for the Cosmos MongoDB account.
     */
    @Attribute
    Boolean cosmosMongoDBAccountEnablePartitionKeyMonitor;
    /**
     * The unique identifier for the Cosmos MongoDB account.
     */
    @Attribute
    String cosmosMongoDBAccountInstanceId;
    /**
     * Indicates whether the virtual network filter is enabled for the Cosmos MongoDB account.
     */
    @Attribute
    Boolean cosmosMongoDBAccountIsVirtualNetworkFilterEnabled;
    /**
     * The locations where the Cosmos MongoDB account is available.
     */
    @Attribute
    SortedSet<String> cosmosMongoDBAccountLocations;
    /**
     * The MongoDB connection endpoint for the Cosmos MongoDB account.
     */
    @Attribute
    String cosmosMongoDBAccountMongoEndpoint;
    /**
     * The status of public network access for the Cosmos MongoDB account.
     */
    @Attribute
    String cosmosMongoDBAccountPublicNetworkAccess;
    /**
     * The read locations configured for the Cosmos MongoDB account.
     */
    @Attribute
    SortedSet<String> cosmosMongoDBAccountReadLocations;
    /**
     * The resource group that contains the Cosmos MongoDB account.
     */
    @Attribute
    String cosmosMongoDBAccountResourceGroup;
    /**
     * The ID of the subscription to which the Cosmos MongoDB account belongs.
     */
    @Attribute
    String cosmosMongoDBAccountSubscriptionId;
    /**
     * The type of the Cosmos MongoDB account, such as RU or VCORE.
     */
    @Attribute
    String cosmosMongoDBAccountType;
    /**
     * The write locations configured for the Cosmos MongoDB account.
     */
    @Attribute
    SortedSet<String> cosmosMongoDBAccountWriteLocations;
    /**
     * Number of databases in this Cosmos MongoDB account.
     */
    @Attribute
    Long cosmosMongoDBDatabaseCount;
    /**
     * Databases that exist within this account.
     */
    @Attribute
    SortedSet<ICosmosMongoDBDatabase> cosmosMongoDBDatabases;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Represents attributes for describing the key schema for the table and indexes.
     */
    @Attribute
    String noSQLSchemaDefinition;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a CosmosMongoDBAccount, from a potentially
     * more-complete CosmosMongoDBAccount object.
     *
     * @return the minimal object necessary to relate to the CosmosMongoDBAccount
     * @throws InvalidRequestException if any of the minimal set of required properties for a CosmosMongoDBAccount relationship are not found in the initial object
     */
    @Override
    public CosmosMongoDBAccount trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all CosmosMongoDBAccount assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) CosmosMongoDBAccount assets will be included.
     *
     * @return a fluent search that includes all CosmosMongoDBAccount assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all CosmosMongoDBAccount assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) CosmosMongoDBAccount assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all CosmosMongoDBAccount assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all CosmosMongoDBAccount assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) CosmosMongoDBAccounts will be included
     * @return a fluent search that includes all CosmosMongoDBAccount assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all CosmosMongoDBAccount assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) CosmosMongoDBAccounts will be included
     * @return a fluent search that includes all CosmosMongoDBAccount assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a CosmosMongoDBAccount by GUID. Use this to create a relationship to this CosmosMongoDBAccount,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the CosmosMongoDBAccount to reference
     * @return reference to a CosmosMongoDBAccount that can be used for defining a relationship to a CosmosMongoDBAccount
     */
    public static CosmosMongoDBAccount refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a CosmosMongoDBAccount by GUID. Use this to create a relationship to this CosmosMongoDBAccount,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the CosmosMongoDBAccount to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a CosmosMongoDBAccount that can be used for defining a relationship to a CosmosMongoDBAccount
     */
    public static CosmosMongoDBAccount refByGuid(String guid, Reference.SaveSemantic semantic) {
        return CosmosMongoDBAccount._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a CosmosMongoDBAccount by qualifiedName. Use this to create a relationship to this CosmosMongoDBAccount,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the CosmosMongoDBAccount to reference
     * @return reference to a CosmosMongoDBAccount that can be used for defining a relationship to a CosmosMongoDBAccount
     */
    public static CosmosMongoDBAccount refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a CosmosMongoDBAccount by qualifiedName. Use this to create a relationship to this CosmosMongoDBAccount,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the CosmosMongoDBAccount to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a CosmosMongoDBAccount that can be used for defining a relationship to a CosmosMongoDBAccount
     */
    public static CosmosMongoDBAccount refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return CosmosMongoDBAccount._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a CosmosMongoDBAccount by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the CosmosMongoDBAccount to retrieve, either its GUID or its full qualifiedName
     * @return the requested full CosmosMongoDBAccount, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CosmosMongoDBAccount does not exist or the provided GUID is not a CosmosMongoDBAccount
     */
    @JsonIgnore
    public static CosmosMongoDBAccount get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a CosmosMongoDBAccount by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the CosmosMongoDBAccount to retrieve, either its GUID or its full qualifiedName
     * @return the requested full CosmosMongoDBAccount, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CosmosMongoDBAccount does not exist or the provided GUID is not a CosmosMongoDBAccount
     */
    @JsonIgnore
    public static CosmosMongoDBAccount get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a CosmosMongoDBAccount by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the CosmosMongoDBAccount to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full CosmosMongoDBAccount, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CosmosMongoDBAccount does not exist or the provided GUID is not a CosmosMongoDBAccount
     */
    @JsonIgnore
    public static CosmosMongoDBAccount get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof CosmosMongoDBAccount) {
                return (CosmosMongoDBAccount) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof CosmosMongoDBAccount) {
                return (CosmosMongoDBAccount) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) CosmosMongoDBAccount to active.
     *
     * @param qualifiedName for the CosmosMongoDBAccount
     * @return true if the CosmosMongoDBAccount is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) CosmosMongoDBAccount to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the CosmosMongoDBAccount
     * @return true if the CosmosMongoDBAccount is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a CosmosMongoDBAccount.
     *
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param name of the CosmosMongoDBAccount
     * @return the minimal request necessary to update the CosmosMongoDBAccount, as a builder
     */
    public static CosmosMongoDBAccountBuilder<?, ?> updater(String qualifiedName, String name) {
        return CosmosMongoDBAccount._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a CosmosMongoDBAccount, from a potentially
     * more-complete CosmosMongoDBAccount object.
     *
     * @return the minimal object necessary to update the CosmosMongoDBAccount, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for CosmosMongoDBAccount are not found in the initial object
     */
    @Override
    public CosmosMongoDBAccountBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a CosmosMongoDBAccount.
     *
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param name of the CosmosMongoDBAccount
     * @return the updated CosmosMongoDBAccount, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a CosmosMongoDBAccount.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param name of the CosmosMongoDBAccount
     * @return the updated CosmosMongoDBAccount, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBAccount) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a CosmosMongoDBAccount.
     *
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param name of the CosmosMongoDBAccount
     * @return the updated CosmosMongoDBAccount, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a CosmosMongoDBAccount.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param name of the CosmosMongoDBAccount
     * @return the updated CosmosMongoDBAccount, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBAccount) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a CosmosMongoDBAccount.
     *
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param name of the CosmosMongoDBAccount
     * @return the updated CosmosMongoDBAccount, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a CosmosMongoDBAccount.
     *
     * @param client connectivity to the Atlan tenant from which to remove the CosmosMongoDBAccount's owners
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param name of the CosmosMongoDBAccount
     * @return the updated CosmosMongoDBAccount, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBAccount) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a CosmosMongoDBAccount.
     *
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated CosmosMongoDBAccount, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a CosmosMongoDBAccount.
     *
     * @param client connectivity to the Atlan tenant on which to update the CosmosMongoDBAccount's certificate
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated CosmosMongoDBAccount, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CosmosMongoDBAccount) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a CosmosMongoDBAccount.
     *
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param name of the CosmosMongoDBAccount
     * @return the updated CosmosMongoDBAccount, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a CosmosMongoDBAccount.
     *
     * @param client connectivity to the Atlan tenant from which to remove the CosmosMongoDBAccount's certificate
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param name of the CosmosMongoDBAccount
     * @return the updated CosmosMongoDBAccount, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBAccount) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a CosmosMongoDBAccount.
     *
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a CosmosMongoDBAccount.
     *
     * @param client connectivity to the Atlan tenant on which to update the CosmosMongoDBAccount's announcement
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CosmosMongoDBAccount) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a CosmosMongoDBAccount.
     *
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param name of the CosmosMongoDBAccount
     * @return the updated CosmosMongoDBAccount, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a CosmosMongoDBAccount.
     *
     * @param client connectivity to the Atlan client from which to remove the CosmosMongoDBAccount's announcement
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param name of the CosmosMongoDBAccount
     * @return the updated CosmosMongoDBAccount, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBAccount) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the CosmosMongoDBAccount.
     *
     * @param qualifiedName for the CosmosMongoDBAccount
     * @param name human-readable name of the CosmosMongoDBAccount
     * @param terms the list of terms to replace on the CosmosMongoDBAccount, or null to remove all terms from the CosmosMongoDBAccount
     * @return the CosmosMongoDBAccount that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the CosmosMongoDBAccount.
     *
     * @param client connectivity to the Atlan tenant on which to replace the CosmosMongoDBAccount's assigned terms
     * @param qualifiedName for the CosmosMongoDBAccount
     * @param name human-readable name of the CosmosMongoDBAccount
     * @param terms the list of terms to replace on the CosmosMongoDBAccount, or null to remove all terms from the CosmosMongoDBAccount
     * @return the CosmosMongoDBAccount that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CosmosMongoDBAccount) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the CosmosMongoDBAccount, without replacing existing terms linked to the CosmosMongoDBAccount.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBAccount's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the CosmosMongoDBAccount
     * @param terms the list of terms to append to the CosmosMongoDBAccount
     * @return the CosmosMongoDBAccount that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the CosmosMongoDBAccount, without replacing existing terms linked to the CosmosMongoDBAccount.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBAccount's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the CosmosMongoDBAccount
     * @param qualifiedName for the CosmosMongoDBAccount
     * @param terms the list of terms to append to the CosmosMongoDBAccount
     * @return the CosmosMongoDBAccount that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CosmosMongoDBAccount) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a CosmosMongoDBAccount, without replacing all existing terms linked to the CosmosMongoDBAccount.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBAccount's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the CosmosMongoDBAccount
     * @param terms the list of terms to remove from the CosmosMongoDBAccount, which must be referenced by GUID
     * @return the CosmosMongoDBAccount that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a CosmosMongoDBAccount, without replacing all existing terms linked to the CosmosMongoDBAccount.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBAccount's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the CosmosMongoDBAccount
     * @param qualifiedName for the CosmosMongoDBAccount
     * @param terms the list of terms to remove from the CosmosMongoDBAccount, which must be referenced by GUID
     * @return the CosmosMongoDBAccount that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBAccount removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CosmosMongoDBAccount) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a CosmosMongoDBAccount, without replacing existing Atlan tags linked to the CosmosMongoDBAccount.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBAccount's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated CosmosMongoDBAccount
     */
    public static CosmosMongoDBAccount appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a CosmosMongoDBAccount, without replacing existing Atlan tags linked to the CosmosMongoDBAccount.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBAccount's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the CosmosMongoDBAccount
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated CosmosMongoDBAccount
     */
    public static CosmosMongoDBAccount appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CosmosMongoDBAccount) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a CosmosMongoDBAccount, without replacing existing Atlan tags linked to the CosmosMongoDBAccount.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBAccount's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated CosmosMongoDBAccount
     */
    public static CosmosMongoDBAccount appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a CosmosMongoDBAccount, without replacing existing Atlan tags linked to the CosmosMongoDBAccount.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBAccount's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the CosmosMongoDBAccount
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated CosmosMongoDBAccount
     */
    public static CosmosMongoDBAccount appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CosmosMongoDBAccount) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a CosmosMongoDBAccount.
     *
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the CosmosMongoDBAccount
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a CosmosMongoDBAccount.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a CosmosMongoDBAccount
     * @param qualifiedName of the CosmosMongoDBAccount
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the CosmosMongoDBAccount
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class CosmosMongoDBAccountBuilder<C extends CosmosMongoDBAccount, B extends CosmosMongoDBAccount.CosmosMongoDBAccountBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cosmosMongoDBAccountConsistencyPolicy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cosmosMongoDBAccountDocumentEndpoint;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean cosmosMongoDBAccountEnableAutomaticFailover;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean cosmosMongoDBAccountEnableMultipleWriteLocations;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean cosmosMongoDBAccountEnablePartitionKeyMonitor;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cosmosMongoDBAccountInstanceId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean cosmosMongoDBAccountIsVirtualNetworkFilterEnabled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> cosmosMongoDBAccountLocations;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cosmosMongoDBAccountMongoEndpoint;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cosmosMongoDBAccountPublicNetworkAccess;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> cosmosMongoDBAccountReadLocations;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cosmosMongoDBAccountResourceGroup;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cosmosMongoDBAccountSubscriptionId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cosmosMongoDBAccountType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> cosmosMongoDBAccountWriteLocations;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long cosmosMongoDBDatabaseCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICosmosMongoDBDatabase> cosmosMongoDBDatabases;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String noSQLSchemaDefinition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            CosmosMongoDBAccount.CosmosMongoDBAccountBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final CosmosMongoDBAccount instance, final CosmosMongoDBAccount.CosmosMongoDBAccountBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cosmosMongoDBAccountConsistencyPolicy(instance.cosmosMongoDBAccountConsistencyPolicy);
            b.cosmosMongoDBAccountDocumentEndpoint(instance.cosmosMongoDBAccountDocumentEndpoint);
            b.cosmosMongoDBAccountEnableAutomaticFailover(instance.cosmosMongoDBAccountEnableAutomaticFailover);
            b.cosmosMongoDBAccountEnableMultipleWriteLocations(instance.cosmosMongoDBAccountEnableMultipleWriteLocations);
            b.cosmosMongoDBAccountEnablePartitionKeyMonitor(instance.cosmosMongoDBAccountEnablePartitionKeyMonitor);
            b.cosmosMongoDBAccountInstanceId(instance.cosmosMongoDBAccountInstanceId);
            b.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled(instance.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled);
            b.cosmosMongoDBAccountLocations(instance.cosmosMongoDBAccountLocations == null ? java.util.Collections.<String>emptySortedSet() : instance.cosmosMongoDBAccountLocations);
            b.cosmosMongoDBAccountMongoEndpoint(instance.cosmosMongoDBAccountMongoEndpoint);
            b.cosmosMongoDBAccountPublicNetworkAccess(instance.cosmosMongoDBAccountPublicNetworkAccess);
            b.cosmosMongoDBAccountReadLocations(instance.cosmosMongoDBAccountReadLocations == null ? java.util.Collections.<String>emptySortedSet() : instance.cosmosMongoDBAccountReadLocations);
            b.cosmosMongoDBAccountResourceGroup(instance.cosmosMongoDBAccountResourceGroup);
            b.cosmosMongoDBAccountSubscriptionId(instance.cosmosMongoDBAccountSubscriptionId);
            b.cosmosMongoDBAccountType(instance.cosmosMongoDBAccountType);
            b.cosmosMongoDBAccountWriteLocations(instance.cosmosMongoDBAccountWriteLocations == null ? java.util.Collections.<String>emptySortedSet() : instance.cosmosMongoDBAccountWriteLocations);
            b.cosmosMongoDBDatabaseCount(instance.cosmosMongoDBDatabaseCount);
            b.cosmosMongoDBDatabases(instance.cosmosMongoDBDatabases == null ? java.util.Collections.<ICosmosMongoDBDatabase>emptySortedSet() : instance.cosmosMongoDBDatabases);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.noSQLSchemaDefinition(instance.noSQLSchemaDefinition);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for CosmosMongoDBAccounts.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * The consistency policy configured for the Cosmos MongoDB account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountConsistencyPolicy(final String cosmosMongoDBAccountConsistencyPolicy) {
            this.cosmosMongoDBAccountConsistencyPolicy = cosmosMongoDBAccountConsistencyPolicy;
            return self();
        }

        /**
         * The Document Endpoint URL for the Cosmos MongoDB account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountDocumentEndpoint(final String cosmosMongoDBAccountDocumentEndpoint) {
            this.cosmosMongoDBAccountDocumentEndpoint = cosmosMongoDBAccountDocumentEndpoint;
            return self();
        }

        /**
         * Indicates whether automatic failover is enabled for the Cosmos MongoDB account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountEnableAutomaticFailover(final Boolean cosmosMongoDBAccountEnableAutomaticFailover) {
            this.cosmosMongoDBAccountEnableAutomaticFailover = cosmosMongoDBAccountEnableAutomaticFailover;
            return self();
        }

        /**
         * Indicates whether multiple write locations are enabled for the Cosmos MongoDB account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountEnableMultipleWriteLocations(final Boolean cosmosMongoDBAccountEnableMultipleWriteLocations) {
            this.cosmosMongoDBAccountEnableMultipleWriteLocations = cosmosMongoDBAccountEnableMultipleWriteLocations;
            return self();
        }

        /**
         * Indicates whether partition key monitoring is enabled for the Cosmos MongoDB account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountEnablePartitionKeyMonitor(final Boolean cosmosMongoDBAccountEnablePartitionKeyMonitor) {
            this.cosmosMongoDBAccountEnablePartitionKeyMonitor = cosmosMongoDBAccountEnablePartitionKeyMonitor;
            return self();
        }

        /**
         * The unique identifier for the Cosmos MongoDB account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountInstanceId(final String cosmosMongoDBAccountInstanceId) {
            this.cosmosMongoDBAccountInstanceId = cosmosMongoDBAccountInstanceId;
            return self();
        }

        /**
         * Indicates whether the virtual network filter is enabled for the Cosmos MongoDB account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountIsVirtualNetworkFilterEnabled(final Boolean cosmosMongoDBAccountIsVirtualNetworkFilterEnabled) {
            this.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled = cosmosMongoDBAccountIsVirtualNetworkFilterEnabled;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountLocation(final String cosmosMongoDBAccountLocation) {
            if (this.cosmosMongoDBAccountLocations == null) this.cosmosMongoDBAccountLocations = new java.util.ArrayList<String>();
            this.cosmosMongoDBAccountLocations.add(cosmosMongoDBAccountLocation);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountLocations(final java.util.Collection<? extends String> cosmosMongoDBAccountLocations) {
            if (cosmosMongoDBAccountLocations == null) {
                throw new java.lang.NullPointerException("cosmosMongoDBAccountLocations cannot be null");
            }
            if (this.cosmosMongoDBAccountLocations == null) this.cosmosMongoDBAccountLocations = new java.util.ArrayList<String>();
            this.cosmosMongoDBAccountLocations.addAll(cosmosMongoDBAccountLocations);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCosmosMongoDBAccountLocations() {
            if (this.cosmosMongoDBAccountLocations != null) this.cosmosMongoDBAccountLocations.clear();
            return self();
        }

        /**
         * The MongoDB connection endpoint for the Cosmos MongoDB account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountMongoEndpoint(final String cosmosMongoDBAccountMongoEndpoint) {
            this.cosmosMongoDBAccountMongoEndpoint = cosmosMongoDBAccountMongoEndpoint;
            return self();
        }

        /**
         * The status of public network access for the Cosmos MongoDB account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountPublicNetworkAccess(final String cosmosMongoDBAccountPublicNetworkAccess) {
            this.cosmosMongoDBAccountPublicNetworkAccess = cosmosMongoDBAccountPublicNetworkAccess;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountReadLocation(final String cosmosMongoDBAccountReadLocation) {
            if (this.cosmosMongoDBAccountReadLocations == null) this.cosmosMongoDBAccountReadLocations = new java.util.ArrayList<String>();
            this.cosmosMongoDBAccountReadLocations.add(cosmosMongoDBAccountReadLocation);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountReadLocations(final java.util.Collection<? extends String> cosmosMongoDBAccountReadLocations) {
            if (cosmosMongoDBAccountReadLocations == null) {
                throw new java.lang.NullPointerException("cosmosMongoDBAccountReadLocations cannot be null");
            }
            if (this.cosmosMongoDBAccountReadLocations == null) this.cosmosMongoDBAccountReadLocations = new java.util.ArrayList<String>();
            this.cosmosMongoDBAccountReadLocations.addAll(cosmosMongoDBAccountReadLocations);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCosmosMongoDBAccountReadLocations() {
            if (this.cosmosMongoDBAccountReadLocations != null) this.cosmosMongoDBAccountReadLocations.clear();
            return self();
        }

        /**
         * The resource group that contains the Cosmos MongoDB account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountResourceGroup(final String cosmosMongoDBAccountResourceGroup) {
            this.cosmosMongoDBAccountResourceGroup = cosmosMongoDBAccountResourceGroup;
            return self();
        }

        /**
         * The ID of the subscription to which the Cosmos MongoDB account belongs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountSubscriptionId(final String cosmosMongoDBAccountSubscriptionId) {
            this.cosmosMongoDBAccountSubscriptionId = cosmosMongoDBAccountSubscriptionId;
            return self();
        }

        /**
         * The type of the Cosmos MongoDB account, such as RU or VCORE.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountType(final String cosmosMongoDBAccountType) {
            this.cosmosMongoDBAccountType = cosmosMongoDBAccountType;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountWriteLocation(final String cosmosMongoDBAccountWriteLocation) {
            if (this.cosmosMongoDBAccountWriteLocations == null) this.cosmosMongoDBAccountWriteLocations = new java.util.ArrayList<String>();
            this.cosmosMongoDBAccountWriteLocations.add(cosmosMongoDBAccountWriteLocation);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountWriteLocations(final java.util.Collection<? extends String> cosmosMongoDBAccountWriteLocations) {
            if (cosmosMongoDBAccountWriteLocations == null) {
                throw new java.lang.NullPointerException("cosmosMongoDBAccountWriteLocations cannot be null");
            }
            if (this.cosmosMongoDBAccountWriteLocations == null) this.cosmosMongoDBAccountWriteLocations = new java.util.ArrayList<String>();
            this.cosmosMongoDBAccountWriteLocations.addAll(cosmosMongoDBAccountWriteLocations);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCosmosMongoDBAccountWriteLocations() {
            if (this.cosmosMongoDBAccountWriteLocations != null) this.cosmosMongoDBAccountWriteLocations.clear();
            return self();
        }

        /**
         * Number of databases in this Cosmos MongoDB account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBDatabaseCount(final Long cosmosMongoDBDatabaseCount) {
            this.cosmosMongoDBDatabaseCount = cosmosMongoDBDatabaseCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBDatabase(final ICosmosMongoDBDatabase cosmosMongoDBDatabase) {
            if (this.cosmosMongoDBDatabases == null) this.cosmosMongoDBDatabases = new java.util.ArrayList<ICosmosMongoDBDatabase>();
            this.cosmosMongoDBDatabases.add(cosmosMongoDBDatabase);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBDatabases(final java.util.Collection<? extends ICosmosMongoDBDatabase> cosmosMongoDBDatabases) {
            if (cosmosMongoDBDatabases == null) {
                throw new java.lang.NullPointerException("cosmosMongoDBDatabases cannot be null");
            }
            if (this.cosmosMongoDBDatabases == null) this.cosmosMongoDBDatabases = new java.util.ArrayList<ICosmosMongoDBDatabase>();
            this.cosmosMongoDBDatabases.addAll(cosmosMongoDBDatabases);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCosmosMongoDBDatabases() {
            if (this.cosmosMongoDBDatabases != null) this.cosmosMongoDBDatabases.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Represents attributes for describing the key schema for the table and indexes.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B noSQLSchemaDefinition(final String noSQLSchemaDefinition) {
            this.noSQLSchemaDefinition = noSQLSchemaDefinition;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "CosmosMongoDBAccount.CosmosMongoDBAccountBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cosmosMongoDBAccountConsistencyPolicy=" + this.cosmosMongoDBAccountConsistencyPolicy + ", cosmosMongoDBAccountDocumentEndpoint=" + this.cosmosMongoDBAccountDocumentEndpoint + ", cosmosMongoDBAccountEnableAutomaticFailover=" + this.cosmosMongoDBAccountEnableAutomaticFailover + ", cosmosMongoDBAccountEnableMultipleWriteLocations=" + this.cosmosMongoDBAccountEnableMultipleWriteLocations + ", cosmosMongoDBAccountEnablePartitionKeyMonitor=" + this.cosmosMongoDBAccountEnablePartitionKeyMonitor + ", cosmosMongoDBAccountInstanceId=" + this.cosmosMongoDBAccountInstanceId + ", cosmosMongoDBAccountIsVirtualNetworkFilterEnabled=" + this.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled + ", cosmosMongoDBAccountLocations=" + this.cosmosMongoDBAccountLocations + ", cosmosMongoDBAccountMongoEndpoint=" + this.cosmosMongoDBAccountMongoEndpoint + ", cosmosMongoDBAccountPublicNetworkAccess=" + this.cosmosMongoDBAccountPublicNetworkAccess + ", cosmosMongoDBAccountReadLocations=" + this.cosmosMongoDBAccountReadLocations + ", cosmosMongoDBAccountResourceGroup=" + this.cosmosMongoDBAccountResourceGroup + ", cosmosMongoDBAccountSubscriptionId=" + this.cosmosMongoDBAccountSubscriptionId + ", cosmosMongoDBAccountType=" + this.cosmosMongoDBAccountType + ", cosmosMongoDBAccountWriteLocations=" + this.cosmosMongoDBAccountWriteLocations + ", cosmosMongoDBDatabaseCount=" + this.cosmosMongoDBDatabaseCount + ", cosmosMongoDBDatabases=" + this.cosmosMongoDBDatabases + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", noSQLSchemaDefinition=" + this.noSQLSchemaDefinition + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class CosmosMongoDBAccountBuilderImpl extends CosmosMongoDBAccount.CosmosMongoDBAccountBuilder<CosmosMongoDBAccount, CosmosMongoDBAccount.CosmosMongoDBAccountBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CosmosMongoDBAccountBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected CosmosMongoDBAccount.CosmosMongoDBAccountBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CosmosMongoDBAccount build() {
            return new CosmosMongoDBAccount(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected CosmosMongoDBAccount(final CosmosMongoDBAccount.CosmosMongoDBAccountBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = CosmosMongoDBAccount.$default$typeName();
        this.cosmosMongoDBAccountConsistencyPolicy = b.cosmosMongoDBAccountConsistencyPolicy;
        this.cosmosMongoDBAccountDocumentEndpoint = b.cosmosMongoDBAccountDocumentEndpoint;
        this.cosmosMongoDBAccountEnableAutomaticFailover = b.cosmosMongoDBAccountEnableAutomaticFailover;
        this.cosmosMongoDBAccountEnableMultipleWriteLocations = b.cosmosMongoDBAccountEnableMultipleWriteLocations;
        this.cosmosMongoDBAccountEnablePartitionKeyMonitor = b.cosmosMongoDBAccountEnablePartitionKeyMonitor;
        this.cosmosMongoDBAccountInstanceId = b.cosmosMongoDBAccountInstanceId;
        this.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled = b.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled;
        java.util.SortedSet<String> cosmosMongoDBAccountLocations = new java.util.TreeSet<String>();
        if (b.cosmosMongoDBAccountLocations != null) cosmosMongoDBAccountLocations.addAll(b.cosmosMongoDBAccountLocations);
        cosmosMongoDBAccountLocations = java.util.Collections.unmodifiableSortedSet(cosmosMongoDBAccountLocations);
        this.cosmosMongoDBAccountLocations = cosmosMongoDBAccountLocations;
        this.cosmosMongoDBAccountMongoEndpoint = b.cosmosMongoDBAccountMongoEndpoint;
        this.cosmosMongoDBAccountPublicNetworkAccess = b.cosmosMongoDBAccountPublicNetworkAccess;
        java.util.SortedSet<String> cosmosMongoDBAccountReadLocations = new java.util.TreeSet<String>();
        if (b.cosmosMongoDBAccountReadLocations != null) cosmosMongoDBAccountReadLocations.addAll(b.cosmosMongoDBAccountReadLocations);
        cosmosMongoDBAccountReadLocations = java.util.Collections.unmodifiableSortedSet(cosmosMongoDBAccountReadLocations);
        this.cosmosMongoDBAccountReadLocations = cosmosMongoDBAccountReadLocations;
        this.cosmosMongoDBAccountResourceGroup = b.cosmosMongoDBAccountResourceGroup;
        this.cosmosMongoDBAccountSubscriptionId = b.cosmosMongoDBAccountSubscriptionId;
        this.cosmosMongoDBAccountType = b.cosmosMongoDBAccountType;
        java.util.SortedSet<String> cosmosMongoDBAccountWriteLocations = new java.util.TreeSet<String>();
        if (b.cosmosMongoDBAccountWriteLocations != null) cosmosMongoDBAccountWriteLocations.addAll(b.cosmosMongoDBAccountWriteLocations);
        cosmosMongoDBAccountWriteLocations = java.util.Collections.unmodifiableSortedSet(cosmosMongoDBAccountWriteLocations);
        this.cosmosMongoDBAccountWriteLocations = cosmosMongoDBAccountWriteLocations;
        this.cosmosMongoDBDatabaseCount = b.cosmosMongoDBDatabaseCount;
        java.util.SortedSet<ICosmosMongoDBDatabase> cosmosMongoDBDatabases = new java.util.TreeSet<ICosmosMongoDBDatabase>();
        if (b.cosmosMongoDBDatabases != null) cosmosMongoDBDatabases.addAll(b.cosmosMongoDBDatabases);
        cosmosMongoDBDatabases = java.util.Collections.unmodifiableSortedSet(cosmosMongoDBDatabases);
        this.cosmosMongoDBDatabases = cosmosMongoDBDatabases;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.noSQLSchemaDefinition = b.noSQLSchemaDefinition;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static CosmosMongoDBAccount.CosmosMongoDBAccountBuilder<?, ?> _internal() {
        return new CosmosMongoDBAccount.CosmosMongoDBAccountBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CosmosMongoDBAccount.CosmosMongoDBAccountBuilder<?, ?> toBuilder() {
        return new CosmosMongoDBAccount.CosmosMongoDBAccountBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * The consistency policy configured for the Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCosmosMongoDBAccountConsistencyPolicy() {
        return this.cosmosMongoDBAccountConsistencyPolicy;
    }

    /**
     * The Document Endpoint URL for the Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCosmosMongoDBAccountDocumentEndpoint() {
        return this.cosmosMongoDBAccountDocumentEndpoint;
    }

    /**
     * Indicates whether automatic failover is enabled for the Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getCosmosMongoDBAccountEnableAutomaticFailover() {
        return this.cosmosMongoDBAccountEnableAutomaticFailover;
    }

    /**
     * Indicates whether multiple write locations are enabled for the Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getCosmosMongoDBAccountEnableMultipleWriteLocations() {
        return this.cosmosMongoDBAccountEnableMultipleWriteLocations;
    }

    /**
     * Indicates whether partition key monitoring is enabled for the Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getCosmosMongoDBAccountEnablePartitionKeyMonitor() {
        return this.cosmosMongoDBAccountEnablePartitionKeyMonitor;
    }

    /**
     * The unique identifier for the Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCosmosMongoDBAccountInstanceId() {
        return this.cosmosMongoDBAccountInstanceId;
    }

    /**
     * Indicates whether the virtual network filter is enabled for the Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getCosmosMongoDBAccountIsVirtualNetworkFilterEnabled() {
        return this.cosmosMongoDBAccountIsVirtualNetworkFilterEnabled;
    }

    /**
     * The locations where the Cosmos MongoDB account is available.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getCosmosMongoDBAccountLocations() {
        return this.cosmosMongoDBAccountLocations;
    }

    /**
     * The MongoDB connection endpoint for the Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCosmosMongoDBAccountMongoEndpoint() {
        return this.cosmosMongoDBAccountMongoEndpoint;
    }

    /**
     * The status of public network access for the Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCosmosMongoDBAccountPublicNetworkAccess() {
        return this.cosmosMongoDBAccountPublicNetworkAccess;
    }

    /**
     * The read locations configured for the Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getCosmosMongoDBAccountReadLocations() {
        return this.cosmosMongoDBAccountReadLocations;
    }

    /**
     * The resource group that contains the Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCosmosMongoDBAccountResourceGroup() {
        return this.cosmosMongoDBAccountResourceGroup;
    }

    /**
     * The ID of the subscription to which the Cosmos MongoDB account belongs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCosmosMongoDBAccountSubscriptionId() {
        return this.cosmosMongoDBAccountSubscriptionId;
    }

    /**
     * The type of the Cosmos MongoDB account, such as RU or VCORE.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCosmosMongoDBAccountType() {
        return this.cosmosMongoDBAccountType;
    }

    /**
     * The write locations configured for the Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getCosmosMongoDBAccountWriteLocations() {
        return this.cosmosMongoDBAccountWriteLocations;
    }

    /**
     * Number of databases in this Cosmos MongoDB account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCosmosMongoDBDatabaseCount() {
        return this.cosmosMongoDBDatabaseCount;
    }

    /**
     * Databases that exist within this account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICosmosMongoDBDatabase> getCosmosMongoDBDatabases() {
        return this.cosmosMongoDBDatabases;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Represents attributes for describing the key schema for the table and indexes.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNoSQLSchemaDefinition() {
        return this.noSQLSchemaDefinition;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CosmosMongoDBAccount)) return false;
        final CosmosMongoDBAccount other = (CosmosMongoDBAccount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$cosmosMongoDBAccountEnableAutomaticFailover = this.getCosmosMongoDBAccountEnableAutomaticFailover();
        final java.lang.Object other$cosmosMongoDBAccountEnableAutomaticFailover = other.getCosmosMongoDBAccountEnableAutomaticFailover();
        if (this$cosmosMongoDBAccountEnableAutomaticFailover == null ? other$cosmosMongoDBAccountEnableAutomaticFailover != null : !this$cosmosMongoDBAccountEnableAutomaticFailover.equals(other$cosmosMongoDBAccountEnableAutomaticFailover)) return false;
        final java.lang.Object this$cosmosMongoDBAccountEnableMultipleWriteLocations = this.getCosmosMongoDBAccountEnableMultipleWriteLocations();
        final java.lang.Object other$cosmosMongoDBAccountEnableMultipleWriteLocations = other.getCosmosMongoDBAccountEnableMultipleWriteLocations();
        if (this$cosmosMongoDBAccountEnableMultipleWriteLocations == null ? other$cosmosMongoDBAccountEnableMultipleWriteLocations != null : !this$cosmosMongoDBAccountEnableMultipleWriteLocations.equals(other$cosmosMongoDBAccountEnableMultipleWriteLocations)) return false;
        final java.lang.Object this$cosmosMongoDBAccountEnablePartitionKeyMonitor = this.getCosmosMongoDBAccountEnablePartitionKeyMonitor();
        final java.lang.Object other$cosmosMongoDBAccountEnablePartitionKeyMonitor = other.getCosmosMongoDBAccountEnablePartitionKeyMonitor();
        if (this$cosmosMongoDBAccountEnablePartitionKeyMonitor == null ? other$cosmosMongoDBAccountEnablePartitionKeyMonitor != null : !this$cosmosMongoDBAccountEnablePartitionKeyMonitor.equals(other$cosmosMongoDBAccountEnablePartitionKeyMonitor)) return false;
        final java.lang.Object this$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled = this.getCosmosMongoDBAccountIsVirtualNetworkFilterEnabled();
        final java.lang.Object other$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled = other.getCosmosMongoDBAccountIsVirtualNetworkFilterEnabled();
        if (this$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled == null ? other$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled != null : !this$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled.equals(other$cosmosMongoDBAccountIsVirtualNetworkFilterEnabled)) return false;
        final java.lang.Object this$cosmosMongoDBDatabaseCount = this.getCosmosMongoDBDatabaseCount();
        final java.lang.Object other$cosmosMongoDBDatabaseCount = other.getCosmosMongoDBDatabaseCount();
        if (this$cosmosMongoDBDatabaseCount == null ? other$cosmosMongoDBDatabaseCount != null : !this$cosmosMongoDBDatabaseCount.equals(other$cosmosMongoDBDatabaseCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$cosmosMongoDBAccountConsistencyPolicy = this.getCosmosMongoDBAccountConsistencyPolicy();
        final java.lang.Object other$cosmosMongoDBAccountConsistencyPolicy = other.getCosmosMongoDBAccountConsistencyPolicy();
        if (this$cosmosMongoDBAccountConsistencyPolicy == null ? other$cosmosMongoDBAccountConsistencyPolicy != null : !this$cosmosMongoDBAccountConsistencyPolicy.equals(other$cosmosMongoDBAccountConsistencyPolicy)) return false;
        final java.lang.Object this$cosmosMongoDBAccountDocumentEndpoint = this.getCosmosMongoDBAccountDocumentEndpoint();
        final java.lang.Object other$cosmosMongoDBAccountDocumentEndpoint = other.getCosmosMongoDBAccountDocumentEndpoint();
        if (this$cosmosMongoDBAccountDocumentEndpoint == null ? other$cosmosMongoDBAccountDocumentEndpoint != null : !this$cosmosMongoDBAccountDocumentEndpoint.equals(other$cosmosMongoDBAccountDocumentEndpoint)) return false;
        final java.lang.Object this$cosmosMongoDBAccountInstanceId = this.getCosmosMongoDBAccountInstanceId();
        final java.lang.Object other$cosmosMongoDBAccountInstanceId = other.getCosmosMongoDBAccountInstanceId();
        if (this$cosmosMongoDBAccountInstanceId == null ? other$cosmosMongoDBAccountInstanceId != null : !this$cosmosMongoDBAccountInstanceId.equals(other$cosmosMongoDBAccountInstanceId)) return false;
        final java.lang.Object this$cosmosMongoDBAccountLocations = this.getCosmosMongoDBAccountLocations();
        final java.lang.Object other$cosmosMongoDBAccountLocations = other.getCosmosMongoDBAccountLocations();
        if (this$cosmosMongoDBAccountLocations == null ? other$cosmosMongoDBAccountLocations != null : !this$cosmosMongoDBAccountLocations.equals(other$cosmosMongoDBAccountLocations)) return false;
        final java.lang.Object this$cosmosMongoDBAccountMongoEndpoint = this.getCosmosMongoDBAccountMongoEndpoint();
        final java.lang.Object other$cosmosMongoDBAccountMongoEndpoint = other.getCosmosMongoDBAccountMongoEndpoint();
        if (this$cosmosMongoDBAccountMongoEndpoint == null ? other$cosmosMongoDBAccountMongoEndpoint != null : !this$cosmosMongoDBAccountMongoEndpoint.equals(other$cosmosMongoDBAccountMongoEndpoint)) return false;
        final java.lang.Object this$cosmosMongoDBAccountPublicNetworkAccess = this.getCosmosMongoDBAccountPublicNetworkAccess();
        final java.lang.Object other$cosmosMongoDBAccountPublicNetworkAccess = other.getCosmosMongoDBAccountPublicNetworkAccess();
        if (this$cosmosMongoDBAccountPublicNetworkAccess == null ? other$cosmosMongoDBAccountPublicNetworkAccess != null : !this$cosmosMongoDBAccountPublicNetworkAccess.equals(other$cosmosMongoDBAccountPublicNetworkAccess)) return false;
        final java.lang.Object this$cosmosMongoDBAccountReadLocations = this.getCosmosMongoDBAccountReadLocations();
        final java.lang.Object other$cosmosMongoDBAccountReadLocations = other.getCosmosMongoDBAccountReadLocations();
        if (this$cosmosMongoDBAccountReadLocations == null ? other$cosmosMongoDBAccountReadLocations != null : !this$cosmosMongoDBAccountReadLocations.equals(other$cosmosMongoDBAccountReadLocations)) return false;
        final java.lang.Object this$cosmosMongoDBAccountResourceGroup = this.getCosmosMongoDBAccountResourceGroup();
        final java.lang.Object other$cosmosMongoDBAccountResourceGroup = other.getCosmosMongoDBAccountResourceGroup();
        if (this$cosmosMongoDBAccountResourceGroup == null ? other$cosmosMongoDBAccountResourceGroup != null : !this$cosmosMongoDBAccountResourceGroup.equals(other$cosmosMongoDBAccountResourceGroup)) return false;
        final java.lang.Object this$cosmosMongoDBAccountSubscriptionId = this.getCosmosMongoDBAccountSubscriptionId();
        final java.lang.Object other$cosmosMongoDBAccountSubscriptionId = other.getCosmosMongoDBAccountSubscriptionId();
        if (this$cosmosMongoDBAccountSubscriptionId == null ? other$cosmosMongoDBAccountSubscriptionId != null : !this$cosmosMongoDBAccountSubscriptionId.equals(other$cosmosMongoDBAccountSubscriptionId)) return false;
        final java.lang.Object this$cosmosMongoDBAccountType = this.getCosmosMongoDBAccountType();
        final java.lang.Object other$cosmosMongoDBAccountType = other.getCosmosMongoDBAccountType();
        if (this$cosmosMongoDBAccountType == null ? other$cosmosMongoDBAccountType != null : !this$cosmosMongoDBAccountType.equals(other$cosmosMongoDBAccountType)) return false;
        final java.lang.Object this$cosmosMongoDBAccountWriteLocations = this.getCosmosMongoDBAccountWriteLocations();
        final java.lang.Object other$cosmosMongoDBAccountWriteLocations = other.getCosmosMongoDBAccountWriteLocations();
        if (this$cosmosMongoDBAccountWriteLocations == null ? other$cosmosMongoDBAccountWriteLocations != null : !this$cosmosMongoDBAccountWriteLocations.equals(other$cosmosMongoDBAccountWriteLocations)) return false;
        final java.lang.Object this$cosmosMongoDBDatabases = this.getCosmosMongoDBDatabases();
        final java.lang.Object other$cosmosMongoDBDatabases = other.getCosmosMongoDBDatabases();
        if (this$cosmosMongoDBDatabases == null ? other$cosmosMongoDBDatabases != null : !this$cosmosMongoDBDatabases.equals(other$cosmosMongoDBDatabases)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        final java.lang.Object other$noSQLSchemaDefinition = other.getNoSQLSchemaDefinition();
        if (this$noSQLSchemaDefinition == null ? other$noSQLSchemaDefinition != null : !this$noSQLSchemaDefinition.equals(other$noSQLSchemaDefinition)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CosmosMongoDBAccount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $cosmosMongoDBAccountEnableAutomaticFailover = this.getCosmosMongoDBAccountEnableAutomaticFailover();
        result = result * PRIME + ($cosmosMongoDBAccountEnableAutomaticFailover == null ? 43 : $cosmosMongoDBAccountEnableAutomaticFailover.hashCode());
        final java.lang.Object $cosmosMongoDBAccountEnableMultipleWriteLocations = this.getCosmosMongoDBAccountEnableMultipleWriteLocations();
        result = result * PRIME + ($cosmosMongoDBAccountEnableMultipleWriteLocations == null ? 43 : $cosmosMongoDBAccountEnableMultipleWriteLocations.hashCode());
        final java.lang.Object $cosmosMongoDBAccountEnablePartitionKeyMonitor = this.getCosmosMongoDBAccountEnablePartitionKeyMonitor();
        result = result * PRIME + ($cosmosMongoDBAccountEnablePartitionKeyMonitor == null ? 43 : $cosmosMongoDBAccountEnablePartitionKeyMonitor.hashCode());
        final java.lang.Object $cosmosMongoDBAccountIsVirtualNetworkFilterEnabled = this.getCosmosMongoDBAccountIsVirtualNetworkFilterEnabled();
        result = result * PRIME + ($cosmosMongoDBAccountIsVirtualNetworkFilterEnabled == null ? 43 : $cosmosMongoDBAccountIsVirtualNetworkFilterEnabled.hashCode());
        final java.lang.Object $cosmosMongoDBDatabaseCount = this.getCosmosMongoDBDatabaseCount();
        result = result * PRIME + ($cosmosMongoDBDatabaseCount == null ? 43 : $cosmosMongoDBDatabaseCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $cosmosMongoDBAccountConsistencyPolicy = this.getCosmosMongoDBAccountConsistencyPolicy();
        result = result * PRIME + ($cosmosMongoDBAccountConsistencyPolicy == null ? 43 : $cosmosMongoDBAccountConsistencyPolicy.hashCode());
        final java.lang.Object $cosmosMongoDBAccountDocumentEndpoint = this.getCosmosMongoDBAccountDocumentEndpoint();
        result = result * PRIME + ($cosmosMongoDBAccountDocumentEndpoint == null ? 43 : $cosmosMongoDBAccountDocumentEndpoint.hashCode());
        final java.lang.Object $cosmosMongoDBAccountInstanceId = this.getCosmosMongoDBAccountInstanceId();
        result = result * PRIME + ($cosmosMongoDBAccountInstanceId == null ? 43 : $cosmosMongoDBAccountInstanceId.hashCode());
        final java.lang.Object $cosmosMongoDBAccountLocations = this.getCosmosMongoDBAccountLocations();
        result = result * PRIME + ($cosmosMongoDBAccountLocations == null ? 43 : $cosmosMongoDBAccountLocations.hashCode());
        final java.lang.Object $cosmosMongoDBAccountMongoEndpoint = this.getCosmosMongoDBAccountMongoEndpoint();
        result = result * PRIME + ($cosmosMongoDBAccountMongoEndpoint == null ? 43 : $cosmosMongoDBAccountMongoEndpoint.hashCode());
        final java.lang.Object $cosmosMongoDBAccountPublicNetworkAccess = this.getCosmosMongoDBAccountPublicNetworkAccess();
        result = result * PRIME + ($cosmosMongoDBAccountPublicNetworkAccess == null ? 43 : $cosmosMongoDBAccountPublicNetworkAccess.hashCode());
        final java.lang.Object $cosmosMongoDBAccountReadLocations = this.getCosmosMongoDBAccountReadLocations();
        result = result * PRIME + ($cosmosMongoDBAccountReadLocations == null ? 43 : $cosmosMongoDBAccountReadLocations.hashCode());
        final java.lang.Object $cosmosMongoDBAccountResourceGroup = this.getCosmosMongoDBAccountResourceGroup();
        result = result * PRIME + ($cosmosMongoDBAccountResourceGroup == null ? 43 : $cosmosMongoDBAccountResourceGroup.hashCode());
        final java.lang.Object $cosmosMongoDBAccountSubscriptionId = this.getCosmosMongoDBAccountSubscriptionId();
        result = result * PRIME + ($cosmosMongoDBAccountSubscriptionId == null ? 43 : $cosmosMongoDBAccountSubscriptionId.hashCode());
        final java.lang.Object $cosmosMongoDBAccountType = this.getCosmosMongoDBAccountType();
        result = result * PRIME + ($cosmosMongoDBAccountType == null ? 43 : $cosmosMongoDBAccountType.hashCode());
        final java.lang.Object $cosmosMongoDBAccountWriteLocations = this.getCosmosMongoDBAccountWriteLocations();
        result = result * PRIME + ($cosmosMongoDBAccountWriteLocations == null ? 43 : $cosmosMongoDBAccountWriteLocations.hashCode());
        final java.lang.Object $cosmosMongoDBDatabases = this.getCosmosMongoDBDatabases();
        result = result * PRIME + ($cosmosMongoDBDatabases == null ? 43 : $cosmosMongoDBDatabases.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        result = result * PRIME + ($noSQLSchemaDefinition == null ? 43 : $noSQLSchemaDefinition.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "CosmosMongoDBAccount(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cosmosMongoDBAccountConsistencyPolicy=" + this.getCosmosMongoDBAccountConsistencyPolicy() + ", cosmosMongoDBAccountDocumentEndpoint=" + this.getCosmosMongoDBAccountDocumentEndpoint() + ", cosmosMongoDBAccountEnableAutomaticFailover=" + this.getCosmosMongoDBAccountEnableAutomaticFailover() + ", cosmosMongoDBAccountEnableMultipleWriteLocations=" + this.getCosmosMongoDBAccountEnableMultipleWriteLocations() + ", cosmosMongoDBAccountEnablePartitionKeyMonitor=" + this.getCosmosMongoDBAccountEnablePartitionKeyMonitor() + ", cosmosMongoDBAccountInstanceId=" + this.getCosmosMongoDBAccountInstanceId() + ", cosmosMongoDBAccountIsVirtualNetworkFilterEnabled=" + this.getCosmosMongoDBAccountIsVirtualNetworkFilterEnabled() + ", cosmosMongoDBAccountLocations=" + this.getCosmosMongoDBAccountLocations() + ", cosmosMongoDBAccountMongoEndpoint=" + this.getCosmosMongoDBAccountMongoEndpoint() + ", cosmosMongoDBAccountPublicNetworkAccess=" + this.getCosmosMongoDBAccountPublicNetworkAccess() + ", cosmosMongoDBAccountReadLocations=" + this.getCosmosMongoDBAccountReadLocations() + ", cosmosMongoDBAccountResourceGroup=" + this.getCosmosMongoDBAccountResourceGroup() + ", cosmosMongoDBAccountSubscriptionId=" + this.getCosmosMongoDBAccountSubscriptionId() + ", cosmosMongoDBAccountType=" + this.getCosmosMongoDBAccountType() + ", cosmosMongoDBAccountWriteLocations=" + this.getCosmosMongoDBAccountWriteLocations() + ", cosmosMongoDBDatabaseCount=" + this.getCosmosMongoDBDatabaseCount() + ", cosmosMongoDBDatabases=" + this.getCosmosMongoDBDatabases() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", noSQLSchemaDefinition=" + this.getNoSQLSchemaDefinition() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for CosmosMongoDBAccounts.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
