// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Cosmos MongoDB database in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class CosmosMongoDBDatabase extends Asset implements ICosmosMongoDBDatabase, ICosmosMongoDB, IMongoDBDatabase, INoSQL, ICatalog, IAsset, IReferenceable, IDatabase, IMongoDB, ISQL {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CosmosMongoDBDatabase.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CosmosMongoDBDatabase";
    /**
     * Fixed typeName for CosmosMongoDBDatabases.
     */
    String typeName;
    /**
     * Simple name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @Attribute
    String calculationViewName;
    /**
     * Unique name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @Attribute
    String calculationViewQualifiedName;
    /**
     * Account in which the database exists.
     */
    @Attribute
    ICosmosMongoDBAccount cosmosMongoDBAccount;
    /**
     * Unique name of the account in which this database exists.
     */
    @Attribute
    String cosmosMongoDBAccountQualifiedName;
    /**
     * Collections that exist within this database.
     */
    @Attribute
    SortedSet<ICosmosMongoDBCollection> cosmosMongoDBCollections;
    /**
     * Simple name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @Attribute
    String databaseName;
    /**
     * Unique name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @Attribute
    String databaseQualifiedName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Whether this asset has been profiled (true) or not (false).
     */
    @Attribute
    Boolean isProfiled;
    /**
     * Time (epoch) at which this asset was last profiled, in milliseconds.
     */
    @Attribute
    @Date
    Long lastProfiledAt;
    /**
     * Collections that exist within this database.
     */
    @Attribute
    SortedSet<IMongoDBCollection> mongoDBCollections;
    /**
     * Number of collections in the database.
     */
    @Attribute
    Integer mongoDBDatabaseCollectionCount;
    /**
     * Represents attributes for describing the key schema for the table and indexes.
     */
    @Attribute
    String noSQLSchemaDefinition;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Number of times this asset has been queried.
     */
    @Attribute
    Long queryCount;
    /**
     * Time (epoch) at which the query count was last updated, in milliseconds.
     */
    @Attribute
    @Date
    Long queryCountUpdatedAt;
    /**
     * Number of unique users who have queried this asset.
     */
    @Attribute
    Long queryUserCount;
    /**
     * Map of unique users who have queried this asset to the number of times they have queried it.
     */
    @Attribute
    Map<String, Long> queryUserMap;
    /**
     * Number of schemas in this database.
     */
    @Attribute
    Integer schemaCount;
    /**
     * Simple name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @Attribute
    String schemaName;
    /**
     * Unique name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @Attribute
    String schemaQualifiedName;
    /**
     * Schemas that exist within this database.
     */
    @Attribute
    SortedSet<ISchema> schemas;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    /**
     * Simple name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @Attribute
    String tableName;
    /**
     * Unique name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @Attribute
    String tableQualifiedName;
    /**
     * Simple name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @Attribute
    String viewName;
    /**
     * Unique name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @Attribute
    String viewQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a CosmosMongoDBDatabase, from a potentially
     * more-complete CosmosMongoDBDatabase object.
     *
     * @return the minimal object necessary to relate to the CosmosMongoDBDatabase
     * @throws InvalidRequestException if any of the minimal set of required properties for a CosmosMongoDBDatabase relationship are not found in the initial object
     */
    @Override
    public CosmosMongoDBDatabase trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all CosmosMongoDBDatabase assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) CosmosMongoDBDatabase assets will be included.
     *
     * @return a fluent search that includes all CosmosMongoDBDatabase assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all CosmosMongoDBDatabase assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) CosmosMongoDBDatabase assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all CosmosMongoDBDatabase assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all CosmosMongoDBDatabase assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) CosmosMongoDBDatabases will be included
     * @return a fluent search that includes all CosmosMongoDBDatabase assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all CosmosMongoDBDatabase assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) CosmosMongoDBDatabases will be included
     * @return a fluent search that includes all CosmosMongoDBDatabase assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a CosmosMongoDBDatabase by GUID. Use this to create a relationship to this CosmosMongoDBDatabase,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the CosmosMongoDBDatabase to reference
     * @return reference to a CosmosMongoDBDatabase that can be used for defining a relationship to a CosmosMongoDBDatabase
     */
    public static CosmosMongoDBDatabase refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a CosmosMongoDBDatabase by GUID. Use this to create a relationship to this CosmosMongoDBDatabase,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the CosmosMongoDBDatabase to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a CosmosMongoDBDatabase that can be used for defining a relationship to a CosmosMongoDBDatabase
     */
    public static CosmosMongoDBDatabase refByGuid(String guid, Reference.SaveSemantic semantic) {
        return CosmosMongoDBDatabase._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a CosmosMongoDBDatabase by qualifiedName. Use this to create a relationship to this CosmosMongoDBDatabase,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the CosmosMongoDBDatabase to reference
     * @return reference to a CosmosMongoDBDatabase that can be used for defining a relationship to a CosmosMongoDBDatabase
     */
    public static CosmosMongoDBDatabase refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a CosmosMongoDBDatabase by qualifiedName. Use this to create a relationship to this CosmosMongoDBDatabase,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the CosmosMongoDBDatabase to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a CosmosMongoDBDatabase that can be used for defining a relationship to a CosmosMongoDBDatabase
     */
    public static CosmosMongoDBDatabase refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return CosmosMongoDBDatabase._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a CosmosMongoDBDatabase by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the CosmosMongoDBDatabase to retrieve, either its GUID or its full qualifiedName
     * @return the requested full CosmosMongoDBDatabase, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CosmosMongoDBDatabase does not exist or the provided GUID is not a CosmosMongoDBDatabase
     */
    @JsonIgnore
    public static CosmosMongoDBDatabase get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a CosmosMongoDBDatabase by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the CosmosMongoDBDatabase to retrieve, either its GUID or its full qualifiedName
     * @return the requested full CosmosMongoDBDatabase, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CosmosMongoDBDatabase does not exist or the provided GUID is not a CosmosMongoDBDatabase
     */
    @JsonIgnore
    public static CosmosMongoDBDatabase get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a CosmosMongoDBDatabase by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the CosmosMongoDBDatabase to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full CosmosMongoDBDatabase, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CosmosMongoDBDatabase does not exist or the provided GUID is not a CosmosMongoDBDatabase
     */
    @JsonIgnore
    public static CosmosMongoDBDatabase get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof CosmosMongoDBDatabase) {
                return (CosmosMongoDBDatabase) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof CosmosMongoDBDatabase) {
                return (CosmosMongoDBDatabase) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) CosmosMongoDBDatabase to active.
     *
     * @param qualifiedName for the CosmosMongoDBDatabase
     * @return true if the CosmosMongoDBDatabase is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) CosmosMongoDBDatabase to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the CosmosMongoDBDatabase
     * @return true if the CosmosMongoDBDatabase is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a CosmosMongoDBDatabase.
     *
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param name of the CosmosMongoDBDatabase
     * @return the minimal request necessary to update the CosmosMongoDBDatabase, as a builder
     */
    public static CosmosMongoDBDatabaseBuilder<?, ?> updater(String qualifiedName, String name) {
        return CosmosMongoDBDatabase._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a CosmosMongoDBDatabase, from a potentially
     * more-complete CosmosMongoDBDatabase object.
     *
     * @return the minimal object necessary to update the CosmosMongoDBDatabase, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for CosmosMongoDBDatabase are not found in the initial object
     */
    @Override
    public CosmosMongoDBDatabaseBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a CosmosMongoDBDatabase.
     *
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param name of the CosmosMongoDBDatabase
     * @return the updated CosmosMongoDBDatabase, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a CosmosMongoDBDatabase.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param name of the CosmosMongoDBDatabase
     * @return the updated CosmosMongoDBDatabase, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBDatabase) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a CosmosMongoDBDatabase.
     *
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param name of the CosmosMongoDBDatabase
     * @return the updated CosmosMongoDBDatabase, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a CosmosMongoDBDatabase.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param name of the CosmosMongoDBDatabase
     * @return the updated CosmosMongoDBDatabase, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBDatabase) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a CosmosMongoDBDatabase.
     *
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param name of the CosmosMongoDBDatabase
     * @return the updated CosmosMongoDBDatabase, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a CosmosMongoDBDatabase.
     *
     * @param client connectivity to the Atlan tenant from which to remove the CosmosMongoDBDatabase's owners
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param name of the CosmosMongoDBDatabase
     * @return the updated CosmosMongoDBDatabase, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBDatabase) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a CosmosMongoDBDatabase.
     *
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated CosmosMongoDBDatabase, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a CosmosMongoDBDatabase.
     *
     * @param client connectivity to the Atlan tenant on which to update the CosmosMongoDBDatabase's certificate
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated CosmosMongoDBDatabase, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CosmosMongoDBDatabase) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a CosmosMongoDBDatabase.
     *
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param name of the CosmosMongoDBDatabase
     * @return the updated CosmosMongoDBDatabase, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a CosmosMongoDBDatabase.
     *
     * @param client connectivity to the Atlan tenant from which to remove the CosmosMongoDBDatabase's certificate
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param name of the CosmosMongoDBDatabase
     * @return the updated CosmosMongoDBDatabase, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBDatabase) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a CosmosMongoDBDatabase.
     *
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a CosmosMongoDBDatabase.
     *
     * @param client connectivity to the Atlan tenant on which to update the CosmosMongoDBDatabase's announcement
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CosmosMongoDBDatabase) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a CosmosMongoDBDatabase.
     *
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param name of the CosmosMongoDBDatabase
     * @return the updated CosmosMongoDBDatabase, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a CosmosMongoDBDatabase.
     *
     * @param client connectivity to the Atlan client from which to remove the CosmosMongoDBDatabase's announcement
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param name of the CosmosMongoDBDatabase
     * @return the updated CosmosMongoDBDatabase, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CosmosMongoDBDatabase) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the CosmosMongoDBDatabase.
     *
     * @param qualifiedName for the CosmosMongoDBDatabase
     * @param name human-readable name of the CosmosMongoDBDatabase
     * @param terms the list of terms to replace on the CosmosMongoDBDatabase, or null to remove all terms from the CosmosMongoDBDatabase
     * @return the CosmosMongoDBDatabase that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the CosmosMongoDBDatabase.
     *
     * @param client connectivity to the Atlan tenant on which to replace the CosmosMongoDBDatabase's assigned terms
     * @param qualifiedName for the CosmosMongoDBDatabase
     * @param name human-readable name of the CosmosMongoDBDatabase
     * @param terms the list of terms to replace on the CosmosMongoDBDatabase, or null to remove all terms from the CosmosMongoDBDatabase
     * @return the CosmosMongoDBDatabase that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CosmosMongoDBDatabase) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the CosmosMongoDBDatabase, without replacing existing terms linked to the CosmosMongoDBDatabase.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBDatabase's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the CosmosMongoDBDatabase
     * @param terms the list of terms to append to the CosmosMongoDBDatabase
     * @return the CosmosMongoDBDatabase that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the CosmosMongoDBDatabase, without replacing existing terms linked to the CosmosMongoDBDatabase.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBDatabase's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the CosmosMongoDBDatabase
     * @param qualifiedName for the CosmosMongoDBDatabase
     * @param terms the list of terms to append to the CosmosMongoDBDatabase
     * @return the CosmosMongoDBDatabase that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CosmosMongoDBDatabase) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a CosmosMongoDBDatabase, without replacing all existing terms linked to the CosmosMongoDBDatabase.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBDatabase's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the CosmosMongoDBDatabase
     * @param terms the list of terms to remove from the CosmosMongoDBDatabase, which must be referenced by GUID
     * @return the CosmosMongoDBDatabase that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a CosmosMongoDBDatabase, without replacing all existing terms linked to the CosmosMongoDBDatabase.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBDatabase's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the CosmosMongoDBDatabase
     * @param qualifiedName for the CosmosMongoDBDatabase
     * @param terms the list of terms to remove from the CosmosMongoDBDatabase, which must be referenced by GUID
     * @return the CosmosMongoDBDatabase that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static CosmosMongoDBDatabase removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CosmosMongoDBDatabase) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a CosmosMongoDBDatabase, without replacing existing Atlan tags linked to the CosmosMongoDBDatabase.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBDatabase's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated CosmosMongoDBDatabase
     */
    public static CosmosMongoDBDatabase appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a CosmosMongoDBDatabase, without replacing existing Atlan tags linked to the CosmosMongoDBDatabase.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBDatabase's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the CosmosMongoDBDatabase
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated CosmosMongoDBDatabase
     */
    public static CosmosMongoDBDatabase appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CosmosMongoDBDatabase) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a CosmosMongoDBDatabase, without replacing existing Atlan tags linked to the CosmosMongoDBDatabase.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBDatabase's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated CosmosMongoDBDatabase
     */
    public static CosmosMongoDBDatabase appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a CosmosMongoDBDatabase, without replacing existing Atlan tags linked to the CosmosMongoDBDatabase.
     * Note: this operation must make two API calls — one to retrieve the CosmosMongoDBDatabase's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the CosmosMongoDBDatabase
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated CosmosMongoDBDatabase
     */
    public static CosmosMongoDBDatabase appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CosmosMongoDBDatabase) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a CosmosMongoDBDatabase.
     *
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the CosmosMongoDBDatabase
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a CosmosMongoDBDatabase.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a CosmosMongoDBDatabase
     * @param qualifiedName of the CosmosMongoDBDatabase
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the CosmosMongoDBDatabase
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class CosmosMongoDBDatabaseBuilder<C extends CosmosMongoDBDatabase, B extends CosmosMongoDBDatabase.CosmosMongoDBDatabaseBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String calculationViewName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String calculationViewQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ICosmosMongoDBAccount cosmosMongoDBAccount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cosmosMongoDBAccountQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICosmosMongoDBCollection> cosmosMongoDBCollections;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String databaseName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String databaseQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModel> dbtModels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtSource> dbtSources;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtTest> dbtTests;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isProfiled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long lastProfiledAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMongoDBCollection> mongoDBCollections;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer mongoDBDatabaseCollectionCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String noSQLSchemaDefinition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryCountUpdatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryUserCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> queryUserMap$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Long> queryUserMap$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer schemaCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISchema> schemas;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtSource> sqlDBTSources;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModel> sqlDbtModels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String viewName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String viewQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            CosmosMongoDBDatabase.CosmosMongoDBDatabaseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final CosmosMongoDBDatabase instance, final CosmosMongoDBDatabase.CosmosMongoDBDatabaseBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.calculationViewName(instance.calculationViewName);
            b.calculationViewQualifiedName(instance.calculationViewQualifiedName);
            b.cosmosMongoDBAccount(instance.cosmosMongoDBAccount);
            b.cosmosMongoDBAccountQualifiedName(instance.cosmosMongoDBAccountQualifiedName);
            b.cosmosMongoDBCollections(instance.cosmosMongoDBCollections == null ? java.util.Collections.<ICosmosMongoDBCollection>emptySortedSet() : instance.cosmosMongoDBCollections);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtModels(instance.dbtModels == null ? java.util.Collections.<IDbtModel>emptySortedSet() : instance.dbtModels);
            b.dbtSources(instance.dbtSources == null ? java.util.Collections.<IDbtSource>emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? java.util.Collections.<IDbtTest>emptySortedSet() : instance.dbtTests);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.isProfiled(instance.isProfiled);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.mongoDBCollections(instance.mongoDBCollections == null ? java.util.Collections.<IMongoDBCollection>emptySortedSet() : instance.mongoDBCollections);
            b.mongoDBDatabaseCollectionCount(instance.mongoDBDatabaseCollectionCount);
            b.noSQLSchemaDefinition(instance.noSQLSchemaDefinition);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? java.util.Collections.<String, Long>emptyMap() : instance.queryUserMap);
            b.schemaCount(instance.schemaCount);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.schemas(instance.schemas == null ? java.util.Collections.<ISchema>emptySortedSet() : instance.schemas);
            b.sqlDBTSources(instance.sqlDBTSources == null ? java.util.Collections.<IDbtSource>emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? java.util.Collections.<IDbtModel>emptySortedSet() : instance.sqlDbtModels);
            b.tableName(instance.tableName);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
        }

        /**
         * Fixed typeName for CosmosMongoDBDatabases.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Simple name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationViewName(final String calculationViewName) {
            this.calculationViewName = calculationViewName;
            return self();
        }

        /**
         * Unique name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationViewQualifiedName(final String calculationViewQualifiedName) {
            this.calculationViewQualifiedName = calculationViewQualifiedName;
            return self();
        }

        /**
         * Account in which the database exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccount(final ICosmosMongoDBAccount cosmosMongoDBAccount) {
            this.cosmosMongoDBAccount = cosmosMongoDBAccount;
            return self();
        }

        /**
         * Unique name of the account in which this database exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBAccountQualifiedName(final String cosmosMongoDBAccountQualifiedName) {
            this.cosmosMongoDBAccountQualifiedName = cosmosMongoDBAccountQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBCollection(final ICosmosMongoDBCollection cosmosMongoDBCollection) {
            if (this.cosmosMongoDBCollections == null) this.cosmosMongoDBCollections = new java.util.ArrayList<ICosmosMongoDBCollection>();
            this.cosmosMongoDBCollections.add(cosmosMongoDBCollection);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cosmosMongoDBCollections(final java.util.Collection<? extends ICosmosMongoDBCollection> cosmosMongoDBCollections) {
            if (cosmosMongoDBCollections == null) {
                throw new java.lang.NullPointerException("cosmosMongoDBCollections cannot be null");
            }
            if (this.cosmosMongoDBCollections == null) this.cosmosMongoDBCollections = new java.util.ArrayList<ICosmosMongoDBCollection>();
            this.cosmosMongoDBCollections.addAll(cosmosMongoDBCollections);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCosmosMongoDBCollections() {
            if (this.cosmosMongoDBCollections != null) this.cosmosMongoDBCollections.clear();
            return self();
        }

        /**
         * Simple name of the database in which this SQL asset exists, or empty if it does not exist within a database.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B databaseName(final String databaseName) {
            this.databaseName = databaseName;
            return self();
        }

        /**
         * Unique name of the database in which this SQL asset exists, or empty if it does not exist within a database.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B databaseQualifiedName(final String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModel(final IDbtModel dbtModel) {
            if (this.dbtModels == null) this.dbtModels = new java.util.ArrayList<IDbtModel>();
            this.dbtModels.add(dbtModel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModels(final java.util.Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new java.lang.NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) this.dbtModels = new java.util.ArrayList<IDbtModel>();
            this.dbtModels.addAll(dbtModels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) this.dbtModels.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtSource(final IDbtSource dbtSource) {
            if (this.dbtSources == null) this.dbtSources = new java.util.ArrayList<IDbtSource>();
            this.dbtSources.add(dbtSource);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtSources(final java.util.Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new java.lang.NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) this.dbtSources = new java.util.ArrayList<IDbtSource>();
            this.dbtSources.addAll(dbtSources);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) this.dbtSources.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTest(final IDbtTest dbtTest) {
            if (this.dbtTests == null) this.dbtTests = new java.util.ArrayList<IDbtTest>();
            this.dbtTests.add(dbtTest);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTests(final java.util.Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new java.lang.NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) this.dbtTests = new java.util.ArrayList<IDbtTest>();
            this.dbtTests.addAll(dbtTests);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) this.dbtTests.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Whether this asset has been profiled (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isProfiled(final Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return self();
        }

        /**
         * Time (epoch) at which this asset was last profiled, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lastProfiledAt(final Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mongoDBCollection(final IMongoDBCollection mongoDBCollection) {
            if (this.mongoDBCollections == null) this.mongoDBCollections = new java.util.ArrayList<IMongoDBCollection>();
            this.mongoDBCollections.add(mongoDBCollection);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mongoDBCollections(final java.util.Collection<? extends IMongoDBCollection> mongoDBCollections) {
            if (mongoDBCollections == null) {
                throw new java.lang.NullPointerException("mongoDBCollections cannot be null");
            }
            if (this.mongoDBCollections == null) this.mongoDBCollections = new java.util.ArrayList<IMongoDBCollection>();
            this.mongoDBCollections.addAll(mongoDBCollections);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMongoDBCollections() {
            if (this.mongoDBCollections != null) this.mongoDBCollections.clear();
            return self();
        }

        /**
         * Number of collections in the database.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mongoDBDatabaseCollectionCount(final Integer mongoDBDatabaseCollectionCount) {
            this.mongoDBDatabaseCollectionCount = mongoDBDatabaseCollectionCount;
            return self();
        }

        /**
         * Represents attributes for describing the key schema for the table and indexes.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B noSQLSchemaDefinition(final String noSQLSchemaDefinition) {
            this.noSQLSchemaDefinition = noSQLSchemaDefinition;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Number of times this asset has been queried.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryCount(final Long queryCount) {
            this.queryCount = queryCount;
            return self();
        }

        /**
         * Time (epoch) at which the query count was last updated, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryCountUpdatedAt(final Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return self();
        }

        /**
         * Number of unique users who have queried this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryUserCount(final Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putQueryUserMap(final String putQueryUserMapKey, final Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new java.util.ArrayList<String>();
                this.queryUserMap$value = new java.util.ArrayList<Long>();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryUserMap(final java.util.Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new java.lang.NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new java.util.ArrayList<String>();
                this.queryUserMap$value = new java.util.ArrayList<Long>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return self();
        }

        /**
         * Number of schemas in this database.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaCount(final Integer schemaCount) {
            this.schemaCount = schemaCount;
            return self();
        }

        /**
         * Simple name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaName(final String schemaName) {
            this.schemaName = schemaName;
            return self();
        }

        /**
         * Unique name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaQualifiedName(final String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schema(final ISchema schema) {
            if (this.schemas == null) this.schemas = new java.util.ArrayList<ISchema>();
            this.schemas.add(schema);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemas(final java.util.Collection<? extends ISchema> schemas) {
            if (schemas == null) {
                throw new java.lang.NullPointerException("schemas cannot be null");
            }
            if (this.schemas == null) this.schemas = new java.util.ArrayList<ISchema>();
            this.schemas.addAll(schemas);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSchemas() {
            if (this.schemas != null) this.schemas.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDBTSource(final IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) this.sqlDBTSources = new java.util.ArrayList<IDbtSource>();
            this.sqlDBTSources.add(sqlDBTSource);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDBTSources(final java.util.Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new java.lang.NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) this.sqlDBTSources = new java.util.ArrayList<IDbtSource>();
            this.sqlDBTSources.addAll(sqlDBTSources);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) this.sqlDBTSources.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDbtModel(final IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) this.sqlDbtModels = new java.util.ArrayList<IDbtModel>();
            this.sqlDbtModels.add(sqlDbtModel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDbtModels(final java.util.Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new java.lang.NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) this.sqlDbtModels = new java.util.ArrayList<IDbtModel>();
            this.sqlDbtModels.addAll(sqlDbtModels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) this.sqlDbtModels.clear();
            return self();
        }

        /**
         * Simple name of the table in which this SQL asset exists, or empty if it does not exist within a table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableName(final String tableName) {
            this.tableName = tableName;
            return self();
        }

        /**
         * Unique name of the table in which this SQL asset exists, or empty if it does not exist within a table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableQualifiedName(final String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return self();
        }

        /**
         * Simple name of the view in which this SQL asset exists, or empty if it does not exist within a view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewName(final String viewName) {
            this.viewName = viewName;
            return self();
        }

        /**
         * Unique name of the view in which this SQL asset exists, or empty if it does not exist within a view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewQualifiedName(final String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "CosmosMongoDBDatabase.CosmosMongoDBDatabaseBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", calculationViewName=" + this.calculationViewName + ", calculationViewQualifiedName=" + this.calculationViewQualifiedName + ", cosmosMongoDBAccount=" + this.cosmosMongoDBAccount + ", cosmosMongoDBAccountQualifiedName=" + this.cosmosMongoDBAccountQualifiedName + ", cosmosMongoDBCollections=" + this.cosmosMongoDBCollections + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtModels=" + this.dbtModels + ", dbtSources=" + this.dbtSources + ", dbtTests=" + this.dbtTests + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isProfiled=" + this.isProfiled + ", lastProfiledAt=" + this.lastProfiledAt + ", mongoDBCollections=" + this.mongoDBCollections + ", mongoDBDatabaseCollectionCount=" + this.mongoDBDatabaseCollectionCount + ", noSQLSchemaDefinition=" + this.noSQLSchemaDefinition + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + this.queryUserMap$key + ", queryUserMap$value=" + this.queryUserMap$value + ", schemaCount=" + this.schemaCount + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", schemas=" + this.schemas + ", sqlDBTSources=" + this.sqlDBTSources + ", sqlDbtModels=" + this.sqlDbtModels + ", tableName=" + this.tableName + ", tableQualifiedName=" + this.tableQualifiedName + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class CosmosMongoDBDatabaseBuilderImpl extends CosmosMongoDBDatabase.CosmosMongoDBDatabaseBuilder<CosmosMongoDBDatabase, CosmosMongoDBDatabase.CosmosMongoDBDatabaseBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CosmosMongoDBDatabaseBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected CosmosMongoDBDatabase.CosmosMongoDBDatabaseBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CosmosMongoDBDatabase build() {
            return new CosmosMongoDBDatabase(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected CosmosMongoDBDatabase(final CosmosMongoDBDatabase.CosmosMongoDBDatabaseBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = CosmosMongoDBDatabase.$default$typeName();
        this.calculationViewName = b.calculationViewName;
        this.calculationViewQualifiedName = b.calculationViewQualifiedName;
        this.cosmosMongoDBAccount = b.cosmosMongoDBAccount;
        this.cosmosMongoDBAccountQualifiedName = b.cosmosMongoDBAccountQualifiedName;
        java.util.SortedSet<ICosmosMongoDBCollection> cosmosMongoDBCollections = new java.util.TreeSet<ICosmosMongoDBCollection>();
        if (b.cosmosMongoDBCollections != null) cosmosMongoDBCollections.addAll(b.cosmosMongoDBCollections);
        cosmosMongoDBCollections = java.util.Collections.unmodifiableSortedSet(cosmosMongoDBCollections);
        this.cosmosMongoDBCollections = cosmosMongoDBCollections;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        java.util.SortedSet<IDbtModel> dbtModels = new java.util.TreeSet<IDbtModel>();
        if (b.dbtModels != null) dbtModels.addAll(b.dbtModels);
        dbtModels = java.util.Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        java.util.SortedSet<IDbtSource> dbtSources = new java.util.TreeSet<IDbtSource>();
        if (b.dbtSources != null) dbtSources.addAll(b.dbtSources);
        dbtSources = java.util.Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        java.util.SortedSet<IDbtTest> dbtTests = new java.util.TreeSet<IDbtTest>();
        if (b.dbtTests != null) dbtTests.addAll(b.dbtTests);
        dbtTests = java.util.Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isProfiled = b.isProfiled;
        this.lastProfiledAt = b.lastProfiledAt;
        java.util.SortedSet<IMongoDBCollection> mongoDBCollections = new java.util.TreeSet<IMongoDBCollection>();
        if (b.mongoDBCollections != null) mongoDBCollections.addAll(b.mongoDBCollections);
        mongoDBCollections = java.util.Collections.unmodifiableSortedSet(mongoDBCollections);
        this.mongoDBCollections = mongoDBCollections;
        this.mongoDBDatabaseCollectionCount = b.mongoDBDatabaseCollectionCount;
        this.noSQLSchemaDefinition = b.noSQLSchemaDefinition;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        this.queryUserCount = b.queryUserCount;
        java.util.Map<String, Long> queryUserMap;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
        case 0: 
            queryUserMap = java.util.Collections.emptyMap();
            break;
        case 1: 
            queryUserMap = java.util.Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
            break;
        default: 
            queryUserMap = new java.util.LinkedHashMap<String, Long>(b.queryUserMap$key.size() < 1073741824 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.queryUserMap$key.size(); $i++) queryUserMap.put(b.queryUserMap$key.get($i), (Long) b.queryUserMap$value.get($i));
            queryUserMap = java.util.Collections.unmodifiableMap(queryUserMap);
        }
        this.queryUserMap = queryUserMap;
        this.schemaCount = b.schemaCount;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        java.util.SortedSet<ISchema> schemas = new java.util.TreeSet<ISchema>();
        if (b.schemas != null) schemas.addAll(b.schemas);
        schemas = java.util.Collections.unmodifiableSortedSet(schemas);
        this.schemas = schemas;
        java.util.SortedSet<IDbtSource> sqlDBTSources = new java.util.TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) sqlDBTSources.addAll(b.sqlDBTSources);
        sqlDBTSources = java.util.Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        java.util.SortedSet<IDbtModel> sqlDbtModels = new java.util.TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) sqlDbtModels.addAll(b.sqlDbtModels);
        sqlDbtModels = java.util.Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.tableName = b.tableName;
        this.tableQualifiedName = b.tableQualifiedName;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static CosmosMongoDBDatabase.CosmosMongoDBDatabaseBuilder<?, ?> _internal() {
        return new CosmosMongoDBDatabase.CosmosMongoDBDatabaseBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CosmosMongoDBDatabase.CosmosMongoDBDatabaseBuilder<?, ?> toBuilder() {
        return new CosmosMongoDBDatabase.CosmosMongoDBDatabaseBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Simple name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCalculationViewName() {
        return this.calculationViewName;
    }

    /**
     * Unique name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCalculationViewQualifiedName() {
        return this.calculationViewQualifiedName;
    }

    /**
     * Account in which the database exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ICosmosMongoDBAccount getCosmosMongoDBAccount() {
        return this.cosmosMongoDBAccount;
    }

    /**
     * Unique name of the account in which this database exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCosmosMongoDBAccountQualifiedName() {
        return this.cosmosMongoDBAccountQualifiedName;
    }

    /**
     * Collections that exist within this database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICosmosMongoDBCollection> getCosmosMongoDBCollections() {
        return this.cosmosMongoDBCollections;
    }

    /**
     * Simple name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    /**
     * Unique name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Whether this asset has been profiled (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    /**
     * Time (epoch) at which this asset was last profiled, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    /**
     * Collections that exist within this database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMongoDBCollection> getMongoDBCollections() {
        return this.mongoDBCollections;
    }

    /**
     * Number of collections in the database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getMongoDBDatabaseCollectionCount() {
        return this.mongoDBDatabaseCollectionCount;
    }

    /**
     * Represents attributes for describing the key schema for the table and indexes.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNoSQLSchemaDefinition() {
        return this.noSQLSchemaDefinition;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Number of times this asset has been queried.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryCount() {
        return this.queryCount;
    }

    /**
     * Time (epoch) at which the query count was last updated, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    /**
     * Number of unique users who have queried this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    /**
     * Map of unique users who have queried this asset to the number of times they have queried it.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    /**
     * Number of schemas in this database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getSchemaCount() {
        return this.schemaCount;
    }

    /**
     * Simple name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    /**
     * Unique name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    /**
     * Schemas that exist within this database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISchema> getSchemas() {
        return this.schemas;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    /**
     * Simple name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableName() {
        return this.tableName;
    }

    /**
     * Unique name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    /**
     * Simple name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getViewName() {
        return this.viewName;
    }

    /**
     * Unique name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CosmosMongoDBDatabase)) return false;
        final CosmosMongoDBDatabase other = (CosmosMongoDBDatabase) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$isProfiled = this.getIsProfiled();
        final java.lang.Object other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !this$isProfiled.equals(other$isProfiled)) return false;
        final java.lang.Object this$lastProfiledAt = this.getLastProfiledAt();
        final java.lang.Object other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !this$lastProfiledAt.equals(other$lastProfiledAt)) return false;
        final java.lang.Object this$mongoDBDatabaseCollectionCount = this.getMongoDBDatabaseCollectionCount();
        final java.lang.Object other$mongoDBDatabaseCollectionCount = other.getMongoDBDatabaseCollectionCount();
        if (this$mongoDBDatabaseCollectionCount == null ? other$mongoDBDatabaseCollectionCount != null : !this$mongoDBDatabaseCollectionCount.equals(other$mongoDBDatabaseCollectionCount)) return false;
        final java.lang.Object this$queryCount = this.getQueryCount();
        final java.lang.Object other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !this$queryCount.equals(other$queryCount)) return false;
        final java.lang.Object this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        final java.lang.Object other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !this$queryCountUpdatedAt.equals(other$queryCountUpdatedAt)) return false;
        final java.lang.Object this$queryUserCount = this.getQueryUserCount();
        final java.lang.Object other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !this$queryUserCount.equals(other$queryUserCount)) return false;
        final java.lang.Object this$schemaCount = this.getSchemaCount();
        final java.lang.Object other$schemaCount = other.getSchemaCount();
        if (this$schemaCount == null ? other$schemaCount != null : !this$schemaCount.equals(other$schemaCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$calculationViewName = this.getCalculationViewName();
        final java.lang.Object other$calculationViewName = other.getCalculationViewName();
        if (this$calculationViewName == null ? other$calculationViewName != null : !this$calculationViewName.equals(other$calculationViewName)) return false;
        final java.lang.Object this$calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        final java.lang.Object other$calculationViewQualifiedName = other.getCalculationViewQualifiedName();
        if (this$calculationViewQualifiedName == null ? other$calculationViewQualifiedName != null : !this$calculationViewQualifiedName.equals(other$calculationViewQualifiedName)) return false;
        final java.lang.Object this$cosmosMongoDBAccount = this.getCosmosMongoDBAccount();
        final java.lang.Object other$cosmosMongoDBAccount = other.getCosmosMongoDBAccount();
        if (this$cosmosMongoDBAccount == null ? other$cosmosMongoDBAccount != null : !this$cosmosMongoDBAccount.equals(other$cosmosMongoDBAccount)) return false;
        final java.lang.Object this$cosmosMongoDBAccountQualifiedName = this.getCosmosMongoDBAccountQualifiedName();
        final java.lang.Object other$cosmosMongoDBAccountQualifiedName = other.getCosmosMongoDBAccountQualifiedName();
        if (this$cosmosMongoDBAccountQualifiedName == null ? other$cosmosMongoDBAccountQualifiedName != null : !this$cosmosMongoDBAccountQualifiedName.equals(other$cosmosMongoDBAccountQualifiedName)) return false;
        final java.lang.Object this$cosmosMongoDBCollections = this.getCosmosMongoDBCollections();
        final java.lang.Object other$cosmosMongoDBCollections = other.getCosmosMongoDBCollections();
        if (this$cosmosMongoDBCollections == null ? other$cosmosMongoDBCollections != null : !this$cosmosMongoDBCollections.equals(other$cosmosMongoDBCollections)) return false;
        final java.lang.Object this$databaseName = this.getDatabaseName();
        final java.lang.Object other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) return false;
        final java.lang.Object this$databaseQualifiedName = this.getDatabaseQualifiedName();
        final java.lang.Object other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) return false;
        final java.lang.Object this$dbtModels = this.getDbtModels();
        final java.lang.Object other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) return false;
        final java.lang.Object this$dbtSources = this.getDbtSources();
        final java.lang.Object other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) return false;
        final java.lang.Object this$dbtTests = this.getDbtTests();
        final java.lang.Object other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$mongoDBCollections = this.getMongoDBCollections();
        final java.lang.Object other$mongoDBCollections = other.getMongoDBCollections();
        if (this$mongoDBCollections == null ? other$mongoDBCollections != null : !this$mongoDBCollections.equals(other$mongoDBCollections)) return false;
        final java.lang.Object this$noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        final java.lang.Object other$noSQLSchemaDefinition = other.getNoSQLSchemaDefinition();
        if (this$noSQLSchemaDefinition == null ? other$noSQLSchemaDefinition != null : !this$noSQLSchemaDefinition.equals(other$noSQLSchemaDefinition)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$queryUserMap = this.getQueryUserMap();
        final java.lang.Object other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !this$queryUserMap.equals(other$queryUserMap)) return false;
        final java.lang.Object this$schemaName = this.getSchemaName();
        final java.lang.Object other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) return false;
        final java.lang.Object this$schemaQualifiedName = this.getSchemaQualifiedName();
        final java.lang.Object other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) return false;
        final java.lang.Object this$schemas = this.getSchemas();
        final java.lang.Object other$schemas = other.getSchemas();
        if (this$schemas == null ? other$schemas != null : !this$schemas.equals(other$schemas)) return false;
        final java.lang.Object this$sqlDBTSources = this.getSqlDBTSources();
        final java.lang.Object other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) return false;
        final java.lang.Object this$sqlDbtModels = this.getSqlDbtModels();
        final java.lang.Object other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) return false;
        final java.lang.Object this$tableName = this.getTableName();
        final java.lang.Object other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) return false;
        final java.lang.Object this$tableQualifiedName = this.getTableQualifiedName();
        final java.lang.Object other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) return false;
        final java.lang.Object this$viewName = this.getViewName();
        final java.lang.Object other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) return false;
        final java.lang.Object this$viewQualifiedName = this.getViewQualifiedName();
        final java.lang.Object other$viewQualifiedName = other.getViewQualifiedName();
        if (this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CosmosMongoDBDatabase;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $isProfiled = this.getIsProfiled();
        result = result * PRIME + ($isProfiled == null ? 43 : $isProfiled.hashCode());
        final java.lang.Object $lastProfiledAt = this.getLastProfiledAt();
        result = result * PRIME + ($lastProfiledAt == null ? 43 : $lastProfiledAt.hashCode());
        final java.lang.Object $mongoDBDatabaseCollectionCount = this.getMongoDBDatabaseCollectionCount();
        result = result * PRIME + ($mongoDBDatabaseCollectionCount == null ? 43 : $mongoDBDatabaseCollectionCount.hashCode());
        final java.lang.Object $queryCount = this.getQueryCount();
        result = result * PRIME + ($queryCount == null ? 43 : $queryCount.hashCode());
        final java.lang.Object $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * PRIME + ($queryCountUpdatedAt == null ? 43 : $queryCountUpdatedAt.hashCode());
        final java.lang.Object $queryUserCount = this.getQueryUserCount();
        result = result * PRIME + ($queryUserCount == null ? 43 : $queryUserCount.hashCode());
        final java.lang.Object $schemaCount = this.getSchemaCount();
        result = result * PRIME + ($schemaCount == null ? 43 : $schemaCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $calculationViewName = this.getCalculationViewName();
        result = result * PRIME + ($calculationViewName == null ? 43 : $calculationViewName.hashCode());
        final java.lang.Object $calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        result = result * PRIME + ($calculationViewQualifiedName == null ? 43 : $calculationViewQualifiedName.hashCode());
        final java.lang.Object $cosmosMongoDBAccount = this.getCosmosMongoDBAccount();
        result = result * PRIME + ($cosmosMongoDBAccount == null ? 43 : $cosmosMongoDBAccount.hashCode());
        final java.lang.Object $cosmosMongoDBAccountQualifiedName = this.getCosmosMongoDBAccountQualifiedName();
        result = result * PRIME + ($cosmosMongoDBAccountQualifiedName == null ? 43 : $cosmosMongoDBAccountQualifiedName.hashCode());
        final java.lang.Object $cosmosMongoDBCollections = this.getCosmosMongoDBCollections();
        result = result * PRIME + ($cosmosMongoDBCollections == null ? 43 : $cosmosMongoDBCollections.hashCode());
        final java.lang.Object $databaseName = this.getDatabaseName();
        result = result * PRIME + ($databaseName == null ? 43 : $databaseName.hashCode());
        final java.lang.Object $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * PRIME + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        final java.lang.Object $dbtModels = this.getDbtModels();
        result = result * PRIME + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        final java.lang.Object $dbtSources = this.getDbtSources();
        result = result * PRIME + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        final java.lang.Object $dbtTests = this.getDbtTests();
        result = result * PRIME + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $mongoDBCollections = this.getMongoDBCollections();
        result = result * PRIME + ($mongoDBCollections == null ? 43 : $mongoDBCollections.hashCode());
        final java.lang.Object $noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        result = result * PRIME + ($noSQLSchemaDefinition == null ? 43 : $noSQLSchemaDefinition.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $queryUserMap = this.getQueryUserMap();
        result = result * PRIME + ($queryUserMap == null ? 43 : $queryUserMap.hashCode());
        final java.lang.Object $schemaName = this.getSchemaName();
        result = result * PRIME + ($schemaName == null ? 43 : $schemaName.hashCode());
        final java.lang.Object $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * PRIME + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        final java.lang.Object $schemas = this.getSchemas();
        result = result * PRIME + ($schemas == null ? 43 : $schemas.hashCode());
        final java.lang.Object $sqlDBTSources = this.getSqlDBTSources();
        result = result * PRIME + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        final java.lang.Object $sqlDbtModels = this.getSqlDbtModels();
        result = result * PRIME + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        final java.lang.Object $tableName = this.getTableName();
        result = result * PRIME + ($tableName == null ? 43 : $tableName.hashCode());
        final java.lang.Object $tableQualifiedName = this.getTableQualifiedName();
        result = result * PRIME + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        final java.lang.Object $viewName = this.getViewName();
        result = result * PRIME + ($viewName == null ? 43 : $viewName.hashCode());
        final java.lang.Object $viewQualifiedName = this.getViewQualifiedName();
        result = result * PRIME + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "CosmosMongoDBDatabase(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", calculationViewName=" + this.getCalculationViewName() + ", calculationViewQualifiedName=" + this.getCalculationViewQualifiedName() + ", cosmosMongoDBAccount=" + this.getCosmosMongoDBAccount() + ", cosmosMongoDBAccountQualifiedName=" + this.getCosmosMongoDBAccountQualifiedName() + ", cosmosMongoDBCollections=" + this.getCosmosMongoDBCollections() + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtModels=" + this.getDbtModels() + ", dbtSources=" + this.getDbtSources() + ", dbtTests=" + this.getDbtTests() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isProfiled=" + this.getIsProfiled() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", mongoDBCollections=" + this.getMongoDBCollections() + ", mongoDBDatabaseCollectionCount=" + this.getMongoDBDatabaseCollectionCount() + ", noSQLSchemaDefinition=" + this.getNoSQLSchemaDefinition() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + this.getQueryUserMap() + ", schemaCount=" + this.getSchemaCount() + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", schemas=" + this.getSchemas() + ", sqlDBTSources=" + this.getSqlDBTSources() + ", sqlDbtModels=" + this.getSqlDbtModels() + ", tableName=" + this.getTableName() + ", tableQualifiedName=" + this.getTableQualifiedName() + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ")";
    }

    /**
     * Fixed typeName for CosmosMongoDBDatabases.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
