// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a cube in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class Cube extends Asset implements ICube, IMultiDimensionalDataset, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(Cube.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Cube";
    /**
     * Fixed typeName for Cubes.
     */
    String typeName;
    /**
     * Number of dimensions in the cube.
     */
    @Attribute
    Long cubeDimensionCount;
    /**
     * Simple name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
     */
    @Attribute
    String cubeDimensionName;
    /**
     * Unique name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
     */
    @Attribute
    String cubeDimensionQualifiedName;
    /**
     * Individual dimensions that make up the cube.
     */
    @Attribute
    SortedSet<ICubeDimension> cubeDimensions;
    /**
     * Simple name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
     */
    @Attribute
    String cubeHierarchyName;
    /**
     * Unique name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
     */
    @Attribute
    String cubeHierarchyQualifiedName;
    /**
     * Simple name of the cube in which this asset exists, or empty if it is itself a cube.
     */
    @Attribute
    String cubeName;
    /**
     * Unique name of the cube in which this asset exists, or empty if it is itself a cube.
     */
    @Attribute
    String cubeQualifiedName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a Cube, from a potentially
     * more-complete Cube object.
     *
     * @return the minimal object necessary to relate to the Cube
     * @throws InvalidRequestException if any of the minimal set of required properties for a Cube relationship are not found in the initial object
     */
    @Override
    public Cube trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all Cube assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Cube assets will be included.
     *
     * @return a fluent search that includes all Cube assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all Cube assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Cube assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all Cube assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all Cube assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) Cubes will be included
     * @return a fluent search that includes all Cube assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all Cube assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) Cubes will be included
     * @return a fluent search that includes all Cube assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a Cube by GUID. Use this to create a relationship to this Cube,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the Cube to reference
     * @return reference to a Cube that can be used for defining a relationship to a Cube
     */
    public static Cube refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Cube by GUID. Use this to create a relationship to this Cube,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the Cube to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Cube that can be used for defining a relationship to a Cube
     */
    public static Cube refByGuid(String guid, Reference.SaveSemantic semantic) {
        return Cube._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a Cube by qualifiedName. Use this to create a relationship to this Cube,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the Cube to reference
     * @return reference to a Cube that can be used for defining a relationship to a Cube
     */
    public static Cube refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Cube by qualifiedName. Use this to create a relationship to this Cube,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the Cube to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Cube that can be used for defining a relationship to a Cube
     */
    public static Cube refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return Cube._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a Cube by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the Cube to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Cube, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Cube does not exist or the provided GUID is not a Cube
     */
    @JsonIgnore
    public static Cube get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a Cube by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Cube to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Cube, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Cube does not exist or the provided GUID is not a Cube
     */
    @JsonIgnore
    public static Cube get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a Cube by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Cube to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full Cube, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Cube does not exist or the provided GUID is not a Cube
     */
    @JsonIgnore
    public static Cube get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof Cube) {
                return (Cube) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof Cube) {
                return (Cube) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) Cube to active.
     *
     * @param qualifiedName for the Cube
     * @return true if the Cube is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) Cube to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the Cube
     * @return true if the Cube is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a Cube.
     *
     * @param name of the Cube
     * @param connectionQualifiedName unique name of the connection in which this Cube exists
     * @return the minimal request necessary to create the Cube, as a builder
     */
    public static CubeBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return Cube._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).name(name).qualifiedName(generateQualifiedName(name, connectionQualifiedName)).connectorType(connectorType).connectionQualifiedName(connectionQualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a Cube.
     *
     * @param qualifiedName of the Cube
     * @param name of the Cube
     * @return the minimal request necessary to update the Cube, as a builder
     */
    public static CubeBuilder<?, ?> updater(String qualifiedName, String name) {
        return Cube._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Generate a unique Cube name.
     *
     * @param name of the Cube
     * @param connectionQualifiedName unique name of the connection in which this Cube exists
     * @return a unique name for the Cube
     */
    public static String generateQualifiedName(String name, String connectionQualifiedName) {
        return connectionQualifiedName + "/" + name;
    }

    /**
     * Builds the minimal object necessary to apply an update to a Cube, from a potentially
     * more-complete Cube object.
     *
     * @return the minimal object necessary to update the Cube, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for Cube are not found in the initial object
     */
    @Override
    public CubeBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a Cube.
     *
     * @param qualifiedName of the Cube
     * @param name of the Cube
     * @return the updated Cube, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Cube removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a Cube.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Cube
     * @param name of the Cube
     * @return the updated Cube, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Cube removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Cube) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a Cube.
     *
     * @param qualifiedName of the Cube
     * @param name of the Cube
     * @return the updated Cube, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Cube removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a Cube.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Cube
     * @param name of the Cube
     * @return the updated Cube, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Cube removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Cube) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a Cube.
     *
     * @param qualifiedName of the Cube
     * @param name of the Cube
     * @return the updated Cube, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Cube removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a Cube.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Cube's owners
     * @param qualifiedName of the Cube
     * @param name of the Cube
     * @return the updated Cube, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Cube removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Cube) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a Cube.
     *
     * @param qualifiedName of the Cube
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Cube, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Cube updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a Cube.
     *
     * @param client connectivity to the Atlan tenant on which to update the Cube's certificate
     * @param qualifiedName of the Cube
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Cube, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Cube updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Cube) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a Cube.
     *
     * @param qualifiedName of the Cube
     * @param name of the Cube
     * @return the updated Cube, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Cube removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a Cube.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Cube's certificate
     * @param qualifiedName of the Cube
     * @param name of the Cube
     * @return the updated Cube, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Cube removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Cube) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a Cube.
     *
     * @param qualifiedName of the Cube
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Cube updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a Cube.
     *
     * @param client connectivity to the Atlan tenant on which to update the Cube's announcement
     * @param qualifiedName of the Cube
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Cube updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Cube) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a Cube.
     *
     * @param qualifiedName of the Cube
     * @param name of the Cube
     * @return the updated Cube, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Cube removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a Cube.
     *
     * @param client connectivity to the Atlan client from which to remove the Cube's announcement
     * @param qualifiedName of the Cube
     * @param name of the Cube
     * @return the updated Cube, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Cube removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Cube) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the Cube.
     *
     * @param qualifiedName for the Cube
     * @param name human-readable name of the Cube
     * @param terms the list of terms to replace on the Cube, or null to remove all terms from the Cube
     * @return the Cube that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Cube replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the Cube.
     *
     * @param client connectivity to the Atlan tenant on which to replace the Cube's assigned terms
     * @param qualifiedName for the Cube
     * @param name human-readable name of the Cube
     * @param terms the list of terms to replace on the Cube, or null to remove all terms from the Cube
     * @return the Cube that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Cube replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Cube) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the Cube, without replacing existing terms linked to the Cube.
     * Note: this operation must make two API calls — one to retrieve the Cube's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the Cube
     * @param terms the list of terms to append to the Cube
     * @return the Cube that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Cube appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the Cube, without replacing existing terms linked to the Cube.
     * Note: this operation must make two API calls — one to retrieve the Cube's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the Cube
     * @param qualifiedName for the Cube
     * @param terms the list of terms to append to the Cube
     * @return the Cube that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Cube appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Cube) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a Cube, without replacing all existing terms linked to the Cube.
     * Note: this operation must make two API calls — one to retrieve the Cube's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the Cube
     * @param terms the list of terms to remove from the Cube, which must be referenced by GUID
     * @return the Cube that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Cube removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a Cube, without replacing all existing terms linked to the Cube.
     * Note: this operation must make two API calls — one to retrieve the Cube's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the Cube
     * @param qualifiedName for the Cube
     * @param terms the list of terms to remove from the Cube, which must be referenced by GUID
     * @return the Cube that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Cube removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Cube) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a Cube, without replacing existing Atlan tags linked to the Cube.
     * Note: this operation must make two API calls — one to retrieve the Cube's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Cube
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Cube
     */
    public static Cube appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Cube, without replacing existing Atlan tags linked to the Cube.
     * Note: this operation must make two API calls — one to retrieve the Cube's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Cube
     * @param qualifiedName of the Cube
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Cube
     */
    public static Cube appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Cube) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Cube, without replacing existing Atlan tags linked to the Cube.
     * Note: this operation must make two API calls — one to retrieve the Cube's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Cube
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Cube
     */
    public static Cube appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a Cube, without replacing existing Atlan tags linked to the Cube.
     * Note: this operation must make two API calls — one to retrieve the Cube's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Cube
     * @param qualifiedName of the Cube
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Cube
     */
    public static Cube appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Cube) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a Cube.
     *
     * @param qualifiedName of the Cube
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Cube
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a Cube.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a Cube
     * @param qualifiedName of the Cube
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Cube
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class CubeBuilder<C extends Cube, B extends Cube.CubeBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long cubeDimensionCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeDimensionName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeDimensionQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICubeDimension> cubeDimensions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeHierarchyName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeHierarchyQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Cube.CubeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Cube instance, final Cube.CubeBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cubeDimensionCount(instance.cubeDimensionCount);
            b.cubeDimensionName(instance.cubeDimensionName);
            b.cubeDimensionQualifiedName(instance.cubeDimensionQualifiedName);
            b.cubeDimensions(instance.cubeDimensions == null ? java.util.Collections.<ICubeDimension>emptySortedSet() : instance.cubeDimensions);
            b.cubeHierarchyName(instance.cubeHierarchyName);
            b.cubeHierarchyQualifiedName(instance.cubeHierarchyQualifiedName);
            b.cubeName(instance.cubeName);
            b.cubeQualifiedName(instance.cubeQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for Cubes.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Number of dimensions in the cube.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeDimensionCount(final Long cubeDimensionCount) {
            this.cubeDimensionCount = cubeDimensionCount;
            return self();
        }

        /**
         * Simple name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeDimensionName(final String cubeDimensionName) {
            this.cubeDimensionName = cubeDimensionName;
            return self();
        }

        /**
         * Unique name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeDimensionQualifiedName(final String cubeDimensionQualifiedName) {
            this.cubeDimensionQualifiedName = cubeDimensionQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeDimension(final ICubeDimension cubeDimension) {
            if (this.cubeDimensions == null) this.cubeDimensions = new java.util.ArrayList<ICubeDimension>();
            this.cubeDimensions.add(cubeDimension);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeDimensions(final java.util.Collection<? extends ICubeDimension> cubeDimensions) {
            if (cubeDimensions == null) {
                throw new java.lang.NullPointerException("cubeDimensions cannot be null");
            }
            if (this.cubeDimensions == null) this.cubeDimensions = new java.util.ArrayList<ICubeDimension>();
            this.cubeDimensions.addAll(cubeDimensions);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCubeDimensions() {
            if (this.cubeDimensions != null) this.cubeDimensions.clear();
            return self();
        }

        /**
         * Simple name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeHierarchyName(final String cubeHierarchyName) {
            this.cubeHierarchyName = cubeHierarchyName;
            return self();
        }

        /**
         * Unique name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeHierarchyQualifiedName(final String cubeHierarchyQualifiedName) {
            this.cubeHierarchyQualifiedName = cubeHierarchyQualifiedName;
            return self();
        }

        /**
         * Simple name of the cube in which this asset exists, or empty if it is itself a cube.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeName(final String cubeName) {
            this.cubeName = cubeName;
            return self();
        }

        /**
         * Unique name of the cube in which this asset exists, or empty if it is itself a cube.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeQualifiedName(final String cubeQualifiedName) {
            this.cubeQualifiedName = cubeQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Cube.CubeBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cubeDimensionCount=" + this.cubeDimensionCount + ", cubeDimensionName=" + this.cubeDimensionName + ", cubeDimensionQualifiedName=" + this.cubeDimensionQualifiedName + ", cubeDimensions=" + this.cubeDimensions + ", cubeHierarchyName=" + this.cubeHierarchyName + ", cubeHierarchyQualifiedName=" + this.cubeHierarchyQualifiedName + ", cubeName=" + this.cubeName + ", cubeQualifiedName=" + this.cubeQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class CubeBuilderImpl extends Cube.CubeBuilder<Cube, Cube.CubeBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CubeBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Cube.CubeBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Cube build() {
            return new Cube(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Cube(final Cube.CubeBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = Cube.$default$typeName();
        this.cubeDimensionCount = b.cubeDimensionCount;
        this.cubeDimensionName = b.cubeDimensionName;
        this.cubeDimensionQualifiedName = b.cubeDimensionQualifiedName;
        java.util.SortedSet<ICubeDimension> cubeDimensions = new java.util.TreeSet<ICubeDimension>();
        if (b.cubeDimensions != null) cubeDimensions.addAll(b.cubeDimensions);
        cubeDimensions = java.util.Collections.unmodifiableSortedSet(cubeDimensions);
        this.cubeDimensions = cubeDimensions;
        this.cubeHierarchyName = b.cubeHierarchyName;
        this.cubeHierarchyQualifiedName = b.cubeHierarchyQualifiedName;
        this.cubeName = b.cubeName;
        this.cubeQualifiedName = b.cubeQualifiedName;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Cube.CubeBuilder<?, ?> _internal() {
        return new Cube.CubeBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Cube.CubeBuilder<?, ?> toBuilder() {
        return new Cube.CubeBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Number of dimensions in the cube.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCubeDimensionCount() {
        return this.cubeDimensionCount;
    }

    /**
     * Simple name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeDimensionName() {
        return this.cubeDimensionName;
    }

    /**
     * Unique name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeDimensionQualifiedName() {
        return this.cubeDimensionQualifiedName;
    }

    /**
     * Individual dimensions that make up the cube.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICubeDimension> getCubeDimensions() {
        return this.cubeDimensions;
    }

    /**
     * Simple name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeHierarchyName() {
        return this.cubeHierarchyName;
    }

    /**
     * Unique name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeHierarchyQualifiedName() {
        return this.cubeHierarchyQualifiedName;
    }

    /**
     * Simple name of the cube in which this asset exists, or empty if it is itself a cube.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeName() {
        return this.cubeName;
    }

    /**
     * Unique name of the cube in which this asset exists, or empty if it is itself a cube.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeQualifiedName() {
        return this.cubeQualifiedName;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Cube)) return false;
        final Cube other = (Cube) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$cubeDimensionCount = this.getCubeDimensionCount();
        final java.lang.Object other$cubeDimensionCount = other.getCubeDimensionCount();
        if (this$cubeDimensionCount == null ? other$cubeDimensionCount != null : !this$cubeDimensionCount.equals(other$cubeDimensionCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$cubeDimensionName = this.getCubeDimensionName();
        final java.lang.Object other$cubeDimensionName = other.getCubeDimensionName();
        if (this$cubeDimensionName == null ? other$cubeDimensionName != null : !this$cubeDimensionName.equals(other$cubeDimensionName)) return false;
        final java.lang.Object this$cubeDimensionQualifiedName = this.getCubeDimensionQualifiedName();
        final java.lang.Object other$cubeDimensionQualifiedName = other.getCubeDimensionQualifiedName();
        if (this$cubeDimensionQualifiedName == null ? other$cubeDimensionQualifiedName != null : !this$cubeDimensionQualifiedName.equals(other$cubeDimensionQualifiedName)) return false;
        final java.lang.Object this$cubeDimensions = this.getCubeDimensions();
        final java.lang.Object other$cubeDimensions = other.getCubeDimensions();
        if (this$cubeDimensions == null ? other$cubeDimensions != null : !this$cubeDimensions.equals(other$cubeDimensions)) return false;
        final java.lang.Object this$cubeHierarchyName = this.getCubeHierarchyName();
        final java.lang.Object other$cubeHierarchyName = other.getCubeHierarchyName();
        if (this$cubeHierarchyName == null ? other$cubeHierarchyName != null : !this$cubeHierarchyName.equals(other$cubeHierarchyName)) return false;
        final java.lang.Object this$cubeHierarchyQualifiedName = this.getCubeHierarchyQualifiedName();
        final java.lang.Object other$cubeHierarchyQualifiedName = other.getCubeHierarchyQualifiedName();
        if (this$cubeHierarchyQualifiedName == null ? other$cubeHierarchyQualifiedName != null : !this$cubeHierarchyQualifiedName.equals(other$cubeHierarchyQualifiedName)) return false;
        final java.lang.Object this$cubeName = this.getCubeName();
        final java.lang.Object other$cubeName = other.getCubeName();
        if (this$cubeName == null ? other$cubeName != null : !this$cubeName.equals(other$cubeName)) return false;
        final java.lang.Object this$cubeQualifiedName = this.getCubeQualifiedName();
        final java.lang.Object other$cubeQualifiedName = other.getCubeQualifiedName();
        if (this$cubeQualifiedName == null ? other$cubeQualifiedName != null : !this$cubeQualifiedName.equals(other$cubeQualifiedName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Cube;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $cubeDimensionCount = this.getCubeDimensionCount();
        result = result * PRIME + ($cubeDimensionCount == null ? 43 : $cubeDimensionCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $cubeDimensionName = this.getCubeDimensionName();
        result = result * PRIME + ($cubeDimensionName == null ? 43 : $cubeDimensionName.hashCode());
        final java.lang.Object $cubeDimensionQualifiedName = this.getCubeDimensionQualifiedName();
        result = result * PRIME + ($cubeDimensionQualifiedName == null ? 43 : $cubeDimensionQualifiedName.hashCode());
        final java.lang.Object $cubeDimensions = this.getCubeDimensions();
        result = result * PRIME + ($cubeDimensions == null ? 43 : $cubeDimensions.hashCode());
        final java.lang.Object $cubeHierarchyName = this.getCubeHierarchyName();
        result = result * PRIME + ($cubeHierarchyName == null ? 43 : $cubeHierarchyName.hashCode());
        final java.lang.Object $cubeHierarchyQualifiedName = this.getCubeHierarchyQualifiedName();
        result = result * PRIME + ($cubeHierarchyQualifiedName == null ? 43 : $cubeHierarchyQualifiedName.hashCode());
        final java.lang.Object $cubeName = this.getCubeName();
        result = result * PRIME + ($cubeName == null ? 43 : $cubeName.hashCode());
        final java.lang.Object $cubeQualifiedName = this.getCubeQualifiedName();
        result = result * PRIME + ($cubeQualifiedName == null ? 43 : $cubeQualifiedName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Cube(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cubeDimensionCount=" + this.getCubeDimensionCount() + ", cubeDimensionName=" + this.getCubeDimensionName() + ", cubeDimensionQualifiedName=" + this.getCubeDimensionQualifiedName() + ", cubeDimensions=" + this.getCubeDimensions() + ", cubeHierarchyName=" + this.getCubeHierarchyName() + ", cubeHierarchyQualifiedName=" + this.getCubeHierarchyQualifiedName() + ", cubeName=" + this.getCubeName() + ", cubeQualifiedName=" + this.getCubeQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for Cubes.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
