// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a cube dimension in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class CubeDimension extends Asset implements ICubeDimension, IMultiDimensionalDataset, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CubeDimension.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CubeDimension";
    /**
     * Fixed typeName for CubeDimensions.
     */
    String typeName;
    /**
     * Cube in which this dimension exists.
     */
    @Attribute
    ICube cube;
    /**
     * Simple name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
     */
    @Attribute
    String cubeDimensionName;
    /**
     * Unique name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
     */
    @Attribute
    String cubeDimensionQualifiedName;
    /**
     * Individual hierarchies that make up the dimension.
     */
    @Attribute
    SortedSet<ICubeHierarchy> cubeHierarchies;
    /**
     * Number of hierarchies in the cube dimension.
     */
    @Attribute
    Long cubeHierarchyCount;
    /**
     * Simple name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
     */
    @Attribute
    String cubeHierarchyName;
    /**
     * Unique name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
     */
    @Attribute
    String cubeHierarchyQualifiedName;
    /**
     * Simple name of the cube in which this asset exists, or empty if it is itself a cube.
     */
    @Attribute
    String cubeName;
    /**
     * Unique name of the cube in which this asset exists, or empty if it is itself a cube.
     */
    @Attribute
    String cubeQualifiedName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a CubeDimension, from a potentially
     * more-complete CubeDimension object.
     *
     * @return the minimal object necessary to relate to the CubeDimension
     * @throws InvalidRequestException if any of the minimal set of required properties for a CubeDimension relationship are not found in the initial object
     */
    @Override
    public CubeDimension trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all CubeDimension assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) CubeDimension assets will be included.
     *
     * @return a fluent search that includes all CubeDimension assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all CubeDimension assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) CubeDimension assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all CubeDimension assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all CubeDimension assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) CubeDimensions will be included
     * @return a fluent search that includes all CubeDimension assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all CubeDimension assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) CubeDimensions will be included
     * @return a fluent search that includes all CubeDimension assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a CubeDimension by GUID. Use this to create a relationship to this CubeDimension,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the CubeDimension to reference
     * @return reference to a CubeDimension that can be used for defining a relationship to a CubeDimension
     */
    public static CubeDimension refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a CubeDimension by GUID. Use this to create a relationship to this CubeDimension,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the CubeDimension to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a CubeDimension that can be used for defining a relationship to a CubeDimension
     */
    public static CubeDimension refByGuid(String guid, Reference.SaveSemantic semantic) {
        return CubeDimension._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a CubeDimension by qualifiedName. Use this to create a relationship to this CubeDimension,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the CubeDimension to reference
     * @return reference to a CubeDimension that can be used for defining a relationship to a CubeDimension
     */
    public static CubeDimension refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a CubeDimension by qualifiedName. Use this to create a relationship to this CubeDimension,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the CubeDimension to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a CubeDimension that can be used for defining a relationship to a CubeDimension
     */
    public static CubeDimension refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return CubeDimension._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a CubeDimension by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the CubeDimension to retrieve, either its GUID or its full qualifiedName
     * @return the requested full CubeDimension, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CubeDimension does not exist or the provided GUID is not a CubeDimension
     */
    @JsonIgnore
    public static CubeDimension get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a CubeDimension by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the CubeDimension to retrieve, either its GUID or its full qualifiedName
     * @return the requested full CubeDimension, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CubeDimension does not exist or the provided GUID is not a CubeDimension
     */
    @JsonIgnore
    public static CubeDimension get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a CubeDimension by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the CubeDimension to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full CubeDimension, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CubeDimension does not exist or the provided GUID is not a CubeDimension
     */
    @JsonIgnore
    public static CubeDimension get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof CubeDimension) {
                return (CubeDimension) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof CubeDimension) {
                return (CubeDimension) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) CubeDimension to active.
     *
     * @param qualifiedName for the CubeDimension
     * @return true if the CubeDimension is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) CubeDimension to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the CubeDimension
     * @return true if the CubeDimension is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a CubeDimension.
     *
     * @param name of the CubeDimension
     * @param cube in which the dimension should be created, which must have at least a qualifiedName
     * @return the minimal request necessary to create the CubeDimension, as a builder
     * @throws InvalidRequestException if the cube provided is without a qualifiedName
     */
    public static CubeDimensionBuilder<?, ?> creator(String name, Cube cube) throws InvalidRequestException {
        validateRelationship(Cube.TYPE_NAME, Map.of("connectionQualifiedName", cube.getConnectionQualifiedName(), "name", cube.getName(), "qualifiedName", cube.getQualifiedName()));
        return creator(name, cube.getConnectionQualifiedName(), cube.getName(), cube.getQualifiedName()).cube(cube.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a CubeDimension.
     *
     * @param name of the CubeDimension
     * @param cubeQualifiedName unique name of the cube in which this CubeDimension exists
     * @return the minimal request necessary to create the CubeDimension, as a builder
     */
    public static CubeDimensionBuilder<?, ?> creator(String name, String cubeQualifiedName) {
        String cubeSlug = StringUtils.getNameFromQualifiedName(cubeQualifiedName);
        String cubeName = IMultiDimensionalDataset.getNameFromSlug(cubeSlug);
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(cubeQualifiedName);
        return creator(name, connectionQualifiedName, cubeName, cubeQualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a CubeDimension.
     *
     * @param name of the CubeDimension
     * @param connectionQualifiedName unique name of the connection in which to create this CubeDimension
     * @param cubeName simple name of the cube in which to create this CubeDimension
     * @param cubeQualifiedName unique name of the cube in which to create this CubeDimension
     * @return the minimal request necessary to create the CubeDimension, as a builder
     */
    public static CubeDimensionBuilder<?, ?> creator(String name, String connectionQualifiedName, String cubeName, String cubeQualifiedName) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return CubeDimension._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).name(name).qualifiedName(generateQualifiedName(name, cubeQualifiedName)).cubeName(cubeName).cubeQualifiedName(cubeQualifiedName).cube(Cube.refByQualifiedName(cubeQualifiedName)).connectorType(connectorType).connectionQualifiedName(connectionQualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a CubeDimension.
     *
     * @param qualifiedName of the CubeDimension
     * @param name of the CubeDimension
     * @return the minimal request necessary to update the CubeDimension, as a builder
     */
    public static CubeDimensionBuilder<?, ?> updater(String qualifiedName, String name) {
        return CubeDimension._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Generate a unique CubeDimension name.
     *
     * @param name of the CubeDimension
     * @param cubeQualifiedName unique name of the cube in which this CubeDimension exists
     * @return a unique name for the CubeDimension
     */
    public static String generateQualifiedName(String name, String cubeQualifiedName) {
        return cubeQualifiedName + "/" + IMultiDimensionalDataset.getSlugForName(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a CubeDimension, from a potentially
     * more-complete CubeDimension object.
     *
     * @return the minimal object necessary to update the CubeDimension, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for CubeDimension are not found in the initial object
     */
    @Override
    public CubeDimensionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a CubeDimension.
     *
     * @param qualifiedName of the CubeDimension
     * @param name of the CubeDimension
     * @return the updated CubeDimension, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a CubeDimension.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the CubeDimension
     * @param name of the CubeDimension
     * @return the updated CubeDimension, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeDimension) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a CubeDimension.
     *
     * @param qualifiedName of the CubeDimension
     * @param name of the CubeDimension
     * @return the updated CubeDimension, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a CubeDimension.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the CubeDimension
     * @param name of the CubeDimension
     * @return the updated CubeDimension, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeDimension) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a CubeDimension.
     *
     * @param qualifiedName of the CubeDimension
     * @param name of the CubeDimension
     * @return the updated CubeDimension, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a CubeDimension.
     *
     * @param client connectivity to the Atlan tenant from which to remove the CubeDimension's owners
     * @param qualifiedName of the CubeDimension
     * @param name of the CubeDimension
     * @return the updated CubeDimension, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeDimension) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a CubeDimension.
     *
     * @param qualifiedName of the CubeDimension
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated CubeDimension, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a CubeDimension.
     *
     * @param client connectivity to the Atlan tenant on which to update the CubeDimension's certificate
     * @param qualifiedName of the CubeDimension
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated CubeDimension, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CubeDimension) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a CubeDimension.
     *
     * @param qualifiedName of the CubeDimension
     * @param name of the CubeDimension
     * @return the updated CubeDimension, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a CubeDimension.
     *
     * @param client connectivity to the Atlan tenant from which to remove the CubeDimension's certificate
     * @param qualifiedName of the CubeDimension
     * @param name of the CubeDimension
     * @return the updated CubeDimension, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeDimension) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a CubeDimension.
     *
     * @param qualifiedName of the CubeDimension
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a CubeDimension.
     *
     * @param client connectivity to the Atlan tenant on which to update the CubeDimension's announcement
     * @param qualifiedName of the CubeDimension
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CubeDimension) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a CubeDimension.
     *
     * @param qualifiedName of the CubeDimension
     * @param name of the CubeDimension
     * @return the updated CubeDimension, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a CubeDimension.
     *
     * @param client connectivity to the Atlan client from which to remove the CubeDimension's announcement
     * @param qualifiedName of the CubeDimension
     * @param name of the CubeDimension
     * @return the updated CubeDimension, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeDimension removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeDimension) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the CubeDimension.
     *
     * @param qualifiedName for the CubeDimension
     * @param name human-readable name of the CubeDimension
     * @param terms the list of terms to replace on the CubeDimension, or null to remove all terms from the CubeDimension
     * @return the CubeDimension that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static CubeDimension replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the CubeDimension.
     *
     * @param client connectivity to the Atlan tenant on which to replace the CubeDimension's assigned terms
     * @param qualifiedName for the CubeDimension
     * @param name human-readable name of the CubeDimension
     * @param terms the list of terms to replace on the CubeDimension, or null to remove all terms from the CubeDimension
     * @return the CubeDimension that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static CubeDimension replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CubeDimension) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the CubeDimension, without replacing existing terms linked to the CubeDimension.
     * Note: this operation must make two API calls — one to retrieve the CubeDimension's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the CubeDimension
     * @param terms the list of terms to append to the CubeDimension
     * @return the CubeDimension that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static CubeDimension appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the CubeDimension, without replacing existing terms linked to the CubeDimension.
     * Note: this operation must make two API calls — one to retrieve the CubeDimension's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the CubeDimension
     * @param qualifiedName for the CubeDimension
     * @param terms the list of terms to append to the CubeDimension
     * @return the CubeDimension that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static CubeDimension appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CubeDimension) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a CubeDimension, without replacing all existing terms linked to the CubeDimension.
     * Note: this operation must make two API calls — one to retrieve the CubeDimension's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the CubeDimension
     * @param terms the list of terms to remove from the CubeDimension, which must be referenced by GUID
     * @return the CubeDimension that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static CubeDimension removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a CubeDimension, without replacing all existing terms linked to the CubeDimension.
     * Note: this operation must make two API calls — one to retrieve the CubeDimension's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the CubeDimension
     * @param qualifiedName for the CubeDimension
     * @param terms the list of terms to remove from the CubeDimension, which must be referenced by GUID
     * @return the CubeDimension that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static CubeDimension removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CubeDimension) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a CubeDimension, without replacing existing Atlan tags linked to the CubeDimension.
     * Note: this operation must make two API calls — one to retrieve the CubeDimension's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the CubeDimension
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated CubeDimension
     */
    public static CubeDimension appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a CubeDimension, without replacing existing Atlan tags linked to the CubeDimension.
     * Note: this operation must make two API calls — one to retrieve the CubeDimension's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the CubeDimension
     * @param qualifiedName of the CubeDimension
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated CubeDimension
     */
    public static CubeDimension appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CubeDimension) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a CubeDimension, without replacing existing Atlan tags linked to the CubeDimension.
     * Note: this operation must make two API calls — one to retrieve the CubeDimension's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the CubeDimension
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated CubeDimension
     */
    public static CubeDimension appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a CubeDimension, without replacing existing Atlan tags linked to the CubeDimension.
     * Note: this operation must make two API calls — one to retrieve the CubeDimension's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the CubeDimension
     * @param qualifiedName of the CubeDimension
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated CubeDimension
     */
    public static CubeDimension appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CubeDimension) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a CubeDimension.
     *
     * @param qualifiedName of the CubeDimension
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the CubeDimension
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a CubeDimension.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a CubeDimension
     * @param qualifiedName of the CubeDimension
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the CubeDimension
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class CubeDimensionBuilder<C extends CubeDimension, B extends CubeDimension.CubeDimensionBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ICube cube;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeDimensionName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeDimensionQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICubeHierarchy> cubeHierarchies;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long cubeHierarchyCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeHierarchyName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeHierarchyQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            CubeDimension.CubeDimensionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final CubeDimension instance, final CubeDimension.CubeDimensionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cube(instance.cube);
            b.cubeDimensionName(instance.cubeDimensionName);
            b.cubeDimensionQualifiedName(instance.cubeDimensionQualifiedName);
            b.cubeHierarchies(instance.cubeHierarchies == null ? java.util.Collections.<ICubeHierarchy>emptySortedSet() : instance.cubeHierarchies);
            b.cubeHierarchyCount(instance.cubeHierarchyCount);
            b.cubeHierarchyName(instance.cubeHierarchyName);
            b.cubeHierarchyQualifiedName(instance.cubeHierarchyQualifiedName);
            b.cubeName(instance.cubeName);
            b.cubeQualifiedName(instance.cubeQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for CubeDimensions.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Cube in which this dimension exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cube(final ICube cube) {
            this.cube = cube;
            return self();
        }

        /**
         * Simple name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeDimensionName(final String cubeDimensionName) {
            this.cubeDimensionName = cubeDimensionName;
            return self();
        }

        /**
         * Unique name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeDimensionQualifiedName(final String cubeDimensionQualifiedName) {
            this.cubeDimensionQualifiedName = cubeDimensionQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeHierarchy(final ICubeHierarchy cubeHierarchy) {
            if (this.cubeHierarchies == null) this.cubeHierarchies = new java.util.ArrayList<ICubeHierarchy>();
            this.cubeHierarchies.add(cubeHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeHierarchies(final java.util.Collection<? extends ICubeHierarchy> cubeHierarchies) {
            if (cubeHierarchies == null) {
                throw new java.lang.NullPointerException("cubeHierarchies cannot be null");
            }
            if (this.cubeHierarchies == null) this.cubeHierarchies = new java.util.ArrayList<ICubeHierarchy>();
            this.cubeHierarchies.addAll(cubeHierarchies);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCubeHierarchies() {
            if (this.cubeHierarchies != null) this.cubeHierarchies.clear();
            return self();
        }

        /**
         * Number of hierarchies in the cube dimension.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeHierarchyCount(final Long cubeHierarchyCount) {
            this.cubeHierarchyCount = cubeHierarchyCount;
            return self();
        }

        /**
         * Simple name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeHierarchyName(final String cubeHierarchyName) {
            this.cubeHierarchyName = cubeHierarchyName;
            return self();
        }

        /**
         * Unique name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeHierarchyQualifiedName(final String cubeHierarchyQualifiedName) {
            this.cubeHierarchyQualifiedName = cubeHierarchyQualifiedName;
            return self();
        }

        /**
         * Simple name of the cube in which this asset exists, or empty if it is itself a cube.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeName(final String cubeName) {
            this.cubeName = cubeName;
            return self();
        }

        /**
         * Unique name of the cube in which this asset exists, or empty if it is itself a cube.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeQualifiedName(final String cubeQualifiedName) {
            this.cubeQualifiedName = cubeQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "CubeDimension.CubeDimensionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cube=" + this.cube + ", cubeDimensionName=" + this.cubeDimensionName + ", cubeDimensionQualifiedName=" + this.cubeDimensionQualifiedName + ", cubeHierarchies=" + this.cubeHierarchies + ", cubeHierarchyCount=" + this.cubeHierarchyCount + ", cubeHierarchyName=" + this.cubeHierarchyName + ", cubeHierarchyQualifiedName=" + this.cubeHierarchyQualifiedName + ", cubeName=" + this.cubeName + ", cubeQualifiedName=" + this.cubeQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class CubeDimensionBuilderImpl extends CubeDimension.CubeDimensionBuilder<CubeDimension, CubeDimension.CubeDimensionBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CubeDimensionBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected CubeDimension.CubeDimensionBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CubeDimension build() {
            return new CubeDimension(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected CubeDimension(final CubeDimension.CubeDimensionBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = CubeDimension.$default$typeName();
        this.cube = b.cube;
        this.cubeDimensionName = b.cubeDimensionName;
        this.cubeDimensionQualifiedName = b.cubeDimensionQualifiedName;
        java.util.SortedSet<ICubeHierarchy> cubeHierarchies = new java.util.TreeSet<ICubeHierarchy>();
        if (b.cubeHierarchies != null) cubeHierarchies.addAll(b.cubeHierarchies);
        cubeHierarchies = java.util.Collections.unmodifiableSortedSet(cubeHierarchies);
        this.cubeHierarchies = cubeHierarchies;
        this.cubeHierarchyCount = b.cubeHierarchyCount;
        this.cubeHierarchyName = b.cubeHierarchyName;
        this.cubeHierarchyQualifiedName = b.cubeHierarchyQualifiedName;
        this.cubeName = b.cubeName;
        this.cubeQualifiedName = b.cubeQualifiedName;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static CubeDimension.CubeDimensionBuilder<?, ?> _internal() {
        return new CubeDimension.CubeDimensionBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CubeDimension.CubeDimensionBuilder<?, ?> toBuilder() {
        return new CubeDimension.CubeDimensionBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Cube in which this dimension exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ICube getCube() {
        return this.cube;
    }

    /**
     * Simple name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeDimensionName() {
        return this.cubeDimensionName;
    }

    /**
     * Unique name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeDimensionQualifiedName() {
        return this.cubeDimensionQualifiedName;
    }

    /**
     * Individual hierarchies that make up the dimension.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICubeHierarchy> getCubeHierarchies() {
        return this.cubeHierarchies;
    }

    /**
     * Number of hierarchies in the cube dimension.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCubeHierarchyCount() {
        return this.cubeHierarchyCount;
    }

    /**
     * Simple name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeHierarchyName() {
        return this.cubeHierarchyName;
    }

    /**
     * Unique name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeHierarchyQualifiedName() {
        return this.cubeHierarchyQualifiedName;
    }

    /**
     * Simple name of the cube in which this asset exists, or empty if it is itself a cube.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeName() {
        return this.cubeName;
    }

    /**
     * Unique name of the cube in which this asset exists, or empty if it is itself a cube.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeQualifiedName() {
        return this.cubeQualifiedName;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CubeDimension)) return false;
        final CubeDimension other = (CubeDimension) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$cubeHierarchyCount = this.getCubeHierarchyCount();
        final java.lang.Object other$cubeHierarchyCount = other.getCubeHierarchyCount();
        if (this$cubeHierarchyCount == null ? other$cubeHierarchyCount != null : !this$cubeHierarchyCount.equals(other$cubeHierarchyCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$cube = this.getCube();
        final java.lang.Object other$cube = other.getCube();
        if (this$cube == null ? other$cube != null : !this$cube.equals(other$cube)) return false;
        final java.lang.Object this$cubeDimensionName = this.getCubeDimensionName();
        final java.lang.Object other$cubeDimensionName = other.getCubeDimensionName();
        if (this$cubeDimensionName == null ? other$cubeDimensionName != null : !this$cubeDimensionName.equals(other$cubeDimensionName)) return false;
        final java.lang.Object this$cubeDimensionQualifiedName = this.getCubeDimensionQualifiedName();
        final java.lang.Object other$cubeDimensionQualifiedName = other.getCubeDimensionQualifiedName();
        if (this$cubeDimensionQualifiedName == null ? other$cubeDimensionQualifiedName != null : !this$cubeDimensionQualifiedName.equals(other$cubeDimensionQualifiedName)) return false;
        final java.lang.Object this$cubeHierarchies = this.getCubeHierarchies();
        final java.lang.Object other$cubeHierarchies = other.getCubeHierarchies();
        if (this$cubeHierarchies == null ? other$cubeHierarchies != null : !this$cubeHierarchies.equals(other$cubeHierarchies)) return false;
        final java.lang.Object this$cubeHierarchyName = this.getCubeHierarchyName();
        final java.lang.Object other$cubeHierarchyName = other.getCubeHierarchyName();
        if (this$cubeHierarchyName == null ? other$cubeHierarchyName != null : !this$cubeHierarchyName.equals(other$cubeHierarchyName)) return false;
        final java.lang.Object this$cubeHierarchyQualifiedName = this.getCubeHierarchyQualifiedName();
        final java.lang.Object other$cubeHierarchyQualifiedName = other.getCubeHierarchyQualifiedName();
        if (this$cubeHierarchyQualifiedName == null ? other$cubeHierarchyQualifiedName != null : !this$cubeHierarchyQualifiedName.equals(other$cubeHierarchyQualifiedName)) return false;
        final java.lang.Object this$cubeName = this.getCubeName();
        final java.lang.Object other$cubeName = other.getCubeName();
        if (this$cubeName == null ? other$cubeName != null : !this$cubeName.equals(other$cubeName)) return false;
        final java.lang.Object this$cubeQualifiedName = this.getCubeQualifiedName();
        final java.lang.Object other$cubeQualifiedName = other.getCubeQualifiedName();
        if (this$cubeQualifiedName == null ? other$cubeQualifiedName != null : !this$cubeQualifiedName.equals(other$cubeQualifiedName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CubeDimension;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $cubeHierarchyCount = this.getCubeHierarchyCount();
        result = result * PRIME + ($cubeHierarchyCount == null ? 43 : $cubeHierarchyCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $cube = this.getCube();
        result = result * PRIME + ($cube == null ? 43 : $cube.hashCode());
        final java.lang.Object $cubeDimensionName = this.getCubeDimensionName();
        result = result * PRIME + ($cubeDimensionName == null ? 43 : $cubeDimensionName.hashCode());
        final java.lang.Object $cubeDimensionQualifiedName = this.getCubeDimensionQualifiedName();
        result = result * PRIME + ($cubeDimensionQualifiedName == null ? 43 : $cubeDimensionQualifiedName.hashCode());
        final java.lang.Object $cubeHierarchies = this.getCubeHierarchies();
        result = result * PRIME + ($cubeHierarchies == null ? 43 : $cubeHierarchies.hashCode());
        final java.lang.Object $cubeHierarchyName = this.getCubeHierarchyName();
        result = result * PRIME + ($cubeHierarchyName == null ? 43 : $cubeHierarchyName.hashCode());
        final java.lang.Object $cubeHierarchyQualifiedName = this.getCubeHierarchyQualifiedName();
        result = result * PRIME + ($cubeHierarchyQualifiedName == null ? 43 : $cubeHierarchyQualifiedName.hashCode());
        final java.lang.Object $cubeName = this.getCubeName();
        result = result * PRIME + ($cubeName == null ? 43 : $cubeName.hashCode());
        final java.lang.Object $cubeQualifiedName = this.getCubeQualifiedName();
        result = result * PRIME + ($cubeQualifiedName == null ? 43 : $cubeQualifiedName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "CubeDimension(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cube=" + this.getCube() + ", cubeDimensionName=" + this.getCubeDimensionName() + ", cubeDimensionQualifiedName=" + this.getCubeDimensionQualifiedName() + ", cubeHierarchies=" + this.getCubeHierarchies() + ", cubeHierarchyCount=" + this.getCubeHierarchyCount() + ", cubeHierarchyName=" + this.getCubeHierarchyName() + ", cubeHierarchyQualifiedName=" + this.getCubeHierarchyQualifiedName() + ", cubeName=" + this.getCubeName() + ", cubeQualifiedName=" + this.getCubeQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for CubeDimensions.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
