// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a cube field in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class CubeField extends Asset implements ICubeField, IMultiDimensionalDataset, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CubeField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CubeField";
    /**
     * Fixed typeName for CubeFields.
     */
    String typeName;
    /**
     * Simple name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
     */
    @Attribute
    String cubeDimensionName;
    /**
     * Unique name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
     */
    @Attribute
    String cubeDimensionQualifiedName;
    /**
     * Generation of the field in the cube hierarchy.
     */
    @Attribute
    Long cubeFieldGeneration;
    /**
     * Level of the field in the cube hierarchy.
     */
    @Attribute
    Long cubeFieldLevel;
    /**
     * Expression used to calculate this measure.
     */
    @Attribute
    String cubeFieldMeasureExpression;
    /**
     * Hierarchy in which this field exists.
     */
    @Attribute
    ICubeHierarchy cubeHierarchy;
    /**
     * Simple name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
     */
    @Attribute
    String cubeHierarchyName;
    /**
     * Unique name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
     */
    @Attribute
    String cubeHierarchyQualifiedName;
    /**
     * Simple name of the cube in which this asset exists, or empty if it is itself a cube.
     */
    @Attribute
    String cubeName;
    /**
     * Individual fields nested within this cube field.
     */
    @Attribute
    SortedSet<ICubeField> cubeNestedFields;
    /**
     * Parent field in which this field is nested.
     */
    @Attribute
    ICubeField cubeParentField;
    /**
     * Name of the parent field in which this field is nested.
     */
    @Attribute
    String cubeParentFieldName;
    /**
     * Unique name of the parent field in which this field is nested.
     */
    @Attribute
    String cubeParentFieldQualifiedName;
    /**
     * Unique name of the cube in which this asset exists, or empty if it is itself a cube.
     */
    @Attribute
    String cubeQualifiedName;
    /**
     * Number of sub-fields that are direct children of this field.
     */
    @Attribute
    Long cubeSubFieldCount;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a CubeField, from a potentially
     * more-complete CubeField object.
     *
     * @return the minimal object necessary to relate to the CubeField
     * @throws InvalidRequestException if any of the minimal set of required properties for a CubeField relationship are not found in the initial object
     */
    @Override
    public CubeField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all CubeField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) CubeField assets will be included.
     *
     * @return a fluent search that includes all CubeField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all CubeField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) CubeField assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all CubeField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all CubeField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) CubeFields will be included
     * @return a fluent search that includes all CubeField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all CubeField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) CubeFields will be included
     * @return a fluent search that includes all CubeField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a CubeField by GUID. Use this to create a relationship to this CubeField,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the CubeField to reference
     * @return reference to a CubeField that can be used for defining a relationship to a CubeField
     */
    public static CubeField refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a CubeField by GUID. Use this to create a relationship to this CubeField,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the CubeField to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a CubeField that can be used for defining a relationship to a CubeField
     */
    public static CubeField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return CubeField._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a CubeField by qualifiedName. Use this to create a relationship to this CubeField,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the CubeField to reference
     * @return reference to a CubeField that can be used for defining a relationship to a CubeField
     */
    public static CubeField refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a CubeField by qualifiedName. Use this to create a relationship to this CubeField,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the CubeField to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a CubeField that can be used for defining a relationship to a CubeField
     */
    public static CubeField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return CubeField._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a CubeField by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the CubeField to retrieve, either its GUID or its full qualifiedName
     * @return the requested full CubeField, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CubeField does not exist or the provided GUID is not a CubeField
     */
    @JsonIgnore
    public static CubeField get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a CubeField by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the CubeField to retrieve, either its GUID or its full qualifiedName
     * @return the requested full CubeField, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CubeField does not exist or the provided GUID is not a CubeField
     */
    @JsonIgnore
    public static CubeField get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a CubeField by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the CubeField to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full CubeField, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the CubeField does not exist or the provided GUID is not a CubeField
     */
    @JsonIgnore
    public static CubeField get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof CubeField) {
                return (CubeField) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof CubeField) {
                return (CubeField) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) CubeField to active.
     *
     * @param qualifiedName for the CubeField
     * @return true if the CubeField is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) CubeField to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the CubeField
     * @return true if the CubeField is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a top-level CubeField.
     *
     * @param name of the CubeField
     * @param hierarchy in which the field should be created, which must have at least a qualifiedName
     * @return the minimal request necessary to create the CubeField, as a builder
     * @throws InvalidRequestException if the hierarchy provided is without a qualifiedName
     */
    public static CubeFieldBuilder<?, ?> creator(String name, CubeHierarchy hierarchy) throws InvalidRequestException {
        validateRelationship(CubeHierarchy.TYPE_NAME, Map.of("connectionQualifiedName", hierarchy.getConnectionQualifiedName(), "cubeName", hierarchy.getCubeName(), "cubeQualifiedName", hierarchy.getCubeQualifiedName(), "cubeDimensionName", hierarchy.getCubeDimensionName(), "cubeDimensionQualifiedName", hierarchy.getCubeDimensionQualifiedName(), "name", hierarchy.getName(), "qualifiedName", hierarchy.getQualifiedName()));
        return creator(name, hierarchy.getConnectionQualifiedName(), hierarchy.getCubeName(), hierarchy.getCubeQualifiedName(), hierarchy.getCubeDimensionName(), hierarchy.getCubeDimensionQualifiedName(), hierarchy.getName(), hierarchy.getQualifiedName(), null, null).cubeHierarchy(hierarchy.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a nested CubeField.
     *
     * @param name of the CubeField
     * @param parentField in which the field should be created, which must have at least a qualifiedName
     * @return the minimal request necessary to create the CubeField, as a builder
     * @throws InvalidRequestException if the parent field provided is without a qualifiedName
     */
    public static CubeFieldBuilder<?, ?> creator(String name, CubeField parentField) throws InvalidRequestException {
        validateRelationship(CubeField.TYPE_NAME, Map.of("connectionQualifiedName", parentField.getConnectionQualifiedName(), "cubeName", parentField.getCubeName(), "cubeQualifiedName", parentField.getCubeQualifiedName(), "cubeDimensionName", parentField.getCubeDimensionName(), "cubeDimensionQualifiedName", parentField.getCubeDimensionQualifiedName(), "cubeHierarchyName", parentField.getCubeHierarchyName(), "cubeHierarchyQualifiedName", parentField.getCubeHierarchyQualifiedName(), "name", parentField.getName(), "qualifiedName", parentField.getQualifiedName()));
        return creator(name, parentField.getConnectionQualifiedName(), parentField.getCubeName(), parentField.getCubeQualifiedName(), parentField.getCubeDimensionName(), parentField.getCubeDimensionQualifiedName(), parentField.getCubeHierarchyName(), parentField.getCubeHierarchyQualifiedName(), parentField.getName(), parentField.getQualifiedName()).cubeParentField(parentField.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a CubeField.
     *
     * @param name of the CubeField
     * @param parentQualifiedName unique name of the parent of the CubeField (either of its hierarchy or parent field)
     * @return the minimal request necessary to create the CubeField, as a builder
     */
    public static CubeFieldBuilder<?, ?> creator(String name, String parentQualifiedName) {
        String parentFieldName = null;
        String parentFieldQualifiedName = null;
        String hierarchyQualifiedName = getHierarchyQualifiedName(parentQualifiedName);
        if (!hierarchyQualifiedName.equals(parentQualifiedName)) {
            parentFieldQualifiedName = parentQualifiedName;
            String parentSlug = StringUtils.getNameFromQualifiedName(parentQualifiedName);
            parentFieldName = IMultiDimensionalDataset.getNameFromSlug(parentSlug);
        }
        String hierarchySlug = StringUtils.getNameFromQualifiedName(hierarchyQualifiedName);
        String hierarchyName = IMultiDimensionalDataset.getNameFromSlug(hierarchySlug);
        String dimensionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(hierarchyQualifiedName);
        String dimensionSlug = StringUtils.getNameFromQualifiedName(dimensionQualifiedName);
        String dimensionName = IMultiDimensionalDataset.getNameFromSlug(dimensionSlug);
        String cubeQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(dimensionQualifiedName);
        String cubeSlug = StringUtils.getNameFromQualifiedName(cubeQualifiedName);
        String cubeName = IMultiDimensionalDataset.getNameFromSlug(cubeSlug);
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(cubeQualifiedName);
        return creator(name, connectionQualifiedName, cubeName, cubeQualifiedName, dimensionName, dimensionQualifiedName, hierarchyName, hierarchyQualifiedName, parentFieldName, parentFieldQualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a CubeField.
     *
     * @param name of the CubeField
     * @param connectionQualifiedName unique name of the connection in which the CubeField should be created
     * @param cubeName simple name of the Cube in which the CubeField should be created
     * @param cubeQualifiedName unique name of the Cube in which the CubeField should be created
     * @param dimensionName simple name of the CubeDimension in which the CubeField should be created
     * @param dimensionQualifiedName unique name of the CubeDimension in which the CubeField should be created
     * @param hierarchyName simple name of the CubeHierarchy in which the CubeField should be created
     * @param hierarchyQualifiedName unique name of the CubeHierarchy in which the CubeField should be created
     * @param parentFieldName simple name of the CubeField in which the CubeField should be nested
     * @param parentFieldQualifiedName unique name of the CubeField in which the CubeField should be nested
     * @return the minimal request necessary to create the CubeField, as a builder
     */
    public static CubeFieldBuilder<?, ?> creator(String name, String connectionQualifiedName, String cubeName, String cubeQualifiedName, String dimensionName, String dimensionQualifiedName, String hierarchyName, String hierarchyQualifiedName, String parentFieldName, String parentFieldQualifiedName) {
        CubeFieldBuilder<?, ?> builder = CubeField._internal().name(name);
        if (parentFieldName != null && parentFieldQualifiedName != null) {
            builder.cubeParentField(CubeField.refByQualifiedName(parentFieldQualifiedName)).cubeParentFieldName(parentFieldName).cubeParentFieldQualifiedName(parentFieldQualifiedName).qualifiedName(generateQualifiedName(name, parentFieldQualifiedName));
        } else {
            builder.qualifiedName(generateQualifiedName(name, hierarchyQualifiedName));
        }
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return builder.guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).cubeName(cubeName).cubeQualifiedName(cubeQualifiedName).cubeDimensionName(dimensionName).cubeDimensionQualifiedName(dimensionQualifiedName).cubeHierarchyName(hierarchyName).cubeHierarchyQualifiedName(hierarchyQualifiedName).cubeHierarchy(CubeHierarchy.refByQualifiedName(hierarchyQualifiedName)).connectorType(connectorType).connectionQualifiedName(connectionQualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a CubeField.
     *
     * @param qualifiedName of the CubeField
     * @param name of the CubeField
     * @return the minimal request necessary to update the CubeField, as a builder
     */
    public static CubeFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return CubeField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Extracts the unique name of the hierarchy from the qualified name of the CubeField's parent.
     *
     * @param parentQualifiedName unique name of the hierarchy or parent field in which this CubeField exists
     * @return the unique name of the CubeHierarchy in which the field exists
     */
    public static String getHierarchyQualifiedName(String parentQualifiedName) {
        if (parentQualifiedName != null) {
            List<String> tokens = Arrays.stream(parentQualifiedName.split("/")).collect(Collectors.toList());
            return String.join("/", tokens.subList(0, 6));
        }
        return null;
    }

    /**
     * Generate a unique CubeField name.
     *
     * @param name of the CubeField
     * @param parentQualifiedName unique name of the hierarchy or parent field in which this CubeField exists
     * @return a unique name for the CubeField
     */
    public static String generateQualifiedName(String name, String parentQualifiedName) {
        return parentQualifiedName + "/" + IMultiDimensionalDataset.getSlugForName(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a CubeField, from a potentially
     * more-complete CubeField object.
     *
     * @return the minimal object necessary to update the CubeField, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for CubeField are not found in the initial object
     */
    @Override
    public CubeFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a CubeField.
     *
     * @param qualifiedName of the CubeField
     * @param name of the CubeField
     * @return the updated CubeField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeField removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a CubeField.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the CubeField
     * @param name of the CubeField
     * @return the updated CubeField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeField) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a CubeField.
     *
     * @param qualifiedName of the CubeField
     * @param name of the CubeField
     * @return the updated CubeField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a CubeField.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the CubeField
     * @param name of the CubeField
     * @return the updated CubeField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeField) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a CubeField.
     *
     * @param qualifiedName of the CubeField
     * @param name of the CubeField
     * @return the updated CubeField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeField removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a CubeField.
     *
     * @param client connectivity to the Atlan tenant from which to remove the CubeField's owners
     * @param qualifiedName of the CubeField
     * @param name of the CubeField
     * @return the updated CubeField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeField) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a CubeField.
     *
     * @param qualifiedName of the CubeField
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated CubeField, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CubeField updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a CubeField.
     *
     * @param client connectivity to the Atlan tenant on which to update the CubeField's certificate
     * @param qualifiedName of the CubeField
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated CubeField, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CubeField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CubeField) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a CubeField.
     *
     * @param qualifiedName of the CubeField
     * @param name of the CubeField
     * @return the updated CubeField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a CubeField.
     *
     * @param client connectivity to the Atlan tenant from which to remove the CubeField's certificate
     * @param qualifiedName of the CubeField
     * @param name of the CubeField
     * @return the updated CubeField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeField) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a CubeField.
     *
     * @param qualifiedName of the CubeField
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CubeField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a CubeField.
     *
     * @param client connectivity to the Atlan tenant on which to update the CubeField's announcement
     * @param qualifiedName of the CubeField
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static CubeField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CubeField) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a CubeField.
     *
     * @param qualifiedName of the CubeField
     * @param name of the CubeField
     * @return the updated CubeField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a CubeField.
     *
     * @param client connectivity to the Atlan client from which to remove the CubeField's announcement
     * @param qualifiedName of the CubeField
     * @param name of the CubeField
     * @return the updated CubeField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static CubeField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeField) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the CubeField.
     *
     * @param qualifiedName for the CubeField
     * @param name human-readable name of the CubeField
     * @param terms the list of terms to replace on the CubeField, or null to remove all terms from the CubeField
     * @return the CubeField that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static CubeField replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the CubeField.
     *
     * @param client connectivity to the Atlan tenant on which to replace the CubeField's assigned terms
     * @param qualifiedName for the CubeField
     * @param name human-readable name of the CubeField
     * @param terms the list of terms to replace on the CubeField, or null to remove all terms from the CubeField
     * @return the CubeField that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static CubeField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CubeField) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the CubeField, without replacing existing terms linked to the CubeField.
     * Note: this operation must make two API calls — one to retrieve the CubeField's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the CubeField
     * @param terms the list of terms to append to the CubeField
     * @return the CubeField that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static CubeField appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the CubeField, without replacing existing terms linked to the CubeField.
     * Note: this operation must make two API calls — one to retrieve the CubeField's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the CubeField
     * @param qualifiedName for the CubeField
     * @param terms the list of terms to append to the CubeField
     * @return the CubeField that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static CubeField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CubeField) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a CubeField, without replacing all existing terms linked to the CubeField.
     * Note: this operation must make two API calls — one to retrieve the CubeField's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the CubeField
     * @param terms the list of terms to remove from the CubeField, which must be referenced by GUID
     * @return the CubeField that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static CubeField removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a CubeField, without replacing all existing terms linked to the CubeField.
     * Note: this operation must make two API calls — one to retrieve the CubeField's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the CubeField
     * @param qualifiedName for the CubeField
     * @param terms the list of terms to remove from the CubeField, which must be referenced by GUID
     * @return the CubeField that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static CubeField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CubeField) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a CubeField, without replacing existing Atlan tags linked to the CubeField.
     * Note: this operation must make two API calls — one to retrieve the CubeField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the CubeField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated CubeField
     */
    public static CubeField appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a CubeField, without replacing existing Atlan tags linked to the CubeField.
     * Note: this operation must make two API calls — one to retrieve the CubeField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the CubeField
     * @param qualifiedName of the CubeField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated CubeField
     */
    public static CubeField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CubeField) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a CubeField, without replacing existing Atlan tags linked to the CubeField.
     * Note: this operation must make two API calls — one to retrieve the CubeField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the CubeField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated CubeField
     */
    public static CubeField appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a CubeField, without replacing existing Atlan tags linked to the CubeField.
     * Note: this operation must make two API calls — one to retrieve the CubeField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the CubeField
     * @param qualifiedName of the CubeField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated CubeField
     */
    public static CubeField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CubeField) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a CubeField.
     *
     * @param qualifiedName of the CubeField
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the CubeField
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a CubeField.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a CubeField
     * @param qualifiedName of the CubeField
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the CubeField
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class CubeFieldBuilder<C extends CubeField, B extends CubeField.CubeFieldBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeDimensionName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeDimensionQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long cubeFieldGeneration;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long cubeFieldLevel;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeFieldMeasureExpression;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ICubeHierarchy cubeHierarchy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeHierarchyName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeHierarchyQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICubeField> cubeNestedFields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ICubeField cubeParentField;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeParentFieldName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeParentFieldQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String cubeQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long cubeSubFieldCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            CubeField.CubeFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final CubeField instance, final CubeField.CubeFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cubeDimensionName(instance.cubeDimensionName);
            b.cubeDimensionQualifiedName(instance.cubeDimensionQualifiedName);
            b.cubeFieldGeneration(instance.cubeFieldGeneration);
            b.cubeFieldLevel(instance.cubeFieldLevel);
            b.cubeFieldMeasureExpression(instance.cubeFieldMeasureExpression);
            b.cubeHierarchy(instance.cubeHierarchy);
            b.cubeHierarchyName(instance.cubeHierarchyName);
            b.cubeHierarchyQualifiedName(instance.cubeHierarchyQualifiedName);
            b.cubeName(instance.cubeName);
            b.cubeNestedFields(instance.cubeNestedFields == null ? java.util.Collections.<ICubeField>emptySortedSet() : instance.cubeNestedFields);
            b.cubeParentField(instance.cubeParentField);
            b.cubeParentFieldName(instance.cubeParentFieldName);
            b.cubeParentFieldQualifiedName(instance.cubeParentFieldQualifiedName);
            b.cubeQualifiedName(instance.cubeQualifiedName);
            b.cubeSubFieldCount(instance.cubeSubFieldCount);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for CubeFields.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Simple name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeDimensionName(final String cubeDimensionName) {
            this.cubeDimensionName = cubeDimensionName;
            return self();
        }

        /**
         * Unique name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeDimensionQualifiedName(final String cubeDimensionQualifiedName) {
            this.cubeDimensionQualifiedName = cubeDimensionQualifiedName;
            return self();
        }

        /**
         * Generation of the field in the cube hierarchy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeFieldGeneration(final Long cubeFieldGeneration) {
            this.cubeFieldGeneration = cubeFieldGeneration;
            return self();
        }

        /**
         * Level of the field in the cube hierarchy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeFieldLevel(final Long cubeFieldLevel) {
            this.cubeFieldLevel = cubeFieldLevel;
            return self();
        }

        /**
         * Expression used to calculate this measure.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeFieldMeasureExpression(final String cubeFieldMeasureExpression) {
            this.cubeFieldMeasureExpression = cubeFieldMeasureExpression;
            return self();
        }

        /**
         * Hierarchy in which this field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeHierarchy(final ICubeHierarchy cubeHierarchy) {
            this.cubeHierarchy = cubeHierarchy;
            return self();
        }

        /**
         * Simple name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeHierarchyName(final String cubeHierarchyName) {
            this.cubeHierarchyName = cubeHierarchyName;
            return self();
        }

        /**
         * Unique name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeHierarchyQualifiedName(final String cubeHierarchyQualifiedName) {
            this.cubeHierarchyQualifiedName = cubeHierarchyQualifiedName;
            return self();
        }

        /**
         * Simple name of the cube in which this asset exists, or empty if it is itself a cube.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeName(final String cubeName) {
            this.cubeName = cubeName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeNestedField(final ICubeField cubeNestedField) {
            if (this.cubeNestedFields == null) this.cubeNestedFields = new java.util.ArrayList<ICubeField>();
            this.cubeNestedFields.add(cubeNestedField);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeNestedFields(final java.util.Collection<? extends ICubeField> cubeNestedFields) {
            if (cubeNestedFields == null) {
                throw new java.lang.NullPointerException("cubeNestedFields cannot be null");
            }
            if (this.cubeNestedFields == null) this.cubeNestedFields = new java.util.ArrayList<ICubeField>();
            this.cubeNestedFields.addAll(cubeNestedFields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCubeNestedFields() {
            if (this.cubeNestedFields != null) this.cubeNestedFields.clear();
            return self();
        }

        /**
         * Parent field in which this field is nested.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeParentField(final ICubeField cubeParentField) {
            this.cubeParentField = cubeParentField;
            return self();
        }

        /**
         * Name of the parent field in which this field is nested.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeParentFieldName(final String cubeParentFieldName) {
            this.cubeParentFieldName = cubeParentFieldName;
            return self();
        }

        /**
         * Unique name of the parent field in which this field is nested.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeParentFieldQualifiedName(final String cubeParentFieldQualifiedName) {
            this.cubeParentFieldQualifiedName = cubeParentFieldQualifiedName;
            return self();
        }

        /**
         * Unique name of the cube in which this asset exists, or empty if it is itself a cube.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeQualifiedName(final String cubeQualifiedName) {
            this.cubeQualifiedName = cubeQualifiedName;
            return self();
        }

        /**
         * Number of sub-fields that are direct children of this field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cubeSubFieldCount(final Long cubeSubFieldCount) {
            this.cubeSubFieldCount = cubeSubFieldCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "CubeField.CubeFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cubeDimensionName=" + this.cubeDimensionName + ", cubeDimensionQualifiedName=" + this.cubeDimensionQualifiedName + ", cubeFieldGeneration=" + this.cubeFieldGeneration + ", cubeFieldLevel=" + this.cubeFieldLevel + ", cubeFieldMeasureExpression=" + this.cubeFieldMeasureExpression + ", cubeHierarchy=" + this.cubeHierarchy + ", cubeHierarchyName=" + this.cubeHierarchyName + ", cubeHierarchyQualifiedName=" + this.cubeHierarchyQualifiedName + ", cubeName=" + this.cubeName + ", cubeNestedFields=" + this.cubeNestedFields + ", cubeParentField=" + this.cubeParentField + ", cubeParentFieldName=" + this.cubeParentFieldName + ", cubeParentFieldQualifiedName=" + this.cubeParentFieldQualifiedName + ", cubeQualifiedName=" + this.cubeQualifiedName + ", cubeSubFieldCount=" + this.cubeSubFieldCount + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class CubeFieldBuilderImpl extends CubeField.CubeFieldBuilder<CubeField, CubeField.CubeFieldBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CubeFieldBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected CubeField.CubeFieldBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CubeField build() {
            return new CubeField(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected CubeField(final CubeField.CubeFieldBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = CubeField.$default$typeName();
        this.cubeDimensionName = b.cubeDimensionName;
        this.cubeDimensionQualifiedName = b.cubeDimensionQualifiedName;
        this.cubeFieldGeneration = b.cubeFieldGeneration;
        this.cubeFieldLevel = b.cubeFieldLevel;
        this.cubeFieldMeasureExpression = b.cubeFieldMeasureExpression;
        this.cubeHierarchy = b.cubeHierarchy;
        this.cubeHierarchyName = b.cubeHierarchyName;
        this.cubeHierarchyQualifiedName = b.cubeHierarchyQualifiedName;
        this.cubeName = b.cubeName;
        java.util.SortedSet<ICubeField> cubeNestedFields = new java.util.TreeSet<ICubeField>();
        if (b.cubeNestedFields != null) cubeNestedFields.addAll(b.cubeNestedFields);
        cubeNestedFields = java.util.Collections.unmodifiableSortedSet(cubeNestedFields);
        this.cubeNestedFields = cubeNestedFields;
        this.cubeParentField = b.cubeParentField;
        this.cubeParentFieldName = b.cubeParentFieldName;
        this.cubeParentFieldQualifiedName = b.cubeParentFieldQualifiedName;
        this.cubeQualifiedName = b.cubeQualifiedName;
        this.cubeSubFieldCount = b.cubeSubFieldCount;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static CubeField.CubeFieldBuilder<?, ?> _internal() {
        return new CubeField.CubeFieldBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CubeField.CubeFieldBuilder<?, ?> toBuilder() {
        return new CubeField.CubeFieldBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Simple name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeDimensionName() {
        return this.cubeDimensionName;
    }

    /**
     * Unique name of the cube dimension in which this asset exists, or empty if it is itself a dimension.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeDimensionQualifiedName() {
        return this.cubeDimensionQualifiedName;
    }

    /**
     * Generation of the field in the cube hierarchy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCubeFieldGeneration() {
        return this.cubeFieldGeneration;
    }

    /**
     * Level of the field in the cube hierarchy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCubeFieldLevel() {
        return this.cubeFieldLevel;
    }

    /**
     * Expression used to calculate this measure.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeFieldMeasureExpression() {
        return this.cubeFieldMeasureExpression;
    }

    /**
     * Hierarchy in which this field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ICubeHierarchy getCubeHierarchy() {
        return this.cubeHierarchy;
    }

    /**
     * Simple name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeHierarchyName() {
        return this.cubeHierarchyName;
    }

    /**
     * Unique name of the dimension hierarchy in which this asset exists, or empty if it is itself a hierarchy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeHierarchyQualifiedName() {
        return this.cubeHierarchyQualifiedName;
    }

    /**
     * Simple name of the cube in which this asset exists, or empty if it is itself a cube.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeName() {
        return this.cubeName;
    }

    /**
     * Individual fields nested within this cube field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICubeField> getCubeNestedFields() {
        return this.cubeNestedFields;
    }

    /**
     * Parent field in which this field is nested.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ICubeField getCubeParentField() {
        return this.cubeParentField;
    }

    /**
     * Name of the parent field in which this field is nested.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeParentFieldName() {
        return this.cubeParentFieldName;
    }

    /**
     * Unique name of the parent field in which this field is nested.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeParentFieldQualifiedName() {
        return this.cubeParentFieldQualifiedName;
    }

    /**
     * Unique name of the cube in which this asset exists, or empty if it is itself a cube.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCubeQualifiedName() {
        return this.cubeQualifiedName;
    }

    /**
     * Number of sub-fields that are direct children of this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCubeSubFieldCount() {
        return this.cubeSubFieldCount;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CubeField)) return false;
        final CubeField other = (CubeField) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$cubeFieldGeneration = this.getCubeFieldGeneration();
        final java.lang.Object other$cubeFieldGeneration = other.getCubeFieldGeneration();
        if (this$cubeFieldGeneration == null ? other$cubeFieldGeneration != null : !this$cubeFieldGeneration.equals(other$cubeFieldGeneration)) return false;
        final java.lang.Object this$cubeFieldLevel = this.getCubeFieldLevel();
        final java.lang.Object other$cubeFieldLevel = other.getCubeFieldLevel();
        if (this$cubeFieldLevel == null ? other$cubeFieldLevel != null : !this$cubeFieldLevel.equals(other$cubeFieldLevel)) return false;
        final java.lang.Object this$cubeSubFieldCount = this.getCubeSubFieldCount();
        final java.lang.Object other$cubeSubFieldCount = other.getCubeSubFieldCount();
        if (this$cubeSubFieldCount == null ? other$cubeSubFieldCount != null : !this$cubeSubFieldCount.equals(other$cubeSubFieldCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$cubeDimensionName = this.getCubeDimensionName();
        final java.lang.Object other$cubeDimensionName = other.getCubeDimensionName();
        if (this$cubeDimensionName == null ? other$cubeDimensionName != null : !this$cubeDimensionName.equals(other$cubeDimensionName)) return false;
        final java.lang.Object this$cubeDimensionQualifiedName = this.getCubeDimensionQualifiedName();
        final java.lang.Object other$cubeDimensionQualifiedName = other.getCubeDimensionQualifiedName();
        if (this$cubeDimensionQualifiedName == null ? other$cubeDimensionQualifiedName != null : !this$cubeDimensionQualifiedName.equals(other$cubeDimensionQualifiedName)) return false;
        final java.lang.Object this$cubeFieldMeasureExpression = this.getCubeFieldMeasureExpression();
        final java.lang.Object other$cubeFieldMeasureExpression = other.getCubeFieldMeasureExpression();
        if (this$cubeFieldMeasureExpression == null ? other$cubeFieldMeasureExpression != null : !this$cubeFieldMeasureExpression.equals(other$cubeFieldMeasureExpression)) return false;
        final java.lang.Object this$cubeHierarchy = this.getCubeHierarchy();
        final java.lang.Object other$cubeHierarchy = other.getCubeHierarchy();
        if (this$cubeHierarchy == null ? other$cubeHierarchy != null : !this$cubeHierarchy.equals(other$cubeHierarchy)) return false;
        final java.lang.Object this$cubeHierarchyName = this.getCubeHierarchyName();
        final java.lang.Object other$cubeHierarchyName = other.getCubeHierarchyName();
        if (this$cubeHierarchyName == null ? other$cubeHierarchyName != null : !this$cubeHierarchyName.equals(other$cubeHierarchyName)) return false;
        final java.lang.Object this$cubeHierarchyQualifiedName = this.getCubeHierarchyQualifiedName();
        final java.lang.Object other$cubeHierarchyQualifiedName = other.getCubeHierarchyQualifiedName();
        if (this$cubeHierarchyQualifiedName == null ? other$cubeHierarchyQualifiedName != null : !this$cubeHierarchyQualifiedName.equals(other$cubeHierarchyQualifiedName)) return false;
        final java.lang.Object this$cubeName = this.getCubeName();
        final java.lang.Object other$cubeName = other.getCubeName();
        if (this$cubeName == null ? other$cubeName != null : !this$cubeName.equals(other$cubeName)) return false;
        final java.lang.Object this$cubeNestedFields = this.getCubeNestedFields();
        final java.lang.Object other$cubeNestedFields = other.getCubeNestedFields();
        if (this$cubeNestedFields == null ? other$cubeNestedFields != null : !this$cubeNestedFields.equals(other$cubeNestedFields)) return false;
        final java.lang.Object this$cubeParentField = this.getCubeParentField();
        final java.lang.Object other$cubeParentField = other.getCubeParentField();
        if (this$cubeParentField == null ? other$cubeParentField != null : !this$cubeParentField.equals(other$cubeParentField)) return false;
        final java.lang.Object this$cubeParentFieldName = this.getCubeParentFieldName();
        final java.lang.Object other$cubeParentFieldName = other.getCubeParentFieldName();
        if (this$cubeParentFieldName == null ? other$cubeParentFieldName != null : !this$cubeParentFieldName.equals(other$cubeParentFieldName)) return false;
        final java.lang.Object this$cubeParentFieldQualifiedName = this.getCubeParentFieldQualifiedName();
        final java.lang.Object other$cubeParentFieldQualifiedName = other.getCubeParentFieldQualifiedName();
        if (this$cubeParentFieldQualifiedName == null ? other$cubeParentFieldQualifiedName != null : !this$cubeParentFieldQualifiedName.equals(other$cubeParentFieldQualifiedName)) return false;
        final java.lang.Object this$cubeQualifiedName = this.getCubeQualifiedName();
        final java.lang.Object other$cubeQualifiedName = other.getCubeQualifiedName();
        if (this$cubeQualifiedName == null ? other$cubeQualifiedName != null : !this$cubeQualifiedName.equals(other$cubeQualifiedName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CubeField;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $cubeFieldGeneration = this.getCubeFieldGeneration();
        result = result * PRIME + ($cubeFieldGeneration == null ? 43 : $cubeFieldGeneration.hashCode());
        final java.lang.Object $cubeFieldLevel = this.getCubeFieldLevel();
        result = result * PRIME + ($cubeFieldLevel == null ? 43 : $cubeFieldLevel.hashCode());
        final java.lang.Object $cubeSubFieldCount = this.getCubeSubFieldCount();
        result = result * PRIME + ($cubeSubFieldCount == null ? 43 : $cubeSubFieldCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $cubeDimensionName = this.getCubeDimensionName();
        result = result * PRIME + ($cubeDimensionName == null ? 43 : $cubeDimensionName.hashCode());
        final java.lang.Object $cubeDimensionQualifiedName = this.getCubeDimensionQualifiedName();
        result = result * PRIME + ($cubeDimensionQualifiedName == null ? 43 : $cubeDimensionQualifiedName.hashCode());
        final java.lang.Object $cubeFieldMeasureExpression = this.getCubeFieldMeasureExpression();
        result = result * PRIME + ($cubeFieldMeasureExpression == null ? 43 : $cubeFieldMeasureExpression.hashCode());
        final java.lang.Object $cubeHierarchy = this.getCubeHierarchy();
        result = result * PRIME + ($cubeHierarchy == null ? 43 : $cubeHierarchy.hashCode());
        final java.lang.Object $cubeHierarchyName = this.getCubeHierarchyName();
        result = result * PRIME + ($cubeHierarchyName == null ? 43 : $cubeHierarchyName.hashCode());
        final java.lang.Object $cubeHierarchyQualifiedName = this.getCubeHierarchyQualifiedName();
        result = result * PRIME + ($cubeHierarchyQualifiedName == null ? 43 : $cubeHierarchyQualifiedName.hashCode());
        final java.lang.Object $cubeName = this.getCubeName();
        result = result * PRIME + ($cubeName == null ? 43 : $cubeName.hashCode());
        final java.lang.Object $cubeNestedFields = this.getCubeNestedFields();
        result = result * PRIME + ($cubeNestedFields == null ? 43 : $cubeNestedFields.hashCode());
        final java.lang.Object $cubeParentField = this.getCubeParentField();
        result = result * PRIME + ($cubeParentField == null ? 43 : $cubeParentField.hashCode());
        final java.lang.Object $cubeParentFieldName = this.getCubeParentFieldName();
        result = result * PRIME + ($cubeParentFieldName == null ? 43 : $cubeParentFieldName.hashCode());
        final java.lang.Object $cubeParentFieldQualifiedName = this.getCubeParentFieldQualifiedName();
        result = result * PRIME + ($cubeParentFieldQualifiedName == null ? 43 : $cubeParentFieldQualifiedName.hashCode());
        final java.lang.Object $cubeQualifiedName = this.getCubeQualifiedName();
        result = result * PRIME + ($cubeQualifiedName == null ? 43 : $cubeQualifiedName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "CubeField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cubeDimensionName=" + this.getCubeDimensionName() + ", cubeDimensionQualifiedName=" + this.getCubeDimensionQualifiedName() + ", cubeFieldGeneration=" + this.getCubeFieldGeneration() + ", cubeFieldLevel=" + this.getCubeFieldLevel() + ", cubeFieldMeasureExpression=" + this.getCubeFieldMeasureExpression() + ", cubeHierarchy=" + this.getCubeHierarchy() + ", cubeHierarchyName=" + this.getCubeHierarchyName() + ", cubeHierarchyQualifiedName=" + this.getCubeHierarchyQualifiedName() + ", cubeName=" + this.getCubeName() + ", cubeNestedFields=" + this.getCubeNestedFields() + ", cubeParentField=" + this.getCubeParentField() + ", cubeParentFieldName=" + this.getCubeParentFieldName() + ", cubeParentFieldQualifiedName=" + this.getCubeParentFieldQualifiedName() + ", cubeQualifiedName=" + this.getCubeQualifiedName() + ", cubeSubFieldCount=" + this.getCubeSubFieldCount() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for CubeFields.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
