// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.DMCardinalityType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a data entity association in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class DMEntityAssociation extends Asset implements IDMEntityAssociation, IDM, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(DMEntityAssociation.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DMEntityAssociation";
    /**
     * Fixed typeName for DMEntityAssociations.
     */
    String typeName;
    /**
     * Business date for the asset.
     */
    @Attribute
    @Date
    Long dmBusinessDate;
    /**
     * Cardinality of the data entity association.
     */
    @Attribute
    DMCardinalityType dmCardinality;
    /**
     * A domain of the data model in which this asset exists.
     */
    @Attribute
    String dmDataModelDomain;
    /**
     * Simple name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @Attribute
    String dmDataModelName;
    /**
     * A namespace of the data model in which this asset exists.
     */
    @Attribute
    String dmDataModelNamespace;
    /**
     * Unique name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @Attribute
    String dmDataModelQualifiedName;
    /**
     * Entity from which this association is related.
     */
    @Attribute
    IDMEntity dmEntityFrom;
    /**
     * Unique name of the association from this entity is related.
     */
    @Attribute
    String dmEntityFromQualifiedName;
    /**
     * Simple name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @Attribute
    String dmEntityName;
    /**
     * Unique name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @Attribute
    String dmEntityQualifiedName;
    /**
     * Entity to which this association is related.
     */
    @Attribute
    IDMEntity dmEntityTo;
    /**
     * Unique name of the association to which this entity is related.
     */
    @Attribute
    String dmEntityToQualifiedName;
    /**
     * Business expiration date for the asset.
     */
    @Attribute
    @Date
    Long dmExpiredAtBusinessDate;
    /**
     * System expiration date for the asset.
     */
    @Attribute
    @Date
    Long dmExpiredAtSystemDate;
    /**
     * Label of the data entity association.
     */
    @Attribute
    String dmLabel;
    /**
     * System date for the asset.
     */
    @Attribute
    @Date
    Long dmSystemDate;
    /**
     * Simple name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @Attribute
    String dmVersionName;
    /**
     * Unique name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @Attribute
    String dmVersionQualifiedName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a DMEntityAssociation, from a potentially
     * more-complete DMEntityAssociation object.
     *
     * @return the minimal object necessary to relate to the DMEntityAssociation
     * @throws InvalidRequestException if any of the minimal set of required properties for a DMEntityAssociation relationship are not found in the initial object
     */
    @Override
    public DMEntityAssociation trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all DMEntityAssociation assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DMEntityAssociation assets will be included.
     *
     * @return a fluent search that includes all DMEntityAssociation assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all DMEntityAssociation assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DMEntityAssociation assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all DMEntityAssociation assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all DMEntityAssociation assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) DMEntityAssociations will be included
     * @return a fluent search that includes all DMEntityAssociation assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all DMEntityAssociation assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) DMEntityAssociations will be included
     * @return a fluent search that includes all DMEntityAssociation assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a DMEntityAssociation by GUID. Use this to create a relationship to this DMEntityAssociation,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the DMEntityAssociation to reference
     * @return reference to a DMEntityAssociation that can be used for defining a relationship to a DMEntityAssociation
     */
    public static DMEntityAssociation refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DMEntityAssociation by GUID. Use this to create a relationship to this DMEntityAssociation,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the DMEntityAssociation to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DMEntityAssociation that can be used for defining a relationship to a DMEntityAssociation
     */
    public static DMEntityAssociation refByGuid(String guid, Reference.SaveSemantic semantic) {
        return DMEntityAssociation._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a DMEntityAssociation by qualifiedName. Use this to create a relationship to this DMEntityAssociation,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the DMEntityAssociation to reference
     * @return reference to a DMEntityAssociation that can be used for defining a relationship to a DMEntityAssociation
     */
    public static DMEntityAssociation refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DMEntityAssociation by qualifiedName. Use this to create a relationship to this DMEntityAssociation,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the DMEntityAssociation to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DMEntityAssociation that can be used for defining a relationship to a DMEntityAssociation
     */
    public static DMEntityAssociation refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return DMEntityAssociation._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a DMEntityAssociation by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the DMEntityAssociation to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DMEntityAssociation, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DMEntityAssociation does not exist or the provided GUID is not a DMEntityAssociation
     */
    @JsonIgnore
    public static DMEntityAssociation get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a DMEntityAssociation by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DMEntityAssociation to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DMEntityAssociation, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DMEntityAssociation does not exist or the provided GUID is not a DMEntityAssociation
     */
    @JsonIgnore
    public static DMEntityAssociation get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a DMEntityAssociation by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DMEntityAssociation to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full DMEntityAssociation, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DMEntityAssociation does not exist or the provided GUID is not a DMEntityAssociation
     */
    @JsonIgnore
    public static DMEntityAssociation get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof DMEntityAssociation) {
                return (DMEntityAssociation) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof DMEntityAssociation) {
                return (DMEntityAssociation) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) DMEntityAssociation to active.
     *
     * @param qualifiedName for the DMEntityAssociation
     * @return true if the DMEntityAssociation is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) DMEntityAssociation to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the DMEntityAssociation
     * @return true if the DMEntityAssociation is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a DMEntityAssociation.
     *
     * @param qualifiedName of the DMEntityAssociation
     * @param name of the DMEntityAssociation
     * @return the minimal request necessary to update the DMEntityAssociation, as a builder
     */
    public static DMEntityAssociationBuilder<?, ?> updater(String qualifiedName, String name) {
        return DMEntityAssociation._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a DMEntityAssociation, from a potentially
     * more-complete DMEntityAssociation object.
     *
     * @return the minimal object necessary to update the DMEntityAssociation, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for DMEntityAssociation are not found in the initial object
     */
    @Override
    public DMEntityAssociationBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a DMEntityAssociation.
     *
     * @param qualifiedName of the DMEntityAssociation
     * @param name of the DMEntityAssociation
     * @return the updated DMEntityAssociation, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a DMEntityAssociation.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DMEntityAssociation
     * @param name of the DMEntityAssociation
     * @return the updated DMEntityAssociation, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMEntityAssociation) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a DMEntityAssociation.
     *
     * @param qualifiedName of the DMEntityAssociation
     * @param name of the DMEntityAssociation
     * @return the updated DMEntityAssociation, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a DMEntityAssociation.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DMEntityAssociation
     * @param name of the DMEntityAssociation
     * @return the updated DMEntityAssociation, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMEntityAssociation) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a DMEntityAssociation.
     *
     * @param qualifiedName of the DMEntityAssociation
     * @param name of the DMEntityAssociation
     * @return the updated DMEntityAssociation, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a DMEntityAssociation.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DMEntityAssociation's owners
     * @param qualifiedName of the DMEntityAssociation
     * @param name of the DMEntityAssociation
     * @return the updated DMEntityAssociation, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMEntityAssociation) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a DMEntityAssociation.
     *
     * @param qualifiedName of the DMEntityAssociation
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DMEntityAssociation, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a DMEntityAssociation.
     *
     * @param client connectivity to the Atlan tenant on which to update the DMEntityAssociation's certificate
     * @param qualifiedName of the DMEntityAssociation
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DMEntityAssociation, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DMEntityAssociation) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a DMEntityAssociation.
     *
     * @param qualifiedName of the DMEntityAssociation
     * @param name of the DMEntityAssociation
     * @return the updated DMEntityAssociation, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a DMEntityAssociation.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DMEntityAssociation's certificate
     * @param qualifiedName of the DMEntityAssociation
     * @param name of the DMEntityAssociation
     * @return the updated DMEntityAssociation, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMEntityAssociation) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a DMEntityAssociation.
     *
     * @param qualifiedName of the DMEntityAssociation
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a DMEntityAssociation.
     *
     * @param client connectivity to the Atlan tenant on which to update the DMEntityAssociation's announcement
     * @param qualifiedName of the DMEntityAssociation
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DMEntityAssociation) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a DMEntityAssociation.
     *
     * @param qualifiedName of the DMEntityAssociation
     * @param name of the DMEntityAssociation
     * @return the updated DMEntityAssociation, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a DMEntityAssociation.
     *
     * @param client connectivity to the Atlan client from which to remove the DMEntityAssociation's announcement
     * @param qualifiedName of the DMEntityAssociation
     * @param name of the DMEntityAssociation
     * @return the updated DMEntityAssociation, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMEntityAssociation) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the DMEntityAssociation.
     *
     * @param qualifiedName for the DMEntityAssociation
     * @param name human-readable name of the DMEntityAssociation
     * @param terms the list of terms to replace on the DMEntityAssociation, or null to remove all terms from the DMEntityAssociation
     * @return the DMEntityAssociation that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the DMEntityAssociation.
     *
     * @param client connectivity to the Atlan tenant on which to replace the DMEntityAssociation's assigned terms
     * @param qualifiedName for the DMEntityAssociation
     * @param name human-readable name of the DMEntityAssociation
     * @param terms the list of terms to replace on the DMEntityAssociation, or null to remove all terms from the DMEntityAssociation
     * @return the DMEntityAssociation that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMEntityAssociation) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the DMEntityAssociation, without replacing existing terms linked to the DMEntityAssociation.
     * Note: this operation must make two API calls — one to retrieve the DMEntityAssociation's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the DMEntityAssociation
     * @param terms the list of terms to append to the DMEntityAssociation
     * @return the DMEntityAssociation that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the DMEntityAssociation, without replacing existing terms linked to the DMEntityAssociation.
     * Note: this operation must make two API calls — one to retrieve the DMEntityAssociation's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the DMEntityAssociation
     * @param qualifiedName for the DMEntityAssociation
     * @param terms the list of terms to append to the DMEntityAssociation
     * @return the DMEntityAssociation that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMEntityAssociation) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a DMEntityAssociation, without replacing all existing terms linked to the DMEntityAssociation.
     * Note: this operation must make two API calls — one to retrieve the DMEntityAssociation's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the DMEntityAssociation
     * @param terms the list of terms to remove from the DMEntityAssociation, which must be referenced by GUID
     * @return the DMEntityAssociation that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a DMEntityAssociation, without replacing all existing terms linked to the DMEntityAssociation.
     * Note: this operation must make two API calls — one to retrieve the DMEntityAssociation's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the DMEntityAssociation
     * @param qualifiedName for the DMEntityAssociation
     * @param terms the list of terms to remove from the DMEntityAssociation, which must be referenced by GUID
     * @return the DMEntityAssociation that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DMEntityAssociation removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMEntityAssociation) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a DMEntityAssociation, without replacing existing Atlan tags linked to the DMEntityAssociation.
     * Note: this operation must make two API calls — one to retrieve the DMEntityAssociation's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DMEntityAssociation
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DMEntityAssociation
     */
    public static DMEntityAssociation appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DMEntityAssociation, without replacing existing Atlan tags linked to the DMEntityAssociation.
     * Note: this operation must make two API calls — one to retrieve the DMEntityAssociation's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DMEntityAssociation
     * @param qualifiedName of the DMEntityAssociation
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DMEntityAssociation
     */
    public static DMEntityAssociation appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DMEntityAssociation) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DMEntityAssociation, without replacing existing Atlan tags linked to the DMEntityAssociation.
     * Note: this operation must make two API calls — one to retrieve the DMEntityAssociation's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DMEntityAssociation
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DMEntityAssociation
     */
    public static DMEntityAssociation appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a DMEntityAssociation, without replacing existing Atlan tags linked to the DMEntityAssociation.
     * Note: this operation must make two API calls — one to retrieve the DMEntityAssociation's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DMEntityAssociation
     * @param qualifiedName of the DMEntityAssociation
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DMEntityAssociation
     */
    public static DMEntityAssociation appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DMEntityAssociation) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a DMEntityAssociation.
     *
     * @param qualifiedName of the DMEntityAssociation
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DMEntityAssociation
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a DMEntityAssociation.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a DMEntityAssociation
     * @param qualifiedName of the DMEntityAssociation
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DMEntityAssociation
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class DMEntityAssociationBuilder<C extends DMEntityAssociation, B extends DMEntityAssociation.DMEntityAssociationBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dmBusinessDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DMCardinalityType dmCardinality;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmDataModelDomain;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmDataModelName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmDataModelNamespace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmDataModelQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IDMEntity dmEntityFrom;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmEntityFromQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmEntityName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmEntityQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IDMEntity dmEntityTo;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmEntityToQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dmExpiredAtBusinessDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dmExpiredAtSystemDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmLabel;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dmSystemDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmVersionName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmVersionQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            DMEntityAssociation.DMEntityAssociationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final DMEntityAssociation instance, final DMEntityAssociation.DMEntityAssociationBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dmBusinessDate(instance.dmBusinessDate);
            b.dmCardinality(instance.dmCardinality);
            b.dmDataModelDomain(instance.dmDataModelDomain);
            b.dmDataModelName(instance.dmDataModelName);
            b.dmDataModelNamespace(instance.dmDataModelNamespace);
            b.dmDataModelQualifiedName(instance.dmDataModelQualifiedName);
            b.dmEntityFrom(instance.dmEntityFrom);
            b.dmEntityFromQualifiedName(instance.dmEntityFromQualifiedName);
            b.dmEntityName(instance.dmEntityName);
            b.dmEntityQualifiedName(instance.dmEntityQualifiedName);
            b.dmEntityTo(instance.dmEntityTo);
            b.dmEntityToQualifiedName(instance.dmEntityToQualifiedName);
            b.dmExpiredAtBusinessDate(instance.dmExpiredAtBusinessDate);
            b.dmExpiredAtSystemDate(instance.dmExpiredAtSystemDate);
            b.dmLabel(instance.dmLabel);
            b.dmSystemDate(instance.dmSystemDate);
            b.dmVersionName(instance.dmVersionName);
            b.dmVersionQualifiedName(instance.dmVersionQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for DMEntityAssociations.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Business date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmBusinessDate(final Long dmBusinessDate) {
            this.dmBusinessDate = dmBusinessDate;
            return self();
        }

        /**
         * Cardinality of the data entity association.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmCardinality(final DMCardinalityType dmCardinality) {
            this.dmCardinality = dmCardinality;
            return self();
        }

        /**
         * A domain of the data model in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmDataModelDomain(final String dmDataModelDomain) {
            this.dmDataModelDomain = dmDataModelDomain;
            return self();
        }

        /**
         * Simple name of the model in which this asset exists, or empty if it is itself a data model.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmDataModelName(final String dmDataModelName) {
            this.dmDataModelName = dmDataModelName;
            return self();
        }

        /**
         * A namespace of the data model in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmDataModelNamespace(final String dmDataModelNamespace) {
            this.dmDataModelNamespace = dmDataModelNamespace;
            return self();
        }

        /**
         * Unique name of the model in which this asset exists, or empty if it is itself a data model.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmDataModelQualifiedName(final String dmDataModelQualifiedName) {
            this.dmDataModelQualifiedName = dmDataModelQualifiedName;
            return self();
        }

        /**
         * Entity from which this association is related.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmEntityFrom(final IDMEntity dmEntityFrom) {
            this.dmEntityFrom = dmEntityFrom;
            return self();
        }

        /**
         * Unique name of the association from this entity is related.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmEntityFromQualifiedName(final String dmEntityFromQualifiedName) {
            this.dmEntityFromQualifiedName = dmEntityFromQualifiedName;
            return self();
        }

        /**
         * Simple name of the entity in which this asset exists, or empty if it is itself a data model entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmEntityName(final String dmEntityName) {
            this.dmEntityName = dmEntityName;
            return self();
        }

        /**
         * Unique name of the entity in which this asset exists, or empty if it is itself a data model entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmEntityQualifiedName(final String dmEntityQualifiedName) {
            this.dmEntityQualifiedName = dmEntityQualifiedName;
            return self();
        }

        /**
         * Entity to which this association is related.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmEntityTo(final IDMEntity dmEntityTo) {
            this.dmEntityTo = dmEntityTo;
            return self();
        }

        /**
         * Unique name of the association to which this entity is related.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmEntityToQualifiedName(final String dmEntityToQualifiedName) {
            this.dmEntityToQualifiedName = dmEntityToQualifiedName;
            return self();
        }

        /**
         * Business expiration date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmExpiredAtBusinessDate(final Long dmExpiredAtBusinessDate) {
            this.dmExpiredAtBusinessDate = dmExpiredAtBusinessDate;
            return self();
        }

        /**
         * System expiration date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmExpiredAtSystemDate(final Long dmExpiredAtSystemDate) {
            this.dmExpiredAtSystemDate = dmExpiredAtSystemDate;
            return self();
        }

        /**
         * Label of the data entity association.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmLabel(final String dmLabel) {
            this.dmLabel = dmLabel;
            return self();
        }

        /**
         * System date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmSystemDate(final Long dmSystemDate) {
            this.dmSystemDate = dmSystemDate;
            return self();
        }

        /**
         * Simple name of the version in which this asset exists, or empty if it is itself a data model version.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmVersionName(final String dmVersionName) {
            this.dmVersionName = dmVersionName;
            return self();
        }

        /**
         * Unique name of the version in which this asset exists, or empty if it is itself a data model version.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmVersionQualifiedName(final String dmVersionQualifiedName) {
            this.dmVersionQualifiedName = dmVersionQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "DMEntityAssociation.DMEntityAssociationBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dmBusinessDate=" + this.dmBusinessDate + ", dmCardinality=" + this.dmCardinality + ", dmDataModelDomain=" + this.dmDataModelDomain + ", dmDataModelName=" + this.dmDataModelName + ", dmDataModelNamespace=" + this.dmDataModelNamespace + ", dmDataModelQualifiedName=" + this.dmDataModelQualifiedName + ", dmEntityFrom=" + this.dmEntityFrom + ", dmEntityFromQualifiedName=" + this.dmEntityFromQualifiedName + ", dmEntityName=" + this.dmEntityName + ", dmEntityQualifiedName=" + this.dmEntityQualifiedName + ", dmEntityTo=" + this.dmEntityTo + ", dmEntityToQualifiedName=" + this.dmEntityToQualifiedName + ", dmExpiredAtBusinessDate=" + this.dmExpiredAtBusinessDate + ", dmExpiredAtSystemDate=" + this.dmExpiredAtSystemDate + ", dmLabel=" + this.dmLabel + ", dmSystemDate=" + this.dmSystemDate + ", dmVersionName=" + this.dmVersionName + ", dmVersionQualifiedName=" + this.dmVersionQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class DMEntityAssociationBuilderImpl extends DMEntityAssociation.DMEntityAssociationBuilder<DMEntityAssociation, DMEntityAssociation.DMEntityAssociationBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DMEntityAssociationBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DMEntityAssociation.DMEntityAssociationBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DMEntityAssociation build() {
            return new DMEntityAssociation(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected DMEntityAssociation(final DMEntityAssociation.DMEntityAssociationBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = DMEntityAssociation.$default$typeName();
        this.dmBusinessDate = b.dmBusinessDate;
        this.dmCardinality = b.dmCardinality;
        this.dmDataModelDomain = b.dmDataModelDomain;
        this.dmDataModelName = b.dmDataModelName;
        this.dmDataModelNamespace = b.dmDataModelNamespace;
        this.dmDataModelQualifiedName = b.dmDataModelQualifiedName;
        this.dmEntityFrom = b.dmEntityFrom;
        this.dmEntityFromQualifiedName = b.dmEntityFromQualifiedName;
        this.dmEntityName = b.dmEntityName;
        this.dmEntityQualifiedName = b.dmEntityQualifiedName;
        this.dmEntityTo = b.dmEntityTo;
        this.dmEntityToQualifiedName = b.dmEntityToQualifiedName;
        this.dmExpiredAtBusinessDate = b.dmExpiredAtBusinessDate;
        this.dmExpiredAtSystemDate = b.dmExpiredAtSystemDate;
        this.dmLabel = b.dmLabel;
        this.dmSystemDate = b.dmSystemDate;
        this.dmVersionName = b.dmVersionName;
        this.dmVersionQualifiedName = b.dmVersionQualifiedName;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static DMEntityAssociation.DMEntityAssociationBuilder<?, ?> _internal() {
        return new DMEntityAssociation.DMEntityAssociationBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DMEntityAssociation.DMEntityAssociationBuilder<?, ?> toBuilder() {
        return new DMEntityAssociation.DMEntityAssociationBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Business date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDmBusinessDate() {
        return this.dmBusinessDate;
    }

    /**
     * Cardinality of the data entity association.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DMCardinalityType getDmCardinality() {
        return this.dmCardinality;
    }

    /**
     * A domain of the data model in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmDataModelDomain() {
        return this.dmDataModelDomain;
    }

    /**
     * Simple name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmDataModelName() {
        return this.dmDataModelName;
    }

    /**
     * A namespace of the data model in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmDataModelNamespace() {
        return this.dmDataModelNamespace;
    }

    /**
     * Unique name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmDataModelQualifiedName() {
        return this.dmDataModelQualifiedName;
    }

    /**
     * Entity from which this association is related.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IDMEntity getDmEntityFrom() {
        return this.dmEntityFrom;
    }

    /**
     * Unique name of the association from this entity is related.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmEntityFromQualifiedName() {
        return this.dmEntityFromQualifiedName;
    }

    /**
     * Simple name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmEntityName() {
        return this.dmEntityName;
    }

    /**
     * Unique name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmEntityQualifiedName() {
        return this.dmEntityQualifiedName;
    }

    /**
     * Entity to which this association is related.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IDMEntity getDmEntityTo() {
        return this.dmEntityTo;
    }

    /**
     * Unique name of the association to which this entity is related.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmEntityToQualifiedName() {
        return this.dmEntityToQualifiedName;
    }

    /**
     * Business expiration date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDmExpiredAtBusinessDate() {
        return this.dmExpiredAtBusinessDate;
    }

    /**
     * System expiration date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDmExpiredAtSystemDate() {
        return this.dmExpiredAtSystemDate;
    }

    /**
     * Label of the data entity association.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmLabel() {
        return this.dmLabel;
    }

    /**
     * System date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDmSystemDate() {
        return this.dmSystemDate;
    }

    /**
     * Simple name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmVersionName() {
        return this.dmVersionName;
    }

    /**
     * Unique name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmVersionQualifiedName() {
        return this.dmVersionQualifiedName;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DMEntityAssociation)) return false;
        final DMEntityAssociation other = (DMEntityAssociation) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$dmBusinessDate = this.getDmBusinessDate();
        final java.lang.Object other$dmBusinessDate = other.getDmBusinessDate();
        if (this$dmBusinessDate == null ? other$dmBusinessDate != null : !this$dmBusinessDate.equals(other$dmBusinessDate)) return false;
        final java.lang.Object this$dmExpiredAtBusinessDate = this.getDmExpiredAtBusinessDate();
        final java.lang.Object other$dmExpiredAtBusinessDate = other.getDmExpiredAtBusinessDate();
        if (this$dmExpiredAtBusinessDate == null ? other$dmExpiredAtBusinessDate != null : !this$dmExpiredAtBusinessDate.equals(other$dmExpiredAtBusinessDate)) return false;
        final java.lang.Object this$dmExpiredAtSystemDate = this.getDmExpiredAtSystemDate();
        final java.lang.Object other$dmExpiredAtSystemDate = other.getDmExpiredAtSystemDate();
        if (this$dmExpiredAtSystemDate == null ? other$dmExpiredAtSystemDate != null : !this$dmExpiredAtSystemDate.equals(other$dmExpiredAtSystemDate)) return false;
        final java.lang.Object this$dmSystemDate = this.getDmSystemDate();
        final java.lang.Object other$dmSystemDate = other.getDmSystemDate();
        if (this$dmSystemDate == null ? other$dmSystemDate != null : !this$dmSystemDate.equals(other$dmSystemDate)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dmCardinality = this.getDmCardinality();
        final java.lang.Object other$dmCardinality = other.getDmCardinality();
        if (this$dmCardinality == null ? other$dmCardinality != null : !this$dmCardinality.equals(other$dmCardinality)) return false;
        final java.lang.Object this$dmDataModelDomain = this.getDmDataModelDomain();
        final java.lang.Object other$dmDataModelDomain = other.getDmDataModelDomain();
        if (this$dmDataModelDomain == null ? other$dmDataModelDomain != null : !this$dmDataModelDomain.equals(other$dmDataModelDomain)) return false;
        final java.lang.Object this$dmDataModelName = this.getDmDataModelName();
        final java.lang.Object other$dmDataModelName = other.getDmDataModelName();
        if (this$dmDataModelName == null ? other$dmDataModelName != null : !this$dmDataModelName.equals(other$dmDataModelName)) return false;
        final java.lang.Object this$dmDataModelNamespace = this.getDmDataModelNamespace();
        final java.lang.Object other$dmDataModelNamespace = other.getDmDataModelNamespace();
        if (this$dmDataModelNamespace == null ? other$dmDataModelNamespace != null : !this$dmDataModelNamespace.equals(other$dmDataModelNamespace)) return false;
        final java.lang.Object this$dmDataModelQualifiedName = this.getDmDataModelQualifiedName();
        final java.lang.Object other$dmDataModelQualifiedName = other.getDmDataModelQualifiedName();
        if (this$dmDataModelQualifiedName == null ? other$dmDataModelQualifiedName != null : !this$dmDataModelQualifiedName.equals(other$dmDataModelQualifiedName)) return false;
        final java.lang.Object this$dmEntityFrom = this.getDmEntityFrom();
        final java.lang.Object other$dmEntityFrom = other.getDmEntityFrom();
        if (this$dmEntityFrom == null ? other$dmEntityFrom != null : !this$dmEntityFrom.equals(other$dmEntityFrom)) return false;
        final java.lang.Object this$dmEntityFromQualifiedName = this.getDmEntityFromQualifiedName();
        final java.lang.Object other$dmEntityFromQualifiedName = other.getDmEntityFromQualifiedName();
        if (this$dmEntityFromQualifiedName == null ? other$dmEntityFromQualifiedName != null : !this$dmEntityFromQualifiedName.equals(other$dmEntityFromQualifiedName)) return false;
        final java.lang.Object this$dmEntityName = this.getDmEntityName();
        final java.lang.Object other$dmEntityName = other.getDmEntityName();
        if (this$dmEntityName == null ? other$dmEntityName != null : !this$dmEntityName.equals(other$dmEntityName)) return false;
        final java.lang.Object this$dmEntityQualifiedName = this.getDmEntityQualifiedName();
        final java.lang.Object other$dmEntityQualifiedName = other.getDmEntityQualifiedName();
        if (this$dmEntityQualifiedName == null ? other$dmEntityQualifiedName != null : !this$dmEntityQualifiedName.equals(other$dmEntityQualifiedName)) return false;
        final java.lang.Object this$dmEntityTo = this.getDmEntityTo();
        final java.lang.Object other$dmEntityTo = other.getDmEntityTo();
        if (this$dmEntityTo == null ? other$dmEntityTo != null : !this$dmEntityTo.equals(other$dmEntityTo)) return false;
        final java.lang.Object this$dmEntityToQualifiedName = this.getDmEntityToQualifiedName();
        final java.lang.Object other$dmEntityToQualifiedName = other.getDmEntityToQualifiedName();
        if (this$dmEntityToQualifiedName == null ? other$dmEntityToQualifiedName != null : !this$dmEntityToQualifiedName.equals(other$dmEntityToQualifiedName)) return false;
        final java.lang.Object this$dmLabel = this.getDmLabel();
        final java.lang.Object other$dmLabel = other.getDmLabel();
        if (this$dmLabel == null ? other$dmLabel != null : !this$dmLabel.equals(other$dmLabel)) return false;
        final java.lang.Object this$dmVersionName = this.getDmVersionName();
        final java.lang.Object other$dmVersionName = other.getDmVersionName();
        if (this$dmVersionName == null ? other$dmVersionName != null : !this$dmVersionName.equals(other$dmVersionName)) return false;
        final java.lang.Object this$dmVersionQualifiedName = this.getDmVersionQualifiedName();
        final java.lang.Object other$dmVersionQualifiedName = other.getDmVersionQualifiedName();
        if (this$dmVersionQualifiedName == null ? other$dmVersionQualifiedName != null : !this$dmVersionQualifiedName.equals(other$dmVersionQualifiedName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof DMEntityAssociation;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $dmBusinessDate = this.getDmBusinessDate();
        result = result * PRIME + ($dmBusinessDate == null ? 43 : $dmBusinessDate.hashCode());
        final java.lang.Object $dmExpiredAtBusinessDate = this.getDmExpiredAtBusinessDate();
        result = result * PRIME + ($dmExpiredAtBusinessDate == null ? 43 : $dmExpiredAtBusinessDate.hashCode());
        final java.lang.Object $dmExpiredAtSystemDate = this.getDmExpiredAtSystemDate();
        result = result * PRIME + ($dmExpiredAtSystemDate == null ? 43 : $dmExpiredAtSystemDate.hashCode());
        final java.lang.Object $dmSystemDate = this.getDmSystemDate();
        result = result * PRIME + ($dmSystemDate == null ? 43 : $dmSystemDate.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dmCardinality = this.getDmCardinality();
        result = result * PRIME + ($dmCardinality == null ? 43 : $dmCardinality.hashCode());
        final java.lang.Object $dmDataModelDomain = this.getDmDataModelDomain();
        result = result * PRIME + ($dmDataModelDomain == null ? 43 : $dmDataModelDomain.hashCode());
        final java.lang.Object $dmDataModelName = this.getDmDataModelName();
        result = result * PRIME + ($dmDataModelName == null ? 43 : $dmDataModelName.hashCode());
        final java.lang.Object $dmDataModelNamespace = this.getDmDataModelNamespace();
        result = result * PRIME + ($dmDataModelNamespace == null ? 43 : $dmDataModelNamespace.hashCode());
        final java.lang.Object $dmDataModelQualifiedName = this.getDmDataModelQualifiedName();
        result = result * PRIME + ($dmDataModelQualifiedName == null ? 43 : $dmDataModelQualifiedName.hashCode());
        final java.lang.Object $dmEntityFrom = this.getDmEntityFrom();
        result = result * PRIME + ($dmEntityFrom == null ? 43 : $dmEntityFrom.hashCode());
        final java.lang.Object $dmEntityFromQualifiedName = this.getDmEntityFromQualifiedName();
        result = result * PRIME + ($dmEntityFromQualifiedName == null ? 43 : $dmEntityFromQualifiedName.hashCode());
        final java.lang.Object $dmEntityName = this.getDmEntityName();
        result = result * PRIME + ($dmEntityName == null ? 43 : $dmEntityName.hashCode());
        final java.lang.Object $dmEntityQualifiedName = this.getDmEntityQualifiedName();
        result = result * PRIME + ($dmEntityQualifiedName == null ? 43 : $dmEntityQualifiedName.hashCode());
        final java.lang.Object $dmEntityTo = this.getDmEntityTo();
        result = result * PRIME + ($dmEntityTo == null ? 43 : $dmEntityTo.hashCode());
        final java.lang.Object $dmEntityToQualifiedName = this.getDmEntityToQualifiedName();
        result = result * PRIME + ($dmEntityToQualifiedName == null ? 43 : $dmEntityToQualifiedName.hashCode());
        final java.lang.Object $dmLabel = this.getDmLabel();
        result = result * PRIME + ($dmLabel == null ? 43 : $dmLabel.hashCode());
        final java.lang.Object $dmVersionName = this.getDmVersionName();
        result = result * PRIME + ($dmVersionName == null ? 43 : $dmVersionName.hashCode());
        final java.lang.Object $dmVersionQualifiedName = this.getDmVersionQualifiedName();
        result = result * PRIME + ($dmVersionQualifiedName == null ? 43 : $dmVersionQualifiedName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "DMEntityAssociation(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dmBusinessDate=" + this.getDmBusinessDate() + ", dmCardinality=" + this.getDmCardinality() + ", dmDataModelDomain=" + this.getDmDataModelDomain() + ", dmDataModelName=" + this.getDmDataModelName() + ", dmDataModelNamespace=" + this.getDmDataModelNamespace() + ", dmDataModelQualifiedName=" + this.getDmDataModelQualifiedName() + ", dmEntityFrom=" + this.getDmEntityFrom() + ", dmEntityFromQualifiedName=" + this.getDmEntityFromQualifiedName() + ", dmEntityName=" + this.getDmEntityName() + ", dmEntityQualifiedName=" + this.getDmEntityQualifiedName() + ", dmEntityTo=" + this.getDmEntityTo() + ", dmEntityToQualifiedName=" + this.getDmEntityToQualifiedName() + ", dmExpiredAtBusinessDate=" + this.getDmExpiredAtBusinessDate() + ", dmExpiredAtSystemDate=" + this.getDmExpiredAtSystemDate() + ", dmLabel=" + this.getDmLabel() + ", dmSystemDate=" + this.getDmSystemDate() + ", dmVersionName=" + this.getDmVersionName() + ", dmVersionQualifiedName=" + this.getDmVersionQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for DMEntityAssociations.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
