// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a version of a data model in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class DMVersion extends Asset implements IDMVersion, IDM, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(DMVersion.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DMVersion";
    /**
     * Fixed typeName for DMVersions.
     */
    String typeName;
    /**
     * Business date for the asset.
     */
    @Attribute
    @Date
    Long dmBusinessDate;
    /**
     * Data model for which this version exists.
     */
    @Attribute
    IDMDataModel dmDataModel;
    /**
     * A domain of the data model in which this asset exists.
     */
    @Attribute
    String dmDataModelDomain;
    /**
     * Simple name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @Attribute
    String dmDataModelName;
    /**
     * A namespace of the data model in which this asset exists.
     */
    @Attribute
    String dmDataModelNamespace;
    /**
     * Unique name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @Attribute
    String dmDataModelQualifiedName;
    /**
     * Individual entities that make up this version of the data model.
     */
    @Attribute
    SortedSet<IDMEntity> dmEntities;
    /**
     * Number of entities in the version.
     */
    @Attribute
    Long dmEntityCount;
    /**
     * Simple name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @Attribute
    String dmEntityName;
    /**
     * Unique name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @Attribute
    String dmEntityQualifiedName;
    /**
     * Business expiration date for the asset.
     */
    @Attribute
    @Date
    Long dmExpiredAtBusinessDate;
    /**
     * System expiration date for the asset.
     */
    @Attribute
    @Date
    Long dmExpiredAtSystemDate;
    /**
     * System date for the asset.
     */
    @Attribute
    @Date
    Long dmSystemDate;
    /**
     * Simple name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @Attribute
    String dmVersionName;
    /**
     * Unique name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @Attribute
    String dmVersionQualifiedName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a DMVersion, from a potentially
     * more-complete DMVersion object.
     *
     * @return the minimal object necessary to relate to the DMVersion
     * @throws InvalidRequestException if any of the minimal set of required properties for a DMVersion relationship are not found in the initial object
     */
    @Override
    public DMVersion trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all DMVersion assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DMVersion assets will be included.
     *
     * @return a fluent search that includes all DMVersion assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all DMVersion assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DMVersion assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all DMVersion assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all DMVersion assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) DMVersions will be included
     * @return a fluent search that includes all DMVersion assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all DMVersion assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) DMVersions will be included
     * @return a fluent search that includes all DMVersion assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a DMVersion by GUID. Use this to create a relationship to this DMVersion,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the DMVersion to reference
     * @return reference to a DMVersion that can be used for defining a relationship to a DMVersion
     */
    public static DMVersion refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DMVersion by GUID. Use this to create a relationship to this DMVersion,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the DMVersion to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DMVersion that can be used for defining a relationship to a DMVersion
     */
    public static DMVersion refByGuid(String guid, Reference.SaveSemantic semantic) {
        return DMVersion._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a DMVersion by qualifiedName. Use this to create a relationship to this DMVersion,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the DMVersion to reference
     * @return reference to a DMVersion that can be used for defining a relationship to a DMVersion
     */
    public static DMVersion refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DMVersion by qualifiedName. Use this to create a relationship to this DMVersion,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the DMVersion to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DMVersion that can be used for defining a relationship to a DMVersion
     */
    public static DMVersion refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return DMVersion._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a DMVersion by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the DMVersion to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DMVersion, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DMVersion does not exist or the provided GUID is not a DMVersion
     */
    @JsonIgnore
    public static DMVersion get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a DMVersion by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DMVersion to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DMVersion, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DMVersion does not exist or the provided GUID is not a DMVersion
     */
    @JsonIgnore
    public static DMVersion get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a DMVersion by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DMVersion to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full DMVersion, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DMVersion does not exist or the provided GUID is not a DMVersion
     */
    @JsonIgnore
    public static DMVersion get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof DMVersion) {
                return (DMVersion) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof DMVersion) {
                return (DMVersion) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) DMVersion to active.
     *
     * @param qualifiedName for the DMVersion
     * @return true if the DMVersion is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) DMVersion to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the DMVersion
     * @return true if the DMVersion is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a DMVersion.
     *
     * @param qualifiedName of the DMVersion
     * @param name of the DMVersion
     * @return the minimal request necessary to update the DMVersion, as a builder
     */
    public static DMVersionBuilder<?, ?> updater(String qualifiedName, String name) {
        return DMVersion._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a DMVersion, from a potentially
     * more-complete DMVersion object.
     *
     * @return the minimal object necessary to update the DMVersion, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for DMVersion are not found in the initial object
     */
    @Override
    public DMVersionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a DMVersion.
     *
     * @param qualifiedName of the DMVersion
     * @param name of the DMVersion
     * @return the updated DMVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a DMVersion.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DMVersion
     * @param name of the DMVersion
     * @return the updated DMVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMVersion) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a DMVersion.
     *
     * @param qualifiedName of the DMVersion
     * @param name of the DMVersion
     * @return the updated DMVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a DMVersion.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DMVersion
     * @param name of the DMVersion
     * @return the updated DMVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMVersion) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a DMVersion.
     *
     * @param qualifiedName of the DMVersion
     * @param name of the DMVersion
     * @return the updated DMVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a DMVersion.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DMVersion's owners
     * @param qualifiedName of the DMVersion
     * @param name of the DMVersion
     * @return the updated DMVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMVersion) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a DMVersion.
     *
     * @param qualifiedName of the DMVersion
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DMVersion, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a DMVersion.
     *
     * @param client connectivity to the Atlan tenant on which to update the DMVersion's certificate
     * @param qualifiedName of the DMVersion
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DMVersion, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DMVersion) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a DMVersion.
     *
     * @param qualifiedName of the DMVersion
     * @param name of the DMVersion
     * @return the updated DMVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a DMVersion.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DMVersion's certificate
     * @param qualifiedName of the DMVersion
     * @param name of the DMVersion
     * @return the updated DMVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMVersion) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a DMVersion.
     *
     * @param qualifiedName of the DMVersion
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a DMVersion.
     *
     * @param client connectivity to the Atlan tenant on which to update the DMVersion's announcement
     * @param qualifiedName of the DMVersion
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DMVersion) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a DMVersion.
     *
     * @param qualifiedName of the DMVersion
     * @param name of the DMVersion
     * @return the updated DMVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a DMVersion.
     *
     * @param client connectivity to the Atlan client from which to remove the DMVersion's announcement
     * @param qualifiedName of the DMVersion
     * @param name of the DMVersion
     * @return the updated DMVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DMVersion removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMVersion) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the DMVersion.
     *
     * @param qualifiedName for the DMVersion
     * @param name human-readable name of the DMVersion
     * @param terms the list of terms to replace on the DMVersion, or null to remove all terms from the DMVersion
     * @return the DMVersion that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DMVersion replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the DMVersion.
     *
     * @param client connectivity to the Atlan tenant on which to replace the DMVersion's assigned terms
     * @param qualifiedName for the DMVersion
     * @param name human-readable name of the DMVersion
     * @param terms the list of terms to replace on the DMVersion, or null to remove all terms from the DMVersion
     * @return the DMVersion that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DMVersion replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMVersion) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the DMVersion, without replacing existing terms linked to the DMVersion.
     * Note: this operation must make two API calls — one to retrieve the DMVersion's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the DMVersion
     * @param terms the list of terms to append to the DMVersion
     * @return the DMVersion that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DMVersion appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the DMVersion, without replacing existing terms linked to the DMVersion.
     * Note: this operation must make two API calls — one to retrieve the DMVersion's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the DMVersion
     * @param qualifiedName for the DMVersion
     * @param terms the list of terms to append to the DMVersion
     * @return the DMVersion that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DMVersion appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMVersion) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a DMVersion, without replacing all existing terms linked to the DMVersion.
     * Note: this operation must make two API calls — one to retrieve the DMVersion's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the DMVersion
     * @param terms the list of terms to remove from the DMVersion, which must be referenced by GUID
     * @return the DMVersion that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DMVersion removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a DMVersion, without replacing all existing terms linked to the DMVersion.
     * Note: this operation must make two API calls — one to retrieve the DMVersion's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the DMVersion
     * @param qualifiedName for the DMVersion
     * @param terms the list of terms to remove from the DMVersion, which must be referenced by GUID
     * @return the DMVersion that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DMVersion removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMVersion) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a DMVersion, without replacing existing Atlan tags linked to the DMVersion.
     * Note: this operation must make two API calls — one to retrieve the DMVersion's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DMVersion
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DMVersion
     */
    public static DMVersion appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DMVersion, without replacing existing Atlan tags linked to the DMVersion.
     * Note: this operation must make two API calls — one to retrieve the DMVersion's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DMVersion
     * @param qualifiedName of the DMVersion
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DMVersion
     */
    public static DMVersion appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DMVersion) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DMVersion, without replacing existing Atlan tags linked to the DMVersion.
     * Note: this operation must make two API calls — one to retrieve the DMVersion's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DMVersion
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DMVersion
     */
    public static DMVersion appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a DMVersion, without replacing existing Atlan tags linked to the DMVersion.
     * Note: this operation must make two API calls — one to retrieve the DMVersion's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DMVersion
     * @param qualifiedName of the DMVersion
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DMVersion
     */
    public static DMVersion appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DMVersion) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a DMVersion.
     *
     * @param qualifiedName of the DMVersion
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DMVersion
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a DMVersion.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a DMVersion
     * @param qualifiedName of the DMVersion
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DMVersion
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class DMVersionBuilder<C extends DMVersion, B extends DMVersion.DMVersionBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dmBusinessDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IDMDataModel dmDataModel;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmDataModelDomain;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmDataModelName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmDataModelNamespace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmDataModelQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDMEntity> dmEntities;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dmEntityCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmEntityName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmEntityQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dmExpiredAtBusinessDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dmExpiredAtSystemDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dmSystemDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmVersionName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dmVersionQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            DMVersion.DMVersionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final DMVersion instance, final DMVersion.DMVersionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dmBusinessDate(instance.dmBusinessDate);
            b.dmDataModel(instance.dmDataModel);
            b.dmDataModelDomain(instance.dmDataModelDomain);
            b.dmDataModelName(instance.dmDataModelName);
            b.dmDataModelNamespace(instance.dmDataModelNamespace);
            b.dmDataModelQualifiedName(instance.dmDataModelQualifiedName);
            b.dmEntities(instance.dmEntities == null ? java.util.Collections.<IDMEntity>emptySortedSet() : instance.dmEntities);
            b.dmEntityCount(instance.dmEntityCount);
            b.dmEntityName(instance.dmEntityName);
            b.dmEntityQualifiedName(instance.dmEntityQualifiedName);
            b.dmExpiredAtBusinessDate(instance.dmExpiredAtBusinessDate);
            b.dmExpiredAtSystemDate(instance.dmExpiredAtSystemDate);
            b.dmSystemDate(instance.dmSystemDate);
            b.dmVersionName(instance.dmVersionName);
            b.dmVersionQualifiedName(instance.dmVersionQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for DMVersions.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Business date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmBusinessDate(final Long dmBusinessDate) {
            this.dmBusinessDate = dmBusinessDate;
            return self();
        }

        /**
         * Data model for which this version exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmDataModel(final IDMDataModel dmDataModel) {
            this.dmDataModel = dmDataModel;
            return self();
        }

        /**
         * A domain of the data model in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmDataModelDomain(final String dmDataModelDomain) {
            this.dmDataModelDomain = dmDataModelDomain;
            return self();
        }

        /**
         * Simple name of the model in which this asset exists, or empty if it is itself a data model.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmDataModelName(final String dmDataModelName) {
            this.dmDataModelName = dmDataModelName;
            return self();
        }

        /**
         * A namespace of the data model in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmDataModelNamespace(final String dmDataModelNamespace) {
            this.dmDataModelNamespace = dmDataModelNamespace;
            return self();
        }

        /**
         * Unique name of the model in which this asset exists, or empty if it is itself a data model.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmDataModelQualifiedName(final String dmDataModelQualifiedName) {
            this.dmDataModelQualifiedName = dmDataModelQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmEntity(final IDMEntity dmEntity) {
            if (this.dmEntities == null) this.dmEntities = new java.util.ArrayList<IDMEntity>();
            this.dmEntities.add(dmEntity);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmEntities(final java.util.Collection<? extends IDMEntity> dmEntities) {
            if (dmEntities == null) {
                throw new java.lang.NullPointerException("dmEntities cannot be null");
            }
            if (this.dmEntities == null) this.dmEntities = new java.util.ArrayList<IDMEntity>();
            this.dmEntities.addAll(dmEntities);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDmEntities() {
            if (this.dmEntities != null) this.dmEntities.clear();
            return self();
        }

        /**
         * Number of entities in the version.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmEntityCount(final Long dmEntityCount) {
            this.dmEntityCount = dmEntityCount;
            return self();
        }

        /**
         * Simple name of the entity in which this asset exists, or empty if it is itself a data model entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmEntityName(final String dmEntityName) {
            this.dmEntityName = dmEntityName;
            return self();
        }

        /**
         * Unique name of the entity in which this asset exists, or empty if it is itself a data model entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmEntityQualifiedName(final String dmEntityQualifiedName) {
            this.dmEntityQualifiedName = dmEntityQualifiedName;
            return self();
        }

        /**
         * Business expiration date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmExpiredAtBusinessDate(final Long dmExpiredAtBusinessDate) {
            this.dmExpiredAtBusinessDate = dmExpiredAtBusinessDate;
            return self();
        }

        /**
         * System expiration date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmExpiredAtSystemDate(final Long dmExpiredAtSystemDate) {
            this.dmExpiredAtSystemDate = dmExpiredAtSystemDate;
            return self();
        }

        /**
         * System date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmSystemDate(final Long dmSystemDate) {
            this.dmSystemDate = dmSystemDate;
            return self();
        }

        /**
         * Simple name of the version in which this asset exists, or empty if it is itself a data model version.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmVersionName(final String dmVersionName) {
            this.dmVersionName = dmVersionName;
            return self();
        }

        /**
         * Unique name of the version in which this asset exists, or empty if it is itself a data model version.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dmVersionQualifiedName(final String dmVersionQualifiedName) {
            this.dmVersionQualifiedName = dmVersionQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "DMVersion.DMVersionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dmBusinessDate=" + this.dmBusinessDate + ", dmDataModel=" + this.dmDataModel + ", dmDataModelDomain=" + this.dmDataModelDomain + ", dmDataModelName=" + this.dmDataModelName + ", dmDataModelNamespace=" + this.dmDataModelNamespace + ", dmDataModelQualifiedName=" + this.dmDataModelQualifiedName + ", dmEntities=" + this.dmEntities + ", dmEntityCount=" + this.dmEntityCount + ", dmEntityName=" + this.dmEntityName + ", dmEntityQualifiedName=" + this.dmEntityQualifiedName + ", dmExpiredAtBusinessDate=" + this.dmExpiredAtBusinessDate + ", dmExpiredAtSystemDate=" + this.dmExpiredAtSystemDate + ", dmSystemDate=" + this.dmSystemDate + ", dmVersionName=" + this.dmVersionName + ", dmVersionQualifiedName=" + this.dmVersionQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class DMVersionBuilderImpl extends DMVersion.DMVersionBuilder<DMVersion, DMVersion.DMVersionBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DMVersionBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DMVersion.DMVersionBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DMVersion build() {
            return new DMVersion(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected DMVersion(final DMVersion.DMVersionBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = DMVersion.$default$typeName();
        this.dmBusinessDate = b.dmBusinessDate;
        this.dmDataModel = b.dmDataModel;
        this.dmDataModelDomain = b.dmDataModelDomain;
        this.dmDataModelName = b.dmDataModelName;
        this.dmDataModelNamespace = b.dmDataModelNamespace;
        this.dmDataModelQualifiedName = b.dmDataModelQualifiedName;
        java.util.SortedSet<IDMEntity> dmEntities = new java.util.TreeSet<IDMEntity>();
        if (b.dmEntities != null) dmEntities.addAll(b.dmEntities);
        dmEntities = java.util.Collections.unmodifiableSortedSet(dmEntities);
        this.dmEntities = dmEntities;
        this.dmEntityCount = b.dmEntityCount;
        this.dmEntityName = b.dmEntityName;
        this.dmEntityQualifiedName = b.dmEntityQualifiedName;
        this.dmExpiredAtBusinessDate = b.dmExpiredAtBusinessDate;
        this.dmExpiredAtSystemDate = b.dmExpiredAtSystemDate;
        this.dmSystemDate = b.dmSystemDate;
        this.dmVersionName = b.dmVersionName;
        this.dmVersionQualifiedName = b.dmVersionQualifiedName;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static DMVersion.DMVersionBuilder<?, ?> _internal() {
        return new DMVersion.DMVersionBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DMVersion.DMVersionBuilder<?, ?> toBuilder() {
        return new DMVersion.DMVersionBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Business date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDmBusinessDate() {
        return this.dmBusinessDate;
    }

    /**
     * Data model for which this version exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IDMDataModel getDmDataModel() {
        return this.dmDataModel;
    }

    /**
     * A domain of the data model in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmDataModelDomain() {
        return this.dmDataModelDomain;
    }

    /**
     * Simple name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmDataModelName() {
        return this.dmDataModelName;
    }

    /**
     * A namespace of the data model in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmDataModelNamespace() {
        return this.dmDataModelNamespace;
    }

    /**
     * Unique name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmDataModelQualifiedName() {
        return this.dmDataModelQualifiedName;
    }

    /**
     * Individual entities that make up this version of the data model.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDMEntity> getDmEntities() {
        return this.dmEntities;
    }

    /**
     * Number of entities in the version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDmEntityCount() {
        return this.dmEntityCount;
    }

    /**
     * Simple name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmEntityName() {
        return this.dmEntityName;
    }

    /**
     * Unique name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmEntityQualifiedName() {
        return this.dmEntityQualifiedName;
    }

    /**
     * Business expiration date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDmExpiredAtBusinessDate() {
        return this.dmExpiredAtBusinessDate;
    }

    /**
     * System expiration date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDmExpiredAtSystemDate() {
        return this.dmExpiredAtSystemDate;
    }

    /**
     * System date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDmSystemDate() {
        return this.dmSystemDate;
    }

    /**
     * Simple name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmVersionName() {
        return this.dmVersionName;
    }

    /**
     * Unique name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDmVersionQualifiedName() {
        return this.dmVersionQualifiedName;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DMVersion)) return false;
        final DMVersion other = (DMVersion) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$dmBusinessDate = this.getDmBusinessDate();
        final java.lang.Object other$dmBusinessDate = other.getDmBusinessDate();
        if (this$dmBusinessDate == null ? other$dmBusinessDate != null : !this$dmBusinessDate.equals(other$dmBusinessDate)) return false;
        final java.lang.Object this$dmEntityCount = this.getDmEntityCount();
        final java.lang.Object other$dmEntityCount = other.getDmEntityCount();
        if (this$dmEntityCount == null ? other$dmEntityCount != null : !this$dmEntityCount.equals(other$dmEntityCount)) return false;
        final java.lang.Object this$dmExpiredAtBusinessDate = this.getDmExpiredAtBusinessDate();
        final java.lang.Object other$dmExpiredAtBusinessDate = other.getDmExpiredAtBusinessDate();
        if (this$dmExpiredAtBusinessDate == null ? other$dmExpiredAtBusinessDate != null : !this$dmExpiredAtBusinessDate.equals(other$dmExpiredAtBusinessDate)) return false;
        final java.lang.Object this$dmExpiredAtSystemDate = this.getDmExpiredAtSystemDate();
        final java.lang.Object other$dmExpiredAtSystemDate = other.getDmExpiredAtSystemDate();
        if (this$dmExpiredAtSystemDate == null ? other$dmExpiredAtSystemDate != null : !this$dmExpiredAtSystemDate.equals(other$dmExpiredAtSystemDate)) return false;
        final java.lang.Object this$dmSystemDate = this.getDmSystemDate();
        final java.lang.Object other$dmSystemDate = other.getDmSystemDate();
        if (this$dmSystemDate == null ? other$dmSystemDate != null : !this$dmSystemDate.equals(other$dmSystemDate)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dmDataModel = this.getDmDataModel();
        final java.lang.Object other$dmDataModel = other.getDmDataModel();
        if (this$dmDataModel == null ? other$dmDataModel != null : !this$dmDataModel.equals(other$dmDataModel)) return false;
        final java.lang.Object this$dmDataModelDomain = this.getDmDataModelDomain();
        final java.lang.Object other$dmDataModelDomain = other.getDmDataModelDomain();
        if (this$dmDataModelDomain == null ? other$dmDataModelDomain != null : !this$dmDataModelDomain.equals(other$dmDataModelDomain)) return false;
        final java.lang.Object this$dmDataModelName = this.getDmDataModelName();
        final java.lang.Object other$dmDataModelName = other.getDmDataModelName();
        if (this$dmDataModelName == null ? other$dmDataModelName != null : !this$dmDataModelName.equals(other$dmDataModelName)) return false;
        final java.lang.Object this$dmDataModelNamespace = this.getDmDataModelNamespace();
        final java.lang.Object other$dmDataModelNamespace = other.getDmDataModelNamespace();
        if (this$dmDataModelNamespace == null ? other$dmDataModelNamespace != null : !this$dmDataModelNamespace.equals(other$dmDataModelNamespace)) return false;
        final java.lang.Object this$dmDataModelQualifiedName = this.getDmDataModelQualifiedName();
        final java.lang.Object other$dmDataModelQualifiedName = other.getDmDataModelQualifiedName();
        if (this$dmDataModelQualifiedName == null ? other$dmDataModelQualifiedName != null : !this$dmDataModelQualifiedName.equals(other$dmDataModelQualifiedName)) return false;
        final java.lang.Object this$dmEntities = this.getDmEntities();
        final java.lang.Object other$dmEntities = other.getDmEntities();
        if (this$dmEntities == null ? other$dmEntities != null : !this$dmEntities.equals(other$dmEntities)) return false;
        final java.lang.Object this$dmEntityName = this.getDmEntityName();
        final java.lang.Object other$dmEntityName = other.getDmEntityName();
        if (this$dmEntityName == null ? other$dmEntityName != null : !this$dmEntityName.equals(other$dmEntityName)) return false;
        final java.lang.Object this$dmEntityQualifiedName = this.getDmEntityQualifiedName();
        final java.lang.Object other$dmEntityQualifiedName = other.getDmEntityQualifiedName();
        if (this$dmEntityQualifiedName == null ? other$dmEntityQualifiedName != null : !this$dmEntityQualifiedName.equals(other$dmEntityQualifiedName)) return false;
        final java.lang.Object this$dmVersionName = this.getDmVersionName();
        final java.lang.Object other$dmVersionName = other.getDmVersionName();
        if (this$dmVersionName == null ? other$dmVersionName != null : !this$dmVersionName.equals(other$dmVersionName)) return false;
        final java.lang.Object this$dmVersionQualifiedName = this.getDmVersionQualifiedName();
        final java.lang.Object other$dmVersionQualifiedName = other.getDmVersionQualifiedName();
        if (this$dmVersionQualifiedName == null ? other$dmVersionQualifiedName != null : !this$dmVersionQualifiedName.equals(other$dmVersionQualifiedName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof DMVersion;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $dmBusinessDate = this.getDmBusinessDate();
        result = result * PRIME + ($dmBusinessDate == null ? 43 : $dmBusinessDate.hashCode());
        final java.lang.Object $dmEntityCount = this.getDmEntityCount();
        result = result * PRIME + ($dmEntityCount == null ? 43 : $dmEntityCount.hashCode());
        final java.lang.Object $dmExpiredAtBusinessDate = this.getDmExpiredAtBusinessDate();
        result = result * PRIME + ($dmExpiredAtBusinessDate == null ? 43 : $dmExpiredAtBusinessDate.hashCode());
        final java.lang.Object $dmExpiredAtSystemDate = this.getDmExpiredAtSystemDate();
        result = result * PRIME + ($dmExpiredAtSystemDate == null ? 43 : $dmExpiredAtSystemDate.hashCode());
        final java.lang.Object $dmSystemDate = this.getDmSystemDate();
        result = result * PRIME + ($dmSystemDate == null ? 43 : $dmSystemDate.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dmDataModel = this.getDmDataModel();
        result = result * PRIME + ($dmDataModel == null ? 43 : $dmDataModel.hashCode());
        final java.lang.Object $dmDataModelDomain = this.getDmDataModelDomain();
        result = result * PRIME + ($dmDataModelDomain == null ? 43 : $dmDataModelDomain.hashCode());
        final java.lang.Object $dmDataModelName = this.getDmDataModelName();
        result = result * PRIME + ($dmDataModelName == null ? 43 : $dmDataModelName.hashCode());
        final java.lang.Object $dmDataModelNamespace = this.getDmDataModelNamespace();
        result = result * PRIME + ($dmDataModelNamespace == null ? 43 : $dmDataModelNamespace.hashCode());
        final java.lang.Object $dmDataModelQualifiedName = this.getDmDataModelQualifiedName();
        result = result * PRIME + ($dmDataModelQualifiedName == null ? 43 : $dmDataModelQualifiedName.hashCode());
        final java.lang.Object $dmEntities = this.getDmEntities();
        result = result * PRIME + ($dmEntities == null ? 43 : $dmEntities.hashCode());
        final java.lang.Object $dmEntityName = this.getDmEntityName();
        result = result * PRIME + ($dmEntityName == null ? 43 : $dmEntityName.hashCode());
        final java.lang.Object $dmEntityQualifiedName = this.getDmEntityQualifiedName();
        result = result * PRIME + ($dmEntityQualifiedName == null ? 43 : $dmEntityQualifiedName.hashCode());
        final java.lang.Object $dmVersionName = this.getDmVersionName();
        result = result * PRIME + ($dmVersionName == null ? 43 : $dmVersionName.hashCode());
        final java.lang.Object $dmVersionQualifiedName = this.getDmVersionQualifiedName();
        result = result * PRIME + ($dmVersionQualifiedName == null ? 43 : $dmVersionQualifiedName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "DMVersion(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dmBusinessDate=" + this.getDmBusinessDate() + ", dmDataModel=" + this.getDmDataModel() + ", dmDataModelDomain=" + this.getDmDataModelDomain() + ", dmDataModelName=" + this.getDmDataModelName() + ", dmDataModelNamespace=" + this.getDmDataModelNamespace() + ", dmDataModelQualifiedName=" + this.getDmDataModelQualifiedName() + ", dmEntities=" + this.getDmEntities() + ", dmEntityCount=" + this.getDmEntityCount() + ", dmEntityName=" + this.getDmEntityName() + ", dmEntityQualifiedName=" + this.getDmEntityQualifiedName() + ", dmExpiredAtBusinessDate=" + this.getDmExpiredAtBusinessDate() + ", dmExpiredAtSystemDate=" + this.getDmExpiredAtSystemDate() + ", dmSystemDate=" + this.getDmSystemDate() + ", dmVersionName=" + this.getDmVersionName() + ", dmVersionQualifiedName=" + this.getDmVersionQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for DMVersions.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
