// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Data contract for an asset.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class DataContract extends Asset implements IDataContract, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(DataContract.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DataContract";
    /**
     * Fixed typeName for DataContracts.
     */
    String typeName;
    /**
     * Asset this contract controls.
     */
    @Attribute
    IAsset dataContractAssetCertified;
    /**
     * Unique identifier of the asset associated with this data contract.
     */
    @Attribute
    String dataContractAssetGuid;
    /**
     * Asset this contract controls or will control.
     */
    @Attribute
    IAsset dataContractAssetLatest;
    /**
     * (Deprecated) Replaced by dataContractSpec attribute.
     */
    @Attribute
    String dataContractJson;
    /**
     * Data contract instance that holds the next version of this contract.
     */
    @Attribute
    IDataContract dataContractNextVersion;
    /**
     * Data contract instance that holds the previous version of this contract.
     */
    @Attribute
    IDataContract dataContractPreviousVersion;
    /**
     * Actual content of the contract in YAML string format. Any changes to this string should create a new instance (with new sequential version number).
     */
    @Attribute
    String dataContractSpec;
    /**
     * Version of the contract.
     */
    @Attribute
    Long dataContractVersion;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a DataContract, from a potentially
     * more-complete DataContract object.
     *
     * @return the minimal object necessary to relate to the DataContract
     * @throws InvalidRequestException if any of the minimal set of required properties for a DataContract relationship are not found in the initial object
     */
    @Override
    public DataContract trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all DataContract assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DataContract assets will be included.
     *
     * @return a fluent search that includes all DataContract assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all DataContract assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DataContract assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all DataContract assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all DataContract assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) DataContracts will be included
     * @return a fluent search that includes all DataContract assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all DataContract assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) DataContracts will be included
     * @return a fluent search that includes all DataContract assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a DataContract by GUID. Use this to create a relationship to this DataContract,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the DataContract to reference
     * @return reference to a DataContract that can be used for defining a relationship to a DataContract
     */
    public static DataContract refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DataContract by GUID. Use this to create a relationship to this DataContract,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the DataContract to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DataContract that can be used for defining a relationship to a DataContract
     */
    public static DataContract refByGuid(String guid, Reference.SaveSemantic semantic) {
        return DataContract._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a DataContract by qualifiedName. Use this to create a relationship to this DataContract,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the DataContract to reference
     * @return reference to a DataContract that can be used for defining a relationship to a DataContract
     */
    public static DataContract refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DataContract by qualifiedName. Use this to create a relationship to this DataContract,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the DataContract to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DataContract that can be used for defining a relationship to a DataContract
     */
    public static DataContract refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return DataContract._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a DataContract by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the DataContract to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DataContract, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DataContract does not exist or the provided GUID is not a DataContract
     */
    @JsonIgnore
    public static DataContract get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a DataContract by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DataContract to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DataContract, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DataContract does not exist or the provided GUID is not a DataContract
     */
    @JsonIgnore
    public static DataContract get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a DataContract by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DataContract to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full DataContract, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DataContract does not exist or the provided GUID is not a DataContract
     */
    @JsonIgnore
    public static DataContract get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof DataContract) {
                return (DataContract) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof DataContract) {
                return (DataContract) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) DataContract to active.
     *
     * @param qualifiedName for the DataContract
     * @return true if the DataContract is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) DataContract to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the DataContract
     * @return true if the DataContract is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a DataContract.
     *
     * @param contract detailed specification of the contract
     * @param asset asset for which to create this contract
     * @return the minimal request necessary to create the DataContract, as a builder
     * @throws InvalidRequestException if the asset provided is without some required information
     */
    public static DataContractBuilder<?, ?> creator(String contract, Asset asset) throws InvalidRequestException {
        validateRelationship(asset.getTypeName(), Map.of("name", asset.getName(), "qualifiedName", asset.getQualifiedName()));
        return creator(contract, asset.getName(), asset.getQualifiedName());
    }

    /**
     * Builds the minimal object necessary to create a DataContract.
     *
     * @param contract detailed specification of the contract
     * @param assetQualifiedName unique name of the asset for which to create this contract
     * @return the minimal request necessary to create the DataContract, as a builder
     */
    public static DataContractBuilder<?, ?> creator(String contract, String assetQualifiedName) {
        return creator(contract, StringUtils.getNameFromQualifiedName(assetQualifiedName), assetQualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a DataContract.
     *
     * @param contract detailed specification of the contract
     * @param assetName simple name of the asset for which to create this contract
     * @param assetQualifiedName unique name of the asset for which to create this contract
     * @return the minimal request necessary to create the DataContract, as a builder
     */
    public static DataContractBuilder<?, ?> creator(String contract, String assetName, String assetQualifiedName) {
        String contractName = "Data contract for " + assetName;
        return DataContract._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).name(contractName).qualifiedName(generateQualifiedName(assetQualifiedName)).dataContractJson(contract);
    }

    /**
     * Builds the minimal object necessary to update a DataContract.
     *
     * @param qualifiedName of the DataContract
     * @param name of the DataContract
     * @return the minimal request necessary to update the DataContract, as a builder
     */
    public static DataContractBuilder<?, ?> updater(String qualifiedName, String name) {
        return DataContract._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Generate a unique DataContract name.
     *
     * @param assetQualifiedName unique name of the asset for which this DataContract exists
     * @return a unique name for the DataContract
     */
    public static String generateQualifiedName(String assetQualifiedName) {
        return assetQualifiedName + "/contract";
    }

    /**
     * Builds the minimal object necessary to apply an update to a DataContract, from a potentially
     * more-complete DataContract object.
     *
     * @return the minimal object necessary to update the DataContract, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for DataContract are not found in the initial object
     */
    @Override
    public DataContractBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a DataContract.
     *
     * @param qualifiedName of the DataContract
     * @param name of the DataContract
     * @return the updated DataContract, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataContract removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a DataContract.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DataContract
     * @param name of the DataContract
     * @return the updated DataContract, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataContract removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataContract) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a DataContract.
     *
     * @param qualifiedName of the DataContract
     * @param name of the DataContract
     * @return the updated DataContract, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataContract removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a DataContract.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DataContract
     * @param name of the DataContract
     * @return the updated DataContract, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataContract removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataContract) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a DataContract.
     *
     * @param qualifiedName of the DataContract
     * @param name of the DataContract
     * @return the updated DataContract, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataContract removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a DataContract.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DataContract's owners
     * @param qualifiedName of the DataContract
     * @param name of the DataContract
     * @return the updated DataContract, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataContract removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataContract) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a DataContract.
     *
     * @param qualifiedName of the DataContract
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DataContract, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DataContract updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a DataContract.
     *
     * @param client connectivity to the Atlan tenant on which to update the DataContract's certificate
     * @param qualifiedName of the DataContract
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DataContract, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DataContract updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DataContract) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a DataContract.
     *
     * @param qualifiedName of the DataContract
     * @param name of the DataContract
     * @return the updated DataContract, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataContract removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a DataContract.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DataContract's certificate
     * @param qualifiedName of the DataContract
     * @param name of the DataContract
     * @return the updated DataContract, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataContract removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataContract) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a DataContract.
     *
     * @param qualifiedName of the DataContract
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DataContract updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a DataContract.
     *
     * @param client connectivity to the Atlan tenant on which to update the DataContract's announcement
     * @param qualifiedName of the DataContract
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DataContract updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DataContract) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a DataContract.
     *
     * @param qualifiedName of the DataContract
     * @param name of the DataContract
     * @return the updated DataContract, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataContract removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a DataContract.
     *
     * @param client connectivity to the Atlan client from which to remove the DataContract's announcement
     * @param qualifiedName of the DataContract
     * @param name of the DataContract
     * @return the updated DataContract, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataContract removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataContract) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the DataContract.
     *
     * @param qualifiedName for the DataContract
     * @param name human-readable name of the DataContract
     * @param terms the list of terms to replace on the DataContract, or null to remove all terms from the DataContract
     * @return the DataContract that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DataContract replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the DataContract.
     *
     * @param client connectivity to the Atlan tenant on which to replace the DataContract's assigned terms
     * @param qualifiedName for the DataContract
     * @param name human-readable name of the DataContract
     * @param terms the list of terms to replace on the DataContract, or null to remove all terms from the DataContract
     * @return the DataContract that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DataContract replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataContract) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the DataContract, without replacing existing terms linked to the DataContract.
     * Note: this operation must make two API calls — one to retrieve the DataContract's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the DataContract
     * @param terms the list of terms to append to the DataContract
     * @return the DataContract that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DataContract appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the DataContract, without replacing existing terms linked to the DataContract.
     * Note: this operation must make two API calls — one to retrieve the DataContract's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the DataContract
     * @param qualifiedName for the DataContract
     * @param terms the list of terms to append to the DataContract
     * @return the DataContract that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DataContract appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataContract) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a DataContract, without replacing all existing terms linked to the DataContract.
     * Note: this operation must make two API calls — one to retrieve the DataContract's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the DataContract
     * @param terms the list of terms to remove from the DataContract, which must be referenced by GUID
     * @return the DataContract that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DataContract removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a DataContract, without replacing all existing terms linked to the DataContract.
     * Note: this operation must make two API calls — one to retrieve the DataContract's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the DataContract
     * @param qualifiedName for the DataContract
     * @param terms the list of terms to remove from the DataContract, which must be referenced by GUID
     * @return the DataContract that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DataContract removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataContract) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a DataContract, without replacing existing Atlan tags linked to the DataContract.
     * Note: this operation must make two API calls — one to retrieve the DataContract's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DataContract
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DataContract
     */
    public static DataContract appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DataContract, without replacing existing Atlan tags linked to the DataContract.
     * Note: this operation must make two API calls — one to retrieve the DataContract's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DataContract
     * @param qualifiedName of the DataContract
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DataContract
     */
    public static DataContract appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DataContract) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DataContract, without replacing existing Atlan tags linked to the DataContract.
     * Note: this operation must make two API calls — one to retrieve the DataContract's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DataContract
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DataContract
     */
    public static DataContract appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a DataContract, without replacing existing Atlan tags linked to the DataContract.
     * Note: this operation must make two API calls — one to retrieve the DataContract's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DataContract
     * @param qualifiedName of the DataContract
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DataContract
     */
    public static DataContract appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DataContract) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a DataContract.
     *
     * @param qualifiedName of the DataContract
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DataContract
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a DataContract.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a DataContract
     * @param qualifiedName of the DataContract
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DataContract
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class DataContractBuilder<C extends DataContract, B extends DataContract.DataContractBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IAsset dataContractAssetCertified;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dataContractAssetGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IAsset dataContractAssetLatest;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dataContractJson;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IDataContract dataContractNextVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IDataContract dataContractPreviousVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dataContractSpec;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dataContractVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            DataContract.DataContractBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final DataContract instance, final DataContract.DataContractBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dataContractAssetCertified(instance.dataContractAssetCertified);
            b.dataContractAssetGuid(instance.dataContractAssetGuid);
            b.dataContractAssetLatest(instance.dataContractAssetLatest);
            b.dataContractJson(instance.dataContractJson);
            b.dataContractNextVersion(instance.dataContractNextVersion);
            b.dataContractPreviousVersion(instance.dataContractPreviousVersion);
            b.dataContractSpec(instance.dataContractSpec);
            b.dataContractVersion(instance.dataContractVersion);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for DataContracts.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Asset this contract controls.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataContractAssetCertified(final IAsset dataContractAssetCertified) {
            this.dataContractAssetCertified = dataContractAssetCertified;
            return self();
        }

        /**
         * Unique identifier of the asset associated with this data contract.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataContractAssetGuid(final String dataContractAssetGuid) {
            this.dataContractAssetGuid = dataContractAssetGuid;
            return self();
        }

        /**
         * Asset this contract controls or will control.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataContractAssetLatest(final IAsset dataContractAssetLatest) {
            this.dataContractAssetLatest = dataContractAssetLatest;
            return self();
        }

        /**
         * (Deprecated) Replaced by dataContractSpec attribute.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataContractJson(final String dataContractJson) {
            this.dataContractJson = dataContractJson;
            return self();
        }

        /**
         * Data contract instance that holds the next version of this contract.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataContractNextVersion(final IDataContract dataContractNextVersion) {
            this.dataContractNextVersion = dataContractNextVersion;
            return self();
        }

        /**
         * Data contract instance that holds the previous version of this contract.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataContractPreviousVersion(final IDataContract dataContractPreviousVersion) {
            this.dataContractPreviousVersion = dataContractPreviousVersion;
            return self();
        }

        /**
         * Actual content of the contract in YAML string format. Any changes to this string should create a new instance (with new sequential version number).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataContractSpec(final String dataContractSpec) {
            this.dataContractSpec = dataContractSpec;
            return self();
        }

        /**
         * Version of the contract.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataContractVersion(final Long dataContractVersion) {
            this.dataContractVersion = dataContractVersion;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "DataContract.DataContractBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dataContractAssetCertified=" + this.dataContractAssetCertified + ", dataContractAssetGuid=" + this.dataContractAssetGuid + ", dataContractAssetLatest=" + this.dataContractAssetLatest + ", dataContractJson=" + this.dataContractJson + ", dataContractNextVersion=" + this.dataContractNextVersion + ", dataContractPreviousVersion=" + this.dataContractPreviousVersion + ", dataContractSpec=" + this.dataContractSpec + ", dataContractVersion=" + this.dataContractVersion + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class DataContractBuilderImpl extends DataContract.DataContractBuilder<DataContract, DataContract.DataContractBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataContractBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DataContract.DataContractBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DataContract build() {
            return new DataContract(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected DataContract(final DataContract.DataContractBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = DataContract.$default$typeName();
        this.dataContractAssetCertified = b.dataContractAssetCertified;
        this.dataContractAssetGuid = b.dataContractAssetGuid;
        this.dataContractAssetLatest = b.dataContractAssetLatest;
        this.dataContractJson = b.dataContractJson;
        this.dataContractNextVersion = b.dataContractNextVersion;
        this.dataContractPreviousVersion = b.dataContractPreviousVersion;
        this.dataContractSpec = b.dataContractSpec;
        this.dataContractVersion = b.dataContractVersion;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static DataContract.DataContractBuilder<?, ?> _internal() {
        return new DataContract.DataContractBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataContract.DataContractBuilder<?, ?> toBuilder() {
        return new DataContract.DataContractBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Asset this contract controls.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IAsset getDataContractAssetCertified() {
        return this.dataContractAssetCertified;
    }

    /**
     * Unique identifier of the asset associated with this data contract.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataContractAssetGuid() {
        return this.dataContractAssetGuid;
    }

    /**
     * Asset this contract controls or will control.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IAsset getDataContractAssetLatest() {
        return this.dataContractAssetLatest;
    }

    /**
     * (Deprecated) Replaced by dataContractSpec attribute.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataContractJson() {
        return this.dataContractJson;
    }

    /**
     * Data contract instance that holds the next version of this contract.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IDataContract getDataContractNextVersion() {
        return this.dataContractNextVersion;
    }

    /**
     * Data contract instance that holds the previous version of this contract.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IDataContract getDataContractPreviousVersion() {
        return this.dataContractPreviousVersion;
    }

    /**
     * Actual content of the contract in YAML string format. Any changes to this string should create a new instance (with new sequential version number).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataContractSpec() {
        return this.dataContractSpec;
    }

    /**
     * Version of the contract.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDataContractVersion() {
        return this.dataContractVersion;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DataContract)) return false;
        final DataContract other = (DataContract) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$dataContractVersion = this.getDataContractVersion();
        final java.lang.Object other$dataContractVersion = other.getDataContractVersion();
        if (this$dataContractVersion == null ? other$dataContractVersion != null : !this$dataContractVersion.equals(other$dataContractVersion)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dataContractAssetCertified = this.getDataContractAssetCertified();
        final java.lang.Object other$dataContractAssetCertified = other.getDataContractAssetCertified();
        if (this$dataContractAssetCertified == null ? other$dataContractAssetCertified != null : !this$dataContractAssetCertified.equals(other$dataContractAssetCertified)) return false;
        final java.lang.Object this$dataContractAssetGuid = this.getDataContractAssetGuid();
        final java.lang.Object other$dataContractAssetGuid = other.getDataContractAssetGuid();
        if (this$dataContractAssetGuid == null ? other$dataContractAssetGuid != null : !this$dataContractAssetGuid.equals(other$dataContractAssetGuid)) return false;
        final java.lang.Object this$dataContractAssetLatest = this.getDataContractAssetLatest();
        final java.lang.Object other$dataContractAssetLatest = other.getDataContractAssetLatest();
        if (this$dataContractAssetLatest == null ? other$dataContractAssetLatest != null : !this$dataContractAssetLatest.equals(other$dataContractAssetLatest)) return false;
        final java.lang.Object this$dataContractJson = this.getDataContractJson();
        final java.lang.Object other$dataContractJson = other.getDataContractJson();
        if (this$dataContractJson == null ? other$dataContractJson != null : !this$dataContractJson.equals(other$dataContractJson)) return false;
        final java.lang.Object this$dataContractNextVersion = this.getDataContractNextVersion();
        final java.lang.Object other$dataContractNextVersion = other.getDataContractNextVersion();
        if (this$dataContractNextVersion == null ? other$dataContractNextVersion != null : !this$dataContractNextVersion.equals(other$dataContractNextVersion)) return false;
        final java.lang.Object this$dataContractPreviousVersion = this.getDataContractPreviousVersion();
        final java.lang.Object other$dataContractPreviousVersion = other.getDataContractPreviousVersion();
        if (this$dataContractPreviousVersion == null ? other$dataContractPreviousVersion != null : !this$dataContractPreviousVersion.equals(other$dataContractPreviousVersion)) return false;
        final java.lang.Object this$dataContractSpec = this.getDataContractSpec();
        final java.lang.Object other$dataContractSpec = other.getDataContractSpec();
        if (this$dataContractSpec == null ? other$dataContractSpec != null : !this$dataContractSpec.equals(other$dataContractSpec)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof DataContract;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $dataContractVersion = this.getDataContractVersion();
        result = result * PRIME + ($dataContractVersion == null ? 43 : $dataContractVersion.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dataContractAssetCertified = this.getDataContractAssetCertified();
        result = result * PRIME + ($dataContractAssetCertified == null ? 43 : $dataContractAssetCertified.hashCode());
        final java.lang.Object $dataContractAssetGuid = this.getDataContractAssetGuid();
        result = result * PRIME + ($dataContractAssetGuid == null ? 43 : $dataContractAssetGuid.hashCode());
        final java.lang.Object $dataContractAssetLatest = this.getDataContractAssetLatest();
        result = result * PRIME + ($dataContractAssetLatest == null ? 43 : $dataContractAssetLatest.hashCode());
        final java.lang.Object $dataContractJson = this.getDataContractJson();
        result = result * PRIME + ($dataContractJson == null ? 43 : $dataContractJson.hashCode());
        final java.lang.Object $dataContractNextVersion = this.getDataContractNextVersion();
        result = result * PRIME + ($dataContractNextVersion == null ? 43 : $dataContractNextVersion.hashCode());
        final java.lang.Object $dataContractPreviousVersion = this.getDataContractPreviousVersion();
        result = result * PRIME + ($dataContractPreviousVersion == null ? 43 : $dataContractPreviousVersion.hashCode());
        final java.lang.Object $dataContractSpec = this.getDataContractSpec();
        result = result * PRIME + ($dataContractSpec == null ? 43 : $dataContractSpec.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "DataContract(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dataContractAssetCertified=" + this.getDataContractAssetCertified() + ", dataContractAssetGuid=" + this.getDataContractAssetGuid() + ", dataContractAssetLatest=" + this.getDataContractAssetLatest() + ", dataContractJson=" + this.getDataContractJson() + ", dataContractNextVersion=" + this.getDataContractNextVersion() + ", dataContractPreviousVersion=" + this.getDataContractPreviousVersion() + ", dataContractSpec=" + this.getDataContractSpec() + ", dataContractVersion=" + this.getDataContractVersion() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for DataContracts.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
