// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.DataProductCriticality;
import com.atlan.model.enums.DataProductSensitivity;
import com.atlan.model.enums.DataProductStatus;
import com.atlan.model.enums.DataProductVisibility;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.mesh.DataProductAssetsDSL;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a data product in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class DataProduct extends Asset implements IDataProduct, IDataMesh, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(DataProduct.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DataProduct";
    /**
     * Fixed typeName for DataProducts.
     */
    String typeName;
    /**
     * Criticality of this data product.
     */
    @Attribute
    DataProductCriticality daapCriticality;
    /**
     * Input ports guids for this data product.
     */
    @Attribute
    SortedSet<String> daapInputPortGuids;
    /**
     * Output ports guids for this data product.
     */
    @Attribute
    SortedSet<String> daapOutputPortGuids;
    /**
     * Information sensitivity of this data product.
     */
    @Attribute
    DataProductSensitivity daapSensitivity;
    /**
     * Status of this data product.
     */
    @Attribute
    DataProductStatus daapStatus;
    /**
     * Visibility of a data product.
     */
    @Attribute
    DataProductVisibility daapVisibility;
    /**
     * list of groups for product visibility control
     */
    @Attribute
    SortedSet<String> daapVisibilityGroups;
    /**
     * list of users for product visibility control
     */
    @Attribute
    SortedSet<String> daapVisibilityUsers;
    /**
     * Data domain in which this data product exists.
     */
    @Attribute
    IDataDomain dataDomain;
    /**
     * Search DSL used to define which assets are part of this data product.
     */
    @Attribute
    String dataProductAssetsDSL;
    /**
     * Playbook filter to define which assets are part of this data product.
     */
    @Attribute
    String dataProductAssetsPlaybookFilter;
    /**
     * Criticality of this data product.
     */
    @Attribute
    DataProductCriticality dataProductCriticality;
    /**
     * Timestamp when the score of this data product was last updated.
     */
    @Attribute
    @Date
    Long dataProductScoreUpdatedAt;
    /**
     * Score of this data product.
     */
    @Attribute
    Double dataProductScoreValue;
    /**
     * Information sensitivity of this data product.
     */
    @Attribute
    DataProductSensitivity dataProductSensitivity;
    /**
     * Status of this data product.
     */
    @Attribute
    DataProductStatus dataProductStatus;
    /**
     * Visibility of a data product.
     */
    @Attribute
    DataProductVisibility dataProductVisibility;
    /**
     * Input ports for this data product.
     */
    @Attribute
    SortedSet<IAsset> inputPorts;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Output ports for this data product.
     */
    @Attribute
    SortedSet<IAsset> outputPorts;
    /**
     * Unique name of the parent domain in which this asset exists.
     */
    @Attribute
    String parentDomainQualifiedName;
    /**
     * Unique name of the top-level domain in which this asset exists.
     */
    @Attribute
    String superDomainQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a DataProduct, from a potentially
     * more-complete DataProduct object.
     *
     * @return the minimal object necessary to relate to the DataProduct
     * @throws InvalidRequestException if any of the minimal set of required properties for a DataProduct relationship are not found in the initial object
     */
    @Override
    public DataProduct trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all DataProduct assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DataProduct assets will be included.
     *
     * @return a fluent search that includes all DataProduct assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all DataProduct assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DataProduct assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all DataProduct assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all DataProduct assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) DataProducts will be included
     * @return a fluent search that includes all DataProduct assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all DataProduct assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) DataProducts will be included
     * @return a fluent search that includes all DataProduct assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a DataProduct by GUID. Use this to create a relationship to this DataProduct,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the DataProduct to reference
     * @return reference to a DataProduct that can be used for defining a relationship to a DataProduct
     */
    public static DataProduct refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DataProduct by GUID. Use this to create a relationship to this DataProduct,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the DataProduct to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DataProduct that can be used for defining a relationship to a DataProduct
     */
    public static DataProduct refByGuid(String guid, Reference.SaveSemantic semantic) {
        return DataProduct._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a DataProduct by qualifiedName. Use this to create a relationship to this DataProduct,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the DataProduct to reference
     * @return reference to a DataProduct that can be used for defining a relationship to a DataProduct
     */
    public static DataProduct refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DataProduct by qualifiedName. Use this to create a relationship to this DataProduct,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the DataProduct to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DataProduct that can be used for defining a relationship to a DataProduct
     */
    public static DataProduct refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return DataProduct._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a DataProduct by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the DataProduct to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DataProduct, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DataProduct does not exist or the provided GUID is not a DataProduct
     */
    @JsonIgnore
    public static DataProduct get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a DataProduct by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DataProduct to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DataProduct, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DataProduct does not exist or the provided GUID is not a DataProduct
     */
    @JsonIgnore
    public static DataProduct get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a DataProduct by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DataProduct to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full DataProduct, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DataProduct does not exist or the provided GUID is not a DataProduct
     */
    @JsonIgnore
    public static DataProduct get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof DataProduct) {
                return (DataProduct) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof DataProduct) {
                return (DataProduct) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) DataProduct to active.
     *
     * @param qualifiedName for the DataProduct
     * @return true if the DataProduct is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) DataProduct to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the DataProduct
     * @return true if the DataProduct is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary for creating a DataProduct.
     *
     * @param name of the DataProduct
     * @param domainQualifiedName unique name of the DataDomain in which this product exists
     * @param assetSelection a query that defines which assets to include in the data product
     * @return the minimal request necessary to create the DataProduct, as a builder
     * @throws InvalidRequestException if the domain provided is without a qualifiedName
     */
    public static DataProductBuilder<?, ?> creator(String name, String domainQualifiedName, FluentSearch assetSelection) throws InvalidRequestException {
        return creator(Atlan.getDefaultClient(), name, domainQualifiedName, assetSelection);
    }

    /**
     * Builds the minimal object necessary for creating a DataProduct.
     *
     * @param client connectivity to the Atlan tenant where the DataProduct is intended to be created
     * @param name of the DataProduct
     * @param domainQualifiedName unique name of the DataDomain in which this product exists
     * @param assetSelection a query that defines which assets to include in the data product
     * @return the minimal request necessary to create the DataProduct, as a builder
     * @throws InvalidRequestException if the domain provided is without a qualifiedName
     */
    public static DataProductBuilder<?, ?> creator(AtlanClient client, String name, String domainQualifiedName, FluentSearch assetSelection) throws InvalidRequestException {
        return creator(name, domainQualifiedName, "").assetSelection(client, assetSelection);
    }

    /**
     * Builds the minimal object necessary for creating a DataProduct.
     *
     * @param name of the DataProduct
     * @param domainQualifiedName unique name of the DataDomain in which this product exists
     * @param assetSelection a query that defines which assets to include in the data product
     * @return the minimal request necessary to create the DataProduct, as a builder
     * @throws InvalidRequestException if the domain provided is without a qualifiedName
     */
    public static DataProductBuilder<?, ?> creator(String name, String domainQualifiedName, IndexSearchDSL assetSelection) throws InvalidRequestException {
        return creator(Atlan.getDefaultClient(), name, domainQualifiedName, assetSelection);
    }

    /**
     * Builds the minimal object necessary for creating a DataProduct.
     *
     * @param client connectivity to the Atlan tenant where the DataProduct is intended to be created
     * @param name of the DataProduct
     * @param domainQualifiedName unique name of the DataDomain in which this product exists
     * @param assetSelection a query that defines which assets to include in the data product
     * @return the minimal request necessary to create the DataProduct, as a builder
     */
    public static DataProductBuilder<?, ?> creator(AtlanClient client, String name, String domainQualifiedName, IndexSearchDSL assetSelection) {
        return DataProduct._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(domainQualifiedName + "/product/" + name).name(name).dataProductStatus(DataProductStatus.ACTIVE).parentDomainQualifiedName(domainQualifiedName).superDomainQualifiedName(StringUtils.getSuperDomainQualifiedName(domainQualifiedName)).dataDomain(DataDomain.refByQualifiedName(domainQualifiedName)).assetSelection(client, assetSelection).dataProductAssetsPlaybookFilter("{\"condition\":\"AND\",\"isGroupLocked\":false,\"rules\":[]}").daapStatus(DataProductStatus.ACTIVE);
    }

    /**
     * Builds the minimal object necessary for creating a DataProduct.
     *
     * @param name of the DataProduct
     * @param domainQualifiedName unique name of the DataDomain in which this product exists
     * @param assetSelection a string containing a query that defines which assets to include in the data product
     * @return the minimal request necessary to create the DataProduct, as a builder
     */
    public static DataProductBuilder<?, ?> creator(String name, String domainQualifiedName, String assetSelection) {
        return DataProduct._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(domainQualifiedName + "/product/" + name).name(name).dataProductStatus(DataProductStatus.ACTIVE).parentDomainQualifiedName(domainQualifiedName).superDomainQualifiedName(StringUtils.getSuperDomainQualifiedName(domainQualifiedName)).dataDomain(DataDomain.refByQualifiedName(domainQualifiedName)).dataProductAssetsDSL(assetSelection).dataProductAssetsPlaybookFilter("{\"condition\":\"AND\",\"isGroupLocked\":false,\"rules\":[]}").daapStatus(DataProductStatus.ACTIVE);
    }

    /**
     * Builds the minimal object necessary to update a DataProduct.
     *
     * @param qualifiedName of the DataProduct
     * @param name of the DataProduct
     * @return the minimal request necessary to update the DataProduct, as a builder
     */
    public static DataProductBuilder<?, ?> updater(String qualifiedName, String name) {
        return DataProduct._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a DataProduct, from a potentially
     * more-complete DataProduct object.
     *
     * @return the minimal object necessary to update the DataProduct, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for DataProduct are not found in the initial object
     */
    @Override
    public DataProductBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Find a DataProduct by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the domain, if found.
     * Note that domains are not unique by name, so there may be multiple results.
     *
     * @param name of the DataProduct
     * @return the DataProduct, if found
     * @throws AtlanException on any API problems, or if the DataProduct does not exist
     */
    public static List<DataProduct> findByName(String name) throws AtlanException {
        return findByName(name, (List<AtlanField>) null);
    }

    /**
     * Find a DataProduct by its human-readable name.
     * Note that domains are not unique by name, so there may be multiple results.
     *
     * @param name of the DataProduct
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the DataProduct
     * @return the DataProduct, if found
     * @throws AtlanException on any API problems, or if the DataProduct does not exist
     */
    public static List<DataProduct> findByName(String name, Collection<String> attributes) throws AtlanException {
        return findByName(Atlan.getDefaultClient(), name, attributes);
    }

    /**
     * Find a DataProduct by its human-readable name.
     * Note that domains are not unique by name, so there may be multiple results.
     *
     * @param name of the DataProduct
     * @param attributes an optional collection of attributes (checked) to retrieve for the DataProduct
     * @return the DataProduct, if found
     * @throws AtlanException on any API problems, or if the DataProduct does not exist
     */
    public static List<DataProduct> findByName(String name, List<AtlanField> attributes) throws AtlanException {
        return findByName(Atlan.getDefaultClient(), name, attributes);
    }

    /**
     * Find a DataProduct by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the domain, if found.
     *
     * @param client connectivity to the Atlan tenant on which to search for the DataProduct
     * @param name of the DataProduct
     * @return the DataProduct, if found
     * @throws AtlanException on any API problems, or if the DataProduct does not exist
     */
    public static List<DataProduct> findByName(AtlanClient client, String name) throws AtlanException {
        return findByName(client, name, (List<AtlanField>) null);
    }

    /**
     * Find a DataProduct by its human-readable name.
     * Note that domains are not unique by name, so there may be multiple results.
     *
     * @param client connectivity to the Atlan tenant on which to search for the DataProduct
     * @param name of the DataProduct
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the DataProduct
     * @return the DataProduct, if found
     * @throws AtlanException on any API problems, or if the DataProduct does not exist
     */
    public static List<DataProduct> findByName(AtlanClient client, String name, Collection<String> attributes) throws AtlanException {
        List<DataProduct> results = new ArrayList<>();
        DataProduct.select(client).where(DataProduct.NAME.eq(name))._includesOnResults(attributes == null ? Collections.emptyList() : attributes).stream().filter(a -> a instanceof DataProduct).forEach(d -> results.add((DataProduct) d));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        return results;
    }

    /**
     * Find a DataProduct by its human-readable name.
     * Note that domains are not unique by name, so there may be multiple results.
     *
     * @param client connectivity to the Atlan tenant on which to search for the DataProduct
     * @param name of the DataProduct
     * @param attributes an optional collection of attributes (checked) to retrieve for the DataProduct
     * @return the DataProduct, if found
     * @throws AtlanException on any API problems, or if the DataProduct does not exist
     */
    public static List<DataProduct> findByName(AtlanClient client, String name, List<AtlanField> attributes) throws AtlanException {
        List<DataProduct> results = new ArrayList<>();
        DataProduct.select(client).where(DataProduct.NAME.eq(name)).includesOnResults(attributes == null ? Collections.emptyList() : attributes).stream().filter(a -> a instanceof DataProduct).forEach(d -> results.add((DataProduct) d));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        return results;
    }


    public static abstract class DataProductBuilder<C extends DataProduct, B extends DataProductBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataProductCriticality daapCriticality;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> daapInputPortGuids;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> daapOutputPortGuids;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataProductSensitivity daapSensitivity;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataProductStatus daapStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataProductVisibility daapVisibility;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> daapVisibilityGroups;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> daapVisibilityUsers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IDataDomain dataDomain;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dataProductAssetsDSL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dataProductAssetsPlaybookFilter;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataProductCriticality dataProductCriticality;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dataProductScoreUpdatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double dataProductScoreValue;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataProductSensitivity dataProductSensitivity;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataProductStatus dataProductStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataProductVisibility dataProductVisibility;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAsset> inputPorts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAsset> outputPorts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String parentDomainQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String superDomainQualifiedName;

        /**
         * Change the selection of assets for the data product, based on the specified Atlan fluent search.
         *
         * @param client connectivity to an Atlan tenant
         * @param assetSelection fluent search query that defines the assets to include in the data product
         * @return the builder for the data product, with an updated set of criteria for its assets
         */
        public B assetSelection(AtlanClient client, FluentSearch assetSelection) {
            return assetSelection(client, IndexSearchDSL.of(assetSelection.toUnfilteredQuery()));
        }

        /**
         * Change the selection of assets for the data product, based on the specified Atlan search query.
         *
         * @param client connectivity to an Atlan tenant
         * @param assetSelection search query that defines the assets to include in the data product
         * @return the builder for the data product, with an updated set of criteria for its assets
         */
        public B assetSelection(AtlanClient client, IndexSearchDSL assetSelection) {
            return this.dataProductAssetsDSL(DataProductAssetsDSL.builder(assetSelection).build().toJson(client));
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            DataProduct.DataProductBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final DataProduct instance, final DataProduct.DataProductBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.daapCriticality(instance.daapCriticality);
            b.daapInputPortGuids(instance.daapInputPortGuids == null ? java.util.Collections.<String>emptySortedSet() : instance.daapInputPortGuids);
            b.daapOutputPortGuids(instance.daapOutputPortGuids == null ? java.util.Collections.<String>emptySortedSet() : instance.daapOutputPortGuids);
            b.daapSensitivity(instance.daapSensitivity);
            b.daapStatus(instance.daapStatus);
            b.daapVisibility(instance.daapVisibility);
            b.daapVisibilityGroups(instance.daapVisibilityGroups == null ? java.util.Collections.<String>emptySortedSet() : instance.daapVisibilityGroups);
            b.daapVisibilityUsers(instance.daapVisibilityUsers == null ? java.util.Collections.<String>emptySortedSet() : instance.daapVisibilityUsers);
            b.dataDomain(instance.dataDomain);
            b.dataProductAssetsDSL(instance.dataProductAssetsDSL);
            b.dataProductAssetsPlaybookFilter(instance.dataProductAssetsPlaybookFilter);
            b.dataProductCriticality(instance.dataProductCriticality);
            b.dataProductScoreUpdatedAt(instance.dataProductScoreUpdatedAt);
            b.dataProductScoreValue(instance.dataProductScoreValue);
            b.dataProductSensitivity(instance.dataProductSensitivity);
            b.dataProductStatus(instance.dataProductStatus);
            b.dataProductVisibility(instance.dataProductVisibility);
            b.inputPorts(instance.inputPorts == null ? java.util.Collections.<IAsset>emptySortedSet() : instance.inputPorts);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.outputPorts(instance.outputPorts == null ? java.util.Collections.<IAsset>emptySortedSet() : instance.outputPorts);
            b.parentDomainQualifiedName(instance.parentDomainQualifiedName);
            b.superDomainQualifiedName(instance.superDomainQualifiedName);
        }

        /**
         * Fixed typeName for DataProducts.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Criticality of this data product.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B daapCriticality(final DataProductCriticality daapCriticality) {
            this.daapCriticality = daapCriticality;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B daapInputPortGuid(final String daapInputPortGuid) {
            if (this.daapInputPortGuids == null) this.daapInputPortGuids = new java.util.ArrayList<String>();
            this.daapInputPortGuids.add(daapInputPortGuid);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B daapInputPortGuids(final java.util.Collection<? extends String> daapInputPortGuids) {
            if (daapInputPortGuids == null) {
                throw new java.lang.NullPointerException("daapInputPortGuids cannot be null");
            }
            if (this.daapInputPortGuids == null) this.daapInputPortGuids = new java.util.ArrayList<String>();
            this.daapInputPortGuids.addAll(daapInputPortGuids);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDaapInputPortGuids() {
            if (this.daapInputPortGuids != null) this.daapInputPortGuids.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B daapOutputPortGuid(final String daapOutputPortGuid) {
            if (this.daapOutputPortGuids == null) this.daapOutputPortGuids = new java.util.ArrayList<String>();
            this.daapOutputPortGuids.add(daapOutputPortGuid);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B daapOutputPortGuids(final java.util.Collection<? extends String> daapOutputPortGuids) {
            if (daapOutputPortGuids == null) {
                throw new java.lang.NullPointerException("daapOutputPortGuids cannot be null");
            }
            if (this.daapOutputPortGuids == null) this.daapOutputPortGuids = new java.util.ArrayList<String>();
            this.daapOutputPortGuids.addAll(daapOutputPortGuids);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDaapOutputPortGuids() {
            if (this.daapOutputPortGuids != null) this.daapOutputPortGuids.clear();
            return self();
        }

        /**
         * Information sensitivity of this data product.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B daapSensitivity(final DataProductSensitivity daapSensitivity) {
            this.daapSensitivity = daapSensitivity;
            return self();
        }

        /**
         * Status of this data product.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B daapStatus(final DataProductStatus daapStatus) {
            this.daapStatus = daapStatus;
            return self();
        }

        /**
         * Visibility of a data product.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B daapVisibility(final DataProductVisibility daapVisibility) {
            this.daapVisibility = daapVisibility;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B daapVisibilityGroup(final String daapVisibilityGroup) {
            if (this.daapVisibilityGroups == null) this.daapVisibilityGroups = new java.util.ArrayList<String>();
            this.daapVisibilityGroups.add(daapVisibilityGroup);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B daapVisibilityGroups(final java.util.Collection<? extends String> daapVisibilityGroups) {
            if (daapVisibilityGroups == null) {
                throw new java.lang.NullPointerException("daapVisibilityGroups cannot be null");
            }
            if (this.daapVisibilityGroups == null) this.daapVisibilityGroups = new java.util.ArrayList<String>();
            this.daapVisibilityGroups.addAll(daapVisibilityGroups);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDaapVisibilityGroups() {
            if (this.daapVisibilityGroups != null) this.daapVisibilityGroups.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B daapVisibilityUser(final String daapVisibilityUser) {
            if (this.daapVisibilityUsers == null) this.daapVisibilityUsers = new java.util.ArrayList<String>();
            this.daapVisibilityUsers.add(daapVisibilityUser);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B daapVisibilityUsers(final java.util.Collection<? extends String> daapVisibilityUsers) {
            if (daapVisibilityUsers == null) {
                throw new java.lang.NullPointerException("daapVisibilityUsers cannot be null");
            }
            if (this.daapVisibilityUsers == null) this.daapVisibilityUsers = new java.util.ArrayList<String>();
            this.daapVisibilityUsers.addAll(daapVisibilityUsers);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDaapVisibilityUsers() {
            if (this.daapVisibilityUsers != null) this.daapVisibilityUsers.clear();
            return self();
        }

        /**
         * Data domain in which this data product exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataDomain(final IDataDomain dataDomain) {
            this.dataDomain = dataDomain;
            return self();
        }

        /**
         * Search DSL used to define which assets are part of this data product.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataProductAssetsDSL(final String dataProductAssetsDSL) {
            this.dataProductAssetsDSL = dataProductAssetsDSL;
            return self();
        }

        /**
         * Playbook filter to define which assets are part of this data product.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataProductAssetsPlaybookFilter(final String dataProductAssetsPlaybookFilter) {
            this.dataProductAssetsPlaybookFilter = dataProductAssetsPlaybookFilter;
            return self();
        }

        /**
         * Criticality of this data product.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataProductCriticality(final DataProductCriticality dataProductCriticality) {
            this.dataProductCriticality = dataProductCriticality;
            return self();
        }

        /**
         * Timestamp when the score of this data product was last updated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataProductScoreUpdatedAt(final Long dataProductScoreUpdatedAt) {
            this.dataProductScoreUpdatedAt = dataProductScoreUpdatedAt;
            return self();
        }

        /**
         * Score of this data product.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataProductScoreValue(final Double dataProductScoreValue) {
            this.dataProductScoreValue = dataProductScoreValue;
            return self();
        }

        /**
         * Information sensitivity of this data product.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataProductSensitivity(final DataProductSensitivity dataProductSensitivity) {
            this.dataProductSensitivity = dataProductSensitivity;
            return self();
        }

        /**
         * Status of this data product.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataProductStatus(final DataProductStatus dataProductStatus) {
            this.dataProductStatus = dataProductStatus;
            return self();
        }

        /**
         * Visibility of a data product.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataProductVisibility(final DataProductVisibility dataProductVisibility) {
            this.dataProductVisibility = dataProductVisibility;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputPort(final IAsset inputPort) {
            if (this.inputPorts == null) this.inputPorts = new java.util.ArrayList<IAsset>();
            this.inputPorts.add(inputPort);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputPorts(final java.util.Collection<? extends IAsset> inputPorts) {
            if (inputPorts == null) {
                throw new java.lang.NullPointerException("inputPorts cannot be null");
            }
            if (this.inputPorts == null) this.inputPorts = new java.util.ArrayList<IAsset>();
            this.inputPorts.addAll(inputPorts);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputPorts() {
            if (this.inputPorts != null) this.inputPorts.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputPort(final IAsset outputPort) {
            if (this.outputPorts == null) this.outputPorts = new java.util.ArrayList<IAsset>();
            this.outputPorts.add(outputPort);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputPorts(final java.util.Collection<? extends IAsset> outputPorts) {
            if (outputPorts == null) {
                throw new java.lang.NullPointerException("outputPorts cannot be null");
            }
            if (this.outputPorts == null) this.outputPorts = new java.util.ArrayList<IAsset>();
            this.outputPorts.addAll(outputPorts);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputPorts() {
            if (this.outputPorts != null) this.outputPorts.clear();
            return self();
        }

        /**
         * Unique name of the parent domain in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B parentDomainQualifiedName(final String parentDomainQualifiedName) {
            this.parentDomainQualifiedName = parentDomainQualifiedName;
            return self();
        }

        /**
         * Unique name of the top-level domain in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B superDomainQualifiedName(final String superDomainQualifiedName) {
            this.superDomainQualifiedName = superDomainQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "DataProduct.DataProductBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", daapCriticality=" + this.daapCriticality + ", daapInputPortGuids=" + this.daapInputPortGuids + ", daapOutputPortGuids=" + this.daapOutputPortGuids + ", daapSensitivity=" + this.daapSensitivity + ", daapStatus=" + this.daapStatus + ", daapVisibility=" + this.daapVisibility + ", daapVisibilityGroups=" + this.daapVisibilityGroups + ", daapVisibilityUsers=" + this.daapVisibilityUsers + ", dataDomain=" + this.dataDomain + ", dataProductAssetsDSL=" + this.dataProductAssetsDSL + ", dataProductAssetsPlaybookFilter=" + this.dataProductAssetsPlaybookFilter + ", dataProductCriticality=" + this.dataProductCriticality + ", dataProductScoreUpdatedAt=" + this.dataProductScoreUpdatedAt + ", dataProductScoreValue=" + this.dataProductScoreValue + ", dataProductSensitivity=" + this.dataProductSensitivity + ", dataProductStatus=" + this.dataProductStatus + ", dataProductVisibility=" + this.dataProductVisibility + ", inputPorts=" + this.inputPorts + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", outputPorts=" + this.outputPorts + ", parentDomainQualifiedName=" + this.parentDomainQualifiedName + ", superDomainQualifiedName=" + this.superDomainQualifiedName + ")";
        }
    }

    /**
     * Remove the system description from a DataProduct.
     *
     * @param qualifiedName of the DataProduct
     * @param name of the DataProduct
     * @return the updated DataProduct, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a DataProduct.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DataProduct
     * @param name of the DataProduct
     * @return the updated DataProduct, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataProduct) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a DataProduct.
     *
     * @param qualifiedName of the DataProduct
     * @param name of the DataProduct
     * @return the updated DataProduct, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a DataProduct.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DataProduct
     * @param name of the DataProduct
     * @return the updated DataProduct, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataProduct) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a DataProduct.
     *
     * @param qualifiedName of the DataProduct
     * @param name of the DataProduct
     * @return the updated DataProduct, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a DataProduct.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DataProduct's owners
     * @param qualifiedName of the DataProduct
     * @param name of the DataProduct
     * @return the updated DataProduct, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataProduct) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a DataProduct.
     *
     * @param qualifiedName of the DataProduct
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DataProduct, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a DataProduct.
     *
     * @param client connectivity to the Atlan tenant on which to update the DataProduct's certificate
     * @param qualifiedName of the DataProduct
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DataProduct, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DataProduct) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a DataProduct.
     *
     * @param qualifiedName of the DataProduct
     * @param name of the DataProduct
     * @return the updated DataProduct, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a DataProduct.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DataProduct's certificate
     * @param qualifiedName of the DataProduct
     * @param name of the DataProduct
     * @return the updated DataProduct, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataProduct) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a DataProduct.
     *
     * @param qualifiedName of the DataProduct
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a DataProduct.
     *
     * @param client connectivity to the Atlan tenant on which to update the DataProduct's announcement
     * @param qualifiedName of the DataProduct
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DataProduct) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a DataProduct.
     *
     * @param qualifiedName of the DataProduct
     * @param name of the DataProduct
     * @return the updated DataProduct, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a DataProduct.
     *
     * @param client connectivity to the Atlan client from which to remove the DataProduct's announcement
     * @param qualifiedName of the DataProduct
     * @param name of the DataProduct
     * @return the updated DataProduct, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataProduct removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataProduct) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the DataProduct.
     *
     * @param qualifiedName for the DataProduct
     * @param name human-readable name of the DataProduct
     * @param terms the list of terms to replace on the DataProduct, or null to remove all terms from the DataProduct
     * @return the DataProduct that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DataProduct replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the DataProduct.
     *
     * @param client connectivity to the Atlan tenant on which to replace the DataProduct's assigned terms
     * @param qualifiedName for the DataProduct
     * @param name human-readable name of the DataProduct
     * @param terms the list of terms to replace on the DataProduct, or null to remove all terms from the DataProduct
     * @return the DataProduct that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DataProduct replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataProduct) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the DataProduct, without replacing existing terms linked to the DataProduct.
     * Note: this operation must make two API calls — one to retrieve the DataProduct's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the DataProduct
     * @param terms the list of terms to append to the DataProduct
     * @return the DataProduct that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DataProduct appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the DataProduct, without replacing existing terms linked to the DataProduct.
     * Note: this operation must make two API calls — one to retrieve the DataProduct's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the DataProduct
     * @param qualifiedName for the DataProduct
     * @param terms the list of terms to append to the DataProduct
     * @return the DataProduct that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DataProduct appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataProduct) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a DataProduct, without replacing all existing terms linked to the DataProduct.
     * Note: this operation must make two API calls — one to retrieve the DataProduct's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the DataProduct
     * @param terms the list of terms to remove from the DataProduct, which must be referenced by GUID
     * @return the DataProduct that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DataProduct removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a DataProduct, without replacing all existing terms linked to the DataProduct.
     * Note: this operation must make two API calls — one to retrieve the DataProduct's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the DataProduct
     * @param qualifiedName for the DataProduct
     * @param terms the list of terms to remove from the DataProduct, which must be referenced by GUID
     * @return the DataProduct that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DataProduct removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataProduct) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a DataProduct, without replacing existing Atlan tags linked to the DataProduct.
     * Note: this operation must make two API calls — one to retrieve the DataProduct's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DataProduct
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DataProduct
     */
    public static DataProduct appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DataProduct, without replacing existing Atlan tags linked to the DataProduct.
     * Note: this operation must make two API calls — one to retrieve the DataProduct's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DataProduct
     * @param qualifiedName of the DataProduct
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DataProduct
     */
    public static DataProduct appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DataProduct) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DataProduct, without replacing existing Atlan tags linked to the DataProduct.
     * Note: this operation must make two API calls — one to retrieve the DataProduct's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DataProduct
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DataProduct
     */
    public static DataProduct appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a DataProduct, without replacing existing Atlan tags linked to the DataProduct.
     * Note: this operation must make two API calls — one to retrieve the DataProduct's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DataProduct
     * @param qualifiedName of the DataProduct
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DataProduct
     */
    public static DataProduct appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DataProduct) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a DataProduct.
     *
     * @param qualifiedName of the DataProduct
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DataProduct
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a DataProduct.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a DataProduct
     * @param qualifiedName of the DataProduct
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DataProduct
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class DataProductBuilderImpl extends DataProduct.DataProductBuilder<DataProduct, DataProduct.DataProductBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataProductBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DataProduct.DataProductBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DataProduct build() {
            return new DataProduct(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected DataProduct(final DataProduct.DataProductBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = DataProduct.$default$typeName();
        this.daapCriticality = b.daapCriticality;
        java.util.SortedSet<String> daapInputPortGuids = new java.util.TreeSet<String>();
        if (b.daapInputPortGuids != null) daapInputPortGuids.addAll(b.daapInputPortGuids);
        daapInputPortGuids = java.util.Collections.unmodifiableSortedSet(daapInputPortGuids);
        this.daapInputPortGuids = daapInputPortGuids;
        java.util.SortedSet<String> daapOutputPortGuids = new java.util.TreeSet<String>();
        if (b.daapOutputPortGuids != null) daapOutputPortGuids.addAll(b.daapOutputPortGuids);
        daapOutputPortGuids = java.util.Collections.unmodifiableSortedSet(daapOutputPortGuids);
        this.daapOutputPortGuids = daapOutputPortGuids;
        this.daapSensitivity = b.daapSensitivity;
        this.daapStatus = b.daapStatus;
        this.daapVisibility = b.daapVisibility;
        java.util.SortedSet<String> daapVisibilityGroups = new java.util.TreeSet<String>();
        if (b.daapVisibilityGroups != null) daapVisibilityGroups.addAll(b.daapVisibilityGroups);
        daapVisibilityGroups = java.util.Collections.unmodifiableSortedSet(daapVisibilityGroups);
        this.daapVisibilityGroups = daapVisibilityGroups;
        java.util.SortedSet<String> daapVisibilityUsers = new java.util.TreeSet<String>();
        if (b.daapVisibilityUsers != null) daapVisibilityUsers.addAll(b.daapVisibilityUsers);
        daapVisibilityUsers = java.util.Collections.unmodifiableSortedSet(daapVisibilityUsers);
        this.daapVisibilityUsers = daapVisibilityUsers;
        this.dataDomain = b.dataDomain;
        this.dataProductAssetsDSL = b.dataProductAssetsDSL;
        this.dataProductAssetsPlaybookFilter = b.dataProductAssetsPlaybookFilter;
        this.dataProductCriticality = b.dataProductCriticality;
        this.dataProductScoreUpdatedAt = b.dataProductScoreUpdatedAt;
        this.dataProductScoreValue = b.dataProductScoreValue;
        this.dataProductSensitivity = b.dataProductSensitivity;
        this.dataProductStatus = b.dataProductStatus;
        this.dataProductVisibility = b.dataProductVisibility;
        java.util.SortedSet<IAsset> inputPorts = new java.util.TreeSet<IAsset>();
        if (b.inputPorts != null) inputPorts.addAll(b.inputPorts);
        inputPorts = java.util.Collections.unmodifiableSortedSet(inputPorts);
        this.inputPorts = inputPorts;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.SortedSet<IAsset> outputPorts = new java.util.TreeSet<IAsset>();
        if (b.outputPorts != null) outputPorts.addAll(b.outputPorts);
        outputPorts = java.util.Collections.unmodifiableSortedSet(outputPorts);
        this.outputPorts = outputPorts;
        this.parentDomainQualifiedName = b.parentDomainQualifiedName;
        this.superDomainQualifiedName = b.superDomainQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static DataProduct.DataProductBuilder<?, ?> _internal() {
        return new DataProduct.DataProductBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataProduct.DataProductBuilder<?, ?> toBuilder() {
        return new DataProduct.DataProductBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Criticality of this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataProductCriticality getDaapCriticality() {
        return this.daapCriticality;
    }

    /**
     * Input ports guids for this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDaapInputPortGuids() {
        return this.daapInputPortGuids;
    }

    /**
     * Output ports guids for this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDaapOutputPortGuids() {
        return this.daapOutputPortGuids;
    }

    /**
     * Information sensitivity of this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataProductSensitivity getDaapSensitivity() {
        return this.daapSensitivity;
    }

    /**
     * Status of this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataProductStatus getDaapStatus() {
        return this.daapStatus;
    }

    /**
     * Visibility of a data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataProductVisibility getDaapVisibility() {
        return this.daapVisibility;
    }

    /**
     * list of groups for product visibility control
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDaapVisibilityGroups() {
        return this.daapVisibilityGroups;
    }

    /**
     * list of users for product visibility control
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDaapVisibilityUsers() {
        return this.daapVisibilityUsers;
    }

    /**
     * Data domain in which this data product exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IDataDomain getDataDomain() {
        return this.dataDomain;
    }

    /**
     * Search DSL used to define which assets are part of this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataProductAssetsDSL() {
        return this.dataProductAssetsDSL;
    }

    /**
     * Playbook filter to define which assets are part of this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataProductAssetsPlaybookFilter() {
        return this.dataProductAssetsPlaybookFilter;
    }

    /**
     * Criticality of this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataProductCriticality getDataProductCriticality() {
        return this.dataProductCriticality;
    }

    /**
     * Timestamp when the score of this data product was last updated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDataProductScoreUpdatedAt() {
        return this.dataProductScoreUpdatedAt;
    }

    /**
     * Score of this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getDataProductScoreValue() {
        return this.dataProductScoreValue;
    }

    /**
     * Information sensitivity of this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataProductSensitivity getDataProductSensitivity() {
        return this.dataProductSensitivity;
    }

    /**
     * Status of this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataProductStatus getDataProductStatus() {
        return this.dataProductStatus;
    }

    /**
     * Visibility of a data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataProductVisibility getDataProductVisibility() {
        return this.dataProductVisibility;
    }

    /**
     * Input ports for this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAsset> getInputPorts() {
        return this.inputPorts;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Output ports for this data product.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAsset> getOutputPorts() {
        return this.outputPorts;
    }

    /**
     * Unique name of the parent domain in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getParentDomainQualifiedName() {
        return this.parentDomainQualifiedName;
    }

    /**
     * Unique name of the top-level domain in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSuperDomainQualifiedName() {
        return this.superDomainQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DataProduct)) return false;
        final DataProduct other = (DataProduct) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$dataProductScoreUpdatedAt = this.getDataProductScoreUpdatedAt();
        final java.lang.Object other$dataProductScoreUpdatedAt = other.getDataProductScoreUpdatedAt();
        if (this$dataProductScoreUpdatedAt == null ? other$dataProductScoreUpdatedAt != null : !this$dataProductScoreUpdatedAt.equals(other$dataProductScoreUpdatedAt)) return false;
        final java.lang.Object this$dataProductScoreValue = this.getDataProductScoreValue();
        final java.lang.Object other$dataProductScoreValue = other.getDataProductScoreValue();
        if (this$dataProductScoreValue == null ? other$dataProductScoreValue != null : !this$dataProductScoreValue.equals(other$dataProductScoreValue)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$daapCriticality = this.getDaapCriticality();
        final java.lang.Object other$daapCriticality = other.getDaapCriticality();
        if (this$daapCriticality == null ? other$daapCriticality != null : !this$daapCriticality.equals(other$daapCriticality)) return false;
        final java.lang.Object this$daapInputPortGuids = this.getDaapInputPortGuids();
        final java.lang.Object other$daapInputPortGuids = other.getDaapInputPortGuids();
        if (this$daapInputPortGuids == null ? other$daapInputPortGuids != null : !this$daapInputPortGuids.equals(other$daapInputPortGuids)) return false;
        final java.lang.Object this$daapOutputPortGuids = this.getDaapOutputPortGuids();
        final java.lang.Object other$daapOutputPortGuids = other.getDaapOutputPortGuids();
        if (this$daapOutputPortGuids == null ? other$daapOutputPortGuids != null : !this$daapOutputPortGuids.equals(other$daapOutputPortGuids)) return false;
        final java.lang.Object this$daapSensitivity = this.getDaapSensitivity();
        final java.lang.Object other$daapSensitivity = other.getDaapSensitivity();
        if (this$daapSensitivity == null ? other$daapSensitivity != null : !this$daapSensitivity.equals(other$daapSensitivity)) return false;
        final java.lang.Object this$daapStatus = this.getDaapStatus();
        final java.lang.Object other$daapStatus = other.getDaapStatus();
        if (this$daapStatus == null ? other$daapStatus != null : !this$daapStatus.equals(other$daapStatus)) return false;
        final java.lang.Object this$daapVisibility = this.getDaapVisibility();
        final java.lang.Object other$daapVisibility = other.getDaapVisibility();
        if (this$daapVisibility == null ? other$daapVisibility != null : !this$daapVisibility.equals(other$daapVisibility)) return false;
        final java.lang.Object this$daapVisibilityGroups = this.getDaapVisibilityGroups();
        final java.lang.Object other$daapVisibilityGroups = other.getDaapVisibilityGroups();
        if (this$daapVisibilityGroups == null ? other$daapVisibilityGroups != null : !this$daapVisibilityGroups.equals(other$daapVisibilityGroups)) return false;
        final java.lang.Object this$daapVisibilityUsers = this.getDaapVisibilityUsers();
        final java.lang.Object other$daapVisibilityUsers = other.getDaapVisibilityUsers();
        if (this$daapVisibilityUsers == null ? other$daapVisibilityUsers != null : !this$daapVisibilityUsers.equals(other$daapVisibilityUsers)) return false;
        final java.lang.Object this$dataDomain = this.getDataDomain();
        final java.lang.Object other$dataDomain = other.getDataDomain();
        if (this$dataDomain == null ? other$dataDomain != null : !this$dataDomain.equals(other$dataDomain)) return false;
        final java.lang.Object this$dataProductAssetsDSL = this.getDataProductAssetsDSL();
        final java.lang.Object other$dataProductAssetsDSL = other.getDataProductAssetsDSL();
        if (this$dataProductAssetsDSL == null ? other$dataProductAssetsDSL != null : !this$dataProductAssetsDSL.equals(other$dataProductAssetsDSL)) return false;
        final java.lang.Object this$dataProductAssetsPlaybookFilter = this.getDataProductAssetsPlaybookFilter();
        final java.lang.Object other$dataProductAssetsPlaybookFilter = other.getDataProductAssetsPlaybookFilter();
        if (this$dataProductAssetsPlaybookFilter == null ? other$dataProductAssetsPlaybookFilter != null : !this$dataProductAssetsPlaybookFilter.equals(other$dataProductAssetsPlaybookFilter)) return false;
        final java.lang.Object this$dataProductCriticality = this.getDataProductCriticality();
        final java.lang.Object other$dataProductCriticality = other.getDataProductCriticality();
        if (this$dataProductCriticality == null ? other$dataProductCriticality != null : !this$dataProductCriticality.equals(other$dataProductCriticality)) return false;
        final java.lang.Object this$dataProductSensitivity = this.getDataProductSensitivity();
        final java.lang.Object other$dataProductSensitivity = other.getDataProductSensitivity();
        if (this$dataProductSensitivity == null ? other$dataProductSensitivity != null : !this$dataProductSensitivity.equals(other$dataProductSensitivity)) return false;
        final java.lang.Object this$dataProductStatus = this.getDataProductStatus();
        final java.lang.Object other$dataProductStatus = other.getDataProductStatus();
        if (this$dataProductStatus == null ? other$dataProductStatus != null : !this$dataProductStatus.equals(other$dataProductStatus)) return false;
        final java.lang.Object this$dataProductVisibility = this.getDataProductVisibility();
        final java.lang.Object other$dataProductVisibility = other.getDataProductVisibility();
        if (this$dataProductVisibility == null ? other$dataProductVisibility != null : !this$dataProductVisibility.equals(other$dataProductVisibility)) return false;
        final java.lang.Object this$inputPorts = this.getInputPorts();
        final java.lang.Object other$inputPorts = other.getInputPorts();
        if (this$inputPorts == null ? other$inputPorts != null : !this$inputPorts.equals(other$inputPorts)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$outputPorts = this.getOutputPorts();
        final java.lang.Object other$outputPorts = other.getOutputPorts();
        if (this$outputPorts == null ? other$outputPorts != null : !this$outputPorts.equals(other$outputPorts)) return false;
        final java.lang.Object this$parentDomainQualifiedName = this.getParentDomainQualifiedName();
        final java.lang.Object other$parentDomainQualifiedName = other.getParentDomainQualifiedName();
        if (this$parentDomainQualifiedName == null ? other$parentDomainQualifiedName != null : !this$parentDomainQualifiedName.equals(other$parentDomainQualifiedName)) return false;
        final java.lang.Object this$superDomainQualifiedName = this.getSuperDomainQualifiedName();
        final java.lang.Object other$superDomainQualifiedName = other.getSuperDomainQualifiedName();
        if (this$superDomainQualifiedName == null ? other$superDomainQualifiedName != null : !this$superDomainQualifiedName.equals(other$superDomainQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof DataProduct;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $dataProductScoreUpdatedAt = this.getDataProductScoreUpdatedAt();
        result = result * PRIME + ($dataProductScoreUpdatedAt == null ? 43 : $dataProductScoreUpdatedAt.hashCode());
        final java.lang.Object $dataProductScoreValue = this.getDataProductScoreValue();
        result = result * PRIME + ($dataProductScoreValue == null ? 43 : $dataProductScoreValue.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $daapCriticality = this.getDaapCriticality();
        result = result * PRIME + ($daapCriticality == null ? 43 : $daapCriticality.hashCode());
        final java.lang.Object $daapInputPortGuids = this.getDaapInputPortGuids();
        result = result * PRIME + ($daapInputPortGuids == null ? 43 : $daapInputPortGuids.hashCode());
        final java.lang.Object $daapOutputPortGuids = this.getDaapOutputPortGuids();
        result = result * PRIME + ($daapOutputPortGuids == null ? 43 : $daapOutputPortGuids.hashCode());
        final java.lang.Object $daapSensitivity = this.getDaapSensitivity();
        result = result * PRIME + ($daapSensitivity == null ? 43 : $daapSensitivity.hashCode());
        final java.lang.Object $daapStatus = this.getDaapStatus();
        result = result * PRIME + ($daapStatus == null ? 43 : $daapStatus.hashCode());
        final java.lang.Object $daapVisibility = this.getDaapVisibility();
        result = result * PRIME + ($daapVisibility == null ? 43 : $daapVisibility.hashCode());
        final java.lang.Object $daapVisibilityGroups = this.getDaapVisibilityGroups();
        result = result * PRIME + ($daapVisibilityGroups == null ? 43 : $daapVisibilityGroups.hashCode());
        final java.lang.Object $daapVisibilityUsers = this.getDaapVisibilityUsers();
        result = result * PRIME + ($daapVisibilityUsers == null ? 43 : $daapVisibilityUsers.hashCode());
        final java.lang.Object $dataDomain = this.getDataDomain();
        result = result * PRIME + ($dataDomain == null ? 43 : $dataDomain.hashCode());
        final java.lang.Object $dataProductAssetsDSL = this.getDataProductAssetsDSL();
        result = result * PRIME + ($dataProductAssetsDSL == null ? 43 : $dataProductAssetsDSL.hashCode());
        final java.lang.Object $dataProductAssetsPlaybookFilter = this.getDataProductAssetsPlaybookFilter();
        result = result * PRIME + ($dataProductAssetsPlaybookFilter == null ? 43 : $dataProductAssetsPlaybookFilter.hashCode());
        final java.lang.Object $dataProductCriticality = this.getDataProductCriticality();
        result = result * PRIME + ($dataProductCriticality == null ? 43 : $dataProductCriticality.hashCode());
        final java.lang.Object $dataProductSensitivity = this.getDataProductSensitivity();
        result = result * PRIME + ($dataProductSensitivity == null ? 43 : $dataProductSensitivity.hashCode());
        final java.lang.Object $dataProductStatus = this.getDataProductStatus();
        result = result * PRIME + ($dataProductStatus == null ? 43 : $dataProductStatus.hashCode());
        final java.lang.Object $dataProductVisibility = this.getDataProductVisibility();
        result = result * PRIME + ($dataProductVisibility == null ? 43 : $dataProductVisibility.hashCode());
        final java.lang.Object $inputPorts = this.getInputPorts();
        result = result * PRIME + ($inputPorts == null ? 43 : $inputPorts.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $outputPorts = this.getOutputPorts();
        result = result * PRIME + ($outputPorts == null ? 43 : $outputPorts.hashCode());
        final java.lang.Object $parentDomainQualifiedName = this.getParentDomainQualifiedName();
        result = result * PRIME + ($parentDomainQualifiedName == null ? 43 : $parentDomainQualifiedName.hashCode());
        final java.lang.Object $superDomainQualifiedName = this.getSuperDomainQualifiedName();
        result = result * PRIME + ($superDomainQualifiedName == null ? 43 : $superDomainQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "DataProduct(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", daapCriticality=" + this.getDaapCriticality() + ", daapInputPortGuids=" + this.getDaapInputPortGuids() + ", daapOutputPortGuids=" + this.getDaapOutputPortGuids() + ", daapSensitivity=" + this.getDaapSensitivity() + ", daapStatus=" + this.getDaapStatus() + ", daapVisibility=" + this.getDaapVisibility() + ", daapVisibilityGroups=" + this.getDaapVisibilityGroups() + ", daapVisibilityUsers=" + this.getDaapVisibilityUsers() + ", dataDomain=" + this.getDataDomain() + ", dataProductAssetsDSL=" + this.getDataProductAssetsDSL() + ", dataProductAssetsPlaybookFilter=" + this.getDataProductAssetsPlaybookFilter() + ", dataProductCriticality=" + this.getDataProductCriticality() + ", dataProductScoreUpdatedAt=" + this.getDataProductScoreUpdatedAt() + ", dataProductScoreValue=" + this.getDataProductScoreValue() + ", dataProductSensitivity=" + this.getDataProductSensitivity() + ", dataProductStatus=" + this.getDataProductStatus() + ", dataProductVisibility=" + this.getDataProductVisibility() + ", inputPorts=" + this.getInputPorts() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", outputPorts=" + this.getOutputPorts() + ", parentDomainQualifiedName=" + this.getParentDomainQualifiedName() + ", superDomainQualifiedName=" + this.getSuperDomainQualifiedName() + ")";
    }

    /**
     * Fixed typeName for DataProducts.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
