// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.GoogleDataStudioAssetType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.GoogleLabel;
import com.atlan.model.structs.GoogleTag;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Google Data Studio asset in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class DataStudioAsset extends Asset implements IDataStudioAsset, IDataStudio, IGoogle, IBI, ICloud, IAsset, IReferenceable, ICatalog {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(DataStudioAsset.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DataStudioAsset";
    /**
     * Fixed typeName for DataStudioAssets.
     */
    String typeName;
    /**
     * Owner of the asset, from Google Data Studio.
     */
    @Attribute
    String dataStudioAssetOwner;
    /**
     * Title of the Google Data Studio asset.
     */
    @Attribute
    String dataStudioAssetTitle;
    /**
     * Type of the Google Data Studio asset, for example: REPORT or DATA_SOURCE.
     */
    @Attribute
    GoogleDataStudioAssetType dataStudioAssetType;
    /**
     * List of labels that have been applied to the asset in Google.
     */
    @Attribute
    List<GoogleLabel> googleLabels;
    /**
     * Location of this asset in Google.
     */
    @Attribute
    String googleLocation;
    /**
     * Type of location of this asset in Google.
     */
    @Attribute
    String googleLocationType;
    /**
     * ID of the project in which the asset exists.
     */
    @Attribute
    String googleProjectId;
    /**
     * Name of the project in which the asset exists.
     */
    @Attribute
    String googleProjectName;
    /**
     * Number of the project in which the asset exists.
     */
    @Attribute
    Long googleProjectNumber;
    /**
     * Service in Google in which the asset exists.
     */
    @Attribute
    String googleService;
    /**
     * List of tags that have been applied to the asset in Google.
     */
    @Attribute
    List<GoogleTag> googleTags;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Whether the Google Data Studio asset has been trashed (true) or not (false).
     */
    @Attribute
    Boolean isTrashedDataStudioAsset;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a DataStudioAsset, from a potentially
     * more-complete DataStudioAsset object.
     *
     * @return the minimal object necessary to relate to the DataStudioAsset
     * @throws InvalidRequestException if any of the minimal set of required properties for a DataStudioAsset relationship are not found in the initial object
     */
    @Override
    public DataStudioAsset trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all DataStudioAsset assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DataStudioAsset assets will be included.
     *
     * @return a fluent search that includes all DataStudioAsset assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all DataStudioAsset assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DataStudioAsset assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all DataStudioAsset assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all DataStudioAsset assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) DataStudioAssets will be included
     * @return a fluent search that includes all DataStudioAsset assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all DataStudioAsset assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) DataStudioAssets will be included
     * @return a fluent search that includes all DataStudioAsset assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a DataStudioAsset by GUID. Use this to create a relationship to this DataStudioAsset,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the DataStudioAsset to reference
     * @return reference to a DataStudioAsset that can be used for defining a relationship to a DataStudioAsset
     */
    public static DataStudioAsset refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DataStudioAsset by GUID. Use this to create a relationship to this DataStudioAsset,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the DataStudioAsset to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DataStudioAsset that can be used for defining a relationship to a DataStudioAsset
     */
    public static DataStudioAsset refByGuid(String guid, Reference.SaveSemantic semantic) {
        return DataStudioAsset._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a DataStudioAsset by qualifiedName. Use this to create a relationship to this DataStudioAsset,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the DataStudioAsset to reference
     * @return reference to a DataStudioAsset that can be used for defining a relationship to a DataStudioAsset
     */
    public static DataStudioAsset refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DataStudioAsset by qualifiedName. Use this to create a relationship to this DataStudioAsset,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the DataStudioAsset to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DataStudioAsset that can be used for defining a relationship to a DataStudioAsset
     */
    public static DataStudioAsset refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return DataStudioAsset._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a DataStudioAsset by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the DataStudioAsset to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DataStudioAsset, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DataStudioAsset does not exist or the provided GUID is not a DataStudioAsset
     */
    @JsonIgnore
    public static DataStudioAsset get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a DataStudioAsset by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DataStudioAsset to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DataStudioAsset, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DataStudioAsset does not exist or the provided GUID is not a DataStudioAsset
     */
    @JsonIgnore
    public static DataStudioAsset get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a DataStudioAsset by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DataStudioAsset to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full DataStudioAsset, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DataStudioAsset does not exist or the provided GUID is not a DataStudioAsset
     */
    @JsonIgnore
    public static DataStudioAsset get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof DataStudioAsset) {
                return (DataStudioAsset) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof DataStudioAsset) {
                return (DataStudioAsset) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) DataStudioAsset to active.
     *
     * @param qualifiedName for the DataStudioAsset
     * @return true if the DataStudioAsset is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) DataStudioAsset to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the DataStudioAsset
     * @return true if the DataStudioAsset is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a Google Data Studio asset.
     *
     * @param name of the asset
     * @param connectionQualifiedName unique name of the connection through which the asset is accessible
     * @param assetType type of the asset
     * @return the minimal object necessary to create the asset, as a builder
     */
    public static DataStudioAssetBuilder<?, ?> creator(String name, String connectionQualifiedName, GoogleDataStudioAssetType assetType) {
        return DataStudioAsset.creator(name, connectionQualifiedName, assetType, UUID.randomUUID().toString());
    }

    /**
     * Builds the minimal object necessary to create a Google Data Studio asset.
     *
     * @param name of the asset
     * @param connectionQualifiedName unique name of the connection through which the asset is accessible
     * @param assetType type of the asset
     * @param gdsId unique identifier of the asset within Google Data Studio
     * @return the minimal object necessary to create the asset, as a builder
     */
    public static DataStudioAssetBuilder<?, ?> creator(String name, String connectionQualifiedName, GoogleDataStudioAssetType assetType, String gdsId) {
        return DataStudioAsset._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(generateQualifiedName(gdsId, connectionQualifiedName)).name(name).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.DATASTUDIO).dataStudioAssetType(assetType);
    }

    /**
     * Generate a unique DataStudioAsset name.
     *
     * @param gdsId unique identifier of the asset within Google Data Studio
     * @param connectionQualifiedName unique name of the connection through which the DataStudioAsset is accessible
     * @return a unique name for the DataStudioAsset
     */
    public static String generateQualifiedName(String gdsId, String connectionQualifiedName) {
        return connectionQualifiedName + "/" + gdsId;
    }

    /**
     * Builds the minimal object necessary to update a DataStudioAsset.
     *
     * @param qualifiedName of the DataStudioAsset
     * @param name of the DataStudioAsset
     * @return the minimal request necessary to update the DataStudioAsset, as a builder
     */
    public static DataStudioAssetBuilder<?, ?> updater(String qualifiedName, String name) {
        return DataStudioAsset._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a DataStudioAsset, from a potentially
     * more-complete DataStudioAsset object.
     *
     * @return the minimal object necessary to update the DataStudioAsset, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for DataStudioAsset are not found in the initial object
     */
    @Override
    public DataStudioAssetBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a DataStudioAsset.
     *
     * @param qualifiedName of the DataStudioAsset
     * @param name of the DataStudioAsset
     * @return the updated DataStudioAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a DataStudioAsset.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DataStudioAsset
     * @param name of the DataStudioAsset
     * @return the updated DataStudioAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a DataStudioAsset.
     *
     * @param qualifiedName of the DataStudioAsset
     * @param name of the DataStudioAsset
     * @return the updated DataStudioAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a DataStudioAsset.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DataStudioAsset
     * @param name of the DataStudioAsset
     * @return the updated DataStudioAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a DataStudioAsset.
     *
     * @param qualifiedName of the DataStudioAsset
     * @param name of the DataStudioAsset
     * @return the updated DataStudioAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a DataStudioAsset.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DataStudioAsset's owners
     * @param qualifiedName of the DataStudioAsset
     * @param name of the DataStudioAsset
     * @return the updated DataStudioAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a DataStudioAsset.
     *
     * @param qualifiedName of the DataStudioAsset
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DataStudioAsset, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a DataStudioAsset.
     *
     * @param client connectivity to the Atlan tenant on which to update the DataStudioAsset's certificate
     * @param qualifiedName of the DataStudioAsset
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DataStudioAsset, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DataStudioAsset) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a DataStudioAsset.
     *
     * @param qualifiedName of the DataStudioAsset
     * @param name of the DataStudioAsset
     * @return the updated DataStudioAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a DataStudioAsset.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DataStudioAsset's certificate
     * @param qualifiedName of the DataStudioAsset
     * @param name of the DataStudioAsset
     * @return the updated DataStudioAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a DataStudioAsset.
     *
     * @param qualifiedName of the DataStudioAsset
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a DataStudioAsset.
     *
     * @param client connectivity to the Atlan tenant on which to update the DataStudioAsset's announcement
     * @param qualifiedName of the DataStudioAsset
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DataStudioAsset) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a DataStudioAsset.
     *
     * @param qualifiedName of the DataStudioAsset
     * @param name of the DataStudioAsset
     * @return the updated DataStudioAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a DataStudioAsset.
     *
     * @param client connectivity to the Atlan client from which to remove the DataStudioAsset's announcement
     * @param qualifiedName of the DataStudioAsset
     * @param name of the DataStudioAsset
     * @return the updated DataStudioAsset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the DataStudioAsset.
     *
     * @param qualifiedName for the DataStudioAsset
     * @param name human-readable name of the DataStudioAsset
     * @param terms the list of terms to replace on the DataStudioAsset, or null to remove all terms from the DataStudioAsset
     * @return the DataStudioAsset that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the DataStudioAsset.
     *
     * @param client connectivity to the Atlan tenant on which to replace the DataStudioAsset's assigned terms
     * @param qualifiedName for the DataStudioAsset
     * @param name human-readable name of the DataStudioAsset
     * @param terms the list of terms to replace on the DataStudioAsset, or null to remove all terms from the DataStudioAsset
     * @return the DataStudioAsset that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataStudioAsset) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the DataStudioAsset, without replacing existing terms linked to the DataStudioAsset.
     * Note: this operation must make two API calls — one to retrieve the DataStudioAsset's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the DataStudioAsset
     * @param terms the list of terms to append to the DataStudioAsset
     * @return the DataStudioAsset that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the DataStudioAsset, without replacing existing terms linked to the DataStudioAsset.
     * Note: this operation must make two API calls — one to retrieve the DataStudioAsset's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the DataStudioAsset
     * @param qualifiedName for the DataStudioAsset
     * @param terms the list of terms to append to the DataStudioAsset
     * @return the DataStudioAsset that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataStudioAsset) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a DataStudioAsset, without replacing all existing terms linked to the DataStudioAsset.
     * Note: this operation must make two API calls — one to retrieve the DataStudioAsset's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the DataStudioAsset
     * @param terms the list of terms to remove from the DataStudioAsset, which must be referenced by GUID
     * @return the DataStudioAsset that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a DataStudioAsset, without replacing all existing terms linked to the DataStudioAsset.
     * Note: this operation must make two API calls — one to retrieve the DataStudioAsset's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the DataStudioAsset
     * @param qualifiedName for the DataStudioAsset
     * @param terms the list of terms to remove from the DataStudioAsset, which must be referenced by GUID
     * @return the DataStudioAsset that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DataStudioAsset removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataStudioAsset) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a DataStudioAsset, without replacing existing Atlan tags linked to the DataStudioAsset.
     * Note: this operation must make two API calls — one to retrieve the DataStudioAsset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DataStudioAsset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DataStudioAsset
     */
    public static DataStudioAsset appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DataStudioAsset, without replacing existing Atlan tags linked to the DataStudioAsset.
     * Note: this operation must make two API calls — one to retrieve the DataStudioAsset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DataStudioAsset
     * @param qualifiedName of the DataStudioAsset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DataStudioAsset
     */
    public static DataStudioAsset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DataStudioAsset) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DataStudioAsset, without replacing existing Atlan tags linked to the DataStudioAsset.
     * Note: this operation must make two API calls — one to retrieve the DataStudioAsset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DataStudioAsset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DataStudioAsset
     */
    public static DataStudioAsset appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a DataStudioAsset, without replacing existing Atlan tags linked to the DataStudioAsset.
     * Note: this operation must make two API calls — one to retrieve the DataStudioAsset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DataStudioAsset
     * @param qualifiedName of the DataStudioAsset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DataStudioAsset
     */
    public static DataStudioAsset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DataStudioAsset) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a DataStudioAsset.
     *
     * @param qualifiedName of the DataStudioAsset
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DataStudioAsset
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a DataStudioAsset.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a DataStudioAsset
     * @param qualifiedName of the DataStudioAsset
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DataStudioAsset
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class DataStudioAssetBuilder<C extends DataStudioAsset, B extends DataStudioAsset.DataStudioAssetBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dataStudioAssetOwner;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dataStudioAssetTitle;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private GoogleDataStudioAssetType dataStudioAssetType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<GoogleLabel> googleLabels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String googleLocation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String googleLocationType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String googleProjectId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String googleProjectName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long googleProjectNumber;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String googleService;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<GoogleTag> googleTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isTrashedDataStudioAsset;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            DataStudioAsset.DataStudioAssetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final DataStudioAsset instance, final DataStudioAsset.DataStudioAssetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dataStudioAssetOwner(instance.dataStudioAssetOwner);
            b.dataStudioAssetTitle(instance.dataStudioAssetTitle);
            b.dataStudioAssetType(instance.dataStudioAssetType);
            b.googleLabels(instance.googleLabels == null ? java.util.Collections.<GoogleLabel>emptyList() : instance.googleLabels);
            b.googleLocation(instance.googleLocation);
            b.googleLocationType(instance.googleLocationType);
            b.googleProjectId(instance.googleProjectId);
            b.googleProjectName(instance.googleProjectName);
            b.googleProjectNumber(instance.googleProjectNumber);
            b.googleService(instance.googleService);
            b.googleTags(instance.googleTags == null ? java.util.Collections.<GoogleTag>emptyList() : instance.googleTags);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.isTrashedDataStudioAsset(instance.isTrashedDataStudioAsset);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for DataStudioAssets.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Owner of the asset, from Google Data Studio.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataStudioAssetOwner(final String dataStudioAssetOwner) {
            this.dataStudioAssetOwner = dataStudioAssetOwner;
            return self();
        }

        /**
         * Title of the Google Data Studio asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataStudioAssetTitle(final String dataStudioAssetTitle) {
            this.dataStudioAssetTitle = dataStudioAssetTitle;
            return self();
        }

        /**
         * Type of the Google Data Studio asset, for example: REPORT or DATA_SOURCE.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataStudioAssetType(final GoogleDataStudioAssetType dataStudioAssetType) {
            this.dataStudioAssetType = dataStudioAssetType;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleLabel(final GoogleLabel googleLabel) {
            if (this.googleLabels == null) this.googleLabels = new java.util.ArrayList<GoogleLabel>();
            this.googleLabels.add(googleLabel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleLabels(final java.util.Collection<? extends GoogleLabel> googleLabels) {
            if (googleLabels == null) {
                throw new java.lang.NullPointerException("googleLabels cannot be null");
            }
            if (this.googleLabels == null) this.googleLabels = new java.util.ArrayList<GoogleLabel>();
            this.googleLabels.addAll(googleLabels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearGoogleLabels() {
            if (this.googleLabels != null) this.googleLabels.clear();
            return self();
        }

        /**
         * Location of this asset in Google.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleLocation(final String googleLocation) {
            this.googleLocation = googleLocation;
            return self();
        }

        /**
         * Type of location of this asset in Google.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleLocationType(final String googleLocationType) {
            this.googleLocationType = googleLocationType;
            return self();
        }

        /**
         * ID of the project in which the asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleProjectId(final String googleProjectId) {
            this.googleProjectId = googleProjectId;
            return self();
        }

        /**
         * Name of the project in which the asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleProjectName(final String googleProjectName) {
            this.googleProjectName = googleProjectName;
            return self();
        }

        /**
         * Number of the project in which the asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleProjectNumber(final Long googleProjectNumber) {
            this.googleProjectNumber = googleProjectNumber;
            return self();
        }

        /**
         * Service in Google in which the asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleService(final String googleService) {
            this.googleService = googleService;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleTag(final GoogleTag googleTag) {
            if (this.googleTags == null) this.googleTags = new java.util.ArrayList<GoogleTag>();
            this.googleTags.add(googleTag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleTags(final java.util.Collection<? extends GoogleTag> googleTags) {
            if (googleTags == null) {
                throw new java.lang.NullPointerException("googleTags cannot be null");
            }
            if (this.googleTags == null) this.googleTags = new java.util.ArrayList<GoogleTag>();
            this.googleTags.addAll(googleTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearGoogleTags() {
            if (this.googleTags != null) this.googleTags.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Whether the Google Data Studio asset has been trashed (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isTrashedDataStudioAsset(final Boolean isTrashedDataStudioAsset) {
            this.isTrashedDataStudioAsset = isTrashedDataStudioAsset;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "DataStudioAsset.DataStudioAssetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dataStudioAssetOwner=" + this.dataStudioAssetOwner + ", dataStudioAssetTitle=" + this.dataStudioAssetTitle + ", dataStudioAssetType=" + this.dataStudioAssetType + ", googleLabels=" + this.googleLabels + ", googleLocation=" + this.googleLocation + ", googleLocationType=" + this.googleLocationType + ", googleProjectId=" + this.googleProjectId + ", googleProjectName=" + this.googleProjectName + ", googleProjectNumber=" + this.googleProjectNumber + ", googleService=" + this.googleService + ", googleTags=" + this.googleTags + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isTrashedDataStudioAsset=" + this.isTrashedDataStudioAsset + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class DataStudioAssetBuilderImpl extends DataStudioAsset.DataStudioAssetBuilder<DataStudioAsset, DataStudioAsset.DataStudioAssetBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataStudioAssetBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DataStudioAsset.DataStudioAssetBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DataStudioAsset build() {
            return new DataStudioAsset(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected DataStudioAsset(final DataStudioAsset.DataStudioAssetBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = DataStudioAsset.$default$typeName();
        this.dataStudioAssetOwner = b.dataStudioAssetOwner;
        this.dataStudioAssetTitle = b.dataStudioAssetTitle;
        this.dataStudioAssetType = b.dataStudioAssetType;
        java.util.List<GoogleLabel> googleLabels;
        switch (b.googleLabels == null ? 0 : b.googleLabels.size()) {
        case 0: 
            googleLabels = java.util.Collections.emptyList();
            break;
        case 1: 
            googleLabels = java.util.Collections.singletonList(b.googleLabels.get(0));
            break;
        default: 
            googleLabels = java.util.Collections.unmodifiableList(new java.util.ArrayList<GoogleLabel>(b.googleLabels));
        }
        this.googleLabels = googleLabels;
        this.googleLocation = b.googleLocation;
        this.googleLocationType = b.googleLocationType;
        this.googleProjectId = b.googleProjectId;
        this.googleProjectName = b.googleProjectName;
        this.googleProjectNumber = b.googleProjectNumber;
        this.googleService = b.googleService;
        java.util.List<GoogleTag> googleTags;
        switch (b.googleTags == null ? 0 : b.googleTags.size()) {
        case 0: 
            googleTags = java.util.Collections.emptyList();
            break;
        case 1: 
            googleTags = java.util.Collections.singletonList(b.googleTags.get(0));
            break;
        default: 
            googleTags = java.util.Collections.unmodifiableList(new java.util.ArrayList<GoogleTag>(b.googleTags));
        }
        this.googleTags = googleTags;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isTrashedDataStudioAsset = b.isTrashedDataStudioAsset;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static DataStudioAsset.DataStudioAssetBuilder<?, ?> _internal() {
        return new DataStudioAsset.DataStudioAssetBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataStudioAsset.DataStudioAssetBuilder<?, ?> toBuilder() {
        return new DataStudioAsset.DataStudioAssetBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Owner of the asset, from Google Data Studio.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataStudioAssetOwner() {
        return this.dataStudioAssetOwner;
    }

    /**
     * Title of the Google Data Studio asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataStudioAssetTitle() {
        return this.dataStudioAssetTitle;
    }

    /**
     * Type of the Google Data Studio asset, for example: REPORT or DATA_SOURCE.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public GoogleDataStudioAssetType getDataStudioAssetType() {
        return this.dataStudioAssetType;
    }

    /**
     * List of labels that have been applied to the asset in Google.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<GoogleLabel> getGoogleLabels() {
        return this.googleLabels;
    }

    /**
     * Location of this asset in Google.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGoogleLocation() {
        return this.googleLocation;
    }

    /**
     * Type of location of this asset in Google.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGoogleLocationType() {
        return this.googleLocationType;
    }

    /**
     * ID of the project in which the asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGoogleProjectId() {
        return this.googleProjectId;
    }

    /**
     * Name of the project in which the asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGoogleProjectName() {
        return this.googleProjectName;
    }

    /**
     * Number of the project in which the asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGoogleProjectNumber() {
        return this.googleProjectNumber;
    }

    /**
     * Service in Google in which the asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGoogleService() {
        return this.googleService;
    }

    /**
     * List of tags that have been applied to the asset in Google.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<GoogleTag> getGoogleTags() {
        return this.googleTags;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Whether the Google Data Studio asset has been trashed (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsTrashedDataStudioAsset() {
        return this.isTrashedDataStudioAsset;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DataStudioAsset)) return false;
        final DataStudioAsset other = (DataStudioAsset) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$googleProjectNumber = this.getGoogleProjectNumber();
        final java.lang.Object other$googleProjectNumber = other.getGoogleProjectNumber();
        if (this$googleProjectNumber == null ? other$googleProjectNumber != null : !this$googleProjectNumber.equals(other$googleProjectNumber)) return false;
        final java.lang.Object this$isTrashedDataStudioAsset = this.getIsTrashedDataStudioAsset();
        final java.lang.Object other$isTrashedDataStudioAsset = other.getIsTrashedDataStudioAsset();
        if (this$isTrashedDataStudioAsset == null ? other$isTrashedDataStudioAsset != null : !this$isTrashedDataStudioAsset.equals(other$isTrashedDataStudioAsset)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dataStudioAssetOwner = this.getDataStudioAssetOwner();
        final java.lang.Object other$dataStudioAssetOwner = other.getDataStudioAssetOwner();
        if (this$dataStudioAssetOwner == null ? other$dataStudioAssetOwner != null : !this$dataStudioAssetOwner.equals(other$dataStudioAssetOwner)) return false;
        final java.lang.Object this$dataStudioAssetTitle = this.getDataStudioAssetTitle();
        final java.lang.Object other$dataStudioAssetTitle = other.getDataStudioAssetTitle();
        if (this$dataStudioAssetTitle == null ? other$dataStudioAssetTitle != null : !this$dataStudioAssetTitle.equals(other$dataStudioAssetTitle)) return false;
        final java.lang.Object this$dataStudioAssetType = this.getDataStudioAssetType();
        final java.lang.Object other$dataStudioAssetType = other.getDataStudioAssetType();
        if (this$dataStudioAssetType == null ? other$dataStudioAssetType != null : !this$dataStudioAssetType.equals(other$dataStudioAssetType)) return false;
        final java.lang.Object this$googleLabels = this.getGoogleLabels();
        final java.lang.Object other$googleLabels = other.getGoogleLabels();
        if (this$googleLabels == null ? other$googleLabels != null : !this$googleLabels.equals(other$googleLabels)) return false;
        final java.lang.Object this$googleLocation = this.getGoogleLocation();
        final java.lang.Object other$googleLocation = other.getGoogleLocation();
        if (this$googleLocation == null ? other$googleLocation != null : !this$googleLocation.equals(other$googleLocation)) return false;
        final java.lang.Object this$googleLocationType = this.getGoogleLocationType();
        final java.lang.Object other$googleLocationType = other.getGoogleLocationType();
        if (this$googleLocationType == null ? other$googleLocationType != null : !this$googleLocationType.equals(other$googleLocationType)) return false;
        final java.lang.Object this$googleProjectId = this.getGoogleProjectId();
        final java.lang.Object other$googleProjectId = other.getGoogleProjectId();
        if (this$googleProjectId == null ? other$googleProjectId != null : !this$googleProjectId.equals(other$googleProjectId)) return false;
        final java.lang.Object this$googleProjectName = this.getGoogleProjectName();
        final java.lang.Object other$googleProjectName = other.getGoogleProjectName();
        if (this$googleProjectName == null ? other$googleProjectName != null : !this$googleProjectName.equals(other$googleProjectName)) return false;
        final java.lang.Object this$googleService = this.getGoogleService();
        final java.lang.Object other$googleService = other.getGoogleService();
        if (this$googleService == null ? other$googleService != null : !this$googleService.equals(other$googleService)) return false;
        final java.lang.Object this$googleTags = this.getGoogleTags();
        final java.lang.Object other$googleTags = other.getGoogleTags();
        if (this$googleTags == null ? other$googleTags != null : !this$googleTags.equals(other$googleTags)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof DataStudioAsset;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $googleProjectNumber = this.getGoogleProjectNumber();
        result = result * PRIME + ($googleProjectNumber == null ? 43 : $googleProjectNumber.hashCode());
        final java.lang.Object $isTrashedDataStudioAsset = this.getIsTrashedDataStudioAsset();
        result = result * PRIME + ($isTrashedDataStudioAsset == null ? 43 : $isTrashedDataStudioAsset.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dataStudioAssetOwner = this.getDataStudioAssetOwner();
        result = result * PRIME + ($dataStudioAssetOwner == null ? 43 : $dataStudioAssetOwner.hashCode());
        final java.lang.Object $dataStudioAssetTitle = this.getDataStudioAssetTitle();
        result = result * PRIME + ($dataStudioAssetTitle == null ? 43 : $dataStudioAssetTitle.hashCode());
        final java.lang.Object $dataStudioAssetType = this.getDataStudioAssetType();
        result = result * PRIME + ($dataStudioAssetType == null ? 43 : $dataStudioAssetType.hashCode());
        final java.lang.Object $googleLabels = this.getGoogleLabels();
        result = result * PRIME + ($googleLabels == null ? 43 : $googleLabels.hashCode());
        final java.lang.Object $googleLocation = this.getGoogleLocation();
        result = result * PRIME + ($googleLocation == null ? 43 : $googleLocation.hashCode());
        final java.lang.Object $googleLocationType = this.getGoogleLocationType();
        result = result * PRIME + ($googleLocationType == null ? 43 : $googleLocationType.hashCode());
        final java.lang.Object $googleProjectId = this.getGoogleProjectId();
        result = result * PRIME + ($googleProjectId == null ? 43 : $googleProjectId.hashCode());
        final java.lang.Object $googleProjectName = this.getGoogleProjectName();
        result = result * PRIME + ($googleProjectName == null ? 43 : $googleProjectName.hashCode());
        final java.lang.Object $googleService = this.getGoogleService();
        result = result * PRIME + ($googleService == null ? 43 : $googleService.hashCode());
        final java.lang.Object $googleTags = this.getGoogleTags();
        result = result * PRIME + ($googleTags == null ? 43 : $googleTags.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "DataStudioAsset(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dataStudioAssetOwner=" + this.getDataStudioAssetOwner() + ", dataStudioAssetTitle=" + this.getDataStudioAssetTitle() + ", dataStudioAssetType=" + this.getDataStudioAssetType() + ", googleLabels=" + this.getGoogleLabels() + ", googleLocation=" + this.getGoogleLocation() + ", googleLocationType=" + this.getGoogleLocationType() + ", googleProjectId=" + this.getGoogleProjectId() + ", googleProjectName=" + this.getGoogleProjectName() + ", googleProjectNumber=" + this.getGoogleProjectNumber() + ", googleService=" + this.getGoogleService() + ", googleTags=" + this.getGoogleTags() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isTrashedDataStudioAsset=" + this.getIsTrashedDataStudioAsset() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for DataStudioAssets.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
