// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.DbtJobRun;
import com.atlan.model.structs.DbtMetricFilter;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a dbt metric in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class DbtMetric extends Asset implements IDbtMetric, IDbt, IMetric, ICatalog, IAsset, IReferenceable, IDataQuality {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(DbtMetric.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtMetric";
    /**
     * Fixed typeName for DbtMetrics.
     */
    String typeName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IAsset> assets;
    /**
     * TBC
     */
    @Attribute
    String dbtAccountName;
    /**
     * TBC
     */
    @Attribute
    String dbtAlias;
    /**
     * TBC
     */
    @Attribute
    String dbtConnectionContext;
    /**
     * TBC
     */
    @Attribute
    String dbtEnvironmentDbtVersion;
    /**
     * TBC
     */
    @Attribute
    String dbtEnvironmentName;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long dbtJobLastRun;
    /**
     * TBC
     */
    @Attribute
    String dbtJobName;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long dbtJobNextRun;
    /**
     * TBC
     */
    @Attribute
    String dbtJobNextRunHumanized;
    /**
     * List of latest DBT job runs across all environments
     */
    @Attribute
    List<DbtJobRun> dbtJobRuns;
    /**
     * TBC
     */
    @Attribute
    String dbtJobSchedule;
    /**
     * TBC
     */
    @Attribute
    String dbtJobScheduleCronHumanized;
    /**
     * TBC
     */
    @Attribute
    String dbtJobStatus;
    /**
     * TBC
     */
    @Attribute
    String dbtMeta;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IColumn> dbtMetricFilterColumns;
    /**
     * TBC
     */
    @Attribute
    List<DbtMetricFilter> dbtMetricFilters;
    /**
     * Model in which this metric exists.
     */
    @Attribute
    IDbtModel dbtModel;
    /**
     * TBC
     */
    @Attribute
    String dbtPackageName;
    /**
     * TBC
     */
    @Attribute
    String dbtProjectName;
    /**
     * TBC
     */
    @Attribute
    String dbtSemanticLayerProxyUrl;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> dbtTags;
    /**
     * TBC
     */
    @Attribute
    String dbtUniqueId;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IColumn> metricDimensionColumns;
    /**
     * Filters to be applied to the metric query.
     */
    @Attribute
    String metricFilters;
    /**
     * SQL query used to compute the metric.
     */
    @Attribute
    String metricSQL;
    /**
     * List of time grains to be applied to the metric query.
     */
    @Attribute
    SortedSet<String> metricTimeGrains;
    /**
     * TBC
     */
    @Attribute
    IColumn metricTimestampColumn;
    /**
     * Type of the metric.
     */
    @Attribute
    String metricType;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a DbtMetric, from a potentially
     * more-complete DbtMetric object.
     *
     * @return the minimal object necessary to relate to the DbtMetric
     * @throws InvalidRequestException if any of the minimal set of required properties for a DbtMetric relationship are not found in the initial object
     */
    @Override
    public DbtMetric trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all DbtMetric assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DbtMetric assets will be included.
     *
     * @return a fluent search that includes all DbtMetric assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all DbtMetric assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DbtMetric assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all DbtMetric assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all DbtMetric assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) DbtMetrics will be included
     * @return a fluent search that includes all DbtMetric assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all DbtMetric assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) DbtMetrics will be included
     * @return a fluent search that includes all DbtMetric assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a DbtMetric by GUID. Use this to create a relationship to this DbtMetric,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the DbtMetric to reference
     * @return reference to a DbtMetric that can be used for defining a relationship to a DbtMetric
     */
    public static DbtMetric refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DbtMetric by GUID. Use this to create a relationship to this DbtMetric,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the DbtMetric to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DbtMetric that can be used for defining a relationship to a DbtMetric
     */
    public static DbtMetric refByGuid(String guid, Reference.SaveSemantic semantic) {
        return DbtMetric._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a DbtMetric by qualifiedName. Use this to create a relationship to this DbtMetric,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the DbtMetric to reference
     * @return reference to a DbtMetric that can be used for defining a relationship to a DbtMetric
     */
    public static DbtMetric refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DbtMetric by qualifiedName. Use this to create a relationship to this DbtMetric,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the DbtMetric to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DbtMetric that can be used for defining a relationship to a DbtMetric
     */
    public static DbtMetric refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return DbtMetric._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a DbtMetric by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the DbtMetric to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DbtMetric, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DbtMetric does not exist or the provided GUID is not a DbtMetric
     */
    @JsonIgnore
    public static DbtMetric get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a DbtMetric by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DbtMetric to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DbtMetric, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DbtMetric does not exist or the provided GUID is not a DbtMetric
     */
    @JsonIgnore
    public static DbtMetric get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a DbtMetric by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DbtMetric to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full DbtMetric, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DbtMetric does not exist or the provided GUID is not a DbtMetric
     */
    @JsonIgnore
    public static DbtMetric get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof DbtMetric) {
                return (DbtMetric) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof DbtMetric) {
                return (DbtMetric) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) DbtMetric to active.
     *
     * @param qualifiedName for the DbtMetric
     * @return true if the DbtMetric is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) DbtMetric to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the DbtMetric
     * @return true if the DbtMetric is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a DbtMetric.
     *
     * @param qualifiedName of the DbtMetric
     * @param name of the DbtMetric
     * @return the minimal request necessary to update the DbtMetric, as a builder
     */
    public static DbtMetricBuilder<?, ?> updater(String qualifiedName, String name) {
        return DbtMetric._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a DbtMetric, from a potentially
     * more-complete DbtMetric object.
     *
     * @return the minimal object necessary to update the DbtMetric, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for DbtMetric are not found in the initial object
     */
    @Override
    public DbtMetricBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a DbtMetric.
     *
     * @param qualifiedName of the DbtMetric
     * @param name of the DbtMetric
     * @return the updated DbtMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a DbtMetric.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DbtMetric
     * @param name of the DbtMetric
     * @return the updated DbtMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtMetric) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a DbtMetric.
     *
     * @param qualifiedName of the DbtMetric
     * @param name of the DbtMetric
     * @return the updated DbtMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a DbtMetric.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DbtMetric
     * @param name of the DbtMetric
     * @return the updated DbtMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtMetric) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a DbtMetric.
     *
     * @param qualifiedName of the DbtMetric
     * @param name of the DbtMetric
     * @return the updated DbtMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a DbtMetric.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DbtMetric's owners
     * @param qualifiedName of the DbtMetric
     * @param name of the DbtMetric
     * @return the updated DbtMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtMetric) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a DbtMetric.
     *
     * @param qualifiedName of the DbtMetric
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DbtMetric, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a DbtMetric.
     *
     * @param client connectivity to the Atlan tenant on which to update the DbtMetric's certificate
     * @param qualifiedName of the DbtMetric
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DbtMetric, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DbtMetric) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a DbtMetric.
     *
     * @param qualifiedName of the DbtMetric
     * @param name of the DbtMetric
     * @return the updated DbtMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a DbtMetric.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DbtMetric's certificate
     * @param qualifiedName of the DbtMetric
     * @param name of the DbtMetric
     * @return the updated DbtMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtMetric) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a DbtMetric.
     *
     * @param qualifiedName of the DbtMetric
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a DbtMetric.
     *
     * @param client connectivity to the Atlan tenant on which to update the DbtMetric's announcement
     * @param qualifiedName of the DbtMetric
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtMetric) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a DbtMetric.
     *
     * @param qualifiedName of the DbtMetric
     * @param name of the DbtMetric
     * @return the updated DbtMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a DbtMetric.
     *
     * @param client connectivity to the Atlan client from which to remove the DbtMetric's announcement
     * @param qualifiedName of the DbtMetric
     * @param name of the DbtMetric
     * @return the updated DbtMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtMetric removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtMetric) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the DbtMetric.
     *
     * @param qualifiedName for the DbtMetric
     * @param name human-readable name of the DbtMetric
     * @param terms the list of terms to replace on the DbtMetric, or null to remove all terms from the DbtMetric
     * @return the DbtMetric that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DbtMetric replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the DbtMetric.
     *
     * @param client connectivity to the Atlan tenant on which to replace the DbtMetric's assigned terms
     * @param qualifiedName for the DbtMetric
     * @param name human-readable name of the DbtMetric
     * @param terms the list of terms to replace on the DbtMetric, or null to remove all terms from the DbtMetric
     * @return the DbtMetric that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DbtMetric replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtMetric) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the DbtMetric, without replacing existing terms linked to the DbtMetric.
     * Note: this operation must make two API calls — one to retrieve the DbtMetric's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the DbtMetric
     * @param terms the list of terms to append to the DbtMetric
     * @return the DbtMetric that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DbtMetric appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the DbtMetric, without replacing existing terms linked to the DbtMetric.
     * Note: this operation must make two API calls — one to retrieve the DbtMetric's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the DbtMetric
     * @param qualifiedName for the DbtMetric
     * @param terms the list of terms to append to the DbtMetric
     * @return the DbtMetric that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DbtMetric appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtMetric) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a DbtMetric, without replacing all existing terms linked to the DbtMetric.
     * Note: this operation must make two API calls — one to retrieve the DbtMetric's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the DbtMetric
     * @param terms the list of terms to remove from the DbtMetric, which must be referenced by GUID
     * @return the DbtMetric that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DbtMetric removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a DbtMetric, without replacing all existing terms linked to the DbtMetric.
     * Note: this operation must make two API calls — one to retrieve the DbtMetric's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the DbtMetric
     * @param qualifiedName for the DbtMetric
     * @param terms the list of terms to remove from the DbtMetric, which must be referenced by GUID
     * @return the DbtMetric that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DbtMetric removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtMetric) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a DbtMetric, without replacing existing Atlan tags linked to the DbtMetric.
     * Note: this operation must make two API calls — one to retrieve the DbtMetric's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DbtMetric
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DbtMetric
     */
    public static DbtMetric appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DbtMetric, without replacing existing Atlan tags linked to the DbtMetric.
     * Note: this operation must make two API calls — one to retrieve the DbtMetric's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DbtMetric
     * @param qualifiedName of the DbtMetric
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DbtMetric
     */
    public static DbtMetric appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DbtMetric) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DbtMetric, without replacing existing Atlan tags linked to the DbtMetric.
     * Note: this operation must make two API calls — one to retrieve the DbtMetric's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DbtMetric
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DbtMetric
     */
    public static DbtMetric appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a DbtMetric, without replacing existing Atlan tags linked to the DbtMetric.
     * Note: this operation must make two API calls — one to retrieve the DbtMetric's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DbtMetric
     * @param qualifiedName of the DbtMetric
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DbtMetric
     */
    public static DbtMetric appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DbtMetric) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a DbtMetric.
     *
     * @param qualifiedName of the DbtMetric
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DbtMetric
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a DbtMetric.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a DbtMetric
     * @param qualifiedName of the DbtMetric
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DbtMetric
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class DbtMetricBuilder<C extends DbtMetric, B extends DbtMetric.DbtMetricBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAsset> assets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtAccountName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtAlias;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtConnectionContext;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtEnvironmentDbtVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtEnvironmentName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dbtJobLastRun;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dbtJobNextRun;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobNextRunHumanized;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<DbtJobRun> dbtJobRuns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobSchedule;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobScheduleCronHumanized;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtMeta;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IColumn> dbtMetricFilterColumns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<DbtMetricFilter> dbtMetricFilters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IDbtModel dbtModel;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtPackageName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtProjectName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtSemanticLayerProxyUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> dbtTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtUniqueId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IColumn> metricDimensionColumns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String metricFilters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String metricSQL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> metricTimeGrains;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IColumn metricTimestampColumn;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String metricType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            DbtMetric.DbtMetricBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final DbtMetric instance, final DbtMetric.DbtMetricBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.assets(instance.assets == null ? java.util.Collections.<IAsset>emptySortedSet() : instance.assets);
            b.dbtAccountName(instance.dbtAccountName);
            b.dbtAlias(instance.dbtAlias);
            b.dbtConnectionContext(instance.dbtConnectionContext);
            b.dbtEnvironmentDbtVersion(instance.dbtEnvironmentDbtVersion);
            b.dbtEnvironmentName(instance.dbtEnvironmentName);
            b.dbtJobLastRun(instance.dbtJobLastRun);
            b.dbtJobName(instance.dbtJobName);
            b.dbtJobNextRun(instance.dbtJobNextRun);
            b.dbtJobNextRunHumanized(instance.dbtJobNextRunHumanized);
            b.dbtJobRuns(instance.dbtJobRuns == null ? java.util.Collections.<DbtJobRun>emptyList() : instance.dbtJobRuns);
            b.dbtJobSchedule(instance.dbtJobSchedule);
            b.dbtJobScheduleCronHumanized(instance.dbtJobScheduleCronHumanized);
            b.dbtJobStatus(instance.dbtJobStatus);
            b.dbtMeta(instance.dbtMeta);
            b.dbtMetricFilterColumns(instance.dbtMetricFilterColumns == null ? java.util.Collections.<IColumn>emptySortedSet() : instance.dbtMetricFilterColumns);
            b.dbtMetricFilters(instance.dbtMetricFilters == null ? java.util.Collections.<DbtMetricFilter>emptyList() : instance.dbtMetricFilters);
            b.dbtModel(instance.dbtModel);
            b.dbtPackageName(instance.dbtPackageName);
            b.dbtProjectName(instance.dbtProjectName);
            b.dbtSemanticLayerProxyUrl(instance.dbtSemanticLayerProxyUrl);
            b.dbtTags(instance.dbtTags == null ? java.util.Collections.<String>emptySortedSet() : instance.dbtTags);
            b.dbtUniqueId(instance.dbtUniqueId);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.metricDimensionColumns(instance.metricDimensionColumns == null ? java.util.Collections.<IColumn>emptySortedSet() : instance.metricDimensionColumns);
            b.metricFilters(instance.metricFilters);
            b.metricSQL(instance.metricSQL);
            b.metricTimeGrains(instance.metricTimeGrains == null ? java.util.Collections.<String>emptySortedSet() : instance.metricTimeGrains);
            b.metricTimestampColumn(instance.metricTimestampColumn);
            b.metricType(instance.metricType);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for DbtMetrics.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B asset(final IAsset asset) {
            if (this.assets == null) this.assets = new java.util.ArrayList<IAsset>();
            this.assets.add(asset);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assets(final java.util.Collection<? extends IAsset> assets) {
            if (assets == null) {
                throw new java.lang.NullPointerException("assets cannot be null");
            }
            if (this.assets == null) this.assets = new java.util.ArrayList<IAsset>();
            this.assets.addAll(assets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssets() {
            if (this.assets != null) this.assets.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtAccountName(final String dbtAccountName) {
            this.dbtAccountName = dbtAccountName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtAlias(final String dbtAlias) {
            this.dbtAlias = dbtAlias;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtConnectionContext(final String dbtConnectionContext) {
            this.dbtConnectionContext = dbtConnectionContext;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtEnvironmentDbtVersion(final String dbtEnvironmentDbtVersion) {
            this.dbtEnvironmentDbtVersion = dbtEnvironmentDbtVersion;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtEnvironmentName(final String dbtEnvironmentName) {
            this.dbtEnvironmentName = dbtEnvironmentName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobLastRun(final Long dbtJobLastRun) {
            this.dbtJobLastRun = dbtJobLastRun;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobName(final String dbtJobName) {
            this.dbtJobName = dbtJobName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobNextRun(final Long dbtJobNextRun) {
            this.dbtJobNextRun = dbtJobNextRun;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobNextRunHumanized(final String dbtJobNextRunHumanized) {
            this.dbtJobNextRunHumanized = dbtJobNextRunHumanized;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobRun(final DbtJobRun dbtJobRun) {
            if (this.dbtJobRuns == null) this.dbtJobRuns = new java.util.ArrayList<DbtJobRun>();
            this.dbtJobRuns.add(dbtJobRun);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobRuns(final java.util.Collection<? extends DbtJobRun> dbtJobRuns) {
            if (dbtJobRuns == null) {
                throw new java.lang.NullPointerException("dbtJobRuns cannot be null");
            }
            if (this.dbtJobRuns == null) this.dbtJobRuns = new java.util.ArrayList<DbtJobRun>();
            this.dbtJobRuns.addAll(dbtJobRuns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtJobRuns() {
            if (this.dbtJobRuns != null) this.dbtJobRuns.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobSchedule(final String dbtJobSchedule) {
            this.dbtJobSchedule = dbtJobSchedule;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobScheduleCronHumanized(final String dbtJobScheduleCronHumanized) {
            this.dbtJobScheduleCronHumanized = dbtJobScheduleCronHumanized;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobStatus(final String dbtJobStatus) {
            this.dbtJobStatus = dbtJobStatus;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtMeta(final String dbtMeta) {
            this.dbtMeta = dbtMeta;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtMetricFilterColumn(final IColumn dbtMetricFilterColumn) {
            if (this.dbtMetricFilterColumns == null) this.dbtMetricFilterColumns = new java.util.ArrayList<IColumn>();
            this.dbtMetricFilterColumns.add(dbtMetricFilterColumn);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtMetricFilterColumns(final java.util.Collection<? extends IColumn> dbtMetricFilterColumns) {
            if (dbtMetricFilterColumns == null) {
                throw new java.lang.NullPointerException("dbtMetricFilterColumns cannot be null");
            }
            if (this.dbtMetricFilterColumns == null) this.dbtMetricFilterColumns = new java.util.ArrayList<IColumn>();
            this.dbtMetricFilterColumns.addAll(dbtMetricFilterColumns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtMetricFilterColumns() {
            if (this.dbtMetricFilterColumns != null) this.dbtMetricFilterColumns.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtMetricFilter(final DbtMetricFilter dbtMetricFilter) {
            if (this.dbtMetricFilters == null) this.dbtMetricFilters = new java.util.ArrayList<DbtMetricFilter>();
            this.dbtMetricFilters.add(dbtMetricFilter);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtMetricFilters(final java.util.Collection<? extends DbtMetricFilter> dbtMetricFilters) {
            if (dbtMetricFilters == null) {
                throw new java.lang.NullPointerException("dbtMetricFilters cannot be null");
            }
            if (this.dbtMetricFilters == null) this.dbtMetricFilters = new java.util.ArrayList<DbtMetricFilter>();
            this.dbtMetricFilters.addAll(dbtMetricFilters);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtMetricFilters() {
            if (this.dbtMetricFilters != null) this.dbtMetricFilters.clear();
            return self();
        }

        /**
         * Model in which this metric exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModel(final IDbtModel dbtModel) {
            this.dbtModel = dbtModel;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtPackageName(final String dbtPackageName) {
            this.dbtPackageName = dbtPackageName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtProjectName(final String dbtProjectName) {
            this.dbtProjectName = dbtProjectName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtSemanticLayerProxyUrl(final String dbtSemanticLayerProxyUrl) {
            this.dbtSemanticLayerProxyUrl = dbtSemanticLayerProxyUrl;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTag(final String dbtTag) {
            if (this.dbtTags == null) this.dbtTags = new java.util.ArrayList<String>();
            this.dbtTags.add(dbtTag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTags(final java.util.Collection<? extends String> dbtTags) {
            if (dbtTags == null) {
                throw new java.lang.NullPointerException("dbtTags cannot be null");
            }
            if (this.dbtTags == null) this.dbtTags = new java.util.ArrayList<String>();
            this.dbtTags.addAll(dbtTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtTags() {
            if (this.dbtTags != null) this.dbtTags.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtUniqueId(final String dbtUniqueId) {
            this.dbtUniqueId = dbtUniqueId;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metricDimensionColumn(final IColumn metricDimensionColumn) {
            if (this.metricDimensionColumns == null) this.metricDimensionColumns = new java.util.ArrayList<IColumn>();
            this.metricDimensionColumns.add(metricDimensionColumn);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metricDimensionColumns(final java.util.Collection<? extends IColumn> metricDimensionColumns) {
            if (metricDimensionColumns == null) {
                throw new java.lang.NullPointerException("metricDimensionColumns cannot be null");
            }
            if (this.metricDimensionColumns == null) this.metricDimensionColumns = new java.util.ArrayList<IColumn>();
            this.metricDimensionColumns.addAll(metricDimensionColumns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMetricDimensionColumns() {
            if (this.metricDimensionColumns != null) this.metricDimensionColumns.clear();
            return self();
        }

        /**
         * Filters to be applied to the metric query.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metricFilters(final String metricFilters) {
            this.metricFilters = metricFilters;
            return self();
        }

        /**
         * SQL query used to compute the metric.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metricSQL(final String metricSQL) {
            this.metricSQL = metricSQL;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metricTimeGrain(final String metricTimeGrain) {
            if (this.metricTimeGrains == null) this.metricTimeGrains = new java.util.ArrayList<String>();
            this.metricTimeGrains.add(metricTimeGrain);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metricTimeGrains(final java.util.Collection<? extends String> metricTimeGrains) {
            if (metricTimeGrains == null) {
                throw new java.lang.NullPointerException("metricTimeGrains cannot be null");
            }
            if (this.metricTimeGrains == null) this.metricTimeGrains = new java.util.ArrayList<String>();
            this.metricTimeGrains.addAll(metricTimeGrains);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMetricTimeGrains() {
            if (this.metricTimeGrains != null) this.metricTimeGrains.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metricTimestampColumn(final IColumn metricTimestampColumn) {
            this.metricTimestampColumn = metricTimestampColumn;
            return self();
        }

        /**
         * Type of the metric.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metricType(final String metricType) {
            this.metricType = metricType;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "DbtMetric.DbtMetricBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", assets=" + this.assets + ", dbtAccountName=" + this.dbtAccountName + ", dbtAlias=" + this.dbtAlias + ", dbtConnectionContext=" + this.dbtConnectionContext + ", dbtEnvironmentDbtVersion=" + this.dbtEnvironmentDbtVersion + ", dbtEnvironmentName=" + this.dbtEnvironmentName + ", dbtJobLastRun=" + this.dbtJobLastRun + ", dbtJobName=" + this.dbtJobName + ", dbtJobNextRun=" + this.dbtJobNextRun + ", dbtJobNextRunHumanized=" + this.dbtJobNextRunHumanized + ", dbtJobRuns=" + this.dbtJobRuns + ", dbtJobSchedule=" + this.dbtJobSchedule + ", dbtJobScheduleCronHumanized=" + this.dbtJobScheduleCronHumanized + ", dbtJobStatus=" + this.dbtJobStatus + ", dbtMeta=" + this.dbtMeta + ", dbtMetricFilterColumns=" + this.dbtMetricFilterColumns + ", dbtMetricFilters=" + this.dbtMetricFilters + ", dbtModel=" + this.dbtModel + ", dbtPackageName=" + this.dbtPackageName + ", dbtProjectName=" + this.dbtProjectName + ", dbtSemanticLayerProxyUrl=" + this.dbtSemanticLayerProxyUrl + ", dbtTags=" + this.dbtTags + ", dbtUniqueId=" + this.dbtUniqueId + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", metricDimensionColumns=" + this.metricDimensionColumns + ", metricFilters=" + this.metricFilters + ", metricSQL=" + this.metricSQL + ", metricTimeGrains=" + this.metricTimeGrains + ", metricTimestampColumn=" + this.metricTimestampColumn + ", metricType=" + this.metricType + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class DbtMetricBuilderImpl extends DbtMetric.DbtMetricBuilder<DbtMetric, DbtMetric.DbtMetricBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DbtMetricBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DbtMetric.DbtMetricBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DbtMetric build() {
            return new DbtMetric(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected DbtMetric(final DbtMetric.DbtMetricBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = DbtMetric.$default$typeName();
        java.util.SortedSet<IAsset> assets = new java.util.TreeSet<IAsset>();
        if (b.assets != null) assets.addAll(b.assets);
        assets = java.util.Collections.unmodifiableSortedSet(assets);
        this.assets = assets;
        this.dbtAccountName = b.dbtAccountName;
        this.dbtAlias = b.dbtAlias;
        this.dbtConnectionContext = b.dbtConnectionContext;
        this.dbtEnvironmentDbtVersion = b.dbtEnvironmentDbtVersion;
        this.dbtEnvironmentName = b.dbtEnvironmentName;
        this.dbtJobLastRun = b.dbtJobLastRun;
        this.dbtJobName = b.dbtJobName;
        this.dbtJobNextRun = b.dbtJobNextRun;
        this.dbtJobNextRunHumanized = b.dbtJobNextRunHumanized;
        java.util.List<DbtJobRun> dbtJobRuns;
        switch (b.dbtJobRuns == null ? 0 : b.dbtJobRuns.size()) {
        case 0: 
            dbtJobRuns = java.util.Collections.emptyList();
            break;
        case 1: 
            dbtJobRuns = java.util.Collections.singletonList(b.dbtJobRuns.get(0));
            break;
        default: 
            dbtJobRuns = java.util.Collections.unmodifiableList(new java.util.ArrayList<DbtJobRun>(b.dbtJobRuns));
        }
        this.dbtJobRuns = dbtJobRuns;
        this.dbtJobSchedule = b.dbtJobSchedule;
        this.dbtJobScheduleCronHumanized = b.dbtJobScheduleCronHumanized;
        this.dbtJobStatus = b.dbtJobStatus;
        this.dbtMeta = b.dbtMeta;
        java.util.SortedSet<IColumn> dbtMetricFilterColumns = new java.util.TreeSet<IColumn>();
        if (b.dbtMetricFilterColumns != null) dbtMetricFilterColumns.addAll(b.dbtMetricFilterColumns);
        dbtMetricFilterColumns = java.util.Collections.unmodifiableSortedSet(dbtMetricFilterColumns);
        this.dbtMetricFilterColumns = dbtMetricFilterColumns;
        java.util.List<DbtMetricFilter> dbtMetricFilters;
        switch (b.dbtMetricFilters == null ? 0 : b.dbtMetricFilters.size()) {
        case 0: 
            dbtMetricFilters = java.util.Collections.emptyList();
            break;
        case 1: 
            dbtMetricFilters = java.util.Collections.singletonList(b.dbtMetricFilters.get(0));
            break;
        default: 
            dbtMetricFilters = java.util.Collections.unmodifiableList(new java.util.ArrayList<DbtMetricFilter>(b.dbtMetricFilters));
        }
        this.dbtMetricFilters = dbtMetricFilters;
        this.dbtModel = b.dbtModel;
        this.dbtPackageName = b.dbtPackageName;
        this.dbtProjectName = b.dbtProjectName;
        this.dbtSemanticLayerProxyUrl = b.dbtSemanticLayerProxyUrl;
        java.util.SortedSet<String> dbtTags = new java.util.TreeSet<String>();
        if (b.dbtTags != null) dbtTags.addAll(b.dbtTags);
        dbtTags = java.util.Collections.unmodifiableSortedSet(dbtTags);
        this.dbtTags = dbtTags;
        this.dbtUniqueId = b.dbtUniqueId;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IColumn> metricDimensionColumns = new java.util.TreeSet<IColumn>();
        if (b.metricDimensionColumns != null) metricDimensionColumns.addAll(b.metricDimensionColumns);
        metricDimensionColumns = java.util.Collections.unmodifiableSortedSet(metricDimensionColumns);
        this.metricDimensionColumns = metricDimensionColumns;
        this.metricFilters = b.metricFilters;
        this.metricSQL = b.metricSQL;
        java.util.SortedSet<String> metricTimeGrains = new java.util.TreeSet<String>();
        if (b.metricTimeGrains != null) metricTimeGrains.addAll(b.metricTimeGrains);
        metricTimeGrains = java.util.Collections.unmodifiableSortedSet(metricTimeGrains);
        this.metricTimeGrains = metricTimeGrains;
        this.metricTimestampColumn = b.metricTimestampColumn;
        this.metricType = b.metricType;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static DbtMetric.DbtMetricBuilder<?, ?> _internal() {
        return new DbtMetric.DbtMetricBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DbtMetric.DbtMetricBuilder<?, ?> toBuilder() {
        return new DbtMetric.DbtMetricBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAsset> getAssets() {
        return this.assets;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtAccountName() {
        return this.dbtAccountName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtAlias() {
        return this.dbtAlias;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtConnectionContext() {
        return this.dbtConnectionContext;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtEnvironmentDbtVersion() {
        return this.dbtEnvironmentDbtVersion;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtEnvironmentName() {
        return this.dbtEnvironmentName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDbtJobLastRun() {
        return this.dbtJobLastRun;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobName() {
        return this.dbtJobName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDbtJobNextRun() {
        return this.dbtJobNextRun;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobNextRunHumanized() {
        return this.dbtJobNextRunHumanized;
    }

    /**
     * List of latest DBT job runs across all environments
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<DbtJobRun> getDbtJobRuns() {
        return this.dbtJobRuns;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobSchedule() {
        return this.dbtJobSchedule;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobScheduleCronHumanized() {
        return this.dbtJobScheduleCronHumanized;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobStatus() {
        return this.dbtJobStatus;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtMeta() {
        return this.dbtMeta;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IColumn> getDbtMetricFilterColumns() {
        return this.dbtMetricFilterColumns;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<DbtMetricFilter> getDbtMetricFilters() {
        return this.dbtMetricFilters;
    }

    /**
     * Model in which this metric exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IDbtModel getDbtModel() {
        return this.dbtModel;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtPackageName() {
        return this.dbtPackageName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtProjectName() {
        return this.dbtProjectName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtSemanticLayerProxyUrl() {
        return this.dbtSemanticLayerProxyUrl;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDbtTags() {
        return this.dbtTags;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtUniqueId() {
        return this.dbtUniqueId;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IColumn> getMetricDimensionColumns() {
        return this.metricDimensionColumns;
    }

    /**
     * Filters to be applied to the metric query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMetricFilters() {
        return this.metricFilters;
    }

    /**
     * SQL query used to compute the metric.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMetricSQL() {
        return this.metricSQL;
    }

    /**
     * List of time grains to be applied to the metric query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMetricTimeGrains() {
        return this.metricTimeGrains;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IColumn getMetricTimestampColumn() {
        return this.metricTimestampColumn;
    }

    /**
     * Type of the metric.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMetricType() {
        return this.metricType;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DbtMetric)) return false;
        final DbtMetric other = (DbtMetric) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$dbtJobLastRun = this.getDbtJobLastRun();
        final java.lang.Object other$dbtJobLastRun = other.getDbtJobLastRun();
        if (this$dbtJobLastRun == null ? other$dbtJobLastRun != null : !this$dbtJobLastRun.equals(other$dbtJobLastRun)) return false;
        final java.lang.Object this$dbtJobNextRun = this.getDbtJobNextRun();
        final java.lang.Object other$dbtJobNextRun = other.getDbtJobNextRun();
        if (this$dbtJobNextRun == null ? other$dbtJobNextRun != null : !this$dbtJobNextRun.equals(other$dbtJobNextRun)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$assets = this.getAssets();
        final java.lang.Object other$assets = other.getAssets();
        if (this$assets == null ? other$assets != null : !this$assets.equals(other$assets)) return false;
        final java.lang.Object this$dbtAccountName = this.getDbtAccountName();
        final java.lang.Object other$dbtAccountName = other.getDbtAccountName();
        if (this$dbtAccountName == null ? other$dbtAccountName != null : !this$dbtAccountName.equals(other$dbtAccountName)) return false;
        final java.lang.Object this$dbtAlias = this.getDbtAlias();
        final java.lang.Object other$dbtAlias = other.getDbtAlias();
        if (this$dbtAlias == null ? other$dbtAlias != null : !this$dbtAlias.equals(other$dbtAlias)) return false;
        final java.lang.Object this$dbtConnectionContext = this.getDbtConnectionContext();
        final java.lang.Object other$dbtConnectionContext = other.getDbtConnectionContext();
        if (this$dbtConnectionContext == null ? other$dbtConnectionContext != null : !this$dbtConnectionContext.equals(other$dbtConnectionContext)) return false;
        final java.lang.Object this$dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        final java.lang.Object other$dbtEnvironmentDbtVersion = other.getDbtEnvironmentDbtVersion();
        if (this$dbtEnvironmentDbtVersion == null ? other$dbtEnvironmentDbtVersion != null : !this$dbtEnvironmentDbtVersion.equals(other$dbtEnvironmentDbtVersion)) return false;
        final java.lang.Object this$dbtEnvironmentName = this.getDbtEnvironmentName();
        final java.lang.Object other$dbtEnvironmentName = other.getDbtEnvironmentName();
        if (this$dbtEnvironmentName == null ? other$dbtEnvironmentName != null : !this$dbtEnvironmentName.equals(other$dbtEnvironmentName)) return false;
        final java.lang.Object this$dbtJobName = this.getDbtJobName();
        final java.lang.Object other$dbtJobName = other.getDbtJobName();
        if (this$dbtJobName == null ? other$dbtJobName != null : !this$dbtJobName.equals(other$dbtJobName)) return false;
        final java.lang.Object this$dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        final java.lang.Object other$dbtJobNextRunHumanized = other.getDbtJobNextRunHumanized();
        if (this$dbtJobNextRunHumanized == null ? other$dbtJobNextRunHumanized != null : !this$dbtJobNextRunHumanized.equals(other$dbtJobNextRunHumanized)) return false;
        final java.lang.Object this$dbtJobRuns = this.getDbtJobRuns();
        final java.lang.Object other$dbtJobRuns = other.getDbtJobRuns();
        if (this$dbtJobRuns == null ? other$dbtJobRuns != null : !this$dbtJobRuns.equals(other$dbtJobRuns)) return false;
        final java.lang.Object this$dbtJobSchedule = this.getDbtJobSchedule();
        final java.lang.Object other$dbtJobSchedule = other.getDbtJobSchedule();
        if (this$dbtJobSchedule == null ? other$dbtJobSchedule != null : !this$dbtJobSchedule.equals(other$dbtJobSchedule)) return false;
        final java.lang.Object this$dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        final java.lang.Object other$dbtJobScheduleCronHumanized = other.getDbtJobScheduleCronHumanized();
        if (this$dbtJobScheduleCronHumanized == null ? other$dbtJobScheduleCronHumanized != null : !this$dbtJobScheduleCronHumanized.equals(other$dbtJobScheduleCronHumanized)) return false;
        final java.lang.Object this$dbtJobStatus = this.getDbtJobStatus();
        final java.lang.Object other$dbtJobStatus = other.getDbtJobStatus();
        if (this$dbtJobStatus == null ? other$dbtJobStatus != null : !this$dbtJobStatus.equals(other$dbtJobStatus)) return false;
        final java.lang.Object this$dbtMeta = this.getDbtMeta();
        final java.lang.Object other$dbtMeta = other.getDbtMeta();
        if (this$dbtMeta == null ? other$dbtMeta != null : !this$dbtMeta.equals(other$dbtMeta)) return false;
        final java.lang.Object this$dbtMetricFilterColumns = this.getDbtMetricFilterColumns();
        final java.lang.Object other$dbtMetricFilterColumns = other.getDbtMetricFilterColumns();
        if (this$dbtMetricFilterColumns == null ? other$dbtMetricFilterColumns != null : !this$dbtMetricFilterColumns.equals(other$dbtMetricFilterColumns)) return false;
        final java.lang.Object this$dbtMetricFilters = this.getDbtMetricFilters();
        final java.lang.Object other$dbtMetricFilters = other.getDbtMetricFilters();
        if (this$dbtMetricFilters == null ? other$dbtMetricFilters != null : !this$dbtMetricFilters.equals(other$dbtMetricFilters)) return false;
        final java.lang.Object this$dbtModel = this.getDbtModel();
        final java.lang.Object other$dbtModel = other.getDbtModel();
        if (this$dbtModel == null ? other$dbtModel != null : !this$dbtModel.equals(other$dbtModel)) return false;
        final java.lang.Object this$dbtPackageName = this.getDbtPackageName();
        final java.lang.Object other$dbtPackageName = other.getDbtPackageName();
        if (this$dbtPackageName == null ? other$dbtPackageName != null : !this$dbtPackageName.equals(other$dbtPackageName)) return false;
        final java.lang.Object this$dbtProjectName = this.getDbtProjectName();
        final java.lang.Object other$dbtProjectName = other.getDbtProjectName();
        if (this$dbtProjectName == null ? other$dbtProjectName != null : !this$dbtProjectName.equals(other$dbtProjectName)) return false;
        final java.lang.Object this$dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        final java.lang.Object other$dbtSemanticLayerProxyUrl = other.getDbtSemanticLayerProxyUrl();
        if (this$dbtSemanticLayerProxyUrl == null ? other$dbtSemanticLayerProxyUrl != null : !this$dbtSemanticLayerProxyUrl.equals(other$dbtSemanticLayerProxyUrl)) return false;
        final java.lang.Object this$dbtTags = this.getDbtTags();
        final java.lang.Object other$dbtTags = other.getDbtTags();
        if (this$dbtTags == null ? other$dbtTags != null : !this$dbtTags.equals(other$dbtTags)) return false;
        final java.lang.Object this$dbtUniqueId = this.getDbtUniqueId();
        final java.lang.Object other$dbtUniqueId = other.getDbtUniqueId();
        if (this$dbtUniqueId == null ? other$dbtUniqueId != null : !this$dbtUniqueId.equals(other$dbtUniqueId)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$metricDimensionColumns = this.getMetricDimensionColumns();
        final java.lang.Object other$metricDimensionColumns = other.getMetricDimensionColumns();
        if (this$metricDimensionColumns == null ? other$metricDimensionColumns != null : !this$metricDimensionColumns.equals(other$metricDimensionColumns)) return false;
        final java.lang.Object this$metricFilters = this.getMetricFilters();
        final java.lang.Object other$metricFilters = other.getMetricFilters();
        if (this$metricFilters == null ? other$metricFilters != null : !this$metricFilters.equals(other$metricFilters)) return false;
        final java.lang.Object this$metricSQL = this.getMetricSQL();
        final java.lang.Object other$metricSQL = other.getMetricSQL();
        if (this$metricSQL == null ? other$metricSQL != null : !this$metricSQL.equals(other$metricSQL)) return false;
        final java.lang.Object this$metricTimeGrains = this.getMetricTimeGrains();
        final java.lang.Object other$metricTimeGrains = other.getMetricTimeGrains();
        if (this$metricTimeGrains == null ? other$metricTimeGrains != null : !this$metricTimeGrains.equals(other$metricTimeGrains)) return false;
        final java.lang.Object this$metricTimestampColumn = this.getMetricTimestampColumn();
        final java.lang.Object other$metricTimestampColumn = other.getMetricTimestampColumn();
        if (this$metricTimestampColumn == null ? other$metricTimestampColumn != null : !this$metricTimestampColumn.equals(other$metricTimestampColumn)) return false;
        final java.lang.Object this$metricType = this.getMetricType();
        final java.lang.Object other$metricType = other.getMetricType();
        if (this$metricType == null ? other$metricType != null : !this$metricType.equals(other$metricType)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof DbtMetric;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $dbtJobLastRun = this.getDbtJobLastRun();
        result = result * PRIME + ($dbtJobLastRun == null ? 43 : $dbtJobLastRun.hashCode());
        final java.lang.Object $dbtJobNextRun = this.getDbtJobNextRun();
        result = result * PRIME + ($dbtJobNextRun == null ? 43 : $dbtJobNextRun.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $assets = this.getAssets();
        result = result * PRIME + ($assets == null ? 43 : $assets.hashCode());
        final java.lang.Object $dbtAccountName = this.getDbtAccountName();
        result = result * PRIME + ($dbtAccountName == null ? 43 : $dbtAccountName.hashCode());
        final java.lang.Object $dbtAlias = this.getDbtAlias();
        result = result * PRIME + ($dbtAlias == null ? 43 : $dbtAlias.hashCode());
        final java.lang.Object $dbtConnectionContext = this.getDbtConnectionContext();
        result = result * PRIME + ($dbtConnectionContext == null ? 43 : $dbtConnectionContext.hashCode());
        final java.lang.Object $dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        result = result * PRIME + ($dbtEnvironmentDbtVersion == null ? 43 : $dbtEnvironmentDbtVersion.hashCode());
        final java.lang.Object $dbtEnvironmentName = this.getDbtEnvironmentName();
        result = result * PRIME + ($dbtEnvironmentName == null ? 43 : $dbtEnvironmentName.hashCode());
        final java.lang.Object $dbtJobName = this.getDbtJobName();
        result = result * PRIME + ($dbtJobName == null ? 43 : $dbtJobName.hashCode());
        final java.lang.Object $dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        result = result * PRIME + ($dbtJobNextRunHumanized == null ? 43 : $dbtJobNextRunHumanized.hashCode());
        final java.lang.Object $dbtJobRuns = this.getDbtJobRuns();
        result = result * PRIME + ($dbtJobRuns == null ? 43 : $dbtJobRuns.hashCode());
        final java.lang.Object $dbtJobSchedule = this.getDbtJobSchedule();
        result = result * PRIME + ($dbtJobSchedule == null ? 43 : $dbtJobSchedule.hashCode());
        final java.lang.Object $dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        result = result * PRIME + ($dbtJobScheduleCronHumanized == null ? 43 : $dbtJobScheduleCronHumanized.hashCode());
        final java.lang.Object $dbtJobStatus = this.getDbtJobStatus();
        result = result * PRIME + ($dbtJobStatus == null ? 43 : $dbtJobStatus.hashCode());
        final java.lang.Object $dbtMeta = this.getDbtMeta();
        result = result * PRIME + ($dbtMeta == null ? 43 : $dbtMeta.hashCode());
        final java.lang.Object $dbtMetricFilterColumns = this.getDbtMetricFilterColumns();
        result = result * PRIME + ($dbtMetricFilterColumns == null ? 43 : $dbtMetricFilterColumns.hashCode());
        final java.lang.Object $dbtMetricFilters = this.getDbtMetricFilters();
        result = result * PRIME + ($dbtMetricFilters == null ? 43 : $dbtMetricFilters.hashCode());
        final java.lang.Object $dbtModel = this.getDbtModel();
        result = result * PRIME + ($dbtModel == null ? 43 : $dbtModel.hashCode());
        final java.lang.Object $dbtPackageName = this.getDbtPackageName();
        result = result * PRIME + ($dbtPackageName == null ? 43 : $dbtPackageName.hashCode());
        final java.lang.Object $dbtProjectName = this.getDbtProjectName();
        result = result * PRIME + ($dbtProjectName == null ? 43 : $dbtProjectName.hashCode());
        final java.lang.Object $dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        result = result * PRIME + ($dbtSemanticLayerProxyUrl == null ? 43 : $dbtSemanticLayerProxyUrl.hashCode());
        final java.lang.Object $dbtTags = this.getDbtTags();
        result = result * PRIME + ($dbtTags == null ? 43 : $dbtTags.hashCode());
        final java.lang.Object $dbtUniqueId = this.getDbtUniqueId();
        result = result * PRIME + ($dbtUniqueId == null ? 43 : $dbtUniqueId.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $metricDimensionColumns = this.getMetricDimensionColumns();
        result = result * PRIME + ($metricDimensionColumns == null ? 43 : $metricDimensionColumns.hashCode());
        final java.lang.Object $metricFilters = this.getMetricFilters();
        result = result * PRIME + ($metricFilters == null ? 43 : $metricFilters.hashCode());
        final java.lang.Object $metricSQL = this.getMetricSQL();
        result = result * PRIME + ($metricSQL == null ? 43 : $metricSQL.hashCode());
        final java.lang.Object $metricTimeGrains = this.getMetricTimeGrains();
        result = result * PRIME + ($metricTimeGrains == null ? 43 : $metricTimeGrains.hashCode());
        final java.lang.Object $metricTimestampColumn = this.getMetricTimestampColumn();
        result = result * PRIME + ($metricTimestampColumn == null ? 43 : $metricTimestampColumn.hashCode());
        final java.lang.Object $metricType = this.getMetricType();
        result = result * PRIME + ($metricType == null ? 43 : $metricType.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "DbtMetric(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", assets=" + this.getAssets() + ", dbtAccountName=" + this.getDbtAccountName() + ", dbtAlias=" + this.getDbtAlias() + ", dbtConnectionContext=" + this.getDbtConnectionContext() + ", dbtEnvironmentDbtVersion=" + this.getDbtEnvironmentDbtVersion() + ", dbtEnvironmentName=" + this.getDbtEnvironmentName() + ", dbtJobLastRun=" + this.getDbtJobLastRun() + ", dbtJobName=" + this.getDbtJobName() + ", dbtJobNextRun=" + this.getDbtJobNextRun() + ", dbtJobNextRunHumanized=" + this.getDbtJobNextRunHumanized() + ", dbtJobRuns=" + this.getDbtJobRuns() + ", dbtJobSchedule=" + this.getDbtJobSchedule() + ", dbtJobScheduleCronHumanized=" + this.getDbtJobScheduleCronHumanized() + ", dbtJobStatus=" + this.getDbtJobStatus() + ", dbtMeta=" + this.getDbtMeta() + ", dbtMetricFilterColumns=" + this.getDbtMetricFilterColumns() + ", dbtMetricFilters=" + this.getDbtMetricFilters() + ", dbtModel=" + this.getDbtModel() + ", dbtPackageName=" + this.getDbtPackageName() + ", dbtProjectName=" + this.getDbtProjectName() + ", dbtSemanticLayerProxyUrl=" + this.getDbtSemanticLayerProxyUrl() + ", dbtTags=" + this.getDbtTags() + ", dbtUniqueId=" + this.getDbtUniqueId() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", metricDimensionColumns=" + this.getMetricDimensionColumns() + ", metricFilters=" + this.getMetricFilters() + ", metricSQL=" + this.getMetricSQL() + ", metricTimeGrains=" + this.getMetricTimeGrains() + ", metricTimestampColumn=" + this.getMetricTimestampColumn() + ", metricType=" + this.getMetricType() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for DbtMetrics.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
