// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.DbtJobRun;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a dbt model in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class DbtModel extends Asset implements IDbtModel, IDbt, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(DbtModel.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtModel";
    /**
     * Fixed typeName for DbtModels.
     */
    String typeName;
    /**
     * TBC
     */
    @Attribute
    String dbtAccountName;
    /**
     * TBC
     */
    @Attribute
    String dbtAlias;
    /**
     * TBC
     */
    @Attribute
    String dbtCompiledSQL;
    /**
     * TBC
     */
    @Attribute
    String dbtConnectionContext;
    /**
     * TBC
     */
    @Attribute
    String dbtEnvironmentDbtVersion;
    /**
     * TBC
     */
    @Attribute
    String dbtEnvironmentName;
    /**
     * TBC
     */
    @Attribute
    String dbtError;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long dbtJobLastRun;
    /**
     * TBC
     */
    @Attribute
    String dbtJobName;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long dbtJobNextRun;
    /**
     * TBC
     */
    @Attribute
    String dbtJobNextRunHumanized;
    /**
     * List of latest DBT job runs across all environments
     */
    @Attribute
    List<DbtJobRun> dbtJobRuns;
    /**
     * TBC
     */
    @Attribute
    String dbtJobSchedule;
    /**
     * TBC
     */
    @Attribute
    String dbtJobScheduleCronHumanized;
    /**
     * TBC
     */
    @Attribute
    String dbtJobStatus;
    /**
     * TBC
     */
    @Attribute
    String dbtMaterializationType;
    /**
     * TBC
     */
    @Attribute
    String dbtMeta;
    /**
     * Metrics that exist within this model.
     */
    @Attribute
    SortedSet<IDbtMetric> dbtMetrics;
    /**
     * Columns that exist within this dbt model.
     */
    @Attribute
    SortedSet<IDbtModelColumn> dbtModelColumns;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long dbtModelCompileCompletedAt;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long dbtModelCompileStartedAt;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long dbtModelExecuteCompletedAt;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long dbtModelExecuteStartedAt;
    /**
     * TBC
     */
    @Attribute
    Double dbtModelExecutionTime;
    /**
     * TBC
     */
    @Attribute
    Double dbtModelRunElapsedTime;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long dbtModelRunGeneratedAt;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISQL> dbtModelSqlAssets;
    /**
     * TBC
     */
    @Attribute
    String dbtPackageName;
    /**
     * TBC
     */
    @Attribute
    String dbtProjectName;
    /**
     * TBC
     */
    @Attribute
    String dbtRawSQL;
    /**
     * TBC
     */
    @Attribute
    String dbtSemanticLayerProxyUrl;
    /**
     * TBC
     */
    @Attribute
    String dbtStats;
    /**
     * TBC
     */
    @Attribute
    String dbtStatus;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> dbtTags;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    /**
     * TBC
     */
    @Attribute
    String dbtUniqueId;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * TBC
     */
    @Attribute
    @JsonProperty("sqlAsset")
    ISQL primarySqlAsset;

    /**
     * Builds the minimal object necessary to create a relationship to a DbtModel, from a potentially
     * more-complete DbtModel object.
     *
     * @return the minimal object necessary to relate to the DbtModel
     * @throws InvalidRequestException if any of the minimal set of required properties for a DbtModel relationship are not found in the initial object
     */
    @Override
    public DbtModel trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all DbtModel assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DbtModel assets will be included.
     *
     * @return a fluent search that includes all DbtModel assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all DbtModel assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DbtModel assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all DbtModel assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all DbtModel assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) DbtModels will be included
     * @return a fluent search that includes all DbtModel assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all DbtModel assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) DbtModels will be included
     * @return a fluent search that includes all DbtModel assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a DbtModel by GUID. Use this to create a relationship to this DbtModel,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the DbtModel to reference
     * @return reference to a DbtModel that can be used for defining a relationship to a DbtModel
     */
    public static DbtModel refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DbtModel by GUID. Use this to create a relationship to this DbtModel,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the DbtModel to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DbtModel that can be used for defining a relationship to a DbtModel
     */
    public static DbtModel refByGuid(String guid, Reference.SaveSemantic semantic) {
        return DbtModel._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a DbtModel by qualifiedName. Use this to create a relationship to this DbtModel,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the DbtModel to reference
     * @return reference to a DbtModel that can be used for defining a relationship to a DbtModel
     */
    public static DbtModel refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DbtModel by qualifiedName. Use this to create a relationship to this DbtModel,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the DbtModel to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DbtModel that can be used for defining a relationship to a DbtModel
     */
    public static DbtModel refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return DbtModel._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a DbtModel by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the DbtModel to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DbtModel, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DbtModel does not exist or the provided GUID is not a DbtModel
     */
    @JsonIgnore
    public static DbtModel get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a DbtModel by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DbtModel to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DbtModel, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DbtModel does not exist or the provided GUID is not a DbtModel
     */
    @JsonIgnore
    public static DbtModel get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a DbtModel by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DbtModel to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full DbtModel, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DbtModel does not exist or the provided GUID is not a DbtModel
     */
    @JsonIgnore
    public static DbtModel get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof DbtModel) {
                return (DbtModel) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof DbtModel) {
                return (DbtModel) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) DbtModel to active.
     *
     * @param qualifiedName for the DbtModel
     * @return true if the DbtModel is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) DbtModel to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the DbtModel
     * @return true if the DbtModel is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a DbtModel.
     *
     * @param qualifiedName of the DbtModel
     * @param name of the DbtModel
     * @return the minimal request necessary to update the DbtModel, as a builder
     */
    public static DbtModelBuilder<?, ?> updater(String qualifiedName, String name) {
        return DbtModel._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a DbtModel, from a potentially
     * more-complete DbtModel object.
     *
     * @return the minimal object necessary to update the DbtModel, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for DbtModel are not found in the initial object
     */
    @Override
    public DbtModelBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a DbtModel.
     *
     * @param qualifiedName of the DbtModel
     * @param name of the DbtModel
     * @return the updated DbtModel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a DbtModel.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DbtModel
     * @param name of the DbtModel
     * @return the updated DbtModel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtModel) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a DbtModel.
     *
     * @param qualifiedName of the DbtModel
     * @param name of the DbtModel
     * @return the updated DbtModel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a DbtModel.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DbtModel
     * @param name of the DbtModel
     * @return the updated DbtModel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtModel) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a DbtModel.
     *
     * @param qualifiedName of the DbtModel
     * @param name of the DbtModel
     * @return the updated DbtModel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a DbtModel.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DbtModel's owners
     * @param qualifiedName of the DbtModel
     * @param name of the DbtModel
     * @return the updated DbtModel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtModel) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a DbtModel.
     *
     * @param qualifiedName of the DbtModel
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DbtModel, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a DbtModel.
     *
     * @param client connectivity to the Atlan tenant on which to update the DbtModel's certificate
     * @param qualifiedName of the DbtModel
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DbtModel, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DbtModel) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a DbtModel.
     *
     * @param qualifiedName of the DbtModel
     * @param name of the DbtModel
     * @return the updated DbtModel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a DbtModel.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DbtModel's certificate
     * @param qualifiedName of the DbtModel
     * @param name of the DbtModel
     * @return the updated DbtModel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtModel) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a DbtModel.
     *
     * @param qualifiedName of the DbtModel
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a DbtModel.
     *
     * @param client connectivity to the Atlan tenant on which to update the DbtModel's announcement
     * @param qualifiedName of the DbtModel
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtModel) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a DbtModel.
     *
     * @param qualifiedName of the DbtModel
     * @param name of the DbtModel
     * @return the updated DbtModel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a DbtModel.
     *
     * @param client connectivity to the Atlan client from which to remove the DbtModel's announcement
     * @param qualifiedName of the DbtModel
     * @param name of the DbtModel
     * @return the updated DbtModel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DbtModel removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtModel) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the DbtModel.
     *
     * @param qualifiedName for the DbtModel
     * @param name human-readable name of the DbtModel
     * @param terms the list of terms to replace on the DbtModel, or null to remove all terms from the DbtModel
     * @return the DbtModel that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DbtModel replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the DbtModel.
     *
     * @param client connectivity to the Atlan tenant on which to replace the DbtModel's assigned terms
     * @param qualifiedName for the DbtModel
     * @param name human-readable name of the DbtModel
     * @param terms the list of terms to replace on the DbtModel, or null to remove all terms from the DbtModel
     * @return the DbtModel that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DbtModel replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtModel) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the DbtModel, without replacing existing terms linked to the DbtModel.
     * Note: this operation must make two API calls — one to retrieve the DbtModel's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the DbtModel
     * @param terms the list of terms to append to the DbtModel
     * @return the DbtModel that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DbtModel appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the DbtModel, without replacing existing terms linked to the DbtModel.
     * Note: this operation must make two API calls — one to retrieve the DbtModel's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the DbtModel
     * @param qualifiedName for the DbtModel
     * @param terms the list of terms to append to the DbtModel
     * @return the DbtModel that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DbtModel appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtModel) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a DbtModel, without replacing all existing terms linked to the DbtModel.
     * Note: this operation must make two API calls — one to retrieve the DbtModel's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the DbtModel
     * @param terms the list of terms to remove from the DbtModel, which must be referenced by GUID
     * @return the DbtModel that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DbtModel removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a DbtModel, without replacing all existing terms linked to the DbtModel.
     * Note: this operation must make two API calls — one to retrieve the DbtModel's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the DbtModel
     * @param qualifiedName for the DbtModel
     * @param terms the list of terms to remove from the DbtModel, which must be referenced by GUID
     * @return the DbtModel that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DbtModel removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtModel) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a DbtModel, without replacing existing Atlan tags linked to the DbtModel.
     * Note: this operation must make two API calls — one to retrieve the DbtModel's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DbtModel
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DbtModel
     */
    public static DbtModel appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DbtModel, without replacing existing Atlan tags linked to the DbtModel.
     * Note: this operation must make two API calls — one to retrieve the DbtModel's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DbtModel
     * @param qualifiedName of the DbtModel
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DbtModel
     */
    public static DbtModel appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DbtModel) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DbtModel, without replacing existing Atlan tags linked to the DbtModel.
     * Note: this operation must make two API calls — one to retrieve the DbtModel's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DbtModel
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DbtModel
     */
    public static DbtModel appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a DbtModel, without replacing existing Atlan tags linked to the DbtModel.
     * Note: this operation must make two API calls — one to retrieve the DbtModel's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DbtModel
     * @param qualifiedName of the DbtModel
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DbtModel
     */
    public static DbtModel appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DbtModel) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a DbtModel.
     *
     * @param qualifiedName of the DbtModel
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DbtModel
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a DbtModel.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a DbtModel
     * @param qualifiedName of the DbtModel
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DbtModel
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class DbtModelBuilder<C extends DbtModel, B extends DbtModel.DbtModelBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtAccountName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtAlias;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtCompiledSQL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtConnectionContext;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtEnvironmentDbtVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtEnvironmentName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtError;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dbtJobLastRun;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dbtJobNextRun;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobNextRunHumanized;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<DbtJobRun> dbtJobRuns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobSchedule;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobScheduleCronHumanized;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtMaterializationType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtMeta;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtMetric> dbtMetrics;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModelColumn> dbtModelColumns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dbtModelCompileCompletedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dbtModelCompileStartedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dbtModelExecuteCompletedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dbtModelExecuteStartedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double dbtModelExecutionTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double dbtModelRunElapsedTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dbtModelRunGeneratedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISQL> dbtModelSqlAssets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtPackageName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtProjectName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtRawSQL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtSemanticLayerProxyUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtStats;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> dbtTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtTest> dbtTests;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtUniqueId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ISQL primarySqlAsset;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            DbtModel.DbtModelBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final DbtModel instance, final DbtModel.DbtModelBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dbtAccountName(instance.dbtAccountName);
            b.dbtAlias(instance.dbtAlias);
            b.dbtCompiledSQL(instance.dbtCompiledSQL);
            b.dbtConnectionContext(instance.dbtConnectionContext);
            b.dbtEnvironmentDbtVersion(instance.dbtEnvironmentDbtVersion);
            b.dbtEnvironmentName(instance.dbtEnvironmentName);
            b.dbtError(instance.dbtError);
            b.dbtJobLastRun(instance.dbtJobLastRun);
            b.dbtJobName(instance.dbtJobName);
            b.dbtJobNextRun(instance.dbtJobNextRun);
            b.dbtJobNextRunHumanized(instance.dbtJobNextRunHumanized);
            b.dbtJobRuns(instance.dbtJobRuns == null ? java.util.Collections.<DbtJobRun>emptyList() : instance.dbtJobRuns);
            b.dbtJobSchedule(instance.dbtJobSchedule);
            b.dbtJobScheduleCronHumanized(instance.dbtJobScheduleCronHumanized);
            b.dbtJobStatus(instance.dbtJobStatus);
            b.dbtMaterializationType(instance.dbtMaterializationType);
            b.dbtMeta(instance.dbtMeta);
            b.dbtMetrics(instance.dbtMetrics == null ? java.util.Collections.<IDbtMetric>emptySortedSet() : instance.dbtMetrics);
            b.dbtModelColumns(instance.dbtModelColumns == null ? java.util.Collections.<IDbtModelColumn>emptySortedSet() : instance.dbtModelColumns);
            b.dbtModelCompileCompletedAt(instance.dbtModelCompileCompletedAt);
            b.dbtModelCompileStartedAt(instance.dbtModelCompileStartedAt);
            b.dbtModelExecuteCompletedAt(instance.dbtModelExecuteCompletedAt);
            b.dbtModelExecuteStartedAt(instance.dbtModelExecuteStartedAt);
            b.dbtModelExecutionTime(instance.dbtModelExecutionTime);
            b.dbtModelRunElapsedTime(instance.dbtModelRunElapsedTime);
            b.dbtModelRunGeneratedAt(instance.dbtModelRunGeneratedAt);
            b.dbtModelSqlAssets(instance.dbtModelSqlAssets == null ? java.util.Collections.<ISQL>emptySortedSet() : instance.dbtModelSqlAssets);
            b.dbtPackageName(instance.dbtPackageName);
            b.dbtProjectName(instance.dbtProjectName);
            b.dbtRawSQL(instance.dbtRawSQL);
            b.dbtSemanticLayerProxyUrl(instance.dbtSemanticLayerProxyUrl);
            b.dbtStats(instance.dbtStats);
            b.dbtStatus(instance.dbtStatus);
            b.dbtTags(instance.dbtTags == null ? java.util.Collections.<String>emptySortedSet() : instance.dbtTags);
            b.dbtTests(instance.dbtTests == null ? java.util.Collections.<IDbtTest>emptySortedSet() : instance.dbtTests);
            b.dbtUniqueId(instance.dbtUniqueId);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.primarySqlAsset(instance.primarySqlAsset);
        }

        /**
         * Fixed typeName for DbtModels.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtAccountName(final String dbtAccountName) {
            this.dbtAccountName = dbtAccountName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtAlias(final String dbtAlias) {
            this.dbtAlias = dbtAlias;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtCompiledSQL(final String dbtCompiledSQL) {
            this.dbtCompiledSQL = dbtCompiledSQL;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtConnectionContext(final String dbtConnectionContext) {
            this.dbtConnectionContext = dbtConnectionContext;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtEnvironmentDbtVersion(final String dbtEnvironmentDbtVersion) {
            this.dbtEnvironmentDbtVersion = dbtEnvironmentDbtVersion;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtEnvironmentName(final String dbtEnvironmentName) {
            this.dbtEnvironmentName = dbtEnvironmentName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtError(final String dbtError) {
            this.dbtError = dbtError;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobLastRun(final Long dbtJobLastRun) {
            this.dbtJobLastRun = dbtJobLastRun;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobName(final String dbtJobName) {
            this.dbtJobName = dbtJobName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobNextRun(final Long dbtJobNextRun) {
            this.dbtJobNextRun = dbtJobNextRun;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobNextRunHumanized(final String dbtJobNextRunHumanized) {
            this.dbtJobNextRunHumanized = dbtJobNextRunHumanized;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobRun(final DbtJobRun dbtJobRun) {
            if (this.dbtJobRuns == null) this.dbtJobRuns = new java.util.ArrayList<DbtJobRun>();
            this.dbtJobRuns.add(dbtJobRun);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobRuns(final java.util.Collection<? extends DbtJobRun> dbtJobRuns) {
            if (dbtJobRuns == null) {
                throw new java.lang.NullPointerException("dbtJobRuns cannot be null");
            }
            if (this.dbtJobRuns == null) this.dbtJobRuns = new java.util.ArrayList<DbtJobRun>();
            this.dbtJobRuns.addAll(dbtJobRuns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtJobRuns() {
            if (this.dbtJobRuns != null) this.dbtJobRuns.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobSchedule(final String dbtJobSchedule) {
            this.dbtJobSchedule = dbtJobSchedule;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobScheduleCronHumanized(final String dbtJobScheduleCronHumanized) {
            this.dbtJobScheduleCronHumanized = dbtJobScheduleCronHumanized;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobStatus(final String dbtJobStatus) {
            this.dbtJobStatus = dbtJobStatus;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtMaterializationType(final String dbtMaterializationType) {
            this.dbtMaterializationType = dbtMaterializationType;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtMeta(final String dbtMeta) {
            this.dbtMeta = dbtMeta;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtMetric(final IDbtMetric dbtMetric) {
            if (this.dbtMetrics == null) this.dbtMetrics = new java.util.ArrayList<IDbtMetric>();
            this.dbtMetrics.add(dbtMetric);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtMetrics(final java.util.Collection<? extends IDbtMetric> dbtMetrics) {
            if (dbtMetrics == null) {
                throw new java.lang.NullPointerException("dbtMetrics cannot be null");
            }
            if (this.dbtMetrics == null) this.dbtMetrics = new java.util.ArrayList<IDbtMetric>();
            this.dbtMetrics.addAll(dbtMetrics);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtMetrics() {
            if (this.dbtMetrics != null) this.dbtMetrics.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelColumn(final IDbtModelColumn dbtModelColumn) {
            if (this.dbtModelColumns == null) this.dbtModelColumns = new java.util.ArrayList<IDbtModelColumn>();
            this.dbtModelColumns.add(dbtModelColumn);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelColumns(final java.util.Collection<? extends IDbtModelColumn> dbtModelColumns) {
            if (dbtModelColumns == null) {
                throw new java.lang.NullPointerException("dbtModelColumns cannot be null");
            }
            if (this.dbtModelColumns == null) this.dbtModelColumns = new java.util.ArrayList<IDbtModelColumn>();
            this.dbtModelColumns.addAll(dbtModelColumns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtModelColumns() {
            if (this.dbtModelColumns != null) this.dbtModelColumns.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelCompileCompletedAt(final Long dbtModelCompileCompletedAt) {
            this.dbtModelCompileCompletedAt = dbtModelCompileCompletedAt;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelCompileStartedAt(final Long dbtModelCompileStartedAt) {
            this.dbtModelCompileStartedAt = dbtModelCompileStartedAt;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelExecuteCompletedAt(final Long dbtModelExecuteCompletedAt) {
            this.dbtModelExecuteCompletedAt = dbtModelExecuteCompletedAt;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelExecuteStartedAt(final Long dbtModelExecuteStartedAt) {
            this.dbtModelExecuteStartedAt = dbtModelExecuteStartedAt;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelExecutionTime(final Double dbtModelExecutionTime) {
            this.dbtModelExecutionTime = dbtModelExecutionTime;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelRunElapsedTime(final Double dbtModelRunElapsedTime) {
            this.dbtModelRunElapsedTime = dbtModelRunElapsedTime;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelRunGeneratedAt(final Long dbtModelRunGeneratedAt) {
            this.dbtModelRunGeneratedAt = dbtModelRunGeneratedAt;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelSqlAsset(final ISQL dbtModelSqlAsset) {
            if (this.dbtModelSqlAssets == null) this.dbtModelSqlAssets = new java.util.ArrayList<ISQL>();
            this.dbtModelSqlAssets.add(dbtModelSqlAsset);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelSqlAssets(final java.util.Collection<? extends ISQL> dbtModelSqlAssets) {
            if (dbtModelSqlAssets == null) {
                throw new java.lang.NullPointerException("dbtModelSqlAssets cannot be null");
            }
            if (this.dbtModelSqlAssets == null) this.dbtModelSqlAssets = new java.util.ArrayList<ISQL>();
            this.dbtModelSqlAssets.addAll(dbtModelSqlAssets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtModelSqlAssets() {
            if (this.dbtModelSqlAssets != null) this.dbtModelSqlAssets.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtPackageName(final String dbtPackageName) {
            this.dbtPackageName = dbtPackageName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtProjectName(final String dbtProjectName) {
            this.dbtProjectName = dbtProjectName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtRawSQL(final String dbtRawSQL) {
            this.dbtRawSQL = dbtRawSQL;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtSemanticLayerProxyUrl(final String dbtSemanticLayerProxyUrl) {
            this.dbtSemanticLayerProxyUrl = dbtSemanticLayerProxyUrl;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtStats(final String dbtStats) {
            this.dbtStats = dbtStats;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtStatus(final String dbtStatus) {
            this.dbtStatus = dbtStatus;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTag(final String dbtTag) {
            if (this.dbtTags == null) this.dbtTags = new java.util.ArrayList<String>();
            this.dbtTags.add(dbtTag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTags(final java.util.Collection<? extends String> dbtTags) {
            if (dbtTags == null) {
                throw new java.lang.NullPointerException("dbtTags cannot be null");
            }
            if (this.dbtTags == null) this.dbtTags = new java.util.ArrayList<String>();
            this.dbtTags.addAll(dbtTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtTags() {
            if (this.dbtTags != null) this.dbtTags.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTest(final IDbtTest dbtTest) {
            if (this.dbtTests == null) this.dbtTests = new java.util.ArrayList<IDbtTest>();
            this.dbtTests.add(dbtTest);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTests(final java.util.Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new java.lang.NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) this.dbtTests = new java.util.ArrayList<IDbtTest>();
            this.dbtTests.addAll(dbtTests);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) this.dbtTests.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtUniqueId(final String dbtUniqueId) {
            this.dbtUniqueId = dbtUniqueId;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @JsonProperty("sqlAsset")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B primarySqlAsset(final ISQL primarySqlAsset) {
            this.primarySqlAsset = primarySqlAsset;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "DbtModel.DbtModelBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dbtAccountName=" + this.dbtAccountName + ", dbtAlias=" + this.dbtAlias + ", dbtCompiledSQL=" + this.dbtCompiledSQL + ", dbtConnectionContext=" + this.dbtConnectionContext + ", dbtEnvironmentDbtVersion=" + this.dbtEnvironmentDbtVersion + ", dbtEnvironmentName=" + this.dbtEnvironmentName + ", dbtError=" + this.dbtError + ", dbtJobLastRun=" + this.dbtJobLastRun + ", dbtJobName=" + this.dbtJobName + ", dbtJobNextRun=" + this.dbtJobNextRun + ", dbtJobNextRunHumanized=" + this.dbtJobNextRunHumanized + ", dbtJobRuns=" + this.dbtJobRuns + ", dbtJobSchedule=" + this.dbtJobSchedule + ", dbtJobScheduleCronHumanized=" + this.dbtJobScheduleCronHumanized + ", dbtJobStatus=" + this.dbtJobStatus + ", dbtMaterializationType=" + this.dbtMaterializationType + ", dbtMeta=" + this.dbtMeta + ", dbtMetrics=" + this.dbtMetrics + ", dbtModelColumns=" + this.dbtModelColumns + ", dbtModelCompileCompletedAt=" + this.dbtModelCompileCompletedAt + ", dbtModelCompileStartedAt=" + this.dbtModelCompileStartedAt + ", dbtModelExecuteCompletedAt=" + this.dbtModelExecuteCompletedAt + ", dbtModelExecuteStartedAt=" + this.dbtModelExecuteStartedAt + ", dbtModelExecutionTime=" + this.dbtModelExecutionTime + ", dbtModelRunElapsedTime=" + this.dbtModelRunElapsedTime + ", dbtModelRunGeneratedAt=" + this.dbtModelRunGeneratedAt + ", dbtModelSqlAssets=" + this.dbtModelSqlAssets + ", dbtPackageName=" + this.dbtPackageName + ", dbtProjectName=" + this.dbtProjectName + ", dbtRawSQL=" + this.dbtRawSQL + ", dbtSemanticLayerProxyUrl=" + this.dbtSemanticLayerProxyUrl + ", dbtStats=" + this.dbtStats + ", dbtStatus=" + this.dbtStatus + ", dbtTags=" + this.dbtTags + ", dbtTests=" + this.dbtTests + ", dbtUniqueId=" + this.dbtUniqueId + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", primarySqlAsset=" + this.primarySqlAsset + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class DbtModelBuilderImpl extends DbtModel.DbtModelBuilder<DbtModel, DbtModel.DbtModelBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DbtModelBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DbtModel.DbtModelBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DbtModel build() {
            return new DbtModel(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected DbtModel(final DbtModel.DbtModelBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = DbtModel.$default$typeName();
        this.dbtAccountName = b.dbtAccountName;
        this.dbtAlias = b.dbtAlias;
        this.dbtCompiledSQL = b.dbtCompiledSQL;
        this.dbtConnectionContext = b.dbtConnectionContext;
        this.dbtEnvironmentDbtVersion = b.dbtEnvironmentDbtVersion;
        this.dbtEnvironmentName = b.dbtEnvironmentName;
        this.dbtError = b.dbtError;
        this.dbtJobLastRun = b.dbtJobLastRun;
        this.dbtJobName = b.dbtJobName;
        this.dbtJobNextRun = b.dbtJobNextRun;
        this.dbtJobNextRunHumanized = b.dbtJobNextRunHumanized;
        java.util.List<DbtJobRun> dbtJobRuns;
        switch (b.dbtJobRuns == null ? 0 : b.dbtJobRuns.size()) {
        case 0: 
            dbtJobRuns = java.util.Collections.emptyList();
            break;
        case 1: 
            dbtJobRuns = java.util.Collections.singletonList(b.dbtJobRuns.get(0));
            break;
        default: 
            dbtJobRuns = java.util.Collections.unmodifiableList(new java.util.ArrayList<DbtJobRun>(b.dbtJobRuns));
        }
        this.dbtJobRuns = dbtJobRuns;
        this.dbtJobSchedule = b.dbtJobSchedule;
        this.dbtJobScheduleCronHumanized = b.dbtJobScheduleCronHumanized;
        this.dbtJobStatus = b.dbtJobStatus;
        this.dbtMaterializationType = b.dbtMaterializationType;
        this.dbtMeta = b.dbtMeta;
        java.util.SortedSet<IDbtMetric> dbtMetrics = new java.util.TreeSet<IDbtMetric>();
        if (b.dbtMetrics != null) dbtMetrics.addAll(b.dbtMetrics);
        dbtMetrics = java.util.Collections.unmodifiableSortedSet(dbtMetrics);
        this.dbtMetrics = dbtMetrics;
        java.util.SortedSet<IDbtModelColumn> dbtModelColumns = new java.util.TreeSet<IDbtModelColumn>();
        if (b.dbtModelColumns != null) dbtModelColumns.addAll(b.dbtModelColumns);
        dbtModelColumns = java.util.Collections.unmodifiableSortedSet(dbtModelColumns);
        this.dbtModelColumns = dbtModelColumns;
        this.dbtModelCompileCompletedAt = b.dbtModelCompileCompletedAt;
        this.dbtModelCompileStartedAt = b.dbtModelCompileStartedAt;
        this.dbtModelExecuteCompletedAt = b.dbtModelExecuteCompletedAt;
        this.dbtModelExecuteStartedAt = b.dbtModelExecuteStartedAt;
        this.dbtModelExecutionTime = b.dbtModelExecutionTime;
        this.dbtModelRunElapsedTime = b.dbtModelRunElapsedTime;
        this.dbtModelRunGeneratedAt = b.dbtModelRunGeneratedAt;
        java.util.SortedSet<ISQL> dbtModelSqlAssets = new java.util.TreeSet<ISQL>();
        if (b.dbtModelSqlAssets != null) dbtModelSqlAssets.addAll(b.dbtModelSqlAssets);
        dbtModelSqlAssets = java.util.Collections.unmodifiableSortedSet(dbtModelSqlAssets);
        this.dbtModelSqlAssets = dbtModelSqlAssets;
        this.dbtPackageName = b.dbtPackageName;
        this.dbtProjectName = b.dbtProjectName;
        this.dbtRawSQL = b.dbtRawSQL;
        this.dbtSemanticLayerProxyUrl = b.dbtSemanticLayerProxyUrl;
        this.dbtStats = b.dbtStats;
        this.dbtStatus = b.dbtStatus;
        java.util.SortedSet<String> dbtTags = new java.util.TreeSet<String>();
        if (b.dbtTags != null) dbtTags.addAll(b.dbtTags);
        dbtTags = java.util.Collections.unmodifiableSortedSet(dbtTags);
        this.dbtTags = dbtTags;
        java.util.SortedSet<IDbtTest> dbtTests = new java.util.TreeSet<IDbtTest>();
        if (b.dbtTests != null) dbtTests.addAll(b.dbtTests);
        dbtTests = java.util.Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        this.dbtUniqueId = b.dbtUniqueId;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.primarySqlAsset = b.primarySqlAsset;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static DbtModel.DbtModelBuilder<?, ?> _internal() {
        return new DbtModel.DbtModelBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DbtModel.DbtModelBuilder<?, ?> toBuilder() {
        return new DbtModel.DbtModelBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtAccountName() {
        return this.dbtAccountName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtAlias() {
        return this.dbtAlias;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtCompiledSQL() {
        return this.dbtCompiledSQL;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtConnectionContext() {
        return this.dbtConnectionContext;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtEnvironmentDbtVersion() {
        return this.dbtEnvironmentDbtVersion;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtEnvironmentName() {
        return this.dbtEnvironmentName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtError() {
        return this.dbtError;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDbtJobLastRun() {
        return this.dbtJobLastRun;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobName() {
        return this.dbtJobName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDbtJobNextRun() {
        return this.dbtJobNextRun;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobNextRunHumanized() {
        return this.dbtJobNextRunHumanized;
    }

    /**
     * List of latest DBT job runs across all environments
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<DbtJobRun> getDbtJobRuns() {
        return this.dbtJobRuns;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobSchedule() {
        return this.dbtJobSchedule;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobScheduleCronHumanized() {
        return this.dbtJobScheduleCronHumanized;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobStatus() {
        return this.dbtJobStatus;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtMaterializationType() {
        return this.dbtMaterializationType;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtMeta() {
        return this.dbtMeta;
    }

    /**
     * Metrics that exist within this model.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtMetric> getDbtMetrics() {
        return this.dbtMetrics;
    }

    /**
     * Columns that exist within this dbt model.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModelColumn> getDbtModelColumns() {
        return this.dbtModelColumns;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDbtModelCompileCompletedAt() {
        return this.dbtModelCompileCompletedAt;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDbtModelCompileStartedAt() {
        return this.dbtModelCompileStartedAt;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDbtModelExecuteCompletedAt() {
        return this.dbtModelExecuteCompletedAt;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDbtModelExecuteStartedAt() {
        return this.dbtModelExecuteStartedAt;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getDbtModelExecutionTime() {
        return this.dbtModelExecutionTime;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getDbtModelRunElapsedTime() {
        return this.dbtModelRunElapsedTime;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDbtModelRunGeneratedAt() {
        return this.dbtModelRunGeneratedAt;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISQL> getDbtModelSqlAssets() {
        return this.dbtModelSqlAssets;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtPackageName() {
        return this.dbtPackageName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtProjectName() {
        return this.dbtProjectName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtRawSQL() {
        return this.dbtRawSQL;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtSemanticLayerProxyUrl() {
        return this.dbtSemanticLayerProxyUrl;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtStats() {
        return this.dbtStats;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtStatus() {
        return this.dbtStatus;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDbtTags() {
        return this.dbtTags;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtUniqueId() {
        return this.dbtUniqueId;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ISQL getPrimarySqlAsset() {
        return this.primarySqlAsset;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DbtModel)) return false;
        final DbtModel other = (DbtModel) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$dbtJobLastRun = this.getDbtJobLastRun();
        final java.lang.Object other$dbtJobLastRun = other.getDbtJobLastRun();
        if (this$dbtJobLastRun == null ? other$dbtJobLastRun != null : !this$dbtJobLastRun.equals(other$dbtJobLastRun)) return false;
        final java.lang.Object this$dbtJobNextRun = this.getDbtJobNextRun();
        final java.lang.Object other$dbtJobNextRun = other.getDbtJobNextRun();
        if (this$dbtJobNextRun == null ? other$dbtJobNextRun != null : !this$dbtJobNextRun.equals(other$dbtJobNextRun)) return false;
        final java.lang.Object this$dbtModelCompileCompletedAt = this.getDbtModelCompileCompletedAt();
        final java.lang.Object other$dbtModelCompileCompletedAt = other.getDbtModelCompileCompletedAt();
        if (this$dbtModelCompileCompletedAt == null ? other$dbtModelCompileCompletedAt != null : !this$dbtModelCompileCompletedAt.equals(other$dbtModelCompileCompletedAt)) return false;
        final java.lang.Object this$dbtModelCompileStartedAt = this.getDbtModelCompileStartedAt();
        final java.lang.Object other$dbtModelCompileStartedAt = other.getDbtModelCompileStartedAt();
        if (this$dbtModelCompileStartedAt == null ? other$dbtModelCompileStartedAt != null : !this$dbtModelCompileStartedAt.equals(other$dbtModelCompileStartedAt)) return false;
        final java.lang.Object this$dbtModelExecuteCompletedAt = this.getDbtModelExecuteCompletedAt();
        final java.lang.Object other$dbtModelExecuteCompletedAt = other.getDbtModelExecuteCompletedAt();
        if (this$dbtModelExecuteCompletedAt == null ? other$dbtModelExecuteCompletedAt != null : !this$dbtModelExecuteCompletedAt.equals(other$dbtModelExecuteCompletedAt)) return false;
        final java.lang.Object this$dbtModelExecuteStartedAt = this.getDbtModelExecuteStartedAt();
        final java.lang.Object other$dbtModelExecuteStartedAt = other.getDbtModelExecuteStartedAt();
        if (this$dbtModelExecuteStartedAt == null ? other$dbtModelExecuteStartedAt != null : !this$dbtModelExecuteStartedAt.equals(other$dbtModelExecuteStartedAt)) return false;
        final java.lang.Object this$dbtModelExecutionTime = this.getDbtModelExecutionTime();
        final java.lang.Object other$dbtModelExecutionTime = other.getDbtModelExecutionTime();
        if (this$dbtModelExecutionTime == null ? other$dbtModelExecutionTime != null : !this$dbtModelExecutionTime.equals(other$dbtModelExecutionTime)) return false;
        final java.lang.Object this$dbtModelRunElapsedTime = this.getDbtModelRunElapsedTime();
        final java.lang.Object other$dbtModelRunElapsedTime = other.getDbtModelRunElapsedTime();
        if (this$dbtModelRunElapsedTime == null ? other$dbtModelRunElapsedTime != null : !this$dbtModelRunElapsedTime.equals(other$dbtModelRunElapsedTime)) return false;
        final java.lang.Object this$dbtModelRunGeneratedAt = this.getDbtModelRunGeneratedAt();
        final java.lang.Object other$dbtModelRunGeneratedAt = other.getDbtModelRunGeneratedAt();
        if (this$dbtModelRunGeneratedAt == null ? other$dbtModelRunGeneratedAt != null : !this$dbtModelRunGeneratedAt.equals(other$dbtModelRunGeneratedAt)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dbtAccountName = this.getDbtAccountName();
        final java.lang.Object other$dbtAccountName = other.getDbtAccountName();
        if (this$dbtAccountName == null ? other$dbtAccountName != null : !this$dbtAccountName.equals(other$dbtAccountName)) return false;
        final java.lang.Object this$dbtAlias = this.getDbtAlias();
        final java.lang.Object other$dbtAlias = other.getDbtAlias();
        if (this$dbtAlias == null ? other$dbtAlias != null : !this$dbtAlias.equals(other$dbtAlias)) return false;
        final java.lang.Object this$dbtCompiledSQL = this.getDbtCompiledSQL();
        final java.lang.Object other$dbtCompiledSQL = other.getDbtCompiledSQL();
        if (this$dbtCompiledSQL == null ? other$dbtCompiledSQL != null : !this$dbtCompiledSQL.equals(other$dbtCompiledSQL)) return false;
        final java.lang.Object this$dbtConnectionContext = this.getDbtConnectionContext();
        final java.lang.Object other$dbtConnectionContext = other.getDbtConnectionContext();
        if (this$dbtConnectionContext == null ? other$dbtConnectionContext != null : !this$dbtConnectionContext.equals(other$dbtConnectionContext)) return false;
        final java.lang.Object this$dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        final java.lang.Object other$dbtEnvironmentDbtVersion = other.getDbtEnvironmentDbtVersion();
        if (this$dbtEnvironmentDbtVersion == null ? other$dbtEnvironmentDbtVersion != null : !this$dbtEnvironmentDbtVersion.equals(other$dbtEnvironmentDbtVersion)) return false;
        final java.lang.Object this$dbtEnvironmentName = this.getDbtEnvironmentName();
        final java.lang.Object other$dbtEnvironmentName = other.getDbtEnvironmentName();
        if (this$dbtEnvironmentName == null ? other$dbtEnvironmentName != null : !this$dbtEnvironmentName.equals(other$dbtEnvironmentName)) return false;
        final java.lang.Object this$dbtError = this.getDbtError();
        final java.lang.Object other$dbtError = other.getDbtError();
        if (this$dbtError == null ? other$dbtError != null : !this$dbtError.equals(other$dbtError)) return false;
        final java.lang.Object this$dbtJobName = this.getDbtJobName();
        final java.lang.Object other$dbtJobName = other.getDbtJobName();
        if (this$dbtJobName == null ? other$dbtJobName != null : !this$dbtJobName.equals(other$dbtJobName)) return false;
        final java.lang.Object this$dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        final java.lang.Object other$dbtJobNextRunHumanized = other.getDbtJobNextRunHumanized();
        if (this$dbtJobNextRunHumanized == null ? other$dbtJobNextRunHumanized != null : !this$dbtJobNextRunHumanized.equals(other$dbtJobNextRunHumanized)) return false;
        final java.lang.Object this$dbtJobRuns = this.getDbtJobRuns();
        final java.lang.Object other$dbtJobRuns = other.getDbtJobRuns();
        if (this$dbtJobRuns == null ? other$dbtJobRuns != null : !this$dbtJobRuns.equals(other$dbtJobRuns)) return false;
        final java.lang.Object this$dbtJobSchedule = this.getDbtJobSchedule();
        final java.lang.Object other$dbtJobSchedule = other.getDbtJobSchedule();
        if (this$dbtJobSchedule == null ? other$dbtJobSchedule != null : !this$dbtJobSchedule.equals(other$dbtJobSchedule)) return false;
        final java.lang.Object this$dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        final java.lang.Object other$dbtJobScheduleCronHumanized = other.getDbtJobScheduleCronHumanized();
        if (this$dbtJobScheduleCronHumanized == null ? other$dbtJobScheduleCronHumanized != null : !this$dbtJobScheduleCronHumanized.equals(other$dbtJobScheduleCronHumanized)) return false;
        final java.lang.Object this$dbtJobStatus = this.getDbtJobStatus();
        final java.lang.Object other$dbtJobStatus = other.getDbtJobStatus();
        if (this$dbtJobStatus == null ? other$dbtJobStatus != null : !this$dbtJobStatus.equals(other$dbtJobStatus)) return false;
        final java.lang.Object this$dbtMaterializationType = this.getDbtMaterializationType();
        final java.lang.Object other$dbtMaterializationType = other.getDbtMaterializationType();
        if (this$dbtMaterializationType == null ? other$dbtMaterializationType != null : !this$dbtMaterializationType.equals(other$dbtMaterializationType)) return false;
        final java.lang.Object this$dbtMeta = this.getDbtMeta();
        final java.lang.Object other$dbtMeta = other.getDbtMeta();
        if (this$dbtMeta == null ? other$dbtMeta != null : !this$dbtMeta.equals(other$dbtMeta)) return false;
        final java.lang.Object this$dbtMetrics = this.getDbtMetrics();
        final java.lang.Object other$dbtMetrics = other.getDbtMetrics();
        if (this$dbtMetrics == null ? other$dbtMetrics != null : !this$dbtMetrics.equals(other$dbtMetrics)) return false;
        final java.lang.Object this$dbtModelColumns = this.getDbtModelColumns();
        final java.lang.Object other$dbtModelColumns = other.getDbtModelColumns();
        if (this$dbtModelColumns == null ? other$dbtModelColumns != null : !this$dbtModelColumns.equals(other$dbtModelColumns)) return false;
        final java.lang.Object this$dbtModelSqlAssets = this.getDbtModelSqlAssets();
        final java.lang.Object other$dbtModelSqlAssets = other.getDbtModelSqlAssets();
        if (this$dbtModelSqlAssets == null ? other$dbtModelSqlAssets != null : !this$dbtModelSqlAssets.equals(other$dbtModelSqlAssets)) return false;
        final java.lang.Object this$dbtPackageName = this.getDbtPackageName();
        final java.lang.Object other$dbtPackageName = other.getDbtPackageName();
        if (this$dbtPackageName == null ? other$dbtPackageName != null : !this$dbtPackageName.equals(other$dbtPackageName)) return false;
        final java.lang.Object this$dbtProjectName = this.getDbtProjectName();
        final java.lang.Object other$dbtProjectName = other.getDbtProjectName();
        if (this$dbtProjectName == null ? other$dbtProjectName != null : !this$dbtProjectName.equals(other$dbtProjectName)) return false;
        final java.lang.Object this$dbtRawSQL = this.getDbtRawSQL();
        final java.lang.Object other$dbtRawSQL = other.getDbtRawSQL();
        if (this$dbtRawSQL == null ? other$dbtRawSQL != null : !this$dbtRawSQL.equals(other$dbtRawSQL)) return false;
        final java.lang.Object this$dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        final java.lang.Object other$dbtSemanticLayerProxyUrl = other.getDbtSemanticLayerProxyUrl();
        if (this$dbtSemanticLayerProxyUrl == null ? other$dbtSemanticLayerProxyUrl != null : !this$dbtSemanticLayerProxyUrl.equals(other$dbtSemanticLayerProxyUrl)) return false;
        final java.lang.Object this$dbtStats = this.getDbtStats();
        final java.lang.Object other$dbtStats = other.getDbtStats();
        if (this$dbtStats == null ? other$dbtStats != null : !this$dbtStats.equals(other$dbtStats)) return false;
        final java.lang.Object this$dbtStatus = this.getDbtStatus();
        final java.lang.Object other$dbtStatus = other.getDbtStatus();
        if (this$dbtStatus == null ? other$dbtStatus != null : !this$dbtStatus.equals(other$dbtStatus)) return false;
        final java.lang.Object this$dbtTags = this.getDbtTags();
        final java.lang.Object other$dbtTags = other.getDbtTags();
        if (this$dbtTags == null ? other$dbtTags != null : !this$dbtTags.equals(other$dbtTags)) return false;
        final java.lang.Object this$dbtTests = this.getDbtTests();
        final java.lang.Object other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) return false;
        final java.lang.Object this$dbtUniqueId = this.getDbtUniqueId();
        final java.lang.Object other$dbtUniqueId = other.getDbtUniqueId();
        if (this$dbtUniqueId == null ? other$dbtUniqueId != null : !this$dbtUniqueId.equals(other$dbtUniqueId)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$primarySqlAsset = this.getPrimarySqlAsset();
        final java.lang.Object other$primarySqlAsset = other.getPrimarySqlAsset();
        if (this$primarySqlAsset == null ? other$primarySqlAsset != null : !this$primarySqlAsset.equals(other$primarySqlAsset)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof DbtModel;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $dbtJobLastRun = this.getDbtJobLastRun();
        result = result * PRIME + ($dbtJobLastRun == null ? 43 : $dbtJobLastRun.hashCode());
        final java.lang.Object $dbtJobNextRun = this.getDbtJobNextRun();
        result = result * PRIME + ($dbtJobNextRun == null ? 43 : $dbtJobNextRun.hashCode());
        final java.lang.Object $dbtModelCompileCompletedAt = this.getDbtModelCompileCompletedAt();
        result = result * PRIME + ($dbtModelCompileCompletedAt == null ? 43 : $dbtModelCompileCompletedAt.hashCode());
        final java.lang.Object $dbtModelCompileStartedAt = this.getDbtModelCompileStartedAt();
        result = result * PRIME + ($dbtModelCompileStartedAt == null ? 43 : $dbtModelCompileStartedAt.hashCode());
        final java.lang.Object $dbtModelExecuteCompletedAt = this.getDbtModelExecuteCompletedAt();
        result = result * PRIME + ($dbtModelExecuteCompletedAt == null ? 43 : $dbtModelExecuteCompletedAt.hashCode());
        final java.lang.Object $dbtModelExecuteStartedAt = this.getDbtModelExecuteStartedAt();
        result = result * PRIME + ($dbtModelExecuteStartedAt == null ? 43 : $dbtModelExecuteStartedAt.hashCode());
        final java.lang.Object $dbtModelExecutionTime = this.getDbtModelExecutionTime();
        result = result * PRIME + ($dbtModelExecutionTime == null ? 43 : $dbtModelExecutionTime.hashCode());
        final java.lang.Object $dbtModelRunElapsedTime = this.getDbtModelRunElapsedTime();
        result = result * PRIME + ($dbtModelRunElapsedTime == null ? 43 : $dbtModelRunElapsedTime.hashCode());
        final java.lang.Object $dbtModelRunGeneratedAt = this.getDbtModelRunGeneratedAt();
        result = result * PRIME + ($dbtModelRunGeneratedAt == null ? 43 : $dbtModelRunGeneratedAt.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dbtAccountName = this.getDbtAccountName();
        result = result * PRIME + ($dbtAccountName == null ? 43 : $dbtAccountName.hashCode());
        final java.lang.Object $dbtAlias = this.getDbtAlias();
        result = result * PRIME + ($dbtAlias == null ? 43 : $dbtAlias.hashCode());
        final java.lang.Object $dbtCompiledSQL = this.getDbtCompiledSQL();
        result = result * PRIME + ($dbtCompiledSQL == null ? 43 : $dbtCompiledSQL.hashCode());
        final java.lang.Object $dbtConnectionContext = this.getDbtConnectionContext();
        result = result * PRIME + ($dbtConnectionContext == null ? 43 : $dbtConnectionContext.hashCode());
        final java.lang.Object $dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        result = result * PRIME + ($dbtEnvironmentDbtVersion == null ? 43 : $dbtEnvironmentDbtVersion.hashCode());
        final java.lang.Object $dbtEnvironmentName = this.getDbtEnvironmentName();
        result = result * PRIME + ($dbtEnvironmentName == null ? 43 : $dbtEnvironmentName.hashCode());
        final java.lang.Object $dbtError = this.getDbtError();
        result = result * PRIME + ($dbtError == null ? 43 : $dbtError.hashCode());
        final java.lang.Object $dbtJobName = this.getDbtJobName();
        result = result * PRIME + ($dbtJobName == null ? 43 : $dbtJobName.hashCode());
        final java.lang.Object $dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        result = result * PRIME + ($dbtJobNextRunHumanized == null ? 43 : $dbtJobNextRunHumanized.hashCode());
        final java.lang.Object $dbtJobRuns = this.getDbtJobRuns();
        result = result * PRIME + ($dbtJobRuns == null ? 43 : $dbtJobRuns.hashCode());
        final java.lang.Object $dbtJobSchedule = this.getDbtJobSchedule();
        result = result * PRIME + ($dbtJobSchedule == null ? 43 : $dbtJobSchedule.hashCode());
        final java.lang.Object $dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        result = result * PRIME + ($dbtJobScheduleCronHumanized == null ? 43 : $dbtJobScheduleCronHumanized.hashCode());
        final java.lang.Object $dbtJobStatus = this.getDbtJobStatus();
        result = result * PRIME + ($dbtJobStatus == null ? 43 : $dbtJobStatus.hashCode());
        final java.lang.Object $dbtMaterializationType = this.getDbtMaterializationType();
        result = result * PRIME + ($dbtMaterializationType == null ? 43 : $dbtMaterializationType.hashCode());
        final java.lang.Object $dbtMeta = this.getDbtMeta();
        result = result * PRIME + ($dbtMeta == null ? 43 : $dbtMeta.hashCode());
        final java.lang.Object $dbtMetrics = this.getDbtMetrics();
        result = result * PRIME + ($dbtMetrics == null ? 43 : $dbtMetrics.hashCode());
        final java.lang.Object $dbtModelColumns = this.getDbtModelColumns();
        result = result * PRIME + ($dbtModelColumns == null ? 43 : $dbtModelColumns.hashCode());
        final java.lang.Object $dbtModelSqlAssets = this.getDbtModelSqlAssets();
        result = result * PRIME + ($dbtModelSqlAssets == null ? 43 : $dbtModelSqlAssets.hashCode());
        final java.lang.Object $dbtPackageName = this.getDbtPackageName();
        result = result * PRIME + ($dbtPackageName == null ? 43 : $dbtPackageName.hashCode());
        final java.lang.Object $dbtProjectName = this.getDbtProjectName();
        result = result * PRIME + ($dbtProjectName == null ? 43 : $dbtProjectName.hashCode());
        final java.lang.Object $dbtRawSQL = this.getDbtRawSQL();
        result = result * PRIME + ($dbtRawSQL == null ? 43 : $dbtRawSQL.hashCode());
        final java.lang.Object $dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        result = result * PRIME + ($dbtSemanticLayerProxyUrl == null ? 43 : $dbtSemanticLayerProxyUrl.hashCode());
        final java.lang.Object $dbtStats = this.getDbtStats();
        result = result * PRIME + ($dbtStats == null ? 43 : $dbtStats.hashCode());
        final java.lang.Object $dbtStatus = this.getDbtStatus();
        result = result * PRIME + ($dbtStatus == null ? 43 : $dbtStatus.hashCode());
        final java.lang.Object $dbtTags = this.getDbtTags();
        result = result * PRIME + ($dbtTags == null ? 43 : $dbtTags.hashCode());
        final java.lang.Object $dbtTests = this.getDbtTests();
        result = result * PRIME + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        final java.lang.Object $dbtUniqueId = this.getDbtUniqueId();
        result = result * PRIME + ($dbtUniqueId == null ? 43 : $dbtUniqueId.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $primarySqlAsset = this.getPrimarySqlAsset();
        result = result * PRIME + ($primarySqlAsset == null ? 43 : $primarySqlAsset.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "DbtModel(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dbtAccountName=" + this.getDbtAccountName() + ", dbtAlias=" + this.getDbtAlias() + ", dbtCompiledSQL=" + this.getDbtCompiledSQL() + ", dbtConnectionContext=" + this.getDbtConnectionContext() + ", dbtEnvironmentDbtVersion=" + this.getDbtEnvironmentDbtVersion() + ", dbtEnvironmentName=" + this.getDbtEnvironmentName() + ", dbtError=" + this.getDbtError() + ", dbtJobLastRun=" + this.getDbtJobLastRun() + ", dbtJobName=" + this.getDbtJobName() + ", dbtJobNextRun=" + this.getDbtJobNextRun() + ", dbtJobNextRunHumanized=" + this.getDbtJobNextRunHumanized() + ", dbtJobRuns=" + this.getDbtJobRuns() + ", dbtJobSchedule=" + this.getDbtJobSchedule() + ", dbtJobScheduleCronHumanized=" + this.getDbtJobScheduleCronHumanized() + ", dbtJobStatus=" + this.getDbtJobStatus() + ", dbtMaterializationType=" + this.getDbtMaterializationType() + ", dbtMeta=" + this.getDbtMeta() + ", dbtMetrics=" + this.getDbtMetrics() + ", dbtModelColumns=" + this.getDbtModelColumns() + ", dbtModelCompileCompletedAt=" + this.getDbtModelCompileCompletedAt() + ", dbtModelCompileStartedAt=" + this.getDbtModelCompileStartedAt() + ", dbtModelExecuteCompletedAt=" + this.getDbtModelExecuteCompletedAt() + ", dbtModelExecuteStartedAt=" + this.getDbtModelExecuteStartedAt() + ", dbtModelExecutionTime=" + this.getDbtModelExecutionTime() + ", dbtModelRunElapsedTime=" + this.getDbtModelRunElapsedTime() + ", dbtModelRunGeneratedAt=" + this.getDbtModelRunGeneratedAt() + ", dbtModelSqlAssets=" + this.getDbtModelSqlAssets() + ", dbtPackageName=" + this.getDbtPackageName() + ", dbtProjectName=" + this.getDbtProjectName() + ", dbtRawSQL=" + this.getDbtRawSQL() + ", dbtSemanticLayerProxyUrl=" + this.getDbtSemanticLayerProxyUrl() + ", dbtStats=" + this.getDbtStats() + ", dbtStatus=" + this.getDbtStatus() + ", dbtTags=" + this.getDbtTags() + ", dbtTests=" + this.getDbtTests() + ", dbtUniqueId=" + this.getDbtUniqueId() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", primarySqlAsset=" + this.getPrimarySqlAsset() + ")";
    }

    /**
     * Fixed typeName for DbtModels.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
