// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.DomoCardType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Domo Card in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class DomoCard extends Asset implements IDomoCard, IDomo, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(DomoCard.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DomoCard";
    /**
     * Fixed typeName for DomoCards.
     */
    String typeName;
    /**
     * Number of dashboards linked to this card.
     */
    @Attribute
    Long domoCardDashboardCount;
    /**
     * Type of the Domo Card.
     */
    @Attribute
    DomoCardType domoCardType;
    /**
     * Type of the Domo Card.
     */
    @Attribute
    String domoCardTypeValue;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDomoDashboard> domoDashboards;
    /**
     * TBC
     */
    @Attribute
    IDomoDataset domoDataset;
    /**
     * Id of the Domo dataset.
     */
    @Attribute
    String domoId;
    /**
     * Id of the owner of the Domo dataset.
     */
    @Attribute
    String domoOwnerId;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a DomoCard, from a potentially
     * more-complete DomoCard object.
     *
     * @return the minimal object necessary to relate to the DomoCard
     * @throws InvalidRequestException if any of the minimal set of required properties for a DomoCard relationship are not found in the initial object
     */
    @Override
    public DomoCard trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all DomoCard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DomoCard assets will be included.
     *
     * @return a fluent search that includes all DomoCard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all DomoCard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) DomoCard assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all DomoCard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all DomoCard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) DomoCards will be included
     * @return a fluent search that includes all DomoCard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all DomoCard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) DomoCards will be included
     * @return a fluent search that includes all DomoCard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a DomoCard by GUID. Use this to create a relationship to this DomoCard,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the DomoCard to reference
     * @return reference to a DomoCard that can be used for defining a relationship to a DomoCard
     */
    public static DomoCard refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DomoCard by GUID. Use this to create a relationship to this DomoCard,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the DomoCard to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DomoCard that can be used for defining a relationship to a DomoCard
     */
    public static DomoCard refByGuid(String guid, Reference.SaveSemantic semantic) {
        return DomoCard._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a DomoCard by qualifiedName. Use this to create a relationship to this DomoCard,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the DomoCard to reference
     * @return reference to a DomoCard that can be used for defining a relationship to a DomoCard
     */
    public static DomoCard refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a DomoCard by qualifiedName. Use this to create a relationship to this DomoCard,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the DomoCard to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a DomoCard that can be used for defining a relationship to a DomoCard
     */
    public static DomoCard refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return DomoCard._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a DomoCard by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the DomoCard to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DomoCard, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DomoCard does not exist or the provided GUID is not a DomoCard
     */
    @JsonIgnore
    public static DomoCard get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a DomoCard by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DomoCard to retrieve, either its GUID or its full qualifiedName
     * @return the requested full DomoCard, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DomoCard does not exist or the provided GUID is not a DomoCard
     */
    @JsonIgnore
    public static DomoCard get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a DomoCard by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the DomoCard to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full DomoCard, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the DomoCard does not exist or the provided GUID is not a DomoCard
     */
    @JsonIgnore
    public static DomoCard get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof DomoCard) {
                return (DomoCard) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof DomoCard) {
                return (DomoCard) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) DomoCard to active.
     *
     * @param qualifiedName for the DomoCard
     * @return true if the DomoCard is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) DomoCard to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the DomoCard
     * @return true if the DomoCard is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a DomoCard.
     *
     * @param qualifiedName of the DomoCard
     * @param name of the DomoCard
     * @return the minimal request necessary to update the DomoCard, as a builder
     */
    public static DomoCardBuilder<?, ?> updater(String qualifiedName, String name) {
        return DomoCard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a DomoCard, from a potentially
     * more-complete DomoCard object.
     *
     * @return the minimal object necessary to update the DomoCard, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for DomoCard are not found in the initial object
     */
    @Override
    public DomoCardBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a DomoCard.
     *
     * @param qualifiedName of the DomoCard
     * @param name of the DomoCard
     * @return the updated DomoCard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a DomoCard.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DomoCard
     * @param name of the DomoCard
     * @return the updated DomoCard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DomoCard) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a DomoCard.
     *
     * @param qualifiedName of the DomoCard
     * @param name of the DomoCard
     * @return the updated DomoCard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a DomoCard.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the DomoCard
     * @param name of the DomoCard
     * @return the updated DomoCard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DomoCard) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a DomoCard.
     *
     * @param qualifiedName of the DomoCard
     * @param name of the DomoCard
     * @return the updated DomoCard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a DomoCard.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DomoCard's owners
     * @param qualifiedName of the DomoCard
     * @param name of the DomoCard
     * @return the updated DomoCard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DomoCard) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a DomoCard.
     *
     * @param qualifiedName of the DomoCard
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DomoCard, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a DomoCard.
     *
     * @param client connectivity to the Atlan tenant on which to update the DomoCard's certificate
     * @param qualifiedName of the DomoCard
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated DomoCard, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DomoCard) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a DomoCard.
     *
     * @param qualifiedName of the DomoCard
     * @param name of the DomoCard
     * @return the updated DomoCard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a DomoCard.
     *
     * @param client connectivity to the Atlan tenant from which to remove the DomoCard's certificate
     * @param qualifiedName of the DomoCard
     * @param name of the DomoCard
     * @return the updated DomoCard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DomoCard) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a DomoCard.
     *
     * @param qualifiedName of the DomoCard
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a DomoCard.
     *
     * @param client connectivity to the Atlan tenant on which to update the DomoCard's announcement
     * @param qualifiedName of the DomoCard
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DomoCard) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a DomoCard.
     *
     * @param qualifiedName of the DomoCard
     * @param name of the DomoCard
     * @return the updated DomoCard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a DomoCard.
     *
     * @param client connectivity to the Atlan client from which to remove the DomoCard's announcement
     * @param qualifiedName of the DomoCard
     * @param name of the DomoCard
     * @return the updated DomoCard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static DomoCard removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DomoCard) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the DomoCard.
     *
     * @param qualifiedName for the DomoCard
     * @param name human-readable name of the DomoCard
     * @param terms the list of terms to replace on the DomoCard, or null to remove all terms from the DomoCard
     * @return the DomoCard that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DomoCard replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the DomoCard.
     *
     * @param client connectivity to the Atlan tenant on which to replace the DomoCard's assigned terms
     * @param qualifiedName for the DomoCard
     * @param name human-readable name of the DomoCard
     * @param terms the list of terms to replace on the DomoCard, or null to remove all terms from the DomoCard
     * @return the DomoCard that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static DomoCard replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DomoCard) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the DomoCard, without replacing existing terms linked to the DomoCard.
     * Note: this operation must make two API calls — one to retrieve the DomoCard's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the DomoCard
     * @param terms the list of terms to append to the DomoCard
     * @return the DomoCard that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DomoCard appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the DomoCard, without replacing existing terms linked to the DomoCard.
     * Note: this operation must make two API calls — one to retrieve the DomoCard's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the DomoCard
     * @param qualifiedName for the DomoCard
     * @param terms the list of terms to append to the DomoCard
     * @return the DomoCard that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static DomoCard appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DomoCard) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a DomoCard, without replacing all existing terms linked to the DomoCard.
     * Note: this operation must make two API calls — one to retrieve the DomoCard's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the DomoCard
     * @param terms the list of terms to remove from the DomoCard, which must be referenced by GUID
     * @return the DomoCard that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DomoCard removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a DomoCard, without replacing all existing terms linked to the DomoCard.
     * Note: this operation must make two API calls — one to retrieve the DomoCard's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the DomoCard
     * @param qualifiedName for the DomoCard
     * @param terms the list of terms to remove from the DomoCard, which must be referenced by GUID
     * @return the DomoCard that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static DomoCard removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DomoCard) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a DomoCard, without replacing existing Atlan tags linked to the DomoCard.
     * Note: this operation must make two API calls — one to retrieve the DomoCard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DomoCard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DomoCard
     */
    public static DomoCard appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DomoCard, without replacing existing Atlan tags linked to the DomoCard.
     * Note: this operation must make two API calls — one to retrieve the DomoCard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DomoCard
     * @param qualifiedName of the DomoCard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated DomoCard
     */
    public static DomoCard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DomoCard) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a DomoCard, without replacing existing Atlan tags linked to the DomoCard.
     * Note: this operation must make two API calls — one to retrieve the DomoCard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the DomoCard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DomoCard
     */
    public static DomoCard appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a DomoCard, without replacing existing Atlan tags linked to the DomoCard.
     * Note: this operation must make two API calls — one to retrieve the DomoCard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the DomoCard
     * @param qualifiedName of the DomoCard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated DomoCard
     */
    public static DomoCard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DomoCard) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a DomoCard.
     *
     * @param qualifiedName of the DomoCard
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DomoCard
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a DomoCard.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a DomoCard
     * @param qualifiedName of the DomoCard
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the DomoCard
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class DomoCardBuilder<C extends DomoCard, B extends DomoCard.DomoCardBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long domoCardDashboardCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DomoCardType domoCardType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String domoCardTypeValue;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDomoDashboard> domoDashboards;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IDomoDataset domoDataset;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String domoId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String domoOwnerId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            DomoCard.DomoCardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final DomoCard instance, final DomoCard.DomoCardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.domoCardDashboardCount(instance.domoCardDashboardCount);
            b.domoCardType(instance.domoCardType);
            b.domoCardTypeValue(instance.domoCardTypeValue);
            b.domoDashboards(instance.domoDashboards == null ? java.util.Collections.<IDomoDashboard>emptySortedSet() : instance.domoDashboards);
            b.domoDataset(instance.domoDataset);
            b.domoId(instance.domoId);
            b.domoOwnerId(instance.domoOwnerId);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for DomoCards.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Number of dashboards linked to this card.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B domoCardDashboardCount(final Long domoCardDashboardCount) {
            this.domoCardDashboardCount = domoCardDashboardCount;
            return self();
        }

        /**
         * Type of the Domo Card.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B domoCardType(final DomoCardType domoCardType) {
            this.domoCardType = domoCardType;
            return self();
        }

        /**
         * Type of the Domo Card.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B domoCardTypeValue(final String domoCardTypeValue) {
            this.domoCardTypeValue = domoCardTypeValue;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B domoDashboard(final IDomoDashboard domoDashboard) {
            if (this.domoDashboards == null) this.domoDashboards = new java.util.ArrayList<IDomoDashboard>();
            this.domoDashboards.add(domoDashboard);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B domoDashboards(final java.util.Collection<? extends IDomoDashboard> domoDashboards) {
            if (domoDashboards == null) {
                throw new java.lang.NullPointerException("domoDashboards cannot be null");
            }
            if (this.domoDashboards == null) this.domoDashboards = new java.util.ArrayList<IDomoDashboard>();
            this.domoDashboards.addAll(domoDashboards);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDomoDashboards() {
            if (this.domoDashboards != null) this.domoDashboards.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B domoDataset(final IDomoDataset domoDataset) {
            this.domoDataset = domoDataset;
            return self();
        }

        /**
         * Id of the Domo dataset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B domoId(final String domoId) {
            this.domoId = domoId;
            return self();
        }

        /**
         * Id of the owner of the Domo dataset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B domoOwnerId(final String domoOwnerId) {
            this.domoOwnerId = domoOwnerId;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "DomoCard.DomoCardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", domoCardDashboardCount=" + this.domoCardDashboardCount + ", domoCardType=" + this.domoCardType + ", domoCardTypeValue=" + this.domoCardTypeValue + ", domoDashboards=" + this.domoDashboards + ", domoDataset=" + this.domoDataset + ", domoId=" + this.domoId + ", domoOwnerId=" + this.domoOwnerId + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class DomoCardBuilderImpl extends DomoCard.DomoCardBuilder<DomoCard, DomoCard.DomoCardBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DomoCardBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DomoCard.DomoCardBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DomoCard build() {
            return new DomoCard(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected DomoCard(final DomoCard.DomoCardBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = DomoCard.$default$typeName();
        this.domoCardDashboardCount = b.domoCardDashboardCount;
        this.domoCardType = b.domoCardType;
        this.domoCardTypeValue = b.domoCardTypeValue;
        java.util.SortedSet<IDomoDashboard> domoDashboards = new java.util.TreeSet<IDomoDashboard>();
        if (b.domoDashboards != null) domoDashboards.addAll(b.domoDashboards);
        domoDashboards = java.util.Collections.unmodifiableSortedSet(domoDashboards);
        this.domoDashboards = domoDashboards;
        this.domoDataset = b.domoDataset;
        this.domoId = b.domoId;
        this.domoOwnerId = b.domoOwnerId;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static DomoCard.DomoCardBuilder<?, ?> _internal() {
        return new DomoCard.DomoCardBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DomoCard.DomoCardBuilder<?, ?> toBuilder() {
        return new DomoCard.DomoCardBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Number of dashboards linked to this card.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDomoCardDashboardCount() {
        return this.domoCardDashboardCount;
    }

    /**
     * Type of the Domo Card.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DomoCardType getDomoCardType() {
        return this.domoCardType;
    }

    /**
     * Type of the Domo Card.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDomoCardTypeValue() {
        return this.domoCardTypeValue;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDomoDashboard> getDomoDashboards() {
        return this.domoDashboards;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IDomoDataset getDomoDataset() {
        return this.domoDataset;
    }

    /**
     * Id of the Domo dataset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDomoId() {
        return this.domoId;
    }

    /**
     * Id of the owner of the Domo dataset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDomoOwnerId() {
        return this.domoOwnerId;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DomoCard)) return false;
        final DomoCard other = (DomoCard) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$domoCardDashboardCount = this.getDomoCardDashboardCount();
        final java.lang.Object other$domoCardDashboardCount = other.getDomoCardDashboardCount();
        if (this$domoCardDashboardCount == null ? other$domoCardDashboardCount != null : !this$domoCardDashboardCount.equals(other$domoCardDashboardCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$domoCardType = this.getDomoCardType();
        final java.lang.Object other$domoCardType = other.getDomoCardType();
        if (this$domoCardType == null ? other$domoCardType != null : !this$domoCardType.equals(other$domoCardType)) return false;
        final java.lang.Object this$domoCardTypeValue = this.getDomoCardTypeValue();
        final java.lang.Object other$domoCardTypeValue = other.getDomoCardTypeValue();
        if (this$domoCardTypeValue == null ? other$domoCardTypeValue != null : !this$domoCardTypeValue.equals(other$domoCardTypeValue)) return false;
        final java.lang.Object this$domoDashboards = this.getDomoDashboards();
        final java.lang.Object other$domoDashboards = other.getDomoDashboards();
        if (this$domoDashboards == null ? other$domoDashboards != null : !this$domoDashboards.equals(other$domoDashboards)) return false;
        final java.lang.Object this$domoDataset = this.getDomoDataset();
        final java.lang.Object other$domoDataset = other.getDomoDataset();
        if (this$domoDataset == null ? other$domoDataset != null : !this$domoDataset.equals(other$domoDataset)) return false;
        final java.lang.Object this$domoId = this.getDomoId();
        final java.lang.Object other$domoId = other.getDomoId();
        if (this$domoId == null ? other$domoId != null : !this$domoId.equals(other$domoId)) return false;
        final java.lang.Object this$domoOwnerId = this.getDomoOwnerId();
        final java.lang.Object other$domoOwnerId = other.getDomoOwnerId();
        if (this$domoOwnerId == null ? other$domoOwnerId != null : !this$domoOwnerId.equals(other$domoOwnerId)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof DomoCard;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $domoCardDashboardCount = this.getDomoCardDashboardCount();
        result = result * PRIME + ($domoCardDashboardCount == null ? 43 : $domoCardDashboardCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $domoCardType = this.getDomoCardType();
        result = result * PRIME + ($domoCardType == null ? 43 : $domoCardType.hashCode());
        final java.lang.Object $domoCardTypeValue = this.getDomoCardTypeValue();
        result = result * PRIME + ($domoCardTypeValue == null ? 43 : $domoCardTypeValue.hashCode());
        final java.lang.Object $domoDashboards = this.getDomoDashboards();
        result = result * PRIME + ($domoDashboards == null ? 43 : $domoDashboards.hashCode());
        final java.lang.Object $domoDataset = this.getDomoDataset();
        result = result * PRIME + ($domoDataset == null ? 43 : $domoDataset.hashCode());
        final java.lang.Object $domoId = this.getDomoId();
        result = result * PRIME + ($domoId == null ? 43 : $domoId.hashCode());
        final java.lang.Object $domoOwnerId = this.getDomoOwnerId();
        result = result * PRIME + ($domoOwnerId == null ? 43 : $domoOwnerId.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "DomoCard(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", domoCardDashboardCount=" + this.getDomoCardDashboardCount() + ", domoCardType=" + this.getDomoCardType() + ", domoCardTypeValue=" + this.getDomoCardTypeValue() + ", domoDashboards=" + this.getDomoDashboards() + ", domoDataset=" + this.getDomoDataset() + ", domoId=" + this.getDomoId() + ", domoOwnerId=" + this.getDomoOwnerId() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for DomoCards.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
