// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a folder within a query collection in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class Folder extends Asset implements IFolder, INamespace, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(Folder.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Folder";
    /**
     * Fixed typeName for Folders.
     */
    String typeName;
    /**
     * Folders that exist within this namespace.
     */
    @Attribute
    SortedSet<IFolder> childrenFolders;
    /**
     * Queries that exist within this namespace.
     */
    @Attribute
    SortedSet<IAtlanQuery> childrenQueries;
    /**
     * Unique name of the collection in which this folder exists.
     */
    @Attribute
    String collectionQualifiedName;
    /**
     * Namespace in which this folder exists.
     */
    @Attribute
    INamespace parent;
    /**
     * Unique name of the parent folder or collection in which this folder exists.
     */
    @Attribute
    String parentQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a Folder, from a potentially
     * more-complete Folder object.
     *
     * @return the minimal object necessary to relate to the Folder
     * @throws InvalidRequestException if any of the minimal set of required properties for a Folder relationship are not found in the initial object
     */
    @Override
    public Folder trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all Folder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Folder assets will be included.
     *
     * @return a fluent search that includes all Folder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all Folder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Folder assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all Folder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all Folder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) Folders will be included
     * @return a fluent search that includes all Folder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all Folder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) Folders will be included
     * @return a fluent search that includes all Folder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a Folder by GUID. Use this to create a relationship to this Folder,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the Folder to reference
     * @return reference to a Folder that can be used for defining a relationship to a Folder
     */
    public static Folder refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Folder by GUID. Use this to create a relationship to this Folder,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the Folder to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Folder that can be used for defining a relationship to a Folder
     */
    public static Folder refByGuid(String guid, Reference.SaveSemantic semantic) {
        return Folder._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a Folder by qualifiedName. Use this to create a relationship to this Folder,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the Folder to reference
     * @return reference to a Folder that can be used for defining a relationship to a Folder
     */
    public static Folder refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Folder by qualifiedName. Use this to create a relationship to this Folder,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the Folder to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Folder that can be used for defining a relationship to a Folder
     */
    public static Folder refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return Folder._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a Folder by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the Folder to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Folder, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Folder does not exist or the provided GUID is not a Folder
     */
    @JsonIgnore
    public static Folder get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a Folder by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Folder to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Folder, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Folder does not exist or the provided GUID is not a Folder
     */
    @JsonIgnore
    public static Folder get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a Folder by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Folder to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full Folder, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Folder does not exist or the provided GUID is not a Folder
     */
    @JsonIgnore
    public static Folder get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof Folder) {
                return (Folder) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof Folder) {
                return (Folder) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) Folder to active.
     *
     * @param qualifiedName for the Folder
     * @return true if the Folder is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) Folder to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the Folder
     * @return true if the Folder is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a Folder.
     *
     * @param name of the Folder
     * @param parentFolder in which the Folder should be created, which must have at least
     *               a qualifiedName
     * @return the minimal request necessary to create the Folder, as a builder
     * @throws InvalidRequestException if the parentFolder provided is without a qualifiedName
     */
    public static FolderBuilder<?, ?> creator(String name, Folder parentFolder) throws InvalidRequestException {
        validateRelationship(AtlanCollection.TYPE_NAME, Map.of("qualifiedName", parentFolder.getQualifiedName(), "collectionQualifiedName", parentFolder.getCollectionQualifiedName()));
        return creator(name, parentFolder.getCollectionQualifiedName(), parentFolder.getQualifiedName()).parent(parentFolder.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a Folder.
     *
     * @param name of the Folder
     * @param collection in which the Folder should be created, which must have at least
     *               a qualifiedName
     * @return the minimal request necessary to create the Folder, as a builder
     * @throws InvalidRequestException if the collection provided is without a qualifiedName
     */
    public static FolderBuilder<?, ?> creator(String name, AtlanCollection collection) throws InvalidRequestException {
        validateRelationship(AtlanCollection.TYPE_NAME, Map.of("qualifiedName", collection.getQualifiedName()));
        return creator(name, collection.getQualifiedName(), null).parent(collection.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a Folder.
     *
     * @param name of the Folder
     * @param collectionQualifiedName unique name of the AtlanCollection in which the Folder should be created
     * @param parentQualifiedName unique name of the Folder in which this Folder should be created (or null if it should be created directly in the collection)
     * @return the minimal request necessary to create the Folder, as a builder
     */
    public static FolderBuilder<?, ?> creator(String name, String collectionQualifiedName, String parentQualifiedName) {
        String qualifiedName = parentQualifiedName == null ? generateQualifiedName(name, collectionQualifiedName) : generateQualifiedName(name, parentQualifiedName);
        FolderBuilder<?, ?> builder = Folder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).name(name).qualifiedName(qualifiedName).collectionQualifiedName(collectionQualifiedName).parentQualifiedName(collectionQualifiedName).parent(AtlanCollection.refByQualifiedName(collectionQualifiedName));
        if (parentQualifiedName != null) {
            builder.parentQualifiedName(parentQualifiedName).parent(Folder.refByQualifiedName(parentQualifiedName));
        }
        return builder;
    }

    /**
     * Generate a unique Folder.
     *
     * @param name of the Folder
     * @param parentQualifiedName unique name of the collection or parent folder in which this Folder exists
     * @return a unique name for the Folder
     */
    public static String generateQualifiedName(String name, String parentQualifiedName) {
        return parentQualifiedName + "/" + name;
    }

    /**
     * Builds the minimal object necessary to update a Folder.
     *
     * @param qualifiedName of the Folder
     * @param name of the Folder
     * @return the minimal request necessary to update the Folder, as a builder
     */
    public static FolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return Folder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a Folder, from a potentially
     * more-complete Folder object.
     *
     * @return the minimal object necessary to update the Folder, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for Folder are not found in the initial object
     */
    @Override
    public FolderBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a Folder.
     *
     * @param qualifiedName of the Folder
     * @param name of the Folder
     * @return the updated Folder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Folder removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a Folder.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Folder
     * @param name of the Folder
     * @return the updated Folder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Folder removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Folder) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a Folder.
     *
     * @param qualifiedName of the Folder
     * @param name of the Folder
     * @return the updated Folder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Folder removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a Folder.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Folder
     * @param name of the Folder
     * @return the updated Folder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Folder removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Folder) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a Folder.
     *
     * @param qualifiedName of the Folder
     * @param name of the Folder
     * @return the updated Folder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Folder removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a Folder.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Folder's owners
     * @param qualifiedName of the Folder
     * @param name of the Folder
     * @return the updated Folder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Folder removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Folder) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a Folder.
     *
     * @param qualifiedName of the Folder
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Folder, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Folder updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a Folder.
     *
     * @param client connectivity to the Atlan tenant on which to update the Folder's certificate
     * @param qualifiedName of the Folder
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Folder, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Folder updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Folder) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a Folder.
     *
     * @param qualifiedName of the Folder
     * @param name of the Folder
     * @return the updated Folder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Folder removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a Folder.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Folder's certificate
     * @param qualifiedName of the Folder
     * @param name of the Folder
     * @return the updated Folder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Folder removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Folder) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a Folder.
     *
     * @param qualifiedName of the Folder
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Folder updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a Folder.
     *
     * @param client connectivity to the Atlan tenant on which to update the Folder's announcement
     * @param qualifiedName of the Folder
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Folder updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Folder) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a Folder.
     *
     * @param qualifiedName of the Folder
     * @param name of the Folder
     * @return the updated Folder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Folder removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a Folder.
     *
     * @param client connectivity to the Atlan client from which to remove the Folder's announcement
     * @param qualifiedName of the Folder
     * @param name of the Folder
     * @return the updated Folder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Folder removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Folder) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the Folder.
     *
     * @param qualifiedName for the Folder
     * @param name human-readable name of the Folder
     * @param terms the list of terms to replace on the Folder, or null to remove all terms from the Folder
     * @return the Folder that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Folder replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the Folder.
     *
     * @param client connectivity to the Atlan tenant on which to replace the Folder's assigned terms
     * @param qualifiedName for the Folder
     * @param name human-readable name of the Folder
     * @param terms the list of terms to replace on the Folder, or null to remove all terms from the Folder
     * @return the Folder that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Folder replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Folder) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the Folder, without replacing existing terms linked to the Folder.
     * Note: this operation must make two API calls — one to retrieve the Folder's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the Folder
     * @param terms the list of terms to append to the Folder
     * @return the Folder that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Folder appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the Folder, without replacing existing terms linked to the Folder.
     * Note: this operation must make two API calls — one to retrieve the Folder's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the Folder
     * @param qualifiedName for the Folder
     * @param terms the list of terms to append to the Folder
     * @return the Folder that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Folder appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Folder) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a Folder, without replacing all existing terms linked to the Folder.
     * Note: this operation must make two API calls — one to retrieve the Folder's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the Folder
     * @param terms the list of terms to remove from the Folder, which must be referenced by GUID
     * @return the Folder that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Folder removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a Folder, without replacing all existing terms linked to the Folder.
     * Note: this operation must make two API calls — one to retrieve the Folder's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the Folder
     * @param qualifiedName for the Folder
     * @param terms the list of terms to remove from the Folder, which must be referenced by GUID
     * @return the Folder that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Folder removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Folder) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a Folder, without replacing existing Atlan tags linked to the Folder.
     * Note: this operation must make two API calls — one to retrieve the Folder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Folder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Folder
     */
    public static Folder appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Folder, without replacing existing Atlan tags linked to the Folder.
     * Note: this operation must make two API calls — one to retrieve the Folder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Folder
     * @param qualifiedName of the Folder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Folder
     */
    public static Folder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Folder) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Folder, without replacing existing Atlan tags linked to the Folder.
     * Note: this operation must make two API calls — one to retrieve the Folder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Folder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Folder
     */
    public static Folder appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a Folder, without replacing existing Atlan tags linked to the Folder.
     * Note: this operation must make two API calls — one to retrieve the Folder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Folder
     * @param qualifiedName of the Folder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Folder
     */
    public static Folder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Folder) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a Folder.
     *
     * @param qualifiedName of the Folder
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Folder
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a Folder.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a Folder
     * @param qualifiedName of the Folder
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Folder
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class FolderBuilder<C extends Folder, B extends Folder.FolderBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IFolder> childrenFolders;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAtlanQuery> childrenQueries;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String collectionQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private INamespace parent;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String parentQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Folder.FolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Folder instance, final Folder.FolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.childrenFolders(instance.childrenFolders == null ? java.util.Collections.<IFolder>emptySortedSet() : instance.childrenFolders);
            b.childrenQueries(instance.childrenQueries == null ? java.util.Collections.<IAtlanQuery>emptySortedSet() : instance.childrenQueries);
            b.collectionQualifiedName(instance.collectionQualifiedName);
            b.parent(instance.parent);
            b.parentQualifiedName(instance.parentQualifiedName);
        }

        /**
         * Fixed typeName for Folders.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B childrenFolder(final IFolder childrenFolder) {
            if (this.childrenFolders == null) this.childrenFolders = new java.util.ArrayList<IFolder>();
            this.childrenFolders.add(childrenFolder);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B childrenFolders(final java.util.Collection<? extends IFolder> childrenFolders) {
            if (childrenFolders == null) {
                throw new java.lang.NullPointerException("childrenFolders cannot be null");
            }
            if (this.childrenFolders == null) this.childrenFolders = new java.util.ArrayList<IFolder>();
            this.childrenFolders.addAll(childrenFolders);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearChildrenFolders() {
            if (this.childrenFolders != null) this.childrenFolders.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B childrenQuery(final IAtlanQuery childrenQuery) {
            if (this.childrenQueries == null) this.childrenQueries = new java.util.ArrayList<IAtlanQuery>();
            this.childrenQueries.add(childrenQuery);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B childrenQueries(final java.util.Collection<? extends IAtlanQuery> childrenQueries) {
            if (childrenQueries == null) {
                throw new java.lang.NullPointerException("childrenQueries cannot be null");
            }
            if (this.childrenQueries == null) this.childrenQueries = new java.util.ArrayList<IAtlanQuery>();
            this.childrenQueries.addAll(childrenQueries);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearChildrenQueries() {
            if (this.childrenQueries != null) this.childrenQueries.clear();
            return self();
        }

        /**
         * Unique name of the collection in which this folder exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B collectionQualifiedName(final String collectionQualifiedName) {
            this.collectionQualifiedName = collectionQualifiedName;
            return self();
        }

        /**
         * Namespace in which this folder exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B parent(final INamespace parent) {
            this.parent = parent;
            return self();
        }

        /**
         * Unique name of the parent folder or collection in which this folder exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B parentQualifiedName(final String parentQualifiedName) {
            this.parentQualifiedName = parentQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Folder.FolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", childrenFolders=" + this.childrenFolders + ", childrenQueries=" + this.childrenQueries + ", collectionQualifiedName=" + this.collectionQualifiedName + ", parent=" + this.parent + ", parentQualifiedName=" + this.parentQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class FolderBuilderImpl extends Folder.FolderBuilder<Folder, Folder.FolderBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private FolderBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Folder.FolderBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Folder build() {
            return new Folder(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Folder(final Folder.FolderBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = Folder.$default$typeName();
        java.util.SortedSet<IFolder> childrenFolders = new java.util.TreeSet<IFolder>();
        if (b.childrenFolders != null) childrenFolders.addAll(b.childrenFolders);
        childrenFolders = java.util.Collections.unmodifiableSortedSet(childrenFolders);
        this.childrenFolders = childrenFolders;
        java.util.SortedSet<IAtlanQuery> childrenQueries = new java.util.TreeSet<IAtlanQuery>();
        if (b.childrenQueries != null) childrenQueries.addAll(b.childrenQueries);
        childrenQueries = java.util.Collections.unmodifiableSortedSet(childrenQueries);
        this.childrenQueries = childrenQueries;
        this.collectionQualifiedName = b.collectionQualifiedName;
        this.parent = b.parent;
        this.parentQualifiedName = b.parentQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Folder.FolderBuilder<?, ?> _internal() {
        return new Folder.FolderBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Folder.FolderBuilder<?, ?> toBuilder() {
        return new Folder.FolderBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Folders that exist within this namespace.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IFolder> getChildrenFolders() {
        return this.childrenFolders;
    }

    /**
     * Queries that exist within this namespace.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAtlanQuery> getChildrenQueries() {
        return this.childrenQueries;
    }

    /**
     * Unique name of the collection in which this folder exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCollectionQualifiedName() {
        return this.collectionQualifiedName;
    }

    /**
     * Namespace in which this folder exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public INamespace getParent() {
        return this.parent;
    }

    /**
     * Unique name of the parent folder or collection in which this folder exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getParentQualifiedName() {
        return this.parentQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Folder)) return false;
        final Folder other = (Folder) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$childrenFolders = this.getChildrenFolders();
        final java.lang.Object other$childrenFolders = other.getChildrenFolders();
        if (this$childrenFolders == null ? other$childrenFolders != null : !this$childrenFolders.equals(other$childrenFolders)) return false;
        final java.lang.Object this$childrenQueries = this.getChildrenQueries();
        final java.lang.Object other$childrenQueries = other.getChildrenQueries();
        if (this$childrenQueries == null ? other$childrenQueries != null : !this$childrenQueries.equals(other$childrenQueries)) return false;
        final java.lang.Object this$collectionQualifiedName = this.getCollectionQualifiedName();
        final java.lang.Object other$collectionQualifiedName = other.getCollectionQualifiedName();
        if (this$collectionQualifiedName == null ? other$collectionQualifiedName != null : !this$collectionQualifiedName.equals(other$collectionQualifiedName)) return false;
        final java.lang.Object this$parent = this.getParent();
        final java.lang.Object other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) return false;
        final java.lang.Object this$parentQualifiedName = this.getParentQualifiedName();
        final java.lang.Object other$parentQualifiedName = other.getParentQualifiedName();
        if (this$parentQualifiedName == null ? other$parentQualifiedName != null : !this$parentQualifiedName.equals(other$parentQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Folder;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $childrenFolders = this.getChildrenFolders();
        result = result * PRIME + ($childrenFolders == null ? 43 : $childrenFolders.hashCode());
        final java.lang.Object $childrenQueries = this.getChildrenQueries();
        result = result * PRIME + ($childrenQueries == null ? 43 : $childrenQueries.hashCode());
        final java.lang.Object $collectionQualifiedName = this.getCollectionQualifiedName();
        result = result * PRIME + ($collectionQualifiedName == null ? 43 : $collectionQualifiedName.hashCode());
        final java.lang.Object $parent = this.getParent();
        result = result * PRIME + ($parent == null ? 43 : $parent.hashCode());
        final java.lang.Object $parentQualifiedName = this.getParentQualifiedName();
        result = result * PRIME + ($parentQualifiedName == null ? 43 : $parentQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Folder(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", childrenFolders=" + this.getChildrenFolders() + ", childrenQueries=" + this.getChildrenQueries() + ", collectionQualifiedName=" + this.getCollectionQualifiedName() + ", parent=" + this.getParent() + ", parentQualifiedName=" + this.getParentQualifiedName() + ")";
    }

    /**
     * Fixed typeName for Folders.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
