// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.GoogleLabel;
import com.atlan.model.structs.GoogleTag;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Google Cloud Storage bucket in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class GCSBucket extends Asset implements IGCSBucket, IGCS, IGoogle, IObjectStore, ICloud, IAsset, IReferenceable, ICatalog {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(GCSBucket.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "GCSBucket";
    /**
     * Fixed typeName for GCSBuckets.
     */
    String typeName;
    /**
     * Access control list for this asset.
     */
    @Attribute
    String gcsAccessControl;
    /**
     * Lifecycle rules for this bucket.
     */
    @Attribute
    String gcsBucketLifecycleRules;
    /**
     * Effective time for retention of objects in this bucket.
     */
    @Attribute
    @Date
    Long gcsBucketRetentionEffectiveTime;
    /**
     * Whether retention is locked for this bucket (true) or not (false).
     */
    @Attribute
    Boolean gcsBucketRetentionLocked;
    /**
     * Retention period for objects in this bucket.
     */
    @Attribute
    Long gcsBucketRetentionPeriod;
    /**
     * Retention policy for this bucket.
     */
    @Attribute
    String gcsBucketRetentionPolicy;
    /**
     * Whether versioning is enabled on the bucket (true) or not (false).
     */
    @Attribute
    Boolean gcsBucketVersioningEnabled;
    /**
     * Entity tag for the asset. An entity tag is a hash of the object and represents changes to the contents of an object only, not its metadata.
     */
    @Attribute
    String gcsETag;
    /**
     * Encryption algorithm used to encrypt this asset.
     */
    @Attribute
    String gcsEncryptionType;
    /**
     * Version of metadata for this asset at this generation. Used for preconditions and detecting changes in metadata. A metageneration number is only meaningful in the context of a particular generation of a particular asset.
     */
    @Attribute
    Long gcsMetaGenerationId;
    /**
     * Number of objects within the bucket.
     */
    @Attribute
    Long gcsObjectCount;
    /**
     * GCS objects within this bucket.
     */
    @Attribute
    SortedSet<IGCSObject> gcsObjects;
    /**
     * Whether the requester pays header was sent when this asset was created (true) or not (false).
     */
    @Attribute
    Boolean gcsRequesterPays;
    /**
     * Storage class of this asset.
     */
    @Attribute
    String gcsStorageClass;
    /**
     * List of labels that have been applied to the asset in Google.
     */
    @Attribute
    List<GoogleLabel> googleLabels;
    /**
     * Location of this asset in Google.
     */
    @Attribute
    String googleLocation;
    /**
     * Type of location of this asset in Google.
     */
    @Attribute
    String googleLocationType;
    /**
     * ID of the project in which the asset exists.
     */
    @Attribute
    String googleProjectId;
    /**
     * Name of the project in which the asset exists.
     */
    @Attribute
    String googleProjectName;
    /**
     * Number of the project in which the asset exists.
     */
    @Attribute
    Long googleProjectNumber;
    /**
     * Service in Google in which the asset exists.
     */
    @Attribute
    String googleService;
    /**
     * List of tags that have been applied to the asset in Google.
     */
    @Attribute
    List<GoogleTag> googleTags;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a GCSBucket, from a potentially
     * more-complete GCSBucket object.
     *
     * @return the minimal object necessary to relate to the GCSBucket
     * @throws InvalidRequestException if any of the minimal set of required properties for a GCSBucket relationship are not found in the initial object
     */
    @Override
    public GCSBucket trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all GCSBucket assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) GCSBucket assets will be included.
     *
     * @return a fluent search that includes all GCSBucket assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all GCSBucket assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) GCSBucket assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all GCSBucket assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all GCSBucket assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) GCSBuckets will be included
     * @return a fluent search that includes all GCSBucket assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all GCSBucket assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) GCSBuckets will be included
     * @return a fluent search that includes all GCSBucket assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a GCSBucket by GUID. Use this to create a relationship to this GCSBucket,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the GCSBucket to reference
     * @return reference to a GCSBucket that can be used for defining a relationship to a GCSBucket
     */
    public static GCSBucket refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a GCSBucket by GUID. Use this to create a relationship to this GCSBucket,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the GCSBucket to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a GCSBucket that can be used for defining a relationship to a GCSBucket
     */
    public static GCSBucket refByGuid(String guid, Reference.SaveSemantic semantic) {
        return GCSBucket._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a GCSBucket by qualifiedName. Use this to create a relationship to this GCSBucket,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the GCSBucket to reference
     * @return reference to a GCSBucket that can be used for defining a relationship to a GCSBucket
     */
    public static GCSBucket refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a GCSBucket by qualifiedName. Use this to create a relationship to this GCSBucket,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the GCSBucket to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a GCSBucket that can be used for defining a relationship to a GCSBucket
     */
    public static GCSBucket refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return GCSBucket._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a GCSBucket by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the GCSBucket to retrieve, either its GUID or its full qualifiedName
     * @return the requested full GCSBucket, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the GCSBucket does not exist or the provided GUID is not a GCSBucket
     */
    @JsonIgnore
    public static GCSBucket get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a GCSBucket by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the GCSBucket to retrieve, either its GUID or its full qualifiedName
     * @return the requested full GCSBucket, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the GCSBucket does not exist or the provided GUID is not a GCSBucket
     */
    @JsonIgnore
    public static GCSBucket get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a GCSBucket by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the GCSBucket to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full GCSBucket, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the GCSBucket does not exist or the provided GUID is not a GCSBucket
     */
    @JsonIgnore
    public static GCSBucket get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof GCSBucket) {
                return (GCSBucket) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof GCSBucket) {
                return (GCSBucket) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) GCSBucket to active.
     *
     * @param qualifiedName for the GCSBucket
     * @return true if the GCSBucket is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) GCSBucket to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the GCSBucket
     * @return true if the GCSBucket is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a GCSBucket.
     *
     * @param name of the GCSBucket
     * @param connectionQualifiedName unique name of the connection through which the GCSBucket is accessible
     * @return the minimal object necessary to create the GCSBucket, as a builder
     */
    public static GCSBucketBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return GCSBucket._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(generateQualifiedName(name, connectionQualifiedName)).name(name).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.GCS);
    }

    /**
     * Generate a unique GCSBucket name.
     *
     * @param name of the GCSBucket
     * @param connectionQualifiedName unique name of the connection through which the GCSBucket is accessible
     * @return a unique name for the GCSBucket
     */
    public static String generateQualifiedName(String name, String connectionQualifiedName) {
        return connectionQualifiedName + "/" + name;
    }

    /**
     * Builds the minimal object necessary to update a GCSBucket.
     *
     * @param qualifiedName of the GCSBucket
     * @param name of the GCSBucket
     * @return the minimal request necessary to update the GCSBucket, as a builder
     */
    public static GCSBucketBuilder<?, ?> updater(String qualifiedName, String name) {
        return GCSBucket._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a GCSBucket, from a potentially
     * more-complete GCSBucket object.
     *
     * @return the minimal object necessary to update the GCSBucket, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for GCSBucket are not found in the initial object
     */
    @Override
    public GCSBucketBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a GCSBucket.
     *
     * @param qualifiedName of the GCSBucket
     * @param name of the GCSBucket
     * @return the updated GCSBucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a GCSBucket.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the GCSBucket
     * @param name of the GCSBucket
     * @return the updated GCSBucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSBucket) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a GCSBucket.
     *
     * @param qualifiedName of the GCSBucket
     * @param name of the GCSBucket
     * @return the updated GCSBucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a GCSBucket.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the GCSBucket
     * @param name of the GCSBucket
     * @return the updated GCSBucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSBucket) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a GCSBucket.
     *
     * @param qualifiedName of the GCSBucket
     * @param name of the GCSBucket
     * @return the updated GCSBucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a GCSBucket.
     *
     * @param client connectivity to the Atlan tenant from which to remove the GCSBucket's owners
     * @param qualifiedName of the GCSBucket
     * @param name of the GCSBucket
     * @return the updated GCSBucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSBucket) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a GCSBucket.
     *
     * @param qualifiedName of the GCSBucket
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated GCSBucket, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a GCSBucket.
     *
     * @param client connectivity to the Atlan tenant on which to update the GCSBucket's certificate
     * @param qualifiedName of the GCSBucket
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated GCSBucket, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (GCSBucket) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a GCSBucket.
     *
     * @param qualifiedName of the GCSBucket
     * @param name of the GCSBucket
     * @return the updated GCSBucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a GCSBucket.
     *
     * @param client connectivity to the Atlan tenant from which to remove the GCSBucket's certificate
     * @param qualifiedName of the GCSBucket
     * @param name of the GCSBucket
     * @return the updated GCSBucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSBucket) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a GCSBucket.
     *
     * @param qualifiedName of the GCSBucket
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a GCSBucket.
     *
     * @param client connectivity to the Atlan tenant on which to update the GCSBucket's announcement
     * @param qualifiedName of the GCSBucket
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (GCSBucket) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a GCSBucket.
     *
     * @param qualifiedName of the GCSBucket
     * @param name of the GCSBucket
     * @return the updated GCSBucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a GCSBucket.
     *
     * @param client connectivity to the Atlan client from which to remove the GCSBucket's announcement
     * @param qualifiedName of the GCSBucket
     * @param name of the GCSBucket
     * @return the updated GCSBucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GCSBucket removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (GCSBucket) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the GCSBucket.
     *
     * @param qualifiedName for the GCSBucket
     * @param name human-readable name of the GCSBucket
     * @param terms the list of terms to replace on the GCSBucket, or null to remove all terms from the GCSBucket
     * @return the GCSBucket that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static GCSBucket replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the GCSBucket.
     *
     * @param client connectivity to the Atlan tenant on which to replace the GCSBucket's assigned terms
     * @param qualifiedName for the GCSBucket
     * @param name human-readable name of the GCSBucket
     * @param terms the list of terms to replace on the GCSBucket, or null to remove all terms from the GCSBucket
     * @return the GCSBucket that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static GCSBucket replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (GCSBucket) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the GCSBucket, without replacing existing terms linked to the GCSBucket.
     * Note: this operation must make two API calls — one to retrieve the GCSBucket's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the GCSBucket
     * @param terms the list of terms to append to the GCSBucket
     * @return the GCSBucket that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static GCSBucket appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the GCSBucket, without replacing existing terms linked to the GCSBucket.
     * Note: this operation must make two API calls — one to retrieve the GCSBucket's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the GCSBucket
     * @param qualifiedName for the GCSBucket
     * @param terms the list of terms to append to the GCSBucket
     * @return the GCSBucket that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static GCSBucket appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (GCSBucket) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a GCSBucket, without replacing all existing terms linked to the GCSBucket.
     * Note: this operation must make two API calls — one to retrieve the GCSBucket's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the GCSBucket
     * @param terms the list of terms to remove from the GCSBucket, which must be referenced by GUID
     * @return the GCSBucket that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static GCSBucket removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a GCSBucket, without replacing all existing terms linked to the GCSBucket.
     * Note: this operation must make two API calls — one to retrieve the GCSBucket's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the GCSBucket
     * @param qualifiedName for the GCSBucket
     * @param terms the list of terms to remove from the GCSBucket, which must be referenced by GUID
     * @return the GCSBucket that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static GCSBucket removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (GCSBucket) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a GCSBucket, without replacing existing Atlan tags linked to the GCSBucket.
     * Note: this operation must make two API calls — one to retrieve the GCSBucket's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the GCSBucket
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated GCSBucket
     */
    public static GCSBucket appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a GCSBucket, without replacing existing Atlan tags linked to the GCSBucket.
     * Note: this operation must make two API calls — one to retrieve the GCSBucket's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the GCSBucket
     * @param qualifiedName of the GCSBucket
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated GCSBucket
     */
    public static GCSBucket appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (GCSBucket) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a GCSBucket, without replacing existing Atlan tags linked to the GCSBucket.
     * Note: this operation must make two API calls — one to retrieve the GCSBucket's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the GCSBucket
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated GCSBucket
     */
    public static GCSBucket appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a GCSBucket, without replacing existing Atlan tags linked to the GCSBucket.
     * Note: this operation must make two API calls — one to retrieve the GCSBucket's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the GCSBucket
     * @param qualifiedName of the GCSBucket
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated GCSBucket
     */
    public static GCSBucket appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (GCSBucket) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a GCSBucket.
     *
     * @param qualifiedName of the GCSBucket
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the GCSBucket
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a GCSBucket.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a GCSBucket
     * @param qualifiedName of the GCSBucket
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the GCSBucket
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class GCSBucketBuilder<C extends GCSBucket, B extends GCSBucket.GCSBucketBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String gcsAccessControl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String gcsBucketLifecycleRules;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long gcsBucketRetentionEffectiveTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean gcsBucketRetentionLocked;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long gcsBucketRetentionPeriod;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String gcsBucketRetentionPolicy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean gcsBucketVersioningEnabled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String gcsETag;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String gcsEncryptionType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long gcsMetaGenerationId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long gcsObjectCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGCSObject> gcsObjects;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean gcsRequesterPays;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String gcsStorageClass;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<GoogleLabel> googleLabels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String googleLocation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String googleLocationType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String googleProjectId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String googleProjectName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long googleProjectNumber;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String googleService;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<GoogleTag> googleTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            GCSBucket.GCSBucketBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final GCSBucket instance, final GCSBucket.GCSBucketBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.gcsAccessControl(instance.gcsAccessControl);
            b.gcsBucketLifecycleRules(instance.gcsBucketLifecycleRules);
            b.gcsBucketRetentionEffectiveTime(instance.gcsBucketRetentionEffectiveTime);
            b.gcsBucketRetentionLocked(instance.gcsBucketRetentionLocked);
            b.gcsBucketRetentionPeriod(instance.gcsBucketRetentionPeriod);
            b.gcsBucketRetentionPolicy(instance.gcsBucketRetentionPolicy);
            b.gcsBucketVersioningEnabled(instance.gcsBucketVersioningEnabled);
            b.gcsETag(instance.gcsETag);
            b.gcsEncryptionType(instance.gcsEncryptionType);
            b.gcsMetaGenerationId(instance.gcsMetaGenerationId);
            b.gcsObjectCount(instance.gcsObjectCount);
            b.gcsObjects(instance.gcsObjects == null ? java.util.Collections.<IGCSObject>emptySortedSet() : instance.gcsObjects);
            b.gcsRequesterPays(instance.gcsRequesterPays);
            b.gcsStorageClass(instance.gcsStorageClass);
            b.googleLabels(instance.googleLabels == null ? java.util.Collections.<GoogleLabel>emptyList() : instance.googleLabels);
            b.googleLocation(instance.googleLocation);
            b.googleLocationType(instance.googleLocationType);
            b.googleProjectId(instance.googleProjectId);
            b.googleProjectName(instance.googleProjectName);
            b.googleProjectNumber(instance.googleProjectNumber);
            b.googleService(instance.googleService);
            b.googleTags(instance.googleTags == null ? java.util.Collections.<GoogleTag>emptyList() : instance.googleTags);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for GCSBuckets.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Access control list for this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsAccessControl(final String gcsAccessControl) {
            this.gcsAccessControl = gcsAccessControl;
            return self();
        }

        /**
         * Lifecycle rules for this bucket.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsBucketLifecycleRules(final String gcsBucketLifecycleRules) {
            this.gcsBucketLifecycleRules = gcsBucketLifecycleRules;
            return self();
        }

        /**
         * Effective time for retention of objects in this bucket.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsBucketRetentionEffectiveTime(final Long gcsBucketRetentionEffectiveTime) {
            this.gcsBucketRetentionEffectiveTime = gcsBucketRetentionEffectiveTime;
            return self();
        }

        /**
         * Whether retention is locked for this bucket (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsBucketRetentionLocked(final Boolean gcsBucketRetentionLocked) {
            this.gcsBucketRetentionLocked = gcsBucketRetentionLocked;
            return self();
        }

        /**
         * Retention period for objects in this bucket.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsBucketRetentionPeriod(final Long gcsBucketRetentionPeriod) {
            this.gcsBucketRetentionPeriod = gcsBucketRetentionPeriod;
            return self();
        }

        /**
         * Retention policy for this bucket.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsBucketRetentionPolicy(final String gcsBucketRetentionPolicy) {
            this.gcsBucketRetentionPolicy = gcsBucketRetentionPolicy;
            return self();
        }

        /**
         * Whether versioning is enabled on the bucket (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsBucketVersioningEnabled(final Boolean gcsBucketVersioningEnabled) {
            this.gcsBucketVersioningEnabled = gcsBucketVersioningEnabled;
            return self();
        }

        /**
         * Entity tag for the asset. An entity tag is a hash of the object and represents changes to the contents of an object only, not its metadata.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsETag(final String gcsETag) {
            this.gcsETag = gcsETag;
            return self();
        }

        /**
         * Encryption algorithm used to encrypt this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsEncryptionType(final String gcsEncryptionType) {
            this.gcsEncryptionType = gcsEncryptionType;
            return self();
        }

        /**
         * Version of metadata for this asset at this generation. Used for preconditions and detecting changes in metadata. A metageneration number is only meaningful in the context of a particular generation of a particular asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsMetaGenerationId(final Long gcsMetaGenerationId) {
            this.gcsMetaGenerationId = gcsMetaGenerationId;
            return self();
        }

        /**
         * Number of objects within the bucket.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsObjectCount(final Long gcsObjectCount) {
            this.gcsObjectCount = gcsObjectCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsObject(final IGCSObject gcsObject) {
            if (this.gcsObjects == null) this.gcsObjects = new java.util.ArrayList<IGCSObject>();
            this.gcsObjects.add(gcsObject);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsObjects(final java.util.Collection<? extends IGCSObject> gcsObjects) {
            if (gcsObjects == null) {
                throw new java.lang.NullPointerException("gcsObjects cannot be null");
            }
            if (this.gcsObjects == null) this.gcsObjects = new java.util.ArrayList<IGCSObject>();
            this.gcsObjects.addAll(gcsObjects);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearGcsObjects() {
            if (this.gcsObjects != null) this.gcsObjects.clear();
            return self();
        }

        /**
         * Whether the requester pays header was sent when this asset was created (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsRequesterPays(final Boolean gcsRequesterPays) {
            this.gcsRequesterPays = gcsRequesterPays;
            return self();
        }

        /**
         * Storage class of this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B gcsStorageClass(final String gcsStorageClass) {
            this.gcsStorageClass = gcsStorageClass;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleLabel(final GoogleLabel googleLabel) {
            if (this.googleLabels == null) this.googleLabels = new java.util.ArrayList<GoogleLabel>();
            this.googleLabels.add(googleLabel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleLabels(final java.util.Collection<? extends GoogleLabel> googleLabels) {
            if (googleLabels == null) {
                throw new java.lang.NullPointerException("googleLabels cannot be null");
            }
            if (this.googleLabels == null) this.googleLabels = new java.util.ArrayList<GoogleLabel>();
            this.googleLabels.addAll(googleLabels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearGoogleLabels() {
            if (this.googleLabels != null) this.googleLabels.clear();
            return self();
        }

        /**
         * Location of this asset in Google.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleLocation(final String googleLocation) {
            this.googleLocation = googleLocation;
            return self();
        }

        /**
         * Type of location of this asset in Google.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleLocationType(final String googleLocationType) {
            this.googleLocationType = googleLocationType;
            return self();
        }

        /**
         * ID of the project in which the asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleProjectId(final String googleProjectId) {
            this.googleProjectId = googleProjectId;
            return self();
        }

        /**
         * Name of the project in which the asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleProjectName(final String googleProjectName) {
            this.googleProjectName = googleProjectName;
            return self();
        }

        /**
         * Number of the project in which the asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleProjectNumber(final Long googleProjectNumber) {
            this.googleProjectNumber = googleProjectNumber;
            return self();
        }

        /**
         * Service in Google in which the asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleService(final String googleService) {
            this.googleService = googleService;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleTag(final GoogleTag googleTag) {
            if (this.googleTags == null) this.googleTags = new java.util.ArrayList<GoogleTag>();
            this.googleTags.add(googleTag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B googleTags(final java.util.Collection<? extends GoogleTag> googleTags) {
            if (googleTags == null) {
                throw new java.lang.NullPointerException("googleTags cannot be null");
            }
            if (this.googleTags == null) this.googleTags = new java.util.ArrayList<GoogleTag>();
            this.googleTags.addAll(googleTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearGoogleTags() {
            if (this.googleTags != null) this.googleTags.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "GCSBucket.GCSBucketBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", gcsAccessControl=" + this.gcsAccessControl + ", gcsBucketLifecycleRules=" + this.gcsBucketLifecycleRules + ", gcsBucketRetentionEffectiveTime=" + this.gcsBucketRetentionEffectiveTime + ", gcsBucketRetentionLocked=" + this.gcsBucketRetentionLocked + ", gcsBucketRetentionPeriod=" + this.gcsBucketRetentionPeriod + ", gcsBucketRetentionPolicy=" + this.gcsBucketRetentionPolicy + ", gcsBucketVersioningEnabled=" + this.gcsBucketVersioningEnabled + ", gcsETag=" + this.gcsETag + ", gcsEncryptionType=" + this.gcsEncryptionType + ", gcsMetaGenerationId=" + this.gcsMetaGenerationId + ", gcsObjectCount=" + this.gcsObjectCount + ", gcsObjects=" + this.gcsObjects + ", gcsRequesterPays=" + this.gcsRequesterPays + ", gcsStorageClass=" + this.gcsStorageClass + ", googleLabels=" + this.googleLabels + ", googleLocation=" + this.googleLocation + ", googleLocationType=" + this.googleLocationType + ", googleProjectId=" + this.googleProjectId + ", googleProjectName=" + this.googleProjectName + ", googleProjectNumber=" + this.googleProjectNumber + ", googleService=" + this.googleService + ", googleTags=" + this.googleTags + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class GCSBucketBuilderImpl extends GCSBucket.GCSBucketBuilder<GCSBucket, GCSBucket.GCSBucketBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private GCSBucketBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected GCSBucket.GCSBucketBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GCSBucket build() {
            return new GCSBucket(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected GCSBucket(final GCSBucket.GCSBucketBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = GCSBucket.$default$typeName();
        this.gcsAccessControl = b.gcsAccessControl;
        this.gcsBucketLifecycleRules = b.gcsBucketLifecycleRules;
        this.gcsBucketRetentionEffectiveTime = b.gcsBucketRetentionEffectiveTime;
        this.gcsBucketRetentionLocked = b.gcsBucketRetentionLocked;
        this.gcsBucketRetentionPeriod = b.gcsBucketRetentionPeriod;
        this.gcsBucketRetentionPolicy = b.gcsBucketRetentionPolicy;
        this.gcsBucketVersioningEnabled = b.gcsBucketVersioningEnabled;
        this.gcsETag = b.gcsETag;
        this.gcsEncryptionType = b.gcsEncryptionType;
        this.gcsMetaGenerationId = b.gcsMetaGenerationId;
        this.gcsObjectCount = b.gcsObjectCount;
        java.util.SortedSet<IGCSObject> gcsObjects = new java.util.TreeSet<IGCSObject>();
        if (b.gcsObjects != null) gcsObjects.addAll(b.gcsObjects);
        gcsObjects = java.util.Collections.unmodifiableSortedSet(gcsObjects);
        this.gcsObjects = gcsObjects;
        this.gcsRequesterPays = b.gcsRequesterPays;
        this.gcsStorageClass = b.gcsStorageClass;
        java.util.List<GoogleLabel> googleLabels;
        switch (b.googleLabels == null ? 0 : b.googleLabels.size()) {
        case 0: 
            googleLabels = java.util.Collections.emptyList();
            break;
        case 1: 
            googleLabels = java.util.Collections.singletonList(b.googleLabels.get(0));
            break;
        default: 
            googleLabels = java.util.Collections.unmodifiableList(new java.util.ArrayList<GoogleLabel>(b.googleLabels));
        }
        this.googleLabels = googleLabels;
        this.googleLocation = b.googleLocation;
        this.googleLocationType = b.googleLocationType;
        this.googleProjectId = b.googleProjectId;
        this.googleProjectName = b.googleProjectName;
        this.googleProjectNumber = b.googleProjectNumber;
        this.googleService = b.googleService;
        java.util.List<GoogleTag> googleTags;
        switch (b.googleTags == null ? 0 : b.googleTags.size()) {
        case 0: 
            googleTags = java.util.Collections.emptyList();
            break;
        case 1: 
            googleTags = java.util.Collections.singletonList(b.googleTags.get(0));
            break;
        default: 
            googleTags = java.util.Collections.unmodifiableList(new java.util.ArrayList<GoogleTag>(b.googleTags));
        }
        this.googleTags = googleTags;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static GCSBucket.GCSBucketBuilder<?, ?> _internal() {
        return new GCSBucket.GCSBucketBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public GCSBucket.GCSBucketBuilder<?, ?> toBuilder() {
        return new GCSBucket.GCSBucketBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Access control list for this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGcsAccessControl() {
        return this.gcsAccessControl;
    }

    /**
     * Lifecycle rules for this bucket.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGcsBucketLifecycleRules() {
        return this.gcsBucketLifecycleRules;
    }

    /**
     * Effective time for retention of objects in this bucket.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGcsBucketRetentionEffectiveTime() {
        return this.gcsBucketRetentionEffectiveTime;
    }

    /**
     * Whether retention is locked for this bucket (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getGcsBucketRetentionLocked() {
        return this.gcsBucketRetentionLocked;
    }

    /**
     * Retention period for objects in this bucket.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGcsBucketRetentionPeriod() {
        return this.gcsBucketRetentionPeriod;
    }

    /**
     * Retention policy for this bucket.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGcsBucketRetentionPolicy() {
        return this.gcsBucketRetentionPolicy;
    }

    /**
     * Whether versioning is enabled on the bucket (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getGcsBucketVersioningEnabled() {
        return this.gcsBucketVersioningEnabled;
    }

    /**
     * Entity tag for the asset. An entity tag is a hash of the object and represents changes to the contents of an object only, not its metadata.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGcsETag() {
        return this.gcsETag;
    }

    /**
     * Encryption algorithm used to encrypt this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGcsEncryptionType() {
        return this.gcsEncryptionType;
    }

    /**
     * Version of metadata for this asset at this generation. Used for preconditions and detecting changes in metadata. A metageneration number is only meaningful in the context of a particular generation of a particular asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGcsMetaGenerationId() {
        return this.gcsMetaGenerationId;
    }

    /**
     * Number of objects within the bucket.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGcsObjectCount() {
        return this.gcsObjectCount;
    }

    /**
     * GCS objects within this bucket.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGCSObject> getGcsObjects() {
        return this.gcsObjects;
    }

    /**
     * Whether the requester pays header was sent when this asset was created (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getGcsRequesterPays() {
        return this.gcsRequesterPays;
    }

    /**
     * Storage class of this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGcsStorageClass() {
        return this.gcsStorageClass;
    }

    /**
     * List of labels that have been applied to the asset in Google.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<GoogleLabel> getGoogleLabels() {
        return this.googleLabels;
    }

    /**
     * Location of this asset in Google.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGoogleLocation() {
        return this.googleLocation;
    }

    /**
     * Type of location of this asset in Google.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGoogleLocationType() {
        return this.googleLocationType;
    }

    /**
     * ID of the project in which the asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGoogleProjectId() {
        return this.googleProjectId;
    }

    /**
     * Name of the project in which the asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGoogleProjectName() {
        return this.googleProjectName;
    }

    /**
     * Number of the project in which the asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGoogleProjectNumber() {
        return this.googleProjectNumber;
    }

    /**
     * Service in Google in which the asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGoogleService() {
        return this.googleService;
    }

    /**
     * List of tags that have been applied to the asset in Google.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<GoogleTag> getGoogleTags() {
        return this.googleTags;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GCSBucket)) return false;
        final GCSBucket other = (GCSBucket) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$gcsBucketRetentionEffectiveTime = this.getGcsBucketRetentionEffectiveTime();
        final java.lang.Object other$gcsBucketRetentionEffectiveTime = other.getGcsBucketRetentionEffectiveTime();
        if (this$gcsBucketRetentionEffectiveTime == null ? other$gcsBucketRetentionEffectiveTime != null : !this$gcsBucketRetentionEffectiveTime.equals(other$gcsBucketRetentionEffectiveTime)) return false;
        final java.lang.Object this$gcsBucketRetentionLocked = this.getGcsBucketRetentionLocked();
        final java.lang.Object other$gcsBucketRetentionLocked = other.getGcsBucketRetentionLocked();
        if (this$gcsBucketRetentionLocked == null ? other$gcsBucketRetentionLocked != null : !this$gcsBucketRetentionLocked.equals(other$gcsBucketRetentionLocked)) return false;
        final java.lang.Object this$gcsBucketRetentionPeriod = this.getGcsBucketRetentionPeriod();
        final java.lang.Object other$gcsBucketRetentionPeriod = other.getGcsBucketRetentionPeriod();
        if (this$gcsBucketRetentionPeriod == null ? other$gcsBucketRetentionPeriod != null : !this$gcsBucketRetentionPeriod.equals(other$gcsBucketRetentionPeriod)) return false;
        final java.lang.Object this$gcsBucketVersioningEnabled = this.getGcsBucketVersioningEnabled();
        final java.lang.Object other$gcsBucketVersioningEnabled = other.getGcsBucketVersioningEnabled();
        if (this$gcsBucketVersioningEnabled == null ? other$gcsBucketVersioningEnabled != null : !this$gcsBucketVersioningEnabled.equals(other$gcsBucketVersioningEnabled)) return false;
        final java.lang.Object this$gcsMetaGenerationId = this.getGcsMetaGenerationId();
        final java.lang.Object other$gcsMetaGenerationId = other.getGcsMetaGenerationId();
        if (this$gcsMetaGenerationId == null ? other$gcsMetaGenerationId != null : !this$gcsMetaGenerationId.equals(other$gcsMetaGenerationId)) return false;
        final java.lang.Object this$gcsObjectCount = this.getGcsObjectCount();
        final java.lang.Object other$gcsObjectCount = other.getGcsObjectCount();
        if (this$gcsObjectCount == null ? other$gcsObjectCount != null : !this$gcsObjectCount.equals(other$gcsObjectCount)) return false;
        final java.lang.Object this$gcsRequesterPays = this.getGcsRequesterPays();
        final java.lang.Object other$gcsRequesterPays = other.getGcsRequesterPays();
        if (this$gcsRequesterPays == null ? other$gcsRequesterPays != null : !this$gcsRequesterPays.equals(other$gcsRequesterPays)) return false;
        final java.lang.Object this$googleProjectNumber = this.getGoogleProjectNumber();
        final java.lang.Object other$googleProjectNumber = other.getGoogleProjectNumber();
        if (this$googleProjectNumber == null ? other$googleProjectNumber != null : !this$googleProjectNumber.equals(other$googleProjectNumber)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$gcsAccessControl = this.getGcsAccessControl();
        final java.lang.Object other$gcsAccessControl = other.getGcsAccessControl();
        if (this$gcsAccessControl == null ? other$gcsAccessControl != null : !this$gcsAccessControl.equals(other$gcsAccessControl)) return false;
        final java.lang.Object this$gcsBucketLifecycleRules = this.getGcsBucketLifecycleRules();
        final java.lang.Object other$gcsBucketLifecycleRules = other.getGcsBucketLifecycleRules();
        if (this$gcsBucketLifecycleRules == null ? other$gcsBucketLifecycleRules != null : !this$gcsBucketLifecycleRules.equals(other$gcsBucketLifecycleRules)) return false;
        final java.lang.Object this$gcsBucketRetentionPolicy = this.getGcsBucketRetentionPolicy();
        final java.lang.Object other$gcsBucketRetentionPolicy = other.getGcsBucketRetentionPolicy();
        if (this$gcsBucketRetentionPolicy == null ? other$gcsBucketRetentionPolicy != null : !this$gcsBucketRetentionPolicy.equals(other$gcsBucketRetentionPolicy)) return false;
        final java.lang.Object this$gcsETag = this.getGcsETag();
        final java.lang.Object other$gcsETag = other.getGcsETag();
        if (this$gcsETag == null ? other$gcsETag != null : !this$gcsETag.equals(other$gcsETag)) return false;
        final java.lang.Object this$gcsEncryptionType = this.getGcsEncryptionType();
        final java.lang.Object other$gcsEncryptionType = other.getGcsEncryptionType();
        if (this$gcsEncryptionType == null ? other$gcsEncryptionType != null : !this$gcsEncryptionType.equals(other$gcsEncryptionType)) return false;
        final java.lang.Object this$gcsObjects = this.getGcsObjects();
        final java.lang.Object other$gcsObjects = other.getGcsObjects();
        if (this$gcsObjects == null ? other$gcsObjects != null : !this$gcsObjects.equals(other$gcsObjects)) return false;
        final java.lang.Object this$gcsStorageClass = this.getGcsStorageClass();
        final java.lang.Object other$gcsStorageClass = other.getGcsStorageClass();
        if (this$gcsStorageClass == null ? other$gcsStorageClass != null : !this$gcsStorageClass.equals(other$gcsStorageClass)) return false;
        final java.lang.Object this$googleLabels = this.getGoogleLabels();
        final java.lang.Object other$googleLabels = other.getGoogleLabels();
        if (this$googleLabels == null ? other$googleLabels != null : !this$googleLabels.equals(other$googleLabels)) return false;
        final java.lang.Object this$googleLocation = this.getGoogleLocation();
        final java.lang.Object other$googleLocation = other.getGoogleLocation();
        if (this$googleLocation == null ? other$googleLocation != null : !this$googleLocation.equals(other$googleLocation)) return false;
        final java.lang.Object this$googleLocationType = this.getGoogleLocationType();
        final java.lang.Object other$googleLocationType = other.getGoogleLocationType();
        if (this$googleLocationType == null ? other$googleLocationType != null : !this$googleLocationType.equals(other$googleLocationType)) return false;
        final java.lang.Object this$googleProjectId = this.getGoogleProjectId();
        final java.lang.Object other$googleProjectId = other.getGoogleProjectId();
        if (this$googleProjectId == null ? other$googleProjectId != null : !this$googleProjectId.equals(other$googleProjectId)) return false;
        final java.lang.Object this$googleProjectName = this.getGoogleProjectName();
        final java.lang.Object other$googleProjectName = other.getGoogleProjectName();
        if (this$googleProjectName == null ? other$googleProjectName != null : !this$googleProjectName.equals(other$googleProjectName)) return false;
        final java.lang.Object this$googleService = this.getGoogleService();
        final java.lang.Object other$googleService = other.getGoogleService();
        if (this$googleService == null ? other$googleService != null : !this$googleService.equals(other$googleService)) return false;
        final java.lang.Object this$googleTags = this.getGoogleTags();
        final java.lang.Object other$googleTags = other.getGoogleTags();
        if (this$googleTags == null ? other$googleTags != null : !this$googleTags.equals(other$googleTags)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof GCSBucket;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $gcsBucketRetentionEffectiveTime = this.getGcsBucketRetentionEffectiveTime();
        result = result * PRIME + ($gcsBucketRetentionEffectiveTime == null ? 43 : $gcsBucketRetentionEffectiveTime.hashCode());
        final java.lang.Object $gcsBucketRetentionLocked = this.getGcsBucketRetentionLocked();
        result = result * PRIME + ($gcsBucketRetentionLocked == null ? 43 : $gcsBucketRetentionLocked.hashCode());
        final java.lang.Object $gcsBucketRetentionPeriod = this.getGcsBucketRetentionPeriod();
        result = result * PRIME + ($gcsBucketRetentionPeriod == null ? 43 : $gcsBucketRetentionPeriod.hashCode());
        final java.lang.Object $gcsBucketVersioningEnabled = this.getGcsBucketVersioningEnabled();
        result = result * PRIME + ($gcsBucketVersioningEnabled == null ? 43 : $gcsBucketVersioningEnabled.hashCode());
        final java.lang.Object $gcsMetaGenerationId = this.getGcsMetaGenerationId();
        result = result * PRIME + ($gcsMetaGenerationId == null ? 43 : $gcsMetaGenerationId.hashCode());
        final java.lang.Object $gcsObjectCount = this.getGcsObjectCount();
        result = result * PRIME + ($gcsObjectCount == null ? 43 : $gcsObjectCount.hashCode());
        final java.lang.Object $gcsRequesterPays = this.getGcsRequesterPays();
        result = result * PRIME + ($gcsRequesterPays == null ? 43 : $gcsRequesterPays.hashCode());
        final java.lang.Object $googleProjectNumber = this.getGoogleProjectNumber();
        result = result * PRIME + ($googleProjectNumber == null ? 43 : $googleProjectNumber.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $gcsAccessControl = this.getGcsAccessControl();
        result = result * PRIME + ($gcsAccessControl == null ? 43 : $gcsAccessControl.hashCode());
        final java.lang.Object $gcsBucketLifecycleRules = this.getGcsBucketLifecycleRules();
        result = result * PRIME + ($gcsBucketLifecycleRules == null ? 43 : $gcsBucketLifecycleRules.hashCode());
        final java.lang.Object $gcsBucketRetentionPolicy = this.getGcsBucketRetentionPolicy();
        result = result * PRIME + ($gcsBucketRetentionPolicy == null ? 43 : $gcsBucketRetentionPolicy.hashCode());
        final java.lang.Object $gcsETag = this.getGcsETag();
        result = result * PRIME + ($gcsETag == null ? 43 : $gcsETag.hashCode());
        final java.lang.Object $gcsEncryptionType = this.getGcsEncryptionType();
        result = result * PRIME + ($gcsEncryptionType == null ? 43 : $gcsEncryptionType.hashCode());
        final java.lang.Object $gcsObjects = this.getGcsObjects();
        result = result * PRIME + ($gcsObjects == null ? 43 : $gcsObjects.hashCode());
        final java.lang.Object $gcsStorageClass = this.getGcsStorageClass();
        result = result * PRIME + ($gcsStorageClass == null ? 43 : $gcsStorageClass.hashCode());
        final java.lang.Object $googleLabels = this.getGoogleLabels();
        result = result * PRIME + ($googleLabels == null ? 43 : $googleLabels.hashCode());
        final java.lang.Object $googleLocation = this.getGoogleLocation();
        result = result * PRIME + ($googleLocation == null ? 43 : $googleLocation.hashCode());
        final java.lang.Object $googleLocationType = this.getGoogleLocationType();
        result = result * PRIME + ($googleLocationType == null ? 43 : $googleLocationType.hashCode());
        final java.lang.Object $googleProjectId = this.getGoogleProjectId();
        result = result * PRIME + ($googleProjectId == null ? 43 : $googleProjectId.hashCode());
        final java.lang.Object $googleProjectName = this.getGoogleProjectName();
        result = result * PRIME + ($googleProjectName == null ? 43 : $googleProjectName.hashCode());
        final java.lang.Object $googleService = this.getGoogleService();
        result = result * PRIME + ($googleService == null ? 43 : $googleService.hashCode());
        final java.lang.Object $googleTags = this.getGoogleTags();
        result = result * PRIME + ($googleTags == null ? 43 : $googleTags.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "GCSBucket(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", gcsAccessControl=" + this.getGcsAccessControl() + ", gcsBucketLifecycleRules=" + this.getGcsBucketLifecycleRules() + ", gcsBucketRetentionEffectiveTime=" + this.getGcsBucketRetentionEffectiveTime() + ", gcsBucketRetentionLocked=" + this.getGcsBucketRetentionLocked() + ", gcsBucketRetentionPeriod=" + this.getGcsBucketRetentionPeriod() + ", gcsBucketRetentionPolicy=" + this.getGcsBucketRetentionPolicy() + ", gcsBucketVersioningEnabled=" + this.getGcsBucketVersioningEnabled() + ", gcsETag=" + this.getGcsETag() + ", gcsEncryptionType=" + this.getGcsEncryptionType() + ", gcsMetaGenerationId=" + this.getGcsMetaGenerationId() + ", gcsObjectCount=" + this.getGcsObjectCount() + ", gcsObjects=" + this.getGcsObjects() + ", gcsRequesterPays=" + this.getGcsRequesterPays() + ", gcsStorageClass=" + this.getGcsStorageClass() + ", googleLabels=" + this.getGoogleLabels() + ", googleLocation=" + this.getGoogleLocation() + ", googleLocationType=" + this.getGoogleLocationType() + ", googleProjectId=" + this.getGoogleProjectId() + ", googleProjectName=" + this.getGoogleProjectName() + ", googleProjectNumber=" + this.getGoogleProjectNumber() + ", googleService=" + this.getGoogleService() + ", googleTags=" + this.getGoogleTags() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for GCSBuckets.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
